# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['RegisteredLimitV3Args', 'RegisteredLimitV3']

@pulumi.input_type
class RegisteredLimitV3Args:
    def __init__(__self__, *,
                 default_limit: pulumi.Input[builtins.int],
                 resource_name: pulumi.Input[builtins.str],
                 service_id: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a RegisteredLimitV3 resource.
        :param pulumi.Input[builtins.int] default_limit: Integer for the actual limit.
        :param pulumi.Input[builtins.str] resource_name: The resource that the limit applies to. On
               updates, either service_id, resource_name or region_id must be different than
               existing value otherwise it will raise 409.
        :param pulumi.Input[builtins.str] service_id: The service the limit applies to. On updates,
               either service_id, resource_name or region_id must be different than existing
               value otherwise it will raise 409.
        :param pulumi.Input[builtins.str] description: Description of the limit
        :param pulumi.Input[builtins.str] region: The region in which to obtain the V3 Keystone client.
               If omitted, the `region` argument of the provider is used. Changing this
               creates a new registered limit.
        """
        pulumi.set(__self__, "default_limit", default_limit)
        pulumi.set(__self__, "resource_name", resource_name)
        pulumi.set(__self__, "service_id", service_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="defaultLimit")
    def default_limit(self) -> pulumi.Input[builtins.int]:
        """
        Integer for the actual limit.
        """
        return pulumi.get(self, "default_limit")

    @default_limit.setter
    def default_limit(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "default_limit", value)

    @property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> pulumi.Input[builtins.str]:
        """
        The resource that the limit applies to. On
        updates, either service_id, resource_name or region_id must be different than
        existing value otherwise it will raise 409.
        """
        return pulumi.get(self, "resource_name")

    @resource_name.setter
    def resource_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_name", value)

    @property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> pulumi.Input[builtins.str]:
        """
        The service the limit applies to. On updates,
        either service_id, resource_name or region_id must be different than existing
        value otherwise it will raise 409.
        """
        return pulumi.get(self, "service_id")

    @service_id.setter
    def service_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "service_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the limit
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The region in which to obtain the V3 Keystone client.
        If omitted, the `region` argument of the provider is used. Changing this
        creates a new registered limit.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _RegisteredLimitV3State:
    def __init__(__self__, *,
                 default_limit: Optional[pulumi.Input[builtins.int]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 resource_name: Optional[pulumi.Input[builtins.str]] = None,
                 service_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering RegisteredLimitV3 resources.
        :param pulumi.Input[builtins.int] default_limit: Integer for the actual limit.
        :param pulumi.Input[builtins.str] description: Description of the limit
        :param pulumi.Input[builtins.str] region: The region in which to obtain the V3 Keystone client.
               If omitted, the `region` argument of the provider is used. Changing this
               creates a new registered limit.
        :param pulumi.Input[builtins.str] resource_name: The resource that the limit applies to. On
               updates, either service_id, resource_name or region_id must be different than
               existing value otherwise it will raise 409.
        :param pulumi.Input[builtins.str] service_id: The service the limit applies to. On updates,
               either service_id, resource_name or region_id must be different than existing
               value otherwise it will raise 409.
        """
        if default_limit is not None:
            pulumi.set(__self__, "default_limit", default_limit)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resource_name is not None:
            pulumi.set(__self__, "resource_name", resource_name)
        if service_id is not None:
            pulumi.set(__self__, "service_id", service_id)

    @property
    @pulumi.getter(name="defaultLimit")
    def default_limit(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Integer for the actual limit.
        """
        return pulumi.get(self, "default_limit")

    @default_limit.setter
    def default_limit(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "default_limit", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the limit
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The region in which to obtain the V3 Keystone client.
        If omitted, the `region` argument of the provider is used. Changing this
        creates a new registered limit.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource that the limit applies to. On
        updates, either service_id, resource_name or region_id must be different than
        existing value otherwise it will raise 409.
        """
        return pulumi.get(self, "resource_name")

    @resource_name.setter
    def resource_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_name", value)

    @property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The service the limit applies to. On updates,
        either service_id, resource_name or region_id must be different than existing
        value otherwise it will raise 409.
        """
        return pulumi.get(self, "service_id")

    @service_id.setter
    def service_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_id", value)


@pulumi.type_token("openstack:identity/registeredLimitV3:RegisteredLimitV3")
class RegisteredLimitV3(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_limit: Optional[pulumi.Input[builtins.int]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 resource_name_: Optional[pulumi.Input[builtins.str]] = None,
                 service_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a V3 Registered Limit resource within OpenStack Keystone.

        > **Note:** You _must_ have admin privileges in your OpenStack cloud to use
        this resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_openstack as openstack

        glance = openstack.identity.get_service(name="glance")
        limit1 = openstack.identity.RegisteredLimitV3("limit_1",
            service_id=glance.id,
            resource_name_="image_count_total",
            default_limit=10,
            description="foo")
        ```

        ## Import

        Registered Limits can be imported using the `id`, e.g.

        ```sh
        $ pulumi import openstack:identity/registeredLimitV3:RegisteredLimitV3 limit_1 89c60255-9bd6-460c-822a-e2b959ede9d2
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.int] default_limit: Integer for the actual limit.
        :param pulumi.Input[builtins.str] description: Description of the limit
        :param pulumi.Input[builtins.str] region: The region in which to obtain the V3 Keystone client.
               If omitted, the `region` argument of the provider is used. Changing this
               creates a new registered limit.
        :param pulumi.Input[builtins.str] resource_name_: The resource that the limit applies to. On
               updates, either service_id, resource_name or region_id must be different than
               existing value otherwise it will raise 409.
        :param pulumi.Input[builtins.str] service_id: The service the limit applies to. On updates,
               either service_id, resource_name or region_id must be different than existing
               value otherwise it will raise 409.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RegisteredLimitV3Args,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a V3 Registered Limit resource within OpenStack Keystone.

        > **Note:** You _must_ have admin privileges in your OpenStack cloud to use
        this resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_openstack as openstack

        glance = openstack.identity.get_service(name="glance")
        limit1 = openstack.identity.RegisteredLimitV3("limit_1",
            service_id=glance.id,
            resource_name_="image_count_total",
            default_limit=10,
            description="foo")
        ```

        ## Import

        Registered Limits can be imported using the `id`, e.g.

        ```sh
        $ pulumi import openstack:identity/registeredLimitV3:RegisteredLimitV3 limit_1 89c60255-9bd6-460c-822a-e2b959ede9d2
        ```

        :param str resource_name: The name of the resource.
        :param RegisteredLimitV3Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RegisteredLimitV3Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_limit: Optional[pulumi.Input[builtins.int]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 resource_name_: Optional[pulumi.Input[builtins.str]] = None,
                 service_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RegisteredLimitV3Args.__new__(RegisteredLimitV3Args)

            if default_limit is None and not opts.urn:
                raise TypeError("Missing required property 'default_limit'")
            __props__.__dict__["default_limit"] = default_limit
            __props__.__dict__["description"] = description
            __props__.__dict__["region"] = region
            if resource_name_ is None and not opts.urn:
                raise TypeError("Missing required property 'resource_name_'")
            __props__.__dict__["resource_name"] = resource_name_
            if service_id is None and not opts.urn:
                raise TypeError("Missing required property 'service_id'")
            __props__.__dict__["service_id"] = service_id
        super(RegisteredLimitV3, __self__).__init__(
            'openstack:identity/registeredLimitV3:RegisteredLimitV3',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            default_limit: Optional[pulumi.Input[builtins.int]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            resource_name_: Optional[pulumi.Input[builtins.str]] = None,
            service_id: Optional[pulumi.Input[builtins.str]] = None) -> 'RegisteredLimitV3':
        """
        Get an existing RegisteredLimitV3 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.int] default_limit: Integer for the actual limit.
        :param pulumi.Input[builtins.str] description: Description of the limit
        :param pulumi.Input[builtins.str] region: The region in which to obtain the V3 Keystone client.
               If omitted, the `region` argument of the provider is used. Changing this
               creates a new registered limit.
        :param pulumi.Input[builtins.str] resource_name_: The resource that the limit applies to. On
               updates, either service_id, resource_name or region_id must be different than
               existing value otherwise it will raise 409.
        :param pulumi.Input[builtins.str] service_id: The service the limit applies to. On updates,
               either service_id, resource_name or region_id must be different than existing
               value otherwise it will raise 409.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RegisteredLimitV3State.__new__(_RegisteredLimitV3State)

        __props__.__dict__["default_limit"] = default_limit
        __props__.__dict__["description"] = description
        __props__.__dict__["region"] = region
        __props__.__dict__["resource_name"] = resource_name_
        __props__.__dict__["service_id"] = service_id
        return RegisteredLimitV3(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="defaultLimit")
    def default_limit(self) -> pulumi.Output[builtins.int]:
        """
        Integer for the actual limit.
        """
        return pulumi.get(self, "default_limit")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Description of the limit
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        The region in which to obtain the V3 Keystone client.
        If omitted, the `region` argument of the provider is used. Changing this
        creates a new registered limit.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> pulumi.Output[builtins.str]:
        """
        The resource that the limit applies to. On
        updates, either service_id, resource_name or region_id must be different than
        existing value otherwise it will raise 409.
        """
        return pulumi.get(self, "resource_name")

    @property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> pulumi.Output[builtins.str]:
        """
        The service the limit applies to. On updates,
        either service_id, resource_name or region_id must be different than existing
        value otherwise it will raise 409.
        """
        return pulumi.get(self, "service_id")

