# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'ContainerV1AclArgs',
    'ContainerV1AclArgsDict',
    'ContainerV1AclReadArgs',
    'ContainerV1AclReadArgsDict',
    'ContainerV1ConsumerArgs',
    'ContainerV1ConsumerArgsDict',
    'ContainerV1SecretRefArgs',
    'ContainerV1SecretRefArgsDict',
    'OrderV1MetaArgs',
    'OrderV1MetaArgsDict',
    'SecretV1AclArgs',
    'SecretV1AclArgsDict',
    'SecretV1AclReadArgs',
    'SecretV1AclReadArgsDict',
]

MYPY = False

if not MYPY:
    class ContainerV1AclArgsDict(TypedDict):
        read: NotRequired[pulumi.Input['ContainerV1AclReadArgsDict']]
elif False:
    ContainerV1AclArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ContainerV1AclArgs:
    def __init__(__self__, *,
                 read: Optional[pulumi.Input['ContainerV1AclReadArgs']] = None):
        if read is not None:
            pulumi.set(__self__, "read", read)

    @property
    @pulumi.getter
    def read(self) -> Optional[pulumi.Input['ContainerV1AclReadArgs']]:
        return pulumi.get(self, "read")

    @read.setter
    def read(self, value: Optional[pulumi.Input['ContainerV1AclReadArgs']]):
        pulumi.set(self, "read", value)


if not MYPY:
    class ContainerV1AclReadArgsDict(TypedDict):
        created_at: NotRequired[pulumi.Input[builtins.str]]
        """
        The date the container was created.
        """
        project_access: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether the container is accessible project wide.
        Defaults to `true`.
        """
        updated_at: NotRequired[pulumi.Input[builtins.str]]
        """
        The date the container was last updated.
        """
        users: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        The list of user IDs, which are allowed to access the
        container, when `project_access` is set to `false`.
        """
elif False:
    ContainerV1AclReadArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ContainerV1AclReadArgs:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[builtins.str]] = None,
                 project_access: Optional[pulumi.Input[builtins.bool]] = None,
                 updated_at: Optional[pulumi.Input[builtins.str]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        :param pulumi.Input[builtins.str] created_at: The date the container was created.
        :param pulumi.Input[builtins.bool] project_access: Whether the container is accessible project wide.
               Defaults to `true`.
        :param pulumi.Input[builtins.str] updated_at: The date the container was last updated.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] users: The list of user IDs, which are allowed to access the
               container, when `project_access` is set to `false`.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if project_access is not None:
            pulumi.set(__self__, "project_access", project_access)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if users is not None:
            pulumi.set(__self__, "users", users)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date the container was created.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter(name="projectAccess")
    def project_access(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the container is accessible project wide.
        Defaults to `true`.
        """
        return pulumi.get(self, "project_access")

    @project_access.setter
    def project_access(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "project_access", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date the container was last updated.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "updated_at", value)

    @property
    @pulumi.getter
    def users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The list of user IDs, which are allowed to access the
        container, when `project_access` is set to `false`.
        """
        return pulumi.get(self, "users")

    @users.setter
    def users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "users", value)


if not MYPY:
    class ContainerV1ConsumerArgsDict(TypedDict):
        name: NotRequired[pulumi.Input[builtins.str]]
        """
        Human-readable name for the Container. Does not have
        to be unique.
        """
        url: NotRequired[pulumi.Input[builtins.str]]
        """
        The consumer URL.
        """
elif False:
    ContainerV1ConsumerArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ContainerV1ConsumerArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 url: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] name: Human-readable name for the Container. Does not have
               to be unique.
        :param pulumi.Input[builtins.str] url: The consumer URL.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Human-readable name for the Container. Does not have
        to be unique.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The consumer URL.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "url", value)


if not MYPY:
    class ContainerV1SecretRefArgsDict(TypedDict):
        secret_ref: pulumi.Input[builtins.str]
        """
        The secret reference / where to find the secret, URL.
        """
        name: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the secret reference. The reference names must correspond the container type, more details are available [here](https://docs.openstack.org/barbican/stein/api/reference/containers.html).
        """
elif False:
    ContainerV1SecretRefArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ContainerV1SecretRefArgs:
    def __init__(__self__, *,
                 secret_ref: pulumi.Input[builtins.str],
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] secret_ref: The secret reference / where to find the secret, URL.
        :param pulumi.Input[builtins.str] name: The name of the secret reference. The reference names must correspond the container type, more details are available [here](https://docs.openstack.org/barbican/stein/api/reference/containers.html).
        """
        pulumi.set(__self__, "secret_ref", secret_ref)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="secretRef")
    def secret_ref(self) -> pulumi.Input[builtins.str]:
        """
        The secret reference / where to find the secret, URL.
        """
        return pulumi.get(self, "secret_ref")

    @secret_ref.setter
    def secret_ref(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "secret_ref", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the secret reference. The reference names must correspond the container type, more details are available [here](https://docs.openstack.org/barbican/stein/api/reference/containers.html).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


if not MYPY:
    class OrderV1MetaArgsDict(TypedDict):
        algorithm: pulumi.Input[builtins.str]
        """
        Algorithm to use for key generation.
        """
        bit_length: pulumi.Input[builtins.int]
        """
        Bit lenght of key to be generated.
        """
        expiration: NotRequired[pulumi.Input[builtins.str]]
        """
        This is a UTC timestamp in ISO 8601 format YYYY-MM-DDTHH:MM:SSZ. If set, the secret will not be available after this time.
        """
        mode: NotRequired[pulumi.Input[builtins.str]]
        """
        The mode to use for key generation.
        """
        name: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the secret set by the user.
        """
        payload_content_type: NotRequired[pulumi.Input[builtins.str]]
        """
        The media type for the content of the secrets payload. Must be one of `text/plain`, `text/plain;charset=utf-8`, `text/plain; charset=utf-8`, `application/octet-stream`, `application/pkcs8`.
        """
elif False:
    OrderV1MetaArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OrderV1MetaArgs:
    def __init__(__self__, *,
                 algorithm: pulumi.Input[builtins.str],
                 bit_length: pulumi.Input[builtins.int],
                 expiration: Optional[pulumi.Input[builtins.str]] = None,
                 mode: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 payload_content_type: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] algorithm: Algorithm to use for key generation.
        :param pulumi.Input[builtins.int] bit_length: Bit lenght of key to be generated.
        :param pulumi.Input[builtins.str] expiration: This is a UTC timestamp in ISO 8601 format YYYY-MM-DDTHH:MM:SSZ. If set, the secret will not be available after this time.
        :param pulumi.Input[builtins.str] mode: The mode to use for key generation.
        :param pulumi.Input[builtins.str] name: The name of the secret set by the user.
        :param pulumi.Input[builtins.str] payload_content_type: The media type for the content of the secrets payload. Must be one of `text/plain`, `text/plain;charset=utf-8`, `text/plain; charset=utf-8`, `application/octet-stream`, `application/pkcs8`.
        """
        pulumi.set(__self__, "algorithm", algorithm)
        pulumi.set(__self__, "bit_length", bit_length)
        if expiration is not None:
            pulumi.set(__self__, "expiration", expiration)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if payload_content_type is not None:
            pulumi.set(__self__, "payload_content_type", payload_content_type)

    @property
    @pulumi.getter
    def algorithm(self) -> pulumi.Input[builtins.str]:
        """
        Algorithm to use for key generation.
        """
        return pulumi.get(self, "algorithm")

    @algorithm.setter
    def algorithm(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "algorithm", value)

    @property
    @pulumi.getter(name="bitLength")
    def bit_length(self) -> pulumi.Input[builtins.int]:
        """
        Bit lenght of key to be generated.
        """
        return pulumi.get(self, "bit_length")

    @bit_length.setter
    def bit_length(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "bit_length", value)

    @property
    @pulumi.getter
    def expiration(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        This is a UTC timestamp in ISO 8601 format YYYY-MM-DDTHH:MM:SSZ. If set, the secret will not be available after this time.
        """
        return pulumi.get(self, "expiration")

    @expiration.setter
    def expiration(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "expiration", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The mode to use for key generation.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the secret set by the user.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="payloadContentType")
    def payload_content_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The media type for the content of the secrets payload. Must be one of `text/plain`, `text/plain;charset=utf-8`, `text/plain; charset=utf-8`, `application/octet-stream`, `application/pkcs8`.
        """
        return pulumi.get(self, "payload_content_type")

    @payload_content_type.setter
    def payload_content_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "payload_content_type", value)


if not MYPY:
    class SecretV1AclArgsDict(TypedDict):
        read: NotRequired[pulumi.Input['SecretV1AclReadArgsDict']]
elif False:
    SecretV1AclArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SecretV1AclArgs:
    def __init__(__self__, *,
                 read: Optional[pulumi.Input['SecretV1AclReadArgs']] = None):
        if read is not None:
            pulumi.set(__self__, "read", read)

    @property
    @pulumi.getter
    def read(self) -> Optional[pulumi.Input['SecretV1AclReadArgs']]:
        return pulumi.get(self, "read")

    @read.setter
    def read(self, value: Optional[pulumi.Input['SecretV1AclReadArgs']]):
        pulumi.set(self, "read", value)


if not MYPY:
    class SecretV1AclReadArgsDict(TypedDict):
        created_at: NotRequired[pulumi.Input[builtins.str]]
        """
        The date the secret was created.
        """
        project_access: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether the secret is accessible project wide.
        Defaults to `true`.
        """
        updated_at: NotRequired[pulumi.Input[builtins.str]]
        """
        The date the secret was last updated.
        """
        users: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        The list of user IDs, which are allowed to access the
        secret, when `project_access` is set to `false`.
        """
elif False:
    SecretV1AclReadArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SecretV1AclReadArgs:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[builtins.str]] = None,
                 project_access: Optional[pulumi.Input[builtins.bool]] = None,
                 updated_at: Optional[pulumi.Input[builtins.str]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        :param pulumi.Input[builtins.str] created_at: The date the secret was created.
        :param pulumi.Input[builtins.bool] project_access: Whether the secret is accessible project wide.
               Defaults to `true`.
        :param pulumi.Input[builtins.str] updated_at: The date the secret was last updated.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] users: The list of user IDs, which are allowed to access the
               secret, when `project_access` is set to `false`.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if project_access is not None:
            pulumi.set(__self__, "project_access", project_access)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if users is not None:
            pulumi.set(__self__, "users", users)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date the secret was created.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter(name="projectAccess")
    def project_access(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the secret is accessible project wide.
        Defaults to `true`.
        """
        return pulumi.get(self, "project_access")

    @project_access.setter
    def project_access(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "project_access", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date the secret was last updated.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "updated_at", value)

    @property
    @pulumi.getter
    def users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The list of user IDs, which are allowed to access the
        secret, when `project_access` is set to `false`.
        """
        return pulumi.get(self, "users")

    @users.setter
    def users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "users", value)


