# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'MembersMember',
    'PoolPersistence',
]

@pulumi.output_type
class MembersMember(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "protocolPort":
            suggest = "protocol_port"
        elif key == "adminStateUp":
            suggest = "admin_state_up"
        elif key == "monitorAddress":
            suggest = "monitor_address"
        elif key == "monitorPort":
            suggest = "monitor_port"
        elif key == "subnetId":
            suggest = "subnet_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MembersMember. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MembersMember.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MembersMember.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: builtins.str,
                 protocol_port: builtins.int,
                 admin_state_up: Optional[builtins.bool] = None,
                 backup: Optional[builtins.bool] = None,
                 id: Optional[builtins.str] = None,
                 monitor_address: Optional[builtins.str] = None,
                 monitor_port: Optional[builtins.int] = None,
                 name: Optional[builtins.str] = None,
                 subnet_id: Optional[builtins.str] = None,
                 weight: Optional[builtins.int] = None):
        """
        :param builtins.str address: The IP address of the members to receive traffic from
               the load balancer.
        :param builtins.int protocol_port: The port on which to listen for client traffic.
        :param builtins.bool admin_state_up: The administrative state of the member.
               A valid value is true (UP) or false (DOWN). Defaults to true.
        :param builtins.bool backup: A bool that indicates whether the member is
               backup. **Requires octavia minor version 2.1 or later**.
        :param builtins.str id: The unique ID for the members.
        :param builtins.str monitor_address: An alternate IP address used for health 
               monitoring a backend member.
        :param builtins.int monitor_port: An alternate protocol port used for health 
               monitoring a backend member.
        :param builtins.str name: Human-readable name for the member.
        :param builtins.str subnet_id: The subnet in which to access the member.
        :param builtins.int weight: A positive integer value that indicates the relative
               portion of traffic that this members should receive from the pool. For
               example, a member with a weight of 10 receives five times as much traffic
               as a member with a weight of 2. Defaults to 1.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "protocol_port", protocol_port)
        if admin_state_up is not None:
            pulumi.set(__self__, "admin_state_up", admin_state_up)
        if backup is not None:
            pulumi.set(__self__, "backup", backup)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if monitor_address is not None:
            pulumi.set(__self__, "monitor_address", monitor_address)
        if monitor_port is not None:
            pulumi.set(__self__, "monitor_port", monitor_port)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter
    def address(self) -> builtins.str:
        """
        The IP address of the members to receive traffic from
        the load balancer.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter(name="protocolPort")
    def protocol_port(self) -> builtins.int:
        """
        The port on which to listen for client traffic.
        """
        return pulumi.get(self, "protocol_port")

    @property
    @pulumi.getter(name="adminStateUp")
    def admin_state_up(self) -> Optional[builtins.bool]:
        """
        The administrative state of the member.
        A valid value is true (UP) or false (DOWN). Defaults to true.
        """
        return pulumi.get(self, "admin_state_up")

    @property
    @pulumi.getter
    def backup(self) -> Optional[builtins.bool]:
        """
        A bool that indicates whether the member is
        backup. **Requires octavia minor version 2.1 or later**.
        """
        return pulumi.get(self, "backup")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The unique ID for the members.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="monitorAddress")
    def monitor_address(self) -> Optional[builtins.str]:
        """
        An alternate IP address used for health 
        monitoring a backend member.
        """
        return pulumi.get(self, "monitor_address")

    @property
    @pulumi.getter(name="monitorPort")
    def monitor_port(self) -> Optional[builtins.int]:
        """
        An alternate protocol port used for health 
        monitoring a backend member.
        """
        return pulumi.get(self, "monitor_port")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Human-readable name for the member.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[builtins.str]:
        """
        The subnet in which to access the member.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter
    def weight(self) -> Optional[builtins.int]:
        """
        A positive integer value that indicates the relative
        portion of traffic that this members should receive from the pool. For
        example, a member with a weight of 10 receives five times as much traffic
        as a member with a weight of 2. Defaults to 1.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class PoolPersistence(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cookieName":
            suggest = "cookie_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PoolPersistence. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PoolPersistence.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PoolPersistence.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: builtins.str,
                 cookie_name: Optional[builtins.str] = None):
        """
        :param builtins.str type: The type of persistence mode. The current specification
               supports SOURCE_IP, HTTP_COOKIE, and APP_COOKIE.
        :param builtins.str cookie_name: The name of the cookie if persistence mode is set
               appropriately. Required if `type = APP_COOKIE`.
        """
        pulumi.set(__self__, "type", type)
        if cookie_name is not None:
            pulumi.set(__self__, "cookie_name", cookie_name)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of persistence mode. The current specification
        supports SOURCE_IP, HTTP_COOKIE, and APP_COOKIE.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="cookieName")
    def cookie_name(self) -> Optional[builtins.str]:
        """
        The name of the cookie if persistence mode is set
        appropriately. Required if `type = APP_COOKIE`.
        """
        return pulumi.get(self, "cookie_name")


