# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AddressGroupV2Args', 'AddressGroupV2']

@pulumi.input_type
class AddressGroupV2Args:
    def __init__(__self__, *,
                 addresses: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a AddressGroupV2 resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] addresses: A list of CIDR blocks that define the addresses in
               the address group. Each address must be a valid IPv4 or IPv6 CIDR block.
        :param pulumi.Input[builtins.str] description: A description of the address group.
        :param pulumi.Input[builtins.str] name: A name of the address group.
        :param pulumi.Input[builtins.str] project_id: The owner of the address group. Required if admin
               wants to create a group for a specific project. Changing this creates a new
               address group.
        :param pulumi.Input[builtins.str] region: The region in which to obtain the V2 networking client.
               If omitted, the `region` argument of the provider is used. Changing this
               creates a new address group.
        """
        pulumi.set(__self__, "addresses", addresses)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def addresses(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        A list of CIDR blocks that define the addresses in
        the address group. Each address must be a valid IPv4 or IPv6 CIDR block.
        """
        return pulumi.get(self, "addresses")

    @addresses.setter
    def addresses(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "addresses", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A description of the address group.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A name of the address group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The owner of the address group. Required if admin
        wants to create a group for a specific project. Changing this creates a new
        address group.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The region in which to obtain the V2 networking client.
        If omitted, the `region` argument of the provider is used. Changing this
        creates a new address group.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _AddressGroupV2State:
    def __init__(__self__, *,
                 addresses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering AddressGroupV2 resources.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] addresses: A list of CIDR blocks that define the addresses in
               the address group. Each address must be a valid IPv4 or IPv6 CIDR block.
        :param pulumi.Input[builtins.str] description: A description of the address group.
        :param pulumi.Input[builtins.str] name: A name of the address group.
        :param pulumi.Input[builtins.str] project_id: The owner of the address group. Required if admin
               wants to create a group for a specific project. Changing this creates a new
               address group.
        :param pulumi.Input[builtins.str] region: The region in which to obtain the V2 networking client.
               If omitted, the `region` argument of the provider is used. Changing this
               creates a new address group.
        """
        if addresses is not None:
            pulumi.set(__self__, "addresses", addresses)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of CIDR blocks that define the addresses in
        the address group. Each address must be a valid IPv4 or IPv6 CIDR block.
        """
        return pulumi.get(self, "addresses")

    @addresses.setter
    def addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "addresses", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A description of the address group.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A name of the address group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The owner of the address group. Required if admin
        wants to create a group for a specific project. Changing this creates a new
        address group.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The region in which to obtain the V2 networking client.
        If omitted, the `region` argument of the provider is used. Changing this
        creates a new address group.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.type_token("openstack:networking/addressGroupV2:AddressGroupV2")
class AddressGroupV2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 addresses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a V2 neutron address group resource within OpenStack.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_openstack as openstack

        group1 = openstack.networking.AddressGroupV2("group_1",
            name="group_1",
            description="My neutron address group",
            addresses=[
                "192.168.0.1/32",
                "2001:db8::1/128",
            ])
        ```

        ## Import

        Address Groups can be imported using the `id`, e.g.

        ```sh
        $ pulumi import openstack:networking/addressGroupV2:AddressGroupV2 group_1 782fef9c-d03c-400a-9735-2f9af5681cb3
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] addresses: A list of CIDR blocks that define the addresses in
               the address group. Each address must be a valid IPv4 or IPv6 CIDR block.
        :param pulumi.Input[builtins.str] description: A description of the address group.
        :param pulumi.Input[builtins.str] name: A name of the address group.
        :param pulumi.Input[builtins.str] project_id: The owner of the address group. Required if admin
               wants to create a group for a specific project. Changing this creates a new
               address group.
        :param pulumi.Input[builtins.str] region: The region in which to obtain the V2 networking client.
               If omitted, the `region` argument of the provider is used. Changing this
               creates a new address group.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AddressGroupV2Args,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a V2 neutron address group resource within OpenStack.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_openstack as openstack

        group1 = openstack.networking.AddressGroupV2("group_1",
            name="group_1",
            description="My neutron address group",
            addresses=[
                "192.168.0.1/32",
                "2001:db8::1/128",
            ])
        ```

        ## Import

        Address Groups can be imported using the `id`, e.g.

        ```sh
        $ pulumi import openstack:networking/addressGroupV2:AddressGroupV2 group_1 782fef9c-d03c-400a-9735-2f9af5681cb3
        ```

        :param str resource_name: The name of the resource.
        :param AddressGroupV2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AddressGroupV2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 addresses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AddressGroupV2Args.__new__(AddressGroupV2Args)

            if addresses is None and not opts.urn:
                raise TypeError("Missing required property 'addresses'")
            __props__.__dict__["addresses"] = addresses
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["region"] = region
        super(AddressGroupV2, __self__).__init__(
            'openstack:networking/addressGroupV2:AddressGroupV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            addresses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project_id: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None) -> 'AddressGroupV2':
        """
        Get an existing AddressGroupV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] addresses: A list of CIDR blocks that define the addresses in
               the address group. Each address must be a valid IPv4 or IPv6 CIDR block.
        :param pulumi.Input[builtins.str] description: A description of the address group.
        :param pulumi.Input[builtins.str] name: A name of the address group.
        :param pulumi.Input[builtins.str] project_id: The owner of the address group. Required if admin
               wants to create a group for a specific project. Changing this creates a new
               address group.
        :param pulumi.Input[builtins.str] region: The region in which to obtain the V2 networking client.
               If omitted, the `region` argument of the provider is used. Changing this
               creates a new address group.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AddressGroupV2State.__new__(_AddressGroupV2State)

        __props__.__dict__["addresses"] = addresses
        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["region"] = region
        return AddressGroupV2(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def addresses(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        A list of CIDR blocks that define the addresses in
        the address group. Each address must be a valid IPv4 or IPv6 CIDR block.
        """
        return pulumi.get(self, "addresses")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A description of the address group.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        A name of the address group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[builtins.str]:
        """
        The owner of the address group. Required if admin
        wants to create a group for a specific project. Changing this creates a new
        address group.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        The region in which to obtain the V2 networking client.
        If omitted, the `region` argument of the provider is used. Changing this
        creates a new address group.
        """
        return pulumi.get(self, "region")

