# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetQosBandwidthLimitRuleResult',
    'AwaitableGetQosBandwidthLimitRuleResult',
    'get_qos_bandwidth_limit_rule',
    'get_qos_bandwidth_limit_rule_output',
]

@pulumi.output_type
class GetQosBandwidthLimitRuleResult:
    """
    A collection of values returned by getQosBandwidthLimitRule.
    """
    def __init__(__self__, direction=None, id=None, max_burst_kbps=None, max_kbps=None, qos_policy_id=None, region=None):
        if direction and not isinstance(direction, str):
            raise TypeError("Expected argument 'direction' to be a str")
        pulumi.set(__self__, "direction", direction)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if max_burst_kbps and not isinstance(max_burst_kbps, int):
            raise TypeError("Expected argument 'max_burst_kbps' to be a int")
        pulumi.set(__self__, "max_burst_kbps", max_burst_kbps)
        if max_kbps and not isinstance(max_kbps, int):
            raise TypeError("Expected argument 'max_kbps' to be a int")
        pulumi.set(__self__, "max_kbps", max_kbps)
        if qos_policy_id and not isinstance(qos_policy_id, str):
            raise TypeError("Expected argument 'qos_policy_id' to be a str")
        pulumi.set(__self__, "qos_policy_id", qos_policy_id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def direction(self) -> builtins.str:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "direction")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="maxBurstKbps")
    def max_burst_kbps(self) -> builtins.int:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "max_burst_kbps")

    @property
    @pulumi.getter(name="maxKbps")
    def max_kbps(self) -> builtins.int:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "max_kbps")

    @property
    @pulumi.getter(name="qosPolicyId")
    def qos_policy_id(self) -> builtins.str:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "qos_policy_id")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "region")


class AwaitableGetQosBandwidthLimitRuleResult(GetQosBandwidthLimitRuleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetQosBandwidthLimitRuleResult(
            direction=self.direction,
            id=self.id,
            max_burst_kbps=self.max_burst_kbps,
            max_kbps=self.max_kbps,
            qos_policy_id=self.qos_policy_id,
            region=self.region)


def get_qos_bandwidth_limit_rule(max_burst_kbps: Optional[builtins.int] = None,
                                 max_kbps: Optional[builtins.int] = None,
                                 qos_policy_id: Optional[builtins.str] = None,
                                 region: Optional[builtins.str] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetQosBandwidthLimitRuleResult:
    """
    Use this data source to get the ID of an available OpenStack QoS bandwidth limit rule.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_openstack as openstack

    qos_bandwidth_limit_rule1 = openstack.networking.get_qos_bandwidth_limit_rule(max_kbps=300)
    ```


    :param builtins.int max_burst_kbps: The maximum burst size in kilobits of a QoS bandwidth limit rule.
    :param builtins.int max_kbps: The maximum kilobits per second of a QoS bandwidth limit rule.
    :param builtins.str qos_policy_id: The QoS policy reference.
    :param builtins.str region: The region in which to obtain the V2 Networking client.
           A Networking client is needed to create a Neutron QoS bandwidth limit rule. If omitted, the
           `region` argument of the provider is used.
    """
    __args__ = dict()
    __args__['maxBurstKbps'] = max_burst_kbps
    __args__['maxKbps'] = max_kbps
    __args__['qosPolicyId'] = qos_policy_id
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('openstack:networking/getQosBandwidthLimitRule:getQosBandwidthLimitRule', __args__, opts=opts, typ=GetQosBandwidthLimitRuleResult).value

    return AwaitableGetQosBandwidthLimitRuleResult(
        direction=pulumi.get(__ret__, 'direction'),
        id=pulumi.get(__ret__, 'id'),
        max_burst_kbps=pulumi.get(__ret__, 'max_burst_kbps'),
        max_kbps=pulumi.get(__ret__, 'max_kbps'),
        qos_policy_id=pulumi.get(__ret__, 'qos_policy_id'),
        region=pulumi.get(__ret__, 'region'))
def get_qos_bandwidth_limit_rule_output(max_burst_kbps: Optional[pulumi.Input[Optional[builtins.int]]] = None,
                                        max_kbps: Optional[pulumi.Input[Optional[builtins.int]]] = None,
                                        qos_policy_id: Optional[pulumi.Input[builtins.str]] = None,
                                        region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetQosBandwidthLimitRuleResult]:
    """
    Use this data source to get the ID of an available OpenStack QoS bandwidth limit rule.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_openstack as openstack

    qos_bandwidth_limit_rule1 = openstack.networking.get_qos_bandwidth_limit_rule(max_kbps=300)
    ```


    :param builtins.int max_burst_kbps: The maximum burst size in kilobits of a QoS bandwidth limit rule.
    :param builtins.int max_kbps: The maximum kilobits per second of a QoS bandwidth limit rule.
    :param builtins.str qos_policy_id: The QoS policy reference.
    :param builtins.str region: The region in which to obtain the V2 Networking client.
           A Networking client is needed to create a Neutron QoS bandwidth limit rule. If omitted, the
           `region` argument of the provider is used.
    """
    __args__ = dict()
    __args__['maxBurstKbps'] = max_burst_kbps
    __args__['maxKbps'] = max_kbps
    __args__['qosPolicyId'] = qos_policy_id
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('openstack:networking/getQosBandwidthLimitRule:getQosBandwidthLimitRule', __args__, opts=opts, typ=GetQosBandwidthLimitRuleResult)
    return __ret__.apply(lambda __response__: GetQosBandwidthLimitRuleResult(
        direction=pulumi.get(__response__, 'direction'),
        id=pulumi.get(__response__, 'id'),
        max_burst_kbps=pulumi.get(__response__, 'max_burst_kbps'),
        max_kbps=pulumi.get(__response__, 'max_kbps'),
        qos_policy_id=pulumi.get(__response__, 'qos_policy_id'),
        region=pulumi.get(__response__, 'region')))
