# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetSegmentV2Result',
    'AwaitableGetSegmentV2Result',
    'get_segment_v2',
    'get_segment_v2_output',
]

@pulumi.output_type
class GetSegmentV2Result:
    """
    A collection of values returned by getSegmentV2.
    """
    def __init__(__self__, created_at=None, description=None, id=None, name=None, network_id=None, network_type=None, physical_network=None, region=None, revision_number=None, segment_id=None, segmentation_id=None, updated_at=None):
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if network_id and not isinstance(network_id, str):
            raise TypeError("Expected argument 'network_id' to be a str")
        pulumi.set(__self__, "network_id", network_id)
        if network_type and not isinstance(network_type, str):
            raise TypeError("Expected argument 'network_type' to be a str")
        pulumi.set(__self__, "network_type", network_type)
        if physical_network and not isinstance(physical_network, str):
            raise TypeError("Expected argument 'physical_network' to be a str")
        pulumi.set(__self__, "physical_network", physical_network)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if revision_number and not isinstance(revision_number, int):
            raise TypeError("Expected argument 'revision_number' to be a int")
        pulumi.set(__self__, "revision_number", revision_number)
        if segment_id and not isinstance(segment_id, str):
            raise TypeError("Expected argument 'segment_id' to be a str")
        pulumi.set(__self__, "segment_id", segment_id)
        if segmentation_id and not isinstance(segmentation_id, int):
            raise TypeError("Expected argument 'segmentation_id' to be a int")
        pulumi.set(__self__, "segmentation_id", segmentation_id)
        if updated_at and not isinstance(updated_at, str):
            raise TypeError("Expected argument 'updated_at' to be a str")
        pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> builtins.str:
        """
        The date and time when the network segment was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> builtins.str:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter(name="networkType")
    def network_type(self) -> builtins.str:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "network_type")

    @property
    @pulumi.getter(name="physicalNetwork")
    def physical_network(self) -> builtins.str:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "physical_network")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="revisionNumber")
    def revision_number(self) -> builtins.int:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "revision_number")

    @property
    @pulumi.getter(name="segmentId")
    def segment_id(self) -> builtins.str:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "segment_id")

    @property
    @pulumi.getter(name="segmentationId")
    def segmentation_id(self) -> builtins.int:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "segmentation_id")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> builtins.str:
        """
        The date and time when the network segment was last updated.
        """
        return pulumi.get(self, "updated_at")


class AwaitableGetSegmentV2Result(GetSegmentV2Result):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSegmentV2Result(
            created_at=self.created_at,
            description=self.description,
            id=self.id,
            name=self.name,
            network_id=self.network_id,
            network_type=self.network_type,
            physical_network=self.physical_network,
            region=self.region,
            revision_number=self.revision_number,
            segment_id=self.segment_id,
            segmentation_id=self.segmentation_id,
            updated_at=self.updated_at)


def get_segment_v2(description: Optional[builtins.str] = None,
                   name: Optional[builtins.str] = None,
                   network_id: Optional[builtins.str] = None,
                   network_type: Optional[builtins.str] = None,
                   physical_network: Optional[builtins.str] = None,
                   region: Optional[builtins.str] = None,
                   revision_number: Optional[builtins.int] = None,
                   segment_id: Optional[builtins.str] = None,
                   segmentation_id: Optional[builtins.int] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSegmentV2Result:
    """
    Use this data source to get the ID of an available OpenStack network.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_openstack as openstack

    network = openstack.networking.get_segment_v2(name="tf_test_segment")
    ```


    :param builtins.str description: Human-readable description of the network segment.
    :param builtins.str name: The name of the network segment.
    :param builtins.str network_id: The ID of the network.
    :param builtins.str network_type: The type of the network, such as `vlan`, `vxlan`,
           `flat`, `gre`, `geneve`, or `local`.
    :param builtins.str physical_network: The name of the physical network.
    :param builtins.str region: The region in which to obtain the V2 Neutron client.
           A Neutron client is needed to retrieve networks ids. If omitted, the
           `region` argument of the provider is used.
    :param builtins.int revision_number: See Argument Reference above.
    :param builtins.str segment_id: The ID of the network segment
    :param builtins.int segmentation_id: The segmentation ID of the network segment.
    """
    __args__ = dict()
    __args__['description'] = description
    __args__['name'] = name
    __args__['networkId'] = network_id
    __args__['networkType'] = network_type
    __args__['physicalNetwork'] = physical_network
    __args__['region'] = region
    __args__['revisionNumber'] = revision_number
    __args__['segmentId'] = segment_id
    __args__['segmentationId'] = segmentation_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('openstack:networking/getSegmentV2:getSegmentV2', __args__, opts=opts, typ=GetSegmentV2Result).value

    return AwaitableGetSegmentV2Result(
        created_at=pulumi.get(__ret__, 'created_at'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        network_id=pulumi.get(__ret__, 'network_id'),
        network_type=pulumi.get(__ret__, 'network_type'),
        physical_network=pulumi.get(__ret__, 'physical_network'),
        region=pulumi.get(__ret__, 'region'),
        revision_number=pulumi.get(__ret__, 'revision_number'),
        segment_id=pulumi.get(__ret__, 'segment_id'),
        segmentation_id=pulumi.get(__ret__, 'segmentation_id'),
        updated_at=pulumi.get(__ret__, 'updated_at'))
def get_segment_v2_output(description: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                          name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                          network_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                          network_type: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                          physical_network: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                          region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                          revision_number: Optional[pulumi.Input[Optional[builtins.int]]] = None,
                          segment_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                          segmentation_id: Optional[pulumi.Input[Optional[builtins.int]]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSegmentV2Result]:
    """
    Use this data source to get the ID of an available OpenStack network.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_openstack as openstack

    network = openstack.networking.get_segment_v2(name="tf_test_segment")
    ```


    :param builtins.str description: Human-readable description of the network segment.
    :param builtins.str name: The name of the network segment.
    :param builtins.str network_id: The ID of the network.
    :param builtins.str network_type: The type of the network, such as `vlan`, `vxlan`,
           `flat`, `gre`, `geneve`, or `local`.
    :param builtins.str physical_network: The name of the physical network.
    :param builtins.str region: The region in which to obtain the V2 Neutron client.
           A Neutron client is needed to retrieve networks ids. If omitted, the
           `region` argument of the provider is used.
    :param builtins.int revision_number: See Argument Reference above.
    :param builtins.str segment_id: The ID of the network segment
    :param builtins.int segmentation_id: The segmentation ID of the network segment.
    """
    __args__ = dict()
    __args__['description'] = description
    __args__['name'] = name
    __args__['networkId'] = network_id
    __args__['networkType'] = network_type
    __args__['physicalNetwork'] = physical_network
    __args__['region'] = region
    __args__['revisionNumber'] = revision_number
    __args__['segmentId'] = segment_id
    __args__['segmentationId'] = segmentation_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('openstack:networking/getSegmentV2:getSegmentV2', __args__, opts=opts, typ=GetSegmentV2Result)
    return __ret__.apply(lambda __response__: GetSegmentV2Result(
        created_at=pulumi.get(__response__, 'created_at'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        network_id=pulumi.get(__response__, 'network_id'),
        network_type=pulumi.get(__response__, 'network_type'),
        physical_network=pulumi.get(__response__, 'physical_network'),
        region=pulumi.get(__response__, 'region'),
        revision_number=pulumi.get(__response__, 'revision_number'),
        segment_id=pulumi.get(__response__, 'segment_id'),
        segmentation_id=pulumi.get(__response__, 'segmentation_id'),
        updated_at=pulumi.get(__response__, 'updated_at')))
