# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RouterArgs', 'Router']

@pulumi.input_type
class RouterArgs:
    def __init__(__self__, *,
                 admin_state_up: Optional[pulumi.Input[builtins.bool]] = None,
                 availability_zone_hints: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 distributed: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_snat: Optional[pulumi.Input[builtins.bool]] = None,
                 external_fixed_ips: Optional[pulumi.Input[Sequence[pulumi.Input['RouterExternalFixedIpArgs']]]] = None,
                 external_network_id: Optional[pulumi.Input[builtins.str]] = None,
                 external_qos_policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 external_subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tenant_id: Optional[pulumi.Input[builtins.str]] = None,
                 value_specs: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 vendor_options: Optional[pulumi.Input['RouterVendorOptionsArgs']] = None):
        """
        The set of arguments for constructing a Router resource.
        :param pulumi.Input[builtins.bool] admin_state_up: Administrative up/down status for the router
               (must be "true" or "false" if provided). Changing this updates the
               `admin_state_up` of an existing router.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] availability_zone_hints: An availability zone is used to make
               network resources highly available. Used for resources with high availability
               so that they are scheduled on different availability zones. Changing this
               creates a new router.
        :param pulumi.Input[builtins.str] description: Human-readable description for the router.
        :param pulumi.Input[builtins.bool] distributed: Indicates whether or not to create a
               distributed router. The default policy setting in Neutron restricts
               usage of this property to administrative users only.
        :param pulumi.Input[builtins.bool] enable_snat: Enable Source NAT for the router. Valid values are
               "true" or "false". An `external_network_id` has to be set in order to
               set this property. Changing this updates the `enable_snat` of the router.
               Setting this value **requires** an **ext-gw-mode** extension to be enabled
               in OpenStack Neutron.
        :param pulumi.Input[Sequence[pulumi.Input['RouterExternalFixedIpArgs']]] external_fixed_ips: An external fixed IP for the router. This
               can be repeated. The structure is described below. An `external_network_id`
               has to be set in order to set this property. Changing this updates the
               external fixed IPs of the router.
        :param pulumi.Input[builtins.str] external_network_id: The network UUID of an external gateway
               for the router. A router with an external gateway is required if any
               compute instances or load balancers will be using floating IPs. Changing
               this updates the external gateway of the router.
        :param pulumi.Input[builtins.str] external_qos_policy_id: The QoS policy UUID that will be applied
               on the external gateway for the router. Changing this updates the external
               gateway of the router.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] external_subnet_ids: A list of external subnet IDs to try over
               each to obtain a fixed IP for the router. If a subnet ID in a list has
               exhausted floating IP pool, the next subnet ID will be tried. This argument is
               used only during the router creation and allows to set only one external fixed
               IP. Conflicts with an `external_fixed_ip` argument.
        :param pulumi.Input[builtins.str] name: A unique name for the router. Changing this
               updates the `name` of an existing router.
        :param pulumi.Input[builtins.str] region: The region in which to obtain the V2 networking client.
               A networking client is needed to create a router. If omitted, the
               `region` argument of the provider is used. Changing this creates a new
               router.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: A set of string tags for the router.
        :param pulumi.Input[builtins.str] tenant_id: The owner of the floating IP. Required if admin wants
               to create a router for another tenant. Changing this creates a new router.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] value_specs: Map of additional driver-specific options.
        :param pulumi.Input['RouterVendorOptionsArgs'] vendor_options: Map of additional vendor-specific options.
               Supported options are described below.
        """
        if admin_state_up is not None:
            pulumi.set(__self__, "admin_state_up", admin_state_up)
        if availability_zone_hints is not None:
            pulumi.set(__self__, "availability_zone_hints", availability_zone_hints)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if distributed is not None:
            pulumi.set(__self__, "distributed", distributed)
        if enable_snat is not None:
            pulumi.set(__self__, "enable_snat", enable_snat)
        if external_fixed_ips is not None:
            pulumi.set(__self__, "external_fixed_ips", external_fixed_ips)
        if external_network_id is not None:
            pulumi.set(__self__, "external_network_id", external_network_id)
        if external_qos_policy_id is not None:
            pulumi.set(__self__, "external_qos_policy_id", external_qos_policy_id)
        if external_subnet_ids is not None:
            pulumi.set(__self__, "external_subnet_ids", external_subnet_ids)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if value_specs is not None:
            pulumi.set(__self__, "value_specs", value_specs)
        if vendor_options is not None:
            pulumi.set(__self__, "vendor_options", vendor_options)

    @property
    @pulumi.getter(name="adminStateUp")
    def admin_state_up(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Administrative up/down status for the router
        (must be "true" or "false" if provided). Changing this updates the
        `admin_state_up` of an existing router.
        """
        return pulumi.get(self, "admin_state_up")

    @admin_state_up.setter
    def admin_state_up(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "admin_state_up", value)

    @property
    @pulumi.getter(name="availabilityZoneHints")
    def availability_zone_hints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        An availability zone is used to make
        network resources highly available. Used for resources with high availability
        so that they are scheduled on different availability zones. Changing this
        creates a new router.
        """
        return pulumi.get(self, "availability_zone_hints")

    @availability_zone_hints.setter
    def availability_zone_hints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "availability_zone_hints", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Human-readable description for the router.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def distributed(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether or not to create a
        distributed router. The default policy setting in Neutron restricts
        usage of this property to administrative users only.
        """
        return pulumi.get(self, "distributed")

    @distributed.setter
    def distributed(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "distributed", value)

    @property
    @pulumi.getter(name="enableSnat")
    def enable_snat(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable Source NAT for the router. Valid values are
        "true" or "false". An `external_network_id` has to be set in order to
        set this property. Changing this updates the `enable_snat` of the router.
        Setting this value **requires** an **ext-gw-mode** extension to be enabled
        in OpenStack Neutron.
        """
        return pulumi.get(self, "enable_snat")

    @enable_snat.setter
    def enable_snat(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_snat", value)

    @property
    @pulumi.getter(name="externalFixedIps")
    def external_fixed_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RouterExternalFixedIpArgs']]]]:
        """
        An external fixed IP for the router. This
        can be repeated. The structure is described below. An `external_network_id`
        has to be set in order to set this property. Changing this updates the
        external fixed IPs of the router.
        """
        return pulumi.get(self, "external_fixed_ips")

    @external_fixed_ips.setter
    def external_fixed_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RouterExternalFixedIpArgs']]]]):
        pulumi.set(self, "external_fixed_ips", value)

    @property
    @pulumi.getter(name="externalNetworkId")
    def external_network_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The network UUID of an external gateway
        for the router. A router with an external gateway is required if any
        compute instances or load balancers will be using floating IPs. Changing
        this updates the external gateway of the router.
        """
        return pulumi.get(self, "external_network_id")

    @external_network_id.setter
    def external_network_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "external_network_id", value)

    @property
    @pulumi.getter(name="externalQosPolicyId")
    def external_qos_policy_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The QoS policy UUID that will be applied
        on the external gateway for the router. Changing this updates the external
        gateway of the router.
        """
        return pulumi.get(self, "external_qos_policy_id")

    @external_qos_policy_id.setter
    def external_qos_policy_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "external_qos_policy_id", value)

    @property
    @pulumi.getter(name="externalSubnetIds")
    def external_subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of external subnet IDs to try over
        each to obtain a fixed IP for the router. If a subnet ID in a list has
        exhausted floating IP pool, the next subnet ID will be tried. This argument is
        used only during the router creation and allows to set only one external fixed
        IP. Conflicts with an `external_fixed_ip` argument.
        """
        return pulumi.get(self, "external_subnet_ids")

    @external_subnet_ids.setter
    def external_subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "external_subnet_ids", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A unique name for the router. Changing this
        updates the `name` of an existing router.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The region in which to obtain the V2 networking client.
        A networking client is needed to create a router. If omitted, the
        `region` argument of the provider is used. Changing this creates a new
        router.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A set of string tags for the router.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The owner of the floating IP. Required if admin wants
        to create a router for another tenant. Changing this creates a new router.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="valueSpecs")
    def value_specs(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of additional driver-specific options.
        """
        return pulumi.get(self, "value_specs")

    @value_specs.setter
    def value_specs(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "value_specs", value)

    @property
    @pulumi.getter(name="vendorOptions")
    def vendor_options(self) -> Optional[pulumi.Input['RouterVendorOptionsArgs']]:
        """
        Map of additional vendor-specific options.
        Supported options are described below.
        """
        return pulumi.get(self, "vendor_options")

    @vendor_options.setter
    def vendor_options(self, value: Optional[pulumi.Input['RouterVendorOptionsArgs']]):
        pulumi.set(self, "vendor_options", value)


@pulumi.input_type
class _RouterState:
    def __init__(__self__, *,
                 admin_state_up: Optional[pulumi.Input[builtins.bool]] = None,
                 all_tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 availability_zone_hints: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 distributed: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_snat: Optional[pulumi.Input[builtins.bool]] = None,
                 external_fixed_ips: Optional[pulumi.Input[Sequence[pulumi.Input['RouterExternalFixedIpArgs']]]] = None,
                 external_network_id: Optional[pulumi.Input[builtins.str]] = None,
                 external_qos_policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 external_subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tenant_id: Optional[pulumi.Input[builtins.str]] = None,
                 value_specs: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 vendor_options: Optional[pulumi.Input['RouterVendorOptionsArgs']] = None):
        """
        Input properties used for looking up and filtering Router resources.
        :param pulumi.Input[builtins.bool] admin_state_up: Administrative up/down status for the router
               (must be "true" or "false" if provided). Changing this updates the
               `admin_state_up` of an existing router.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] all_tags: The collection of tags assigned on the router, which have been
               explicitly and implicitly added.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] availability_zone_hints: An availability zone is used to make
               network resources highly available. Used for resources with high availability
               so that they are scheduled on different availability zones. Changing this
               creates a new router.
        :param pulumi.Input[builtins.str] description: Human-readable description for the router.
        :param pulumi.Input[builtins.bool] distributed: Indicates whether or not to create a
               distributed router. The default policy setting in Neutron restricts
               usage of this property to administrative users only.
        :param pulumi.Input[builtins.bool] enable_snat: Enable Source NAT for the router. Valid values are
               "true" or "false". An `external_network_id` has to be set in order to
               set this property. Changing this updates the `enable_snat` of the router.
               Setting this value **requires** an **ext-gw-mode** extension to be enabled
               in OpenStack Neutron.
        :param pulumi.Input[Sequence[pulumi.Input['RouterExternalFixedIpArgs']]] external_fixed_ips: An external fixed IP for the router. This
               can be repeated. The structure is described below. An `external_network_id`
               has to be set in order to set this property. Changing this updates the
               external fixed IPs of the router.
        :param pulumi.Input[builtins.str] external_network_id: The network UUID of an external gateway
               for the router. A router with an external gateway is required if any
               compute instances or load balancers will be using floating IPs. Changing
               this updates the external gateway of the router.
        :param pulumi.Input[builtins.str] external_qos_policy_id: The QoS policy UUID that will be applied
               on the external gateway for the router. Changing this updates the external
               gateway of the router.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] external_subnet_ids: A list of external subnet IDs to try over
               each to obtain a fixed IP for the router. If a subnet ID in a list has
               exhausted floating IP pool, the next subnet ID will be tried. This argument is
               used only during the router creation and allows to set only one external fixed
               IP. Conflicts with an `external_fixed_ip` argument.
        :param pulumi.Input[builtins.str] name: A unique name for the router. Changing this
               updates the `name` of an existing router.
        :param pulumi.Input[builtins.str] region: The region in which to obtain the V2 networking client.
               A networking client is needed to create a router. If omitted, the
               `region` argument of the provider is used. Changing this creates a new
               router.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: A set of string tags for the router.
        :param pulumi.Input[builtins.str] tenant_id: The owner of the floating IP. Required if admin wants
               to create a router for another tenant. Changing this creates a new router.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] value_specs: Map of additional driver-specific options.
        :param pulumi.Input['RouterVendorOptionsArgs'] vendor_options: Map of additional vendor-specific options.
               Supported options are described below.
        """
        if admin_state_up is not None:
            pulumi.set(__self__, "admin_state_up", admin_state_up)
        if all_tags is not None:
            pulumi.set(__self__, "all_tags", all_tags)
        if availability_zone_hints is not None:
            pulumi.set(__self__, "availability_zone_hints", availability_zone_hints)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if distributed is not None:
            pulumi.set(__self__, "distributed", distributed)
        if enable_snat is not None:
            pulumi.set(__self__, "enable_snat", enable_snat)
        if external_fixed_ips is not None:
            pulumi.set(__self__, "external_fixed_ips", external_fixed_ips)
        if external_network_id is not None:
            pulumi.set(__self__, "external_network_id", external_network_id)
        if external_qos_policy_id is not None:
            pulumi.set(__self__, "external_qos_policy_id", external_qos_policy_id)
        if external_subnet_ids is not None:
            pulumi.set(__self__, "external_subnet_ids", external_subnet_ids)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if value_specs is not None:
            pulumi.set(__self__, "value_specs", value_specs)
        if vendor_options is not None:
            pulumi.set(__self__, "vendor_options", vendor_options)

    @property
    @pulumi.getter(name="adminStateUp")
    def admin_state_up(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Administrative up/down status for the router
        (must be "true" or "false" if provided). Changing this updates the
        `admin_state_up` of an existing router.
        """
        return pulumi.get(self, "admin_state_up")

    @admin_state_up.setter
    def admin_state_up(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "admin_state_up", value)

    @property
    @pulumi.getter(name="allTags")
    def all_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The collection of tags assigned on the router, which have been
        explicitly and implicitly added.
        """
        return pulumi.get(self, "all_tags")

    @all_tags.setter
    def all_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "all_tags", value)

    @property
    @pulumi.getter(name="availabilityZoneHints")
    def availability_zone_hints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        An availability zone is used to make
        network resources highly available. Used for resources with high availability
        so that they are scheduled on different availability zones. Changing this
        creates a new router.
        """
        return pulumi.get(self, "availability_zone_hints")

    @availability_zone_hints.setter
    def availability_zone_hints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "availability_zone_hints", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Human-readable description for the router.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def distributed(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether or not to create a
        distributed router. The default policy setting in Neutron restricts
        usage of this property to administrative users only.
        """
        return pulumi.get(self, "distributed")

    @distributed.setter
    def distributed(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "distributed", value)

    @property
    @pulumi.getter(name="enableSnat")
    def enable_snat(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable Source NAT for the router. Valid values are
        "true" or "false". An `external_network_id` has to be set in order to
        set this property. Changing this updates the `enable_snat` of the router.
        Setting this value **requires** an **ext-gw-mode** extension to be enabled
        in OpenStack Neutron.
        """
        return pulumi.get(self, "enable_snat")

    @enable_snat.setter
    def enable_snat(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_snat", value)

    @property
    @pulumi.getter(name="externalFixedIps")
    def external_fixed_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RouterExternalFixedIpArgs']]]]:
        """
        An external fixed IP for the router. This
        can be repeated. The structure is described below. An `external_network_id`
        has to be set in order to set this property. Changing this updates the
        external fixed IPs of the router.
        """
        return pulumi.get(self, "external_fixed_ips")

    @external_fixed_ips.setter
    def external_fixed_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RouterExternalFixedIpArgs']]]]):
        pulumi.set(self, "external_fixed_ips", value)

    @property
    @pulumi.getter(name="externalNetworkId")
    def external_network_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The network UUID of an external gateway
        for the router. A router with an external gateway is required if any
        compute instances or load balancers will be using floating IPs. Changing
        this updates the external gateway of the router.
        """
        return pulumi.get(self, "external_network_id")

    @external_network_id.setter
    def external_network_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "external_network_id", value)

    @property
    @pulumi.getter(name="externalQosPolicyId")
    def external_qos_policy_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The QoS policy UUID that will be applied
        on the external gateway for the router. Changing this updates the external
        gateway of the router.
        """
        return pulumi.get(self, "external_qos_policy_id")

    @external_qos_policy_id.setter
    def external_qos_policy_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "external_qos_policy_id", value)

    @property
    @pulumi.getter(name="externalSubnetIds")
    def external_subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of external subnet IDs to try over
        each to obtain a fixed IP for the router. If a subnet ID in a list has
        exhausted floating IP pool, the next subnet ID will be tried. This argument is
        used only during the router creation and allows to set only one external fixed
        IP. Conflicts with an `external_fixed_ip` argument.
        """
        return pulumi.get(self, "external_subnet_ids")

    @external_subnet_ids.setter
    def external_subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "external_subnet_ids", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A unique name for the router. Changing this
        updates the `name` of an existing router.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The region in which to obtain the V2 networking client.
        A networking client is needed to create a router. If omitted, the
        `region` argument of the provider is used. Changing this creates a new
        router.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A set of string tags for the router.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The owner of the floating IP. Required if admin wants
        to create a router for another tenant. Changing this creates a new router.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="valueSpecs")
    def value_specs(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of additional driver-specific options.
        """
        return pulumi.get(self, "value_specs")

    @value_specs.setter
    def value_specs(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "value_specs", value)

    @property
    @pulumi.getter(name="vendorOptions")
    def vendor_options(self) -> Optional[pulumi.Input['RouterVendorOptionsArgs']]:
        """
        Map of additional vendor-specific options.
        Supported options are described below.
        """
        return pulumi.get(self, "vendor_options")

    @vendor_options.setter
    def vendor_options(self, value: Optional[pulumi.Input['RouterVendorOptionsArgs']]):
        pulumi.set(self, "vendor_options", value)


@pulumi.type_token("openstack:networking/router:Router")
class Router(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_state_up: Optional[pulumi.Input[builtins.bool]] = None,
                 availability_zone_hints: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 distributed: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_snat: Optional[pulumi.Input[builtins.bool]] = None,
                 external_fixed_ips: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RouterExternalFixedIpArgs', 'RouterExternalFixedIpArgsDict']]]]] = None,
                 external_network_id: Optional[pulumi.Input[builtins.str]] = None,
                 external_qos_policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 external_subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tenant_id: Optional[pulumi.Input[builtins.str]] = None,
                 value_specs: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 vendor_options: Optional[pulumi.Input[Union['RouterVendorOptionsArgs', 'RouterVendorOptionsArgsDict']]] = None,
                 __props__=None):
        """
        Manages a V2 router resource within OpenStack.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_openstack as openstack

        router1 = openstack.networking.Router("router_1",
            name="my_router",
            admin_state_up=True,
            external_network_id="f67f0d72-0ddf-11e4-9d95-e1f29f417e2f")
        ```

        ## Import

        Routers can be imported using the `id`, e.g.

        ```sh
        $ pulumi import openstack:networking/router:Router router_1 014395cd-89fc-4c9b-96b7-13d1ee79dad2
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] admin_state_up: Administrative up/down status for the router
               (must be "true" or "false" if provided). Changing this updates the
               `admin_state_up` of an existing router.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] availability_zone_hints: An availability zone is used to make
               network resources highly available. Used for resources with high availability
               so that they are scheduled on different availability zones. Changing this
               creates a new router.
        :param pulumi.Input[builtins.str] description: Human-readable description for the router.
        :param pulumi.Input[builtins.bool] distributed: Indicates whether or not to create a
               distributed router. The default policy setting in Neutron restricts
               usage of this property to administrative users only.
        :param pulumi.Input[builtins.bool] enable_snat: Enable Source NAT for the router. Valid values are
               "true" or "false". An `external_network_id` has to be set in order to
               set this property. Changing this updates the `enable_snat` of the router.
               Setting this value **requires** an **ext-gw-mode** extension to be enabled
               in OpenStack Neutron.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RouterExternalFixedIpArgs', 'RouterExternalFixedIpArgsDict']]]] external_fixed_ips: An external fixed IP for the router. This
               can be repeated. The structure is described below. An `external_network_id`
               has to be set in order to set this property. Changing this updates the
               external fixed IPs of the router.
        :param pulumi.Input[builtins.str] external_network_id: The network UUID of an external gateway
               for the router. A router with an external gateway is required if any
               compute instances or load balancers will be using floating IPs. Changing
               this updates the external gateway of the router.
        :param pulumi.Input[builtins.str] external_qos_policy_id: The QoS policy UUID that will be applied
               on the external gateway for the router. Changing this updates the external
               gateway of the router.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] external_subnet_ids: A list of external subnet IDs to try over
               each to obtain a fixed IP for the router. If a subnet ID in a list has
               exhausted floating IP pool, the next subnet ID will be tried. This argument is
               used only during the router creation and allows to set only one external fixed
               IP. Conflicts with an `external_fixed_ip` argument.
        :param pulumi.Input[builtins.str] name: A unique name for the router. Changing this
               updates the `name` of an existing router.
        :param pulumi.Input[builtins.str] region: The region in which to obtain the V2 networking client.
               A networking client is needed to create a router. If omitted, the
               `region` argument of the provider is used. Changing this creates a new
               router.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: A set of string tags for the router.
        :param pulumi.Input[builtins.str] tenant_id: The owner of the floating IP. Required if admin wants
               to create a router for another tenant. Changing this creates a new router.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] value_specs: Map of additional driver-specific options.
        :param pulumi.Input[Union['RouterVendorOptionsArgs', 'RouterVendorOptionsArgsDict']] vendor_options: Map of additional vendor-specific options.
               Supported options are described below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[RouterArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a V2 router resource within OpenStack.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_openstack as openstack

        router1 = openstack.networking.Router("router_1",
            name="my_router",
            admin_state_up=True,
            external_network_id="f67f0d72-0ddf-11e4-9d95-e1f29f417e2f")
        ```

        ## Import

        Routers can be imported using the `id`, e.g.

        ```sh
        $ pulumi import openstack:networking/router:Router router_1 014395cd-89fc-4c9b-96b7-13d1ee79dad2
        ```

        :param str resource_name: The name of the resource.
        :param RouterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RouterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_state_up: Optional[pulumi.Input[builtins.bool]] = None,
                 availability_zone_hints: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 distributed: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_snat: Optional[pulumi.Input[builtins.bool]] = None,
                 external_fixed_ips: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RouterExternalFixedIpArgs', 'RouterExternalFixedIpArgsDict']]]]] = None,
                 external_network_id: Optional[pulumi.Input[builtins.str]] = None,
                 external_qos_policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 external_subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tenant_id: Optional[pulumi.Input[builtins.str]] = None,
                 value_specs: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 vendor_options: Optional[pulumi.Input[Union['RouterVendorOptionsArgs', 'RouterVendorOptionsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RouterArgs.__new__(RouterArgs)

            __props__.__dict__["admin_state_up"] = admin_state_up
            __props__.__dict__["availability_zone_hints"] = availability_zone_hints
            __props__.__dict__["description"] = description
            __props__.__dict__["distributed"] = distributed
            __props__.__dict__["enable_snat"] = enable_snat
            __props__.__dict__["external_fixed_ips"] = external_fixed_ips
            __props__.__dict__["external_network_id"] = external_network_id
            __props__.__dict__["external_qos_policy_id"] = external_qos_policy_id
            __props__.__dict__["external_subnet_ids"] = external_subnet_ids
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            __props__.__dict__["tags"] = tags
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["value_specs"] = value_specs
            __props__.__dict__["vendor_options"] = vendor_options
            __props__.__dict__["all_tags"] = None
        super(Router, __self__).__init__(
            'openstack:networking/router:Router',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            admin_state_up: Optional[pulumi.Input[builtins.bool]] = None,
            all_tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            availability_zone_hints: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            distributed: Optional[pulumi.Input[builtins.bool]] = None,
            enable_snat: Optional[pulumi.Input[builtins.bool]] = None,
            external_fixed_ips: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RouterExternalFixedIpArgs', 'RouterExternalFixedIpArgsDict']]]]] = None,
            external_network_id: Optional[pulumi.Input[builtins.str]] = None,
            external_qos_policy_id: Optional[pulumi.Input[builtins.str]] = None,
            external_subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            tenant_id: Optional[pulumi.Input[builtins.str]] = None,
            value_specs: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            vendor_options: Optional[pulumi.Input[Union['RouterVendorOptionsArgs', 'RouterVendorOptionsArgsDict']]] = None) -> 'Router':
        """
        Get an existing Router resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] admin_state_up: Administrative up/down status for the router
               (must be "true" or "false" if provided). Changing this updates the
               `admin_state_up` of an existing router.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] all_tags: The collection of tags assigned on the router, which have been
               explicitly and implicitly added.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] availability_zone_hints: An availability zone is used to make
               network resources highly available. Used for resources with high availability
               so that they are scheduled on different availability zones. Changing this
               creates a new router.
        :param pulumi.Input[builtins.str] description: Human-readable description for the router.
        :param pulumi.Input[builtins.bool] distributed: Indicates whether or not to create a
               distributed router. The default policy setting in Neutron restricts
               usage of this property to administrative users only.
        :param pulumi.Input[builtins.bool] enable_snat: Enable Source NAT for the router. Valid values are
               "true" or "false". An `external_network_id` has to be set in order to
               set this property. Changing this updates the `enable_snat` of the router.
               Setting this value **requires** an **ext-gw-mode** extension to be enabled
               in OpenStack Neutron.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RouterExternalFixedIpArgs', 'RouterExternalFixedIpArgsDict']]]] external_fixed_ips: An external fixed IP for the router. This
               can be repeated. The structure is described below. An `external_network_id`
               has to be set in order to set this property. Changing this updates the
               external fixed IPs of the router.
        :param pulumi.Input[builtins.str] external_network_id: The network UUID of an external gateway
               for the router. A router with an external gateway is required if any
               compute instances or load balancers will be using floating IPs. Changing
               this updates the external gateway of the router.
        :param pulumi.Input[builtins.str] external_qos_policy_id: The QoS policy UUID that will be applied
               on the external gateway for the router. Changing this updates the external
               gateway of the router.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] external_subnet_ids: A list of external subnet IDs to try over
               each to obtain a fixed IP for the router. If a subnet ID in a list has
               exhausted floating IP pool, the next subnet ID will be tried. This argument is
               used only during the router creation and allows to set only one external fixed
               IP. Conflicts with an `external_fixed_ip` argument.
        :param pulumi.Input[builtins.str] name: A unique name for the router. Changing this
               updates the `name` of an existing router.
        :param pulumi.Input[builtins.str] region: The region in which to obtain the V2 networking client.
               A networking client is needed to create a router. If omitted, the
               `region` argument of the provider is used. Changing this creates a new
               router.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: A set of string tags for the router.
        :param pulumi.Input[builtins.str] tenant_id: The owner of the floating IP. Required if admin wants
               to create a router for another tenant. Changing this creates a new router.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] value_specs: Map of additional driver-specific options.
        :param pulumi.Input[Union['RouterVendorOptionsArgs', 'RouterVendorOptionsArgsDict']] vendor_options: Map of additional vendor-specific options.
               Supported options are described below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RouterState.__new__(_RouterState)

        __props__.__dict__["admin_state_up"] = admin_state_up
        __props__.__dict__["all_tags"] = all_tags
        __props__.__dict__["availability_zone_hints"] = availability_zone_hints
        __props__.__dict__["description"] = description
        __props__.__dict__["distributed"] = distributed
        __props__.__dict__["enable_snat"] = enable_snat
        __props__.__dict__["external_fixed_ips"] = external_fixed_ips
        __props__.__dict__["external_network_id"] = external_network_id
        __props__.__dict__["external_qos_policy_id"] = external_qos_policy_id
        __props__.__dict__["external_subnet_ids"] = external_subnet_ids
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["value_specs"] = value_specs
        __props__.__dict__["vendor_options"] = vendor_options
        return Router(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="adminStateUp")
    def admin_state_up(self) -> pulumi.Output[builtins.bool]:
        """
        Administrative up/down status for the router
        (must be "true" or "false" if provided). Changing this updates the
        `admin_state_up` of an existing router.
        """
        return pulumi.get(self, "admin_state_up")

    @property
    @pulumi.getter(name="allTags")
    def all_tags(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        The collection of tags assigned on the router, which have been
        explicitly and implicitly added.
        """
        return pulumi.get(self, "all_tags")

    @property
    @pulumi.getter(name="availabilityZoneHints")
    def availability_zone_hints(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        An availability zone is used to make
        network resources highly available. Used for resources with high availability
        so that they are scheduled on different availability zones. Changing this
        creates a new router.
        """
        return pulumi.get(self, "availability_zone_hints")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Human-readable description for the router.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def distributed(self) -> pulumi.Output[builtins.bool]:
        """
        Indicates whether or not to create a
        distributed router. The default policy setting in Neutron restricts
        usage of this property to administrative users only.
        """
        return pulumi.get(self, "distributed")

    @property
    @pulumi.getter(name="enableSnat")
    def enable_snat(self) -> pulumi.Output[builtins.bool]:
        """
        Enable Source NAT for the router. Valid values are
        "true" or "false". An `external_network_id` has to be set in order to
        set this property. Changing this updates the `enable_snat` of the router.
        Setting this value **requires** an **ext-gw-mode** extension to be enabled
        in OpenStack Neutron.
        """
        return pulumi.get(self, "enable_snat")

    @property
    @pulumi.getter(name="externalFixedIps")
    def external_fixed_ips(self) -> pulumi.Output[Sequence['outputs.RouterExternalFixedIp']]:
        """
        An external fixed IP for the router. This
        can be repeated. The structure is described below. An `external_network_id`
        has to be set in order to set this property. Changing this updates the
        external fixed IPs of the router.
        """
        return pulumi.get(self, "external_fixed_ips")

    @property
    @pulumi.getter(name="externalNetworkId")
    def external_network_id(self) -> pulumi.Output[builtins.str]:
        """
        The network UUID of an external gateway
        for the router. A router with an external gateway is required if any
        compute instances or load balancers will be using floating IPs. Changing
        this updates the external gateway of the router.
        """
        return pulumi.get(self, "external_network_id")

    @property
    @pulumi.getter(name="externalQosPolicyId")
    def external_qos_policy_id(self) -> pulumi.Output[builtins.str]:
        """
        The QoS policy UUID that will be applied
        on the external gateway for the router. Changing this updates the external
        gateway of the router.
        """
        return pulumi.get(self, "external_qos_policy_id")

    @property
    @pulumi.getter(name="externalSubnetIds")
    def external_subnet_ids(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        A list of external subnet IDs to try over
        each to obtain a fixed IP for the router. If a subnet ID in a list has
        exhausted floating IP pool, the next subnet ID will be tried. This argument is
        used only during the router creation and allows to set only one external fixed
        IP. Conflicts with an `external_fixed_ip` argument.
        """
        return pulumi.get(self, "external_subnet_ids")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        A unique name for the router. Changing this
        updates the `name` of an existing router.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        The region in which to obtain the V2 networking client.
        A networking client is needed to create a router. If omitted, the
        `region` argument of the provider is used. Changing this creates a new
        router.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        A set of string tags for the router.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[builtins.str]:
        """
        The owner of the floating IP. Required if admin wants
        to create a router for another tenant. Changing this creates a new router.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter(name="valueSpecs")
    def value_specs(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Map of additional driver-specific options.
        """
        return pulumi.get(self, "value_specs")

    @property
    @pulumi.getter(name="vendorOptions")
    def vendor_options(self) -> pulumi.Output[Optional['outputs.RouterVendorOptions']]:
        """
        Map of additional vendor-specific options.
        Supported options are described below.
        """
        return pulumi.get(self, "vendor_options")

