# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RouterRoutesV2Args', 'RouterRoutesV2']

@pulumi.input_type
class RouterRoutesV2Args:
    def __init__(__self__, *,
                 router_id: pulumi.Input[builtins.str],
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 routes: Optional[pulumi.Input[Sequence[pulumi.Input['RouterRoutesV2RouteArgs']]]] = None):
        """
        The set of arguments for constructing a RouterRoutesV2 resource.
        :param pulumi.Input[builtins.str] router_id: ID of the router these routing entries belong to.
               Changing this creates new routing entries.
        :param pulumi.Input[builtins.str] region: The region in which to obtain the V2 networking client.
               A networking client is needed to configure routing entres on a router. If
               omitted, the `region` argument of the provider is used. Changing this creates
               new routing entries.
        :param pulumi.Input[Sequence[pulumi.Input['RouterRoutesV2RouteArgs']]] routes: A set of routing entries to add to the router.
        """
        pulumi.set(__self__, "router_id", router_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if routes is not None:
            pulumi.set(__self__, "routes", routes)

    @property
    @pulumi.getter(name="routerId")
    def router_id(self) -> pulumi.Input[builtins.str]:
        """
        ID of the router these routing entries belong to.
        Changing this creates new routing entries.
        """
        return pulumi.get(self, "router_id")

    @router_id.setter
    def router_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "router_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The region in which to obtain the V2 networking client.
        A networking client is needed to configure routing entres on a router. If
        omitted, the `region` argument of the provider is used. Changing this creates
        new routing entries.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RouterRoutesV2RouteArgs']]]]:
        """
        A set of routing entries to add to the router.
        """
        return pulumi.get(self, "routes")

    @routes.setter
    def routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RouterRoutesV2RouteArgs']]]]):
        pulumi.set(self, "routes", value)


@pulumi.input_type
class _RouterRoutesV2State:
    def __init__(__self__, *,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 router_id: Optional[pulumi.Input[builtins.str]] = None,
                 routes: Optional[pulumi.Input[Sequence[pulumi.Input['RouterRoutesV2RouteArgs']]]] = None):
        """
        Input properties used for looking up and filtering RouterRoutesV2 resources.
        :param pulumi.Input[builtins.str] region: The region in which to obtain the V2 networking client.
               A networking client is needed to configure routing entres on a router. If
               omitted, the `region` argument of the provider is used. Changing this creates
               new routing entries.
        :param pulumi.Input[builtins.str] router_id: ID of the router these routing entries belong to.
               Changing this creates new routing entries.
        :param pulumi.Input[Sequence[pulumi.Input['RouterRoutesV2RouteArgs']]] routes: A set of routing entries to add to the router.
        """
        if region is not None:
            pulumi.set(__self__, "region", region)
        if router_id is not None:
            pulumi.set(__self__, "router_id", router_id)
        if routes is not None:
            pulumi.set(__self__, "routes", routes)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The region in which to obtain the V2 networking client.
        A networking client is needed to configure routing entres on a router. If
        omitted, the `region` argument of the provider is used. Changing this creates
        new routing entries.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="routerId")
    def router_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID of the router these routing entries belong to.
        Changing this creates new routing entries.
        """
        return pulumi.get(self, "router_id")

    @router_id.setter
    def router_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "router_id", value)

    @property
    @pulumi.getter
    def routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RouterRoutesV2RouteArgs']]]]:
        """
        A set of routing entries to add to the router.
        """
        return pulumi.get(self, "routes")

    @routes.setter
    def routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RouterRoutesV2RouteArgs']]]]):
        pulumi.set(self, "routes", value)


@pulumi.type_token("openstack:networking/routerRoutesV2:RouterRoutesV2")
class RouterRoutesV2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 router_id: Optional[pulumi.Input[builtins.str]] = None,
                 routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RouterRoutesV2RouteArgs', 'RouterRoutesV2RouteArgsDict']]]]] = None,
                 __props__=None):
        """
        Creates routing entries on a OpenStack V2 router.

        > **Note:** This resource uses the OpenStack Neutron `extraroute-atomic`
        extension. If your environment does not have this extension, you should use the
        `networking.RouterRoute` resource to add routes instead.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_openstack as openstack

        router1 = openstack.networking.Router("router_1",
            name="router_1",
            admin_state_up=True)
        network1 = openstack.networking.Network("network_1",
            name="network_1",
            admin_state_up=True)
        subnet1 = openstack.networking.Subnet("subnet_1",
            network_id=network1.id,
            cidr="192.168.199.0/24",
            ip_version=4)
        int1 = openstack.networking.RouterInterface("int_1",
            router_id=router1.id,
            subnet_id=subnet1.id)
        router_routes1 = openstack.networking.RouterRoutesV2("router_routes_1",
            router_id=int1.router_id,
            routes=[
                {
                    "destination_cidr": "10.0.1.0/24",
                    "next_hop": "192.168.199.254",
                },
                {
                    "destination_cidr": "10.0.2.0/24",
                    "next_hop": "192.168.199.254",
                },
            ])
        ```

        ## Notes

        The `next_hop` IP address must be directly reachable from the router at the
        ``networking.RouterRoutesV2`` resource creation time.  You can
        ensure that by explicitly specifying a dependency on the
        ``networking.RouterInterface`` resource that connects the next
        hop to the router, as in the example above.

        ## Import

        Routing entries can be imported using a router `id`:

        ```sh
        $ pulumi import openstack:networking/routerRoutesV2:RouterRoutesV2 router_routes_1 686fe248-386c-4f70-9f6c-281607dad079
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] region: The region in which to obtain the V2 networking client.
               A networking client is needed to configure routing entres on a router. If
               omitted, the `region` argument of the provider is used. Changing this creates
               new routing entries.
        :param pulumi.Input[builtins.str] router_id: ID of the router these routing entries belong to.
               Changing this creates new routing entries.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RouterRoutesV2RouteArgs', 'RouterRoutesV2RouteArgsDict']]]] routes: A set of routing entries to add to the router.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RouterRoutesV2Args,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates routing entries on a OpenStack V2 router.

        > **Note:** This resource uses the OpenStack Neutron `extraroute-atomic`
        extension. If your environment does not have this extension, you should use the
        `networking.RouterRoute` resource to add routes instead.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_openstack as openstack

        router1 = openstack.networking.Router("router_1",
            name="router_1",
            admin_state_up=True)
        network1 = openstack.networking.Network("network_1",
            name="network_1",
            admin_state_up=True)
        subnet1 = openstack.networking.Subnet("subnet_1",
            network_id=network1.id,
            cidr="192.168.199.0/24",
            ip_version=4)
        int1 = openstack.networking.RouterInterface("int_1",
            router_id=router1.id,
            subnet_id=subnet1.id)
        router_routes1 = openstack.networking.RouterRoutesV2("router_routes_1",
            router_id=int1.router_id,
            routes=[
                {
                    "destination_cidr": "10.0.1.0/24",
                    "next_hop": "192.168.199.254",
                },
                {
                    "destination_cidr": "10.0.2.0/24",
                    "next_hop": "192.168.199.254",
                },
            ])
        ```

        ## Notes

        The `next_hop` IP address must be directly reachable from the router at the
        ``networking.RouterRoutesV2`` resource creation time.  You can
        ensure that by explicitly specifying a dependency on the
        ``networking.RouterInterface`` resource that connects the next
        hop to the router, as in the example above.

        ## Import

        Routing entries can be imported using a router `id`:

        ```sh
        $ pulumi import openstack:networking/routerRoutesV2:RouterRoutesV2 router_routes_1 686fe248-386c-4f70-9f6c-281607dad079
        ```

        :param str resource_name: The name of the resource.
        :param RouterRoutesV2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RouterRoutesV2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 router_id: Optional[pulumi.Input[builtins.str]] = None,
                 routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RouterRoutesV2RouteArgs', 'RouterRoutesV2RouteArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RouterRoutesV2Args.__new__(RouterRoutesV2Args)

            __props__.__dict__["region"] = region
            if router_id is None and not opts.urn:
                raise TypeError("Missing required property 'router_id'")
            __props__.__dict__["router_id"] = router_id
            __props__.__dict__["routes"] = routes
        super(RouterRoutesV2, __self__).__init__(
            'openstack:networking/routerRoutesV2:RouterRoutesV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            router_id: Optional[pulumi.Input[builtins.str]] = None,
            routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RouterRoutesV2RouteArgs', 'RouterRoutesV2RouteArgsDict']]]]] = None) -> 'RouterRoutesV2':
        """
        Get an existing RouterRoutesV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] region: The region in which to obtain the V2 networking client.
               A networking client is needed to configure routing entres on a router. If
               omitted, the `region` argument of the provider is used. Changing this creates
               new routing entries.
        :param pulumi.Input[builtins.str] router_id: ID of the router these routing entries belong to.
               Changing this creates new routing entries.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RouterRoutesV2RouteArgs', 'RouterRoutesV2RouteArgsDict']]]] routes: A set of routing entries to add to the router.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RouterRoutesV2State.__new__(_RouterRoutesV2State)

        __props__.__dict__["region"] = region
        __props__.__dict__["router_id"] = router_id
        __props__.__dict__["routes"] = routes
        return RouterRoutesV2(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        The region in which to obtain the V2 networking client.
        A networking client is needed to configure routing entres on a router. If
        omitted, the `region` argument of the provider is used. Changing this creates
        new routing entries.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="routerId")
    def router_id(self) -> pulumi.Output[builtins.str]:
        """
        ID of the router these routing entries belong to.
        Changing this creates new routing entries.
        """
        return pulumi.get(self, "router_id")

    @property
    @pulumi.getter
    def routes(self) -> pulumi.Output[Optional[Sequence['outputs.RouterRoutesV2Route']]]:
        """
        A set of routing entries to add to the router.
        """
        return pulumi.get(self, "routes")

