# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SegmentV2Args', 'SegmentV2']

@pulumi.input_type
class SegmentV2Args:
    def __init__(__self__, *,
                 network_id: pulumi.Input[builtins.str],
                 network_type: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 physical_network: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 segmentation_id: Optional[pulumi.Input[builtins.int]] = None):
        """
        The set of arguments for constructing a SegmentV2 resource.
        :param pulumi.Input[builtins.str] network_id: The UUID of the network this segment belongs to.
               Changing this will create a new segment.
        :param pulumi.Input[builtins.str] network_type: The network type. Valid values depend on the
               backend (e.g., `vlan`, `vxlan`, `flat`, `gre`, `geneve`, `local`). Changing
               this will create a new segment.
        :param pulumi.Input[builtins.str] description: A description for the segment.
        :param pulumi.Input[builtins.str] name: A name for the segment.
        :param pulumi.Input[builtins.str] physical_network: The name of the physical network. Changing this
               will create a new segment.
        :param pulumi.Input[builtins.str] region: The region in which to obtain the V2 Networking client.
               A Networking client is needed to create a Neutron network. If omitted, the
               `region` argument of the provider is used. Changing this creates a new
               segment.
        :param pulumi.Input[builtins.int] segmentation_id: A segmentation identifier. Changing is allowed
               only for `vlan`.
        """
        pulumi.set(__self__, "network_id", network_id)
        pulumi.set(__self__, "network_type", network_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if physical_network is not None:
            pulumi.set(__self__, "physical_network", physical_network)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if segmentation_id is not None:
            pulumi.set(__self__, "segmentation_id", segmentation_id)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[builtins.str]:
        """
        The UUID of the network this segment belongs to.
        Changing this will create a new segment.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter(name="networkType")
    def network_type(self) -> pulumi.Input[builtins.str]:
        """
        The network type. Valid values depend on the
        backend (e.g., `vlan`, `vxlan`, `flat`, `gre`, `geneve`, `local`). Changing
        this will create a new segment.
        """
        return pulumi.get(self, "network_type")

    @network_type.setter
    def network_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "network_type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A description for the segment.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A name for the segment.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="physicalNetwork")
    def physical_network(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the physical network. Changing this
        will create a new segment.
        """
        return pulumi.get(self, "physical_network")

    @physical_network.setter
    def physical_network(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "physical_network", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The region in which to obtain the V2 Networking client.
        A Networking client is needed to create a Neutron network. If omitted, the
        `region` argument of the provider is used. Changing this creates a new
        segment.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="segmentationId")
    def segmentation_id(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        A segmentation identifier. Changing is allowed
        only for `vlan`.
        """
        return pulumi.get(self, "segmentation_id")

    @segmentation_id.setter
    def segmentation_id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "segmentation_id", value)


@pulumi.input_type
class _SegmentV2State:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_id: Optional[pulumi.Input[builtins.str]] = None,
                 network_type: Optional[pulumi.Input[builtins.str]] = None,
                 physical_network: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 revision_number: Optional[pulumi.Input[builtins.int]] = None,
                 segmentation_id: Optional[pulumi.Input[builtins.int]] = None,
                 updated_at: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering SegmentV2 resources.
        :param pulumi.Input[builtins.str] created_at: Creation timestamp (RFC3339 format).
        :param pulumi.Input[builtins.str] description: A description for the segment.
        :param pulumi.Input[builtins.str] name: A name for the segment.
        :param pulumi.Input[builtins.str] network_id: The UUID of the network this segment belongs to.
               Changing this will create a new segment.
        :param pulumi.Input[builtins.str] network_type: The network type. Valid values depend on the
               backend (e.g., `vlan`, `vxlan`, `flat`, `gre`, `geneve`, `local`). Changing
               this will create a new segment.
        :param pulumi.Input[builtins.str] physical_network: The name of the physical network. Changing this
               will create a new segment.
        :param pulumi.Input[builtins.str] region: The region in which to obtain the V2 Networking client.
               A Networking client is needed to create a Neutron network. If omitted, the
               `region` argument of the provider is used. Changing this creates a new
               segment.
        :param pulumi.Input[builtins.int] revision_number: The revision number of the segment.
        :param pulumi.Input[builtins.int] segmentation_id: A segmentation identifier. Changing is allowed
               only for `vlan`.
        :param pulumi.Input[builtins.str] updated_at: Last update timestamp (RFC3339 format).
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if network_type is not None:
            pulumi.set(__self__, "network_type", network_type)
        if physical_network is not None:
            pulumi.set(__self__, "physical_network", physical_network)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if revision_number is not None:
            pulumi.set(__self__, "revision_number", revision_number)
        if segmentation_id is not None:
            pulumi.set(__self__, "segmentation_id", segmentation_id)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Creation timestamp (RFC3339 format).
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A description for the segment.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A name for the segment.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The UUID of the network this segment belongs to.
        Changing this will create a new segment.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter(name="networkType")
    def network_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The network type. Valid values depend on the
        backend (e.g., `vlan`, `vxlan`, `flat`, `gre`, `geneve`, `local`). Changing
        this will create a new segment.
        """
        return pulumi.get(self, "network_type")

    @network_type.setter
    def network_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network_type", value)

    @property
    @pulumi.getter(name="physicalNetwork")
    def physical_network(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the physical network. Changing this
        will create a new segment.
        """
        return pulumi.get(self, "physical_network")

    @physical_network.setter
    def physical_network(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "physical_network", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The region in which to obtain the V2 Networking client.
        A Networking client is needed to create a Neutron network. If omitted, the
        `region` argument of the provider is used. Changing this creates a new
        segment.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="revisionNumber")
    def revision_number(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The revision number of the segment.
        """
        return pulumi.get(self, "revision_number")

    @revision_number.setter
    def revision_number(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "revision_number", value)

    @property
    @pulumi.getter(name="segmentationId")
    def segmentation_id(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        A segmentation identifier. Changing is allowed
        only for `vlan`.
        """
        return pulumi.get(self, "segmentation_id")

    @segmentation_id.setter
    def segmentation_id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "segmentation_id", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Last update timestamp (RFC3339 format).
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "updated_at", value)


@pulumi.type_token("openstack:networking/segmentV2:SegmentV2")
class SegmentV2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_id: Optional[pulumi.Input[builtins.str]] = None,
                 network_type: Optional[pulumi.Input[builtins.str]] = None,
                 physical_network: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 segmentation_id: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        """
        Manages a Neutron network segment resource within OpenStack.

        > **Note:** This resource is only available if the Neutron service is
        configured with the `segments` extension.

        > **Note:** This ussually requires admin privileges to create or manage
        segments.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_openstack as openstack

        net1 = openstack.networking.Network("net_1", name="demo-net")
        segment1 = openstack.networking.SegmentV2("segment_1",
            name="flat-segment",
            description="Example flat segment",
            network_id=net1.id,
            network_type="flat",
            physical_network="public")
        ```

        ## Import

        This resource can be imported by specifying the segment ID:

        ```sh
        $ pulumi import openstack:networking/segmentV2:SegmentV2 segment1 a5e3a494-26ee-4fde-ad26-2d846c47072e
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: A description for the segment.
        :param pulumi.Input[builtins.str] name: A name for the segment.
        :param pulumi.Input[builtins.str] network_id: The UUID of the network this segment belongs to.
               Changing this will create a new segment.
        :param pulumi.Input[builtins.str] network_type: The network type. Valid values depend on the
               backend (e.g., `vlan`, `vxlan`, `flat`, `gre`, `geneve`, `local`). Changing
               this will create a new segment.
        :param pulumi.Input[builtins.str] physical_network: The name of the physical network. Changing this
               will create a new segment.
        :param pulumi.Input[builtins.str] region: The region in which to obtain the V2 Networking client.
               A Networking client is needed to create a Neutron network. If omitted, the
               `region` argument of the provider is used. Changing this creates a new
               segment.
        :param pulumi.Input[builtins.int] segmentation_id: A segmentation identifier. Changing is allowed
               only for `vlan`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SegmentV2Args,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Neutron network segment resource within OpenStack.

        > **Note:** This resource is only available if the Neutron service is
        configured with the `segments` extension.

        > **Note:** This ussually requires admin privileges to create or manage
        segments.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_openstack as openstack

        net1 = openstack.networking.Network("net_1", name="demo-net")
        segment1 = openstack.networking.SegmentV2("segment_1",
            name="flat-segment",
            description="Example flat segment",
            network_id=net1.id,
            network_type="flat",
            physical_network="public")
        ```

        ## Import

        This resource can be imported by specifying the segment ID:

        ```sh
        $ pulumi import openstack:networking/segmentV2:SegmentV2 segment1 a5e3a494-26ee-4fde-ad26-2d846c47072e
        ```

        :param str resource_name: The name of the resource.
        :param SegmentV2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SegmentV2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_id: Optional[pulumi.Input[builtins.str]] = None,
                 network_type: Optional[pulumi.Input[builtins.str]] = None,
                 physical_network: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 segmentation_id: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SegmentV2Args.__new__(SegmentV2Args)

            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
            if network_type is None and not opts.urn:
                raise TypeError("Missing required property 'network_type'")
            __props__.__dict__["network_type"] = network_type
            __props__.__dict__["physical_network"] = physical_network
            __props__.__dict__["region"] = region
            __props__.__dict__["segmentation_id"] = segmentation_id
            __props__.__dict__["created_at"] = None
            __props__.__dict__["revision_number"] = None
            __props__.__dict__["updated_at"] = None
        super(SegmentV2, __self__).__init__(
            'openstack:networking/segmentV2:SegmentV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            network_id: Optional[pulumi.Input[builtins.str]] = None,
            network_type: Optional[pulumi.Input[builtins.str]] = None,
            physical_network: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            revision_number: Optional[pulumi.Input[builtins.int]] = None,
            segmentation_id: Optional[pulumi.Input[builtins.int]] = None,
            updated_at: Optional[pulumi.Input[builtins.str]] = None) -> 'SegmentV2':
        """
        Get an existing SegmentV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] created_at: Creation timestamp (RFC3339 format).
        :param pulumi.Input[builtins.str] description: A description for the segment.
        :param pulumi.Input[builtins.str] name: A name for the segment.
        :param pulumi.Input[builtins.str] network_id: The UUID of the network this segment belongs to.
               Changing this will create a new segment.
        :param pulumi.Input[builtins.str] network_type: The network type. Valid values depend on the
               backend (e.g., `vlan`, `vxlan`, `flat`, `gre`, `geneve`, `local`). Changing
               this will create a new segment.
        :param pulumi.Input[builtins.str] physical_network: The name of the physical network. Changing this
               will create a new segment.
        :param pulumi.Input[builtins.str] region: The region in which to obtain the V2 Networking client.
               A Networking client is needed to create a Neutron network. If omitted, the
               `region` argument of the provider is used. Changing this creates a new
               segment.
        :param pulumi.Input[builtins.int] revision_number: The revision number of the segment.
        :param pulumi.Input[builtins.int] segmentation_id: A segmentation identifier. Changing is allowed
               only for `vlan`.
        :param pulumi.Input[builtins.str] updated_at: Last update timestamp (RFC3339 format).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SegmentV2State.__new__(_SegmentV2State)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["network_type"] = network_type
        __props__.__dict__["physical_network"] = physical_network
        __props__.__dict__["region"] = region
        __props__.__dict__["revision_number"] = revision_number
        __props__.__dict__["segmentation_id"] = segmentation_id
        __props__.__dict__["updated_at"] = updated_at
        return SegmentV2(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[builtins.str]:
        """
        Creation timestamp (RFC3339 format).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A description for the segment.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        A name for the segment.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[builtins.str]:
        """
        The UUID of the network this segment belongs to.
        Changing this will create a new segment.
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter(name="networkType")
    def network_type(self) -> pulumi.Output[builtins.str]:
        """
        The network type. Valid values depend on the
        backend (e.g., `vlan`, `vxlan`, `flat`, `gre`, `geneve`, `local`). Changing
        this will create a new segment.
        """
        return pulumi.get(self, "network_type")

    @property
    @pulumi.getter(name="physicalNetwork")
    def physical_network(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of the physical network. Changing this
        will create a new segment.
        """
        return pulumi.get(self, "physical_network")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        The region in which to obtain the V2 Networking client.
        A Networking client is needed to create a Neutron network. If omitted, the
        `region` argument of the provider is used. Changing this creates a new
        segment.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="revisionNumber")
    def revision_number(self) -> pulumi.Output[builtins.int]:
        """
        The revision number of the segment.
        """
        return pulumi.get(self, "revision_number")

    @property
    @pulumi.getter(name="segmentationId")
    def segmentation_id(self) -> pulumi.Output[builtins.int]:
        """
        A segmentation identifier. Changing is allowed
        only for `vlan`.
        """
        return pulumi.get(self, "segmentation_id")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[builtins.str]:
        """
        Last update timestamp (RFC3339 format).
        """
        return pulumi.get(self, "updated_at")

