# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AccountV1Args', 'AccountV1']

@pulumi.input_type
class AccountV1Args:
    def __init__(__self__, *,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a AccountV1 resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] metadata: A map of custom key/value pairs to associate with the
               account metadata. Changing the `Quota-Bytes` key value is allowed to be
               updated only by the cloud administrator.
        :param pulumi.Input[builtins.str] project_id: The project ID of the corresponding account. If
               omitted, the token's project ID is used. Changing this creates a new account.
        :param pulumi.Input[builtins.str] region: The region in which to create the account. If omitted,
               the `region` argument of the provider is used. Changing this creates a new
               account.
        """
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of custom key/value pairs to associate with the
        account metadata. Changing the `Quota-Bytes` key value is allowed to be
        updated only by the cloud administrator.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The project ID of the corresponding account. If
        omitted, the token's project ID is used. Changing this creates a new account.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The region in which to create the account. If omitted,
        the `region` argument of the provider is used. Changing this creates a new
        account.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _AccountV1State:
    def __init__(__self__, *,
                 bytes_used: Optional[pulumi.Input[builtins.int]] = None,
                 container_count: Optional[pulumi.Input[builtins.int]] = None,
                 headers: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 object_count: Optional[pulumi.Input[builtins.int]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 quota_bytes: Optional[pulumi.Input[builtins.int]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering AccountV1 resources.
        :param pulumi.Input[builtins.int] bytes_used: The number of bytes used by the account.
        :param pulumi.Input[builtins.int] container_count: The number of containers in the account.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] headers: A map of headers returned for the account.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] metadata: A map of custom key/value pairs to associate with the
               account metadata. Changing the `Quota-Bytes` key value is allowed to be
               updated only by the cloud administrator.
        :param pulumi.Input[builtins.int] object_count: The number of objects in the account.
        :param pulumi.Input[builtins.str] project_id: The project ID of the corresponding account. If
               omitted, the token's project ID is used. Changing this creates a new account.
        :param pulumi.Input[builtins.int] quota_bytes: The number of bytes allowed for the account.
        :param pulumi.Input[builtins.str] region: The region in which to create the account. If omitted,
               the `region` argument of the provider is used. Changing this creates a new
               account.
        """
        if bytes_used is not None:
            pulumi.set(__self__, "bytes_used", bytes_used)
        if container_count is not None:
            pulumi.set(__self__, "container_count", container_count)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if object_count is not None:
            pulumi.set(__self__, "object_count", object_count)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if quota_bytes is not None:
            pulumi.set(__self__, "quota_bytes", quota_bytes)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="bytesUsed")
    def bytes_used(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of bytes used by the account.
        """
        return pulumi.get(self, "bytes_used")

    @bytes_used.setter
    def bytes_used(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "bytes_used", value)

    @property
    @pulumi.getter(name="containerCount")
    def container_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of containers in the account.
        """
        return pulumi.get(self, "container_count")

    @container_count.setter
    def container_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "container_count", value)

    @property
    @pulumi.getter
    def headers(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of headers returned for the account.
        """
        return pulumi.get(self, "headers")

    @headers.setter
    def headers(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "headers", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of custom key/value pairs to associate with the
        account metadata. Changing the `Quota-Bytes` key value is allowed to be
        updated only by the cloud administrator.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter(name="objectCount")
    def object_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of objects in the account.
        """
        return pulumi.get(self, "object_count")

    @object_count.setter
    def object_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "object_count", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The project ID of the corresponding account. If
        omitted, the token's project ID is used. Changing this creates a new account.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="quotaBytes")
    def quota_bytes(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of bytes allowed for the account.
        """
        return pulumi.get(self, "quota_bytes")

    @quota_bytes.setter
    def quota_bytes(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "quota_bytes", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The region in which to create the account. If omitted,
        the `region` argument of the provider is used. Changing this creates a new
        account.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.type_token("openstack:objectstorage/accountV1:AccountV1")
class AccountV1(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a V1 account resource within OpenStack.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_openstack as openstack

        account1 = openstack.objectstorage.AccountV1("account_1",
            region="RegionOne",
            metadata={
                "Temp-Url-Key": "testkey",
                "test": "true",
            })
        ```

        ## Import

        This resource can be imported by specifying the project ID of the account:

        ```sh
        $ pulumi import openstack:objectstorage/accountV1:AccountV1 account_1 1202b3d0aaa44cfc8b79475c007b0711
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] metadata: A map of custom key/value pairs to associate with the
               account metadata. Changing the `Quota-Bytes` key value is allowed to be
               updated only by the cloud administrator.
        :param pulumi.Input[builtins.str] project_id: The project ID of the corresponding account. If
               omitted, the token's project ID is used. Changing this creates a new account.
        :param pulumi.Input[builtins.str] region: The region in which to create the account. If omitted,
               the `region` argument of the provider is used. Changing this creates a new
               account.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[AccountV1Args] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a V1 account resource within OpenStack.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_openstack as openstack

        account1 = openstack.objectstorage.AccountV1("account_1",
            region="RegionOne",
            metadata={
                "Temp-Url-Key": "testkey",
                "test": "true",
            })
        ```

        ## Import

        This resource can be imported by specifying the project ID of the account:

        ```sh
        $ pulumi import openstack:objectstorage/accountV1:AccountV1 account_1 1202b3d0aaa44cfc8b79475c007b0711
        ```

        :param str resource_name: The name of the resource.
        :param AccountV1Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AccountV1Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AccountV1Args.__new__(AccountV1Args)

            __props__.__dict__["metadata"] = metadata
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["region"] = region
            __props__.__dict__["bytes_used"] = None
            __props__.__dict__["container_count"] = None
            __props__.__dict__["headers"] = None
            __props__.__dict__["object_count"] = None
            __props__.__dict__["quota_bytes"] = None
        super(AccountV1, __self__).__init__(
            'openstack:objectstorage/accountV1:AccountV1',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bytes_used: Optional[pulumi.Input[builtins.int]] = None,
            container_count: Optional[pulumi.Input[builtins.int]] = None,
            headers: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            object_count: Optional[pulumi.Input[builtins.int]] = None,
            project_id: Optional[pulumi.Input[builtins.str]] = None,
            quota_bytes: Optional[pulumi.Input[builtins.int]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None) -> 'AccountV1':
        """
        Get an existing AccountV1 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.int] bytes_used: The number of bytes used by the account.
        :param pulumi.Input[builtins.int] container_count: The number of containers in the account.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] headers: A map of headers returned for the account.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] metadata: A map of custom key/value pairs to associate with the
               account metadata. Changing the `Quota-Bytes` key value is allowed to be
               updated only by the cloud administrator.
        :param pulumi.Input[builtins.int] object_count: The number of objects in the account.
        :param pulumi.Input[builtins.str] project_id: The project ID of the corresponding account. If
               omitted, the token's project ID is used. Changing this creates a new account.
        :param pulumi.Input[builtins.int] quota_bytes: The number of bytes allowed for the account.
        :param pulumi.Input[builtins.str] region: The region in which to create the account. If omitted,
               the `region` argument of the provider is used. Changing this creates a new
               account.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AccountV1State.__new__(_AccountV1State)

        __props__.__dict__["bytes_used"] = bytes_used
        __props__.__dict__["container_count"] = container_count
        __props__.__dict__["headers"] = headers
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["object_count"] = object_count
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["quota_bytes"] = quota_bytes
        __props__.__dict__["region"] = region
        return AccountV1(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="bytesUsed")
    def bytes_used(self) -> pulumi.Output[builtins.int]:
        """
        The number of bytes used by the account.
        """
        return pulumi.get(self, "bytes_used")

    @property
    @pulumi.getter(name="containerCount")
    def container_count(self) -> pulumi.Output[builtins.int]:
        """
        The number of containers in the account.
        """
        return pulumi.get(self, "container_count")

    @property
    @pulumi.getter
    def headers(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        A map of headers returned for the account.
        """
        return pulumi.get(self, "headers")

    @property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A map of custom key/value pairs to associate with the
        account metadata. Changing the `Quota-Bytes` key value is allowed to be
        updated only by the cloud administrator.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter(name="objectCount")
    def object_count(self) -> pulumi.Output[builtins.int]:
        """
        The number of objects in the account.
        """
        return pulumi.get(self, "object_count")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[builtins.str]:
        """
        The project ID of the corresponding account. If
        omitted, the token's project ID is used. Changing this creates a new account.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="quotaBytes")
    def quota_bytes(self) -> pulumi.Output[builtins.int]:
        """
        The number of bytes allowed for the account.
        """
        return pulumi.get(self, "quota_bytes")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        The region in which to create the account. If omitted,
        the `region` argument of the provider is used. Changing this creates a new
        account.
        """
        return pulumi.get(self, "region")

