# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['StackV1Args', 'StackV1']

@pulumi.input_type
class StackV1Args:
    def __init__(__self__, *,
                 template_opts: pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]],
                 stack_outputs: Optional[pulumi.Input[Sequence[pulumi.Input['StackV1StackOutputArgs']]]] = None,
                 capabilities: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 creation_time: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 disable_rollback: Optional[pulumi.Input[builtins.bool]] = None,
                 environment_opts: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 notification_topics: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 status_reason: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 template_description: Optional[pulumi.Input[builtins.str]] = None,
                 timeout: Optional[pulumi.Input[builtins.int]] = None,
                 updated_time: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a StackV1 resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] template_opts: Template key/value pairs to associate with the
               stack which contains either the template file or url.
               Allowed keys: Bin, URL, Files. Changing this updates the existing stack
               Template Opts.
        :param pulumi.Input[Sequence[pulumi.Input['StackV1StackOutputArgs']]] stack_outputs: A list of stack outputs.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] capabilities: List of stack capabilities for stack.
        :param pulumi.Input[builtins.str] creation_time: The date and time when the resource was created. The date
               and time stamp format is ISO 8601: CCYY-MM-DDThh:mm:ss±hh:mm
               For example, 2015-08-27T09:49:58-05:00. The ±hh:mm value, if included,
               is the time zone as an offset from UTC.
        :param pulumi.Input[builtins.str] description: The description of the stack resource.
        :param pulumi.Input[builtins.bool] disable_rollback: Enables or disables deletion of all stack
               resources when a stack creation fails. Default is true, meaning all
               resources are not deleted when stack creation fails.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] environment_opts: Environment key/value pairs to associate with
               the stack which contains details for the environment of the stack.
               Allowed keys: Bin, URL, Files. Changing this updates the existing stack
               Environment Opts.
        :param pulumi.Input[builtins.str] name: A unique name for the stack. It must start with an
               alphabetic character. Changing this updates the stack's name.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] notification_topics: List of notification topics for stack.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] parameters: User-defined key/value pairs as parameters to pass
               to the template. Changing this updates the existing stack parameters.
        :param pulumi.Input[builtins.str] region: The region in which to create the stack. If
               omitted, the `region` argument of the provider is used. Changing this
               creates a new stack.
        :param pulumi.Input[builtins.str] status: The status of the stack.
        :param pulumi.Input[builtins.str] status_reason: The reason for the current status of the stack.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: A list of tags to assosciate with the Stack
        :param pulumi.Input[builtins.str] template_description: The description of the stack template.
        :param pulumi.Input[builtins.int] timeout: The timeout for stack action in minutes.
        :param pulumi.Input[builtins.str] updated_time: The date and time when the resource was updated. The date
               and time stamp format is ISO 8601: CCYY-MM-DDThh:mm:ss±hh:mm
               For example, 2015-08-27T09:49:58-05:00. The ±hh:mm value, if included,
               is the time zone as an offset from UTC.
        """
        pulumi.set(__self__, "template_opts", template_opts)
        if stack_outputs is not None:
            pulumi.set(__self__, "stack_outputs", stack_outputs)
        if capabilities is not None:
            pulumi.set(__self__, "capabilities", capabilities)
        if creation_time is not None:
            pulumi.set(__self__, "creation_time", creation_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_rollback is not None:
            pulumi.set(__self__, "disable_rollback", disable_rollback)
        if environment_opts is not None:
            pulumi.set(__self__, "environment_opts", environment_opts)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notification_topics is not None:
            pulumi.set(__self__, "notification_topics", notification_topics)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if status_reason is not None:
            pulumi.set(__self__, "status_reason", status_reason)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if template_description is not None:
            pulumi.set(__self__, "template_description", template_description)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if updated_time is not None:
            pulumi.set(__self__, "updated_time", updated_time)

    @property
    @pulumi.getter(name="templateOpts")
    def template_opts(self) -> pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]:
        """
        Template key/value pairs to associate with the
        stack which contains either the template file or url.
        Allowed keys: Bin, URL, Files. Changing this updates the existing stack
        Template Opts.
        """
        return pulumi.get(self, "template_opts")

    @template_opts.setter
    def template_opts(self, value: pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]):
        pulumi.set(self, "template_opts", value)

    @property
    @pulumi.getter(name="StackOutputs")
    def stack_outputs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StackV1StackOutputArgs']]]]:
        """
        A list of stack outputs.
        """
        return pulumi.get(self, "stack_outputs")

    @stack_outputs.setter
    def stack_outputs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StackV1StackOutputArgs']]]]):
        pulumi.set(self, "stack_outputs", value)

    @property
    @pulumi.getter
    def capabilities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of stack capabilities for stack.
        """
        return pulumi.get(self, "capabilities")

    @capabilities.setter
    def capabilities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "capabilities", value)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time when the resource was created. The date
        and time stamp format is ISO 8601: CCYY-MM-DDThh:mm:ss±hh:mm
        For example, 2015-08-27T09:49:58-05:00. The ±hh:mm value, if included,
        is the time zone as an offset from UTC.
        """
        return pulumi.get(self, "creation_time")

    @creation_time.setter
    def creation_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "creation_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the stack resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="disableRollback")
    def disable_rollback(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enables or disables deletion of all stack
        resources when a stack creation fails. Default is true, meaning all
        resources are not deleted when stack creation fails.
        """
        return pulumi.get(self, "disable_rollback")

    @disable_rollback.setter
    def disable_rollback(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "disable_rollback", value)

    @property
    @pulumi.getter(name="environmentOpts")
    def environment_opts(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Environment key/value pairs to associate with
        the stack which contains details for the environment of the stack.
        Allowed keys: Bin, URL, Files. Changing this updates the existing stack
        Environment Opts.
        """
        return pulumi.get(self, "environment_opts")

    @environment_opts.setter
    def environment_opts(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "environment_opts", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A unique name for the stack. It must start with an
        alphabetic character. Changing this updates the stack's name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="notificationTopics")
    def notification_topics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of notification topics for stack.
        """
        return pulumi.get(self, "notification_topics")

    @notification_topics.setter
    def notification_topics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "notification_topics", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        User-defined key/value pairs as parameters to pass
        to the template. Changing this updates the existing stack parameters.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The region in which to create the stack. If
        omitted, the `region` argument of the provider is used. Changing this
        creates a new stack.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The status of the stack.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="statusReason")
    def status_reason(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The reason for the current status of the stack.
        """
        return pulumi.get(self, "status_reason")

    @status_reason.setter
    def status_reason(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status_reason", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of tags to assosciate with the Stack
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="templateDescription")
    def template_description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the stack template.
        """
        return pulumi.get(self, "template_description")

    @template_description.setter
    def template_description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "template_description", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The timeout for stack action in minutes.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "timeout", value)

    @property
    @pulumi.getter(name="updatedTime")
    def updated_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time when the resource was updated. The date
        and time stamp format is ISO 8601: CCYY-MM-DDThh:mm:ss±hh:mm
        For example, 2015-08-27T09:49:58-05:00. The ±hh:mm value, if included,
        is the time zone as an offset from UTC.
        """
        return pulumi.get(self, "updated_time")

    @updated_time.setter
    def updated_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "updated_time", value)


@pulumi.input_type
class _StackV1State:
    def __init__(__self__, *,
                 stack_outputs: Optional[pulumi.Input[Sequence[pulumi.Input['StackV1StackOutputArgs']]]] = None,
                 capabilities: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 creation_time: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 disable_rollback: Optional[pulumi.Input[builtins.bool]] = None,
                 environment_opts: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 notification_topics: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 status_reason: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 template_description: Optional[pulumi.Input[builtins.str]] = None,
                 template_opts: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 timeout: Optional[pulumi.Input[builtins.int]] = None,
                 updated_time: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering StackV1 resources.
        :param pulumi.Input[Sequence[pulumi.Input['StackV1StackOutputArgs']]] stack_outputs: A list of stack outputs.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] capabilities: List of stack capabilities for stack.
        :param pulumi.Input[builtins.str] creation_time: The date and time when the resource was created. The date
               and time stamp format is ISO 8601: CCYY-MM-DDThh:mm:ss±hh:mm
               For example, 2015-08-27T09:49:58-05:00. The ±hh:mm value, if included,
               is the time zone as an offset from UTC.
        :param pulumi.Input[builtins.str] description: The description of the stack resource.
        :param pulumi.Input[builtins.bool] disable_rollback: Enables or disables deletion of all stack
               resources when a stack creation fails. Default is true, meaning all
               resources are not deleted when stack creation fails.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] environment_opts: Environment key/value pairs to associate with
               the stack which contains details for the environment of the stack.
               Allowed keys: Bin, URL, Files. Changing this updates the existing stack
               Environment Opts.
        :param pulumi.Input[builtins.str] name: A unique name for the stack. It must start with an
               alphabetic character. Changing this updates the stack's name.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] notification_topics: List of notification topics for stack.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] parameters: User-defined key/value pairs as parameters to pass
               to the template. Changing this updates the existing stack parameters.
        :param pulumi.Input[builtins.str] region: The region in which to create the stack. If
               omitted, the `region` argument of the provider is used. Changing this
               creates a new stack.
        :param pulumi.Input[builtins.str] status: The status of the stack.
        :param pulumi.Input[builtins.str] status_reason: The reason for the current status of the stack.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: A list of tags to assosciate with the Stack
        :param pulumi.Input[builtins.str] template_description: The description of the stack template.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] template_opts: Template key/value pairs to associate with the
               stack which contains either the template file or url.
               Allowed keys: Bin, URL, Files. Changing this updates the existing stack
               Template Opts.
        :param pulumi.Input[builtins.int] timeout: The timeout for stack action in minutes.
        :param pulumi.Input[builtins.str] updated_time: The date and time when the resource was updated. The date
               and time stamp format is ISO 8601: CCYY-MM-DDThh:mm:ss±hh:mm
               For example, 2015-08-27T09:49:58-05:00. The ±hh:mm value, if included,
               is the time zone as an offset from UTC.
        """
        if stack_outputs is not None:
            pulumi.set(__self__, "stack_outputs", stack_outputs)
        if capabilities is not None:
            pulumi.set(__self__, "capabilities", capabilities)
        if creation_time is not None:
            pulumi.set(__self__, "creation_time", creation_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_rollback is not None:
            pulumi.set(__self__, "disable_rollback", disable_rollback)
        if environment_opts is not None:
            pulumi.set(__self__, "environment_opts", environment_opts)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notification_topics is not None:
            pulumi.set(__self__, "notification_topics", notification_topics)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if status_reason is not None:
            pulumi.set(__self__, "status_reason", status_reason)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if template_description is not None:
            pulumi.set(__self__, "template_description", template_description)
        if template_opts is not None:
            pulumi.set(__self__, "template_opts", template_opts)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if updated_time is not None:
            pulumi.set(__self__, "updated_time", updated_time)

    @property
    @pulumi.getter(name="StackOutputs")
    def stack_outputs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StackV1StackOutputArgs']]]]:
        """
        A list of stack outputs.
        """
        return pulumi.get(self, "stack_outputs")

    @stack_outputs.setter
    def stack_outputs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StackV1StackOutputArgs']]]]):
        pulumi.set(self, "stack_outputs", value)

    @property
    @pulumi.getter
    def capabilities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of stack capabilities for stack.
        """
        return pulumi.get(self, "capabilities")

    @capabilities.setter
    def capabilities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "capabilities", value)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time when the resource was created. The date
        and time stamp format is ISO 8601: CCYY-MM-DDThh:mm:ss±hh:mm
        For example, 2015-08-27T09:49:58-05:00. The ±hh:mm value, if included,
        is the time zone as an offset from UTC.
        """
        return pulumi.get(self, "creation_time")

    @creation_time.setter
    def creation_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "creation_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the stack resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="disableRollback")
    def disable_rollback(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enables or disables deletion of all stack
        resources when a stack creation fails. Default is true, meaning all
        resources are not deleted when stack creation fails.
        """
        return pulumi.get(self, "disable_rollback")

    @disable_rollback.setter
    def disable_rollback(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "disable_rollback", value)

    @property
    @pulumi.getter(name="environmentOpts")
    def environment_opts(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Environment key/value pairs to associate with
        the stack which contains details for the environment of the stack.
        Allowed keys: Bin, URL, Files. Changing this updates the existing stack
        Environment Opts.
        """
        return pulumi.get(self, "environment_opts")

    @environment_opts.setter
    def environment_opts(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "environment_opts", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A unique name for the stack. It must start with an
        alphabetic character. Changing this updates the stack's name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="notificationTopics")
    def notification_topics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of notification topics for stack.
        """
        return pulumi.get(self, "notification_topics")

    @notification_topics.setter
    def notification_topics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "notification_topics", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        User-defined key/value pairs as parameters to pass
        to the template. Changing this updates the existing stack parameters.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The region in which to create the stack. If
        omitted, the `region` argument of the provider is used. Changing this
        creates a new stack.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The status of the stack.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="statusReason")
    def status_reason(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The reason for the current status of the stack.
        """
        return pulumi.get(self, "status_reason")

    @status_reason.setter
    def status_reason(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status_reason", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of tags to assosciate with the Stack
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="templateDescription")
    def template_description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the stack template.
        """
        return pulumi.get(self, "template_description")

    @template_description.setter
    def template_description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "template_description", value)

    @property
    @pulumi.getter(name="templateOpts")
    def template_opts(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Template key/value pairs to associate with the
        stack which contains either the template file or url.
        Allowed keys: Bin, URL, Files. Changing this updates the existing stack
        Template Opts.
        """
        return pulumi.get(self, "template_opts")

    @template_opts.setter
    def template_opts(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "template_opts", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The timeout for stack action in minutes.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "timeout", value)

    @property
    @pulumi.getter(name="updatedTime")
    def updated_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time when the resource was updated. The date
        and time stamp format is ISO 8601: CCYY-MM-DDThh:mm:ss±hh:mm
        For example, 2015-08-27T09:49:58-05:00. The ±hh:mm value, if included,
        is the time zone as an offset from UTC.
        """
        return pulumi.get(self, "updated_time")

    @updated_time.setter
    def updated_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "updated_time", value)


@pulumi.type_token("openstack:orchestration/stackV1:StackV1")
class StackV1(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 stack_outputs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StackV1StackOutputArgs', 'StackV1StackOutputArgsDict']]]]] = None,
                 capabilities: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 creation_time: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 disable_rollback: Optional[pulumi.Input[builtins.bool]] = None,
                 environment_opts: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 notification_topics: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 status_reason: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 template_description: Optional[pulumi.Input[builtins.str]] = None,
                 template_opts: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 timeout: Optional[pulumi.Input[builtins.int]] = None,
                 updated_time: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a V1 stack resource within OpenStack.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_openstack as openstack

        stack1 = openstack.orchestration.StackV1("stack_1",
            name="stack_1",
            parameters={
                "length": "4",
            },
            template_opts={
                "Bin": \"\"\"heat_template_version: 2013-05-23
        parameters:
          length:
            type: number
        resources:
          test_res:
            type: OS::Heat::TestResource
          random:
            type: OS::Heat::RandomString
            properties:
              length: {get_param: length}
        \"\"\",
            },
            environment_opts={
                "Bin": "\\n",
            },
            disable_rollback=True,
            timeout=30)
        ```

        ## Import

        stacks can be imported using the `id`, e.g.

        ```sh
        $ pulumi import openstack:orchestration/stackV1:StackV1 stack_1 ea257959-eeb1-4c10-8d33-26f0409a755d
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['StackV1StackOutputArgs', 'StackV1StackOutputArgsDict']]]] stack_outputs: A list of stack outputs.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] capabilities: List of stack capabilities for stack.
        :param pulumi.Input[builtins.str] creation_time: The date and time when the resource was created. The date
               and time stamp format is ISO 8601: CCYY-MM-DDThh:mm:ss±hh:mm
               For example, 2015-08-27T09:49:58-05:00. The ±hh:mm value, if included,
               is the time zone as an offset from UTC.
        :param pulumi.Input[builtins.str] description: The description of the stack resource.
        :param pulumi.Input[builtins.bool] disable_rollback: Enables or disables deletion of all stack
               resources when a stack creation fails. Default is true, meaning all
               resources are not deleted when stack creation fails.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] environment_opts: Environment key/value pairs to associate with
               the stack which contains details for the environment of the stack.
               Allowed keys: Bin, URL, Files. Changing this updates the existing stack
               Environment Opts.
        :param pulumi.Input[builtins.str] name: A unique name for the stack. It must start with an
               alphabetic character. Changing this updates the stack's name.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] notification_topics: List of notification topics for stack.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] parameters: User-defined key/value pairs as parameters to pass
               to the template. Changing this updates the existing stack parameters.
        :param pulumi.Input[builtins.str] region: The region in which to create the stack. If
               omitted, the `region` argument of the provider is used. Changing this
               creates a new stack.
        :param pulumi.Input[builtins.str] status: The status of the stack.
        :param pulumi.Input[builtins.str] status_reason: The reason for the current status of the stack.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: A list of tags to assosciate with the Stack
        :param pulumi.Input[builtins.str] template_description: The description of the stack template.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] template_opts: Template key/value pairs to associate with the
               stack which contains either the template file or url.
               Allowed keys: Bin, URL, Files. Changing this updates the existing stack
               Template Opts.
        :param pulumi.Input[builtins.int] timeout: The timeout for stack action in minutes.
        :param pulumi.Input[builtins.str] updated_time: The date and time when the resource was updated. The date
               and time stamp format is ISO 8601: CCYY-MM-DDThh:mm:ss±hh:mm
               For example, 2015-08-27T09:49:58-05:00. The ±hh:mm value, if included,
               is the time zone as an offset from UTC.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: StackV1Args,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a V1 stack resource within OpenStack.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_openstack as openstack

        stack1 = openstack.orchestration.StackV1("stack_1",
            name="stack_1",
            parameters={
                "length": "4",
            },
            template_opts={
                "Bin": \"\"\"heat_template_version: 2013-05-23
        parameters:
          length:
            type: number
        resources:
          test_res:
            type: OS::Heat::TestResource
          random:
            type: OS::Heat::RandomString
            properties:
              length: {get_param: length}
        \"\"\",
            },
            environment_opts={
                "Bin": "\\n",
            },
            disable_rollback=True,
            timeout=30)
        ```

        ## Import

        stacks can be imported using the `id`, e.g.

        ```sh
        $ pulumi import openstack:orchestration/stackV1:StackV1 stack_1 ea257959-eeb1-4c10-8d33-26f0409a755d
        ```

        :param str resource_name: The name of the resource.
        :param StackV1Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StackV1Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 stack_outputs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StackV1StackOutputArgs', 'StackV1StackOutputArgsDict']]]]] = None,
                 capabilities: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 creation_time: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 disable_rollback: Optional[pulumi.Input[builtins.bool]] = None,
                 environment_opts: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 notification_topics: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 status_reason: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 template_description: Optional[pulumi.Input[builtins.str]] = None,
                 template_opts: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 timeout: Optional[pulumi.Input[builtins.int]] = None,
                 updated_time: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StackV1Args.__new__(StackV1Args)

            __props__.__dict__["stack_outputs"] = stack_outputs
            __props__.__dict__["capabilities"] = capabilities
            __props__.__dict__["creation_time"] = creation_time
            __props__.__dict__["description"] = description
            __props__.__dict__["disable_rollback"] = disable_rollback
            __props__.__dict__["environment_opts"] = environment_opts
            __props__.__dict__["name"] = name
            __props__.__dict__["notification_topics"] = notification_topics
            __props__.__dict__["parameters"] = parameters
            __props__.__dict__["region"] = region
            __props__.__dict__["status"] = status
            __props__.__dict__["status_reason"] = status_reason
            __props__.__dict__["tags"] = tags
            __props__.__dict__["template_description"] = template_description
            if template_opts is None and not opts.urn:
                raise TypeError("Missing required property 'template_opts'")
            __props__.__dict__["template_opts"] = template_opts
            __props__.__dict__["timeout"] = timeout
            __props__.__dict__["updated_time"] = updated_time
        super(StackV1, __self__).__init__(
            'openstack:orchestration/stackV1:StackV1',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            stack_outputs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StackV1StackOutputArgs', 'StackV1StackOutputArgsDict']]]]] = None,
            capabilities: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            creation_time: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            disable_rollback: Optional[pulumi.Input[builtins.bool]] = None,
            environment_opts: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            notification_topics: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            status: Optional[pulumi.Input[builtins.str]] = None,
            status_reason: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            template_description: Optional[pulumi.Input[builtins.str]] = None,
            template_opts: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            timeout: Optional[pulumi.Input[builtins.int]] = None,
            updated_time: Optional[pulumi.Input[builtins.str]] = None) -> 'StackV1':
        """
        Get an existing StackV1 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['StackV1StackOutputArgs', 'StackV1StackOutputArgsDict']]]] stack_outputs: A list of stack outputs.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] capabilities: List of stack capabilities for stack.
        :param pulumi.Input[builtins.str] creation_time: The date and time when the resource was created. The date
               and time stamp format is ISO 8601: CCYY-MM-DDThh:mm:ss±hh:mm
               For example, 2015-08-27T09:49:58-05:00. The ±hh:mm value, if included,
               is the time zone as an offset from UTC.
        :param pulumi.Input[builtins.str] description: The description of the stack resource.
        :param pulumi.Input[builtins.bool] disable_rollback: Enables or disables deletion of all stack
               resources when a stack creation fails. Default is true, meaning all
               resources are not deleted when stack creation fails.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] environment_opts: Environment key/value pairs to associate with
               the stack which contains details for the environment of the stack.
               Allowed keys: Bin, URL, Files. Changing this updates the existing stack
               Environment Opts.
        :param pulumi.Input[builtins.str] name: A unique name for the stack. It must start with an
               alphabetic character. Changing this updates the stack's name.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] notification_topics: List of notification topics for stack.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] parameters: User-defined key/value pairs as parameters to pass
               to the template. Changing this updates the existing stack parameters.
        :param pulumi.Input[builtins.str] region: The region in which to create the stack. If
               omitted, the `region` argument of the provider is used. Changing this
               creates a new stack.
        :param pulumi.Input[builtins.str] status: The status of the stack.
        :param pulumi.Input[builtins.str] status_reason: The reason for the current status of the stack.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: A list of tags to assosciate with the Stack
        :param pulumi.Input[builtins.str] template_description: The description of the stack template.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] template_opts: Template key/value pairs to associate with the
               stack which contains either the template file or url.
               Allowed keys: Bin, URL, Files. Changing this updates the existing stack
               Template Opts.
        :param pulumi.Input[builtins.int] timeout: The timeout for stack action in minutes.
        :param pulumi.Input[builtins.str] updated_time: The date and time when the resource was updated. The date
               and time stamp format is ISO 8601: CCYY-MM-DDThh:mm:ss±hh:mm
               For example, 2015-08-27T09:49:58-05:00. The ±hh:mm value, if included,
               is the time zone as an offset from UTC.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _StackV1State.__new__(_StackV1State)

        __props__.__dict__["stack_outputs"] = stack_outputs
        __props__.__dict__["capabilities"] = capabilities
        __props__.__dict__["creation_time"] = creation_time
        __props__.__dict__["description"] = description
        __props__.__dict__["disable_rollback"] = disable_rollback
        __props__.__dict__["environment_opts"] = environment_opts
        __props__.__dict__["name"] = name
        __props__.__dict__["notification_topics"] = notification_topics
        __props__.__dict__["parameters"] = parameters
        __props__.__dict__["region"] = region
        __props__.__dict__["status"] = status
        __props__.__dict__["status_reason"] = status_reason
        __props__.__dict__["tags"] = tags
        __props__.__dict__["template_description"] = template_description
        __props__.__dict__["template_opts"] = template_opts
        __props__.__dict__["timeout"] = timeout
        __props__.__dict__["updated_time"] = updated_time
        return StackV1(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="StackOutputs")
    def stack_outputs(self) -> pulumi.Output[Sequence['outputs.StackV1StackOutput']]:
        """
        A list of stack outputs.
        """
        return pulumi.get(self, "stack_outputs")

    @property
    @pulumi.getter
    def capabilities(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        List of stack capabilities for stack.
        """
        return pulumi.get(self, "capabilities")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> pulumi.Output[builtins.str]:
        """
        The date and time when the resource was created. The date
        and time stamp format is ISO 8601: CCYY-MM-DDThh:mm:ss±hh:mm
        For example, 2015-08-27T09:49:58-05:00. The ±hh:mm value, if included,
        is the time zone as an offset from UTC.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        The description of the stack resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="disableRollback")
    def disable_rollback(self) -> pulumi.Output[builtins.bool]:
        """
        Enables or disables deletion of all stack
        resources when a stack creation fails. Default is true, meaning all
        resources are not deleted when stack creation fails.
        """
        return pulumi.get(self, "disable_rollback")

    @property
    @pulumi.getter(name="environmentOpts")
    def environment_opts(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Environment key/value pairs to associate with
        the stack which contains details for the environment of the stack.
        Allowed keys: Bin, URL, Files. Changing this updates the existing stack
        Environment Opts.
        """
        return pulumi.get(self, "environment_opts")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        A unique name for the stack. It must start with an
        alphabetic character. Changing this updates the stack's name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="notificationTopics")
    def notification_topics(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        List of notification topics for stack.
        """
        return pulumi.get(self, "notification_topics")

    @property
    @pulumi.getter
    def parameters(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        User-defined key/value pairs as parameters to pass
        to the template. Changing this updates the existing stack parameters.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        The region in which to create the stack. If
        omitted, the `region` argument of the provider is used. Changing this
        creates a new stack.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[builtins.str]:
        """
        The status of the stack.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="statusReason")
    def status_reason(self) -> pulumi.Output[builtins.str]:
        """
        The reason for the current status of the stack.
        """
        return pulumi.get(self, "status_reason")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        A list of tags to assosciate with the Stack
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="templateDescription")
    def template_description(self) -> pulumi.Output[builtins.str]:
        """
        The description of the stack template.
        """
        return pulumi.get(self, "template_description")

    @property
    @pulumi.getter(name="templateOpts")
    def template_opts(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        Template key/value pairs to associate with the
        stack which contains either the template file or url.
        Allowed keys: Bin, URL, Files. Changing this updates the existing stack
        Template Opts.
        """
        return pulumi.get(self, "template_opts")

    @property
    @pulumi.getter
    def timeout(self) -> pulumi.Output[builtins.int]:
        """
        The timeout for stack action in minutes.
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter(name="updatedTime")
    def updated_time(self) -> pulumi.Output[builtins.str]:
        """
        The date and time when the resource was updated. The date
        and time stamp format is ISO 8601: CCYY-MM-DDThh:mm:ss±hh:mm
        For example, 2015-08-27T09:49:58-05:00. The ±hh:mm value, if included,
        is the time zone as an offset from UTC.
        """
        return pulumi.get(self, "updated_time")

