# Changelog

- This file provides a full account of all changes to `dbt-snowflake`
- The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html),
and is generated by [Changie](https://github.com/miniscruff/changie)
- Changes are listed under the (pre-)release in which they first appear
- Subsequent releases include changes from previous releases
- "Breaking changes" listed under a version may require action from end users or external maintainers when upgrading to that version
- Do not edit this file directly. This file is auto-generated using [changie](https://github.com/miniscruff/changie)
- For details on how to document a change, see the [contributing guide](/CONTRIBUTING.md#changelog-entry)

## dbt-snowflake 1.11.0-b2 - November 04, 2025

### Features

- Add cluster by config in Snowflake for dynamic tables ([#706](https://github.com/dbt-labs/dbt-adapters/issues/706))
- Remove catalog from target_relation in incremental macro ([#1376](https://github.com/dbt-labs/dbt-adapters/issues/1376))
- Add basic support for materializing tables in a Glue Catalog Linked Database with Iceberg REST ([#1377](https://github.com/dbt-labs/dbt-adapters/issues/1377))
- Add platform_detection_timeout_seconds configuration param to disable eager metadata detection in the snowflake-connector ([#1278](https://github.com/dbt-labs/dbt-adapters/issues/1278))
- Support volatility setting in sql UDFs ([#1345](https://github.com/dbt-labs/dbt-adapters/issues/1345))

### Fixes

- Set client prefetch threads to 1 to prevent deadlock at exit ([#1368](https://github.com/dbt-labs/dbt-adapters/issues/1368))

### Under the Hood

- Improve snowflake connector log handling ([#1399](https://github.com/dbt-labs/dbt-adapters/issues/1399))
- Update bigquery job handling to invoke job.cancel on timeout ([#1355](https://github.com/dbt-labs/dbt-adapters/issues/1355))
- Test handling of unknown function macro lookup ([#1344](https://github.com/dbt-labs/dbt-adapters/issues/1344))

### Dependencies

- Upgrade snowflake-connector-python to 4.0.0 ([#1368](https://github.com/dbt-labs/dbt-adapters/pull/1368))
- Drop support for python 3.9 ([#1412](https://github.com/dbt-labs/dbt-adapters/pull/1412))

### Contributors
- [@nazliander](https://github.com/nazliander) ([#706](https://github.com/dbt-labs/dbt-adapters/issues/706))
- [@wiggzz](https://github.com/wiggzz) ([#1368](https://github.com/dbt-labs/dbt-adapters/issues/1368), [#1368](https://github.com/dbt-labs/dbt-adapters/pull/1368))


## dbt-snowflake 1.11.0-b1 - October 07, 2025

### Features

- Support Iceberg REST with Catalog Linked Databases in Snowflake ([#1251](https://github.com/dbt-labs/dbt-adapters/issues/1251))
- Add support for incremental materializations using iceberg rest catalog / catalog linked db  ([#1123](https://github.com/dbt-labs/dbt-adapters/issues/1123))
- Support for scalar functions ([#1292](https://github.com/dbt-labs/dbt-adapters/issues/1292))

### Fixes

- Fix adapter.get_relation to find quoted case-sensitive relations ([#694](https://github.com/dbt-labs/dbt-adapters/issues/694))
- quote columns when altering tables for incremental materialization ([#695](https://github.com/dbt-labs/dbt-adapters/issues/695))
- fix table and column descriptions for snowflake iceberg tables ([#1015](https://github.com/dbt-labs/dbt-adapters/issues/1015))
- Rename DT temp tables to avoid problematic drops ([#713](https://github.com/dbt-labs/dbt-adapters/issues/713))
- Omit external volume from DDL when not provided in the YAML file ([#772](https://github.com/dbt-labs/dbt-adapters/issues/772))
- fix issue where incorrect varchar size is applied for iceberg table columns ([#1257](https://github.com/dbt-labs/dbt-adapters/issues/1257))
- handle non-model node types being passed to generate_database_name ([#1309](https://github.com/dbt-labs/dbt-adapters/issues/1309))
- Fix references to function properties in funciton macros ([#1365](https://github.com/dbt-labs/dbt-adapters/issues/1365))

### Dependencies

- bump dbt-adapters version pin floor to >=1.16.6  ([#1328](https://github.com/dbt-labs/dbt-adapters/pull/1328))

### Contributors
- [@dlouseiro](https://github.com/dlouseiro) ([#772](https://github.com/dbt-labs/dbt-adapters/issues/772))
- [@prashantpiyush](https://github.com/prashantpiyush) ([#694](https://github.com/dbt-labs/dbt-adapters/issues/694))
- [@sandeepmullangi2](https://github.com/sandeepmullangi2) ([#1015](https://github.com/dbt-labs/dbt-adapters/issues/1015))
- [@skadyan](https://github.com/skadyan) ([#695](https://github.com/dbt-labs/dbt-adapters/issues/695))

## dbt-snowflake 1.10.0-rc3 - June 24, 2025

### Features

- Add support for optional iceberg builtin catalog relation parameters for data retention/extension, storage serialization & change tracking ([#1158](https://github.com/dbt-labs/dbt-adapters/issues/1158))
- Add 's3_stage_vpce_dns_name' session parameter ([#1161](https://github.com/dbt-labs/dbt-adapters/issues/1161))

### Under the Hood

- remove reliance on setting session `quoted_identifiers_ignore_case` parameter to normalize snowflake metadata queries ([#1159](https://github.com/dbt-labs/dbt-adapters/issues/1159))

### Dependencies

- update the lower bound for dbt-adapters version in dbt-snowflake to >=1.16 ([#1148](https://github.com/dbt-labs/dbt-adapters/pull/1148))

### Contributors
- [@csquire](https://github.com/csquire) ([#1161](https://github.com/dbt-labs/dbt-adapters/issues/1161))

## dbt-snowflake 1.10.0-rc2 - June 04, 2025

### Features

- Add row_access_policy and table_tag config for Snowflake models ([#697](https://github.com/dbt-labs/dbt-adapters/issues/697))
- Use catalog_name as signifier for logical catalog ([#1134](https://github.com/dbt-labs/dbt-adapters/issues/1134))

### Under the Hood

- populate file_format from top level integration config field ([#1134](https://github.com/dbt-labs/dbt-adapters/issues/1134))

### Contributors
- [@b-per](https://github.com/b-per) ([#697](https://github.com/dbt-labs/dbt-adapters/issues/697))

## dbt-snowflake 1.10.0-rc1 - May 28, 2025

### Fixes

- Set append=True as default query comment append behaviour ([#1066](https://github.com/dbt-labs/dbt-adapters/issues/1066))
- Apply cluster keys via a separate ALTER statement after creating a table via a CTAS statement. ([#1071](https://github.com/dbt-labs/dbt-adapters/issues/1071))
- Respect QUOTED_IDENTIFIERS_IGNORE_CASE with dynamic tables. ([#993](https://github.com/dbt-labs/dbt-adapters/issues/993))

### Under the Hood

- Remove enable_iceberg_materializations behavior flag now that 2025_01 is required ([#1025](https://github.com/dbt-labs/dbt-adapters/issues/1025))
- Expand snapshot testing. ([#1068](https://github.com/dbt-labs/dbt-adapters/issues/1068))
- Raise the dbt-adapters pin to 1.14.3 to make dbt-adapter dependency resolution more reliable for higher versions of snowflake. ([#1098](https://github.com/dbt-labs/dbt-adapters/issues/1098))

## dbt-snowflake 1.9.4 - May 02, 2025

### Fixes

- correct cluster_by type check to return str as-is ([#1050](https://github.com/dbt-labs/dbt-adapters/issues/1050))

## dbt-snowflake 1.9.3 - April 29, 2025

### Breaking Changes

- Update `iceberg_managed` catalog type to `built_in` ([#1011](https://github.com/dbt-labs/dbt-adapters/issues/1011))

### Features

- Add support for Snowflake's managed Iceberg catalog via dbt's catalog framework ([#932](https://github.com/dbt-labs/dbt-adapters/issues/932))

### Fixes

- Correctly detect Iceberg tables when using multiple databases. ([#846](https://github.com/dbt-labs/dbt-adapters/issues/846))
- Dynamic table metadata queries now ignore the QUOTED_IDENTIFIERS_IGNORE_CASE setting ([#917](https://github.com/dbt-labs/dbt-adapters/issues/917))
- `datetime.datetime.utcnow()` is deprecated as of Python 3.12 ([#980](https://github.com/dbt-labs/dbt-adapters/issues/980))
- Fix regression in list_relations pagination that did not properly handle projects with more than 1,000 models ([#989](https://github.com/dbt-labs/dbt-adapters/issues/989))
- Pin certifi library to address regression in version 2025.4.26 ([#1027](https://github.com/dbt-labs/dbt-adapters/issues/1027))

### Under the Hood

- Simple fix to record/replay annotation. ([#761](https://github.com/dbt-labs/dbt-adapters/issues/761))
- Update list_relations_without_caching macro to reuse the same query on pagination and handle the quoted_identifiers_ignore_case setting ([#967](https://github.com/dbt-labs/dbt-adapters/issues/967))

### Contributors
- [@ms32035](https://github.com/ms32035) ([#846](https://github.com/dbt-labs/dbt-adapters/issues/846))

## dbt-snowflake 1.9.2 - March 07, 2025

### Features

- Support MicrobatchConcurrency ([#1260](https://github.com/dbt-labs/dbt-adapters/issues/1260))
- Added support for custom iceberg base_location_root ([#1284](https://github.com/dbt-labs/dbt-adapters/issues/1284))
- Add insert_overwrite 'incremental' strategy. ([#736](https://github.com/dbt-labs/dbt-adapters/issues/736))

### Fixes

- Fix parsing of the VECTOR type ([#1098](https://github.com/dbt-labs/dbt-adapters/issues/1098))
- Use timestamp_tz type in microbatch `delete` DDL ([#1256](https://github.com/dbt-labs/dbt-adapters/issues/1256))
- AUTO should no longer lead to rebuilds of dynamic tables. ([#1267](https://github.com/dbt-labs/dbt-adapters/issues/1267))
- Loosen pin for snowflake-connector-python to pin at 3.x ([#835](https://github.com/dbt-labs/dbt-adapters/issues/835))

### Under the Hood

- Move from setup.py to pyproject.toml and to hatch as a dev tool ([#1250](https://github.com/dbt-labs/dbt-adapters/issues/1250))
- Use new `batch` context variables over `node.config.__dbt_internal` ones ([#1263](https://github.com/dbt-labs/dbt-adapters/issues/1263))
- Update default Python version for python models ([#1203](https://github.com/dbt-labs/dbt-adapters/issues/1203))
- Expand types allowed in columns to allow structured types. ([#310](https://github.com/dbt-labs/dbt-adapters/issues/310))

### Security

- Resolve CVE-2025-24794 ([#859](https://github.com/dbt-labs/dbt-adapters/pull/859))

### Contributors
- [@LProcopi15](https://github.com/LProcopi15) ([#1284](https://github.com/dbt-labs/dbt-adapters/issues/1284))
- [@achawkins](https://github.com/achawkins) ([#1098](https://github.com/dbt-labs/dbt-adapters/issues/1098))

## Previous Releases
For information on prior major and minor releases, see their changelogs:
- [1.9](https://github.com/dbt-labs/dbt-snowflake/blob/1.9.latest/CHANGELOG.md)
- [1.8](https://github.com/dbt-labs/dbt-snowflake/blob/1.8.latest/CHANGELOG.md)
- [1.7](https://github.com/dbt-labs/dbt-snowflake/blob/1.7.latest/CHANGELOG.md)
- [1.6](https://github.com/dbt-labs/dbt-snowflake/blob/1.6.latest/CHANGELOG.md)
- [1.5](https://github.com/dbt-labs/dbt-snowflake/blob/1.5.latest/CHANGELOG.md)
- [1.4](https://github.com/dbt-labs/dbt-snowflake/blob/1.4.latest/CHANGELOG.md)
- [1.3](https://github.com/dbt-labs/dbt-snowflake/blob/1.3.latest/CHANGELOG.md)
- [1.2](https://github.com/dbt-labs/dbt-snowflake/blob/1.2.latest/CHANGELOG.md)
- [1.1](https://github.com/dbt-labs/dbt-snowflake/blob/1.1.latest/CHANGELOG.md)
- [1.0](https://github.com/dbt-labs/dbt-snowflake/blob/1.0.latest/CHANGELOG.md)
