# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .workflow_engine import WorkflowEngine
from .workflow_prompt_group import WorkflowPromptGroup
from .workflow_step_config_field import WorkflowStepConfigField


class WorkflowStepConfig(UniversalBaseModel):
    """
    Configurations for an agent, including LLM information and prompts
    """

    engine: typing.Optional[WorkflowEngine] = None
    field: typing.Optional[WorkflowStepConfigField] = pydantic.Field(default=None)
    """
    The field where agent output will be saved
    """

    includes: typing.Optional[typing.Dict[str, bool]] = None
    prompt: typing.Optional[WorkflowPromptGroup] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
