# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NamespaceArgs', 'Namespace']

@pulumi.input_type
class NamespaceArgs:
    def __init__(__self__, *,
                 capabilities: Optional[pulumi.Input['NamespaceCapabilitiesArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 meta: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 node_pool_config: Optional[pulumi.Input['NamespaceNodePoolConfigArgs']] = None,
                 quota: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Namespace resource.
        :param pulumi.Input['NamespaceCapabilitiesArgs'] capabilities: `(block: <optional>)` - A block of capabilities for the namespace. Can't
               be repeated. See below for the structure of this block.
        :param pulumi.Input[_builtins.str] description: `(string: "")` - A description of the namespace.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] meta: `(map[string]string: <optional>)` -  Specifies arbitrary KV metadata to associate with the namespace.
        :param pulumi.Input[_builtins.str] name: `(string: <required>)` - A unique name for the namespace.
        :param pulumi.Input['NamespaceNodePoolConfigArgs'] node_pool_config: `(block: <optional>)` - A block with node pool configuration for the namespace (Nomad Enterprise only).
        :param pulumi.Input[_builtins.str] quota: `(string: "")` - A resource quota to attach to the namespace.
        """
        if capabilities is not None:
            pulumi.set(__self__, "capabilities", capabilities)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if meta is not None:
            pulumi.set(__self__, "meta", meta)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_pool_config is not None:
            pulumi.set(__self__, "node_pool_config", node_pool_config)
        if quota is not None:
            pulumi.set(__self__, "quota", quota)

    @_builtins.property
    @pulumi.getter
    def capabilities(self) -> Optional[pulumi.Input['NamespaceCapabilitiesArgs']]:
        """
        `(block: <optional>)` - A block of capabilities for the namespace. Can't
        be repeated. See below for the structure of this block.
        """
        return pulumi.get(self, "capabilities")

    @capabilities.setter
    def capabilities(self, value: Optional[pulumi.Input['NamespaceCapabilitiesArgs']]):
        pulumi.set(self, "capabilities", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `(string: "")` - A description of the namespace.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def meta(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        `(map[string]string: <optional>)` -  Specifies arbitrary KV metadata to associate with the namespace.
        """
        return pulumi.get(self, "meta")

    @meta.setter
    def meta(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "meta", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `(string: <required>)` - A unique name for the namespace.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nodePoolConfig")
    def node_pool_config(self) -> Optional[pulumi.Input['NamespaceNodePoolConfigArgs']]:
        """
        `(block: <optional>)` - A block with node pool configuration for the namespace (Nomad Enterprise only).
        """
        return pulumi.get(self, "node_pool_config")

    @node_pool_config.setter
    def node_pool_config(self, value: Optional[pulumi.Input['NamespaceNodePoolConfigArgs']]):
        pulumi.set(self, "node_pool_config", value)

    @_builtins.property
    @pulumi.getter
    def quota(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `(string: "")` - A resource quota to attach to the namespace.
        """
        return pulumi.get(self, "quota")

    @quota.setter
    def quota(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "quota", value)


@pulumi.input_type
class _NamespaceState:
    def __init__(__self__, *,
                 capabilities: Optional[pulumi.Input['NamespaceCapabilitiesArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 meta: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 node_pool_config: Optional[pulumi.Input['NamespaceNodePoolConfigArgs']] = None,
                 quota: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Namespace resources.
        :param pulumi.Input['NamespaceCapabilitiesArgs'] capabilities: `(block: <optional>)` - A block of capabilities for the namespace. Can't
               be repeated. See below for the structure of this block.
        :param pulumi.Input[_builtins.str] description: `(string: "")` - A description of the namespace.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] meta: `(map[string]string: <optional>)` -  Specifies arbitrary KV metadata to associate with the namespace.
        :param pulumi.Input[_builtins.str] name: `(string: <required>)` - A unique name for the namespace.
        :param pulumi.Input['NamespaceNodePoolConfigArgs'] node_pool_config: `(block: <optional>)` - A block with node pool configuration for the namespace (Nomad Enterprise only).
        :param pulumi.Input[_builtins.str] quota: `(string: "")` - A resource quota to attach to the namespace.
        """
        if capabilities is not None:
            pulumi.set(__self__, "capabilities", capabilities)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if meta is not None:
            pulumi.set(__self__, "meta", meta)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_pool_config is not None:
            pulumi.set(__self__, "node_pool_config", node_pool_config)
        if quota is not None:
            pulumi.set(__self__, "quota", quota)

    @_builtins.property
    @pulumi.getter
    def capabilities(self) -> Optional[pulumi.Input['NamespaceCapabilitiesArgs']]:
        """
        `(block: <optional>)` - A block of capabilities for the namespace. Can't
        be repeated. See below for the structure of this block.
        """
        return pulumi.get(self, "capabilities")

    @capabilities.setter
    def capabilities(self, value: Optional[pulumi.Input['NamespaceCapabilitiesArgs']]):
        pulumi.set(self, "capabilities", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `(string: "")` - A description of the namespace.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def meta(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        `(map[string]string: <optional>)` -  Specifies arbitrary KV metadata to associate with the namespace.
        """
        return pulumi.get(self, "meta")

    @meta.setter
    def meta(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "meta", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `(string: <required>)` - A unique name for the namespace.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nodePoolConfig")
    def node_pool_config(self) -> Optional[pulumi.Input['NamespaceNodePoolConfigArgs']]:
        """
        `(block: <optional>)` - A block with node pool configuration for the namespace (Nomad Enterprise only).
        """
        return pulumi.get(self, "node_pool_config")

    @node_pool_config.setter
    def node_pool_config(self, value: Optional[pulumi.Input['NamespaceNodePoolConfigArgs']]):
        pulumi.set(self, "node_pool_config", value)

    @_builtins.property
    @pulumi.getter
    def quota(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `(string: "")` - A resource quota to attach to the namespace.
        """
        return pulumi.get(self, "quota")

    @quota.setter
    def quota(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "quota", value)


@pulumi.type_token("nomad:index/namespace:Namespace")
class Namespace(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 capabilities: Optional[pulumi.Input[Union['NamespaceCapabilitiesArgs', 'NamespaceCapabilitiesArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 meta: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 node_pool_config: Optional[pulumi.Input[Union['NamespaceNodePoolConfigArgs', 'NamespaceNodePoolConfigArgsDict']]] = None,
                 quota: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provisions a namespace within a Nomad cluster.

        Nomad auto-generates a default namespace called `default`. This namespace
        cannot be removed, so destroying a `Namespace` resource where
        `name = "default"` will cause the namespace to be reset to its default
        configuration.

        ## Example Usage

        Registering a namespace:

        ```python
        import pulumi
        import pulumi_nomad as nomad

        dev = nomad.Namespace("dev",
            name="dev",
            description="Shared development environment.",
            quota="dev",
            meta={
                "owner": "John Doe",
                "foo": "bar",
            })
        ```

        Registering a namespace with a quota:

        ```python
        import pulumi
        import pulumi_nomad as nomad

        web_team = nomad.QuoteSpecification("web_team",
            name="web-team",
            description="web team quota",
            limits=[{
                "region": "global",
                "region_limit": {
                    "cpu": 1000,
                    "memory_mb": 256,
                },
            }])
        web = nomad.Namespace("web",
            name="web",
            description="Web team production environment.",
            quota=web_team.name)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['NamespaceCapabilitiesArgs', 'NamespaceCapabilitiesArgsDict']] capabilities: `(block: <optional>)` - A block of capabilities for the namespace. Can't
               be repeated. See below for the structure of this block.
        :param pulumi.Input[_builtins.str] description: `(string: "")` - A description of the namespace.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] meta: `(map[string]string: <optional>)` -  Specifies arbitrary KV metadata to associate with the namespace.
        :param pulumi.Input[_builtins.str] name: `(string: <required>)` - A unique name for the namespace.
        :param pulumi.Input[Union['NamespaceNodePoolConfigArgs', 'NamespaceNodePoolConfigArgsDict']] node_pool_config: `(block: <optional>)` - A block with node pool configuration for the namespace (Nomad Enterprise only).
        :param pulumi.Input[_builtins.str] quota: `(string: "")` - A resource quota to attach to the namespace.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[NamespaceArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provisions a namespace within a Nomad cluster.

        Nomad auto-generates a default namespace called `default`. This namespace
        cannot be removed, so destroying a `Namespace` resource where
        `name = "default"` will cause the namespace to be reset to its default
        configuration.

        ## Example Usage

        Registering a namespace:

        ```python
        import pulumi
        import pulumi_nomad as nomad

        dev = nomad.Namespace("dev",
            name="dev",
            description="Shared development environment.",
            quota="dev",
            meta={
                "owner": "John Doe",
                "foo": "bar",
            })
        ```

        Registering a namespace with a quota:

        ```python
        import pulumi
        import pulumi_nomad as nomad

        web_team = nomad.QuoteSpecification("web_team",
            name="web-team",
            description="web team quota",
            limits=[{
                "region": "global",
                "region_limit": {
                    "cpu": 1000,
                    "memory_mb": 256,
                },
            }])
        web = nomad.Namespace("web",
            name="web",
            description="Web team production environment.",
            quota=web_team.name)
        ```

        :param str resource_name: The name of the resource.
        :param NamespaceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NamespaceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 capabilities: Optional[pulumi.Input[Union['NamespaceCapabilitiesArgs', 'NamespaceCapabilitiesArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 meta: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 node_pool_config: Optional[pulumi.Input[Union['NamespaceNodePoolConfigArgs', 'NamespaceNodePoolConfigArgsDict']]] = None,
                 quota: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NamespaceArgs.__new__(NamespaceArgs)

            __props__.__dict__["capabilities"] = capabilities
            __props__.__dict__["description"] = description
            __props__.__dict__["meta"] = meta
            __props__.__dict__["name"] = name
            __props__.__dict__["node_pool_config"] = node_pool_config
            __props__.__dict__["quota"] = quota
        super(Namespace, __self__).__init__(
            'nomad:index/namespace:Namespace',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            capabilities: Optional[pulumi.Input[Union['NamespaceCapabilitiesArgs', 'NamespaceCapabilitiesArgsDict']]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            meta: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            node_pool_config: Optional[pulumi.Input[Union['NamespaceNodePoolConfigArgs', 'NamespaceNodePoolConfigArgsDict']]] = None,
            quota: Optional[pulumi.Input[_builtins.str]] = None) -> 'Namespace':
        """
        Get an existing Namespace resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['NamespaceCapabilitiesArgs', 'NamespaceCapabilitiesArgsDict']] capabilities: `(block: <optional>)` - A block of capabilities for the namespace. Can't
               be repeated. See below for the structure of this block.
        :param pulumi.Input[_builtins.str] description: `(string: "")` - A description of the namespace.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] meta: `(map[string]string: <optional>)` -  Specifies arbitrary KV metadata to associate with the namespace.
        :param pulumi.Input[_builtins.str] name: `(string: <required>)` - A unique name for the namespace.
        :param pulumi.Input[Union['NamespaceNodePoolConfigArgs', 'NamespaceNodePoolConfigArgsDict']] node_pool_config: `(block: <optional>)` - A block with node pool configuration for the namespace (Nomad Enterprise only).
        :param pulumi.Input[_builtins.str] quota: `(string: "")` - A resource quota to attach to the namespace.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NamespaceState.__new__(_NamespaceState)

        __props__.__dict__["capabilities"] = capabilities
        __props__.__dict__["description"] = description
        __props__.__dict__["meta"] = meta
        __props__.__dict__["name"] = name
        __props__.__dict__["node_pool_config"] = node_pool_config
        __props__.__dict__["quota"] = quota
        return Namespace(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def capabilities(self) -> pulumi.Output[Optional['outputs.NamespaceCapabilities']]:
        """
        `(block: <optional>)` - A block of capabilities for the namespace. Can't
        be repeated. See below for the structure of this block.
        """
        return pulumi.get(self, "capabilities")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        `(string: "")` - A description of the namespace.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def meta(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        `(map[string]string: <optional>)` -  Specifies arbitrary KV metadata to associate with the namespace.
        """
        return pulumi.get(self, "meta")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        `(string: <required>)` - A unique name for the namespace.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nodePoolConfig")
    def node_pool_config(self) -> pulumi.Output['outputs.NamespaceNodePoolConfig']:
        """
        `(block: <optional>)` - A block with node pool configuration for the namespace (Nomad Enterprise only).
        """
        return pulumi.get(self, "node_pool_config")

    @_builtins.property
    @pulumi.getter
    def quota(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        `(string: "")` - A resource quota to attach to the namespace.
        """
        return pulumi.get(self, "quota")

