# Generated by Django 4.2.23 on 2025-08-14 15:13

import django.contrib.postgres.fields
from django.db import migrations, models
import django.db.models.deletion
import django_lifecycle.mixins
import uuid


class Migration(migrations.Migration):

    replaces = [
        ("container", "0001_initial"),
        ("container", "0002_containerrepository"),
        ("container", "0003_oci_mediatype"),
        ("container", "0004_upload"),
        ("container", "0005_contentredirectcontentguard"),
        ("container", "0006_containerpushrepository"),
        ("container", "0007_clear_tags_artifacts_refs"),
        ("container", "0008_include_exclude_tags"),
        ("container", "0009_container_namespace"),
        ("container", "0010_remove_uploadchunk"),
        ("container", "0011_add_container_repository_permissions"),
        ("container", "0012_add_container_namespace_permissions"),
        ("container", "0013_add_pull_push_permissions"),
        ("container", "0014_containerdistribution_private"),
        ("container", "0015_manage_tags_push_repo"),
        ("container", "0016_add_delete_versions_permission"),
        ("container", "0017_add_granular_perms"),
        ("container", "0018_containerdistribution_description"),
        ("container", "0019_DATA_distribution_model_swap"),
        ("container", "0020_update_push_repo_perms"),
        ("container", "0021_data_move_redirect_content_guard_to_core"),
        ("container", "0022_delete_contentredirectcontentguard"),
        ("container", "0023_manifestsignature"),
        ("container", "0024_containerremote_sigstore"),
        ("container", "0025_signature_stored_in_textfield"),
        ("container", "0026_manifest_signing_service"),
        ("container", "0027_data_translate_perms_to_roles"),
        ("container", "0028_add_role_manage_permissions"),
        ("container", "0029_remove_blob_media_type"),
        ("container", "0030_enforce_tagged_manifest_reference"),
        ("container", "0031_replace_charf_with_textf"),
        ("container", "0032_upload_artifact"),
    ]

    initial = True

    dependencies = [
        ("core", "0091_systemid"),
    ]

    operations = [
        migrations.CreateModel(
            name="Blob",
            fields=[
                (
                    "content_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        related_name="container_blob",
                        serialize=False,
                        to="core.content",
                    ),
                ),
                ("digest", models.TextField(db_index=True)),
            ],
            options={
                "default_related_name": "%(app_label)s_%(model_name)s",
                "unique_together": {("digest",)},
            },
            bases=("core.content",),
        ),
        migrations.CreateModel(
            name="BlobManifest",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Manifest",
            fields=[
                (
                    "content_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        related_name="container_manifest",
                        serialize=False,
                        to="core.content",
                    ),
                ),
                ("digest", models.CharField(db_index=True, max_length=255)),
                ("schema_version", models.IntegerField()),
                (
                    "media_type",
                    models.CharField(
                        choices=[
                            (
                                "application/vnd.docker.distribution.manifest.v1+json",
                                "application/vnd.docker.distribution.manifest.v1+json",
                            ),
                            (
                                "application/vnd.docker.distribution.manifest.v2+json",
                                "application/vnd.docker.distribution.manifest.v2+json",
                            ),
                            (
                                "application/vnd.docker.distribution.manifest.list.v2+json",
                                "application/vnd.docker.distribution.manifest.list.v2+json",
                            ),
                        ],
                        max_length=60,
                    ),
                ),
                (
                    "blobs",
                    models.ManyToManyField(
                        related_name="container_manifest",
                        through="container.BlobManifest",
                        to="container.blob",
                    ),
                ),
                (
                    "config_blob",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="config_blob",
                        to="container.blob",
                    ),
                ),
            ],
            options={
                "default_related_name": "%(app_label)s_%(model_name)s",
            },
            bases=("core.content",),
        ),
        migrations.CreateModel(
            name="ManifestListManifest",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("architecture", models.TextField()),
                ("os", models.TextField()),
                ("os_version", models.TextField(blank=True, default="")),
                ("os_features", models.TextField(blank=True, default="")),
                ("features", models.TextField(blank=True, default="")),
                ("variant", models.TextField(blank=True, default="")),
                (
                    "image_manifest",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="image_manifests",
                        to="container.manifest",
                    ),
                ),
                (
                    "manifest_list",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="manifest_lists",
                        to="container.manifest",
                    ),
                ),
            ],
            options={
                "unique_together": {("image_manifest", "manifest_list")},
            },
        ),
        migrations.AddField(
            model_name="manifest",
            name="listed_manifests",
            field=models.ManyToManyField(
                related_name="container_manifest",
                through="container.ManifestListManifest",
                to="container.manifest",
            ),
        ),
        migrations.AddField(
            model_name="blobmanifest",
            name="manifest",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="blob_manifests",
                to="container.manifest",
            ),
        ),
        migrations.AddField(
            model_name="blobmanifest",
            name="manifest_blob",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="manifest_blobs",
                to="container.blob",
            ),
        ),
        migrations.AlterUniqueTogether(
            name="manifest",
            unique_together={("digest",)},
        ),
        migrations.AlterField(
            model_name="manifest",
            name="media_type",
            field=models.CharField(
                choices=[
                    (
                        "application/vnd.docker.distribution.manifest.v1+json",
                        "application/vnd.docker.distribution.manifest.v1+json",
                    ),
                    (
                        "application/vnd.docker.distribution.manifest.v2+json",
                        "application/vnd.docker.distribution.manifest.v2+json",
                    ),
                    (
                        "application/vnd.docker.distribution.manifest.list.v2+json",
                        "application/vnd.docker.distribution.manifest.list.v2+json",
                    ),
                    (
                        "application/vnd.oci.image.manifest.v1+json",
                        "application/vnd.oci.image.manifest.v1+json",
                    ),
                    (
                        "application/vnd.oci.image.index.v1+json",
                        "application/vnd.oci.image.index.v1+json",
                    ),
                ],
                max_length=60,
            ),
        ),
        migrations.CreateModel(
            name="ContainerNamespace",
            fields=[
                (
                    "pulp_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                ("pulp_created", models.DateTimeField(auto_now_add=True)),
                ("pulp_last_updated", models.DateTimeField(auto_now=True, null=True)),
                ("name", models.TextField(db_index=True)),
            ],
            options={
                "unique_together": {("name",)},
                "permissions": [
                    ("namespace_add_containerdistribution", "Add any distribution to a namespace"),
                    (
                        "namespace_delete_containerdistribution",
                        "Delete any distribution from a namespace",
                    ),
                    (
                        "namespace_view_containerdistribution",
                        "View any distribution in a namespace",
                    ),
                    (
                        "namespace_pull_containerdistribution",
                        "Pull from any distribution in a namespace",
                    ),
                    (
                        "namespace_push_containerdistribution",
                        "Push to any distribution in a namespace",
                    ),
                    (
                        "namespace_change_containerdistribution",
                        "Change any distribution in a namespace",
                    ),
                    (
                        "namespace_view_containerpushrepository",
                        "View any push repository in a namespace",
                    ),
                    (
                        "namespace_modify_content_containerpushrepository",
                        "Modify content in any push repository in a namespace",
                    ),
                    (
                        "namespace_change_containerpushrepository",
                        "Update any existing push repository in a namespace",
                    ),
                    (
                        "manage_roles_containernamespace",
                        "Can manage role assignments on container namespace",
                    ),
                ],
            },
            bases=(django_lifecycle.mixins.LifecycleModelMixin, models.Model),
        ),
        migrations.AlterUniqueTogether(
            name="blobmanifest",
            unique_together={("manifest", "manifest_blob")},
        ),
        migrations.CreateModel(
            name="ContainerDistribution",
            fields=[
                (
                    "distribution_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        related_name="container_containerdistribution",
                        serialize=False,
                        to="core.distribution",
                    ),
                ),
                (
                    "private",
                    models.BooleanField(
                        default=False,
                        help_text="Restrict pull access to explicitly authorized users. Defaults to unrestricted pull access.",
                    ),
                ),
                (
                    "namespace",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="container_distributions",
                        to="container.containernamespace",
                    ),
                ),
                ("description", models.TextField(null=True)),
            ],
            options={
                "default_related_name": "%(app_label)s_%(model_name)s",
                "permissions": [
                    ("pull_containerdistribution", "Can pull from a registry repo"),
                    ("push_containerdistribution", "Can push into the registry repo"),
                    (
                        "manage_roles_containerdistribution",
                        "Can manage role assignments on container distribution",
                    ),
                ],
            },
            bases=("core.distribution",),
        ),
        migrations.CreateModel(
            name="ManifestSigningService",
            fields=[
                (
                    "signingservice_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="core.signingservice",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=("core.signingservice",),
        ),
        migrations.CreateModel(
            name="ContainerPushRepository",
            fields=[
                (
                    "repository_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        related_name="container_containerpushrepository",
                        serialize=False,
                        to="core.repository",
                    ),
                ),
                (
                    "manifest_signing_service",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="container_containerpushrepository",
                        to="container.manifestsigningservice",
                    ),
                ),
            ],
            options={
                "default_related_name": "%(app_label)s_%(model_name)s",
                "permissions": [
                    (
                        "modify_content_containerpushrepository",
                        "Can modify content in a push repository",
                    ),
                    (
                        "manage_roles_containerpushrepository",
                        "Can manage role assignments on container pushrepository",
                    ),
                ],
            },
            bases=("core.repository",),
        ),
        migrations.CreateModel(
            name="ContainerRepository",
            fields=[
                (
                    "repository_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        related_name="container_containerrepository",
                        serialize=False,
                        to="core.repository",
                    ),
                ),
                (
                    "manifest_signing_service",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="container_containerrepository",
                        to="container.manifestsigningservice",
                    ),
                ),
            ],
            options={
                "default_related_name": "%(app_label)s_%(model_name)s",
                "permissions": [
                    ("sync_containerrepository", "Can start a sync task"),
                    ("modify_content_containerrepository", "Can modify content in a repository"),
                    (
                        "build_image_containerrepository",
                        "Can use the image builder in a repository",
                    ),
                    ("delete_containerrepository_versions", "Can delete repository versions"),
                    (
                        "manage_roles_containerrepository",
                        "Can manage role assignments on container repository",
                    ),
                ],
            },
            bases=("core.repository",),
        ),
        migrations.CreateModel(
            name="ContainerRemote",
            fields=[
                (
                    "remote_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        related_name="container_containerremote",
                        serialize=False,
                        to="core.remote",
                    ),
                ),
                ("upstream_name", models.TextField(db_index=True)),
                ("include_foreign_layers", models.BooleanField(default=False)),
                (
                    "include_tags",
                    django.contrib.postgres.fields.ArrayField(
                        base_field=models.TextField(null=True), null=True, size=None
                    ),
                ),
                (
                    "exclude_tags",
                    django.contrib.postgres.fields.ArrayField(
                        base_field=models.TextField(null=True), null=True, size=None
                    ),
                ),
                ("sigstore", models.TextField(null=True)),
            ],
            options={
                "default_related_name": "%(app_label)s_%(model_name)s",
                "permissions": [
                    (
                        "manage_roles_containerremote",
                        "Can manage role assignments on container remote",
                    )
                ],
            },
            bases=("core.remote",),
        ),
        migrations.AlterField(
            model_name="manifest",
            name="digest",
            field=models.TextField(db_index=True),
        ),
        migrations.AlterField(
            model_name="manifest",
            name="media_type",
            field=models.TextField(
                choices=[
                    (
                        "application/vnd.docker.distribution.manifest.v1+json",
                        "application/vnd.docker.distribution.manifest.v1+json",
                    ),
                    (
                        "application/vnd.docker.distribution.manifest.v2+json",
                        "application/vnd.docker.distribution.manifest.v2+json",
                    ),
                    (
                        "application/vnd.docker.distribution.manifest.list.v2+json",
                        "application/vnd.docker.distribution.manifest.list.v2+json",
                    ),
                    (
                        "application/vnd.oci.image.manifest.v1+json",
                        "application/vnd.oci.image.manifest.v1+json",
                    ),
                    (
                        "application/vnd.oci.image.index.v1+json",
                        "application/vnd.oci.image.index.v1+json",
                    ),
                ]
            ),
        ),
        migrations.CreateModel(
            name="ManifestSignature",
            fields=[
                (
                    "content_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        related_name="container_manifestsignature",
                        serialize=False,
                        to="core.content",
                    ),
                ),
                ("name", models.TextField(db_index=True)),
                ("digest", models.TextField()),
                ("type", models.TextField(choices=[("atomic", "atomic")])),
                ("key_id", models.TextField(db_index=True)),
                ("timestamp", models.PositiveIntegerField()),
                ("creator", models.TextField(blank=True)),
                ("data", models.TextField()),
                (
                    "signed_manifest",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="signed_manifests",
                        to="container.manifest",
                    ),
                ),
            ],
            options={
                "default_related_name": "%(app_label)s_%(model_name)s",
                "unique_together": {("digest",)},
            },
            bases=("core.content",),
        ),
        migrations.CreateModel(
            name="Tag",
            fields=[
                (
                    "content_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        related_name="container_tag",
                        serialize=False,
                        to="core.content",
                    ),
                ),
                ("name", models.TextField(db_index=True)),
                (
                    "tagged_manifest",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="tagged_manifests",
                        to="container.manifest",
                    ),
                ),
            ],
            options={
                "default_related_name": "%(app_label)s_%(model_name)s",
                "unique_together": {("name", "tagged_manifest")},
            },
            bases=("core.content",),
        ),
        migrations.CreateModel(
            name="Upload",
            fields=[
                (
                    "repository",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="uploads",
                        to="core.repository",
                    ),
                ),
                (
                    "upload_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="core.upload",
                    ),
                ),
                (
                    "artifact",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="uploads",
                        to="core.artifact",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
    ]
