# Generated by Django 4.2.10 on 2024-02-29 16:04
import warnings

from django.db import migrations, models


def print_warning_for_initializing_image_nature(apps, schema_editor):
    warnings.warn(
        "Run 'pulpcore-manager container-handle-image-data' to initialize and expose metadata "
        "(i.e., annotations and labels) for all manifests."
    )


class Migration(migrations.Migration):

    dependencies = [
        ('container', '0037_create_pull_through_cache_models'),
    ]

    operations = [
        migrations.AddField(
            model_name='manifest',
            name='annotations',
            field=models.JSONField(default=dict),
        ),
        migrations.AddField(
            model_name='manifest',
            name='is_bootable',
            field=models.BooleanField(default=False),
        ),
        migrations.AddField(
            model_name='manifest',
            name='is_flatpak',
            field=models.BooleanField(default=False),
        ),
        migrations.AddField(
            model_name='manifest',
            name='labels',
            field=models.JSONField(default=dict),
        ),
        migrations.RunPython(
            code=print_warning_for_initializing_image_nature,
            reverse_code=migrations.RunPython.noop,
            elidable=True,
        )
    ]
