import numpy as np
import pytest


# ========================================== Mesh Setup ============================================
@pytest.fixture(scope="module")
def mesh_small():
    meta_data = {
        "mesh_bounds_x": [0, 1],
        "mesh_bounds_y": [0, 1],
        "num_points_x": 3,
        "num_points_y": 3,
    }

    vertices = np.array(
        [
            [0.0, 0.0],
            [0.0, 0.5],
            [0.0, 1.0],
            [0.5, 0.0],
            [0.5, 0.5],
            [0.5, 1.0],
            [1.0, 0.0],
            [1.0, 0.5],
            [1.0, 1.0],
        ],
        dtype=np.float32,
    )

    simplices = np.array(
        [[1, 3, 4], [3, 1, 0], [5, 1, 4], [1, 5, 2], [3, 7, 4], [7, 3, 6], [7, 5, 4], [5, 7, 8]],
        dtype=np.int32,
    )

    return vertices, simplices, meta_data


# --------------------------------------------------------------------------------------------------
@pytest.fixture(scope="module")
def mesh_and_adjacency_data_small(mesh_small):
    adjacency_data = np.array(
        [
            [[0, 3, 1, 1], [-1, -1, -1, -1], [-1, -1, -1, -1], [-1, -1, -1, -1]],
            [[1, 3, 4, 0], [1, 3, 0, 1], [1, 5, 4, 2], [1, 5, 2, 3]],
            [[2, 1, 5, 3], [-1, -1, -1, -1], [-1, -1, -1, -1], [-1, -1, -1, -1]],
            [[3, 1, 4, 0], [3, 1, 0, 1], [3, 7, 4, 4], [3, 7, 6, 5]],
            [[4, 1, 3, 0], [4, 5, 1, 2], [4, 3, 7, 4], [4, 7, 5, 6]],
            [[5, 1, 4, 2], [5, 1, 2, 3], [5, 7, 4, 6], [5, 7, 8, 7]],
            [[6, 7, 3, 5], [-1, -1, -1, -1], [-1, -1, -1, -1], [-1, -1, -1, -1]],
            [[7, 3, 4, 4], [7, 3, 6, 5], [7, 5, 4, 6], [7, 5, 8, 7]],
            [[8, 5, 7, 7], [-1, -1, -1, -1], [-1, -1, -1, -1], [-1, -1, -1, -1]],
        ],
        dtype=np.int32,
    )

    return mesh_small, adjacency_data
