
---

## 🧾 **README.md**

````markdown
# 🚀 Rocket Package

The **Rocket** package simulates a rocket ship that can be used in games, learning projects, or physics simulations.  
It was created as part of a Python packaging exercise to demonstrate how to build, install, and distribute custom modules.

---

## 📦 Installation

### Option 1 — From source
After building your package using:
```bash
python setup.py sdist
````

Install it with:

```bash
pip install dist/rocket-0.1.tar.gz
```

### Option 2 — From wheel

Alternatively, build and install the wheel:

```bash
python setup.py bdist_wheel
pip install dist/rocket-0.1-py3-none-any.whl
```

---

## 🚀 Usage Example

Once installed, you can use the package in your Python scripts:

```python
from rocket import rocket

# Create a new rocket at coordinates (0, 0)
r = rocket.Rocket()

# Print its initial position
print(f"Rocket position: x={r.x}, y={r.y}")

# Move the rocket
r.move_rocket(10, 15)
print(f"New position: x={r.x}, y={r.y}")
```

---

## 🧠 Project Structure

```
rocket/
│
├── LICENSE.txt
├── README.md
├── setup.py
└── rocket/
    ├── __init__.py
    └── rocket.py
```

---

## 📝 License

This project is licensed under the [MIT License](https://choosealicense.com/licenses/mit/).
You are free to use, modify, and distribute it for any purpose.

---

## 👨‍💻 Author

**Your Name**
📧 [youremail@example.com](mailto:youremail@example.com)
📂 [https://github.com/AbdallahYettou/rocket](https://github.com/AbdallahYettou/rocket)

```


