# Configuration file for the Sphinx documentation builder.
#
# For a full list of options, see
# https://www.sphinx-doc.org/en/master/usage/configuration.html

# -- Project information ---------------------------------------------------------------

project = "sdmx"
copyright = "2014–2024 sdmx1 developers"


# -- General configuration -------------------------------------------------------------

# Sphinx extension module names
extensions = [
    "sphinx.ext.autodoc",
    "sphinx.ext.autosummary",
    "sphinx.ext.extlinks",
    "sphinx.ext.intersphinx",
    "sphinx.ext.linkcode",
    "sphinx.ext.napoleon",
    "sphinx.ext.todo",
    "IPython.sphinxext.ipython_console_highlighting",
    "IPython.sphinxext.ipython_directive",
]

nitpicky = True

rst_prolog = """
.. role:: py(code)
   :language: python
.. role:: xml(code)
   :language: xml
"""

# -- Options for HTML output -----------------------------------------------------------

# The theme to use for HTML and HTML Help pages.
html_theme = "sphinx_book_theme"

html_theme_options = dict(
    path_to_docs="doc",
    repository_url="https://github.com/khaeru/sdmx",
    show_navbar_depth=2,
    use_edit_page_button=True,
    use_issues_button=True,
    use_repository_button=True,
    use_source_button=True,
)


# -- Options for sphinx.ext.extlinks ---------------------------------------------------

extlinks = {
    "issue": ("https://github.com/khaeru/sdmx/issues/%s", "#%s"),
    "pull": ("https://github.com/khaeru/sdmx/pull/%s", "PR #%s"),
    "gh-user": ("https://github.com/%s", "@%s"),
}


# -- Options for sphinx.ext.intersphinx ------------------------------------------------

intersphinx_mapping = {
    "np": ("https://numpy.org/doc/stable/", None),
    "pd": ("https://pandas.pydata.org/pandas-docs/stable/", None),
    "py": ("https://docs.python.org/3/", None),
    "requests": ("https://requests.readthedocs.io/en/latest/", None),
    "requests-cache": ("https://requests-cache.readthedocs.io/en/latest/", None),
}

# -- Options for sphinx.ext.linkcode ---------------------------------------------------


def linkcode_resolve(domain, info):
    if domain != "py" or not info["module"]:
        return None
    filename = info["module"].replace(".", "/")
    return f"https://github.com/khaeru/sdmx/tree/main/{filename}.py"


# -- Options for sphinx.ext.napoleon ---------------------------------------------------

napolean_preprocess_types = True

# -- Options for sphinx.ext.todo -------------------------------------------------------

# If True, todo and todolist produce output, else they produce nothing
todo_include_todos = True

# -- Options for IPython.sphinxext.ipython_directive -----------------------------------

# Specify if the embedded Sphinx shell should import Matplotlib and set the backend
ipython_mplbackend = ""

# -- Dynamic configuration


def setup(app):
    from importlib import import_module
    from pathlib import Path

    # Update files containing lists of classes
    for mod in "common", "v21", "v30":
        # prefix = f"{mod}." if mod != "common" else ""
        prefix = f"{mod}."
        path = Path(__file__).parent.joinpath("api", f"model-{mod}-list.rst")
        with open(path, "w") as f:
            f.write(".. This file is auto-generated by doc/conf.py.\n\n")
            f.writelines(
                f":obj:`~.{prefix}{name}`\n"
                for name in sorted(import_module(f"sdmx.model.{mod}").__all__)
            )
