from tunacode.core.state import StateManager


def test_no_permission_fields_present():
    """
    Characterization: SessionState and StateManager do not implement explicit permissions.
    """
    sm = StateManager()
    session = sm.session
    # No permission-related fields
    permission_fields = [f for f in session.__dataclass_fields__ if "permission" in f]
    assert permission_fields == []


def test_no_permission_state_transitions():
    """
    Characterization: No permission state transitions or inheritance logic present.
    """
    sm = StateManager()
    # No methods or fields for permission transitions
    assert not hasattr(sm.session, "set_permission")
    assert not hasattr(sm.session, "inherit_permission")


# Quirk: Permission state and inheritance not implemented in current StateManager.
