"""TFDWT: Fast Discrete Wavelet Transform TensorFlow Layers.
Copyright (C) 2025 Kishore Kumar Tarafdar

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <https://www.gnu.org/licenses/>.

Impulse Responses of Orthogonal and Biorthogonal Wavelet Families. """

FBimpulseResponses = {"haar": [[[0.7071067811865476, 0.7071067811865476], [0.7071067811865476, -0.7071067811865476]], [[0.7071067811865476, 0.7071067811865476], [0.7071067811865476, -0.7071067811865476]]], "db1": [[[0.7071067811865476, 0.7071067811865476], [0.7071067811865476, -0.7071067811865476]], [[0.7071067811865476, 0.7071067811865476], [0.7071067811865476, -0.7071067811865476]]], "db2": [[[0.48296291314453416, 0.8365163037378079, 0.2241438680420134, -0.12940952255126037], [-0.12940952255126037, -0.2241438680420134, 0.8365163037378079, -0.48296291314453416]], [[0.48296291314453416, 0.8365163037378079, 0.2241438680420134, -0.12940952255126037], [-0.12940952255126037, -0.2241438680420134, 0.8365163037378079, -0.48296291314453416]]], "db3": [[[0.33267055295008263, 0.8068915093110925, 0.45987750211849154, -0.13501102001025458, -0.08544127388202666, 0.03522629188570953], [0.03522629188570953, 0.08544127388202666, -0.13501102001025458, -0.45987750211849154, 0.8068915093110925, -0.33267055295008263]], [[0.33267055295008263, 0.8068915093110925, 0.45987750211849154, -0.13501102001025458, -0.08544127388202666, 0.03522629188570953], [0.03522629188570953, 0.08544127388202666, -0.13501102001025458, -0.45987750211849154, 0.8068915093110925, -0.33267055295008263]]], "db4": [[[0.2303778133088965, 0.7148465705529157, 0.6308807679298589, -0.027983769416859854, -0.18703481171909309, 0.030841381835560764, 0.0328830116668852, -0.010597401785069032], [-0.010597401785069032, -0.0328830116668852, 0.030841381835560764, 0.18703481171909309, -0.027983769416859854, -0.6308807679298589, 0.7148465705529157, -0.2303778133088965]], [[0.2303778133088965, 0.7148465705529157, 0.6308807679298589, -0.027983769416859854, -0.18703481171909309, 0.030841381835560764, 0.0328830116668852, -0.010597401785069032], [-0.010597401785069032, -0.0328830116668852, 0.030841381835560764, 0.18703481171909309, -0.027983769416859854, -0.6308807679298589, 0.7148465705529157, -0.2303778133088965]]], "db5": [[[0.16010239797419293, 0.6038292697971896, 0.7243085284377729, 0.13842814590132074, -0.24229488706638203, -0.032244869584638375, 0.07757149384004572, -0.006241490212798274, -0.012580751999081999, 0.0033357252854737712], [0.0033357252854737712, 0.012580751999081999, -0.006241490212798274, -0.07757149384004572, -0.032244869584638375, 0.24229488706638203, 0.13842814590132074, -0.7243085284377729, 0.6038292697971896, -0.16010239797419293]], [[0.16010239797419293, 0.6038292697971896, 0.7243085284377729, 0.13842814590132074, -0.24229488706638203, -0.032244869584638375, 0.07757149384004572, -0.006241490212798274, -0.012580751999081999, 0.0033357252854737712], [0.0033357252854737712, 0.012580751999081999, -0.006241490212798274, -0.07757149384004572, -0.032244869584638375, 0.24229488706638203, 0.13842814590132074, -0.7243085284377729, 0.6038292697971896, -0.16010239797419293]]], "db6": [[[0.11154074335010947, 0.49462389039845306, 0.7511339080210954, 0.31525035170919763, -0.22626469396543983, -0.12976686756726194, 0.09750160558732304, 0.027522865530305727, -0.03158203931748603, 0.0005538422011614961, 0.004777257510945511, -0.0010773010853084796], [-0.0010773010853084796, -0.004777257510945511, 0.0005538422011614961, 0.03158203931748603, 0.027522865530305727, -0.09750160558732304, -0.12976686756726194, 0.22626469396543983, 0.31525035170919763, -0.7511339080210954, 0.49462389039845306, -0.11154074335010947]], [[0.11154074335010947, 0.49462389039845306, 0.7511339080210954, 0.31525035170919763, -0.22626469396543983, -0.12976686756726194, 0.09750160558732304, 0.027522865530305727, -0.03158203931748603, 0.0005538422011614961, 0.004777257510945511, -0.0010773010853084796], [-0.0010773010853084796, -0.004777257510945511, 0.0005538422011614961, 0.03158203931748603, 0.027522865530305727, -0.09750160558732304, -0.12976686756726194, 0.22626469396543983, 0.31525035170919763, -0.7511339080210954, 0.49462389039845306, -0.11154074335010947]]], "db7": [[[0.07785205408500918, 0.3965393194819173, 0.7291320908462351, 0.4697822874051931, -0.14390600392856498, -0.22403618499387498, 0.07130921926683026, 0.08061260915108308, -0.03802993693501441, -0.01657454163066688, 0.01255099855609984, 0.0004295779729213665, -0.0018016407040474908, 0.00035371379997452024], [0.00035371379997452024, 0.0018016407040474908, 0.0004295779729213665, -0.01255099855609984, -0.01657454163066688, 0.03802993693501441, 0.08061260915108308, -0.07130921926683026, -0.22403618499387498, 0.14390600392856498, 0.4697822874051931, -0.7291320908462351, 0.3965393194819173, -0.07785205408500918]], [[0.07785205408500918, 0.3965393194819173, 0.7291320908462351, 0.4697822874051931, -0.14390600392856498, -0.22403618499387498, 0.07130921926683026, 0.08061260915108308, -0.03802993693501441, -0.01657454163066688, 0.01255099855609984, 0.0004295779729213665, -0.0018016407040474908, 0.00035371379997452024], [0.00035371379997452024, 0.0018016407040474908, 0.0004295779729213665, -0.01255099855609984, -0.01657454163066688, 0.03802993693501441, 0.08061260915108308, -0.07130921926683026, -0.22403618499387498, 0.14390600392856498, 0.4697822874051931, -0.7291320908462351, 0.3965393194819173, -0.07785205408500918]]], "db8": [[[0.05441584224310401, 0.31287159091429995, 0.6756307362972898, 0.5853546836542067, -0.015829105256349306, -0.2840155429615469, 0.0004724845739132828, 0.12874742662047847, -0.017369301001807547, -0.044088253930794755, 0.013981027917398282, 0.008746094047405777, -0.004870352993451574, -0.00039174037337694705, 0.0006754494064505693, -0.00011747678412476953], [-0.00011747678412476953, -0.0006754494064505693, -0.00039174037337694705, 0.004870352993451574, 0.008746094047405777, -0.013981027917398282, -0.044088253930794755, 0.017369301001807547, 0.12874742662047847, -0.0004724845739132828, -0.2840155429615469, 0.015829105256349306, 0.5853546836542067, -0.6756307362972898, 0.31287159091429995, -0.05441584224310401]], [[0.05441584224310401, 0.31287159091429995, 0.6756307362972898, 0.5853546836542067, -0.015829105256349306, -0.2840155429615469, 0.0004724845739132828, 0.12874742662047847, -0.017369301001807547, -0.044088253930794755, 0.013981027917398282, 0.008746094047405777, -0.004870352993451574, -0.00039174037337694705, 0.0006754494064505693, -0.00011747678412476953], [-0.00011747678412476953, -0.0006754494064505693, -0.00039174037337694705, 0.004870352993451574, 0.008746094047405777, -0.013981027917398282, -0.044088253930794755, 0.017369301001807547, 0.12874742662047847, -0.0004724845739132828, -0.2840155429615469, 0.015829105256349306, 0.5853546836542067, -0.6756307362972898, 0.31287159091429995, -0.05441584224310401]]], "db9": [[[0.038077947363878345, 0.24383467461259034, 0.6048231236901112, 0.6572880780513005, 0.13319738582500756, -0.2932737832791749, -0.09684078322297646, 0.14854074933810638, 0.03072568147933338, -0.06763282906132997, 0.00025094711483145197, 0.022361662123679096, -0.004723204757751397, -0.00428150368246343, 0.0018476468830562265, 0.00023038576352319597, -0.0002519631889427101, 3.93473203162716e-05], [3.93473203162716e-05, 0.0002519631889427101, 0.00023038576352319597, -0.0018476468830562265, -0.00428150368246343, 0.004723204757751397, 0.022361662123679096, -0.00025094711483145197, -0.06763282906132997, -0.03072568147933338, 0.14854074933810638, 0.09684078322297646, -0.2932737832791749, -0.13319738582500756, 0.6572880780513005, -0.6048231236901112, 0.24383467461259034, -0.038077947363878345]], [[0.038077947363878345, 0.24383467461259034, 0.6048231236901112, 0.6572880780513005, 0.13319738582500756, -0.2932737832791749, -0.09684078322297646, 0.14854074933810638, 0.03072568147933338, -0.06763282906132997, 0.00025094711483145197, 0.022361662123679096, -0.004723204757751397, -0.00428150368246343, 0.0018476468830562265, 0.00023038576352319597, -0.0002519631889427101, 3.93473203162716e-05], [3.93473203162716e-05, 0.0002519631889427101, 0.00023038576352319597, -0.0018476468830562265, -0.00428150368246343, 0.004723204757751397, 0.022361662123679096, -0.00025094711483145197, -0.06763282906132997, -0.03072568147933338, 0.14854074933810638, 0.09684078322297646, -0.2932737832791749, -0.13319738582500756, 0.6572880780513005, -0.6048231236901112, 0.24383467461259034, -0.038077947363878345]]], "db10": [[[0.026670057900555554, 0.1881768000776915, 0.5272011889317256, 0.6884590394536035, 0.2811723436605775, -0.24984642432731538, -0.19594627437737705, 0.12736934033579325, 0.09305736460357235, -0.07139414716639708, -0.029457536821875813, 0.033212674059341, 0.0036065535669561697, -0.010733175483330575, 0.001395351747052901, 0.001992405295185056, -0.0006858566949597116, -0.00011646685512928545, 9.358867032006959e-05, -1.3264202894521244e-05], [-1.3264202894521244e-05, -9.358867032006959e-05, -0.00011646685512928545, 0.0006858566949597116, 0.001992405295185056, -0.001395351747052901, -0.010733175483330575, -0.0036065535669561697, 0.033212674059341, 0.029457536821875813, -0.07139414716639708, -0.09305736460357235, 0.12736934033579325, 0.19594627437737705, -0.24984642432731538, -0.2811723436605775, 0.6884590394536035, -0.5272011889317256, 0.1881768000776915, -0.026670057900555554]], [[0.026670057900555554, 0.1881768000776915, 0.5272011889317256, 0.6884590394536035, 0.2811723436605775, -0.24984642432731538, -0.19594627437737705, 0.12736934033579325, 0.09305736460357235, -0.07139414716639708, -0.029457536821875813, 0.033212674059341, 0.0036065535669561697, -0.010733175483330575, 0.001395351747052901, 0.001992405295185056, -0.0006858566949597116, -0.00011646685512928545, 9.358867032006959e-05, -1.3264202894521244e-05], [-1.3264202894521244e-05, -9.358867032006959e-05, -0.00011646685512928545, 0.0006858566949597116, 0.001992405295185056, -0.001395351747052901, -0.010733175483330575, -0.0036065535669561697, 0.033212674059341, 0.029457536821875813, -0.07139414716639708, -0.09305736460357235, 0.12736934033579325, 0.19594627437737705, -0.24984642432731538, -0.2811723436605775, 0.6884590394536035, -0.5272011889317256, 0.1881768000776915, -0.026670057900555554]]], "db11": [[[0.018694297761471083, 0.1440670211506245, 0.44989976435604534, 0.6856867749162006, 0.41196436894790744, -0.16227524502749036, -0.27423084681794696, 0.0660435881966832, 0.14981201246637849, -0.046479955116684187, -0.0664387856950252, 0.031335090219046076, 0.020840904360181062, -0.0153648209062016, -0.0033408588730144454, 0.004928417656059041, -0.0003085928588151432, -0.0008930232506662646, 0.0002491525235528235, 5.4439074699368475e-05, -3.4634984186984996e-05, 4.49427427723651e-06], [4.49427427723651e-06, 3.4634984186984996e-05, 5.4439074699368475e-05, -0.0002491525235528235, -0.0008930232506662646, 0.0003085928588151432, 0.004928417656059041, 0.0033408588730144454, -0.0153648209062016, -0.020840904360181062, 0.031335090219046076, 0.0664387856950252, -0.046479955116684187, -0.14981201246637849, 0.0660435881966832, 0.27423084681794696, -0.16227524502749036, -0.41196436894790744, 0.6856867749162006, -0.44989976435604534, 0.1440670211506245, -0.018694297761471083]], [[0.018694297761471083, 0.1440670211506245, 0.44989976435604534, 0.6856867749162006, 0.41196436894790744, -0.16227524502749036, -0.27423084681794696, 0.0660435881966832, 0.14981201246637849, -0.046479955116684187, -0.0664387856950252, 0.031335090219046076, 0.020840904360181062, -0.0153648209062016, -0.0033408588730144454, 0.004928417656059041, -0.0003085928588151432, -0.0008930232506662646, 0.0002491525235528235, 5.4439074699368475e-05, -3.4634984186984996e-05, 4.49427427723651e-06], [4.49427427723651e-06, 3.4634984186984996e-05, 5.4439074699368475e-05, -0.0002491525235528235, -0.0008930232506662646, 0.0003085928588151432, 0.004928417656059041, 0.0033408588730144454, -0.0153648209062016, -0.020840904360181062, 0.031335090219046076, 0.0664387856950252, -0.046479955116684187, -0.14981201246637849, 0.0660435881966832, 0.27423084681794696, -0.16227524502749036, -0.41196436894790744, 0.6856867749162006, -0.44989976435604534, 0.1440670211506245, -0.018694297761471083]]], "db12": [[[0.013112257957229518, 0.10956627282118515, 0.37735513521421266, 0.6571987225793071, 0.5158864784278157, -0.04476388565377463, -0.3161784537527855, -0.023779257256069726, 0.18247860592757967, 0.00535956967435215, -0.09643212009650708, 0.010849130255822185, 0.04154627749508444, -0.01221864906974828, -0.012840825198300683, 0.00671149900879551, 0.0022486072409952378, -0.0021795036186277603, 6.545128212509596e-06, 0.00038865306282093143, -8.850410920820432e-05, -2.4241545757030785e-05, 1.2776952219379767e-05, -1.529071758068511e-06], [-1.529071758068511e-06, -1.2776952219379767e-05, -2.4241545757030785e-05, 8.850410920820432e-05, 0.00038865306282093143, -6.545128212509596e-06, -0.0021795036186277603, -0.0022486072409952378, 0.00671149900879551, 0.012840825198300683, -0.01221864906974828, -0.04154627749508444, 0.010849130255822185, 0.09643212009650708, 0.00535956967435215, -0.18247860592757967, -0.023779257256069726, 0.3161784537527855, -0.04476388565377463, -0.5158864784278157, 0.6571987225793071, -0.37735513521421266, 0.10956627282118515, -0.013112257957229518]], [[0.013112257957229518, 0.10956627282118515, 0.37735513521421266, 0.6571987225793071, 0.5158864784278157, -0.04476388565377463, -0.3161784537527855, -0.023779257256069726, 0.18247860592757967, 0.00535956967435215, -0.09643212009650708, 0.010849130255822185, 0.04154627749508444, -0.01221864906974828, -0.012840825198300683, 0.00671149900879551, 0.0022486072409952378, -0.0021795036186277603, 6.545128212509596e-06, 0.00038865306282093143, -8.850410920820432e-05, -2.4241545757030785e-05, 1.2776952219379767e-05, -1.529071758068511e-06], [-1.529071758068511e-06, -1.2776952219379767e-05, -2.4241545757030785e-05, 8.850410920820432e-05, 0.00038865306282093143, -6.545128212509596e-06, -0.0021795036186277603, -0.0022486072409952378, 0.00671149900879551, 0.012840825198300683, -0.01221864906974828, -0.04154627749508444, 0.010849130255822185, 0.09643212009650708, 0.00535956967435215, -0.18247860592757967, -0.023779257256069726, 0.3161784537527855, -0.04476388565377463, -0.5158864784278157, 0.6571987225793071, -0.37735513521421266, 0.10956627282118515, -0.013112257957229518]]], "db13": [[[0.009202133538962367, 0.08286124387290278, 0.31199632216043804, 0.6110558511587877, 0.5888895704312189, 0.08698572617964724, -0.31497290771138864, -0.12457673075081525, 0.17947607942933985, 0.07294893365677717, -0.10580761818793433, -0.026488406475343694, 0.05613947710028343, 0.0023799722540590786, -0.02383142071032365, 0.003923941448797416, 0.007255589401617566, -0.0027619112346568622, -0.001315673911892299, 0.0009323261308672633, 4.9251525126289464e-05, -0.0001651289885565055, 3.0678537579325496e-05, 1.0441930571408138e-05, -4.700416479360868e-06, 5.220035098454864e-07], [5.220035098454864e-07, 4.700416479360868e-06, 1.0441930571408138e-05, -3.0678537579325496e-05, -0.0001651289885565055, -4.9251525126289464e-05, 0.0009323261308672633, 0.001315673911892299, -0.0027619112346568622, -0.007255589401617566, 0.003923941448797416, 0.02383142071032365, 0.0023799722540590786, -0.05613947710028343, -0.026488406475343694, 0.10580761818793433, 0.07294893365677717, -0.17947607942933985, -0.12457673075081525, 0.31497290771138864, 0.08698572617964724, -0.5888895704312189, 0.6110558511587877, -0.31199632216043804, 0.08286124387290278, -0.009202133538962367]], [[0.009202133538962367, 0.08286124387290278, 0.31199632216043804, 0.6110558511587877, 0.5888895704312189, 0.08698572617964724, -0.31497290771138864, -0.12457673075081525, 0.17947607942933985, 0.07294893365677717, -0.10580761818793433, -0.026488406475343694, 0.05613947710028343, 0.0023799722540590786, -0.02383142071032365, 0.003923941448797416, 0.007255589401617566, -0.0027619112346568622, -0.001315673911892299, 0.0009323261308672633, 4.9251525126289464e-05, -0.0001651289885565055, 3.0678537579325496e-05, 1.0441930571408138e-05, -4.700416479360868e-06, 5.220035098454864e-07], [5.220035098454864e-07, 4.700416479360868e-06, 1.0441930571408138e-05, -3.0678537579325496e-05, -0.0001651289885565055, -4.9251525126289464e-05, 0.0009323261308672633, 0.001315673911892299, -0.0027619112346568622, -0.007255589401617566, 0.003923941448797416, 0.02383142071032365, 0.0023799722540590786, -0.05613947710028343, -0.026488406475343694, 0.10580761818793433, 0.07294893365677717, -0.17947607942933985, -0.12457673075081525, 0.31497290771138864, 0.08698572617964724, -0.5888895704312189, 0.6110558511587877, -0.31199632216043804, 0.08286124387290278, -0.009202133538962367]]], "db14": [[[0.006461153460087948, 0.0623647588493989, 0.2548502677926214, 0.5543056179408938, 0.6311878491048568, 0.21867068775890652, -0.27168855227874805, -0.21803352999327605, 0.1383952138648066, 0.1399890165844607, -0.08674841156816969, -0.07154895550404614, 0.05523712625921604, 0.026981408307912916, -0.030185351540390634, -0.005615049530356959, 0.01278949326633341, -0.000746218989268385, -0.0038496388680221874, 0.001061691085606762, 0.0007080211542355279, -0.0003868319473129545, -4.1777245770372596e-05, 6.87550425269751e-05, -1.0337209184570774e-05, -4.389704901781394e-06, 1.7249946753678127e-06, -1.7871399683113592e-07], [-1.7871399683113592e-07, -1.7249946753678127e-06, -4.389704901781394e-06, 1.0337209184570774e-05, 6.87550425269751e-05, 4.1777245770372596e-05, -0.0003868319473129545, -0.0007080211542355279, 0.001061691085606762, 0.0038496388680221874, -0.000746218989268385, -0.01278949326633341, -0.005615049530356959, 0.030185351540390634, 0.026981408307912916, -0.05523712625921604, -0.07154895550404614, 0.08674841156816969, 0.1399890165844607, -0.1383952138648066, -0.21803352999327605, 0.27168855227874805, 0.21867068775890652, -0.6311878491048568, 0.5543056179408938, -0.2548502677926214, 0.0623647588493989, -0.006461153460087948]], [[0.006461153460087948, 0.0623647588493989, 0.2548502677926214, 0.5543056179408938, 0.6311878491048568, 0.21867068775890652, -0.27168855227874805, -0.21803352999327605, 0.1383952138648066, 0.1399890165844607, -0.08674841156816969, -0.07154895550404614, 0.05523712625921604, 0.026981408307912916, -0.030185351540390634, -0.005615049530356959, 0.01278949326633341, -0.000746218989268385, -0.0038496388680221874, 0.001061691085606762, 0.0007080211542355279, -0.0003868319473129545, -4.1777245770372596e-05, 6.87550425269751e-05, -1.0337209184570774e-05, -4.389704901781394e-06, 1.7249946753678127e-06, -1.7871399683113592e-07], [-1.7871399683113592e-07, -1.7249946753678127e-06, -4.389704901781394e-06, 1.0337209184570774e-05, 6.87550425269751e-05, 4.1777245770372596e-05, -0.0003868319473129545, -0.0007080211542355279, 0.001061691085606762, 0.0038496388680221874, -0.000746218989268385, -0.01278949326633341, -0.005615049530356959, 0.030185351540390634, 0.026981408307912916, -0.05523712625921604, -0.07154895550404614, 0.08674841156816969, 0.1399890165844607, -0.1383952138648066, -0.21803352999327605, 0.27168855227874805, 0.21867068775890652, -0.6311878491048568, 0.5543056179408938, -0.2548502677926214, 0.0623647588493989, -0.006461153460087948]]], "db15": [[[0.004538537361578899, 0.04674339489276627, 0.20602386398699574, 0.4926317717081396, 0.6458131403574243, 0.3390025354547315, -0.19320413960914543, -0.28888259656696563, 0.06528295284877282, 0.190146714007123, -0.039666176555790945, -0.1111209360372317, 0.033877143923507685, 0.05478055058450761, -0.025767007328439964, -0.020810050169693083, 0.015083918027835902, 0.005101000360407543, -0.006487734560315745, -0.00024175649076162427, 0.0019433239803822114, -0.000373482354137617, -0.0003595652443624688, 0.00015589648992059973, 2.5792699155318936e-05, -2.8133296266047814e-05, 3.36298718173758e-06, 1.8112704079405772e-06, -6.316882325881664e-07, 6.133359913305752e-08], [6.133359913305752e-08, 6.316882325881664e-07, 1.8112704079405772e-06, -3.36298718173758e-06, -2.8133296266047814e-05, -2.5792699155318936e-05, 0.00015589648992059973, 0.0003595652443624688, -0.000373482354137617, -0.0019433239803822114, -0.00024175649076162427, 0.006487734560315745, 0.005101000360407543, -0.015083918027835902, -0.020810050169693083, 0.025767007328439964, 0.05478055058450761, -0.033877143923507685, -0.1111209360372317, 0.039666176555790945, 0.190146714007123, -0.06528295284877282, -0.28888259656696563, 0.19320413960914543, 0.3390025354547315, -0.6458131403574243, 0.4926317717081396, -0.20602386398699574, 0.04674339489276627, -0.004538537361578899]], [[0.004538537361578899, 0.04674339489276627, 0.20602386398699574, 0.4926317717081396, 0.6458131403574243, 0.3390025354547315, -0.19320413960914543, -0.28888259656696563, 0.06528295284877282, 0.190146714007123, -0.039666176555790945, -0.1111209360372317, 0.033877143923507685, 0.05478055058450761, -0.025767007328439964, -0.020810050169693083, 0.015083918027835902, 0.005101000360407543, -0.006487734560315745, -0.00024175649076162427, 0.0019433239803822114, -0.000373482354137617, -0.0003595652443624688, 0.00015589648992059973, 2.5792699155318936e-05, -2.8133296266047814e-05, 3.36298718173758e-06, 1.8112704079405772e-06, -6.316882325881664e-07, 6.133359913305752e-08], [6.133359913305752e-08, 6.316882325881664e-07, 1.8112704079405772e-06, -3.36298718173758e-06, -2.8133296266047814e-05, -2.5792699155318936e-05, 0.00015589648992059973, 0.0003595652443624688, -0.000373482354137617, -0.0019433239803822114, -0.00024175649076162427, 0.006487734560315745, 0.005101000360407543, -0.015083918027835902, -0.020810050169693083, 0.025767007328439964, 0.05478055058450761, -0.033877143923507685, -0.1111209360372317, 0.039666176555790945, 0.190146714007123, -0.06528295284877282, -0.28888259656696563, 0.19320413960914543, 0.3390025354547315, -0.6458131403574243, 0.4926317717081396, -0.20602386398699574, 0.04674339489276627, -0.004538537361578899]]], "db16": [[[0.003189220925347738, 0.034907714323673344, 0.16506428348885313, 0.4303127228460038, 0.637356332083789, 0.4402902568863569, -0.08975108940248964, -0.3270633105279177, -0.027918208133028276, 0.2111906939471043, 0.027340263752716042, -0.1323883055638104, -0.006239722752474872, 0.07592423604427631, -0.007588974368857738, -0.03688839769173014, 0.01029765964095597, 0.013993768859828731, -0.006990014563413916, -0.00364427962149839, 0.003128023381206269, 0.00040789698084971285, -0.0009410217493595676, 0.00011424152003872239, 0.00017478724522533817, -6.103596621410936e-05, -1.3945668988208893e-05, 1.1336608661276258e-05, -1.0435713423116066e-06, -7.363656785451205e-07, 2.3087840868575457e-07, -2.109339630100743e-08], [-2.109339630100743e-08, -2.3087840868575457e-07, -7.363656785451205e-07, 1.0435713423116066e-06, 1.1336608661276258e-05, 1.3945668988208893e-05, -6.103596621410936e-05, -0.00017478724522533817, 0.00011424152003872239, 0.0009410217493595676, 0.00040789698084971285, -0.003128023381206269, -0.00364427962149839, 0.006990014563413916, 0.013993768859828731, -0.01029765964095597, -0.03688839769173014, 0.007588974368857738, 0.07592423604427631, 0.006239722752474872, -0.1323883055638104, -0.027340263752716042, 0.2111906939471043, 0.027918208133028276, -0.3270633105279177, 0.08975108940248964, 0.4402902568863569, -0.637356332083789, 0.4303127228460038, -0.16506428348885313, 0.034907714323673344, -0.003189220925347738]], [[0.003189220925347738, 0.034907714323673344, 0.16506428348885313, 0.4303127228460038, 0.637356332083789, 0.4402902568863569, -0.08975108940248964, -0.3270633105279177, -0.027918208133028276, 0.2111906939471043, 0.027340263752716042, -0.1323883055638104, -0.006239722752474872, 0.07592423604427631, -0.007588974368857738, -0.03688839769173014, 0.01029765964095597, 0.013993768859828731, -0.006990014563413916, -0.00364427962149839, 0.003128023381206269, 0.00040789698084971285, -0.0009410217493595676, 0.00011424152003872239, 0.00017478724522533817, -6.103596621410936e-05, -1.3945668988208893e-05, 1.1336608661276258e-05, -1.0435713423116066e-06, -7.363656785451205e-07, 2.3087840868575457e-07, -2.109339630100743e-08], [-2.109339630100743e-08, -2.3087840868575457e-07, -7.363656785451205e-07, 1.0435713423116066e-06, 1.1336608661276258e-05, 1.3945668988208893e-05, -6.103596621410936e-05, -0.00017478724522533817, 0.00011424152003872239, 0.0009410217493595676, 0.00040789698084971285, -0.003128023381206269, -0.00364427962149839, 0.006990014563413916, 0.013993768859828731, -0.01029765964095597, -0.03688839769173014, 0.007588974368857738, 0.07592423604427631, 0.006239722752474872, -0.1323883055638104, -0.027340263752716042, 0.2111906939471043, 0.027918208133028276, -0.3270633105279177, 0.08975108940248964, 0.4402902568863569, -0.637356332083789, 0.4303127228460038, -0.16506428348885313, 0.034907714323673344, -0.003189220925347738]]], "db17": [[[0.0022418070010373128, 0.025985393703606044, 0.1312149033078244, 0.37035072415264114, 0.6109966156846228, 0.5183157640569378, 0.027314970403293636, -0.32832074836396175, -0.1265997522158827, 0.197310589565011, 0.10113548917747027, -0.1268156917782863, -0.05709141963167693, 0.08110598665416088, 0.022312336178103798, -0.04692243838926974, -0.0032709555358192938, 0.02273367658394627, -0.003042989981354637, -0.008602921520322855, 0.0029679966915260947, 0.0023012052421535457, -0.0014368453048029762, -0.00032813251940983797, 0.0004394654277686437, -2.5610109566548458e-05, -8.204803202453391e-05, 2.3186813798745952e-05, 6.9906009850767515e-06, -4.505942477222988e-06, 3.0165496099945573e-07, 2.957700933316857e-07, -8.42394844600268e-08, 7.2674929685616085e-09], [7.2674929685616085e-09, 8.42394844600268e-08, 2.957700933316857e-07, -3.0165496099945573e-07, -4.505942477222988e-06, -6.9906009850767515e-06, 2.3186813798745952e-05, 8.204803202453391e-05, -2.5610109566548458e-05, -0.0004394654277686437, -0.00032813251940983797, 0.0014368453048029762, 0.0023012052421535457, -0.0029679966915260947, -0.008602921520322855, 0.003042989981354637, 0.02273367658394627, 0.0032709555358192938, -0.04692243838926974, -0.022312336178103798, 0.08110598665416088, 0.05709141963167693, -0.1268156917782863, -0.10113548917747027, 0.197310589565011, 0.1265997522158827, -0.32832074836396175, -0.027314970403293636, 0.5183157640569378, -0.6109966156846228, 0.37035072415264114, -0.1312149033078244, 0.025985393703606044, -0.0022418070010373128]], [[0.0022418070010373128, 0.025985393703606044, 0.1312149033078244, 0.37035072415264114, 0.6109966156846228, 0.5183157640569378, 0.027314970403293636, -0.32832074836396175, -0.1265997522158827, 0.197310589565011, 0.10113548917747027, -0.1268156917782863, -0.05709141963167693, 0.08110598665416088, 0.022312336178103798, -0.04692243838926974, -0.0032709555358192938, 0.02273367658394627, -0.003042989981354637, -0.008602921520322855, 0.0029679966915260947, 0.0023012052421535457, -0.0014368453048029762, -0.00032813251940983797, 0.0004394654277686437, -2.5610109566548458e-05, -8.204803202453391e-05, 2.3186813798745952e-05, 6.9906009850767515e-06, -4.505942477222988e-06, 3.0165496099945573e-07, 2.957700933316857e-07, -8.42394844600268e-08, 7.2674929685616085e-09], [7.2674929685616085e-09, 8.42394844600268e-08, 2.957700933316857e-07, -3.0165496099945573e-07, -4.505942477222988e-06, -6.9906009850767515e-06, 2.3186813798745952e-05, 8.204803202453391e-05, -2.5610109566548458e-05, -0.0004394654277686437, -0.00032813251940983797, 0.0014368453048029762, 0.0023012052421535457, -0.0029679966915260947, -0.008602921520322855, 0.003042989981354637, 0.02273367658394627, 0.0032709555358192938, -0.04692243838926974, -0.022312336178103798, 0.08110598665416088, 0.05709141963167693, -0.1268156917782863, -0.10113548917747027, 0.197310589565011, 0.1265997522158827, -0.32832074836396175, -0.027314970403293636, 0.5183157640569378, -0.6109966156846228, 0.37035072415264114, -0.1312149033078244, 0.025985393703606044, -0.0022418070010373128]]], "db18": [[[0.0015763102184407605, 0.019288531724146376, 0.10358846582242359, 0.3146789413370317, 0.5718268077666072, 0.5718016548886513, 0.14722311196992816, -0.29365404073655876, -0.21648093400514298, 0.14953397556537779, 0.1670813127632574, -0.09233188415084628, -0.10675224665982849, 0.06488721621190545, 0.057051247738536884, -0.044526141902982326, -0.023733210395860002, 0.02667070592647059, 0.006262167954305707, -0.013051480946612001, 0.00011863003385811746, 0.004943343605466738, -0.0011187326669924971, -0.0013405962983361066, 0.0006284656829651457, 0.0002135815619103407, -0.00019864855231174796, -1.5359171235347246e-07, 3.7412378807400385e-05, -8.520602537446696e-06, -3.332634478885822e-06, 1.7687129836276155e-06, -7.691632689885177e-08, -1.1760987670282317e-07, 3.068835863045175e-08, -2.5079344549485983e-09], [-2.5079344549485983e-09, -3.068835863045175e-08, -1.1760987670282317e-07, 7.691632689885177e-08, 1.7687129836276155e-06, 3.332634478885822e-06, -8.520602537446696e-06, -3.7412378807400385e-05, -1.5359171235347246e-07, 0.00019864855231174796, 0.0002135815619103407, -0.0006284656829651457, -0.0013405962983361066, 0.0011187326669924971, 0.004943343605466738, -0.00011863003385811746, -0.013051480946612001, -0.006262167954305707, 0.02667070592647059, 0.023733210395860002, -0.044526141902982326, -0.057051247738536884, 0.06488721621190545, 0.10675224665982849, -0.09233188415084628, -0.1670813127632574, 0.14953397556537779, 0.21648093400514298, -0.29365404073655876, -0.14722311196992816, 0.5718016548886513, -0.5718268077666072, 0.3146789413370317, -0.10358846582242359, 0.019288531724146376, -0.0015763102184407605]], [[0.0015763102184407605, 0.019288531724146376, 0.10358846582242359, 0.3146789413370317, 0.5718268077666072, 0.5718016548886513, 0.14722311196992816, -0.29365404073655876, -0.21648093400514298, 0.14953397556537779, 0.1670813127632574, -0.09233188415084628, -0.10675224665982849, 0.06488721621190545, 0.057051247738536884, -0.044526141902982326, -0.023733210395860002, 0.02667070592647059, 0.006262167954305707, -0.013051480946612001, 0.00011863003385811746, 0.004943343605466738, -0.0011187326669924971, -0.0013405962983361066, 0.0006284656829651457, 0.0002135815619103407, -0.00019864855231174796, -1.5359171235347246e-07, 3.7412378807400385e-05, -8.520602537446696e-06, -3.332634478885822e-06, 1.7687129836276155e-06, -7.691632689885177e-08, -1.1760987670282317e-07, 3.068835863045175e-08, -2.5079344549485983e-09], [-2.5079344549485983e-09, -3.068835863045175e-08, -1.1760987670282317e-07, 7.691632689885177e-08, 1.7687129836276155e-06, 3.332634478885822e-06, -8.520602537446696e-06, -3.7412378807400385e-05, -1.5359171235347246e-07, 0.00019864855231174796, 0.0002135815619103407, -0.0006284656829651457, -0.0013405962983361066, 0.0011187326669924971, 0.004943343605466738, -0.00011863003385811746, -0.013051480946612001, -0.006262167954305707, 0.02667070592647059, 0.023733210395860002, -0.044526141902982326, -0.057051247738536884, 0.06488721621190545, 0.10675224665982849, -0.09233188415084628, -0.1670813127632574, 0.14953397556537779, 0.21648093400514298, -0.29365404073655876, -0.14722311196992816, 0.5718016548886513, -0.5718268077666072, 0.3146789413370317, -0.10358846582242359, 0.019288531724146376, -0.0015763102184407605]]], "db19": [[[0.0011086697631817106, 0.014281098450764397, 0.08127811326545956, 0.26438843174089677, 0.5244363774646549, 0.6017045491275379, 0.26089495265103885, -0.22809139421548263, -0.28583863175582624, 0.07465226970810326, 0.21234974330627848, -0.03351854190230288, -0.1427856950387366, 0.027584350625628667, 0.08690675555581223, -0.02650123625012304, -0.04567422627723091, 0.02162376740958505, 0.019375549889176127, -0.013988388678535142, -0.005866922281012175, 0.007040747367105243, 0.0007689543592575484, -0.002687551800701582, 0.00034180865345859575, 0.0007358025205054352, -0.000260676135678628, -0.00012460079173415878, 8.711270467219923e-05, 5.105950487073886e-06, -1.6640176297154945e-05, 3.0109643162965265e-06, 1.531931476691193e-06, -6.862755657769143e-07, 1.4470882987978445e-08, 4.6369377757826045e-08, -1.1164020670358259e-08, 8.666848838997619e-10], [8.666848838997619e-10, 1.1164020670358259e-08, 4.6369377757826045e-08, -1.4470882987978445e-08, -6.862755657769143e-07, -1.531931476691193e-06, 3.0109643162965265e-06, 1.6640176297154945e-05, 5.105950487073886e-06, -8.711270467219923e-05, -0.00012460079173415878, 0.000260676135678628, 0.0007358025205054352, -0.00034180865345859575, -0.002687551800701582, -0.0007689543592575484, 0.007040747367105243, 0.005866922281012175, -0.013988388678535142, -0.019375549889176127, 0.02162376740958505, 0.04567422627723091, -0.02650123625012304, -0.08690675555581223, 0.027584350625628667, 0.1427856950387366, -0.03351854190230288, -0.21234974330627848, 0.07465226970810326, 0.28583863175582624, -0.22809139421548263, -0.26089495265103885, 0.6017045491275379, -0.5244363774646549, 0.26438843174089677, -0.08127811326545956, 0.014281098450764397, -0.0011086697631817106]], [[0.0011086697631817106, 0.014281098450764397, 0.08127811326545956, 0.26438843174089677, 0.5244363774646549, 0.6017045491275379, 0.26089495265103885, -0.22809139421548263, -0.28583863175582624, 0.07465226970810326, 0.21234974330627848, -0.03351854190230288, -0.1427856950387366, 0.027584350625628667, 0.08690675555581223, -0.02650123625012304, -0.04567422627723091, 0.02162376740958505, 0.019375549889176127, -0.013988388678535142, -0.005866922281012175, 0.007040747367105243, 0.0007689543592575484, -0.002687551800701582, 0.00034180865345859575, 0.0007358025205054352, -0.000260676135678628, -0.00012460079173415878, 8.711270467219923e-05, 5.105950487073886e-06, -1.6640176297154945e-05, 3.0109643162965265e-06, 1.531931476691193e-06, -6.862755657769143e-07, 1.4470882987978445e-08, 4.6369377757826045e-08, -1.1164020670358259e-08, 8.666848838997619e-10], [8.666848838997619e-10, 1.1164020670358259e-08, 4.6369377757826045e-08, -1.4470882987978445e-08, -6.862755657769143e-07, -1.531931476691193e-06, 3.0109643162965265e-06, 1.6640176297154945e-05, 5.105950487073886e-06, -8.711270467219923e-05, -0.00012460079173415878, 0.000260676135678628, 0.0007358025205054352, -0.00034180865345859575, -0.002687551800701582, -0.0007689543592575484, 0.007040747367105243, 0.005866922281012175, -0.013988388678535142, -0.019375549889176127, 0.02162376740958505, 0.04567422627723091, -0.02650123625012304, -0.08690675555581223, 0.027584350625628667, 0.1427856950387366, -0.03351854190230288, -0.21234974330627848, 0.07465226970810326, 0.28583863175582624, -0.22809139421548263, -0.26089495265103885, 0.6017045491275379, -0.5244363774646549, 0.26438843174089677, -0.08127811326545956, 0.014281098450764397, -0.0011086697631817106]]], "db20": [[[0.0007799536136668463, 0.010549394624950399, 0.06342378045908152, 0.21994211355139703, 0.4726961853109017, 0.6104932389385939, 0.36150229873933104, -0.13921208801148388, -0.32678680043403496, -0.016727088309077008, 0.22829105081991632, 0.0398502464577712, -0.15545875070726795, -0.024716827338613585, 0.10229171917444256, 0.005632246857307436, -0.06172289962468046, 0.005874681811811827, 0.03229429953076958, -0.00878932492390156, -0.01381052613715192, 0.006721627302259457, 0.004420542387045791, -0.0035814942596096226, -0.0008315621728225569, 0.0013925596193231364, -5.349759843997695e-05, -0.00038510474869921763, 0.00010153288973670291, 6.77428082837773e-05, -3.710586183394713e-05, -4.376143862183997e-06, 7.2412482876736205e-06, -1.0119940100188862e-06, -6.847079597000557e-07, 2.6339242262700013e-07, 2.0143220235505126e-10, -1.814843248299696e-08, 4.056127055551833e-09, -2.9988364896193194e-10], [-2.9988364896193194e-10, -4.056127055551833e-09, -1.814843248299696e-08, -2.0143220235505126e-10, 2.6339242262700013e-07, 6.847079597000557e-07, -1.0119940100188862e-06, -7.2412482876736205e-06, -4.376143862183997e-06, 3.710586183394713e-05, 6.77428082837773e-05, -0.00010153288973670291, -0.00038510474869921763, 5.349759843997695e-05, 0.0013925596193231364, 0.0008315621728225569, -0.0035814942596096226, -0.004420542387045791, 0.006721627302259457, 0.01381052613715192, -0.00878932492390156, -0.03229429953076958, 0.005874681811811827, 0.06172289962468046, 0.005632246857307436, -0.10229171917444256, -0.024716827338613585, 0.15545875070726795, 0.0398502464577712, -0.22829105081991632, -0.016727088309077008, 0.32678680043403496, -0.13921208801148388, -0.36150229873933104, 0.6104932389385939, -0.4726961853109017, 0.21994211355139703, -0.06342378045908152, 0.010549394624950399, -0.0007799536136668463]], [[0.0007799536136668463, 0.010549394624950399, 0.06342378045908152, 0.21994211355139703, 0.4726961853109017, 0.6104932389385939, 0.36150229873933104, -0.13921208801148388, -0.32678680043403496, -0.016727088309077008, 0.22829105081991632, 0.0398502464577712, -0.15545875070726795, -0.024716827338613585, 0.10229171917444256, 0.005632246857307436, -0.06172289962468046, 0.005874681811811827, 0.03229429953076958, -0.00878932492390156, -0.01381052613715192, 0.006721627302259457, 0.004420542387045791, -0.0035814942596096226, -0.0008315621728225569, 0.0013925596193231364, -5.349759843997695e-05, -0.00038510474869921763, 0.00010153288973670291, 6.77428082837773e-05, -3.710586183394713e-05, -4.376143862183997e-06, 7.2412482876736205e-06, -1.0119940100188862e-06, -6.847079597000557e-07, 2.6339242262700013e-07, 2.0143220235505126e-10, -1.814843248299696e-08, 4.056127055551833e-09, -2.9988364896193194e-10], [-2.9988364896193194e-10, -4.056127055551833e-09, -1.814843248299696e-08, -2.0143220235505126e-10, 2.6339242262700013e-07, 6.847079597000557e-07, -1.0119940100188862e-06, -7.2412482876736205e-06, -4.376143862183997e-06, 3.710586183394713e-05, 6.77428082837773e-05, -0.00010153288973670291, -0.00038510474869921763, 5.349759843997695e-05, 0.0013925596193231364, 0.0008315621728225569, -0.0035814942596096226, -0.004420542387045791, 0.006721627302259457, 0.01381052613715192, -0.00878932492390156, -0.03229429953076958, 0.005874681811811827, 0.06172289962468046, 0.005632246857307436, -0.10229171917444256, -0.024716827338613585, 0.15545875070726795, 0.0398502464577712, -0.22829105081991632, -0.016727088309077008, 0.32678680043403496, -0.13921208801148388, -0.36150229873933104, 0.6104932389385939, -0.4726961853109017, 0.21994211355139703, -0.06342378045908152, 0.010549394624950399, -0.0007799536136668463]]], "db21": [[[0.0005488225098526838, 0.007776639052354784, 0.049247771538177276, 0.1813596254403815, 0.4196879449393628, 0.6015060949350038, 0.4445904519276003, -0.03572291961725529, -0.3356640895305295, -0.11239707156845098, 0.2115645276808724, 0.1152332984396871, -0.1399404249325472, -0.08177594298086382, 0.09660039032372422, 0.04572340574922879, -0.06497750489373232, -0.018653859202118515, 0.039726835427850445, 0.0033577563903381107, -0.02089205367797908, 0.002403470920805435, 0.008988824381971912, -0.0028913343485889014, -0.002958374038932831, 0.001716607040630624, 0.0006394185005120303, -0.0006906711170821016, -3.196406277680437e-05, 0.00019366465041650805, -3.635520250086338e-05, -3.4996659849874476e-05, 1.535482509276049e-05, 2.790330539814487e-06, -3.0900171645456993e-06, 3.1660954423670305e-07, 2.9921366304648526e-07, -1.0004008790305973e-07, -2.2540149746733303e-09, 7.058033541231122e-09, -1.4719541976503653e-09, 1.0388055710237066e-10], [1.0388055710237066e-10, 1.4719541976503653e-09, 7.058033541231122e-09, 2.2540149746733303e-09, -1.0004008790305973e-07, -2.9921366304648526e-07, 3.1660954423670305e-07, 3.0900171645456993e-06, 2.790330539814487e-06, -1.535482509276049e-05, -3.4996659849874476e-05, 3.635520250086338e-05, 0.00019366465041650805, 3.196406277680437e-05, -0.0006906711170821016, -0.0006394185005120303, 0.001716607040630624, 0.002958374038932831, -0.0028913343485889014, -0.008988824381971912, 0.002403470920805435, 0.02089205367797908, 0.0033577563903381107, -0.039726835427850445, -0.018653859202118515, 0.06497750489373232, 0.04572340574922879, -0.09660039032372422, -0.08177594298086382, 0.1399404249325472, 0.1152332984396871, -0.2115645276808724, -0.11239707156845098, 0.3356640895305295, -0.03572291961725529, -0.4445904519276003, 0.6015060949350038, -0.4196879449393628, 0.1813596254403815, -0.049247771538177276, 0.007776639052354784, -0.0005488225098526838]], [[0.0005488225098526838, 0.007776639052354784, 0.049247771538177276, 0.1813596254403815, 0.4196879449393628, 0.6015060949350038, 0.4445904519276003, -0.03572291961725529, -0.3356640895305295, -0.11239707156845098, 0.2115645276808724, 0.1152332984396871, -0.1399404249325472, -0.08177594298086382, 0.09660039032372422, 0.04572340574922879, -0.06497750489373232, -0.018653859202118515, 0.039726835427850445, 0.0033577563903381107, -0.02089205367797908, 0.002403470920805435, 0.008988824381971912, -0.0028913343485889014, -0.002958374038932831, 0.001716607040630624, 0.0006394185005120303, -0.0006906711170821016, -3.196406277680437e-05, 0.00019366465041650805, -3.635520250086338e-05, -3.4996659849874476e-05, 1.535482509276049e-05, 2.790330539814487e-06, -3.0900171645456993e-06, 3.1660954423670305e-07, 2.9921366304648526e-07, -1.0004008790305973e-07, -2.2540149746733303e-09, 7.058033541231122e-09, -1.4719541976503653e-09, 1.0388055710237066e-10], [1.0388055710237066e-10, 1.4719541976503653e-09, 7.058033541231122e-09, 2.2540149746733303e-09, -1.0004008790305973e-07, -2.9921366304648526e-07, 3.1660954423670305e-07, 3.0900171645456993e-06, 2.790330539814487e-06, -1.535482509276049e-05, -3.4996659849874476e-05, 3.635520250086338e-05, 0.00019366465041650805, 3.196406277680437e-05, -0.0006906711170821016, -0.0006394185005120303, 0.001716607040630624, 0.002958374038932831, -0.0028913343485889014, -0.008988824381971912, 0.002403470920805435, 0.02089205367797908, 0.0033577563903381107, -0.039726835427850445, -0.018653859202118515, 0.06497750489373232, 0.04572340574922879, -0.09660039032372422, -0.08177594298086382, 0.1399404249325472, 0.1152332984396871, -0.2115645276808724, -0.11239707156845098, 0.3356640895305295, -0.03572291961725529, -0.4445904519276003, 0.6015060949350038, -0.4196879449393628, 0.1813596254403815, -0.049247771538177276, 0.007776639052354784, -0.0005488225098526838]]], "db22": [[[0.00038626323149109823, 0.0057218546313345395, 0.03806993723641108, 0.14836754089011142, 0.3677286834460375, 0.5784327310095244, 0.5079010906221639, 0.07372450118363015, -0.3127265804282962, -0.2005684061048871, 0.16409318810676649, 0.1799731879928913, -0.09711079840911471, -0.1317681376866834, 0.06807631439273222, 0.08455737636682607, -0.05136425429744413, -0.046530811827506714, 0.03697084662069802, 0.02058670762756536, -0.023480001344493188, -0.006213782849364659, 0.012564725218343373, 0.0003001373985076436, -0.005455691986156717, 0.0010442607391860253, 0.0018270104956572791, -0.0007706909881231197, -0.00042378739983918006, 0.0003286094142136787, 4.345899904532003e-05, -9.40522363481576e-05, 1.1374349662125932e-05, 1.7373756957561893e-05, -6.166729316467578e-06, -1.5651791319951602e-06, 1.2951820573188775e-06, -8.779879873361287e-08, -1.2833362287517545e-07, 3.7612287493373625e-08, 1.6801714049229888e-09, -2.729623146632976e-09, 5.33593882166749e-10, -3.602113484339555e-11], [-3.602113484339555e-11, -5.33593882166749e-10, -2.729623146632976e-09, -1.6801714049229888e-09, 3.7612287493373625e-08, 1.2833362287517545e-07, -8.779879873361287e-08, -1.2951820573188775e-06, -1.5651791319951602e-06, 6.166729316467578e-06, 1.7373756957561893e-05, -1.1374349662125932e-05, -9.40522363481576e-05, -4.345899904532003e-05, 0.0003286094142136787, 0.00042378739983918006, -0.0007706909881231197, -0.0018270104956572791, 0.0010442607391860253, 0.005455691986156717, 0.0003001373985076436, -0.012564725218343373, -0.006213782849364659, 0.023480001344493188, 0.02058670762756536, -0.03697084662069802, -0.046530811827506714, 0.05136425429744413, 0.08455737636682607, -0.06807631439273222, -0.1317681376866834, 0.09711079840911471, 0.1799731879928913, -0.16409318810676649, -0.2005684061048871, 0.3127265804282962, 0.07372450118363015, -0.5079010906221639, 0.5784327310095244, -0.3677286834460375, 0.14836754089011142, -0.03806993723641108, 0.0057218546313345395, -0.00038626323149109823]], [[0.00038626323149109823, 0.0057218546313345395, 0.03806993723641108, 0.14836754089011142, 0.3677286834460375, 0.5784327310095244, 0.5079010906221639, 0.07372450118363015, -0.3127265804282962, -0.2005684061048871, 0.16409318810676649, 0.1799731879928913, -0.09711079840911471, -0.1317681376866834, 0.06807631439273222, 0.08455737636682607, -0.05136425429744413, -0.046530811827506714, 0.03697084662069802, 0.02058670762756536, -0.023480001344493188, -0.006213782849364659, 0.012564725218343373, 0.0003001373985076436, -0.005455691986156717, 0.0010442607391860253, 0.0018270104956572791, -0.0007706909881231197, -0.00042378739983918006, 0.0003286094142136787, 4.345899904532003e-05, -9.40522363481576e-05, 1.1374349662125932e-05, 1.7373756957561893e-05, -6.166729316467578e-06, -1.5651791319951602e-06, 1.2951820573188775e-06, -8.779879873361287e-08, -1.2833362287517545e-07, 3.7612287493373625e-08, 1.6801714049229888e-09, -2.729623146632976e-09, 5.33593882166749e-10, -3.602113484339555e-11], [-3.602113484339555e-11, -5.33593882166749e-10, -2.729623146632976e-09, -1.6801714049229888e-09, 3.7612287493373625e-08, 1.2833362287517545e-07, -8.779879873361287e-08, -1.2951820573188775e-06, -1.5651791319951602e-06, 6.166729316467578e-06, 1.7373756957561893e-05, -1.1374349662125932e-05, -9.40522363481576e-05, -4.345899904532003e-05, 0.0003286094142136787, 0.00042378739983918006, -0.0007706909881231197, -0.0018270104956572791, 0.0010442607391860253, 0.005455691986156717, 0.0003001373985076436, -0.012564725218343373, -0.006213782849364659, 0.023480001344493188, 0.02058670762756536, -0.03697084662069802, -0.046530811827506714, 0.05136425429744413, 0.08455737636682607, -0.06807631439273222, -0.1317681376866834, 0.09711079840911471, 0.1799731879928913, -0.16409318810676649, -0.2005684061048871, 0.3127265804282962, 0.07372450118363015, -0.5079010906221639, 0.5784327310095244, -0.3677286834460375, 0.14836754089011142, -0.03806993723641108, 0.0057218546313345395, -0.00038626323149109823]]], "db23": [[[0.00027190419412828886, 0.004202748893183833, 0.029310003657884116, 0.12051553178397194, 0.3184508138528652, 0.5449311478735205, 0.5510185172419194, 0.18139262536384002, -0.2613921480306441, -0.27140209860784303, 0.09212540708241805, 0.22357365824204023, -0.03303744709428938, -0.16401132153187592, 0.0202830745756493, 0.11229704361810729, -0.02112621235622724, -0.0702073915749011, 0.021765856834499976, 0.038495332522569196, -0.01852351365015616, -0.017537101003035845, 0.012751943931528287, 0.006031840650024163, -0.007075319273706152, -0.0011348654733562516, 0.003122876449818145, -0.0002465014005163512, -0.0010612312288866513, 0.00031942049270990115, 0.00025676245200787374, -0.0001500218503490341, -3.378894834120904e-05, 4.426071203109246e-05, -2.6352078892491864e-06, -8.347875567854625e-06, 2.39756954684024e-06, 8.147574834779447e-07, -5.339005405209421e-07, 1.853091785633965e-08, 5.4175491795392784e-08, -1.3999354954379989e-08, -9.472885901812052e-10, 1.0504464536965433e-09, -1.9324051113134174e-10, 1.250203302351041e-11], [1.250203302351041e-11, 1.9324051113134174e-10, 1.0504464536965433e-09, 9.472885901812052e-10, -1.3999354954379989e-08, -5.4175491795392784e-08, 1.853091785633965e-08, 5.339005405209421e-07, 8.147574834779447e-07, -2.39756954684024e-06, -8.347875567854625e-06, 2.6352078892491864e-06, 4.426071203109246e-05, 3.378894834120904e-05, -0.0001500218503490341, -0.00025676245200787374, 0.00031942049270990115, 0.0010612312288866513, -0.0002465014005163512, -0.003122876449818145, -0.0011348654733562516, 0.007075319273706152, 0.006031840650024163, -0.012751943931528287, -0.017537101003035845, 0.01852351365015616, 0.038495332522569196, -0.021765856834499976, -0.0702073915749011, 0.02112621235622724, 0.11229704361810729, -0.0202830745756493, -0.16401132153187592, 0.03303744709428938, 0.22357365824204023, -0.09212540708241805, -0.27140209860784303, 0.2613921480306441, 0.18139262536384002, -0.5510185172419194, 0.5449311478735205, -0.3184508138528652, 0.12051553178397194, -0.029310003657884116, 0.004202748893183833, -0.00027190419412828886]], [[0.00027190419412828886, 0.004202748893183833, 0.029310003657884116, 0.12051553178397194, 0.3184508138528652, 0.5449311478735205, 0.5510185172419194, 0.18139262536384002, -0.2613921480306441, -0.27140209860784303, 0.09212540708241805, 0.22357365824204023, -0.03303744709428938, -0.16401132153187592, 0.0202830745756493, 0.11229704361810729, -0.02112621235622724, -0.0702073915749011, 0.021765856834499976, 0.038495332522569196, -0.01852351365015616, -0.017537101003035845, 0.012751943931528287, 0.006031840650024163, -0.007075319273706152, -0.0011348654733562516, 0.003122876449818145, -0.0002465014005163512, -0.0010612312288866513, 0.00031942049270990115, 0.00025676245200787374, -0.0001500218503490341, -3.378894834120904e-05, 4.426071203109246e-05, -2.6352078892491864e-06, -8.347875567854625e-06, 2.39756954684024e-06, 8.147574834779447e-07, -5.339005405209421e-07, 1.853091785633965e-08, 5.4175491795392784e-08, -1.3999354954379989e-08, -9.472885901812052e-10, 1.0504464536965433e-09, -1.9324051113134174e-10, 1.250203302351041e-11], [1.250203302351041e-11, 1.9324051113134174e-10, 1.0504464536965433e-09, 9.472885901812052e-10, -1.3999354954379989e-08, -5.4175491795392784e-08, 1.853091785633965e-08, 5.339005405209421e-07, 8.147574834779447e-07, -2.39756954684024e-06, -8.347875567854625e-06, 2.6352078892491864e-06, 4.426071203109246e-05, 3.378894834120904e-05, -0.0001500218503490341, -0.00025676245200787374, 0.00031942049270990115, 0.0010612312288866513, -0.0002465014005163512, -0.003122876449818145, -0.0011348654733562516, 0.007075319273706152, 0.006031840650024163, -0.012751943931528287, -0.017537101003035845, 0.01852351365015616, 0.038495332522569196, -0.021765856834499976, -0.0702073915749011, 0.02112621235622724, 0.11229704361810729, -0.0202830745756493, -0.16401132153187592, 0.03303744709428938, 0.22357365824204023, -0.09212540708241805, -0.27140209860784303, 0.2613921480306441, 0.18139262536384002, -0.5510185172419194, 0.5449311478735205, -0.3184508138528652, 0.12051553178397194, -0.029310003657884116, 0.004202748893183833, -0.00027190419412828886]]], "db24": [[[0.00019143580094755136, 0.0030820817149054946, 0.02248233994971641, 0.0972622358336252, 0.2729089160677263, 0.504371040839925, 0.574939221095542, 0.2809855532337119, -0.18727140688515623, -0.31794307899936275, 0.004776613684344728, 0.23923738878031087, 0.04252872964148383, -0.1711753513703469, -0.038777173577920016, 0.12101630346922423, 0.020980113709144814, -0.08216165420800167, -0.004578436241819222, 0.05130162003998088, -0.004944709428125628, -0.02821310709490189, 0.007661721881646586, 0.013049970871085736, -0.006291435370018188, -0.004746568786323114, 0.0037360461782825235, 0.0011537649368394815, -0.0016964568189748244, -4.41618485614152e-05, 0.000586127059318311, -0.00011812332379695547, -0.0001460079817762617, 6.559388639305635e-05, 2.1832414604665582e-05, -2.0228882926126976e-05, 1.3411577508091147e-08, 3.901100338597703e-06, -8.980253143938407e-07, -4.032507756879972e-07, 2.1663396532785745e-07, -5.0576454197925e-10, -2.2557403881760862e-08, 5.157776789672e-09, 4.748375824256231e-10, -4.0246586445843797e-10, 6.99180115763823e-11, -4.34278250380371e-12], [-4.34278250380371e-12, -6.99180115763823e-11, -4.0246586445843797e-10, -4.748375824256231e-10, 5.157776789672e-09, 2.2557403881760862e-08, -5.0576454197925e-10, -2.1663396532785745e-07, -4.032507756879972e-07, 8.980253143938407e-07, 3.901100338597703e-06, -1.3411577508091147e-08, -2.0228882926126976e-05, -2.1832414604665582e-05, 6.559388639305635e-05, 0.0001460079817762617, -0.00011812332379695547, -0.000586127059318311, -4.41618485614152e-05, 0.0016964568189748244, 0.0011537649368394815, -0.0037360461782825235, -0.004746568786323114, 0.006291435370018188, 0.013049970871085736, -0.007661721881646586, -0.02821310709490189, 0.004944709428125628, 0.05130162003998088, 0.004578436241819222, -0.08216165420800167, -0.020980113709144814, 0.12101630346922423, 0.038777173577920016, -0.1711753513703469, -0.04252872964148383, 0.23923738878031087, -0.004776613684344728, -0.31794307899936275, 0.18727140688515623, 0.2809855532337119, -0.574939221095542, 0.504371040839925, -0.2729089160677263, 0.0972622358336252, -0.02248233994971641, 0.0030820817149054946, -0.00019143580094755136]], [[0.00019143580094755136, 0.0030820817149054946, 0.02248233994971641, 0.0972622358336252, 0.2729089160677263, 0.504371040839925, 0.574939221095542, 0.2809855532337119, -0.18727140688515623, -0.31794307899936275, 0.004776613684344728, 0.23923738878031087, 0.04252872964148383, -0.1711753513703469, -0.038777173577920016, 0.12101630346922423, 0.020980113709144814, -0.08216165420800167, -0.004578436241819222, 0.05130162003998088, -0.004944709428125628, -0.02821310709490189, 0.007661721881646586, 0.013049970871085736, -0.006291435370018188, -0.004746568786323114, 0.0037360461782825235, 0.0011537649368394815, -0.0016964568189748244, -4.41618485614152e-05, 0.000586127059318311, -0.00011812332379695547, -0.0001460079817762617, 6.559388639305635e-05, 2.1832414604665582e-05, -2.0228882926126976e-05, 1.3411577508091147e-08, 3.901100338597703e-06, -8.980253143938407e-07, -4.032507756879972e-07, 2.1663396532785745e-07, -5.0576454197925e-10, -2.2557403881760862e-08, 5.157776789672e-09, 4.748375824256231e-10, -4.0246586445843797e-10, 6.99180115763823e-11, -4.34278250380371e-12], [-4.34278250380371e-12, -6.99180115763823e-11, -4.0246586445843797e-10, -4.748375824256231e-10, 5.157776789672e-09, 2.2557403881760862e-08, -5.0576454197925e-10, -2.1663396532785745e-07, -4.032507756879972e-07, 8.980253143938407e-07, 3.901100338597703e-06, -1.3411577508091147e-08, -2.0228882926126976e-05, -2.1832414604665582e-05, 6.559388639305635e-05, 0.0001460079817762617, -0.00011812332379695547, -0.000586127059318311, -4.41618485614152e-05, 0.0016964568189748244, 0.0011537649368394815, -0.0037360461782825235, -0.004746568786323114, 0.006291435370018188, 0.013049970871085736, -0.007661721881646586, -0.02821310709490189, 0.004944709428125628, 0.05130162003998088, 0.004578436241819222, -0.08216165420800167, -0.020980113709144814, 0.12101630346922423, 0.038777173577920016, -0.1711753513703469, -0.04252872964148383, 0.23923738878031087, -0.004776613684344728, -0.31794307899936275, 0.18727140688515623, 0.2809855532337119, -0.574939221095542, 0.504371040839925, -0.2729089160677263, 0.0972622358336252, -0.02248233994971641, 0.0030820817149054946, -0.00019143580094755136]]], "db25": [[[0.0001348029793470189, 0.0022569595918547794, 0.017186741254040155, 0.07803586287213267, 0.23169350788602183, 0.4596834151460946, 0.5816368967460578, 0.3678850748029467, -0.09717464096463814, -0.3364730796417461, -0.08758761458765466, 0.2245378197451017, 0.11815528671995985, -0.15056021375057962, -0.09850861528996022, 0.10663380501847795, 0.0667521644940186, -0.0770841110565742, -0.03717396286112251, 0.0536179093987795, 0.015542605929102291, -0.03404232046065334, -0.0030798367948470366, 0.018922804476627628, -0.0019894257822027366, -0.008860702618046369, 0.0027269362587384956, 0.003322707773973192, -0.0018424842902033313, -0.000899977423746295, 0.0008772581936748275, 0.00011532124404663005, -0.0003098800990984698, 3.543714523276059e-05, 7.904640003965528e-05, -2.7330481199600417e-05, -1.2771952931997837e-05, 8.990661393062588e-06, 5.232827708153076e-07, -1.7792013326536346e-06, 3.212037518862519e-07, 1.9228067901423717e-07, -8.656941732278507e-08, -2.6115985561117707e-09, 9.279224480081372e-09, -1.8804157550621554e-09, -2.228474910228169e-10, 1.5359015701626572e-10, -2.5276251634656447e-11, 1.5096920828239108e-12], [1.5096920828239108e-12, 2.5276251634656447e-11, 1.5359015701626572e-10, 2.228474910228169e-10, -1.8804157550621554e-09, -9.279224480081372e-09, -2.6115985561117707e-09, 8.656941732278507e-08, 1.9228067901423717e-07, -3.212037518862519e-07, -1.7792013326536346e-06, -5.232827708153076e-07, 8.990661393062588e-06, 1.2771952931997837e-05, -2.7330481199600417e-05, -7.904640003965528e-05, 3.543714523276059e-05, 0.0003098800990984698, 0.00011532124404663005, -0.0008772581936748275, -0.000899977423746295, 0.0018424842902033313, 0.003322707773973192, -0.0027269362587384956, -0.008860702618046369, 0.0019894257822027366, 0.018922804476627628, 0.0030798367948470366, -0.03404232046065334, -0.015542605929102291, 0.0536179093987795, 0.03717396286112251, -0.0770841110565742, -0.0667521644940186, 0.10663380501847795, 0.09850861528996022, -0.15056021375057962, -0.11815528671995985, 0.2245378197451017, 0.08758761458765466, -0.3364730796417461, 0.09717464096463814, 0.3678850748029467, -0.5816368967460578, 0.4596834151460946, -0.23169350788602183, 0.07803586287213267, -0.017186741254040155, 0.0022569595918547794, -0.0001348029793470189]], [[0.0001348029793470189, 0.0022569595918547794, 0.017186741254040155, 0.07803586287213267, 0.23169350788602183, 0.4596834151460946, 0.5816368967460578, 0.3678850748029467, -0.09717464096463814, -0.3364730796417461, -0.08758761458765466, 0.2245378197451017, 0.11815528671995985, -0.15056021375057962, -0.09850861528996022, 0.10663380501847795, 0.0667521644940186, -0.0770841110565742, -0.03717396286112251, 0.0536179093987795, 0.015542605929102291, -0.03404232046065334, -0.0030798367948470366, 0.018922804476627628, -0.0019894257822027366, -0.008860702618046369, 0.0027269362587384956, 0.003322707773973192, -0.0018424842902033313, -0.000899977423746295, 0.0008772581936748275, 0.00011532124404663005, -0.0003098800990984698, 3.543714523276059e-05, 7.904640003965528e-05, -2.7330481199600417e-05, -1.2771952931997837e-05, 8.990661393062588e-06, 5.232827708153076e-07, -1.7792013326536346e-06, 3.212037518862519e-07, 1.9228067901423717e-07, -8.656941732278507e-08, -2.6115985561117707e-09, 9.279224480081372e-09, -1.8804157550621554e-09, -2.228474910228169e-10, 1.5359015701626572e-10, -2.5276251634656447e-11, 1.5096920828239108e-12], [1.5096920828239108e-12, 2.5276251634656447e-11, 1.5359015701626572e-10, 2.228474910228169e-10, -1.8804157550621554e-09, -9.279224480081372e-09, -2.6115985561117707e-09, 8.656941732278507e-08, 1.9228067901423717e-07, -3.212037518862519e-07, -1.7792013326536346e-06, -5.232827708153076e-07, 8.990661393062588e-06, 1.2771952931997837e-05, -2.7330481199600417e-05, -7.904640003965528e-05, 3.543714523276059e-05, 0.0003098800990984698, 0.00011532124404663005, -0.0008772581936748275, -0.000899977423746295, 0.0018424842902033313, 0.003322707773973192, -0.0027269362587384956, -0.008860702618046369, 0.0019894257822027366, 0.018922804476627628, 0.0030798367948470366, -0.03404232046065334, -0.015542605929102291, 0.0536179093987795, 0.03717396286112251, -0.0770841110565742, -0.0667521644940186, 0.10663380501847795, 0.09850861528996022, -0.15056021375057962, -0.11815528671995985, 0.2245378197451017, 0.08758761458765466, -0.3364730796417461, 0.09717464096463814, 0.3678850748029467, -0.5816368967460578, 0.4596834151460946, -0.23169350788602183, 0.07803586287213267, -0.017186741254040155, 0.0022569595918547794, -0.0001348029793470189]]], "db26": [[[9.493795750710593e-05, 0.0016505202335329882, 0.0130975542925585, 0.062274744025149605, 0.1950394387167701, 0.4132929622783564, 0.5736690430342223, 0.43915831178916626, 0.0017740767809866858, -0.32638459369178, -0.1748399612893925, 0.1812918323111227, 0.18275540958967237, -0.10432390028592704, -0.1479771932752545, 0.06982318611329237, 0.10648240524980863, -0.053448561681483195, -0.06865475960403591, 0.042232185796372036, 0.03853571597111186, -0.03137811036306776, -0.017760903568358185, 0.020734920179963826, 0.005829580555318888, -0.01178549790619303, -0.0005287383992626815, 0.005601947239423805, -0.000939058250473829, -0.002145530281567621, 0.0008383488056543616, 0.0006161382204574344, -0.00043195570742618077, -0.0001060574748283804, 0.00015747952386074935, -5.277795493037869e-06, -4.1096739963914775e-05, 1.074221540872195e-05, 7.000078682964987e-06, -3.887400161856795e-06, -4.6504632206402627e-07, 7.939210633709952e-07, -1.0790042375786714e-07, -8.90446637016859e-08, 3.40779562129073e-08, 2.169328259850323e-09, -3.776010478532324e-09, 6.780047245828637e-10, 1.0023031910465269e-10, -5.840408185341171e-11, 9.130510016371797e-12, -5.251871224244435e-13], [-5.251871224244435e-13, -9.130510016371797e-12, -5.840408185341171e-11, -1.0023031910465269e-10, 6.780047245828637e-10, 3.776010478532324e-09, 2.169328259850323e-09, -3.40779562129073e-08, -8.90446637016859e-08, 1.0790042375786714e-07, 7.939210633709952e-07, 4.6504632206402627e-07, -3.887400161856795e-06, -7.000078682964987e-06, 1.074221540872195e-05, 4.1096739963914775e-05, -5.277795493037869e-06, -0.00015747952386074935, -0.0001060574748283804, 0.00043195570742618077, 0.0006161382204574344, -0.0008383488056543616, -0.002145530281567621, 0.000939058250473829, 0.005601947239423805, 0.0005287383992626815, -0.01178549790619303, -0.005829580555318888, 0.020734920179963826, 0.017760903568358185, -0.03137811036306776, -0.03853571597111186, 0.042232185796372036, 0.06865475960403591, -0.053448561681483195, -0.10648240524980863, 0.06982318611329237, 0.1479771932752545, -0.10432390028592704, -0.18275540958967237, 0.1812918323111227, 0.1748399612893925, -0.32638459369178, -0.0017740767809866858, 0.43915831178916626, -0.5736690430342223, 0.4132929622783564, -0.1950394387167701, 0.062274744025149605, -0.0130975542925585, 0.0016505202335329882, -9.493795750710593e-05]], [[9.493795750710593e-05, 0.0016505202335329882, 0.0130975542925585, 0.062274744025149605, 0.1950394387167701, 0.4132929622783564, 0.5736690430342223, 0.43915831178916626, 0.0017740767809866858, -0.32638459369178, -0.1748399612893925, 0.1812918323111227, 0.18275540958967237, -0.10432390028592704, -0.1479771932752545, 0.06982318611329237, 0.10648240524980863, -0.053448561681483195, -0.06865475960403591, 0.042232185796372036, 0.03853571597111186, -0.03137811036306776, -0.017760903568358185, 0.020734920179963826, 0.005829580555318888, -0.01178549790619303, -0.0005287383992626815, 0.005601947239423805, -0.000939058250473829, -0.002145530281567621, 0.0008383488056543616, 0.0006161382204574344, -0.00043195570742618077, -0.0001060574748283804, 0.00015747952386074935, -5.277795493037869e-06, -4.1096739963914775e-05, 1.074221540872195e-05, 7.000078682964987e-06, -3.887400161856795e-06, -4.6504632206402627e-07, 7.939210633709952e-07, -1.0790042375786714e-07, -8.90446637016859e-08, 3.40779562129073e-08, 2.169328259850323e-09, -3.776010478532324e-09, 6.780047245828637e-10, 1.0023031910465269e-10, -5.840408185341171e-11, 9.130510016371797e-12, -5.251871224244435e-13], [-5.251871224244435e-13, -9.130510016371797e-12, -5.840408185341171e-11, -1.0023031910465269e-10, 6.780047245828637e-10, 3.776010478532324e-09, 2.169328259850323e-09, -3.40779562129073e-08, -8.90446637016859e-08, 1.0790042375786714e-07, 7.939210633709952e-07, 4.6504632206402627e-07, -3.887400161856795e-06, -7.000078682964987e-06, 1.074221540872195e-05, 4.1096739963914775e-05, -5.277795493037869e-06, -0.00015747952386074935, -0.0001060574748283804, 0.00043195570742618077, 0.0006161382204574344, -0.0008383488056543616, -0.002145530281567621, 0.000939058250473829, 0.005601947239423805, 0.0005287383992626815, -0.01178549790619303, -0.005829580555318888, 0.020734920179963826, 0.017760903568358185, -0.03137811036306776, -0.03853571597111186, 0.042232185796372036, 0.06865475960403591, -0.053448561681483195, -0.10648240524980863, 0.06982318611329237, 0.1479771932752545, -0.10432390028592704, -0.18275540958967237, 0.1812918323111227, 0.1748399612893925, -0.32638459369178, -0.0017740767809866858, 0.43915831178916626, -0.5736690430342223, 0.4132929622783564, -0.1950394387167701, 0.062274744025149605, -0.0130975542925585, 0.0016505202335329882, -9.493795750710593e-05]]], "db27": [[[6.687131385431931e-05, 0.0012055312316732133, 0.00995258878087662, 0.04945259998290488, 0.16292202750239332, 0.3671102141253898, 0.5538498609904801, 0.493406122677999, 0.10284085506182292, -0.2897168033145949, -0.24826458190326056, 0.11482301951778535, 0.22727328841417083, -0.03878641863180231, -0.1780317409590086, 0.015799397460240484, 0.13119797171715533, -0.014062751555808765, -0.09102290652956592, 0.01731101826549371, 0.05796940573471799, -0.018512493561998078, -0.03273906663102087, 0.016146966922395666, 0.015665595648924578, -0.011577186458976282, -0.005862096345462926, 0.0068566356096848805, 0.0013426268773036795, -0.0033328544695200063, 0.00014575296259317286, 0.001301177450244135, -0.00034183512269154277, -0.00038790185741013276, 0.00020197198796903268, 7.660058387068577e-05, -7.711145517797584e-05, -3.5174836149074453e-06, 2.0634426477368854e-05, -3.901164070638425e-06, -3.657500908187105e-06, 1.6343696247256378e-06, 3.050880686251999e-07, -3.4724681473943893e-07, 3.2865589680551595e-08, 4.0262550528669086e-08, -1.3213322739900565e-08, -1.3094656068569551e-09, 1.5216149847785218e-09, -2.415526928011131e-10, -4.3749862242936544e-11, 2.2136620880676626e-11, -3.295790122476586e-12, 1.828188352882425e-13], [1.828188352882425e-13, 3.295790122476586e-12, 2.2136620880676626e-11, 4.3749862242936544e-11, -2.415526928011131e-10, -1.5216149847785218e-09, -1.3094656068569551e-09, 1.3213322739900565e-08, 4.0262550528669086e-08, -3.2865589680551595e-08, -3.4724681473943893e-07, -3.050880686251999e-07, 1.6343696247256378e-06, 3.657500908187105e-06, -3.901164070638425e-06, -2.0634426477368854e-05, -3.5174836149074453e-06, 7.711145517797584e-05, 7.660058387068577e-05, -0.00020197198796903268, -0.00038790185741013276, 0.00034183512269154277, 0.001301177450244135, -0.00014575296259317286, -0.0033328544695200063, -0.0013426268773036795, 0.0068566356096848805, 0.005862096345462926, -0.011577186458976282, -0.015665595648924578, 0.016146966922395666, 0.03273906663102087, -0.018512493561998078, -0.05796940573471799, 0.01731101826549371, 0.09102290652956592, -0.014062751555808765, -0.13119797171715533, 0.015799397460240484, 0.1780317409590086, -0.03878641863180231, -0.22727328841417083, 0.11482301951778535, 0.24826458190326056, -0.2897168033145949, -0.10284085506182292, 0.493406122677999, -0.5538498609904801, 0.3671102141253898, -0.16292202750239332, 0.04945259998290488, -0.00995258878087662, 0.0012055312316732133, -6.687131385431931e-05]], [[6.687131385431931e-05, 0.0012055312316732133, 0.00995258878087662, 0.04945259998290488, 0.16292202750239332, 0.3671102141253898, 0.5538498609904801, 0.493406122677999, 0.10284085506182292, -0.2897168033145949, -0.24826458190326056, 0.11482301951778535, 0.22727328841417083, -0.03878641863180231, -0.1780317409590086, 0.015799397460240484, 0.13119797171715533, -0.014062751555808765, -0.09102290652956592, 0.01731101826549371, 0.05796940573471799, -0.018512493561998078, -0.03273906663102087, 0.016146966922395666, 0.015665595648924578, -0.011577186458976282, -0.005862096345462926, 0.0068566356096848805, 0.0013426268773036795, -0.0033328544695200063, 0.00014575296259317286, 0.001301177450244135, -0.00034183512269154277, -0.00038790185741013276, 0.00020197198796903268, 7.660058387068577e-05, -7.711145517797584e-05, -3.5174836149074453e-06, 2.0634426477368854e-05, -3.901164070638425e-06, -3.657500908187105e-06, 1.6343696247256378e-06, 3.050880686251999e-07, -3.4724681473943893e-07, 3.2865589680551595e-08, 4.0262550528669086e-08, -1.3213322739900565e-08, -1.3094656068569551e-09, 1.5216149847785218e-09, -2.415526928011131e-10, -4.3749862242936544e-11, 2.2136620880676626e-11, -3.295790122476586e-12, 1.828188352882425e-13], [1.828188352882425e-13, 3.295790122476586e-12, 2.2136620880676626e-11, 4.3749862242936544e-11, -2.415526928011131e-10, -1.5216149847785218e-09, -1.3094656068569551e-09, 1.3213322739900565e-08, 4.0262550528669086e-08, -3.2865589680551595e-08, -3.4724681473943893e-07, -3.050880686251999e-07, 1.6343696247256378e-06, 3.657500908187105e-06, -3.901164070638425e-06, -2.0634426477368854e-05, -3.5174836149074453e-06, 7.711145517797584e-05, 7.660058387068577e-05, -0.00020197198796903268, -0.00038790185741013276, 0.00034183512269154277, 0.001301177450244135, -0.00014575296259317286, -0.0033328544695200063, -0.0013426268773036795, 0.0068566356096848805, 0.005862096345462926, -0.011577186458976282, -0.015665595648924578, 0.016146966922395666, 0.03273906663102087, -0.018512493561998078, -0.05796940573471799, 0.01731101826549371, 0.09102290652956592, -0.014062751555808765, -0.13119797171715533, 0.015799397460240484, 0.1780317409590086, -0.03878641863180231, -0.22727328841417083, 0.11482301951778535, 0.24826458190326056, -0.2897168033145949, -0.10284085506182292, 0.493406122677999, -0.5538498609904801, 0.3671102141253898, -0.16292202750239332, 0.04945259998290488, -0.00995258878087662, 0.0012055312316732133, -6.687131385431931e-05]]], "db28": [[[4.710807775014051e-05, 0.000879498515984387, 0.007542650377646859, 0.039092608115405346, 0.13513791425364105, 0.32256336128552243, 0.5249982316303355, 0.5305162934414858, 0.20017614404598444, -0.23049895404758253, -0.30132780953264177, 0.0328578791633871, 0.24580815137375955, 0.03690688531571127, -0.18287733073298493, -0.04683823374455168, 0.1346275679102261, 0.0344786312750997, -0.09768535580565244, -0.0173419228313059, 0.06774789550190934, 0.0034480189555409512, -0.04333336861608628, 0.004431732910062988, 0.024688060010151867, -0.006815549764552309, -0.01206359196821849, 0.005838816627748945, 0.0047848631124542415, -0.003725461247074255, -0.0013603738456396924, 0.0018759986682027956, 0.00014156723931404644, -0.000748674955911463, 0.00011546560636589213, 0.00022957909822334563, -8.903901490044488e-05, -4.9077134161902505e-05, 3.6414012110508025e-05, 4.638664981394295e-06, -1.0043260413334226e-05, 1.2479003175748342e-06, 1.8403637345177692e-06, -6.670215479954893e-07, -1.7574611732098427e-07, 1.4906600135353622e-07, -8.262387315626558e-09, -1.78413869087571e-08, 5.044047056383437e-09, 6.944540328946227e-10, -6.077041247229011e-10, 8.492220011056382e-11, 1.8673672637833906e-11, -8.3654904712588e-12, 1.1888505334059015e-12, -6.367772354714857e-14], [-6.367772354714857e-14, -1.1888505334059015e-12, -8.3654904712588e-12, -1.8673672637833906e-11, 8.492220011056382e-11, 6.077041247229011e-10, 6.944540328946227e-10, -5.044047056383437e-09, -1.78413869087571e-08, 8.262387315626558e-09, 1.4906600135353622e-07, 1.7574611732098427e-07, -6.670215479954893e-07, -1.8403637345177692e-06, 1.2479003175748342e-06, 1.0043260413334226e-05, 4.638664981394295e-06, -3.6414012110508025e-05, -4.9077134161902505e-05, 8.903901490044488e-05, 0.00022957909822334563, -0.00011546560636589213, -0.000748674955911463, -0.00014156723931404644, 0.0018759986682027956, 0.0013603738456396924, -0.003725461247074255, -0.0047848631124542415, 0.005838816627748945, 0.01206359196821849, -0.006815549764552309, -0.024688060010151867, 0.004431732910062988, 0.04333336861608628, 0.0034480189555409512, -0.06774789550190934, -0.0173419228313059, 0.09768535580565244, 0.0344786312750997, -0.1346275679102261, -0.04683823374455168, 0.18287733073298493, 0.03690688531571127, -0.24580815137375955, 0.0328578791633871, 0.30132780953264177, -0.23049895404758253, -0.20017614404598444, 0.5305162934414858, -0.5249982316303355, 0.32256336128552243, -0.13513791425364105, 0.039092608115405346, -0.007542650377646859, 0.000879498515984387, -4.710807775014051e-05]], [[4.710807775014051e-05, 0.000879498515984387, 0.007542650377646859, 0.039092608115405346, 0.13513791425364105, 0.32256336128552243, 0.5249982316303355, 0.5305162934414858, 0.20017614404598444, -0.23049895404758253, -0.30132780953264177, 0.0328578791633871, 0.24580815137375955, 0.03690688531571127, -0.18287733073298493, -0.04683823374455168, 0.1346275679102261, 0.0344786312750997, -0.09768535580565244, -0.0173419228313059, 0.06774789550190934, 0.0034480189555409512, -0.04333336861608628, 0.004431732910062988, 0.024688060010151867, -0.006815549764552309, -0.01206359196821849, 0.005838816627748945, 0.0047848631124542415, -0.003725461247074255, -0.0013603738456396924, 0.0018759986682027956, 0.00014156723931404644, -0.000748674955911463, 0.00011546560636589213, 0.00022957909822334563, -8.903901490044488e-05, -4.9077134161902505e-05, 3.6414012110508025e-05, 4.638664981394295e-06, -1.0043260413334226e-05, 1.2479003175748342e-06, 1.8403637345177692e-06, -6.670215479954893e-07, -1.7574611732098427e-07, 1.4906600135353622e-07, -8.262387315626558e-09, -1.78413869087571e-08, 5.044047056383437e-09, 6.944540328946227e-10, -6.077041247229011e-10, 8.492220011056382e-11, 1.8673672637833906e-11, -8.3654904712588e-12, 1.1888505334059015e-12, -6.367772354714857e-14], [-6.367772354714857e-14, -1.1888505334059015e-12, -8.3654904712588e-12, -1.8673672637833906e-11, 8.492220011056382e-11, 6.077041247229011e-10, 6.944540328946227e-10, -5.044047056383437e-09, -1.78413869087571e-08, 8.262387315626558e-09, 1.4906600135353622e-07, 1.7574611732098427e-07, -6.670215479954893e-07, -1.8403637345177692e-06, 1.2479003175748342e-06, 1.0043260413334226e-05, 4.638664981394295e-06, -3.6414012110508025e-05, -4.9077134161902505e-05, 8.903901490044488e-05, 0.00022957909822334563, -0.00011546560636589213, -0.000748674955911463, -0.00014156723931404644, 0.0018759986682027956, 0.0013603738456396924, -0.003725461247074255, -0.0047848631124542415, 0.005838816627748945, 0.01206359196821849, -0.006815549764552309, -0.024688060010151867, 0.004431732910062988, 0.04333336861608628, 0.0034480189555409512, -0.06774789550190934, -0.0173419228313059, 0.09768535580565244, 0.0344786312750997, -0.1346275679102261, -0.04683823374455168, 0.18287733073298493, 0.03690688531571127, -0.24580815137375955, 0.0328578791633871, 0.30132780953264177, -0.23049895404758253, -0.20017614404598444, 0.5305162934414858, -0.5249982316303355, 0.32256336128552243, -0.13513791425364105, 0.039092608115405346, -0.007542650377646859, 0.000879498515984387, -4.710807775014051e-05]]], "db29": [[[3.318966279841525e-05, 0.0006409516803044435, 0.0057021265177733755, 0.030773580221408376, 0.11137011695174052, 0.28065345597098296, 0.4897588047621993, 0.5513744327583752, 0.2891052383358292, -0.15402873445990006, -0.33004094891758806, -0.055706800072940856, 0.23610523615302595, 0.11241917487318838, -0.16087798859418773, -0.10784594993872142, 0.11447229589381826, 0.08322074716244976, -0.0851254926156355, -0.055027489525325726, 0.06347916458421186, 0.030531543272704135, -0.04518798127778834, -0.012917142554266795, 0.02947043187174764, 0.002648327307678168, -0.01704122457360669, 0.001737880332720511, 0.008469725493560752, -0.0025508071277894726, -0.0034737989896811007, 0.0018771209257236502, 0.001087053942226063, -0.0010007783270856805, -0.00020007113630767797, 0.0004111283454742767, -2.2920180412145e-05, -0.00012930448400807207, 3.645026068562775e-05, 2.913344750169041e-05, -1.6573283953066164e-05, -3.5936448040251875e-06, 4.7506092464525525e-06, -3.029054592052818e-07, -8.975701750636281e-07, 2.633898386997697e-07, 9.387197411095864e-08, -6.286156922010786e-08, 1.0765919066191961e-09, 7.768978854770062e-09, -1.893995386171984e-09, -3.426800863263089e-10, 2.4070994535093427e-10, -2.940589250764533e-11, -7.832509733627818e-12, 3.1527624133703105e-12, -4.2856548700683443e-13, 2.219191311588303e-14], [2.219191311588303e-14, 4.2856548700683443e-13, 3.1527624133703105e-12, 7.832509733627818e-12, -2.940589250764533e-11, -2.4070994535093427e-10, -3.426800863263089e-10, 1.893995386171984e-09, 7.768978854770062e-09, -1.0765919066191961e-09, -6.286156922010786e-08, -9.387197411095864e-08, 2.633898386997697e-07, 8.975701750636281e-07, -3.029054592052818e-07, -4.7506092464525525e-06, -3.5936448040251875e-06, 1.6573283953066164e-05, 2.913344750169041e-05, -3.645026068562775e-05, -0.00012930448400807207, 2.2920180412145e-05, 0.0004111283454742767, 0.00020007113630767797, -0.0010007783270856805, -0.001087053942226063, 0.0018771209257236502, 0.0034737989896811007, -0.0025508071277894726, -0.008469725493560752, 0.001737880332720511, 0.01704122457360669, 0.002648327307678168, -0.02947043187174764, -0.012917142554266795, 0.04518798127778834, 0.030531543272704135, -0.06347916458421186, -0.055027489525325726, 0.0851254926156355, 0.08322074716244976, -0.11447229589381826, -0.10784594993872142, 0.16087798859418773, 0.11241917487318838, -0.23610523615302595, -0.055706800072940856, 0.33004094891758806, -0.15402873445990006, -0.2891052383358292, 0.5513744327583752, -0.4897588047621993, 0.28065345597098296, -0.11137011695174052, 0.030773580221408376, -0.0057021265177733755, 0.0006409516803044435, -3.318966279841525e-05]], [[3.318966279841525e-05, 0.0006409516803044435, 0.0057021265177733755, 0.030773580221408376, 0.11137011695174052, 0.28065345597098296, 0.4897588047621993, 0.5513744327583752, 0.2891052383358292, -0.15402873445990006, -0.33004094891758806, -0.055706800072940856, 0.23610523615302595, 0.11241917487318838, -0.16087798859418773, -0.10784594993872142, 0.11447229589381826, 0.08322074716244976, -0.0851254926156355, -0.055027489525325726, 0.06347916458421186, 0.030531543272704135, -0.04518798127778834, -0.012917142554266795, 0.02947043187174764, 0.002648327307678168, -0.01704122457360669, 0.001737880332720511, 0.008469725493560752, -0.0025508071277894726, -0.0034737989896811007, 0.0018771209257236502, 0.001087053942226063, -0.0010007783270856805, -0.00020007113630767797, 0.0004111283454742767, -2.2920180412145e-05, -0.00012930448400807207, 3.645026068562775e-05, 2.913344750169041e-05, -1.6573283953066164e-05, -3.5936448040251875e-06, 4.7506092464525525e-06, -3.029054592052818e-07, -8.975701750636281e-07, 2.633898386997697e-07, 9.387197411095864e-08, -6.286156922010786e-08, 1.0765919066191961e-09, 7.768978854770062e-09, -1.893995386171984e-09, -3.426800863263089e-10, 2.4070994535093427e-10, -2.940589250764533e-11, -7.832509733627818e-12, 3.1527624133703105e-12, -4.2856548700683443e-13, 2.219191311588303e-14], [2.219191311588303e-14, 4.2856548700683443e-13, 3.1527624133703105e-12, 7.832509733627818e-12, -2.940589250764533e-11, -2.4070994535093427e-10, -3.426800863263089e-10, 1.893995386171984e-09, 7.768978854770062e-09, -1.0765919066191961e-09, -6.286156922010786e-08, -9.387197411095864e-08, 2.633898386997697e-07, 8.975701750636281e-07, -3.029054592052818e-07, -4.7506092464525525e-06, -3.5936448040251875e-06, 1.6573283953066164e-05, 2.913344750169041e-05, -3.645026068562775e-05, -0.00012930448400807207, 2.2920180412145e-05, 0.0004111283454742767, 0.00020007113630767797, -0.0010007783270856805, -0.001087053942226063, 0.0018771209257236502, 0.0034737989896811007, -0.0025508071277894726, -0.008469725493560752, 0.001737880332720511, 0.01704122457360669, 0.002648327307678168, -0.02947043187174764, -0.012917142554266795, 0.04518798127778834, 0.030531543272704135, -0.06347916458421186, -0.055027489525325726, 0.0851254926156355, 0.08322074716244976, -0.11447229589381826, -0.10784594993872142, 0.16087798859418773, 0.11241917487318838, -0.23610523615302595, -0.055706800072940856, 0.33004094891758806, -0.15402873445990006, -0.2891052383358292, 0.5513744327583752, -0.4897588047621993, 0.28065345597098296, -0.11137011695174052, 0.030773580221408376, -0.0057021265177733755, 0.0006409516803044435, -3.318966279841525e-05]]], "db30": [[[2.3386161727314215e-05, 0.0004666379504285509, 0.004300797165048069, 0.02413083267158838, 0.0912383040670157, 0.2420206709402141, 0.4504878218533178, 0.5575722329128364, 0.36624268337162796, -0.06618367077593731, -0.3329669750208556, -0.14196851333008292, 0.19946212158066431, 0.17782987324483673, -0.11455821943270778, -0.1572368179599938, 0.07277865897036442, 0.12274774604500938, -0.053806465458257076, -0.08765869003638366, 0.04380166467141773, 0.0567123657447357, -0.03567339749675961, -0.03226375891935221, 0.027078619595294184, 0.015287960769857396, -0.01839974386811734, -0.005296859666131087, 0.01091563165830489, 0.0006196717564977244, -0.005530730148192003, 0.0008433845866620934, 0.002324520094060099, -0.0008609276968110424, -0.0007678782504380919, 0.0005050948239033468, 0.00017248258423517096, -0.00021617183011696337, -8.54830546758407e-06, 6.982008370808328e-05, -1.3397168632939717e-05, -1.6361524787254266e-05, 7.252145535890469e-06, 2.3275490984936866e-06, -2.1872676769961665e-06, 1.0994743385262033e-08, 4.2616623260115723e-07, -1.0004146823545009e-07, -4.7643799651394533e-08, 2.6054427549776254e-08, 5.553397861397054e-10, -3.331105680467578e-09, 6.984862691832183e-10, 1.6136229782709042e-10, -9.461387997276803e-11, 1.0001051313931712e-11, 3.239428638532286e-12, -1.1852375921015822e-12, 1.54399757084762e-13, -7.737942630954405e-15], [-7.737942630954405e-15, -1.54399757084762e-13, -1.1852375921015822e-12, -3.239428638532286e-12, 1.0001051313931712e-11, 9.461387997276803e-11, 1.6136229782709042e-10, -6.984862691832183e-10, -3.331105680467578e-09, -5.553397861397054e-10, 2.6054427549776254e-08, 4.7643799651394533e-08, -1.0004146823545009e-07, -4.2616623260115723e-07, 1.0994743385262033e-08, 2.1872676769961665e-06, 2.3275490984936866e-06, -7.252145535890469e-06, -1.6361524787254266e-05, 1.3397168632939717e-05, 6.982008370808328e-05, 8.54830546758407e-06, -0.00021617183011696337, -0.00017248258423517096, 0.0005050948239033468, 0.0007678782504380919, -0.0008609276968110424, -0.002324520094060099, 0.0008433845866620934, 0.005530730148192003, 0.0006196717564977244, -0.01091563165830489, -0.005296859666131087, 0.01839974386811734, 0.015287960769857396, -0.027078619595294184, -0.03226375891935221, 0.03567339749675961, 0.0567123657447357, -0.04380166467141773, -0.08765869003638366, 0.053806465458257076, 0.12274774604500938, -0.07277865897036442, -0.1572368179599938, 0.11455821943270778, 0.17782987324483673, -0.19946212158066431, -0.14196851333008292, 0.3329669750208556, -0.06618367077593731, -0.36624268337162796, 0.5575722329128364, -0.4504878218533178, 0.2420206709402141, -0.0912383040670157, 0.02413083267158838, -0.004300797165048069, 0.0004666379504285509, -2.3386161727314215e-05]], [[2.3386161727314215e-05, 0.0004666379504285509, 0.004300797165048069, 0.02413083267158838, 0.0912383040670157, 0.2420206709402141, 0.4504878218533178, 0.5575722329128364, 0.36624268337162796, -0.06618367077593731, -0.3329669750208556, -0.14196851333008292, 0.19946212158066431, 0.17782987324483673, -0.11455821943270778, -0.1572368179599938, 0.07277865897036442, 0.12274774604500938, -0.053806465458257076, -0.08765869003638366, 0.04380166467141773, 0.0567123657447357, -0.03567339749675961, -0.03226375891935221, 0.027078619595294184, 0.015287960769857396, -0.01839974386811734, -0.005296859666131087, 0.01091563165830489, 0.0006196717564977244, -0.005530730148192003, 0.0008433845866620934, 0.002324520094060099, -0.0008609276968110424, -0.0007678782504380919, 0.0005050948239033468, 0.00017248258423517096, -0.00021617183011696337, -8.54830546758407e-06, 6.982008370808328e-05, -1.3397168632939717e-05, -1.6361524787254266e-05, 7.252145535890469e-06, 2.3275490984936866e-06, -2.1872676769961665e-06, 1.0994743385262033e-08, 4.2616623260115723e-07, -1.0004146823545009e-07, -4.7643799651394533e-08, 2.6054427549776254e-08, 5.553397861397054e-10, -3.331105680467578e-09, 6.984862691832183e-10, 1.6136229782709042e-10, -9.461387997276803e-11, 1.0001051313931712e-11, 3.239428638532286e-12, -1.1852375921015822e-12, 1.54399757084762e-13, -7.737942630954405e-15], [-7.737942630954405e-15, -1.54399757084762e-13, -1.1852375921015822e-12, -3.239428638532286e-12, 1.0001051313931712e-11, 9.461387997276803e-11, 1.6136229782709042e-10, -6.984862691832183e-10, -3.331105680467578e-09, -5.553397861397054e-10, 2.6054427549776254e-08, 4.7643799651394533e-08, -1.0004146823545009e-07, -4.2616623260115723e-07, 1.0994743385262033e-08, 2.1872676769961665e-06, 2.3275490984936866e-06, -7.252145535890469e-06, -1.6361524787254266e-05, 1.3397168632939717e-05, 6.982008370808328e-05, 8.54830546758407e-06, -0.00021617183011696337, -0.00017248258423517096, 0.0005050948239033468, 0.0007678782504380919, -0.0008609276968110424, -0.002324520094060099, 0.0008433845866620934, 0.005530730148192003, 0.0006196717564977244, -0.01091563165830489, -0.005296859666131087, 0.01839974386811734, 0.015287960769857396, -0.027078619595294184, -0.03226375891935221, 0.03567339749675961, 0.0567123657447357, -0.04380166467141773, -0.08765869003638366, 0.053806465458257076, 0.12274774604500938, -0.07277865897036442, -0.1572368179599938, 0.11455821943270778, 0.17782987324483673, -0.19946212158066431, -0.14196851333008292, 0.3329669750208556, -0.06618367077593731, -0.36624268337162796, 0.5575722329128364, -0.4504878218533178, 0.2420206709402141, -0.0912383040670157, 0.02413083267158838, -0.004300797165048069, 0.0004666379504285509, -2.3386161727314215e-05]]], "db31": [[[1.648013386456141e-05, 0.0003394122037769957, 0.0032368840686277213, 0.018853691612985914, 0.07433609301164788, 0.20701287448523534, 0.40919220003742784, 0.5511398409142755, 0.4294688082061373, 0.027169212497369463, -0.3109551183195075, -0.21797848552356336, 0.14017828876527327, 0.2249667114737371, -0.04992634916046824, -0.18696236089571544, 0.015436988429488934, 0.1450895009319932, -0.008139832273469236, -0.10761277332349563, 0.01094129745236497, 0.07535361174328141, -0.014880026618104822, -0.04861907546485433, 0.016154171565985913, 0.02804761936675617, -0.01427627527776352, -0.01390055293926653, 0.010517639487371841, 0.005516163573310993, -0.006520852375874612, -0.00142826422321891, 0.0033930667767159317, -6.397901106014601e-05, -0.001459041741985161, 0.00034313982969047345, 0.0004998816175637223, -0.00023965834694029495, -0.00012434116172502287, 0.00010895843504167668, 1.501335727444533e-05, -3.631255157860086e-05, 4.034520235184279e-06, 8.795301342692988e-06, -3.0351423658915096e-06, -1.3690602309429407e-06, 9.810015422044372e-07, 5.327250656974915e-08, -1.9759251291702062e-07, 3.6168265173310047e-08, 2.3283097138214097e-08, -1.0615296021502523e-08, -6.474311687959861e-10, 1.4085681510251775e-09, -2.524043954153353e-10, -7.348930032486264e-11, 3.6921088088711296e-11, -3.32700896712598e-12, -1.324334917243963e-12, 4.4454670962919323e-13, -5.5594420505790146e-14, 2.6993828797626656e-15], [2.6993828797626656e-15, 5.5594420505790146e-14, 4.4454670962919323e-13, 1.324334917243963e-12, -3.32700896712598e-12, -3.6921088088711296e-11, -7.348930032486264e-11, 2.524043954153353e-10, 1.4085681510251775e-09, 6.474311687959861e-10, -1.0615296021502523e-08, -2.3283097138214097e-08, 3.6168265173310047e-08, 1.9759251291702062e-07, 5.327250656974915e-08, -9.810015422044372e-07, -1.3690602309429407e-06, 3.0351423658915096e-06, 8.795301342692988e-06, -4.034520235184279e-06, -3.631255157860086e-05, -1.501335727444533e-05, 0.00010895843504167668, 0.00012434116172502287, -0.00023965834694029495, -0.0004998816175637223, 0.00034313982969047345, 0.001459041741985161, -6.397901106014601e-05, -0.0033930667767159317, -0.00142826422321891, 0.006520852375874612, 0.005516163573310993, -0.010517639487371841, -0.01390055293926653, 0.01427627527776352, 0.02804761936675617, -0.016154171565985913, -0.04861907546485433, 0.014880026618104822, 0.07535361174328141, -0.01094129745236497, -0.10761277332349563, 0.008139832273469236, 0.1450895009319932, -0.015436988429488934, -0.18696236089571544, 0.04992634916046824, 0.2249667114737371, -0.14017828876527327, -0.21797848552356336, 0.3109551183195075, 0.027169212497369463, -0.4294688082061373, 0.5511398409142755, -0.40919220003742784, 0.20701287448523534, -0.07433609301164788, 0.018853691612985914, -0.0032368840686277213, 0.0003394122037769957, -1.648013386456141e-05]], [[1.648013386456141e-05, 0.0003394122037769957, 0.0032368840686277213, 0.018853691612985914, 0.07433609301164788, 0.20701287448523534, 0.40919220003742784, 0.5511398409142755, 0.4294688082061373, 0.027169212497369463, -0.3109551183195075, -0.21797848552356336, 0.14017828876527327, 0.2249667114737371, -0.04992634916046824, -0.18696236089571544, 0.015436988429488934, 0.1450895009319932, -0.008139832273469236, -0.10761277332349563, 0.01094129745236497, 0.07535361174328141, -0.014880026618104822, -0.04861907546485433, 0.016154171565985913, 0.02804761936675617, -0.01427627527776352, -0.01390055293926653, 0.010517639487371841, 0.005516163573310993, -0.006520852375874612, -0.00142826422321891, 0.0033930667767159317, -6.397901106014601e-05, -0.001459041741985161, 0.00034313982969047345, 0.0004998816175637223, -0.00023965834694029495, -0.00012434116172502287, 0.00010895843504167668, 1.501335727444533e-05, -3.631255157860086e-05, 4.034520235184279e-06, 8.795301342692988e-06, -3.0351423658915096e-06, -1.3690602309429407e-06, 9.810015422044372e-07, 5.327250656974915e-08, -1.9759251291702062e-07, 3.6168265173310047e-08, 2.3283097138214097e-08, -1.0615296021502523e-08, -6.474311687959861e-10, 1.4085681510251775e-09, -2.524043954153353e-10, -7.348930032486264e-11, 3.6921088088711296e-11, -3.32700896712598e-12, -1.324334917243963e-12, 4.4454670962919323e-13, -5.5594420505790146e-14, 2.6993828797626656e-15], [2.6993828797626656e-15, 5.5594420505790146e-14, 4.4454670962919323e-13, 1.324334917243963e-12, -3.32700896712598e-12, -3.6921088088711296e-11, -7.348930032486264e-11, 2.524043954153353e-10, 1.4085681510251775e-09, 6.474311687959861e-10, -1.0615296021502523e-08, -2.3283097138214097e-08, 3.6168265173310047e-08, 1.9759251291702062e-07, 5.327250656974915e-08, -9.810015422044372e-07, -1.3690602309429407e-06, 3.0351423658915096e-06, 8.795301342692988e-06, -4.034520235184279e-06, -3.631255157860086e-05, -1.501335727444533e-05, 0.00010895843504167668, 0.00012434116172502287, -0.00023965834694029495, -0.0004998816175637223, 0.00034313982969047345, 0.001459041741985161, -6.397901106014601e-05, -0.0033930667767159317, -0.00142826422321891, 0.006520852375874612, 0.005516163573310993, -0.010517639487371841, -0.01390055293926653, 0.01427627527776352, 0.02804761936675617, -0.016154171565985913, -0.04861907546485433, 0.014880026618104822, 0.07535361174328141, -0.01094129745236497, -0.10761277332349563, 0.008139832273469236, 0.1450895009319932, -0.015436988429488934, -0.18696236089571544, 0.04992634916046824, 0.2249667114737371, -0.14017828876527327, -0.21797848552356336, 0.3109551183195075, 0.027169212497369463, -0.4294688082061373, 0.5511398409142755, -0.40919220003742784, 0.20701287448523534, -0.07433609301164788, 0.018853691612985914, -0.0032368840686277213, 0.0003394122037769957, -1.648013386456141e-05]]], "db32": [[[1.1614633021350149e-05, 0.00024665669063809033, 0.002431261919572266, 0.014681046381419136, 0.06025749912033537, 0.1757507836394389, 0.36750962859734965, 0.5343179193409539, 0.4778091637339484, 0.12063053826561783, -0.26669818147667557, -0.2774215815584272, 0.06471335480551624, 0.24831064235688016, 0.024662444839697404, -0.1921023447085469, -0.04899511718467174, 0.14523207947528666, 0.04440490819993974, -0.10945611311608938, -0.029627872508447704, 0.08087414063848396, 0.014106151516106608, -0.05692631406247844, -0.0023802644649325738, 0.03705145792354468, -0.004145907660827218, -0.021662822836391194, 0.006167527310685675, 0.011017400715406881, -0.005411568257275791, -0.004649216751184412, 0.003627224640687865, 0.0014689551004684678, -0.0019647405558217783, -0.0002211678729579098, 0.0008673058518450555, -0.00010245373106073962, -0.0003059654423826912, 0.00010539154617398281, 8.103678329134838e-05, -5.259809282684323e-05, -1.2940457794055127e-05, 1.8242684019806914e-05, -6.361781532260255e-07, -4.558309576264423e-06, 1.202889036321621e-06, 7.560047625595948e-07, -4.285970693151457e-07, -5.00336186874823e-08, 8.965966311957729e-08, -1.2199243594833731e-08, -1.104383021722649e-08, 4.250422311980593e-09, 4.3843877999404743e-10, -5.881091462634606e-10, 8.904723796221606e-11, 3.263270741332908e-11, -1.4309187651692024e-11, 1.0756106535010622e-12, 5.361482229611802e-13, -1.6638004894334023e-13, 2.000715303810525e-14, -9.421019139535079e-16], [-9.421019139535079e-16, -2.000715303810525e-14, -1.6638004894334023e-13, -5.361482229611802e-13, 1.0756106535010622e-12, 1.4309187651692024e-11, 3.263270741332908e-11, -8.904723796221606e-11, -5.881091462634606e-10, -4.3843877999404743e-10, 4.250422311980593e-09, 1.104383021722649e-08, -1.2199243594833731e-08, -8.965966311957729e-08, -5.00336186874823e-08, 4.285970693151457e-07, 7.560047625595948e-07, -1.202889036321621e-06, -4.558309576264423e-06, 6.361781532260255e-07, 1.8242684019806914e-05, 1.2940457794055127e-05, -5.259809282684323e-05, -8.103678329134838e-05, 0.00010539154617398281, 0.0003059654423826912, -0.00010245373106073962, -0.0008673058518450555, -0.0002211678729579098, 0.0019647405558217783, 0.0014689551004684678, -0.003627224640687865, -0.004649216751184412, 0.005411568257275791, 0.011017400715406881, -0.006167527310685675, -0.021662822836391194, 0.004145907660827218, 0.03705145792354468, 0.0023802644649325738, -0.05692631406247844, -0.014106151516106608, 0.08087414063848396, 0.029627872508447704, -0.10945611311608938, -0.04440490819993974, 0.14523207947528666, 0.04899511718467174, -0.1921023447085469, -0.024662444839697404, 0.24831064235688016, -0.06471335480551624, -0.2774215815584272, 0.26669818147667557, 0.12063053826561783, -0.4778091637339484, 0.5343179193409539, -0.36750962859734965, 0.1757507836394389, -0.06025749912033537, 0.014681046381419136, -0.002431261919572266, 0.00024665669063809033, -1.1614633021350149e-05]], [[1.1614633021350149e-05, 0.00024665669063809033, 0.002431261919572266, 0.014681046381419136, 0.06025749912033537, 0.1757507836394389, 0.36750962859734965, 0.5343179193409539, 0.4778091637339484, 0.12063053826561783, -0.26669818147667557, -0.2774215815584272, 0.06471335480551624, 0.24831064235688016, 0.024662444839697404, -0.1921023447085469, -0.04899511718467174, 0.14523207947528666, 0.04440490819993974, -0.10945611311608938, -0.029627872508447704, 0.08087414063848396, 0.014106151516106608, -0.05692631406247844, -0.0023802644649325738, 0.03705145792354468, -0.004145907660827218, -0.021662822836391194, 0.006167527310685675, 0.011017400715406881, -0.005411568257275791, -0.004649216751184412, 0.003627224640687865, 0.0014689551004684678, -0.0019647405558217783, -0.0002211678729579098, 0.0008673058518450555, -0.00010245373106073962, -0.0003059654423826912, 0.00010539154617398281, 8.103678329134838e-05, -5.259809282684323e-05, -1.2940457794055127e-05, 1.8242684019806914e-05, -6.361781532260255e-07, -4.558309576264423e-06, 1.202889036321621e-06, 7.560047625595948e-07, -4.285970693151457e-07, -5.00336186874823e-08, 8.965966311957729e-08, -1.2199243594833731e-08, -1.104383021722649e-08, 4.250422311980593e-09, 4.3843877999404743e-10, -5.881091462634606e-10, 8.904723796221606e-11, 3.263270741332908e-11, -1.4309187651692024e-11, 1.0756106535010622e-12, 5.361482229611802e-13, -1.6638004894334023e-13, 2.000715303810525e-14, -9.421019139535079e-16], [-9.421019139535079e-16, -2.000715303810525e-14, -1.6638004894334023e-13, -5.361482229611802e-13, 1.0756106535010622e-12, 1.4309187651692024e-11, 3.263270741332908e-11, -8.904723796221606e-11, -5.881091462634606e-10, -4.3843877999404743e-10, 4.250422311980593e-09, 1.104383021722649e-08, -1.2199243594833731e-08, -8.965966311957729e-08, -5.00336186874823e-08, 4.285970693151457e-07, 7.560047625595948e-07, -1.202889036321621e-06, -4.558309576264423e-06, 6.361781532260255e-07, 1.8242684019806914e-05, 1.2940457794055127e-05, -5.259809282684323e-05, -8.103678329134838e-05, 0.00010539154617398281, 0.0003059654423826912, -0.00010245373106073962, -0.0008673058518450555, -0.0002211678729579098, 0.0019647405558217783, 0.0014689551004684678, -0.003627224640687865, -0.004649216751184412, 0.005411568257275791, 0.011017400715406881, -0.006167527310685675, -0.021662822836391194, 0.004145907660827218, 0.03705145792354468, 0.0023802644649325738, -0.05692631406247844, -0.014106151516106608, 0.08087414063848396, 0.029627872508447704, -0.10945611311608938, -0.04440490819993974, 0.14523207947528666, 0.04899511718467174, -0.1921023447085469, -0.024662444839697404, 0.24831064235688016, -0.06471335480551624, -0.2774215815584272, 0.26669818147667557, 0.12063053826561783, -0.4778091637339484, 0.5343179193409539, -0.36750962859734965, 0.1757507836394389, -0.06025749912033537, 0.014681046381419136, -0.002431261919572266, 0.00024665669063809033, -1.1614633021350149e-05]]], "db33": [[[8.186358314175091e-06, 0.00017910161537027915, 0.0018227094351640843, 0.01139594337458161, 0.04861466653171619, 0.14818631318005282, 0.32671813011770756, 0.5093761725149396, 0.5112547705832675, 0.20958235071305542, -0.20420262239854212, -0.31599741076656024, -0.01927833943695276, 0.24542061211927912, 0.09985155868033815, -0.17142809905185932, -0.11084413311671079, 0.12196785640373461, 0.09478808805061596, -0.09114696835133149, -0.07030248505405616, 0.07019114394099653, 0.04573456189389668, -0.05347125133582229, -0.025248582977476498, 0.038687060760244966, 0.010703265820019549, -0.025728761754732973, -0.002167758617353607, 0.015316954115857666, -0.0015942887824146048, -0.00795354038705794, 0.0023890624081659086, 0.003480800953405712, -0.001860718214455796, -0.001204309257604659, 0.0010743806963512913, 0.0002727305847336937, -0.0004908329007590351, 4.3931662517661856e-06, 0.00017804318982512455, -4.1604385162737096e-05, -4.9295644234173015e-05, 2.4233353988168903e-05, 9.070805757828453e-06, -8.866121366757737e-06, -3.607516102879772e-07, 2.2883712761415273e-06, -4.4269234079528704e-07, -3.985791291985944e-07, 1.8224433325710535e-07, 3.377972703730854e-08, -3.9878381985188806e-08, 3.6728635768381814e-09, 5.111211857347454e-09, -1.6713926772519324e-09, -2.496402105246194e-10, 2.426833102305682e-10, -3.0495744539458635e-11, -1.4202368598899367e-11, 5.509414720765525e-12, -3.343481218953279e-13, -2.1524883868333026e-13, 6.214740247174398e-14, -7.196510545363322e-15, 3.289373678416306e-16], [3.289373678416306e-16, 7.196510545363322e-15, 6.214740247174398e-14, 2.1524883868333026e-13, -3.343481218953279e-13, -5.509414720765525e-12, -1.4202368598899367e-11, 3.0495744539458635e-11, 2.426833102305682e-10, 2.496402105246194e-10, -1.6713926772519324e-09, -5.111211857347454e-09, 3.6728635768381814e-09, 3.9878381985188806e-08, 3.377972703730854e-08, -1.8224433325710535e-07, -3.985791291985944e-07, 4.4269234079528704e-07, 2.2883712761415273e-06, 3.607516102879772e-07, -8.866121366757737e-06, -9.070805757828453e-06, 2.4233353988168903e-05, 4.9295644234173015e-05, -4.1604385162737096e-05, -0.00017804318982512455, 4.3931662517661856e-06, 0.0004908329007590351, 0.0002727305847336937, -0.0010743806963512913, -0.001204309257604659, 0.001860718214455796, 0.003480800953405712, -0.0023890624081659086, -0.00795354038705794, 0.0015942887824146048, 0.015316954115857666, 0.002167758617353607, -0.025728761754732973, -0.010703265820019549, 0.038687060760244966, 0.025248582977476498, -0.05347125133582229, -0.04573456189389668, 0.07019114394099653, 0.07030248505405616, -0.09114696835133149, -0.09478808805061596, 0.12196785640373461, 0.11084413311671079, -0.17142809905185932, -0.09985155868033815, 0.24542061211927912, 0.01927833943695276, -0.31599741076656024, 0.20420262239854212, 0.20958235071305542, -0.5112547705832675, 0.5093761725149396, -0.32671813011770756, 0.14818631318005282, -0.04861466653171619, 0.01139594337458161, -0.0018227094351640843, 0.00017910161537027915, -8.186358314175091e-06]], [[8.186358314175091e-06, 0.00017910161537027915, 0.0018227094351640843, 0.01139594337458161, 0.04861466653171619, 0.14818631318005282, 0.32671813011770756, 0.5093761725149396, 0.5112547705832675, 0.20958235071305542, -0.20420262239854212, -0.31599741076656024, -0.01927833943695276, 0.24542061211927912, 0.09985155868033815, -0.17142809905185932, -0.11084413311671079, 0.12196785640373461, 0.09478808805061596, -0.09114696835133149, -0.07030248505405616, 0.07019114394099653, 0.04573456189389668, -0.05347125133582229, -0.025248582977476498, 0.038687060760244966, 0.010703265820019549, -0.025728761754732973, -0.002167758617353607, 0.015316954115857666, -0.0015942887824146048, -0.00795354038705794, 0.0023890624081659086, 0.003480800953405712, -0.001860718214455796, -0.001204309257604659, 0.0010743806963512913, 0.0002727305847336937, -0.0004908329007590351, 4.3931662517661856e-06, 0.00017804318982512455, -4.1604385162737096e-05, -4.9295644234173015e-05, 2.4233353988168903e-05, 9.070805757828453e-06, -8.866121366757737e-06, -3.607516102879772e-07, 2.2883712761415273e-06, -4.4269234079528704e-07, -3.985791291985944e-07, 1.8224433325710535e-07, 3.377972703730854e-08, -3.9878381985188806e-08, 3.6728635768381814e-09, 5.111211857347454e-09, -1.6713926772519324e-09, -2.496402105246194e-10, 2.426833102305682e-10, -3.0495744539458635e-11, -1.4202368598899367e-11, 5.509414720765525e-12, -3.343481218953279e-13, -2.1524883868333026e-13, 6.214740247174398e-14, -7.196510545363322e-15, 3.289373678416306e-16], [3.289373678416306e-16, 7.196510545363322e-15, 6.214740247174398e-14, 2.1524883868333026e-13, -3.343481218953279e-13, -5.509414720765525e-12, -1.4202368598899367e-11, 3.0495744539458635e-11, 2.426833102305682e-10, 2.496402105246194e-10, -1.6713926772519324e-09, -5.111211857347454e-09, 3.6728635768381814e-09, 3.9878381985188806e-08, 3.377972703730854e-08, -1.8224433325710535e-07, -3.985791291985944e-07, 4.4269234079528704e-07, 2.2883712761415273e-06, 3.607516102879772e-07, -8.866121366757737e-06, -9.070805757828453e-06, 2.4233353988168903e-05, 4.9295644234173015e-05, -4.1604385162737096e-05, -0.00017804318982512455, 4.3931662517661856e-06, 0.0004908329007590351, 0.0002727305847336937, -0.0010743806963512913, -0.001204309257604659, 0.001860718214455796, 0.003480800953405712, -0.0023890624081659086, -0.00795354038705794, 0.0015942887824146048, 0.015316954115857666, 0.002167758617353607, -0.025728761754732973, -0.010703265820019549, 0.038687060760244966, 0.025248582977476498, -0.05347125133582229, -0.04573456189389668, 0.07019114394099653, 0.07030248505405616, -0.09114696835133149, -0.09478808805061596, 0.12196785640373461, 0.11084413311671079, -0.17142809905185932, -0.09985155868033815, 0.24542061211927912, 0.01927833943695276, -0.31599741076656024, 0.20420262239854212, 0.20958235071305542, -0.5112547705832675, 0.5093761725149396, -0.32671813011770756, 0.14818631318005282, -0.04861466653171619, 0.01139594337458161, -0.0018227094351640843, 0.00017910161537027915, -8.186358314175091e-06]]], "db34": [[[5.770510632730285e-06, 0.000129947620067953, 0.00136406139005905, 0.008819889403884978, 0.03904884135178594, 0.1241524821113768, 0.28776505923371454, 0.47847874627937104, 0.5305550996564632, 0.290366329507275, -0.12824684217443716, -0.33152530150838694, -0.10389191551564048, 0.21690722018742759, 0.16660175041220746, -0.12733735822380116, -0.1609249271778668, 0.07799184693794811, 0.13412596027113613, -0.05448296806413905, -0.10294759699281408, 0.043576094649631296, 0.0731852354367956, -0.03701283841786245, -0.04743855964527776, 0.030739746573959344, 0.027228350756354196, -0.023671737922826366, -0.013143980016657161, 0.01640937419986519, 0.00471364926099981, -0.01004550670836152, -0.0006194748845153873, 0.005334950768759936, -0.0007692127975067837, -0.002399453943537056, 0.0008589959874363662, 0.0008751999064078689, -0.0005527355762144198, -0.00023267321402335316, 0.00026507723975580577, 2.660050018453442e-05, -9.914697770780135e-05, 1.3531172272496496e-05, 2.8449514196978075e-05, -1.0576574942579506e-05, -5.710826510998304e-06, 4.169871758547028e-06, 4.979718101421308e-07, -1.1163065348170084e-06, 1.448195708333185e-07, 2.0259906666678593e-07, -7.52670174041259e-08, -1.990346501531737e-08, 1.740423332936068e-08, -8.665744261368722e-10, -2.316501946995483e-09, 6.446378210323402e-10, 1.3004103186094153e-10, -9.90477453763241e-11, 1.0042087354617698e-11, 6.0801253540001675e-12, -2.1078791089153017e-12, 9.799451158211598e-14, 8.579194051799733e-14, -2.3170837039064084e-14, 2.5873383819356996e-15, -1.14894475448059e-16], [-1.14894475448059e-16, -2.5873383819356996e-15, -2.3170837039064084e-14, -8.579194051799733e-14, 9.799451158211598e-14, 2.1078791089153017e-12, 6.0801253540001675e-12, -1.0042087354617698e-11, -9.90477453763241e-11, -1.3004103186094153e-10, 6.446378210323402e-10, 2.316501946995483e-09, -8.665744261368722e-10, -1.740423332936068e-08, -1.990346501531737e-08, 7.52670174041259e-08, 2.0259906666678593e-07, -1.448195708333185e-07, -1.1163065348170084e-06, -4.979718101421308e-07, 4.169871758547028e-06, 5.710826510998304e-06, -1.0576574942579506e-05, -2.8449514196978075e-05, 1.3531172272496496e-05, 9.914697770780135e-05, 2.660050018453442e-05, -0.00026507723975580577, -0.00023267321402335316, 0.0005527355762144198, 0.0008751999064078689, -0.0008589959874363662, -0.002399453943537056, 0.0007692127975067837, 0.005334950768759936, 0.0006194748845153873, -0.01004550670836152, -0.00471364926099981, 0.01640937419986519, 0.013143980016657161, -0.023671737922826366, -0.027228350756354196, 0.030739746573959344, 0.04743855964527776, -0.03701283841786245, -0.0731852354367956, 0.043576094649631296, 0.10294759699281408, -0.05448296806413905, -0.13412596027113613, 0.07799184693794811, 0.1609249271778668, -0.12733735822380116, -0.16660175041220746, 0.21690722018742759, 0.10389191551564048, -0.33152530150838694, 0.12824684217443716, 0.290366329507275, -0.5305550996564632, 0.47847874627937104, -0.28776505923371454, 0.1241524821113768, -0.03904884135178594, 0.008819889403884978, -0.00136406139005905, 0.000129947620067953, -5.770510632730285e-06]], [[5.770510632730285e-06, 0.000129947620067953, 0.00136406139005905, 0.008819889403884978, 0.03904884135178594, 0.1241524821113768, 0.28776505923371454, 0.47847874627937104, 0.5305550996564632, 0.290366329507275, -0.12824684217443716, -0.33152530150838694, -0.10389191551564048, 0.21690722018742759, 0.16660175041220746, -0.12733735822380116, -0.1609249271778668, 0.07799184693794811, 0.13412596027113613, -0.05448296806413905, -0.10294759699281408, 0.043576094649631296, 0.0731852354367956, -0.03701283841786245, -0.04743855964527776, 0.030739746573959344, 0.027228350756354196, -0.023671737922826366, -0.013143980016657161, 0.01640937419986519, 0.00471364926099981, -0.01004550670836152, -0.0006194748845153873, 0.005334950768759936, -0.0007692127975067837, -0.002399453943537056, 0.0008589959874363662, 0.0008751999064078689, -0.0005527355762144198, -0.00023267321402335316, 0.00026507723975580577, 2.660050018453442e-05, -9.914697770780135e-05, 1.3531172272496496e-05, 2.8449514196978075e-05, -1.0576574942579506e-05, -5.710826510998304e-06, 4.169871758547028e-06, 4.979718101421308e-07, -1.1163065348170084e-06, 1.448195708333185e-07, 2.0259906666678593e-07, -7.52670174041259e-08, -1.990346501531737e-08, 1.740423332936068e-08, -8.665744261368722e-10, -2.316501946995483e-09, 6.446378210323402e-10, 1.3004103186094153e-10, -9.90477453763241e-11, 1.0042087354617698e-11, 6.0801253540001675e-12, -2.1078791089153017e-12, 9.799451158211598e-14, 8.579194051799733e-14, -2.3170837039064084e-14, 2.5873383819356996e-15, -1.14894475448059e-16], [-1.14894475448059e-16, -2.5873383819356996e-15, -2.3170837039064084e-14, -8.579194051799733e-14, 9.799451158211598e-14, 2.1078791089153017e-12, 6.0801253540001675e-12, -1.0042087354617698e-11, -9.90477453763241e-11, -1.3004103186094153e-10, 6.446378210323402e-10, 2.316501946995483e-09, -8.665744261368722e-10, -1.740423332936068e-08, -1.990346501531737e-08, 7.52670174041259e-08, 2.0259906666678593e-07, -1.448195708333185e-07, -1.1163065348170084e-06, -4.979718101421308e-07, 4.169871758547028e-06, 5.710826510998304e-06, -1.0576574942579506e-05, -2.8449514196978075e-05, 1.3531172272496496e-05, 9.914697770780135e-05, 2.660050018453442e-05, -0.00026507723975580577, -0.00023267321402335316, 0.0005527355762144198, 0.0008751999064078689, -0.0008589959874363662, -0.002399453943537056, 0.0007692127975067837, 0.005334950768759936, 0.0006194748845153873, -0.01004550670836152, -0.00471364926099981, 0.01640937419986519, 0.013143980016657161, -0.023671737922826366, -0.027228350756354196, 0.030739746573959344, 0.04743855964527776, -0.03701283841786245, -0.0731852354367956, 0.043576094649631296, 0.10294759699281408, -0.05448296806413905, -0.13412596027113613, 0.07799184693794811, 0.1609249271778668, -0.12733735822380116, -0.16660175041220746, 0.21690722018742759, 0.10389191551564048, -0.33152530150838694, 0.12824684217443716, 0.290366329507275, -0.5305550996564632, 0.47847874627937104, -0.28776505923371454, 0.1241524821113768, -0.03904884135178594, 0.008819889403884978, -0.00136406139005905, 0.000129947620067953, -5.770510632730285e-06]]], "db35": [[[4.067934061148559e-06, 9.42146947557674e-05, 0.0010191226803750982, 0.006807292884319132, 0.031236288511490715, 0.10340445586147838, 0.2513073789944933, 0.4435927392240354, 0.5370084275091661, 0.36034564051804735, -0.04388388187393404, -0.32382286491211615, -0.18178697676672784, 0.16604135749078092, 0.2172992893210893, -0.06526287131067754, -0.19191958929859396, 0.01930954466601835, 0.1552924803962371, -0.004752680834111351, -0.12058552264339356, 0.004734229172641949, 0.08991354757072954, -0.009318558949903924, -0.06335603744044346, 0.013228549585036555, 0.04125469306470509, -0.014366839784220072, -0.024169497801660268, 0.012766456715656745, 0.012289436008118711, -0.00957779789923571, -0.00508599164923343, 0.006137754586740521, 0.0014280887940707622, -0.0033576443809223834, 7.615969435172737e-06, 0.001549637469702363, -0.0003346692164250855, -0.0005864810318991818, 0.0002648328819961289, 0.0001700012283661249, -0.00013658830722611617, -2.9769959628485097e-05, 5.30414312291331e-05, -2.43700152682779e-06, -1.5724420772702817e-05, 4.308047861716731e-06, 3.35334586287131e-06, -1.8959296176931532e-06, -3.9039317332873064e-07, 5.302368616904761e-07, -3.700308378205125e-08, -9.990396944534901e-08, 3.008188650719067e-08, 1.0849027337899348e-08, -7.458116552893037e-09, 5.897951310384362e-11, 1.0308233454854333e-09, -2.433545573751673e-10, -6.407938256501889e-11, 4.0005366272537445e-11, -3.1256393571085576e-12, -2.5670654761550815e-12, 8.015088533687901e-13, -2.5979543288938482e-14, -3.3977208567962675e-14, 8.624037434720089e-15, -9.298012529324185e-16, 4.0146287123334886e-17], [4.0146287123334886e-17, 9.298012529324185e-16, 8.624037434720089e-15, 3.3977208567962675e-14, -2.5979543288938482e-14, -8.015088533687901e-13, -2.5670654761550815e-12, 3.1256393571085576e-12, 4.0005366272537445e-11, 6.407938256501889e-11, -2.433545573751673e-10, -1.0308233454854333e-09, 5.897951310384362e-11, 7.458116552893037e-09, 1.0849027337899348e-08, -3.008188650719067e-08, -9.990396944534901e-08, 3.700308378205125e-08, 5.302368616904761e-07, 3.9039317332873064e-07, -1.8959296176931532e-06, -3.35334586287131e-06, 4.308047861716731e-06, 1.5724420772702817e-05, -2.43700152682779e-06, -5.30414312291331e-05, -2.9769959628485097e-05, 0.00013658830722611617, 0.0001700012283661249, -0.0002648328819961289, -0.0005864810318991818, 0.0003346692164250855, 0.001549637469702363, -7.615969435172737e-06, -0.0033576443809223834, -0.0014280887940707622, 0.006137754586740521, 0.00508599164923343, -0.00957779789923571, -0.012289436008118711, 0.012766456715656745, 0.024169497801660268, -0.014366839784220072, -0.04125469306470509, 0.013228549585036555, 0.06335603744044346, -0.009318558949903924, -0.08991354757072954, 0.004734229172641949, 0.12058552264339356, -0.004752680834111351, -0.1552924803962371, 0.01930954466601835, 0.19191958929859396, -0.06526287131067754, -0.2172992893210893, 0.16604135749078092, 0.18178697676672784, -0.32382286491211615, 0.04388388187393404, 0.36034564051804735, -0.5370084275091661, 0.4435927392240354, -0.2513073789944933, 0.10340445586147838, -0.031236288511490715, 0.006807292884319132, -0.0010191226803750982, 9.42146947557674e-05, -4.067934061148559e-06]], [[4.067934061148559e-06, 9.42146947557674e-05, 0.0010191226803750982, 0.006807292884319132, 0.031236288511490715, 0.10340445586147838, 0.2513073789944933, 0.4435927392240354, 0.5370084275091661, 0.36034564051804735, -0.04388388187393404, -0.32382286491211615, -0.18178697676672784, 0.16604135749078092, 0.2172992893210893, -0.06526287131067754, -0.19191958929859396, 0.01930954466601835, 0.1552924803962371, -0.004752680834111351, -0.12058552264339356, 0.004734229172641949, 0.08991354757072954, -0.009318558949903924, -0.06335603744044346, 0.013228549585036555, 0.04125469306470509, -0.014366839784220072, -0.024169497801660268, 0.012766456715656745, 0.012289436008118711, -0.00957779789923571, -0.00508599164923343, 0.006137754586740521, 0.0014280887940707622, -0.0033576443809223834, 7.615969435172737e-06, 0.001549637469702363, -0.0003346692164250855, -0.0005864810318991818, 0.0002648328819961289, 0.0001700012283661249, -0.00013658830722611617, -2.9769959628485097e-05, 5.30414312291331e-05, -2.43700152682779e-06, -1.5724420772702817e-05, 4.308047861716731e-06, 3.35334586287131e-06, -1.8959296176931532e-06, -3.9039317332873064e-07, 5.302368616904761e-07, -3.700308378205125e-08, -9.990396944534901e-08, 3.008188650719067e-08, 1.0849027337899348e-08, -7.458116552893037e-09, 5.897951310384362e-11, 1.0308233454854333e-09, -2.433545573751673e-10, -6.407938256501889e-11, 4.0005366272537445e-11, -3.1256393571085576e-12, -2.5670654761550815e-12, 8.015088533687901e-13, -2.5979543288938482e-14, -3.3977208567962675e-14, 8.624037434720089e-15, -9.298012529324185e-16, 4.0146287123334886e-17], [4.0146287123334886e-17, 9.298012529324185e-16, 8.624037434720089e-15, 3.3977208567962675e-14, -2.5979543288938482e-14, -8.015088533687901e-13, -2.5670654761550815e-12, 3.1256393571085576e-12, 4.0005366272537445e-11, 6.407938256501889e-11, -2.433545573751673e-10, -1.0308233454854333e-09, 5.897951310384362e-11, 7.458116552893037e-09, 1.0849027337899348e-08, -3.008188650719067e-08, -9.990396944534901e-08, 3.700308378205125e-08, 5.302368616904761e-07, 3.9039317332873064e-07, -1.8959296176931532e-06, -3.35334586287131e-06, 4.308047861716731e-06, 1.5724420772702817e-05, -2.43700152682779e-06, -5.30414312291331e-05, -2.9769959628485097e-05, 0.00013658830722611617, 0.0001700012283661249, -0.0002648328819961289, -0.0005864810318991818, 0.0003346692164250855, 0.001549637469702363, -7.615969435172737e-06, -0.0033576443809223834, -0.0014280887940707622, 0.006137754586740521, 0.00508599164923343, -0.00957779789923571, -0.012289436008118711, 0.012766456715656745, 0.024169497801660268, -0.014366839784220072, -0.04125469306470509, 0.013228549585036555, 0.06335603744044346, -0.009318558949903924, -0.08991354757072954, 0.004734229172641949, 0.12058552264339356, -0.004752680834111351, -0.1552924803962371, 0.01930954466601835, 0.19191958929859396, -0.06526287131067754, -0.2172992893210893, 0.16604135749078092, 0.18178697676672784, -0.32382286491211615, 0.04388388187393404, 0.36034564051804735, -0.5370084275091661, 0.4435927392240354, -0.2513073789944933, 0.10340445586147838, -0.031236288511490715, 0.006807292884319132, -0.0010191226803750982, 9.42146947557674e-05, -4.067934061148559e-06]]], "db36": [[[2.867925182755946e-06, 6.826028678546358e-05, 0.0007602151099668488, 0.005240297377409884, 0.024890565644827965, 0.08565209259526409, 0.2177569530979008, 0.4064336977082553, 0.5322668952607287, 0.4178753356009698, 0.04397519752934863, -0.2944210395891146, -0.24680703697812553, 0.09811420416311477, 0.2465372776089742, 0.007278515095792229, -0.19933720560864962, -0.045861400746392715, 0.1541062366276429, 0.05027618007353843, -0.11880375431013564, -0.03988085357551317, 0.09115678225801654, 0.02503872144956849, -0.06820901663681751, -0.011319100316817429, 0.04851308354780909, 0.0014249726617653917, -0.0319807206776397, 0.003984040198717005, 0.01906359478062536, -0.005657813245058818, -0.009990263473281372, 0.005022989106665829, 0.004413484835350576, -0.0034845414454048834, -0.0015030740662966438, 0.0019907937718517373, 0.0002776812795712026, -0.0009463403823261102, 8.614565758992702e-05, 0.00036935072849675105, -0.00011551188958435271, -0.00011318994680846657, 6.69474119693059e-05, 2.3751066836608608e-05, -2.7313908246543378e-05, -1.183471059985616e-06, 8.372218198160788e-06, -1.5861457824345775e-06, -1.8708116028591808e-06, 8.311421279707779e-07, 2.5484235225565776e-07, -2.4553776584342327e-07, 2.753249073339512e-09, 4.799043465450992e-08, -1.1560936888170085e-08, -5.612784343327791e-09, 3.138841695782424e-09, 1.0908155537137518e-10, -4.5125457785632494e-10, 8.962418203859612e-11, 3.037429098112535e-11, -1.599716689261357e-11, 8.876846287217375e-13, 1.070969357114017e-12, -3.029285026974877e-13, 5.542263182639804e-15, 1.3380713862991059e-14, -3.2046285434017497e-15, 3.339971984818693e-16, -1.4032741753731907e-17], [-1.4032741753731907e-17, -3.339971984818693e-16, -3.2046285434017497e-15, -1.3380713862991059e-14, 5.542263182639804e-15, 3.029285026974877e-13, 1.070969357114017e-12, -8.876846287217375e-13, -1.599716689261357e-11, -3.037429098112535e-11, 8.962418203859612e-11, 4.5125457785632494e-10, 1.0908155537137518e-10, -3.138841695782424e-09, -5.612784343327791e-09, 1.1560936888170085e-08, 4.799043465450992e-08, -2.753249073339512e-09, -2.4553776584342327e-07, -2.5484235225565776e-07, 8.311421279707779e-07, 1.8708116028591808e-06, -1.5861457824345775e-06, -8.372218198160788e-06, -1.183471059985616e-06, 2.7313908246543378e-05, 2.3751066836608608e-05, -6.69474119693059e-05, -0.00011318994680846657, 0.00011551188958435271, 0.00036935072849675105, -8.614565758992702e-05, -0.0009463403823261102, -0.0002776812795712026, 0.0019907937718517373, 0.0015030740662966438, -0.0034845414454048834, -0.004413484835350576, 0.005022989106665829, 0.009990263473281372, -0.005657813245058818, -0.01906359478062536, 0.003984040198717005, 0.0319807206776397, 0.0014249726617653917, -0.04851308354780909, -0.011319100316817429, 0.06820901663681751, 0.02503872144956849, -0.09115678225801654, -0.03988085357551317, 0.11880375431013564, 0.05027618007353843, -0.1541062366276429, -0.045861400746392715, 0.19933720560864962, 0.007278515095792229, -0.2465372776089742, 0.09811420416311477, 0.24680703697812553, -0.2944210395891146, -0.04397519752934863, 0.4178753356009698, -0.5322668952607287, 0.4064336977082553, -0.2177569530979008, 0.08565209259526409, -0.024890565644827965, 0.005240297377409884, -0.0007602151099668488, 6.826028678546358e-05, -2.867925182755946e-06]], [[2.867925182755946e-06, 6.826028678546358e-05, 0.0007602151099668488, 0.005240297377409884, 0.024890565644827965, 0.08565209259526409, 0.2177569530979008, 0.4064336977082553, 0.5322668952607287, 0.4178753356009698, 0.04397519752934863, -0.2944210395891146, -0.24680703697812553, 0.09811420416311477, 0.2465372776089742, 0.007278515095792229, -0.19933720560864962, -0.045861400746392715, 0.1541062366276429, 0.05027618007353843, -0.11880375431013564, -0.03988085357551317, 0.09115678225801654, 0.02503872144956849, -0.06820901663681751, -0.011319100316817429, 0.04851308354780909, 0.0014249726617653917, -0.0319807206776397, 0.003984040198717005, 0.01906359478062536, -0.005657813245058818, -0.009990263473281372, 0.005022989106665829, 0.004413484835350576, -0.0034845414454048834, -0.0015030740662966438, 0.0019907937718517373, 0.0002776812795712026, -0.0009463403823261102, 8.614565758992702e-05, 0.00036935072849675105, -0.00011551188958435271, -0.00011318994680846657, 6.69474119693059e-05, 2.3751066836608608e-05, -2.7313908246543378e-05, -1.183471059985616e-06, 8.372218198160788e-06, -1.5861457824345775e-06, -1.8708116028591808e-06, 8.311421279707779e-07, 2.5484235225565776e-07, -2.4553776584342327e-07, 2.753249073339512e-09, 4.799043465450992e-08, -1.1560936888170085e-08, -5.612784343327791e-09, 3.138841695782424e-09, 1.0908155537137518e-10, -4.5125457785632494e-10, 8.962418203859612e-11, 3.037429098112535e-11, -1.599716689261357e-11, 8.876846287217375e-13, 1.070969357114017e-12, -3.029285026974877e-13, 5.542263182639804e-15, 1.3380713862991059e-14, -3.2046285434017497e-15, 3.339971984818693e-16, -1.4032741753731907e-17], [-1.4032741753731907e-17, -3.339971984818693e-16, -3.2046285434017497e-15, -1.3380713862991059e-14, 5.542263182639804e-15, 3.029285026974877e-13, 1.070969357114017e-12, -8.876846287217375e-13, -1.599716689261357e-11, -3.037429098112535e-11, 8.962418203859612e-11, 4.5125457785632494e-10, 1.0908155537137518e-10, -3.138841695782424e-09, -5.612784343327791e-09, 1.1560936888170085e-08, 4.799043465450992e-08, -2.753249073339512e-09, -2.4553776584342327e-07, -2.5484235225565776e-07, 8.311421279707779e-07, 1.8708116028591808e-06, -1.5861457824345775e-06, -8.372218198160788e-06, -1.183471059985616e-06, 2.7313908246543378e-05, 2.3751066836608608e-05, -6.69474119693059e-05, -0.00011318994680846657, 0.00011551188958435271, 0.00036935072849675105, -8.614565758992702e-05, -0.0009463403823261102, -0.0002776812795712026, 0.0019907937718517373, 0.0015030740662966438, -0.0034845414454048834, -0.004413484835350576, 0.005022989106665829, 0.009990263473281372, -0.005657813245058818, -0.01906359478062536, 0.003984040198717005, 0.0319807206776397, 0.0014249726617653917, -0.04851308354780909, -0.011319100316817429, 0.06820901663681751, 0.02503872144956849, -0.09115678225801654, -0.03988085357551317, 0.11880375431013564, 0.05027618007353843, -0.1541062366276429, -0.045861400746392715, 0.19933720560864962, 0.007278515095792229, -0.2465372776089742, 0.09811420416311477, 0.24680703697812553, -0.2944210395891146, -0.04397519752934863, 0.4178753356009698, -0.5322668952607287, 0.4064336977082553, -0.2177569530979008, 0.08565209259526409, -0.024890565644827965, 0.005240297377409884, -0.0007602151099668488, 6.826028678546358e-05, -2.867925182755946e-06]]], "db37": [[[2.0220608624983923e-06, 4.942343750628132e-05, 0.0005662418377066724, 0.0040241403682572865, 0.01976228615387959, 0.0705848259771816, 0.18732633186206493, 0.36844097240030615, 0.5181670408556229, 0.4622075536616057, 0.13087896323302017, -0.24618042976108342, -0.29437591526266177, 0.01967150045235939, 0.2515232543602687, 0.08180602838721862, -0.181962291778608, -0.10845171382330178, 0.12992964695985376, 0.10178029683881418, -0.09660754061668439, -0.08233021190655741, 0.07504761994836018, 0.059567410871529954, -0.05925681563265897, -0.03825382947938425, 0.045807944151268334, 0.020972800592597547, -0.03352358406410097, -0.008833493890410233, 0.022618651544599473, 0.0016904723834844238, -0.013763981962894785, 0.0015193057788333991, 0.007387757452855584, -0.0022480531870038246, -0.0033945232764083988, 0.0018168713438014236, 0.0012639342581174772, -0.0011114848653186302, -0.00032807884708801983, 0.0005490532773373631, 1.5344390231955034e-05, -0.00022089440324554938, 4.336726125945695e-05, 7.055138782065466e-05, -3.09866292761993e-05, -1.6391624961605832e-05, 1.3543277184167817e-05, 1.8499450031155903e-06, -4.3099415565970926e-06, 4.854731396996412e-07, 1.0021213992971776e-06, -3.494948603445728e-07, -1.5098853886715837e-07, 1.1090312322164394e-07, 5.3506575154614344e-09, -2.2521938367248057e-08, 4.224485706362419e-09, 2.793974465953983e-09, -1.297205001469435e-09, -1.031411129096975e-10, 1.946164894082315e-10, -3.203398244123242e-11, -1.3984157155376414e-11, 6.3349554409739135e-12, -2.0963631942348006e-13, -4.4216124098721056e-13, 1.1380528309214397e-13, -4.518889607463727e-16, -5.243025691884206e-15, 1.1890123875082528e-15, -1.1992803358528796e-16, 4.9066150649352034e-18], [4.9066150649352034e-18, 1.1992803358528796e-16, 1.1890123875082528e-15, 5.243025691884206e-15, -4.518889607463727e-16, -1.1380528309214397e-13, -4.4216124098721056e-13, 2.0963631942348006e-13, 6.3349554409739135e-12, 1.3984157155376414e-11, -3.203398244123242e-11, -1.946164894082315e-10, -1.031411129096975e-10, 1.297205001469435e-09, 2.793974465953983e-09, -4.224485706362419e-09, -2.2521938367248057e-08, -5.3506575154614344e-09, 1.1090312322164394e-07, 1.5098853886715837e-07, -3.494948603445728e-07, -1.0021213992971776e-06, 4.854731396996412e-07, 4.3099415565970926e-06, 1.8499450031155903e-06, -1.3543277184167817e-05, -1.6391624961605832e-05, 3.09866292761993e-05, 7.055138782065466e-05, -4.336726125945695e-05, -0.00022089440324554938, -1.5344390231955034e-05, 0.0005490532773373631, 0.00032807884708801983, -0.0011114848653186302, -0.0012639342581174772, 0.0018168713438014236, 0.0033945232764083988, -0.0022480531870038246, -0.007387757452855584, 0.0015193057788333991, 0.013763981962894785, 0.0016904723834844238, -0.022618651544599473, -0.008833493890410233, 0.03352358406410097, 0.020972800592597547, -0.045807944151268334, -0.03825382947938425, 0.05925681563265897, 0.059567410871529954, -0.07504761994836018, -0.08233021190655741, 0.09660754061668439, 0.10178029683881418, -0.12992964695985376, -0.10845171382330178, 0.181962291778608, 0.08180602838721862, -0.2515232543602687, 0.01967150045235939, 0.29437591526266177, -0.24618042976108342, -0.13087896323302017, 0.4622075536616057, -0.5181670408556229, 0.36844097240030615, -0.18732633186206493, 0.0705848259771816, -0.01976228615387959, 0.0040241403682572865, -0.0005662418377066724, 4.942343750628132e-05, -2.0220608624983923e-06]], [[2.0220608624983923e-06, 4.942343750628132e-05, 0.0005662418377066724, 0.0040241403682572865, 0.01976228615387959, 0.0705848259771816, 0.18732633186206493, 0.36844097240030615, 0.5181670408556229, 0.4622075536616057, 0.13087896323302017, -0.24618042976108342, -0.29437591526266177, 0.01967150045235939, 0.2515232543602687, 0.08180602838721862, -0.181962291778608, -0.10845171382330178, 0.12992964695985376, 0.10178029683881418, -0.09660754061668439, -0.08233021190655741, 0.07504761994836018, 0.059567410871529954, -0.05925681563265897, -0.03825382947938425, 0.045807944151268334, 0.020972800592597547, -0.03352358406410097, -0.008833493890410233, 0.022618651544599473, 0.0016904723834844238, -0.013763981962894785, 0.0015193057788333991, 0.007387757452855584, -0.0022480531870038246, -0.0033945232764083988, 0.0018168713438014236, 0.0012639342581174772, -0.0011114848653186302, -0.00032807884708801983, 0.0005490532773373631, 1.5344390231955034e-05, -0.00022089440324554938, 4.336726125945695e-05, 7.055138782065466e-05, -3.09866292761993e-05, -1.6391624961605832e-05, 1.3543277184167817e-05, 1.8499450031155903e-06, -4.3099415565970926e-06, 4.854731396996412e-07, 1.0021213992971776e-06, -3.494948603445728e-07, -1.5098853886715837e-07, 1.1090312322164394e-07, 5.3506575154614344e-09, -2.2521938367248057e-08, 4.224485706362419e-09, 2.793974465953983e-09, -1.297205001469435e-09, -1.031411129096975e-10, 1.946164894082315e-10, -3.203398244123242e-11, -1.3984157155376414e-11, 6.3349554409739135e-12, -2.0963631942348006e-13, -4.4216124098721056e-13, 1.1380528309214397e-13, -4.518889607463727e-16, -5.243025691884206e-15, 1.1890123875082528e-15, -1.1992803358528796e-16, 4.9066150649352034e-18], [4.9066150649352034e-18, 1.1992803358528796e-16, 1.1890123875082528e-15, 5.243025691884206e-15, -4.518889607463727e-16, -1.1380528309214397e-13, -4.4216124098721056e-13, 2.0963631942348006e-13, 6.3349554409739135e-12, 1.3984157155376414e-11, -3.203398244123242e-11, -1.946164894082315e-10, -1.031411129096975e-10, 1.297205001469435e-09, 2.793974465953983e-09, -4.224485706362419e-09, -2.2521938367248057e-08, -5.3506575154614344e-09, 1.1090312322164394e-07, 1.5098853886715837e-07, -3.494948603445728e-07, -1.0021213992971776e-06, 4.854731396996412e-07, 4.3099415565970926e-06, 1.8499450031155903e-06, -1.3543277184167817e-05, -1.6391624961605832e-05, 3.09866292761993e-05, 7.055138782065466e-05, -4.336726125945695e-05, -0.00022089440324554938, -1.5344390231955034e-05, 0.0005490532773373631, 0.00032807884708801983, -0.0011114848653186302, -0.0012639342581174772, 0.0018168713438014236, 0.0033945232764083988, -0.0022480531870038246, -0.007387757452855584, 0.0015193057788333991, 0.013763981962894785, 0.0016904723834844238, -0.022618651544599473, -0.008833493890410233, 0.03352358406410097, 0.020972800592597547, -0.045807944151268334, -0.03825382947938425, 0.05925681563265897, 0.059567410871529954, -0.07504761994836018, -0.08233021190655741, 0.09660754061668439, 0.10178029683881418, -0.12992964695985376, -0.10845171382330178, 0.181962291778608, 0.08180602838721862, -0.2515232543602687, 0.01967150045235939, 0.29437591526266177, -0.24618042976108342, -0.13087896323302017, 0.4622075536616057, -0.5181670408556229, 0.36844097240030615, -0.18732633186206493, 0.0705848259771816, -0.01976228615387959, 0.0040241403682572865, -0.0005662418377066724, 4.942343750628132e-05, -2.0220608624983923e-06]]], "db38": [[[1.4257766416741318e-06, 3.576251994264023e-05, 0.00042117026647271163, 0.0030830881192537517, 0.015637249347572157, 0.057889943612859256, 0.1600719935641107, 0.33077578141101466, 0.4965911753117181, 0.4933560785171008, 0.2130505713555785, -0.1828676677083359, -0.3216756378089979, -0.06226650604782432, 0.2321259638353531, 0.14998511961871702, -0.1417956859730596, -0.15991256515824437, 0.08563812155615105, 0.14141473407338268, -0.05658645863072738, -0.11473117071074437, 0.04309589543304764, 0.08720439826203975, -0.036605103402874296, -0.06176620870841316, 0.03198987753153781, 0.04005498110511595, -0.026891493880894516, -0.023114134020549317, 0.020904645255655243, 0.011290497278685965, -0.014701882065398682, -0.004131306656031089, 0.00921478503219718, 0.0005625715748403532, -0.005071314509218348, 0.0007169821821064019, 0.0024006977818909732, -0.0008448626665537775, -0.0009424614077227377, 0.0005810759750532864, 0.00028176392503806707, -0.0003031020460726612, -4.55568269666842e-05, 0.00012620433501661708, -1.1554091038337172e-05, -4.175141648540398e-05, 1.3341761499213504e-05, 1.0373591840455998e-05, -6.456730428469619e-06, -1.5508443501186026e-06, 2.1499602699396653e-06, -8.487087586072593e-08, -5.187733738874145e-07, 1.3963775455083553e-07, 8.400351046895966e-08, -4.8847579374592866e-08, -5.424274800287298e-09, 1.0347045392748585e-08, -1.4363294877951358e-09, -1.3491977539834489e-09, 5.261132557357599e-10, 6.732336490189309e-11, -8.278256522538134e-11, 1.1016929345994545e-11, 6.291537317039508e-12, -2.4847892375636427e-12, 2.626496504065252e-14, 1.8086612362745306e-13, -4.249817819571463e-14, -4.563397162127374e-16, 2.0450996767889887e-15, -4.405307042483461e-16, 4.3045968395587903e-17, -1.7161524510887442e-18], [-1.7161524510887442e-18, -4.3045968395587903e-17, -4.405307042483461e-16, -2.0450996767889887e-15, -4.563397162127374e-16, 4.249817819571463e-14, 1.8086612362745306e-13, -2.626496504065252e-14, -2.4847892375636427e-12, -6.291537317039508e-12, 1.1016929345994545e-11, 8.278256522538134e-11, 6.732336490189309e-11, -5.261132557357599e-10, -1.3491977539834489e-09, 1.4363294877951358e-09, 1.0347045392748585e-08, 5.424274800287298e-09, -4.8847579374592866e-08, -8.400351046895966e-08, 1.3963775455083553e-07, 5.187733738874145e-07, -8.487087586072593e-08, -2.1499602699396653e-06, -1.5508443501186026e-06, 6.456730428469619e-06, 1.0373591840455998e-05, -1.3341761499213504e-05, -4.175141648540398e-05, 1.1554091038337172e-05, 0.00012620433501661708, 4.55568269666842e-05, -0.0003031020460726612, -0.00028176392503806707, 0.0005810759750532864, 0.0009424614077227377, -0.0008448626665537775, -0.0024006977818909732, 0.0007169821821064019, 0.005071314509218348, 0.0005625715748403532, -0.00921478503219718, -0.004131306656031089, 0.014701882065398682, 0.011290497278685965, -0.020904645255655243, -0.023114134020549317, 0.026891493880894516, 0.04005498110511595, -0.03198987753153781, -0.06176620870841316, 0.036605103402874296, 0.08720439826203975, -0.04309589543304764, -0.11473117071074437, 0.05658645863072738, 0.14141473407338268, -0.08563812155615105, -0.15991256515824437, 0.1417956859730596, 0.14998511961871702, -0.2321259638353531, -0.06226650604782432, 0.3216756378089979, -0.1828676677083359, -0.2130505713555785, 0.4933560785171008, -0.4965911753117181, 0.33077578141101466, -0.1600719935641107, 0.057889943612859256, -0.015637249347572157, 0.0030830881192537517, -0.00042117026647271163, 3.576251994264023e-05, -1.4257766416741318e-06]], [[1.4257766416741318e-06, 3.576251994264023e-05, 0.00042117026647271163, 0.0030830881192537517, 0.015637249347572157, 0.057889943612859256, 0.1600719935641107, 0.33077578141101466, 0.4965911753117181, 0.4933560785171008, 0.2130505713555785, -0.1828676677083359, -0.3216756378089979, -0.06226650604782432, 0.2321259638353531, 0.14998511961871702, -0.1417956859730596, -0.15991256515824437, 0.08563812155615105, 0.14141473407338268, -0.05658645863072738, -0.11473117071074437, 0.04309589543304764, 0.08720439826203975, -0.036605103402874296, -0.06176620870841316, 0.03198987753153781, 0.04005498110511595, -0.026891493880894516, -0.023114134020549317, 0.020904645255655243, 0.011290497278685965, -0.014701882065398682, -0.004131306656031089, 0.00921478503219718, 0.0005625715748403532, -0.005071314509218348, 0.0007169821821064019, 0.0024006977818909732, -0.0008448626665537775, -0.0009424614077227377, 0.0005810759750532864, 0.00028176392503806707, -0.0003031020460726612, -4.55568269666842e-05, 0.00012620433501661708, -1.1554091038337172e-05, -4.175141648540398e-05, 1.3341761499213504e-05, 1.0373591840455998e-05, -6.456730428469619e-06, -1.5508443501186026e-06, 2.1499602699396653e-06, -8.487087586072593e-08, -5.187733738874145e-07, 1.3963775455083553e-07, 8.400351046895966e-08, -4.8847579374592866e-08, -5.424274800287298e-09, 1.0347045392748585e-08, -1.4363294877951358e-09, -1.3491977539834489e-09, 5.261132557357599e-10, 6.732336490189309e-11, -8.278256522538134e-11, 1.1016929345994545e-11, 6.291537317039508e-12, -2.4847892375636427e-12, 2.626496504065252e-14, 1.8086612362745306e-13, -4.249817819571463e-14, -4.563397162127374e-16, 2.0450996767889887e-15, -4.405307042483461e-16, 4.3045968395587903e-17, -1.7161524510887442e-18], [-1.7161524510887442e-18, -4.3045968395587903e-17, -4.405307042483461e-16, -2.0450996767889887e-15, -4.563397162127374e-16, 4.249817819571463e-14, 1.8086612362745306e-13, -2.626496504065252e-14, -2.4847892375636427e-12, -6.291537317039508e-12, 1.1016929345994545e-11, 8.278256522538134e-11, 6.732336490189309e-11, -5.261132557357599e-10, -1.3491977539834489e-09, 1.4363294877951358e-09, 1.0347045392748585e-08, 5.424274800287298e-09, -4.8847579374592866e-08, -8.400351046895966e-08, 1.3963775455083553e-07, 5.187733738874145e-07, -8.487087586072593e-08, -2.1499602699396653e-06, -1.5508443501186026e-06, 6.456730428469619e-06, 1.0373591840455998e-05, -1.3341761499213504e-05, -4.175141648540398e-05, 1.1554091038337172e-05, 0.00012620433501661708, 4.55568269666842e-05, -0.0003031020460726612, -0.00028176392503806707, 0.0005810759750532864, 0.0009424614077227377, -0.0008448626665537775, -0.0024006977818909732, 0.0007169821821064019, 0.005071314509218348, 0.0005625715748403532, -0.00921478503219718, -0.004131306656031089, 0.014701882065398682, 0.011290497278685965, -0.020904645255655243, -0.023114134020549317, 0.026891493880894516, 0.04005498110511595, -0.03198987753153781, -0.06176620870841316, 0.036605103402874296, 0.08720439826203975, -0.04309589543304764, -0.11473117071074437, 0.05658645863072738, 0.14141473407338268, -0.08563812155615105, -0.15991256515824437, 0.1417956859730596, 0.14998511961871702, -0.2321259638353531, -0.06226650604782432, 0.3216756378089979, -0.1828676677083359, -0.2130505713555785, 0.4933560785171008, -0.4965911753117181, 0.33077578141101466, -0.1600719935641107, 0.057889943612859256, -0.015637249347572157, 0.0030830881192537517, -0.00042117026647271163, 3.576251994264023e-05, -1.4257766416741318e-06]]], "sym2": [[[0.48296291314469025, 0.836516303737469, 0.22414386804185735, -0.12940952255092145], [-0.12940952255092145, -0.22414386804185735, 0.836516303737469, -0.48296291314469025]], [[0.48296291314469025, 0.836516303737469, 0.22414386804185735, -0.12940952255092145], [-0.12940952255092145, -0.22414386804185735, 0.836516303737469, -0.48296291314469025]]], "sym3": [[[0.3326705529509569, 0.8068915093133388, 0.4598775021193313, -0.13501102001039084, -0.08544127388224149, 0.035226291882100656], [0.035226291882100656, 0.08544127388224149, -0.13501102001039084, -0.4598775021193313, 0.8068915093133388, -0.3326705529509569]], [[0.3326705529509569, 0.8068915093133388, 0.4598775021193313, -0.13501102001039084, -0.08544127388224149, 0.035226291882100656], [0.035226291882100656, 0.08544127388224149, -0.13501102001039084, -0.4598775021193313, 0.8068915093133388, -0.3326705529509569]]], "sym4": [[[0.0322231006040427, -0.012603967262037833, -0.09921954357684722, 0.29785779560527736, 0.8037387518059161, 0.49761866763201545, -0.02963552764599851, -0.07576571478927333], [-0.07576571478927333, 0.02963552764599851, 0.49761866763201545, -0.8037387518059161, 0.29785779560527736, 0.09921954357684722, -0.012603967262037833, -0.0322231006040427]], [[0.0322231006040427, -0.012603967262037833, -0.09921954357684722, 0.29785779560527736, 0.8037387518059161, 0.49761866763201545, -0.02963552764599851, -0.07576571478927333], [-0.07576571478927333, 0.02963552764599851, 0.49761866763201545, -0.8037387518059161, 0.29785779560527736, 0.09921954357684722, -0.012603967262037833, -0.0322231006040427]]], "sym5": [[[0.019538882735286728, -0.021101834024758855, -0.17532808990845047, 0.01660210576452232, 0.6339789634582119, 0.7234076904024206, 0.1993975339773936, -0.039134249302383094, 0.029519490925774643, 0.027333068345077982], [0.027333068345077982, -0.029519490925774643, -0.039134249302383094, -0.1993975339773936, 0.7234076904024206, -0.6339789634582119, 0.01660210576452232, 0.17532808990845047, -0.021101834024758855, -0.019538882735286728]], [[0.019538882735286728, -0.021101834024758855, -0.17532808990845047, 0.01660210576452232, 0.6339789634582119, 0.7234076904024206, 0.1993975339773936, -0.039134249302383094, 0.029519490925774643, 0.027333068345077982], [0.027333068345077982, -0.029519490925774643, -0.039134249302383094, -0.1993975339773936, 0.7234076904024206, -0.6339789634582119, 0.01660210576452232, 0.17532808990845047, -0.021101834024758855, -0.019538882735286728]]], "sym6": [[[-0.007800708325034148, 0.0017677118642428036, 0.04472490177066578, -0.021060292512300564, -0.07263752278646252, 0.3379294217276218, 0.787641141030194, 0.4910559419267466, -0.048311742585633, -0.11799011114819057, 0.0034907120842174702, 0.015404109327027373], [0.015404109327027373, -0.0034907120842174702, -0.11799011114819057, 0.048311742585633, 0.4910559419267466, -0.787641141030194, 0.3379294217276218, 0.07263752278646252, -0.021060292512300564, -0.04472490177066578, 0.0017677118642428036, 0.007800708325034148]], [[-0.007800708325034148, 0.0017677118642428036, 0.04472490177066578, -0.021060292512300564, -0.07263752278646252, 0.3379294217276218, 0.787641141030194, 0.4910559419267466, -0.048311742585633, -0.11799011114819057, 0.0034907120842174702, 0.015404109327027373], [0.015404109327027373, -0.0034907120842174702, -0.11799011114819057, 0.048311742585633, 0.4910559419267466, -0.787641141030194, 0.3379294217276218, 0.07263752278646252, -0.021060292512300564, -0.04472490177066578, 0.0017677118642428036, 0.007800708325034148]]], "sym7": [[[0.010268176708511255, 0.004010244871533663, -0.10780823770381774, -0.14004724044296152, 0.2886296317515146, 0.767764317003164, 0.5361019170917628, 0.017441255086855827, -0.049552834937127255, 0.0678926935013727, 0.03051551316596357, -0.01263630340325193, -0.0010473848886829163, 0.002681814568257878], [0.002681814568257878, 0.0010473848886829163, -0.01263630340325193, -0.03051551316596357, 0.0678926935013727, 0.049552834937127255, 0.017441255086855827, -0.5361019170917628, 0.767764317003164, -0.2886296317515146, -0.14004724044296152, 0.10780823770381774, 0.004010244871533663, -0.010268176708511255]], [[0.010268176708511255, 0.004010244871533663, -0.10780823770381774, -0.14004724044296152, 0.2886296317515146, 0.767764317003164, 0.5361019170917628, 0.017441255086855827, -0.049552834937127255, 0.0678926935013727, 0.03051551316596357, -0.01263630340325193, -0.0010473848886829163, 0.002681814568257878], [0.002681814568257878, 0.0010473848886829163, -0.01263630340325193, -0.03051551316596357, 0.0678926935013727, 0.049552834937127255, 0.017441255086855827, -0.5361019170917628, 0.767764317003164, -0.2886296317515146, -0.14004724044296152, 0.10780823770381774, 0.004010244871533663, -0.010268176708511255]]], "sym8": [[[0.0018899503327594609, -0.0003029205147213668, -0.01495225833704823, 0.003808752013890615, 0.049137179673607506, -0.027219029917056003, -0.05194583810770904, 0.3644418948353314, 0.7771857517005235, 0.4813596512583722, -0.061273359067658524, -0.1432942383508097, 0.007607487324917605, 0.03169508781149298, -0.0005421323317911481, -0.0033824159510061256], [-0.0033824159510061256, 0.0005421323317911481, 0.03169508781149298, -0.007607487324917605, -0.1432942383508097, 0.061273359067658524, 0.4813596512583722, -0.7771857517005235, 0.3644418948353314, 0.05194583810770904, -0.027219029917056003, -0.049137179673607506, 0.003808752013890615, 0.01495225833704823, -0.0003029205147213668, -0.0018899503327594609]], [[0.0018899503327594609, -0.0003029205147213668, -0.01495225833704823, 0.003808752013890615, 0.049137179673607506, -0.027219029917056003, -0.05194583810770904, 0.3644418948353314, 0.7771857517005235, 0.4813596512583722, -0.061273359067658524, -0.1432942383508097, 0.007607487324917605, 0.03169508781149298, -0.0005421323317911481, -0.0033824159510061256], [-0.0033824159510061256, 0.0005421323317911481, 0.03169508781149298, -0.007607487324917605, -0.1432942383508097, 0.061273359067658524, 0.4813596512583722, -0.7771857517005235, 0.3644418948353314, 0.05194583810770904, -0.027219029917056003, -0.049137179673607506, 0.003808752013890615, 0.01495225833704823, -0.0003029205147213668, -0.0018899503327594609]]], "sym9": [[[0.0010694900329086053, -0.0004731544986800831, -0.010264064027633142, 0.008859267493400484, 0.06207778930288603, -0.018233770779395985, -0.19155083129728512, 0.035272488035271894, 0.6173384491409358, 0.717897082764412, 0.238760914607303, -0.05456895843083407, 0.0005834627461258068, 0.03022487885827568, -0.01152821020767923, -0.013271967781817119, 0.0006197808889855868, 0.0014009155259146807], [0.0014009155259146807, -0.0006197808889855868, -0.013271967781817119, 0.01152821020767923, 0.03022487885827568, -0.0005834627461258068, -0.05456895843083407, -0.238760914607303, 0.717897082764412, -0.6173384491409358, 0.035272488035271894, 0.19155083129728512, -0.018233770779395985, -0.06207778930288603, 0.008859267493400484, 0.010264064027633142, -0.0004731544986800831, -0.0010694900329086053]], [[0.0010694900329086053, -0.0004731544986800831, -0.010264064027633142, 0.008859267493400484, 0.06207778930288603, -0.018233770779395985, -0.19155083129728512, 0.035272488035271894, 0.6173384491409358, 0.717897082764412, 0.238760914607303, -0.05456895843083407, 0.0005834627461258068, 0.03022487885827568, -0.01152821020767923, -0.013271967781817119, 0.0006197808889855868, 0.0014009155259146807], [0.0014009155259146807, -0.0006197808889855868, -0.013271967781817119, 0.01152821020767923, 0.03022487885827568, -0.0005834627461258068, -0.05456895843083407, -0.238760914607303, 0.717897082764412, -0.6173384491409358, 0.035272488035271894, 0.19155083129728512, -0.018233770779395985, -0.06207778930288603, 0.008859267493400484, 0.010264064027633142, -0.0004731544986800831, -0.0010694900329086053]]], "sym10": [[[-0.0004593294210046588, 5.7036083618494284e-05, 0.004593173585311828, -0.0008043589320165449, -0.02035493981231129, 0.005764912033581909, 0.04999497207737669, -0.0319900568824278, -0.03553674047381755, 0.38382676106708546, 0.7695100370211071, 0.47169066693843925, -0.07088053578324385, -0.15949427888491757, 0.011609893903711381, 0.0459272392310922, -0.0014653825813050513, -0.008641299277022422, 9.563267072289475e-05, 0.0007701598091144901], [0.0007701598091144901, -9.563267072289475e-05, -0.008641299277022422, 0.0014653825813050513, 0.0459272392310922, -0.011609893903711381, -0.15949427888491757, 0.07088053578324385, 0.47169066693843925, -0.7695100370211071, 0.38382676106708546, 0.03553674047381755, -0.0319900568824278, -0.04999497207737669, 0.005764912033581909, 0.02035493981231129, -0.0008043589320165449, -0.004593173585311828, 5.7036083618494284e-05, 0.0004593294210046588]], [[-0.0004593294210046588, 5.7036083618494284e-05, 0.004593173585311828, -0.0008043589320165449, -0.02035493981231129, 0.005764912033581909, 0.04999497207737669, -0.0319900568824278, -0.03553674047381755, 0.38382676106708546, 0.7695100370211071, 0.47169066693843925, -0.07088053578324385, -0.15949427888491757, 0.011609893903711381, 0.0459272392310922, -0.0014653825813050513, -0.008641299277022422, 9.563267072289475e-05, 0.0007701598091144901], [0.0007701598091144901, -9.563267072289475e-05, -0.008641299277022422, 0.0014653825813050513, 0.0459272392310922, -0.011609893903711381, -0.15949427888491757, 0.07088053578324385, 0.47169066693843925, -0.7695100370211071, 0.38382676106708546, 0.03553674047381755, -0.0319900568824278, -0.04999497207737669, 0.005764912033581909, 0.02035493981231129, -0.0008043589320165449, -0.004593173585311828, 5.7036083618494284e-05, 0.0004593294210046588]]], "sym11": [[[0.0004892636102619239, 0.00011053509764272153, -0.006389603666454892, -0.0020034719001093887, 0.04300019068155228, 0.03526675956446655, -0.1446023437053156, -0.2046547944958006, 0.23768990904924897, 0.7303435490883957, 0.5720229780100871, 0.09719839445890947, -0.022832651022562687, 0.06997679961073414, 0.0370374159788594, -0.024080841595864003, -0.009857934828789794, 0.00651249567477145, 0.0005883527353969915, -0.0017343662672978692, -3.8795655736158566e-05, 0.00017172195069934854], [0.00017172195069934854, 3.8795655736158566e-05, -0.0017343662672978692, -0.0005883527353969915, 0.00651249567477145, 0.009857934828789794, -0.024080841595864003, -0.0370374159788594, 0.06997679961073414, 0.022832651022562687, 0.09719839445890947, -0.5720229780100871, 0.7303435490883957, -0.23768990904924897, -0.2046547944958006, 0.1446023437053156, 0.03526675956446655, -0.04300019068155228, -0.0020034719001093887, 0.006389603666454892, 0.00011053509764272153, -0.0004892636102619239]], [[0.0004892636102619239, 0.00011053509764272153, -0.006389603666454892, -0.0020034719001093887, 0.04300019068155228, 0.03526675956446655, -0.1446023437053156, -0.2046547944958006, 0.23768990904924897, 0.7303435490883957, 0.5720229780100871, 0.09719839445890947, -0.022832651022562687, 0.06997679961073414, 0.0370374159788594, -0.024080841595864003, -0.009857934828789794, 0.00651249567477145, 0.0005883527353969915, -0.0017343662672978692, -3.8795655736158566e-05, 0.00017172195069934854], [0.00017172195069934854, 3.8795655736158566e-05, -0.0017343662672978692, -0.0005883527353969915, 0.00651249567477145, 0.009857934828789794, -0.024080841595864003, -0.0370374159788594, 0.06997679961073414, 0.022832651022562687, 0.09719839445890947, -0.5720229780100871, 0.7303435490883957, -0.23768990904924897, -0.2046547944958006, 0.1446023437053156, 0.03526675956446655, -0.04300019068155228, -0.0020034719001093887, 0.006389603666454892, 0.00011053509764272153, -0.0004892636102619239]]], "sym12": [[[-0.0001790665869750869, -1.8158078862617515e-05, 0.002350297614183465, 0.00030764779631059454, -0.014589836449234145, -0.0026043910313322326, 0.05780417944550566, 0.01530174062247884, -0.17037069723886492, -0.07833262231634322, 0.46274103121927235, 0.7634790977836572, 0.39888597239022, -0.022162306170337816, -0.03584883073695439, 0.04917931829966084, 0.0075537806116804775, -0.024220722675013445, -0.0014089092443297553, 0.007414965517654251, 0.00018021409008538188, -0.0013497557555715387, -1.1353928041541452e-05, 0.00011196719424656033], [0.00011196719424656033, 1.1353928041541452e-05, -0.0013497557555715387, -0.00018021409008538188, 0.007414965517654251, 0.0014089092443297553, -0.024220722675013445, -0.0075537806116804775, 0.04917931829966084, 0.03584883073695439, -0.022162306170337816, -0.39888597239022, 0.7634790977836572, -0.46274103121927235, -0.07833262231634322, 0.17037069723886492, 0.01530174062247884, -0.05780417944550566, -0.0026043910313322326, 0.014589836449234145, 0.00030764779631059454, -0.002350297614183465, -1.8158078862617515e-05, 0.0001790665869750869]], [[-0.0001790665869750869, -1.8158078862617515e-05, 0.002350297614183465, 0.00030764779631059454, -0.014589836449234145, -0.0026043910313322326, 0.05780417944550566, 0.01530174062247884, -0.17037069723886492, -0.07833262231634322, 0.46274103121927235, 0.7634790977836572, 0.39888597239022, -0.022162306170337816, -0.03584883073695439, 0.04917931829966084, 0.0075537806116804775, -0.024220722675013445, -0.0014089092443297553, 0.007414965517654251, 0.00018021409008538188, -0.0013497557555715387, -1.1353928041541452e-05, 0.00011196719424656033], [0.00011196719424656033, 1.1353928041541452e-05, -0.0013497557555715387, -0.00018021409008538188, 0.007414965517654251, 0.0014089092443297553, -0.024220722675013445, -0.0075537806116804775, 0.04917931829966084, 0.03584883073695439, -0.022162306170337816, -0.39888597239022, 0.7634790977836572, -0.46274103121927235, -0.07833262231634322, 0.17037069723886492, 0.01530174062247884, -0.05780417944550566, -0.0026043910313322326, 0.014589836449234145, 0.00030764779631059454, -0.002350297614183465, -1.8158078862617515e-05, 0.0001790665869750869]]], "sym13": [[[7.042986690694402e-05, 3.690537342319624e-05, -0.0007213643851362283, 0.00041326119884196064, 0.0056748537601224395, -0.0014924472742598532, -0.020749686325515677, 0.017618296880653084, 0.09292603089913712, 0.008819757670420546, -0.14049009311363403, 0.11023022302137217, 0.6445643839011856, 0.6957391505614964, 0.19770481877117801, -0.12436246075153011, -0.0597506277179437, 0.013862497435849205, -0.017211642726299048, -0.02021676813338983, 0.005296359738725025, 0.0075262253899681, -0.0001709428585302221, -0.0011360634389281183, -3.573862364868901e-05, 6.820325263075319e-05], [6.820325263075319e-05, 3.573862364868901e-05, -0.0011360634389281183, 0.0001709428585302221, 0.0075262253899681, -0.005296359738725025, -0.02021676813338983, 0.017211642726299048, 0.013862497435849205, 0.0597506277179437, -0.12436246075153011, -0.19770481877117801, 0.6957391505614964, -0.6445643839011856, 0.11023022302137217, 0.14049009311363403, 0.008819757670420546, -0.09292603089913712, 0.017618296880653084, 0.020749686325515677, -0.0014924472742598532, -0.0056748537601224395, 0.00041326119884196064, 0.0007213643851362283, 3.690537342319624e-05, -7.042986690694402e-05]], [[7.042986690694402e-05, 3.690537342319624e-05, -0.0007213643851362283, 0.00041326119884196064, 0.0056748537601224395, -0.0014924472742598532, -0.020749686325515677, 0.017618296880653084, 0.09292603089913712, 0.008819757670420546, -0.14049009311363403, 0.11023022302137217, 0.6445643839011856, 0.6957391505614964, 0.19770481877117801, -0.12436246075153011, -0.0597506277179437, 0.013862497435849205, -0.017211642726299048, -0.02021676813338983, 0.005296359738725025, 0.0075262253899681, -0.0001709428585302221, -0.0011360634389281183, -3.573862364868901e-05, 6.820325263075319e-05], [6.820325263075319e-05, 3.573862364868901e-05, -0.0011360634389281183, 0.0001709428585302221, 0.0075262253899681, -0.005296359738725025, -0.02021676813338983, 0.017211642726299048, 0.013862497435849205, 0.0597506277179437, -0.12436246075153011, -0.19770481877117801, 0.6957391505614964, -0.6445643839011856, 0.11023022302137217, 0.14049009311363403, 0.008819757670420546, -0.09292603089913712, 0.017618296880653084, 0.020749686325515677, -0.0014924472742598532, -0.0056748537601224395, 0.00041326119884196064, 0.0007213643851362283, 3.690537342319624e-05, -7.042986690694402e-05]]], "sym14": [[[4.4618977991475265e-05, 1.9329016965523917e-05, -0.0006057601824664335, -7.321421356702399e-05, 0.004532677471945648, 0.0010131419871842082, -0.019439314263626713, -0.002365048836740385, 0.06982761636180755, 0.02589858753104667, -0.15999741114652205, -0.05811182331771783, 0.4753357626342066, 0.7599762419610909, 0.39320152196208885, -0.03531811211497973, -0.057634498351326995, 0.03743308836285345, 0.004280520499019378, -0.029196217764038187, -0.002753774791224071, 0.01003769371767227, 0.0003664765736601183, -0.002579441725933078, -6.286542481477636e-05, 0.00039843567297594335, 1.1210865808890361e-05, -2.5879090265397886e-05], [-2.5879090265397886e-05, -1.1210865808890361e-05, 0.00039843567297594335, 6.286542481477636e-05, -0.002579441725933078, -0.0003664765736601183, 0.01003769371767227, 0.002753774791224071, -0.029196217764038187, -0.004280520499019378, 0.03743308836285345, 0.057634498351326995, -0.03531811211497973, -0.39320152196208885, 0.7599762419610909, -0.4753357626342066, -0.05811182331771783, 0.15999741114652205, 0.02589858753104667, -0.06982761636180755, -0.002365048836740385, 0.019439314263626713, 0.0010131419871842082, -0.004532677471945648, -7.321421356702399e-05, 0.0006057601824664335, 1.9329016965523917e-05, -4.4618977991475265e-05]], [[4.4618977991475265e-05, 1.9329016965523917e-05, -0.0006057601824664335, -7.321421356702399e-05, 0.004532677471945648, 0.0010131419871842082, -0.019439314263626713, -0.002365048836740385, 0.06982761636180755, 0.02589858753104667, -0.15999741114652205, -0.05811182331771783, 0.4753357626342066, 0.7599762419610909, 0.39320152196208885, -0.03531811211497973, -0.057634498351326995, 0.03743308836285345, 0.004280520499019378, -0.029196217764038187, -0.002753774791224071, 0.01003769371767227, 0.0003664765736601183, -0.002579441725933078, -6.286542481477636e-05, 0.00039843567297594335, 1.1210865808890361e-05, -2.5879090265397886e-05], [-2.5879090265397886e-05, -1.1210865808890361e-05, 0.00039843567297594335, 6.286542481477636e-05, -0.002579441725933078, -0.0003664765736601183, 0.01003769371767227, 0.002753774791224071, -0.029196217764038187, -0.004280520499019378, 0.03743308836285345, 0.057634498351326995, -0.03531811211497973, -0.39320152196208885, 0.7599762419610909, -0.4753357626342066, -0.05811182331771783, 0.15999741114652205, 0.02589858753104667, -0.06982761636180755, -0.002365048836740385, 0.019439314263626713, 0.0010131419871842082, -0.004532677471945648, -7.321421356702399e-05, 0.0006057601824664335, 1.9329016965523917e-05, -4.4618977991475265e-05]]], "sym15": [[[2.866070852531808e-05, 2.171789015077892e-05, -0.00040216853760293483, -0.00010815440168545525, 0.003481028737064895, 0.0015261382781819983, -0.01717125278163873, -0.008744788886477952, 0.06796982904487918, 0.06839331006048024, -0.1340562984562539, -0.1966263587662373, 0.2439627054321663, 0.7218430296361812, 0.5786404152150345, 0.11153369514261872, -0.04108266663538248, 0.04073547969681068, 0.021937642719753955, -0.03887671687683349, -0.01940501143093447, 0.01007997708790567, 0.003423450736351241, -0.0035901654473726417, -0.0002673164464718057, 0.0010705672194623959, 5.512254785558665e-05, -0.00016066186637495343, -7.35966679891947e-06, 9.712419737963348e-06], [9.712419737963348e-06, 7.35966679891947e-06, -0.00016066186637495343, -5.512254785558665e-05, 0.0010705672194623959, 0.0002673164464718057, -0.0035901654473726417, -0.003423450736351241, 0.01007997708790567, 0.01940501143093447, -0.03887671687683349, -0.021937642719753955, 0.04073547969681068, 0.04108266663538248, 0.11153369514261872, -0.5786404152150345, 0.7218430296361812, -0.2439627054321663, -0.1966263587662373, 0.1340562984562539, 0.06839331006048024, -0.06796982904487918, -0.008744788886477952, 0.01717125278163873, 0.0015261382781819983, -0.003481028737064895, -0.00010815440168545525, 0.00040216853760293483, 2.171789015077892e-05, -2.866070852531808e-05]], [[2.866070852531808e-05, 2.171789015077892e-05, -0.00040216853760293483, -0.00010815440168545525, 0.003481028737064895, 0.0015261382781819983, -0.01717125278163873, -0.008744788886477952, 0.06796982904487918, 0.06839331006048024, -0.1340562984562539, -0.1966263587662373, 0.2439627054321663, 0.7218430296361812, 0.5786404152150345, 0.11153369514261872, -0.04108266663538248, 0.04073547969681068, 0.021937642719753955, -0.03887671687683349, -0.01940501143093447, 0.01007997708790567, 0.003423450736351241, -0.0035901654473726417, -0.0002673164464718057, 0.0010705672194623959, 5.512254785558665e-05, -0.00016066186637495343, -7.35966679891947e-06, 9.712419737963348e-06], [9.712419737963348e-06, 7.35966679891947e-06, -0.00016066186637495343, -5.512254785558665e-05, 0.0010705672194623959, 0.0002673164464718057, -0.0035901654473726417, -0.003423450736351241, 0.01007997708790567, 0.01940501143093447, -0.03887671687683349, -0.021937642719753955, 0.04073547969681068, 0.04108266663538248, 0.11153369514261872, -0.5786404152150345, 0.7218430296361812, -0.2439627054321663, -0.1966263587662373, 0.1340562984562539, 0.06839331006048024, -0.06796982904487918, -0.008744788886477952, 0.01717125278163873, 0.0015261382781819983, -0.003481028737064895, -0.00010815440168545525, 0.00040216853760293483, 2.171789015077892e-05, -2.866070852531808e-05]]], "sym16": [[[-1.0797982104319795e-05, -5.396483179315242e-06, 0.00016545679579108483, 3.656592483348223e-05, -0.0013387206066921965, -0.00022211647621176323, 0.0069377611308027096, 0.001359844742484172, -0.024952758046290123, -0.003510275068374009, 0.07803785290341991, 0.03072113906330156, -0.15959219218520598, -0.054040601387606135, 0.47534280601152273, 0.7565249878756971, 0.39712293362064416, -0.034574228416972504, -0.06698304907021778, 0.032333091610663785, 0.004869274404904607, -0.031051202843553064, -0.0031265171722710075, 0.012666731659857348, 0.0007182119788317892, -0.0038809122526038786, -0.0001084456223089688, 0.0008523547108047095, 2.8078582128442894e-05, -0.00010943147929529757, -3.113556407621969e-06, 6.230006701220761e-06], [6.230006701220761e-06, 3.113556407621969e-06, -0.00010943147929529757, -2.8078582128442894e-05, 0.0008523547108047095, 0.0001084456223089688, -0.0038809122526038786, -0.0007182119788317892, 0.012666731659857348, 0.0031265171722710075, -0.031051202843553064, -0.004869274404904607, 0.032333091610663785, 0.06698304907021778, -0.034574228416972504, -0.39712293362064416, 0.7565249878756971, -0.47534280601152273, -0.054040601387606135, 0.15959219218520598, 0.03072113906330156, -0.07803785290341991, -0.003510275068374009, 0.024952758046290123, 0.001359844742484172, -0.0069377611308027096, -0.00022211647621176323, 0.0013387206066921965, 3.656592483348223e-05, -0.00016545679579108483, -5.396483179315242e-06, 1.0797982104319795e-05]], [[-1.0797982104319795e-05, -5.396483179315242e-06, 0.00016545679579108483, 3.656592483348223e-05, -0.0013387206066921965, -0.00022211647621176323, 0.0069377611308027096, 0.001359844742484172, -0.024952758046290123, -0.003510275068374009, 0.07803785290341991, 0.03072113906330156, -0.15959219218520598, -0.054040601387606135, 0.47534280601152273, 0.7565249878756971, 0.39712293362064416, -0.034574228416972504, -0.06698304907021778, 0.032333091610663785, 0.004869274404904607, -0.031051202843553064, -0.0031265171722710075, 0.012666731659857348, 0.0007182119788317892, -0.0038809122526038786, -0.0001084456223089688, 0.0008523547108047095, 2.8078582128442894e-05, -0.00010943147929529757, -3.113556407621969e-06, 6.230006701220761e-06], [6.230006701220761e-06, 3.113556407621969e-06, -0.00010943147929529757, -2.8078582128442894e-05, 0.0008523547108047095, 0.0001084456223089688, -0.0038809122526038786, -0.0007182119788317892, 0.012666731659857348, 0.0031265171722710075, -0.031051202843553064, -0.004869274404904607, 0.032333091610663785, 0.06698304907021778, -0.034574228416972504, -0.39712293362064416, 0.7565249878756971, -0.47534280601152273, -0.054040601387606135, 0.15959219218520598, 0.03072113906330156, -0.07803785290341991, -0.003510275068374009, 0.024952758046290123, 0.001359844742484172, -0.0069377611308027096, -0.00022211647621176323, 0.0013387206066921965, 3.656592483348223e-05, -0.00016545679579108483, -5.396483179315242e-06, 1.0797982104319795e-05]]], "sym17": [[[3.7912531943321266e-06, -2.4527163425833e-06, -7.607124405605129e-05, 2.520793314082878e-05, 0.0007198270642148971, 5.8400428694052584e-05, -0.003932325279797902, -0.001905407689852666, 0.012396988366648726, 0.009952982523509598, -0.01803889724191924, -0.007261634750928767, 0.016158808725919346, -0.08607087472073338, -0.15507600534974825, 0.18053958458111286, 0.681488995344925, 0.6507166292045456, 0.1423983504146782, -0.11856693261143636, 0.0172711782105185, 0.10475461484223211, 0.01790395221434112, -0.03329138349235933, -0.004819212803176148, 0.010482366933031529, 0.0008567700701915741, -0.0027416759756816018, -0.000138642302680455, 0.0004759963802638669, -1.3506383399901165e-05, -6.293702597554192e-05, 2.7801266938414138e-06, 4.297343327345983e-06], [4.297343327345983e-06, -2.7801266938414138e-06, -6.293702597554192e-05, 1.3506383399901165e-05, 0.0004759963802638669, 0.000138642302680455, -0.0027416759756816018, -0.0008567700701915741, 0.010482366933031529, 0.004819212803176148, -0.03329138349235933, -0.01790395221434112, 0.10475461484223211, -0.0172711782105185, -0.11856693261143636, -0.1423983504146782, 0.6507166292045456, -0.681488995344925, 0.18053958458111286, 0.15507600534974825, -0.08607087472073338, -0.016158808725919346, -0.007261634750928767, 0.01803889724191924, 0.009952982523509598, -0.012396988366648726, -0.001905407689852666, 0.003932325279797902, 5.8400428694052584e-05, -0.0007198270642148971, 2.520793314082878e-05, 7.607124405605129e-05, -2.4527163425833e-06, -3.7912531943321266e-06]], [[3.7912531943321266e-06, -2.4527163425833e-06, -7.607124405605129e-05, 2.520793314082878e-05, 0.0007198270642148971, 5.8400428694052584e-05, -0.003932325279797902, -0.001905407689852666, 0.012396988366648726, 0.009952982523509598, -0.01803889724191924, -0.007261634750928767, 0.016158808725919346, -0.08607087472073338, -0.15507600534974825, 0.18053958458111286, 0.681488995344925, 0.6507166292045456, 0.1423983504146782, -0.11856693261143636, 0.0172711782105185, 0.10475461484223211, 0.01790395221434112, -0.03329138349235933, -0.004819212803176148, 0.010482366933031529, 0.0008567700701915741, -0.0027416759756816018, -0.000138642302680455, 0.0004759963802638669, -1.3506383399901165e-05, -6.293702597554192e-05, 2.7801266938414138e-06, 4.297343327345983e-06], [4.297343327345983e-06, -2.7801266938414138e-06, -6.293702597554192e-05, 1.3506383399901165e-05, 0.0004759963802638669, 0.000138642302680455, -0.0027416759756816018, -0.0008567700701915741, 0.010482366933031529, 0.004819212803176148, -0.03329138349235933, -0.01790395221434112, 0.10475461484223211, -0.0172711782105185, -0.11856693261143636, -0.1423983504146782, 0.6507166292045456, -0.681488995344925, 0.18053958458111286, 0.15507600534974825, -0.08607087472073338, -0.016158808725919346, -0.007261634750928767, 0.01803889724191924, 0.009952982523509598, -0.012396988366648726, -0.001905407689852666, 0.003932325279797902, 5.8400428694052584e-05, -0.0007198270642148971, 2.520793314082878e-05, 7.607124405605129e-05, -2.4527163425833e-06, -3.7912531943321266e-06]]], "sym18": [[[-1.5131530692371587e-06, 7.847298055831765e-07, 2.955743762093081e-05, -9.858816030140058e-06, -0.0002658301102424104, 4.741614518373667e-05, 0.0014280863270832796, -0.00018877623940755607, -0.005239789683026608, 0.001087784789595693, 0.015012356344250213, -0.0032607442000749834, -0.03171268473181454, 0.006277944554311694, 0.028529597039037808, -0.07379920729060717, -0.032480573290138676, 0.40148386057061813, 0.7536291401017928, 0.47396905989393956, -0.052029158983952786, -0.15993814866932407, 0.03399566710394736, 0.08421992997038655, -0.005077085160757053, -0.030325091089369604, 0.001642986397278216, 0.009502164390962365, -0.00041152110923597756, -0.002313871814506099, 7.021273459036268e-05, 0.00039616840638254753, -1.4020992577726755e-05, -4.5246757874949856e-05, 1.354915761832114e-06, 2.6126125564836423e-06], [2.6126125564836423e-06, -1.354915761832114e-06, -4.5246757874949856e-05, 1.4020992577726755e-05, 0.00039616840638254753, -7.021273459036268e-05, -0.002313871814506099, 0.00041152110923597756, 0.009502164390962365, -0.001642986397278216, -0.030325091089369604, 0.005077085160757053, 0.08421992997038655, -0.03399566710394736, -0.15993814866932407, 0.052029158983952786, 0.47396905989393956, -0.7536291401017928, 0.40148386057061813, 0.032480573290138676, -0.07379920729060717, -0.028529597039037808, 0.006277944554311694, 0.03171268473181454, -0.0032607442000749834, -0.015012356344250213, 0.001087784789595693, 0.005239789683026608, -0.00018877623940755607, -0.0014280863270832796, 4.741614518373667e-05, 0.0002658301102424104, -9.858816030140058e-06, -2.955743762093081e-05, 7.847298055831765e-07, 1.5131530692371587e-06]], [[-1.5131530692371587e-06, 7.847298055831765e-07, 2.955743762093081e-05, -9.858816030140058e-06, -0.0002658301102424104, 4.741614518373667e-05, 0.0014280863270832796, -0.00018877623940755607, -0.005239789683026608, 0.001087784789595693, 0.015012356344250213, -0.0032607442000749834, -0.03171268473181454, 0.006277944554311694, 0.028529597039037808, -0.07379920729060717, -0.032480573290138676, 0.40148386057061813, 0.7536291401017928, 0.47396905989393956, -0.052029158983952786, -0.15993814866932407, 0.03399566710394736, 0.08421992997038655, -0.005077085160757053, -0.030325091089369604, 0.001642986397278216, 0.009502164390962365, -0.00041152110923597756, -0.002313871814506099, 7.021273459036268e-05, 0.00039616840638254753, -1.4020992577726755e-05, -4.5246757874949856e-05, 1.354915761832114e-06, 2.6126125564836423e-06], [2.6126125564836423e-06, -1.354915761832114e-06, -4.5246757874949856e-05, 1.4020992577726755e-05, 0.00039616840638254753, -7.021273459036268e-05, -0.002313871814506099, 0.00041152110923597756, 0.009502164390962365, -0.001642986397278216, -0.030325091089369604, 0.005077085160757053, 0.08421992997038655, -0.03399566710394736, -0.15993814866932407, 0.052029158983952786, 0.47396905989393956, -0.7536291401017928, 0.40148386057061813, 0.032480573290138676, -0.07379920729060717, -0.028529597039037808, 0.006277944554311694, 0.03171268473181454, -0.0032607442000749834, -0.015012356344250213, 0.001087784789595693, 0.005239789683026608, -0.00018877623940755607, -0.0014280863270832796, 4.741614518373667e-05, 0.0002658301102424104, -9.858816030140058e-06, -2.955743762093081e-05, 7.847298055831765e-07, 1.5131530692371587e-06]]], "sym19": [[[1.7509367995348687e-06, 2.0623170632395688e-06, -2.8151138661550245e-05, -1.6821387029373716e-05, 0.0002762187768573407, 0.00012930767650701415, -0.0017049602611649971, -0.0006179223277983108, 0.008262236955528255, 0.004319351874894969, -0.02770989693131125, -0.016908234861345205, 0.08407267627924504, 0.09363084341589714, -0.11624173010739675, -0.17659686625203097, 0.2582661692372836, 0.7195555257163943, 0.578144945338605, 0.10902582508127781, -0.06752505804029409, 0.008954591173043624, 0.0070155738571741596, -0.046635983534938946, -0.02265199337824595, 0.01579743929567463, 0.007968438320613306, -0.005122205002583014, -0.0011607032572062486, 0.0021214250281823303, 0.00015915804768084938, -0.000635764515004334, -4.612039600210587e-05, 0.0001155392333357879, 8.873312173729286e-06, -1.1880518269823984e-05, -6.463651303345963e-07, 5.487732768215838e-07], [5.487732768215838e-07, 6.463651303345963e-07, -1.1880518269823984e-05, -8.873312173729286e-06, 0.0001155392333357879, 4.612039600210587e-05, -0.000635764515004334, -0.00015915804768084938, 0.0021214250281823303, 0.0011607032572062486, -0.005122205002583014, -0.007968438320613306, 0.01579743929567463, 0.02265199337824595, -0.046635983534938946, -0.0070155738571741596, 0.008954591173043624, 0.06752505804029409, 0.10902582508127781, -0.578144945338605, 0.7195555257163943, -0.2582661692372836, -0.17659686625203097, 0.11624173010739675, 0.09363084341589714, -0.08407267627924504, -0.016908234861345205, 0.02770989693131125, 0.004319351874894969, -0.008262236955528255, -0.0006179223277983108, 0.0017049602611649971, 0.00012930767650701415, -0.0002762187768573407, -1.6821387029373716e-05, 2.8151138661550245e-05, 2.0623170632395688e-06, -1.7509367995348687e-06]], [[1.7509367995348687e-06, 2.0623170632395688e-06, -2.8151138661550245e-05, -1.6821387029373716e-05, 0.0002762187768573407, 0.00012930767650701415, -0.0017049602611649971, -0.0006179223277983108, 0.008262236955528255, 0.004319351874894969, -0.02770989693131125, -0.016908234861345205, 0.08407267627924504, 0.09363084341589714, -0.11624173010739675, -0.17659686625203097, 0.2582661692372836, 0.7195555257163943, 0.578144945338605, 0.10902582508127781, -0.06752505804029409, 0.008954591173043624, 0.0070155738571741596, -0.046635983534938946, -0.02265199337824595, 0.01579743929567463, 0.007968438320613306, -0.005122205002583014, -0.0011607032572062486, 0.0021214250281823303, 0.00015915804768084938, -0.000635764515004334, -4.612039600210587e-05, 0.0001155392333357879, 8.873312173729286e-06, -1.1880518269823984e-05, -6.463651303345963e-07, 5.487732768215838e-07], [5.487732768215838e-07, 6.463651303345963e-07, -1.1880518269823984e-05, -8.873312173729286e-06, 0.0001155392333357879, 4.612039600210587e-05, -0.000635764515004334, -0.00015915804768084938, 0.0021214250281823303, 0.0011607032572062486, -0.005122205002583014, -0.007968438320613306, 0.01579743929567463, 0.02265199337824595, -0.046635983534938946, -0.0070155738571741596, 0.008954591173043624, 0.06752505804029409, 0.10902582508127781, -0.578144945338605, 0.7195555257163943, -0.2582661692372836, -0.17659686625203097, 0.11624173010739675, 0.09363084341589714, -0.08407267627924504, -0.016908234861345205, 0.02770989693131125, 0.004319351874894969, -0.008262236955528255, -0.0006179223277983108, 0.0017049602611649971, 0.00012930767650701415, -0.0002762187768573407, -1.6821387029373716e-05, 2.8151138661550245e-05, 2.0623170632395688e-06, -1.7509367995348687e-06]]], "sym20": [[[-6.329129044776395e-07, -3.2567026420174407e-07, 1.22872527779612e-05, 4.525422209151636e-06, -0.00011739133516291466, -2.6615550335516086e-05, 0.0007476108597820572, 0.0001254409172306726, -0.0034716478028440734, -0.0006111263857992088, 0.012157040948785737, 0.0019385970672402002, -0.035373336756604236, -0.0068437019650692274, 0.08891966802819956, 0.03625095165393308, -0.16057829841525254, -0.0510883429210674, 0.47199147510148703, 0.75116272842273, 0.4058314443484506, -0.02981936888033373, -0.07899434492839816, 0.025579349509413946, 0.008123228356009682, -0.031629437144957966, -0.003313857383623359, 0.01700404902339034, 0.0014230873594621453, -0.006606585799088861, -0.0003052628317957281, 0.002088994708190198, 7.215991188074035e-05, -0.0004947310915672655, -1.928412300645204e-05, 7.992967835772481e-05, 3.025666062736966e-06, -7.919361411976999e-06, -1.9015675890554106e-07, 3.695537474835221e-07], [3.695537474835221e-07, 1.9015675890554106e-07, -7.919361411976999e-06, -3.025666062736966e-06, 7.992967835772481e-05, 1.928412300645204e-05, -0.0004947310915672655, -7.215991188074035e-05, 0.002088994708190198, 0.0003052628317957281, -0.006606585799088861, -0.0014230873594621453, 0.01700404902339034, 0.003313857383623359, -0.031629437144957966, -0.008123228356009682, 0.025579349509413946, 0.07899434492839816, -0.02981936888033373, -0.4058314443484506, 0.75116272842273, -0.47199147510148703, -0.0510883429210674, 0.16057829841525254, 0.03625095165393308, -0.08891966802819956, -0.0068437019650692274, 0.035373336756604236, 0.0019385970672402002, -0.012157040948785737, -0.0006111263857992088, 0.0034716478028440734, 0.0001254409172306726, -0.0007476108597820572, -2.6615550335516086e-05, 0.00011739133516291466, 4.525422209151636e-06, -1.22872527779612e-05, -3.2567026420174407e-07, 6.329129044776395e-07]], [[-6.329129044776395e-07, -3.2567026420174407e-07, 1.22872527779612e-05, 4.525422209151636e-06, -0.00011739133516291466, -2.6615550335516086e-05, 0.0007476108597820572, 0.0001254409172306726, -0.0034716478028440734, -0.0006111263857992088, 0.012157040948785737, 0.0019385970672402002, -0.035373336756604236, -0.0068437019650692274, 0.08891966802819956, 0.03625095165393308, -0.16057829841525254, -0.0510883429210674, 0.47199147510148703, 0.75116272842273, 0.4058314443484506, -0.02981936888033373, -0.07899434492839816, 0.025579349509413946, 0.008123228356009682, -0.031629437144957966, -0.003313857383623359, 0.01700404902339034, 0.0014230873594621453, -0.006606585799088861, -0.0003052628317957281, 0.002088994708190198, 7.215991188074035e-05, -0.0004947310915672655, -1.928412300645204e-05, 7.992967835772481e-05, 3.025666062736966e-06, -7.919361411976999e-06, -1.9015675890554106e-07, 3.695537474835221e-07], [3.695537474835221e-07, 1.9015675890554106e-07, -7.919361411976999e-06, -3.025666062736966e-06, 7.992967835772481e-05, 1.928412300645204e-05, -0.0004947310915672655, -7.215991188074035e-05, 0.002088994708190198, 0.0003052628317957281, -0.006606585799088861, -0.0014230873594621453, 0.01700404902339034, 0.003313857383623359, -0.031629437144957966, -0.008123228356009682, 0.025579349509413946, 0.07899434492839816, -0.02981936888033373, -0.4058314443484506, 0.75116272842273, -0.47199147510148703, -0.0510883429210674, 0.16057829841525254, 0.03625095165393308, -0.08891966802819956, -0.0068437019650692274, 0.035373336756604236, 0.0019385970672402002, -0.012157040948785737, -0.0006111263857992088, 0.0034716478028440734, 0.0001254409172306726, -0.0007476108597820572, -2.6615550335516086e-05, 0.00011739133516291466, 4.525422209151636e-06, -1.22872527779612e-05, -3.2567026420174407e-07, 6.329129044776395e-07]]], "coif1": [[[-0.07273261951252645, 0.3378976624574818, 0.8525720202116004, 0.3848648468648578, -0.07273261951252645, -0.015655728135791993], [-0.015655728135791993, 0.07273261951252645, 0.3848648468648578, -0.8525720202116004, 0.3378976624574818, 0.07273261951252645]], [[-0.07273261951252645, 0.3378976624574818, 0.8525720202116004, 0.3848648468648578, -0.07273261951252645, -0.015655728135791993], [-0.015655728135791993, 0.07273261951252645, 0.3848648468648578, -0.8525720202116004, 0.3378976624574818, 0.07273261951252645]]], "coif2": [[[0.01638733646320364, -0.04146493678687178, -0.0673725547237256, 0.3861100668227629, 0.8127236354494135, 0.4170051844232391, -0.07648859907828076, -0.05943441864643109, 0.02368017194684777, 0.005611434819368834, -0.0018232088709110323, -0.000720549445520347], [-0.000720549445520347, 0.0018232088709110323, 0.005611434819368834, -0.02368017194684777, -0.05943441864643109, 0.07648859907828076, 0.4170051844232391, -0.8127236354494135, 0.3861100668227629, 0.0673725547237256, -0.04146493678687178, -0.01638733646320364]], [[0.01638733646320364, -0.04146493678687178, -0.0673725547237256, 0.3861100668227629, 0.8127236354494135, 0.4170051844232391, -0.07648859907828076, -0.05943441864643109, 0.02368017194684777, 0.005611434819368834, -0.0018232088709110323, -0.000720549445520347], [-0.000720549445520347, 0.0018232088709110323, 0.005611434819368834, -0.02368017194684777, -0.05943441864643109, 0.07648859907828076, 0.4170051844232391, -0.8127236354494135, 0.3861100668227629, 0.0673725547237256, -0.04146493678687178, -0.01638733646320364]]], "coif3": [[[-0.003793512864380802, 0.007782596425672746, 0.023452696142077168, -0.06577191128146936, -0.06112339000297255, 0.40517690240911824, 0.7937772226260872, 0.42848347637737, -0.07179982161915484, -0.08230192710629983, 0.03455502757329774, 0.015880544863669452, -0.009007976136730624, -0.0025745176881367972, 0.0011175187708306303, 0.0004662169598204029, -7.0983302506379e-05, -3.459977319727278e-05], [-3.459977319727278e-05, 7.0983302506379e-05, 0.0004662169598204029, -0.0011175187708306303, -0.0025745176881367972, 0.009007976136730624, 0.015880544863669452, -0.03455502757329774, -0.08230192710629983, 0.07179982161915484, 0.42848347637737, -0.7937772226260872, 0.40517690240911824, 0.06112339000297255, -0.06577191128146936, -0.023452696142077168, 0.007782596425672746, 0.003793512864380802]], [[-0.003793512864380802, 0.007782596425672746, 0.023452696142077168, -0.06577191128146936, -0.06112339000297255, 0.40517690240911824, 0.7937772226260872, 0.42848347637737, -0.07179982161915484, -0.08230192710629983, 0.03455502757329774, 0.015880544863669452, -0.009007976136730624, -0.0025745176881367972, 0.0011175187708306303, 0.0004662169598204029, -7.0983302506379e-05, -3.459977319727278e-05], [-3.459977319727278e-05, 7.0983302506379e-05, 0.0004662169598204029, -0.0011175187708306303, -0.0025745176881367972, 0.009007976136730624, 0.015880544863669452, -0.03455502757329774, -0.08230192710629983, 0.07179982161915484, 0.42848347637737, -0.7937772226260872, 0.40517690240911824, 0.06112339000297255, -0.06577191128146936, -0.023452696142077168, 0.007782596425672746, 0.003793512864380802]]], "coif4": [[[0.000892313902537003, -0.001629492425226786, -0.007346167936268051, 0.01606894713157503, 0.02668230466960483, -0.08126671024919373, -0.05607731960356926, 0.41530842700068227, 0.7822389344242826, 0.43438603311435653, -0.06662747236681717, -0.09622042453595264, 0.03933442260558915, 0.02508225333794961, -0.015211728187697211, -0.0056582838001308835, 0.0037514346971460866, 0.0012665610789256603, -0.0005890202246332165, -0.0002599743371222568, 6.233885431278719e-05, 3.1229861599195265e-05, -3.259647940030751e-06, -1.7849909144933469e-06], [-1.7849909144933469e-06, 3.259647940030751e-06, 3.1229861599195265e-05, -6.233885431278719e-05, -0.0002599743371222568, 0.0005890202246332165, 0.0012665610789256603, -0.0037514346971460866, -0.0056582838001308835, 0.015211728187697211, 0.02508225333794961, -0.03933442260558915, -0.09622042453595264, 0.06662747236681717, 0.43438603311435653, -0.7822389344242826, 0.41530842700068227, 0.05607731960356926, -0.08126671024919373, -0.02668230466960483, 0.01606894713157503, 0.007346167936268051, -0.001629492425226786, -0.000892313902537003]], [[0.000892313902537003, -0.001629492425226786, -0.007346167936268051, 0.01606894713157503, 0.02668230466960483, -0.08126671024919373, -0.05607731960356926, 0.41530842700068227, 0.7822389344242826, 0.43438603311435653, -0.06662747236681717, -0.09622042453595264, 0.03933442260558915, 0.02508225333794961, -0.015211728187697211, -0.0056582838001308835, 0.0037514346971460866, 0.0012665610789256603, -0.0005890202246332165, -0.0002599743371222568, 6.233885431278719e-05, 3.1229861599195265e-05, -3.259647940030751e-06, -1.7849909144933469e-06], [-1.7849909144933469e-06, 3.259647940030751e-06, 3.1229861599195265e-05, -6.233885431278719e-05, -0.0002599743371222568, 0.0005890202246332165, 0.0012665610789256603, -0.0037514346971460866, -0.0056582838001308835, 0.015211728187697211, 0.02508225333794961, -0.03933442260558915, -0.09622042453595264, 0.06662747236681717, 0.43438603311435653, -0.7822389344242826, 0.41530842700068227, 0.05607731960356926, -0.08126671024919373, -0.02668230466960483, 0.01606894713157503, 0.007346167936268051, -0.001629492425226786, -0.000892313902537003]]], "coif5": [[[-0.000212081862067494, 0.0003585777411617577, 0.0021782943778456947, -0.00415931262757864, -0.010131584846900276, 0.023408322118927783, 0.028169744270532353, -0.09192158806008609, -0.052046670253554764, 0.42157126673075435, 0.7742936228603274, 0.4379823066591634, -0.06203775157498196, -0.10556315130733723, 0.041287530472117834, 0.032674799467057355, -0.019758391600965465, -0.009159507338676163, 0.006761520220620417, 0.0024315754425382886, -0.0016616273039298788, -0.0006375589261258812, 0.0003018579416682448, 0.00014035632812373243, -4.12198619242655e-05, -2.1270221672515614e-05, 3.7007277113394796e-06, 2.0612203985788783e-06, -1.6237995172048338e-07, -9.604010112767894e-08], [-9.604010112767894e-08, 1.6237995172048338e-07, 2.0612203985788783e-06, -3.7007277113394796e-06, -2.1270221672515614e-05, 4.12198619242655e-05, 0.00014035632812373243, -0.0003018579416682448, -0.0006375589261258812, 0.0016616273039298788, 0.0024315754425382886, -0.006761520220620417, -0.009159507338676163, 0.019758391600965465, 0.032674799467057355, -0.041287530472117834, -0.10556315130733723, 0.06203775157498196, 0.4379823066591634, -0.7742936228603274, 0.42157126673075435, 0.052046670253554764, -0.09192158806008609, -0.028169744270532353, 0.023408322118927783, 0.010131584846900276, -0.00415931262757864, -0.0021782943778456947, 0.0003585777411617577, 0.000212081862067494]], [[-0.000212081862067494, 0.0003585777411617577, 0.0021782943778456947, -0.00415931262757864, -0.010131584846900276, 0.023408322118927783, 0.028169744270532353, -0.09192158806008609, -0.052046670253554764, 0.42157126673075435, 0.7742936228603274, 0.4379823066591634, -0.06203775157498196, -0.10556315130733723, 0.041287530472117834, 0.032674799467057355, -0.019758391600965465, -0.009159507338676163, 0.006761520220620417, 0.0024315754425382886, -0.0016616273039298788, -0.0006375589261258812, 0.0003018579416682448, 0.00014035632812373243, -4.12198619242655e-05, -2.1270221672515614e-05, 3.7007277113394796e-06, 2.0612203985788783e-06, -1.6237995172048338e-07, -9.604010112767894e-08], [-9.604010112767894e-08, 1.6237995172048338e-07, 2.0612203985788783e-06, -3.7007277113394796e-06, -2.1270221672515614e-05, 4.12198619242655e-05, 0.00014035632812373243, -0.0003018579416682448, -0.0006375589261258812, 0.0016616273039298788, 0.0024315754425382886, -0.006761520220620417, -0.009159507338676163, 0.019758391600965465, 0.032674799467057355, -0.041287530472117834, -0.10556315130733723, 0.06203775157498196, 0.4379823066591634, -0.7742936228603274, 0.42157126673075435, 0.052046670253554764, -0.09192158806008609, -0.028169744270532353, 0.023408322118927783, 0.010131584846900276, -0.00415931262757864, -0.0021782943778456947, 0.0003585777411617577, 0.000212081862067494]]], "coif6": [[[5.0775487836340565e-05, -8.117002626784841e-05, -0.0006246130439256836, 0.0010916247123259031, 0.0035390198715409982, -0.007029406391002729, -0.012231577790037914, 0.029645772891323842, 0.02878611434666557, -0.09967300204601176, -0.04876407217567388, 0.42581954501283853, 0.7684032575798925, 0.4404011911268528, -0.0581089179726148, -0.11226080796481724, 0.04185249067613627, 0.03888132625151076, -0.022950153279849065, -0.012650067908732352, 0.009591090175904054, 0.0038576582705936867, -0.0030739395072085594, -0.0011574350134273348, 0.0007698547307507267, 0.0003252223590102408, -0.0001545771992797995, -7.528004306935965e-05, 2.473655932872323e-05, 1.3139851354021442e-05, -2.924385559757523e-06, -1.6596192951024209e-06, 2.255997852816182e-07, 1.3503244993561446e-07, -8.487143396262437e-09, -5.309088417196894e-09], [-5.309088417196894e-09, 8.487143396262437e-09, 1.3503244993561446e-07, -2.255997852816182e-07, -1.6596192951024209e-06, 2.924385559757523e-06, 1.3139851354021442e-05, -2.473655932872323e-05, -7.528004306935965e-05, 0.0001545771992797995, 0.0003252223590102408, -0.0007698547307507267, -0.0011574350134273348, 0.0030739395072085594, 0.0038576582705936867, -0.009591090175904054, -0.012650067908732352, 0.022950153279849065, 0.03888132625151076, -0.04185249067613627, -0.11226080796481724, 0.0581089179726148, 0.4404011911268528, -0.7684032575798925, 0.42581954501283853, 0.04876407217567388, -0.09967300204601176, -0.02878611434666557, 0.029645772891323842, 0.012231577790037914, -0.007029406391002729, -0.0035390198715409982, 0.0010916247123259031, 0.0006246130439256836, -8.117002626784841e-05, -5.0775487836340565e-05]], [[5.0775487836340565e-05, -8.117002626784841e-05, -0.0006246130439256836, 0.0010916247123259031, 0.0035390198715409982, -0.007029406391002729, -0.012231577790037914, 0.029645772891323842, 0.02878611434666557, -0.09967300204601176, -0.04876407217567388, 0.42581954501283853, 0.7684032575798925, 0.4404011911268528, -0.0581089179726148, -0.11226080796481724, 0.04185249067613627, 0.03888132625151076, -0.022950153279849065, -0.012650067908732352, 0.009591090175904054, 0.0038576582705936867, -0.0030739395072085594, -0.0011574350134273348, 0.0007698547307507267, 0.0003252223590102408, -0.0001545771992797995, -7.528004306935965e-05, 2.473655932872323e-05, 1.3139851354021442e-05, -2.924385559757523e-06, -1.6596192951024209e-06, 2.255997852816182e-07, 1.3503244993561446e-07, -8.487143396262437e-09, -5.309088417196894e-09], [-5.309088417196894e-09, 8.487143396262437e-09, 1.3503244993561446e-07, -2.255997852816182e-07, -1.6596192951024209e-06, 2.924385559757523e-06, 1.3139851354021442e-05, -2.473655932872323e-05, -7.528004306935965e-05, 0.0001545771992797995, 0.0003252223590102408, -0.0007698547307507267, -0.0011574350134273348, 0.0030739395072085594, 0.0038576582705936867, -0.009591090175904054, -0.012650067908732352, 0.022950153279849065, 0.03888132625151076, -0.04185249067613627, -0.11226080796481724, 0.0581089179726148, 0.4404011911268528, -0.7684032575798925, 0.42581954501283853, 0.04876407217567388, -0.09967300204601176, -0.02878611434666557, 0.029645772891323842, 0.012231577790037914, -0.007029406391002729, -0.0035390198715409982, 0.0010916247123259031, 0.0006246130439256836, -8.117002626784841e-05, -5.0775487836340565e-05]]], "coif7": [[[-1.2222250624065772e-05, 1.871135500141218e-05, 0.0001751021677848318, -0.0002872023753570612, -0.0011693144285797635, 0.002105772041410548, 0.004829446560702039, -0.00993889526908058, -0.0138025542362884, 0.03491050510474272, 0.02893704198352315, -0.1055561682215613, -0.0460333970384663, 0.4288888072494226, 0.7638153654167334, 0.44213746140184257, -0.054751241648150456, -0.11729357104319278, 0.04170535760257679, 0.04399304616307942, -0.025154257568539024, -0.015946846819567942, 0.012052338241841624, 0.005431316442880096, -0.004617842130433119, -0.0018015372833330428, 0.0014347418566524124, 0.0005794994482340954, -0.00036906682873489536, -0.00016781721215484974, 7.971050025993867e-05, 4.04304824171402e-05, -1.4235636978451501e-05, -7.771243547311862e-06, 2.0020780498554183e-06, 1.1579769069489573e-06, -2.0693205243938526e-07, -1.2550913190794572e-07, 1.3935103885216453e-08, 8.796593384856987e-09, -4.578334067792951e-10, -2.990566231736866e-10], [-2.990566231736866e-10, 4.578334067792951e-10, 8.796593384856987e-09, -1.3935103885216453e-08, -1.2550913190794572e-07, 2.0693205243938526e-07, 1.1579769069489573e-06, -2.0020780498554183e-06, -7.771243547311862e-06, 1.4235636978451501e-05, 4.04304824171402e-05, -7.971050025993867e-05, -0.00016781721215484974, 0.00036906682873489536, 0.0005794994482340954, -0.0014347418566524124, -0.0018015372833330428, 0.004617842130433119, 0.005431316442880096, -0.012052338241841624, -0.015946846819567942, 0.025154257568539024, 0.04399304616307942, -0.04170535760257679, -0.11729357104319278, 0.054751241648150456, 0.44213746140184257, -0.7638153654167334, 0.4288888072494226, 0.0460333970384663, -0.1055561682215613, -0.02893704198352315, 0.03491050510474272, 0.0138025542362884, -0.00993889526908058, -0.004829446560702039, 0.002105772041410548, 0.0011693144285797635, -0.0002872023753570612, -0.0001751021677848318, 1.871135500141218e-05, 1.2222250624065772e-05]], [[-1.2222250624065772e-05, 1.871135500141218e-05, 0.0001751021677848318, -0.0002872023753570612, -0.0011693144285797635, 0.002105772041410548, 0.004829446560702039, -0.00993889526908058, -0.0138025542362884, 0.03491050510474272, 0.02893704198352315, -0.1055561682215613, -0.0460333970384663, 0.4288888072494226, 0.7638153654167334, 0.44213746140184257, -0.054751241648150456, -0.11729357104319278, 0.04170535760257679, 0.04399304616307942, -0.025154257568539024, -0.015946846819567942, 0.012052338241841624, 0.005431316442880096, -0.004617842130433119, -0.0018015372833330428, 0.0014347418566524124, 0.0005794994482340954, -0.00036906682873489536, -0.00016781721215484974, 7.971050025993867e-05, 4.04304824171402e-05, -1.4235636978451501e-05, -7.771243547311862e-06, 2.0020780498554183e-06, 1.1579769069489573e-06, -2.0693205243938526e-07, -1.2550913190794572e-07, 1.3935103885216453e-08, 8.796593384856987e-09, -4.578334067792951e-10, -2.990566231736866e-10], [-2.990566231736866e-10, 4.578334067792951e-10, 8.796593384856987e-09, -1.3935103885216453e-08, -1.2550913190794572e-07, 2.0693205243938526e-07, 1.1579769069489573e-06, -2.0020780498554183e-06, -7.771243547311862e-06, 1.4235636978451501e-05, 4.04304824171402e-05, -7.971050025993867e-05, -0.00016781721215484974, 0.00036906682873489536, 0.0005794994482340954, -0.0014347418566524124, -0.0018015372833330428, 0.004617842130433119, 0.005431316442880096, -0.012052338241841624, -0.015946846819567942, 0.025154257568539024, 0.04399304616307942, -0.04170535760257679, -0.11729357104319278, 0.054751241648150456, 0.44213746140184257, -0.7638153654167334, 0.4288888072494226, 0.0460333970384663, -0.1055561682215613, -0.02893704198352315, 0.03491050510474272, 0.0138025542362884, -0.00993889526908058, -0.004829446560702039, 0.002105772041410548, 0.0011693144285797635, -0.0002872023753570612, -0.0001751021677848318, 1.871135500141218e-05, 1.2222250624065772e-05]]], "coif8": [[[2.9543365214148865e-06, -4.368264820320075e-06, -4.8296315214092946e-05, 7.54736783816504e-05, 0.0003712949956074124, -0.0006235604474579403, -0.001783260008597197, 0.0033008250106161103, 0.005994849192155886, -0.012742370632719796, -0.014978462081708435, 0.03937203787797985, 0.02882862175928801, -0.11016997698347017, -0.04371898336594559, 0.43120981555508764, 0.7601133020179406, 0.44344254984152603, -0.05186074316118868, -0.12121116823149648, 0.04118580667625654, 0.04825237108568226, -0.026656710542648603, -0.01898524469525487, 0.014117470077618783, 0.007065827011035097, -0.006156659548258421, -0.0025440037102452736, 0.002235649422048103, 0.0008967760630796798, -0.0006871716433480045, -0.00029777893219564, 0.00018169287648431021, 8.754452091843062e-05, -4.147478606916182e-05, -2.1802000767010356e-05, 8.031502995440787e-06, 4.496936443579392e-06, -1.2754542996407565e-06, -7.515021558886325e-07, 1.589351722153065e-07, 9.772418508367799e-08, -1.454000853375353e-08, -9.271205591546297e-09, 8.669995082338711e-10, 5.704810333909736e-10, -2.5254234938854572e-11, -1.7079895947055486e-11], [-1.7079895947055486e-11, 2.5254234938854572e-11, 5.704810333909736e-10, -8.669995082338711e-10, -9.271205591546297e-09, 1.454000853375353e-08, 9.772418508367799e-08, -1.589351722153065e-07, -7.515021558886325e-07, 1.2754542996407565e-06, 4.496936443579392e-06, -8.031502995440787e-06, -2.1802000767010356e-05, 4.147478606916182e-05, 8.754452091843062e-05, -0.00018169287648431021, -0.00029777893219564, 0.0006871716433480045, 0.0008967760630796798, -0.002235649422048103, -0.0025440037102452736, 0.006156659548258421, 0.007065827011035097, -0.014117470077618783, -0.01898524469525487, 0.026656710542648603, 0.04825237108568226, -0.04118580667625654, -0.12121116823149648, 0.05186074316118868, 0.44344254984152603, -0.7601133020179406, 0.43120981555508764, 0.04371898336594559, -0.11016997698347017, -0.02882862175928801, 0.03937203787797985, 0.014978462081708435, -0.012742370632719796, -0.005994849192155886, 0.0033008250106161103, 0.001783260008597197, -0.0006235604474579403, -0.0003712949956074124, 7.54736783816504e-05, 4.8296315214092946e-05, -4.368264820320075e-06, -2.9543365214148865e-06]], [[2.9543365214148865e-06, -4.368264820320075e-06, -4.8296315214092946e-05, 7.54736783816504e-05, 0.0003712949956074124, -0.0006235604474579403, -0.001783260008597197, 0.0033008250106161103, 0.005994849192155886, -0.012742370632719796, -0.014978462081708435, 0.03937203787797985, 0.02882862175928801, -0.11016997698347017, -0.04371898336594559, 0.43120981555508764, 0.7601133020179406, 0.44344254984152603, -0.05186074316118868, -0.12121116823149648, 0.04118580667625654, 0.04825237108568226, -0.026656710542648603, -0.01898524469525487, 0.014117470077618783, 0.007065827011035097, -0.006156659548258421, -0.0025440037102452736, 0.002235649422048103, 0.0008967760630796798, -0.0006871716433480045, -0.00029777893219564, 0.00018169287648431021, 8.754452091843062e-05, -4.147478606916182e-05, -2.1802000767010356e-05, 8.031502995440787e-06, 4.496936443579392e-06, -1.2754542996407565e-06, -7.515021558886325e-07, 1.589351722153065e-07, 9.772418508367799e-08, -1.454000853375353e-08, -9.271205591546297e-09, 8.669995082338711e-10, 5.704810333909736e-10, -2.5254234938854572e-11, -1.7079895947055486e-11], [-1.7079895947055486e-11, 2.5254234938854572e-11, 5.704810333909736e-10, -8.669995082338711e-10, -9.271205591546297e-09, 1.454000853375353e-08, 9.772418508367799e-08, -1.589351722153065e-07, -7.515021558886325e-07, 1.2754542996407565e-06, 4.496936443579392e-06, -8.031502995440787e-06, -2.1802000767010356e-05, 4.147478606916182e-05, 8.754452091843062e-05, -0.00018169287648431021, -0.00029777893219564, 0.0006871716433480045, 0.0008967760630796798, -0.002235649422048103, -0.0025440037102452736, 0.006156659548258421, 0.007065827011035097, -0.014117470077618783, -0.01898524469525487, 0.026656710542648603, 0.04825237108568226, -0.04118580667625654, -0.12121116823149648, 0.05186074316118868, 0.44344254984152603, -0.7601133020179406, 0.43120981555508764, 0.04371898336594559, -0.11016997698347017, -0.02882862175928801, 0.03937203787797985, 0.014978462081708435, -0.012742370632719796, -0.005994849192155886, 0.0033008250106161103, 0.001783260008597197, -0.0006235604474579403, -0.0003712949956074124, 7.54736783816504e-05, 4.8296315214092946e-05, -4.368264820320075e-06, -2.9543365214148865e-06]]], "coif9": [[[-7.164920431247886e-07, 1.0293200668945786e-06, 1.315888564542533e-05, -1.978720443246248e-05, -0.00011443395278590283, 0.00018228485966342262, 0.000626473032139716, -0.001075458272741238, -0.0024212416736516485, 0.004597056424920538, 0.007022340460196238, -0.015376649629718764, -0.015860223894792906, 0.04318172760825045, 0.028572667556949285, -0.11388350819004509, -0.041726110205852804, 0.4330267511031542, 0.7570455233843789, 0.44445789317644796, -0.04934886629362917, -0.12434558953929063, 0.04047376745572896, 0.05184461568624732, -0.027661239498680462, -0.021754553510948845, 0.01581871581592506, 0.008702757446229182, -0.007614042448258918, -0.0033576745265865788, 0.003113227788384304, 0.00126969092513534, -0.001095745627952607, -0.00046272908550530433, 0.0003369138692848271, 0.00015541352126673886, -9.135595508746477e-05, -4.613708198462493e-05, 2.177639641002903e-05, 1.1814409451578695e-05, -4.488111475152765e-06, -2.5723835744866874e-06, 7.802480329370886e-07, 4.679584769454299e-07, -1.1096670180879424e-07, -6.916547041218038e-08, 1.2375256619810126e-08, 7.97400588684683e-09, -1.0136275688170466e-09, -6.723464414885984e-10, 5.4171009642830385e-11, 3.686179736445179e-11, -1.416273550918584e-12, -9.858437261237078e-13], [-9.858437261237078e-13, 1.416273550918584e-12, 3.686179736445179e-11, -5.4171009642830385e-11, -6.723464414885984e-10, 1.0136275688170466e-09, 7.97400588684683e-09, -1.2375256619810126e-08, -6.916547041218038e-08, 1.1096670180879424e-07, 4.679584769454299e-07, -7.802480329370886e-07, -2.5723835744866874e-06, 4.488111475152765e-06, 1.1814409451578695e-05, -2.177639641002903e-05, -4.613708198462493e-05, 9.135595508746477e-05, 0.00015541352126673886, -0.0003369138692848271, -0.00046272908550530433, 0.001095745627952607, 0.00126969092513534, -0.003113227788384304, -0.0033576745265865788, 0.007614042448258918, 0.008702757446229182, -0.01581871581592506, -0.021754553510948845, 0.027661239498680462, 0.05184461568624732, -0.04047376745572896, -0.12434558953929063, 0.04934886629362917, 0.44445789317644796, -0.7570455233843789, 0.4330267511031542, 0.041726110205852804, -0.11388350819004509, -0.028572667556949285, 0.04318172760825045, 0.015860223894792906, -0.015376649629718764, -0.007022340460196238, 0.004597056424920538, 0.0024212416736516485, -0.001075458272741238, -0.000626473032139716, 0.00018228485966342262, 0.00011443395278590283, -1.978720443246248e-05, -1.315888564542533e-05, 1.0293200668945786e-06, 7.164920431247886e-07]], [[-7.164920431247886e-07, 1.0293200668945786e-06, 1.315888564542533e-05, -1.978720443246248e-05, -0.00011443395278590283, 0.00018228485966342262, 0.000626473032139716, -0.001075458272741238, -0.0024212416736516485, 0.004597056424920538, 0.007022340460196238, -0.015376649629718764, -0.015860223894792906, 0.04318172760825045, 0.028572667556949285, -0.11388350819004509, -0.041726110205852804, 0.4330267511031542, 0.7570455233843789, 0.44445789317644796, -0.04934886629362917, -0.12434558953929063, 0.04047376745572896, 0.05184461568624732, -0.027661239498680462, -0.021754553510948845, 0.01581871581592506, 0.008702757446229182, -0.007614042448258918, -0.0033576745265865788, 0.003113227788384304, 0.00126969092513534, -0.001095745627952607, -0.00046272908550530433, 0.0003369138692848271, 0.00015541352126673886, -9.135595508746477e-05, -4.613708198462493e-05, 2.177639641002903e-05, 1.1814409451578695e-05, -4.488111475152765e-06, -2.5723835744866874e-06, 7.802480329370886e-07, 4.679584769454299e-07, -1.1096670180879424e-07, -6.916547041218038e-08, 1.2375256619810126e-08, 7.97400588684683e-09, -1.0136275688170466e-09, -6.723464414885984e-10, 5.4171009642830385e-11, 3.686179736445179e-11, -1.416273550918584e-12, -9.858437261237078e-13], [-9.858437261237078e-13, 1.416273550918584e-12, 3.686179736445179e-11, -5.4171009642830385e-11, -6.723464414885984e-10, 1.0136275688170466e-09, 7.97400588684683e-09, -1.2375256619810126e-08, -6.916547041218038e-08, 1.1096670180879424e-07, 4.679584769454299e-07, -7.802480329370886e-07, -2.5723835744866874e-06, 4.488111475152765e-06, 1.1814409451578695e-05, -2.177639641002903e-05, -4.613708198462493e-05, 9.135595508746477e-05, 0.00015541352126673886, -0.0003369138692848271, -0.00046272908550530433, 0.001095745627952607, 0.00126969092513534, -0.003113227788384304, -0.0033576745265865788, 0.007614042448258918, 0.008702757446229182, -0.01581871581592506, -0.021754553510948845, 0.027661239498680462, 0.05184461568624732, -0.04047376745572896, -0.12434558953929063, 0.04934886629362917, 0.44445789317644796, -0.7570455233843789, 0.4330267511031542, 0.041726110205852804, -0.11388350819004509, -0.028572667556949285, 0.04318172760825045, 0.015860223894792906, -0.015376649629718764, -0.007022340460196238, 0.004597056424920538, 0.0024212416736516485, -0.001075458272741238, -0.000626473032139716, 0.00018228485966342262, 0.00011443395278590283, -1.978720443246248e-05, -1.315888564542533e-05, 1.0293200668945786e-06, 7.164920431247886e-07]]], "coif10": [[[1.7423674803127223e-07, -2.4427648648848456e-07, -3.551205538569571e-06, 5.173962608452716e-06, 3.4459693234170226e-05, -5.264472185921728e-05, -0.00021177413649420268, 0.00034345502618015684, 0.0009249399604237315, -0.001620778108853293, -0.003053992493811566, 0.0059373732658958775, 0.007917157067706418, -0.017820445781285547, -0.016521511268705533, 0.046462747054700444, 0.028232912738798778, -0.11693607050206899, -0.03998711301587224, 0.43448818216271134, 0.754450109494782, 0.445269197719615, -0.04714526253802028, -0.12690910430554908, 0.039668349279538065, 0.05490896399592108, -0.028310063944428577, -0.024267328682795093, 0.01720591249831959, 0.010305378002449852, -0.008953207286543774, -0.004218113884810503, 0.004020222790700274, 0.0016899697926397446, -0.0015748582231923617, -0.0006598662532419506, 0.0005451673708605962, 0.0002436317307208456, -0.00016857983433223972, -8.202162255997293e-05, 4.6724981354812776e-05, 2.4541910121029197e-05, -1.1531058392150231e-05, -6.434329489073881e-06, 2.4972027910054274e-06, 1.4624450319782122e-06, -4.657624401004923e-07, -2.840907583862188e-07, 7.315542758722409e-08, 4.620903057304521e-08, -9.39633274741924e-09, -6.118910132543529e-09, 9.4678306369391e-10, 6.333121950019277e-10, -7.01292033330539e-11, -4.8040522124783065e-11, 3.393464737916166e-12, 2.374617931225516e-12, -8.044508599489871e-14, -5.737961266897435e-14], [-5.737961266897435e-14, 8.044508599489871e-14, 2.374617931225516e-12, -3.393464737916166e-12, -4.8040522124783065e-11, 7.01292033330539e-11, 6.333121950019277e-10, -9.4678306369391e-10, -6.118910132543529e-09, 9.39633274741924e-09, 4.620903057304521e-08, -7.315542758722409e-08, -2.840907583862188e-07, 4.657624401004923e-07, 1.4624450319782122e-06, -2.4972027910054274e-06, -6.434329489073881e-06, 1.1531058392150231e-05, 2.4541910121029197e-05, -4.6724981354812776e-05, -8.202162255997293e-05, 0.00016857983433223972, 0.0002436317307208456, -0.0005451673708605962, -0.0006598662532419506, 0.0015748582231923617, 0.0016899697926397446, -0.004020222790700274, -0.004218113884810503, 0.008953207286543774, 0.010305378002449852, -0.01720591249831959, -0.024267328682795093, 0.028310063944428577, 0.05490896399592108, -0.039668349279538065, -0.12690910430554908, 0.04714526253802028, 0.445269197719615, -0.754450109494782, 0.43448818216271134, 0.03998711301587224, -0.11693607050206899, -0.028232912738798778, 0.046462747054700444, 0.016521511268705533, -0.017820445781285547, -0.007917157067706418, 0.0059373732658958775, 0.003053992493811566, -0.001620778108853293, -0.0009249399604237315, 0.00034345502618015684, 0.00021177413649420268, -5.264472185921728e-05, -3.4459693234170226e-05, 5.173962608452716e-06, 3.551205538569571e-06, -2.4427648648848456e-07, -1.7423674803127223e-07]], [[1.7423674803127223e-07, -2.4427648648848456e-07, -3.551205538569571e-06, 5.173962608452716e-06, 3.4459693234170226e-05, -5.264472185921728e-05, -0.00021177413649420268, 0.00034345502618015684, 0.0009249399604237315, -0.001620778108853293, -0.003053992493811566, 0.0059373732658958775, 0.007917157067706418, -0.017820445781285547, -0.016521511268705533, 0.046462747054700444, 0.028232912738798778, -0.11693607050206899, -0.03998711301587224, 0.43448818216271134, 0.754450109494782, 0.445269197719615, -0.04714526253802028, -0.12690910430554908, 0.039668349279538065, 0.05490896399592108, -0.028310063944428577, -0.024267328682795093, 0.01720591249831959, 0.010305378002449852, -0.008953207286543774, -0.004218113884810503, 0.004020222790700274, 0.0016899697926397446, -0.0015748582231923617, -0.0006598662532419506, 0.0005451673708605962, 0.0002436317307208456, -0.00016857983433223972, -8.202162255997293e-05, 4.6724981354812776e-05, 2.4541910121029197e-05, -1.1531058392150231e-05, -6.434329489073881e-06, 2.4972027910054274e-06, 1.4624450319782122e-06, -4.657624401004923e-07, -2.840907583862188e-07, 7.315542758722409e-08, 4.620903057304521e-08, -9.39633274741924e-09, -6.118910132543529e-09, 9.4678306369391e-10, 6.333121950019277e-10, -7.01292033330539e-11, -4.8040522124783065e-11, 3.393464737916166e-12, 2.374617931225516e-12, -8.044508599489871e-14, -5.737961266897435e-14], [-5.737961266897435e-14, 8.044508599489871e-14, 2.374617931225516e-12, -3.393464737916166e-12, -4.8040522124783065e-11, 7.01292033330539e-11, 6.333121950019277e-10, -9.4678306369391e-10, -6.118910132543529e-09, 9.39633274741924e-09, 4.620903057304521e-08, -7.315542758722409e-08, -2.840907583862188e-07, 4.657624401004923e-07, 1.4624450319782122e-06, -2.4972027910054274e-06, -6.434329489073881e-06, 1.1531058392150231e-05, 2.4541910121029197e-05, -4.6724981354812776e-05, -8.202162255997293e-05, 0.00016857983433223972, 0.0002436317307208456, -0.0005451673708605962, -0.0006598662532419506, 0.0015748582231923617, 0.0016899697926397446, -0.004020222790700274, -0.004218113884810503, 0.008953207286543774, 0.010305378002449852, -0.01720591249831959, -0.024267328682795093, 0.028310063944428577, 0.05490896399592108, -0.039668349279538065, -0.12690910430554908, 0.04714526253802028, 0.445269197719615, -0.754450109494782, 0.43448818216271134, 0.03998711301587224, -0.11693607050206899, -0.028232912738798778, 0.046462747054700444, 0.016521511268705533, -0.017820445781285547, -0.007917157067706418, 0.0059373732658958775, 0.003053992493811566, -0.001620778108853293, -0.0009249399604237315, 0.00034345502618015684, 0.00021177413649420268, -5.264472185921728e-05, -3.4459693234170226e-05, 5.173962608452716e-06, 3.551205538569571e-06, -2.4427648648848456e-07, -1.7423674803127223e-07]]], "coif11": [[[-4.2466588505053215e-08, 5.829773387691354e-08, 9.510573210512222e-07, -1.3493521791802846e-06, -1.0185919231767138e-05, 1.503949885335962e-05, 6.942759574780768e-05, -0.00010766668137712068, -0.0003381080420145401, 0.0005577204869484765, 0.0012520730398850818, -0.002236842519594617, -0.0036638635291587457, 0.007283017155944007, 0.008691538302863684, -0.020073251976164126, -0.017015922424480568, 0.049312538937724984, 0.027847051241316454, -0.11948939622817124, -0.038452460685844056, 0.43568960835151255, 0.7522175440402374, 0.44593144282059277, -0.04519495629357892, -0.12904373222526422, 0.038825603724123164, 0.0575502447040702, -0.028702596019727928, -0.026545070862175356, 0.018329643336621636, 0.011851974427506963, -0.010160884866512015, -0.005105112841283235, 0.004922673261101513, 0.002149020717634627, -0.0021036100764663637, -0.0008861775180562737, 0.0008017452103384918, 0.0003512267504200824, -0.00027542687784672955, -0.0001298668208927486, 8.582415436286544e-05, 4.368364304478778e-05, -2.4235592024624014e-05, -1.3163750930799775e-05, 6.153164872698854e-06, 3.5211459772931156e-06, -1.3873754845796895e-06, -8.287967353524098e-07, 2.73769336370002e-07, 1.6966516600849333e-07, -4.647551654558209e-08, -2.9737144543121354e-08, 6.643004284847311e-09, 4.371514216501341e-09, -7.7681779289702e-10, -5.240838827477836e-10, 7.131883881772345e-11, 4.919793979271459e-11, -4.818423114601901e-12, -3.391025392797988e-12, 2.1292784594645594e-13, 1.525825549533055e-13, -4.615818040032402e-15, -3.3623613180937427e-15], [-3.3623613180937427e-15, 4.615818040032402e-15, 1.525825549533055e-13, -2.1292784594645594e-13, -3.391025392797988e-12, 4.818423114601901e-12, 4.919793979271459e-11, -7.131883881772345e-11, -5.240838827477836e-10, 7.7681779289702e-10, 4.371514216501341e-09, -6.643004284847311e-09, -2.9737144543121354e-08, 4.647551654558209e-08, 1.6966516600849333e-07, -2.73769336370002e-07, -8.287967353524098e-07, 1.3873754845796895e-06, 3.5211459772931156e-06, -6.153164872698854e-06, -1.3163750930799775e-05, 2.4235592024624014e-05, 4.368364304478778e-05, -8.582415436286544e-05, -0.0001298668208927486, 0.00027542687784672955, 0.0003512267504200824, -0.0008017452103384918, -0.0008861775180562737, 0.0021036100764663637, 0.002149020717634627, -0.004922673261101513, -0.005105112841283235, 0.010160884866512015, 0.011851974427506963, -0.018329643336621636, -0.026545070862175356, 0.028702596019727928, 0.0575502447040702, -0.038825603724123164, -0.12904373222526422, 0.04519495629357892, 0.44593144282059277, -0.7522175440402374, 0.43568960835151255, 0.038452460685844056, -0.11948939622817124, -0.027847051241316454, 0.049312538937724984, 0.017015922424480568, -0.020073251976164126, -0.008691538302863684, 0.007283017155944007, 0.0036638635291587457, -0.002236842519594617, -0.0012520730398850818, 0.0005577204869484765, 0.0003381080420145401, -0.00010766668137712068, -6.942759574780768e-05, 1.503949885335962e-05, 1.0185919231767138e-05, -1.3493521791802846e-06, -9.510573210512222e-07, 5.829773387691354e-08, 4.2466588505053215e-08]], [[-4.2466588505053215e-08, 5.829773387691354e-08, 9.510573210512222e-07, -1.3493521791802846e-06, -1.0185919231767138e-05, 1.503949885335962e-05, 6.942759574780768e-05, -0.00010766668137712068, -0.0003381080420145401, 0.0005577204869484765, 0.0012520730398850818, -0.002236842519594617, -0.0036638635291587457, 0.007283017155944007, 0.008691538302863684, -0.020073251976164126, -0.017015922424480568, 0.049312538937724984, 0.027847051241316454, -0.11948939622817124, -0.038452460685844056, 0.43568960835151255, 0.7522175440402374, 0.44593144282059277, -0.04519495629357892, -0.12904373222526422, 0.038825603724123164, 0.0575502447040702, -0.028702596019727928, -0.026545070862175356, 0.018329643336621636, 0.011851974427506963, -0.010160884866512015, -0.005105112841283235, 0.004922673261101513, 0.002149020717634627, -0.0021036100764663637, -0.0008861775180562737, 0.0008017452103384918, 0.0003512267504200824, -0.00027542687784672955, -0.0001298668208927486, 8.582415436286544e-05, 4.368364304478778e-05, -2.4235592024624014e-05, -1.3163750930799775e-05, 6.153164872698854e-06, 3.5211459772931156e-06, -1.3873754845796895e-06, -8.287967353524098e-07, 2.73769336370002e-07, 1.6966516600849333e-07, -4.647551654558209e-08, -2.9737144543121354e-08, 6.643004284847311e-09, 4.371514216501341e-09, -7.7681779289702e-10, -5.240838827477836e-10, 7.131883881772345e-11, 4.919793979271459e-11, -4.818423114601901e-12, -3.391025392797988e-12, 2.1292784594645594e-13, 1.525825549533055e-13, -4.615818040032402e-15, -3.3623613180937427e-15], [-3.3623613180937427e-15, 4.615818040032402e-15, 1.525825549533055e-13, -2.1292784594645594e-13, -3.391025392797988e-12, 4.818423114601901e-12, 4.919793979271459e-11, -7.131883881772345e-11, -5.240838827477836e-10, 7.7681779289702e-10, 4.371514216501341e-09, -6.643004284847311e-09, -2.9737144543121354e-08, 4.647551654558209e-08, 1.6966516600849333e-07, -2.73769336370002e-07, -8.287967353524098e-07, 1.3873754845796895e-06, 3.5211459772931156e-06, -6.153164872698854e-06, -1.3163750930799775e-05, 2.4235592024624014e-05, 4.368364304478778e-05, -8.582415436286544e-05, -0.0001298668208927486, 0.00027542687784672955, 0.0003512267504200824, -0.0008017452103384918, -0.0008861775180562737, 0.0021036100764663637, 0.002149020717634627, -0.004922673261101513, -0.005105112841283235, 0.010160884866512015, 0.011851974427506963, -0.018329643336621636, -0.026545070862175356, 0.028702596019727928, 0.0575502447040702, -0.038825603724123164, -0.12904373222526422, 0.04519495629357892, 0.44593144282059277, -0.7522175440402374, 0.43568960835151255, 0.038452460685844056, -0.11948939622817124, -0.027847051241316454, 0.049312538937724984, 0.017015922424480568, -0.020073251976164126, -0.008691538302863684, 0.007283017155944007, 0.0036638635291587457, -0.002236842519594617, -0.0012520730398850818, 0.0005577204869484765, 0.0003381080420145401, -0.00010766668137712068, -6.942759574780768e-05, 1.503949885335962e-05, 1.0185919231767138e-05, -1.3493521791802846e-06, -9.510573210512222e-07, 5.829773387691354e-08, 4.2466588505053215e-08]]], "coif12": [[[1.037010009101513e-08, -1.3976374181436278e-08, -2.531117984656268e-07, 3.510411417820054e-07, 2.965411949878776e-06, -4.255365106601994e-06, -2.2199299361439428e-05, 3.3195586707854686e-05, 0.00011925526520634742, -0.00018759057842499834, -0.0004894690765309505, 0.0008204877603314604, 0.0015956995222675778, -0.0029033496249956684, -0.004241021014921407, 0.008608649814937598, 0.009359630574317225, -0.022144389024790895, -0.017382714538990422, 0.05180772024804606, 0.02743798196811415, -0.12165660970268917, -0.03708505815411896, 0.43669517449050693, 0.7502707776506686, 0.4464815228895739, -0.04345493993503663, -0.13084806656615866, 0.03797767256570917, 0.05984819686064441, -0.028908947441411717, -0.02861160212351853, 0.019235228829337574, 0.013330755435505158, -0.011236928414836344, -0.006002793708808538, 0.005797853171804964, 0.002638532076072489, -0.0026630986958948283, -0.0011384852551442936, 0.001099444238862774, 0.00047699273328864105, -0.00041198987135958684, -0.00018957894275957224, 0.0001411686033736131, 6.98246553433854e-05, -4.433611442746385e-05, -2.344975069700953e-05, 1.2718544951144566e-05, 7.112977349641407e-06, -3.3062392128971766e-06, -1.935601054214237e-06, 7.708437343672786e-07, 4.6902731107106103e-07, -1.5931230530960278e-07, -1.0022581131987928e-07, 2.879531926985976e-08, 1.8654137706790354e-08, -4.4775234981507144e-09, -2.9769070322269534e-09, 5.864666471845081e-10, 3.990594029041717e-10, -6.288984311455846e-11, -4.369389307221472e-11, 5.299712095238988e-12, 3.7520235203128594e-12, -3.2900456000023057e-13, -2.3693808823010433e-13, 1.3374548129663105e-14, 9.783102459953237e-15, -2.670361623332566e-16, -1.9813377170414736e-16], [-1.9813377170414736e-16, 2.670361623332566e-16, 9.783102459953237e-15, -1.3374548129663105e-14, -2.3693808823010433e-13, 3.2900456000023057e-13, 3.7520235203128594e-12, -5.299712095238988e-12, -4.369389307221472e-11, 6.288984311455846e-11, 3.990594029041717e-10, -5.864666471845081e-10, -2.9769070322269534e-09, 4.4775234981507144e-09, 1.8654137706790354e-08, -2.879531926985976e-08, -1.0022581131987928e-07, 1.5931230530960278e-07, 4.6902731107106103e-07, -7.708437343672786e-07, -1.935601054214237e-06, 3.3062392128971766e-06, 7.112977349641407e-06, -1.2718544951144566e-05, -2.344975069700953e-05, 4.433611442746385e-05, 6.98246553433854e-05, -0.0001411686033736131, -0.00018957894275957224, 0.00041198987135958684, 0.00047699273328864105, -0.001099444238862774, -0.0011384852551442936, 0.0026630986958948283, 0.002638532076072489, -0.005797853171804964, -0.006002793708808538, 0.011236928414836344, 0.013330755435505158, -0.019235228829337574, -0.02861160212351853, 0.028908947441411717, 0.05984819686064441, -0.03797767256570917, -0.13084806656615866, 0.04345493993503663, 0.4464815228895739, -0.7502707776506686, 0.43669517449050693, 0.03708505815411896, -0.12165660970268917, -0.02743798196811415, 0.05180772024804606, 0.017382714538990422, -0.022144389024790895, -0.009359630574317225, 0.008608649814937598, 0.004241021014921407, -0.0029033496249956684, -0.0015956995222675778, 0.0008204877603314604, 0.0004894690765309505, -0.00018759057842499834, -0.00011925526520634742, 3.3195586707854686e-05, 2.2199299361439428e-05, -4.255365106601994e-06, -2.965411949878776e-06, 3.510411417820054e-07, 2.531117984656268e-07, -1.3976374181436278e-08, -1.037010009101513e-08]], [[1.037010009101513e-08, -1.3976374181436278e-08, -2.531117984656268e-07, 3.510411417820054e-07, 2.965411949878776e-06, -4.255365106601994e-06, -2.2199299361439428e-05, 3.3195586707854686e-05, 0.00011925526520634742, -0.00018759057842499834, -0.0004894690765309505, 0.0008204877603314604, 0.0015956995222675778, -0.0029033496249956684, -0.004241021014921407, 0.008608649814937598, 0.009359630574317225, -0.022144389024790895, -0.017382714538990422, 0.05180772024804606, 0.02743798196811415, -0.12165660970268917, -0.03708505815411896, 0.43669517449050693, 0.7502707776506686, 0.4464815228895739, -0.04345493993503663, -0.13084806656615866, 0.03797767256570917, 0.05984819686064441, -0.028908947441411717, -0.02861160212351853, 0.019235228829337574, 0.013330755435505158, -0.011236928414836344, -0.006002793708808538, 0.005797853171804964, 0.002638532076072489, -0.0026630986958948283, -0.0011384852551442936, 0.001099444238862774, 0.00047699273328864105, -0.00041198987135958684, -0.00018957894275957224, 0.0001411686033736131, 6.98246553433854e-05, -4.433611442746385e-05, -2.344975069700953e-05, 1.2718544951144566e-05, 7.112977349641407e-06, -3.3062392128971766e-06, -1.935601054214237e-06, 7.708437343672786e-07, 4.6902731107106103e-07, -1.5931230530960278e-07, -1.0022581131987928e-07, 2.879531926985976e-08, 1.8654137706790354e-08, -4.4775234981507144e-09, -2.9769070322269534e-09, 5.864666471845081e-10, 3.990594029041717e-10, -6.288984311455846e-11, -4.369389307221472e-11, 5.299712095238988e-12, 3.7520235203128594e-12, -3.2900456000023057e-13, -2.3693808823010433e-13, 1.3374548129663105e-14, 9.783102459953237e-15, -2.670361623332566e-16, -1.9813377170414736e-16], [-1.9813377170414736e-16, 2.670361623332566e-16, 9.783102459953237e-15, -1.3374548129663105e-14, -2.3693808823010433e-13, 3.2900456000023057e-13, 3.7520235203128594e-12, -5.299712095238988e-12, -4.369389307221472e-11, 6.288984311455846e-11, 3.990594029041717e-10, -5.864666471845081e-10, -2.9769070322269534e-09, 4.4775234981507144e-09, 1.8654137706790354e-08, -2.879531926985976e-08, -1.0022581131987928e-07, 1.5931230530960278e-07, 4.6902731107106103e-07, -7.708437343672786e-07, -1.935601054214237e-06, 3.3062392128971766e-06, 7.112977349641407e-06, -1.2718544951144566e-05, -2.344975069700953e-05, 4.433611442746385e-05, 6.98246553433854e-05, -0.0001411686033736131, -0.00018957894275957224, 0.00041198987135958684, 0.00047699273328864105, -0.001099444238862774, -0.0011384852551442936, 0.0026630986958948283, 0.002638532076072489, -0.005797853171804964, -0.006002793708808538, 0.011236928414836344, 0.013330755435505158, -0.019235228829337574, -0.02861160212351853, 0.028908947441411717, 0.05984819686064441, -0.03797767256570917, -0.13084806656615866, 0.04345493993503663, 0.4464815228895739, -0.7502707776506686, 0.43669517449050693, 0.03708505815411896, -0.12165660970268917, -0.02743798196811415, 0.05180772024804606, 0.017382714538990422, -0.022144389024790895, -0.009359630574317225, 0.008608649814937598, 0.004241021014921407, -0.0029033496249956684, -0.0015956995222675778, 0.0008204877603314604, 0.0004894690765309505, -0.00018759057842499834, -0.00011925526520634742, 3.3195586707854686e-05, 2.2199299361439428e-05, -4.255365106601994e-06, -2.965411949878776e-06, 3.510411417820054e-07, 2.531117984656268e-07, -1.3976374181436278e-08, -1.037010009101513e-08]]], "coif13": [[[-2.536460462157101e-09, 3.36329851203463e-09, 6.701078769903018e-08, -9.111838156033149e-08, -8.524405890651041e-07, 1.1938880784407088e-06, 6.9523017512637995e-06, -1.008560197073056e-05, -4.083713796575876e-05, 6.181045384455713e-05, 0.00018399068204652167, -0.00029338106939892823, -0.000661238086717906, 0.001125533913083125, 0.0019462954123873873, -0.003603311278768316, -0.004780675949334216, 0.00989833068184399, 0.009935243248428365, -0.024047340050364834, -0.017650941474490738, 0.05400870551305577, 0.02701986705945437, -0.12351915633983332, -0.03585654727086103, 0.43754954331413537, 0.7485538324581938, 0.4469451189120829, -0.041891314001197784, -0.13239268372862886, 0.03714297920870842, 0.06186422181011113, -0.02897913316298715, -0.030490095794234087, 0.01996119614595352, 0.014736317631638981, -0.012188034671027213, -0.006899115322911729, 0.006631574528454967, 0.0031508776381888974, -0.003237559413824625, -0.0014135265368952603, 0.0014301051868561214, 0.0006196153396181822, -0.0005766881259563565, -0.0002607867431764195, 0.0002139168889952906, 0.00010322189107027523, -7.32975891000369e-05, -3.7799662099993004e-05, 2.3187742509380654e-05, 1.2676538815653462e-05, -6.740799218474298e-06, -3.868533337330695e-06, 1.7875606278098434e-06, 1.0684276177195792e-06, -4.2870074334562694e-07, -2.653281517709694e-07, 9.209610667203678e-08, 5.8765319522698225e-08, -1.7530546273017996e-08, -1.1492127566309325e-08, 2.9186399704548127e-09, 1.959961326135216e-09, -4.1821465407121307e-10, -2.869880459508663e-10, 5.051249576886846e-11, 3.534700054054496e-11, -4.99908968900025e-12, -3.5608264474554287e-12, 3.891579035068562e-13, 2.8171589120208276e-13, -2.23397799523526e-14, -1.6413244059647732e-14, 8.406602973450898e-16, 6.26097167955162e-16, -1.5554270417986292e-17, -1.1730386640303018e-17], [-1.1730386640303018e-17, 1.5554270417986292e-17, 6.26097167955162e-16, -8.406602973450898e-16, -1.6413244059647732e-14, 2.23397799523526e-14, 2.8171589120208276e-13, -3.891579035068562e-13, -3.5608264474554287e-12, 4.99908968900025e-12, 3.534700054054496e-11, -5.051249576886846e-11, -2.869880459508663e-10, 4.1821465407121307e-10, 1.959961326135216e-09, -2.9186399704548127e-09, -1.1492127566309325e-08, 1.7530546273017996e-08, 5.8765319522698225e-08, -9.209610667203678e-08, -2.653281517709694e-07, 4.2870074334562694e-07, 1.0684276177195792e-06, -1.7875606278098434e-06, -3.868533337330695e-06, 6.740799218474298e-06, 1.2676538815653462e-05, -2.3187742509380654e-05, -3.7799662099993004e-05, 7.32975891000369e-05, 0.00010322189107027523, -0.0002139168889952906, -0.0002607867431764195, 0.0005766881259563565, 0.0006196153396181822, -0.0014301051868561214, -0.0014135265368952603, 0.003237559413824625, 0.0031508776381888974, -0.006631574528454967, -0.006899115322911729, 0.012188034671027213, 0.014736317631638981, -0.01996119614595352, -0.030490095794234087, 0.02897913316298715, 0.06186422181011113, -0.03714297920870842, -0.13239268372862886, 0.041891314001197784, 0.4469451189120829, -0.7485538324581938, 0.43754954331413537, 0.03585654727086103, -0.12351915633983332, -0.02701986705945437, 0.05400870551305577, 0.017650941474490738, -0.024047340050364834, -0.009935243248428365, 0.00989833068184399, 0.004780675949334216, -0.003603311278768316, -0.0019462954123873873, 0.001125533913083125, 0.000661238086717906, -0.00029338106939892823, -0.00018399068204652167, 6.181045384455713e-05, 4.083713796575876e-05, -1.008560197073056e-05, -6.9523017512637995e-06, 1.1938880784407088e-06, 8.524405890651041e-07, -9.111838156033149e-08, -6.701078769903018e-08, 3.36329851203463e-09, 2.536460462157101e-09]], [[-2.536460462157101e-09, 3.36329851203463e-09, 6.701078769903018e-08, -9.111838156033149e-08, -8.524405890651041e-07, 1.1938880784407088e-06, 6.9523017512637995e-06, -1.008560197073056e-05, -4.083713796575876e-05, 6.181045384455713e-05, 0.00018399068204652167, -0.00029338106939892823, -0.000661238086717906, 0.001125533913083125, 0.0019462954123873873, -0.003603311278768316, -0.004780675949334216, 0.00989833068184399, 0.009935243248428365, -0.024047340050364834, -0.017650941474490738, 0.05400870551305577, 0.02701986705945437, -0.12351915633983332, -0.03585654727086103, 0.43754954331413537, 0.7485538324581938, 0.4469451189120829, -0.041891314001197784, -0.13239268372862886, 0.03714297920870842, 0.06186422181011113, -0.02897913316298715, -0.030490095794234087, 0.01996119614595352, 0.014736317631638981, -0.012188034671027213, -0.006899115322911729, 0.006631574528454967, 0.0031508776381888974, -0.003237559413824625, -0.0014135265368952603, 0.0014301051868561214, 0.0006196153396181822, -0.0005766881259563565, -0.0002607867431764195, 0.0002139168889952906, 0.00010322189107027523, -7.32975891000369e-05, -3.7799662099993004e-05, 2.3187742509380654e-05, 1.2676538815653462e-05, -6.740799218474298e-06, -3.868533337330695e-06, 1.7875606278098434e-06, 1.0684276177195792e-06, -4.2870074334562694e-07, -2.653281517709694e-07, 9.209610667203678e-08, 5.8765319522698225e-08, -1.7530546273017996e-08, -1.1492127566309325e-08, 2.9186399704548127e-09, 1.959961326135216e-09, -4.1821465407121307e-10, -2.869880459508663e-10, 5.051249576886846e-11, 3.534700054054496e-11, -4.99908968900025e-12, -3.5608264474554287e-12, 3.891579035068562e-13, 2.8171589120208276e-13, -2.23397799523526e-14, -1.6413244059647732e-14, 8.406602973450898e-16, 6.26097167955162e-16, -1.5554270417986292e-17, -1.1730386640303018e-17], [-1.1730386640303018e-17, 1.5554270417986292e-17, 6.26097167955162e-16, -8.406602973450898e-16, -1.6413244059647732e-14, 2.23397799523526e-14, 2.8171589120208276e-13, -3.891579035068562e-13, -3.5608264474554287e-12, 4.99908968900025e-12, 3.534700054054496e-11, -5.051249576886846e-11, -2.869880459508663e-10, 4.1821465407121307e-10, 1.959961326135216e-09, -2.9186399704548127e-09, -1.1492127566309325e-08, 1.7530546273017996e-08, 5.8765319522698225e-08, -9.209610667203678e-08, -2.653281517709694e-07, 4.2870074334562694e-07, 1.0684276177195792e-06, -1.7875606278098434e-06, -3.868533337330695e-06, 6.740799218474298e-06, 1.2676538815653462e-05, -2.3187742509380654e-05, -3.7799662099993004e-05, 7.32975891000369e-05, 0.00010322189107027523, -0.0002139168889952906, -0.0002607867431764195, 0.0005766881259563565, 0.0006196153396181822, -0.0014301051868561214, -0.0014135265368952603, 0.003237559413824625, 0.0031508776381888974, -0.006631574528454967, -0.006899115322911729, 0.012188034671027213, 0.014736317631638981, -0.01996119614595352, -0.030490095794234087, 0.02897913316298715, 0.06186422181011113, -0.03714297920870842, -0.13239268372862886, 0.041891314001197784, 0.4469451189120829, -0.7485538324581938, 0.43754954331413537, 0.03585654727086103, -0.12351915633983332, -0.02701986705945437, 0.05400870551305577, 0.017650941474490738, -0.024047340050364834, -0.009935243248428365, 0.00989833068184399, 0.004780675949334216, -0.003603311278768316, -0.0019462954123873873, 0.001125533913083125, 0.000661238086717906, -0.00029338106939892823, -0.00018399068204652167, 6.181045384455713e-05, 4.083713796575876e-05, -1.008560197073056e-05, -6.9523017512637995e-06, 1.1938880784407088e-06, 8.524405890651041e-07, -9.111838156033149e-08, -6.701078769903018e-08, 3.36329851203463e-09, 2.536460462157101e-09]]], "coif14": [[[6.212814528402405e-10, -8.118993462836169e-10, -1.7662495148738494e-08, 2.360235756379167e-08, 2.424279845810464e-07, -3.324658385771607e-07, -2.1394639250579226e-06, 3.0247808186844957e-06, 1.3640357675528054e-05, -1.9995576397409376e-05, -6.692604993754285e-05, 0.00010248333219568599, 0.0002628623520649985, -0.00042463732869716845, -0.0008488083847885695, 0.0014661214569906416, 0.0022967107264584086, -0.004323062280774556, -0.005281202836308561, 0.01114255210951469, 0.010430949170645139, -0.02579684377082798, -0.01784235415243864, 0.05596345341137636, 0.02660154627198806, -0.12513713600885462, -0.03474484970544801, 0.43828475995016103, 0.7470249379615077, 0.4473406567537405, -0.04047709315229175, -0.13372942834321538, 0.03633187623818003, 0.063646203141354, -0.02894925613194684, -0.03220185256406462, 0.020539499874530513, 0.016067283926065306, -0.013024088005389463, -0.0077852024170722255, 0.0074157782307655, 0.0036793235019773754, -0.003814524076580171, -0.0017080538661070365, 0.0017856181989036103, 0.0007777201566101956, -0.0007668251488526076, -0.00034297286150624035, 0.0003043599006063343, 0.00014390413588042603, -0.00011221961943808774, -5.65441840412094e-05, 3.849201590195014e-05, 2.0583278936576757e-05, -1.2254515725465707e-05, -6.8957093978400805e-06, 3.602893601306652e-06, 2.1160757624955858e-06, -9.71842353346463e-07, -5.919974641332918e-07, 2.3876494051964654e-07, 1.5013413713144253e-07, -5.300650696936342e-08, -3.427757286145719e-08, 1.0538640451894265e-08, 6.987387541011994e-09, -1.8568684752939706e-09, -1.2590752100024664e-09, 2.862848247030911e-10, 1.9809120346710113e-10, -3.801184928644451e-11, -2.6789821104151334e-11, 4.257417896733187e-12, 3.051235212860773e-12, -3.9104860636051463e-13, -2.845914016875714e-13, 2.827804378477004e-14, 2.087175435684504e-14, -1.5093680534110733e-15, -1.1286067317116846e-15, 5.286274517465632e-17, 4.000437986126701e-17, -9.112090547755774e-19, -6.972752077994577e-19], [-6.972752077994577e-19, 9.112090547755774e-19, 4.000437986126701e-17, -5.286274517465632e-17, -1.1286067317116846e-15, 1.5093680534110733e-15, 2.087175435684504e-14, -2.827804378477004e-14, -2.845914016875714e-13, 3.9104860636051463e-13, 3.051235212860773e-12, -4.257417896733187e-12, -2.6789821104151334e-11, 3.801184928644451e-11, 1.9809120346710113e-10, -2.862848247030911e-10, -1.2590752100024664e-09, 1.8568684752939706e-09, 6.987387541011994e-09, -1.0538640451894265e-08, -3.427757286145719e-08, 5.300650696936342e-08, 1.5013413713144253e-07, -2.3876494051964654e-07, -5.919974641332918e-07, 9.71842353346463e-07, 2.1160757624955858e-06, -3.602893601306652e-06, -6.8957093978400805e-06, 1.2254515725465707e-05, 2.0583278936576757e-05, -3.849201590195014e-05, -5.65441840412094e-05, 0.00011221961943808774, 0.00014390413588042603, -0.0003043599006063343, -0.00034297286150624035, 0.0007668251488526076, 0.0007777201566101956, -0.0017856181989036103, -0.0017080538661070365, 0.003814524076580171, 0.0036793235019773754, -0.0074157782307655, -0.0077852024170722255, 0.013024088005389463, 0.016067283926065306, -0.020539499874530513, -0.03220185256406462, 0.02894925613194684, 0.063646203141354, -0.03633187623818003, -0.13372942834321538, 0.04047709315229175, 0.4473406567537405, -0.7470249379615077, 0.43828475995016103, 0.03474484970544801, -0.12513713600885462, -0.02660154627198806, 0.05596345341137636, 0.01784235415243864, -0.02579684377082798, -0.010430949170645139, 0.01114255210951469, 0.005281202836308561, -0.004323062280774556, -0.0022967107264584086, 0.0014661214569906416, 0.0008488083847885695, -0.00042463732869716845, -0.0002628623520649985, 0.00010248333219568599, 6.692604993754285e-05, -1.9995576397409376e-05, -1.3640357675528054e-05, 3.0247808186844957e-06, 2.1394639250579226e-06, -3.324658385771607e-07, -2.424279845810464e-07, 2.360235756379167e-08, 1.7662495148738494e-08, -8.118993462836169e-10, -6.212814528402405e-10]], [[6.212814528402405e-10, -8.118993462836169e-10, -1.7662495148738494e-08, 2.360235756379167e-08, 2.424279845810464e-07, -3.324658385771607e-07, -2.1394639250579226e-06, 3.0247808186844957e-06, 1.3640357675528054e-05, -1.9995576397409376e-05, -6.692604993754285e-05, 0.00010248333219568599, 0.0002628623520649985, -0.00042463732869716845, -0.0008488083847885695, 0.0014661214569906416, 0.0022967107264584086, -0.004323062280774556, -0.005281202836308561, 0.01114255210951469, 0.010430949170645139, -0.02579684377082798, -0.01784235415243864, 0.05596345341137636, 0.02660154627198806, -0.12513713600885462, -0.03474484970544801, 0.43828475995016103, 0.7470249379615077, 0.4473406567537405, -0.04047709315229175, -0.13372942834321538, 0.03633187623818003, 0.063646203141354, -0.02894925613194684, -0.03220185256406462, 0.020539499874530513, 0.016067283926065306, -0.013024088005389463, -0.0077852024170722255, 0.0074157782307655, 0.0036793235019773754, -0.003814524076580171, -0.0017080538661070365, 0.0017856181989036103, 0.0007777201566101956, -0.0007668251488526076, -0.00034297286150624035, 0.0003043599006063343, 0.00014390413588042603, -0.00011221961943808774, -5.65441840412094e-05, 3.849201590195014e-05, 2.0583278936576757e-05, -1.2254515725465707e-05, -6.8957093978400805e-06, 3.602893601306652e-06, 2.1160757624955858e-06, -9.71842353346463e-07, -5.919974641332918e-07, 2.3876494051964654e-07, 1.5013413713144253e-07, -5.300650696936342e-08, -3.427757286145719e-08, 1.0538640451894265e-08, 6.987387541011994e-09, -1.8568684752939706e-09, -1.2590752100024664e-09, 2.862848247030911e-10, 1.9809120346710113e-10, -3.801184928644451e-11, -2.6789821104151334e-11, 4.257417896733187e-12, 3.051235212860773e-12, -3.9104860636051463e-13, -2.845914016875714e-13, 2.827804378477004e-14, 2.087175435684504e-14, -1.5093680534110733e-15, -1.1286067317116846e-15, 5.286274517465632e-17, 4.000437986126701e-17, -9.112090547755774e-19, -6.972752077994577e-19], [-6.972752077994577e-19, 9.112090547755774e-19, 4.000437986126701e-17, -5.286274517465632e-17, -1.1286067317116846e-15, 1.5093680534110733e-15, 2.087175435684504e-14, -2.827804378477004e-14, -2.845914016875714e-13, 3.9104860636051463e-13, 3.051235212860773e-12, -4.257417896733187e-12, -2.6789821104151334e-11, 3.801184928644451e-11, 1.9809120346710113e-10, -2.862848247030911e-10, -1.2590752100024664e-09, 1.8568684752939706e-09, 6.987387541011994e-09, -1.0538640451894265e-08, -3.427757286145719e-08, 5.300650696936342e-08, 1.5013413713144253e-07, -2.3876494051964654e-07, -5.919974641332918e-07, 9.71842353346463e-07, 2.1160757624955858e-06, -3.602893601306652e-06, -6.8957093978400805e-06, 1.2254515725465707e-05, 2.0583278936576757e-05, -3.849201590195014e-05, -5.65441840412094e-05, 0.00011221961943808774, 0.00014390413588042603, -0.0003043599006063343, -0.00034297286150624035, 0.0007668251488526076, 0.0007777201566101956, -0.0017856181989036103, -0.0017080538661070365, 0.003814524076580171, 0.0036793235019773754, -0.0074157782307655, -0.0077852024170722255, 0.013024088005389463, 0.016067283926065306, -0.020539499874530513, -0.03220185256406462, 0.02894925613194684, 0.063646203141354, -0.03633187623818003, -0.13372942834321538, 0.04047709315229175, 0.4473406567537405, -0.7470249379615077, 0.43828475995016103, 0.03474484970544801, -0.12513713600885462, -0.02660154627198806, 0.05596345341137636, 0.01784235415243864, -0.02579684377082798, -0.010430949170645139, 0.01114255210951469, 0.005281202836308561, -0.004323062280774556, -0.0022967107264584086, 0.0014661214569906416, 0.0008488083847885695, -0.00042463732869716845, -0.0002628623520649985, 0.00010248333219568599, 6.692604993754285e-05, -1.9995576397409376e-05, -1.3640357675528054e-05, 3.0247808186844957e-06, 2.1394639250579226e-06, -3.324658385771607e-07, -2.424279845810464e-07, 2.360235756379167e-08, 1.7662495148738494e-08, -8.118993462836169e-10, -6.212814528402405e-10]]], "coif15": [[[-1.5236571538490177e-10, 1.9651736248532452e-10, 4.637763468611607e-09, -6.102214747289204e-09, -6.831331679744407e-08, 9.197256712539524e-08, 6.485869388545793e-07, -8.968212011102488e-07, -4.460423183361215e-06, 6.3636840151377605e-06, 2.3673215731114123e-05, -3.505374322008593e-05, -0.00010088156289150039, 0.00015621764400384816, 0.0003545813856134762, -0.0005800110441534674, -0.0010479389168413227, 0.0018356604466900303, 0.0026417538147238176, -0.005051893642506076, -0.005742902847255388, 0.012336147571654249, 0.010857812184642856, -0.02740743945377812, -0.017973423829255167, 0.05771035117514861, 0.02618853484172406, -0.12655584892864374, -0.0337324960509805, 0.43892440853136216, 0.7456522133710781, 0.44768169876169045, -0.03919056961249979, -0.1348972365781996, 0.03554988160862526, 0.0652319448331683, -0.028845673444251017, -0.03376590813619631, 0.020996338546795255, 0.01732475364848346, -0.013756093488966998, -0.008654690594816529, 0.008146642682593415, 0.0042180895009639825, -0.004384524134541961, -0.0020189297967994208, 0.0021584984665309805, 0.0009498999754877983, -0.0009790730546106287, -0.0004355429437926704, 0.00041206868138830995, 0.00019175221055863048, -0.00016180532955436765, -7.98658233350688e-05, 5.94367722239149e-05, 3.1122483672216425e-05, -2.0413990718732566e-05, -1.1267101774009072e-05, 6.534415586793016e-06, 3.772091064754691e-06, -1.939800386832085e-06, -1.1633685314082286e-06, 5.309958252905003e-07, 3.291526254111233e-07, -1.3320726739212342e-07, -8.500698229913931e-08, 3.0420306905522665e-08, 1.992151339689276e-08, -6.276946965454188e-09, -4.207104779368382e-09, 1.1601835214850227e-09, 7.940677605424421e-10, -1.9012249889043818e-10, -1.3262295239786245e-10, 2.7277991222913513e-11, 1.936074181554065e-11, -3.37280719675715e-12, -2.4321347403077765e-12, 3.52051387891066e-13, 2.575890601011181e-13, -3.015982985137597e-14, -2.236551020293379e-14, 2.0358794477130563e-15, 1.528582254287465e-15, -1.0152622757776431e-16, -7.710937330347505e-17, 3.3250227224748574e-18, 2.552475920584872e-18, -5.364244753127261e-20, -4.1590573930635623e-20], [-4.1590573930635623e-20, 5.364244753127261e-20, 2.552475920584872e-18, -3.3250227224748574e-18, -7.710937330347505e-17, 1.0152622757776431e-16, 1.528582254287465e-15, -2.0358794477130563e-15, -2.236551020293379e-14, 3.015982985137597e-14, 2.575890601011181e-13, -3.52051387891066e-13, -2.4321347403077765e-12, 3.37280719675715e-12, 1.936074181554065e-11, -2.7277991222913513e-11, -1.3262295239786245e-10, 1.9012249889043818e-10, 7.940677605424421e-10, -1.1601835214850227e-09, -4.207104779368382e-09, 6.276946965454188e-09, 1.992151339689276e-08, -3.0420306905522665e-08, -8.500698229913931e-08, 1.3320726739212342e-07, 3.291526254111233e-07, -5.309958252905003e-07, -1.1633685314082286e-06, 1.939800386832085e-06, 3.772091064754691e-06, -6.534415586793016e-06, -1.1267101774009072e-05, 2.0413990718732566e-05, 3.1122483672216425e-05, -5.94367722239149e-05, -7.98658233350688e-05, 0.00016180532955436765, 0.00019175221055863048, -0.00041206868138830995, -0.0004355429437926704, 0.0009790730546106287, 0.0009498999754877983, -0.0021584984665309805, -0.0020189297967994208, 0.004384524134541961, 0.0042180895009639825, -0.008146642682593415, -0.008654690594816529, 0.013756093488966998, 0.01732475364848346, -0.020996338546795255, -0.03376590813619631, 0.028845673444251017, 0.0652319448331683, -0.03554988160862526, -0.1348972365781996, 0.03919056961249979, 0.44768169876169045, -0.7456522133710781, 0.43892440853136216, 0.0337324960509805, -0.12655584892864374, -0.02618853484172406, 0.05771035117514861, 0.017973423829255167, -0.02740743945377812, -0.010857812184642856, 0.012336147571654249, 0.005742902847255388, -0.005051893642506076, -0.0026417538147238176, 0.0018356604466900303, 0.0010479389168413227, -0.0005800110441534674, -0.0003545813856134762, 0.00015621764400384816, 0.00010088156289150039, -3.505374322008593e-05, -2.3673215731114123e-05, 6.3636840151377605e-06, 4.460423183361215e-06, -8.968212011102488e-07, -6.485869388545793e-07, 9.197256712539524e-08, 6.831331679744407e-08, -6.102214747289204e-09, -4.637763468611607e-09, 1.9651736248532452e-10, 1.5236571538490177e-10]], [[-1.5236571538490177e-10, 1.9651736248532452e-10, 4.637763468611607e-09, -6.102214747289204e-09, -6.831331679744407e-08, 9.197256712539524e-08, 6.485869388545793e-07, -8.968212011102488e-07, -4.460423183361215e-06, 6.3636840151377605e-06, 2.3673215731114123e-05, -3.505374322008593e-05, -0.00010088156289150039, 0.00015621764400384816, 0.0003545813856134762, -0.0005800110441534674, -0.0010479389168413227, 0.0018356604466900303, 0.0026417538147238176, -0.005051893642506076, -0.005742902847255388, 0.012336147571654249, 0.010857812184642856, -0.02740743945377812, -0.017973423829255167, 0.05771035117514861, 0.02618853484172406, -0.12655584892864374, -0.0337324960509805, 0.43892440853136216, 0.7456522133710781, 0.44768169876169045, -0.03919056961249979, -0.1348972365781996, 0.03554988160862526, 0.0652319448331683, -0.028845673444251017, -0.03376590813619631, 0.020996338546795255, 0.01732475364848346, -0.013756093488966998, -0.008654690594816529, 0.008146642682593415, 0.0042180895009639825, -0.004384524134541961, -0.0020189297967994208, 0.0021584984665309805, 0.0009498999754877983, -0.0009790730546106287, -0.0004355429437926704, 0.00041206868138830995, 0.00019175221055863048, -0.00016180532955436765, -7.98658233350688e-05, 5.94367722239149e-05, 3.1122483672216425e-05, -2.0413990718732566e-05, -1.1267101774009072e-05, 6.534415586793016e-06, 3.772091064754691e-06, -1.939800386832085e-06, -1.1633685314082286e-06, 5.309958252905003e-07, 3.291526254111233e-07, -1.3320726739212342e-07, -8.500698229913931e-08, 3.0420306905522665e-08, 1.992151339689276e-08, -6.276946965454188e-09, -4.207104779368382e-09, 1.1601835214850227e-09, 7.940677605424421e-10, -1.9012249889043818e-10, -1.3262295239786245e-10, 2.7277991222913513e-11, 1.936074181554065e-11, -3.37280719675715e-12, -2.4321347403077765e-12, 3.52051387891066e-13, 2.575890601011181e-13, -3.015982985137597e-14, -2.236551020293379e-14, 2.0358794477130563e-15, 1.528582254287465e-15, -1.0152622757776431e-16, -7.710937330347505e-17, 3.3250227224748574e-18, 2.552475920584872e-18, -5.364244753127261e-20, -4.1590573930635623e-20], [-4.1590573930635623e-20, 5.364244753127261e-20, 2.552475920584872e-18, -3.3250227224748574e-18, -7.710937330347505e-17, 1.0152622757776431e-16, 1.528582254287465e-15, -2.0358794477130563e-15, -2.236551020293379e-14, 3.015982985137597e-14, 2.575890601011181e-13, -3.52051387891066e-13, -2.4321347403077765e-12, 3.37280719675715e-12, 1.936074181554065e-11, -2.7277991222913513e-11, -1.3262295239786245e-10, 1.9012249889043818e-10, 7.940677605424421e-10, -1.1601835214850227e-09, -4.207104779368382e-09, 6.276946965454188e-09, 1.992151339689276e-08, -3.0420306905522665e-08, -8.500698229913931e-08, 1.3320726739212342e-07, 3.291526254111233e-07, -5.309958252905003e-07, -1.1633685314082286e-06, 1.939800386832085e-06, 3.772091064754691e-06, -6.534415586793016e-06, -1.1267101774009072e-05, 2.0413990718732566e-05, 3.1122483672216425e-05, -5.94367722239149e-05, -7.98658233350688e-05, 0.00016180532955436765, 0.00019175221055863048, -0.00041206868138830995, -0.0004355429437926704, 0.0009790730546106287, 0.0009498999754877983, -0.0021584984665309805, -0.0020189297967994208, 0.004384524134541961, 0.0042180895009639825, -0.008146642682593415, -0.008654690594816529, 0.013756093488966998, 0.01732475364848346, -0.020996338546795255, -0.03376590813619631, 0.028845673444251017, 0.0652319448331683, -0.03554988160862526, -0.1348972365781996, 0.03919056961249979, 0.44768169876169045, -0.7456522133710781, 0.43892440853136216, 0.0337324960509805, -0.12655584892864374, -0.02618853484172406, 0.05771035117514861, 0.017973423829255167, -0.02740743945377812, -0.010857812184642856, 0.012336147571654249, 0.005742902847255388, -0.005051893642506076, -0.0026417538147238176, 0.0018356604466900303, 0.0010479389168413227, -0.0005800110441534674, -0.0003545813856134762, 0.00015621764400384816, 0.00010088156289150039, -3.505374322008593e-05, -2.3673215731114123e-05, 6.3636840151377605e-06, 4.460423183361215e-06, -8.968212011102488e-07, -6.485869388545793e-07, 9.197256712539524e-08, 6.831331679744407e-08, -6.102214747289204e-09, -4.637763468611607e-09, 1.9651736248532452e-10, 1.5236571538490177e-10]]], "coif16": [[[3.740776214156405e-11, -4.7676012848234074e-11, -1.213763349944682e-09, 1.574985240567528e-09, 1.909693969280092e-08, -2.5293812897900863e-08, -1.9408663643989093e-07, 2.6320533867728105e-07, 1.4320792047190594e-06, -1.99600860362496e-06, -8.174656304120635e-06, 1.1765624579909586e-05, 3.756395791987938e-05, -5.616532904749551e-05, -0.00014276520952053923, 0.00022347487351192206, 0.00045758095418508594, -0.0007575611156619532, -0.0012549104014289146, 0.0022280627527115925, 0.0029777774831563023, -0.005781576422578688, -0.0061672047402296405, 0.01347684513904909, 0.01122539739108762, -0.02889277993976114, -0.0180567607738234, 0.05928039565969397, 0.02578422990744645, -0.12781007706564043, -0.03280546383358694, 0.4394862290626149, 0.7444108510775944, 0.44797844765328076, -0.03801409965109623, -0.13592591498912343, 0.034799585149717135, 0.06665164158948773, -0.028687828349824907, -0.0351990273138655, 0.021353089890706896, 0.018511294910050092, -0.014395049063084732, -0.009503158857743535, 0.008823187183975602, 0.004762320192500803, -0.004940628195250106, -0.0023432001881844894, 0.0025421630161041337, 0.0011347385993702146, -0.0012098453397664975, -0.0005378608496461215, 0.0005360682879309423, 0.0002465548333905216, -0.00022237656647526452, -0.00010783305712030611, 8.66638640700267e-05, 4.450165161739414e-05, -3.1753723132732214e-05, -1.720027603845479e-05, 1.0919026051004468e-05, 6.1967347722344424e-06, -3.5111629395158586e-06, -2.073723145043526e-06, 1.0510455241801266e-06, 6.424757126690244e-07, -2.914269718183252e-07, -1.835890843628986e-07, 7.445242757454341e-08, 4.817367733205772e-08, -1.7425737163136953e-08, -1.1548600098911635e-08, 3.7128890308434562e-09, 2.5144313898152126e-09, -7.149797543708523e-10, -4.937872384599663e-10, 1.233822423910208e-10, 8.674866101263907e-11, -1.888754243442615e-11, -1.3498670292821783e-11, 2.533043295168227e-12, 1.837741692652944e-12, -2.929603467665681e-13, -2.1550866999641267e-13, 2.862384604227304e-14, 2.1327620856639504e-14, -2.297130946940807e-15, -1.7320153218245642e-15, 1.4537260798059527e-16, 1.1082430334134505e-16, -6.801835449347436e-18, -5.238852980994671e-18, 2.0917311921863158e-19, 1.626584021224701e-19, -3.171243373967865e-21, -2.4882348740871053e-21], [-2.4882348740871053e-21, 3.171243373967865e-21, 1.626584021224701e-19, -2.0917311921863158e-19, -5.238852980994671e-18, 6.801835449347436e-18, 1.1082430334134505e-16, -1.4537260798059527e-16, -1.7320153218245642e-15, 2.297130946940807e-15, 2.1327620856639504e-14, -2.862384604227304e-14, -2.1550866999641267e-13, 2.929603467665681e-13, 1.837741692652944e-12, -2.533043295168227e-12, -1.3498670292821783e-11, 1.888754243442615e-11, 8.674866101263907e-11, -1.233822423910208e-10, -4.937872384599663e-10, 7.149797543708523e-10, 2.5144313898152126e-09, -3.7128890308434562e-09, -1.1548600098911635e-08, 1.7425737163136953e-08, 4.817367733205772e-08, -7.445242757454341e-08, -1.835890843628986e-07, 2.914269718183252e-07, 6.424757126690244e-07, -1.0510455241801266e-06, -2.073723145043526e-06, 3.5111629395158586e-06, 6.1967347722344424e-06, -1.0919026051004468e-05, -1.720027603845479e-05, 3.1753723132732214e-05, 4.450165161739414e-05, -8.66638640700267e-05, -0.00010783305712030611, 0.00022237656647526452, 0.0002465548333905216, -0.0005360682879309423, -0.0005378608496461215, 0.0012098453397664975, 0.0011347385993702146, -0.0025421630161041337, -0.0023432001881844894, 0.004940628195250106, 0.004762320192500803, -0.008823187183975602, -0.009503158857743535, 0.014395049063084732, 0.018511294910050092, -0.021353089890706896, -0.0351990273138655, 0.028687828349824907, 0.06665164158948773, -0.034799585149717135, -0.13592591498912343, 0.03801409965109623, 0.44797844765328076, -0.7444108510775944, 0.4394862290626149, 0.03280546383358694, -0.12781007706564043, -0.02578422990744645, 0.05928039565969397, 0.0180567607738234, -0.02889277993976114, -0.01122539739108762, 0.01347684513904909, 0.0061672047402296405, -0.005781576422578688, -0.0029777774831563023, 0.0022280627527115925, 0.0012549104014289146, -0.0007575611156619532, -0.00045758095418508594, 0.00022347487351192206, 0.00014276520952053923, -5.616532904749551e-05, -3.756395791987938e-05, 1.1765624579909586e-05, 8.174656304120635e-06, -1.99600860362496e-06, -1.4320792047190594e-06, 2.6320533867728105e-07, 1.9408663643989093e-07, -2.5293812897900863e-08, -1.909693969280092e-08, 1.574985240567528e-09, 1.213763349944682e-09, -4.7676012848234074e-11, -3.740776214156405e-11]], [[3.740776214156405e-11, -4.7676012848234074e-11, -1.213763349944682e-09, 1.574985240567528e-09, 1.909693969280092e-08, -2.5293812897900863e-08, -1.9408663643989093e-07, 2.6320533867728105e-07, 1.4320792047190594e-06, -1.99600860362496e-06, -8.174656304120635e-06, 1.1765624579909586e-05, 3.756395791987938e-05, -5.616532904749551e-05, -0.00014276520952053923, 0.00022347487351192206, 0.00045758095418508594, -0.0007575611156619532, -0.0012549104014289146, 0.0022280627527115925, 0.0029777774831563023, -0.005781576422578688, -0.0061672047402296405, 0.01347684513904909, 0.01122539739108762, -0.02889277993976114, -0.0180567607738234, 0.05928039565969397, 0.02578422990744645, -0.12781007706564043, -0.03280546383358694, 0.4394862290626149, 0.7444108510775944, 0.44797844765328076, -0.03801409965109623, -0.13592591498912343, 0.034799585149717135, 0.06665164158948773, -0.028687828349824907, -0.0351990273138655, 0.021353089890706896, 0.018511294910050092, -0.014395049063084732, -0.009503158857743535, 0.008823187183975602, 0.004762320192500803, -0.004940628195250106, -0.0023432001881844894, 0.0025421630161041337, 0.0011347385993702146, -0.0012098453397664975, -0.0005378608496461215, 0.0005360682879309423, 0.0002465548333905216, -0.00022237656647526452, -0.00010783305712030611, 8.66638640700267e-05, 4.450165161739414e-05, -3.1753723132732214e-05, -1.720027603845479e-05, 1.0919026051004468e-05, 6.1967347722344424e-06, -3.5111629395158586e-06, -2.073723145043526e-06, 1.0510455241801266e-06, 6.424757126690244e-07, -2.914269718183252e-07, -1.835890843628986e-07, 7.445242757454341e-08, 4.817367733205772e-08, -1.7425737163136953e-08, -1.1548600098911635e-08, 3.7128890308434562e-09, 2.5144313898152126e-09, -7.149797543708523e-10, -4.937872384599663e-10, 1.233822423910208e-10, 8.674866101263907e-11, -1.888754243442615e-11, -1.3498670292821783e-11, 2.533043295168227e-12, 1.837741692652944e-12, -2.929603467665681e-13, -2.1550866999641267e-13, 2.862384604227304e-14, 2.1327620856639504e-14, -2.297130946940807e-15, -1.7320153218245642e-15, 1.4537260798059527e-16, 1.1082430334134505e-16, -6.801835449347436e-18, -5.238852980994671e-18, 2.0917311921863158e-19, 1.626584021224701e-19, -3.171243373967865e-21, -2.4882348740871053e-21], [-2.4882348740871053e-21, 3.171243373967865e-21, 1.626584021224701e-19, -2.0917311921863158e-19, -5.238852980994671e-18, 6.801835449347436e-18, 1.1082430334134505e-16, -1.4537260798059527e-16, -1.7320153218245642e-15, 2.297130946940807e-15, 2.1327620856639504e-14, -2.862384604227304e-14, -2.1550866999641267e-13, 2.929603467665681e-13, 1.837741692652944e-12, -2.533043295168227e-12, -1.3498670292821783e-11, 1.888754243442615e-11, 8.674866101263907e-11, -1.233822423910208e-10, -4.937872384599663e-10, 7.149797543708523e-10, 2.5144313898152126e-09, -3.7128890308434562e-09, -1.1548600098911635e-08, 1.7425737163136953e-08, 4.817367733205772e-08, -7.445242757454341e-08, -1.835890843628986e-07, 2.914269718183252e-07, 6.424757126690244e-07, -1.0510455241801266e-06, -2.073723145043526e-06, 3.5111629395158586e-06, 6.1967347722344424e-06, -1.0919026051004468e-05, -1.720027603845479e-05, 3.1753723132732214e-05, 4.450165161739414e-05, -8.66638640700267e-05, -0.00010783305712030611, 0.00022237656647526452, 0.0002465548333905216, -0.0005360682879309423, -0.0005378608496461215, 0.0012098453397664975, 0.0011347385993702146, -0.0025421630161041337, -0.0023432001881844894, 0.004940628195250106, 0.004762320192500803, -0.008823187183975602, -0.009503158857743535, 0.014395049063084732, 0.018511294910050092, -0.021353089890706896, -0.0351990273138655, 0.028687828349824907, 0.06665164158948773, -0.034799585149717135, -0.13592591498912343, 0.03801409965109623, 0.44797844765328076, -0.7444108510775944, 0.4394862290626149, 0.03280546383358694, -0.12781007706564043, -0.02578422990744645, 0.05928039565969397, 0.0180567607738234, -0.02889277993976114, -0.01122539739108762, 0.01347684513904909, 0.0061672047402296405, -0.005781576422578688, -0.0029777774831563023, 0.0022280627527115925, 0.0012549104014289146, -0.0007575611156619532, -0.00045758095418508594, 0.00022347487351192206, 0.00014276520952053923, -5.616532904749551e-05, -3.756395791987938e-05, 1.1765624579909586e-05, 8.174656304120635e-06, -1.99600860362496e-06, -1.4320792047190594e-06, 2.6320533867728105e-07, 1.9408663643989093e-07, -2.5293812897900863e-08, -1.909693969280092e-08, 1.574985240567528e-09, 1.213763349944682e-09, -4.7676012848234074e-11, -3.740776214156405e-11]]], "coif17": [[[-9.193044901647832e-12, 1.1589611003950017e-11, 3.16742992539928e-10, -4.0587190405967067e-10, -5.301395728318189e-09, 6.919675145357251e-09, 5.742465077331123e-08, -7.654855556872685e-08, -4.524984010195444e-07, 6.179728213804948e-07, 2.764328498891352e-06, -3.882741927783709e-06, -1.3625117490772095e-05, 1.977791990756864e-05, 5.5677347144655594e-05, -8.40349922171605e-05, -0.0001923595852477447, 0.00030426489109187585, 0.0005701892687802022, -0.0009550264124726987, -0.0014665663886605695, 0.0026379020095295557, 0.0033023194534331645, -0.0065058949128243, -0.00655615479827296, 0.014564276648080908, 0.011541898708774485, -0.030265350462571627, -0.018102118385278566, 0.060698836099323736, 0.025390658639329416, -0.1289269634440451, -0.031952352520615034, 0.439983820652042, 0.743281221441139, 0.44823872485149524, -0.036933200696832556, -0.13683866582966367, 0.034081797453796955, 0.0679296726646839, -0.02849019813685731, -0.0365158661868462, 0.021627181084123398, 0.019630293958411843, -0.014951364256061297, -0.01032766598728408, 0.009446275522838598, 0.005308007234603321, -0.005477959124841988, -0.0026781423352943918, 0.0029310184543699363, 0.001330834181963005, -0.0014555598050827946, -0.00064926747401087, 0.0006750053722876709, 0.0003080445755741306, -0.00029391737297815475, -0.0001404313649191619, 0.00012063544336913172, 6.085540589948547e-05, -4.674968583543716e-05, -2.4873607461599964e-05, 1.7094583307705573e-05, 9.54094608426775e-06, -5.88363073019203e-06, -3.422757310554498e-06, 1.8992806819779945e-06, 1.1451303776922555e-06, -5.726779955346247e-07, -3.562354702980367e-07, 1.6059153270877367e-07, 1.0269526627044103e-07, -4.169073699211024e-08, -2.732772421056791e-08, 9.970659851204182e-09, 6.682924028386819e-09, -2.1848047745514903e-09, -1.4942808790878761e-09, 4.359447175469891e-10, 3.037030461263032e-10, -7.864847350619418e-11, -5.5722043699987653e-11, 1.2721761153695078e-11, 9.153903474792874e-12, -1.826498790845331e-12, -1.3331324069830058e-12, 2.298842703415546e-13, 1.7001567646610816e-13, -2.4968201502492676e-14, -1.8692778101462477e-14, 2.292546657107991e-15, 1.7359444437405518e-15, -1.7301946960729858e-16, -1.324052488356665e-16, 1.0304394817390555e-17, 7.963782939035077e-18, -4.540571956247478e-19, -3.541741324829286e-19, 1.3159795922880464e-20, 1.0354104908732473e-20, -1.881677148105947e-22, -1.4925731767051474e-22], [-1.4925731767051474e-22, 1.881677148105947e-22, 1.0354104908732473e-20, -1.3159795922880464e-20, -3.541741324829286e-19, 4.540571956247478e-19, 7.963782939035077e-18, -1.0304394817390555e-17, -1.324052488356665e-16, 1.7301946960729858e-16, 1.7359444437405518e-15, -2.292546657107991e-15, -1.8692778101462477e-14, 2.4968201502492676e-14, 1.7001567646610816e-13, -2.298842703415546e-13, -1.3331324069830058e-12, 1.826498790845331e-12, 9.153903474792874e-12, -1.2721761153695078e-11, -5.5722043699987653e-11, 7.864847350619418e-11, 3.037030461263032e-10, -4.359447175469891e-10, -1.4942808790878761e-09, 2.1848047745514903e-09, 6.682924028386819e-09, -9.970659851204182e-09, -2.732772421056791e-08, 4.169073699211024e-08, 1.0269526627044103e-07, -1.6059153270877367e-07, -3.562354702980367e-07, 5.726779955346247e-07, 1.1451303776922555e-06, -1.8992806819779945e-06, -3.422757310554498e-06, 5.88363073019203e-06, 9.54094608426775e-06, -1.7094583307705573e-05, -2.4873607461599964e-05, 4.674968583543716e-05, 6.085540589948547e-05, -0.00012063544336913172, -0.0001404313649191619, 0.00029391737297815475, 0.0003080445755741306, -0.0006750053722876709, -0.00064926747401087, 0.0014555598050827946, 0.001330834181963005, -0.0029310184543699363, -0.0026781423352943918, 0.005477959124841988, 0.005308007234603321, -0.009446275522838598, -0.01032766598728408, 0.014951364256061297, 0.019630293958411843, -0.021627181084123398, -0.0365158661868462, 0.02849019813685731, 0.0679296726646839, -0.034081797453796955, -0.13683866582966367, 0.036933200696832556, 0.44823872485149524, -0.743281221441139, 0.439983820652042, 0.031952352520615034, -0.1289269634440451, -0.025390658639329416, 0.060698836099323736, 0.018102118385278566, -0.030265350462571627, -0.011541898708774485, 0.014564276648080908, 0.00655615479827296, -0.0065058949128243, -0.0033023194534331645, 0.0026379020095295557, 0.0014665663886605695, -0.0009550264124726987, -0.0005701892687802022, 0.00030426489109187585, 0.0001923595852477447, -8.40349922171605e-05, -5.5677347144655594e-05, 1.977791990756864e-05, 1.3625117490772095e-05, -3.882741927783709e-06, -2.764328498891352e-06, 6.179728213804948e-07, 4.524984010195444e-07, -7.654855556872685e-08, -5.742465077331123e-08, 6.919675145357251e-09, 5.301395728318189e-09, -4.0587190405967067e-10, -3.16742992539928e-10, 1.1589611003950017e-11, 9.193044901647832e-12]], [[-9.193044901647832e-12, 1.1589611003950017e-11, 3.16742992539928e-10, -4.0587190405967067e-10, -5.301395728318189e-09, 6.919675145357251e-09, 5.742465077331123e-08, -7.654855556872685e-08, -4.524984010195444e-07, 6.179728213804948e-07, 2.764328498891352e-06, -3.882741927783709e-06, -1.3625117490772095e-05, 1.977791990756864e-05, 5.5677347144655594e-05, -8.40349922171605e-05, -0.0001923595852477447, 0.00030426489109187585, 0.0005701892687802022, -0.0009550264124726987, -0.0014665663886605695, 0.0026379020095295557, 0.0033023194534331645, -0.0065058949128243, -0.00655615479827296, 0.014564276648080908, 0.011541898708774485, -0.030265350462571627, -0.018102118385278566, 0.060698836099323736, 0.025390658639329416, -0.1289269634440451, -0.031952352520615034, 0.439983820652042, 0.743281221441139, 0.44823872485149524, -0.036933200696832556, -0.13683866582966367, 0.034081797453796955, 0.0679296726646839, -0.02849019813685731, -0.0365158661868462, 0.021627181084123398, 0.019630293958411843, -0.014951364256061297, -0.01032766598728408, 0.009446275522838598, 0.005308007234603321, -0.005477959124841988, -0.0026781423352943918, 0.0029310184543699363, 0.001330834181963005, -0.0014555598050827946, -0.00064926747401087, 0.0006750053722876709, 0.0003080445755741306, -0.00029391737297815475, -0.0001404313649191619, 0.00012063544336913172, 6.085540589948547e-05, -4.674968583543716e-05, -2.4873607461599964e-05, 1.7094583307705573e-05, 9.54094608426775e-06, -5.88363073019203e-06, -3.422757310554498e-06, 1.8992806819779945e-06, 1.1451303776922555e-06, -5.726779955346247e-07, -3.562354702980367e-07, 1.6059153270877367e-07, 1.0269526627044103e-07, -4.169073699211024e-08, -2.732772421056791e-08, 9.970659851204182e-09, 6.682924028386819e-09, -2.1848047745514903e-09, -1.4942808790878761e-09, 4.359447175469891e-10, 3.037030461263032e-10, -7.864847350619418e-11, -5.5722043699987653e-11, 1.2721761153695078e-11, 9.153903474792874e-12, -1.826498790845331e-12, -1.3331324069830058e-12, 2.298842703415546e-13, 1.7001567646610816e-13, -2.4968201502492676e-14, -1.8692778101462477e-14, 2.292546657107991e-15, 1.7359444437405518e-15, -1.7301946960729858e-16, -1.324052488356665e-16, 1.0304394817390555e-17, 7.963782939035077e-18, -4.540571956247478e-19, -3.541741324829286e-19, 1.3159795922880464e-20, 1.0354104908732473e-20, -1.881677148105947e-22, -1.4925731767051474e-22], [-1.4925731767051474e-22, 1.881677148105947e-22, 1.0354104908732473e-20, -1.3159795922880464e-20, -3.541741324829286e-19, 4.540571956247478e-19, 7.963782939035077e-18, -1.0304394817390555e-17, -1.324052488356665e-16, 1.7301946960729858e-16, 1.7359444437405518e-15, -2.292546657107991e-15, -1.8692778101462477e-14, 2.4968201502492676e-14, 1.7001567646610816e-13, -2.298842703415546e-13, -1.3331324069830058e-12, 1.826498790845331e-12, 9.153903474792874e-12, -1.2721761153695078e-11, -5.5722043699987653e-11, 7.864847350619418e-11, 3.037030461263032e-10, -4.359447175469891e-10, -1.4942808790878761e-09, 2.1848047745514903e-09, 6.682924028386819e-09, -9.970659851204182e-09, -2.732772421056791e-08, 4.169073699211024e-08, 1.0269526627044103e-07, -1.6059153270877367e-07, -3.562354702980367e-07, 5.726779955346247e-07, 1.1451303776922555e-06, -1.8992806819779945e-06, -3.422757310554498e-06, 5.88363073019203e-06, 9.54094608426775e-06, -1.7094583307705573e-05, -2.4873607461599964e-05, 4.674968583543716e-05, 6.085540589948547e-05, -0.00012063544336913172, -0.0001404313649191619, 0.00029391737297815475, 0.0003080445755741306, -0.0006750053722876709, -0.00064926747401087, 0.0014555598050827946, 0.001330834181963005, -0.0029310184543699363, -0.0026781423352943918, 0.005477959124841988, 0.005308007234603321, -0.009446275522838598, -0.01032766598728408, 0.014951364256061297, 0.019630293958411843, -0.021627181084123398, -0.0365158661868462, 0.02849019813685731, 0.0679296726646839, -0.034081797453796955, -0.13683866582966367, 0.036933200696832556, 0.44823872485149524, -0.743281221441139, 0.439983820652042, 0.031952352520615034, -0.1289269634440451, -0.025390658639329416, 0.060698836099323736, 0.018102118385278566, -0.030265350462571627, -0.011541898708774485, 0.014564276648080908, 0.00655615479827296, -0.0065058949128243, -0.0033023194534331645, 0.0026379020095295557, 0.0014665663886605695, -0.0009550264124726987, -0.0005701892687802022, 0.00030426489109187585, 0.0001923595852477447, -8.40349922171605e-05, -5.5677347144655594e-05, 1.977791990756864e-05, 1.3625117490772095e-05, -3.882741927783709e-06, -2.764328498891352e-06, 6.179728213804948e-07, 4.524984010195444e-07, -7.654855556872685e-08, -5.742465077331123e-08, 6.919675145357251e-09, 5.301395728318189e-09, -4.0587190405967067e-10, -3.16742992539928e-10, 1.1589611003950017e-11, 9.193044901647832e-12]]], "bior1.1": [[[0.7071067811865476, 0.7071067811865476], [0.7071067811865476, -0.7071067811865476]], [[0.7071067811865476, 0.7071067811865476], [0.7071067811865476, -0.7071067811865476]]], "bior1.3": [[[-0.08838834764831845, 0.08838834764831845, 0.7071067811865476, 0.7071067811865476, 0.08838834764831845, -0.08838834764831845], [0.0, -0.0, 0.7071067811865476, -0.7071067811865476, 0.0, -0.0]], [[0.0, 0.0, 0.7071067811865476, 0.7071067811865476, 0.0, 0.0], [-0.08838834764831845, -0.08838834764831845, 0.7071067811865476, -0.7071067811865476, 0.08838834764831845, 0.08838834764831845]]], "bior1.5": [[[0.016572815184059706, -0.016572815184059706, -0.12153397801643785, 0.12153397801643785, 0.7071067811865476, 0.7071067811865476, 0.12153397801643785, -0.12153397801643785, -0.016572815184059706, 0.016572815184059706], [0.0, -0.0, 0.0, -0.0, 0.7071067811865476, -0.7071067811865476, 0.0, -0.0, 0.0, -0.0]], [[0.0, 0.0, 0.0, 0.0, 0.7071067811865476, 0.7071067811865476, 0.0, 0.0, 0.0, 0.0], [0.016572815184059706, 0.016572815184059706, -0.12153397801643785, -0.12153397801643785, 0.7071067811865476, -0.7071067811865476, 0.12153397801643785, 0.12153397801643785, -0.016572815184059706, -0.016572815184059706]]], "bior2.2": [[[-0.1767766952966369, 0.3535533905932738, 1.0606601717798212, 0.3535533905932738, -0.1767766952966369, 0.0], [0.0, -0.0, 0.3535533905932738, -0.7071067811865476, 0.3535533905932738, -0.0]], [[0.0, 0.3535533905932738, 0.7071067811865476, 0.3535533905932738, 0.0, 0.0], [0.0, 0.1767766952966369, 0.3535533905932738, -1.0606601717798212, 0.3535533905932738, 0.1767766952966369]]], "bior2.4": [[[0.03314563036811941, -0.06629126073623882, -0.1767766952966369, 0.4198446513295126, 0.9943689110435825, 0.4198446513295126, -0.1767766952966369, -0.06629126073623882, 0.03314563036811941, 0.0], [0.0, -0.0, 0.0, -0.0, 0.3535533905932738, -0.7071067811865476, 0.3535533905932738, -0.0, 0.0, -0.0]], [[0.0, 0.0, 0.0, 0.3535533905932738, 0.7071067811865476, 0.3535533905932738, 0.0, 0.0, 0.0, 0.0], [0.0, -0.03314563036811941, -0.06629126073623882, 0.1767766952966369, 0.4198446513295126, -0.9943689110435825, 0.4198446513295126, 0.1767766952966369, -0.06629126073623882, -0.03314563036811941]]], "bior2.6": [[[-0.006905339660024878, 0.013810679320049757, 0.04695630968816917, -0.1077232986963881, -0.16987135563661201, 0.4474660099696121, 0.966747552403483, 0.4474660099696121, -0.16987135563661201, -0.1077232986963881, 0.04695630968816917, 0.013810679320049757, -0.006905339660024878, 0.0], [0.0, -0.0, 0.0, -0.0, 0.0, -0.0, 0.3535533905932738, -0.7071067811865476, 0.3535533905932738, -0.0, 0.0, -0.0, 0.0, -0.0]], [[0.0, 0.0, 0.0, 0.0, 0.0, 0.3535533905932738, 0.7071067811865476, 0.3535533905932738, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.006905339660024878, 0.013810679320049757, -0.04695630968816917, -0.1077232986963881, 0.16987135563661201, 0.4474660099696121, -0.966747552403483, 0.4474660099696121, 0.16987135563661201, -0.1077232986963881, -0.04695630968816917, 0.013810679320049757, 0.006905339660024878]]], "bior2.8": [[[0.0015105430506304422, -0.0030210861012608843, -0.012947511862546647, 0.02891610982635418, 0.05299848189069094, -0.13491307360773605, -0.16382918343409023, 0.46257144047591653, 0.9516421218971786, 0.46257144047591653, -0.16382918343409023, -0.13491307360773605, 0.05299848189069094, 0.02891610982635418, -0.012947511862546647, -0.0030210861012608843, 0.0015105430506304422, 0.0], [0.0, -0.0, 0.0, -0.0, 0.0, -0.0, 0.0, -0.0, 0.3535533905932738, -0.7071067811865476, 0.3535533905932738, -0.0, 0.0, -0.0, 0.0, -0.0, 0.0, -0.0]], [[0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.3535533905932738, 0.7071067811865476, 0.3535533905932738, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, -0.0015105430506304422, -0.0030210861012608843, 0.012947511862546647, 0.02891610982635418, -0.05299848189069094, -0.13491307360773605, 0.16382918343409023, 0.46257144047591653, -0.9516421218971786, 0.46257144047591653, 0.16382918343409023, -0.13491307360773605, -0.05299848189069094, 0.02891610982635418, 0.012947511862546647, -0.0030210861012608843, -0.0015105430506304422]]], "bior3.1": [[[-0.3535533905932738, 1.0606601717798212, 1.0606601717798212, -0.3535533905932738], [0.1767766952966369, -0.5303300858899106, 0.5303300858899106, -0.1767766952966369]], [[0.1767766952966369, 0.5303300858899106, 0.5303300858899106, 0.1767766952966369], [-0.3535533905932738, -1.0606601717798212, 1.0606601717798212, 0.3535533905932738]]], "bior3.3": [[[0.06629126073623882, -0.1988737822087165, -0.15467960838455727, 0.9943689110435825, 0.9943689110435825, -0.15467960838455727, -0.1988737822087165, 0.06629126073623882], [0.0, -0.0, 0.1767766952966369, -0.5303300858899106, 0.5303300858899106, -0.1767766952966369, 0.0, -0.0]], [[0.0, 0.0, 0.1767766952966369, 0.5303300858899106, 0.5303300858899106, 0.1767766952966369, 0.0, 0.0], [0.06629126073623882, 0.1988737822087165, -0.15467960838455727, -0.9943689110435825, 0.9943689110435825, 0.15467960838455727, -0.1988737822087165, -0.06629126073623882]]], "bior3.5": [[[-0.013810679320049757, 0.04143203796014927, 0.052480581416189075, -0.26792717880896527, -0.07181553246425873, 0.966747552403483, 0.966747552403483, -0.07181553246425873, -0.26792717880896527, 0.052480581416189075, 0.04143203796014927, -0.013810679320049757], [0.0, -0.0, 0.0, -0.0, 0.1767766952966369, -0.5303300858899106, 0.5303300858899106, -0.1767766952966369, 0.0, -0.0, 0.0, -0.0]], [[0.0, 0.0, 0.0, 0.0, 0.1767766952966369, 0.5303300858899106, 0.5303300858899106, 0.1767766952966369, 0.0, 0.0, 0.0, 0.0], [-0.013810679320049757, -0.04143203796014927, 0.052480581416189075, 0.26792717880896527, -0.07181553246425873, -0.966747552403483, 0.966747552403483, 0.07181553246425873, -0.26792717880896527, -0.052480581416189075, 0.04143203796014927, 0.013810679320049757]]], "bior3.7": [[[0.0030210861012608843, -0.009063258303782653, -0.01683176542131064, 0.074663985074019, 0.03133297870736289, -0.301159125922835, -0.02649924094534547, 0.9516421218971786, 0.9516421218971786, -0.02649924094534547, -0.301159125922835, 0.03133297870736289, 0.074663985074019, -0.01683176542131064, -0.009063258303782653, 0.0030210861012608843], [0.0, -0.0, 0.0, -0.0, 0.0, -0.0, 0.1767766952966369, -0.5303300858899106, 0.5303300858899106, -0.1767766952966369, 0.0, -0.0, 0.0, -0.0, 0.0, -0.0]], [[0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1767766952966369, 0.5303300858899106, 0.5303300858899106, 0.1767766952966369, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0030210861012608843, 0.009063258303782653, -0.01683176542131064, -0.074663985074019, 0.03133297870736289, 0.301159125922835, -0.02649924094534547, -0.9516421218971786, 0.9516421218971786, 0.02649924094534547, -0.301159125922835, -0.03133297870736289, 0.074663985074019, 0.01683176542131064, -0.009063258303782653, -0.0030210861012608843]]], "bior3.9": [[[-0.0006797443727836989, 0.002039233118351097, 0.005060319219611981, -0.020618912641105536, -0.014112787930175844, 0.09913478249423216, 0.012300136269419315, -0.32019196836077857, 0.0020500227115698858, 0.9421257006782068, 0.9421257006782068, 0.0020500227115698858, -0.32019196836077857, 0.012300136269419315, 0.09913478249423216, -0.014112787930175844, -0.020618912641105536, 0.005060319219611981, 0.002039233118351097, -0.0006797443727836989], [0.0, -0.0, 0.0, -0.0, 0.0, -0.0, 0.0, -0.0, 0.1767766952966369, -0.5303300858899106, 0.5303300858899106, -0.1767766952966369, 0.0, -0.0, 0.0, -0.0, 0.0, -0.0, 0.0, -0.0]], [[0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1767766952966369, 0.5303300858899106, 0.5303300858899106, 0.1767766952966369, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [-0.0006797443727836989, -0.002039233118351097, 0.005060319219611981, 0.020618912641105536, -0.014112787930175844, -0.09913478249423216, 0.012300136269419315, 0.32019196836077857, 0.0020500227115698858, -0.9421257006782068, 0.9421257006782068, -0.0020500227115698858, -0.32019196836077857, -0.012300136269419315, 0.09913478249423216, 0.014112787930175844, -0.020618912641105536, -0.005060319219611981, 0.002039233118351097, 0.0006797443727836989]]], "bior4.4": [[[0.03782845550726404, -0.023849465019556843, -0.11062440441843718, 0.37740285561283066, 0.8526986790088938, 0.37740285561283066, -0.11062440441843718, -0.023849465019556843, 0.03782845550726404, 0.0], [0.0, -0.0, -0.06453888262869706, 0.04068941760916406, 0.41809227322161724, -0.7884856164055829, 0.41809227322161724, 0.04068941760916406, -0.06453888262869706, -0.0]], [[0.0, -0.06453888262869706, -0.04068941760916406, 0.41809227322161724, 0.7884856164055829, 0.41809227322161724, -0.04068941760916406, -0.06453888262869706, 0.0, 0.0], [0.0, -0.03782845550726404, -0.023849465019556843, 0.11062440441843718, 0.37740285561283066, -0.8526986790088938, 0.37740285561283066, 0.11062440441843718, -0.023849465019556843, -0.03782845550726404]]], "bior5.5": [[[0.0, 0.03968708834740544, 0.007948108637240322, -0.05446378846823691, 0.34560528195603346, 0.7366601814282105, 0.34560528195603346, -0.05446378846823691, 0.007948108637240322, 0.03968708834740544, 0.0, 0.0], [0.0, -0.013456709459118716, -0.002694966880111507, 0.13670658466432914, -0.09350469740093886, -0.47680326579848425, 0.8995061097486484, -0.47680326579848425, -0.09350469740093886, 0.13670658466432914, -0.002694966880111507, -0.013456709459118716]], [[0.013456709459118716, -0.002694966880111507, -0.13670658466432914, -0.09350469740093886, 0.47680326579848425, 0.8995061097486484, 0.47680326579848425, -0.09350469740093886, -0.13670658466432914, -0.002694966880111507, 0.013456709459118716, 0.0], [0.0, -0.0, 0.03968708834740544, -0.007948108637240322, -0.05446378846823691, -0.34560528195603346, 0.7366601814282105, -0.34560528195603346, -0.05446378846823691, -0.007948108637240322, 0.03968708834740544, -0.0]]], "bior6.8": [[[0.0019088317364812906, -0.0019142861290887667, -0.016990639867602342, 0.01193456527972926, 0.04973290349094079, -0.07726317316720414, -0.09405920349573646, 0.4207962846098268, 0.8259229974584023, 0.4207962846098268, -0.09405920349573646, -0.07726317316720414, 0.04973290349094079, 0.01193456527972926, -0.016990639867602342, -0.0019142861290887667, 0.0019088317364812906, 0.0], [0.0, -0.0, 0.0, -0.0, 0.014426282505624435, -0.014467504896790148, -0.07872200106262882, 0.04036797903033992, 0.41784910915027457, -0.7589077294536541, 0.41784910915027457, 0.04036797903033992, -0.07872200106262882, -0.014467504896790148, 0.014426282505624435, -0.0, 0.0, -0.0]], [[0.0, 0.0, 0.0, 0.014426282505624435, 0.014467504896790148, -0.07872200106262882, -0.04036797903033992, 0.41784910915027457, 0.7589077294536541, 0.41784910915027457, -0.04036797903033992, -0.07872200106262882, 0.014467504896790148, 0.014426282505624435, 0.0, 0.0, 0.0, 0.0], [0.0, -0.0019088317364812906, -0.0019142861290887667, 0.016990639867602342, 0.01193456527972926, -0.04973290349094079, -0.07726317316720414, 0.09405920349573646, 0.4207962846098268, -0.8259229974584023, 0.4207962846098268, 0.09405920349573646, -0.07726317316720414, -0.04973290349094079, 0.01193456527972926, 0.016990639867602342, -0.0019142861290887667, -0.0019088317364812906]]], "rbio1.1": [[[0.7071067811865476, 0.7071067811865476], [0.7071067811865476, -0.7071067811865476]], [[0.7071067811865476, 0.7071067811865476], [0.7071067811865476, -0.7071067811865476]]], "rbio1.3": [[[0.0, 0.0, 0.7071067811865476, 0.7071067811865476, 0.0, 0.0], [-0.08838834764831845, -0.08838834764831845, 0.7071067811865476, -0.7071067811865476, 0.08838834764831845, 0.08838834764831845]], [[-0.08838834764831845, 0.08838834764831845, 0.7071067811865476, 0.7071067811865476, 0.08838834764831845, -0.08838834764831845], [0.0, -0.0, 0.7071067811865476, -0.7071067811865476, 0.0, -0.0]]], "rbio1.5": [[[0.0, 0.0, 0.0, 0.0, 0.7071067811865476, 0.7071067811865476, 0.0, 0.0, 0.0, 0.0], [0.016572815184059706, 0.016572815184059706, -0.12153397801643785, -0.12153397801643785, 0.7071067811865476, -0.7071067811865476, 0.12153397801643785, 0.12153397801643785, -0.016572815184059706, -0.016572815184059706]], [[0.016572815184059706, -0.016572815184059706, -0.12153397801643785, 0.12153397801643785, 0.7071067811865476, 0.7071067811865476, 0.12153397801643785, -0.12153397801643785, -0.016572815184059706, 0.016572815184059706], [0.0, -0.0, 0.0, -0.0, 0.7071067811865476, -0.7071067811865476, 0.0, -0.0, 0.0, -0.0]]], "rbio2.2": [[[0.0, 0.3535533905932738, 0.7071067811865476, 0.3535533905932738, 0.0, 0.0], [0.0, 0.1767766952966369, 0.3535533905932738, -1.0606601717798212, 0.3535533905932738, 0.1767766952966369]], [[-0.1767766952966369, 0.3535533905932738, 1.0606601717798212, 0.3535533905932738, -0.1767766952966369, 0.0], [0.0, -0.0, 0.3535533905932738, -0.7071067811865476, 0.3535533905932738, -0.0]]], "rbio2.4": [[[0.0, 0.0, 0.0, 0.3535533905932738, 0.7071067811865476, 0.3535533905932738, 0.0, 0.0, 0.0, 0.0], [0.0, -0.03314563036811941, -0.06629126073623882, 0.1767766952966369, 0.4198446513295126, -0.9943689110435825, 0.4198446513295126, 0.1767766952966369, -0.06629126073623882, -0.03314563036811941]], [[0.03314563036811941, -0.06629126073623882, -0.1767766952966369, 0.4198446513295126, 0.9943689110435825, 0.4198446513295126, -0.1767766952966369, -0.06629126073623882, 0.03314563036811941, 0.0], [0.0, -0.0, 0.0, -0.0, 0.3535533905932738, -0.7071067811865476, 0.3535533905932738, -0.0, 0.0, -0.0]]], "rbio2.6": [[[0.0, 0.0, 0.0, 0.0, 0.0, 0.3535533905932738, 0.7071067811865476, 0.3535533905932738, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.006905339660024878, 0.013810679320049757, -0.04695630968816917, -0.1077232986963881, 0.16987135563661201, 0.4474660099696121, -0.966747552403483, 0.4474660099696121, 0.16987135563661201, -0.1077232986963881, -0.04695630968816917, 0.013810679320049757, 0.006905339660024878]], [[-0.006905339660024878, 0.013810679320049757, 0.04695630968816917, -0.1077232986963881, -0.16987135563661201, 0.4474660099696121, 0.966747552403483, 0.4474660099696121, -0.16987135563661201, -0.1077232986963881, 0.04695630968816917, 0.013810679320049757, -0.006905339660024878, 0.0], [0.0, -0.0, 0.0, -0.0, 0.0, -0.0, 0.3535533905932738, -0.7071067811865476, 0.3535533905932738, -0.0, 0.0, -0.0, 0.0, -0.0]]], "rbio2.8": [[[0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.3535533905932738, 0.7071067811865476, 0.3535533905932738, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, -0.0015105430506304422, -0.0030210861012608843, 0.012947511862546647, 0.02891610982635418, -0.05299848189069094, -0.13491307360773605, 0.16382918343409023, 0.46257144047591653, -0.9516421218971786, 0.46257144047591653, 0.16382918343409023, -0.13491307360773605, -0.05299848189069094, 0.02891610982635418, 0.012947511862546647, -0.0030210861012608843, -0.0015105430506304422]], [[0.0015105430506304422, -0.0030210861012608843, -0.012947511862546647, 0.02891610982635418, 0.05299848189069094, -0.13491307360773605, -0.16382918343409023, 0.46257144047591653, 0.9516421218971786, 0.46257144047591653, -0.16382918343409023, -0.13491307360773605, 0.05299848189069094, 0.02891610982635418, -0.012947511862546647, -0.0030210861012608843, 0.0015105430506304422, 0.0], [0.0, -0.0, 0.0, -0.0, 0.0, -0.0, 0.0, -0.0, 0.3535533905932738, -0.7071067811865476, 0.3535533905932738, -0.0, 0.0, -0.0, 0.0, -0.0, 0.0, -0.0]]], "rbio3.1": [[[0.1767766952966369, 0.5303300858899106, 0.5303300858899106, 0.1767766952966369], [-0.3535533905932738, -1.0606601717798212, 1.0606601717798212, 0.3535533905932738]], [[-0.3535533905932738, 1.0606601717798212, 1.0606601717798212, -0.3535533905932738], [0.1767766952966369, -0.5303300858899106, 0.5303300858899106, -0.1767766952966369]]], "rbio3.3": [[[0.0, 0.0, 0.1767766952966369, 0.5303300858899106, 0.5303300858899106, 0.1767766952966369, 0.0, 0.0], [0.06629126073623882, 0.1988737822087165, -0.15467960838455727, -0.9943689110435825, 0.9943689110435825, 0.15467960838455727, -0.1988737822087165, -0.06629126073623882]], [[0.06629126073623882, -0.1988737822087165, -0.15467960838455727, 0.9943689110435825, 0.9943689110435825, -0.15467960838455727, -0.1988737822087165, 0.06629126073623882], [0.0, -0.0, 0.1767766952966369, -0.5303300858899106, 0.5303300858899106, -0.1767766952966369, 0.0, -0.0]]], "rbio3.5": [[[0.0, 0.0, 0.0, 0.0, 0.1767766952966369, 0.5303300858899106, 0.5303300858899106, 0.1767766952966369, 0.0, 0.0, 0.0, 0.0], [-0.013810679320049757, -0.04143203796014927, 0.052480581416189075, 0.26792717880896527, -0.07181553246425873, -0.966747552403483, 0.966747552403483, 0.07181553246425873, -0.26792717880896527, -0.052480581416189075, 0.04143203796014927, 0.013810679320049757]], [[-0.013810679320049757, 0.04143203796014927, 0.052480581416189075, -0.26792717880896527, -0.07181553246425873, 0.966747552403483, 0.966747552403483, -0.07181553246425873, -0.26792717880896527, 0.052480581416189075, 0.04143203796014927, -0.013810679320049757], [0.0, -0.0, 0.0, -0.0, 0.1767766952966369, -0.5303300858899106, 0.5303300858899106, -0.1767766952966369, 0.0, -0.0, 0.0, -0.0]]], "rbio3.7": [[[0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1767766952966369, 0.5303300858899106, 0.5303300858899106, 0.1767766952966369, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0030210861012608843, 0.009063258303782653, -0.01683176542131064, -0.074663985074019, 0.03133297870736289, 0.301159125922835, -0.02649924094534547, -0.9516421218971786, 0.9516421218971786, 0.02649924094534547, -0.301159125922835, -0.03133297870736289, 0.074663985074019, 0.01683176542131064, -0.009063258303782653, -0.0030210861012608843]], [[0.0030210861012608843, -0.009063258303782653, -0.01683176542131064, 0.074663985074019, 0.03133297870736289, -0.301159125922835, -0.02649924094534547, 0.9516421218971786, 0.9516421218971786, -0.02649924094534547, -0.301159125922835, 0.03133297870736289, 0.074663985074019, -0.01683176542131064, -0.009063258303782653, 0.0030210861012608843], [0.0, -0.0, 0.0, -0.0, 0.0, -0.0, 0.1767766952966369, -0.5303300858899106, 0.5303300858899106, -0.1767766952966369, 0.0, -0.0, 0.0, -0.0, 0.0, -0.0]]], "rbio3.9": [[[0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1767766952966369, 0.5303300858899106, 0.5303300858899106, 0.1767766952966369, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [-0.0006797443727836989, -0.002039233118351097, 0.005060319219611981, 0.020618912641105536, -0.014112787930175844, -0.09913478249423216, 0.012300136269419315, 0.32019196836077857, 0.0020500227115698858, -0.9421257006782068, 0.9421257006782068, -0.0020500227115698858, -0.32019196836077857, -0.012300136269419315, 0.09913478249423216, 0.014112787930175844, -0.020618912641105536, -0.005060319219611981, 0.002039233118351097, 0.0006797443727836989]], [[-0.0006797443727836989, 0.002039233118351097, 0.005060319219611981, -0.020618912641105536, -0.014112787930175844, 0.09913478249423216, 0.012300136269419315, -0.32019196836077857, 0.0020500227115698858, 0.9421257006782068, 0.9421257006782068, 0.0020500227115698858, -0.32019196836077857, 0.012300136269419315, 0.09913478249423216, -0.014112787930175844, -0.020618912641105536, 0.005060319219611981, 0.002039233118351097, -0.0006797443727836989], [0.0, -0.0, 0.0, -0.0, 0.0, -0.0, 0.0, -0.0, 0.1767766952966369, -0.5303300858899106, 0.5303300858899106, -0.1767766952966369, 0.0, -0.0, 0.0, -0.0, 0.0, -0.0, 0.0, -0.0]]], "rbio4.4": [[[0.0, -0.06453888262869706, -0.04068941760916406, 0.41809227322161724, 0.7884856164055829, 0.41809227322161724, -0.04068941760916406, -0.06453888262869706, 0.0, 0.0], [0.0, -0.03782845550726404, -0.023849465019556843, 0.11062440441843718, 0.37740285561283066, -0.8526986790088938, 0.37740285561283066, 0.11062440441843718, -0.023849465019556843, -0.03782845550726404]], [[0.03782845550726404, -0.023849465019556843, -0.11062440441843718, 0.37740285561283066, 0.8526986790088938, 0.37740285561283066, -0.11062440441843718, -0.023849465019556843, 0.03782845550726404, 0.0], [0.0, -0.0, -0.06453888262869706, 0.04068941760916406, 0.41809227322161724, -0.7884856164055829, 0.41809227322161724, 0.04068941760916406, -0.06453888262869706, -0.0]]], "rbio5.5": [[[0.013456709459118716, -0.002694966880111507, -0.13670658466432914, -0.09350469740093886, 0.47680326579848425, 0.8995061097486484, 0.47680326579848425, -0.09350469740093886, -0.13670658466432914, -0.002694966880111507, 0.013456709459118716, 0.0], [0.0, -0.0, 0.03968708834740544, -0.007948108637240322, -0.05446378846823691, -0.34560528195603346, 0.7366601814282105, -0.34560528195603346, -0.05446378846823691, -0.007948108637240322, 0.03968708834740544, -0.0]], [[0.0, 0.03968708834740544, 0.007948108637240322, -0.05446378846823691, 0.34560528195603346, 0.7366601814282105, 0.34560528195603346, -0.05446378846823691, 0.007948108637240322, 0.03968708834740544, 0.0, 0.0], [0.0, -0.013456709459118716, -0.002694966880111507, 0.13670658466432914, -0.09350469740093886, -0.47680326579848425, 0.8995061097486484, -0.47680326579848425, -0.09350469740093886, 0.13670658466432914, -0.002694966880111507, -0.013456709459118716]]], "rbio6.8": [[[0.0, 0.0, 0.0, 0.014426282505624435, 0.014467504896790148, -0.07872200106262882, -0.04036797903033992, 0.41784910915027457, 0.7589077294536541, 0.41784910915027457, -0.04036797903033992, -0.07872200106262882, 0.014467504896790148, 0.014426282505624435, 0.0, 0.0, 0.0, 0.0], [0.0, -0.0019088317364812906, -0.0019142861290887667, 0.016990639867602342, 0.01193456527972926, -0.04973290349094079, -0.07726317316720414, 0.09405920349573646, 0.4207962846098268, -0.8259229974584023, 0.4207962846098268, 0.09405920349573646, -0.07726317316720414, -0.04973290349094079, 0.01193456527972926, 0.016990639867602342, -0.0019142861290887667, -0.0019088317364812906]], [[0.0019088317364812906, -0.0019142861290887667, -0.016990639867602342, 0.01193456527972926, 0.04973290349094079, -0.07726317316720414, -0.09405920349573646, 0.4207962846098268, 0.8259229974584023, 0.4207962846098268, -0.09405920349573646, -0.07726317316720414, 0.04973290349094079, 0.01193456527972926, -0.016990639867602342, -0.0019142861290887667, 0.0019088317364812906, 0.0], [0.0, -0.0, 0.0, -0.0, 0.014426282505624435, -0.014467504896790148, -0.07872200106262882, 0.04036797903033992, 0.41784910915027457, -0.7589077294536541, 0.41784910915027457, 0.04036797903033992, -0.07872200106262882, -0.014467504896790148, 0.014426282505624435, -0.0, 0.0, -0.0]]]}



if __name__=='__main__':
    print(f"\n\nSupported wavelets: {list(FBimpulseResponses.keys())}")