# Security Policy

This document describes the Security Policy for ApeWorX Ltd., including vulnerability disclosures for the Ape Framework, any of its maintained plugins, or any packages we maintain used by those as dependencies.
We are committed to conduct our Security Process in a professional and civil manner.
Public shaming, under-reporting, or misrepresentation of vulnerabilities will not be tolerated.

To submit a finding, please follow the steps outlined in receiving disclosures [section](#disclosing-a-vulnerability).

## Responsible Disclosure Standard

ApeWorX follows a community [standard](https://github.com/RD-Crypto-Spec/Responsible-Disclosure#the-standard) for responsible disclosure in cryptocurrency and related software.
This document is a public commitment to following the standard.

This standard provides detailed information for:

- [Initial Contact](https://github.com/RD-Crypto-Spec/Responsible-Disclosure#initial-contact):
  how to establish initial contact with our security team.
- [Giving Details](https://github.com/RD-Crypto-Spec/Responsible-Disclosure#giving-details):
  what details to include with your vulnerability disclosure after having received a response to your initial contact.
- [Setting Dates](https://github.com/RD-Crypto-Spec/Responsible-Disclosure#setting-dates):
  how to agree on timelines for releasing updates and making details of the issue public.

Any expected deviations and necessary clarifications around the standard are explained in the following sections.

## Disclosing a Vulnerability

### Supported Versions

Ape is currently under active development, we support the latest release by major version.
Any security issues found on the latest minor version of Ape will be fixed and released in either a patch or minor release.

| Version | Supported          |
| ------- | ------------------ |
| > 0.6.x | :white_check_mark: |

### Directly to ApeWorX

ApeWorX is committed to working with researchers who submit security vulnerability notifications to us, to resolve those issues on an appropriate timeline, and to perform a coordinated release, giving credit to the reporter if they would so like.

Please submit disclosures to **all** of the following main points of contact for security related issues according to the [initial contact](https://github.com/RD-Crypto-Spec/Responsible-Disclosure#initial-contact) and [giving details](https://github.com/RD-Crypto-Spec/Responsible-Disclosure#giving-details) guidelines.

For all security related issues, ApeWorX has the following main points of contact:

| Contact                                                | Keybase                                                     |
| ------------------------------------------------------ | ----------------------------------------------------------- |
| [@fubuloubu](https://github.com/fubuloubu)             | [@fubuloubu](https://keybase.io/fubuloubu/chat)             |
| [@NotPeopling2day](https://github.com/NotPeopling2day) | [@NotPeopling2day](https://keybase.io/notpeopling2day/chat) |
| [@unparalleled-js](https://github.com/unparalleled-js) | [@Antazoey](https://keybase.io/antazoey/chat)               |

## Sending Disclosures

In the case where we become aware of security issues affecting projects using Ape, our intention is to engage in responsible disclosures with them as described in the adopted [standard](https://github.com/RD-Crypto-Spec/Responsible-Disclosure).

## Bilateral Responsible Disclosure Agreements

_ApeWorX does not currently have any established bilateral disclosure agreements._

## Bug Bounty Program

_ApeWorX does not currently have any bug bounty programs._

## Credits

Parts of this document were inspired by [Yearn's security policy](https://github.com/yearn/yearn-security/blob/master/SECURITY.md).
