from abc import abstractmethod

from ape.utils.abi import (
    LogInputABICollection,
    Struct,
    StructParser,
    is_array,
    is_dynamic_sized_type,
    is_named_tuple,
    is_struct,
    returns_array,
)
from ape.utils.basemodel import (
    BaseInterface,
    BaseInterfaceModel,
    ExtraAttributesMixin,
    ExtraModelAttributes,
    ManagerAccessMixin,
    injected_before_use,
    only_raise_attribute_error,
)
from ape.utils.github import GithubClient, github_client
from ape.utils.misc import (
    DEFAULT_LIVE_NETWORK_BASE_FEE_MULTIPLIER,
    DEFAULT_LOCAL_TRANSACTION_ACCEPTANCE_TIMEOUT,
    DEFAULT_TRANSACTION_ACCEPTANCE_TIMEOUT,
    EMPTY_BYTES32,
    SOURCE_EXCLUDE_PATTERNS,
    USER_AGENT,
    ZERO_ADDRESS,
    add_padding_to_strings,
    allow_disconnected,
    cached_property,
    extract_nested_value,
    gas_estimation_error_message,
    get_current_timestamp_ms,
    get_package_version,
    is_evm_precompile,
    is_zero_hex,
    load_config,
    log_instead_of_fail,
    nonreentrant,
    pragma_str_to_specifier_set,
    raises_not_implemented,
    run_until_complete,
    singledispatchmethod,
    stream_response,
    to_int,
)
from ape.utils.os import (
    create_tempdir,
    expand_environment_variables,
    get_all_files_in_directory,
    get_full_extension,
    get_relative_path,
    run_in_tempdir,
    use_temp_sys_path,
)
from ape.utils.process import JoinableQueue, spawn
from ape.utils.testing import (
    DEFAULT_NUMBER_OF_TEST_ACCOUNTS,
    DEFAULT_TEST_CHAIN_ID,
    DEFAULT_TEST_HD_PATH,
    DEFAULT_TEST_MNEMONIC,
    GeneratedDevAccount,
    generate_dev_accounts,
)
from ape.utils.trace import USER_ASSERT_TAG, TraceStyles, parse_coverage_tables, parse_gas_table

__all__ = [
    "abstractmethod",
    "add_padding_to_strings",
    "allow_disconnected",
    "BaseInterface",
    "BaseInterfaceModel",
    "cached_property",
    "create_tempdir",
    "DEFAULT_LIVE_NETWORK_BASE_FEE_MULTIPLIER",
    "DEFAULT_LOCAL_TRANSACTION_ACCEPTANCE_TIMEOUT",
    "DEFAULT_NUMBER_OF_TEST_ACCOUNTS",
    "DEFAULT_TEST_CHAIN_ID",
    "DEFAULT_TEST_MNEMONIC",
    "DEFAULT_TEST_HD_PATH",
    "DEFAULT_TRANSACTION_ACCEPTANCE_TIMEOUT",
    "EMPTY_BYTES32",
    "ExtraAttributesMixin",
    "expand_environment_variables",
    "extract_nested_value",
    "ExtraModelAttributes",
    "get_relative_path",
    "gas_estimation_error_message",
    "get_package_version",
    "GithubClient",
    "github_client",
    "GeneratedDevAccount",
    "generate_dev_accounts",
    "get_all_files_in_directory",
    "get_current_timestamp_ms",
    "get_full_extension",
    "pragma_str_to_specifier_set",
    "injected_before_use",
    "is_array",
    "is_dynamic_sized_type",
    "is_evm_precompile",
    "is_named_tuple",
    "is_struct",
    "is_zero_hex",
    "JoinableQueue",
    "load_config",
    "log_instead_of_fail",
    "LogInputABICollection",
    "ManagerAccessMixin",
    "nonreentrant",
    "only_raise_attribute_error",
    "parse_coverage_tables",
    "parse_gas_table",
    "raises_not_implemented",
    "returns_array",
    "run_in_tempdir",
    "run_until_complete",
    "singledispatchmethod",
    "SOURCE_EXCLUDE_PATTERNS",
    "spawn",
    "stream_response",
    "Struct",
    "StructParser",
    "to_int",
    "TraceStyles",
    "use_temp_sys_path",
    "USER_AGENT",
    "USER_ASSERT_TAG",
    "ZERO_ADDRESS",
]
