from eth_pydantic_types import HexBytes

from ape_ethereum.transactions import TransactionStatusEnum

TRACE_RESPONSE = {
    "jsonrpc": "2.0",
    "id": 7,
    "result": [
        {
            "action": {
                "from": "0x5cab1e5286529370880776461c53a0e47d74fb63",
                "callType": "call",
                "gas": "0x17e6f0",
                "input": "0x96d373e5",
                "to": "0xc17f2c69ae2e66fd87367e3260412eeff637f70e",
                "value": "0x0",
            },
            "blockHash": "0xa7e0792b07687130af6042d9e295e7a96d83a34f40fe01074348cac5c5dd0699",
            "blockNumber": 15104985,
            "result": {"gasUsed": "0x1562f0", "output": "0x"},
            "subtraces": 1,
            "traceAddress": [],
            "transactionHash": "0x3cef4aaa52b97b6b61aa32b3afcecb0d14f7862ca80fdc76504c37a9374645c4",
            "transactionPosition": 259,
            "type": "call",
        }
    ],
}
MAINNET_RECEIPT_DICT = local_receipt_data = {
    "block_number": 11279968,
    "gas_limit": 1402309,
    "gas_price": 95000000000,
    "gas_used": 1045273,
    "logs": [
        {
            "blockHash": HexBytes(
                "0x509e2a7bc82fade6f91b7c1efb47f89940efad06661bc3d1d0e8bc37e4325428"
            ),
            "address": "0xF14f0648435CF34f8bC800d4E71FF0Ba15bC52dD",
            "logIndex": 136,
            "data": "0x00000000000000000000000000000000000000000000000000479f69c6ac000000000000000000000000000000000000000000000000000000000000000000400000000000000000000000000000000000000000000000000000000000000b441cff79cd000000000000000000000000533c8844ba1922b88d892aca090df0cc0c292f1b00000000000000000000000000000000000000000000000000000000000000400000000000000000000000000000000000000000000000000000000000000ac4f708847b00000000000000000000000000000000000000000000000000000000000000800000000000000000000000004ddc2d193948926d02f9b1fe9e1daa0718270ed5000000000000000000000000f650c3d88d12db855b8bf7d11be6c55a4e07dcc90000000000000000000000000000000000000000000000000000000000000000000000000000000000000000dac17f958d2ee523a2206206994597c13d831ec7000000000000000000000000eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee000000000000000000000000000000000000000000000000000000051f4d5c0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000067a4a5343b74de28cc000000000000000000000000000003ba0319533c578527ae69bf7fa2d289f20b9b55c00000000000000000000000061935cbdd02287b511119ddb11aeb42f1593b7ef00000000000000000000000000000000000000000000000000000000000001200000000000000000000000000000000000000000068b0a6df6d303ae8900000000000000000000000000000000000000000000000000000000000000000008e8a6c3bf330000000000000000000000000000000000000000000000000000000000000060000000000000000000000000000000000000000000000000000000051f4d5c00000000000000000000000000000000000000000000000000000000000000078000000000000000000000000000000000000000000000000000000000000000020000000000000000000000000000000000000000000000000000000000000040000000000000000000000000000000000000000000000000000000000000026000000000000000000000000057845987c8c859d52931ee248d8d84ab10532407000000000000000000000000f14f0648435cf34f8bc800d4e71ff0ba15bc52dd000000000000000000000000100000000000000000000000000000000000001100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000026ac56ad607a6a00000000000000000000000000000000000000000000000000000000005209d0d7f00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005fb4acca00000000000000000000000000000000000000000000000000000175d9c171a700000000000000000000000000000000000000000000000000000000000001c0000000000000000000000000000000000000000000000000000000000000064000000000000000000000000000000000000000000000000000000000000006a000000000000000000000000000000000000000000000000000000000000006a00000000000000000000000000000000000000000000000000000000000000024f47261b0000000000000000000000000c02aaa39b223fe8d0a0e5c4f27ead9083c756cc200000000000000000000000000000000000000000000000000000000000000000000000000000000c47b7094f378e54347e281aab170e8cca69d880a000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002640810b1f010301d000000000000000000000000000000000000000000000000000000051f4d5c0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005fb4c8876573a792d8faba391a985b937c96dfe336f8022285a4e5d5fa2b07c3eef9834600000000000000000000000000000000000000000000000000000000000001c00000000000000000000000000000000000000000000000000000000000000420000000000000000000000000000000000000000000000000000000000000048000000000000000000000000000000000000000000000000000000000000004800000000000000000000000000000000000000000000000000000000000000224dc1600f3000000000000000000000000c02aaa39b223fe8d0a0e5c4f27ead9083c756cc2000000000000000000000000c47b7094f378e54347e281aab170e8cca69d880a000000000000000000000000000000000000000000000000000000000000006000000000000000000000000000000000000000000000000000000000000001a0000000000000000000000000dac17f958d2ee523a2206206994597c13d831ec7000000000000000000000000000000000000000000000000000000000000004000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000020000000000000000000000000dcd6011f4c6b80e470d9487f5871a0cba7c93f48000000000000000000000000000000000000000000000000000000051f4d5c00000000000000000000000000000000000000000000000002640810b1f010301d0000000000000000000000000000000000000000000000000000000000000080000000000000000000000000000000000000000000000000000000000000008000000000000000000000000000000000000000000000000000000000000000200000000000000000000000000000000000000000000000000000000000000002000000000000000000000000dac17f958d2ee523a2206206994597c13d831ec7000000000000000000000000c02aaa39b223fe8d0a0e5c4f27ead9083c756cc2000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000024f47261b0000000000000000000000000dac17f958d2ee523a2206206994597c13d831ec70000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002000000000000000000000000000000000000000000000000000000000000004000000000000000000000000000000000000000000000000000000000000000c000000000000000000000000000000000000000000000000000000000000000421ca1a7c12b193b68e6ac3d4269b9c1fd75051a012db63ecd99d217f7b8bc95badb74a1c07e0046c5f98f8b3acf1f745d1cc0b8950ec852ba929ca1479c6e025ff10300000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010400000000000000000000000000000000000000000000000000000000000000869584cd000000000000000000000000322d58b9e75a6918f7e7849aee0ff09369977e0800000000000000000000000000000000000000000000003cf9caf5925fb4ac6700000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
            "removed": False,
            "topics": [
                HexBytes("0x1cff79cd00000000000000000000000000000000000000000000000000000000"),
                HexBytes("0x0000000000000000000000005668ead1edb8e2a4d724c8fb9cb5ffeabeb422dc"),
                HexBytes("0x000000000000000000000000533c8844ba1922b88d892aca090df0cc0c292f1b"),
                HexBytes("0x0000000000000000000000000000000000000000000000000000000000000040"),
            ],
            "blockNumber": 11279968,
            "transactionIndex": 60,
            "transactionHash": HexBytes(
                "0x0537316f37627655b7fe5e50e23f71cd835b377d1cde4226443c94723d036e32"
            ),
        },
        {
            "blockHash": HexBytes(
                "0x509e2a7bc82fade6f91b7c1efb47f89940efad06661bc3d1d0e8bc37e4325428"
            ),
            "address": "0xf650C3d88D12dB855b8bf7D11Be6C55A4e07dCC9",
            "logIndex": 137,
            "data": "0x0000000000000000000000000000000000000000000000000000088ee804439c00000000000000000000000000000000000000000000000000000000043f9e830000000000000000000000000000000000000000000000000e80cfd37ffe100800000000000000000000000000000000000000000000000000001d139751603c",
            "removed": False,
            "topics": [
                HexBytes("0x4dec04e750ca11537cabcd8a9eab06494de08da3735bc8871cd41250e190bc04")
            ],
            "blockNumber": 11279968,
            "transactionIndex": 60,
            "transactionHash": HexBytes(
                "0x0537316f37627655b7fe5e50e23f71cd835b377d1cde4226443c94723d036e32"
            ),
        },
        {
            "blockHash": HexBytes(
                "0x509e2a7bc82fade6f91b7c1efb47f89940efad06661bc3d1d0e8bc37e4325428"
            ),
            "address": "0xc00e94Cb662C3520282E6f5717214004A7f26888",
            "logIndex": 138,
            "data": "0x000000000000000000000000000000000000000000000000064fdb83b0307d50",
            "removed": False,
            "topics": [
                HexBytes("0xddf252ad1be2c89b69c2b068fc378daa952ba7f163c4a11628f55a4df523b3ef"),
                HexBytes("0x0000000000000000000000003d9819210a31b4961b30ef54be2aed79b9c9cd3b"),
                HexBytes("0x000000000000000000000000f14f0648435cf34f8bc800d4e71ff0ba15bc52dd"),
            ],
            "blockNumber": 11279968,
            "transactionIndex": 60,
            "transactionHash": HexBytes(
                "0x0537316f37627655b7fe5e50e23f71cd835b377d1cde4226443c94723d036e32"
            ),
        },
        {
            "blockHash": HexBytes(
                "0x509e2a7bc82fade6f91b7c1efb47f89940efad06661bc3d1d0e8bc37e4325428"
            ),
            "address": "0x3d9819210A31b4961b30EF54bE2aeD79B9c9Cd3B",
            "logIndex": 139,
            "data": "0x000000000000000000000000000000000000000000000000064fdb83b0307d50000000000000000000000000000f81764ab6c0f546d710606e89bc296ba11e96",
            "removed": False,
            "topics": [
                HexBytes("0x1fc3ecc087d8d2d15e23d0032af5a47059c3892d003d8e139fdcb6bb327c99a6"),
                HexBytes("0x000000000000000000000000f650c3d88d12db855b8bf7d11be6c55a4e07dcc9"),
                HexBytes("0x000000000000000000000000f14f0648435cf34f8bc800d4e71ff0ba15bc52dd"),
            ],
            "blockNumber": 11279968,
            "transactionIndex": 60,
            "transactionHash": HexBytes(
                "0x0537316f37627655b7fe5e50e23f71cd835b377d1cde4226443c94723d036e32"
            ),
        },
        {
            "blockHash": HexBytes(
                "0x509e2a7bc82fade6f91b7c1efb47f89940efad06661bc3d1d0e8bc37e4325428"
            ),
            "address": "0xdAC17F958D2ee523a2206206994597C13D831ec7",
            "logIndex": 140,
            "data": "0x000000000000000000000000000000000000000000000000000000051f4d5c00",
            "removed": False,
            "topics": [
                HexBytes("0xddf252ad1be2c89b69c2b068fc378daa952ba7f163c4a11628f55a4df523b3ef"),
                HexBytes("0x000000000000000000000000f650c3d88d12db855b8bf7d11be6c55a4e07dcc9"),
                HexBytes("0x000000000000000000000000f14f0648435cf34f8bc800d4e71ff0ba15bc52dd"),
            ],
            "blockNumber": 11279968,
            "transactionIndex": 60,
            "transactionHash": HexBytes(
                "0x0537316f37627655b7fe5e50e23f71cd835b377d1cde4226443c94723d036e32"
            ),
        },
        {
            "blockHash": HexBytes(
                "0x509e2a7bc82fade6f91b7c1efb47f89940efad06661bc3d1d0e8bc37e4325428"
            ),
            "address": "0xf650C3d88D12dB855b8bf7D11Be6C55A4e07dCC9",
            "logIndex": 141,
            "data": "0x000000000000000000000000f14f0648435cf34f8bc800d4e71ff0ba15bc52dd000000000000000000000000000000000000000000000000000000051f4d5c000000000000000000000000000000000000000000000000000000002bee8c02a100000000000000000000000000000000000000000000000000001d18b69ebc3c",
            "removed": False,
            "topics": [
                HexBytes("0x13ed6866d4e1ee6da46f845c46d7e54120883d75c5ea9a2dacc1c4ca8984ab80")
            ],
            "blockNumber": 11279968,
            "transactionIndex": 60,
            "transactionHash": HexBytes(
                "0x0537316f37627655b7fe5e50e23f71cd835b377d1cde4226443c94723d036e32"
            ),
        },
        {
            "blockHash": HexBytes(
                "0x509e2a7bc82fade6f91b7c1efb47f89940efad06661bc3d1d0e8bc37e4325428"
            ),
            "address": "0xdAC17F958D2ee523a2206206994597C13D831ec7",
            "logIndex": 142,
            "data": "0x0000000000000000000000000000000000000000000000000000000003473bc0",
            "removed": False,
            "topics": [
                HexBytes("0xddf252ad1be2c89b69c2b068fc378daa952ba7f163c4a11628f55a4df523b3ef"),
                HexBytes("0x000000000000000000000000f14f0648435cf34f8bc800d4e71ff0ba15bc52dd"),
                HexBytes("0x000000000000000000000000322d58b9e75a6918f7e7849aee0ff09369977e08"),
            ],
            "blockNumber": 11279968,
            "transactionIndex": 60,
            "transactionHash": HexBytes(
                "0x0537316f37627655b7fe5e50e23f71cd835b377d1cde4226443c94723d036e32"
            ),
        },
        {
            "blockHash": HexBytes(
                "0x509e2a7bc82fade6f91b7c1efb47f89940efad06661bc3d1d0e8bc37e4325428"
            ),
            "address": "0xdAC17F958D2ee523a2206206994597C13D831ec7",
            "logIndex": 143,
            "data": "0x0000000000000000000000000000000000000000000000000000000000000000",
            "removed": False,
            "topics": [
                HexBytes("0x8c5be1e5ebec7d5bd14f71427d1e84f3dd0314c0f7b2291e5b200ac8c7c3b925"),
                HexBytes("0x000000000000000000000000f14f0648435cf34f8bc800d4e71ff0ba15bc52dd"),
                HexBytes("0x00000000000000000000000095e6f48254609a6ee006f7d493c8e5fb97094cef"),
            ],
            "blockNumber": 11279968,
            "transactionIndex": 60,
            "transactionHash": HexBytes(
                "0x0537316f37627655b7fe5e50e23f71cd835b377d1cde4226443c94723d036e32"
            ),
        },
        {
            "blockHash": HexBytes(
                "0x509e2a7bc82fade6f91b7c1efb47f89940efad06661bc3d1d0e8bc37e4325428"
            ),
            "address": "0xdAC17F958D2ee523a2206206994597C13D831ec7",
            "logIndex": 144,
            "data": "0x000000000000000000000000000000000000000000000000000000051c062040",
            "removed": False,
            "topics": [
                HexBytes("0x8c5be1e5ebec7d5bd14f71427d1e84f3dd0314c0f7b2291e5b200ac8c7c3b925"),
                HexBytes("0x000000000000000000000000f14f0648435cf34f8bc800d4e71ff0ba15bc52dd"),
                HexBytes("0x00000000000000000000000095e6f48254609a6ee006f7d493c8e5fb97094cef"),
            ],
            "blockNumber": 11279968,
            "transactionIndex": 60,
            "transactionHash": HexBytes(
                "0x0537316f37627655b7fe5e50e23f71cd835b377d1cde4226443c94723d036e32"
            ),
        },
        {
            "blockHash": HexBytes(
                "0x509e2a7bc82fade6f91b7c1efb47f89940efad06661bc3d1d0e8bc37e4325428"
            ),
            "address": "0x61935CbDd02287B511119DDb11Aeb42F1593b7Ef",
            "logIndex": 145,
            "data": "0x000000000000000000000000000000000000000000000000000000000000016000000000000000000000000000000000000000000000000000000000000001c000000000000000000000000000000000000000000000000000000000000002200000000000000000000000000000000000000000000000000000000000000240000000000000000000000000f14f0648435cf34f8bc800d4e71ff0ba15bc52dd000000000000000000000000f14f0648435cf34f8bc800d4e71ff0ba15bc52dd000000000000000000000000000000000000000000000002689b8d5f98f1cbc8000000000000000000000000000000000000000000000000000000051c062040000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000017a023c7c1a0000000000000000000000000000000000000000000000000000000000000000024f47261b0000000000000000000000000c02aaa39b223fe8d0a0e5c4f27ead9083c756cc2000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000024f47261b0000000000000000000000000dac17f958d2ee523a2206206994597c13d831ec70000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
            "removed": False,
            "topics": [
                HexBytes("0x6869791f0a34781b29882982cc39e882768cf2c96995c2a110c577c53bc932d5"),
                HexBytes("0x00000000000000000000000057845987c8c859d52931ee248d8d84ab10532407"),
                HexBytes("0x0000000000000000000000001000000000000000000000000000000000000011"),
                HexBytes("0x37593fc865d3f3712f13e5a5c86cca53f1728ed4484809675840433bcc9c5a30"),
            ],
            "blockNumber": 11279968,
            "transactionIndex": 60,
            "transactionHash": HexBytes(
                "0x0537316f37627655b7fe5e50e23f71cd835b377d1cde4226443c94723d036e32"
            ),
        },
        {
            "blockHash": HexBytes(
                "0x509e2a7bc82fade6f91b7c1efb47f89940efad06661bc3d1d0e8bc37e4325428"
            ),
            "address": "0xdAC17F958D2ee523a2206206994597C13D831ec7",
            "logIndex": 146,
            "data": "0x000000000000000000000000000000000000000000000000000000051c062040",
            "removed": False,
            "topics": [
                HexBytes("0xddf252ad1be2c89b69c2b068fc378daa952ba7f163c4a11628f55a4df523b3ef"),
                HexBytes("0x000000000000000000000000f14f0648435cf34f8bc800d4e71ff0ba15bc52dd"),
                HexBytes("0x00000000000000000000000057845987c8c859d52931ee248d8d84ab10532407"),
            ],
            "blockNumber": 11279968,
            "transactionIndex": 60,
            "transactionHash": HexBytes(
                "0x0537316f37627655b7fe5e50e23f71cd835b377d1cde4226443c94723d036e32"
            ),
        },
        {
            "blockHash": HexBytes(
                "0x509e2a7bc82fade6f91b7c1efb47f89940efad06661bc3d1d0e8bc37e4325428"
            ),
            "address": "0xC02aaA39b223FE8D0A0e5C4F27eAD9083C756Cc2",
            "logIndex": 147,
            "data": "0x000000000000000000000000000000000000000000000002689b8d5f98f1cbc8",
            "removed": False,
            "topics": [
                HexBytes("0xddf252ad1be2c89b69c2b068fc378daa952ba7f163c4a11628f55a4df523b3ef"),
                HexBytes("0x00000000000000000000000057845987c8c859d52931ee248d8d84ab10532407"),
                HexBytes("0x000000000000000000000000f14f0648435cf34f8bc800d4e71ff0ba15bc52dd"),
            ],
            "blockNumber": 11279968,
            "transactionIndex": 60,
            "transactionHash": HexBytes(
                "0x0537316f37627655b7fe5e50e23f71cd835b377d1cde4226443c94723d036e32"
            ),
        },
        {
            "blockHash": HexBytes(
                "0x509e2a7bc82fade6f91b7c1efb47f89940efad06661bc3d1d0e8bc37e4325428"
            ),
            "address": "0xC02aaA39b223FE8D0A0e5C4F27eAD9083C756Cc2",
            "logIndex": 148,
            "data": "0x000000000000000000000000000000000000000000000002689b8d5f98f1cbc8",
            "removed": False,
            "topics": [
                HexBytes("0x7fcf532c15f0a6db0bd6d0e038bea71d30d808c7d98cb3bf7268a95bf5081b65"),
                HexBytes("0x000000000000000000000000f14f0648435cf34f8bc800d4e71ff0ba15bc52dd"),
            ],
            "blockNumber": 11279968,
            "transactionIndex": 60,
            "transactionHash": HexBytes(
                "0x0537316f37627655b7fe5e50e23f71cd835b377d1cde4226443c94723d036e32"
            ),
        },
        {
            "blockHash": HexBytes(
                "0x509e2a7bc82fade6f91b7c1efb47f89940efad06661bc3d1d0e8bc37e4325428"
            ),
            "address": "0x4Ddc2D193948926D02f9B1fE9e1daa0718270ED5",
            "logIndex": 149,
            "data": "0x00000000000000000000000000000000000000000000000000086079fb32a6440000000000000000000000000000000000000000000000000e74838b38dfff90000000000000000000000000000000000000000000000ad7de5bcfee7eb6d2da",
            "removed": False,
            "topics": [
                HexBytes("0x875352fb3fadeb8c0be7cbbe8ff761b308fa7033470cd0287f02f3436fd76cb9")
            ],
            "blockNumber": 11279968,
            "transactionIndex": 60,
            "transactionHash": HexBytes(
                "0x0537316f37627655b7fe5e50e23f71cd835b377d1cde4226443c94723d036e32"
            ),
        },
        {
            "blockHash": HexBytes(
                "0x509e2a7bc82fade6f91b7c1efb47f89940efad06661bc3d1d0e8bc37e4325428"
            ),
            "address": "0xc00e94Cb662C3520282E6f5717214004A7f26888",
            "logIndex": 150,
            "data": "0x000000000000000000000000000000000000000000000000008bd386c2ed4798",
            "removed": False,
            "topics": [
                HexBytes("0xddf252ad1be2c89b69c2b068fc378daa952ba7f163c4a11628f55a4df523b3ef"),
                HexBytes("0x0000000000000000000000003d9819210a31b4961b30ef54be2aed79b9c9cd3b"),
                HexBytes("0x000000000000000000000000f14f0648435cf34f8bc800d4e71ff0ba15bc52dd"),
            ],
            "blockNumber": 11279968,
            "transactionIndex": 60,
            "transactionHash": HexBytes(
                "0x0537316f37627655b7fe5e50e23f71cd835b377d1cde4226443c94723d036e32"
            ),
        },
        {
            "blockHash": HexBytes(
                "0x509e2a7bc82fade6f91b7c1efb47f89940efad06661bc3d1d0e8bc37e4325428"
            ),
            "address": "0x3d9819210A31b4961b30EF54bE2aeD79B9c9Cd3B",
            "logIndex": 151,
            "data": "0x000000000000000000000000000000000000000000000000008bd386c2ed479800000000000000000000000000000b68525e31895cf9cf5c67d3bdec9b7aef76",
            "removed": False,
            "topics": [
                HexBytes("0x2caecd17d02f56fa897705dcc740da2d237c373f70686f4e0d9bd3bf0400ea7a"),
                HexBytes("0x0000000000000000000000004ddc2d193948926d02f9b1fe9e1daa0718270ed5"),
                HexBytes("0x000000000000000000000000f14f0648435cf34f8bc800d4e71ff0ba15bc52dd"),
            ],
            "blockNumber": 11279968,
            "transactionIndex": 60,
            "transactionHash": HexBytes(
                "0x0537316f37627655b7fe5e50e23f71cd835b377d1cde4226443c94723d036e32"
            ),
        },
        {
            "blockHash": HexBytes(
                "0x509e2a7bc82fade6f91b7c1efb47f89940efad06661bc3d1d0e8bc37e4325428"
            ),
            "address": "0x4Ddc2D193948926D02f9B1fE9e1daa0718270ED5",
            "logIndex": 152,
            "data": "0x000000000000000000000000f14f0648435cf34f8bc800d4e71ff0ba15bc52dd0000000000000000000000000000000000000000000000026883ed3bd1302bc800000000000000000000000000000000000000000000000000000033a46a6672",
            "removed": False,
            "topics": [
                HexBytes("0x4c209b5fc8ad50758f13e2e1088ba56a560dff690a1c6fef26394f4c03821c4f")
            ],
            "blockNumber": 11279968,
            "transactionIndex": 60,
            "transactionHash": HexBytes(
                "0x0537316f37627655b7fe5e50e23f71cd835b377d1cde4226443c94723d036e32"
            ),
        },
        {
            "blockHash": HexBytes(
                "0x509e2a7bc82fade6f91b7c1efb47f89940efad06661bc3d1d0e8bc37e4325428"
            ),
            "address": "0x4Ddc2D193948926D02f9B1fE9e1daa0718270ED5",
            "logIndex": 153,
            "data": "0x00000000000000000000000000000000000000000000000000000033a46a6672",
            "removed": False,
            "topics": [
                HexBytes("0xddf252ad1be2c89b69c2b068fc378daa952ba7f163c4a11628f55a4df523b3ef"),
                HexBytes("0x0000000000000000000000004ddc2d193948926d02f9b1fe9e1daa0718270ed5"),
                HexBytes("0x000000000000000000000000f14f0648435cf34f8bc800d4e71ff0ba15bc52dd"),
            ],
            "blockNumber": 11279968,
            "transactionIndex": 60,
            "transactionHash": HexBytes(
                "0x0537316f37627655b7fe5e50e23f71cd835b377d1cde4226443c94723d036e32"
            ),
        },
        {
            "blockHash": HexBytes(
                "0x509e2a7bc82fade6f91b7c1efb47f89940efad06661bc3d1d0e8bc37e4325428"
            ),
            "address": "0x5c55B921f590a89C1Ebe84dF170E655a82b62126",
            "logIndex": 154,
            "data": "0x00000000000000000000000000000000000000000000000000000000000000200000000000000000000000000000000000000000000000000000000000000080000000000000000000000000000000000000000000000000000000051c0620400000000000000000000000000000000000000000000000026883ed3bd1302bc8000000000000000000000000eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee000000000000000000000000dac17f958d2ee523a2206206994597c13d831ec7",
            "removed": False,
            "topics": [
                HexBytes("0xa21bd02d37a839b5f9b81157b445649b4115e939611690d8a93b46bdb035a664"),
                HexBytes("0x000000000000000000000000f14f0648435cf34f8bc800d4e71ff0ba15bc52dd"),
                HexBytes("0x0000000000000000000000005668ead1edb8e2a4d724c8fb9cb5ffeabeb422dc"),
                HexBytes("0x66688ffd4cb9146843859636430609f5de9141fe8f1ea0544ac5932d715436ef"),
            ],
            "blockNumber": 11279968,
            "transactionIndex": 60,
            "transactionHash": HexBytes(
                "0x0537316f37627655b7fe5e50e23f71cd835b377d1cde4226443c94723d036e32"
            ),
        },
    ],
    "required_confirmations": 0,
    "status": TransactionStatusEnum.NO_ERROR,
    "txn_hash": "0x0537316f37627655b7fe5e50e23f71cd835b377d1cde4226443c94723d036e32",
    "value": 20160000000000000,
    "transaction": {
        "receiver": "0xF14f0648435CF34f8bC800d4E71FF0Ba15bC52dD",
        "sender": "0x5668EAd1eDB8E2a4d724C8fb9cB5fFEabEB422dc",
        "gas_limit": 1402309,
        "nonce": 1153,
        "value": 20160000000000000,
        "data": b"\x1c\xffy\xcd\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00S<\x88D\xba\x19\"\xb8\x8d\x89*\xca\t\r\xf0\xcc\x0c)/\x1b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00@\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\n\xc4\xf7\x08\x84{\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00M\xdc-\x199H\x92m\x02\xf9\xb1\xfe\x9e\x1d\xaa\x07\x18'\x0e\xd5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf6P\xc3\xd8\x8d\x12\xdb\x85[\x8b\xf7\xd1\x1b\xe6\xc5ZN\x07\xdc\xc9\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xda\xc1\x7f\x95\x8d.\xe5#\xa2 b\x06\x99E\x97\xc1=\x83\x1e\xc7\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xee\xee\xee\xee\xee\xee\xee\xee\xee\xee\xee\xee\xee\xee\xee\xee\xee\xee\xee\xee\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x05\x1fM\\\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x06zJSC\xb7M\xe2\x8c\xc0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00;\xa01\x953\xc5xRz\xe6\x9b\xf7\xfa-(\x9f \xb9\xb5\\\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00a\x93\\\xbd\xd0\"\x87\xb5\x11\x11\x9d\xdb\x11\xae\xb4/\x15\x93\xb7\xef\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01 \x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x06\x8b\nm\xf6\xd3\x03\xae\x89\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\xe8\xa6\xc3\xbf3\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00`\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x05\x1fM\\\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x07\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00@\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02`\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00W\x84Y\x87\xc8\xc8Y\xd5)1\xee$\x8d\x8d\x84\xab\x10S$\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf1O\x06HC\\\xf3O\x8b\xc8\x00\xd4\xe7\x1f\xf0\xba\x15\xbcR\xdd\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x11\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02j\xc5j\xd6\x07\xa6\xa0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x05 \x9d\r\x7f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00_\xb4\xac\xca\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01u\xd9\xc1q\xa7\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\xc0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x06@\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x06\xa0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x06\xa0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00$\xf4ra\xb0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc0*\xaa9\xb2#\xfe\x8d\n\x0e\\O'\xea\xd9\x08<ul\xc2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc4{p\x94\xf3x\xe5CG\xe2\x81\xaa\xb1p\xe8\xcc\xa6\x9d\x88\n\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02d\x08\x10\xb1\xf0\x100\x1d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x05\x1fM\\\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00_\xb4\xc8\x87es\xa7\x92\xd8\xfa\xba9\x1a\x98[\x93|\x96\xdf\xe36\xf8\x02\"\x85\xa4\xe5\xd5\xfa+\x07\xc3\xee\xf9\x83F\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\xc0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04 \x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02$\xdc\x16\x00\xf3\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc0*\xaa9\xb2#\xfe\x8d\n\x0e\\O'\xea\xd9\x08<ul\xc2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc4{p\x94\xf3x\xe5CG\xe2\x81\xaa\xb1p\xe8\xcc\xa6\x9d\x88\n\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00`\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\xa0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xda\xc1\x7f\x95\x8d.\xe5#\xa2 b\x06\x99E\x97\xc1=\x83\x1e\xc7\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00@\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00 \x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xdc\xd6\x01\x1fLk\x80\xe4p\xd9H\x7fXq\xa0\xcb\xa7\xc9?H\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x05\x1fM\\\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02d\x08\x10\xb1\xf0\x100\x1d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00 \x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xda\xc1\x7f\x95\x8d.\xe5#\xa2 b\x06\x99E\x97\xc1=\x83\x1e\xc7\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc0*\xaa9\xb2#\xfe\x8d\n\x0e\\O'\xea\xd9\x08<ul\xc2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00$\xf4ra\xb0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xda\xc1\x7f\x95\x8d.\xe5#\xa2 b\x06\x99E\x97\xc1=\x83\x1e\xc7\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00@\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00B\x1c\xa1\xa7\xc1+\x19;h\xe6\xac=Bi\xb9\xc1\xfdu\x05\x1a\x01-\xb6>\xcd\x99\xd2\x17\xf7\xb8\xbc\x95\xba\xdbt\xa1\xc0~\x00F\xc5\xf9\x8f\x8b:\xcf\x1ft]\x1c\xc0\xb8\x95\x0e\xc8R\xba\x92\x9c\xa1G\x9cn\x02_\xf1\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x86\x95\x84\xcd\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x002-X\xb9\xe7Zi\x18\xf7\xe7\x84\x9a\xee\x0f\xf0\x93i\x97~\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00<\xf9\xca\xf5\x92_\xb4\xacg\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00",
        "type": 0,
    },
}
