from typing import TYPE_CHECKING, Any, Tuple, List

if TYPE_CHECKING:
    from ..routes import Route

class Auth:
    """Authentication facade."""

    def add_guard(name: str, guard: Any): ...
    def set_configuration(config: dict): ...
    def guard(guard: Any) -> "Auth": ...
    def get_guard(name: str = None) -> Any: ...
    def get_config_options(guard: Any = None) -> dict: ...
    def attempt(email: str, password: str, once: bool = False) -> Any: ...
    def attempt_by_id(user_id: int, once: bool = False) -> Any: ...
    def logout(self) -> "Auth":
        """Logout the current authenticated user."""
        ...
    def user(self) -> Any:
        """Get the current authenticated user."""
        ...
    def register(dictionary: dict) -> Any:
        """"""
        ...
    def password_reset(email: str) -> "Tuple[None, None]|Tuple[int,str]":
        """Reset password of the user with the given email."""
        ...
    def reset_password(password: str, token: str) -> bool:
        """Reset password of the user with the given authentication token."""
        ...
    @classmethod
    def routes(self) -> List[Route]: ...
