/**
 * @description Get a Base URL for Snyk APIs
 * @export
 * @param {string} defaultUrl URL to default to, should be the one defined in the config.default.json file
 * @param {(string | undefined)} envvarDefinedApiUrl if there is an URL defined in the SNYK_API envvar
 * @param {(string | undefined)} configDefinedApiUrl if there is an URL defined in the 'endpoint' key of the config
 * @returns {string} Returns a Base URL - without the /v1. Use this to construct derived URLs
 */
export declare function getBaseApiUrl(defaultUrl: string, envvarDefinedApiUrl?: string, configDefinedApiUrl?: string): string;
export declare function getV1ApiUrl(baseApiUrl: string): string;
/**
 * @description Return Snyk REST API URL
 * @export
 * @param {string} baseApiUrl
 * @param {string} envvarDefinedRestApiUrl
 * @param {string} envvarDefinedRestV3Url
 * @returns {string}
 */
export declare function getRestApiUrl(baseApiUrl: string, envvarDefinedRestApiUrl?: string, envvarDefinedRestV3Url?: string): string;
