# coding: utf-8

"""
    Arize REST API

    API specification for the backend data server. The API is hosted globally at https://api.arize.com/v2 or in your own environment. You can access the OpenAPI spec for this API at https://api.arize.com/v2/spec.yaml 

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class Experiment(BaseModel):
    """
    An experiment message
    """ # noqa: E501
    id: StrictStr = Field(description="Unique identifier for the experiment")
    name: StrictStr = Field(description="Name of the experiment")
    dataset_id: StrictStr = Field(description="Unique identifier for the dataset this experiment belongs to", alias="datasetId")
    dataset_version_id: StrictStr = Field(description="Unique identifier for the dataset version this experiment belongs to", alias="datasetVersionId")
    created_at: datetime = Field(description="Timestamp for when the experiment was created", alias="createdAt")
    updated_at: datetime = Field(description="Timestamp for the last update of the experiment", alias="updatedAt")
    created_by: StrictStr = Field(description="Unique identifier for the user who created the experiment", alias="createdBy")
    experiment_traces_project_id: Optional[StrictStr] = Field(default=None, description="Unique identifier for the experiment traces project this experiment belongs to (if it exists)", alias="experimentTracesProjectId")
    __properties: ClassVar[List[str]] = ["id", "name", "datasetId", "datasetVersionId", "createdAt", "updatedAt", "createdBy", "experimentTracesProjectId"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Experiment from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Experiment from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        # raise errors for additional fields in the input
        for _key in obj.keys():
            if _key not in cls.__properties:
                raise ValueError("Error due to additional fields (not defined in Experiment) in the input: " + _key)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "datasetId": obj.get("datasetId"),
            "datasetVersionId": obj.get("datasetVersionId"),
            "createdAt": obj.get("createdAt"),
            "updatedAt": obj.get("updatedAt"),
            "createdBy": obj.get("createdBy"),
            "experimentTracesProjectId": obj.get("experimentTracesProjectId")
        })
        return _obj


