# Generated by Django 2.2.23 on 2022-02-07 16:01

from django.db import migrations, models
import django.db.models.deletion
import djangoldp.fields


class Migration(migrations.Migration):

    dependencies = [
        ('djangoldp_circle', '0031_circle_parentcircle'),
        ('djangoldp_fcpe', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='EstablishmentSpaceInfo',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
            ],
            options={
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
                'depth': 0,
            },
        ),
        migrations.CreateModel(
            name='EventSpaceInfo',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
            ],
            options={
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
                'depth': 0,
            },
        ),
        migrations.CreateModel(
            name='FCPESpace',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('coverImage', models.URLField(blank=True, null=True)),
                ('category', models.CharField(choices=[('Etablissement', 'Etablissement'), ('Evenement', 'Evénement'), ('Thematique', 'Thématique')], default='Etablissement', max_length=16)),
                ('circle', models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='space', to='djangoldp_circle.Circle')),
            ],
            options={
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
                'depth': 0,
            },
        ),
        migrations.CreateModel(
            name='ThemeSpaceInfo',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('space', models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='theme_info', to='djangoldp_fcpe.FCPESpace')),
            ],
            options={
                'abstract': False,
                'default_permissions': ['add', 'change', 'delete', 'view', 'control'],
                'depth': 0,
            },
        ),
        migrations.RemoveField(
            model_name='eventspace',
            name='circle',
        ),
        migrations.RemoveField(
            model_name='themespace',
            name='circle',
        ),
        migrations.DeleteModel(
            name='EstablishmentSpace',
        ),
        migrations.DeleteModel(
            name='EventSpace',
        ),
        migrations.DeleteModel(
            name='ThemeSpace',
        ),
        migrations.AddField(
            model_name='eventspaceinfo',
            name='space',
            field=models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='event_info', to='djangoldp_fcpe.FCPESpace'),
        ),
        migrations.AddField(
            model_name='establishmentspaceinfo',
            name='space',
            field=models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='establishment_info', to='djangoldp_fcpe.FCPESpace'),
        ),
    ]
