"""Default ignore patterns for file discovery."""

from __future__ import annotations

from collections.abc import Sequence

DEFAULT_IGNORE_PATTERNS: Sequence[str] = (
    # --- Version control / metadata ---
    ".git/",
    ".gitmodules",
    ".gitattributes",
    ".gitignore",
    ".svn/",
    ".hg/",
    ".DS_Store",
    "Thumbs.db",
    # --- Python caches / envs ---
    "__pycache__/",
    "*.pyc",
    "*.pyo",
    "*.pyd",
    ".mypy_cache/",
    ".ruff_cache/",
    ".pytest_cache/",
    ".tox/",
    ".nox/",
    ".coverage",
    "htmlcov/",
    ".hypothesis/",
    ".ropeproject/",
    ".env/",
    ".venv/",
    "env/",
    "venv/",
    ".virtualenv/",
    "pip-wheel-metadata/",
    "*.egg-info/",
    "*.eggs/",
    "*.whl",
    # --- JS/TS / Frontend build artifacts ---
    "node_modules/",
    "bower_components/",
    "jspm_packages/",
    ".next/",
    ".nuxt/",
    ".svelte-kit/",
    ".angular/",
    ".vercel/",
    ".astro/",
    ".vite/",
    ".parcel-cache/",
    ".turbo/",
    ".uv-cache/",
    "out/",
    "dist/",
    "build/",
    "coverage/",
    "reports/",
    "storybook-static/",
    ".cache/",
    ".eslintcache",
    ".stylelintcache",
    # --- Dependency / lockfiles ---
    "yarn.lock",
    "package-lock.json",
    "pnpm-lock.yaml",
    "bun.lockb",
    "uv.lock",
    "poetry.lock",
    "Pipfile.lock",
    "Cargo.lock",
    "Gemfile.lock",
    "composer.lock",
    "go.sum",
    "gradle.lockfile",
    "requirements.txt~",
    "package.json~",
    # --- Gradle / Java / Kotlin ---
    ".gradle/",
    "gradlew",
    "gradlew.bat",
    "gradle.properties",
    "build/",
    "target/",
    "*.class",
    "*.jar",
    "*.war",
    "*.ear",
    "*.iml",
    ".idea/",
    ".project",
    ".classpath",
    ".settings/",
    ".metadata/",
    ".factorypath",
    "MANIFEST.MF",
    # --- Rust / Go / C / C++ / Swift ---
    "target/",
    "Cargo.lock",
    "*.o",
    "*.obj",
    "*.so",
    "*.dll",
    "*.dylib",
    "*.a",
    "*.lib",
    "*.exe",
    "*.app",
    "*.dSYM/",
    "*.ipa",
    "vendor/",
    "bin/",
    "debug/",
    "release/",
    "out/",
    "*.ninja",
    "build.ninja",
    "CMakeFiles/",
    "CMakeCache.txt",
    "Makefile",
    "meson.build",
    "meson-private/",
    "bazel-*",
    ".bazelrc",
    "buck-out/",
    ".buckconfig",
    ".cargo/",
    ".swiftpm/",
    "Package.resolved",
    # --- Static / generated assets ---
    "assets/",
    "static/",
    "media/",
    "images/",
    "fonts/",
    "videos/",
    "*.svg",
    "*.png",
    "*.jpg",
    "*.jpeg",
    "*.gif",
    "*.ico",
    "*.pdf",
    "*.mp3",
    "*.mp4",
    "*.wav",
    "*.mov",
    "*.webm",
    "*.webp",
    "*.tiff",
    "*.bmp",
    # --- Binaries / models / archives ---
    "*.bin",
    "*.pkl",
    "*.h5",
    "*.onnx",
    "*.pt",
    "*.tflite",
    "*.npy",
    "*.npz",
    "*.sqlite",
    "*.db",
    "*.mdb",
    "*.zip",
    "*.tar",
    "*.tar.gz",
    "*.7z",
    "*.rar",
    "*.gz",
    "*.bz2",
    "*.xz",
    "*.zst",
    # --- Misc tool metadata ---
    ".prettierrc*",
    ".eslintrc*",
    ".stylelintrc*",
    ".editorconfig",
    ".npmrc",
    ".yarnrc",
    ".nvmrc",
    ".python-version",
    ".tool-versions",
    ".ruff_cache/",
    ".DS_Store",
    ".vscode/",
    ".idea/",
    ".nx/",
    ".expo/",
    ".sourcemaps/",
)
