"""
Residue Bond Information Constants

This module contains bond connectivity information for standard residues
extracted from the Chemical Component Dictionary (CCD). This data is used
for molecular structure validation and bond detection in HBAT.

Generated automatically from CCD BinaryCIF files.
"""

from typing import Any, Dict, List, Union

# Bond information for standard residues
RESIDUE_BONDS: Dict[str, Dict] = {
    "A": {
        "bond_count": 39,
        "aromatic_bonds": 0,
        "bond_orders": {"sing": 34, "doub": 5},
        "bonds": [
            {"atom1": "OP3", "atom2": "P", "order": "sing", "aromatic": False},
            {"atom1": "OP3", "atom2": "HOP3", "order": "sing", "aromatic": False},
            {"atom1": "P", "atom2": "OP1", "order": "doub", "aromatic": False},
            {"atom1": "P", "atom2": "OP2", "order": "sing", "aromatic": False},
            {"atom1": "P", "atom2": "O5'", "order": "sing", "aromatic": False},
            {"atom1": "OP2", "atom2": "HOP2", "order": "sing", "aromatic": False},
            {"atom1": "O5'", "atom2": "C5'", "order": "sing", "aromatic": False},
            {"atom1": "C5'", "atom2": "C4'", "order": "sing", "aromatic": False},
            {"atom1": "C5'", "atom2": "H5'", "order": "sing", "aromatic": False},
            {"atom1": "C5'", "atom2": "H5''", "order": "sing", "aromatic": False},
            {"atom1": "C4'", "atom2": "O4'", "order": "sing", "aromatic": False},
            {"atom1": "C4'", "atom2": "C3'", "order": "sing", "aromatic": False},
            {"atom1": "C4'", "atom2": "H4'", "order": "sing", "aromatic": False},
            {"atom1": "O4'", "atom2": "C1'", "order": "sing", "aromatic": False},
            {"atom1": "C3'", "atom2": "O3'", "order": "sing", "aromatic": False},
            {"atom1": "C3'", "atom2": "C2'", "order": "sing", "aromatic": False},
            {"atom1": "C3'", "atom2": "H3'", "order": "sing", "aromatic": False},
            {"atom1": "O3'", "atom2": "HO3'", "order": "sing", "aromatic": False},
            {"atom1": "C2'", "atom2": "O2'", "order": "sing", "aromatic": False},
            {"atom1": "C2'", "atom2": "C1'", "order": "sing", "aromatic": False},
            {"atom1": "C2'", "atom2": "H2'", "order": "sing", "aromatic": False},
            {"atom1": "O2'", "atom2": "HO2'", "order": "sing", "aromatic": False},
            {"atom1": "C1'", "atom2": "N9", "order": "sing", "aromatic": False},
            {"atom1": "C1'", "atom2": "H1'", "order": "sing", "aromatic": False},
            {"atom1": "N9", "atom2": "C8", "order": "sing", "aromatic": False},
            {"atom1": "N9", "atom2": "C4", "order": "sing", "aromatic": False},
            {"atom1": "C8", "atom2": "N7", "order": "doub", "aromatic": False},
            {"atom1": "C8", "atom2": "H8", "order": "sing", "aromatic": False},
            {"atom1": "N7", "atom2": "C5", "order": "sing", "aromatic": False},
            {"atom1": "C5", "atom2": "C6", "order": "sing", "aromatic": False},
            {"atom1": "C5", "atom2": "C4", "order": "doub", "aromatic": False},
            {"atom1": "C6", "atom2": "N6", "order": "sing", "aromatic": False},
            {"atom1": "C6", "atom2": "N1", "order": "doub", "aromatic": False},
            {"atom1": "N6", "atom2": "H61", "order": "sing", "aromatic": False},
            {"atom1": "N6", "atom2": "H62", "order": "sing", "aromatic": False},
            {"atom1": "N1", "atom2": "C2", "order": "sing", "aromatic": False},
            {"atom1": "C2", "atom2": "N3", "order": "doub", "aromatic": False},
            {"atom1": "C2", "atom2": "H2", "order": "sing", "aromatic": False},
            {"atom1": "N3", "atom2": "C4", "order": "sing", "aromatic": False},
        ],
    },
    "ALA": {
        "bond_count": 14,
        "aromatic_bonds": 0,
        "bond_orders": {"sing": 13, "doub": 1},
        "bonds": [
            {"atom1": "N", "atom2": "CA", "order": "sing", "aromatic": False},
            {"atom1": "N", "atom2": "H", "order": "sing", "aromatic": False},
            {"atom1": "N", "atom2": "H2", "order": "sing", "aromatic": False},
            {"atom1": "CA", "atom2": "C", "order": "sing", "aromatic": False},
            {"atom1": "CA", "atom2": "CB", "order": "sing", "aromatic": False},
            {"atom1": "CA", "atom2": "HA", "order": "sing", "aromatic": False},
            {"atom1": "C", "atom2": "O", "order": "doub", "aromatic": False},
            {"atom1": "C", "atom2": "OXT", "order": "sing", "aromatic": False},
            {"atom1": "CB", "atom2": "HB1", "order": "sing", "aromatic": False},
            {"atom1": "CB", "atom2": "HB2", "order": "sing", "aromatic": False},
            {"atom1": "CB", "atom2": "HB3", "order": "sing", "aromatic": False},
            {"atom1": "OXT", "atom2": "HXT", "order": "sing", "aromatic": False},
            {"atom1": "H1", "atom2": "N", "order": "sing", "aromatic": False},
            {"atom1": "H3", "atom2": "N", "order": "sing", "aromatic": False},
        ],
    },
    "ARG": {
        "bond_count": 28,
        "aromatic_bonds": 0,
        "bond_orders": {"sing": 26, "doub": 2},
        "bonds": [
            {"atom1": "N", "atom2": "CA", "order": "sing", "aromatic": False},
            {"atom1": "N", "atom2": "H", "order": "sing", "aromatic": False},
            {"atom1": "N", "atom2": "H2", "order": "sing", "aromatic": False},
            {"atom1": "CA", "atom2": "C", "order": "sing", "aromatic": False},
            {"atom1": "CA", "atom2": "CB", "order": "sing", "aromatic": False},
            {"atom1": "CA", "atom2": "HA", "order": "sing", "aromatic": False},
            {"atom1": "C", "atom2": "O", "order": "doub", "aromatic": False},
            {"atom1": "C", "atom2": "OXT", "order": "sing", "aromatic": False},
            {"atom1": "CB", "atom2": "CG", "order": "sing", "aromatic": False},
            {"atom1": "CB", "atom2": "HB2", "order": "sing", "aromatic": False},
            {"atom1": "CB", "atom2": "HB3", "order": "sing", "aromatic": False},
            {"atom1": "CG", "atom2": "CD", "order": "sing", "aromatic": False},
            {"atom1": "CG", "atom2": "HG2", "order": "sing", "aromatic": False},
            {"atom1": "CG", "atom2": "HG3", "order": "sing", "aromatic": False},
            {"atom1": "CD", "atom2": "NE", "order": "sing", "aromatic": False},
            {"atom1": "CD", "atom2": "HD2", "order": "sing", "aromatic": False},
            {"atom1": "CD", "atom2": "HD3", "order": "sing", "aromatic": False},
            {"atom1": "NE", "atom2": "CZ", "order": "sing", "aromatic": False},
            {"atom1": "NE", "atom2": "HE", "order": "sing", "aromatic": False},
            {"atom1": "CZ", "atom2": "NH1", "order": "sing", "aromatic": False},
            {"atom1": "CZ", "atom2": "NH2", "order": "doub", "aromatic": False},
            {"atom1": "NH1", "atom2": "HH11", "order": "sing", "aromatic": False},
            {"atom1": "NH1", "atom2": "HH12", "order": "sing", "aromatic": False},
            {"atom1": "NH2", "atom2": "HH21", "order": "sing", "aromatic": False},
            {"atom1": "NH2", "atom2": "HH22", "order": "sing", "aromatic": False},
            {"atom1": "OXT", "atom2": "HXT", "order": "sing", "aromatic": False},
            {"atom1": "H1", "atom2": "N", "order": "sing", "aromatic": False},
            {"atom1": "H3", "atom2": "N", "order": "sing", "aromatic": False},
        ],
    },
    "ASN": {
        "bond_count": 18,
        "aromatic_bonds": 0,
        "bond_orders": {"sing": 16, "doub": 2},
        "bonds": [
            {"atom1": "N", "atom2": "CA", "order": "sing", "aromatic": False},
            {"atom1": "N", "atom2": "H", "order": "sing", "aromatic": False},
            {"atom1": "N", "atom2": "H2", "order": "sing", "aromatic": False},
            {"atom1": "CA", "atom2": "C", "order": "sing", "aromatic": False},
            {"atom1": "CA", "atom2": "CB", "order": "sing", "aromatic": False},
            {"atom1": "CA", "atom2": "HA", "order": "sing", "aromatic": False},
            {"atom1": "C", "atom2": "O", "order": "doub", "aromatic": False},
            {"atom1": "C", "atom2": "OXT", "order": "sing", "aromatic": False},
            {"atom1": "CB", "atom2": "CG", "order": "sing", "aromatic": False},
            {"atom1": "CB", "atom2": "HB2", "order": "sing", "aromatic": False},
            {"atom1": "CB", "atom2": "HB3", "order": "sing", "aromatic": False},
            {"atom1": "CG", "atom2": "OD1", "order": "doub", "aromatic": False},
            {"atom1": "CG", "atom2": "ND2", "order": "sing", "aromatic": False},
            {"atom1": "ND2", "atom2": "HD21", "order": "sing", "aromatic": False},
            {"atom1": "ND2", "atom2": "HD22", "order": "sing", "aromatic": False},
            {"atom1": "OXT", "atom2": "HXT", "order": "sing", "aromatic": False},
            {"atom1": "H1", "atom2": "N", "order": "sing", "aromatic": False},
            {"atom1": "H3", "atom2": "N", "order": "sing", "aromatic": False},
        ],
    },
    "ASP": {
        "bond_count": 17,
        "aromatic_bonds": 0,
        "bond_orders": {"sing": 15, "doub": 2},
        "bonds": [
            {"atom1": "N", "atom2": "CA", "order": "sing", "aromatic": False},
            {"atom1": "N", "atom2": "H", "order": "sing", "aromatic": False},
            {"atom1": "N", "atom2": "H2", "order": "sing", "aromatic": False},
            {"atom1": "CA", "atom2": "C", "order": "sing", "aromatic": False},
            {"atom1": "CA", "atom2": "CB", "order": "sing", "aromatic": False},
            {"atom1": "CA", "atom2": "HA", "order": "sing", "aromatic": False},
            {"atom1": "C", "atom2": "O", "order": "doub", "aromatic": False},
            {"atom1": "C", "atom2": "OXT", "order": "sing", "aromatic": False},
            {"atom1": "CB", "atom2": "CG", "order": "sing", "aromatic": False},
            {"atom1": "CB", "atom2": "HB2", "order": "sing", "aromatic": False},
            {"atom1": "CB", "atom2": "HB3", "order": "sing", "aromatic": False},
            {"atom1": "CG", "atom2": "OD1", "order": "doub", "aromatic": False},
            {"atom1": "CG", "atom2": "OD2", "order": "sing", "aromatic": False},
            {"atom1": "OD2", "atom2": "HD2", "order": "sing", "aromatic": False},
            {"atom1": "OXT", "atom2": "HXT", "order": "sing", "aromatic": False},
            {"atom1": "H1", "atom2": "N", "order": "sing", "aromatic": False},
            {"atom1": "H3", "atom2": "N", "order": "sing", "aromatic": False},
        ],
    },
    "C": {
        "bond_count": 36,
        "aromatic_bonds": 0,
        "bond_orders": {"sing": 32, "doub": 4},
        "bonds": [
            {"atom1": "OP3", "atom2": "P", "order": "sing", "aromatic": False},
            {"atom1": "OP3", "atom2": "HOP3", "order": "sing", "aromatic": False},
            {"atom1": "P", "atom2": "OP1", "order": "doub", "aromatic": False},
            {"atom1": "P", "atom2": "OP2", "order": "sing", "aromatic": False},
            {"atom1": "P", "atom2": "O5'", "order": "sing", "aromatic": False},
            {"atom1": "OP2", "atom2": "HOP2", "order": "sing", "aromatic": False},
            {"atom1": "O5'", "atom2": "C5'", "order": "sing", "aromatic": False},
            {"atom1": "C5'", "atom2": "C4'", "order": "sing", "aromatic": False},
            {"atom1": "C5'", "atom2": "H5'", "order": "sing", "aromatic": False},
            {"atom1": "C5'", "atom2": "H5''", "order": "sing", "aromatic": False},
            {"atom1": "C4'", "atom2": "O4'", "order": "sing", "aromatic": False},
            {"atom1": "C4'", "atom2": "C3'", "order": "sing", "aromatic": False},
            {"atom1": "C4'", "atom2": "H4'", "order": "sing", "aromatic": False},
            {"atom1": "O4'", "atom2": "C1'", "order": "sing", "aromatic": False},
            {"atom1": "C3'", "atom2": "O3'", "order": "sing", "aromatic": False},
            {"atom1": "C3'", "atom2": "C2'", "order": "sing", "aromatic": False},
            {"atom1": "C3'", "atom2": "H3'", "order": "sing", "aromatic": False},
            {"atom1": "O3'", "atom2": "HO3'", "order": "sing", "aromatic": False},
            {"atom1": "C2'", "atom2": "O2'", "order": "sing", "aromatic": False},
            {"atom1": "C2'", "atom2": "C1'", "order": "sing", "aromatic": False},
            {"atom1": "C2'", "atom2": "H2'", "order": "sing", "aromatic": False},
            {"atom1": "O2'", "atom2": "HO2'", "order": "sing", "aromatic": False},
            {"atom1": "C1'", "atom2": "N1", "order": "sing", "aromatic": False},
            {"atom1": "C1'", "atom2": "H1'", "order": "sing", "aromatic": False},
            {"atom1": "N1", "atom2": "C2", "order": "sing", "aromatic": False},
            {"atom1": "N1", "atom2": "C6", "order": "sing", "aromatic": False},
            {"atom1": "C2", "atom2": "O2", "order": "doub", "aromatic": False},
            {"atom1": "C2", "atom2": "N3", "order": "sing", "aromatic": False},
            {"atom1": "N3", "atom2": "C4", "order": "doub", "aromatic": False},
            {"atom1": "C4", "atom2": "N4", "order": "sing", "aromatic": False},
            {"atom1": "C4", "atom2": "C5", "order": "sing", "aromatic": False},
            {"atom1": "N4", "atom2": "H41", "order": "sing", "aromatic": False},
            {"atom1": "N4", "atom2": "H42", "order": "sing", "aromatic": False},
            {"atom1": "C5", "atom2": "C6", "order": "doub", "aromatic": False},
            {"atom1": "C5", "atom2": "H5", "order": "sing", "aromatic": False},
            {"atom1": "C6", "atom2": "H6", "order": "sing", "aromatic": False},
        ],
    },
    "CYS": {
        "bond_count": 15,
        "aromatic_bonds": 0,
        "bond_orders": {"sing": 14, "doub": 1},
        "bonds": [
            {"atom1": "N", "atom2": "CA", "order": "sing", "aromatic": False},
            {"atom1": "N", "atom2": "H", "order": "sing", "aromatic": False},
            {"atom1": "N", "atom2": "H2", "order": "sing", "aromatic": False},
            {"atom1": "CA", "atom2": "C", "order": "sing", "aromatic": False},
            {"atom1": "CA", "atom2": "CB", "order": "sing", "aromatic": False},
            {"atom1": "CA", "atom2": "HA", "order": "sing", "aromatic": False},
            {"atom1": "C", "atom2": "O", "order": "doub", "aromatic": False},
            {"atom1": "C", "atom2": "OXT", "order": "sing", "aromatic": False},
            {"atom1": "CB", "atom2": "SG", "order": "sing", "aromatic": False},
            {"atom1": "CB", "atom2": "HB2", "order": "sing", "aromatic": False},
            {"atom1": "CB", "atom2": "HB3", "order": "sing", "aromatic": False},
            {"atom1": "SG", "atom2": "HG", "order": "sing", "aromatic": False},
            {"atom1": "OXT", "atom2": "HXT", "order": "sing", "aromatic": False},
            {"atom1": "H1", "atom2": "N", "order": "sing", "aromatic": False},
            {"atom1": "H3", "atom2": "N", "order": "sing", "aromatic": False},
        ],
    },
    "DA": {
        "bond_count": 38,
        "aromatic_bonds": 0,
        "bond_orders": {"sing": 33, "doub": 5},
        "bonds": [
            {"atom1": "OP3", "atom2": "P", "order": "sing", "aromatic": False},
            {"atom1": "OP3", "atom2": "HOP3", "order": "sing", "aromatic": False},
            {"atom1": "P", "atom2": "OP1", "order": "doub", "aromatic": False},
            {"atom1": "P", "atom2": "OP2", "order": "sing", "aromatic": False},
            {"atom1": "P", "atom2": "O5'", "order": "sing", "aromatic": False},
            {"atom1": "OP2", "atom2": "HOP2", "order": "sing", "aromatic": False},
            {"atom1": "O5'", "atom2": "C5'", "order": "sing", "aromatic": False},
            {"atom1": "C5'", "atom2": "C4'", "order": "sing", "aromatic": False},
            {"atom1": "C5'", "atom2": "H5'", "order": "sing", "aromatic": False},
            {"atom1": "C5'", "atom2": "H5''", "order": "sing", "aromatic": False},
            {"atom1": "C4'", "atom2": "O4'", "order": "sing", "aromatic": False},
            {"atom1": "C4'", "atom2": "C3'", "order": "sing", "aromatic": False},
            {"atom1": "C4'", "atom2": "H4'", "order": "sing", "aromatic": False},
            {"atom1": "O4'", "atom2": "C1'", "order": "sing", "aromatic": False},
            {"atom1": "C3'", "atom2": "O3'", "order": "sing", "aromatic": False},
            {"atom1": "C3'", "atom2": "C2'", "order": "sing", "aromatic": False},
            {"atom1": "C3'", "atom2": "H3'", "order": "sing", "aromatic": False},
            {"atom1": "O3'", "atom2": "HO3'", "order": "sing", "aromatic": False},
            {"atom1": "C2'", "atom2": "C1'", "order": "sing", "aromatic": False},
            {"atom1": "C2'", "atom2": "H2'", "order": "sing", "aromatic": False},
            {"atom1": "C2'", "atom2": "H2''", "order": "sing", "aromatic": False},
            {"atom1": "C1'", "atom2": "N9", "order": "sing", "aromatic": False},
            {"atom1": "C1'", "atom2": "H1'", "order": "sing", "aromatic": False},
            {"atom1": "N9", "atom2": "C8", "order": "sing", "aromatic": False},
            {"atom1": "N9", "atom2": "C4", "order": "sing", "aromatic": False},
            {"atom1": "C8", "atom2": "N7", "order": "doub", "aromatic": False},
            {"atom1": "C8", "atom2": "H8", "order": "sing", "aromatic": False},
            {"atom1": "N7", "atom2": "C5", "order": "sing", "aromatic": False},
            {"atom1": "C5", "atom2": "C6", "order": "sing", "aromatic": False},
            {"atom1": "C5", "atom2": "C4", "order": "doub", "aromatic": False},
            {"atom1": "C6", "atom2": "N6", "order": "sing", "aromatic": False},
            {"atom1": "C6", "atom2": "N1", "order": "doub", "aromatic": False},
            {"atom1": "N6", "atom2": "H61", "order": "sing", "aromatic": False},
            {"atom1": "N6", "atom2": "H62", "order": "sing", "aromatic": False},
            {"atom1": "N1", "atom2": "C2", "order": "sing", "aromatic": False},
            {"atom1": "C2", "atom2": "N3", "order": "doub", "aromatic": False},
            {"atom1": "C2", "atom2": "H2", "order": "sing", "aromatic": False},
            {"atom1": "N3", "atom2": "C4", "order": "sing", "aromatic": False},
        ],
    },
    "DC": {
        "bond_count": 35,
        "aromatic_bonds": 0,
        "bond_orders": {"sing": 31, "doub": 4},
        "bonds": [
            {"atom1": "OP3", "atom2": "P", "order": "sing", "aromatic": False},
            {"atom1": "OP3", "atom2": "HOP3", "order": "sing", "aromatic": False},
            {"atom1": "P", "atom2": "OP1", "order": "doub", "aromatic": False},
            {"atom1": "P", "atom2": "OP2", "order": "sing", "aromatic": False},
            {"atom1": "P", "atom2": "O5'", "order": "sing", "aromatic": False},
            {"atom1": "OP2", "atom2": "HOP2", "order": "sing", "aromatic": False},
            {"atom1": "O5'", "atom2": "C5'", "order": "sing", "aromatic": False},
            {"atom1": "C5'", "atom2": "C4'", "order": "sing", "aromatic": False},
            {"atom1": "C5'", "atom2": "H5'", "order": "sing", "aromatic": False},
            {"atom1": "C5'", "atom2": "H5''", "order": "sing", "aromatic": False},
            {"atom1": "C4'", "atom2": "O4'", "order": "sing", "aromatic": False},
            {"atom1": "C4'", "atom2": "C3'", "order": "sing", "aromatic": False},
            {"atom1": "C4'", "atom2": "H4'", "order": "sing", "aromatic": False},
            {"atom1": "O4'", "atom2": "C1'", "order": "sing", "aromatic": False},
            {"atom1": "C3'", "atom2": "O3'", "order": "sing", "aromatic": False},
            {"atom1": "C3'", "atom2": "C2'", "order": "sing", "aromatic": False},
            {"atom1": "C3'", "atom2": "H3'", "order": "sing", "aromatic": False},
            {"atom1": "O3'", "atom2": "HO3'", "order": "sing", "aromatic": False},
            {"atom1": "C2'", "atom2": "C1'", "order": "sing", "aromatic": False},
            {"atom1": "C2'", "atom2": "H2'", "order": "sing", "aromatic": False},
            {"atom1": "C2'", "atom2": "H2''", "order": "sing", "aromatic": False},
            {"atom1": "C1'", "atom2": "N1", "order": "sing", "aromatic": False},
            {"atom1": "C1'", "atom2": "H1'", "order": "sing", "aromatic": False},
            {"atom1": "N1", "atom2": "C2", "order": "sing", "aromatic": False},
            {"atom1": "N1", "atom2": "C6", "order": "sing", "aromatic": False},
            {"atom1": "C2", "atom2": "O2", "order": "doub", "aromatic": False},
            {"atom1": "C2", "atom2": "N3", "order": "sing", "aromatic": False},
            {"atom1": "N3", "atom2": "C4", "order": "doub", "aromatic": False},
            {"atom1": "C4", "atom2": "N4", "order": "sing", "aromatic": False},
            {"atom1": "C4", "atom2": "C5", "order": "sing", "aromatic": False},
            {"atom1": "N4", "atom2": "H41", "order": "sing", "aromatic": False},
            {"atom1": "N4", "atom2": "H42", "order": "sing", "aromatic": False},
            {"atom1": "C5", "atom2": "C6", "order": "doub", "aromatic": False},
            {"atom1": "C5", "atom2": "H5", "order": "sing", "aromatic": False},
            {"atom1": "C6", "atom2": "H6", "order": "sing", "aromatic": False},
        ],
    },
    "DG": {
        "bond_count": 39,
        "aromatic_bonds": 0,
        "bond_orders": {"sing": 34, "doub": 5},
        "bonds": [
            {"atom1": "OP3", "atom2": "P", "order": "sing", "aromatic": False},
            {"atom1": "OP3", "atom2": "HOP3", "order": "sing", "aromatic": False},
            {"atom1": "P", "atom2": "OP1", "order": "doub", "aromatic": False},
            {"atom1": "P", "atom2": "OP2", "order": "sing", "aromatic": False},
            {"atom1": "P", "atom2": "O5'", "order": "sing", "aromatic": False},
            {"atom1": "OP2", "atom2": "HOP2", "order": "sing", "aromatic": False},
            {"atom1": "O5'", "atom2": "C5'", "order": "sing", "aromatic": False},
            {"atom1": "C5'", "atom2": "C4'", "order": "sing", "aromatic": False},
            {"atom1": "C5'", "atom2": "H5'", "order": "sing", "aromatic": False},
            {"atom1": "C5'", "atom2": "H5''", "order": "sing", "aromatic": False},
            {"atom1": "C4'", "atom2": "O4'", "order": "sing", "aromatic": False},
            {"atom1": "C4'", "atom2": "C3'", "order": "sing", "aromatic": False},
            {"atom1": "C4'", "atom2": "H4'", "order": "sing", "aromatic": False},
            {"atom1": "O4'", "atom2": "C1'", "order": "sing", "aromatic": False},
            {"atom1": "C3'", "atom2": "O3'", "order": "sing", "aromatic": False},
            {"atom1": "C3'", "atom2": "C2'", "order": "sing", "aromatic": False},
            {"atom1": "C3'", "atom2": "H3'", "order": "sing", "aromatic": False},
            {"atom1": "O3'", "atom2": "HO3'", "order": "sing", "aromatic": False},
            {"atom1": "C2'", "atom2": "C1'", "order": "sing", "aromatic": False},
            {"atom1": "C2'", "atom2": "H2'", "order": "sing", "aromatic": False},
            {"atom1": "C2'", "atom2": "H2''", "order": "sing", "aromatic": False},
            {"atom1": "C1'", "atom2": "N9", "order": "sing", "aromatic": False},
            {"atom1": "C1'", "atom2": "H1'", "order": "sing", "aromatic": False},
            {"atom1": "N9", "atom2": "C8", "order": "sing", "aromatic": False},
            {"atom1": "N9", "atom2": "C4", "order": "sing", "aromatic": False},
            {"atom1": "C8", "atom2": "N7", "order": "doub", "aromatic": False},
            {"atom1": "C8", "atom2": "H8", "order": "sing", "aromatic": False},
            {"atom1": "N7", "atom2": "C5", "order": "sing", "aromatic": False},
            {"atom1": "C5", "atom2": "C6", "order": "sing", "aromatic": False},
            {"atom1": "C5", "atom2": "C4", "order": "doub", "aromatic": False},
            {"atom1": "C6", "atom2": "O6", "order": "doub", "aromatic": False},
            {"atom1": "C6", "atom2": "N1", "order": "sing", "aromatic": False},
            {"atom1": "N1", "atom2": "C2", "order": "sing", "aromatic": False},
            {"atom1": "N1", "atom2": "H1", "order": "sing", "aromatic": False},
            {"atom1": "C2", "atom2": "N2", "order": "sing", "aromatic": False},
            {"atom1": "C2", "atom2": "N3", "order": "doub", "aromatic": False},
            {"atom1": "N2", "atom2": "H21", "order": "sing", "aromatic": False},
            {"atom1": "N2", "atom2": "H22", "order": "sing", "aromatic": False},
            {"atom1": "N3", "atom2": "C4", "order": "sing", "aromatic": False},
        ],
    },
    "DI": {
        "bond_count": 37,
        "aromatic_bonds": 0,
        "bond_orders": {"sing": 32, "doub": 5},
        "bonds": [
            {"atom1": "OP3", "atom2": "P", "order": "sing", "aromatic": False},
            {"atom1": "OP3", "atom2": "HOP3", "order": "sing", "aromatic": False},
            {"atom1": "P", "atom2": "OP1", "order": "doub", "aromatic": False},
            {"atom1": "P", "atom2": "OP2", "order": "sing", "aromatic": False},
            {"atom1": "P", "atom2": "O5'", "order": "sing", "aromatic": False},
            {"atom1": "OP2", "atom2": "HOP2", "order": "sing", "aromatic": False},
            {"atom1": "O5'", "atom2": "C5'", "order": "sing", "aromatic": False},
            {"atom1": "C5'", "atom2": "C4'", "order": "sing", "aromatic": False},
            {"atom1": "C5'", "atom2": "H5'", "order": "sing", "aromatic": False},
            {"atom1": "C5'", "atom2": "H5''", "order": "sing", "aromatic": False},
            {"atom1": "C4'", "atom2": "O4'", "order": "sing", "aromatic": False},
            {"atom1": "C4'", "atom2": "C3'", "order": "sing", "aromatic": False},
            {"atom1": "C4'", "atom2": "H4'", "order": "sing", "aromatic": False},
            {"atom1": "O4'", "atom2": "C1'", "order": "sing", "aromatic": False},
            {"atom1": "C3'", "atom2": "O3'", "order": "sing", "aromatic": False},
            {"atom1": "C3'", "atom2": "C2'", "order": "sing", "aromatic": False},
            {"atom1": "C3'", "atom2": "H3'", "order": "sing", "aromatic": False},
            {"atom1": "O3'", "atom2": "HO3'", "order": "sing", "aromatic": False},
            {"atom1": "C2'", "atom2": "C1'", "order": "sing", "aromatic": False},
            {"atom1": "C2'", "atom2": "H2'", "order": "sing", "aromatic": False},
            {"atom1": "C2'", "atom2": "H2''", "order": "sing", "aromatic": False},
            {"atom1": "C1'", "atom2": "N9", "order": "sing", "aromatic": False},
            {"atom1": "C1'", "atom2": "H1'", "order": "sing", "aromatic": False},
            {"atom1": "N9", "atom2": "C8", "order": "sing", "aromatic": False},
            {"atom1": "N9", "atom2": "C4", "order": "sing", "aromatic": False},
            {"atom1": "C8", "atom2": "N7", "order": "doub", "aromatic": False},
            {"atom1": "C8", "atom2": "H8", "order": "sing", "aromatic": False},
            {"atom1": "N7", "atom2": "C5", "order": "sing", "aromatic": False},
            {"atom1": "C5", "atom2": "C6", "order": "sing", "aromatic": False},
            {"atom1": "C5", "atom2": "C4", "order": "doub", "aromatic": False},
            {"atom1": "C6", "atom2": "O6", "order": "doub", "aromatic": False},
            {"atom1": "C6", "atom2": "N1", "order": "sing", "aromatic": False},
            {"atom1": "N1", "atom2": "C2", "order": "sing", "aromatic": False},
            {"atom1": "N1", "atom2": "H1", "order": "sing", "aromatic": False},
            {"atom1": "C2", "atom2": "N3", "order": "doub", "aromatic": False},
            {"atom1": "C2", "atom2": "H2", "order": "sing", "aromatic": False},
            {"atom1": "N3", "atom2": "C4", "order": "sing", "aromatic": False},
        ],
    },
    "DOD": {
        "bond_count": 2,
        "aromatic_bonds": 0,
        "bond_orders": {"sing": 2},
        "bonds": [
            {"atom1": "O", "atom2": "D1", "order": "sing", "aromatic": False},
            {"atom1": "O", "atom2": "D2", "order": "sing", "aromatic": False},
        ],
    },
    "DT": {
        "bond_count": 37,
        "aromatic_bonds": 0,
        "bond_orders": {"sing": 33, "doub": 4},
        "bonds": [
            {"atom1": "OP3", "atom2": "P", "order": "sing", "aromatic": False},
            {"atom1": "OP3", "atom2": "HOP3", "order": "sing", "aromatic": False},
            {"atom1": "P", "atom2": "OP1", "order": "doub", "aromatic": False},
            {"atom1": "P", "atom2": "OP2", "order": "sing", "aromatic": False},
            {"atom1": "P", "atom2": "O5'", "order": "sing", "aromatic": False},
            {"atom1": "OP2", "atom2": "HOP2", "order": "sing", "aromatic": False},
            {"atom1": "O5'", "atom2": "C5'", "order": "sing", "aromatic": False},
            {"atom1": "C5'", "atom2": "C4'", "order": "sing", "aromatic": False},
            {"atom1": "C5'", "atom2": "H5'", "order": "sing", "aromatic": False},
            {"atom1": "C5'", "atom2": "H5''", "order": "sing", "aromatic": False},
            {"atom1": "C4'", "atom2": "O4'", "order": "sing", "aromatic": False},
            {"atom1": "C4'", "atom2": "C3'", "order": "sing", "aromatic": False},
            {"atom1": "C4'", "atom2": "H4'", "order": "sing", "aromatic": False},
            {"atom1": "O4'", "atom2": "C1'", "order": "sing", "aromatic": False},
            {"atom1": "C3'", "atom2": "O3'", "order": "sing", "aromatic": False},
            {"atom1": "C3'", "atom2": "C2'", "order": "sing", "aromatic": False},
            {"atom1": "C3'", "atom2": "H3'", "order": "sing", "aromatic": False},
            {"atom1": "O3'", "atom2": "HO3'", "order": "sing", "aromatic": False},
            {"atom1": "C2'", "atom2": "C1'", "order": "sing", "aromatic": False},
            {"atom1": "C2'", "atom2": "H2'", "order": "sing", "aromatic": False},
            {"atom1": "C2'", "atom2": "H2''", "order": "sing", "aromatic": False},
            {"atom1": "C1'", "atom2": "N1", "order": "sing", "aromatic": False},
            {"atom1": "C1'", "atom2": "H1'", "order": "sing", "aromatic": False},
            {"atom1": "N1", "atom2": "C2", "order": "sing", "aromatic": False},
            {"atom1": "N1", "atom2": "C6", "order": "sing", "aromatic": False},
            {"atom1": "C2", "atom2": "O2", "order": "doub", "aromatic": False},
            {"atom1": "C2", "atom2": "N3", "order": "sing", "aromatic": False},
            {"atom1": "N3", "atom2": "C4", "order": "sing", "aromatic": False},
            {"atom1": "N3", "atom2": "H3", "order": "sing", "aromatic": False},
            {"atom1": "C4", "atom2": "O4", "order": "doub", "aromatic": False},
            {"atom1": "C4", "atom2": "C5", "order": "sing", "aromatic": False},
            {"atom1": "C5", "atom2": "C7", "order": "sing", "aromatic": False},
            {"atom1": "C5", "atom2": "C6", "order": "doub", "aromatic": False},
            {"atom1": "C7", "atom2": "H71", "order": "sing", "aromatic": False},
            {"atom1": "C7", "atom2": "H72", "order": "sing", "aromatic": False},
            {"atom1": "C7", "atom2": "H73", "order": "sing", "aromatic": False},
            {"atom1": "C6", "atom2": "H6", "order": "sing", "aromatic": False},
        ],
    },
    "G": {
        "bond_count": 40,
        "aromatic_bonds": 0,
        "bond_orders": {"sing": 35, "doub": 5},
        "bonds": [
            {"atom1": "OP3", "atom2": "P", "order": "sing", "aromatic": False},
            {"atom1": "OP3", "atom2": "HOP3", "order": "sing", "aromatic": False},
            {"atom1": "P", "atom2": "OP1", "order": "doub", "aromatic": False},
            {"atom1": "P", "atom2": "OP2", "order": "sing", "aromatic": False},
            {"atom1": "P", "atom2": "O5'", "order": "sing", "aromatic": False},
            {"atom1": "OP2", "atom2": "HOP2", "order": "sing", "aromatic": False},
            {"atom1": "O5'", "atom2": "C5'", "order": "sing", "aromatic": False},
            {"atom1": "C5'", "atom2": "C4'", "order": "sing", "aromatic": False},
            {"atom1": "C5'", "atom2": "H5'", "order": "sing", "aromatic": False},
            {"atom1": "C5'", "atom2": "H5''", "order": "sing", "aromatic": False},
            {"atom1": "C4'", "atom2": "O4'", "order": "sing", "aromatic": False},
            {"atom1": "C4'", "atom2": "C3'", "order": "sing", "aromatic": False},
            {"atom1": "C4'", "atom2": "H4'", "order": "sing", "aromatic": False},
            {"atom1": "O4'", "atom2": "C1'", "order": "sing", "aromatic": False},
            {"atom1": "C3'", "atom2": "O3'", "order": "sing", "aromatic": False},
            {"atom1": "C3'", "atom2": "C2'", "order": "sing", "aromatic": False},
            {"atom1": "C3'", "atom2": "H3'", "order": "sing", "aromatic": False},
            {"atom1": "O3'", "atom2": "HO3'", "order": "sing", "aromatic": False},
            {"atom1": "C2'", "atom2": "O2'", "order": "sing", "aromatic": False},
            {"atom1": "C2'", "atom2": "C1'", "order": "sing", "aromatic": False},
            {"atom1": "C2'", "atom2": "H2'", "order": "sing", "aromatic": False},
            {"atom1": "O2'", "atom2": "HO2'", "order": "sing", "aromatic": False},
            {"atom1": "C1'", "atom2": "N9", "order": "sing", "aromatic": False},
            {"atom1": "C1'", "atom2": "H1'", "order": "sing", "aromatic": False},
            {"atom1": "N9", "atom2": "C8", "order": "sing", "aromatic": False},
            {"atom1": "N9", "atom2": "C4", "order": "sing", "aromatic": False},
            {"atom1": "C8", "atom2": "N7", "order": "doub", "aromatic": False},
            {"atom1": "C8", "atom2": "H8", "order": "sing", "aromatic": False},
            {"atom1": "N7", "atom2": "C5", "order": "sing", "aromatic": False},
            {"atom1": "C5", "atom2": "C6", "order": "sing", "aromatic": False},
            {"atom1": "C5", "atom2": "C4", "order": "doub", "aromatic": False},
            {"atom1": "C6", "atom2": "O6", "order": "doub", "aromatic": False},
            {"atom1": "C6", "atom2": "N1", "order": "sing", "aromatic": False},
            {"atom1": "N1", "atom2": "C2", "order": "sing", "aromatic": False},
            {"atom1": "N1", "atom2": "H1", "order": "sing", "aromatic": False},
            {"atom1": "C2", "atom2": "N2", "order": "sing", "aromatic": False},
            {"atom1": "C2", "atom2": "N3", "order": "doub", "aromatic": False},
            {"atom1": "N2", "atom2": "H21", "order": "sing", "aromatic": False},
            {"atom1": "N2", "atom2": "H22", "order": "sing", "aromatic": False},
            {"atom1": "N3", "atom2": "C4", "order": "sing", "aromatic": False},
        ],
    },
    "GLN": {
        "bond_count": 21,
        "aromatic_bonds": 0,
        "bond_orders": {"sing": 19, "doub": 2},
        "bonds": [
            {"atom1": "N", "atom2": "CA", "order": "sing", "aromatic": False},
            {"atom1": "N", "atom2": "H", "order": "sing", "aromatic": False},
            {"atom1": "N", "atom2": "H2", "order": "sing", "aromatic": False},
            {"atom1": "CA", "atom2": "C", "order": "sing", "aromatic": False},
            {"atom1": "CA", "atom2": "CB", "order": "sing", "aromatic": False},
            {"atom1": "CA", "atom2": "HA", "order": "sing", "aromatic": False},
            {"atom1": "C", "atom2": "O", "order": "doub", "aromatic": False},
            {"atom1": "C", "atom2": "OXT", "order": "sing", "aromatic": False},
            {"atom1": "CB", "atom2": "CG", "order": "sing", "aromatic": False},
            {"atom1": "CB", "atom2": "HB2", "order": "sing", "aromatic": False},
            {"atom1": "CB", "atom2": "HB3", "order": "sing", "aromatic": False},
            {"atom1": "CG", "atom2": "CD", "order": "sing", "aromatic": False},
            {"atom1": "CG", "atom2": "HG2", "order": "sing", "aromatic": False},
            {"atom1": "CG", "atom2": "HG3", "order": "sing", "aromatic": False},
            {"atom1": "CD", "atom2": "OE1", "order": "doub", "aromatic": False},
            {"atom1": "CD", "atom2": "NE2", "order": "sing", "aromatic": False},
            {"atom1": "NE2", "atom2": "HE21", "order": "sing", "aromatic": False},
            {"atom1": "NE2", "atom2": "HE22", "order": "sing", "aromatic": False},
            {"atom1": "OXT", "atom2": "HXT", "order": "sing", "aromatic": False},
            {"atom1": "H1", "atom2": "N", "order": "sing", "aromatic": False},
            {"atom1": "H3", "atom2": "N", "order": "sing", "aromatic": False},
        ],
    },
    "GLU": {
        "bond_count": 20,
        "aromatic_bonds": 0,
        "bond_orders": {"sing": 18, "doub": 2},
        "bonds": [
            {"atom1": "N", "atom2": "CA", "order": "sing", "aromatic": False},
            {"atom1": "N", "atom2": "H", "order": "sing", "aromatic": False},
            {"atom1": "N", "atom2": "H2", "order": "sing", "aromatic": False},
            {"atom1": "CA", "atom2": "C", "order": "sing", "aromatic": False},
            {"atom1": "CA", "atom2": "CB", "order": "sing", "aromatic": False},
            {"atom1": "CA", "atom2": "HA", "order": "sing", "aromatic": False},
            {"atom1": "C", "atom2": "O", "order": "doub", "aromatic": False},
            {"atom1": "C", "atom2": "OXT", "order": "sing", "aromatic": False},
            {"atom1": "CB", "atom2": "CG", "order": "sing", "aromatic": False},
            {"atom1": "CB", "atom2": "HB2", "order": "sing", "aromatic": False},
            {"atom1": "CB", "atom2": "HB3", "order": "sing", "aromatic": False},
            {"atom1": "CG", "atom2": "CD", "order": "sing", "aromatic": False},
            {"atom1": "CG", "atom2": "HG2", "order": "sing", "aromatic": False},
            {"atom1": "CG", "atom2": "HG3", "order": "sing", "aromatic": False},
            {"atom1": "CD", "atom2": "OE1", "order": "doub", "aromatic": False},
            {"atom1": "CD", "atom2": "OE2", "order": "sing", "aromatic": False},
            {"atom1": "OE2", "atom2": "HE2", "order": "sing", "aromatic": False},
            {"atom1": "OXT", "atom2": "HXT", "order": "sing", "aromatic": False},
            {"atom1": "H1", "atom2": "N", "order": "sing", "aromatic": False},
            {"atom1": "H3", "atom2": "N", "order": "sing", "aromatic": False},
        ],
    },
    "GLY": {
        "bond_count": 11,
        "aromatic_bonds": 0,
        "bond_orders": {"sing": 10, "doub": 1},
        "bonds": [
            {"atom1": "N", "atom2": "CA", "order": "sing", "aromatic": False},
            {"atom1": "N", "atom2": "H", "order": "sing", "aromatic": False},
            {"atom1": "N", "atom2": "H2", "order": "sing", "aromatic": False},
            {"atom1": "CA", "atom2": "C", "order": "sing", "aromatic": False},
            {"atom1": "CA", "atom2": "HA2", "order": "sing", "aromatic": False},
            {"atom1": "CA", "atom2": "HA3", "order": "sing", "aromatic": False},
            {"atom1": "C", "atom2": "O", "order": "doub", "aromatic": False},
            {"atom1": "C", "atom2": "OXT", "order": "sing", "aromatic": False},
            {"atom1": "OXT", "atom2": "HXT", "order": "sing", "aromatic": False},
            {"atom1": "H1", "atom2": "N", "order": "sing", "aromatic": False},
            {"atom1": "H3", "atom2": "N", "order": "sing", "aromatic": False},
        ],
    },
    "HIS": {
        "bond_count": 23,
        "aromatic_bonds": 0,
        "bond_orders": {"sing": 20, "doub": 3},
        "bonds": [
            {"atom1": "N", "atom2": "CA", "order": "sing", "aromatic": False},
            {"atom1": "N", "atom2": "H", "order": "sing", "aromatic": False},
            {"atom1": "N", "atom2": "H2", "order": "sing", "aromatic": False},
            {"atom1": "CA", "atom2": "C", "order": "sing", "aromatic": False},
            {"atom1": "CA", "atom2": "CB", "order": "sing", "aromatic": False},
            {"atom1": "CA", "atom2": "HA", "order": "sing", "aromatic": False},
            {"atom1": "C", "atom2": "O", "order": "doub", "aromatic": False},
            {"atom1": "C", "atom2": "OXT", "order": "sing", "aromatic": False},
            {"atom1": "CB", "atom2": "CG", "order": "sing", "aromatic": False},
            {"atom1": "CB", "atom2": "HB2", "order": "sing", "aromatic": False},
            {"atom1": "CB", "atom2": "HB3", "order": "sing", "aromatic": False},
            {"atom1": "CG", "atom2": "ND1", "order": "sing", "aromatic": False},
            {"atom1": "CG", "atom2": "CD2", "order": "doub", "aromatic": False},
            {"atom1": "ND1", "atom2": "CE1", "order": "doub", "aromatic": False},
            {"atom1": "ND1", "atom2": "HD1", "order": "sing", "aromatic": False},
            {"atom1": "CD2", "atom2": "NE2", "order": "sing", "aromatic": False},
            {"atom1": "CD2", "atom2": "HD2", "order": "sing", "aromatic": False},
            {"atom1": "CE1", "atom2": "NE2", "order": "sing", "aromatic": False},
            {"atom1": "CE1", "atom2": "HE1", "order": "sing", "aromatic": False},
            {"atom1": "NE2", "atom2": "HE2", "order": "sing", "aromatic": False},
            {"atom1": "OXT", "atom2": "HXT", "order": "sing", "aromatic": False},
            {"atom1": "H1", "atom2": "N", "order": "sing", "aromatic": False},
            {"atom1": "H3", "atom2": "N", "order": "sing", "aromatic": False},
        ],
    },
    "HOH": {
        "bond_count": 2,
        "aromatic_bonds": 0,
        "bond_orders": {"sing": 2},
        "bonds": [
            {"atom1": "O", "atom2": "H1", "order": "sing", "aromatic": False},
            {"atom1": "O", "atom2": "H2", "order": "sing", "aromatic": False},
        ],
    },
    "I": {
        "bond_count": 38,
        "aromatic_bonds": 0,
        "bond_orders": {"sing": 33, "doub": 5},
        "bonds": [
            {"atom1": "OP3", "atom2": "P", "order": "sing", "aromatic": False},
            {"atom1": "OP3", "atom2": "HOP3", "order": "sing", "aromatic": False},
            {"atom1": "P", "atom2": "OP1", "order": "doub", "aromatic": False},
            {"atom1": "P", "atom2": "OP2", "order": "sing", "aromatic": False},
            {"atom1": "P", "atom2": "O5'", "order": "sing", "aromatic": False},
            {"atom1": "OP2", "atom2": "HOP2", "order": "sing", "aromatic": False},
            {"atom1": "O5'", "atom2": "C5'", "order": "sing", "aromatic": False},
            {"atom1": "C5'", "atom2": "C4'", "order": "sing", "aromatic": False},
            {"atom1": "C5'", "atom2": "H5'", "order": "sing", "aromatic": False},
            {"atom1": "C5'", "atom2": "H5''", "order": "sing", "aromatic": False},
            {"atom1": "C4'", "atom2": "O4'", "order": "sing", "aromatic": False},
            {"atom1": "C4'", "atom2": "C3'", "order": "sing", "aromatic": False},
            {"atom1": "C4'", "atom2": "H4'", "order": "sing", "aromatic": False},
            {"atom1": "O4'", "atom2": "C1'", "order": "sing", "aromatic": False},
            {"atom1": "C3'", "atom2": "O3'", "order": "sing", "aromatic": False},
            {"atom1": "C3'", "atom2": "C2'", "order": "sing", "aromatic": False},
            {"atom1": "C3'", "atom2": "H3'", "order": "sing", "aromatic": False},
            {"atom1": "O3'", "atom2": "HO3'", "order": "sing", "aromatic": False},
            {"atom1": "C2'", "atom2": "O2'", "order": "sing", "aromatic": False},
            {"atom1": "C2'", "atom2": "C1'", "order": "sing", "aromatic": False},
            {"atom1": "C2'", "atom2": "H2'", "order": "sing", "aromatic": False},
            {"atom1": "O2'", "atom2": "HO2'", "order": "sing", "aromatic": False},
            {"atom1": "C1'", "atom2": "N9", "order": "sing", "aromatic": False},
            {"atom1": "C1'", "atom2": "H1'", "order": "sing", "aromatic": False},
            {"atom1": "N9", "atom2": "C8", "order": "sing", "aromatic": False},
            {"atom1": "N9", "atom2": "C4", "order": "sing", "aromatic": False},
            {"atom1": "C8", "atom2": "N7", "order": "doub", "aromatic": False},
            {"atom1": "C8", "atom2": "H8", "order": "sing", "aromatic": False},
            {"atom1": "N7", "atom2": "C5", "order": "sing", "aromatic": False},
            {"atom1": "C5", "atom2": "C6", "order": "sing", "aromatic": False},
            {"atom1": "C5", "atom2": "C4", "order": "doub", "aromatic": False},
            {"atom1": "C6", "atom2": "O6", "order": "doub", "aromatic": False},
            {"atom1": "C6", "atom2": "N1", "order": "sing", "aromatic": False},
            {"atom1": "N1", "atom2": "C2", "order": "sing", "aromatic": False},
            {"atom1": "N1", "atom2": "H1", "order": "sing", "aromatic": False},
            {"atom1": "C2", "atom2": "N3", "order": "doub", "aromatic": False},
            {"atom1": "C2", "atom2": "H2", "order": "sing", "aromatic": False},
            {"atom1": "N3", "atom2": "C4", "order": "sing", "aromatic": False},
        ],
    },
    "ILE": {
        "bond_count": 23,
        "aromatic_bonds": 0,
        "bond_orders": {"sing": 22, "doub": 1},
        "bonds": [
            {"atom1": "N", "atom2": "CA", "order": "sing", "aromatic": False},
            {"atom1": "N", "atom2": "H", "order": "sing", "aromatic": False},
            {"atom1": "N", "atom2": "H2", "order": "sing", "aromatic": False},
            {"atom1": "CA", "atom2": "C", "order": "sing", "aromatic": False},
            {"atom1": "CA", "atom2": "CB", "order": "sing", "aromatic": False},
            {"atom1": "CA", "atom2": "HA", "order": "sing", "aromatic": False},
            {"atom1": "C", "atom2": "O", "order": "doub", "aromatic": False},
            {"atom1": "C", "atom2": "OXT", "order": "sing", "aromatic": False},
            {"atom1": "CB", "atom2": "CG1", "order": "sing", "aromatic": False},
            {"atom1": "CB", "atom2": "CG2", "order": "sing", "aromatic": False},
            {"atom1": "CB", "atom2": "HB", "order": "sing", "aromatic": False},
            {"atom1": "CG1", "atom2": "CD1", "order": "sing", "aromatic": False},
            {"atom1": "CG1", "atom2": "HG12", "order": "sing", "aromatic": False},
            {"atom1": "CG1", "atom2": "HG13", "order": "sing", "aromatic": False},
            {"atom1": "CG2", "atom2": "HG21", "order": "sing", "aromatic": False},
            {"atom1": "CG2", "atom2": "HG22", "order": "sing", "aromatic": False},
            {"atom1": "CG2", "atom2": "HG23", "order": "sing", "aromatic": False},
            {"atom1": "CD1", "atom2": "HD11", "order": "sing", "aromatic": False},
            {"atom1": "CD1", "atom2": "HD12", "order": "sing", "aromatic": False},
            {"atom1": "CD1", "atom2": "HD13", "order": "sing", "aromatic": False},
            {"atom1": "OXT", "atom2": "HXT", "order": "sing", "aromatic": False},
            {"atom1": "H1", "atom2": "N", "order": "sing", "aromatic": False},
            {"atom1": "H3", "atom2": "N", "order": "sing", "aromatic": False},
        ],
    },
    "LEU": {
        "bond_count": 23,
        "aromatic_bonds": 0,
        "bond_orders": {"sing": 22, "doub": 1},
        "bonds": [
            {"atom1": "N", "atom2": "CA", "order": "sing", "aromatic": False},
            {"atom1": "N", "atom2": "H", "order": "sing", "aromatic": False},
            {"atom1": "N", "atom2": "H2", "order": "sing", "aromatic": False},
            {"atom1": "CA", "atom2": "C", "order": "sing", "aromatic": False},
            {"atom1": "CA", "atom2": "CB", "order": "sing", "aromatic": False},
            {"atom1": "CA", "atom2": "HA", "order": "sing", "aromatic": False},
            {"atom1": "C", "atom2": "O", "order": "doub", "aromatic": False},
            {"atom1": "C", "atom2": "OXT", "order": "sing", "aromatic": False},
            {"atom1": "CB", "atom2": "CG", "order": "sing", "aromatic": False},
            {"atom1": "CB", "atom2": "HB2", "order": "sing", "aromatic": False},
            {"atom1": "CB", "atom2": "HB3", "order": "sing", "aromatic": False},
            {"atom1": "CG", "atom2": "CD1", "order": "sing", "aromatic": False},
            {"atom1": "CG", "atom2": "CD2", "order": "sing", "aromatic": False},
            {"atom1": "CG", "atom2": "HG", "order": "sing", "aromatic": False},
            {"atom1": "CD1", "atom2": "HD11", "order": "sing", "aromatic": False},
            {"atom1": "CD1", "atom2": "HD12", "order": "sing", "aromatic": False},
            {"atom1": "CD1", "atom2": "HD13", "order": "sing", "aromatic": False},
            {"atom1": "CD2", "atom2": "HD21", "order": "sing", "aromatic": False},
            {"atom1": "CD2", "atom2": "HD22", "order": "sing", "aromatic": False},
            {"atom1": "CD2", "atom2": "HD23", "order": "sing", "aromatic": False},
            {"atom1": "OXT", "atom2": "HXT", "order": "sing", "aromatic": False},
            {"atom1": "H1", "atom2": "N", "order": "sing", "aromatic": False},
            {"atom1": "H3", "atom2": "N", "order": "sing", "aromatic": False},
        ],
    },
    "LYS": {
        "bond_count": 26,
        "aromatic_bonds": 0,
        "bond_orders": {"sing": 25, "doub": 1},
        "bonds": [
            {"atom1": "N", "atom2": "CA", "order": "sing", "aromatic": False},
            {"atom1": "N", "atom2": "H", "order": "sing", "aromatic": False},
            {"atom1": "N", "atom2": "H2", "order": "sing", "aromatic": False},
            {"atom1": "CA", "atom2": "C", "order": "sing", "aromatic": False},
            {"atom1": "CA", "atom2": "CB", "order": "sing", "aromatic": False},
            {"atom1": "CA", "atom2": "HA", "order": "sing", "aromatic": False},
            {"atom1": "C", "atom2": "O", "order": "doub", "aromatic": False},
            {"atom1": "C", "atom2": "OXT", "order": "sing", "aromatic": False},
            {"atom1": "CB", "atom2": "CG", "order": "sing", "aromatic": False},
            {"atom1": "CB", "atom2": "HB2", "order": "sing", "aromatic": False},
            {"atom1": "CB", "atom2": "HB3", "order": "sing", "aromatic": False},
            {"atom1": "CG", "atom2": "CD", "order": "sing", "aromatic": False},
            {"atom1": "CG", "atom2": "HG2", "order": "sing", "aromatic": False},
            {"atom1": "CG", "atom2": "HG3", "order": "sing", "aromatic": False},
            {"atom1": "CD", "atom2": "CE", "order": "sing", "aromatic": False},
            {"atom1": "CD", "atom2": "HD2", "order": "sing", "aromatic": False},
            {"atom1": "CD", "atom2": "HD3", "order": "sing", "aromatic": False},
            {"atom1": "CE", "atom2": "NZ", "order": "sing", "aromatic": False},
            {"atom1": "CE", "atom2": "HE2", "order": "sing", "aromatic": False},
            {"atom1": "CE", "atom2": "HE3", "order": "sing", "aromatic": False},
            {"atom1": "NZ", "atom2": "HZ1", "order": "sing", "aromatic": False},
            {"atom1": "NZ", "atom2": "HZ2", "order": "sing", "aromatic": False},
            {"atom1": "NZ", "atom2": "HZ3", "order": "sing", "aromatic": False},
            {"atom1": "OXT", "atom2": "HXT", "order": "sing", "aromatic": False},
            {"atom1": "H1", "atom2": "N", "order": "sing", "aromatic": False},
            {"atom1": "H3", "atom2": "N", "order": "sing", "aromatic": False},
        ],
    },
    "MET": {
        "bond_count": 21,
        "aromatic_bonds": 0,
        "bond_orders": {"sing": 20, "doub": 1},
        "bonds": [
            {"atom1": "N", "atom2": "CA", "order": "sing", "aromatic": False},
            {"atom1": "N", "atom2": "H", "order": "sing", "aromatic": False},
            {"atom1": "N", "atom2": "H2", "order": "sing", "aromatic": False},
            {"atom1": "CA", "atom2": "C", "order": "sing", "aromatic": False},
            {"atom1": "CA", "atom2": "CB", "order": "sing", "aromatic": False},
            {"atom1": "CA", "atom2": "HA", "order": "sing", "aromatic": False},
            {"atom1": "C", "atom2": "O", "order": "doub", "aromatic": False},
            {"atom1": "C", "atom2": "OXT", "order": "sing", "aromatic": False},
            {"atom1": "CB", "atom2": "CG", "order": "sing", "aromatic": False},
            {"atom1": "CB", "atom2": "HB2", "order": "sing", "aromatic": False},
            {"atom1": "CB", "atom2": "HB3", "order": "sing", "aromatic": False},
            {"atom1": "CG", "atom2": "SD", "order": "sing", "aromatic": False},
            {"atom1": "CG", "atom2": "HG2", "order": "sing", "aromatic": False},
            {"atom1": "CG", "atom2": "HG3", "order": "sing", "aromatic": False},
            {"atom1": "SD", "atom2": "CE", "order": "sing", "aromatic": False},
            {"atom1": "CE", "atom2": "HE1", "order": "sing", "aromatic": False},
            {"atom1": "CE", "atom2": "HE2", "order": "sing", "aromatic": False},
            {"atom1": "CE", "atom2": "HE3", "order": "sing", "aromatic": False},
            {"atom1": "OXT", "atom2": "HXT", "order": "sing", "aromatic": False},
            {"atom1": "H1", "atom2": "N", "order": "sing", "aromatic": False},
            {"atom1": "H3", "atom2": "N", "order": "sing", "aromatic": False},
        ],
    },
    "PHE": {
        "bond_count": 25,
        "aromatic_bonds": 0,
        "bond_orders": {"sing": 21, "doub": 4},
        "bonds": [
            {"atom1": "N", "atom2": "CA", "order": "sing", "aromatic": False},
            {"atom1": "N", "atom2": "H", "order": "sing", "aromatic": False},
            {"atom1": "N", "atom2": "H2", "order": "sing", "aromatic": False},
            {"atom1": "CA", "atom2": "C", "order": "sing", "aromatic": False},
            {"atom1": "CA", "atom2": "CB", "order": "sing", "aromatic": False},
            {"atom1": "CA", "atom2": "HA", "order": "sing", "aromatic": False},
            {"atom1": "C", "atom2": "O", "order": "doub", "aromatic": False},
            {"atom1": "C", "atom2": "OXT", "order": "sing", "aromatic": False},
            {"atom1": "CB", "atom2": "CG", "order": "sing", "aromatic": False},
            {"atom1": "CB", "atom2": "HB2", "order": "sing", "aromatic": False},
            {"atom1": "CB", "atom2": "HB3", "order": "sing", "aromatic": False},
            {"atom1": "CG", "atom2": "CD1", "order": "doub", "aromatic": False},
            {"atom1": "CG", "atom2": "CD2", "order": "sing", "aromatic": False},
            {"atom1": "CD1", "atom2": "CE1", "order": "sing", "aromatic": False},
            {"atom1": "CD1", "atom2": "HD1", "order": "sing", "aromatic": False},
            {"atom1": "CD2", "atom2": "CE2", "order": "doub", "aromatic": False},
            {"atom1": "CD2", "atom2": "HD2", "order": "sing", "aromatic": False},
            {"atom1": "CE1", "atom2": "CZ", "order": "doub", "aromatic": False},
            {"atom1": "CE1", "atom2": "HE1", "order": "sing", "aromatic": False},
            {"atom1": "CE2", "atom2": "CZ", "order": "sing", "aromatic": False},
            {"atom1": "CE2", "atom2": "HE2", "order": "sing", "aromatic": False},
            {"atom1": "CZ", "atom2": "HZ", "order": "sing", "aromatic": False},
            {"atom1": "OXT", "atom2": "HXT", "order": "sing", "aromatic": False},
            {"atom1": "H1", "atom2": "N", "order": "sing", "aromatic": False},
            {"atom1": "H3", "atom2": "N", "order": "sing", "aromatic": False},
        ],
    },
    "PRO": {
        "bond_count": 19,
        "aromatic_bonds": 0,
        "bond_orders": {"sing": 18, "doub": 1},
        "bonds": [
            {"atom1": "N", "atom2": "CA", "order": "sing", "aromatic": False},
            {"atom1": "N", "atom2": "CD", "order": "sing", "aromatic": False},
            {"atom1": "N", "atom2": "H", "order": "sing", "aromatic": False},
            {"atom1": "CA", "atom2": "C", "order": "sing", "aromatic": False},
            {"atom1": "CA", "atom2": "CB", "order": "sing", "aromatic": False},
            {"atom1": "CA", "atom2": "HA", "order": "sing", "aromatic": False},
            {"atom1": "C", "atom2": "O", "order": "doub", "aromatic": False},
            {"atom1": "C", "atom2": "OXT", "order": "sing", "aromatic": False},
            {"atom1": "CB", "atom2": "CG", "order": "sing", "aromatic": False},
            {"atom1": "CB", "atom2": "HB2", "order": "sing", "aromatic": False},
            {"atom1": "CB", "atom2": "HB3", "order": "sing", "aromatic": False},
            {"atom1": "CG", "atom2": "CD", "order": "sing", "aromatic": False},
            {"atom1": "CG", "atom2": "HG2", "order": "sing", "aromatic": False},
            {"atom1": "CG", "atom2": "HG3", "order": "sing", "aromatic": False},
            {"atom1": "CD", "atom2": "HD2", "order": "sing", "aromatic": False},
            {"atom1": "CD", "atom2": "HD3", "order": "sing", "aromatic": False},
            {"atom1": "OXT", "atom2": "HXT", "order": "sing", "aromatic": False},
            {"atom1": "N", "atom2": "H2", "order": "sing", "aromatic": False},
            {"atom1": "H3", "atom2": "N", "order": "sing", "aromatic": False},
        ],
    },
    "SER": {
        "bond_count": 15,
        "aromatic_bonds": 0,
        "bond_orders": {"sing": 14, "doub": 1},
        "bonds": [
            {"atom1": "N", "atom2": "CA", "order": "sing", "aromatic": False},
            {"atom1": "N", "atom2": "H", "order": "sing", "aromatic": False},
            {"atom1": "N", "atom2": "H2", "order": "sing", "aromatic": False},
            {"atom1": "CA", "atom2": "C", "order": "sing", "aromatic": False},
            {"atom1": "CA", "atom2": "CB", "order": "sing", "aromatic": False},
            {"atom1": "CA", "atom2": "HA", "order": "sing", "aromatic": False},
            {"atom1": "C", "atom2": "O", "order": "doub", "aromatic": False},
            {"atom1": "C", "atom2": "OXT", "order": "sing", "aromatic": False},
            {"atom1": "CB", "atom2": "OG", "order": "sing", "aromatic": False},
            {"atom1": "CB", "atom2": "HB2", "order": "sing", "aromatic": False},
            {"atom1": "CB", "atom2": "HB3", "order": "sing", "aromatic": False},
            {"atom1": "OG", "atom2": "HG", "order": "sing", "aromatic": False},
            {"atom1": "OXT", "atom2": "HXT", "order": "sing", "aromatic": False},
            {"atom1": "H1", "atom2": "N", "order": "sing", "aromatic": False},
            {"atom1": "H3", "atom2": "N", "order": "sing", "aromatic": False},
        ],
    },
    "THR": {
        "bond_count": 18,
        "aromatic_bonds": 0,
        "bond_orders": {"sing": 17, "doub": 1},
        "bonds": [
            {"atom1": "N", "atom2": "CA", "order": "sing", "aromatic": False},
            {"atom1": "N", "atom2": "H", "order": "sing", "aromatic": False},
            {"atom1": "N", "atom2": "H2", "order": "sing", "aromatic": False},
            {"atom1": "CA", "atom2": "C", "order": "sing", "aromatic": False},
            {"atom1": "CA", "atom2": "CB", "order": "sing", "aromatic": False},
            {"atom1": "CA", "atom2": "HA", "order": "sing", "aromatic": False},
            {"atom1": "C", "atom2": "O", "order": "doub", "aromatic": False},
            {"atom1": "C", "atom2": "OXT", "order": "sing", "aromatic": False},
            {"atom1": "CB", "atom2": "OG1", "order": "sing", "aromatic": False},
            {"atom1": "CB", "atom2": "CG2", "order": "sing", "aromatic": False},
            {"atom1": "CB", "atom2": "HB", "order": "sing", "aromatic": False},
            {"atom1": "OG1", "atom2": "HG1", "order": "sing", "aromatic": False},
            {"atom1": "CG2", "atom2": "HG21", "order": "sing", "aromatic": False},
            {"atom1": "CG2", "atom2": "HG22", "order": "sing", "aromatic": False},
            {"atom1": "CG2", "atom2": "HG23", "order": "sing", "aromatic": False},
            {"atom1": "OXT", "atom2": "HXT", "order": "sing", "aromatic": False},
            {"atom1": "H1", "atom2": "N", "order": "sing", "aromatic": False},
            {"atom1": "H3", "atom2": "N", "order": "sing", "aromatic": False},
        ],
    },
    "TRP": {
        "bond_count": 30,
        "aromatic_bonds": 0,
        "bond_orders": {"sing": 25, "doub": 5},
        "bonds": [
            {"atom1": "N", "atom2": "CA", "order": "sing", "aromatic": False},
            {"atom1": "N", "atom2": "H", "order": "sing", "aromatic": False},
            {"atom1": "N", "atom2": "H2", "order": "sing", "aromatic": False},
            {"atom1": "CA", "atom2": "C", "order": "sing", "aromatic": False},
            {"atom1": "CA", "atom2": "CB", "order": "sing", "aromatic": False},
            {"atom1": "CA", "atom2": "HA", "order": "sing", "aromatic": False},
            {"atom1": "C", "atom2": "O", "order": "doub", "aromatic": False},
            {"atom1": "C", "atom2": "OXT", "order": "sing", "aromatic": False},
            {"atom1": "CB", "atom2": "CG", "order": "sing", "aromatic": False},
            {"atom1": "CB", "atom2": "HB2", "order": "sing", "aromatic": False},
            {"atom1": "CB", "atom2": "HB3", "order": "sing", "aromatic": False},
            {"atom1": "CG", "atom2": "CD1", "order": "doub", "aromatic": False},
            {"atom1": "CG", "atom2": "CD2", "order": "sing", "aromatic": False},
            {"atom1": "CD1", "atom2": "NE1", "order": "sing", "aromatic": False},
            {"atom1": "CD1", "atom2": "HD1", "order": "sing", "aromatic": False},
            {"atom1": "CD2", "atom2": "CE2", "order": "doub", "aromatic": False},
            {"atom1": "CD2", "atom2": "CE3", "order": "sing", "aromatic": False},
            {"atom1": "NE1", "atom2": "CE2", "order": "sing", "aromatic": False},
            {"atom1": "NE1", "atom2": "HE1", "order": "sing", "aromatic": False},
            {"atom1": "CE2", "atom2": "CZ2", "order": "sing", "aromatic": False},
            {"atom1": "CE3", "atom2": "CZ3", "order": "doub", "aromatic": False},
            {"atom1": "CE3", "atom2": "HE3", "order": "sing", "aromatic": False},
            {"atom1": "CZ2", "atom2": "CH2", "order": "doub", "aromatic": False},
            {"atom1": "CZ2", "atom2": "HZ2", "order": "sing", "aromatic": False},
            {"atom1": "CZ3", "atom2": "CH2", "order": "sing", "aromatic": False},
            {"atom1": "CZ3", "atom2": "HZ3", "order": "sing", "aromatic": False},
            {"atom1": "CH2", "atom2": "HH2", "order": "sing", "aromatic": False},
            {"atom1": "OXT", "atom2": "HXT", "order": "sing", "aromatic": False},
            {"atom1": "H1", "atom2": "N", "order": "sing", "aromatic": False},
            {"atom1": "H3", "atom2": "N", "order": "sing", "aromatic": False},
        ],
    },
    "TYR": {
        "bond_count": 26,
        "aromatic_bonds": 0,
        "bond_orders": {"sing": 22, "doub": 4},
        "bonds": [
            {"atom1": "N", "atom2": "CA", "order": "sing", "aromatic": False},
            {"atom1": "N", "atom2": "H", "order": "sing", "aromatic": False},
            {"atom1": "N", "atom2": "H2", "order": "sing", "aromatic": False},
            {"atom1": "CA", "atom2": "C", "order": "sing", "aromatic": False},
            {"atom1": "CA", "atom2": "CB", "order": "sing", "aromatic": False},
            {"atom1": "CA", "atom2": "HA", "order": "sing", "aromatic": False},
            {"atom1": "C", "atom2": "O", "order": "doub", "aromatic": False},
            {"atom1": "C", "atom2": "OXT", "order": "sing", "aromatic": False},
            {"atom1": "CB", "atom2": "CG", "order": "sing", "aromatic": False},
            {"atom1": "CB", "atom2": "HB2", "order": "sing", "aromatic": False},
            {"atom1": "CB", "atom2": "HB3", "order": "sing", "aromatic": False},
            {"atom1": "CG", "atom2": "CD1", "order": "doub", "aromatic": False},
            {"atom1": "CG", "atom2": "CD2", "order": "sing", "aromatic": False},
            {"atom1": "CD1", "atom2": "CE1", "order": "sing", "aromatic": False},
            {"atom1": "CD1", "atom2": "HD1", "order": "sing", "aromatic": False},
            {"atom1": "CD2", "atom2": "CE2", "order": "doub", "aromatic": False},
            {"atom1": "CD2", "atom2": "HD2", "order": "sing", "aromatic": False},
            {"atom1": "CE1", "atom2": "CZ", "order": "doub", "aromatic": False},
            {"atom1": "CE1", "atom2": "HE1", "order": "sing", "aromatic": False},
            {"atom1": "CE2", "atom2": "CZ", "order": "sing", "aromatic": False},
            {"atom1": "CE2", "atom2": "HE2", "order": "sing", "aromatic": False},
            {"atom1": "CZ", "atom2": "OH", "order": "sing", "aromatic": False},
            {"atom1": "OH", "atom2": "HH", "order": "sing", "aromatic": False},
            {"atom1": "OXT", "atom2": "HXT", "order": "sing", "aromatic": False},
            {"atom1": "H1", "atom2": "N", "order": "sing", "aromatic": False},
            {"atom1": "H3", "atom2": "N", "order": "sing", "aromatic": False},
        ],
    },
    "U": {
        "bond_count": 35,
        "aromatic_bonds": 0,
        "bond_orders": {"sing": 31, "doub": 4},
        "bonds": [
            {"atom1": "OP3", "atom2": "P", "order": "sing", "aromatic": False},
            {"atom1": "OP3", "atom2": "HOP3", "order": "sing", "aromatic": False},
            {"atom1": "P", "atom2": "OP1", "order": "doub", "aromatic": False},
            {"atom1": "P", "atom2": "OP2", "order": "sing", "aromatic": False},
            {"atom1": "P", "atom2": "O5'", "order": "sing", "aromatic": False},
            {"atom1": "OP2", "atom2": "HOP2", "order": "sing", "aromatic": False},
            {"atom1": "O5'", "atom2": "C5'", "order": "sing", "aromatic": False},
            {"atom1": "C5'", "atom2": "C4'", "order": "sing", "aromatic": False},
            {"atom1": "C5'", "atom2": "H5'", "order": "sing", "aromatic": False},
            {"atom1": "C5'", "atom2": "H5''", "order": "sing", "aromatic": False},
            {"atom1": "C4'", "atom2": "O4'", "order": "sing", "aromatic": False},
            {"atom1": "C4'", "atom2": "C3'", "order": "sing", "aromatic": False},
            {"atom1": "C4'", "atom2": "H4'", "order": "sing", "aromatic": False},
            {"atom1": "O4'", "atom2": "C1'", "order": "sing", "aromatic": False},
            {"atom1": "C3'", "atom2": "O3'", "order": "sing", "aromatic": False},
            {"atom1": "C3'", "atom2": "C2'", "order": "sing", "aromatic": False},
            {"atom1": "C3'", "atom2": "H3'", "order": "sing", "aromatic": False},
            {"atom1": "O3'", "atom2": "HO3'", "order": "sing", "aromatic": False},
            {"atom1": "C2'", "atom2": "O2'", "order": "sing", "aromatic": False},
            {"atom1": "C2'", "atom2": "C1'", "order": "sing", "aromatic": False},
            {"atom1": "C2'", "atom2": "H2'", "order": "sing", "aromatic": False},
            {"atom1": "O2'", "atom2": "HO2'", "order": "sing", "aromatic": False},
            {"atom1": "C1'", "atom2": "N1", "order": "sing", "aromatic": False},
            {"atom1": "C1'", "atom2": "H1'", "order": "sing", "aromatic": False},
            {"atom1": "N1", "atom2": "C2", "order": "sing", "aromatic": False},
            {"atom1": "N1", "atom2": "C6", "order": "sing", "aromatic": False},
            {"atom1": "C2", "atom2": "O2", "order": "doub", "aromatic": False},
            {"atom1": "C2", "atom2": "N3", "order": "sing", "aromatic": False},
            {"atom1": "N3", "atom2": "C4", "order": "sing", "aromatic": False},
            {"atom1": "N3", "atom2": "H3", "order": "sing", "aromatic": False},
            {"atom1": "C4", "atom2": "O4", "order": "doub", "aromatic": False},
            {"atom1": "C4", "atom2": "C5", "order": "sing", "aromatic": False},
            {"atom1": "C5", "atom2": "C6", "order": "doub", "aromatic": False},
            {"atom1": "C5", "atom2": "H5", "order": "sing", "aromatic": False},
            {"atom1": "C6", "atom2": "H6", "order": "sing", "aromatic": False},
        ],
    },
    "VAL": {
        "bond_count": 20,
        "aromatic_bonds": 0,
        "bond_orders": {"sing": 19, "doub": 1},
        "bonds": [
            {"atom1": "N", "atom2": "CA", "order": "sing", "aromatic": False},
            {"atom1": "N", "atom2": "H", "order": "sing", "aromatic": False},
            {"atom1": "N", "atom2": "H2", "order": "sing", "aromatic": False},
            {"atom1": "CA", "atom2": "C", "order": "sing", "aromatic": False},
            {"atom1": "CA", "atom2": "CB", "order": "sing", "aromatic": False},
            {"atom1": "CA", "atom2": "HA", "order": "sing", "aromatic": False},
            {"atom1": "C", "atom2": "O", "order": "doub", "aromatic": False},
            {"atom1": "C", "atom2": "OXT", "order": "sing", "aromatic": False},
            {"atom1": "CB", "atom2": "CG1", "order": "sing", "aromatic": False},
            {"atom1": "CB", "atom2": "CG2", "order": "sing", "aromatic": False},
            {"atom1": "CB", "atom2": "HB", "order": "sing", "aromatic": False},
            {"atom1": "CG1", "atom2": "HG11", "order": "sing", "aromatic": False},
            {"atom1": "CG1", "atom2": "HG12", "order": "sing", "aromatic": False},
            {"atom1": "CG1", "atom2": "HG13", "order": "sing", "aromatic": False},
            {"atom1": "CG2", "atom2": "HG21", "order": "sing", "aromatic": False},
            {"atom1": "CG2", "atom2": "HG22", "order": "sing", "aromatic": False},
            {"atom1": "CG2", "atom2": "HG23", "order": "sing", "aromatic": False},
            {"atom1": "OXT", "atom2": "HXT", "order": "sing", "aromatic": False},
            {"atom1": "H1", "atom2": "N", "order": "sing", "aromatic": False},
            {"atom1": "H3", "atom2": "N", "order": "sing", "aromatic": False},
        ],
    },
}


def get_residue_bonds(residue: str) -> List[Dict[str, Union[str, bool]]]:
    """
    Get bond information for a specific residue.

    Args:
        residue: Three-letter residue code (e.g., "ALA", "GLY")

    Returns:
        List of bond dictionaries with atom1, atom2, order, and aromatic info
    """
    bonds = RESIDUE_BONDS.get(residue, {}).get("bonds", [])
    # Type guard to ensure proper typing
    if isinstance(bonds, list):
        return [bond for bond in bonds if isinstance(bond, dict)]
    return []


def get_residue_bond_count(residue: str) -> int:
    """
    Get the total number of bonds for a residue.

    Args:
        residue: Three-letter residue code

    Returns:
        Number of bonds in the residue
    """
    count = RESIDUE_BONDS.get(residue, {}).get("bond_count", 0)
    return count if isinstance(count, int) else 0


def has_aromatic_bonds(residue: str) -> bool:
    """
    Check if a residue has aromatic bonds.

    Args:
        residue: Three-letter residue code

    Returns:
        True if the residue has aromatic bonds, False otherwise
    """
    aromatic_count = RESIDUE_BONDS.get(residue, {}).get("aromatic_bonds", 0)
    return isinstance(aromatic_count, int) and aromatic_count > 0


# Summary information
TOTAL_RESIDUES_WITH_BONDS = 32
AROMATIC_RESIDUES_COUNT = 0
TOTAL_BONDS_COUNT = 791

RESIDUES_WITH_BOND_DATA: List[str] = [
    "A",
    "ALA",
    "ARG",
    "ASN",
    "ASP",
    "C",
    "CYS",
    "DA",
    "DC",
    "DG",
    "DI",
    "DOD",
    "DT",
    "G",
    "GLN",
    "GLU",
    "GLY",
    "HIS",
    "HOH",
    "I",
    "ILE",
    "LEU",
    "LYS",
    "MET",
    "PHE",
    "PRO",
    "SER",
    "THR",
    "TRP",
    "TYR",
    "U",
    "VAL",
]
