# Generated by Django 5.0.9 on 2024-11-08 14:20

import django.core.validators
import django.db.models.deletion
import re
import taggit.managers
import utilities.json
import uuid
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("contenttypes", "0002_remove_content_type_name"),
        ("dcim", "0191_module_bay_rebuild"),
        ("extras", "0121_customfield_related_object_filter"),
        ("ipam", "0070_vlangroup_vlan_id_ranges"),
        ("tenancy", "0015_contactassignment_rename_content_type"),
        ("virtualization", "0040_convert_disk_size"),
    ]

    operations = [
        migrations.CreateModel(
            name="Application",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True, null=True)),
                ("last_updated", models.DateTimeField(auto_now=True, null=True)),
                (
                    "custom_field_data",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        encoder=utilities.json.CustomFieldJSONEncoder,
                    ),
                ),
                ("name", models.CharField(max_length=100)),
                ("version", models.CharField(max_length=100)),
                (
                    "devices",
                    models.ManyToManyField(
                        blank=True, related_name="nb_itsm_uses_apps", to="dcim.device"
                    ),
                ),
                (
                    "ipam_services",
                    models.ManyToManyField(
                        blank=True, related_name="nb_itsm_uses_apps", to="ipam.service"
                    ),
                ),
                (
                    "tags",
                    taggit.managers.TaggableManager(
                        through="extras.TaggedItem", to="extras.Tag"
                    ),
                ),
                (
                    "vm",
                    models.ManyToManyField(
                        blank=True,
                        related_name="nb_itsm_uses_apps",
                        to="virtualization.virtualmachine",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="ConfigurationItem",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True, null=True)),
                ("last_updated", models.DateTimeField(auto_now=True, null=True)),
                (
                    "custom_field_data",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        encoder=utilities.json.CustomFieldJSONEncoder,
                    ),
                ),
                (
                    "assigned_object_id",
                    models.PositiveIntegerField(blank=True, null=True),
                ),
                (
                    "assigned_object_type",
                    models.ForeignKey(
                        blank=True,
                        limit_choices_to=models.Q(
                            models.Q(
                                models.Q(("app_label", "dcim"), ("model", "device")),
                                models.Q(
                                    ("app_label", "circuits"), ("model", "circuit")
                                ),
                                models.Q(
                                    ("app_label", "virtualization"),
                                    ("model", "virtualmachine"),
                                ),
                                models.Q(
                                    ("app_label", "nb_itsm"), ("model", "application")
                                ),
                                _connector="OR",
                            )
                        ),
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="nb_itsm_object_models",
                        to="contenttypes.contenttype",
                    ),
                ),
                (
                    "tags",
                    taggit.managers.TaggableManager(
                        through="extras.TaggedItem", to="extras.Tag"
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Service",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True, null=True)),
                ("last_updated", models.DateTimeField(auto_now=True, null=True)),
                (
                    "custom_field_data",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        encoder=utilities.json.CustomFieldJSONEncoder,
                    ),
                ),
                ("name", models.CharField(max_length=100)),
                (
                    "slug",
                    models.CharField(
                        default=uuid.uuid4,
                        max_length=50,
                        unique=True,
                        validators=[
                            django.core.validators.RegexValidator(
                                flags=re.RegexFlag["IGNORECASE"],
                                message="Only alphanumeric characters and underscores are allowed.",
                                regex="^[a-z0-9_-]+$",
                            ),
                            django.core.validators.RegexValidator(
                                flags=re.RegexFlag["IGNORECASE"],
                                inverse_match=True,
                                message="Double underscores are not permitted in custom field names.",
                                regex="__",
                            ),
                        ],
                    ),
                ),
                ("status", models.CharField(max_length=100)),
                ("type", models.CharField(max_length=100)),
                ("comments", models.TextField(blank=True)),
                (
                    "client_groups",
                    models.ManyToManyField(
                        related_name="nb_itsm_services", to="tenancy.tenantgroup"
                    ),
                ),
                (
                    "clients",
                    models.ManyToManyField(
                        related_name="nb_itsm_services", to="tenancy.tenant"
                    ),
                ),
                (
                    "tags",
                    taggit.managers.TaggableManager(
                        through="extras.TaggedItem", to="extras.Tag"
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="Relation",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True, null=True)),
                ("last_updated", models.DateTimeField(auto_now=True, null=True)),
                (
                    "custom_field_data",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        encoder=utilities.json.CustomFieldJSONEncoder,
                    ),
                ),
                ("source_shape", models.IntegerField()),
                ("destination_shape", models.IntegerField()),
                ("connector_shape", models.IntegerField()),
                ("link_text", models.CharField(max_length=100)),
                (
                    "destination",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="nb_itsm_destination",
                        to="nb_itsm.configurationitem",
                    ),
                ),
                (
                    "source",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="nb_itsm_source",
                        to="nb_itsm.configurationitem",
                    ),
                ),
                (
                    "tags",
                    taggit.managers.TaggableManager(
                        through="extras.TaggedItem", to="extras.Tag"
                    ),
                ),
                (
                    "service",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="nb_itsm_relationships",
                        to="nb_itsm.service",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="PenTest",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True, null=True)),
                ("last_updated", models.DateTimeField(auto_now=True, null=True)),
                (
                    "custom_field_data",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        encoder=utilities.json.CustomFieldJSONEncoder,
                    ),
                ),
                ("comments", models.TextField(blank=True)),
                ("status", models.IntegerField()),
                ("date", models.DateField()),
                ("ticket", models.CharField(max_length=100)),
                ("report_link", models.CharField(max_length=100)),
                (
                    "tags",
                    taggit.managers.TaggableManager(
                        through="extras.TaggedItem", to="extras.Tag"
                    ),
                ),
                (
                    "service",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="nb_itsm_pentest_reports",
                        to="nb_itsm.service",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.AddField(
            model_name="configurationitem",
            name="service",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="nb_itsm_configuration_items",
                to="nb_itsm.service",
            ),
        ),
        migrations.AlterUniqueTogether(
            name="configurationitem",
            unique_together={("service", "assigned_object_type", "assigned_object_id")},
        ),
    ]
