# Copyright [2025] [SOPTIM AG]
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""
This module contains builders for transformer in the power grid model.
"""

from .experimental.two_w_transformer_as_genb_with_aux import (
    Transformer2WAsGenericBranchWithAuxBuilder,
)
from .experimental.two_w_transformer_aux_node import Transformer2WAuxNodeBuilder
from .three_w_pst_as_genb import Pst3WAsGenericBranchBuilder
from .three_w_pst_aux_node import Pst3WAuxNodeBuilder
from .three_w_transformer_as_genb import Transformer3WAsGenericBranchBuilder
from .three_w_transformer_aux_node import Transformer3WAuxNodeBuilder
from .two_w_pst_as_genb import Pst2WAsGenericBranchBuilder
from .two_w_transformer_as_genb import Transformer2WAsGenericBranchBuilder
