from decimal import Decimal
from django.db import models
from fec_raw.fields import CharField, IntegerField, DecimalField

class RawF3XFiling(models.Model):
    """
    One-to-one mapping of the fields in the raw data CSVs.
    Specific to F3X filing topsheets.
    """
    filing_no = IntegerField(
        unique=True)
    # ID of filing that this one amends
    report_id = CharField(
        max_length=20,
        null=True,
        blank=True)
    # 0-indexed (1 means first amendment)
    report_number = IntegerField(
        default=0)

    form_type = CharField(
        max_length=4,
        null=True,
        blank=True)
    filer_committee_id_number = CharField(
        max_length=9)

    committee_name = CharField(
        max_length=200,
        null=True,
        blank=True)
    change_of_address = CharField(
        max_length=1,
        null=True,
        blank=True)
    street_1 = CharField(
        max_length=50,
        null=True,
        blank=True)
    street_2 = CharField(
        max_length=50,
        null=True,
        blank=True)
    city = CharField(
        max_length=30,
        null=True,
        blank=True)
    state = CharField(
        max_length=2,
        null=True,
        blank=True)
    zip_code = CharField(
        max_length=20,
        null=True,
        blank=True)

    report_code = CharField(
        max_length=3,
        null=True,
        blank=True)
    election_code = CharField(
        max_length=5,
        null=True,
        blank=True)
    date_of_election = models.DateField(
        auto_now=False,
        null=True,
        blank=True)
    state_of_election = CharField(
        max_length=2,
        null=True,
        blank=True)
    coverage_from_date = models.DateField(
        auto_now=False,
        null=True)
    coverage_through_date = models.DateField(
        auto_now=False,
        null=True)

    qualified_committee = CharField(
        max_length=1,
        null=True,
        blank=True)

    treasurer_last_name = CharField(
        max_length=50,
        null=True,
        blank=True)
    treasurer_first_name = CharField(
        max_length=50,
        null=True,
        blank=True)
    treasurer_middle_name = CharField(
        max_length=50,
        null=True,
        blank=True)
    treasurer_prefix = CharField(
        max_length=10,
        null=True,
        blank=True)
    treasurer_suffix = CharField(
        max_length=200,
        null=True,
        blank=True)
    date_signed = models.DateField(
        auto_now=False)
    
    col_a_cash_on_hand_beginning_period = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_total_receipts = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_subtotal = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_total_disbursements = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_cash_on_hand_close_of_period = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_debts_to = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_debts_by = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_individuals_itemized = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_individuals_unitemized = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_individual_contribution_total = DecimalField(
        max_digits=16,
        decimal_places=2, 
        default=0)
    col_a_political_party_committees = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_other_political_committees_pacs = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_total_contributions = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_transfers_from_aff_other_party_cmttees = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_total_loans = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_total_loan_repayments_received = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_offsets_to_expenditures = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_total_contributions_refunds = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_other_federal_receipts = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_transfers_from_nonfederal_h3 = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_levin_funds = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_total_nonfederal_transfers = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_total_federal_receipts = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_shared_operating_expenditures_federal = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_shared_operating_expenditures_nonfederal = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_other_federal_operating_expenditures = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_total_operating_expenditures = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_transfers_to_affiliated = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_contributions_to_candidates = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_independent_expenditures = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_coordinated_expenditures_by_party_committees = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_total_loan_repayments_made = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_loans_made = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_refunds_to_individuals = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_refunds_to_party_committees = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_refunds_to_other_committees = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_total_refunds = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_other_disbursements = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_federal_election_activity_federal_share = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_federal_election_activity_levin_share = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_federal_election_activity_all_federal = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_federal_election_activity_total = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_total_federal_disbursements = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_net_contributions = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_total_federal_operating_expenditures = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_total_offsets_to_expenditures = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_net_operating_expenditures = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_cash_on_hand_jan_1 = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_year = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_total_receipts = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_subtotal = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_total_disbursements = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_cash_on_hand_close_of_period = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_individuals_itemized = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_individuals_unitemized = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_individual_contribution_total = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_political_party_committees = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_other_political_committees_pacs = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_total_contributions = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_transfers_from_aff_other_party_cmttees = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_total_loans = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_total_loan_repayments_received = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_offsets_to_expenditures = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_total_contributions_refunds = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_other_federal_receipts = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_transfers_from_nonfederal_h3 = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_levin_funds = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_total_nonfederal_transfers = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_total_federal_receipts = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_shared_operating_expenditures_federal = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_shared_operating_expenditures_nonfederal = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_other_federal_operating_expenditures = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_total_operating_expenditures = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_transfers_to_affiliated = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_contributions_to_candidates = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_independent_expenditures = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_coordinated_expenditures_by_party_committees = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_total_loan_repayments_made = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_loans_made = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_refunds_to_individuals = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_refunds_to_party_committees = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_refunds_to_other_committees = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_total_refunds = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_other_disbursements = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_federal_election_activity_federal_share = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_federal_election_activity_levin_share = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_federal_election_activity_all_federal = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_federal_election_activity_total = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_total_federal_disbursements = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_net_contributions = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_total_federal_operating_expenditures = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_total_offsets_to_expenditures = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_net_operating_expenditures = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)

    def __unicode__(self):
        return 'F3X filing {}'.format(self.filing_no)

class RawF3PFiling(models.Model):
    """
    Contains one-to-one copy of the raw fields produced by FECh.
    Specific to F3P filings.
    """
    filing_no = IntegerField(
        unique=True)
    # ID of filing that this one amends
    report_id = CharField(
        max_length=20,
        null=True,
        blank=True)
    # 0-indexed (1 means first amendment)
    report_number = IntegerField(
        default=0)

    form_type = CharField(
        max_length=4,
        null=True,
        blank=True)
    filer_committee_id_number = CharField(
        max_length=9, 
        null=True,
        blank=True)

    committee_name = CharField(
        max_length=200,
        null=True,
        blank=True)
    change_of_address = CharField(
        max_length=1,
        null=True,
        blank=True)
    street_1 = CharField(
        max_length=50,
        null=True,
        blank=True)
    street_2 = CharField(
        max_length=50,
        null=True,
        blank=True)
    city = CharField(
        max_length=30,
        null=True,
        blank=True)
    state = CharField(
        max_length=2,
        null=True,
        blank=True)
    zip_code = CharField(
        max_length=20, 
        null=True, 
        blank=True)

    activity_primary = CharField(
        max_length=1,
        null=True,
        blank=True)
    activity_general = CharField(
        max_length=1,
        null=True,
        blank=True)
    report_code = CharField(
        max_length=3,
        null=True,
        blank=True)
    election_code = CharField(
        max_length=5,
        null=True,
        blank=True)
    date_of_election = models.DateField(
        auto_now=False, 
        null=True, 
        blank=True)
    state_of_election = CharField(
        max_length=2,
        null=True,
        blank=True)
    coverage_from_date = models.DateField(
        auto_now=False,
        null=True)
    coverage_through_date = models.DateField(
        auto_now=False,
        null=True)

    treasurer_last_name = CharField(
        max_length=50,
        null=True,
        blank=True)
    treasurer_first_name = CharField(
        max_length=50,
        null=True,
        blank=True)
    treasurer_middle_name = CharField(
        max_length=50,
        null=True,
        blank=True)
    treasurer_prefix = CharField(
        max_length=10,
        null=True,
        blank=True)
    treasurer_suffix = CharField(
        max_length=10,
        null=True,
        blank=True)
    date_signed = models.DateField(
        auto_now=False)

    col_a_cash_on_hand_beginning_period = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_total_receipts = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_subtotal = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_total_disbursements = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_cash_on_hand_close_of_period = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_debts_to = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_debts_by = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_expenditures_subject_to_limits = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_net_contributions = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_net_operating_expenditures = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_federal_funds = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_individuals_itemized = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_individuals_unitemized = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_individual_contribution_total = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_political_party_committees_receipts = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_other_political_committees_pacs = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_the_candidate = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_total_contributions = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_transfers_from_aff_other_party_cmttees = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_received_from_or_guaranteed_by_cand = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_other_loans = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_total_loans = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_operating = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_fundraising = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_legal_and_accounting = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_total_offsets_to_expenditures = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_other_receipts = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_operating_expenditures = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_transfers_to_other_authorized_committees = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_fundraising_disbursements = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_exempt_legal_accounting_disbursement = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_made_or_guaranteed_by_candidate = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_other_repayments = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_total_loan_repayments_made = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_individuals = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_political_party_committees_refunds = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_other_political_committees = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_total_contributions_refunds = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_other_disbursements = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_items_on_hand_to_be_liquidated = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_alabama = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_alaska = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_arizona = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_arkansas = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_california = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_colorado = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_connecticut = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_delaware = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_dist_of_columbia = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_florida = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_georgia = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_hawaii = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_idaho = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_illinois = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_indiana = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_iowa = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_kansas = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_kentucky = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_louisiana = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_maine = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_maryland = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_massachusetts = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_michigan = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_minnesota = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_mississippi = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_missouri = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_montana = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_nebraska = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_nevada = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_new_hampshire = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_new_jersey = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_new_mexico = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_new_york = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_north_carolina = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_north_dakota = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_ohio = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_oklahoma = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_oregon = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_pennsylvania = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_rhode_island = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_south_carolina = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_south_dakota = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_tennessee = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_texas = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_utah = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_vermont = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_virginia = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_washington = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_west_virginia = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_wisconsin = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_wyoming = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_puerto_rico = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_guam = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_virgin_islands = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_a_totals = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)

    col_b_federal_funds = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_individuals_itemized = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_individuals_unitemized = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_individual_contribution_total = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_political_party_committees_receipts = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_other_political_committees_pacs = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_the_candidate = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_total_contributions_other_than_loans = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_transfers_from_aff_other_party_cmttees = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_received_from_or_guaranteed_by_cand = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_other_loans = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_total_loans = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_operating = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_fundraising = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_legal_and_accounting = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_total_offsets_to_operating_expenditures = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_other_receipts = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_total_receipts = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_operating_expenditures = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_transfers_to_other_authorized_committees = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_fundraising_disbursements = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_exempt_legal_accounting_disbursement = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_made_or_guaranteed_by_the_candidate = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_other_repayments = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_total_loan_repayments_made = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_individuals = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_political_party_committees_refunds = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_other_political_committees = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_total_contributions_refunds = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_other_disbursements = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_total_disbursements = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_alabama = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_alaska = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_arizona = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_arkansas = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_california = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_colorado = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_connecticut = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_delaware = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_dist_of_columbia = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_florida = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_georgia = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_hawaii = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_idaho = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_illinois = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_indiana = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_iowa = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_kansas = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_kentucky = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_louisiana = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_maine = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_maryland = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_massachusetts = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_michigan = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_minnesota = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_mississippi = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_missouri = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_montana = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_nebraska = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_nevada = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_new_hampshire = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_new_jersey = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_new_mexico = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_new_york = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_north_carolina = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_north_dakota = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_ohio = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_oklahoma = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_oregon = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_pennsylvania = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_rhode_island = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_south_carolina = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_south_dakota = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_tennessee = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_texas = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_utah = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_vermont = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_virginia = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_washington = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_west_virginia = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_wisconsin = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_wyoming = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_puerto_rico = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_guam = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_virgin_islands = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)
    col_b_totals = DecimalField(
        max_digits=16,
        decimal_places=2,
        default=0)

    def __unicode__(self):
        return 'F3P filing {}'.format(self.filing_no)

class RawF24Filing(models.Model):
    """
    One-to-one mapping of the fields in the raw data CSVs.
    Specific to F24 filing topsheets.
    """
    filing_no = IntegerField(
        unique=True)
    # ID of filing that this one amends
    report_id = CharField(
        max_length=20,
        null=True,
        blank=True)
    # 0-indexed (1 means first amendment)
    report_number = IntegerField(
        default=0)

    form_type = CharField(
        max_length=4,
        null=True,
        blank=True)
    filer_committee_id_number = CharField(
        max_length=9,
        null=True,
        blank=True)
    report_type = CharField(
        max_length=2,
        null=True,
        blank=True)
    original_amendment_date = models.DateField(
        auto_now=False,
        null=True)

    committee_name = CharField(
        max_length=200,
        null=True,
        blank=True)
    street_1 = CharField(
        max_length=50,
        null=True,
        blank=True)
    street_2 = CharField(
        max_length=50,
        null=True,
        blank=True)
    city = CharField(
        max_length=30,
        null=True,
        blank=True)
    state = CharField(
        max_length=2,
        null=True,
        blank=True)
    zip_code = CharField(
        max_length=20,
        null=True,
        blank=True)

    treasurer_last_name = CharField(
        max_length=50,
        null=True,
        blank=True)
    treasurer_first_name = CharField(
        max_length=50,
        null=True,
        blank=True)
    treasurer_middle_name = CharField(
        max_length=50,
        null=True,
        blank=True)
    treasurer_prefix = CharField(
        max_length=10,
        null=True,
        blank=True)
    treasurer_suffix = CharField(
        max_length=10,
        null=True,
        blank=True)
    date_signed = models.DateField(
        auto_now=False)

    def __unicode__(self):
        return 'F24 filing {}'.format(self.filing_no)
