# IMPORT LIBRARIES
import io
import base64
from PIL import Image as PIL_Image
from .N_GUI import GUI
from .N_Image_Lite import Image_Lite
from .N_Custom import Event_Bind

def Create_Image(Image_Data):
    try:
        Image_Data = base64.b64decode(Image_Data)
        return PIL_Image.open(io.BytesIO(Image_Data))
    except:
        pass

Image_True = Create_Image("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")
Image_False = Create_Image("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")

class Variable:

    def __init__(self, *args, **kwargs):
        self._GUI = GUI._Instance
        if self._GUI is not None:
            self._Type = 'Variable'
            self._Variable = False
            self._Widget = []
        else:
            print("Error: GUI Create Instance Has Not Been Created")
        
    def __str__(self):
        return "Nucleon_GUI_Radio_Value[]"

    def __repr__(self):
        return "Nucleon_GUI_Radio_Value[]"
        
    def Get(self):
        try:
            return self._Variable
        except Exception as E:
            self._GUI.Error(f"{self._Type} ->  -> {E}")

class Radio:

    def __init__(self, Main, *args, **kwargs):
        self._GUI = GUI._Instance
        if self._GUI is not None:
            self._Type = "Radio"
            try:
                self._Config = ['Name', 'Auto_Dark', 'Background', 'Light_Background', 'Dark_Background', 'Resize_Width', 'Resize', 'Resize_Height', 'Move', 'Move_Left', 'Move_Top', 'Popup', 'Display', 'Left', 'Top', 'Width', 'Height', 'Value', 'Variable']
                self._Initialized = False
                self._Name = False
                self._Last_Name = False
                self._Widget = []
                self._Resize_Font, self._Resize, self._Resize_Width, self._Resize_Height, self._Move, self._Move_Left, self._Move_Top = False, True, True, True, True, True, True
                self._Image = {True: Image_True, False: Image_False}
                self._Popup = False
                self._Display = True
                self._Size_Update = False
                self._Resize_Index = 0
                self._Main = Main
                self._Frame = Image_Lite(self._Main)
                self._Frame.Config(Convert_Type='RGBA')
                self._Background = self._Main._Background
                self._Background_Main = True
                self._Check = False
                self._On_Change = False
                self._Value = False
                self._Variable = False
                self._Resizable = self._Main._Resizable
                self._Auto_Dark = True
                self._On_Show = False
                self._On_Hide = False
            except Exception as E:
                self._GUI.Error(f"{self._Type} -> Init -> {E}")
        else:
            print("Error: Gluonix -> GUI Instance Has Not Been Created")

    def __str__(self):
        return "Nucleon_Glunoix_Radio[]"

    def __repr__(self):
        return "Nucleon_Glunoix_Radio[]"
    
    def Copy(self, Name=False, Main=False):
        try:
            if not Main:
                Main = self._Main
            Instance = type(self)(Main)
            for Key in self._Config:
                if hasattr(self, "_"+Key):
                    setattr(Instance, "_"+Key, getattr(self, "_"+Key))
            if Name:
                setattr(Instance, "_Name", Name)
            Instance.Create()
            return Instance
        except Exception as E:
            self._GUI.Error(f"{self._Type} -> Copy -> {E}")
        
    def Delete(self):
        try:
            self._Main._Widget.remove(self)
            self._Frame.Delete()
            if self:
                del self
        except Exception as E:
            self._GUI.Error(f"{self._Type} -> Delete -> {E}")
            
    def Hide(self):
        try:
            self._Frame.Hide()
            self._Display = False
            if self._On_Hide:
                self._On_Hide()
        except Exception as E:
            self._GUI.Error(f"{self._Type} -> Hide -> {E}")
            
    def Show(self):
        try:
            self._Display = True
            if self._Resizable and self._Resize_Index<self._GUI._Resize_Index:
                self.Resize()
            else:
                self.Display()
            if self._On_Show:
                self._On_Show()
        except Exception as E:
            self._GUI.Error(f"{self._Type} -> Show -> {E}")
            
    def Display(self):
        try:
            self._Frame.Show()
            self._Display = True
        except Exception as E:
            self._GUI.Error(f"{self._Type} -> Display -> {E}")
    
    def Grab(self, Path=False):
        try:
            return self._GUI.Grab_Widget(Path=Path, Widget=self)
        except Exception as E:
            self._GUI.Error(f"{self._Type} -> Grab -> {E}")
            
    def Animate(self):
        try:
            self._Frame.Animate()
            self.Show()
        except Exception as E:
            self._GUI.Error(f"{self._Type} -> Animate -> {E}")
            self.Animate_Cancel()
            
    def Animate_Cancel(self):
        try:
            self._Frame.Animate_Cancel()
        except Exception as E:
            self._GUI.Error(f"{self._Type} -> Animate_Cancel -> {E}")
            
    def Reset(self):
        try:
            self._Frame.Set(Path=self._Image[False])
        except Exception as E:
            self._GUI.Error(f"{self._Type} -> Reset -> {E}")
            
    def Set(self):
        try:
            if self._Variable:
                if self._Value!=self._Variable._Variable:
                    self._Variable._Variable = self._Value
                    for Each in self._Variable._Widget:
                        Each.Reset()
                    self._Frame.Set(Path=self._Image[True])
        except Exception as E:
            self._GUI.Error(f"{self._Type} -> Set -> {E}")
            
    def Set_On_Click(self):
        try:
            if self._Variable:
                if self._Value!=self._Variable._Variable:
                    self._Variable._Variable = self._Value
                    for Each in self._Variable._Widget:
                        Each.Reset()
                    self._Frame.Set(Path=self._Image[True])
                    if self._On_Change:
                        self._On_Change()
        except Exception as E:
            self._GUI.Error(f"{self._Type} -> Set_On_Click -> {E}")
            
    def Widget(self):
        try:
            return self._Frame._Widget
        except Exception as E:
            self._GUI.Error(f"{self._Type} -> Widget -> {E}")
            
    def Bind(self, **Input):
        try:
            if 'On_Show' in Input:
                self._On_Show = Input['On_Show']
            if 'On_Hide' in Input:
                self._On_Hide = Input['On_Hide']
            if 'On_Change' in Input:
                self._On_Change = Input['On_Change']
            self._Frame.Bind(**Input)
        except Exception as E:
            self._GUI.Error(f"{self._Type} -> Bind -> {E}")
            
    def Config_Get(self, *Input):
        try:
            Return = {}
            for Each in self._Config:
                if Each in Input:
                    Return[Each] = getattr(self, "_"+Each)
            return Return
        except Exception as E:
            self._GUI.Error(f"{self._Type} -> Config_Get -> {E}")
                
    def Config(self, **Input):
        try:
            Run = False
            for Each in self._Config:
                if Each in Input:
                    Value = Input[Each]
                    setattr(self, "_"+Each, Value)
                    Run = True
            self._Frame.Config(**Input)
            if "Width" in Input or "Height" in Input or "Left" in Input or "Top" in Input:
                self._Size_Update = True
            if self._Initialized and Run:
                self.Create()
            if "Background" in Input:
                self._Background_Main = not bool(Input["Background"])
        except Exception as E:
            self._GUI.Error(f"{self._Type} -> Config -> {E}")
            
    def Move(self, Left=None, Top=None):
        try:
            if Left is not None:
                self._Left += Left
            if Top is not None:
                self._Top += Top
            if Left is not None or Top is not None:
                self.Position(Left=self._Left, Top=self._Top)
            return True
        except Exception as E:
            self._GUI.Error(f"{self._Type} -> Move -> {E}")
            
    def Center(self, Left=None, Top=None):
        try:
            if Left is not None:
                self._Left = Left-self._Width/2
            if Top is not None:
                self._Top = Top-self._Height/2
            if Left is not None or Top is not None:
                self.Position(Left=self._Left, Top=self._Top)
            return [self._Left+self._Width/2, self._Top+self._Height/2]
        except Exception as E:
            self._GUI.Error(f"{self._Type} -> Center -> {E}")
            
    def Position(self, Left=None, Top=None):
        try:
            if Left is not None:
                self._Left = Left
            if Top is not None:
                self._Top = Top
            if Left is not None or Top is not None:
                self._Frame.Position(Left=self._Left, Top=self._Top)
                self.Relocate()
            return self._Frame.Position()
        except Exception as E:
            self._GUI.Error(f"{self._Type} -> Position -> {E}")
            
    def Size(self, Width=False, Height=False):
        try:
            if Width:
                self._Width = Width
            if Height:
                self._Height = Height
            if Width or Height:
                self._Frame.Size(Width=self._Width, Height=self._Height)
                self.Relocate()
            return self._Frame.Size()
        except Exception as E:
            self._GUI.Error(f"{self._Type} -> Size -> {E}")
        
    def Locate(self, Width, Height, Left, Top):
        try:
            Width = self._Width*(Width/100)
            Height = self._Height*(Height/100)
            Left = self._Width*(Left/100)-self._Border_Size
            Top = self._Height*(Top/100)-self._Border_Size
            return [Width, Height, Left, Top]
        except Exception as E:
            self._GUI.Error(f"{self._Type} -> Locate -> {E}")
        
    def Locate_Reverse(self, Width, Height, Left, Top):
        try:
            Width = round((Width/self._Width)*100, 3)
            Height = round((Height/self._Height)*100, 3)
            Left =  round((Left/self._Width)*100, 3)
            Top =  round((Top/self._Height)*100, 3)
            return [Width, Height, Left, Top]
        except Exception as E:
            self._GUI.Error(f"{self._Type} -> Locate_Reverse -> {E}")
            
    def Create(self):
        try:
            if not self._Background:
                self._Background = self._Main._Background
                if not hasattr(self, "_Light_Background"):
                    setattr(self, "_Light_Background", self._Background)
                if not hasattr(self, "_Dark_Background"):
                    setattr(self, "_Dark_Background", self._GUI.Invert(self._Background))
            if self._Auto_Dark and not self._GUI._Dark_Mode:
                self.Update_Color()
            if not self._Initialized:
                self.Update_Color()
                self._Width_Current, self._Height_Current, self._Left_Current, self._Top_Current, = self._Width, self._Height, self._Left, self._Top
                self._Frame.Config(Width=self._Width_Current, Height=self._Height_Current, Left=self._Left_Current, Top=self._Top_Current)
                self._Frame.Config(Background=self._Background)
                self._Frame.Config(Transparent=True, Use_Foreground=True)
                self._Frame.Bind(On_Click=lambda E: self.Set_On_Click())
                self._Frame.Create()
                self._Frame.Config(Convert_Type='RGBA', Pil=True)
                if not self._Display:
                    self.Hide()
                self._Main._Widget.append(self)
                self._Initialized = True
            if self._Variable:
                if self not in self._Variable._Widget:
                    self._Variable._Widget.append(self)
            self._Frame.Set(Path=self._Image[self._Check])
            self.Resize()
            if self._Display:
                self.Display()
            if self._Name!=self._Last_Name:
                if self._Last_Name:
                    if self._Last_Name in self._Main.__dict__:
                        del self._Main.__dict__[self._Last_Name]
                if self._Name:
                    self._Main.__dict__[self._Name] = self
                self._Last_Name = self._Name
        except Exception as E:
            self._GUI.Error(f"{self._Type} -> Create -> {E}")
            
    def Update_Color(self):
        try:
            self._GUI.Initiate_Colors(self)
        except Exception as E:
            self._GUI.Error(f"{self._Type} -> Update_Color -> {E}")
            
    def Relocate(self, Direct=False):
        try:
            self.Display()
        except Exception as E:
            self._GUI.Error(f"{self._Type} -> Relocate -> {E}")
            
    def Resize(self):
        try:
            self._Resize_Index = self._GUI._Resize_Index
            self.Relocate()
        except Exception as E:
            self._GUI.Error(f"{self._Type} -> Resize -> {E}")
            