# Gluonix Designer V(6.2)
- Gluonix Designer is a GUI design tool for Python applications that simplifies the process of creating graphical user interfaces using a drag-and-drop approach. This tool is aimed at developers who want to quickly prototype or build Python GUIs without extensive manual coding.

## Feedback
- We hope you find Gluonix Designer helpful and easy to use. If you have any thoughts or suggestions, we’d love to hear from you at feedback@nucleonautomation.com. Your feedback is invaluable in helping us improve and enhance the tool.

## Features
- Drag-and-Drop Interface: Design your GUI by dragging and dropping components onto a canvas.
- Python Code Generation: Automatically generates Python code based on your GUI design.
- Component Library: Includes a variety of pre-built components such as buttons, labels, input fields, etc.
- Customization: Customize properties and behaviors of components directly through the interface.
- Export to Python: Export your designed GUI to a Python script that can be integrated into your Python project.## Screenshots

### Project Setting

![Github Home](https://raw.githubusercontent.com/nucleonautomation/Gluonix-Designer/main/Screenshots/Image_01.png)

### Design Panel

![Github Home](https://raw.githubusercontent.com/nucleonautomation/Gluonix-Designer/main/Screenshots/Image_02.png)

## Examples

### [Replica of Covision Quality](https://github.com/nucleonautomation/Gluonix-Designer/blob/main/Examples/Covision)

![Github Home](https://raw.githubusercontent.com/nucleonautomation/Gluonix-Designer/main/Examples/Covision/Image_01.png)

### [Replica of Github Desktop](https://github.com/nucleonautomation/Gluonix-Designer/blob/main/Examples/Github)

![Github Home](https://raw.githubusercontent.com/nucleonautomation/Gluonix-Designer/main/Examples/Github/Image_01.png)
![Github Menu](https://raw.githubusercontent.com/nucleonautomation/Gluonix-Designer/main/Examples/Github/Image_02.png)


## Tutorial
- See the [TUTORIAL](https://github.com/nucleonautomation/Gluonix-Designer/blob/main/TUTORIAL.md) file for details.

## Help
- See the [HELP](https://github.com/nucleonautomation/Gluonix-Designer/blob/main/Help.pdf) file for details.

## Installation Pypi
```
# Requires Python >=3.6
pip install GluonixDesigner

# Start Application
Gluonix
#or
GluonixDesigner
```

## Installation Git
```
# Requires Python >=3.6
git clone https://github.com/nucleonautomation/Gluonix-Designer.git

# Start Application
cd Gluonix-Designer
python Designer.py
```

## Requirements
```
pip install -r requirements.txt
```

## License
- This project is licensed under BSD 4-Clause License. See the [LICENSE](https://github.com/nucleonautomation/Gluonix-Designer/blob/main/LICENSE.md) file for details.

## Change Log
- See the [LOG](https://github.com/nucleonautomation/Gluonix-Designer/blob/main/LOG.md) file for details.
