# Generated by Django 2.2.10 on 2020-07-06 16:20

from ..fields import VRPaymentDecimalField
import django.contrib.postgres.fields.jsonb
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="VRPaymentBasicPayment",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created_at",
                    models.DateTimeField(auto_now_add=True, verbose_name="Created at"),
                ),
                (
                    "last_modified",
                    models.DateTimeField(auto_now=True, verbose_name="Last modified"),
                ),
                (
                    "entity_id",
                    models.CharField(
                        help_text="The entity required to authorize the request. This should be the channel entity identifier. In case channel dispatching is activated then it should be the merchant entity identifier.",
                        max_length=32,
                        verbose_name="Entity ID",
                    ),
                ),
                (
                    "amount",
                    VRPaymentDecimalField(
                        decimal_places=2,
                        help_text="Indicates the amount of the payment request. The dot is used as decimal separator. The amount is the only amount value which is processing relevant. All other amount declarations like taxAmount or shipping.cost are already included.",
                        max_digits=12,
                        verbose_name="Amount",
                    ),
                ),
                (
                    "tax_amount",
                    VRPaymentDecimalField(
                        decimal_places=2,
                        help_text="Indicates the tax amount of the payment request.",
                        max_digits=12,
                        verbose_name="Tax amount",
                    ),
                ),
                (
                    "currency",
                    models.CharField(
                        default="EUR",
                        help_text="The ISO 4217 currency code of the payment request's amount",
                        max_length=3,
                        verbose_name="Currency",
                    ),
                ),
                (
                    "payment_brand",
                    models.CharField(
                        blank=True,
                        help_text="The brand specifies the method of payment for the request. This is optional if you want to use brand detection for credit cards, if not then it is mandatory.",
                        max_length=32,
                        null=True,
                        validators=[
                            django.core.validators.RegexValidator(
                                regex="[a-zA-Z0-9_]{1,32}"
                            )
                        ],
                        verbose_name="Payment brand",
                    ),
                ),
                (
                    "payment_type",
                    models.CharField(
                        choices=[
                            ("PA", "Preauthorization"),
                            ("DB", "Debit"),
                            ("CD", "Credit"),
                            ("CP", "Capture"),
                            ("RV", "Reversal"),
                            ("RF", "Refund"),
                        ],
                        help_text="The payment type for the request. See docs for supported types",
                        max_length=2,
                        verbose_name="Payment type",
                    ),
                ),
                (
                    "descriptor",
                    models.CharField(
                        blank=True,
                        help_text="Can be used to populate all or part of the Merchant Name descriptor, which often appears on the first line of the shopper's statement. The full use of this field depends on the Merchant Account configuration. NOTE: merchant.name can override any data sent in this field.",
                        max_length=127,
                        null=True,
                        verbose_name="Descriptor",
                    ),
                ),
                (
                    "merchant_transaction_id",
                    models.CharField(
                        help_text="Merchant-provided reference number, should be unique for your transactions. Some receivers require this ID. This identifier is often used for reconciliation.",
                        max_length=255,
                        unique=True,
                        validators=[django.core.validators.MinLengthValidator(8)],
                        verbose_name="Merchant transaction ID",
                    ),
                ),
                (
                    "merchant_invoice_id",
                    models.CharField(
                        blank=True,
                        help_text="Merchant-provided invoice number, should be unique for your transactions. This identifier is not sent onwards.",
                        max_length=255,
                        null=True,
                        unique=True,
                        validators=[django.core.validators.MinLengthValidator(8)],
                        verbose_name="Merchant invoice ID",
                    ),
                ),
                (
                    "merchant_memo",
                    models.CharField(
                        blank=True,
                        help_text="Merchant-provided additional information. The information provided is not transaction processing relevant. It will appear in reporting only.",
                        max_length=255,
                        null=True,
                        validators=[django.core.validators.MinLengthValidator(8)],
                        verbose_name="Merchant memo",
                    ),
                ),
                (
                    "transaction_category",
                    models.CharField(
                        blank=True,
                        help_text="The category of the transaction. See docs for possible values:",
                        max_length=32,
                        null=True,
                        verbose_name="Transaction category",
                    ),
                ),
                (
                    "sandbox",
                    models.BooleanField(
                        help_text="Determine if this transaction uses the Test or Live host",
                        verbose_name="Sandbox",
                    ),
                ),
                (
                    "resource_path",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="VR Payment resource path can. Can be used to get the status",
                        max_length=512,
                        null=True,
                        verbose_name="VR Payment Resource Path",
                    ),
                ),
                (
                    "payment_id",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="The identifier of the payment request that can be used to reference the payment later",
                        max_length=32,
                        null=True,
                        validators=[
                            django.core.validators.RegexValidator("[a-zA-Z0-9]{32}")
                        ],
                        verbose_name="VR Payment ID",
                    ),
                ),
            ],
            options={
                "verbose_name": "VR Payment Basic Payment Checkout",
                "verbose_name_plural": "VR Payment Basic Checkouts",
            },
        ),
        migrations.CreateModel(
            name="VRPaymentCheckoutResponse",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created_at",
                    models.DateTimeField(auto_now_add=True, verbose_name="Created at"),
                ),
                (
                    "last_modified",
                    models.DateTimeField(auto_now=True, verbose_name="Last modified"),
                ),
                (
                    "http_status_code",
                    models.IntegerField(
                        help_text="response status code",
                        verbose_name="HTTP status code",
                    ),
                ),
                ("url", models.URLField(help_text="request url", verbose_name="URL")),
                (
                    "raw_headers",
                    django.contrib.postgres.fields.jsonb.JSONField(
                        help_text="response header as json", verbose_name="Headers"
                    ),
                ),
                (
                    "raw_content",
                    django.contrib.postgres.fields.jsonb.JSONField(
                        help_text="response content as json", verbose_name="Content"
                    ),
                ),
                (
                    "build_number",
                    models.CharField(
                        blank=True,
                        help_text="Useful for support purposes.",
                        max_length=255,
                        null=True,
                        verbose_name="API response build number",
                    ),
                ),
                (
                    "ndc",
                    models.CharField(
                        blank=True,
                        help_text="An internal unique identifier for the request.",
                        max_length=65,
                        null=True,
                        verbose_name="ndc",
                    ),
                ),
                (
                    "result_code",
                    models.CharField(
                        blank=True,
                        help_text="Status Code from VR Payment. see content for description",
                        max_length=11,
                        null=True,
                        verbose_name="VR Payment status code",
                    ),
                ),
                (
                    "result_description",
                    models.CharField(
                        blank=True,
                        help_text="A textual description explaining the result.code's meaning.",
                        max_length=255,
                        null=True,
                        verbose_name="Result Description",
                    ),
                ),
                (
                    "result_avs_response",
                    models.CharField(
                        blank=True,
                        help_text="Contains the AVS response returned by the acquirer. It may include one the following result:A = Address does match, zip code does not matchZ = Address does not match, zip code does matchN = Address and zip code do not matchU = Technical or logical error. AVS cannot be applied on card or address (not UK or US issuer), issuer is not available, etc.F = Address and Postal Code Matches",
                        max_length=1,
                        null=True,
                        verbose_name="Result avs response",
                    ),
                ),
                (
                    "result_cvv_response",
                    models.CharField(
                        blank=True,
                        help_text="Contains the CVV response returned by the acquirer.",
                        max_length=1,
                        null=True,
                        verbose_name="Result cvv response",
                    ),
                ),
                (
                    "result_details",
                    django.contrib.postgres.fields.jsonb.JSONField(
                        blank=True,
                        help_text="A container for name value pair used for enriching the response with bank-specific response details. I.e. the actual parameters used within resultDetails are bank-specific.",
                        null=True,
                        verbose_name="Result details",
                    ),
                ),
                (
                    "result_details_acquirer_response",
                    django.contrib.postgres.fields.jsonb.JSONField(
                        blank=True,
                        help_text="Represents the acquirer original response code retrieved from the acquirer directly.",
                        null=True,
                        verbose_name="Result details - Acquirer response",
                    ),
                ),
                (
                    "card_bin",
                    models.CharField(
                        blank=True,
                        help_text="The first six digits of the card.number",
                        max_length=6,
                        null=True,
                        verbose_name="Card bin",
                    ),
                ),
                (
                    "card_holder",
                    models.CharField(
                        blank=True,
                        help_text="Holder of the credit card account",
                        max_length=6,
                        null=True,
                        verbose_name="Card holder",
                    ),
                ),
                (
                    "card_expiry_month",
                    models.CharField(
                        blank=True,
                        help_text="The expiry month of the card",
                        max_length=2,
                        null=True,
                        verbose_name="Card expiry month",
                    ),
                ),
                (
                    "card_expiry_year",
                    models.CharField(
                        blank=True,
                        help_text="The expiry year of the card",
                        max_length=4,
                        null=True,
                        verbose_name="Card expiry year",
                    ),
                ),
                (
                    "merchant_bank_account_holder",
                    models.CharField(
                        blank=True,
                        help_text="Holder of the merchant's bank account",
                        max_length=128,
                        null=True,
                        verbose_name="Merchant bank account holder",
                    ),
                ),
                (
                    "merchant_bank_account_nummber",
                    models.CharField(
                        blank=True,
                        help_text="The account number of the merchant's bank account. (IBAN for SEPA accounts)",
                        max_length=64,
                        null=True,
                        verbose_name="Merchant bank account nummber",
                    ),
                ),
                (
                    "merchant_bank_account_bic",
                    models.CharField(
                        blank=True,
                        help_text="The BIC (Bank Identifier Code (SWIFT)) number of the merchant's bank account.",
                        max_length=11,
                        null=True,
                        verbose_name="Merchant bank account bic",
                    ),
                ),
                (
                    "merchant_bank_account_country",
                    models.CharField(
                        blank=True,
                        help_text="The country code of the merchant's bank account (ISO 3166-1).",
                        max_length=2,
                        null=True,
                        verbose_name="Merchant bank account country",
                    ),
                ),
                (
                    "vr_pay_id",
                    models.CharField(
                        blank=True,
                        help_text="The VR Pay identifier of this object",
                        max_length=48,
                        null=True,
                        verbose_name="ID",
                    ),
                ),
                (
                    "reference_id",
                    models.CharField(
                        blank=True,
                        help_text="In case of referenced payment (e.g., Capture or Refund), this fields included to see which payment was referenced.",
                        max_length=32,
                        null=True,
                        validators=[
                            django.core.validators.RegexValidator(
                                regex="[a-zA-Z0-9]{32}"
                            )
                        ],
                        verbose_name="ReferenceID",
                    ),
                ),
                (
                    "payment_brand",
                    models.CharField(
                        blank=True,
                        help_text="The payment brand of the request.",
                        max_length=32,
                        null=True,
                        validators=[
                            django.core.validators.RegexValidator(
                                regex="[a-zA-Z0-9_] {1,32}"
                            )
                        ],
                        verbose_name="Payment brand",
                    ),
                ),
                (
                    "amount",
                    VRPaymentDecimalField(
                        blank=True,
                        decimal_places=2,
                        help_text="The amount of the request",
                        max_digits=12,
                        null=True,
                        verbose_name="Amount",
                    ),
                ),
                (
                    "currency",
                    models.CharField(
                        default="EUR",
                        help_text="The ISO 4217 currency code of the payment request's amount",
                        max_length=3,
                        null=True,
                        verbose_name="Currency",
                    ),
                ),
                (
                    "descriptor",
                    models.CharField(
                        blank=True,
                        help_text="The descriptor of the request.",
                        max_length=127,
                        null=True,
                        verbose_name="Descriptor",
                    ),
                ),
                (
                    "risk_score",
                    models.IntegerField(
                        blank=True,
                        help_text="Returns the score of the executed transaction risk checks. The value is a number from -99999 to +99999. Can be returned both for standalone risk requests and payment requests that include risk checks.",
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(-99999),
                            django.core.validators.MaxValueValidator(99999),
                        ],
                        verbose_name="Risk score",
                    ),
                ),
                (
                    "other",
                    django.contrib.postgres.fields.jsonb.JSONField(
                        blank=True,
                        help_text="The response can also contain each of the data structures listed above, such as 'customer' and 'billingAddress'.",
                        null=True,
                        verbose_name="Other",
                    ),
                ),
                (
                    "basic_payment",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="checkout_response",
                        to="django_vr_payment.VRPaymentBasicPayment",
                        verbose_name="VR Payment Basic Payment Checkout",
                    ),
                ),
            ],
            options={
                "verbose_name": "VR Payment Checkout Reponse",
                "verbose_name_plural": "VR Payment Checkout Reponses",
            },
        ),
        migrations.CreateModel(
            name="VRPaymentBasicPaymentStatusResponse",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created_at",
                    models.DateTimeField(auto_now_add=True, verbose_name="Created at"),
                ),
                (
                    "last_modified",
                    models.DateTimeField(auto_now=True, verbose_name="Last modified"),
                ),
                (
                    "http_status_code",
                    models.IntegerField(
                        help_text="response status code",
                        verbose_name="HTTP status code",
                    ),
                ),
                ("url", models.URLField(help_text="request url", verbose_name="URL")),
                (
                    "raw_headers",
                    django.contrib.postgres.fields.jsonb.JSONField(
                        help_text="response header as json", verbose_name="Headers"
                    ),
                ),
                (
                    "raw_content",
                    django.contrib.postgres.fields.jsonb.JSONField(
                        help_text="response content as json", verbose_name="Content"
                    ),
                ),
                (
                    "build_number",
                    models.CharField(
                        blank=True,
                        help_text="Useful for support purposes.",
                        max_length=255,
                        null=True,
                        verbose_name="API response build number",
                    ),
                ),
                (
                    "ndc",
                    models.CharField(
                        blank=True,
                        help_text="An internal unique identifier for the request.",
                        max_length=65,
                        null=True,
                        verbose_name="ndc",
                    ),
                ),
                (
                    "result_code",
                    models.CharField(
                        blank=True,
                        help_text="Status Code from VR Payment. see content for description",
                        max_length=11,
                        null=True,
                        verbose_name="VR Payment status code",
                    ),
                ),
                (
                    "result_description",
                    models.CharField(
                        blank=True,
                        help_text="A textual description explaining the result.code's meaning.",
                        max_length=255,
                        null=True,
                        verbose_name="Result Description",
                    ),
                ),
                (
                    "result_avs_response",
                    models.CharField(
                        blank=True,
                        help_text="Contains the AVS response returned by the acquirer. It may include one the following result:A = Address does match, zip code does not matchZ = Address does not match, zip code does matchN = Address and zip code do not matchU = Technical or logical error. AVS cannot be applied on card or address (not UK or US issuer), issuer is not available, etc.F = Address and Postal Code Matches",
                        max_length=1,
                        null=True,
                        verbose_name="Result avs response",
                    ),
                ),
                (
                    "result_cvv_response",
                    models.CharField(
                        blank=True,
                        help_text="Contains the CVV response returned by the acquirer.",
                        max_length=1,
                        null=True,
                        verbose_name="Result cvv response",
                    ),
                ),
                (
                    "result_details",
                    django.contrib.postgres.fields.jsonb.JSONField(
                        blank=True,
                        help_text="A container for name value pair used for enriching the response with bank-specific response details. I.e. the actual parameters used within resultDetails are bank-specific.",
                        null=True,
                        verbose_name="Result details",
                    ),
                ),
                (
                    "result_details_acquirer_response",
                    django.contrib.postgres.fields.jsonb.JSONField(
                        blank=True,
                        help_text="Represents the acquirer original response code retrieved from the acquirer directly.",
                        null=True,
                        verbose_name="Result details - Acquirer response",
                    ),
                ),
                (
                    "card_bin",
                    models.CharField(
                        blank=True,
                        help_text="The first six digits of the card.number",
                        max_length=6,
                        null=True,
                        verbose_name="Card bin",
                    ),
                ),
                (
                    "card_holder",
                    models.CharField(
                        blank=True,
                        help_text="Holder of the credit card account",
                        max_length=6,
                        null=True,
                        verbose_name="Card holder",
                    ),
                ),
                (
                    "card_expiry_month",
                    models.CharField(
                        blank=True,
                        help_text="The expiry month of the card",
                        max_length=2,
                        null=True,
                        verbose_name="Card expiry month",
                    ),
                ),
                (
                    "card_expiry_year",
                    models.CharField(
                        blank=True,
                        help_text="The expiry year of the card",
                        max_length=4,
                        null=True,
                        verbose_name="Card expiry year",
                    ),
                ),
                (
                    "merchant_bank_account_holder",
                    models.CharField(
                        blank=True,
                        help_text="Holder of the merchant's bank account",
                        max_length=128,
                        null=True,
                        verbose_name="Merchant bank account holder",
                    ),
                ),
                (
                    "merchant_bank_account_nummber",
                    models.CharField(
                        blank=True,
                        help_text="The account number of the merchant's bank account. (IBAN for SEPA accounts)",
                        max_length=64,
                        null=True,
                        verbose_name="Merchant bank account nummber",
                    ),
                ),
                (
                    "merchant_bank_account_bic",
                    models.CharField(
                        blank=True,
                        help_text="The BIC (Bank Identifier Code (SWIFT)) number of the merchant's bank account.",
                        max_length=11,
                        null=True,
                        verbose_name="Merchant bank account bic",
                    ),
                ),
                (
                    "merchant_bank_account_country",
                    models.CharField(
                        blank=True,
                        help_text="The country code of the merchant's bank account (ISO 3166-1).",
                        max_length=2,
                        null=True,
                        verbose_name="Merchant bank account country",
                    ),
                ),
                (
                    "vr_pay_id",
                    models.CharField(
                        blank=True,
                        help_text="The VR Pay identifier of this object",
                        max_length=48,
                        null=True,
                        verbose_name="ID",
                    ),
                ),
                (
                    "reference_id",
                    models.CharField(
                        blank=True,
                        help_text="In case of referenced payment (e.g., Capture or Refund), this fields included to see which payment was referenced.",
                        max_length=32,
                        null=True,
                        validators=[
                            django.core.validators.RegexValidator(
                                regex="[a-zA-Z0-9]{32}"
                            )
                        ],
                        verbose_name="ReferenceID",
                    ),
                ),
                (
                    "payment_brand",
                    models.CharField(
                        blank=True,
                        help_text="The payment brand of the request.",
                        max_length=32,
                        null=True,
                        validators=[
                            django.core.validators.RegexValidator(
                                regex="[a-zA-Z0-9_] {1,32}"
                            )
                        ],
                        verbose_name="Payment brand",
                    ),
                ),
                (
                    "amount",
                    VRPaymentDecimalField(
                        blank=True,
                        decimal_places=2,
                        help_text="The amount of the request",
                        max_digits=12,
                        null=True,
                        verbose_name="Amount",
                    ),
                ),
                (
                    "currency",
                    models.CharField(
                        default="EUR",
                        help_text="The ISO 4217 currency code of the payment request's amount",
                        max_length=3,
                        null=True,
                        verbose_name="Currency",
                    ),
                ),
                (
                    "descriptor",
                    models.CharField(
                        blank=True,
                        help_text="The descriptor of the request.",
                        max_length=127,
                        null=True,
                        verbose_name="Descriptor",
                    ),
                ),
                (
                    "risk_score",
                    models.IntegerField(
                        blank=True,
                        help_text="Returns the score of the executed transaction risk checks. The value is a number from -99999 to +99999. Can be returned both for standalone risk requests and payment requests that include risk checks.",
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(-99999),
                            django.core.validators.MaxValueValidator(99999),
                        ],
                        verbose_name="Risk score",
                    ),
                ),
                (
                    "other",
                    django.contrib.postgres.fields.jsonb.JSONField(
                        blank=True,
                        help_text="The response can also contain each of the data structures listed above, such as 'customer' and 'billingAddress'.",
                        null=True,
                        verbose_name="Other",
                    ),
                ),
                (
                    "basic_payment",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="payment_responses",
                        to="django_vr_payment.VRPaymentBasicPayment",
                        verbose_name="VR Payment Basic Checkouts",
                    ),
                ),
            ],
            options={
                "verbose_name": "VR Payment Payment Response",
                "verbose_name_plural": "VR Payment Payment Responses",
            },
        ),
        migrations.AddIndex(
            model_name="vrpaymentbasicpayment",
            index=models.Index(
                fields=["merchant_transaction_id"],
                name="vr_payment__merchan_9521ba_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="vrpaymentbasicpayment",
            index=models.Index(
                fields=["merchant_invoice_id"], name="vr_payment__merchan_44f0b9_idx"
            ),
        ),
    ]
