# -*- coding: UTF-8 -*-
from . import api_base
try:
    from StringIO import StringIO
except:
    from io import StringIO
import pandas as pd
import sys
from datetime import datetime
from .api_base import get_cache_key, get_data_from_cache, put_data_in_cache, pretty_traceback
import inspect
try:
    unicode
except:
    unicode = str

__doc__="华通人"
def MacroDataDjsjdACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    华通人地级市季度数据。历史数据从1998年开始。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getMacroDataDjsjdACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MacroDataDjsndACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    华通人地级市年度数据。历史数据从1949年开始。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getMacroDataDjsndACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MacroDataDjsydACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    华通人地级市月度数据。历史数据从1987年开始。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getMacroDataDjsydACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MacroDataFsjdACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    华通人分省季度数据。历史数据从1986年开始。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getMacroDataFsjdACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MacroDataFsndACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    华通人分省年度数据。历史数据从1947年开始。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getMacroDataFsndACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MacroDataFsydACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    华通人分省月度数据。历史数据从1986年开始。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getMacroDataFsydACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MacroDataHgjdACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    华通人全国宏观季度数据。历史数据从1978年开始。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getMacroDataHgjdACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MacroDataHgndACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    华通人全国宏观年度数据。历史数据从1949年开始。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getMacroDataHgndACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MacroDataHgydACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    华通人全国宏观月度数据。历史数据从1978年开始。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getMacroDataHgydACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MacroInfoACMRGet(dbCode = "", indicID = "", indicName = "", field = "", pandas = "1"):
    """
    华通人库的宏观指标基本信息，划分为宏观月度数据hgyd、宏观季度数据hgjd、宏观年度数据hgnd、分省月度数据fsyd、分省季度数据fsjd、分省年度数据fsnd、地级市月度数据djsyd、地级市季度数据djsjd、地级市年度数据djsnd9个库。输入数据库代码、指标代码或指标名称，可获取指标名称、指标频度、单位、是否目录、层级、注释等。
    
    :param dbCode: 数据库代码，包含宏观月度(hgyd)、宏观季度(hgjd)、宏观年度(hgnd)、分省月度(fsyd)、分省季度(fsjd)、分省年度(fsnd)、地级市月度(djsyd)、地级市季度(djsjd)、地级市年度(djsnd)9类。,可空
    :param indicID: 指标代码，可多值输入。,可以是列表,可空
    :param indicName: 指标名称，可模糊查询。,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getMacroInfoACMR.csv?ispandas=1&') 
    if not isinstance(dbCode, str) and not isinstance(dbCode, unicode):
        dbCode = str(dbCode)

    requestString.append("dbCode=%s"%(dbCode))
    requestString.append("&indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1496)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1496)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'dbCode', u'indicID', u'indicName', u'frequency', u'unit', u'isList', u'level', u'memo']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'dbCode': 'str','indicID': 'str','indicName': 'str','frequency': 'str','unit': 'str','isList': 'str','memo': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgjdGDPACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国季度国内生产总值数据。指标代码为'A0101'开头的7位编码。历史数据从1992年开始，按季更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgjdGDPACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 253)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 253)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgjdGDPIndexACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国季度国内生产总值指数及环比数据。指标代码为'A0102' 或 'A0103'开头的7位编码。历史数据从1992年开始，按季更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgjdGDPIndexACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 254)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 254)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgjdAFAHFOutputValueACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国季度农林牧渔业总产值数据。指标代码为'A0201'开头的7位编码。历史数据从2001年开始，按季更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgjdAFAHFOutputValueACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 255)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 255)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgjdSalesInvofPetrolGasACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国季度成品糖产销及库存数据。指标代码为'A03010603'开头的11位编码。历史数据从1998年开始，按季更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgjdSalesInvofPetrolGasACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 258)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 258)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgjdSalesInvofCigarettesACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国季度卷烟产销及库存数据。指标代码为'A03010801'开头的11位编码。历史数据从1998年开始，按季更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgjdSalesInvofCigarettesACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 259)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 259)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgjdSalesInvofGasolineACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国季度汽油产销及库存数据。指标代码为'A03010D01'开头的11位编码。历史数据从1998年开始，按季更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgjdSalesInvofGasolineACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 260)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 260)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgjdSalesInvofKeroseneACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国季度煤油产销及库存数据。指标代码为'A03010D02'开头的11位编码。历史数据从1998年开始，按季更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgjdSalesInvofKeroseneACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 261)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 261)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgjdSalesInvofDieselOilACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国季度柴油产销及库存数据。指标代码为'A03010D03'开头的11位编码。历史数据从1998年开始，按季更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgjdSalesInvofDieselOilACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 262)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 262)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgjdSalesInvofNonFerrousMetalsACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国季度十种有色金属产销及库存数据。指标代码为'A03010K01'开头的11位编码。历史数据从1998年开始，按季更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgjdSalesInvofNonFerrousMetalsACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 263)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 263)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgjdSalesInvofMotorVehiclesACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国季度汽车产销及库存数据。指标代码为'A03010N01'开头的11位编码。历史数据从1998年开始，按季更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgjdSalesInvofMotorVehiclesACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 264)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 264)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgjdSalesInvofPassengerCarsACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国季度轿车产销及库存数据。指标代码为'A03010N04'开头的11位编码。历史数据从1998年开始，按季更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgjdSalesInvofPassengerCarsACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 265)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 265)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgjdSalesInvofMotorcyclesACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国季度摩托车产销及库存数据。指标代码为'A03010N09'开头的11位编码。历史数据从1998年开始，按季更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgjdSalesInvofMotorcyclesACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 266)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 266)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgjdSalesInvofWashingMachinesACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国季度家用洗衣机产销及库存数据。指标代码为'A03010O02'开头的11位编码。历史数据从1998年开始，按季更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgjdSalesInvofWashingMachinesACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 267)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 267)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgjdSalesInvofRefrigeratorsACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国季度家用电冰箱产销及库存数据。指标代码为'A03010O04'开头的11位编码。历史数据从1998年开始，按季更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgjdSalesInvofRefrigeratorsACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 268)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 268)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgjdSalesInvofAirConditionersACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国季度房间空气调节器产销及库存数据。指标代码为'A03010O07'开头的11位编码。历史数据从1998年开始，按季更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgjdSalesInvofAirConditionersACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 269)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 269)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgjdSalesInvofColorTVACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国季度彩色电视机产销及库存数据。指标代码为'A03010P0C'开头的11位编码。历史数据从1998年开始，按季更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgjdSalesInvofColorTVACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 270)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 270)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgjdSalesInvofCamerasACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国季度照相机产销及库存数据。指标代码为'A03010Q02'开头的11位编码。历史数据从1998年开始，按季更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgjdSalesInvofCamerasACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 271)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 271)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgjdConstructionOutputACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国季度建筑业总产值数据。指标代码为'A0401'开头的7位编码。历史数据从2003年开始，按季更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgjdConstructionOutputACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 272)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 272)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgjdConstructionRevenueACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国季度建筑业企业总收入数据。指标代码为'A0407'开头的7位编码。历史数据从2003年开始，按季更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgjdConstructionRevenueACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 273)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 273)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgjdConstructionProfitACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国季度建筑业企业利润数据。指标代码为'A0408'开头的7位编码。历史数据从2003年开始，按季更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgjdConstructionProfitACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 274)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 274)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgjdConstructionExpenditureACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国季度建筑业企业费用情况数据。指标代码为'A0409'开头的7位编码。历史数据从2003年开始，按季更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgjdConstructionExpenditureACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 275)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 275)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgjdConstructionBalanceACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国季度建筑业企业资产负债情况数据。指标代码为'A040A'开头的7位编码。历史数据从2012年开始，按季更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgjdConstructionBalanceACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 276)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 276)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgjdUrbanLivingConditionACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国季度城镇居民生活(2005年始)数据。指标代码为'A0501'开头的9位编码。历史数据从2005年开始，按季更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgjdUrbanLivingConditionACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 277)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 277)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgjdRuralCashIncomePerCapitaACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国季度农村居民家庭平均每人现金收入数据。指标代码为'A050201'开头的9位编码。历史数据从2001年开始，按季更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgjdRuralCashIncomePerCapitaACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 278)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 278)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgjdRuralCashExpPerCapitaACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国季度农村居民家庭平均每人现金支出数据。指标代码为'A050202'开头的9位编码。历史数据从2001年开始，按季更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgjdRuralCashExpPerCapitaACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 279)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 279)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgjdUrbanUnitsEmploymentNumACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国季度城镇单位从业人员数据。指标代码为'A0601'开头的7位编码。历史数据从1998年开始，按季更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgjdUrbanUnitsEmploymentNumACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 280)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 280)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgjdUrbanUnitsTotalWagesACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国季度城镇单位从业人员工资总额数据。指标代码为'A0602'开头的7位编码。历史数据从1998年开始，按季更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgjdUrbanUnitsTotalWagesACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 281)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 281)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgjdUrbanUnitsAvgWageACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国季度城镇单位从业人员平均工资数据。指标代码为'A0603'开头的7位编码。历史数据从2000年开始，按季更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgjdUrbanUnitsAvgWageACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 282)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 282)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgjdUrbanUnemploymentACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国季度城镇失业情况数据。指标代码为'A060B'开头的7位编码。历史数据从1978年开始，按季更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgjdUrbanUnemploymentACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 283)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 283)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgjdLandTransactionsPIACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国季度土地交易价格指数数据。指标代码为'A070101'开头的9位编码。历史数据从1998年开始，按季更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgjdLandTransactionsPIACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 284)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 284)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgjdAgriculturalProductsPIACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国季度农产品生产价格指数数据。指标代码为'A0702'开头的7位编码。历史数据从2003年开始，按季更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgjdAgriculturalProductsPIACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 285)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 285)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgjdFAIPIACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国季度固定资产投资价格指数数据。指标代码为'A0703'开头的7位编码。历史数据从1998年开始，按季更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgjdFAIPIACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 286)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 286)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgydCPIByCategoryACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国月度居民消费价格分类指数数据。指标代码为'A01010101'或'A01020101'或'A01030101'开头的11位编码。历史数据从1987年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgydCPIByCategoryACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 287)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 287)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgydCPIUrbanByCategoryACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国月度城市居民消费价格分类指数数据。指标代码为'A01010201'或'A01020201'或'A01030201'开头的11位编码。历史数据从1987年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgydCPIUrbanByCategoryACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 288)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 288)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgydCPIRuralByCategoryACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国月度农村居民消费价格分类指数数据。指标代码为'A01010301'或'A01020301'或'A01030301'开头的11位编码。历史数据从1987年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgydCPIRuralByCategoryACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 289)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 289)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgydRPIByCategoryACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国月度商品零售价格指数数据。指标代码为'A010401'或'A010501'或'A010601'开头的9位编码。历史数据从1986年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgydRPIByCategoryACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 290)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 290)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgydPPIACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国月度工业生产者出厂价格指数数据。指标代码为'A010801'或'A010802'或'A010803'开头的9位编码。历史数据从1996年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgydPPIACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 291)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 291)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgydRealEstatePIACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国月度房地产价格指数数据。指标代码为'A010B'开头的9位编码。历史数据从2006年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgydRealEstatePIACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 292)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 292)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgydIndustryOutputCPACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国月度工业总产值(现行价格)数据。指标代码为'A0201'开头的7位编码。历史数据从1990年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgydIndustryOutputCPACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 293)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 293)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgydIndustryVAACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国月度工业增加值数据。指标代码为'A0203'开头的7位编码。历史数据从1998年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgydIndustryVAACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 294)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 294)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgydIndustryMajorIndicACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国月度工业企业主要经济指标数据。指标代码为'A020A'开头的7位编码。历史数据从1999年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgydIndustryMajorIndicACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 295)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 295)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgydEnergyElectricityProductionACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国月度发电量数据。指标代码为'A0301'开头的7位编码。历史数据从1989年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgydEnergyElectricityProductionACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 296)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 296)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgydEnergyConsumptionElectricityACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国月度全社会用电量数据。指标代码为'A0304'开头的7位编码。历史数据从2005年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgydEnergyConsumptionElectricityACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 297)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 297)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgydEnergyOutputCrudeOilACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国月度天然原油数据。指标代码为'A030B01'开头的9位编码。历史数据从1989年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgydEnergyOutputCrudeOilACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 298)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 298)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgydEnergyOutputNaturalGasACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国月度天然气数据。指标代码为'A030B02'开头的9位编码。历史数据从1989年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgydEnergyOutputNaturalGasACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 299)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 299)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgydFAIACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国月度固定资产投资及环比数据。指标代码为'A0401'或'A0402'开头的7位编码。历史数据从1994年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgydFAIACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 300)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 300)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgydFAIDevelopmentFundsACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国月度固定资产投资资金来源情况数据。指标代码为'A0404'开头的7位编码。历史数据从1998年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgydFAIDevelopmentFundsACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 301)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 301)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgydFAIPrivateACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国月度民间固定资产投资数据。指标代码为'A040C'开头的7位编码。历史数据从2012年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgydFAIPrivateACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 302)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 302)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgydREIACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国月度房地产开发投资情况数据。指标代码为'A0501'开头的7位编码。历史数据从1994年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgydREIACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 303)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 303)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgydREIDevelopmentFundsACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国月度房地产开发投资资金来源数据。指标代码为'A0502'开头的7位编码。历史数据从1998年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgydREIDevelopmentFundsACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 304)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 304)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgydRELandDevelopmentSalesACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国月度房地产土地开发与销售情况数据。指标代码为'A0503'开头的7位编码。历史数据从1998年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgydRELandDevelopmentSalesACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 305)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 305)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgydCommercialBldgSoldSpaceACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国月度商品房销售面积数据。指标代码为'A0508'开头的7位编码。历史数据从1998年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgydCommercialBldgSoldSpaceACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 306)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 306)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgydCommercialBldgSoldAmountACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国月度商品房销售额数据。指标代码为'A0509'开头的7位编码。历史数据从1998年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgydCommercialBldgSoldAmountACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 307)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 307)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgydConsumerGoodsRetailSalesACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国月度社会消费品零售总额数据。指标代码为'A0601'或'A0602'开头的7位编码。历史数据从1984年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgydConsumerGoodsRetailSalesACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 308)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 308)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgydImExpTotalACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国月度进出口总额数据。指标代码为'A0701'开头的7位编码。历史数据从1994年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgydImExpTotalACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 309)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 309)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgydForeignInvestmentACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国月度实际利用外资额数据。指标代码为'A070D'开头的7位编码。历史数据从1999年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgydForeignInvestmentACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 310)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 310)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgydFreightTrafficACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国月度货物运输量数据。指标代码为'A0801'开头的7位编码。历史数据从1983年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgydFreightTrafficACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 311)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 311)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgydFreightTurnoverACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国月度货物周转量数据。指标代码为'A0802'开头的7位编码。历史数据从1986年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgydFreightTurnoverACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 312)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 312)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgydPassengerTrafficACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国月度旅客运输量数据。指标代码为'A0803'开头的7位编码。历史数据从1983年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgydPassengerTrafficACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 313)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 313)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgydPassengerTurnoverACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国月度旅客周转量数据。指标代码为'A0804'开头的7位编码。历史数据从1986年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgydPassengerTurnoverACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 314)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 314)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgydFreightHandledMajorPortsACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国月度主要港口吞吐量数据。指标代码为'A0805'开头的7位编码。历史数据从2001年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgydFreightHandledMajorPortsACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 315)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 315)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgydTransportInvestmentACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国月度交通业固定资产投资数据。指标代码为'A0806'开头的7位编码。历史数据从2003年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgydTransportInvestmentACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 316)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 316)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgydCivilAviationTurnoverTotalACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国月度民航运输总周转量数据。指标代码为'A080701'开头的11位编码。历史数据从1998年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgydCivilAviationTurnoverTotalACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 317)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 317)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgydCivilAviationTurnoverPassengerACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国月度民航旅客周转量数据。指标代码为'A080702'开头的11位编码。历史数据从1986年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgydCivilAviationTurnoverPassengerACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 318)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 318)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgydCivilAviationPassengerTrafficACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国月度民航旅客运输量数据。指标代码为'A080703'开头的11位编码。历史数据从1986年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgydCivilAviationPassengerTrafficACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 319)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 319)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgydRailwaysTrafficPassengerACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国月度铁路运输旅客发送量数据。指标代码为'A080801'开头的9位编码。历史数据从2006年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgydRailwaysTrafficPassengerACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 320)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 320)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgydRailwaysTurnoverPassengerACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国月度铁路运输旅客周转量数据。指标代码为'A080802'开头的9位编码。历史数据从2006年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgydRailwaysTurnoverPassengerACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 321)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 321)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgydRailwaysTrafficFreightACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国月度铁路运输货运总发送量数据。指标代码为'A080804'开头的9位编码。历史数据从2006年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgydRailwaysTrafficFreightACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 322)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 322)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgydRailwaysTurnoverFreightACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国月度铁路运输货运总周转量数据。指标代码为'A080807'开头的9位编码。历史数据从2006年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgydRailwaysTurnoverFreightACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 323)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 323)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgydGovRevenueACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国月度国家财政预算收入完成情况(2007-)数据。指标代码为'A0A01'开头的7位编码。历史数据从1998年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgydGovRevenueACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 324)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 324)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgydGovExpenditureACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国月度国家财政预算支出完成情况(2007-)数据。指标代码为'A0A04'开头的7位编码。历史数据从1998年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgydGovExpenditureACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 325)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 325)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgydMoneySupplyACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国月度货币供应量数据。指标代码为'A0B01'开头的7位编码。历史数据从1978年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgydMoneySupplyACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 326)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 326)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgydAllSystemFinancingACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国月度社会融资规模数据。指标代码为'A0B0C'开头的7位编码。历史数据从2002年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgydAllSystemFinancingACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 327)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 327)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgydExchangeRateACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国月度汇率数据。指标代码为'A0B0G'开头的7位编码。历史数据从1996年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgydExchangeRateACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 328)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 328)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgydInsuranceOperationACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国月度保险业经营情况数据。指标代码为'A0D01'开头的7位编码。历史数据从1999年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgydInsuranceOperationACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 329)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 329)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgydPropertyInsurancePremiumACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国月度财产保险公司原保险保费收入数据。指标代码为'A0D02'开头的7位编码。历史数据从1999年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgydPropertyInsurancePremiumACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 330)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 330)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgydLifeInsurancePremiumACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国月度人寿保险公司原保险保费收入数据。指标代码为'A0D05'开头的7位编码。历史数据从1999年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgydLifeInsurancePremiumACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 331)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 331)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgydPMIACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国月度制造业采购经理指数数据。指标代码为'A0F01'或'A0F02'开头的7位编码。历史数据从2005年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgydPMIACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 332)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 332)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgydCCIACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国月度消费者景气指数数据。指标代码为'A0F03'开头的7位编码。历史数据从1998年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgydCCIACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 333)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 333)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgydECIACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国月度宏观经济景气指数数据。指标代码为'A0F04'开头的7位编码。历史数据从1991年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgydECIACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 334)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 334)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgndGDPACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国年度国内生产总值数据。指标代码为'A0201'开头的7位编码。历史数据从1952年开始，按年更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgndGDPACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 335)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 335)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgndGDPConstantPriceACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国年度不变价国内生产总值数据。指标代码为'A020204'或'A020205'或'A020301'或'A020302'开头的9位编码。历史数据从1953年开始，按年更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgndGDPConstantPriceACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 336)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 336)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgndThirdIndustryVAACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国年度第三产业增加值数据。指标代码为'A020504'或'A020505'或'A020601'或'A020602'开头的9位编码。历史数据从1953年开始，按年更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgndThirdIndustryVAACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 337)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 337)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgndTotalFAIACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国年度全社会固定资产投资数据。指标代码为'A0501'开头的7位编码。历史数据从1980年开始，按年更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgndTotalFAIACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 344)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 344)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgndConstructionScaleACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国年度建设规模数据。指标代码为'A051O01'开头的9位编码。历史数据从2008年开始，按年更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgndConstructionScaleACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 345)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 345)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgndGoodsTradeFIEntACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国年度外商投资企业货物进出口总额数据。指标代码为'A070B'开头的7位编码。历史数据从2000年开始，按年更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgndGoodsTradeFIEntACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 346)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 346)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgndFIUseContractACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国年度合同利用外资数据。指标代码为'A070C'开头的7位编码。历史数据从1983年开始，按年更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgndFIUseContractACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 347)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 347)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgndFIActuallyUtilizedACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国年度实际利用外资数据。指标代码为'A070D'开头的7位编码。历史数据从1983年开始，按年更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgndFIActuallyUtilizedACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 348)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 348)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgndFDIActuallyUtilizedACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国年度实际利用外商直接投资数据。指标代码为'A070E01'开头的11位编码。历史数据从1997年开始，按年更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgndFDIActuallyUtilizedACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 349)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 349)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgndFIProjectByRegimeACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国年度按方式分外商投资额项目数据。指标代码为'A070F01'开头的9位编码。历史数据从1983年开始，按年更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgndFIProjectByRegimeACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 350)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 350)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgndFIAmountByIndustryACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国年度按行业分外商直接投资额合同项目数据。指标代码为'A070G01'开头的9位编码。历史数据从1983年开始，按年更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgndFIAmountByIndustryACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 351)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 351)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgndInvestmentNumACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国年度投资总额数据。指标代码为'A070H02'开头的9位编码。历史数据从1992年开始，按年更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgndInvestmentNumACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 352)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 352)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgndFinanceACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国年度国家财政主要收支数据。指标代码为'A090401'或'A090402'或'A090403' 或'A090501'或'A090502'或'A090503'开头的9位编码。历史数据从1950年开始，按年更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgndFinanceACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 353)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 353)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgndTaxACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国年度各项税收数据。指标代码为'A0906'开头的7位编码。历史数据从1950年开始，按年更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgndTaxACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 354)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 354)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgndCPIACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国年度居民消费价格分类指数(上年=100)数据。指标代码为'A0A03'开头的9位编码。历史数据从1984年开始，按年更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgndCPIACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 355)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 355)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgndRPIACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国年度商品零售价格分类指数(上年=100)数据。指标代码为'A0A06'开头的7位编码。历史数据从1951年开始，按年更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgndRPIACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 356)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 356)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgndAgriculturalMeansPIACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国年度农业生产资料价格分类指数(上年=100)数据。指标代码为'A0A09'开头的7位编码。历史数据从1978年开始，按年更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgndAgriculturalMeansPIACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 357)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 357)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgndAgriculturalProductsPIACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国年度农产品生产价格指数(上年=100)数据。指标代码为'A0A0A'开头的7位编码。历史数据从1978年开始，按年更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgndAgriculturalProductsPIACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 358)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 358)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgndPPIByDepartmentsACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国年度按工业部门分工业生产者出厂价格指数(上年=100)数据。指标代码为'A0A0B'开头的7位编码。历史数据从1978年开始，按年更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgndPPIByDepartmentsACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 359)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 359)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgndPPIBySectorACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国年度按工业行业分工业生产者出厂价格指数(上年=100数据。指标代码为'A0A0C'开头的7位编码。历史数据从1978年开始，按年更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgndPPIBySectorACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 360)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 360)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgndPPIACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国年度工业生产者出厂价格分类指数(上年=100)数据。指标代码为'A0A0D'开头的7位编码。历史数据从1978年开始，按年更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgndPPIACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 361)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 361)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgndPPIRMACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国年度工业生产者购进价格指数(上年=100)数据。指标代码为'A0A0E'开头的7位编码。历史数据从1989年开始，按年更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgndPPIRMACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 362)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 362)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgndFAIPIACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国年度固定资产投资价格指数(上年=100)数据。指标代码为'A0A0F'开头的7位编码。历史数据从1990年开始，按年更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgndFAIPIACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 363)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 363)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgndHousingSalesPIACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国年度房屋销售价格指数(上年=100)数据。指标代码为'A0A0G01'开头的9位编码。历史数据从1998年开始，按年更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgndHousingSalesPIACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 364)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 364)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgndLandTransactionsPIACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国年度土地交易价格指数(上年=100)数据。指标代码为'A0A0G02'开头的9位编码。历史数据从1998年开始，按年更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgndLandTransactionsPIACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 365)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 365)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgndHousingLeasePIACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国年度房屋租赁价格指数(上年=100)数据。指标代码为'A0A0G03'开头的9位编码。历史数据从1998年开始，按年更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgndHousingLeasePIACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 366)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 366)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgndNewHousingACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国年度新建房屋数据。指标代码为'A0B0V01'开头的9位编码。历史数据从1981年开始，按年更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgndNewHousingACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 367)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 367)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgndHousingSituationACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国年度住房情况数据。指标代码为'A0B0V02'开头的9位编码。历史数据从1978年开始，按年更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgndHousingSituationACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 368)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 368)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgndAboveSizeEntNumACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国年度规模以上工业企业主要经济指标企业单位数数据。指标代码为'A0F0101'开头的9位编码。历史数据从1957年开始，按年更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgndAboveSizeEntNumACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 369)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 369)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgndAboveSizeIndustrialOutputACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国年度规模以上工业企业主要经济指标工业总产值(当年价格)数据。指标代码为'A0F0102'开头的9位编码。历史数据从1949年开始，按年更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgndAboveSizeIndustrialOutputACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 370)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 370)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgndAboveSizeTotalAssetsACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国年度规模以上工业企业主要经济指标资产总计数据。指标代码为'A0F0103'开头的9位编码。历史数据从1978年开始，按年更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgndAboveSizeTotalAssetsACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 371)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 371)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgndAboveSizePrincipalBusinessACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国年度规模以上工业企业主要经济指标主营业务收入数据。指标代码为'A0F0104'开头的9位编码。历史数据从1979年开始，按年更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgndAboveSizePrincipalBusinessACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 372)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 372)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgndAboveSizeTotalProfitsACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国年度规模以上工业企业主要经济指标利润总额数据。指标代码为'A0F0105'开头的9位编码。历史数据从1978年开始，按年更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgndAboveSizeTotalProfitsACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 373)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 373)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgndIndustrialProductsOutputACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国年度工业产品产量数据。指标代码为'A0F0C'开头的7位编码。历史数据从1949年开始，按年更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgndIndustrialProductsOutputACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 374)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 374)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgndConstructionEntSurveyACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国年度建筑业企业概况数据。指标代码为'A0G01'开头的7位编码。历史数据从1980年开始，按年更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgndConstructionEntSurveyACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 375)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 375)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgndPassengerTrafficACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国年度客运量数据。指标代码为'A0H04'开头的7位编码。历史数据从1949年开始，按年更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgndPassengerTrafficACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 376)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 376)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgndPassengerTurnoverACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国年度旅客周转量数据。指标代码为'A0H05'开头的7位编码。历史数据从1949年开始，按年更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgndPassengerTurnoverACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 377)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 377)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgndFreightVolumeACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国年度货运量数据。指标代码为'A0H06'开头的7位编码。历史数据从1949年开始，按年更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgndFreightVolumeACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 378)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 378)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgndCargoTurnoverACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国年度货物周转量数据。指标代码为'A0H07'开头的7位编码。历史数据从1949年开始，按年更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgndCargoTurnoverACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 379)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 379)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgndConsumerGoodsRetailSalesACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国年度社会消费品零售总额数据。指标代码为'A0J0B'开头的7位编码。历史数据从1952年开始，按年更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgndConsumerGoodsRetailSalesACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 380)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 380)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgndFinancialInstitutionsSourcesACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国年度金融机构人民币信贷资金平衡表(资金来源)数据。指标代码为'A0M01'开头的7位编码。历史数据从1952年开始，按年更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgndFinancialInstitutionsSourcesACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 381)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 381)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgndFinancialInstitutionsUsesACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国年度金融机构人民币信贷资金平衡表(资金运用)数据。指标代码为'A0M02'开头的7位编码。历史数据从1952年开始，按年更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgndFinancialInstitutionsUsesACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 382)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 382)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgndMoneySupplyACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国年度货币供应量数据。指标代码为'A0M03'开头的7位编码。历史数据从1952年开始，按年更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgndMoneySupplyACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 383)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 383)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgndReservesofGoldExchangeACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国年度黄金和外汇储备数据。指标代码为'A0M06'开头的7位编码。历史数据从1950年开始，按年更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgndReservesofGoldExchangeACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 384)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 384)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HgndAllSystemFinancingACMRGet(indicID = "", indicName = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含全国年度社会融资规模及构成数据。指标代码为'A0M0H'开头的7位编码。历史数据从2002年开始，按年更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getHgndAllSystemFinancingACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 385)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 385)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def DjsjdResidentIncomeExpACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含地级市季度城镇居民收支数据。指标代码为'A0101'开头的7位编码。历史数据从1998年开始，按季更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getDjsjdResidentIncomeExpACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 386)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 386)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def DjsjdHouseholdsExpenditureACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含地级市季度城镇居民消费支出数据。指标代码为'A0102'开头的7位编码。历史数据从1998年开始，按季更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getDjsjdHouseholdsExpenditureACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 387)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 387)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def DjsjdHousingSalesPIACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含地级市季度房屋销售价格指数数据。指标代码为'A0201'开头的7位编码。历史数据从1998年开始，按季更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getDjsjdHousingSalesPIACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 388)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 388)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def DjsjdLandExchangePIACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含地级市季度土地交易价格指数数据。指标代码为'A0202'开头的7位编码。历史数据从1998年开始，按季更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getDjsjdLandExchangePIACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 389)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 389)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def DjsndAdministrativeDivisionACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含地级市年度行政区划数据。指标代码为'A01'开头的5位编码。历史数据从1949年开始，按年更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getDjsndAdministrativeDivisionACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 390)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 390)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def DjsndGDPACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含地级市年度国民经济核算数据。指标代码为'A02'开头的7位编码。历史数据从1949年开始，按年更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getDjsndGDPACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 391)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 391)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def DjsndPopulationACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含地级市年度人口数据。指标代码为'A03'开头的5位编码。历史数据从1949年开始，按年更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getDjsndPopulationACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 392)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 392)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def DjsndEmployeeACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含地级市年度从业人员数据。指标代码为'A0401'开头的7位编码。历史数据从1949年开始，按年更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getDjsndEmployeeACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 393)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 393)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def DjsndEmployeeBySectorACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含地级市年度分行业单位从业人员数据。指标代码为'A0402'开头的7位编码。历史数据从1997年开始，按年更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getDjsndEmployeeBySectorACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 394)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 394)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def DjsndEmployeeNumAndWageACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含地级市年度职工人数及工资水平数据。指标代码为'A0403'开头的7位编码。历史数据从1949年开始，按年更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getDjsndEmployeeNumAndWageACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 395)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 395)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def DjsndTotalFAIACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含地级市年度全社会固定资产投资数据。指标代码为'A0501'开头的7位编码。历史数据从1949年开始，按年更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getDjsndTotalFAIACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 396)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 396)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def DjsndUrbanFAIACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含地级市年度城镇固定资产投资数据。指标代码为'A0502'开头的7位编码。历史数据从1949年开始，按年更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getDjsndUrbanFAIACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 397)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 397)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def DjsndCommodityBuildingsSalesACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含地级市年度商品房屋销售数据。指标代码为'A0503'开头的7位编码。历史数据从1986年开始，按年更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getDjsndCommodityBuildingsSalesACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 398)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 398)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def DjsndImExpTotalACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含地级市年度进出口总额数据。指标代码为'A0601'开头的7位编码。历史数据从1949年开始，按年更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getDjsndImExpTotalACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 399)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 399)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def DjsndForeignUtilizedACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含地级市年度利用外商数据。指标代码为'A0602'开头的7位编码。历史数据从1950年开始，按年更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getDjsndForeignUtilizedACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 400)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 400)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def DjsndLocalGovBudgetaryRevenueACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含地级市年度地方财政预算内收入数据。指标代码为'A0701'开头的7位编码。历史数据从1949年开始，按年更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getDjsndLocalGovBudgetaryRevenueACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 401)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 401)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def DjsndLocalGovBudgetaryExpenditureACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含地级市年度地方财政预算内支出数据。指标代码为'A0702'开头的7位编码。历史数据从1949年开始，按年更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getDjsndLocalGovBudgetaryExpenditureACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 402)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 402)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def DjsndDomesticConsumptionTaxACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含地级市年度国内消费税数据。指标代码为'A0709'开头的7位编码。历史数据从1994年开始，按年更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getDjsndDomesticConsumptionTaxACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 403)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 403)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def DjsndBudgetaryFundIncomeACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含地级市年度预算内基金收入数据。指标代码为'A070A'开头的7位编码。历史数据从2000年开始，按年更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getDjsndBudgetaryFundIncomeACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 404)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 404)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def DjsndPeopleLifeACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含地级市年度人民生活数据。指标代码为'A08'开头的5位编码。历史数据从1949年开始，按年更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getDjsndPeopleLifeACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 405)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 405)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def DjsndRuralLaborAndOutputACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含地级市年度乡村劳动力及产值数据。指标代码为'A0901'开头的7位编码。历史数据从1949年开始，按年更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getDjsndRuralLaborAndOutputACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 406)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 406)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def DjsndAgriculturalProductionACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含地级市年度农业生产条件数据。指标代码为'A0902'开头的7位编码。历史数据从1949年开始，按年更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getDjsndAgriculturalProductionACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 407)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 407)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def DjsndIndustrialEntNumACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含地级市年度限额以上工业企业单位数数据。指标代码为'A0A01'开头的7位编码。历史数据从1949年开始，按年更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getDjsndIndustrialEntNumACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 408)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 408)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def DjsndIndustrialTotalOutputACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含地级市年度限额以上现价工业总产值数据。指标代码为'A0A02'开头的7位编码。历史数据从1949年开始，按年更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getDjsndIndustrialTotalOutputACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 409)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 409)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def DjsndIndustrialFinanceACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含地级市年度限额以上工业企业财务状况数据。指标代码为'A0A03'开头的7位编码。历史数据从1949年开始，按年更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getDjsndIndustrialFinanceACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 410)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 410)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def DjsndConstructionACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含地级市年度建筑业数据。指标代码为'A0B'开头的5位编码。历史数据从1949年开始，按年更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getDjsndConstructionACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 411)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 411)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def DjsndWholesaleAndRetailACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含地级市年度批发零售贸易业基本情况数据。指标代码为'A0C01'开头的7位编码。历史数据从1978年开始，按年更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getDjsndWholesaleAndRetailACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 412)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 412)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def DjsndConsumerGoodsRetailSalesACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含地级市年度社会消费品零售总额数据。指标代码为'A0C02'开头的7位编码。历史数据从1949年开始，按年更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getDjsndConsumerGoodsRetailSalesACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 413)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 413)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def DjsndHighwayMileageACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含地级市年度公路里程数据。指标代码为'A0D01'开头的7位编码。历史数据从1949年开始，按年更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getDjsndHighwayMileageACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 414)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 414)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def DjsndPassengerTrafficACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含地级市年度旅客运输量数据。指标代码为'A0D02'开头的7位编码。历史数据从1949年开始，按年更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getDjsndPassengerTrafficACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 415)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 415)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def DjsndFreightTrafficACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含地级市年度货物运输量数据。指标代码为'A0D03'开头的7位编码。历史数据从1949年开始，按年更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getDjsndFreightTrafficACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 416)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 416)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def DjsndCivilAutomobileNumACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含地级市年度民用汽车拥有量数据。指标代码为'A0D04'开头的7位编码。历史数据从1949年开始，按年更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getDjsndCivilAutomobileNumACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 417)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 417)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def DjsndTelecomACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含地级市年度邮电通信数据。指标代码为'A0E'开头的5位编码。历史数据从1949年开始，按年更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getDjsndTelecomACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 418)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 418)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def DjsndTourismACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含地级市年度旅游数据。指标代码为'A0F'开头的5位编码。历史数据从1978年开始，按年更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getDjsndTourismACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 419)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 419)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def DjsndBankingACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含地级市年度存贷款数据。指标代码为'A0G'开头的5位编码。历史数据从1949年开始，按年更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getDjsndBankingACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 420)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 420)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def DjsndCityWaterSupplyACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含地级市年度城市供水数据。指标代码为'A0K05'开头的7位编码。历史数据从1949年开始，按年更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getDjsndCityWaterSupplyACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 421)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 421)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def DjsndCityLiquefiedPetrolGasACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含地级市年度城市液化石油气数据。指标代码为'A0K0B'开头的7位编码。历史数据从1972年开始，按年更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getDjsndCityLiquefiedPetrolGasACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 422)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 422)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def DjsndCityLandscapingACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含地级市年度城市园林绿化数据。指标代码为'A0K0I'开头的7位编码。历史数据从1978年开始，按年更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getDjsndCityLandscapingACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 423)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 423)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def Djsyd36CityCPIACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含地级市月度36个城市居民消费价格分类指数数据。指标代码为'A0101'或'A0102'或'A0103'开头的7位编码。历史数据从1987年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getDjsyd36CityCPIACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 424)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 424)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def Djsyd36CityRPIACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含地级市月度36个城市商品零售价格分类指数数据。指标代码为'A0104'或'A0105'开头的7位编码。历史数据从1990年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getDjsyd36CityRPIACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 425)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 425)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def Djsyd70CityHousingSalesPIACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含地级市月度70个大中城市住宅销售价格指数数据。指标代码为'A0106'开头的7位编码。历史数据从2004年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getDjsyd70CityHousingSalesPIACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 426)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 426)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def DjsydUrbanResidentIncomeExpACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含地级市月度城镇居民收支数据。指标代码为'A0201'开头的7位编码。历史数据从1998年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getDjsydUrbanResidentIncomeExpACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 427)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 427)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def DjsydMeteorologicalACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含地级市月度气象数据。指标代码为'A03'开头的5位编码。历史数据从2011年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getDjsydMeteorologicalACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 428)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 428)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FsydCPIACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含分省月度居民消费价格分类指数数据。指标代码为'A010101'或'A010103'或'A010103'开头的9位编码。历史数据从1987年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getFsydCPIACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 429)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 429)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FsydRPIACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含分省月度商品零售价格分类指数数据。指标代码为'A0102'开头的9位编码。历史数据从1986年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getFsydRPIACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 430)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 430)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FsydAgriculturalMeansPIACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含分省月度农业生产资料价格指数数据。指标代码为'A0105'开头的9位编码。历史数据从1987年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getFsydAgriculturalMeansPIACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 431)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 431)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FsydIndustryValueAddedACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含分省月度工业增加值数据。指标代码为'A0201'开头的7位编码。历史数据从1996年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getFsydIndustryValueAddedACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 432)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 432)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FsydProductSalesRateACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含分省月度产品销售率数据。指标代码为'A0202'开头的7位编码。历史数据从1993年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getFsydProductSalesRateACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 433)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 433)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FsydIndustryMajorIndicACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含分省月度工业主要经济指标数据。指标代码为'A0203'开头的7位编码。历史数据从1996年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getFsydIndustryMajorIndicACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 434)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 434)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FsydProdOutputNaturalGasExploitationACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含分省月度石油和天然气开采业产量数据。指标代码为'A020602'开头的11位编码。历史数据从1989年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getFsydProdOutputNaturalGasExploitationACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 435)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 435)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FsydProdOutputTransportEquipManufacturingACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含分省月度交通运输设备制造业产量数据。指标代码为'A02060U'开头的11位编码。历史数据从1989年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getFsydProdOutputTransportEquipManufacturingACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 436)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 436)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FsydProdOutputNaturalCrudeOilACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含分省月度天然原油产量数据。指标代码为'A030101'开头的9位编码。历史数据从1989年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getFsydProdOutputNaturalCrudeOilACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 437)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 437)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FsydProdOutputNaturalGasACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含分省月度天然气产量数据。指标代码为'A030102'开头的9位编码。历史数据从1989年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getFsydProdOutputNaturalGasACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 438)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 438)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FsydFAICompositionACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含分省月度固定资产投资构成情况数据。指标代码为'A0401'开头的7位编码。历史数据从1996年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getFsydFAICompositionACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 439)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 439)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FsydFAIHousingConstructionACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含分省月度固定资产投资住宅建设情况数据。指标代码为'A0402'开头的7位编码。历史数据从1999年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getFsydFAIHousingConstructionACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 440)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 440)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FsydFAIProjectACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含分省月度固定资产投资项目情况数据。指标代码为'A0403'开头的7位编码。历史数据从1998年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getFsydFAIProjectACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 441)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 441)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FsydREDevelopmentACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含分省月度房地产开发投资情况数据。指标代码为'A0501'开头的7位编码。历史数据从1994年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getFsydREDevelopmentACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 442)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 442)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FsydLandDevelopmentGrowthACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含分省月度土地开发与购置增长情况数据。指标代码为'A0502'开头的7位编码。历史数据从1996年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getFsydLandDevelopmentGrowthACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 443)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 443)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FsydREDevelopmentFundsACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含分省月度房地产开发投资资金来源数据。指标代码为'A0503'开头的7位编码。历史数据从1998年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getFsydREDevelopmentFundsACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 444)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 444)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FsydREConstructionCompletionSpaceACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含分省月度房地产施工、竣工面积数据。指标代码为'A0504'开头的7位编码。历史数据从1996年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getFsydREConstructionCompletionSpaceACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 445)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 445)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FsydHousingConstructionCompletionSpaceACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含分省月度商品住宅施工、竣工面积数据。指标代码为'A0505'开头的7位编码。历史数据从1996年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getFsydHousingConstructionCompletionSpaceACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 446)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 446)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FsydCommercialBldgSoldSpaceACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含分省月度商品房销售面积数据。指标代码为'A0508'开头的7位编码。历史数据从1996年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getFsydCommercialBldgSoldSpaceACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 447)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 447)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FsydCommercialBldgSoldAmountACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含分省月度商品房销售额数据。指标代码为'A0509'开头的7位编码。历史数据从1998年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getFsydCommercialBldgSoldAmountACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 448)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 448)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FsydCommercialHousingSalesSpaceACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含分省月度商品住宅销售面积数据。指标代码为'A050A'开头的7位编码。历史数据从1996年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getFsydCommercialHousingSalesSpaceACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 449)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 449)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FsydCommercialHousingSalesACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含分省月度商品住宅销售额数据。指标代码为'A050B'开头的7位编码。历史数据从1999年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getFsydCommercialHousingSalesACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 450)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 450)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FsydConsumerGoodsRetailSalesACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含分省月度社会消费品零售总额数据。指标代码为'A0601'开头的7位编码。历史数据从1994年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getFsydConsumerGoodsRetailSalesACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 451)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 451)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FsydImExpAmountDomesticSourcesACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含分省月度按商品境内目的地货源地进出口总额数据。指标代码为'A0701'开头的7位编码。历史数据从1998年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getFsydImExpAmountDomesticSourcesACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 452)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 452)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FsydImExpAmountByBusinessLocationACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含分省月度按商品经营单位所在地进出口总额数据。指标代码为'A0702'开头的7位编码。历史数据从1998年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getFsydImExpAmountByBusinessLocationACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 453)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 453)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FsydHighwayAndWaterwayFreightTrafficACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含分省月度公里、水路货物运输量数据。指标代码为'A0801'开头的7位编码。历史数据从1986年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getFsydHighwayAndWaterwayFreightTrafficACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 454)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 454)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FsydHighwayAndWaterwayCargoTurnoverACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含分省月度公路、水路货物周转量数据。指标代码为'A0802'开头的7位编码。历史数据从1986年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getFsydHighwayAndWaterwayCargoTurnoverACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 455)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 455)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FsydHighwayAndWaterwayPassengerTrafficACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含分省月度公路、水路旅客运输量数据。指标代码为'A0803'开头的7位编码。历史数据从1986年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getFsydHighwayAndWaterwayPassengerTrafficACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 456)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 456)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FsydHighwayAndWaterwayPassengerTurnoverACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含分省月度公路、水路旅客周转量数据。指标代码为'A0804'开头的7位编码。历史数据从1986年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getFsydHighwayAndWaterwayPassengerTurnoverACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 457)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 457)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FsydLocalGovBudgetRevenueACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含分省月度地方财政预算收入数据。指标代码为'A0901'开头的7位编码。历史数据从1998年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getFsydLocalGovBudgetRevenueACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 458)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 458)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FsydSpotBondTradingACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含分省月度现券买卖数据。指标代码为'A0A01'开头的7位编码。历史数据从2011年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getFsydSpotBondTradingACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 459)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 459)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FsydLendingMeltInOutACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含分省月度同业拆借融入融出数据。指标代码为'A0A02'开头的7位编码。历史数据从2011年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getFsydLendingMeltInOutACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 460)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 460)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FsydPledgedRepoIntoMeltInOutACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含分省月度质押式回购融入融出数据。指标代码为'A0A03'开头的7位编码。历史数据从2011年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getFsydPledgedRepoIntoMeltInOutACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 461)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 461)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FsydOutrightRepoIntoMeltInOutACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含分省月度买断式回购融入融出数据。指标代码为'A0A04'开头的7位编码。历史数据从2011年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getFsydOutrightRepoIntoMeltInOutACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 462)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 462)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FsydSoftwareIndustryRevenueACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含分省月度软件业收入数据。指标代码为'A0C01'开头的7位编码。历史数据从2008年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getFsydSoftwareIndustryRevenueACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 463)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 463)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FsydUrbanResidentIncomeExpACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含分省月度城镇居民收支概况数据。指标代码为'A0E0101'开头的9位编码。历史数据从1998年开始，按月更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getFsydUrbanResidentIncomeExpACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 464)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 464)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FsjdGDPACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含分省季度地区生产总值数据。指标代码为'A0101'开头的7位编码。历史数据从1992年开始，按季更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getFsjdGDPACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 465)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 465)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FsjdConstructionOutputACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含分省季度建筑业总产值数据。指标代码为'A0201'开头的7位编码。历史数据从2003年开始，按季更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getFsjdConstructionOutputACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 466)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 466)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FsjdConstructionSignedContractsACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含分省季度建筑业企业签订合同情况数据。指标代码为'A0202'开头的7位编码。历史数据从2004年开始，按季更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getFsjdConstructionSignedContractsACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 467)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 467)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FsjdConstructionConstructSpaceACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含分省季度建筑业企业房屋建筑施工面积数据。指标代码为'A0203'开头的7位编码。历史数据从2003年开始，按季更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getFsjdConstructionConstructSpaceACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 468)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 468)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FsjdConstructionNumAndLaborACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含分省季度建筑业企业个数、从业人数和劳动生产率数据。指标代码为'A0204'开头的7位编码。历史数据从2003年开始，按季更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getFsjdConstructionNumAndLaborACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 469)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 469)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FsjdConstructionCompletionSpaceACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含分省季度建筑业企业房屋建筑竣工面积数据。指标代码为'A0205'开头的7位编码。历史数据从2004年开始，按季更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getFsjdConstructionCompletionSpaceACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 470)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 470)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FsjdConstructionCompletionValueACMRGet(indicID = "", indicName = "", regionCD = "", region = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含分省季度建筑业企业房屋建筑竣工价值数据。指标代码为'A0206'开头的7位编码。历史数据从2004年开始，按季更新。
    
    :param indicID: 指标代码，可多值输入。,可以是列表,indicID、indicName至少选择一个
    :param indicName: 指标名称，可模糊查询,indicID、indicName至少选择一个
    :param regionCD: 地区代码，国家统计局行政区划编码,可以是列表,可空
    :param region: 地区名称,可空
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getFsjdConstructionCompletionValueACMR.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    if not isinstance(indicName, str) and not isinstance(indicName, unicode):
        indicName = str(indicName)

    requestString.append("&indicName=%s"%(indicName))
    requestString.append("&regionCD=")
    if hasattr(regionCD,'__iter__') and not isinstance(regionCD, str):
        if len(regionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = regionCD
            requestString.append(None)
        else:
            requestString.append(','.join(regionCD))
    else:
        requestString.append(regionCD)
    if not isinstance(region, str) and not isinstance(region, unicode):
        region = str(region)

    requestString.append("&region=%s"%(region))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 471)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 471)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'indicName', u'regionCD', u'region', u'periodDate', u'dataValue', u'unit', u'dataSourceCD', u'dataSource', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indicID': 'str','indicName': 'str','regionCD': 'str','region': 'str','unit': 'str','dataSourceCD': 'str','dataSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise