# -*- coding: UTF-8 -*-
from . import api_base
try:
    from StringIO import StringIO
except:
    from io import StringIO
import pandas as pd
import sys
from datetime import datetime
from .api_base import get_cache_key, get_data_from_cache, put_data_in_cache, pretty_traceback
import inspect
try:
    unicode
except:
    unicode = str

__doc__="通联数据"
def PartyIDGet(partyID = "", partyName = "", field = "", pandas = "1"):
    """
    输入一个或多个机构名称，获取机构ID，机构在数据结构中的一个唯一识别的编码
    
    :param partyID: 通联编制的发行机构代码。,可以是列表,partyID、partyName至少选择一个
    :param partyName: 输入一个机构名称，如"平安银行",partyID、partyName至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/master/getPartyID.csv?ispandas=1&') 
    requestString.append("partyID=")
    if hasattr(partyID,'__iter__') and not isinstance(partyID, str):
        if len(partyID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = partyID
            requestString.append(None)
        else:
            requestString.append(','.join(partyID))
    else:
        requestString.append(partyID)
    if not isinstance(partyName, str) and not isinstance(partyName, unicode):
        partyName = str(partyName)

    requestString.append("&partyName=%s"%(partyName))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1691)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1691)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'partyID', u'partyFullName', u'partyFullNameEn', u'partyShortName', u'partyShortNameEn', u'officeAddr', u'primeOperating', u'partyNatureCD', u'instStatus', u'isIssBond']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'partyFullName': 'str','partyFullNameEn': 'str','partyShortName': 'str','partyShortNameEn': 'str','officeAddr': 'str','primeOperating': 'str','partyNatureCD': 'str','isIssBond': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def SecHaltGet(beginDate = "", secID = "", ticker = "", endDate = "", listStatusCD = "", field = "", pandas = "1"):
    """
    输入证券ID或证券交易代码，获取证券停牌起始时间、截止时间。也可以根据日期范围查询出在这段时间内持续停牌的证券，例如起始日期、结束日期设置为同一天，可以查询出当天停牌的所有证券。
    
    :param beginDate: 查询范围的起始日期，输入格式“YYYYMMDD”。,beginDate、secID、ticker、endDate至少选择一个
    :param secID: 证券内部编码，可通过交易代码和交易市场在DataAPI.SecIDGet获取到。,可以是列表,beginDate、secID、ticker、endDate至少选择一个
    :param ticker: 证券交易代码，如'000001',可以是列表,beginDate、secID、ticker、endDate至少选择一个
    :param endDate: 查询范围的截止日期，输入格式，输入格式“YYYYMMDD”。若无输入值，默认获取从开始日期到现在所有存在过的停牌记录。,beginDate、secID、ticker、endDate至少选择一个
    :param listStatusCD: 上市状态。L-上市；S-暂停；DE-终止上市；UN-未上市。,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/master/getSecHalt.csv?ispandas=1&') 
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("beginDate=%s"%(beginDate))
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&listStatusCD=")
    if hasattr(listStatusCD,'__iter__') and not isinstance(listStatusCD, str):
        if len(listStatusCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = listStatusCD
            requestString.append(None)
        else:
            requestString.append(','.join(listStatusCD))
    else:
        requestString.append(listStatusCD)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 150)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 150)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'haltBeginTime', u'haltEndTime', u'ticker', u'secShortName', u'exchangeCD', u'listStatusCD', u'delistDate', u'assetClass']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','haltBeginTime': 'str','haltEndTime': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str','listStatusCD': 'str','assetClass': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def SecIDGet(partyID = "", assetClass = "", ticker = "", cnSpell = "", field = "", pandas = "1"):
    """
    输入一个或多个证券交易代码，获取证券ID，证券在数据结构中的一个唯一识别的编码；同时可以获取输入证券的基本上市信息，如交易市场，上市状态，交易币种，ISIN编码等。
    
    :param partyID: 机构ID，assetClass为股票和债券时，是发行人的机构ID；assetClass为基金时，是基金管理人的机构ID；assetClass为指数时，是指数发布机构ID。,可以是列表,partyID、assetClass、ticker、cnSpell至少选择一个
    :param assetClass: 证券类型，可供选择类型：E 股票,B 债券,F 基金,IDX 指数,FU 期货,OP 期权；默认为 E。,partyID、assetClass、ticker、cnSpell至少选择一个
    :param ticker: 证券在交易所的交易代码，可输入一个或多个，用","分隔，如"000001"、"000001,600001"。,可以是列表,partyID、assetClass、ticker、cnSpell至少选择一个
    :param cnSpell: 通过输入证券简称拼音的方式，获取证券交易代码等信息，拼音以使用汉字拼音首位连接，如“平安银行”，即“PAYH”。,可以是列表,partyID、assetClass、ticker、cnSpell至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/master/getSecID.csv?ispandas=1&') 
    requestString.append("partyID=")
    if hasattr(partyID,'__iter__') and not isinstance(partyID, str):
        if len(partyID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = partyID
            requestString.append(None)
        else:
            requestString.append(','.join(partyID))
    else:
        requestString.append(partyID)
    if not isinstance(assetClass, str) and not isinstance(assetClass, unicode):
        assetClass = str(assetClass)

    requestString.append("&assetClass=%s"%(assetClass))
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&cnSpell=")
    if hasattr(cnSpell,'__iter__') and not isinstance(cnSpell, str):
        if len(cnSpell) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = cnSpell
            requestString.append(None)
        else:
            requestString.append(','.join(cnSpell))
    else:
        requestString.append(cnSpell)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1281)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1281)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'cnSpell', u'exchangeCD', u'assetClass', u'listStatusCD', u'listDate', u'transCurrCD', u'ISIN', u'partyID']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','cnSpell': 'str','exchangeCD': 'str','assetClass': 'str','listStatusCD': 'str','transCurrCD': 'str','ISIN': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def SecTradeTimeGet(secID = "", ticker = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取证券在上市交易场所的交易时间。默认查看过去1年。
    
    :param secID: 证券内部编码，可通过交易代码和交易市场在DataAPI.SecIDGet获取到。,可以是列表,secID、ticker至少选择一个
    :param ticker: 证券交易代码，如'000001',可以是列表,secID、ticker至少选择一个
    :param beginDate: 起始日期，默认为当前日期，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，默认当前日期加1年，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/master/getSecTradeTime.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1878)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1878)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'tradeDate', u'tradeTime', u'ticker', u'secShortName', u'exchangeCD']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','tradeTime': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def TradeCalGet(exchangeCD, beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    记录了上海证券交易所,深圳证券交易所,中国银行间市场,大连商品交易所,郑州商品交易所,上海期货交易所,中国金融期货交易所和香港交易所等交易所在日历日期当天是否开市的信息，其中上证、深证记录了自成立以来的全部日期是否开始信息。各交易日节假日安排通知发布当天即更新数据。
    
    :param exchangeCD: 证券交易所。可选：XSHG，XSHE，CCFX，XDCE，XSGE，XZCE，XHKG。XSHG表示上海证券交易所，XSHE表示深圳证券交易所，CCFX表示中国金融期货交易所，XDCE表示大连商品交易所，XSGE表示上海期货交易所，XZCE表示郑州商品交易所，XHKG表示香港证券交易所。可同时输入多个证券交易所,可以是列表
    :param beginDate: 起始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/master/getTradeCal.csv?ispandas=1&') 
    requestString.append("exchangeCD=")
    if hasattr(exchangeCD,'__iter__') and not isinstance(exchangeCD, str):
        if len(exchangeCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = exchangeCD
            requestString.append(None)
        else:
            requestString.append(','.join(exchangeCD))
    else:
        requestString.append(exchangeCD)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1293)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1293)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'exchangeCD', u'calendarDate', u'isOpen', u'prevTradeDate', u'isWeekEnd', u'isMonthEnd', u'isQuarterEnd', u'isYearEnd']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def IndustryGet(industryVersion = "", industryVersionCD = "", industryLevel = "", isNew = "", field = "", pandas = "1"):
    """
    输入行业分类通联编码(如，010303表示申万行业分类2014版)或输入一个行业分类标准名称，获取行业分类标准下行业划分
    
    :param industryVersion: 行业分类标准。SW- 申万行业分类,industryVersion、industryVersionCD至少选择一个
    :param industryVersionCD: 行业分类标准数字编码。010301-证监会行业V2012、010303-申万行业、010308-中证行业,可以是列表,industryVersion、industryVersionCD至少选择一个
    :param industryLevel: 输入数字如1,2,3,4，可指定查询的第几级行业,可以是列表,可空
    :param isNew: 是否最新，1表示是，0表示否,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/master/getIndustry.csv?ispandas=1&') 
    if not isinstance(industryVersion, str) and not isinstance(industryVersion, unicode):
        industryVersion = str(industryVersion)

    requestString.append("industryVersion=%s"%(industryVersion))
    requestString.append("&industryVersionCD=")
    if hasattr(industryVersionCD,'__iter__') and not isinstance(industryVersionCD, str):
        if len(industryVersionCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = industryVersionCD
            requestString.append(None)
        else:
            requestString.append(','.join(industryVersionCD))
    else:
        requestString.append(industryVersionCD)
    requestString.append("&industryLevel=")
    if hasattr(industryLevel,'__iter__') and not isinstance(industryLevel, str):
        if len(industryLevel) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = industryLevel
            requestString.append(None)
        else:
            requestString.append(','.join(industryLevel))
    else:
        requestString.append(industryLevel)
    if not isinstance(isNew, str) and not isinstance(isNew, unicode):
        isNew = str(isNew)

    requestString.append("&isNew=%s"%(isNew))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1473)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1473)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'industryVersionCD', u'industryVersion', u'industry', u'industryID', u'industrySymbol', u'industryName', u'industryLevel', u'isNew', u'indexSymbol', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'industryVersionCD': 'str','industryVersion': 'str','industry': 'str','industryID': 'str','industrySymbol': 'str','industryName': 'str','indexSymbol': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def SecTypeRelGet(typeID = "", secID = "", ticker = "", field = "", pandas = "1"):
    """
    记录证券每个分类的成分，证券分类可通过在getSecType获取。
    
    :param typeID: 输入某个证券分类的typeID值（分类的子节点），可获取该子节点分类下全部成分。分类可在api如DataAPI.SecTypeXXXGet获取，如地域类DataAPI.SecTypeRegionGet。,可空
    :param secID: 输入证券ID，可查询该证券属于哪些分类的成分，支持输入多个证券ID。,可以是列表,可空
    :param ticker: 输入证券交易代码，可查询该证券交易代码属于哪些分类的成分，支持输入多个证券交易代码。,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/master/getSecTypeRel.csv?ispandas=1&') 
    if not isinstance(typeID, str) and not isinstance(typeID, unicode):
        typeID = str(typeID)

    requestString.append("typeID=%s"%(typeID))
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1457)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1457)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'typeID', u'typeName', u'secID', u'ticker', u'exchangeCD', u'secShortName']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'typeID': 'str','typeName': 'str','secID': 'str','ticker': 'str','exchangeCD': 'str','secShortName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def EquInfoGet(ticker = "", field = "", pandas = "1"):
    """
    根据拼音或股票代码，匹配股票代码、名称。包含正在上市的全部沪深和新三板股票。
    
    :param ticker: 可以输入证券交易代码，如'000001',可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/master/getEquInfo.csv?ispandas=1&') 
    if not isinstance(ticker, str) and not isinstance(ticker, unicode):
        ticker = str(ticker)

    requestString.append("ticker=%s"%(ticker))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1365)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1365)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'ticker', u'exchangeCD', u'shortNM']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'ticker': 'str','exchangeCD': 'str','shortNM': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def SecTypeRegionRelGet(typeID = "", secID = "", ticker = "", field = "", pandas = "1"):
    """
    获取沪深股票地域分类，以注册地所在行政区域为标准。详细划分可在商品“地域分类”获取
    
    :param typeID: 输入某个证券分类的typeID值（分类的子节点），可获取该子节点分类下全部成分。分类可在api如DataAPI.SecTypeXXXGet获取，如地域类DataAPI.SecTypeRegionGet。,可空
    :param secID: 输入证券ID，可查询该证券属于哪些分类的成分，支持输入多个证券ID。,可以是列表,可空
    :param ticker: 输入证券交易代码，可查询该证券交易代码属于哪些分类的成分，支持输入多个证券交易代码。,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/master/getSecTypeRegionRel.csv?ispandas=1&') 
    if not isinstance(typeID, str) and not isinstance(typeID, unicode):
        typeID = str(typeID)

    requestString.append("typeID=%s"%(typeID))
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1429)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1429)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'typeID', u'typeName', u'secID', u'ticker', u'exchangeCD', u'secShortName']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'typeID': 'str','typeName': 'str','secID': 'str','ticker': 'str','exchangeCD': 'str','secShortName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def SecTypeGet(field = "", pandas = "1"):
    """
    证券分类列表，一级分类包含有沪深股票、港股、基金、债券、期货、期权等，每个分类又细分有不同类型；可一次获取全部分类。
    
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/master/getSecType.csv?ispandas=1&') 
    requestString.append("field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1458)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1458)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'typeID', u'typeName', u'parentID', u'typeLevel']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'typeID': 'str','typeName': 'str','parentID': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def SecTypeRegionGet(field = "", pandas = "1"):
    """
    获取中国地域分类，以行政划分为标准。
    
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/master/getSecTypeRegion.csv?ispandas=1&') 
    requestString.append("field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1430)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1430)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'typeID', u'typeName', u'parentID', u'typeLevel']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'typeID': 'str','typeName': 'str','parentID': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def SysCodeGet(codeTypeID = "", valueCD = "", field = "", pandas = "1"):
    """
    各api接口有枚举值特性的输出列，如getSecID输出项exchangeCD值，编码分别代表的是什么市场，所有枚举值都可以在这个接口获取。
    
    :param codeTypeID: 输入获知的参数分类ID，可以查询到这个参数分类下所有枚举值，非必须输入项,可以是列表,可空
    :param valueCD: 输入获知的参数下常量值，可以查询到这个常量值的说明，非必须输入项,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/master/getSysCode.csv?ispandas=1&') 
    requestString.append("codeTypeID=")
    if hasattr(codeTypeID,'__iter__') and not isinstance(codeTypeID, str):
        if len(codeTypeID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = codeTypeID
            requestString.append(None)
        else:
            requestString.append(','.join(codeTypeID))
    else:
        requestString.append(codeTypeID)
    requestString.append("&valueCD=")
    if hasattr(valueCD,'__iter__') and not isinstance(valueCD, str):
        if len(valueCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = valueCD
            requestString.append(None)
        else:
            requestString.append(','.join(valueCD))
    else:
        requestString.append(valueCD)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1537)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1537)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'codeTypeID', u'valueCD', u'valueName']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'valueCD': 'str','valueName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def SysCodeNewGet(codeTypeID = "", useType = "", valueCD = "", field = "", pandas = "1"):
    """
    各api接口有枚举值特性的输出列，如getSecID输出项exchangeCD值，编码分别代表的是什么市场，所有枚举值都可以在这个接口获取。
    
    :param codeTypeID: 输入获知的参数分类ID，可以查询到这个参数分类下所有枚举值，非必须输入项,可以是列表,可空
    :param useType: 输入获知的参数取用列名,可以查询到有该类编码的所有枚举值,非必须输入项,可以是列表,可空
    :param valueCD: 输入获知的参数下常量值，可以查询到这个常量值的说明，非必须输入项,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/master/getSysCodeNew.csv?ispandas=1&') 
    requestString.append("codeTypeID=")
    if hasattr(codeTypeID,'__iter__') and not isinstance(codeTypeID, str):
        if len(codeTypeID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = codeTypeID
            requestString.append(None)
        else:
            requestString.append(','.join(codeTypeID))
    else:
        requestString.append(codeTypeID)
    requestString.append("&useType=")
    if hasattr(useType,'__iter__') and not isinstance(useType, str):
        if len(useType) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = useType
            requestString.append(None)
        else:
            requestString.append(','.join(useType))
    else:
        requestString.append(useType)
    requestString.append("&valueCD=")
    if hasattr(valueCD,'__iter__') and not isinstance(valueCD, str):
        if len(valueCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = valueCD
            requestString.append(None)
        else:
            requestString.append(','.join(valueCD))
    else:
        requestString.append(valueCD)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 2010)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 2010)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'codeTypeID', u'useType', u'valueCD', u'valueName']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'useType': 'str','valueCD': 'str','valueName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktEqudGet(tradeDate = "", secID = "", ticker = "", beginDate = "", endDate = "", isOpen = "", field = "", pandas = "1"):
    """
    获取沪深AB股日行情信息，包含昨收价、开盘价、最高价、最低价、收盘价、成交量、成交金额等字段，每日16:00更新
    
    :param tradeDate: 输入一个日期，不输入其他请求参数，可获取到一天全部沪深股票日行情数据，输入格式“YYYYMMDD”,tradeDate、secID、ticker至少选择一个
    :param secID: 通联编制的证券编码，格式是“交易代码.证券市场代码”，如000001.XSHE。 可传入证券交易代码使用DataAPI.SecIDGet接口获取到。,可以是列表,tradeDate、secID、ticker至少选择一个
    :param ticker: 股票交易代码，如'000001'（可多值输入）,可以是列表,tradeDate、secID、ticker至少选择一个
    :param beginDate: 起始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，输入格式“YYYYMMDD”,可空
    :param isOpen: 股票今日是否开盘标记位：0-今日未开盘，1-今日有开盘,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktEqud.csv?ispandas=1&') 
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("tradeDate=%s"%(tradeDate))
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    if not isinstance(isOpen, str) and not isinstance(isOpen, unicode):
        isOpen = str(isOpen)

    requestString.append("&isOpen=%s"%(isOpen))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 80)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 80)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'tradeDate', u'preClosePrice', u'actPreClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'turnoverValue', u'dealAmount', u'turnoverRate', u'accumAdjFactor', u'negMarketValue', u'marketValue', u'chgPct', u'PE', u'PE1', u'PB', u'isOpen', u'vwap']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktFutdGet(tradeDate = "", secID = "", ticker = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取四大期货交易所日行情信息，包括开高低收、成交量、成交金额、持仓量、结算价、主力合约标记等信息， 其中主力合约按持仓量计算，每日16:00更新。
    
    :param tradeDate: 输入一个日期，不输入其他请求参数，可获取到一天全部期货合约日行情数据，输入格式“YYYYMMDD”,tradeDate、secID、ticker至少选择一个
    :param secID: 通联编制的证券编码，格式是“交易代码.证券市场代码”，如000001.XSHE。 可传入证券交易代码使用DataAPI.SecIDGet接口获取到。,可以是列表,tradeDate、secID、ticker至少选择一个
    :param ticker: 合约交易代码，如'cu1106'（可多值输入）,可以是列表,tradeDate、secID、ticker至少选择一个
    :param beginDate: 起始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktFutd.csv?ispandas=1&') 
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("tradeDate=%s"%(tradeDate))
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 85)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 85)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'exchangeCD', u'secShortName', u'tradeDate', u'contractObject', u'contractMark', u'preSettlePrice', u'preClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'settlePrice', u'turnoverVol', u'turnoverValue', u'openInt', u'CHG', u'CHG1', u'CHGPct', u'mainCon', u'smainCon']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','exchangeCD': 'str','secShortName': 'str','contractObject': 'str','contractMark': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktIdxdGet(tradeDate = "", indexID = "", ticker = "", beginDate = "", endDate = "", exchangeCD = "", field = "", pandas = "1"):
    """
    获取指数日线行情信息，包含昨收价、开盘价、最高价、最低价、收盘价、成交量、成交金额等字段。
    
    :param tradeDate: 输入一个日期，不输入其他请求参数，可获取到一天全部指数日行情数据，输入格式“YYYYMMDD”,tradeDate、indexID、ticker至少选择一个
    :param indexID: 通联编制的指数编码。 可通过指数代码和证券类型（assetClass=IDX）在DataAPI.SecIDGet获取到。,可以是列表,tradeDate、indexID、ticker至少选择一个
    :param ticker: 指数交易代码（可多值输入）,可以是列表,tradeDate、indexID、ticker至少选择一个
    :param beginDate: 起始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，输入格式“YYYYMMDD”,可空
    :param exchangeCD: 通联编制的证券市场编码。例如，XSHG-上海证券交易所；XSHE-深圳证券交易所；XIBE-中国银行间市场等。对应DataAPI.SysCodeGet.codeTypeID=10002。,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktIdxd.csv?ispandas=1&') 
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("tradeDate=%s"%(tradeDate))
    requestString.append("&indexID=")
    if hasattr(indexID,'__iter__') and not isinstance(indexID, str):
        if len(indexID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indexID
            requestString.append(None)
        else:
            requestString.append(','.join(indexID))
    else:
        requestString.append(indexID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&exchangeCD=")
    if hasattr(exchangeCD,'__iter__') and not isinstance(exchangeCD, str):
        if len(exchangeCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = exchangeCD
            requestString.append(None)
        else:
            requestString.append(','.join(exchangeCD))
    else:
        requestString.append(exchangeCD)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 90)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 90)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indexID', u'ticker', u'porgFullName', u'secShortName', u'exchangeCD', u'tradeDate', u'preCloseIndex', u'openIndex', u'lowestIndex', u'highestIndex', u'closeIndex', u'turnoverVol', u'turnoverValue', u'CHG', u'CHGPct']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indexID': 'str','ticker': 'str','porgFullName': 'str','secShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktBlockdGet(tradeDate = "", secID = "", ticker = "", beginDate = "", endDate = "", assetClass = "", field = "", pandas = "1"):
    """
    获取沪深交易所交易日大宗交易成交价，成交量等信息。
    
    :param tradeDate: 输入一个日期，不输入其他请求参数，可获取到一天全部沪深证券大宗交易数据，输入格式“YYYYMMDD”,tradeDate、secID、ticker至少选择一个
    :param secID: 证券ID，证券统一编码，可通过交易代码在DataAPI.SecIDGet获取到。（可多值输入）,可以是列表,tradeDate、secID、ticker至少选择一个
    :param ticker: 证券交易代码，如'000001'（可多值输入）,可以是列表,tradeDate、secID、ticker至少选择一个
    :param beginDate: 起始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，输入格式“YYYYMMDD”,可空
    :param assetClass: 通联编制的证券类别编码。例如，E-股票；B-债券；F-基金等。对应DataAPI.SysCodeGet.codeTypeID=10001。,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktBlockd.csv?ispandas=1&') 
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("tradeDate=%s"%(tradeDate))
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    if not isinstance(assetClass, str) and not isinstance(assetClass, unicode):
        assetClass = str(assetClass)

    requestString.append("&assetClass=%s"%(assetClass))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 82)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 82)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'tradeDate', u'secID', u'ticker', u'assetClass', u'exchangeCD', u'secFullName', u'currencyCD', u'tradePrice', u'tradeVal', u'tradeVol', u'buyerBD', u'sellerBD']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','assetClass': 'str','exchangeCD': 'str','secFullName': 'str','currencyCD': 'str','buyerBD': 'str','sellerBD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktRepodGet(tradeDate = "", secID = "", ticker = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取债券回购交易开、收、高、低，成交等日行情信息，每日16:00前更新
    
    :param tradeDate: 输入一个日期，不输入其他请求参数，可获取到一天全部证券债券回购日行情数据，输入格式“YYYYMMDD”,tradeDate、secID、ticker至少选择一个
    :param secID: 通联编制的证券编码，格式是“交易代码.证券市场代码”，如202001.XSHG。 可传入证券交易代码使用DataAPI.SecIDGet接口获取到。,可以是列表,tradeDate、secID、ticker至少选择一个
    :param ticker: 回购交易代码，如'204001'（可多值输入）,可以是列表,tradeDate、secID、ticker至少选择一个
    :param beginDate: 起始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktRepod.csv?ispandas=1&') 
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("tradeDate=%s"%(tradeDate))
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 84)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 84)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'tradeDate', u'preCloseRate', u'openRate', u'highestRate', u'lowestRate', u'closeRate', u'turnoverVol', u'turnoverValue', u'dealAmount']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktBonddGet(tradeDate = "", secID = "", ticker = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取债券交易开、收、高、低，成交等日行情信息，每日16:00前更新
    
    :param tradeDate: 输入一个日期，不输入其他请求参数，可获取到一天全部债券日行情数据，输入格式“YYYYMMDD”,tradeDate、secID、ticker至少选择一个
    :param secID: 证券ID，证券统一编码，可通过交易代码在DataAPI.SecIDGet获取到。（可多值输入）,可以是列表,tradeDate、secID、ticker至少选择一个
    :param ticker: 债券交易代码，如'100501'（可多值输入）,可以是列表,tradeDate、secID、ticker至少选择一个
    :param beginDate: 起始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktBondd.csv?ispandas=1&') 
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("tradeDate=%s"%(tradeDate))
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 83)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 83)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'tradeDate', u'preClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'turnoverValue', u'dealAmount', u'accrInterest', u'YTM']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktHKEqudGet(secID = "", ticker = "", tradeDate = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取香港交易所股票开、收、高、低，成交等日行情信息，每日17:00前更新
    
    :param secID: 证券ID，证券统一编码，可通过交易代码在DataAPI.SecIDGet获取到。（可多值输入）,可以是列表,secID、ticker、tradeDate至少选择一个
    :param ticker: 交易代码，如'00001'（可多值输入）,可以是列表,secID、ticker、tradeDate至少选择一个
    :param tradeDate: 输入一个日期，不输入其他请求参数，可获取到一天全部港股日行情数据，输入格式“YYYYMMDD”,secID、ticker、tradeDate至少选择一个
    :param beginDate: 起始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktHKEqud.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("&tradeDate=%s"%(tradeDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 81)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 81)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'exchangeCD', u'secShortName', u'tradeDate', u'preClosePrice', u'actPreClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'turnoverValue', u'SMA10', u'SMA20', u'SMA50', u'SMA250']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','exchangeCD': 'str','secShortName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktTickRTSnapshotGet(ticker = "", securityID = "", exchangeCD = "", assetClass = "", field = "", pandas = "1"):
    """
    高频数据，获取一只或多只证券最新Level1股票信息。 输入一只或多只证券代码，如000001.XSHG (上证指数） 或000001.XSHE（平安银行）， 还有所选字段， 得到证券的最新交易快照。 证券可以是股票，指数， 部分债券或 基金。
    
    :param ticker: 证券在证券市场通用的交易代码，可选参数，允许多值逗号分隔,可以是列表,ticker、securityID至少选择一个
    :param securityID: 通联编制的证券编码，格式是“交易代码.证券市场代码”，如000001.XSHE。 证券市场代码请根据证券的上市市场确定：XSHG-上海证券交易所，XSHE-深圳证券交易所，XHKG-香港交易所。,可以是列表,ticker、securityID至少选择一个
    :param exchangeCD: 通联编制的证券市场编码。例如，XSHG-上海证券交易所；XSHE-深圳证券交易所；XIBE-中国银行间市场等。对应DataAPI.SysCodeGet.codeTypeID=10002。,可以是列表,可空
    :param assetClass: 通联编制的证券类别编码。例如，E-股票；B-债券；F-基金；FU-期货等。对应DataAPI.SysCodeGet.codeTypeID=10001。,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getTickRTSnapshot.csv?ispandas=1&') 
    requestString.append("ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&securityID=")
    if hasattr(securityID,'__iter__') and not isinstance(securityID, str):
        if len(securityID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = securityID
            requestString.append(None)
        else:
            requestString.append(','.join(securityID))
    else:
        requestString.append(securityID)
    requestString.append("&exchangeCD=")
    if hasattr(exchangeCD,'__iter__') and not isinstance(exchangeCD, str):
        if len(exchangeCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = exchangeCD
            requestString.append(None)
        else:
            requestString.append(','.join(exchangeCD))
    else:
        requestString.append(exchangeCD)
    if not isinstance(assetClass, str) and not isinstance(assetClass, unicode):
        assetClass = str(assetClass)

    requestString.append("&assetClass=%s"%(assetClass))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 91)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 91)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'timestamp', u'ticker', u'exchangeCD', u'localTimestamp', u'dataDate', u'dataTime', u'shortNM', u'utcOffset', u'currencyCD', u'prevClosePrice', u'openPrice', u'volume', u'value', u'deal', u'highPrice', u'lowPrice', u'lastPrice', u'bidBook_price1', u'bidBook_volume1', u'bidBook_price2', u'bidBook_volume2', u'bidBook_price3', u'bidBook_volume3', u'bidBook_price4', u'bidBook_volume4', u'bidBook_price5', u'bidBook_volume5', u'askBook_price1', u'askBook_volume1', u'askBook_price2', u'askBook_volume2', u'askBook_price3', u'askBook_volume3', u'askBook_price4', u'amplitude', u'askBook_volume4', u'turnoverRate', u'askBook_price5', u'negMarketValue', u'askBook_volume5', u'staticPE', u'suspension', u'tradType', u'IEP', u'AggQty', u'nominalPrice', u'VWAP', u'change', u'changePct', u'Yield', u'tradStatus', u'tradSessionID', u'tradSessionSubID', u'tradSessionStatus', u'orderType', u'smallOrderValue', u'mediumOrderValue', u'largeOrderValue', u'extraLargeOrderValue', u'totalOrderValue', u'forwardPE']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'ticker': 'str','exchangeCD': 'str','dataDate': 'str','dataTime': 'str','shortNM': 'str','utcOffset': 'str','currencyCD': 'str','orderType': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktTickRTSnapshotIndexGet(securityID, field = "", pandas = "1"):
    """
    高频数据，获取一个指数的成分股的最新Level1股票信息。 输入一个指数的证券代码，如000001.XSHG (上证指数） 或000300.XSHG（沪深300）， 还有所选字段， 得到指数成分股的最新交易快照。
    
    :param securityID: 一个指数的证券代码，用,分隔，格式是“数字.交易所代码”，如000001.XSHG。目前支持的指数是：000001.XSHG（上证指数），000010.XSHG（上证180），000016.XSHG（上证50），000300.XSHG（沪深300）,000903.XSHG（中证100），000905.XSHG（中证500）,000906.XSHG（中证800）
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getTickRTSnapshotIndex.csv?ispandas=1&') 
    if not isinstance(securityID, str) and not isinstance(securityID, unicode):
        securityID = str(securityID)

    requestString.append("securityID=%s"%(securityID))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 92)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 92)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'timestamp', u'ticker', u'exchangeCD', u'localTimestamp', u'dataDate', u'dataTime', u'shortNM', u'utcOffset', u'currencyCD', u'prevClosePrice', u'openPrice', u'volume', u'value', u'deal', u'highPrice', u'lowPrice', u'lastPrice', u'bidBook_price1', u'bidBook_volume1', u'bidBook_price2', u'bidBook_volume2', u'bidBook_price3', u'bidBook_volume3', u'bidBook_price4', u'bidBook_volume4', u'bidBook_price5', u'bidBook_volume5', u'askBook_price1', u'askBook_volume1', u'askBook_price2', u'askBook_volume2', u'askBook_price3', u'askBook_volume3', u'askBook_price4', u'askBook_volume4', u'askBook_price5', u'askBook_volume5', u'suspension']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'ticker': 'str','exchangeCD': 'str','dataDate': 'str','dataTime': 'str','shortNM': 'str','utcOffset': 'str','currencyCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktFutureTickRTSnapshotGet(instrumentID = "", field = "", pandas = "1"):
    """
    高频数据，获取一只或多只期货的最新市场信息快照
    
    :param instrumentID: 证券在证券市场通用的交易代码。,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getFutureTickRTSnapshot.csv?ispandas=1&') 
    requestString.append("instrumentID=")
    if hasattr(instrumentID,'__iter__') and not isinstance(instrumentID, str):
        if len(instrumentID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = instrumentID
            requestString.append(None)
        else:
            requestString.append(','.join(instrumentID))
    else:
        requestString.append(instrumentID)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'instrumentID', u'timestamp', u'dataDate', u'dataTime', u'dataMillisec', u'prevClosePrice', u'openPrice', u'volume', u'value', u'highPrice', u'lowPrice', u'lastPrice', u'exchangeCD', u'openInterest', u'preOpenInterest', u'upperLimitPrice', u'lowerLimitPrice', u'preSettlementPrice', u'settlementPrice', u'closePrice', u'preDelta', u'currDelta', u'clearingDay', u'bidBook_price1', u'bidBook_volume1', u'bidBook_price2', u'bidBook_volume2', u'bidBook_price3', u'bidBook_volume3', u'bidBook_price4', u'bidBook_volume4', u'bidBook_price5', u'bidBook_volume5', u'askBook_price1', u'askBook_volume1', u'askBook_price2', u'askBook_volume2', u'askBook_price3', u'askBook_volume3', u'askBook_price4', u'askBook_volume4', u'askBook_price5', u'askBook_volume5', u'milliSecOffset', u'localTimestamp', u'currencyCD', u'utcOffset']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'instrumentID': 'str','dataDate': 'str','dataTime': 'str','exchangeCD': 'str','clearingDay': 'str','currencyCD': 'str','utcOffset': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktTickRTIntraDayGet(securityID, startTime = "", endTime = "", field = "", pandas = "1"):
    """
    高频数据，获取一只证券当日内时间段的Level1信息。 证券可以是股票，指数， 部分债券或 基金。
    
    :param securityID: 通联编制的证券编码，格式是“交易代码.证券市场代码”，如000001.XSHE。 证券市场代码请根据证券的上市市场确定：XSHG-上海证券交易所，XSHE-深圳证券交易所。
    :param startTime: 开始时间，必须大于等于09:25，例如10:05，如果为空则是09:25,可空
    :param endTime: 结束时间，必须小于等于15:05，例如14:20，如果为空则是15：05,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getTickRTIntraDay.csv?ispandas=1&') 
    if not isinstance(securityID, str) and not isinstance(securityID, unicode):
        securityID = str(securityID)

    requestString.append("securityID=%s"%(securityID))
    if not isinstance(startTime, str) and not isinstance(startTime, unicode):
        startTime = str(startTime)

    requestString.append("&startTime=%s"%(startTime))
    if not isinstance(endTime, str) and not isinstance(endTime, unicode):
        endTime = str(endTime)

    requestString.append("&endTime=%s"%(endTime))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 97)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 97)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'bidVolume2', u'bidPrice3', u'bidVolume3', u'bidPrice4', u'bidVolume4', u'bidPrice5', u'bidVolume5', u'askPrice1', u'askVolume1', u'askPrice2', u'askVolume2', u'askPrice3', u'askVolume3', u'askPrice4', u'askVolume4', u'askPrice5', u'askVolume5', u'dataDate', u'dataTime', u'ticker', u'exchangeCD', u'shortNM', u'secOffset', u'currencyCD', u'prevClosePrice', u'openPrice', u'volume', u'value', u'deal', u'highPrice', u'lowPrice', u'lastPrice', u'bidPrice1', u'bidVolume1', u'bidPrice2']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'dataTime': 'str','ticker': 'str','exchangeCD': 'str','shortNM': 'str','currencyCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktBarRTIntraDayGet(securityID, startTime = "", endTime = "", unit = "", pandas = "1"):
    """
    高频数据，获取一只证券当日的分钟线信息，包含1/5/15/30/60分钟的分钟线。 输入一只证券代码，如000001.XSHE（平安银行）， 得到此证券的当日的分钟线。 证券目前是股票，指数，基金和部分债券。分钟线的有效数据上午从09：30 到11：30，下午从13：01到15：00，分钟线的计算规则为分钟内前开后闭，向后归结，即（9:31:00.000，9:32:00.000]归为9:32分的数据，9:30的分钟线包含时间范围为9:30:00前所有成交（即集合竞价成交）
    
    :param securityID: 通联编制的证券编码。格式是“交易代码.证券市场代码”，如000001.XSHE。 证券市场代码请根据证券的上市市场确定：XSHG-上海证券交易所，XSHE-深圳证券交易所。
    :param startTime: 分钟线起始时间， 如09:40，就是从早上九点四十开始。 默认开始时间早上开市时间，即09:30，不选即为默认值,可空
    :param endTime: 分钟线终止时间， 如14:00, 就是到下午14点结束。 如终止时间是空， 则截止到最新数据或到关市为止，即15:00，不选即为默认值,可空
    :param unit: Bar(s)的时间宽度，单位分钟。取值范围： 1（分钟）/ 3（分钟）/5（分钟）/15（分钟）/30（分钟）/60（分钟）,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getBarRTIntraDay.csv?ispandas=1&') 
    if not isinstance(securityID, str) and not isinstance(securityID, unicode):
        securityID = str(securityID)

    requestString.append("securityID=%s"%(securityID))
    if not isinstance(startTime, str) and not isinstance(startTime, unicode):
        startTime = str(startTime)

    requestString.append("&startTime=%s"%(startTime))
    if not isinstance(endTime, str) and not isinstance(endTime, unicode):
        endTime = str(endTime)

    requestString.append("&endTime=%s"%(endTime))
    if not isinstance(unit, str) and not isinstance(unit, unicode):
        unit = str(unit)

    requestString.append("&unit=%s"%(unit))
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 94)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 94)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'unit', u'ticker', u'exchangeCD', u'shortNM', u'utcOffset', u'currencyCD', u'barTime', u'closePrice', u'openPrice', u'highPrice', u'lowPrice', u'totalVolume', u'totalValue']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'ticker': 'str','exchangeCD': 'str','shortNM': 'str','utcOffset': 'str','currencyCD': 'str','barTime': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktBarHistOneDayGet(securityID, date, startTime = "", endTime = "", unit = "", field = "", pandas = "1"):
    """
    高频数据，获取一只或多只证券在历史某一日的分钟线信息，包含1/3/5/15/30/60分钟的分钟线。 输入一只证券代码，如000001.XSHE（平安银行）， 得到这只证券在历史某一日的分钟线数据。 证券目前是股票，指数，基金和部分债券。分钟线的有效数据上午从09：30 到11：30，下午从13：01到15：00，分钟线的计算规则为分钟内前开后闭，向后归结，即（9:31:00.000，9:32:00.000]归为9:32分的数据，9:30的分钟线包含时间范围为9:30:00前所有成交（即集合竞价成交）
    
    :param securityID: 通联编制的证券编码，格式是“交易代码.证券市场代码”，如000001.XSHE。 证券市场代码请根据证券的上市市场确定：XSHG-上海证券交易所，XSHE-深圳证券交易所，XHKG-香港交易所。,可以是列表
    :param date: 查询日期，格式YYYYMMDD
    :param startTime: 分钟线起始时间， 如09:40，就是从早上九点四十开始。 默认开始时间早上开市时间，即09:30，不选即为默认值,可空
    :param endTime: 分钟线终止时间， 如14:00, 就是到下午14点结束。 如终止时间是空， 则截止到最新数据或到关市为止，即15:00，不选即为默认值,可空
    :param unit: Bar(s)的时间宽度，单位分钟。取值范围： 1（分钟）/3(分钟)/5（分钟）/15（分钟）/30（分钟）/60（分钟）,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getBarHistOneDay.csv?ispandas=1&') 
    requestString.append("securityID=")
    if hasattr(securityID,'__iter__') and not isinstance(securityID, str):
        if len(securityID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = securityID
            requestString.append(None)
        else:
            requestString.append(','.join(securityID))
    else:
        requestString.append(securityID)
    try:
        date = date.strftime('%Y%m%d')
    except:
        date = date.replace('-', '')
    requestString.append("&date=%s"%(date))
    if not isinstance(startTime, str) and not isinstance(startTime, unicode):
        startTime = str(startTime)

    requestString.append("&startTime=%s"%(startTime))
    if not isinstance(endTime, str) and not isinstance(endTime, unicode):
        endTime = str(endTime)

    requestString.append("&endTime=%s"%(endTime))
    if not isinstance(unit, str) and not isinstance(unit, unicode):
        unit = str(unit)

    requestString.append("&unit=%s"%(unit))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 95)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 95)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'unit', u'ticker', u'exchangeCD', u'shortNM', u'currencyCD', u'dataDate', u'barTime', u'closePrice', u'openPrice', u'highPrice', u'lowPrice', u'totalVolume', u'totalValue']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'ticker': 'str','exchangeCD': 'str','shortNM': 'str','currencyCD': 'str','barTime': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktBarHistDateRangeGet(securityID, startDate, endDate, unit = "", field = "", pandas = "1"):
    """
    高频数据，获取一只证券在历史某个日期段的分钟线信息，包含1/3/5/15/30/60分钟的分钟线。 输入一只证券代码，如000001.XSHE（平安银行）， 得到这只证券在历史某个日期段的分钟线数据。 证券目前是股票，指数，基金和部分债券。 不支持跨月查询：开始日期和结束日期必须在同一个月内。分钟线的有效数据上午从09：30 到11：30，下午从13：01到15：00，分钟线的计算规则为分钟内前开后闭，向后归结，即（9:31:00.000，9:32:00.000]归为9:32分的数据，9:30的分钟线包含时间范围为9:30:00前所有成交（即集合竞价成交）
    
    :param securityID: 通联编制的证券编码，格式是“交易代码.证券市场代码”，如000001.XSHE。 证券市场代码请根据证券的上市市场确定：XSHG-上海证券交易所，XSHE-深圳证券交易所，XHKG-香港交易所。
    :param startDate: 日期范围的起始日期，格式““YYYYMMDD”。
    :param endDate: 日期范围的截止日期，格式““YYYYMMDD”。startDate和endDate必须在同一个月。
    :param unit: Bar(s)的时间宽度，单位分钟, 如 1(分钟)/3(分钟)/5(分钟)/10(分钟)/60(分钟),可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getBarHistDateRange.csv?ispandas=1&') 
    if not isinstance(securityID, str) and not isinstance(securityID, unicode):
        securityID = str(securityID)

    requestString.append("securityID=%s"%(securityID))
    if not isinstance(startDate, str) and not isinstance(startDate, unicode):
        startDate = str(startDate)

    requestString.append("&startDate=%s"%(startDate))
    if not isinstance(endDate, str) and not isinstance(endDate, unicode):
        endDate = str(endDate)

    requestString.append("&endDate=%s"%(endDate))
    if not isinstance(unit, str) and not isinstance(unit, unicode):
        unit = str(unit)

    requestString.append("&unit=%s"%(unit))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 96)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 96)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'unit', u'ticker', u'exchangeCD', u'shortNM', u'currencyCD', u'dataDate', u'barTime', u'closePrice', u'openPrice', u'highPrice', u'lowPrice', u'totalVolume', u'totalValue']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'ticker': 'str','exchangeCD': 'str','shortNM': 'str','currencyCD': 'str','barTime': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktTicksHistOneDayGet(securityID, date, startSecOffset = "", endSecOffset = "", field = "", pandas = "1"):
    """
    高频数据，获取一只证券在历史上某一天内的Tick数据。 输入一只证券代码，如000001.XSHE（平安银行）。证券包括股票， 指数，部分债券和基金
    
    :param securityID: 通联编制的证券编码，格式是“交易代码.证券市场代码”，如000001.XSHE。 证券市场代码请根据证券的上市市场确定：XSHG-上海证券交易所，XSHE-深圳证券交易所，XHKG-香港交易所。
    :param date: 数据日期。格式是YYYYMMDD。
    :param startSecOffset: 查询范围的开始时间相对8点的秒偏移量(>=0)。,可空
    :param endSecOffset: 查询范围的结束时间相对8点的秒偏移量(>=0)。,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getTicksHistOneDay.csv?ispandas=1&') 
    if not isinstance(securityID, str) and not isinstance(securityID, unicode):
        securityID = str(securityID)

    requestString.append("securityID=%s"%(securityID))
    if not isinstance(date, str) and not isinstance(date, unicode):
        date = str(date)

    requestString.append("&date=%s"%(date))
    if not isinstance(startSecOffset, str) and not isinstance(startSecOffset, unicode):
        startSecOffset = str(startSecOffset)

    requestString.append("&startSecOffset=%s"%(startSecOffset))
    if not isinstance(endSecOffset, str) and not isinstance(endSecOffset, unicode):
        endSecOffset = str(endSecOffset)

    requestString.append("&endSecOffset=%s"%(endSecOffset))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 98)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 98)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'bidVolume2', u'bidPrice3', u'dataDate', u'dataTime', u'ticker', u'exchangeCD', u'shortNM', u'secOffset', u'currencyCD', u'prevClosePrice', u'openPrice', u'volume', u'value', u'deal', u'highPrice', u'lowPrice', u'lastPrice', u'bidVolume3', u'bidPrice4', u'bidVolume4', u'bidPrice5', u'bidVolume5', u'askPrice1', u'askVolume1', u'askPrice2', u'askVolume2', u'askPrice3', u'askVolume3', u'askPrice4', u'askVolume4', u'askPrice5', u'bidPrice1', u'bidVolume1', u'askVolume5', u'bidPrice2']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'dataTime': 'str','ticker': 'str','exchangeCD': 'str','shortNM': 'str','currencyCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktTicksHistTimeSeriesGet(endOffset, securityID, date, startOffset, field = "", pandas = "1"):
    """
    高频数据，获取一只或多只证券在历史上某一个交易日内某个时间段的Tick数据。 输入一只证券代码，如000001.XSHE（平安银行）。证券包括股票， 指数，部分债券和基金,按照时间排序。
    
    :param endOffset: 结束时间偏移，相对于早上八点的秒数偏移，如6000，注意endOffset-startOffset最多为600(10分钟)，此外，注意最后返回的数据的时间区间是[startOffset, endOffset)
    :param securityID: 通联编制的证券编码，格式是“交易代码.证券市场代码”，如000001.XSHE。 证券市场代码请根据证券的上市市场确定：XSHG-上海证券交易所，XSHE-深圳证券交易所，XHKG-香港交易所。,可以是列表
    :param date: 历史交易日期。格式是YYYYMMDD，如20140106表示2014年1月6日。
    :param startOffset: 开始时间偏移，相对于早上八点的秒数偏移，如5400
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getTicksHistTimeSeries.csv?ispandas=1&') 
    if not isinstance(endOffset, str) and not isinstance(endOffset, unicode):
        endOffset = str(endOffset)

    requestString.append("endOffset=%s"%(endOffset))
    requestString.append("&securityID=")
    if hasattr(securityID,'__iter__') and not isinstance(securityID, str):
        if len(securityID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = securityID
            requestString.append(None)
        else:
            requestString.append(','.join(securityID))
    else:
        requestString.append(securityID)
    if not isinstance(date, str) and not isinstance(date, unicode):
        date = str(date)

    requestString.append("&date=%s"%(date))
    if not isinstance(startOffset, str) and not isinstance(startOffset, unicode):
        startOffset = str(startOffset)

    requestString.append("&startOffset=%s"%(startOffset))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 99)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 99)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'dataDate', u'dataTime', u'ticker', u'exchangeCD', u'shortNM', u'secOffset', u'currencyCD', u'prevClosePrice', u'openPrice', u'volume', u'value', u'deal', u'highPrice', u'lowPrice', u'lastPrice', u'bidPrice1', u'bidVolume1', u'bidPrice2', u'bidVolume2', u'bidPrice3', u'bidVolume3', u'bidPrice4', u'bidVolume4', u'bidPrice5', u'bidVolume5', u'askPrice1', u'askVolume1', u'askPrice2', u'askVolume2', u'askPrice3', u'askVolume3', u'askPrice4', u'askVolume4', u'askPrice5', u'askVolume5']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'dataTime': 'str','ticker': 'str','exchangeCD': 'str','shortNM': 'str','currencyCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktFutureTicksHistOneDayGet(instrumentID, date, startSecOffset = "", endSecOffset = "", field = "", pandas = "1"):
    """
    高频数据，获取一只期货在历史上某一清算日内的Tick数据，可根据交易时间筛选返回数据。
    
    :param instrumentID: 一个期货合约代码，如A1009;也可以是期货合约类型，如A，此时表示查主力合约。
    :param date: 数据清算日期。格式是“YYYYMMDD”，一个完整的清算日包含夜盘+日盘的全部Tick信息
    :param startSecOffset: 开始时间相对0点的秒偏移量。若从09:00开始，则填写32400。,可空
    :param endSecOffset: 结束时间相对0点的秒偏移量，若到10:00结束，则填写36000。,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getFutureTicksHistOneDay.csv?ispandas=1&') 
    if not isinstance(instrumentID, str) and not isinstance(instrumentID, unicode):
        instrumentID = str(instrumentID)

    requestString.append("instrumentID=%s"%(instrumentID))
    if not isinstance(date, str) and not isinstance(date, unicode):
        date = str(date)

    requestString.append("&date=%s"%(date))
    if not isinstance(startSecOffset, str) and not isinstance(startSecOffset, unicode):
        startSecOffset = str(startSecOffset)

    requestString.append("&startSecOffset=%s"%(startSecOffset))
    if not isinstance(endSecOffset, str) and not isinstance(endSecOffset, unicode):
        endSecOffset = str(endSecOffset)

    requestString.append("&endSecOffset=%s"%(endSecOffset))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 100)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 100)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'dataDate', u'dataTime', u'dataMillisec', u'instrumentID', u'milliSecOffset', u'contractType', u'prevClosePrice', u'openPrice', u'volume', u'value', u'highPrice', u'lowPrice', u'lastPrice', u'exchangeCD', u'openInterest', u'preOpenInterest', u'upperLimitPrice', u'lowerLimitPrice', u'preSettlementPrice', u'settlementPrice', u'closePrice', u'preDelta', u'currDelta', u'clearingDay', u'mflag', u'source', u'bidPrice1', u'bidVolume1', u'bidPrice2', u'bidVolume2', u'bidPrice3', u'bidVolume3', u'bidPrice4', u'bidVolume4', u'bidPrice5', u'bidVolume5', u'askPrice1', u'askVolume1', u'askPrice2', u'askVolume2', u'askPrice3', u'askVolume3', u'askPrice4', u'askVolume4', u'askPrice5', u'askVolume5', u'tflag']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'dataTime': 'str','instrumentID': 'str','contractType': 'str','exchangeCD': 'str','clearingDay': 'str','mflag': 'str','source': 'str','tflag': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktFutureTicksHistTimeSeriesGet(instrumentID, date, startSecOffset, endSecOffset, field = "", pandas = "1"):
    """
    高频数据，获取多只期货在历史上某一天某个时间段内的Tick数据，最多10分钟
    
    :param instrumentID: 多只期货代码，用逗号分割，每个代码可以是期货合约代码，也可以是期货品种，表示查询主力合约，如A1009，C"表示查询A1009和C品种的主力合约,可以是列表
    :param date: 日期，格式如20130719，这里表示的是交易日
    :param startSecOffset: 开始时间，是相对0点的秒偏移量
    :param endSecOffset: 结束时间，是相对0点的秒偏移量，0< endSecOffset-startSecOffset<=600，返回的数据区间是[startSecOffset, endSecOffset)
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getFutureTicksHistTimeSeries.csv?ispandas=1&') 
    requestString.append("instrumentID=")
    if hasattr(instrumentID,'__iter__') and not isinstance(instrumentID, str):
        if len(instrumentID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = instrumentID
            requestString.append(None)
        else:
            requestString.append(','.join(instrumentID))
    else:
        requestString.append(instrumentID)
    if not isinstance(date, str) and not isinstance(date, unicode):
        date = str(date)

    requestString.append("&date=%s"%(date))
    if not isinstance(startSecOffset, str) and not isinstance(startSecOffset, unicode):
        startSecOffset = str(startSecOffset)

    requestString.append("&startSecOffset=%s"%(startSecOffset))
    if not isinstance(endSecOffset, str) and not isinstance(endSecOffset, unicode):
        endSecOffset = str(endSecOffset)

    requestString.append("&endSecOffset=%s"%(endSecOffset))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 101)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 101)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'dataDate', u'dataTime', u'dataMillisec', u'instrumentID', u'exchangeCD', u'lastPrice', u'lowPrice', u'highPrice', u'volume', u'value', u'openInterest', u'preOpenInterest', u'upperLimitPrice', u'lowerLimitPrice', u'preSettlementPrice', u'prevClosePrice', u'settlementPrice', u'openPrice', u'closePrice', u'preDelta', u'currDelta', u'clearingDay', u'mflag', u'tflag', u'source', u'contractType', u'milliSecOffset', u'bidPrice1', u'bidVolume1', u'bidPrice2', u'bidVolume2', u'bidPrice3', u'bidVolume3', u'bidPrice4', u'bidVolume4', u'bidPrice5', u'bidVolume5', u'askPrice1', u'askVolume1', u'askPrice2', u'askVolume2', u'askPrice3', u'askVolume3', u'askPrice4', u'askVolume4', u'askPrice5', u'askVolume5']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'dataTime': 'str','instrumentID': 'str','exchangeCD': 'str','clearingDay': 'str','mflag': 'str','tflag': 'str','source': 'str','contractType': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktFutureTicksHistOneClearingDayGet(instrumentID, date, tflag, field = "", pandas = "1"):
    """
    高频数据，获取一只期货在历史上某一清算日的Tick数据。
    
    :param instrumentID: 一个期货合约代码，如A1009(大小写均可);也可以是期货品种代码，如A，此时表示查主力合约。
    :param date: 日期，格式如20130719，注意这里表示的是清算日
    :param tflag: 查询日盘，夜盘，还是全部，1表示日盘，0表示夜盘，2表示全部
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getFutureTicksHistOneClearingDay.csv?ispandas=1&') 
    if not isinstance(instrumentID, str) and not isinstance(instrumentID, unicode):
        instrumentID = str(instrumentID)

    requestString.append("instrumentID=%s"%(instrumentID))
    if not isinstance(date, str) and not isinstance(date, unicode):
        date = str(date)

    requestString.append("&date=%s"%(date))
    if not isinstance(tflag, str) and not isinstance(tflag, unicode):
        tflag = str(tflag)

    requestString.append("&tflag=%s"%(tflag))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 102)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 102)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'dataDate', u'dataTime', u'dataMillisec', u'instrumentID', u'milliSecOffset', u'contractType', u'prevClosePrice', u'openPrice', u'volume', u'value', u'highPrice', u'lowPrice', u'lastPrice', u'exchangeCD', u'openInterest', u'preOpenInterest', u'upperLimitPrice', u'lowerLimitPrice', u'preSettlementPrice', u'settlementPrice', u'closePrice', u'preDelta', u'currDelta', u'clearingDay', u'mflag', u'source', u'bidPrice1', u'bidVolume1', u'bidPrice2', u'bidVolume2', u'bidPrice3', u'bidVolume3', u'bidPrice4', u'bidVolume4', u'bidPrice5', u'bidVolume5', u'askPrice1', u'askVolume1', u'askPrice2', u'askVolume2', u'askPrice3', u'askVolume3', u'askPrice4', u'askVolume4', u'askPrice5', u'askVolume5', u'tflag']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'dataTime': 'str','instrumentID': 'str','contractType': 'str','exchangeCD': 'str','mflag': 'str','source': 'str','tflag': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktFutureTickRTIntraDayGet(instrumentID, startTime = "", endTime = "", field = "", pandas = "1"):
    """
    高频数据，获取一只期货在本清算日内某时间段的Tick数据
    
    :param instrumentID: 一个期货合约代码，如A1009(大小写均可)，此处不可以是合约类型代码。
    :param startTime: 开始时间，如10:10，若空，则表示没有上界,可空
    :param endTime: 结束时间，如10:15，若空，则表示没有下界,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getFutureTickRTIntraDay.csv?ispandas=1&') 
    if not isinstance(instrumentID, str) and not isinstance(instrumentID, unicode):
        instrumentID = str(instrumentID)

    requestString.append("instrumentID=%s"%(instrumentID))
    if not isinstance(startTime, str) and not isinstance(startTime, unicode):
        startTime = str(startTime)

    requestString.append("&startTime=%s"%(startTime))
    if not isinstance(endTime, str) and not isinstance(endTime, unicode):
        endTime = str(endTime)

    requestString.append("&endTime=%s"%(endTime))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 103)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 103)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'dataDate', u'dataTime', u'dataMillisec', u'instrumentID', u'exchangeCD', u'lastPrice', u'lowPrice', u'highPrice', u'volume', u'value', u'openInterest', u'preOpenInterest', u'upperLimitPrice', u'lowerLimitPrice', u'preSettlementPrice', u'prevClosePrice', u'settlementPrice', u'openPrice', u'closePrice', u'preDelta', u'currDelta', u'clearingDay', u'milliSecOffset', u'bidPrice1', u'bidVolume1', u'bidPrice2', u'bidVolume2', u'bidPrice3', u'bidVolume3', u'bidPrice4', u'bidVolume4', u'bidPrice5', u'bidVolume5', u'askPrice1', u'askVolume1', u'askPrice2', u'askVolume2', u'askPrice3', u'askVolume3', u'askPrice4', u'askVolume4', u'askPrice5', u'askVolume5']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'dataTime': 'str','instrumentID': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktStockFactorsOneDayGet(tradeDate, secID = "", ticker = "", field = "", pandas = "1"):
    """
    获取多只股票历史上某一天的因子数据
    
    :param tradeDate: 日期
    :param secID: 多只股票ID，用逗号隔开,可以是列表,可空
    :param ticker: 多只股票交易代码，用逗号隔开,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getStockFactorsOneDay.csv?ispandas=1&') 
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("tradeDate=%s"%(tradeDate))
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 104)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 104)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'tradeDate', u'AccountsPayablesTDays', u'AccountsPayablesTRate', u'AdminiExpenseRate', u'ARTDays', u'ARTRate', u'ASSI', u'BLEV', u'BondsPayableToAsset', u'CashRateOfSales', u'CashToCurrentLiability', u'CMRA', u'CTOP', u'CTP5', u'CurrentAssetsRatio', u'CurrentAssetsTRate', u'CurrentRatio', u'DAVOL10', u'DAVOL20', u'DAVOL5', u'DDNBT', u'DDNCR', u'DDNSR', u'DebtEquityRatio', u'DebtsAssetRatio', u'DHILO', u'DilutedEPS', u'DVRAT', u'EBITToTOR', u'EGRO', u'EMA10', u'EMA120', u'EMA20', u'EMA5', u'EMA60', u'EPS', u'EquityFixedAssetRatio', u'EquityToAsset', u'EquityTRate', u'ETOP', u'ETP5', u'FinancialExpenseRate', u'FinancingCashGrowRate', u'FixAssetRatio', u'FixedAssetsTRate', u'GrossIncomeRatio', u'HBETA', u'HSIGMA', u'IntangibleAssetRatio', u'InventoryTDays', u'InventoryTRate', u'InvestCashGrowRate', u'LCAP', u'LFLO', u'LongDebtToAsset', u'LongDebtToWorkingCapital', u'LongTermDebtToAsset', u'MA10', u'MA120', u'MA20', u'MA5', u'MA60', u'MAWVAD', u'MFI', u'MLEV', u'NetAssetGrowRate', u'NetProfitGrowRate', u'NetProfitRatio', u'NOCFToOperatingNI', u'NonCurrentAssetsRatio', u'NPParentCompanyGrowRate', u'NPToTOR', u'OperatingExpenseRate', u'OperatingProfitGrowRate', u'OperatingProfitRatio', u'OperatingProfitToTOR', u'OperatingRevenueGrowRate', u'OperCashGrowRate', u'OperCashInToCurrentLiability', u'PB', u'PCF', u'PE', u'PS', u'PSY', u'QuickRatio', u'REVS10', u'REVS20', u'REVS5', u'ROA', u'ROA5', u'ROE', u'ROE5', u'RSI', u'RSTR12', u'RSTR24', u'SalesCostRatio', u'SaleServiceCashToOR', u'SUE', u'TaxRatio', u'TOBT', u'TotalAssetGrowRate', u'TotalAssetsTRate', u'TotalProfitCostRatio', u'TotalProfitGrowRate', u'VOL10', u'VOL120', u'VOL20', u'VOL240', u'VOL5', u'VOL60', u'WVAD', u'REC', u'DAREC', u'GREC', u'FY12P', u'DAREV', u'GREV', u'SFY12P', u'DASREV', u'GSREV', u'FEARNG', u'FSALESG', u'TA2EV', u'CFO2EV', u'ACCA', u'DEGM', u'SUOI', u'EARNMOM', u'FiftyTwoWeekHigh', u'Volatility', u'Skewness', u'ILLIQUIDITY', u'BackwardADJ', u'MACD', u'ADTM', u'ATR14', u'ATR6', u'BIAS10', u'BIAS20', u'BIAS5', u'BIAS60', u'BollDown', u'BollUp', u'CCI10', u'CCI20', u'CCI5', u'CCI88', u'KDJ_K', u'KDJ_D', u'KDJ_J', u'ROC6', u'ROC20', u'SBM', u'STM', u'UpRVI', u'DownRVI', u'RVI', u'SRMI', u'ChandeSD', u'ChandeSU', u'CMO', u'DBCD', u'ARC', u'OBV', u'OBV6', u'OBV20', u'TVMA20', u'TVMA6', u'TVSTD20', u'TVSTD6', u'VDEA', u'VDIFF', u'VEMA10', u'VEMA12', u'VEMA26', u'VEMA5', u'VMACD', u'VOSC', u'VR', u'VROC12', u'VROC6', u'VSTD10', u'VSTD20', u'KlingerOscillator', u'MoneyFlow20', u'AD', u'AD20', u'AD6', u'CoppockCurve', u'ASI', u'ChaikinOscillator', u'ChaikinVolatility', u'EMV14', u'EMV6', u'plusDI', u'minusDI', u'ADX', u'ADXR', u'Aroon', u'AroonDown', u'AroonUp', u'DEA', u'DIFF', u'DDI', u'DIZ', u'DIF', u'MTM', u'MTMMA', u'PVT', u'PVT6', u'PVT12', u'TRIX5', u'TRIX10', u'UOS', u'MA10RegressCoeff12', u'MA10RegressCoeff6', u'PLRC6', u'PLRC12', u'SwingIndex', u'Ulcer10', u'Ulcer5', u'Hurst', u'ACD6', u'ACD20', u'EMA12', u'EMA26', u'APBMA', u'BBI', u'BBIC', u'TEMA10', u'TEMA5', u'MA10Close', u'AR', u'BR', u'ARBR', u'CR20', u'MassIndex', u'BearPower', u'BullPower', u'Elder', u'NVI', u'PVI', u'RC12', u'RC24', u'JDQS20']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktStockFactorsDateRangeGet(secID = "", ticker = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取一只股票历史上某一时间段的因子数据
    
    :param secID: 一只股票ID,secID、ticker至少选择一个
    :param ticker: 一只股票交易代码,secID、ticker至少选择一个
    :param beginDate: 开始日期,可空
    :param endDate: 结束日期,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getStockFactorsDateRange.csv?ispandas=1&') 
    if not isinstance(secID, str) and not isinstance(secID, unicode):
        secID = str(secID)

    requestString.append("secID=%s"%(secID))
    if not isinstance(ticker, str) and not isinstance(ticker, unicode):
        ticker = str(ticker)

    requestString.append("&ticker=%s"%(ticker))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 105)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 105)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'tradeDate', u'AccountsPayablesTDays', u'AccountsPayablesTRate', u'AdminiExpenseRate', u'ARTDays', u'ARTRate', u'ASSI', u'BLEV', u'BondsPayableToAsset', u'CashRateOfSales', u'CashToCurrentLiability', u'CMRA', u'CTOP', u'CTP5', u'CurrentAssetsRatio', u'CurrentAssetsTRate', u'CurrentRatio', u'DAVOL10', u'DAVOL20', u'DAVOL5', u'DDNBT', u'DDNCR', u'DDNSR', u'DebtEquityRatio', u'DebtsAssetRatio', u'DHILO', u'DilutedEPS', u'DVRAT', u'EBITToTOR', u'EGRO', u'EMA10', u'EMA120', u'EMA20', u'EMA5', u'EMA60', u'EPS', u'EquityFixedAssetRatio', u'EquityToAsset', u'EquityTRate', u'ETOP', u'ETP5', u'FinancialExpenseRate', u'FinancingCashGrowRate', u'FixAssetRatio', u'FixedAssetsTRate', u'GrossIncomeRatio', u'HBETA', u'HSIGMA', u'IntangibleAssetRatio', u'InventoryTDays', u'InventoryTRate', u'InvestCashGrowRate', u'LCAP', u'LFLO', u'LongDebtToAsset', u'LongDebtToWorkingCapital', u'LongTermDebtToAsset', u'MA10', u'MA120', u'MA20', u'MA5', u'MA60', u'MAWVAD', u'MFI', u'MLEV', u'NetAssetGrowRate', u'NetProfitGrowRate', u'NetProfitRatio', u'NOCFToOperatingNI', u'NonCurrentAssetsRatio', u'NPParentCompanyGrowRate', u'NPToTOR', u'OperatingExpenseRate', u'OperatingProfitGrowRate', u'OperatingProfitRatio', u'OperatingProfitToTOR', u'OperatingRevenueGrowRate', u'OperCashGrowRate', u'OperCashInToCurrentLiability', u'PB', u'PCF', u'PE', u'PS', u'PSY', u'QuickRatio', u'REVS10', u'REVS20', u'REVS5', u'ROA', u'ROA5', u'ROE', u'ROE5', u'RSI', u'RSTR12', u'RSTR24', u'SalesCostRatio', u'SaleServiceCashToOR', u'SUE', u'TaxRatio', u'TOBT', u'TotalAssetGrowRate', u'TotalAssetsTRate', u'TotalProfitCostRatio', u'TotalProfitGrowRate', u'VOL10', u'VOL120', u'VOL20', u'VOL240', u'VOL5', u'VOL60', u'WVAD', u'REC', u'DAREC', u'GREC', u'FY12P', u'DAREV', u'GREV', u'SFY12P', u'DASREV', u'GSREV', u'FEARNG', u'FSALESG', u'TA2EV', u'CFO2EV', u'ACCA', u'DEGM', u'SUOI', u'EARNMOM', u'FiftyTwoWeekHigh', u'Volatility', u'Skewness', u'ILLIQUIDITY', u'BackwardADJ', u'MACD', u'ADTM', u'ATR14', u'ATR6', u'BIAS10', u'BIAS20', u'BIAS5', u'BIAS60', u'BollDown', u'BollUp', u'CCI10', u'CCI20', u'CCI5', u'CCI88', u'KDJ_K', u'KDJ_D', u'KDJ_J', u'ROC6', u'ROC20', u'SBM', u'STM', u'UpRVI', u'DownRVI', u'RVI', u'SRMI', u'ChandeSD', u'ChandeSU', u'CMO', u'DBCD', u'ARC', u'OBV', u'OBV6', u'OBV20', u'TVMA20', u'TVMA6', u'TVSTD20', u'TVSTD6', u'VDEA', u'VDIFF', u'VEMA10', u'VEMA12', u'VEMA26', u'VEMA5', u'VMACD', u'VOSC', u'VR', u'VROC12', u'VROC6', u'VSTD10', u'VSTD20', u'KlingerOscillator', u'MoneyFlow20', u'AD', u'AD20', u'AD6', u'CoppockCurve', u'ASI', u'ChaikinOscillator', u'ChaikinVolatility', u'EMV14', u'EMV6', u'plusDI', u'minusDI', u'ADX', u'ADXR', u'Aroon', u'AroonDown', u'AroonUp', u'DEA', u'DIFF', u'DDI', u'DIZ', u'DIF', u'MTM', u'MTMMA', u'PVT', u'PVT6', u'PVT12', u'TRIX5', u'TRIX10', u'UOS', u'MA10RegressCoeff12', u'MA10RegressCoeff6', u'PLRC6', u'PLRC12', u'SwingIndex', u'Ulcer10', u'Ulcer5', u'Hurst', u'ACD6', u'ACD20', u'EMA12', u'EMA26', u'APBMA', u'BBI', u'BBIC', u'TEMA10', u'TEMA5', u'MA10Close', u'AR', u'BR', u'ARBR', u'CR20', u'MassIndex', u'BearPower', u'BullPower', u'Elder', u'NVI', u'PVI', u'RC12', u'RC24', u'JDQS20']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktFunddGet(tradeDate = "", secID = "", ticker = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取基金买卖交易开、收、高、低，成交等日行情信息。
    
    :param tradeDate: 输入一个日期，不输入其他请求参数，可获取到一天全部基金日行情数据，输入格式“YYYYMMDD”,tradeDate、secID、ticker至少选择一个
    :param secID: 通联编制的证券编码，格式是“交易代码.证券市场代码”，如000001.XSHE。 可传入证券交易代码使用DataAPI.SecIDGet接口获取到。,可以是列表,tradeDate、secID、ticker至少选择一个
    :param ticker: 基金交易代码，如'150001',可以是列表,tradeDate、secID、ticker至少选择一个
    :param beginDate: 起始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktFundd.csv?ispandas=1&') 
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("tradeDate=%s"%(tradeDate))
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 89)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 89)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'exchangeCD', u'secShortName', u'tradeDate', u'preClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'CHG', u'CHGPct', u'turnoverVol', u'turnoverValue', u'discount', u'discountRatio', u'circulationShares', u'accumAdjFactor']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','exchangeCD': 'str','secShortName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktFutMTRGet(beginDate = "", endDate = "", secID = "", ticker = "", field = "", pandas = "1"):
    """
    获取期货会员在各交易日期货合约的成交量、成交排名及成交量增减信息，每日18:00前更新。
    
    :param beginDate: 根据交易日期范围查询的起始日期，默认为一年前。输入格式“YYYYMMDD”,可空
    :param endDate: 根据交易日期范围查询的截止日期，默认为当前日期。输入格式“YYYYMMDD”,可空
    :param secID: 通联编制的证券编码，格式是“交易代码.证券市场代码”，如000001.XSHE。 可传入证券交易代码使用DataAPI.SecIDGet接口获取到。,可以是列表,可空
    :param ticker: 证券在证券市场通用的交易代码。,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktFutMTR.csv?ispandas=1&') 
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 88)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 88)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'partyShortName', u'exchangeCD', u'tradeDate', u'turnoverVol', u'CHG', u'rank']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','partyShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktFutMSRGet(secID = "", ticker = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取期货会员在各交易日期货合约的空头持仓、排名及空头持仓增减信息，每日18:00前更新。
    
    :param secID: 通联编制的证券编码，格式是“交易代码.证券市场代码”，如000001.XSHE。 可传入证券交易代码使用DataAPI.SecIDGet接口获取到。,可以是列表,secID、ticker至少选择一个
    :param ticker: 期货合约代码，如'SR501',可以是列表,secID、ticker至少选择一个
    :param beginDate: 起始日期，默认为一年前当前日期，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，默认为当前日期，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktFutMSR.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 87)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 87)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'partyShortName', u'exchangeCD', u'tradeDate', u'shortVol', u'CHG', u'rank']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','partyShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktFutMLRGet(secID = "", ticker = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取期货会员在各交易日期货合约的多头持仓、排名及多头持仓增减信息，每日18:00前更新。
    
    :param secID: 通联编制的证券编码，格式是“交易代码.证券市场代码”，如000001.XSHE。 可传入证券交易代码使用DataAPI.SecIDGet接口获取到。,可以是列表,secID、ticker至少选择一个
    :param ticker: 期货合约代码，如'cu1501',可以是列表,secID、ticker至少选择一个
    :param beginDate: 起始日期，默认为一年前当前日期，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，默认为当前日期，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktFutMLR.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 86)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 86)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'partyShortName', u'exchangeCD', u'tradeDate', u'longVol', u'CHG', u'rank']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','partyShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktFutWRdGet(beginDate, endDate, contractObject = "", exchangeCD = "", field = "", pandas = "1"):
    """
    获取期货仓单日报情况，包括品种代码、交易市场、仓库、上期仓单量、本期仓单量等字段，每日16:00更新
    
    :param beginDate: 起始日期，默认为一周前，输入格式“YYYYMMDD”
    :param endDate: 截止日期，默认为当前日期，输入格式“YYYYMMDD”
    :param contractObject: 品种代码,可以是列表,可空
    :param exchangeCD: 通联编制的证券市场编码。例如，XSHG-上海证券交易所；XSHE-深圳证券交易所；XIBE-中国银行间市场等。对应DataAPI.SysCodeGet.codeTypeID=10002。,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktFutWRd.csv?ispandas=1&') 
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&contractObject=")
    if hasattr(contractObject,'__iter__') and not isinstance(contractObject, str):
        if len(contractObject) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = contractObject
            requestString.append(None)
        else:
            requestString.append(','.join(contractObject))
    else:
        requestString.append(contractObject)
    requestString.append("&exchangeCD=")
    if hasattr(exchangeCD,'__iter__') and not isinstance(exchangeCD, str):
        if len(exchangeCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = exchangeCD
            requestString.append(None)
        else:
            requestString.append(','.join(exchangeCD))
    else:
        requestString.append(exchangeCD)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1592)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1592)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'tradeDate', u'contractObject', u'exchangeCD', u'unit', u'warehouse', u'preWrVOL', u'wrVOL', u'chg']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'contractObject': 'str','exchangeCD': 'str','unit': 'str','warehouse': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktMFutdGet(tradeDate = "", mainCon = "", contractMark = "", contractObject = "", startDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取四大期货交易所日行情信息，包括开高低收、成交量、成交金额、持仓量、结算价、主力合约标记等信息， 其中主力合约按持仓量计算，每日16:00更新。
    
    :param tradeDate: 输入一个日期，不输入其他请求参数，可获取到一天全部期货合约日行情数据，输入格式“YYYYMMDD”,tradeDate、mainCon、contractMark、contractObject至少选择一个
    :param mainCon: 1为主力合约，0为非主力合约,tradeDate、mainCon、contractMark、contractObject至少选择一个
    :param contractMark: 商品期货：L0-即将进入交割的合约L1-连一合约（连续合约）L2-连二合约L3-连三合约L4-连四合约金融期货（四个合约）：L0-当月连续L1-下月连续L3-当季连续L6-下季连续金融期货（三个合约）：L3-当季连续L6-下季连续L9-隔季连续,tradeDate、mainCon、contractMark、contractObject至少选择一个
    :param contractObject: 期货合约标的。例如，CU-阴极铜，AU-黄金。对应DataAPI.SysCodeGet.codeTypeID=60003。,tradeDate、mainCon、contractMark、contractObject至少选择一个
    :param startDate: 起始日期，输入格式为yyyymmdd,可空
    :param endDate: 结束日期，输入格式为yyyymmdd,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktMFutd.csv?ispandas=1&') 
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("tradeDate=%s"%(tradeDate))
    if not isinstance(mainCon, str) and not isinstance(mainCon, unicode):
        mainCon = str(mainCon)

    requestString.append("&mainCon=%s"%(mainCon))
    if not isinstance(contractMark, str) and not isinstance(contractMark, unicode):
        contractMark = str(contractMark)

    requestString.append("&contractMark=%s"%(contractMark))
    if not isinstance(contractObject, str) and not isinstance(contractObject, unicode):
        contractObject = str(contractObject)

    requestString.append("&contractObject=%s"%(contractObject))
    try:
        startDate = startDate.strftime('%Y%m%d')
    except:
        startDate = startDate.replace('-', '')
    requestString.append("&startDate=%s"%(startDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1282)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1282)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'exchangeCD', u'secShortName', u'secShortNameEN', u'tradeDate', u'contractObject', u'contractMark', u'preSettlePrice', u'preClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'settlePrice', u'closePrice', u'turnoverVol', u'turnoverValue', u'openInt', u'chg', u'chg1', u'chgPct', u'mainCon', u'smainCon']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','exchangeCD': 'str','secShortName': 'str','secShortNameEN': 'str','contractObject': 'str','contractMark': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktOptdGet(tradeDate = "", secID = "", optID = "", ticker = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    主要记录上交所期权行情，包含昨结算、昨收盘、开盘价、最高价、最低价、收盘价、结算价、成交量、成交金额、持仓量等字段，每日16:00前更新。
    
    :param tradeDate: 输入一个日期，不输入其他请求参数，可获取到一天全部期权日行情数据，输入格式“YYYYMMDD”,tradeDate、secID、optID、ticker至少选择一个
    :param secID: 通联编制的证券编码，格式是“交易代码.证券市场代码”，如000001.XSHE。 可传入证券交易代码使用DataAPI.SecIDGet接口获取到。,tradeDate、secID、optID、ticker至少选择一个
    :param optID: 交易所指定8位代码,tradeDate、secID、optID、ticker至少选择一个
    :param ticker: 合约交易代码,tradeDate、secID、optID、ticker至少选择一个
    :param beginDate: 起始日期，输入格式为yyyymmdd,可空
    :param endDate: 结束日期，输入格式为yyyymmdd,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktOptd.csv?ispandas=1&') 
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("tradeDate=%s"%(tradeDate))
    if not isinstance(secID, str) and not isinstance(secID, unicode):
        secID = str(secID)

    requestString.append("&secID=%s"%(secID))
    if not isinstance(optID, str) and not isinstance(optID, unicode):
        optID = str(optID)

    requestString.append("&optID=%s"%(optID))
    if not isinstance(ticker, str) and not isinstance(ticker, unicode):
        ticker = str(ticker)

    requestString.append("&ticker=%s"%(ticker))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1292)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1292)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'optID', u'ticker', u'secShortName', u'exchangeCD', u'tradeDate', u'preSettlePrice', u'preClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'settlPrice', u'turnoverVol', u'turnoverValue', u'openInt']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','optID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktEqudAdjGet(tradeDate = "", secID = "", ticker = "", isOpen = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取沪深A股和B股前复权日行情信息，包含前复权昨收价、前复权开盘价、前复权最高价、前复权最低价、前复权收盘价。
    
    :param tradeDate: 交易日。输入格式“YYYYMMDD”,tradeDate、secID、ticker至少选择一个
    :param secID: 通联编制的证券编码，格式是“交易代码.证券市场代码”，如000001.XSHE。 可传入证券交易代码使用DataAPI.SecIDGet接口获取到。,可以是列表,tradeDate、secID、ticker至少选择一个
    :param ticker: 输入股票代码，如000001。,可以是列表,tradeDate、secID、ticker至少选择一个
    :param isOpen: 股票今日是否开盘标记位：0-今日未开盘，1-今日有开盘,可空
    :param beginDate: 开始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 结束日期，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktEqudAdj.csv?ispandas=1&') 
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("tradeDate=%s"%(tradeDate))
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    if not isinstance(isOpen, str) and not isinstance(isOpen, unicode):
        isOpen = str(isOpen)

    requestString.append("&isOpen=%s"%(isOpen))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1290)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1290)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'tradeDate', u'preClosePrice', u'actPreClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'negMarketValue', u'dealAmount', u'turnoverRate', u'accumAdjFactor', u'turnoverValue', u'marketValue', u'isOpen']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktAdjfGet(exDivDate = "", secID = "", ticker = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取沪深A股和B股用来调整行情的前复权因子数据，包含除权除息日、除权除息事项具体数据、本次复权因子、累积复权因子以及因子调整的截止日期。该因子用来调整历史行情，不作为预测使用，于除权除息日进行计算调整。
    
    :param exDivDate: 除权除息日，输入格式：YYYYMMDD,exDivDate、secID、ticker至少选择一个
    :param secID: 通联编制的证券编码，格式是“交易代码.证券市场代码”，如000001.XSHE。 可传入证券交易代码使用DataAPI.SecIDGet接口获取到。,可以是列表,exDivDate、secID、ticker至少选择一个
    :param ticker: 一只或多只股票代码，用,分隔，如000001,000002。,可以是列表,exDivDate、secID、ticker至少选择一个
    :param beginDate: 除权除息日查询为基准，查询开始日期,输入格式"YYYYMMDD",可空
    :param endDate: 除权除息日查询为基准，查询截止日期,输入格式"YYYYMMDD",可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktAdjf.csv?ispandas=1&') 
    try:
        exDivDate = exDivDate.strftime('%Y%m%d')
    except:
        exDivDate = exDivDate.replace('-', '')
    requestString.append("exDivDate=%s"%(exDivDate))
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1291)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1291)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'exchangeCD', u'secShortName', u'secShortNameEn', u'exDivDate', u'perCashDiv', u'perShareDivRatio', u'perShareTransRatio', u'allotmentRatio', u'allotmentPrice', u'adjFactor', u'accumAdjFactor', u'endDate']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','exchangeCD': 'str','secShortName': 'str','secShortNameEn': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktOptionTickRTSnapshotGet(optionId = "", field = "", pandas = "1"):
    """
    高频数据，获取期权最新市场信息快照
    
    :param optionId: 期权代码，如果为空，返回当前所有期权,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getOptionTickRTSnapshot.csv?ispandas=1&') 
    requestString.append("optionId=")
    if hasattr(optionId,'__iter__') and not isinstance(optionId, str):
        if len(optionId) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = optionId
            requestString.append(None)
        else:
            requestString.append(','.join(optionId))
    else:
        requestString.append(optionId)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'preClosePrice', u'dealAmount', u'timestamp', u'dataDate', u'dataTime', u'optionId', u'instrumentID', u'preSettlePrice', u'settlePrice', u'openPrice', u'volume', u'value', u'highPrice', u'lowPrice', u'lastPrice', u'bidBook_price1', u'bidBook_volume1', u'bidBook_price2', u'bidBook_volume2', u'bidBook_price3', u'bidBook_volume3', u'bidBook_price4', u'bidBook_volume4', u'bidBook_price5', u'bidBook_volume5', u'askBook_price1', u'askBook_volume1', u'askBook_price2', u'askBook_volume2', u'askBook_price3', u'askBook_volume3', u'askBook_price4', u'askBook_volume4', u'askBook_price5', u'askBook_volume5', u'auctionPrice', u'auctionQty', u'totalLongPosition', u'origTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'dataDate': 'str','dataTime': 'str','optionId': 'str','instrumentID': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def OptionTicksHistOneDayGet(optionId, date, startSecOffset = "", endSecOffset = "", field = "", pandas = "1"):
    """
    高频数据，获取一只期权在历史上某一交易日内的Tick数据
    
    :param optionId: 期权代码
    :param date: 数据日期。格式是YYYYMMDD，如20130729，2013年7月29日。
    :param startSecOffset: 开始时间，相对8点的秒偏移量（>=0），若空，则表示开市时间。,可空
    :param endSecOffset: 结束时间，相对8点的秒偏移量(>=0)，若空，则表示闭市时间。,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getOptionTicksHistOneDay.csv?ispandas=1&') 
    if not isinstance(optionId, str) and not isinstance(optionId, unicode):
        optionId = str(optionId)

    requestString.append("optionId=%s"%(optionId))
    if not isinstance(date, str) and not isinstance(date, unicode):
        date = str(date)

    requestString.append("&date=%s"%(date))
    if not isinstance(startSecOffset, str) and not isinstance(startSecOffset, unicode):
        startSecOffset = str(startSecOffset)

    requestString.append("&startSecOffset=%s"%(startSecOffset))
    if not isinstance(endSecOffset, str) and not isinstance(endSecOffset, unicode):
        endSecOffset = str(endSecOffset)

    requestString.append("&endSecOffset=%s"%(endSecOffset))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'dataDate', u'dataTime', u'dataTimeMs', u'optionId', u'upTime', u'localTime', u'exchangeCD', u'secOffset', u'preSettlePrice', u'preClosePrice', u'settlePrice', u'openPrice', u'volume', u'value', u'dealAmount', u'highPrice', u'lowPrice', u'lastPrice', u'bidPrice1', u'bidVolume1', u'bidPrice2', u'bidVolume2', u'bidPrice3', u'bidVolume3', u'bidPrice4', u'bidVolume4', u'bidPrice5', u'bidVolume5', u'askPrice1', u'askVolume1', u'askPrice2', u'askVolume2', u'askPrice3', u'askVolume3', u'askPrice4', u'askVolume4', u'askPrice5', u'askVolume5', u'auctionPrice', u'auctionQty', u'origTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'dataTime': 'str','optionId': 'str','localTime': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktFutureBarRTIntraDayGet(instrumentID, startTime = "", endTime = "", unit = "", field = "", pandas = "1"):
    """
    高频数据，获取当日期货分钟线，包含1/5/15/30/60分钟的分钟线。分钟线的有效数据从夜盘开始到日线结束，分钟线的计算规则为分钟内前开后闭，向后归结，即（9:31:00.000，9:32:00.000]归为9:32分的数据，第一根分钟线包含时间范围为集合竞价开始到连续竞价开始
    
    :param instrumentID: 期货在证券市场通用的交易代码。
    :param startTime: 根据bar的时间范围查询的开始时间，默认是前一天的20:00（前一天夜盘开始时间）。格式"hh:mm"。,可空
    :param endTime: 根据bar的时间范围查询的结束时间，默认是当前时间。格式"hh:mm"。,可空
    :param unit: Bar(s)的时间宽度，单位分钟。取值范围： 1（分钟）/ 3（分钟）/5（分钟）/15（分钟）/30（分钟）/60（分钟）,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getFutureBarRTIntraDay.csv?ispandas=1&') 
    if not isinstance(instrumentID, str) and not isinstance(instrumentID, unicode):
        instrumentID = str(instrumentID)

    requestString.append("instrumentID=%s"%(instrumentID))
    if not isinstance(startTime, str) and not isinstance(startTime, unicode):
        startTime = str(startTime)

    requestString.append("&startTime=%s"%(startTime))
    if not isinstance(endTime, str) and not isinstance(endTime, unicode):
        endTime = str(endTime)

    requestString.append("&endTime=%s"%(endTime))
    if not isinstance(unit, str) and not isinstance(unit, unicode):
        unit = str(unit)

    requestString.append("&unit=%s"%(unit))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'unit', u'instrumentID', u'exchangeCD', u'utcOffset', u'currencyCD', u'barTime', u'closePrice', u'openPrice', u'highPrice', u'lowPrice', u'totalVolume', u'totalValue']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'instrumentID': 'str','exchangeCD': 'str','utcOffset': 'str','currencyCD': 'str','barTime': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktFutureBarHistOneDayGet(instrumentID, date, unit = "", field = "", pandas = "1"):
    """
    高频数据，获取一只或者多只期货在历史某一清算日的分钟线数据，包含1/3/5/15/30/60分钟的分钟线。分钟线的有效数据从夜盘开始到日线结束，分钟线的计算规则为分钟内前开后闭，向后归结，即（9:31:00.000，9:32:00.000]归为9:32分的数据，第一根分钟线包含时间范围为集合竞价开始到连续竞价开始
    
    :param instrumentID: 期货代码，支持多值输入,可以是列表
    :param date: 查询日期，以清算日为准，例如20140210，会返回20140209的夜盘和20140210的日盘
    :param unit: Bar(s)的时间宽度，单位分钟，如 1（分钟）/3(分钟)/5（分钟）/15（分钟）/30（分钟）/60（分钟）,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getFutureBarHistOneDay.csv?ispandas=1&') 
    requestString.append("instrumentID=")
    if hasattr(instrumentID,'__iter__') and not isinstance(instrumentID, str):
        if len(instrumentID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = instrumentID
            requestString.append(None)
        else:
            requestString.append(','.join(instrumentID))
    else:
        requestString.append(instrumentID)
    if not isinstance(date, str) and not isinstance(date, unicode):
        date = str(date)

    requestString.append("&date=%s"%(date))
    if not isinstance(unit, str) and not isinstance(unit, unicode):
        unit = str(unit)

    requestString.append("&unit=%s"%(unit))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'unit', u'instrumentID', u'exchangeCD', u'currencyCD', u'barTime', u'dataDate', u'clearingDay', u'closePrice', u'openPrice', u'highPrice', u'lowPrice', u'totalVolume', u'totalValue', u'openInterest']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'instrumentID': 'str','exchangeCD': 'str','currencyCD': 'str','barTime': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktFutureBarHistDateRangeGet(instrumentID, startDate, endDate, unit = "", field = "", pandas = "1"):
    """
    高频数据，获取一只期货在历史某个日期段内的分钟线数据，包含1/3/5/15/30/60分钟的分钟线。不支持跨月查询：开始日期和结束日期必须在同一个月内。分钟线的有效数据从夜盘开始到日线结束，分钟线的计算规则为分钟内前开后闭，向后归结，即（9:31:00.000，9:32:00.000]归为9:32分的数据，第一根分钟线包含时间范围为集合竞价开始到连续竞价开始
    
    :param instrumentID: 期货代码，仅支持单值输入
    :param startDate: 起始日期，需与结束日期在同一个月
    :param endDate: 结束日期，需与起始日期在同一个月
    :param unit: Bar(s)的时间宽度，单位分钟，如 1（分钟）/3(分钟)/5（分钟）/15（分钟）/30（分钟）/60（分钟）,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getFutureBarHistDateRange.csv?ispandas=1&') 
    if not isinstance(instrumentID, str) and not isinstance(instrumentID, unicode):
        instrumentID = str(instrumentID)

    requestString.append("instrumentID=%s"%(instrumentID))
    if not isinstance(startDate, str) and not isinstance(startDate, unicode):
        startDate = str(startDate)

    requestString.append("&startDate=%s"%(startDate))
    if not isinstance(endDate, str) and not isinstance(endDate, unicode):
        endDate = str(endDate)

    requestString.append("&endDate=%s"%(endDate))
    if not isinstance(unit, str) and not isinstance(unit, unicode):
        unit = str(unit)

    requestString.append("&unit=%s"%(unit))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'openInterest', u'unit', u'instrumentID', u'exchangeCD', u'currencyCD', u'barTime', u'closePrice', u'openPrice', u'highPrice', u'lowPrice', u'totalVolume', u'totalValue', u'dataDate', u'clearingDay']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'instrumentID': 'str','exchangeCD': 'str','currencyCD': 'str','barTime': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktFutdVolGet(secID = "", ticker = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取四大期货交易所日行情信息，包括开高低收、成交量、成交金额、持仓量、结算价、主力合约标记等信息， 其中主力合约按成交量计算，每日17:00更新。
    
    :param secID: 合约内部编码，可传入证券交易代码使用DataAPI.SecIDGet接口获取到。,可以是列表,secID、ticker至少选择一个
    :param ticker: 合约内部编码，可传入证券交易代码使用DataAPI.SecIDGet接口获取到。,可以是列表,secID、ticker至少选择一个
    :param beginDate: 起始日期，默认为一年前当前日期，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，默认为当前日期，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktFutdVol.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1321)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1321)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'exchangeCD', u'secShortName', u'tradeDate', u'contractObject', u'contractMark', u'preSettlePrice', u'preClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'settlePrice', u'turnoverVol', u'turnoverValue', u'openInt', u'CHG', u'CHG1', u'CHGPct', u'mainCon', u'smainCon']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','exchangeCD': 'str','secShortName': 'str','contractObject': 'str','contractMark': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FutureL1TransactionOneClearingDayGet(instrumentID, date, field = "", pandas = "1"):
    """
    高频数据，获取一只期货，在历史上某一清算日的分笔成交
    
    :param instrumentID: 一个期货合约代码，如A1009（大小写均可）;也可以是期货合约类型，如A，此时表示查主力合约。
    :param date: 日期，格式如20130719，注意这里表示的是清算日
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getFutureL1TransactionOneClearingDay.csv?ispandas=1&') 
    if not isinstance(instrumentID, str) and not isinstance(instrumentID, unicode):
        instrumentID = str(instrumentID)

    requestString.append("instrumentID=%s"%(instrumentID))
    if not isinstance(date, str) and not isinstance(date, unicode):
        date = str(date)

    requestString.append("&date=%s"%(date))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'dataDate', u'dataTime', u'dataMillisec', u'instrumentID', u'exchangeCD', u'volume', u'lastPrice', u'clearingDay', u'intsCHG', u'side', u'type']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'dataTime': 'str','instrumentID': 'str','exchangeCD': 'str','side': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktEqudLatelyGet(secID = "", ticker = "", field = "", pandas = "1"):
    """
    获取沪深股票个股最近一次日行情，当日数据更新返回当日数据，当日数据为更新之前返回上一个交易日数据，包含昨收价、开盘价、最高价、最低价、收盘价、成交量、成交金额等字段，每日16:30更新。
    
    :param secID: 通联编制的证券编码，格式是“交易代码.证券市场代码”，如000001.XSHE。 可传入证券交易代码使用DataAPI.SecIDGet接口获取到。,可以是列表,可空
    :param ticker: 股票交易代码，如'000001'（可多值输入）,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktEqudLately.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1327)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1327)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'tradeDate', u'preClosePrice', u'actPreClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'turnoverValue', u'dealAmount', u'turnoverRate', u'accumAdjFactor', u'exDivDate', u'negMarketValue', u'marketValue']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktLimitGet(exchangeCD = "", secID = "", ticker = "", tradeDate = "", field = "", pandas = "1"):
    """
    主要记录盘前每日个股及基金涨跌停板价格，每日9:00更新
    
    :param exchangeCD: 通联编制的证券市场编码。例如，XSHG-上海证券交易所；XSHE-深圳证券交易所；XIBE-中国银行间市场等。对应DataAPI.SysCodeGet.codeTypeID=10002。,可以是列表,exchangeCD、secID、ticker、tradeDate至少选择一个
    :param secID: 通联编制的证券编码，格式是“交易代码.证券市场代码”，如000001.XSHE。 可传入证券交易代码使用DataAPI.SecIDGet接口获取到。,可以是列表,exchangeCD、secID、ticker、tradeDate至少选择一个
    :param ticker: 证券交易代码,可以是列表,exchangeCD、secID、ticker、tradeDate至少选择一个
    :param tradeDate: 交易日，输入格式YYYYMMDD,exchangeCD、secID、ticker、tradeDate至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktLimit.csv?ispandas=1&') 
    requestString.append("exchangeCD=")
    if hasattr(exchangeCD,'__iter__') and not isinstance(exchangeCD, str):
        if len(exchangeCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = exchangeCD
            requestString.append(None)
        else:
            requestString.append(','.join(exchangeCD))
    else:
        requestString.append(exchangeCD)
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("&tradeDate=%s"%(tradeDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1357)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1357)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'secShortNameEn', u'exchangeCD', u'tradeDate', u'limitUpPrice', u'limitDownPrice', u'upLimitReachedTimes', u'downLimitReachedTimes']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','secShortNameEn': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def SecTipsGet(tipsTypeCD = "", tipsType = "", field = "", pandas = "1"):
    """
    上海证券交易所、深圳证券交易所今日停复牌股票列表。数据更新频率：日。
    
    :param tipsTypeCD: 交易提示类型。H-停牌，R-复牌,可空
    :param tipsType: 交易提示类型中文，可输入中文：“停牌”；“复牌”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getSecTips.csv?ispandas=1&') 
    if not isinstance(tipsTypeCD, str) and not isinstance(tipsTypeCD, unicode):
        tipsTypeCD = str(tipsTypeCD)

    requestString.append("tipsTypeCD=%s"%(tipsTypeCD))
    if not isinstance(tipsType, str) and not isinstance(tipsType, unicode):
        tipsType = str(tipsType)

    requestString.append("&tipsType=%s"%(tipsType))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1367)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1367)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'exchangeCD', u'secShortName', u'tipsDesc', u'tipsTypeCD', u'tipsType']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','exchangeCD': 'str','secShortName': 'str','tipsDesc': 'str','tipsTypeCD': 'str','tipsType': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def BarRTIntraDayOneMinuteGet(time, unit = "", exchangeCD = "", assetClass = "", field = "", pandas = "1"):
    """
    高频数据，获取当日所有股票某一分钟的分钟线，包含1/5/15/30/60分钟的分钟线。分钟线的有效数据上午从09：30 到11：30，下午从13：01到15：00，分钟线的计算规则为分钟内前开后闭，向后归结，即（9:31:00.000，9:32:00.000]归为9:32分的数据，9:30的分钟线包含时间范围为9:30:00前所有成交（即集合竞价成交）
    
    :param time: 查询时间，如09:33
    :param unit: Bar(s)的时间宽度，单位分钟。取值范围： 1（分钟）/ 3（分钟）/5（分钟）/15（分钟）/30（分钟）/60（分钟）,可空
    :param exchangeCD: 通联编制的证券市场编码。例如，XSHG-上海证券交易所；XSHE-深圳证券交易所；XIBE-中国银行间市场等。对应DataAPI.SysCodeGet.codeTypeID=10002。,可空
    :param assetClass: 通联编制的证券类别编码。例如，E-股票；B-债券；F-基金；FU-期货等。对应DataAPI.SysCodeGet.codeTypeID=10001。,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getBarRTIntraDayOneMinute.csv?ispandas=1&') 
    if not isinstance(time, str) and not isinstance(time, unicode):
        time = str(time)

    requestString.append("time=%s"%(time))
    if not isinstance(unit, str) and not isinstance(unit, unicode):
        unit = str(unit)

    requestString.append("&unit=%s"%(unit))
    if not isinstance(exchangeCD, str) and not isinstance(exchangeCD, unicode):
        exchangeCD = str(exchangeCD)

    requestString.append("&exchangeCD=%s"%(exchangeCD))
    if not isinstance(assetClass, str) and not isinstance(assetClass, unicode):
        assetClass = str(assetClass)

    requestString.append("&assetClass=%s"%(assetClass))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'unit', u'ticker', u'exchangeCD', u'shortNM', u'utcOffset', u'currencyCD', u'barTime', u'closePrice', u'openPrice', u'highPrice', u'lowPrice', u'totalVolume', u'totalValue']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'ticker': 'str','exchangeCD': 'str','shortNM': 'str','utcOffset': 'str','currencyCD': 'str','barTime': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def EquRTRankGet(exchangeCD = "", desc = "", field = "", pandas = "1"):
    """
    获取沪深股票涨跌幅排行
    
    :param exchangeCD: 通联编制的证券市场编码。例如，XSHG-上海证券交易所；XSHE-深圳证券交易所；XIBE-中国银行间市场等。对应DataAPI.SysCodeGet.codeTypeID=10002。,可空
    :param desc: 是否是跌幅排行；不输入返回涨幅排行；输入1返回跌幅排行,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getEquRTRank.csv?ispandas=1&') 
    if not isinstance(exchangeCD, str) and not isinstance(exchangeCD, unicode):
        exchangeCD = str(exchangeCD)

    requestString.append("exchangeCD=%s"%(exchangeCD))
    if not isinstance(desc, str) and not isinstance(desc, unicode):
        desc = str(desc)

    requestString.append("&desc=%s"%(desc))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1369)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1369)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'dataTime', u'ticker', u'exchangeCD', u'shortNM', u'prevClosePrice', u'openPrice', u'volume', u'value', u'deal', u'highPrice', u'lowPrice', u'lastPrice', u'change', u'changePct']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'dataTime': 'str','ticker': 'str','exchangeCD': 'str','shortNM': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def SWIndustryRTRankGet(desc = "", field = "", pandas = "1"):
    """
    获取申万行业涨跌幅排行
    
    :param desc: 是否是跌幅排行；不输入返回涨幅排行；输入1返回跌幅排行,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getSWIndustryRTRank.csv?ispandas=1&') 
    if not isinstance(desc, str) and not isinstance(desc, unicode):
        desc = str(desc)

    requestString.append("desc=%s"%(desc))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'dataTime', u'ticker', u'exchangeCD', u'shortNM', u'prevClosePrice', u'openPrice', u'volume', u'value', u'deal', u'highPrice', u'lowPrice', u'lastPrice', u'change', u'changePct', u'bidAskRatio', u'upNum', u'flatNum', u'downNum', u'totalAskVolume', u'totalBidVolume']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'dataTime': 'str','ticker': 'str','exchangeCD': 'str','shortNM': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def IndustryTickRTSnapshotGet(securityID = "", field = "", pandas = "1"):
    """
    获取行业（证监会行业标准）资金流向，内容包括小单，中单，大单，超大单的资金流入，流出，净流入等。
    
    :param securityID: 证监会行业分类标准的二级行业ID，用“,”分隔，为空返回所有行业，可以使用getIndustry接口获取所有ID，industryVersionCD=010301，industryLevel=2。,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getIndustryTickRTSnapshot.csv?ispandas=1&') 
    requestString.append("securityID=")
    if hasattr(securityID,'__iter__') and not isinstance(securityID, str):
        if len(securityID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = securityID
            requestString.append(None)
        else:
            requestString.append(','.join(securityID))
    else:
        requestString.append(securityID)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'inflowS', u'inflowM', u'inflowL', u'inflowXL', u'outflowS', u'outflowM', u'outflowL', u'outflowXL', u'netInflowS', u'netInflowM', u'netInflowL', u'netInflowXL', u'type', u'dataDate', u'dataTime', u'shortNM']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'type': 'str','dataDate': 'str','dataTime': 'str','shortNM': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktQuoteInfoGet(secID = "", ticker = "", exchangeCD = "", field = "", pandas = "1"):
    """
    记录沪深交易所行情报价要素，包含最小申报数量、申报价格最小变动单位
    
    :param secID: 证券ID，通联给证券赋予的编码，可通过交易代码等在DataAPI.SecIDGet获取到。,可以是列表,secID、ticker、exchangeCD至少选择一个
    :param ticker: 交易代码,可以是列表,secID、ticker、exchangeCD至少选择一个
    :param exchangeCD: 交易市场。例如，XSHG-上海证券交易所；XSHE-深圳证券交易所。对应DataAPI.SysCodeGet.codeTypeID=10002。,可以是列表,secID、ticker、exchangeCD至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktQuoteInfo.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&exchangeCD=")
    if hasattr(exchangeCD,'__iter__') and not isinstance(exchangeCD, str):
        if len(exchangeCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = exchangeCD
            requestString.append(None)
        else:
            requestString.append(','.join(exchangeCD))
    else:
        requestString.append(exchangeCD)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'exchangeCD', u'secShortName', u'quoteVolMin', u'quoteVolMinUnit', u'quotePriceMin', u'quotePriceMinUnit', u'transCurrCD']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','exchangeCD': 'str','secShortName': 'str','quoteVolMin': 'str','quoteVolMinUnit': 'str','quotePriceMin': 'str','quotePriceMinUnit': 'str','transCurrCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HSIIdMapGet(field = "", pandas = "1"):
    """
    
    
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getHSIIdMap.csv?ispandas=1&') 
    requestString.append("field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'exCountryCD', u'ticker', u'secShortName', u'exchangeCD', u'secFullName', u'srcName', u'srcFullName']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','exCountryCD': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str','secFullName': 'str','srcFullName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktFunddAdjGet(secID = "", ticker = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    主要记录基金每日后复权行情，包括开高低收、成交量、成交价格等
    
    :param secID: 证券内部编码,可以是列表,secID、ticker至少选择一个
    :param ticker: 证券交易代码,可以是列表,secID、ticker至少选择一个
    :param beginDate: 起始日期,可空
    :param endDate: 结束日期,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktFunddAdj.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1489)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1489)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'secShortName', u'secShortNameEn', u'ticker', u'exchangeCD', u'tradeDate', u'preClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'turnoverValue']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','secShortName': 'str','secShortNameEn': 'str','ticker': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def OptionBarRTIntraDayGet(optionId, startTime = "", endTime = "", unit = "", field = "", pandas = "1"):
    """
    高频数据，获取当日期权分钟线。分钟线的有效数据上午从09：30 到11：30，下午从13：01到15：00，分钟线的计算规则为分钟内前开后闭，向后归结，即（9:31:00.000，9:32:00.000]归为9:32分的数据，9:30的分钟线包含时间范围为9:30:00前所有成交（即集合竞价成交）
    
    :param optionId: 期权代码
    :param startTime: 开始时间，如果为空则是前一天的20:00（前一天夜盘开始时间）,可空
    :param endTime: 结束时间，例如14:20，如果为空则是当前时间,可空
    :param unit: Bar(s)的时间宽度，单位分钟，仅包含1分钟,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getOptionBarRTIntraDay.csv?ispandas=1&') 
    if not isinstance(optionId, str) and not isinstance(optionId, unicode):
        optionId = str(optionId)

    requestString.append("optionId=%s"%(optionId))
    if not isinstance(startTime, str) and not isinstance(startTime, unicode):
        startTime = str(startTime)

    requestString.append("&startTime=%s"%(startTime))
    if not isinstance(endTime, str) and not isinstance(endTime, unicode):
        endTime = str(endTime)

    requestString.append("&endTime=%s"%(endTime))
    if not isinstance(unit, str) and not isinstance(unit, unicode):
        unit = str(unit)

    requestString.append("&unit=%s"%(unit))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'unit', u'optionId', u'exchangeCD', u'utcOffset', u'currencyCD', u'barTime', u'closePrice', u'openPrice', u'highPrice', u'lowPrice', u'totalVolume', u'totalValue']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'optionId': 'str','exchangeCD': 'str','utcOffset': 'str','currencyCD': 'str','barTime': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def OptionBarHistOneDayGet(optionId, date, field = "", pandas = "1"):
    """
    高频数据，获取一只或者多只期权在历史某一日的分钟线数据。分钟线的有效数据上午从09：30 到11：30，下午从13：01到15：00，分钟线的计算规则为分钟内前开后闭，向后归结，即（9:31:00.000，9:32:00.000]归为9:32分的数据，9:30的分钟线包含时间范围为9:30:00前所有成交（即集合竞价成交）
    
    :param optionId: 期货代码，支持多值输入,可以是列表
    :param date: 查询日期，以清算日为准，例如20140210，会返回20140209的夜盘和20140210的日盘
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getOptionBarHistOneDay.csv?ispandas=1&') 
    requestString.append("optionId=")
    if hasattr(optionId,'__iter__') and not isinstance(optionId, str):
        if len(optionId) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = optionId
            requestString.append(None)
        else:
            requestString.append(','.join(optionId))
    else:
        requestString.append(optionId)
    if not isinstance(date, str) and not isinstance(date, unicode):
        date = str(date)

    requestString.append("&date=%s"%(date))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'unit', u'optionId', u'exchangeCD', u'currencyCD', u'barTime', u'dataDate', u'closePrice', u'openPrice', u'highPrice', u'lowPrice', u'totalVolume', u'totalValue', u'totalLongPosition']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'optionId': 'str','exchangeCD': 'str','currencyCD': 'str','barTime': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def OptionBarHistDateRangeGet(optionId, startDate, endDate, field = "", pandas = "1"):
    """
    高频数据，获取一只期权在历史某个日期段内的分钟线数据。分钟线的有效数据上午从09：30 到11：30，下午从13：01到15：00，分钟线的计算规则为分钟内前开后闭，向后归结，即（9:31:00.000，9:32:00.000]归为9:32分的数据，9:30的分钟线包含时间范围为9:30:00前所有成交（即集合竞价成交）
    
    :param optionId: 期权代码
    :param startDate: 起始日期，需与结束日期在同一个月
    :param endDate: 结束日期，需与起始日期在同一个月
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getOptionBarHistDateRange.csv?ispandas=1&') 
    if not isinstance(optionId, str) and not isinstance(optionId, unicode):
        optionId = str(optionId)

    requestString.append("optionId=%s"%(optionId))
    if not isinstance(startDate, str) and not isinstance(startDate, unicode):
        startDate = str(startDate)

    requestString.append("&startDate=%s"%(startDate))
    if not isinstance(endDate, str) and not isinstance(endDate, unicode):
        endDate = str(endDate)

    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'totalLongPosition', u'unit', u'optionId', u'exchangeCD', u'currencyCD', u'barTime', u'closePrice', u'openPrice', u'highPrice', u'lowPrice', u'totalVolume', u'totalValue', u'dataDate']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'optionId': 'str','exchangeCD': 'str','currencyCD': 'str','barTime': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktIdxdLatelyGet(field = "", pandas = "1"):
    """
    主要记录指数基本信息及最新日行情
    
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktIdxdLately.csv?ispandas=1&') 
    requestString.append("field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'tradeDate', u'publishDate', u'secShortName', u'indexTypeCD', u'indexType', u'pubOrgCD', u'porgFullName', u'baseDate', u'basePoint', u'endDate', u'isValid', u'preClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'turnoverValue', u'CHG', u'CHGPct']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','indexTypeCD': 'str','indexType': 'str','porgFullName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktAdjfAf2006Get(secID = "", ticker = "", exchangeCD = "", field = "", pandas = "1"):
    """
    获取沪深A股和B股调整行情的后复权因子数据（以2006-01-01价格为基准），包含除权除息日、除权除息事项具体数据、本次复权因子、累积复权因子以及因子调整的截止日期。该因子用来调整历史行情，不作为预测使用，于除权除息日进行计算调整。
    
    :param secID: 通联编制的证券编码，格式是“交易代码.证券市场代码”，如000001.XSHE。 可传入证券交易代码使用DataAPI.SecIDGet接口获取到。,可以是列表,secID、ticker、exchangeCD至少选择一个
    :param ticker: 一只或多只股票代码，用,分隔，如000001,000002。,可以是列表,secID、ticker、exchangeCD至少选择一个
    :param exchangeCD: 通联编制的证券市场编码。例如，XSHG-上海证券交易所；XSHE-深圳证券交易所；XIBE-中国银行间市场等。对应DataAPI.SysCodeGet.codeTypeID=10002。,可以是列表,secID、ticker、exchangeCD至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktAdjfAf2006.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&exchangeCD=")
    if hasattr(exchangeCD,'__iter__') and not isinstance(exchangeCD, str):
        if len(exchangeCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = exchangeCD
            requestString.append(None)
        else:
            requestString.append(','.join(exchangeCD))
    else:
        requestString.append(exchangeCD)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'exchangeCD', u'secShortName', u'secShortNameEn', u'exDivDate', u'perCashDiv', u'perShareDivRatio', u'perShareTransRatio', u'allotmentRatio', u'allotmentPrice', u'adjFactor', u'accumAdjFactor', u'endDate']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','exchangeCD': 'str','secShortName': 'str','secShortNameEn': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktEqudAdjAf2006Get(secID = "", ticker = "", tradeDate = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取获取沪深A股和B股后复权日行情信息（以2006-01-01价格为基准），包含后复权昨收价、后复权开盘价、后复权最高价、后复权最低价、后复权收盘价，每日收市后更新数据。
    
    :param secID: 通联编制的证券编码，格式是“交易代码.证券市场代码”，如000001.XSHE。 可传入证券交易代码使用DataAPI.SecIDGet接口获取到。,可以是列表,secID、ticker、tradeDate至少选择一个
    :param ticker: 输入股票代码，如000001。,可以是列表,secID、ticker、tradeDate至少选择一个
    :param tradeDate: 输入一个日期，不输入其他请求参数，可获取到一天全部沪深股票复权行情数据，输入格式“YYYYMMDD”,secID、ticker、tradeDate至少选择一个
    :param beginDate: 开始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 结束日期，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktEqudAdjAf2006.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("&tradeDate=%s"%(tradeDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'exchangeCD', u'secShortName', u'secShortNameEn', u'tradeDate', u'preClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','exchangeCD': 'str','secShortName': 'str','secShortNameEn': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktFunddAdjBfGet(secID = "", ticker = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    基金前复权行情，包含前收盘、今开盘、最高价、最低价、收盘价等
    
    :param secID: 证券内部编码,可以是列表,secID、ticker至少选择一个
    :param ticker: 证券代码,可以是列表,secID、ticker至少选择一个
    :param beginDate: 起始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktFunddAdjBf.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1588)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1588)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'secShortNameEn', u'exchangeCD', u'tradeDate', u'preClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'turnoverValue']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','secShortNameEn': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktEquFlowGet(tradeDate = "", secID = "", ticker = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取每日个股资金流向数据，包含个股资金流入、资金流出和资金净流入等
    
    :param tradeDate: 交易日，输入格式“YYYYMMDD”,tradeDate、secID、ticker至少选择一个
    :param secID: 通联编制的证券编码，格式是“交易代码.证券市场代码”，如000001.XSHE。 可传入证券交易代码使用DataAPI.SecIDGet接口获取到。,可以是列表,tradeDate、secID、ticker至少选择一个
    :param ticker: 股票交易代码，如'000001'（可多值输入）,可以是列表,tradeDate、secID、ticker至少选择一个
    :param beginDate: 起始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktEquFlow.csv?ispandas=1&') 
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("tradeDate=%s"%(tradeDate))
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1585)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1585)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'secShortNameEn', u'exchangeCD', u'tradeDate', u'moneyInflow', u'moneyOutflow', u'netMoneyInflow']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','secShortNameEn': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktIndustryFlowGet(industryID = "", tradeDate = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取每日行业资金流向数据，包含行业资金流入、资金流出和资金净流入等，行业分类标准为证监会行业分类标准
    
    :param industryID: 证监会行业分类标准的二级行业ID。 可以使用getIndustry接口获取所有ID，industryVersionCD=010301，industryLevel=2。,可以是列表,industryID、tradeDate至少选择一个
    :param tradeDate: 输入一个日期，不输入其他请求参数，可获取到一天全部行业日资金流向数据，输入格式“YYYYMMDD”,industryID、tradeDate至少选择一个
    :param beginDate: 起始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktIndustryFlow.csv?ispandas=1&') 
    requestString.append("industryID=")
    if hasattr(industryID,'__iter__') and not isinstance(industryID, str):
        if len(industryID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = industryID
            requestString.append(None)
        else:
            requestString.append(','.join(industryID))
    else:
        requestString.append(industryID)
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("&tradeDate=%s"%(tradeDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1586)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1586)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'industryID', u'industryName', u'tradeDate', u'moneyInflow', u'moneyOutflow', u'netMoneyInflow']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'industryID': 'str','industryName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktAdjfAfGet(secID = "", ticker = "", exchangeCD = "", exDivDate = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取沪深A股和B股调整行情的后复权因子数据（以上市价格为基准），包含除权除息日、除权除息事项具体数据、本次复权因子、累积复权因子以及因子调整的截止日期。该因子用来调整历史行情，不作为预测使用，于除权除息日进行计算调整。
    
    :param secID: 通联编制的证券编码，格式是“交易代码.证券市场代码”，如000001.XSHE。 可传入证券交易代码使用DataAPI.SecIDGet接口获取到。,可以是列表,secID、ticker、exchangeCD、exDivDate至少选择一个
    :param ticker: 一只或多只股票代码，用,分隔，如000001,000002。,可以是列表,secID、ticker、exchangeCD、exDivDate至少选择一个
    :param exchangeCD: 通联编制的证券市场编码。例如，XSHG-上海证券交易所；XSHE-深圳证券交易所；XIBE-中国银行间市场等。对应DataAPI.SysCodeGet.codeTypeID=10002。,可以是列表,secID、ticker、exchangeCD、exDivDate至少选择一个
    :param exDivDate: 除权除息日，输入格式：YYYYMMDD,secID、ticker、exchangeCD、exDivDate至少选择一个
    :param beginDate: 除权除息日查询为基准，查询开始日期，输入格式："YYYYMMDD",可空
    :param endDate: 除权除息日查询为基准，查询截止日期，输入格式："YYYYMMDD",可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktAdjfAf.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&exchangeCD=")
    if hasattr(exchangeCD,'__iter__') and not isinstance(exchangeCD, str):
        if len(exchangeCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = exchangeCD
            requestString.append(None)
        else:
            requestString.append(','.join(exchangeCD))
    else:
        requestString.append(exchangeCD)
    try:
        exDivDate = exDivDate.strftime('%Y%m%d')
    except:
        exDivDate = exDivDate.replace('-', '')
    requestString.append("&exDivDate=%s"%(exDivDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1597)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1597)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'exchangeCD', u'secShortName', u'secShortNameEn', u'exDivDate', u'perCashDiv', u'perShareDivRatio', u'perShareTransRatio', u'allotmentRatio', u'allotmentPrice', u'splitsRatio', u'adjFactor', u'accumAdjFactor', u'endDate']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','exchangeCD': 'str','secShortName': 'str','secShortNameEn': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktEqudAdjAfGet(secID = "", ticker = "", tradeDate = "", isOpen = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取获取沪深A股和B股后复权日行情信息（以上市价格为基准），包含后复权昨收价、后复权开盘价、后复权最高价、后复权最低价、后复权收盘价，每日16:00更新。
    
    :param secID: 通联编制的证券编码，格式是“交易代码.证券市场代码”，如000001.XSHE。 可传入证券交易代码使用DataAPI.SecIDGet接口获取到。,可以是列表,secID、ticker、tradeDate至少选择一个
    :param ticker: 输入股票代码，如000001。,可以是列表,secID、ticker、tradeDate至少选择一个
    :param tradeDate: 交易日。输入格式“YYYYMMDD”,secID、ticker、tradeDate至少选择一个
    :param isOpen: 股票今日是否开盘标记位：0-今日未开盘，1-今日有开盘,可空
    :param beginDate: 开始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 结束日期，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktEqudAdjAf.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("&tradeDate=%s"%(tradeDate))
    if not isinstance(isOpen, str) and not isinstance(isOpen, unicode):
        isOpen = str(isOpen)

    requestString.append("&isOpen=%s"%(isOpen))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1598)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1598)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'tradeDate', u'preClosePrice', u'actPreClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'turnoverValue', u'dealAmount', u'turnoverRate', u'accumAdjFactor', u'negMarketValue', u'marketValue', u'isOpen']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktEquFlowOrderGet(secID = "", ticker = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取股票日资金流向按照单类大小明细，包含小单资金流入，小单资金流出，小单资金净流入等，以L2数据计算得出其中单类大小定义为：（单位：元）N：0S:(0,100万]M:(100万,500万]L:(500万,1000万]XL:1000万以上
    
    :param secID: 通联编制的证券编码，格式是“交易代码.证券市场代码”，如000001.XSHE。 可传入证券交易代码使用DataAPI.SecIDGet接口获取到。,可以是列表,secID、ticker至少选择一个
    :param ticker: 证券代码,证券在交易所交易的代码,可以是列表,secID、ticker至少选择一个
    :param beginDate: 起始日期，输入格式为yyyymmdd,可空
    :param endDate: 截止日期，输入格式为yyyymmdd,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktEquFlowOrder.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1643)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1643)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'tradeDate', u'inflowS', u'inflowM', u'inflowL', u'inflowXl', u'outflowS', u'outflowM', u'outflowL', u'outflowXl', u'netInflowS', u'netInflowM', u'netInflowL', u'netInflowXl']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktIndustryFlowOrderGet(tradeDate = "", beginDate = "", endDate = "", industryID = "", field = "", pandas = "1"):
    """
    获取行业日资金流向按照单类大小明细，包含小单资金流入，小单资金流出，小单资金净流入等，以L2数据计算得出其中单类大小定义为：（单位：元）N：0S:(0,100万]M:(100万,500万]L:(500万,1000万]XL:1000万以上
    
    :param tradeDate: 交易日期,可空
    :param beginDate: 起始日期，输入格式为yyyymmdd,可空
    :param endDate: 截止日期，输入格式为yyyymmdd,可空
    :param industryID: 证监会行业分类标准的二级行业ID。 可以使用getIndustry接口获取所有ID，industryVersionCD=010301，industryLevel=2。,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktIndustryFlowOrder.csv?ispandas=1&') 
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("tradeDate=%s"%(tradeDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&industryID=")
    if hasattr(industryID,'__iter__') and not isinstance(industryID, str):
        if len(industryID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = industryID
            requestString.append(None)
        else:
            requestString.append(','.join(industryID))
    else:
        requestString.append(industryID)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1644)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1644)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'industryID', u'industryName', u'tradeDate', u'inflowS', u'inflowM', u'inflowL', u'inflowXl', u'outflowS', u'outflowM', u'outflowL', u'outflowXl', u'netInflowS', u'netInflowM', u'netInflowL', u'netInflowXl']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'industryID': 'str','industryName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def InvestorsStatsGet(beginDate, endDate, statCycle, field = "", pandas = "1"):
    """
    记录周期内，如一周内新增投资者数量、期末投资者数量、期末持仓投资者数量、期间参与交易的投资者数量的统计数据。
    
    :param beginDate: 统计周期起始日期为基准，查询起始日，输入格式“YYYYMMDD”
    :param endDate: 统计周期起始日期为基准，查询截止日，输入格式“YYYYMMDD”
    :param statCycle: 统计周期，W-每周
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getInvestorsStats.csv?ispandas=1&') 
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    if not isinstance(statCycle, str) and not isinstance(statCycle, unicode):
        statCycle = str(statCycle)

    requestString.append("&statCycle=%s"%(statCycle))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1653)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1653)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'statsBeginDate', u'statsEnddate', u'newlyIncreased', u'newlyIncreasedNatural', u'newlyIncreasedNonnatural', u'endingNumber', u'endingNatural', u'endingNaturalA', u'endingNaturalB', u'endingNonnatural', u'endingNonnaturalA', u'endingNonnaturalB', u'endingHolding', u'endingHoldingA', u'endingHoldingB', u'endingTrading', u'endingTradingA', u'endingTradingB', u'statCycle']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'statCycle': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def IRATransLossGet(beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    记录沪市、深市及创业板的交易量及交易损耗（不包括B股）
    
    :param beginDate: 交易日，查询开始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 交易日，查询截止日期，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getIRATransLoss.csv?ispandas=1&') 
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'tradeDate', u'shTurnoverValue', u'shTransLoss', u'szTurnoverValue', u'szTransLoss', u'cyTurnoverValue', u'cyTransLoss']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktSpotdGet(secID = "", ticker = "", tradeDate = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取现货日行情，包含上海黄金交易所所有现货行情。
    
    :param secID: 证券内部编码，一串流水号,可先通过DataAPI.SecIDGet获取到，如在DataAPI.SecIDGet，选择证券类型为'SPOT',输入'Au(T+D)'，可获取到ID'AU(T+D).SGEX'后，在此输入'AU(T+D).SGEX',可以是列表,secID、ticker至少选择一个
    :param ticker: 证券在交易所的交易代码,可以是列表,secID、ticker至少选择一个
    :param tradeDate: 交易日期，格式为yyyymmdd,可空
    :param beginDate: 起始日期，格式为yyyymmdd,可空
    :param endDate: 截止日期，格式为yyyymmdd,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktSpotd.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("&tradeDate=%s"%(tradeDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1654)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1654)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'sec_ID', u'ticker', u'secShortName', u'exchangeCD', u'tradeDate', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'chg', u'chgPct', u'wPrice', u'turnoverVolume', u'turnoverValue', u'openInt', u'deliverySide', u'deliveryVol']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'sec_ID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def TickRTIntraDayMoneyFlowOrderGet(securityID, startTime = "", endTime = "", field = "", pandas = "1"):
    """
    获取一只股票当日资金流向
    
    :param securityID: 通联编制的证券编码，格式是“交易代码.证券市场代码”，如000001.XSHE。 可传入证券交易代码使用DataAPI.SecIDGet接口获取到。
    :param startTime: 开始时间，必须大于等于09:25，例如10:05，如果为空则是09:25,可空
    :param endTime: 结束时间，必须小于等于15:05，例如14:20，如果为空则是15：05,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getTickRTIntraDayMoneyFlowOrder.csv?ispandas=1&') 
    if not isinstance(securityID, str) and not isinstance(securityID, unicode):
        securityID = str(securityID)

    requestString.append("securityID=%s"%(securityID))
    if not isinstance(startTime, str) and not isinstance(startTime, unicode):
        startTime = str(startTime)

    requestString.append("&startTime=%s"%(startTime))
    if not isinstance(endTime, str) and not isinstance(endTime, unicode):
        endTime = str(endTime)

    requestString.append("&endTime=%s"%(endTime))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1738)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1738)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'dataDate', u'dataTime', u'ticker', u'exchangeCD', u'secOffset', u'moneyInflow', u'moneyInflowType', u'moneyOutflow', u'moneyOutflowType', u'netMoneyInflow', u'netMoneyInflowType']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'dataTime': 'str','ticker': 'str','exchangeCD': 'str','moneyInflowType': 'str','moneyOutflowType': 'str','netMoneyInflowType': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def InvestorCapitalChgGet(beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    证券及股票期权投资者的资金余额及变动情况
    
    :param beginDate: 统计起始日期为基准，查询起始日，输入格式“YYYYMMDD”,可空
    :param endDate: 统计起始日期为基准，查询截止日，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getInvestorCapitalChg.csv?ispandas=1&') 
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1655)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1655)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'statsBeginDate', u'statsEnddate', u'capitalType', u'endingBalance', u'dailyAverage', u'transIn', u'transOut', u'netTransIn', u'remark']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'remark': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktFxRefRateGet(currencyPair, beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取人民币汇率中间价
    
    :param currencyPair: 货币对,例如100JPY/CNY、AUD/CNY、CAD/CNY、CNY/MYR、CNY/RUB、EUR/CNY、GBP/CNY、HKD/CNY、NZD/CNY、USD/CNY
    :param beginDate: 起始日期，格式为yyyymmdd,可空
    :param endDate: 截止日期，格式为yyyymmdd,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktFxRefRate.csv?ispandas=1&') 
    if not isinstance(currencyPair, str) and not isinstance(currencyPair, unicode):
        currencyPair = str(currencyPair)

    requestString.append("currencyPair=%s"%(currencyPair))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1659)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1659)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'tradeDate', u'currencyPair', u'midRate']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'currencyPair': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktOptStatsGet(tradeDate = "", secID = "", ticker = "", beginDate = "", endDate = "", statsInterval = "", field = "", pandas = "1"):
    """
    获取期权交易统计
    
    :param tradeDate: 交易日期，格式为yyyymmdd,tradeDate、secID、ticker至少选择一个
    :param secID: 证券内部编码，一串流水号,可先通过DataAPI.SecIDGet获取到，如在DataAPI.SecIDGet，选择证券类型为'F 基金',输入'510050'，可获取到ID'510050.XSHG'后，在此输入510050.XSHG',可以是列表,tradeDate、secID、ticker至少选择一个
    :param ticker: 证券交易代码,可以是列表,tradeDate、secID、ticker至少选择一个
    :param beginDate: 起始日期，格式为yyyymmdd,可空
    :param endDate: 截止日期，格式为yyyymmdd,可空
    :param statsInterval: 数据统计区间。2=月；4=日。对应DataAPI.SysCodeGet.codeTypeID=50042。,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktOptStats.csv?ispandas=1&') 
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("tradeDate=%s"%(tradeDate))
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&statsInterval=")
    if hasattr(statsInterval,'__iter__') and not isinstance(statsInterval, str):
        if len(statsInterval) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = statsInterval
            requestString.append(None)
        else:
            requestString.append(','.join(statsInterval))
    else:
        requestString.append(statsInterval)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1661)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1661)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'statsInterval', u'tradeDate', u'turnoverVol', u'cVol', u'pVol', u'pcRate', u'openInt', u'cOpenInt', u'pOpenInt']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktOptTdRankGet(ticker = "", secID = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取最活跃3个合约品种及持仓最大3个合约交易排名情况，次日上午9:00更新
    
    :param ticker: 输入证券交易代码，如“510050”,ticker、secID至少选择一个
    :param secID: 证券内部编码，一串流水号,可先通过DataAPI.SecIDGet获取到，如在DataAPI.SecIDGet，选择证券类型为'F 基金',输入'510050'，可获取到ID'510050.XSHG'后，在此输入510050.XSHG',可以是列表,ticker、secID至少选择一个
    :param beginDate: 起始日期，格式为yyyymmdd,可空
    :param endDate: 截止日期，格式为yyyymmdd,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktOptTdRank.csv?ispandas=1&') 
    if not isinstance(ticker, str) and not isinstance(ticker, unicode):
        ticker = str(ticker)

    requestString.append("ticker=%s"%(ticker))
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1662)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1662)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'tradeDate', u'rank', u'volume', u'partyID', u'partyShortName', u'statsType']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str','partyShortName': 'str','statsType': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktEquwGet(secID = "", ticker = "", weekEndDate = "", isOpen = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取股票周行情，包含周开高低收量价、涨跌幅、换手率等
    
    :param secID: 通联编制的证券编码，格式是“交易代码.证券市场代码”，如000001.XSHE。 可传入证券交易代码使用DataAPI.SecIDGet接口获取到。,可以是列表,secID、ticker、weekEndDate至少选择一个
    :param ticker: 股票交易代码，如'000001'（可多值输入）,可以是列表,secID、ticker、weekEndDate至少选择一个
    :param weekEndDate: 交易日期，输入格式“YYYYMMDD”,secID、ticker、weekEndDate至少选择一个
    :param isOpen: 股票当周是否开盘标记位：0-未开盘，1-开盘。 当周交易天数为0时属于未开盘。,可空
    :param beginDate: 起始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktEquw.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        weekEndDate = weekEndDate.strftime('%Y%m%d')
    except:
        weekEndDate = weekEndDate.replace('-', '')
    requestString.append("&weekEndDate=%s"%(weekEndDate))
    if not isinstance(isOpen, str) and not isinstance(isOpen, unicode):
        isOpen = str(isOpen)

    requestString.append("&isOpen=%s"%(isOpen))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1674)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1674)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'weekBeginDate', u'endDate', u'tradeDays', u'preClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'turnoverValue', u'chg', u'chgPct', u'return', u'turnoverRate', u'avgTurnoverRate', u'varReturn100', u'sdReturn100', u'avgReturn100']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktEquwAdjGet(secID = "", ticker = "", weekEndDate = "", isOpen = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取股票周前复权行情，包含开高低收量价、涨跌幅、换手率等，数据正常调用时间为21:00 - 次日 18:00
    
    :param secID: 通联编制的证券编码，格式是“交易代码.证券市场代码”，如000001.XSHE。 可传入证券交易代码使用DataAPI.SecIDGet接口获取到。,可以是列表,secID、ticker、weekEndDate至少选择一个
    :param ticker: 股票交易代码，如'000001'（可多值输入）,可以是列表,secID、ticker、weekEndDate至少选择一个
    :param weekEndDate: 交易日期，输入格式“YYYYMMDD”,secID、ticker、weekEndDate至少选择一个
    :param isOpen: 股票当周是否开盘标记位：0-未开盘，1-开盘。 当周交易天数为0时属于未开盘。,可空
    :param beginDate: 起始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktEquwAdj.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        weekEndDate = weekEndDate.strftime('%Y%m%d')
    except:
        weekEndDate = weekEndDate.replace('-', '')
    requestString.append("&weekEndDate=%s"%(weekEndDate))
    if not isinstance(isOpen, str) and not isinstance(isOpen, unicode):
        isOpen = str(isOpen)

    requestString.append("&isOpen=%s"%(isOpen))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1675)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1675)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'weekBeginDate', u'endDate', u'tradeDays', u'preClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'turnoverValue', u'chg', u'chgPct', u'return', u'turnoverRate', u'avgTurnoverRate', u'varReturn100', u'sdReturn100', u'avgReturn100']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktEquwAdjAfGet(secID = "", ticker = "", weekEndDate = "", isOpen = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取股票周后复权行情，包含开高低收量价、涨跌幅、换手率等，数据正常调用时间为21:00 - 次日 18:00
    
    :param secID: 通联编制的证券编码，格式是“交易代码.证券市场代码”，如000001.XSHE。 可传入证券交易代码使用DataAPI.SecIDGet接口获取到。,可以是列表,secID、ticker、weekEndDate至少选择一个
    :param ticker: 股票交易代码，如'000001'（可多值输入）,可以是列表,secID、ticker、weekEndDate至少选择一个
    :param weekEndDate: 交易日期，输入格式“YYYYMMDD”,secID、ticker、weekEndDate至少选择一个
    :param isOpen: 股票当周是否开盘标记位：0-未开盘，1-开盘。 当周交易天数为0时属于未开盘。,可空
    :param beginDate: 起始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktEquwAdjAf.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        weekEndDate = weekEndDate.strftime('%Y%m%d')
    except:
        weekEndDate = weekEndDate.replace('-', '')
    requestString.append("&weekEndDate=%s"%(weekEndDate))
    if not isinstance(isOpen, str) and not isinstance(isOpen, unicode):
        isOpen = str(isOpen)

    requestString.append("&isOpen=%s"%(isOpen))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1676)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1676)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'weekBeginDate', u'endDate', u'tradeDays', u'preClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'turnoverValue', u'chg', u'chgPct', u'return', u'turnoverRate', u'avgTurnoverRate', u'varReturn100', u'sdReturn100', u'avgReturn100']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktEqumGet(secID = "", ticker = "", monthEndDate = "", isOpen = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取股票月行情，包含月开高低收量价、涨跌幅、换手率等
    
    :param secID: 通联编制的证券编码，格式是“交易代码.证券市场代码”，如000001.XSHE。 可传入证券交易代码使用DataAPI.SecIDGet接口获取到。,可以是列表,secID、ticker、monthEndDate至少选择一个
    :param ticker: 证券在证券市场通用的交易代码。,可以是列表,secID、ticker、monthEndDate至少选择一个
    :param monthEndDate: 月最后交易日，输入格式“YYYYMMDD”,secID、ticker、monthEndDate至少选择一个
    :param isOpen: 股票当月是否开盘标记位：0-未开盘，1-开盘。 当月交易天数为0时属于未开盘。,可空
    :param beginDate: 根据月最后交易日范围查询的起始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 根据月最后交易日范围查询的截止日期，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktEqum.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        monthEndDate = monthEndDate.strftime('%Y%m%d')
    except:
        monthEndDate = monthEndDate.replace('-', '')
    requestString.append("&monthEndDate=%s"%(monthEndDate))
    if not isinstance(isOpen, str) and not isinstance(isOpen, unicode):
        isOpen = str(isOpen)

    requestString.append("&isOpen=%s"%(isOpen))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1678)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1678)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'monthBeginDate', u'endDate', u'tradeDays', u'preClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'turnoverValue', u'chg', u'chgPct', u'return', u'turnoverRate', u'avgTurnoverRate', u'varReturn24', u'sdReturn24', u'avgReturn24', u'varReturn60', u'sdReturn60', u'avgReturn60']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktEqumAdjGet(secID = "", ticker = "", monthEndDate = "", isOpen = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取股票月前复权行情，包含开高低收量价、涨跌幅、换手率等，数据正常调用时间为21:00 - 次日 18:00
    
    :param secID: 通联编制的证券编码，格式是“交易代码.证券市场代码”，如000001.XSHE。 可传入证券交易代码使用DataAPI.SecIDGet接口获取到。,可以是列表,secID、ticker、monthEndDate至少选择一个
    :param ticker: 股票交易代码，如'000001'（可多值输入）,可以是列表,secID、ticker、monthEndDate至少选择一个
    :param monthEndDate: 交易日期，输入格式“YYYYMMDD”,secID、ticker、monthEndDate至少选择一个
    :param isOpen: 股票当月是否开盘标记位：0-未开盘，1-开盘。 当月交易天数为0时属于未开盘。,可空
    :param beginDate: 起始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktEqumAdj.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        monthEndDate = monthEndDate.strftime('%Y%m%d')
    except:
        monthEndDate = monthEndDate.replace('-', '')
    requestString.append("&monthEndDate=%s"%(monthEndDate))
    if not isinstance(isOpen, str) and not isinstance(isOpen, unicode):
        isOpen = str(isOpen)

    requestString.append("&isOpen=%s"%(isOpen))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1679)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1679)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'monthBeginDate', u'endDate', u'tradeDays', u'preClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'turnoverValue', u'chg', u'chgPct', u'return', u'turnoverRate', u'avgTurnoverRate', u'varReturn24', u'sdReturn24', u'avgReturn24', u'varReturn60', u'sdReturn60', u'avgReturn60']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktEqumAdjAfGet(secID = "", ticker = "", monthEndDate = "", isOpen = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取股票月后复权行情，包含开高低收量价、涨跌幅、换手率等，数据正常调用时间为21:00 - 次日 18:00
    
    :param secID: 通联编制的证券编码，格式是“交易代码.证券市场代码”，如000001.XSHE。 可传入证券交易代码使用DataAPI.SecIDGet接口获取到。,可以是列表,secID、ticker、monthEndDate至少选择一个
    :param ticker: 股票交易代码，如'000001'（可多值输入）,可以是列表,secID、ticker、monthEndDate至少选择一个
    :param monthEndDate: 交易日期，输入格式“YYYYMMDD”,secID、ticker、monthEndDate至少选择一个
    :param isOpen: 股票当月是否开盘标记位：0-未开盘，1-开盘。 当月交易天数为0时属于未开盘。,可空
    :param beginDate: 起始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktEqumAdjAf.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        monthEndDate = monthEndDate.strftime('%Y%m%d')
    except:
        monthEndDate = monthEndDate.replace('-', '')
    requestString.append("&monthEndDate=%s"%(monthEndDate))
    if not isinstance(isOpen, str) and not isinstance(isOpen, unicode):
        isOpen = str(isOpen)

    requestString.append("&isOpen=%s"%(isOpen))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1680)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1680)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'monthBeginDate', u'endDate', u'tradeDays', u'preClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'turnoverValue', u'chg', u'chgPct', u'return', u'turnoverRate', u'avgTurnoverRate', u'varReturn24', u'sdReturn24', u'avgReturn24', u'varReturn60', u'sdReturn60', u'avgReturn60']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktIborGet(secID = "", ticker = "", tradeDate = "", beginDate = "", endDate = "", currency = "", field = "", pandas = "1"):
    """
    获取银行间同业拆借利率，包括shibor，libor，hibor。
    
    :param secID: 拆借品种ID，可传入证券交易代码使用DataAPI.SecIDGet接口获取到。,可以是列表,secID、ticker、tradeDate至少选择一个
    :param ticker: 拆借品种，如隔夜，Hibor1D,可以是列表,secID、ticker、tradeDate至少选择一个
    :param tradeDate: 拆借日期,secID、ticker、tradeDate至少选择一个
    :param beginDate: 查询起始日期，格式为yyyymmdd,可空
    :param endDate: 查询截止日期，格式为yyyymmdd,可空
    :param currency: 拆借币种。对应DataAPI.SysCodeGet.codeTypeID=10004。,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktIbor.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("&tradeDate=%s"%(tradeDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&currency=")
    if hasattr(currency,'__iter__') and not isinstance(currency, str):
        if len(currency) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = currency
            requestString.append(None)
        else:
            requestString.append(','.join(currency))
    else:
        requestString.append(currency)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1664)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1664)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'tradeDate', u'currency', u'rate']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','currency': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def DeltaTickRTIntraDayGet(securityID, field = "", pandas = "1"):
    """
    获取一只股票最新10条分笔成交
    
    :param securityID: 通联编制的证券编码，格式是“交易代码.证券市场代码”，如000001.XSHE。 证券市场代码请根据证券的上市市场确定：XSHG-上海证券交易所，XSHE-深圳证券交易所，XHKG-香港交易所。
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getDeltaTickRTIntraDay.csv?ispandas=1&') 
    if not isinstance(securityID, str) and not isinstance(securityID, unicode):
        securityID = str(securityID)

    requestString.append("securityID=%s"%(securityID))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'ticker', u'exchangeCD', u'dataTime', u'deltaVolume', u'lastPrice', u'deltaPrice']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'ticker': 'str','exchangeCD': 'str','dataTime': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktIBBonddGet(secID = "", ticker = "", tradeDate = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取银行间现券交易日行情
    
    :param secID: 证券内部编码，可通过交易代码在DataAPI.SecIDGet获取到。（可多值输入）,可以是列表,secID、ticker、tradeDate至少选择一个
    :param ticker: 证券交易代码，如'111593425'（可多值输入）,可以是列表,secID、ticker、tradeDate至少选择一个
    :param tradeDate: 输入一个日期，不输入其他请求参数，可获取到一天全部银行间现券日行情数据，输入格式“YYYYMMDD”,secID、ticker、tradeDate至少选择一个
    :param beginDate: 起始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktIBBondd.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("&tradeDate=%s"%(tradeDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1681)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1681)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'tradeDate', u'preClosePrice', u'preWAVGPrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'wAvgPrice', u'chgPct', u'turnoverVol', u'preCloseYield', u'preWAVGYield', u'openYield', u'highestYield', u'lowestYield', u'closeYield', u'wAvgYield']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktCBOMOGet(omoType, beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取央行公开市场操作信息，包含正回购、逆回购、短期流动性调节工具交易等信息
    
    :param omoType: 公开市场操作交易方式:1-正回购、2-逆回购、3-SLO投放、4-SLO回笼、5-MLF中期借贷便利。对应DataAPI.SysCodeGet.codeTypeID=12002。,可以是列表
    :param beginDate: 以公开市场操作日期为基准，查询起始日期，输入格式：YYYYMMDD,可空
    :param endDate: 以公开市场操作日期为基准，查询截止日期，输入格式：YYYYMMDD,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktCBOMO.csv?ispandas=1&') 
    requestString.append("omoType=")
    if hasattr(omoType,'__iter__') and not isinstance(omoType, str):
        if len(omoType) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = omoType
            requestString.append(None)
        else:
            requestString.append(','.join(omoType))
    else:
        requestString.append(omoType)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1682)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1682)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'omoTerm', u'operateDate', u'operateDueDate', u'publishDate', u'turnoverVol', u'tenderRate', u'omoType', u'tenderType', u'remark']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'omoTerm': 'str','remark': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktFxQtRateGet(currencyPair, beginTime = "", endTime = "", field = "", pandas = "1"):
    """
    获取中国银行发布的实时外汇牌价，包含现钞现汇买入卖出价等
    
    :param currencyPair: 货币代码。对应DataAPI.SysCodeGet.codeTypeID=10004。
    :param beginTime: 查询发布开始时间，格式为YYYYMMDDHHMMSS，如20160222093000,可空
    :param endTime: 查询发布截止时间，格式为YYYYMMDDHHMMSS，如20160222113000,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktFxQtRate.csv?ispandas=1&') 
    if not isinstance(currencyPair, str) and not isinstance(currencyPair, unicode):
        currencyPair = str(currencyPair)

    requestString.append("currencyPair=%s"%(currencyPair))
    if not isinstance(beginTime, str) and not isinstance(beginTime, unicode):
        beginTime = str(beginTime)

    requestString.append("&beginTime=%s"%(beginTime))
    if not isinstance(endTime, str) and not isinstance(endTime, unicode):
        endTime = str(endTime)

    requestString.append("&endTime=%s"%(endTime))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1689)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1689)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'currencyPair', u'currencyPairCn', u'publishTime', u'currencyBid', u'cashBid', u'currencyAsk', u'cashAsk', u'conversionPrice', u'partyID', u'partyFullName']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'currencyPair': 'str','currencyPairCn': 'str','partyFullName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktChiborGet(secID = "", ticker = "", tradeDate = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取存款类机构间同业拆借行情，包含开、高、低、收、加权利率等，次日上午8:00更新
    
    :param secID: 证券内部编码，可通过交易代码在DataAPI.SecIDGet获取到。,可以是列表,secID、ticker、tradeDate至少选择一个
    :param ticker: 证券交易代码，如'IBO1M'（可多值输入）,可以是列表,secID、ticker、tradeDate至少选择一个
    :param tradeDate: 输入一个日期，不输入其他请求参数，可获取到一天全部Chibor行情数据，输入格式“YYYYMMDD”,secID、ticker、tradeDate至少选择一个
    :param beginDate: 起始日期，格式为YYYYMMDD,可空
    :param endDate: 截止日期，格式为YYYYMMDD,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktChibor.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("&tradeDate=%s"%(tradeDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1692)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1692)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'tradeDate', u'preCloseRate', u'preCloseWRate', u'openRate', u'highestRate', u'lowestRate', u'closeRate', u'wRate', u'bpChg', u'dealAmount', u'turnoverValue', u'turnoverChg']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktRankListStocksGet(tradeDate = "", secID = "", ticker = "", abnormalTypeCD = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取沪深交易所每日股票交易公开信息，包括涨跌幅异常、换手率异常等各种公开信息
    
    :param tradeDate: 输入一个日期，不输入其他请求参数，可获取到一天全部数据，输入格式“YYYYMMDD”,tradeDate、secID、ticker、abnormalTypeCD至少选择一个
    :param secID: 通联编制的证券编码，格式是“交易代码.证券市场代码”，如000001.XSHE。 可传入证券交易代码使用DataAPI.SecIDGet接口获取到。,可以是列表,tradeDate、secID、ticker、abnormalTypeCD至少选择一个
    :param ticker: 证券交易代码，如'600000'（可多值输入）,可以是列表,tradeDate、secID、ticker、abnormalTypeCD至少选择一个
    :param abnormalTypeCD: 异动类型代码，可在DataAPI.SysCodeGet中获得，令codeTypeID=12006,可以是列表,tradeDate、secID、ticker、abnormalTypeCD至少选择一个
    :param beginDate: 查询起始日期，格式为YYYYMMDD,可空
    :param endDate: 查询截至日期，格式为YYYYMMDD,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktRankListStocks.csv?ispandas=1&') 
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("tradeDate=%s"%(tradeDate))
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&abnormalTypeCD=")
    if hasattr(abnormalTypeCD,'__iter__') and not isinstance(abnormalTypeCD, str):
        if len(abnormalTypeCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = abnormalTypeCD
            requestString.append(None)
        else:
            requestString.append(','.join(abnormalTypeCD))
    else:
        requestString.append(abnormalTypeCD)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1785)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1785)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'tradeDate', u'abnormalTypeCD', u'abnormalType', u'deviation', u'turnoverVol', u'turnoverValue', u'abnormalBeginDate', u'abnormalEndDate']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str','abnormalType': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktRankListSalesGet(secID = "", ticker = "", side = "", rank = "", tradeDate = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取沪深交易所每日营业部交易公开信息，包括涨跌幅异常、换手率异常等各营业部排名
    
    :param secID: 通联编制的证券编码，格式是“交易代码.证券市场代码”，如000001.XSHE。 可传入证券交易代码使用DataAPI.SecIDGet接口获取到。,可以是列表,secID、ticker、side、rank、tradeDate至少选择一个
    :param ticker: 证券交易代码，如'600000'（可多值输入）,可以是列表,secID、ticker、side、rank、tradeDate至少选择一个
    :param side: 买卖方向，B-买入、S-卖出、N-买卖综合,可以是列表,secID、ticker、side、rank、tradeDate至少选择一个
    :param rank: 排名，提供第1~5名的排名,可以是列表,secID、ticker、side、rank、tradeDate至少选择一个
    :param tradeDate: 输入一个日期，不输入其他请求参数，可获取到一天全部数据，输入格式“YYYYMMDD”,secID、ticker、side、rank、tradeDate至少选择一个
    :param beginDate: 查询起始日期，格式为YYYYMMDD,可空
    :param endDate: 查询截至日期，格式为YYYYMMDD,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktRankListSales.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&side=")
    if hasattr(side,'__iter__') and not isinstance(side, str):
        if len(side) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = side
            requestString.append(None)
        else:
            requestString.append(','.join(side))
    else:
        requestString.append(side)
    requestString.append("&rank=")
    if hasattr(rank,'__iter__') and not isinstance(rank, str):
        if len(rank) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = rank
            requestString.append(None)
        else:
            requestString.append(','.join(rank))
    else:
        requestString.append(rank)
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("&tradeDate=%s"%(tradeDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1786)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1786)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'tradeDate', u'side', u'rank', u'sales', u'buyValue', u'sellValue', u'totalValue', u'abnormalTypeCD']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str','side': 'str','sales': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktRefIrGet(secID = "", ticker = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取货币市场参考利率指标，包含上海证券交易所债券质押式回购定盘利率和中国外汇交易中心回购定盘利率、七天回购移动平均利率。
    
    :param secID: 利率指标，一串流水号,可先通过DataAPI.SecIDGet获取到，如在DataAPI.SecIDGet，选择证券类型为'IR',输入'FRGC001'，可获取到ID'FRGC001.XSHG'后，在此输入'FRGC001.XSHG',可以是列表,secID、ticker至少选择一个
    :param ticker: 指标代码,如FRGC001,可以是列表,secID、ticker至少选择一个
    :param beginDate: 起始日期，格式为yyyymmdd,可空
    :param endDate: 截止日期，格式为yyyymmdd,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktRefIr.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 2104)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 2104)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'sec_ID', u'secShortName', u'ticker', u'exchangeCD', u'tradeDate', u'rateType', u'rate']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'sec_ID': 'str','secShortName': 'str','ticker': 'str','exchangeCD': 'str','rateType': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktExTdShszGet(statsTypeCD = "", statsTypeClassCD = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取沪深交易所股票、基金、债券成交概况和深圳证券交易所股票行业统计情况。
    
    :param statsTypeCD: 统计角度编码，可在DataAPI.SysCodeGet获得，令codeTypeID=12004,选择其中2~4位编码,可以是列表,可空
    :param statsTypeClassCD: 角度类型细分编码，可在DataAPI.SysCodeGet获得，令codeTypeID=12004,选择其中4~6位编码,可以是列表,可空
    :param beginDate: 起始日期，格式为yyyymmdd,可空
    :param endDate: 截止日期，格式为yyyymmdd,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktExTdShsz.csv?ispandas=1&') 
    requestString.append("statsTypeCD=")
    if hasattr(statsTypeCD,'__iter__') and not isinstance(statsTypeCD, str):
        if len(statsTypeCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = statsTypeCD
            requestString.append(None)
        else:
            requestString.append(','.join(statsTypeCD))
    else:
        requestString.append(statsTypeCD)
    requestString.append("&statsTypeClassCD=")
    if hasattr(statsTypeClassCD,'__iter__') and not isinstance(statsTypeClassCD, str):
        if len(statsTypeClassCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = statsTypeClassCD
            requestString.append(None)
        else:
            requestString.append(','.join(statsTypeClassCD))
    else:
        requestString.append(statsTypeClassCD)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 2105)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 2105)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'statsTypeCD', u'statsType', u'statsTypeClassCD', u'statsTypeClass', u'exchangeCD', u'tradeDate', u'marketValue', u'negMarketValue', u'totalShares', u'floatShares', u'turnoverVol', u'turnoverValue', u'dealAmount', u'avgPE', u'turnoverRate', u'listSecNum', u'tradeSecNum', u'upSecNum', u'flatSecNum', u'downSecNum']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'statsTypeCD': 'str','statsType': 'str','statsTypeClassCD': 'str','statsTypeClass': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktExTdIbGet(tradeTypeCD = "", statsTypeClassCD = "", statsTypeCD = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取中国外汇交易中心同业拆借日报、质押式回购日报、买断式回购日报、现券买卖日报的市场成交情况。
    
    :param tradeTypeCD: 交易类型，同业拆借日报- chibor  质押式回购日报- repo买断式回购日报- orepo现券买卖日报- bond,可以是列表,可空
    :param statsTypeClassCD: 角度类型细分编码，可在DataAPI.SysCodeGet获得，令codeTypeID=12005,选择其中4~6位编码,可以是列表,可空
    :param statsTypeCD: 统计角度编码，可在DataAPI.SysCodeGet获得，令codeTypeID=12005,选择其中2~4位编码,可以是列表,可空
    :param beginDate: 起始日期，格式为yyyymmdd,可空
    :param endDate: 截止日期，格式为yyyymmdd,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktExTdIb.csv?ispandas=1&') 
    requestString.append("tradeTypeCD=")
    if hasattr(tradeTypeCD,'__iter__') and not isinstance(tradeTypeCD, str):
        if len(tradeTypeCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = tradeTypeCD
            requestString.append(None)
        else:
            requestString.append(','.join(tradeTypeCD))
    else:
        requestString.append(tradeTypeCD)
    requestString.append("&statsTypeClassCD=")
    if hasattr(statsTypeClassCD,'__iter__') and not isinstance(statsTypeClassCD, str):
        if len(statsTypeClassCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = statsTypeClassCD
            requestString.append(None)
        else:
            requestString.append(','.join(statsTypeClassCD))
    else:
        requestString.append(statsTypeClassCD)
    requestString.append("&statsTypeCD=")
    if hasattr(statsTypeCD,'__iter__') and not isinstance(statsTypeCD, str):
        if len(statsTypeCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = statsTypeCD
            requestString.append(None)
        else:
            requestString.append(','.join(statsTypeCD))
    else:
        requestString.append(statsTypeCD)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 2106)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 2106)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'tradeTypeCD', u'statsTypeCD', u'statsType', u'statsTypeClassCD', u'statsTypeClass', u'tradeDate', u'dealAmount', u'dealChg', u'turnoverVol', u'turnoverVolChg', u'wRate', u'bpChg', u'tradableNum', u'tradingNum', u'involvedNum']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'tradeTypeCD': 'str','statsTypeCD': 'str','statsType': 'str','statsTypeClassCD': 'str','statsTypeClass': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktUsequdGet(ticker, beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取纳斯达克证券交易所、纽约证券交易所的股票日行情
    
    :param ticker: 股票交易代码，如'000001'（可多值输入）,可以是列表
    :param beginDate: 起始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktUsequd.csv?ispandas=1&') 
    requestString.append("ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1831)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1831)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'ticker', u'exchangeCD', u'tradeDate', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'ticker': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktAdjfAfIntraDayGet(secID = "", ticker = "", exDivDate = "", field = "", pandas = "1"):
    """
    获取沪深A股和B股调整行情的后复权因子数据（以上市价格为基准），包含除权除息日、除权除息事项具体数据、本次复权因子、累积复权因子以及因子调整的截止日期，每日早9:00更新，包含当日除权除息股票的复权因子信息。该因子用来调整历史行情，不作为预测使用，于除权除息日进行计算调整。
    
    :param secID: 通联编制的证券编码，格式是“交易代码.证券市场代码”，如000001.XSHE。 可传入证券交易代码使用DataAPI.SecIDGet接口获取到。,可以是列表,可空
    :param ticker: 一只或多只股票代码，用,分隔，如000001,000002。,可以是列表,可空
    :param exDivDate: 除权除息日,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktAdjfAfIntraDay.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&exDivDate=")
    if hasattr(exDivDate,'__iter__') and not isinstance(exDivDate, str):
        if len(exDivDate) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = exDivDate
            requestString.append(None)
        else:
            requestString.append(','.join(exDivDate))
    else:
        requestString.append(exDivDate)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'exDivDate', u'perCashDiv', u'perShareDivRatio', u'perShareTransRatio', u'allotmentRatio', u'allotmentPrice', u'adjFactor', u'accumAdjFactor', u'adjFactor3', u'accumAdjFactor3', u'adjFactor4', u'accumAdjFactor4']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def VirtualAuctionIntraDayGet(secID, field = "", pandas = "1"):
    """
    高频数据，获取一只证券当日集合竞价信息，证券类型可以是股票，部分债券或基金，时间范围为9:15:00~9:25:00。
    
    :param secID: 通联编制的证券编码，格式是“交易代码.证券市场代码”，如000001.XSHE。 可传入证券交易代码使用DataAPI.SecIDGet接口获取到。,可以是列表
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getVirtualAuctionIntraDay.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1839)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1839)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'tradeDate', u'tradeTime', u'virAucPrice', u'virAucQty', u'leaveQty', u'side']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','tradeTime': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktRANKInstTrGet(tradeDate, industryName = "", field = "", pandas = "1"):
    """
    获取每个交易日行业换手率排名信息，按照申万一级行业进行分类，只展示行业排名前三名的证券，每日下午16:30更新
    
    :param tradeDate: 交易日期，格式为yyyymmdd
    :param industryName: 行业名称，如：传媒,电气设备等，可多值输入，以下为申万28个行业名称：休闲服务,房地产,商业贸易,综合,钢铁,农林牧渔,食品饮料,采掘,电子,国防军工,通信,公用事业,交通运输,轻工制造,计算机,电气设备,家用电器,医药生物,传媒,非银金融,汽车,有色金属,机械设备,建筑材料,化工,纺织服装,银行,建筑装饰,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktRANKInstTr.csv?ispandas=1&') 
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("tradeDate=%s"%(tradeDate))
    requestString.append("&industryName=")
    if hasattr(industryName,'__iter__') and not isinstance(industryName, str):
        if len(industryName) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = industryName
            requestString.append(None)
        else:
            requestString.append(','.join(industryName))
    else:
        requestString.append(industryName)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'tradeDate', u'turnoverRate', u'closePrice', u'industryID', u'industryName', u'industry', u'rank']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str','industryID': 'str','industryName': 'str','industry': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def TickRTSnapshotL2Get(securityID = "", exchangeCD = "", field = "", pandas = "1"):
    """
    高频数据，获取一只证券当日内时间段的Level2信息。 证券可以是股票，指数， 部分债券或 基金，包含买卖10档行情、成交笔数、委买卖总量，IOPV等
    
    :param securityID: 一只或多只证券代码，用,分隔，格式是“数字.交易所代码”，如000001.XSHG。如果为空，则为全部证券。,可以是列表,可空
    :param exchangeCD: 通联编制的证券市场编码。例如，XSHG-上海证券交易所；XSHE-深圳证券交易所；XIBE-中国银行间市场等。对应DataAPI.SysCodeGet.codeTypeID=10002。,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getTickRTSnapshotL2.csv?ispandas=1&') 
    requestString.append("securityID=")
    if hasattr(securityID,'__iter__') and not isinstance(securityID, str):
        if len(securityID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = securityID
            requestString.append(None)
        else:
            requestString.append(','.join(securityID))
    else:
        requestString.append(securityID)
    if not isinstance(exchangeCD, str) and not isinstance(exchangeCD, unicode):
        exchangeCD = str(exchangeCD)

    requestString.append("&exchangeCD=%s"%(exchangeCD))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'timestamp', u'ticker', u'exchangeCD', u'localTimestamp', u'dataDate', u'dataTime', u'utcOffset', u'currencyCD', u'prevClosePrice', u'openPrice', u'volume', u'value', u'tradeNumber', u'highPrice', u'lowPrice', u'lastPrice', u'askBook', u'bidBook', u'suspension', u'closePrice', u'totalBidVolume', u'weightedAvgBidPrice', u'totalAskVolume', u'weightedAvgAskPrice', u'IOPV']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'ticker': 'str','exchangeCD': 'str','dataDate': 'str','dataTime': 'str','utcOffset': 'str','currencyCD': 'str','askBook': 'str','bidBook': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktIdxwGet(beginDate, endDate, indexID = "", ticker = "", field = "", pandas = "1"):
    """
    获取指数周线行情信息，包含昨收价、开盘价、最高价、最低价、收盘价、成交量、成交金额等字段。每日16:00到20:00,次日上午10:00到12:00循环生产。
    
    :param beginDate: 起始日期，输入格式“YYYYMMDD”
    :param endDate: 截止日期，输入格式“YYYYMMDD”
    :param indexID: 指数内部编码，可通过交易代码在DataAPI.MktIdxdGet获取。,可以是列表,可空
    :param ticker: 指数交易代码,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktIdxw.csv?ispandas=1&') 
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&indexID=")
    if hasattr(indexID,'__iter__') and not isinstance(indexID, str):
        if len(indexID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indexID
            requestString.append(None)
        else:
            requestString.append(','.join(indexID))
    else:
        requestString.append(indexID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1855)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1855)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indexID', u'ticker', u'secShortName', u'endDate', u'tradeDays', u'preClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'turnoverValue', u'chg', u'chgPct', u'avgPrice', u'wAvgReyurn', u'yReturn']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indexID': 'str','ticker': 'str','secShortName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktIdxmGet(beginDate, endDate, indexID = "", ticker = "", field = "", pandas = "1"):
    """
    获取指数月线行情信息，包含昨收价、开盘价、最高价、最低价、收盘价、成交量、成交金额等字段。每日16:00到20:00,次日上午10:00到12:00循环生产。
    
    :param beginDate: 起始日期，输入格式“YYYYMMDD”
    :param endDate: 截止日期，输入格式“YYYYMMDD”
    :param indexID: 指数内部编码，可通过交易代码在DataAPI.MktIdxdGet获取。,可以是列表,可空
    :param ticker: 指数交易代码,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktIdxm.csv?ispandas=1&') 
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&indexID=")
    if hasattr(indexID,'__iter__') and not isinstance(indexID, str):
        if len(indexID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indexID
            requestString.append(None)
        else:
            requestString.append(','.join(indexID))
    else:
        requestString.append(indexID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1856)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1856)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indexID', u'ticker', u'secShortName', u'endDate', u'tradeDays', u'preClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'turnoverValue', u'chg', u'chgPct', u'avgPrice', u'mAvgReyurn', u'yReturn']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indexID': 'str','ticker': 'str','secShortName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktStockFactorsOneDayProGet(tradeDate, secID = "", ticker = "", field = "", pandas = "1"):
    """
    获取多只股票历史上某一天的因子数据（专业版）。股票因子分三个时间段生产，分别是T日17点00分、T日21点30分和T+1日04点00分生产完成。如果调用的因子中包含还未生产完成的因子会导致所有因子都不会返回。具体每个因子的生产时间在文档中有标注，请在调用因子时确认清楚。
    
    :param tradeDate: 日期
    :param secID: 多只股票ID，用逗号隔开,可以是列表,可空
    :param ticker: 多只股票交易代码，用逗号隔开,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktStockFactorsOneDayPro.csv?ispandas=1&') 
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("tradeDate=%s"%(tradeDate))
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1859)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1859)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'tradeDate', u'AccountsPayablesTDays', u'AccountsPayablesTRate', u'AdminiExpenseRate', u'ARTDays', u'ARTRate', u'ASSI', u'BLEV', u'BondsPayableToAsset', u'CashRateOfSales', u'CashToCurrentLiability', u'CMRA', u'CTOP', u'CTP5', u'CurrentAssetsRatio', u'CurrentAssetsTRate', u'CurrentRatio', u'DAVOL10', u'DAVOL20', u'DAVOL5', u'DDNBT', u'DDNCR', u'DDNSR', u'DebtEquityRatio', u'DebtsAssetRatio', u'DHILO', u'DilutedEPS', u'DVRAT', u'EBITToTOR', u'EGRO', u'EMA10', u'EMA120', u'EMA20', u'EMA5', u'EMA60', u'EPS', u'EquityFixedAssetRatio', u'EquityToAsset', u'EquityTRate', u'ETOP', u'ETP5', u'FinancialExpenseRate', u'FinancingCashGrowRate', u'FixAssetRatio', u'FixedAssetsTRate', u'GrossIncomeRatio', u'HBETA', u'HSIGMA', u'IntangibleAssetRatio', u'InventoryTDays', u'InventoryTRate', u'InvestCashGrowRate', u'LCAP', u'LFLO', u'LongDebtToAsset', u'LongDebtToWorkingCapital', u'LongTermDebtToAsset', u'MA10', u'MA120', u'MA20', u'MA5', u'MA60', u'MAWVAD', u'MFI', u'MLEV', u'NetAssetGrowRate', u'NetProfitGrowRate', u'NetProfitRatio', u'NOCFToOperatingNI', u'NonCurrentAssetsRatio', u'NPParentCompanyGrowRate', u'NPToTOR', u'OperatingExpenseRate', u'OperatingProfitGrowRate', u'OperatingProfitRatio', u'OperatingProfitToTOR', u'OperatingRevenueGrowRate', u'OperCashGrowRate', u'OperCashInToCurrentLiability', u'PB', u'PCF', u'PE', u'PS', u'PSY', u'QuickRatio', u'REVS10', u'REVS20', u'REVS5', u'ROA', u'ROA5', u'ROE', u'ROE5', u'RSI', u'RSTR12', u'RSTR24', u'SalesCostRatio', u'SaleServiceCashToOR', u'SUE', u'TaxRatio', u'TOBT', u'TotalAssetGrowRate', u'TotalAssetsTRate', u'TotalProfitCostRatio', u'TotalProfitGrowRate', u'VOL10', u'VOL120', u'VOL20', u'VOL240', u'VOL5', u'VOL60', u'WVAD', u'REC', u'DAREC', u'GREC', u'FY12P', u'DAREV', u'GREV', u'SFY12P', u'DASREV', u'GSREV', u'FEARNG', u'FSALESG', u'TA2EV', u'CFO2EV', u'ACCA', u'DEGM', u'SUOI', u'EARNMOM', u'FiftyTwoWeekHigh', u'Volatility', u'Skewness', u'ILLIQUIDITY', u'BackwardADJ', u'MACD', u'ADTM', u'ATR14', u'ATR6', u'BIAS10', u'BIAS20', u'BIAS5', u'BIAS60', u'BollDown', u'BollUp', u'CCI10', u'CCI20', u'CCI5', u'CCI88', u'KDJ_K', u'KDJ_D', u'KDJ_J', u'ROC6', u'ROC20', u'SBM', u'STM', u'UpRVI', u'DownRVI', u'RVI', u'SRMI', u'ChandeSD', u'ChandeSU', u'CMO', u'DBCD', u'ARC', u'OBV', u'OBV6', u'OBV20', u'TVMA20', u'TVMA6', u'TVSTD20', u'TVSTD6', u'VDEA', u'VDIFF', u'VEMA10', u'VEMA12', u'VEMA26', u'VEMA5', u'VMACD', u'VOSC', u'VR', u'VROC12', u'VROC6', u'VSTD10', u'VSTD20', u'KlingerOscillator', u'MoneyFlow20', u'AD', u'AD20', u'AD6', u'CoppockCurve', u'ASI', u'ChaikinOscillator', u'ChaikinVolatility', u'EMV14', u'EMV6', u'plusDI', u'minusDI', u'ADX', u'ADXR', u'Aroon', u'AroonDown', u'AroonUp', u'DEA', u'DIFF', u'DDI', u'DIZ', u'DIF', u'MTM', u'MTMMA', u'PVT', u'PVT6', u'PVT12', u'TRIX5', u'TRIX10', u'UOS', u'MA10RegressCoeff12', u'MA10RegressCoeff6', u'PLRC6', u'PLRC12', u'SwingIndex', u'Ulcer10', u'Ulcer5', u'Hurst', u'ACD6', u'ACD20', u'EMA12', u'EMA26', u'APBMA', u'BBI', u'BBIC', u'TEMA10', u'TEMA5', u'MA10Close', u'AR', u'BR', u'ARBR', u'CR20', u'MassIndex', u'BearPower', u'BullPower', u'Elder', u'NVI', u'PVI', u'RC12', u'RC24', u'JDQS20', u'Variance20', u'Variance60', u'Variance120', u'Kurtosis20', u'Kurtosis60', u'Kurtosis120', u'Alpha20', u'Alpha60', u'Alpha120', u'Beta20', u'Beta60', u'Beta120', u'SharpeRatio20', u'SharpeRatio60', u'SharpeRatio120', u'TreynorRatio20', u'TreynorRatio60', u'TreynorRatio120', u'InformationRatio20', u'InformationRatio60', u'InformationRatio120', u'GainVariance20', u'GainVariance60', u'GainVariance120', u'LossVariance20', u'LossVariance60', u'LossVariance120', u'GainLossVarianceRatio20', u'GainLossVarianceRatio60', u'GainLossVarianceRatio120', u'RealizedVolatility', u'REVS60', u'REVS120', u'REVS250', u'REVS750', u'REVS5m20', u'REVS5m60', u'REVS5Indu1', u'REVS20Indu1', u'Volumn1M', u'Volumn3M', u'Price1M', u'Price3M', u'Price1Y', u'Rank1M', u'CashDividendCover', u'DividendCover', u'DividendPaidRatio', u'RetainedEarningRatio', u'CashEquivalentPS', u'DividendPS', u'EPSTTM', u'NetAssetPS', u'TORPS', u'TORPSLatest', u'OperatingRevenuePS', u'OperatingRevenuePSLatest', u'OperatingProfitPS', u'OperatingProfitPSLatest', u'CapitalSurplusFundPS', u'SurplusReserveFundPS', u'UndividedProfitPS', u'RetainedEarningsPS', u'OperCashFlowPS', u'CashFlowPS', u'NetNonOIToTP', u'NetNonOIToTPLatest', u'PeriodCostsRate', u'InterestCover', u'NetProfitGrowRate3Y', u'NetProfitGrowRate5Y', u'OperatingRevenueGrowRate3Y', u'OperatingRevenueGrowRate5Y', u'NetCashFlowGrowRate', u'NetProfitCashCover', u'OperCashInToAsset', u'CashConversionCycle', u'OperatingCycle', u'PEG3Y', u'PEG5Y', u'PEIndu', u'PBIndu', u'PSIndu', u'PCFIndu', u'PEHist20', u'PEHist60', u'PEHist120', u'PEHist250', u'StaticPE', u'ForwardPE', u'EnterpriseFCFPS', u'ShareholderFCFPS', u'ROEDiluted', u'ROEAvg', u'ROEWeighted', u'ROECut', u'ROECutWeighted', u'ROIC', u'ROAEBIT', u'ROAEBITTTM', u'OperatingNIToTP', u'OperatingNIToTPLatest', u'InvestRAssociatesToTP', u'InvestRAssociatesToTPLatest', u'NPCutToNP', u'SuperQuickRatio', u'TSEPToInterestBearDebt', u'DebtTangibleEquityRatio', u'TangibleAToInteBearDebt', u'TangibleAToNetDebt', u'NOCFToTLiability', u'NOCFToInterestBearDebt', u'NOCFToNetDebt', u'TSEPToTotalCapital', u'InteBearDebtToTotalCapital', u'NPParentCompanyCutYOY', u'SalesServiceCashToORLatest', u'CashRateOfSalesLatest', u'NOCFToOperatingNILatest', u'TotalAssets', u'MktValue', u'NegMktValue', u'TEAP', u'NIAP', u'TotalFixedAssets', u'IntFreeCL', u'IntFreeNCL', u'IntCL', u'IntDebt', u'NetDebt', u'NetTangibleAssets', u'WorkingCapital', u'NetWorkingCapital', u'TotalPaidinCapital', u'RetainedEarnings', u'OperateNetIncome', u'ValueChgProfit', u'NetIntExpense', u'EBIT', u'EBITDA', u'EBIAT', u'NRProfitLoss', u'NIAPCut', u'FCFF', u'FCFE', u'DA', u'TRevenueTTM', u'TCostTTM', u'RevenueTTM', u'CostTTM', u'GrossProfitTTM', u'SalesExpenseTTM', u'AdminExpenseTTM', u'FinanExpenseTTM', u'AssetImpairLossTTM', u'NPFromOperatingTTM', u'NPFromValueChgTTM', u'OperateProfitTTM', u'NonOperatingNPTTM', u'TProfitTTM', u'NetProfitTTM', u'NetProfitAPTTM', u'SaleServiceRenderCashTTM', u'NetOperateCFTTM', u'NetInvestCFTTM', u'NetFinanceCFTTM', u'GrossProfit', u'Beta252', u'RSTR504', u'EPIBS', u'CETOP', u'DASTD', u'CmraCNE5', u'HsigmaCNE5', u'SGRO', u'EgibsLong', u'STOM', u'STOQ', u'STOA', u'NLSIZE']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktStockFactorsDateRangeProGet(secID = "", ticker = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取一只股票历史上某一时间段的因子数据（专业版）。股票因子分三个时间段生产，分别是T日17点00分、T日21点30分和T+1日04点00分生产完成。如果调用的因子中包含还未生产完成的因子会导致所有因子都不会返回。具体每个因子的生产时间在文档中有标注，请在调用因子时确认清楚。
    
    :param secID: 一只股票ID,secID、ticker至少选择一个
    :param ticker: 一只股票交易代码,secID、ticker至少选择一个
    :param beginDate: 开始日期,可空
    :param endDate: 结束日期,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktStockFactorsDateRangePro.csv?ispandas=1&') 
    if not isinstance(secID, str) and not isinstance(secID, unicode):
        secID = str(secID)

    requestString.append("secID=%s"%(secID))
    if not isinstance(ticker, str) and not isinstance(ticker, unicode):
        ticker = str(ticker)

    requestString.append("&ticker=%s"%(ticker))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1860)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1860)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'tradeDate', u'AccountsPayablesTDays', u'AccountsPayablesTRate', u'AdminiExpenseRate', u'ARTDays', u'ARTRate', u'ASSI', u'BLEV', u'BondsPayableToAsset', u'CashRateOfSales', u'CashToCurrentLiability', u'CMRA', u'CTOP', u'CTP5', u'CurrentAssetsRatio', u'CurrentAssetsTRate', u'CurrentRatio', u'DAVOL10', u'DAVOL20', u'DAVOL5', u'DDNBT', u'DDNCR', u'DDNSR', u'DebtEquityRatio', u'DebtsAssetRatio', u'DHILO', u'DilutedEPS', u'DVRAT', u'EBITToTOR', u'EGRO', u'EMA10', u'EMA120', u'EMA20', u'EMA5', u'EMA60', u'EPS', u'EquityFixedAssetRatio', u'EquityToAsset', u'EquityTRate', u'ETOP', u'ETP5', u'FinancialExpenseRate', u'FinancingCashGrowRate', u'FixAssetRatio', u'FixedAssetsTRate', u'GrossIncomeRatio', u'HBETA', u'HSIGMA', u'IntangibleAssetRatio', u'InventoryTDays', u'InventoryTRate', u'InvestCashGrowRate', u'LCAP', u'LFLO', u'LongDebtToAsset', u'LongDebtToWorkingCapital', u'LongTermDebtToAsset', u'MA10', u'MA120', u'MA20', u'MA5', u'MA60', u'MAWVAD', u'MFI', u'MLEV', u'NetAssetGrowRate', u'NetProfitGrowRate', u'NetProfitRatio', u'NOCFToOperatingNI', u'NonCurrentAssetsRatio', u'NPParentCompanyGrowRate', u'NPToTOR', u'OperatingExpenseRate', u'OperatingProfitGrowRate', u'OperatingProfitRatio', u'OperatingProfitToTOR', u'OperatingRevenueGrowRate', u'OperCashGrowRate', u'OperCashInToCurrentLiability', u'PB', u'PCF', u'PE', u'PS', u'PSY', u'QuickRatio', u'REVS10', u'REVS20', u'REVS5', u'ROA', u'ROA5', u'ROE', u'ROE5', u'RSI', u'RSTR12', u'RSTR24', u'SalesCostRatio', u'SaleServiceCashToOR', u'SUE', u'TaxRatio', u'TOBT', u'TotalAssetGrowRate', u'TotalAssetsTRate', u'TotalProfitCostRatio', u'TotalProfitGrowRate', u'VOL10', u'VOL120', u'VOL20', u'VOL240', u'VOL5', u'VOL60', u'WVAD', u'REC', u'DAREC', u'GREC', u'FY12P', u'DAREV', u'GREV', u'SFY12P', u'DASREV', u'GSREV', u'FEARNG', u'FSALESG', u'TA2EV', u'CFO2EV', u'ACCA', u'DEGM', u'SUOI', u'EARNMOM', u'FiftyTwoWeekHigh', u'Volatility', u'Skewness', u'ILLIQUIDITY', u'BackwardADJ', u'MACD', u'ADTM', u'ATR14', u'ATR6', u'BIAS10', u'BIAS20', u'BIAS5', u'BIAS60', u'BollDown', u'BollUp', u'CCI10', u'CCI20', u'CCI5', u'CCI88', u'KDJ_K', u'KDJ_D', u'KDJ_J', u'ROC6', u'ROC20', u'SBM', u'STM', u'UpRVI', u'DownRVI', u'RVI', u'SRMI', u'ChandeSD', u'ChandeSU', u'CMO', u'DBCD', u'ARC', u'OBV', u'OBV6', u'OBV20', u'TVMA20', u'TVMA6', u'TVSTD20', u'TVSTD6', u'VDEA', u'VDIFF', u'VEMA10', u'VEMA12', u'VEMA26', u'VEMA5', u'VMACD', u'VOSC', u'VR', u'VROC12', u'VROC6', u'VSTD10', u'VSTD20', u'KlingerOscillator', u'MoneyFlow20', u'AD', u'AD20', u'AD6', u'CoppockCurve', u'ASI', u'ChaikinOscillator', u'ChaikinVolatility', u'EMV14', u'EMV6', u'plusDI', u'minusDI', u'ADX', u'ADXR', u'Aroon', u'AroonDown', u'AroonUp', u'DEA', u'DIFF', u'DDI', u'DIZ', u'DIF', u'MTM', u'MTMMA', u'PVT', u'PVT6', u'PVT12', u'TRIX5', u'TRIX10', u'UOS', u'MA10RegressCoeff12', u'MA10RegressCoeff6', u'PLRC6', u'PLRC12', u'SwingIndex', u'Ulcer10', u'Ulcer5', u'Hurst', u'ACD6', u'ACD20', u'EMA12', u'EMA26', u'APBMA', u'BBI', u'BBIC', u'TEMA10', u'TEMA5', u'MA10Close', u'AR', u'BR', u'ARBR', u'CR20', u'MassIndex', u'BearPower', u'BullPower', u'Elder', u'NVI', u'PVI', u'RC12', u'RC24', u'JDQS20', u'Variance20', u'Variance60', u'Variance120', u'Kurtosis20', u'Kurtosis60', u'Kurtosis120', u'Alpha20', u'Alpha60', u'Alpha120', u'Beta20', u'Beta60', u'Beta120', u'SharpeRatio20', u'SharpeRatio60', u'SharpeRatio120', u'TreynorRatio20', u'TreynorRatio60', u'TreynorRatio120', u'InformationRatio20', u'InformationRatio60', u'InformationRatio120', u'GainVariance20', u'GainVariance60', u'GainVariance120', u'LossVariance20', u'LossVariance60', u'LossVariance120', u'GainLossVarianceRatio20', u'GainLossVarianceRatio60', u'GainLossVarianceRatio120', u'RealizedVolatility', u'REVS60', u'REVS120', u'REVS250', u'REVS750', u'REVS5m20', u'REVS5m60', u'REVS5Indu1', u'REVS20Indu1', u'Volumn1M', u'Volumn3M', u'Price1M', u'Price3M', u'Price1Y', u'Rank1M', u'CashDividendCover', u'DividendCover', u'DividendPaidRatio', u'RetainedEarningRatio', u'CashEquivalentPS', u'DividendPS', u'EPSTTM', u'NetAssetPS', u'TORPS', u'TORPSLatest', u'OperatingRevenuePS', u'OperatingRevenuePSLatest', u'OperatingProfitPS', u'OperatingProfitPSLatest', u'CapitalSurplusFundPS', u'SurplusReserveFundPS', u'UndividedProfitPS', u'RetainedEarningsPS', u'OperCashFlowPS', u'CashFlowPS', u'NetNonOIToTP', u'NetNonOIToTPLatest', u'PeriodCostsRate', u'InterestCover', u'NetProfitGrowRate3Y', u'NetProfitGrowRate5Y', u'OperatingRevenueGrowRate3Y', u'OperatingRevenueGrowRate5Y', u'NetCashFlowGrowRate', u'NetProfitCashCover', u'OperCashInToAsset', u'CashConversionCycle', u'OperatingCycle', u'PEG3Y', u'PEG5Y', u'PEIndu', u'PBIndu', u'PSIndu', u'PCFIndu', u'PEHist20', u'PEHist60', u'PEHist120', u'PEHist250', u'StaticPE', u'ForwardPE', u'EnterpriseFCFPS', u'ShareholderFCFPS', u'ROEDiluted', u'ROEAvg', u'ROEWeighted', u'ROECut', u'ROECutWeighted', u'ROIC', u'ROAEBIT', u'ROAEBITTTM', u'OperatingNIToTP', u'OperatingNIToTPLatest', u'InvestRAssociatesToTP', u'InvestRAssociatesToTPLatest', u'NPCutToNP', u'SuperQuickRatio', u'TSEPToInterestBearDebt', u'DebtTangibleEquityRatio', u'TangibleAToInteBearDebt', u'TangibleAToNetDebt', u'NOCFToTLiability', u'NOCFToInterestBearDebt', u'NOCFToNetDebt', u'TSEPToTotalCapital', u'InteBearDebtToTotalCapital', u'NPParentCompanyCutYOY', u'SalesServiceCashToORLatest', u'CashRateOfSalesLatest', u'NOCFToOperatingNILatest', u'TotalAssets', u'MktValue', u'NegMktValue', u'TEAP', u'NIAP', u'TotalFixedAssets', u'IntFreeCL', u'IntFreeNCL', u'IntCL', u'IntDebt', u'NetDebt', u'NetTangibleAssets', u'WorkingCapital', u'NetWorkingCapital', u'TotalPaidinCapital', u'RetainedEarnings', u'OperateNetIncome', u'ValueChgProfit', u'NetIntExpense', u'EBIT', u'EBITDA', u'EBIAT', u'NRProfitLoss', u'NIAPCut', u'FCFF', u'FCFE', u'DA', u'TRevenueTTM', u'TCostTTM', u'RevenueTTM', u'CostTTM', u'GrossProfitTTM', u'SalesExpenseTTM', u'AdminExpenseTTM', u'FinanExpenseTTM', u'AssetImpairLossTTM', u'NPFromOperatingTTM', u'NPFromValueChgTTM', u'OperateProfitTTM', u'NonOperatingNPTTM', u'TProfitTTM', u'NetProfitTTM', u'NetProfitAPTTM', u'SaleServiceRenderCashTTM', u'NetOperateCFTTM', u'NetInvestCFTTM', u'NetFinanceCFTTM', u'GrossProfit', u'Beta252', u'RSTR504', u'EPIBS', u'CETOP', u'DASTD', u'CmraCNE5', u'HsigmaCNE5', u'SGRO', u'EgibsLong', u'STOM', u'STOQ', u'STOA', u'NLSIZE']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktVolAdjfGet(secID = "", ticker = "", beginDate = "", endDate = "", exchangeCD = "", exDivDate = "", field = "", pandas = "1"):
    """
    沪深股票成交量复权因子，包含单次和累计成交量前后复权因子，每日早上8:30更新
    
    :param secID: 通联编制的证券编码，格式是“交易代码.证券市场代码”，如000001.XSHE。 可传入证券交易代码使用DataAPI.SecIDGet接口获取到。,可以是列表,secID、ticker、beginDate、endDate、exchangeCD至少选择一个
    :param ticker: 股票交易代码，如'000001',可以是列表,secID、ticker、beginDate、endDate、exchangeCD至少选择一个
    :param beginDate: 除权除息日查询为基准，查询开始日期,输入格式"YYYYMMDD",secID、ticker、beginDate、endDate、exchangeCD至少选择一个
    :param endDate: 除权除息日查询为基准，查询截止日期,输入格式"YYYYMMDD",secID、ticker、beginDate、endDate、exchangeCD至少选择一个
    :param exchangeCD: 通联编制的证券市场编码。例如，XSHG-上海证券交易所；XSHE-深圳证券交易所；XIBE-中国银行间市场等。对应DataAPI.SysCodeGet.codeTypeID=10002。,可以是列表,secID、ticker、beginDate、endDate、exchangeCD至少选择一个
    :param exDivDate: 除权除息日，输入格式：YYYYMMDD,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktVolAdjf.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&exchangeCD=")
    if hasattr(exchangeCD,'__iter__') and not isinstance(exchangeCD, str):
        if len(exchangeCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = exchangeCD
            requestString.append(None)
        else:
            requestString.append(','.join(exchangeCD))
    else:
        requestString.append(exchangeCD)
    try:
        exDivDate = exDivDate.strftime('%Y%m%d')
    except:
        exDivDate = exDivDate.replace('-', '')
    requestString.append("&exDivDate=%s"%(exDivDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1864)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1864)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'exchangeCD', u'secShortName', u'exDivDate', u'preShareDivRatio', u'perShareTransRatio', u'allotmentRatio', u'splitsRatio', u'adjFactor3', u'accumAdjFactor3', u'adjFactor4', u'accumAdjFactor4']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','exchangeCD': 'str','secShortName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktFutwGet(secID = "", ticker = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    期货周行情，每个合约仅计算当日有交易的交易日数据，每日下午17:00更新
    
    :param secID: 合约内部编码，可传入证券交易代码使用DataAPI.SecIDGet接口获取到。,可以是列表,secID、ticker、beginDate、endDate至少选择一个
    :param ticker: 期货合约在证券市场通用的交易代码。,可以是列表,secID、ticker、beginDate、endDate至少选择一个
    :param beginDate: 起始日期，为每周最后一个交易日，yyyymmdd格式,secID、ticker、beginDate、endDate至少选择一个
    :param endDate: 截止日期，为每周最后一个交易日，yyyymmdd格式,secID、ticker、beginDate、endDate至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktFutw.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1872)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1872)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'endDate', u'tradeDays', u'preClosePrice', u'preSettlePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'settlePrice', u'turnoverVol', u'turnoverVolChg', u'turnoverValue', u'turnoverValueChg', u'openInt', u'openIntChg', u'chg', u'chg1']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktFutmGet(secID = "", ticker = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    期货月行情，每个合约仅计算当日有交易的交易日数据，每日下午17:00更新
    
    :param secID: 合约内部编码，可传入证券交易代码使用DataAPI.SecIDGet接口获取到。,可以是列表,secID、ticker、beginDate、endDate至少选择一个
    :param ticker: 期货合约在证券市场通用的交易代码。,可以是列表,secID、ticker、beginDate、endDate至少选择一个
    :param beginDate: 起始日期，为每月最后一个日期，yyyymmdd格式,secID、ticker、beginDate、endDate至少选择一个
    :param endDate: 截止日期，为每月最后一个日期，yyyymmdd格式,secID、ticker、beginDate、endDate至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktFutm.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1873)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1873)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'endDate', u'tradeDays', u'preClosePrice', u'preSettlePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'settlePrice', u'turnoverVol', u'turnoverVolChg', u'turnoverValue', u'turnoverValueChg', u'openInt', u'openIntChg', u'chg', u'chg1']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktAdjfAfMGet(secID = "", ticker = "", exDivDate = "", field = "", pandas = "1"):
    """
    获取沪深A股和B股调整行情的后复权因子数据（以上市价格为基准），包含除权除息日、除权除息事项具体数据、本次复权因子、累积复权因子以及因子调整的截止日期。该因子用来调整历史行情，不作为预测使用，于除权除息日进行计算调整，数据于每日早上9:00更新。
    
    :param secID: 通联编制的证券编码，格式是“交易代码.证券市场代码”，如000001.XSHE。 可传入证券交易代码使用DataAPI.SecIDGet接口获取到。,可以是列表,secID、ticker、exDivDate至少选择一个
    :param ticker: 一只或多只股票代码，用,分隔，如000001,000002。,可以是列表,secID、ticker、exDivDate至少选择一个
    :param exDivDate: 除权除息日,可以是列表,secID、ticker、exDivDate至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktAdjfAfM.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&exDivDate=")
    if hasattr(exDivDate,'__iter__') and not isinstance(exDivDate, str):
        if len(exDivDate) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = exDivDate
            requestString.append(None)
        else:
            requestString.append(','.join(exDivDate))
    else:
        requestString.append(exDivDate)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1877)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1877)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'exDivDate', u'perCashDiv', u'perShareDivRatio', u'perShareTransRatio', u'allotmentRatio', u'allotmentPrice', u'adjFactor', u'accumAdjFactor']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktCmeFutdGet(ticker = "", tradeDate = "", beginDate = "", endDate = "", contractObject = "", field = "", pandas = "1"):
    """
    获取CME Group所有期货合约日行情信息，CME Group引领国际期货市场发展，包含芝加哥商业交易所 (CME)、 芝加哥期货交易所(CBOT)、纽约商业交易所 (NYMEX)、纽约商品交易所 (COMEX)，数据每日10:00am更新
    
    :param ticker: 合约在CME交易的交易代码,可以是列表,ticker、tradeDate、beginDate、endDate、contractObject至少选择一个
    :param tradeDate: 交易日期，格式为yyyymmdd,可以是列表,ticker、tradeDate、beginDate、endDate、contractObject至少选择一个
    :param beginDate: 起始日期，格式为yyyymmdd,ticker、tradeDate、beginDate、endDate、contractObject至少选择一个
    :param endDate: 结束日期，格式为yyyymmdd,ticker、tradeDate、beginDate、endDate、contractObject至少选择一个
    :param contractObject: CME全品种标的： HG0--铜现货（TAS） GCT--黄金期货（TAS） GCK--黄金期货 HGS--铜金融期货 ZNC--锌期货 SIT--银期货（TAS） MJP--铝日本普氏期货 SI--银期货 SIL--1000盎司白银期货 AUP--铝MW美国交易溢价普氏期货 LED--铅期货 AEP--欧洲豪华铝金属通报期货 A38--铝合金（A-380标准普尔全球普氏）期货 ALI--物理铝期货 HG--铜期货 HGT--铜期货（TAS） QO--迷你黄金期货 QI--迷你白银期货 EDP--欧洲完税铝溢价期货合约 MGC--E-微型黄金期货 QC--E-微型铜期货 GC--黄金期货 其中TAS为Trade at Settlement,可以是列表,ticker、tradeDate、beginDate、endDate、contractObject至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktCmeFutd.csv?ispandas=1&') 
    requestString.append("ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&tradeDate=")
    if hasattr(tradeDate,'__iter__') and not isinstance(tradeDate, str):
        if len(tradeDate) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = tradeDate
            requestString.append(None)
        else:
            requestString.append(','.join(tradeDate))
    else:
        requestString.append(tradeDate)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&contractObject=")
    if hasattr(contractObject,'__iter__') and not isinstance(contractObject, str):
        if len(contractObject) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = contractObject
            requestString.append(None)
        else:
            requestString.append(','.join(contractObject))
    else:
        requestString.append(contractObject)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1879)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1879)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'ticker', u'tradeDate', u'deliYear', u'deliMonth', u'deliDate', u'secFullName', u'contractObject', u'preSettlePrice', u'preOpenInt', u'openPrice', u'highestPrice', u'highestPriceSide', u'lowestPrice', u'lowestPriceSide', u'closePrice', u'closePriceSide', u'settlePrice', u'chg', u'turnoverVol']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'ticker': 'str','secFullName': 'str','contractObject': 'str','highestPriceSide': 'str','lowestPriceSide': 'str','closePriceSide': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktFutLimitGet(secID = "", ticker = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取期货合约每个交易日的涨停价和跌停价信息，目前只包括正在进行交易合约的信息，每日16:00更新
    
    :param secID: 合约内部编码，可传入证券交易代码使用DataAPI.SecIDGet接口获取到。,可以是列表,secID、ticker、beginDate、endDate至少选择一个
    :param ticker: 期货合约在证券市场通用的交易代码。,可以是列表,secID、ticker、beginDate、endDate至少选择一个
    :param beginDate: 根据交易日期范围查询的起始日期，输入格式“YYYYMMDD”,secID、ticker、beginDate、endDate至少选择一个
    :param endDate: 根据交易日期范围查询的截止日期，输入格式“YYYYMMDD”,secID、ticker、beginDate、endDate至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktFutLimit.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1889)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1889)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'tradeDATE', u'limitUpPrice', u'limitDownPrice']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktIpoConTraddaysGet(secID = "", ticker = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取2010年以后上市的股票连板天数信息，包括是否持续连板以及连板收益率等，每日16:00更新
    
    :param secID: 通联编制的证券编码，格式是“交易代码.证券市场代码”，如000001.XSHE。 可传入证券交易代码使用DataAPI.SecIDGet接口获取到。,可以是列表,secID、ticker、beginDate、endDate至少选择一个
    :param ticker: 证券在证券市场通用的交易代码。,可以是列表,secID、ticker、beginDate、endDate至少选择一个
    :param beginDate: 上市日期起始日期，输入格式“YYYYMMDD”,secID、ticker、beginDate、endDate至少选择一个
    :param endDate: 上市日期截止日期，输入格式“YYYYMMDD”,secID、ticker、beginDate、endDate至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktIpoConTraddays.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1890)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1890)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'listDate', u'issuePrice', u'firstDayClosePrice', u'firstDayChgPct', u'breakConClosePrice', u'continiousTradDays', u'conReturn', u'isContinue']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def RrpMktRLStkNrGet(secID = "", ticker = "", beginDate = "", endDate = "", uniqID = "", abnormalTypeCD = "", field = "", pandas = "1"):
    """
    晚报-龙虎榜列表
    
    :param secID: 证券ID,可以是列表,可空
    :param ticker: 交易代码,可以是列表,可空
    :param beginDate: 根据交易日期范围查询的开始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 根据交易日期范围查询的结束日期，输入格式“YYYYMMDD”,可空
    :param uniqID: 龙虎榜单编码,可以是列表,可空
    :param abnormalTypeCD: 异动类型代码,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getRrpMktRLStkNr.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&uniqID=")
    if hasattr(uniqID,'__iter__') and not isinstance(uniqID, str):
        if len(uniqID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = uniqID
            requestString.append(None)
        else:
            requestString.append(','.join(uniqID))
    else:
        requestString.append(uniqID)
    requestString.append("&abnormalTypeCD=")
    if hasattr(abnormalTypeCD,'__iter__') and not isinstance(abnormalTypeCD, str):
        if len(abnormalTypeCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = abnormalTypeCD
            requestString.append(None)
        else:
            requestString.append(','.join(abnormalTypeCD))
    else:
        requestString.append(abnormalTypeCD)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'exchangeCD', u'exchangeName', u'secShortName', u'tradeDate', u'abnormalDisplay', u'abnormalTypeCD', u'abnormalType', u'uniqID', u'deviation', u'turnoverVol', u'turnoverValue', u'abnormalBeginDate', u'abnormalEndDate']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','exchangeCD': 'str','exchangeName': 'str','secShortName': 'str','abnormalDisplay': 'str','abnormalTypeCD': 'str','abnormalType': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def RrpMktRLStatNrGet(secID = "", ticker = "", beginDate = "", endDate = "", side = "", uniqID = "", abnormalTypeCD = "", field = "", pandas = "1"):
    """
    晚报-龙虎榜分类型统计
    
    :param secID: 证券ID,可以是列表,可空
    :param ticker: 交易代码,可以是列表,可空
    :param beginDate: 根据交易日期范围查询的开始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 根据交易日期范围查询的结束日期，输入格式“YYYYMMDD”,可空
    :param side: 买卖方向,可以是列表,可空
    :param uniqID: 龙虎榜单编码,可以是列表,可空
    :param abnormalTypeCD: 异动类型代码,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getRrpMktRLStatNr.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&side=")
    if hasattr(side,'__iter__') and not isinstance(side, str):
        if len(side) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = side
            requestString.append(None)
        else:
            requestString.append(','.join(side))
    else:
        requestString.append(side)
    requestString.append("&uniqID=")
    if hasattr(uniqID,'__iter__') and not isinstance(uniqID, str):
        if len(uniqID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = uniqID
            requestString.append(None)
        else:
            requestString.append(','.join(uniqID))
    else:
        requestString.append(uniqID)
    requestString.append("&abnormalTypeCD=")
    if hasattr(abnormalTypeCD,'__iter__') and not isinstance(abnormalTypeCD, str):
        if len(abnormalTypeCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = abnormalTypeCD
            requestString.append(None)
        else:
            requestString.append(','.join(abnormalTypeCD))
    else:
        requestString.append(abnormalTypeCD)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'exchangeCD', u'exchangeName', u'secShortName', u'tradeDate', u'abnormalTypeCD', u'uniqID', u'side', u'rank', u'buyValue', u'sellValue', u'netValue']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','exchangeCD': 'str','exchangeName': 'str','secShortName': 'str','abnormalTypeCD': 'str','side': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def RrpMktRLSalesNrGet(secID = "", ticker = "", beginDate = "", endDate = "", side = "", uniqID = "", abnormalTypeCD = "", field = "", pandas = "1"):
    """
    晚报-龙虎榜成交明细
    
    :param secID: 证券ID,可以是列表,可空
    :param ticker: 交易代码,可以是列表,可空
    :param beginDate: 根据交易日期范围查询的开始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 根据交易日期范围查询的结束日期，输入格式“YYYYMMDD”,可空
    :param side: 买卖方向,可以是列表,可空
    :param uniqID: 龙虎榜单编码,可以是列表,可空
    :param abnormalTypeCD: 异动类型代码,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getRrpMktRLSalesNr.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&side=")
    if hasattr(side,'__iter__') and not isinstance(side, str):
        if len(side) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = side
            requestString.append(None)
        else:
            requestString.append(','.join(side))
    else:
        requestString.append(side)
    requestString.append("&uniqID=")
    if hasattr(uniqID,'__iter__') and not isinstance(uniqID, str):
        if len(uniqID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = uniqID
            requestString.append(None)
        else:
            requestString.append(','.join(uniqID))
    else:
        requestString.append(uniqID)
    requestString.append("&abnormalTypeCD=")
    if hasattr(abnormalTypeCD,'__iter__') and not isinstance(abnormalTypeCD, str):
        if len(abnormalTypeCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = abnormalTypeCD
            requestString.append(None)
        else:
            requestString.append(','.join(abnormalTypeCD))
    else:
        requestString.append(abnormalTypeCD)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'exchangeCD', u'exchangeName', u'secShortName', u'tradeDate', u'abnormalTypeCD', u'abnormalType', u'uniqID', u'side', u'rank', u'sales', u'buyValue', u'sellValue', u'totalValue', u'netValue']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','exchangeCD': 'str','exchangeName': 'str','secShortName': 'str','abnormalTypeCD': 'str','abnormalType': 'str','side': 'str','sales': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktIdxFactorOneDayGet(tradeDate, secID = "", ticker = "", field = "", pandas = "1"):
    """
    获取多个指数历史上某一天的因子数据
    
    :param tradeDate: 交易日期
    :param secID: 多个指数ID，用逗号隔开,可以是列表,可空
    :param ticker: 多个指数代码，用逗号隔开,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktIdxFactorOneDay.csv?ispandas=1&') 
    if not isinstance(tradeDate, str) and not isinstance(tradeDate, unicode):
        tradeDate = str(tradeDate)

    requestString.append("tradeDate=%s"%(tradeDate))
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1896)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1896)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'tradeDate', u'ticker', u'ChgPct', u'Close', u'DownPct', u'LimitDownPct', u'LimitUpPct', u'MA5', u'MA10', u'MA20', u'MA60', u'MA120', u'MACD', u'DIFF', u'DEA', u'PB1', u'PB2', u'PE1', u'PE2', u'RSI12', u'TurnoverValue', u'TurnoverVol', u'UpPct', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktIdxFactorDateRangeGet(secID = "", ticker = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取一个指数历史上某一时间段的因子数据
    
    :param secID: 一个指数ID,secID、ticker至少选择一个
    :param ticker: 一个指数代码,secID、ticker至少选择一个
    :param beginDate: 开始日期,可空
    :param endDate: 结束日期,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktIdxFactorDateRange.csv?ispandas=1&') 
    if not isinstance(secID, str) and not isinstance(secID, unicode):
        secID = str(secID)

    requestString.append("secID=%s"%(secID))
    if not isinstance(ticker, str) and not isinstance(ticker, unicode):
        ticker = str(ticker)

    requestString.append("&ticker=%s"%(ticker))
    if not isinstance(beginDate, str) and not isinstance(beginDate, unicode):
        beginDate = str(beginDate)

    requestString.append("&beginDate=%s"%(beginDate))
    if not isinstance(endDate, str) and not isinstance(endDate, unicode):
        endDate = str(endDate)

    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1897)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1897)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'tradeDate', u'ticker', u'ChgPct', u'Close', u'DownPct', u'LimitDownPct', u'LimitUpPct', u'MA5', u'MA10', u'MA20', u'MA60', u'MA120', u'MACD', u'DIFF', u'DEA', u'PB1', u'PB2', u'PE1', u'PE2', u'RSI12', u'TurnoverValue', u'TurnoverVol', u'UpPct', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktGEMEvaluateGet(beginDate, endDate, field = "", pandas = "1"):
    """
    获取每日创业板估值信息，即每日动态市盈率处于不同标准的股票个数信息，每日18:30更新
    
    :param beginDate: 交易日的起始日期，输入格式“YYYYMMDD”
    :param endDate: 交易日的截止日期，输入格式“YYYYMMDD”
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktGEMEvaluate.csv?ispandas=1&') 
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1956)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1956)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'tradeDate', u'numUnder50', u'numUnder100', u'numUnder150', u'numUnder200', u'numOver200']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktFutOiRatioGet(contractObject, beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取每日个期货品种多空持仓占比情况，包含一个品种持买量、持卖量及持卖量占持买量的比例，每日18:30更新
    
    :param contractObject: 期货合约标的。例如，CU-阴极铜，AU-黄金。对应DataAPI.SysCodeGet.codeTypeID=60003。,可以是列表
    :param beginDate: 交易日的起始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 交易日的截止日期，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktFutOiRatio.csv?ispandas=1&') 
    requestString.append("contractObject=")
    if hasattr(contractObject,'__iter__') and not isinstance(contractObject, str):
        if len(contractObject) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = contractObject
            requestString.append(None)
        else:
            requestString.append(','.join(contractObject))
    else:
        requestString.append(contractObject)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1957)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1957)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'contractObject', u'contractObjectCn', u'tradeDate', u'longOpenInt', u'shortOpenInt', u'ratio']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'contractObject': 'str','contractObjectCn': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktFutIdxBasisGet(secID = "", ticker = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取估值期货升贴水信息，包含期货价格、对应股指价格及每个股指期货合约的升贴水情况，每日18:30更新
    
    :param secID: 通联编制的证券编码，格式是“交易代码.证券市场代码”，如000001.XSHE。 可传入证券交易代码使用DataAPI.SecIDGet接口获取到。,可以是列表,secID、ticker、beginDate、endDate至少选择一个
    :param ticker: 期货合约在证券市场通用的交易代码。,可以是列表,secID、ticker、beginDate、endDate至少选择一个
    :param beginDate: 交易日的起始日期，输入格式“YYYYMMDD”,secID、ticker、beginDate、endDate至少选择一个
    :param endDate: 交易日的截止日期，输入格式“YYYYMMDD”,secID、ticker、beginDate、endDate至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktFutIdxBasis.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1958)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1958)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'secShortName', u'ticker', u'exchangeCD', u'tradeDate', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'indexID', u'indexSymbol', u'closeIndex', u'basis']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','secShortName': 'str','ticker': 'str','exchangeCD': 'str','indexSymbol': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktIdxdEvalGet(secID = "", ticker = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取指数估值信息，包含市值、PE、PB等信息，目前仅包含上证综指、沪深300、中小板综、中小板指、创业板指、创业板R、创业板综，每日18:30更新
    
    :param secID: 通联编制的证券编码，格式是“交易代码.证券市场代码”，如000001.XSHE。 可传入证券交易代码使用DataAPI.SecIDGet接口获取到。,可以是列表,secID、ticker、beginDate、endDate至少选择一个
    :param ticker: 证券在证券市场通用的交易代码。,可以是列表,secID、ticker、beginDate、endDate至少选择一个
    :param beginDate: 交易日的起始日期，输入格式“YYYYMMDD”,secID、ticker、beginDate、endDate至少选择一个
    :param endDate: 交易日的截止日期，输入格式“YYYYMMDD”,secID、ticker、beginDate、endDate至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktIdxdEval.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1959)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1959)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'progFullName', u'secShortName', u'exchangeCD', u'tradeDate', u'indexMarketValue', u'indexIncome', u'indexAttrP', u'PEValue', u'PEType', u'PB']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','progFullName': 'str','secShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktIndustryEvalGet(beginDate, endDate, industryID = "", field = "", pandas = "1"):
    """
    获取申万三级行业估计信息，包含市值、PE、PB等信息，每日18:30更新
    
    :param beginDate: 交易日的起始日期，输入格式“YYYYMMDD”
    :param endDate: 交易日的截止日期，输入格式“YYYYMMDD”
    :param industryID: 通联编制的行业分类编码，可以通过getIndustry获取。,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktIndustryEval.csv?ispandas=1&') 
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&industryID=")
    if hasattr(industryID,'__iter__') and not isinstance(industryID, str):
        if len(industryID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = industryID
            requestString.append(None)
        else:
            requestString.append(','.join(industryID))
    else:
        requestString.append(industryID)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1960)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1960)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'industryID', u'industryName', u'tradeDate', u'industryMarketValue', u'industryIncome', u'industryAttrP', u'PEValue', u'PEType', u'PB']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'industryID': 'str','industryName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktRankDivYieldGet(beginDate, endDate, field = "", pandas = "1"):
    """
    获取每日股息率排名前100的股票信息，包含当日的收盘价、近一年分红汇总及股息率，每日18:30更新
    
    :param beginDate: 交易日的起始日期，输入格式“YYYYMMDD”
    :param endDate: 交易日的截止日期，输入格式“YYYYMMDD”
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktRankDivYield.csv?ispandas=1&') 
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1961)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1961)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'tradeDate', u'closePrice', u'sumDivTTM', u'divRate', u'rank']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktConsBondPremiumGet(SecID = "", tickerBond = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取可转债折溢价信息，包含每日可转债价格、正股价格、可转债折溢价等信息，每日18:30更新
    
    :param SecID: 通联编制的证券编码，格式是“交易代码.证券市场代码”，如000001.XSHE。 可传入证券交易代码使用DataAPI.SecIDGet接口获取到。,可以是列表,SecID、tickerBond、beginDate、endDate至少选择一个
    :param tickerBond: 证券在证券市场通用的交易代码。,可以是列表,SecID、tickerBond、beginDate、endDate至少选择一个
    :param beginDate: 交易日的起始日期，输入格式“YYYYMMDD”,SecID、tickerBond、beginDate、endDate至少选择一个
    :param endDate: 交易日的截止日期，输入格式“YYYYMMDD”,SecID、tickerBond、beginDate、endDate至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktConsBondPremium.csv?ispandas=1&') 
    requestString.append("SecID=")
    if hasattr(SecID,'__iter__') and not isinstance(SecID, str):
        if len(SecID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = SecID
            requestString.append(None)
        else:
            requestString.append(','.join(SecID))
    else:
        requestString.append(SecID)
    requestString.append("&tickerBond=")
    if hasattr(tickerBond,'__iter__') and not isinstance(tickerBond, str):
        if len(tickerBond) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = tickerBond
            requestString.append(None)
        else:
            requestString.append(','.join(tickerBond))
    else:
        requestString.append(tickerBond)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1962)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1962)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'SecID', u'tickerBond', u'secShortNameBond', u'tradeDate', u'closePriceBond', u'tickerEqu', u'secShortNameEqu', u'closePriceEqu', u'convPrice', u'bondPremDisc']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'SecID': 'str','tickerBond': 'str','secShortNameBond': 'str','tickerEqu': 'str','secShortNameEqu': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktNeeqEqudGet(secID = "", ticker = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取每日新三板股票日行情信息，包含股票的开、高、低、收、量等信息，每日17:00更新
    
    :param secID: 通联编制的证券编码，格式是“交易代码.证券市场代码”，如000001.XSHE。 可传入证券交易代码使用DataAPI.SecIDGet接口获取到。,可以是列表,secID、ticker、beginDate、endDate至少选择一个
    :param ticker: 证券在证券市场通用的交易代码。,可以是列表,secID、ticker、beginDate、endDate至少选择一个
    :param beginDate: 交易日的起始日期，输入格式“YYYYMMDD”,secID、ticker、beginDate、endDate至少选择一个
    :param endDate: 交易日的截止日期，输入格式“YYYYMMDD”,secID、ticker、beginDate、endDate至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktNeeqEqud.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1963)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1963)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'secShortName', u'ticker', u'exchangeCD', u'tradeDate', u'preClosePrice', u'actPreClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'turnoverValue', u'marketValue', u'negMarketValue', u'chgPct', u'rangePct', u'turnoverRate']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','secShortName': 'str','ticker': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktNeeqDpoGet(SecID = "", ticker = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取每日新三板盘前静态信息，包含每股面值、涨停价、跌停价等信息，每日9:20更新
    
    :param SecID: 通联编制的证券编码，格式是“交易代码.证券市场代码”，如000001.XSHE。 可传入证券交易代码使用DataAPI.SecIDGet接口获取到。,可以是列表,SecID、ticker、beginDate、endDate至少选择一个
    :param ticker: 证券在证券市场通用的交易代码。,可以是列表,SecID、ticker、beginDate、endDate至少选择一个
    :param beginDate: 交易日的起始日期，输入格式“YYYYMMDD”,SecID、ticker、beginDate、endDate至少选择一个
    :param endDate: 交易日的截止日期，输入格式“YYYYMMDD”,SecID、ticker、beginDate、endDate至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktNeeqDpo.csv?ispandas=1&') 
    requestString.append("SecID=")
    if hasattr(SecID,'__iter__') and not isinstance(SecID, str):
        if len(SecID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = SecID
            requestString.append(None)
        else:
            requestString.append(','.join(SecID))
    else:
        requestString.append(SecID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1964)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1964)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'SecID', u'secShortName', u'ticker', u'exchangeCD', u'tradeDate', u'transUnit', u'industryCategory', u'par', u'baseTicker', u'totalShares', u'nonrestFloatShares', u'EPSLy', u'listDate', u'firstAccrDate', u'perDealLimit', u'bidUnit', u'askUnit', u'fdTransLimitCd', u'dTransLimitCd', u'transLimitCdType', u'limitUpPrice', u'limitDownPrice', u'blockLimitUpPrice', u'blockLimitDownPrice', u'divRatio', u'transStatus', u'equType', u'transType', u'marketMakerVol', u'haltSymbol', u'divSymbol']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'SecID': 'str','secShortName': 'str','ticker': 'str','exchangeCD': 'str','industryCategory': 'str','baseTicker': 'str','transStatus': 'str','equType': 'str','transType': 'str','haltSymbol': 'str','divSymbol': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def NeeqStockTicksHistOneDayGet(ticker, date, startTime = "", endTime = "", field = "", pandas = "1"):
    """
    高频数据，获取一只新三板证券在历史上某一天内的Tick数据。 输入一只证券交易代码，如400002（长白5）。
    
    :param ticker: 证券6位代码， 如400002,可以是列表
    :param date: 数据日期。格式是YYYYMMDD。
    :param startTime: 交易起始时间。输入格式为hh:mm,可空
    :param endTime: 交易截止时间。输入格式为hh:mm,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getNeeqStockTicksHistOneDay.csv?ispandas=1&') 
    requestString.append("ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    if not isinstance(date, str) and not isinstance(date, unicode):
        date = str(date)

    requestString.append("&date=%s"%(date))
    if not isinstance(startTime, str) and not isinstance(startTime, unicode):
        startTime = str(startTime)

    requestString.append("&startTime=%s"%(startTime))
    if not isinstance(endTime, str) and not isinstance(endTime, unicode):
        endTime = str(endTime)

    requestString.append("&endTime=%s"%(endTime))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'ticker', u'shortNm', u'dataDate', u'dataTime', u'timeOffset', u'statusCode', u'preclosePrice', u'openPrice', u'lastPrice', u'volume', u'value', u'highPrice', u'lowPrice', u'askPrice1', u'askVolume1', u'askPrice2', u'askVolume2', u'askPrice3', u'askVolume3', u'askPrice4', u'askVolume4', u'askPrice5', u'askVolume5', u'bidPrice1', u'bidVolume1', u'bidPrice2', u'bidVolume2', u'bidPrice3', u'bidVolume3', u'bidPrice4', u'bidVolume4', u'bidPrice5', u'bidVolume5', u'localTime', u'seqNo']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'ticker': 'str','shortNm': 'str','dataDate': 'str','dataTime': 'str','timeOffset': 'str','localTime': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def NeeqIndexTicksHistOneDayGet(ticker, date, startTime = "", endTime = "", field = "", pandas = "1"):
    """
    高频数据，获取一只新三板证券在历史上某一天内的Tick数据。 输入一只指数交易代码，如899001（三板成指）。
    
    :param ticker: 指数6位代码， 如899001,可以是列表
    :param date: 数据日期。格式是YYYYMMDD。
    :param startTime: 交易起始时间。输入格式为hh:mm,可空
    :param endTime: 交易截止时间。输入格式为hh:mm,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getNeeqIndexTicksHistOneDay.csv?ispandas=1&') 
    requestString.append("ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    if not isinstance(date, str) and not isinstance(date, unicode):
        date = str(date)

    requestString.append("&date=%s"%(date))
    if not isinstance(startTime, str) and not isinstance(startTime, unicode):
        startTime = str(startTime)

    requestString.append("&startTime=%s"%(startTime))
    if not isinstance(endTime, str) and not isinstance(endTime, unicode):
        endTime = str(endTime)

    requestString.append("&endTime=%s"%(endTime))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'ticker', u'shortNm', u'dataDate', u'dataTime', u'timeOffset', u'statusCode', u'preclosePrice', u'openPrice', u'lastPrice', u'volume', u'value', u'highPrice', u'lowPrice', u'localTime', u'seqNo']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'ticker': 'str','shortNm': 'str','dataTime': 'str','timeOffset': 'str','localTime': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def NeeqTransactionTicksHistOneDayGet(ticker, date, startTime = "", endTime = "", field = "", pandas = "1"):
    """
    高频数据，获取一只新三板证券在历史上某一天内的协议成交数据，输入一只证券交易代码，如831850（分豆教育）
    
    :param ticker: 证券6位代码， 如400002,可以是列表
    :param date: 数据日期。格式是YYYYMMDD。
    :param startTime: 交易起始时间。输入格式为hh:mm,可空
    :param endTime: 交易截止时间。输入格式为hh:mm,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getNeeqTransactionTicksHistOneDay.csv?ispandas=1&') 
    requestString.append("ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    if not isinstance(date, str) and not isinstance(date, unicode):
        date = str(date)

    requestString.append("&date=%s"%(date))
    if not isinstance(startTime, str) and not isinstance(startTime, unicode):
        startTime = str(startTime)

    requestString.append("&startTime=%s"%(startTime))
    if not isinstance(endTime, str) and not isinstance(endTime, unicode):
        endTime = str(endTime)

    requestString.append("&endTime=%s"%(endTime))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'ticker', u'dataDate', u'orderTime', u'dataTime', u'transactionUnit', u'transactionType', u'volume', u'price', u'recordStatus', u'localTime', u'seqNo']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'ticker': 'str','orderTime': 'str','dataTime': 'str','transactionUnit': 'str','transactionType': 'str','recordStatus': 'str','localTime': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def NOBBTickRTIntraDayGet(ticker, startTime = "", endTime = "", field = "", pandas = "1"):
    """
    高频数据，获取一只新三板股票当日内时间段的tick信息。
    
    :param ticker: 证券6位代码， 如400002,可以是列表
    :param startTime: 开始时间，必须大于等于09:25，例如10:05，如果为空则是09:25,可空
    :param endTime: 结束时间，必须小于等于15:05，例如14:20，如果为空则是15：05,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getNOBBTickRTIntraDay.csv?ispandas=1&') 
    requestString.append("ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    if not isinstance(startTime, str) and not isinstance(startTime, unicode):
        startTime = str(startTime)

    requestString.append("&startTime=%s"%(startTime))
    if not isinstance(endTime, str) and not isinstance(endTime, unicode):
        endTime = str(endTime)

    requestString.append("&endTime=%s"%(endTime))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'ticker', u'dataDate', u'dataTime', u'shortNm', u'preclosePrice', u'openPrice', u'volume', u'value', u'deal', u'highPrice', u'lowPrice', u'lastPrice', u'bigPrice1', u'bigVolume1', u'bigPrice2', u'bigVolume2', u'bigPrice3', u'bigVolume3', u'bigPrice4', u'bigVolume4', u'bigPrice5', u'bigVolume5', u'askPrice1', u'askVolume1', u'askPrice2', u'askVolume2', u'askPrice3', u'askVolume3', u'askPrice4', u'askVolume4', u'askPrice5', u'askVolume5']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'ticker': 'str','dataDate': 'str','dataTime': 'str','shortNm': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def TickNOBBRTSnapshotGet(ticker, field = "", pandas = "1"):
    """
    高频数据，获取一只或多只新三板股票最新tick信息。 输入一只或多只证券代码，如000001，还有所选字段， 得到证券的最新交易快照。
    
    :param ticker: 证券6位代码， 如400002,可以是列表
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getTickNOBBRTSnapshot.csv?ispandas=1&') 
    requestString.append("ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'ticker', u'timestamp', u'change', u'changePct', u'dataTime', u'highPrice', u'lastPrice', u'localTimestamp', u'lowPrice', u'openPrice', u'prevClosePrice', u'shortNM', u'utcOffset', u'value', u'volume', u'askBook_price1', u'askBook_price2', u'askBook_price3', u'askBook_price4', u'askBook_price5', u'askBook_volume1', u'askBook_volume2', u'askBook_volume3', u'askBook_volume4', u'askBook_volume5', u'bidBook_price1', u'bidBook_price2', u'bidBook_price3', u'bidBook_price4', u'bidBook_price5', u'bidBook_volume1', u'bidBook_volume2', u'bidBook_volume3', u'bidBook_volume4', u'bidBook_volume5']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'ticker': 'str','timestamp': 'str','dataTime': 'str','localTimestamp': 'str','shortNM': 'str','utcOffset': 'str','value': 'str','volume': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktSubnewEqudGet(secID = "", ticker = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取每日次新股日行情信息，包含次新股的当日开高低收价等，每日18:00更新
    
    :param secID: 通联编制的证券编码，格式是“交易代码.证券市场代码”，如000001.XSHE。 可传入证券交易代码使用DataAPI.SecIDGet接口获取到。,可以是列表,secID、ticker、beginDate、endDate至少选择一个
    :param ticker: 证券在证券市场通用的交易代码。,可以是列表,secID、ticker、beginDate、endDate至少选择一个
    :param beginDate: 交易日的起始日期，输入格式“YYYYMMDD”,secID、ticker、beginDate、endDate至少选择一个
    :param endDate: 交易日的截止日期，输入格式“YYYYMMDD”,secID、ticker、beginDate、endDate至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktSubnewEqud.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1982)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1982)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'exchangeCD', u'boardID', u'boardName', u'tradeDate', u'preClosePrice', u'actPreClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'turnoverValue', u'dealAmount', u'PE', u'PE1', u'PB', u'marketValue', u'marketValue', u'chgPct', u'turnoverRate']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','exchangeCD': 'str','boardID': 'str','boardName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktAHCompdGet(secID = "", ticker = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取每日AH比价信息，包含A股收盘、H股收盘以及H股占A股比例等信息，每日18:00更新
    
    :param secID: 通联编制的证券编码，格式是“交易代码.证券市场代码”，如000002.XSHE。 可传入证券交易代码使用DataAPI.SecIDGet接口获取到。,可以是列表,secID、ticker、beginDate、endDate至少选择一个
    :param ticker: 证券在证券市场通用的交易代码。,可以是列表,secID、ticker、beginDate、endDate至少选择一个
    :param beginDate: 交易日的起始日期，输入格式“YYYYMMDD”,secID、ticker、beginDate、endDate至少选择一个
    :param endDate: 交易日的截止日期，输入格式“YYYYMMDD”,secID、ticker、beginDate、endDate至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktAHCompd.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1983)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1983)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'partyID', u'secIDA', u'tradeDate', u'tickerA', u'tickerH', u'secShortNameA', u'secShortNameH', u'closePriceA', u'closePriceH', u'closePriceHA', u'chgPctA', u'chgPctH', u'ahRatio', u'turnoverVolA', u'turnoverVolH']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secIDA': 'str','tickerA': 'str','tickerH': 'str','secShortNameA': 'str','secShortNameH': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktAdjfAfKunhongGet(secID = "", ticker = "", exchangeCD = "", exDivDate = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取沪深A股和B股调整行情的后复权因子数据（以上市价格为基准），包含除权除息日、除权除息事项具体数据、本次复权因子、累积复权因子以及因子调整的截止日期。该因子用来调整历史行情，不作为预测使用，于除权除息日进行计算调整。
    
    :param secID: 通联编制的证券编码，格式是“交易代码.证券市场代码”，如000001.XSHE。 可传入证券交易代码使用DataAPI.SecIDGet接口获取到。,可以是列表,secID、ticker、exchangeCD、exDivDate至少选择一个
    :param ticker: 一只或多只股票代码，用,分隔，如000001,000002。,可以是列表,secID、ticker、exchangeCD、exDivDate至少选择一个
    :param exchangeCD: 通联编制的证券市场编码。例如，XSHG-上海证券交易所；XSHE-深圳证券交易所；XIBE-中国银行间市场等。对应DataAPI.SysCodeGet.codeTypeID=10002。,可以是列表,secID、ticker、exchangeCD、exDivDate至少选择一个
    :param exDivDate: 除权除息日，输入格式：YYYYMMDD,secID、ticker、exchangeCD、exDivDate至少选择一个
    :param beginDate: 除权除息日查询为基准，查询开始日期，输入格式："YYYYMMDD",可空
    :param endDate: 除权除息日查询为基准，查询截止日期，输入格式："YYYYMMDD",可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktAdjfAfKunhong.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&exchangeCD=")
    if hasattr(exchangeCD,'__iter__') and not isinstance(exchangeCD, str):
        if len(exchangeCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = exchangeCD
            requestString.append(None)
        else:
            requestString.append(','.join(exchangeCD))
    else:
        requestString.append(exchangeCD)
    try:
        exDivDate = exDivDate.strftime('%Y%m%d')
    except:
        exDivDate = exDivDate.replace('-', '')
    requestString.append("&exDivDate=%s"%(exDivDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'exchangeCD', u'secShortName', u'secShortNameEn', u'exDivDate', u'perCashDiv', u'perShareDivRatio', u'perShareTransRatio', u'allotmentRatio', u'allotmentPrice', u'splitsRatio', u'adjFactor', u'accumAdjFactor', u'endDate']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','exchangeCD': 'str','secShortName': 'str','secShortNameEn': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FutureL1TransactionIntraDayGet(instrumentID, startTime = "", endTime = "", field = "", pandas = "1"):
    """
    高频数据，获取一只期货当日内时间段分笔成交信息，包含瞬时成交量，瞬时仓差，买卖方向，开平仓性质等。
    
    :param instrumentID: 一个期货合约代码，如A1009（大小写均可）,可以是列表
    :param startTime: 交易开始时间，格式为HH:SS,可空
    :param endTime: 交易截止时间，格式为HH:SS,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getFutureL1TransactionIntraDay.csv?ispandas=1&') 
    requestString.append("instrumentID=")
    if hasattr(instrumentID,'__iter__') and not isinstance(instrumentID, str):
        if len(instrumentID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = instrumentID
            requestString.append(None)
        else:
            requestString.append(','.join(instrumentID))
    else:
        requestString.append(instrumentID)
    if not isinstance(startTime, str) and not isinstance(startTime, unicode):
        startTime = str(startTime)

    requestString.append("&startTime=%s"%(startTime))
    if not isinstance(endTime, str) and not isinstance(endTime, unicode):
        endTime = str(endTime)

    requestString.append("&endTime=%s"%(endTime))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 2003)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 2003)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'instrumentID', u'dataDate', u'clearingDay', u'dataTime', u'dataMillisec', u'offSet', u'exchangeCD', u'volume', u'lastPrice', u'intsCHG', u'side', u'type']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'instrumentID': 'str','clearingDay': 'str','exchangeCD': 'str','side': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HSITicksHistOneDayGet(tradeDate, ticker, field = "", pandas = "1"):
    """
    高频数据，获取一只恒生指数在历史某一个交易日的tick数据信息，包含开、高、低、收、成交金额等内容。
    
    :param tradeDate: 交易日期（年月日部分），格式是YYYYMMDD.
    :param ticker: 恒生指数代码，根据getIdx中porgFullName为"恒生指数有限公司"可获取到指数的代码。,可以是列表
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getHSITicksHistOneDay.csv?ispandas=1&') 
    if not isinstance(tradeDate, str) and not isinstance(tradeDate, unicode):
        tradeDate = str(tradeDate)

    requestString.append("tradeDate=%s"%(tradeDate))
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 2008)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 2008)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'tradeDate', u'updateTime', u'ticker', u'indexStatus', u'securityrName', u'dailyIndexHigh', u'dailyIndexLow', u'currentIndex', u'estamitedAveragePrice', u'indexTurnover', u'indexPointChange', u'indexPointChangePercent']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'ticker': 'str','indexStatus': 'str','securityrName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HSIBarHistOneDayGet(tradeDate, ticker, startTime = "", endTime = "", unit = "", field = "", pandas = "1"):
    """
    高频数据，获取一只恒生指数在历史某一个交易日的分钟线数据信息，包含分钟内开、高、低、收、成交量、成交金额等内容。
    
    :param tradeDate: 交易日期（年月日部分），格式是YYYYMMDD.
    :param ticker: 恒生指数代码，根据getIdx中porgFullName为"恒生指数有限公司"可获取到指数的代码。,可以是列表
    :param startTime: 分钟起始时间，格式为HH:MM,可空
    :param endTime: 分钟截止时间，格式为HH:MM,可空
    :param unit: 分钟维度，可为1/5/15/30/60，不填写默认为1分钟线,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getHSIBarHistOneDay.csv?ispandas=1&') 
    if not isinstance(tradeDate, str) and not isinstance(tradeDate, unicode):
        tradeDate = str(tradeDate)

    requestString.append("tradeDate=%s"%(tradeDate))
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    if not isinstance(startTime, str) and not isinstance(startTime, unicode):
        startTime = str(startTime)

    requestString.append("&startTime=%s"%(startTime))
    if not isinstance(endTime, str) and not isinstance(endTime, unicode):
        endTime = str(endTime)

    requestString.append("&endTime=%s"%(endTime))
    if not isinstance(unit, str) and not isinstance(unit, unicode):
        unit = str(unit)

    requestString.append("&unit=%s"%(unit))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 2009)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 2009)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'tradeDate', u'barTime', u'utcOffset', u'ticker', u'closePrice', u'openPrice', u'highPrice', u'lowPrice', u'indexTurnover']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'barTime': 'str','ticker': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def NOBBBarHistOneDayGet(ticker, tradeDate, startTime = "", endTime = "", unit = "", field = "", pandas = "1"):
    """
    高频数据，获取一只新三板证券在历史某一个交易日的分钟线数据信息，包含分钟内开、高、低、收、成交量、成交金额等内容。
    
    :param ticker: 证券交易代码，如400002,可以是列表
    :param tradeDate: 交易日期（年月日部分），格式是YYYYMMDD.
    :param startTime: 分钟线起始时间， 如09:40，就是从早上九点四十开始。 默认开始时间早上开市时间，即09:30，不选即为默认值,可空
    :param endTime: 分钟线终止时间， 如14:00, 就是到下午14点结束。 如终止时间是空， 则截止到最新数据或到关市为止，即15:00，不选即为默认值,可空
    :param unit: 分钟维度，可为1/5/15/30/60，不填写默认为1分钟线,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getNOBBBarHistOneDay.csv?ispandas=1&') 
    requestString.append("ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    if not isinstance(tradeDate, str) and not isinstance(tradeDate, unicode):
        tradeDate = str(tradeDate)

    requestString.append("&tradeDate=%s"%(tradeDate))
    if not isinstance(startTime, str) and not isinstance(startTime, unicode):
        startTime = str(startTime)

    requestString.append("&startTime=%s"%(startTime))
    if not isinstance(endTime, str) and not isinstance(endTime, unicode):
        endTime = str(endTime)

    requestString.append("&endTime=%s"%(endTime))
    if not isinstance(unit, str) and not isinstance(unit, unicode):
        unit = str(unit)

    requestString.append("&unit=%s"%(unit))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'ticker', u'tradeDate', u'barTime', u'openPrice', u'highPrice', u'lowPrice', u'closePrice', u'volume', u'value', u'vwap']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'ticker': 'str','barTime': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def NOBBBarRTIntraDayOneMinuteGet(time, unit = "", assetClass = "", field = "", pandas = "1"):
    """
    高频数据，获取当日新三板所有股票某一分钟的分钟线数据，用户可输入分钟截止时间获取该分钟维度信息，包含开、高、低、收，成交量等，分钟维度包含1/5/15/30/60分钟线
    
    :param time: 查询时间，如09:33
    :param unit: Bar(s)的时间宽度，单位分钟。取值范围： 1（分钟）/ 3（分钟）/5（分钟）/15（分钟）/30（分钟）/60（分钟）,可空
    :param assetClass: 通联编制的证券类别编码。例如，E-股票；IDX-指数。对应DataAPI.SysCodeGet.codeTypeID=10001。,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getNOBBBarRTIntraDayOneMinute.csv?ispandas=1&') 
    if not isinstance(time, str) and not isinstance(time, unicode):
        time = str(time)

    requestString.append("time=%s"%(time))
    if not isinstance(unit, str) and not isinstance(unit, unicode):
        unit = str(unit)

    requestString.append("&unit=%s"%(unit))
    if not isinstance(assetClass, str) and not isinstance(assetClass, unicode):
        assetClass = str(assetClass)

    requestString.append("&assetClass=%s"%(assetClass))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'exchangeCD', u'unit', u'ticker', u'shortNM', u'utcOffset', u'currencyCD', u'barTime', u'closePrice', u'openPrice', u'highPrice', u'lowPrice', u'totalVolume', u'totalValue']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'exchangeCD': 'str','ticker': 'str','shortNM': 'str','utcOffset': 'str','currencyCD': 'str','barTime': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def NOBBBarRTIntraDayGet(ticker, startTime = "", endTime = "", unit = "", field = "", pandas = "1"):
    """
    高频数据，获取当日新三板一只证券从开盘截至目前所有分钟线数据，包含开、高、低、收，成交量等，分钟维度包含1/5/15/30/60分钟线
    
    :param ticker: 证券在证券市场通用的交易代码。,可以是列表
    :param startTime: 分钟线起始时间， 如09:40，就是从早上九点四十开始。 默认开始时间早上开市时间，即09:30，不选即为默认值,可空
    :param endTime: 分钟线终止时间， 如14:00, 就是到下午14点结束。 如终止时间是空， 则截止到最新数据或到关市为止，即15:00，不选即为默认值,可空
    :param unit: Bar(s)的时间宽度，单位分钟。取值范围： 1（分钟）/5（分钟）/15（分钟）/30（分钟）/60（分钟）,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getNOBBBarRTIntraDay.csv?ispandas=1&') 
    requestString.append("ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    if not isinstance(startTime, str) and not isinstance(startTime, unicode):
        startTime = str(startTime)

    requestString.append("&startTime=%s"%(startTime))
    if not isinstance(endTime, str) and not isinstance(endTime, unicode):
        endTime = str(endTime)

    requestString.append("&endTime=%s"%(endTime))
    if not isinstance(unit, str) and not isinstance(unit, unicode):
        unit = str(unit)

    requestString.append("&unit=%s"%(unit))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'ticker', u'shortNM', u'utcOffset', u'currencyCD', u'barTime', u'closePrice', u'openPrice', u'highPrice', u'lowPrice', u'totalVolume', u'totalValue', u'exchangeCD', u'unit']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'ticker': 'str','shortNM': 'str','utcOffset': 'str','currencyCD': 'str','barTime': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HSITickRTSnapshotGet(ticker, field = "", pandas = "1"):
    """
    高频数据，获取一只或多只恒生指数最新市场信息快照，包含开、高、低、最新价以及成交量、成交金额等
    
    :param ticker: 恒生指数代码，根据getIdx中porgFullName为"恒生指数有限公司"可获取到指数的代码。,可以是列表
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getHSITickRTSnapshot.csv?ispandas=1&') 
    requestString.append("ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 2064)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 2064)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'ticker', u'shortNM', u'dataTime', u'utcOffset', u'status', u'highPrice', u'lowPrice', u'lastPrice', u'value', u'change', u'changePct']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'ticker': 'str','shortNM': 'str','dataTime': 'str','utcOffset': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HSITickRTIntraDayGet(ticker, field = "", pandas = "1"):
    """
    高频数据，获取一只恒生指数在当日时间段内的tick数据，包含最新价、最高价、最低价、均价等
    
    :param ticker: 恒生指数代码，根据getIdx中porgFullName为"恒生指数有限公司"可获取到指数的代码。,可以是列表
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getHSITickRTIntraDay.csv?ispandas=1&') 
    requestString.append("ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 2069)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 2069)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'ticker', u'dataDate', u'shortNM', u'dataTime', u'status', u'currencyCd', u'highPrice', u'lowPrice', u'lastPrice', u'avgPrice', u'value', u'chg', u'changePct']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'ticker': 'str','dataDate': 'str','shortNM': 'str','dataTime': 'str','currencyCd': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HKTickRTIntraDayGet(ticker, startTime = "", endTime = "", field = "", pandas = "1"):
    """
    高频数据，获取一只港交所证券在当日时间段内的tick数据，当前仅包含港交所股票信息，涉及字段包含最新价，成交量，成交金额，当日最高价，当日最低价，买卖一档价格等等
    
    :param ticker: 证券在港交所的交易代码，如00001-长和
    :param startTime: 开始时间，格式为HH:MM,可空
    :param endTime: 结束时间，格式为HH:MM,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getHKTickRTIntraDay.csv?ispandas=1&') 
    if not isinstance(ticker, str) and not isinstance(ticker, unicode):
        ticker = str(ticker)

    requestString.append("ticker=%s"%(ticker))
    if not isinstance(startTime, str) and not isinstance(startTime, unicode):
        startTime = str(startTime)

    requestString.append("&startTime=%s"%(startTime))
    if not isinstance(endTime, str) and not isinstance(endTime, unicode):
        endTime = str(endTime)

    requestString.append("&endTime=%s"%(endTime))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'dataDate', u'dataTime', u'secOffset', u'currencyCD', u'ticker', u'shortNM', u'prevClosePrice', u'openPrice', u'volume', u'value', u'highPrice', u'lowPrice', u'lastPrice', u'bidPrice1', u'bidVolume1', u'askPrice1', u'askVolume1', u'tradType', u'IEP', u'aggQty', u'nominalPrice', u'vwap', u'chg', u'changePct', u'yield', u'tradStatus']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'dataDate': 'str','dataTime': 'str','secOffset': 'str','currencyCD': 'str','ticker': 'str','shortNM': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def SHSZTickRTIntraDayGet(ticker, exchangeCD, startTime = "", endTime = "", field = "", pandas = "1"):
    """
    高频数据，获取一只沪深证券在当日时间段内的tick数据，包含最新价、最高价、最低价、成交量、成交金额，买卖五档信息等
    
    :param ticker: 证券在交易所的交易代码，比如000001-平安银行
    :param exchangeCD: XSHE-深交所；XSHG-上交所
    :param startTime: 开始时间，格式为HH:MM,可空
    :param endTime: 结束时间，格式为HH:MM,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getSHSZTickRTIntraDay.csv?ispandas=1&') 
    if not isinstance(ticker, str) and not isinstance(ticker, unicode):
        ticker = str(ticker)

    requestString.append("ticker=%s"%(ticker))
    if not isinstance(exchangeCD, str) and not isinstance(exchangeCD, unicode):
        exchangeCD = str(exchangeCD)

    requestString.append("&exchangeCD=%s"%(exchangeCD))
    if not isinstance(startTime, str) and not isinstance(startTime, unicode):
        startTime = str(startTime)

    requestString.append("&startTime=%s"%(startTime))
    if not isinstance(endTime, str) and not isinstance(endTime, unicode):
        endTime = str(endTime)

    requestString.append("&endTime=%s"%(endTime))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'dataDate', u'ticker', u'secOffset', u'dataTime', u'exchangeCD', u'currencyCD', u'shortNM', u'prevClosePrice', u'openPrice', u'volume', u'value', u'highPrice', u'lowPrice', u'lastPrice', u'bidPrice1', u'bidVolume1', u'bidPrice2', u'bidVolume2', u'bidPrice3', u'bidVolume3', u'bidPrice4', u'bidVolume4', u'bidPrice5', u'bidVolume5', u'askPrice1', u'askVolume1', u'askPrice2', u'askVolume2', u'askPrice3', u'askVolume3', u'askPrice4', u'askVolume4', u'askPrice5', u'askVolume5']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'dataDate': 'str','ticker': 'str','dataTime': 'str','exchangeCD': 'str','currencyCD': 'str','shortNM': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktIdxPerformanceGet(SecID = "", ticker = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取一只指数在段时间的业绩表现数据，包含不同期间内的平均收益率，收益率方差和夏普比率信息
    
    :param SecID: 通联编制的指数编码。 可通过指数代码和证券类型（assetClass=IDX）在DataAPI.SecIDGet获取到。,SecID、ticker至少选择一个
    :param ticker: 证券在证券市场通用的交易代码。,SecID、ticker至少选择一个
    :param beginDate: 交易日的起始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 交易日的截止日期，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktIdxPerformance.csv?ispandas=1&') 
    if not isinstance(SecID, str) and not isinstance(SecID, unicode):
        SecID = str(SecID)

    requestString.append("SecID=%s"%(SecID))
    if not isinstance(ticker, str) and not isinstance(ticker, unicode):
        ticker = str(ticker)

    requestString.append("&ticker=%s"%(ticker))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 2070)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 2070)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'SecID', u'ticker', u'tradeDate', u'avgReturn1M', u'avgReturn3M', u'avgReturn6M', u'avgReturn1Y', u'avgReturn2Y', u'avgReturn3Y', u'avgReturn4Y', u'avgReturn5Y', u'avgReturn6Y', u'avgReturnShis', u'stdDev6M', u'stdDev1Y', u'stdDev2Y', u'stdDev3Y', u'sharpRatio6M', u'sharpRatio1Y', u'sharpRatio2Y', u'sharpRatio3Y']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'SecID': 'str','ticker': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FutureOptTicksHistOneDayGet(instrumentID, date, field = "", pandas = "1"):
    """
    高频数据，获取一只期货期权合约在历史某一个交易日内的Tick数据，包含最新价、开盘价、最高价、最低价、成交量、成交金额、买卖一档等信息
    
    :param instrumentID: 一个期权合约代码，如m1801-P-2650;
    :param date: 数据日期。格式是“YYYYMMDD”
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getFutureOptTicksHistOneDay.csv?ispandas=1&') 
    if not isinstance(instrumentID, str) and not isinstance(instrumentID, unicode):
        instrumentID = str(instrumentID)

    requestString.append("instrumentID=%s"%(instrumentID))
    if not isinstance(date, str) and not isinstance(date, unicode):
        date = str(date)

    requestString.append("&date=%s"%(date))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'instrumentID', u'dataDate', u'clearingDay', u'dataTime', u'exchangeCD', u'lastPrice', u'preSettlementPrice', u'prevClosePrice', u'preOpenInterest', u'openPrice', u'highPrice', u'lowPrice', u'volume', u'value', u'openInterest', u'closePrice', u'settlementPrice', u'upperLimitPrice', u'lowerLimitPrice', u'bidPrice1', u'bidVolume1', u'askPrice1', u'askVolume1', u'bidPrice2', u'bidVolume2', u'bidPrice3', u'bidVolume3', u'bidPrice4', u'bidVolume4', u'bidPrice5', u'bidVolume5', u'askPrice2', u'askVolume2', u'askPrice3', u'askVolume3', u'askPrice4', u'askVolume4', u'askPrice5', u'askVolume5', u'tflag']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'instrumentID': 'str','dataTime': 'str','exchangeCD': 'str','tflag': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def NeeqDeltaTickRTIntraDayGet(ticker, field = "", pandas = "1"):
    """
    高频数据，获取一只新三板股票最新的十笔分笔成交记录，包含最新10笔分笔的成交价格和成交数量，以及价格变动等信息
    
    :param ticker: 证券6位代码， 如400002,可以是列表
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getNeeqDeltaTickRTIntraDay.csv?ispandas=1&') 
    requestString.append("ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'ticker', u'dataTime', u'deltaVolume', u'lastPrice', u'deltaPrice']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'ticker': 'str','dataTime': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktNeeqEquwGet(secID = "", ticker = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    新三板股票周行情数据，包含周开高低收价、成交量、成交金额等
    
    :param secID: 通联编制的证券编码，格式是“交易代码.证券市场代码”，如400002.NOBB。 可传入证券交易代码使用DataAPI.SecIDGet接口获取到。,可以是列表,secID、ticker至少选择一个
    :param ticker: 证券在证券市场通用的交易代码。,可以是列表,secID、ticker至少选择一个
    :param beginDate: 交易日的起始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 交易日的截止日期，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktNeeqEquw.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 2078)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 2078)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'weekBeginDate', u'endDate', u'tradeDays', u'preClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'turnoverValue', u'chg', u'chgPct', u'wReturn', u'wVarReturn100', u'wSdReturn100', u'wAvgReturn100']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktNeeqEqumGet(secID = "", ticker = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    新三板股票月行情数据，包含周开高低收价、成交量、成交金额等
    
    :param secID: 通联编制的证券编码，格式是“交易代码.证券市场代码”，如400002.NOBB。 可传入证券交易代码使用DataAPI.SecIDGet接口获取到。,可以是列表,secID、ticker至少选择一个
    :param ticker: 证券在证券市场通用的交易代码。,可以是列表,secID、ticker至少选择一个
    :param beginDate: 交易日的起始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 交易日的截止日期，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktNeeqEqum.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 2079)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 2079)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'monthBeginDate', u'endDate', u'tradeDays', u'preClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'turnoverValue', u'chg', u'chgPct', u'mReturn', u'mVarReturn24', u'mSdReturn24', u'mAvgReturn24', u'mVarReturn60', u'mSdReturn60', u'mAvgReturn60']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FutureOptTicksIntraDayGet(instrumentID, startTime = "", endTime = "", field = "", pandas = "1"):
    """
    高频数据，获取一只期货期权在本清算日（包含夜盘）内自交易开始的所有行情信息
    
    :param instrumentID: 一个期货期权合约代码，如m1709-P-3100(大小写均可)。
    :param startTime: 开始时间，如10:10，若空，则表示没有上界,可空
    :param endTime: 结束时间，如10:15，若空，则表示没有下界,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getFutureOptTicksIntraDay.csv?ispandas=1&') 
    if not isinstance(instrumentID, str) and not isinstance(instrumentID, unicode):
        instrumentID = str(instrumentID)

    requestString.append("instrumentID=%s"%(instrumentID))
    if not isinstance(startTime, str) and not isinstance(startTime, unicode):
        startTime = str(startTime)

    requestString.append("&startTime=%s"%(startTime))
    if not isinstance(endTime, str) and not isinstance(endTime, unicode):
        endTime = str(endTime)

    requestString.append("&endTime=%s"%(endTime))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'dataDate', u'dataTime', u'dataMillisec', u'milliSecOffset', u'exchangeCD', u'instrumentID', u'prevClosePrice', u'preSettlementPrice', u'preOpenInterest', u'openPrice', u'closePrice', u'volume', u'value', u'settlementPrice', u'openInterest', u'highPrice', u'lowPrice', u'lastPrice', u'upperLimitPrice', u'lowerLimitPrice', u'clearingDay', u'bidPrice1', u'bidVolume1', u'askPrice1', u'askVolume1']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'dataTime': 'str','exchangeCD': 'str','instrumentID': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FutureOptTickRTSnapshotGet(instrumentID = "", field = "", pandas = "1"):
    """
    高频数据，获取期货期权最新市场信息快照
    
    :param instrumentID: 证券在证券市场通用的交易代码，如m1709-P-3100(大小写均可)。,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getFutureOptTickRTSnapshot.csv?ispandas=1&') 
    if not isinstance(instrumentID, str) and not isinstance(instrumentID, unicode):
        instrumentID = str(instrumentID)

    requestString.append("instrumentID=%s"%(instrumentID))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'instrumentID', u'timestamp', u'dataDate', u'dataTime', u'dataMillisec', u'prevClosePrice', u'openPrice', u'volume', u'value', u'highPrice', u'lowPrice', u'lastPrice', u'exchangeCD', u'openInterest', u'preOpenInterest', u'upperLimitPrice', u'lowerLimitPrice', u'preSettlementPrice', u'settlementPrice', u'closePrice', u'clearingDay', u'bidBook_price1', u'bidBook_volume1', u'bidBook_price2', u'bidBook_volume2', u'bidBook_price3', u'bidBook_volume3', u'bidBook_price4', u'bidBook_volume4', u'bidBook_price5', u'bidBook_volume5', u'askBook_price1', u'askBook_volume1', u'askBook_price2', u'askBook_volume2', u'askBook_price3', u'askBook_volume3', u'askBook_price4', u'askBook_volume4', u'askBook_price5', u'askBook_volume5', u'milliSecOffset', u'localTimestamp', u'utcOffset']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'instrumentID': 'str','dataDate': 'str','dataTime': 'str','exchangeCD': 'str','clearingDay': 'str','utcOffset': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FutureSecBarHistOneDayGet(instrumentID, tradeDate, startTime = "", endTime = "", field = "", pandas = "1"):
    """
    高频数据，获取一只期货合约在历史某一清算日（包含夜盘）内自交易开始的所有秒线行情信息
    
    :param instrumentID: 期货代码，如"bu1709"
    :param tradeDate: 清算日期，包含夜盘数据，如"YYYYMMDD"
    :param startTime: 秒线起始时间，不输入默认返回当前交易日开始时间，可输入"HHMM"或"HHMMSS"的形式,可空
    :param endTime: 秒线截止时间，不输入默认返回当前交易日结束时间，可输入"HHMM"或"HHMMSS"的形式,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getFutureSecBarHistOneDay.csv?ispandas=1&') 
    if not isinstance(instrumentID, str) and not isinstance(instrumentID, unicode):
        instrumentID = str(instrumentID)

    requestString.append("instrumentID=%s"%(instrumentID))
    if not isinstance(tradeDate, str) and not isinstance(tradeDate, unicode):
        tradeDate = str(tradeDate)

    requestString.append("&tradeDate=%s"%(tradeDate))
    if not isinstance(startTime, str) and not isinstance(startTime, unicode):
        startTime = str(startTime)

    requestString.append("&startTime=%s"%(startTime))
    if not isinstance(endTime, str) and not isinstance(endTime, unicode):
        endTime = str(endTime)

    requestString.append("&endTime=%s"%(endTime))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'clearingDay', u'tDate', u'instrumentID', u'exchangeCD', u'barTime', u'totalVolume', u'totalValue', u'highPrice', u'lowPrice', u'openPrice', u'closePrice', u'openInterest', u'bidBook_price1', u'bidBook_volume1', u'askBook_price1', u'askBook_volume1']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'instrumentID': 'str','exchangeCD': 'str','barTime': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FutureSecBarRTIntraDayGet(instrumentID, startTime = "", endTime = "", field = "", pandas = "1"):
    """
    高频数据，获取一只期货合约在当日（包含夜盘）内一段时间秒线行情信息
    
    :param instrumentID: 期货代码，如"bu1709"
    :param startTime: 秒线起始时间，不输入默认返回当前交易日开始时间，可输入"HHMM"或"HHMMSS"的形式,可空
    :param endTime: 秒线截止时间，不输入默认返回当前交易日结束时间，可输入"HHMM"或"HHMMSS"的形式,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getFutureSecBarRTIntraDay.csv?ispandas=1&') 
    if not isinstance(instrumentID, str) and not isinstance(instrumentID, unicode):
        instrumentID = str(instrumentID)

    requestString.append("instrumentID=%s"%(instrumentID))
    if not isinstance(startTime, str) and not isinstance(startTime, unicode):
        startTime = str(startTime)

    requestString.append("&startTime=%s"%(startTime))
    if not isinstance(endTime, str) and not isinstance(endTime, unicode):
        endTime = str(endTime)

    requestString.append("&endTime=%s"%(endTime))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'tDate', u'clearingDay', u'barTime', u'exchangeCD', u'instrumentID', u'openPrice', u'highPrice', u'lowPrice', u'closePrice', u'totalVolume', u'totalValue', u'openInterest', u'bidBook_price1', u'bidBook_volume1', u'askBook_price1', u'askBook_volume1']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'exchangeCD': 'str','instrumentID': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktAdjfAfKunhongV2Get(secID = "", ticker = "", exchangeCD = "", exDivDate = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取沪深A股和B股调整行情的后复权因子数据（以上市价格为基准），包含除权除息日、除权除息事项具体数据、本次复权因子、累积复权因子以及因子调整的截止日期。该因子用来调整历史行情，不作为预测使用，于除权除息日进行计算调整。
    
    :param secID: 通联编制的证券编码，格式是“交易代码.证券市场代码”，如000001.XSHE。 可传入证券交易代码使用DataAPI.SecIDGet接口获取到。,可以是列表,可空
    :param ticker: 一只或多只股票代码，用,分隔，如000001,000002。,可以是列表,可空
    :param exchangeCD: 通联编制的证券市场编码。例如，XSHG-上海证券交易所；XSHE-深圳证券交易所；XIBE-中国银行间市场等。对应DataAPI.SysCodeGet.codeTypeID=10002。,可以是列表,可空
    :param exDivDate: 除权除息日，输入格式：YYYYMMDD,可空
    :param beginDate: 除权除息日查询为基准，查询开始日期，输入格式："YYYYMMDD",可空
    :param endDate: 除权除息日查询为基准，查询截止日期，输入格式："YYYYMMDD",可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktAdjfAfKunhongV2.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&exchangeCD=")
    if hasattr(exchangeCD,'__iter__') and not isinstance(exchangeCD, str):
        if len(exchangeCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = exchangeCD
            requestString.append(None)
        else:
            requestString.append(','.join(exchangeCD))
    else:
        requestString.append(exchangeCD)
    try:
        exDivDate = exDivDate.strftime('%Y%m%d')
    except:
        exDivDate = exDivDate.replace('-', '')
    requestString.append("&exDivDate=%s"%(exDivDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'exchangeCD', u'secShortName', u'secShortNameEn', u'exDivDate', u'perCashDiv', u'perShareDivRatio', u'perShareTransRatio', u'allotmentRatio', u'allotmentPrice', u'splitsRatio', u'adjFactor', u'accumAdjFactor', u'endDate']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','exchangeCD': 'str','secShortName': 'str','secShortNameEn': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FutureOptBarRTIntraDayGet(instrumentID, startTime = "", endTime = "", unit = "", field = "", pandas = "1"):
    """
    高频数据，获取当日期权期权的分钟线，包含1/5/15/30/60分钟的分钟线。分钟线的有效数据从夜盘开始到日线结束，分钟线的计算规则为分钟内前开后闭，向后归结，即（9:31:00.000，9:32:00.000]归为9:32分的数据，第一根分钟线包含时间范围为集合竞价开始到连续竞价开始
    
    :param instrumentID: 期货期权合约在证券市场通用的交易代码。
    :param startTime: 根据bar的时间范围查询的开始时间，默认是前一天的21:00（前一天夜盘开始时间）。格式"hh:mm"。,可空
    :param endTime: 根据bar的时间范围查询的结束时间，默认是当前时间。格式"hh:mm"。,可空
    :param unit: Bar(s)的时间宽度，单位分钟。取值范围： 1（分钟）/ 3（分钟）/5（分钟）/15（分钟）/30（分钟）/60（分钟）,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getFutureOptBarRTIntraDay.csv?ispandas=1&') 
    if not isinstance(instrumentID, str) and not isinstance(instrumentID, unicode):
        instrumentID = str(instrumentID)

    requestString.append("instrumentID=%s"%(instrumentID))
    if not isinstance(startTime, str) and not isinstance(startTime, unicode):
        startTime = str(startTime)

    requestString.append("&startTime=%s"%(startTime))
    if not isinstance(endTime, str) and not isinstance(endTime, unicode):
        endTime = str(endTime)

    requestString.append("&endTime=%s"%(endTime))
    if not isinstance(unit, str) and not isinstance(unit, unicode):
        unit = str(unit)

    requestString.append("&unit=%s"%(unit))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'instrumentID', u'exchangeCD', u'unit', u'utcOffset', u'currencyCD', u'barTime', u'closePrice', u'openPrice', u'highPrice', u'lowPrice', u'totalVolume', u'totalValue', u'openInterest']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'instrumentID': 'str','exchangeCD': 'str','utcOffset': 'str','currencyCD': 'str','barTime': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def SHSZMoneyFlowBarHistOneDayGet(ticker, tradeDate, beginTime = "", endTime = "", investorType = "", unit = "", field = "", pandas = "1"):
    """
    高频数据，获取一只沪深股票在历史某一交易日的资金流向分钟粒度数据，包含主力、散户和原始资金流向等分类，其中主力定义为瞬时成交额为500w（包含）或以上的记录，散户为瞬时成交额为500w以下及记录。分钟划分标准为分钟前开后闭，向后归结，即（9:30:00,9:31:00]算作9:31的分钟线。主力、散户不计算集合竞价期间成交信息
    
    :param ticker: 证券在交易所的交易代码，如000001，最多输入5个股票,可以是列表
    :param tradeDate: 交易日期，格式为YYYYMMDD
    :param beginTime: 分钟线开始时间，格式为HH:MM,不输入默认09:30,可空
    :param endTime: 分钟线开始时间，格式为HH:MM,不输入默认15:00,可空
    :param investorType: 0-原始数据；1-主力；2-散户，不输入默认为原始数据,可空
    :param unit: Bar(s)的时间宽度，单位分钟。取值范围： 1（分钟）/3（分钟）/5（分钟）/15（分钟）/30（分钟）/60（分钟）,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getSHSZMoneyFlowBarHistOneDay.csv?ispandas=1&') 
    requestString.append("ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    if not isinstance(tradeDate, str) and not isinstance(tradeDate, unicode):
        tradeDate = str(tradeDate)

    requestString.append("&tradeDate=%s"%(tradeDate))
    if not isinstance(beginTime, str) and not isinstance(beginTime, unicode):
        beginTime = str(beginTime)

    requestString.append("&beginTime=%s"%(beginTime))
    if not isinstance(endTime, str) and not isinstance(endTime, unicode):
        endTime = str(endTime)

    requestString.append("&endTime=%s"%(endTime))
    if not isinstance(investorType, str) and not isinstance(investorType, unicode):
        investorType = str(investorType)

    requestString.append("&investorType=%s"%(investorType))
    if not isinstance(unit, str) and not isinstance(unit, unicode):
        unit = str(unit)

    requestString.append("&unit=%s"%(unit))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 2134)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 2134)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'ticker', u'tradeDate', u'barTime', u'exchangeCD', u'investorType', u'moneyInflowS', u'moneyInflowM', u'moneyInflowL', u'moneyInflowXL', u'moneyOutflowS', u'moneyOutflowM', u'moneyOutflowL', u'moneyOutflowXL', u'moneyNetInflowS', u'moneyNetInflowM', u'moneyNetInflowL', u'moneyNetInflowXL']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'barTime': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def StockTagsGet(secID = "", ticker = "", tradeDate = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    根据股票因子数据，对股票进行分类，比如根据市值分为超级大盘股、大盘股、小盘股，根据PE分为高PE股，低PE股等。
    
    :param secID: 证券内部编码，一串流水号,可先通过DataAPI.SecIDGet获取到，如在DataAPI.SecIDGet，选择证券类型为'E',输入'000001'，可获取到ID'000001.XSHE'后，在此输入'000001.XSHE',可以是列表,secID、ticker、tradeDate至少选择一个
    :param ticker: 证券在证券市场通用的交易代码。,可以是列表,secID、ticker、tradeDate至少选择一个
    :param tradeDate: 交易日期，输入格式“YYYYMMDD”,secID、ticker、tradeDate至少选择一个
    :param beginDate: 根据交易日期范围查询的开始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 根据交易日期范围查询的结束日期，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getStockTags.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    if not isinstance(tradeDate, str) and not isinstance(tradeDate, unicode):
        tradeDate = str(tradeDate)

    requestString.append("&tradeDate=%s"%(tradeDate))
    if not isinstance(beginDate, str) and not isinstance(beginDate, unicode):
        beginDate = str(beginDate)

    requestString.append("&beginDate=%s"%(beginDate))
    if not isinstance(endDate, str) and not isinstance(endDate, unicode):
        endDate = str(endDate)

    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 2126)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 2126)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'ticker', u'secID', u'tradeDate', u'marketValueStyle', u'growth', u'worth', u'price', u'leverage', u'pe', u'roe', u'mobility', u'profitability', u'momentum', u'volatility', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'ticker': 'str','secID': 'str','marketValueStyle': 'str','growth': 'str','worth': 'str','price': 'str','leverage': 'str','pe': 'str','roe': 'str','mobility': 'str','profitability': 'str','momentum': 'str','volatility': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FutureOptBarHistOneDayGet(instrumentID, tradeDate, startTime = "", endTime = "", unit = "", field = "", pandas = "1"):
    """
    高频数据，获取一只或者多只商品期权在历史某一清算日的分钟线数据，包含1/3/5/15/30/60分钟的分钟线。分钟线的有效数据从夜盘开始到日线结束，分钟线的计算规则为分钟内前开后闭，向后归结，即（9:31:00.000，9:32:00.000]归为9:32分的数据，第一根分钟线包含时间范围为集合竞价开始到连续竞价开始
    
    :param instrumentID: 合约在交易所的交易代码，如“m1707-C-2600”，最多允许输入5只合约,可以是列表
    :param tradeDate: 查询日期，以清算日为准，例如20170613，会返回20170612的夜盘和20170613的日盘
    :param startTime: 不输入默认查询当日开盘时间,可空
    :param endTime: 不输入默认查询当日收盘时间,可空
    :param unit: Bar(s)的时间宽度，单位分钟，如 1（分钟）/ 3（分钟）/5（分钟）/15（分钟）/30（分钟）/60（分钟），不输入默认返回1分钟线,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getFutureOptBarHistOneDay.csv?ispandas=1&') 
    requestString.append("instrumentID=")
    if hasattr(instrumentID,'__iter__') and not isinstance(instrumentID, str):
        if len(instrumentID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = instrumentID
            requestString.append(None)
        else:
            requestString.append(','.join(instrumentID))
    else:
        requestString.append(instrumentID)
    if not isinstance(tradeDate, str) and not isinstance(tradeDate, unicode):
        tradeDate = str(tradeDate)

    requestString.append("&tradeDate=%s"%(tradeDate))
    if not isinstance(startTime, str) and not isinstance(startTime, unicode):
        startTime = str(startTime)

    requestString.append("&startTime=%s"%(startTime))
    if not isinstance(endTime, str) and not isinstance(endTime, unicode):
        endTime = str(endTime)

    requestString.append("&endTime=%s"%(endTime))
    if not isinstance(unit, str) and not isinstance(unit, unicode):
        unit = str(unit)

    requestString.append("&unit=%s"%(unit))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'clearingDay', u'dataDate', u'instrumentID', u'exchangeCD', u'barTime', u'closePrice', u'openPrice', u'highPrice', u'lowPrice', u'totalVolume', u'totalValue', u'openInterest']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'instrumentID': 'str','exchangeCD': 'str','barTime': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def SHSZTicksHistOneDayGet(ticker, exchangeCD, tradeDate, field = "", pandas = "1"):
    """
    高频数据，获取一只沪深证券在历史上某一天内的Tick数据。 输入一只证券代码，如000001和证券所在的交易市场XSHE，即可获取平安银行的历史行情。证券包括股票， 指数，部分债券和基金
    
    :param ticker: 证券在证券市场通用的交易代码
    :param exchangeCD: 通联编制的证券市场编码。例如，XSHG-上海证券交易所；XSHE-深圳证券交易所；XIBE-中国银行间市场等。对应DataAPI.SysCodeGet.codeTypeID=10002。
    :param tradeDate: 格式是YYYYMMDD,可以是列表
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getSHSZTicksHistOneDay.csv?ispandas=1&') 
    if not isinstance(ticker, str) and not isinstance(ticker, unicode):
        ticker = str(ticker)

    requestString.append("ticker=%s"%(ticker))
    if not isinstance(exchangeCD, str) and not isinstance(exchangeCD, unicode):
        exchangeCD = str(exchangeCD)

    requestString.append("&exchangeCD=%s"%(exchangeCD))
    requestString.append("&tradeDate=")
    if hasattr(tradeDate,'__iter__') and not isinstance(tradeDate, str):
        if len(tradeDate) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = tradeDate
            requestString.append(None)
        else:
            requestString.append(','.join(tradeDate))
    else:
        requestString.append(tradeDate)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'tradeDate', u'ticker', u'dataTime', u'exchangeCD', u'currencyCD', u'shortNM', u'prevClosePrice', u'openPrice', u'volume', u'value', u'deal', u'highPrice', u'lowPrice', u'lastPrice', u'bidPrice1', u'bidVolume1', u'bidPrice2', u'bidVolume2', u'bidPrice3', u'bidVolume3', u'bidPrice4', u'bidVolume4', u'bidPrice5', u'bidVolume5', u'askPrice1', u'askVolume1', u'askPrice2', u'askVolume2', u'askPrice3', u'askVolume3', u'askPrice4', u'askVolume4', u'askPrice5', u'askVolume5']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'dataTime': 'str','exchangeCD': 'str','currencyCD': 'str','shortNM': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HKTicksHistOneDayGet(ticker, tradeDate, field = "", pandas = "1"):
    """
    高频数据，获取一只港交所证券在历史上某一天内的Tick数据。 输入一只证券代码，如00001，即可获取长和的历史行情。
    
    :param ticker: 证券在证券市场通用的交易代码
    :param tradeDate: 格式是YYYYMMDD,可以是列表
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getHKTicksHistOneDay.csv?ispandas=1&') 
    if not isinstance(ticker, str) and not isinstance(ticker, unicode):
        ticker = str(ticker)

    requestString.append("ticker=%s"%(ticker))
    requestString.append("&tradeDate=")
    if hasattr(tradeDate,'__iter__') and not isinstance(tradeDate, str):
        if len(tradeDate) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = tradeDate
            requestString.append(None)
        else:
            requestString.append(','.join(tradeDate))
    else:
        requestString.append(tradeDate)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'tradeDate', u'ticker', u'dataTime', u'exchangeCD', u'currencyCD', u'prevClosePrice', u'openPrice', u'highPrice', u'lowPrice', u'lastPrice', u'volume', u'value', u'bidPrice1', u'bidVolume1', u'bidPrice2', u'bidVolume2', u'bidPrice3', u'bidVolume3', u'bidPrice4', u'bidVolume4', u'bidPrice5', u'bidVolume5', u'bidPrice6', u'bidVolume6', u'bidPrice7', u'bidVolume7', u'bidPrice8', u'bidVolume8', u'bidPrice9', u'bidPrice9', u'bidVolume9', u'bidPrice10', u'bidVolume10', u'askPrice1', u'askVolume1', u'askPrice2', u'askVolume2', u'askPrice3', u'askVolume3', u'askPrice4', u'askVolume4', u'askPrice5', u'askVolume5', u'askPrice6', u'askVolume6', u'askPrice7', u'askVolume7', u'askPrice8', u'askVolume8', u'askPrice9', u'askVolume9', u'askPrice10', u'askVolume10', u'tradeType', u'IEP', u'aggQty', u'nominalPrice', u'chg', u'chgPct', u'tradeStatus']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'dataTime': 'str','exchangeCD': 'str','currencyCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def SHSZBarRTIntraDayGet(unit, assetClass = "", startTime = "", endTime = "", ticker = "", exchangeCD = "", field = "", pandas = "1"):
    """
    高频数据，获取一只沪深交易所证券当日的分钟线信息，包含1/3/5/15/30/60分钟的分钟线。 证券目前是股票，指数，基金和部分债券。分钟线的有效数据上午从09：30 到11：30，下午从13：01到15：00，分钟线的计算规则为分钟内前开后闭，向后归结，即（9:31:00.000，9:32:00.000]归为9:32分的数据，9:30的分钟线包含时间范围为9:30:00前所有成交（即集合竞价成交）
    
    :param unit: Bar(s)的时间宽度，单位分钟。取值范围： 1（分钟）/ 3（分钟）/5（分钟）/15（分钟）/30（分钟）/60（分钟）
    :param assetClass: 证券类型。例如，E-股票,B-债券,F-基金。对应DataAPI.SysCodeGet.codeTypeID=10001。,可空
    :param startTime: 分钟线起始时间， 如09:40，就是从早上九点四十开始。 默认开始时间早上开市时间，即09:30，不选即为默认值,可空
    :param endTime: 分钟线终止时间， 如14:00, 就是到下午14点结束。 如终止时间是空， 则截止到最新数据或到关市为止，即15:00，不选即为默认值,可空
    :param ticker: 证券在证券市场通用的交易代码。,可以是列表,可空
    :param exchangeCD: 通联编制的证券市场编码。例如，XSHG-上海证券交易所；XSHE-深圳证券交易所等。对应DataAPI.SysCodeGet.codeTypeID=10002。,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getSHSZBarRTIntraDay.csv?ispandas=1&') 
    if not isinstance(unit, str) and not isinstance(unit, unicode):
        unit = str(unit)

    requestString.append("unit=%s"%(unit))
    if not isinstance(assetClass, str) and not isinstance(assetClass, unicode):
        assetClass = str(assetClass)

    requestString.append("&assetClass=%s"%(assetClass))
    if not isinstance(startTime, str) and not isinstance(startTime, unicode):
        startTime = str(startTime)

    requestString.append("&startTime=%s"%(startTime))
    if not isinstance(endTime, str) and not isinstance(endTime, unicode):
        endTime = str(endTime)

    requestString.append("&endTime=%s"%(endTime))
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    if not isinstance(exchangeCD, str) and not isinstance(exchangeCD, unicode):
        exchangeCD = str(exchangeCD)

    requestString.append("&exchangeCD=%s"%(exchangeCD))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 2150)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 2150)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'unit', u'ticker', u'exchangeCD', u'shortNM', u'currencyCD', u'barTime', u'closePrice', u'openPrice', u'highPrice', u'lowPrice', u'totalVolume', u'totalValue']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'ticker': 'str','exchangeCD': 'str','shortNM': 'str','currencyCD': 'str','barTime': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HKBarRTIntraDayGet(unit, ticker = "", startTime = "", endTime = "", field = "", pandas = "1"):
    """
    高频数据，获取一只港交所证券当日的分钟线信息，包含1/3/5/15/30/60分钟的分钟线。 证券目前仅包含股票。分钟线的有效数据上午从09：30 到12：30（随机收市，分钟线计算至12:30），下午从13：01到16：30（随机收市，分钟线计算至16:30），分钟线的计算规则为分钟内前开后闭，向后归结，即（9:31:00.000，9:32:00.000]归为9:32分的数据，9:30的分钟线包含时间范围为9:30:00前所有成交（即集合竞价成交）
    
    :param unit: Bar(s)的时间宽度，单位分钟。取值范围： 1（分钟）/ 3（分钟）/5（分钟）/15（分钟）/30（分钟）/60（分钟）
    :param ticker: 证券在证券市场通用的交易代码。,可以是列表,可空
    :param startTime: 分钟线起始时间， 如09:40，就是从早上九点四十开始。 默认开始时间早上开市时间，即09:30，不选即为默认值,可空
    :param endTime: 分钟线终止时间， 如14:00, 就是到下午14点结束。 如终止时间是空， 则截止到最新数据或到关市为止，即15:00，不选即为默认值,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getHKBarRTIntraDay.csv?ispandas=1&') 
    if not isinstance(unit, str) and not isinstance(unit, unicode):
        unit = str(unit)

    requestString.append("unit=%s"%(unit))
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    if not isinstance(startTime, str) and not isinstance(startTime, unicode):
        startTime = str(startTime)

    requestString.append("&startTime=%s"%(startTime))
    if not isinstance(endTime, str) and not isinstance(endTime, unicode):
        endTime = str(endTime)

    requestString.append("&endTime=%s"%(endTime))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'unit', u'ticker', u'exchangeCD', u'shortNM', u'currencyCD', u'barTime', u'closePrice', u'openPrice', u'highPrice', u'lowPrice', u'totalVolume', u'totalValue']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'ticker': 'str','exchangeCD': 'str','shortNM': 'str','currencyCD': 'str','barTime': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HSIBarRTIntraDayGet(unit, ticker = "", startTime = "", endTime = "", field = "", pandas = "1"):
    """
    高频数据，获取一只恒生指数当日的分钟线信息，包含1/3/5/15/30/60分钟的分钟线。分钟线的有效数据上午从09：30 到12：30（随机收市，分钟线计算至12:30），下午从13：01到16：30（随机收市，分钟线计算至16:30），分钟线的计算规则为分钟内前开后闭，向后归结，即（9:31:00.000，9:32:00.000]归为9:32分的数据，9:30的分钟线包含时间范围为9:30:00前所有成交（即集合竞价成交）
    
    :param unit: Bar(s)的时间宽度，单位分钟。取值范围： 1（分钟）/ 3（分钟）/5（分钟）/15（分钟）/30（分钟）/60（分钟）
    :param ticker: 恒生指数代码，根据getIdx中porgFullName为"恒生指数有限公司"可获取到指数的代码。,可以是列表,可空
    :param startTime: 分钟线起始时间， 如09:40，就是从早上九点四十开始。 默认开始时间早上开市时间，即09:30，不选即为默认值,可空
    :param endTime: 分钟线终止时间， 如14:00, 就是到下午14点结束。 如终止时间是空， 则截止到最新数据或到关市为止，即15:00，不选即为默认值,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getHSIBarRTIntraDay.csv?ispandas=1&') 
    if not isinstance(unit, str) and not isinstance(unit, unicode):
        unit = str(unit)

    requestString.append("unit=%s"%(unit))
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    if not isinstance(startTime, str) and not isinstance(startTime, unicode):
        startTime = str(startTime)

    requestString.append("&startTime=%s"%(startTime))
    if not isinstance(endTime, str) and not isinstance(endTime, unicode):
        endTime = str(endTime)

    requestString.append("&endTime=%s"%(endTime))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 2152)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 2152)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'unit', u'ticker', u'exchangeCD', u'shortNM', u'currencyCD', u'barTime', u'closePrice', u'openPrice', u'highPrice', u'lowPrice', u'totalVolume', u'totalValue']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'ticker': 'str','exchangeCD': 'str','shortNM': 'str','currencyCD': 'str','barTime': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def EnergyFutureTicksHistOneDayGet(instrumentID, tradeDate, field = "", pandas = "1"):
    """
    高频数据，获取一只上海国际能源交易中心期货合约在历史某一清算日内的Tick数据。目前仅包含上期能源原油期货（品种尚未上市，数据为测试数据）
    
    :param instrumentID: 证券在证券市场通用的交易代码。
    :param tradeDate: 清算日期
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getEnergyFutureTicksHistOneDay.csv?ispandas=1&') 
    if not isinstance(instrumentID, str) and not isinstance(instrumentID, unicode):
        instrumentID = str(instrumentID)

    requestString.append("instrumentID=%s"%(instrumentID))
    if not isinstance(tradeDate, str) and not isinstance(tradeDate, unicode):
        tradeDate = str(tradeDate)

    requestString.append("&tradeDate=%s"%(tradeDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 2153)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 2153)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'clearingDay', u'dataDate', u'dataTime', u'dataMillisec', u'instrumentID', u'preOpenInterest', u'preSettlementPrice', u'prevClosePrice', u'openPrice', u'highPrice', u'lowPrice', u'lastPrice', u'closePrice', u'settlementPrice', u'openInterest', u'volume', u'value', u'upperLimitPrice', u'lowerLimitPrice', u'askPrice1', u'askVolume1', u'askPrice2', u'askVolume2', u'askPrice3', u'askVolume3', u'askPrice4', u'askVolume4', u'askPrice5', u'askVolume5', u'bidPrice1', u'bidVolume1', u'askPrice2', u'askVolume2', u'askPrice3', u'askVolume3', u'askPrice4', u'askVolume4', u'askPrice5', u'askVolume5', u'tflag']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'instrumentID': 'str','tflag': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def SHSZBarHistOneDayGet(tradeDate, exchangeCD, ticker, unit = "", startTime = "", endTime = "", field = "", pandas = "1"):
    """
    高频数据，获取一只或多只沪深证券在历史某一日的分钟线信息，包含1/3/5/15/30/60分钟的分钟线。 输入一只证券代码，如000001（平安银行）， 得到这只证券在历史某一日的分钟线数据。 证券目前是股票，指数，基金和部分债券。分钟线的有效数据上午从09：30 到11：30，下午从13：01到15：00，分钟线的计算规则为分钟内前开后闭，向后归结，即（9:31:00.000，9:32:00.000]归为9:32分的数据，9:30的分钟线包含时间范围为9:30:00前所有成交（即集合竞价成交）
    
    :param tradeDate: 查询日期，格式YYYYMMDD
    :param exchangeCD: 通联编制的证券市场编码。例如，XIBE-中国银行间市场；XSHE-深圳证券交易所等。对应DataAPI.SysCodeGet.codeTypeID=10002。
    :param ticker: 证券在证券市场通用的交易代码。,可以是列表
    :param unit: Bar(s)的时间宽度，单位分钟。取值范围： 1（分钟）/3(分钟)/5（分钟）/15（分钟）/30（分钟）/60（分钟）,可空
    :param startTime: 分钟线起始时间， 如09:40，就是从早上九点四十开始。 默认开始时间早上开市时间，即09:30，不选即为默认值,可空
    :param endTime: 分钟线终止时间， 如14:00, 就是到下午14点结束。 如终止时间是空， 则截止到最新数据或到关市为止，即15:00，不选即为默认值,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getSHSZBarHistOneDay.csv?ispandas=1&') 
    if not isinstance(tradeDate, str) and not isinstance(tradeDate, unicode):
        tradeDate = str(tradeDate)

    requestString.append("tradeDate=%s"%(tradeDate))
    if not isinstance(exchangeCD, str) and not isinstance(exchangeCD, unicode):
        exchangeCD = str(exchangeCD)

    requestString.append("&exchangeCD=%s"%(exchangeCD))
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    if not isinstance(unit, str) and not isinstance(unit, unicode):
        unit = str(unit)

    requestString.append("&unit=%s"%(unit))
    if not isinstance(startTime, str) and not isinstance(startTime, unicode):
        startTime = str(startTime)

    requestString.append("&startTime=%s"%(startTime))
    if not isinstance(endTime, str) and not isinstance(endTime, unicode):
        endTime = str(endTime)

    requestString.append("&endTime=%s"%(endTime))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 2154)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 2154)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'ticker', u'exchangeCD', u'shortNM', u'currencyCD', u'dataDate', u'barTime', u'closePrice', u'openPrice', u'highPrice', u'lowPrice', u'totalVolume', u'totalValue', u'unit']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'ticker': 'str','exchangeCD': 'str','shortNM': 'str','currencyCD': 'str','barTime': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HKBarHistOneDayGet(ticker, tradeDate, unit = "", startTime = "", endTime = "", field = "", pandas = "1"):
    """
    高频数据，获取一只或多只港交所股票在历史某一日的分钟线信息，包含1/3/5/15/30/60分钟的分钟线。 输入一只证券代码，如00001（长和）， 得到这只证券在历史某一日的分钟线数据。 分钟线的有效数据上午从09：30 到12：30（随机收市，分钟线计算延迟到12:30），下午从13：01到16：30（随机收市，分钟线计算延迟到16:30），分钟线的计算规则为分钟内前开后闭，向后归结，即（9:31:00.000，9:32:00.000]归为9:32分的数据，9:30的分钟线包含时间范围为9:30:00前所有成交（即集合竞价成交）
    
    :param ticker: 证券在证券市场通用的交易代码。,可以是列表
    :param tradeDate: 查询日期，格式YYYYMMDD
    :param unit: Bar(s)的时间宽度，单位分钟。取值范围： 1（分钟）/3(分钟)/5（分钟）/15（分钟）/30（分钟）/60（分钟）,可空
    :param startTime: 分钟线起始时间， 如09:40，就是从早上九点四十开始。 默认开始时间早上开市时间，即09:30，不选即为默认值,可空
    :param endTime: 分钟线终止时间， 如14:00, 就是到下午14点结束。 如终止时间是空， 则截止到最新数据或到关市为止，即16:30，不选即为默认值,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getHKBarHistOneDay.csv?ispandas=1&') 
    requestString.append("ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    if not isinstance(tradeDate, str) and not isinstance(tradeDate, unicode):
        tradeDate = str(tradeDate)

    requestString.append("&tradeDate=%s"%(tradeDate))
    if not isinstance(unit, str) and not isinstance(unit, unicode):
        unit = str(unit)

    requestString.append("&unit=%s"%(unit))
    if not isinstance(startTime, str) and not isinstance(startTime, unicode):
        startTime = str(startTime)

    requestString.append("&startTime=%s"%(startTime))
    if not isinstance(endTime, str) and not isinstance(endTime, unicode):
        endTime = str(endTime)

    requestString.append("&endTime=%s"%(endTime))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 2155)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 2155)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'ticker', u'exchangeCD', u'shortNM', u'currencyCD', u'dataDate', u'barTime', u'closePrice', u'openPrice', u'highPrice', u'lowPrice', u'totalVolume', u'totalValue', u'unit']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'ticker': 'str','exchangeCD': 'str','shortNM': 'str','currencyCD': 'str','barTime': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def NHIndexTickHistOneDayGet(ticker, tradeDate, field = "", pandas = "1"):
    """
    高频数据，获取一只南华指数在历史上某个交易日的Tick数据，指数范围仅包含以下6个：南华工业品指数、南华能化指数、南华贵金属指数、南华商品指数、南华金属指数、南华农产品指数
    
    :param ticker: NHCI-南华工业品指数、NHCI-南华能化指数、NHCI-南华贵金属指数、NHCI-南华商品指数、NHCI-南华金属指数、NHCI-南华农产品指数,可以是列表
    :param tradeDate: 清算日期，无夜盘的情况下同交易日期，格式为yyyymmdd
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getNHIndexTickHistOneDay.csv?ispandas=1&') 
    requestString.append("ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    if not isinstance(tradeDate, str) and not isinstance(tradeDate, unicode):
        tradeDate = str(tradeDate)

    requestString.append("&tradeDate=%s"%(tradeDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 2166)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 2166)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'ticker', u'tradeDate', u'tradeTime', u'updateSequence', u'clearingDay', u'volume', u'value', u'lastPrice', u'highPrice', u'lowPrice', u'openPrice', u'preClosePrice', u'openInt']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'ticker': 'str','tradeTime': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def EnergyFutureTicksIntraDayGet(instrumentID, field = "", pandas = "1"):
    """
    高频数据，获取一只上期能源期货合约在当日内Tick数据（目前仅包含石油品种，且为测试数据，该品种尚未上市）
    
    :param instrumentID: 上期能源期货合约交易代码，目前仅包含石油
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getEnergyFutureTicksIntraDay.csv?ispandas=1&') 
    if not isinstance(instrumentID, str) and not isinstance(instrumentID, unicode):
        instrumentID = str(instrumentID)

    requestString.append("instrumentID=%s"%(instrumentID))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 2167)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 2167)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'clearingDay', u'dataDate', u'dataTime', u'instrumentID', u'lastPrice', u'preSettlementPrice', u'prevClosePrice', u'preOpenInterest', u'openPrice', u'highPrice', u'lowPrice', u'volume', u'value', u'openInterest', u'closePrice', u'settlementPrice', u'upperLimitPrice', u'lowerLimitPrice', u'bidPrice1', u'bidVolume1', u'askPrice1', u'askVolume1']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'dataTime': 'str','instrumentID': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def NHFutureIndexTickRTSnapshotGet(ticker = "", field = "", pandas = "1"):
    """
    高频数据，获取南华指数最新市场信息快照，包含以下六个指数：南华工业品指数、南华能化指数、南华贵金属指数、南华商品指数、南华金属指数、南华农产品指数
    
    :param ticker: NHCI-南华工业品指数、NHCI-南华能化指数、NHCI-南华贵金属指数、NHCI-南华商品指数、NHCI-南华金属指数、NHCI-南华农产品指数,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getNHFutureIndexTickRTSnapshot.csv?ispandas=1&') 
    requestString.append("ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 2174)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 2174)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'clearingDay', u'dataDate', u'dataTime', u'ticker', u'prevClosePrice', u'openPrice', u'highPrice', u'lowPrice', u'lastPrice', u'value', u'volume', u'openInterest']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'clearingDay': 'str','dataDate': 'str','dataTime': 'str','ticker': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def SHSZTickRTSnapshotGet(exchangeCD, assetClass = "", ticker = "", field = "", pandas = "1"):
    """
    高频数据，获取一只或多只证券最新Level1信息快照。 输入一只或多只证券交易代码，如000001,并指定其证券品种,如"E",即可获取平安银行的最新市场信息快照, 证券可以是股票，指数， 部分债券或 基金
    
    :param exchangeCD: 通联编制的证券市场编码。例如，XSHG-上海证券交易所；XSHE-深圳证券交易所；XIBE-中国银行间市场等。对应DataAPI.SysCodeGet.codeTypeID=10002。,可以是列表
    :param assetClass: 通联编制的证券类别编码。例如，E-股票；B-债券；F-基金；IDX-指数等;对应DataAPI.SysCodeGet.codeTypeID=10001;不输入返回所有证券类型,可空
    :param ticker: 证券在证券市场通用的交易代码,不输入返回全市场证券,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getSHSZTickRTSnapshot.csv?ispandas=1&') 
    requestString.append("exchangeCD=")
    if hasattr(exchangeCD,'__iter__') and not isinstance(exchangeCD, str):
        if len(exchangeCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = exchangeCD
            requestString.append(None)
        else:
            requestString.append(','.join(exchangeCD))
    else:
        requestString.append(exchangeCD)
    if not isinstance(assetClass, str) and not isinstance(assetClass, unicode):
        assetClass = str(assetClass)

    requestString.append("&assetClass=%s"%(assetClass))
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'dataDate', u'dataTime', u'ticker', u'shortNM', u'exchangeCD', u'currencyCD', u'prevClosePrice', u'openPrice', u'highPrice', u'lowPrice', u'lastPrice', u'volume', u'value', u'deal', u'negMarketValue', u'MarketValue', u'staticPE', u'forwardPE', u'PETTM', u'PB', u'PCFTTM', u'PSTTM', u'amplitude', u'change', u'changePct', u'turnoverRate', u'askBook', u'bidBook', u'suspension', u'timestamp']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'dataDate': 'str','dataTime': 'str','ticker': 'str','shortNM': 'str','exchangeCD': 'str','currencyCD': 'str','askBook': 'str','bidBook': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HKTickRTSnapshotGet(ticker = "", field = "", pandas = "1"):
    """
    高频数据，获取一只或多只港交所证券最新市场信息快照。 输入一只或多只证券交易代码，如000001,并指定其证券品种,如"E"(目前仅支持股票),即可获取长和的最新市场信息快照
    
    :param ticker: 证券在证券市场通用的交易代码,不输入返回全市场证券,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getHKTickRTSnapshot.csv?ispandas=1&') 
    requestString.append("ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'dataDate', u'dataTime', u'ticker', u'currencyCD', u'prevClosePrice', u'openPrice', u'highPrice', u'lowPrice', u'lastPrice', u'nominalPrice', u'volume', u'value', u'askBook', u'bidBook', u'change', u'changePct', u'amplitude', u'VWAP', u'AggQty', u'IEP', u'tradSessionStatus', u'tradSessionID', u'tradSessionSubID', u'tradStatus', u'tradType', u'timestamp', u'localTimestamp']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'dataDate': 'str','dataTime': 'str','ticker': 'str','currencyCD': 'str','askBook': 'str','bidBook': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktIndustryQuoteGet(tradeDate = "", beginDate = "", endDate = "", industryID = "", statsFreq = "", field = "", pandas = "1"):
    """
    获取申万三级行业板块区间行情信息,区间维度包含1日，5日，10日，30日，60日，90日，180日，360日，720日，1080日,区间行情的计算方式主要包含算数平均,总市值加权,流通市值加权等
    
    :param tradeDate: 格式为"yyyymmdd",tradeDate、beginDate、endDate至少选择一个
    :param beginDate: 格式为"yyyymmdd",tradeDate、beginDate、endDate至少选择一个
    :param endDate: 格式为"yyyymmdd",tradeDate、beginDate、endDate至少选择一个
    :param industryID: 行业划分数字编码，通联赋予,可从接口getIndustry查询,不填写默认所有行业,可以是列表,可空
    :param statsFreq: 可输入1日，5日，10日，30日，60日，90日，180日，360日，720日，1080日,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktIndustryQuote.csv?ispandas=1&') 
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("tradeDate=%s"%(tradeDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&industryID=")
    if hasattr(industryID,'__iter__') and not isinstance(industryID, str):
        if len(industryID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = industryID
            requestString.append(None)
        else:
            requestString.append(','.join(industryID))
    else:
        requestString.append(industryID)
    if not isinstance(statsFreq, str) and not isinstance(statsFreq, unicode):
        statsFreq = str(statsFreq)

    requestString.append("&statsFreq=%s"%(statsFreq))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 2176)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 2176)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'industryID', u'industryName', u'tradeDate', u'statsFreq', u'varVol', u'openPriceAvg', u'hightestPriceAvg', u'lowestPriceAvg', u'closePriceAvg', u'openPriceTsW', u'highestPriceTsW', u'lowestPriceTsW', u'closePriceTsW', u'openPriceNfaW', u'highestPriceNfaW', u'lowestPriceNfaW', u'closePriceNfaW', u'turnoverVol', u'turnoverValue', u'chgPctAvg', u'chgPctMvW', u'chgPctNmvW', u'turnoverRateAvg', u'turnoverRateMvW', u'turnoverRateNmvW', u'totalMarketValue', u'marketValueAvg', u'totalNegMarketValue', u'negMarketValueAvg']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'industryID': 'str','industryName': 'str','statsFreq': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktConOptMSRGet(tradeDate = "", beginDate = "", endDate = "", secID = "", ticker = "", contractType = "", field = "", pandas = "1"):
    """
    商品期权合约空头持仓排名,大商所、郑商所所期权品种信息仅公布活跃月份（大商所标的期货合约双边持仓量大于、等于2万手）合约系列
    
    :param tradeDate: 格式为"yyyymmdd",tradeDate、beginDate、endDate至少选择一个
    :param beginDate: 格式为"yyyymmdd",tradeDate、beginDate、endDate至少选择一个
    :param endDate: 格式为"yyyymmdd",tradeDate、beginDate、endDate至少选择一个
    :param secID: 通联编制的证券编码。 可传入证券交易代码使用DataAPI.SecIDGet接口获取到。,可以是列表,可空
    :param ticker: 标的合约在交易所的交易代码,如m1801,可以是列表,可空
    :param contractType: CO:看涨期权,PO:看跌期权,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktConOptMSR.csv?ispandas=1&') 
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("tradeDate=%s"%(tradeDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    if not isinstance(contractType, str) and not isinstance(contractType, unicode):
        contractType = str(contractType)

    requestString.append("&contractType=%s"%(contractType))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 2177)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 2177)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'contractType', u'partyShortName', u'exchangeCD', u'tradeDate', u'shortOpenInt', u'chg', u'rank']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','contractType': 'str','partyShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktConOptMLRGet(tradeDate = "", beginDate = "", endDate = "", secID = "", ticker = "", contractType = "", field = "", pandas = "1"):
    """
    商品期权合约多头持仓排名,大商所、郑商所所期权品种信息仅公布活跃月份（大商所标的期货合约双边持仓量大于、等于2万手）合约系列
    
    :param tradeDate: 格式为"yyyymmdd",tradeDate、beginDate、endDate至少选择一个
    :param beginDate: 格式为"yyyymmdd",tradeDate、beginDate、endDate至少选择一个
    :param endDate: 格式为"yyyymmdd",tradeDate、beginDate、endDate至少选择一个
    :param secID: 通联编制的证券编码。 可传入证券交易代码使用DataAPI.SecIDGet接口获取到。,可以是列表,可空
    :param ticker: 标的合约在交易所的交易代码,如m1801,可以是列表,可空
    :param contractType: CO:看涨期权,PO:看跌期权,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktConOptMLR.csv?ispandas=1&') 
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("tradeDate=%s"%(tradeDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    if not isinstance(contractType, str) and not isinstance(contractType, unicode):
        contractType = str(contractType)

    requestString.append("&contractType=%s"%(contractType))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 2178)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 2178)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'contractType', u'partyShortName', u'exchangeCD', u'tradeDate', u'longOpenInt', u'chg', u'rank']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','contractType': 'str','partyShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktConOptMTRGet(tradeDate = "", beginDate = "", endDate = "", secID = "", ticker = "", contractType = "", field = "", pandas = "1"):
    """
    商品期权合约成交量排名,大商所、郑商所所期权品种信息仅公布活跃月份（大商所标的期货合约双边持仓量大于、等于2万手）合约系列
    
    :param tradeDate: 格式为"yyyymmdd",tradeDate、beginDate、endDate至少选择一个
    :param beginDate: 格式为"yyyymmdd",tradeDate、beginDate、endDate至少选择一个
    :param endDate: 格式为"yyyymmdd",tradeDate、beginDate、endDate至少选择一个
    :param secID: 通联编制的证券编码。 可传入证券交易代码使用DataAPI.SecIDGet接口获取到。,可以是列表,可空
    :param ticker: 标的合约在交易所的交易代码,如m1801,可以是列表,可空
    :param contractType: CO:看涨期权,PO:看跌期权,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktConOptMTR.csv?ispandas=1&') 
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("tradeDate=%s"%(tradeDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    if not isinstance(contractType, str) and not isinstance(contractType, unicode):
        contractType = str(contractType)

    requestString.append("&contractType=%s"%(contractType))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 2179)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 2179)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'contractType', u'partyShortName', u'exchangeCD', u'tradeDate', u'turnoverVol', u'chg', u'rank']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','contractType': 'str','partyShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def NHIndexTickRTIntraDayGet(ticker, field = "", pandas = "1"):
    """
    高频数据,获取一只南华期货指数在当日内的Tick数据,包含以下六个指数：南华工业品指数、南华能化指数、南华贵金属指数、南华商品指数、南华金属指数、南华农产品指数
    
    :param ticker: NHCI-南华工业品指数、NHCI-南华能化指数、NHCI-南华贵金属指数、NHCI-南华商品指数、NHCI-南华金属指数、NHCI-南华农产品指数
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getNHIndexTickRTIntraDay.csv?ispandas=1&') 
    if not isinstance(ticker, str) and not isinstance(ticker, unicode):
        ticker = str(ticker)

    requestString.append("ticker=%s"%(ticker))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 2180)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 2180)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'clearingDay', u'dataDate', u'dataTime', u'ticker', u'prevClosePrice', u'openPrice', u'highPrice', u'lowPrice', u'lastPrice', u'value', u'volume', u'openInterest', u'dataSeq']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'dataTime': 'str','ticker': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktIdxqGet(beginDate, endDate, secID = "", field = "", pandas = "1"):
    """
    获取指数季线行情信息，包含昨收价、开盘价、最高价、最低价、收盘价、成交量、成交金额等字段。每日16:00到20:00,次日上午10:00到12:00循环生产。
    
    :param beginDate: 起始日期，输入格式“YYYYMMDD”
    :param endDate: 截止日期，输入格式“YYYYMMDD”
    :param secID: 通联编制的证券编码，可传入证券交易代码使用DataAPI.SecIDGet接口获取到。,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktIdxq.csv?ispandas=1&') 
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 2185)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 2185)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indexID', u'ticker', u'secShortName', u'endDate', u'tradeDays', u'preClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'turnoverValue', u'chg', u'chgPct', u'avgPrice', u'qAvgReyurn']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indexID': 'str','ticker': 'str','secShortName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktIdxsGet(beginDate, endDate, secID = "", field = "", pandas = "1"):
    """
    获取指数半年线行情信息，包含昨收价、开盘价、最高价、最低价、收盘价、成交量、成交金额等字段。每日16:00到20:00,次日上午10:00到12:00循环生产。
    
    :param beginDate: 起始日期，输入格式“YYYYMMDD”
    :param endDate: 截止日期，输入格式“YYYYMMDD”
    :param secID: 通联编制的证券编码，可传入证券交易代码使用DataAPI.SecIDGet接口获取到。,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktIdxs.csv?ispandas=1&') 
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 2186)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 2186)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indexID', u'ticker', u'secShortName', u'endDate', u'tradeDays', u'preClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'turnoverValue', u'chg', u'chgPct', u'avgPrice', u'sAvgReyurn']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indexID': 'str','ticker': 'str','secShortName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktIdxaGet(beginDate, endDate, secID = "", field = "", pandas = "1"):
    """
    获取指数年线行情信息，包含昨收价、开盘价、最高价、最低价、收盘价、成交量、成交金额等字段。每日16:00到20:00,次日上午10:00到12:00循环生产。
    
    :param beginDate: 起始日期，输入格式“YYYYMMDD”
    :param endDate: 截止日期，输入格式“YYYYMMDD”
    :param secID: 通联编制的证券编码，可传入证券交易代码使用DataAPI.SecIDGet接口获取到。,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktIdxa.csv?ispandas=1&') 
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 2187)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 2187)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indexID', u'ticker', u'secShortName', u'endDate', u'tradeDays', u'preClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'turnoverValue', u'chg', u'chgPct', u'avgPrice', u'aAvgReyurn']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indexID': 'str','ticker': 'str','secShortName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FXTickRTSnapshotGet(currencyPair, field = "", pandas = "1"):
    """
    获取福汇外汇市场信息快照
    
    :param currencyPair: 货币对，包含以下几种：USD|CHF，EUR|USD，GBP|USD，GBP|AUD，USD|CAD，NZD|USD，EUR|JPY，NZD|CAD，AUD|NZD，EUR|GBP，GBP|CAD，GBP|JPY，AUD|JPY，USD|JPY，EUR|CHF，USD|CNH，EUR|AUD，AUD|CHF，AUD|USD，USD|HKD，不输入返回全部,可以是列表
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getFXTickRTSnapshot.csv?ispandas=1&') 
    requestString.append("currencyPair=")
    if hasattr(currencyPair,'__iter__') and not isinstance(currencyPair, str):
        if len(currencyPair) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = currencyPair
            requestString.append(None)
        else:
            requestString.append(','.join(currencyPair))
    else:
        requestString.append(currencyPair)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 2190)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 2190)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'currencyPair', u'offerID', u'quoteID', u'tradeDate', u'dataTime', u'bid', u'ask', u'Low', u'High', u'volume', u'valueDate', u'buyInterest', u'sellInterest', u'contractCurrency', u'contractMultiplier', u'Digits', u'pointSize', u'tradingStatus', u'localTimestamp']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'currencyPair': 'str','quoteID': 'str','tradeDate': 'str','dataTime': 'str','valueDate': 'str','contractCurrency': 'str','tradingStatus': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FXTickRTIntraDayGet(currencyPair, field = "", pandas = "1"):
    """
    获取福汇外汇市场当日Tick数据信息
    
    :param currencyPair: 货币对，包含EUR|USD、USD|JPY、GBP|USD、USD|CHF、EUR|CHF、AUD|USD、AUD|CHF、USD|CAD、NZD|USD、EUR|GBP、USD|CNH、EUR|JPY、GBP|JPY、EUR|AUD、AUD|JPY、USD|HKD、GBP|CAD、GBP|AUD、NZD|CAD、AUD|NZD
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getFXTickRTIntraDay.csv?ispandas=1&') 
    if not isinstance(currencyPair, str) and not isinstance(currencyPair, unicode):
        currencyPair = str(currencyPair)

    requestString.append("currencyPair=%s"%(currencyPair))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 2203)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 2203)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'updateDate', u'updateTime', u'offerID', u'currencyPair', u'quoteID', u'bid', u'ask', u'low', u'high', u'volume', u'sellInterest', u'buyInterest', u'contractCurrency', u'digits', u'pointSize', u'contractMultiplier', u'tradingStatus', u'valueDate']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'currencyPair': 'str','quoteID': 'str','contractCurrency': 'str','tradingStatus': 'str','valueDate': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktEquqGet(beginDate, endDate, secID = "", ticker = "", field = "", pandas = "1"):
    """
    获取股票季行情，包含季开高低收量价、涨跌幅等信息
    
    :param beginDate: 查询的起始日期，输入格式“YYYYMMDD”
    :param endDate: 查询的截止日期，输入格式“YYYYMMDD”
    :param secID: 通联编制的证券编码，可传入证券交易代码使用DataAPI.SecIDGet接口获取到。,可以是列表,可空
    :param ticker: 证券在证券市场通用的交易代码。,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktEquq.csv?ispandas=1&') 
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 2214)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 2214)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'endDate', u'tradeDays', u'preClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'turnoverValue', u'chg', u'chgPct']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktEquqAdjGet(beginDate, endDate, secID = "", ticker = "", field = "", pandas = "1"):
    """
    获取股票季前复权行情，包含季开高低收量价、涨跌幅等信息
    
    :param beginDate: 查询的起始日期，输入格式“YYYYMMDD”
    :param endDate: 查询的截止日期，输入格式“YYYYMMDD”
    :param secID: 通联编制的证券编码，可传入证券交易代码使用DataAPI.SecIDGet接口获取到。,可以是列表,可空
    :param ticker: 证券在证券市场通用的交易代码。,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktEquqAdj.csv?ispandas=1&') 
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 2215)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 2215)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'endDate', u'tradeDays', u'preClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'turnoverValue', u'chg', u'chgPct']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktEquqAdjAfGet(beginDate, endDate, secID = "", ticker = "", field = "", pandas = "1"):
    """
    获取股票季后复权行情，包含季开高低收量价、涨跌幅等信息
    
    :param beginDate: 查询的起始日期，输入格式“YYYYMMDD”
    :param endDate: 查询的截止日期，输入格式“YYYYMMDD”
    :param secID: 通联编制的证券编码，可传入证券交易代码使用DataAPI.SecIDGet接口获取到。,可以是列表,可空
    :param ticker: 证券在证券市场通用的交易代码。,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktEquqAdjAf.csv?ispandas=1&') 
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 2216)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 2216)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'endDate', u'tradeDays', u'preClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'turnoverValue', u'chg', u'chgPct']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktEqusGet(beginDate, endDate, secID = "", ticker = "", field = "", pandas = "1"):
    """
    获取股票半年行情，包含季开高低收量价、涨跌幅等信息
    
    :param beginDate: 查询的起始日期，输入格式“YYYYMMDD”
    :param endDate: 查询的截止日期，输入格式“YYYYMMDD”
    :param secID: 通联编制的证券编码，可传入证券交易代码使用DataAPI.SecIDGet接口获取到。,可以是列表,可空
    :param ticker: 证券在证券市场通用的交易代码。,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktEqus.csv?ispandas=1&') 
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 2217)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 2217)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'endDate', u'tradeDays', u'preClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'turnoverValue', u'chg', u'chgPct']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktEqusAdjGet(beginDate, endDate, secID = "", ticker = "", field = "", pandas = "1"):
    """
    获取股票半年前复权行情，包含季开高低收量价、涨跌幅等信息
    
    :param beginDate: 查询的起始日期，输入格式“YYYYMMDD”
    :param endDate: 查询的截止日期，输入格式“YYYYMMDD”
    :param secID: 通联编制的证券编码，可传入证券交易代码使用DataAPI.SecIDGet接口获取到。,可以是列表,可空
    :param ticker: 证券在证券市场通用的交易代码。,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktEqusAdj.csv?ispandas=1&') 
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 2218)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 2218)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'endDate', u'tradeDays', u'preClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'turnoverValue', u'chg', u'chgPct']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktEqusAdjAfGet(beginDate, endDate, secID = "", ticker = "", field = "", pandas = "1"):
    """
    获取股票半年后复权行情，包含季开高低收量价、涨跌幅等信息
    
    :param beginDate: 查询的起始日期，输入格式“YYYYMMDD”
    :param endDate: 查询的截止日期，输入格式“YYYYMMDD”
    :param secID: 通联编制的证券编码，可传入证券交易代码使用DataAPI.SecIDGet接口获取到。,可以是列表,可空
    :param ticker: 证券在证券市场通用的交易代码。,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktEqusAdjAf.csv?ispandas=1&') 
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 2219)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 2219)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'endDate', u'tradeDays', u'preClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'turnoverValue', u'chg', u'chgPct']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktEquaGet(beginDate, endDate, secID = "", ticker = "", field = "", pandas = "1"):
    """
    获取股票年行情，包含季开高低收量价、涨跌幅等信息
    
    :param beginDate: 查询的起始日期，输入格式“YYYYMMDD”
    :param endDate: 查询的截止日期，输入格式“YYYYMMDD”
    :param secID: 通联编制的证券编码，可传入证券交易代码使用DataAPI.SecIDGet接口获取到。,可以是列表,可空
    :param ticker: 证券在证券市场通用的交易代码。,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktEqua.csv?ispandas=1&') 
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 2220)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 2220)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'endDate', u'tradeDays', u'preClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'turnoverValue', u'chg', u'chgPct']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktEquaAdjGet(beginDate, endDate, secID = "", ticker = "", field = "", pandas = "1"):
    """
    获取股票年前复权行情，包含季开高低收量价、涨跌幅等信息
    
    :param beginDate: 查询的起始日期，输入格式“YYYYMMDD”
    :param endDate: 查询的截止日期，输入格式“YYYYMMDD”
    :param secID: 通联编制的证券编码，可传入证券交易代码使用DataAPI.SecIDGet接口获取到。,可以是列表,可空
    :param ticker: 证券在证券市场通用的交易代码。,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktEquaAdj.csv?ispandas=1&') 
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 2221)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 2221)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'endDate', u'tradeDays', u'preClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'turnoverValue', u'chg', u'chgPct']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktEquaAdjAfGet(beginDate, endDate, secID = "", ticker = "", field = "", pandas = "1"):
    """
    获取股票年后复权行情，包含季开高低收量价、涨跌幅等信息
    
    :param beginDate: 查询的起始日期，输入格式“YYYYMMDD”
    :param endDate: 查询的截止日期，输入格式“YYYYMMDD”
    :param secID: 通联编制的证券编码，可传入证券交易代码使用DataAPI.SecIDGet接口获取到。,可以是列表,可空
    :param ticker: 证券在证券市场通用的交易代码。,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktEquaAdjAf.csv?ispandas=1&') 
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 2222)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 2222)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'endDate', u'tradeDays', u'preClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'turnoverValue', u'chg', u'chgPct']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FXBarRTIntraDayGet(currencyPair, field = "", pandas = "1"):
    """
    高频数据，获取福汇外汇交易市场当日分钟线数据
    
    :param currencyPair: 货币对，包含EUR|USD、USD|JPY、GBP|USD、USD|CHF、EUR|CHF、AUD|USD、AUD|CHF、USD|CAD、NZD|USD、EUR|GBP、USD|CNH、EUR|JPY、GBP|JPY、EUR|AUD、AUD|JPY、USD|HKD、GBP|CAD、GBP|AUD、NZD|CAD、AUD|NZD,可以是列表
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getFXBarRTIntraDay.csv?ispandas=1&') 
    requestString.append("currencyPair=")
    if hasattr(currencyPair,'__iter__') and not isinstance(currencyPair, str):
        if len(currencyPair) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = currencyPair
            requestString.append(None)
        else:
            requestString.append(','.join(currencyPair))
    else:
        requestString.append(currencyPair)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 2233)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 2233)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'dataDate', u'currencyPair', u'barTime', u'openBid', u'highBid', u'lowBid', u'closeBid', u'openAsk', u'highAsk', u'lowAsk', u'closeAsk', u'totalTicks']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'currencyPair': 'str','barTime': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def NHIndexBarRTIntraDayGet(ticker, field = "", pandas = "1"):
    """
    高频数据，获取一只南华指数当日分钟线数据，指数范围仅包含以下6个：南华工业品指数、南华能化指数、南华贵金属指数、南华商品指数、南华金属指数、南华农产品指数
    
    :param ticker: NHCI-南华工业品指数、NHCI-南华能化指数、NHCI-南华贵金属指数、NHCI-南华商品指数、NHCI-南华金属指数、NHCI-南华农产品指数
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getNHIndexBarRTIntraDay.csv?ispandas=1&') 
    if not isinstance(ticker, str) and not isinstance(ticker, unicode):
        ticker = str(ticker)

    requestString.append("ticker=%s"%(ticker))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 2238)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 2238)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'dataDate', u'clearingDay', u'barTime', u'offSet', u'ticker', u'openPrice', u'highPrice', u'lowPrice', u'closePirce', u'volume', u'value', u'openInt']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'barTime': 'str','ticker': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktFutqGet(beginDate, endDate, secID = "", ticker = "", field = "", pandas = "1"):
    """
    获取期货季行情，包含季开高低收量价以及持仓等信息，计算周期内剔除未成交交易日
    
    :param beginDate: 查询的起始日期，输入格式“YYYYMMDD”
    :param endDate: 查询的截止日期，输入格式“YYYYMMDD”
    :param secID: 通联编制的证券编码，可传入证券交易代码使用DataAPI.SecIDGet接口获取到。,可以是列表,可空
    :param ticker: 证券在证券市场通用的交易代码。,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktFutq.csv?ispandas=1&') 
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 2223)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 2223)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'endDate', u'tradeDays', u'preClosePrice', u'preSettlePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'settlePrice', u'turnoverVol', u'turnoverVolChg', u'turnoverValue', u'turnoverValueChg', u'openInt', u'openIntChg']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktFutsGet(beginDate, endDate, secID = "", ticker = "", field = "", pandas = "1"):
    """
    获取期货半年行情，包含半年度开高低收量价以及持仓等信息，计算周期内剔除未成交交易日
    
    :param beginDate: 查询的起始日期，输入格式“YYYYMMDD”
    :param endDate: 查询的截止日期，输入格式“YYYYMMDD”
    :param secID: 通联编制的证券编码，可传入证券交易代码使用DataAPI.SecIDGet接口获取到。,可以是列表,可空
    :param ticker: 证券在证券市场通用的交易代码。,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktFuts.csv?ispandas=1&') 
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 2224)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 2224)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'endDate', u'tradeDays', u'preClosePrice', u'preSettlePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'settlePrice', u'turnoverVol', u'turnoverVolChg', u'turnoverValue', u'turnoverValueChg', u'openInt', u'openIntChg']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktFutaGet(beginDate, endDate, secID = "", ticker = "", field = "", pandas = "1"):
    """
    获取期货年行情，包含年开高低收量价以及持仓等信息，计算周期内剔除未成交交易日
    
    :param beginDate: 查询的起始日期，输入格式“YYYYMMDD”
    :param endDate: 查询的截止日期，输入格式“YYYYMMDD”
    :param secID: 通联编制的证券编码，可传入证券交易代码使用DataAPI.SecIDGet接口获取到。,可以是列表,可空
    :param ticker: 证券在证券市场通用的交易代码。,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktFuta.csv?ispandas=1&') 
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 2225)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 2225)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'endDate', u'tradeDays', u'preClosePrice', u'preSettlePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'settlePrice', u'turnoverVol', u'turnoverVolChg', u'turnoverValue', u'turnoverValueChg', u'openInt', u'openIntChg']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def CryptoTickRTSnapShotHBGet(instrumentID = "", field = "", pandas = "1"):
    """
    获取火币网数字货币最新市场信息快照，仅包含BTC（比特币）和LTC（莱特币）
    
    :param instrumentID: 货币代码，目前仅包含BTC、LTC，允许多值输入,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getCryptoTickRTSnapShotHB.csv?ispandas=1&') 
    requestString.append("instrumentID=")
    if hasattr(instrumentID,'__iter__') and not isinstance(instrumentID, str):
        if len(instrumentID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = instrumentID
            requestString.append(None)
        else:
            requestString.append(','.join(instrumentID))
    else:
        requestString.append(instrumentID)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 2260)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 2260)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'instrumentID', u'tradeDate', u'tradeTime', u'utcOffset', u'currencyCD', u'exchangeCD', u'openPrice', u'highPrice', u'lowPrice', u'lastPrice', u'askBook', u'bidBook', u'volume', u'totalVolume', u'timestamp', u'localTimestamp']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'instrumentID': 'str','tradeDate': 'str','tradeTime': 'str','utcOffset': 'str','currencyCD': 'str','exchangeCD': 'str','askBook': 'str','bidBook': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FXBarHistOneDayGet(currencyPair, tradeDate, field = "", pandas = "1"):
    """
    获取外汇交易市场历史某一日的分钟线数据
    
    :param currencyPair: 货币对，包含EUR|USD、USD|JPY、GBP|USD、USD|CHF、EUR|CHF、AUD|USD、AUD|CHF、USD|CAD、NZD|USD、EUR|GBP、USD|CNH、EUR|JPY、GBP|JPY、EUR|AUD、AUD|JPY、USD|HKD、GBP|CAD、GBP|AUD、NZD|CAD、AUD|NZD
    :param tradeDate: 交易日期，格式为YYYYMMDD
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getFXBarHistOneDay.csv?ispandas=1&') 
    if not isinstance(currencyPair, str) and not isinstance(currencyPair, unicode):
        currencyPair = str(currencyPair)

    requestString.append("currencyPair=%s"%(currencyPair))
    if not isinstance(tradeDate, str) and not isinstance(tradeDate, unicode):
        tradeDate = str(tradeDate)

    requestString.append("&tradeDate=%s"%(tradeDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 2257)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 2257)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'currencyPair', u'tradeDate', u'barTime', u'openBid', u'highBid', u'lowBid', u'closeBid', u'openAsk', u'highAsk', u'lowAsk', u'closeAsk', u'totalTick']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'currencyPair': 'str','barTime': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FXTickHistOneDayGet(currencyPair, tradeDate, field = "", pandas = "1"):
    """
    获取外汇交易市场历史某一日的Tick数据
    
    :param currencyPair: 货币对，包含EUR|USD、USD|JPY、GBP|USD、USD|CHF、EUR|CHF、AUD|USD、AUD|CHF、USD|CAD、NZD|USD、EUR|GBP、USD|CNH、EUR|JPY、GBP|JPY、EUR|AUD、AUD|JPY、USD|HKD、GBP|CAD、GBP|AUD、NZD|CAD、AUD|NZD
    :param tradeDate: 更新日期，经格林威治时间转为北京时间
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getFXTickHistOneDay.csv?ispandas=1&') 
    if not isinstance(currencyPair, str) and not isinstance(currencyPair, unicode):
        currencyPair = str(currencyPair)

    requestString.append("currencyPair=%s"%(currencyPair))
    if not isinstance(tradeDate, str) and not isinstance(tradeDate, unicode):
        tradeDate = str(tradeDate)

    requestString.append("&tradeDate=%s"%(tradeDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 2258)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 2258)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'offerID', u'currencyPair', u'quoteID', u'bid', u'ask', u'Low', u'High', u'volume', u'updateDate', u'updateTime', u'sellInterest', u'buyInterest', u'contractCurrency', u'Digits', u'pointSize', u'contractMultiplier', u'tradingStatus', u'valueDate']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'currencyPair': 'str','quoteID': 'str','contractCurrency': 'str','tradingStatus': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def NHIndexBarHistOneDayGet(ticker, tradeDate, unit = "", field = "", pandas = "1"):
    """
    获取一只南华指数在历史某一日分钟线数据
    
    :param ticker: NHCI-南华工业品指数、NHCI-南华能化指数、NHCI-南华贵金属指数、NHCI-南华商品指数、NHCI-南华金属指数、NHCI-南华农产品指数
    :param tradeDate: 交易日期
    :param unit: 当前bar时间,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getNHIndexBarHistOneDay.csv?ispandas=1&') 
    if not isinstance(ticker, str) and not isinstance(ticker, unicode):
        ticker = str(ticker)

    requestString.append("ticker=%s"%(ticker))
    if not isinstance(tradeDate, str) and not isinstance(tradeDate, unicode):
        tradeDate = str(tradeDate)

    requestString.append("&tradeDate=%s"%(tradeDate))
    if not isinstance(unit, str) and not isinstance(unit, unicode):
        unit = str(unit)

    requestString.append("&unit=%s"%(unit))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 2259)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 2259)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'tradeDate', u'ticker', u'secOffSet', u'barTime', u'closePrice', u'openPrice', u'highPrice', u'lowPrice', u'volume', u'value', u'openInt']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'tradeDate': 'str','ticker': 'str','barTime': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktHKCbbcdGet(tradeDate, secID = "", ticker = "", field = "", pandas = "1"):
    """
    获取港交所牛熊证日行情信息，包含昨收价、开盘价、最高价、最低价、收盘价、成交量、成交金额等字段
    
    :param tradeDate: 交易日期，格式为yyyyymmdd
    :param secID: 通联编制的证券编码，格式是“交易代码.证券市场代码”,可传入证券交易代码使用DataAPI.SecIDGet接口获取到。,可以是列表,可空
    :param ticker: 证券在证券市场通用的交易代码。,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktHKCbbcd.csv?ispandas=1&') 
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("tradeDate=%s"%(tradeDate))
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 2243)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 2243)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'secShortName', u'ticker', u'exchangeCD', u'tradeDate', u'preClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'turnoverValue', u'chg', u'chgPct']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','secShortName': 'str','ticker': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktHKDwdGet(tradeDate, secID = "", ticker = "", field = "", pandas = "1"):
    """
    获取港交所权证日行情信息，包含昨收价、开盘价、最高价、最低价、收盘价、成交量、成交金额等字段
    
    :param tradeDate: 交易日期，格式为yyyyymmdd
    :param secID: 通联编制的证券编码，格式是“交易代码.证券市场代码”,可传入证券交易代码使用DataAPI.SecIDGet接口获取到。,可以是列表,可空
    :param ticker: 证券在证券市场通用的交易代码。,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktHKDwd.csv?ispandas=1&') 
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("tradeDate=%s"%(tradeDate))
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 2244)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 2244)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'secShortName', u'ticker', u'exchangeCD', u'tradeDate', u'preClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'turnoverValue', u'chg', u'chgPct']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','secShortName': 'str','ticker': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktEquLatestTraddayGet(tradeDate, secID = "", ticker = "", field = "", pandas = "1"):
    """
    获取某只股票在某一交易日的最近交易日，若当日不停牌，最近交易日即当日，若停牌，为上一个有成交的交易日
    
    :param tradeDate: 交易日期，格式为yyyyymmdd
    :param secID: 通联编制的证券编码，格式是“交易代码.证券市场代码”,可传入证券交易代码使用DataAPI.SecIDGet接口获取到。,可以是列表,secID、ticker至少选择一个
    :param ticker: 证券在证券市场通用的交易代码。,可以是列表,secID、ticker至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktEquLatestTradday.csv?ispandas=1&') 
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("tradeDate=%s"%(tradeDate))
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 2240)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 2240)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'secShortName', u'ticker', u'exchangeCD', u'tradeDate', u'latestTradday']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','secShortName': 'str','ticker': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FdmtBSGet(ticker = "", secID = "", reportType = "", endDateRep = "", beginDateRep = "", beginYear = "", endYear = "", fiscalPeriod = "", endDate = "", beginDate = "", publishDateEnd = "", publishDateBegin = "", field = "", pandas = "1"):
    """
     1、根据2007年新会计准则制定的合并资产负债表模板，收集了2007年以来沪深上市公司定期报告中各个会计期间的资产负债表数据； 2、仅收集合并报表数据，包括期末和期初数据； 3、如果上市公司对外财务报表进行更正，调整，均有采集并对外展示； 4、本表中单位为人民币元； 5、每季更新。
    
    :param ticker: 股票代码，如'000002',可以是列表,ticker、secID、reportType至少选择一个
    :param secID: 证券内部编码,可通过交易代码和交易市场在DataAPI.SecIDGet获取到,如'000002.XSHE',可以是列表,ticker、secID、reportType至少选择一个
    :param reportType: 报告类型。Q1-一季度，S1-半年度，Q3-三季度，A-年度。对应DataAPI.SysCodeGet.codeTypeID=70001。,可以是列表,ticker、secID、reportType至少选择一个
    :param endDateRep: 报表会计期末，结束时间，输入格式“YYYYMMDD”,可空
    :param beginDateRep: 报表会计期末，起始时间，输入格式“YYYYMMDD”,可空
    :param beginYear: 年度，起始时间，输入格式"YYYY",可空
    :param endYear: 年度，结束时间，输入格式"YYYY",可空
    :param fiscalPeriod: 会计期间长度，3，6，9，12,可多值输入,可以是列表,可空
    :param endDate: 会计期间截止日期，结束时间，输入格式“YYYYMMDD”,可空
    :param beginDate: 会计期间截止日期，起始时间，输入格式“YYYYMMDD”,可空
    :param publishDateEnd: 证券交易所披露的信息发布日期，结束时间，默认为当前日期，输入格式“YYYYMMDD”,可空
    :param publishDateBegin: 证券交易所披露的信息发布日期，起始时间，默认为1年前当前日期，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getFdmtBS.csv?ispandas=1&') 
    requestString.append("ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&reportType=")
    if hasattr(reportType,'__iter__') and not isinstance(reportType, str):
        if len(reportType) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = reportType
            requestString.append(None)
        else:
            requestString.append(','.join(reportType))
    else:
        requestString.append(reportType)
    try:
        endDateRep = endDateRep.strftime('%Y%m%d')
    except:
        endDateRep = endDateRep.replace('-', '')
    requestString.append("&endDateRep=%s"%(endDateRep))
    try:
        beginDateRep = beginDateRep.strftime('%Y%m%d')
    except:
        beginDateRep = beginDateRep.replace('-', '')
    requestString.append("&beginDateRep=%s"%(beginDateRep))
    if not isinstance(beginYear, str) and not isinstance(beginYear, unicode):
        beginYear = str(beginYear)

    requestString.append("&beginYear=%s"%(beginYear))
    if not isinstance(endYear, str) and not isinstance(endYear, unicode):
        endYear = str(endYear)

    requestString.append("&endYear=%s"%(endYear))
    requestString.append("&fiscalPeriod=")
    if hasattr(fiscalPeriod,'__iter__') and not isinstance(fiscalPeriod, str):
        if len(fiscalPeriod) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = fiscalPeriod
            requestString.append(None)
        else:
            requestString.append(','.join(fiscalPeriod))
    else:
        requestString.append(fiscalPeriod)
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        publishDateEnd = publishDateEnd.strftime('%Y%m%d')
    except:
        publishDateEnd = publishDateEnd.replace('-', '')
    requestString.append("&publishDateEnd=%s"%(publishDateEnd))
    try:
        publishDateBegin = publishDateBegin.strftime('%Y%m%d')
    except:
        publishDateBegin = publishDateBegin.replace('-', '')
    requestString.append("&publishDateBegin=%s"%(publishDateBegin))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 151)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 151)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'publishDate', u'endDate', u'endDateRep', u'partyID', u'ticker', u'secShortName', u'exchangeCD', u'actPubtime', u'mergedFlag', u'reportType', u'fiscalPeriod', u'accoutingStandards', u'currencyCD', u'cashCEquiv', u'settProv', u'loanToOthBankFi', u'tradingFA', u'NotesReceiv', u'AR', u'prepayment', u'premiumReceiv', u'reinsurReceiv', u'reinsurReserReceiv', u'intReceiv', u'divReceiv', u'othReceiv', u'purResaleFa', u'inventories', u'NCAWithin1Y', u'othCA', u'TCA', u'disburLA', u'availForSaleFa', u'htmInvest', u'LTReceive', u'LTEquityInvest', u'investRealEstate', u'fixedAssets', u'CIP', u'constMaterials', u'fixedAssetsDisp', u'producBiolAssets', u'oilAndGasAssets', u'intanAssets', u'RD', u'goodwill', u'LTAmorExp', u'deferTaxAssets', u'othNCA', u'TNCA', u'TAssets', u'STBorr', u'CBBorr', u'depos', u'loanFrOthBankFi', u'tradingFL', u'NotesPayable', u'AP', u'advanceReceipts', u'soldForRepurFa', u'commisPayable', u'payrollPayable', u'taxesPayable', u'intPayable', u'divPayable', u'othPayable', u'reinsurPayable', u'insurReser', u'fundsSecTradAgen', u'fundsSecUndwAgen', u'NCLWithin1Y', u'othCL', u'TCL', u'LTBorr', u'bondPayable', u'preferredStockL', u'perpetualBondL', u'LTPayable', u'specificPayables', u'estimatedLiab', u'deferTaxLiab', u'othNCL', u'TNCL', u'TLiab', u'paidInCapital', u'othEquityInstr', u'preferredStockE', u'perpetualBondE', u'capitalReser', u'treasuryShare', u'othCompreIncome', u'specialReser', u'surplusReser', u'ordinRiskReser', u'retainedEarnings', u'forexDiffer', u'TEquityAttrP', u'minorityInt', u'TShEquity', u'TLiabEquity']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str','actPubtime': 'str','mergedFlag': 'str','reportType': 'str','fiscalPeriod': 'str','accoutingStandards': 'str','currencyCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FdmtBSBankGet(ticker = "", secID = "", reportType = "", endDate = "", beginDate = "", publishDateEnd = "", publishDateBegin = "", endDateRep = "", beginDateRep = "", beginYear = "", endYear = "", fiscalPeriod = "", field = "", pandas = "1"):
    """
     1、根据2007年新会计准则制定的银行业资产负债表模板，收集了2007年以来沪深上市公司定期报告中所有以此模板披露的资产负债表数据；（主要是银行业上市公司） 2、仅收集合并报表数据，包括期末和期初数据； 3、如果上市公司对外财务报表进行更正，调整，均有采集并对外展示； 4、本表中单位为人民币元； 5、每季更新。
    
    :param ticker: 股票代码，如'000001',可以是列表,ticker、secID、reportType至少选择一个
    :param secID: 证券内部编码,可通过交易代码和交易市场在DataAPI.SecIDGet获取到,如'000001.XSHE',可以是列表,ticker、secID、reportType至少选择一个
    :param reportType: 报告类型。Q1-一季度，S1-半年度，Q3-三季度，A-年度。对应DataAPI.SysCodeGet.codeTypeID=70001。,可以是列表,ticker、secID、reportType至少选择一个
    :param endDate: 会计期间截止日期，结束时间，输入格式“YYYYMMDD”,可空
    :param beginDate: 会计期间截止日期，起始时间，输入格式“YYYYMMDD”,可空
    :param publishDateEnd: 证券交易所披露的信息发布日期，结束时间，默认为当前日期，输入格式“YYYYMMDD”,可空
    :param publishDateBegin: 证券交易所披露的信息发布日期，起始时间，默认为1年前当前日期，输入格式“YYYYMMDD”,可空
    :param endDateRep: 报表会计期末，结束时间，输入格式“YYYYMMDD”,可空
    :param beginDateRep: 报表会计期末，起始时间，输入格式“YYYYMMDD”,可空
    :param beginYear: 年度，起始时间，输入格式"YYYY",可空
    :param endYear: 年度，结束时间，输入格式"YYYY",可空
    :param fiscalPeriod: 会计期间长度，3，6，9，12,可多值输入,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getFdmtBSBank.csv?ispandas=1&') 
    requestString.append("ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&reportType=")
    if hasattr(reportType,'__iter__') and not isinstance(reportType, str):
        if len(reportType) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = reportType
            requestString.append(None)
        else:
            requestString.append(','.join(reportType))
    else:
        requestString.append(reportType)
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        publishDateEnd = publishDateEnd.strftime('%Y%m%d')
    except:
        publishDateEnd = publishDateEnd.replace('-', '')
    requestString.append("&publishDateEnd=%s"%(publishDateEnd))
    try:
        publishDateBegin = publishDateBegin.strftime('%Y%m%d')
    except:
        publishDateBegin = publishDateBegin.replace('-', '')
    requestString.append("&publishDateBegin=%s"%(publishDateBegin))
    try:
        endDateRep = endDateRep.strftime('%Y%m%d')
    except:
        endDateRep = endDateRep.replace('-', '')
    requestString.append("&endDateRep=%s"%(endDateRep))
    try:
        beginDateRep = beginDateRep.strftime('%Y%m%d')
    except:
        beginDateRep = beginDateRep.replace('-', '')
    requestString.append("&beginDateRep=%s"%(beginDateRep))
    if not isinstance(beginYear, str) and not isinstance(beginYear, unicode):
        beginYear = str(beginYear)

    requestString.append("&beginYear=%s"%(beginYear))
    if not isinstance(endYear, str) and not isinstance(endYear, unicode):
        endYear = str(endYear)

    requestString.append("&endYear=%s"%(endYear))
    requestString.append("&fiscalPeriod=")
    if hasattr(fiscalPeriod,'__iter__') and not isinstance(fiscalPeriod, str):
        if len(fiscalPeriod) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = fiscalPeriod
            requestString.append(None)
        else:
            requestString.append(','.join(fiscalPeriod))
    else:
        requestString.append(fiscalPeriod)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 152)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 152)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'publishDate', u'endDate', u'endDateRep', u'partyID', u'ticker', u'secShortName', u'exchangeCD', u'actPubtime', u'mergedFlag', u'reportType', u'fiscalPeriod', u'accoutingStandards', u'currencyCD', u'loanToOthBankFi', u'tradingFA', u'intReceiv', u'purResaleFa', u'disburLA', u'availForSaleFA', u'htmInvest', u'LTEquityInvest', u'investRealEstate', u'fixedAssets', u'CIP', u'intanAssets', u'goodwill', u'deferTaxAssets', u'CReserCB', u'deposInOthBfi', u'preciMetals', u'derivAssets', u'finanLeaseReceiv', u'investAsReceiv', u'othAssets', u'AE', u'AA', u'TAssets', u'CBBorr', u'depos', u'loanFrOthBankFi', u'tradingFL', u'soldForRepurFa', u'payrollPayable', u'taxesPayable', u'intPayable', u'bondPayable', u'preferredStockL', u'perpetualBondL', u'estimatedLiab', u'deferTaxLiab', u'deposFrOthBfi', u'derivLiab', u'othLiab', u'LE', u'LA', u'TLiab', u'paidInCapital', u'othEquityInstr', u'preferredStockE', u'perpetualBondE', u'capitalReser', u'treasuryShare', u'othCompreIncome', u'surplusReser', u'ordinRiskReser', u'retainedEarnings', u'forexDiffer', u'SEE', u'SEA', u'TEquityAttrP', u'minorityInt', u'othEffectSE', u'othEffectSA', u'TShEquity', u'LEE', u'LEA', u'TLiabEquity']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str','actPubtime': 'str','mergedFlag': 'str','reportType': 'str','fiscalPeriod': 'str','accoutingStandards': 'str','currencyCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FdmtBSSecuGet(ticker = "", secID = "", reportType = "", endDate = "", beginDate = "", publishDateEnd = "", publishDateBegin = "", endDateRep = "", beginDateRep = "", beginYear = "", endYear = "", fiscalPeriod = "", field = "", pandas = "1"):
    """
    1、根据2007年新会计准则制定的证券业资产负债表模板，收集了2007年以来沪深上市公司定期报告中所有以此模板披露的资产负债表数据；（主要是证券业上市公司） 2、仅收集合并报表数据，包括期末和期初数据； 3、如果上市公司对外财务报表进行更正，调整，均有采集并对外展示； 4、本表中单位为人民币元； 5、每季更新。
    
    :param ticker: 股票代码，如'600369',可以是列表,ticker、secID、reportType至少选择一个
    :param secID: 证券内部编码,可通过交易代码和交易市场在DataAPI.SecIDGet获取到,如'600369.XSHG',可以是列表,ticker、secID、reportType至少选择一个
    :param reportType: 报告类型。Q1-一季度，S1-半年度，Q3-三季度，A-年度。对应DataAPI.SysCodeGet.codeTypeID=70001。,可以是列表,ticker、secID、reportType至少选择一个
    :param endDate: 会计期间截止日期，结束时间，输入格式“YYYYMMDD”,可空
    :param beginDate: 会计期间截止日期，起始时间，输入格式“YYYYMMDD”,可空
    :param publishDateEnd: 证券交易所披露的信息发布日期，结束时间，默认为当前日期，输入格式“YYYYMMDD”,可空
    :param publishDateBegin: 证券交易所披露的信息发布日期，起始时间，默认为1年前当前日期，输入格式“YYYYMMDD”,可空
    :param endDateRep: 报表会计期末，结束时间，输入格式“YYYYMMDD”,可空
    :param beginDateRep: 报表会计期末，起始时间，输入格式“YYYYMMDD”,可空
    :param beginYear: 年度，起始时间，输入格式"YYYY",可空
    :param endYear: 年度，结束时间，输入格式"YYYY",可空
    :param fiscalPeriod: 会计期间长度，3，6，9，12,可多值输入,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getFdmtBSSecu.csv?ispandas=1&') 
    requestString.append("ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&reportType=")
    if hasattr(reportType,'__iter__') and not isinstance(reportType, str):
        if len(reportType) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = reportType
            requestString.append(None)
        else:
            requestString.append(','.join(reportType))
    else:
        requestString.append(reportType)
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        publishDateEnd = publishDateEnd.strftime('%Y%m%d')
    except:
        publishDateEnd = publishDateEnd.replace('-', '')
    requestString.append("&publishDateEnd=%s"%(publishDateEnd))
    try:
        publishDateBegin = publishDateBegin.strftime('%Y%m%d')
    except:
        publishDateBegin = publishDateBegin.replace('-', '')
    requestString.append("&publishDateBegin=%s"%(publishDateBegin))
    try:
        endDateRep = endDateRep.strftime('%Y%m%d')
    except:
        endDateRep = endDateRep.replace('-', '')
    requestString.append("&endDateRep=%s"%(endDateRep))
    try:
        beginDateRep = beginDateRep.strftime('%Y%m%d')
    except:
        beginDateRep = beginDateRep.replace('-', '')
    requestString.append("&beginDateRep=%s"%(beginDateRep))
    if not isinstance(beginYear, str) and not isinstance(beginYear, unicode):
        beginYear = str(beginYear)

    requestString.append("&beginYear=%s"%(beginYear))
    if not isinstance(endYear, str) and not isinstance(endYear, unicode):
        endYear = str(endYear)

    requestString.append("&endYear=%s"%(endYear))
    requestString.append("&fiscalPeriod=")
    if hasattr(fiscalPeriod,'__iter__') and not isinstance(fiscalPeriod, str):
        if len(fiscalPeriod) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = fiscalPeriod
            requestString.append(None)
        else:
            requestString.append(','.join(fiscalPeriod))
    else:
        requestString.append(fiscalPeriod)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 153)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 153)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'publishDate', u'endDate', u'endDateRep', u'partyID', u'ticker', u'secShortName', u'exchangeCD', u'actPubtime', u'mergedFlag', u'reportType', u'fiscalPeriod', u'accoutingStandards', u'currencyCD', u'cashCEquiv', u'clientDepos', u'settProv', u'clientProv', u'loanToOthBankFi', u'tradingFA', u'intReceiv', u'purResaleFa', u'availForSaleFa', u'htmInvest', u'LTEquityInvest', u'investRealEstate', u'fixedAssets', u'intanAssets', u'transacSeatFee', u'deferTaxAssets', u'derivAssets', u'refundDepos', u'othAssets', u'AE', u'AA', u'TAssets', u'STBorr', u'pledgeBorr', u'loanFrOthBankFi', u'tradingFL', u'soldForRepurFa', u'payrollPayable', u'taxesPayable', u'intPayable', u'fundsSecTradAgen', u'fundsSecUndwAgen', u'LTBorr', u'bondPayable', u'preferredStockL', u'perpetualBondL', u'estimatedLiab', u'deferTaxLiab', u'derivLiab', u'othLiab', u'LE', u'LA', u'TLiab', u'paidInCapital', u'othEquityInstr', u'preferredStockE', u'perpetualBondE', u'capitalReser', u'treasuryShare', u'othCompreIncome', u'surplusReser', u'ordinRiskReser', u'transacRiskReser', u'retainedEarnings', u'forexDiffer', u'SEE', u'SEA', u'TEquityAttrP', u'minorityInt', u'othEffectSE', u'othEffectSA', u'TShEquity', u'TLiabEquity']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str','actPubtime': 'str','mergedFlag': 'str','reportType': 'str','fiscalPeriod': 'str','accoutingStandards': 'str','currencyCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FdmtBSInduGet(ticker = "", secID = "", reportType = "", endDateRep = "", beginDateRep = "", beginYear = "", endYear = "", fiscalPeriod = "", endDate = "", beginDate = "", publishDateEnd = "", publishDateBegin = "", field = "", pandas = "1"):
    """
     1、根据2007年新会计准则制定的一般工商业资产负债表模板，收集了2007年以来沪深上市公司定期报告中所有以此模板披露的资产负债表数据；（主要是一般工商业上市公司） 2、仅收集合并报表数据，包括期末和期初数据； 3、如果上市公司对外财务报表进行更正，调整，均有采集并对外展示； 4、本表中单位为人民币元； 5、每季更新。
    
    :param ticker: 股票代码，如'000002',可以是列表,ticker、secID、reportType至少选择一个
    :param secID: 证券内部编码,可通过交易代码和交易市场在DataAPI.SecIDGet获取到,如'000002.XSHE',可以是列表,ticker、secID、reportType至少选择一个
    :param reportType: 报告类型。Q1-一季度，S1-半年度，Q3-三季度，A-年度。对应DataAPI.SysCodeGet.codeTypeID=70001。,可以是列表,ticker、secID、reportType至少选择一个
    :param endDateRep: 报表会计期末，结束时间，输入格式“YYYYMMDD”,可空
    :param beginDateRep: 报表会计期末，起始时间，输入格式“YYYYMMDD”,可空
    :param beginYear: 年度，起始时间，输入格式"YYYY",可空
    :param endYear: 年度，结束时间，输入格式"YYYY",可空
    :param fiscalPeriod: 会计期间长度，3，6，9，12,可多值输入,可以是列表,可空
    :param endDate: 会计期间截止日期，结束时间，输入格式“YYYYMMDD”,可空
    :param beginDate: 会计期间截止日期，起始时间，输入格式“YYYYMMDD”,可空
    :param publishDateEnd: 证券交易所披露的信息发布日期，结束时间，默认为当前日期，输入格式“YYYYMMDD”,可空
    :param publishDateBegin: 证券交易所披露的信息发布日期，起始时间，默认为1年前当前日期，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getFdmtBSIndu.csv?ispandas=1&') 
    requestString.append("ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&reportType=")
    if hasattr(reportType,'__iter__') and not isinstance(reportType, str):
        if len(reportType) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = reportType
            requestString.append(None)
        else:
            requestString.append(','.join(reportType))
    else:
        requestString.append(reportType)
    try:
        endDateRep = endDateRep.strftime('%Y%m%d')
    except:
        endDateRep = endDateRep.replace('-', '')
    requestString.append("&endDateRep=%s"%(endDateRep))
    try:
        beginDateRep = beginDateRep.strftime('%Y%m%d')
    except:
        beginDateRep = beginDateRep.replace('-', '')
    requestString.append("&beginDateRep=%s"%(beginDateRep))
    if not isinstance(beginYear, str) and not isinstance(beginYear, unicode):
        beginYear = str(beginYear)

    requestString.append("&beginYear=%s"%(beginYear))
    if not isinstance(endYear, str) and not isinstance(endYear, unicode):
        endYear = str(endYear)

    requestString.append("&endYear=%s"%(endYear))
    requestString.append("&fiscalPeriod=")
    if hasattr(fiscalPeriod,'__iter__') and not isinstance(fiscalPeriod, str):
        if len(fiscalPeriod) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = fiscalPeriod
            requestString.append(None)
        else:
            requestString.append(','.join(fiscalPeriod))
    else:
        requestString.append(fiscalPeriod)
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        publishDateEnd = publishDateEnd.strftime('%Y%m%d')
    except:
        publishDateEnd = publishDateEnd.replace('-', '')
    requestString.append("&publishDateEnd=%s"%(publishDateEnd))
    try:
        publishDateBegin = publishDateBegin.strftime('%Y%m%d')
    except:
        publishDateBegin = publishDateBegin.replace('-', '')
    requestString.append("&publishDateBegin=%s"%(publishDateBegin))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 154)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 154)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'publishDate', u'endDate', u'endDateRep', u'partyID', u'ticker', u'secShortName', u'exchangeCD', u'actPubtime', u'mergedFlag', u'reportType', u'fiscalPeriod', u'accoutingStandards', u'currencyCD', u'cashCEquiv', u'settProv', u'loanToOthBankFi', u'tradingFA', u'derivAssets', u'NotesReceiv', u'AR', u'prepayment', u'premiumReceiv', u'reinsurReceiv', u'reinsurReserReceiv', u'intReceiv', u'divReceiv', u'othReceiv', u'purResaleFa', u'inventories', u'assetsHeldForSale', u'NCAWithin1Y', u'othCA', u'CAE', u'CAA', u'TCA', u'disburLA', u'availForSaleFa', u'htmInvest', u'LTReceive', u'LTEquityInvest', u'investRealEstate', u'fixedAssets', u'CIP', u'constMaterials', u'fixedAssetsDisp', u'producBiolAssets', u'oilAndGasAssets', u'intanAssets', u'RD', u'goodwill', u'LTAmorExp', u'deferTaxAssets', u'othNCA', u'NCAE', u'NCAA', u'TNCA', u'AE', u'AA', u'TAssets', u'STBorr', u'CBBorr', u'depos', u'loanFrOthBankFi', u'tradingFL', u'derivLiab', u'NotesPayable', u'AP', u'advanceReceipts', u'soldForRepurFa', u'commisPayable', u'payrollPayable', u'taxesPayable', u'intPayable', u'divPayable', u'othPayable', u'reinsurPayable', u'insurReser', u'fundsSecTradAgen', u'fundsSecUndwAgen', u'liabHeldForSale', u'NCLWithin1Y', u'accruedExp', u'othCL', u'CLE', u'CLA', u'TCL', u'LTBorr', u'bondPayable', u'preferredStockL', u'perpetualBondL', u'LTPayable', u'LTPayrollPayable', u'specificPayables', u'estimatedLiab', u'deferRevenue', u'deferTaxLiab', u'othNCL', u'NCLE', u'NCLA', u'TNCL', u'LE', u'LA', u'TLiab', u'paidInCapital', u'othEquityInstr', u'preferredStockE', u'perpetualBondE', u'capitalReser', u'treasuryShare', u'othCompreIncome', u'specialReser', u'surplusReser', u'ordinRiskReser', u'retainedEarnings', u'forexDiffer', u'SEE', u'SEA', u'TEquityAttrP', u'minorityInt', u'othEffectSE', u'othEffectSA', u'TShEquity', u'LEE', u'LEA', u'TLiabEquity']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str','actPubtime': 'str','mergedFlag': 'str','reportType': 'str','fiscalPeriod': 'str','accoutingStandards': 'str','currencyCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FdmtBSInsuGet(ticker = "", secID = "", reportType = "", endDateRep = "", beginDateRep = "", beginYear = "", endYear = "", fiscalPeriod = "", endDate = "", beginDate = "", publishDateEnd = "", publishDateBegin = "", field = "", pandas = "1"):
    """
    1、根据2007年新会计准则制定的保险业资产负债表模板，收集了2007年以来沪深上市公司定期报告中所有以此模板披露的资产负债表数据；（主要是保险业上市公司） 2、仅收集合并报表数据，包括期末和期初数据； 3、如果上市公司对外财务报表进行更正，调整，均有采集并对外展示； 4、本表中单位为人民币元。 5、每季更新。
    
    :param ticker: 股票代码，如'601318',可以是列表,ticker、secID、reportType至少选择一个
    :param secID: 证券内部编码,可通过交易代码和交易市场在DataAPI.SecIDGet获取到,如'601318.XSHG',可以是列表,ticker、secID、reportType至少选择一个
    :param reportType: 报告类型。Q1-一季度，S1-半年度，Q3-三季度，A-年度。对应DataAPI.SysCodeGet.codeTypeID=70001。,可以是列表,ticker、secID、reportType至少选择一个
    :param endDateRep: 报表会计期末，结束时间，输入格式“YYYYMMDD”,可空
    :param beginDateRep: 报表会计期末，起始时间，输入格式“YYYYMMDD”,可空
    :param beginYear: 年度，起始时间，输入格式"YYYY",可空
    :param endYear: 年度，结束时间，输入格式"YYYY",可空
    :param fiscalPeriod: 会计期间长度，3，6，9，12,可多值输入,可以是列表,可空
    :param endDate: 会计期间截止日期，结束时间，输入格式“YYYYMMDD”,可空
    :param beginDate: 会计期间截止日期，起始时间，输入格式“YYYYMMDD”,可空
    :param publishDateEnd: 证券交易所披露的信息发布日期，结束时间，默认为当前日期，输入格式“YYYYMMDD”,可空
    :param publishDateBegin: 证券交易所披露的信息发布日期，起始时间，默认为1年前当前日期，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getFdmtBSInsu.csv?ispandas=1&') 
    requestString.append("ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&reportType=")
    if hasattr(reportType,'__iter__') and not isinstance(reportType, str):
        if len(reportType) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = reportType
            requestString.append(None)
        else:
            requestString.append(','.join(reportType))
    else:
        requestString.append(reportType)
    try:
        endDateRep = endDateRep.strftime('%Y%m%d')
    except:
        endDateRep = endDateRep.replace('-', '')
    requestString.append("&endDateRep=%s"%(endDateRep))
    try:
        beginDateRep = beginDateRep.strftime('%Y%m%d')
    except:
        beginDateRep = beginDateRep.replace('-', '')
    requestString.append("&beginDateRep=%s"%(beginDateRep))
    if not isinstance(beginYear, str) and not isinstance(beginYear, unicode):
        beginYear = str(beginYear)

    requestString.append("&beginYear=%s"%(beginYear))
    if not isinstance(endYear, str) and not isinstance(endYear, unicode):
        endYear = str(endYear)

    requestString.append("&endYear=%s"%(endYear))
    requestString.append("&fiscalPeriod=")
    if hasattr(fiscalPeriod,'__iter__') and not isinstance(fiscalPeriod, str):
        if len(fiscalPeriod) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = fiscalPeriod
            requestString.append(None)
        else:
            requestString.append(','.join(fiscalPeriod))
    else:
        requestString.append(fiscalPeriod)
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        publishDateEnd = publishDateEnd.strftime('%Y%m%d')
    except:
        publishDateEnd = publishDateEnd.replace('-', '')
    requestString.append("&publishDateEnd=%s"%(publishDateEnd))
    try:
        publishDateBegin = publishDateBegin.strftime('%Y%m%d')
    except:
        publishDateBegin = publishDateBegin.replace('-', '')
    requestString.append("&publishDateBegin=%s"%(publishDateBegin))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 155)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 155)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'publishDate', u'endDate', u'endDateRep', u'partyID', u'ticker', u'secShortName', u'exchangeCD', u'actPubtime', u'mergedFlag', u'reportType', u'fiscalPeriod', u'accoutingStandards', u'currencyCD', u'cashCEquiv', u'loanToOthBankFi', u'tradingFA', u'premiumReceiv', u'reinsurReceiv', u'intReceiv', u'purResaleFa', u'availForSaleFa', u'htmInvest', u'LTEquityInvest', u'investRealEstate', u'fixedAssets', u'intanAssets', u'deferTaxAssets', u'derivAssets', u'subrogRecoReceiv', u'RRReinsUnePrem', u'RRReinsOutstdCla', u'RRReinsLinsLiab', u'RRReinsLThinsLiab', u'PHPledgeLoans', u'fixedTermDepos', u'refundCapDepos', u'indepAccAssets', u'othAssets', u'AE', u'AA', u'TAssets', u'STBorr', u'loanFrOthBankFi', u'tradingFL', u'soldForRepurFa', u'commisPayable', u'payrollPayable', u'taxesPayable', u'reinsurPayable', u'LTBorr', u'bondPayable', u'preferredStockL', u'perpetualBondL', u'deferTaxLiab', u'derivLiab', u'premReceivAdva', u'indemAccPayable', u'policyDivPayable', u'PHInvest', u'reserUnePrem', u'reserOutstdClaims', u'reserLinsLiab', u'reserLthinsLiab', u'indeptAccLiab', u'othLiab', u'LE', u'LA', u'TLiab', u'paidInCapital', u'othEquityInstr', u'preferredStockE', u'perpetualBondE', u'capitalReser', u'treasuryShare', u'othCompreIncome', u'surplusReser', u'ordinRiskReser', u'retainedEarnings', u'forexDiffer', u'SEE', u'SEA', u'TEquityAttrP', u'minorityInt', u'othEffectSE', u'othEffectSA', u'TShEquity', u'LEE', u'LEA', u'TLiabEquity']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str','actPubtime': 'str','mergedFlag': 'str','reportType': 'str','fiscalPeriod': 'str','accoutingStandards': 'str','currencyCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FdmtCFGet(ticker = "", secID = "", reportType = "", endDateRep = "", beginDateRep = "", beginYear = "", endYear = "", fiscalPeriod = "", endDate = "", beginDate = "", publishDateEnd = "", publishDateBegin = "", field = "", pandas = "1"):
    """
    1、根据2007年新会计准则制定的合并现金流量表模板，收集了2007年以来沪深上市公司定期报告中各个会计期间的现金流量表数据； 2、仅收集合并报表数据，包括本期和上期数据； 3、如果上市公司对外财务报表进行更正，调整，均有采集并对外展示； 4、本表中单位为人民币元； 5、每季更新。
    
    :param ticker: 股票代码，如'000002',可以是列表,ticker、secID、reportType至少选择一个
    :param secID: 证券内部编码,可通过交易代码和交易市场在DataAPI.SecIDGet获取到,如'000002.XSHE',可以是列表,ticker、secID、reportType至少选择一个
    :param reportType: 报告类型。Q1-第一季报，S1-半年报，Q3-第三季报，CQ3-三季报（累计1-9月），A-年报。对应DataAPI.SysCodeGet.codeTypeID=70001。,可以是列表,ticker、secID、reportType至少选择一个
    :param endDateRep: 报表会计期末，结束时间，输入格式“YYYYMMDD”,可空
    :param beginDateRep: 报表会计期末，起始时间，输入格式“YYYYMMDD”,可空
    :param beginYear: 年度，起始时间，输入格式"YYYY",可空
    :param endYear: 年度，结束时间，输入格式"YYYY",可空
    :param fiscalPeriod: 会计期间长度，3，6，9，12,可多值输入,可以是列表,可空
    :param endDate: 会计期间截止日期，结束时间，输入格式“YYYYMMDD”,可空
    :param beginDate: 会计期间截止日期，起始时间，输入格式“YYYYMMDD”,可空
    :param publishDateEnd: 证券交易所披露的信息发布日期，结束时间，默认为当前日期，输入格式“YYYYMMDD”,可空
    :param publishDateBegin: 证券交易所披露的信息发布日期，起始时间，默认为1年前当前日期，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getFdmtCF.csv?ispandas=1&') 
    requestString.append("ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&reportType=")
    if hasattr(reportType,'__iter__') and not isinstance(reportType, str):
        if len(reportType) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = reportType
            requestString.append(None)
        else:
            requestString.append(','.join(reportType))
    else:
        requestString.append(reportType)
    try:
        endDateRep = endDateRep.strftime('%Y%m%d')
    except:
        endDateRep = endDateRep.replace('-', '')
    requestString.append("&endDateRep=%s"%(endDateRep))
    try:
        beginDateRep = beginDateRep.strftime('%Y%m%d')
    except:
        beginDateRep = beginDateRep.replace('-', '')
    requestString.append("&beginDateRep=%s"%(beginDateRep))
    if not isinstance(beginYear, str) and not isinstance(beginYear, unicode):
        beginYear = str(beginYear)

    requestString.append("&beginYear=%s"%(beginYear))
    if not isinstance(endYear, str) and not isinstance(endYear, unicode):
        endYear = str(endYear)

    requestString.append("&endYear=%s"%(endYear))
    requestString.append("&fiscalPeriod=")
    if hasattr(fiscalPeriod,'__iter__') and not isinstance(fiscalPeriod, str):
        if len(fiscalPeriod) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = fiscalPeriod
            requestString.append(None)
        else:
            requestString.append(','.join(fiscalPeriod))
    else:
        requestString.append(fiscalPeriod)
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        publishDateEnd = publishDateEnd.strftime('%Y%m%d')
    except:
        publishDateEnd = publishDateEnd.replace('-', '')
    requestString.append("&publishDateEnd=%s"%(publishDateEnd))
    try:
        publishDateBegin = publishDateBegin.strftime('%Y%m%d')
    except:
        publishDateBegin = publishDateBegin.replace('-', '')
    requestString.append("&publishDateBegin=%s"%(publishDateBegin))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 156)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 156)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'publishDate', u'endDate', u'endDateRep', u'partyID', u'ticker', u'secShortName', u'exchangeCD', u'actPubtime', u'mergedFlag', u'reportType', u'fiscalPeriod', u'accoutingStandards', u'currencyCD', u'CFrSaleGS', u'NDeposIncrCFI', u'NIncrBorrFrCB', u'NIncBorrOthFI', u'premFrOrigContr', u'NReinsurPrem', u'NIncPhDeposInv', u'NIncDispTradFA', u'IFCCashIncr', u'NIncFrBorr', u'NCApIncrRepur', u'refundOfTax', u'CFrOthOperateA', u'CInfFrOperateA', u'CPaidGS', u'NIncDisburOfLA', u'NIncrDeposInFI', u'origContrCIndem', u'CPaidIFC', u'CPaidPolDiv', u'CPaidToForEmpl', u'CPaidForTaxes', u'CPaidForOthOpA', u'COutfOperateA', u'NCFOperateA', u'procSellInvest', u'gainInvest', u'dispFixAssetsOth', u'NDispSubsOthBizC', u'CFrOthInvestA', u'CInfFrInvestA', u'purFixAssetsOth', u'CPaidInvest', u'NIncrPledgeLoan', u'NCPaidAcquis', u'CPaidOthInvestA', u'COutfFrInvestA', u'NCFFrInvestA', u'CFrCapContr', u'CFrMinoSSubs', u'CFrBorr', u'CFrIssueBond', u'CFrOthFinanA', u'CInfFrFinanA', u'CPaidForDebts', u'CPaidDivProfInt', u'divProfSubsMinoS', u'CPaidOthFinanA', u'COutfFrFinanA', u'NCFFrFinanA', u'forexEffects', u'NChangeInCash', u'NCEBegBal', u'NCEEndBal']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str','actPubtime': 'str','mergedFlag': 'str','reportType': 'str','fiscalPeriod': 'str','accoutingStandards': 'str','currencyCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FdmtCFBankGet(ticker = "", secID = "", reportType = "", endDateRep = "", beginDateRep = "", beginYear = "", endYear = "", fiscalPeriod = "", endDate = "", beginDate = "", publishDateEnd = "", publishDateBegin = "", field = "", pandas = "1"):
    """
    1、根据2007年新会计准则制定的银行业现金流量表模板，收集了2007年以来沪深上市公司定期报告中所有以此模板披露的现金流量表数据；（主要是银行业上市公司） 2、仅收集合并报表数据，包括本期和上期数据； 3、如果上市公司对外财务报表进行更正，调整，均有采集并对外展示； 4、本表中单位为人民币元；5、每季更新。
    
    :param ticker: 股票代码，如'000001',可以是列表,ticker、secID、reportType至少选择一个
    :param secID: 证券内部编码,可通过交易代码和交易市场在DataAPI.SecIDGet获取到,如'000001.XSHE',可以是列表,ticker、secID、reportType至少选择一个
    :param reportType: 报告类型。Q1-第一季报，S1-半年报，Q3-第三季报，CQ3-三季报（累计1-9月），A-年报。对应DataAPI.SysCodeGet.codeTypeID=70001。,可以是列表,ticker、secID、reportType至少选择一个
    :param endDateRep: 报表会计期末，结束时间，输入格式“YYYYMMDD”,可空
    :param beginDateRep: 报表会计期末，起始时间，输入格式“YYYYMMDD”,可空
    :param beginYear: 年度，起始时间，输入格式"YYYY",可空
    :param endYear: 年度，结束时间，输入格式"YYYY",可空
    :param fiscalPeriod: 会计期间长度，3，6，9，12,可多值输入,可以是列表,可空
    :param endDate: 会计期间截止日期，结束时间，输入格式“YYYYMMDD”,可空
    :param beginDate: 会计期间截止日期，起始时间，输入格式“YYYYMMDD”,可空
    :param publishDateEnd: 证券交易所披露的信息发布日期，结束时间，默认为当前日期，输入格式“YYYYMMDD”,可空
    :param publishDateBegin: 证券交易所披露的信息发布日期，起始时间，默认为1年前当前日期，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getFdmtCFBank.csv?ispandas=1&') 
    requestString.append("ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&reportType=")
    if hasattr(reportType,'__iter__') and not isinstance(reportType, str):
        if len(reportType) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = reportType
            requestString.append(None)
        else:
            requestString.append(','.join(reportType))
    else:
        requestString.append(reportType)
    try:
        endDateRep = endDateRep.strftime('%Y%m%d')
    except:
        endDateRep = endDateRep.replace('-', '')
    requestString.append("&endDateRep=%s"%(endDateRep))
    try:
        beginDateRep = beginDateRep.strftime('%Y%m%d')
    except:
        beginDateRep = beginDateRep.replace('-', '')
    requestString.append("&beginDateRep=%s"%(beginDateRep))
    if not isinstance(beginYear, str) and not isinstance(beginYear, unicode):
        beginYear = str(beginYear)

    requestString.append("&beginYear=%s"%(beginYear))
    if not isinstance(endYear, str) and not isinstance(endYear, unicode):
        endYear = str(endYear)

    requestString.append("&endYear=%s"%(endYear))
    requestString.append("&fiscalPeriod=")
    if hasattr(fiscalPeriod,'__iter__') and not isinstance(fiscalPeriod, str):
        if len(fiscalPeriod) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = fiscalPeriod
            requestString.append(None)
        else:
            requestString.append(','.join(fiscalPeriod))
    else:
        requestString.append(fiscalPeriod)
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        publishDateEnd = publishDateEnd.strftime('%Y%m%d')
    except:
        publishDateEnd = publishDateEnd.replace('-', '')
    requestString.append("&publishDateEnd=%s"%(publishDateEnd))
    try:
        publishDateBegin = publishDateBegin.strftime('%Y%m%d')
    except:
        publishDateBegin = publishDateBegin.replace('-', '')
    requestString.append("&publishDateBegin=%s"%(publishDateBegin))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 157)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 157)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'publishDate', u'endDate', u'endDateRep', u'partyID', u'ticker', u'secShortName', u'exchangeCD', u'actPubtime', u'mergedFlag', u'reportType', u'fiscalPeriod', u'accoutingStandards', u'currencyCD', u'NDeposIncrCFI', u'NIncrBorrFrCB', u'NIncBorrOthFI', u'NDecrInDisburOfLa', u'NDecrInDeposInFI', u'NDecrLoanToOthFI', u'IFCCashIncr', u'CFrOthOperateA', u'specOCIF', u'AOCIF', u'CInfFrOperateA', u'NDeposDecrFrFI', u'NDecrBorrFrCB', u'NDecrBorrFrOthFI', u'NIncDisburOfLA', u'NIncrDeposInFI', u'NIncrLoansToOthFi', u'CPaidIFC', u'CPaidToForEmpl', u'CPaidForTaxes', u'CPaidForOthOpA', u'specOCOF', u'AOCOF', u'COutfOperateA', u'ANOCF', u'NCFOperateA', u'procSellInvest', u'gainInvest', u'dispFixAssetsOth', u'NDispSubsOthBizC', u'CFrOthInvestA', u'specICIF', u'AICIF', u'CInfFrInvestA', u'purFixAssetsOth', u'CPaidInvest', u'NCPaidAcquis', u'CPaidOthInvestA', u'specICOF', u'AICOF', u'COutfFrInvestA', u'ANICF', u'NCFFrInvestA', u'CFrCapContr', u'CFrMinoSSubs', u'CFrIssueBond', u'CFrOthFinanA', u'specFCIF', u'AFCIF', u'CInfFrFinanA', u'CPaidForDebts', u'CPaidDivProfInt', u'divProfSubsMinoS', u'CPaidOthFinanA', u'specFCOF', u'AFCOF', u'COutfFrFinanA', u'ANFCF', u'NCFFrFinanA', u'forexEffects', u'othEffectCE', u'ACE', u'NChangeInCash', u'NCEBegBal', u'othEffectCEI', u'ACEI', u'NCEEndBal']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str','actPubtime': 'str','mergedFlag': 'str','reportType': 'str','fiscalPeriod': 'str','accoutingStandards': 'str','currencyCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FdmtCFSecuGet(ticker = "", secID = "", reportType = "", endDateRep = "", beginDateRep = "", beginYear = "", endYear = "", fiscalPeriod = "", endDate = "", beginDate = "", publishDateEnd = "", publishDateBegin = "", field = "", pandas = "1"):
    """
    1、根据2007年新会计准则制定的证券业现金流量表模板，收集了2007年以来沪深上市公司定期报告中所有以此模板披露的现金流量表数据；（主要是证券业上市公司） 2、仅收集合并报表数据，包括本期和上期数据； 3、如果上市公司对外财务报表进行更正，调整，均有采集并对外展示； 4、本表中单位为人民币元；5、每季更新。
    
    :param ticker: 股票代码，如'600369',可以是列表,ticker、secID、reportType至少选择一个
    :param secID: 证券内部编码,可通过交易代码和交易市场在DataAPI.SecIDGet获取到,如'600369.XSHG ',可以是列表,ticker、secID、reportType至少选择一个
    :param reportType: 报告类型。Q1-第一季报，S1-半年报，Q3-第三季报，CQ3-三季报（累计1-9月），A-年报。对应DataAPI.SysCodeGet.codeTypeID=70001。,可以是列表,ticker、secID、reportType至少选择一个
    :param endDateRep: 报表会计期末，结束时间，输入格式“YYYYMMDD”,可空
    :param beginDateRep: 报表会计期末，起始时间，输入格式“YYYYMMDD”,可空
    :param beginYear: 年度，起始时间，输入格式"YYYY",可空
    :param endYear: 年度，结束时间，输入格式"YYYY",可空
    :param fiscalPeriod: 会计期间长度，3，6，9，12,可多值输入,可以是列表,可空
    :param endDate: 会计期间截止日期，结束时间，输入格式“YYYYMMDD”,可空
    :param beginDate: 会计期间截止日期，起始时间，输入格式“YYYYMMDD”,可空
    :param publishDateEnd: 证券交易所披露的信息发布日期，结束时间，默认为当前日期，输入格式“YYYYMMDD”,可空
    :param publishDateBegin: 证券交易所披露的信息发布日期，起始时间，默认为1年前当前日期，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getFdmtCFSecu.csv?ispandas=1&') 
    requestString.append("ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&reportType=")
    if hasattr(reportType,'__iter__') and not isinstance(reportType, str):
        if len(reportType) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = reportType
            requestString.append(None)
        else:
            requestString.append(','.join(reportType))
    else:
        requestString.append(reportType)
    try:
        endDateRep = endDateRep.strftime('%Y%m%d')
    except:
        endDateRep = endDateRep.replace('-', '')
    requestString.append("&endDateRep=%s"%(endDateRep))
    try:
        beginDateRep = beginDateRep.strftime('%Y%m%d')
    except:
        beginDateRep = beginDateRep.replace('-', '')
    requestString.append("&beginDateRep=%s"%(beginDateRep))
    if not isinstance(beginYear, str) and not isinstance(beginYear, unicode):
        beginYear = str(beginYear)

    requestString.append("&beginYear=%s"%(beginYear))
    if not isinstance(endYear, str) and not isinstance(endYear, unicode):
        endYear = str(endYear)

    requestString.append("&endYear=%s"%(endYear))
    requestString.append("&fiscalPeriod=")
    if hasattr(fiscalPeriod,'__iter__') and not isinstance(fiscalPeriod, str):
        if len(fiscalPeriod) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = fiscalPeriod
            requestString.append(None)
        else:
            requestString.append(','.join(fiscalPeriod))
    else:
        requestString.append(fiscalPeriod)
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        publishDateEnd = publishDateEnd.strftime('%Y%m%d')
    except:
        publishDateEnd = publishDateEnd.replace('-', '')
    requestString.append("&publishDateEnd=%s"%(publishDateEnd))
    try:
        publishDateBegin = publishDateBegin.strftime('%Y%m%d')
    except:
        publishDateBegin = publishDateBegin.replace('-', '')
    requestString.append("&publishDateBegin=%s"%(publishDateBegin))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 158)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 158)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'publishDate', u'endDate', u'endDateRep', u'partyID', u'ticker', u'secShortName', u'exchangeCD', u'actPubtime', u'mergedFlag', u'reportType', u'fiscalPeriod', u'accoutingStandards', u'currencyCD', u'NIncBorrOthFI', u'NIncDispTradFA', u'NIncDispFaFS', u'IFCCashIncr', u'NIncFrBorr', u'NCApIncrRepur', u'refundOfTax', u'CFrOthOperateA', u'specOCIF', u'AOCIF', u'CInfFrOperateA', u'CPaidIFC', u'CPaidToForEmpl', u'CPaidForTaxes', u'CPaidForOthOpA', u'specOCOF', u'AOCOF', u'COutfOperateA', u'ANOCF', u'NCFOperateA', u'procSellInvest', u'gainInvest', u'dispFixAssetsOth', u'NDispSubsOthBizC', u'CFrOthInvestA', u'specICIF', u'AICIF', u'CInfFrInvestA', u'purFixAssetsOth', u'CPaidInvest', u'NCPaidAcquis', u'CPaidOthInvestA', u'specICOF', u'AICOF', u'COutfFrInvestA', u'ANICF', u'NCFFrInvestA', u'CFrCapContr', u'CFrMinoSSubs', u'CFrBorr', u'CFrIssueBond', u'CFrOthFinanA', u'specFCIF', u'AFCIF', u'CInfFrFinanA', u'CPaidForDebts', u'CPaidDivProfInt', u'divProfSubsMinoS', u'CPaidOthFinanA', u'specFCOF', u'AFCOF', u'COutfFrFinanA', u'ANFCF', u'NCFFrFinanA', u'forexEffects', u'othEffectCE', u'ACE', u'NChangeInCash', u'NCEBegBal', u'othEffectCEI', u'ACEI', u'NCEEndBal']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str','actPubtime': 'str','mergedFlag': 'str','reportType': 'str','fiscalPeriod': 'str','accoutingStandards': 'str','currencyCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FdmtCFInduGet(ticker = "", secID = "", reportType = "", endDateRep = "", beginDateRep = "", beginYear = "", endYear = "", fiscalPeriod = "", endDate = "", beginDate = "", publishDateEnd = "", publishDateBegin = "", field = "", pandas = "1"):
    """
    1、根据2007年新会计准则制定的一般工商业现金流量表模板，收集了2007年以来沪深上市公司定期报告中所有以此模板披露的现金流量表数据；（主要是一般工商业上市公司） 2、仅收集合并报表数据，包括本期和上期数据； 3、如果上市公司对外财务报表进行更正，调整，均有采集并对外展示； 4、本表中单位为人民币元； 5、每季更新。
    
    :param ticker: 股票代码，如'000002',可以是列表,ticker、secID、reportType至少选择一个
    :param secID: 证券内部编码,可通过交易代码和交易市场在DataAPI.SecIDGet获取到,如'000002.XSHE',可以是列表,ticker、secID、reportType至少选择一个
    :param reportType: 报告类型。Q1-第一季报，S1-半年报，Q3-第三季报，CQ3-三季报（累计1-9月），A-年报。对应DataAPI.SysCodeGet.codeTypeID=70001。,可以是列表,ticker、secID、reportType至少选择一个
    :param endDateRep: 报表会计期末，结束时间，输入格式“YYYYMMDD”,可空
    :param beginDateRep: 报表会计期末，起始时间，输入格式“YYYYMMDD”,可空
    :param beginYear: 年度，起始时间，输入格式"YYYY",可空
    :param endYear: 年度，结束时间，输入格式"YYYY",可空
    :param fiscalPeriod: 会计期间长度，3，6，9，12,可多值输入,可以是列表,可空
    :param endDate: 会计期间截止日期，结束时间，输入格式“YYYYMMDD”,可空
    :param beginDate: 会计期间截止日期，起始时间，输入格式“YYYYMMDD”,可空
    :param publishDateEnd: 证券交易所披露的信息发布日期，结束时间，默认为当前日期，输入格式“YYYYMMDD”,可空
    :param publishDateBegin: 证券交易所披露的信息发布日期，起始时间，默认为1年前当前日期，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getFdmtCFIndu.csv?ispandas=1&') 
    requestString.append("ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&reportType=")
    if hasattr(reportType,'__iter__') and not isinstance(reportType, str):
        if len(reportType) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = reportType
            requestString.append(None)
        else:
            requestString.append(','.join(reportType))
    else:
        requestString.append(reportType)
    try:
        endDateRep = endDateRep.strftime('%Y%m%d')
    except:
        endDateRep = endDateRep.replace('-', '')
    requestString.append("&endDateRep=%s"%(endDateRep))
    try:
        beginDateRep = beginDateRep.strftime('%Y%m%d')
    except:
        beginDateRep = beginDateRep.replace('-', '')
    requestString.append("&beginDateRep=%s"%(beginDateRep))
    if not isinstance(beginYear, str) and not isinstance(beginYear, unicode):
        beginYear = str(beginYear)

    requestString.append("&beginYear=%s"%(beginYear))
    if not isinstance(endYear, str) and not isinstance(endYear, unicode):
        endYear = str(endYear)

    requestString.append("&endYear=%s"%(endYear))
    requestString.append("&fiscalPeriod=")
    if hasattr(fiscalPeriod,'__iter__') and not isinstance(fiscalPeriod, str):
        if len(fiscalPeriod) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = fiscalPeriod
            requestString.append(None)
        else:
            requestString.append(','.join(fiscalPeriod))
    else:
        requestString.append(fiscalPeriod)
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        publishDateEnd = publishDateEnd.strftime('%Y%m%d')
    except:
        publishDateEnd = publishDateEnd.replace('-', '')
    requestString.append("&publishDateEnd=%s"%(publishDateEnd))
    try:
        publishDateBegin = publishDateBegin.strftime('%Y%m%d')
    except:
        publishDateBegin = publishDateBegin.replace('-', '')
    requestString.append("&publishDateBegin=%s"%(publishDateBegin))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 159)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 159)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'publishDate', u'endDate', u'endDateRep', u'partyID', u'ticker', u'secShortName', u'exchangeCD', u'actPubtime', u'mergedFlag', u'reportType', u'fiscalPeriod', u'accoutingStandards', u'currencyCD', u'CFrSaleGS', u'NDeposIncrCFI', u'NIncrBorrFrCB', u'NIncBorrOthFI', u'premFrOrigContr', u'NReinsurPrem', u'NIncPhDeposInv', u'NIncDispTradFA', u'IFCCashIncr', u'NIncFrBorr', u'NCApIncrRepur', u'refundOfTax', u'CFrOthOperateA', u'specOCIF', u'AOCIF', u'CInfFrOperateA', u'CPaidGS', u'NIncDisburOfLA', u'NIncrDeposInFI', u'origContrCIndem', u'CPaidIFC', u'CPaidPolDiv', u'CPaidToForEmpl', u'CPaidForTaxes', u'CPaidForOthOpA', u'specOCOF', u'AOCOF', u'COutfOperateA', u'ANOCF', u'NCFOperateA', u'procSellInvest', u'gainInvest', u'dispFixAssetsOth', u'NDispSubsOthBizC', u'CFrOthInvestA', u'specICIF', u'AICIF', u'CInfFrInvestA', u'purFixAssetsOth', u'CPaidInvest', u'NIncrPledgeLoan', u'NCPaidAcquis', u'CPaidOthInvestA', u'specICOF', u'AICOF', u'COutfFrInvestA', u'ANICF', u'NCFFrInvestA', u'CFrCapContr', u'CFrMinoSSubs', u'CFrBorr', u'CFrIssueBond', u'CFrOthFinanA', u'specFCIF', u'AFCIF', u'CInfFrFinanA', u'CPaidForDebts', u'CPaidDivProfInt', u'divProfSubsMinoS', u'CPaidOthFinanA', u'specFCOF', u'AFCOF', u'COutfFrFinanA', u'ANFCF', u'NCFFrFinanA', u'forexEffects', u'othEffectCE', u'ACE', u'NChangeInCash', u'NCEBegBal', u'othEffectCEI', u'ACEI', u'NCEEndBal']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str','actPubtime': 'str','mergedFlag': 'str','reportType': 'str','fiscalPeriod': 'str','accoutingStandards': 'str','currencyCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FdmtCFInsuGet(ticker = "", secID = "", reportType = "", endDate = "", beginDate = "", publishDateEnd = "", publishDateBegin = "", endDateRep = "", beginDateRep = "", beginYear = "", endYear = "", fiscalPeriod = "", field = "", pandas = "1"):
    """
    1、根据2007年新会计准则制定的保险业现金流量表模板，收集了2007年以来沪深上市公司定期报告中所有以此模板披露的现金流量表数据；（主要是保险业上市公司） 2、仅收集合并报表数据，包括本期和上期数据； 3、如果上市公司对外财务报表进行更正，调整，均有采集并对外展示； 4、本表中单位为人民币元； 5、每季更新。
    
    :param ticker: 股票代码，如'601318',可以是列表,ticker、secID、reportType至少选择一个
    :param secID: 证券内部编码,可通过交易代码和交易市场在DataAPI.SecIDGet获取到,如'601318.XSHG',可以是列表,ticker、secID、reportType至少选择一个
    :param reportType: 报告类型。Q1-第一季报，S1-半年报，Q3-第三季报，CQ3-三季报（累计1-9月），A-年报。对应DataAPI.SysCodeGet.codeTypeID=70001。,可以是列表,ticker、secID、reportType至少选择一个
    :param endDate: 会计期间截止日期，结束时间，输入格式“YYYYMMDD”,可空
    :param beginDate: 会计期间截止日期，起始时间，输入格式“YYYYMMDD”,可空
    :param publishDateEnd: 证券交易所披露的信息发布日期，结束时间，默认为当前日期，输入格式“YYYYMMDD”,可空
    :param publishDateBegin: 证券交易所披露的信息发布日期，起始时间，默认为1年前当前日期，输入格式“YYYYMMDD”,可空
    :param endDateRep: 报表会计期末，结束时间，输入格式“YYYYMMDD”,可空
    :param beginDateRep: 报表会计期末，起始时间，输入格式“YYYYMMDD”,可空
    :param beginYear: 年度，起始时间，输入格式"YYYY",可空
    :param endYear: 年度，结束时间，输入格式"YYYY",可空
    :param fiscalPeriod: 会计期间长度，3，6，9，12,可多值输入,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getFdmtCFInsu.csv?ispandas=1&') 
    requestString.append("ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&reportType=")
    if hasattr(reportType,'__iter__') and not isinstance(reportType, str):
        if len(reportType) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = reportType
            requestString.append(None)
        else:
            requestString.append(','.join(reportType))
    else:
        requestString.append(reportType)
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        publishDateEnd = publishDateEnd.strftime('%Y%m%d')
    except:
        publishDateEnd = publishDateEnd.replace('-', '')
    requestString.append("&publishDateEnd=%s"%(publishDateEnd))
    try:
        publishDateBegin = publishDateBegin.strftime('%Y%m%d')
    except:
        publishDateBegin = publishDateBegin.replace('-', '')
    requestString.append("&publishDateBegin=%s"%(publishDateBegin))
    try:
        endDateRep = endDateRep.strftime('%Y%m%d')
    except:
        endDateRep = endDateRep.replace('-', '')
    requestString.append("&endDateRep=%s"%(endDateRep))
    try:
        beginDateRep = beginDateRep.strftime('%Y%m%d')
    except:
        beginDateRep = beginDateRep.replace('-', '')
    requestString.append("&beginDateRep=%s"%(beginDateRep))
    if not isinstance(beginYear, str) and not isinstance(beginYear, unicode):
        beginYear = str(beginYear)

    requestString.append("&beginYear=%s"%(beginYear))
    if not isinstance(endYear, str) and not isinstance(endYear, unicode):
        endYear = str(endYear)

    requestString.append("&endYear=%s"%(endYear))
    requestString.append("&fiscalPeriod=")
    if hasattr(fiscalPeriod,'__iter__') and not isinstance(fiscalPeriod, str):
        if len(fiscalPeriod) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = fiscalPeriod
            requestString.append(None)
        else:
            requestString.append(','.join(fiscalPeriod))
    else:
        requestString.append(fiscalPeriod)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 160)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=False)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 160)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'publishDate', u'endDate', u'endDateRep', u'partyID', u'ticker', u'secShortName', u'exchangeCD', u'actPubtime', u'mergedFlag', u'reportType', u'fiscalPeriod', u'accoutingStandards', u'currencyCD', u'NDeposIncrCFI', u'NIncrBorrFrCB', u'premFrOrigContr', u'NReinsurPrem', u'NIncPhDeposInv', u'IFCCashIncr', u'refundOfTax', u'CFrOthOperateA', u'specOCIF', u'AOCIF', u'CInfFrOperateA', u'NIncDisburOfLA', u'NIncrDeposInFI', u'origContrCIndem', u'CPaidIFC', u'CPaidPolDiv', u'CPaidToForEmpl', u'CPaidForTaxes', u'CPaidForOthOpA', u'specOCOF', u'AOCOF', u'COutfOperateA', u'ANOCF', u'NCFOperateA', u'procSellInvest', u'gainInvest', u'dispFixAssetsOth', u'NDispSubsOthBizC', u'CFrOthInvestA', u'specICIF', u'AICIF', u'CInfFrInvestA', u'PurFixAssetsOth', u'CPaidInvest', u'NIncrPledgeLoan', u'NCPaidAcquis', u'CPaidOthInvestA', u'specICOF', u'AICOF', u'COutfFrInvestA', u'ANICF', u'NCFFrInvestA', u'CFrCapContr', u'CFrMinoSSubs', u'CFrBorr', u'CFrIssueBond', u'CFrOthFinanA', u'specFCIF', u'AFCIF', u'CInfFrFinanA', u'CPaidForDebts', u'CPaidDivProfInt', u'divProfSubsMinoS', u'CPaidOthFinanA', u'specFCOF', u'AFCOF', u'COutfFrFinanA', u'ANFCF', u'NCFFrFinanA', u'forexEffects', u'othEffectCE', u'ACE', u'NChangeInCash', u'NCEBegBal', u'othEffectCEI', u'ACEI', u'NCEEndBal']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str','actPubtime': 'str','mergedFlag': 'str','reportType': 'str','fiscalPeriod': 'str','accoutingStandards': 'str','currencyCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FdmtISGet(ticker = "", secID = "", reportType = "", endDate = "", beginDate = "", publishDateEnd = "", publishDateBegin = "", endDateRep = "", beginDateRep = "", beginYear = "", endYear = "", fiscalPeriod = "", field = "", pandas = "1"):
    """
    1、根据2007年新会计准则制定的合并利润表模板，收集了2007年以来沪深上市公司定期报告中各个会计期间的利润表数据； 2、仅收集合并报表数据，包括本期和上期数据； 3、如果上市公司对外财务报表进行更正，调整，均有采集并对外展示； 4、本表中单位为人民币元； 5、每季更新。
    
    :param ticker: 股票代码，如'000002',可以是列表,ticker、secID、reportType至少选择一个
    :param secID: 证券内部编码,可通过交易代码和交易市场在DataAPI.SecIDGet获取到,如'000002.XSHE',可以是列表,ticker、secID、reportType至少选择一个
    :param reportType: 报告类型。Q1-第一季报，S1-半年报，Q3-第三季报，CQ3-三季报（累计1-9月），A-年报。对应DataAPI.SysCodeGet.codeTypeID=70001。,可以是列表,ticker、secID、reportType至少选择一个
    :param endDate: 会计期间截止日期，结束时间，输入格式“YYYYMMDD”,可空
    :param beginDate: 会计期间截止日期，起始时间，输入格式“YYYYMMDD”,可空
    :param publishDateEnd: 证券交易所披露的信息发布日期，结束时间，默认为当前日期，输入格式“YYYYMMDD”,可空
    :param publishDateBegin: 证券交易所披露的信息发布日期，起始时间，默认为1年前当前日期，输入格式“YYYYMMDD”,可空
    :param endDateRep: 报表会计期末，结束时间，输入格式“YYYYMMDD”,可空
    :param beginDateRep: 报表会计期末，起始时间，输入格式“YYYYMMDD”,可空
    :param beginYear: 年度，起始时间，输入格式"YYYY",可空
    :param endYear: 年度，结束时间，输入格式"YYYY",可空
    :param fiscalPeriod: 会计期间长度，3，6，9，12,可多值输入,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, c