# -*- coding: UTF-8 -*-
from . import api_base
try:
    from StringIO import StringIO
except:
    from io import StringIO
import pandas as pd
import sys
from datetime import datetime
from .api_base import get_cache_key, get_data_from_cache, put_data_in_cache, pretty_traceback
import inspect
try:
    unicode
except:
    unicode = str

__doc__="恒生聚源"
def EquJYGet(secID = "", ticker = "", exchangeCD = "", equTypeCD = "", listStatusCD = "", listSectorCD = "", field = "", pandas = "1"):
    """
    获取股票的基本信息，包含股票交易代码及其简称、股票类型、上市状态、上市板块、上市日期等；上市状态为最新数据，不显示历史变动信息。
    
    :param secID: 一只或多只证券代码，用,分隔，格式是“数字.交易所代码”，如000001.XSHE。如果为空，则为全部证券。,可以是列表,secID、ticker、exchangeCD至少选择一个
    :param ticker: 一只或多只股票代码，用,分隔，如000001,000002。,可以是列表,secID、ticker、exchangeCD至少选择一个
    :param exchangeCD: 交易市场。例如，XSHG-上海证券交易所；XSHE-深圳证券交易所。对应DataAPI.SysCodeGet.codeTypeID=10002。,可以是列表,secID、ticker、exchangeCD至少选择一个
    :param equTypeCD: 股票类别。例如，0201010201-A股；0201010202-B股。对应DataAPI.SysCodeGet.codeTypeID=20010。,可以是列表,可空
    :param listStatusCD: 上市状态。L-上市；S-暂停；DE-终止上市；UN-未上市。对应DataAPI.SysCodeGet.codeTypeID=10005。,可以是列表,可空
    :param listSectorCD: 上市板块。例如，1-主板；2-创业板；3-中小板。对应DataAPI.SysCodeGet.codeTypeID=10016。,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/listedCorp/getEquJY.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&exchangeCD=")
    if hasattr(exchangeCD,'__iter__') and not isinstance(exchangeCD, str):
        if len(exchangeCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = exchangeCD
            requestString.append(None)
        else:
            requestString.append(','.join(exchangeCD))
    else:
        requestString.append(exchangeCD)
    requestString.append("&equTypeCD=")
    if hasattr(equTypeCD,'__iter__') and not isinstance(equTypeCD, str):
        if len(equTypeCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = equTypeCD
            requestString.append(None)
        else:
            requestString.append(','.join(equTypeCD))
    else:
        requestString.append(equTypeCD)
    requestString.append("&listStatusCD=")
    if hasattr(listStatusCD,'__iter__') and not isinstance(listStatusCD, str):
        if len(listStatusCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = listStatusCD
            requestString.append(None)
        else:
            requestString.append(','.join(listStatusCD))
    else:
        requestString.append(listStatusCD)
    requestString.append("&listSectorCD=")
    if hasattr(listSectorCD,'__iter__') and not isinstance(listSectorCD, str):
        if len(listSectorCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = listSectorCD
            requestString.append(None)
        else:
            requestString.append(','.join(listSectorCD))
    else:
        requestString.append(listSectorCD)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1127)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1127)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'exchangeCD', u'equTypeCD', u'listSectorCD', u'cnSpell', u'secShortName', u'secShortNameEn', u'secFullName', u'secFullNameEn', u'partyID', u'listDate', u'listStatusCD']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','exchangeCD': 'str','equTypeCD': 'str','listSectorCD': 'str','cnSpell': 'str','secShortName': 'str','secShortNameEn': 'str','secFullName': 'str','secFullNameEn': 'str','listStatusCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def EquIPOaJYGet(secID = "", ticker = "", exchangeCD = "", eventProcessCD = "", listDateStart = "", listDateEnd = "", field = "", pandas = "1"):
    """
    获取A股首次公开发行上市的基本信息，包含股票首次公开发行的进程及发行结果。
    
    :param secID: 一只证券代码,格式是“数字.交易所代码”，如000001.XSHE。,secID、ticker、exchangeCD至少选择一个
    :param ticker: 一只股票代码，如000001。,secID、ticker、exchangeCD至少选择一个
    :param exchangeCD: 交易市场。例如，XSHG-上海证券交易所；XSHE-深圳证券交易所。对应DataAPI.SysCodeGet.codeTypeID=10002。,可以是列表,secID、ticker、exchangeCD至少选择一个
    :param eventProcessCD: 事件进程。例如，9-上市；10-撤销上市。对应DataAPI.SysCodeGet.codeTypeID=20001。,可以是列表,可空
    :param listDateStart: 该期间所有的IPO股票上市日期，输入格式“YYYYMMDD”，如输入起始日期"20130101"，截止日期"20131231"，可以查询到2013年期间所有IPO的基本信息。,可空
    :param listDateEnd: 该期间所有的IPO股票上市日期，输入格式“YYYYMMDD”，如输入起始日期"20130101"，截止日期"20131231"，可以查询到2013年期间所有IPO的基本信息。,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/listedCorp/getEquIPOaJY.csv?ispandas=1&') 
    if not isinstance(secID, str) and not isinstance(secID, unicode):
        secID = str(secID)

    requestString.append("secID=%s"%(secID))
    if not isinstance(ticker, str) and not isinstance(ticker, unicode):
        ticker = str(ticker)

    requestString.append("&ticker=%s"%(ticker))
    requestString.append("&exchangeCD=")
    if hasattr(exchangeCD,'__iter__') and not isinstance(exchangeCD, str):
        if len(exchangeCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = exchangeCD
            requestString.append(None)
        else:
            requestString.append(','.join(exchangeCD))
    else:
        requestString.append(exchangeCD)
    requestString.append("&eventProcessCD=")
    if hasattr(eventProcessCD,'__iter__') and not isinstance(eventProcessCD, str):
        if len(eventProcessCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = eventProcessCD
            requestString.append(None)
        else:
            requestString.append(','.join(eventProcessCD))
    else:
        requestString.append(eventProcessCD)
    try:
        listDateStart = listDateStart.strftime('%Y%m%d')
    except:
        listDateStart = listDateStart.replace('-', '')
    requestString.append("&listDateStart=%s"%(listDateStart))
    try:
        listDateEnd = listDateEnd.strftime('%Y%m%d')
    except:
        listDateEnd = listDateEnd.replace('-', '')
    requestString.append("&listDateEnd=%s"%(listDateEnd))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1128)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1128)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'exchangeCD', u'secShortName', u'secShortNameEn', u'equTypeCD', u'intPublishDate', u'proPublishDate', u'listPublishDate', u'listDate', u'eventProcessCD', u'parValue', u'issuePrice', u'currencyCD', u'issueShares', u'sharesBfIpo', u'sharesAfIpo', u'issueRaiseCap', u'issueCost', u'issueCostPerShare', u'onlineIssueBeginDate', u'onlineIssueEndDate', u'offlineIssueBeginDate', u'offlineIssueEndDate', u'onlineIssueApplyCode', u'onlineIssueApplyAbbr', u'onlineIssueLottoRatio', u'onlineIssueShares', u'offlineIssueShares', u'issuePED', u'issuePEW', u'firstDayOpenPrice', u'firstDayClosePrice', u'issueModeCD', u'underwritingModeCD', u'sponsor', u'leadUnderwriter', u'coleadUnderwriter']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','exchangeCD': 'str','secShortName': 'str','secShortNameEn': 'str','equTypeCD': 'str','eventProcessCD': 'str','currencyCD': 'str','onlineIssueApplyCode': 'str','onlineIssueApplyAbbr': 'str','issueModeCD': 'str','underwritingModeCD': 'str','sponsor': 'str','leadUnderwriter': 'str','coleadUnderwriter': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def EquIPObJYGet(secID = "", ticker = "", exchangeCD = "", listDateStart = "", listDateEnd = "", field = "", pandas = "1"):
    """
    获取B股首次公开发行上市的基本信息，包含股票首次公开发行的进程及发行结果。
    
    :param secID: 一只证券代码,格式是“数字.交易所代码”，如000001.XSHE。,secID、ticker、exchangeCD至少选择一个
    :param ticker: 一只股票代码，如000001。,secID、ticker、exchangeCD至少选择一个
    :param exchangeCD: 交易市场。例如，XSHG-上海证券交易所；XSHE-深圳证券交易所。对应DataAPI.SysCodeGet.codeTypeID=10002。,可以是列表,secID、ticker、exchangeCD至少选择一个
    :param listDateStart: 该期间所有的IPO股票上市日期，输入格式“YYYYMMDD”，如输入起始日期"20130101"，截止日期"20131231"，可以查询到2013年期间所有IPO的基本信息。,可空
    :param listDateEnd: 该期间所有的IPO股票上市日期，输入格式“YYYYMMDD”，如输入起始日期"20130101"，截止日期"20131231"，可以查询到2013年期间所有IPO的基本信息。,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/listedCorp/getEquIPObJY.csv?ispandas=1&') 
    if not isinstance(secID, str) and not isinstance(secID, unicode):
        secID = str(secID)

    requestString.append("secID=%s"%(secID))
    if not isinstance(ticker, str) and not isinstance(ticker, unicode):
        ticker = str(ticker)

    requestString.append("&ticker=%s"%(ticker))
    requestString.append("&exchangeCD=")
    if hasattr(exchangeCD,'__iter__') and not isinstance(exchangeCD, str):
        if len(exchangeCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = exchangeCD
            requestString.append(None)
        else:
            requestString.append(','.join(exchangeCD))
    else:
        requestString.append(exchangeCD)
    try:
        listDateStart = listDateStart.strftime('%Y%m%d')
    except:
        listDateStart = listDateStart.replace('-', '')
    requestString.append("&listDateStart=%s"%(listDateStart))
    try:
        listDateEnd = listDateEnd.strftime('%Y%m%d')
    except:
        listDateEnd = listDateEnd.replace('-', '')
    requestString.append("&listDateEnd=%s"%(listDateEnd))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1129)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1129)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'exchangeCD', u'secShortName', u'secShortNameEn', u'equTypeCD', u'intPublishDate', u'proPublishDate', u'listPublishDate', u'listDate', u'parValue', u'issuePrice', u'frIssuePrice', u'frCurrencyCD', u'issueShares', u'issueRaiseCap', u'frIssueRaiseCap', u'issueCost', u'issueCostPerShare', u'frIssueCost', u'frIssueCostPerShare', u'issuePED', u'issuePEW', u'firstDayOpenPrice', u'firstDayClosePrice', u'issueModeCD', u'underwritingModeCD']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','exchangeCD': 'str','secShortName': 'str','secShortNameEn': 'str','equTypeCD': 'str','frCurrencyCD': 'str','issueModeCD': 'str','underwritingModeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def EquDivJYGet(secID = "", ticker = "", exchangeCD = "", endDateEnd = "", isDiv = "", eventProcessCD = "", endDateStart = "", field = "", pandas = "1"):
    """
    获取股票历次分红(派现、送股、转增股)的基本信息，包含历次分红预案的内容、实施进展情况、历史宣告分红次数以及股改分红情况。
    
    :param secID: 一只证券代码,格式是“数字.交易所代码”，如000001.XSHE。,secID、ticker、exchangeCD至少选择一个
    :param ticker: 一只股票代码，如000001。,secID、ticker、exchangeCD至少选择一个
    :param exchangeCD: 交易市场。例如，XSHG-上海证券交易所；XSHE-深圳证券交易所。对应DataAPI.SysCodeGet.codeTypeID=10002。,可以是列表,secID、ticker、exchangeCD至少选择一个
    :param endDateEnd: 本次分红所属的财政年度、财政半年度、财政季度的最后一个自然日，输入格式“YYYYMMDD”，如输入起始日期"20130101"，截止日期"20131231"，可以查询到2013年期间所有分红,可空
    :param isDiv: 是否分红。例如，0-否；05-分红。对应DataAPI.SysCodeGet.codeTypeID=20011。,可以是列表,可空
    :param eventProcessCD: 事件进程。例如，1-董事预案；3-股东大会否决。对应DataAPI.SysCodeGet.codeTypeID=20001。,可以是列表,可空
    :param endDateStart: 本次分红所属的财政年度、财政半年度、财政季度的最后一个自然日，输入格式“YYYYMMDD”，如输入起始日期"20130101"，截止日期"20131231"，可以查询到2013年期间所有分红,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/listedCorp/getEquDivJY.csv?ispandas=1&') 
    if not isinstance(secID, str) and not isinstance(secID, unicode):
        secID = str(secID)

    requestString.append("secID=%s"%(secID))
    if not isinstance(ticker, str) and not isinstance(ticker, unicode):
        ticker = str(ticker)

    requestString.append("&ticker=%s"%(ticker))
    requestString.append("&exchangeCD=")
    if hasattr(exchangeCD,'__iter__') and not isinstance(exchangeCD, str):
        if len(exchangeCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = exchangeCD
            requestString.append(None)
        else:
            requestString.append(','.join(exchangeCD))
    else:
        requestString.append(exchangeCD)
    try:
        endDateEnd = endDateEnd.strftime('%Y%m%d')
    except:
        endDateEnd = endDateEnd.replace('-', '')
    requestString.append("&endDateEnd=%s"%(endDateEnd))
    requestString.append("&isDiv=")
    if hasattr(isDiv,'__iter__') and not isinstance(isDiv, str):
        if len(isDiv) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = isDiv
            requestString.append(None)
        else:
            requestString.append(','.join(isDiv))
    else:
        requestString.append(isDiv)
    requestString.append("&eventProcessCD=")
    if hasattr(eventProcessCD,'__iter__') and not isinstance(eventProcessCD, str):
        if len(eventProcessCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = eventProcessCD
            requestString.append(None)
        else:
            requestString.append(','.join(eventProcessCD))
    else:
        requestString.append(eventProcessCD)
    try:
        endDateStart = endDateStart.strftime('%Y%m%d')
    except:
        endDateStart = endDateStart.replace('-', '')
    requestString.append("&endDateStart=%s"%(endDateStart))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1130)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1130)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'exchangeCD', u'secShortName', u'secShortNameEn', u'endDate', u'isDiv', u'planPublishDate', u'imPublishDate', u'eventProcessCD', u'perCashDiv', u'perCashDivAfTax', u'frCurrencyCD', u'frPerCashDiv', u'frPerCashDivAfTax', u'perShareDivRatio', u'perShareTransRatio', u'divObjectCD', u'recordDate', u'exDivDate', u'bLastTradeDate', u'payCashDate', u'bonusShareListDate', u'totalCashDiv', u'frTotalCashDiv', u'baseShares', u'sharesAfDiv']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','exchangeCD': 'str','secShortName': 'str','secShortNameEn': 'str','eventProcessCD': 'str','frCurrencyCD': 'str','divObjectCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def EquAllotaJYGet(secID = "", ticker = "", exchangeCD = "", field = "", pandas = "1"):
    """
    获取A股历次配股的基本信息，包含每次配股方案的内容、方案进度、历史配股预案公布次数。
    
    :param secID: 一只证券代码,格式是“数字.交易所代码”，如000001.XSHE。,secID、ticker、exchangeCD至少选择一个
    :param ticker: 一只股票代码，如000001。,secID、ticker、exchangeCD至少选择一个
    :param exchangeCD: 交易市场。例如，XSHG-上海证券交易所；XSHE-深圳证券交易所。对应DataAPI.SysCodeGet.codeTypeID=10002。,可以是列表,secID、ticker、exchangeCD至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/listedCorp/getEquAllotaJY.csv?ispandas=1&') 
    if not isinstance(secID, str) and not isinstance(secID, unicode):
        secID = str(secID)

    requestString.append("secID=%s"%(secID))
    if not isinstance(ticker, str) and not isinstance(ticker, unicode):
        ticker = str(ticker)

    requestString.append("&ticker=%s"%(ticker))
    requestString.append("&exchangeCD=")
    if hasattr(exchangeCD,'__iter__') and not isinstance(exchangeCD, str):
        if len(exchangeCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = exchangeCD
            requestString.append(None)
        else:
            requestString.append(','.join(exchangeCD))
    else:
        requestString.append(exchangeCD)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1131)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1131)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'exchangeCD', u'secShortName', u'secShortNameEn', u'iniPublishDate', u'allotYear', u'equTypeCD', u'planPublishDate', u'proPublishDate', u'allotCode', u'allotAbbr', u'allotmentPrice', u'allotmentRatio', u'baseShares', u'allotShares', u'recordDate', u'exRightsDate', u'payBeginDate', u'payEndDate', u'listDate', u'raiseCap', u'allotCost']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','exchangeCD': 'str','secShortName': 'str','secShortNameEn': 'str','equTypeCD': 'str','allotCode': 'str','allotAbbr': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def EquAllotbJYGet(secID = "", ticker = "", exchangeCD = "", field = "", pandas = "1"):
    """
    获取B股历次配股的基本信息，包含每次配股方案的内容、方案进度、历史配股预案公布次数。
    
    :param secID: 一只证券代码,格式是“数字.交易所代码”，如000001.XSHE。,secID、ticker、exchangeCD至少选择一个
    :param ticker: 一只股票代码，如000001。,secID、ticker、exchangeCD至少选择一个
    :param exchangeCD: 交易市场。例如，XSHG-上海证券交易所；XSHE-深圳证券交易所。对应DataAPI.SysCodeGet.codeTypeID=10002。,可以是列表,secID、ticker、exchangeCD至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/listedCorp/getEquAllotbJY.csv?ispandas=1&') 
    if not isinstance(secID, str) and not isinstance(secID, unicode):
        secID = str(secID)

    requestString.append("secID=%s"%(secID))
    if not isinstance(ticker, str) and not isinstance(ticker, unicode):
        ticker = str(ticker)

    requestString.append("&ticker=%s"%(ticker))
    requestString.append("&exchangeCD=")
    if hasattr(exchangeCD,'__iter__') and not isinstance(exchangeCD, str):
        if len(exchangeCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = exchangeCD
            requestString.append(None)
        else:
            requestString.append(','.join(exchangeCD))
    else:
        requestString.append(exchangeCD)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1132)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1132)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'exchangeCD', u'secShortName', u'secShortNameEn', u'iniPublishDate', u'allotYear', u'equTypeCD', u'planPublishDate', u'proPublishDate', u'allotCode', u'allotAbbr', u'allotmentPrice', u'allotFrPrice', u'frCurrencyCD', u'allotmentRatio', u'allotShares', u'recordDate', u'exRightsDate', u'payBeginDate', u'payEndDate', u'listDate', u'raiseCap', u'frRaiseCap', u'allotCost', u'frAllotCost']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','exchangeCD': 'str','secShortName': 'str','secShortNameEn': 'str','equTypeCD': 'str','allotCode': 'str','allotAbbr': 'str','frCurrencyCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def EquSPOaJYGet(secID = "", ticker = "", exchangeCD = "", eventProcessCD = "", spoTypeCD = "", isExright = "", field = "", pandas = "1"):
    """
    获取历次增发A股的基本信息，包含每次增发方案的内容、方案进度。
    
    :param secID: 一只证券代码,格式是“数字.交易所代码”，如000001.XSHE。,secID、ticker、exchangeCD至少选择一个
    :param ticker: 一只股票代码，如000001。,secID、ticker、exchangeCD至少选择一个
    :param exchangeCD: 交易市场。例如，XSHG-上海证券交易所；XSHE-深圳证券交易所。对应DataAPI.SysCodeGet.codeTypeID=10002。,可以是列表,secID、ticker、exchangeCD至少选择一个
    :param eventProcessCD: 事件进程。例如，1-董事会预案；2-股东大会通过；3-股东大会否决。对应DataAPI.SysCodeGet.codeTypeID=20001。,可以是列表,可空
    :param spoTypeCD: 增发类型。例如，0101-公开增发；0102-非公开增发。对应DataAPI.SysCodeGet.codeTypeID=20019。,可以是列表,可空
    :param isExright: 是否除权。1-是，0-否。,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/listedCorp/getEquSPOaJY.csv?ispandas=1&') 
    if not isinstance(secID, str) and not isinstance(secID, unicode):
        secID = str(secID)

    requestString.append("secID=%s"%(secID))
    if not isinstance(ticker, str) and not isinstance(ticker, unicode):
        ticker = str(ticker)

    requestString.append("&ticker=%s"%(ticker))
    requestString.append("&exchangeCD=")
    if hasattr(exchangeCD,'__iter__') and not isinstance(exchangeCD, str):
        if len(exchangeCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = exchangeCD
            requestString.append(None)
        else:
            requestString.append(','.join(exchangeCD))
    else:
        requestString.append(exchangeCD)
    requestString.append("&eventProcessCD=")
    if hasattr(eventProcessCD,'__iter__') and not isinstance(eventProcessCD, str):
        if len(eventProcessCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = eventProcessCD
            requestString.append(None)
        else:
            requestString.append(','.join(eventProcessCD))
    else:
        requestString.append(eventProcessCD)
    requestString.append("&spoTypeCD=")
    if hasattr(spoTypeCD,'__iter__') and not isinstance(spoTypeCD, str):
        if len(spoTypeCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = spoTypeCD
            requestString.append(None)
        else:
            requestString.append(','.join(spoTypeCD))
    else:
        requestString.append(spoTypeCD)
    requestString.append("&isExright=")
    if hasattr(isExright,'__iter__') and not isinstance(isExright, str):
        if len(isExright) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = isExright
            requestString.append(None)
        else:
            requestString.append(','.join(isExright))
    else:
        requestString.append(isExright)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1133)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1133)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'exchangeCD', u'secShortName', u'secShortNameEn', u'iniPublishDate', u'planPublishDate', u'vldBeginDate', u'vldEndDate', u'issuePricePul', u'issuePricePll', u'issuePricePllAdj', u'issueSharesPul', u'issueSharesPll', u'changeTypeCD', u'proPublishDate', u'issueBeginDate', u'issueEndDate', u'eventProcessCD', u'spoTypeCD', u'isExright', u'listPublishDate', u'recordDate', u'exRightsDate', u'listDate', u'issuePrice', u'issueShares', u'issueRaiseCap', u'tradeShares', u'allotmentRatio']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','exchangeCD': 'str','secShortName': 'str','secShortNameEn': 'str','changeTypeCD': 'str','eventProcessCD': 'str','spoTypeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def EquSPObJYGet(secID = "", ticker = "", exchangeCD = "", spoTypeCD = "", field = "", pandas = "1"):
    """
    获取历次增发B股的基本信息，包含每次增发方案的内容、方案进度。
    
    :param secID: 一只证券代码,格式是“数字.交易所代码”，如000001.XSHE。,secID、ticker、exchangeCD至少选择一个
    :param ticker: 一只股票代码，如000001。,secID、ticker、exchangeCD至少选择一个
    :param exchangeCD: 交易市场。例如，XSHG-上海证券交易所；XSHE-深圳证券交易所。对应DataAPI.SysCodeGet.codeTypeID=10002。,可以是列表,secID、ticker、exchangeCD至少选择一个
    :param spoTypeCD: 增发类型。例如，0101-公开增发；0102-非公开增发。对应DataAPI.SysCodeGet.codeTypeID=20019。,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/listedCorp/getEquSPObJY.csv?ispandas=1&') 
    if not isinstance(secID, str) and not isinstance(secID, unicode):
        secID = str(secID)

    requestString.append("secID=%s"%(secID))
    if not isinstance(ticker, str) and not isinstance(ticker, unicode):
        ticker = str(ticker)

    requestString.append("&ticker=%s"%(ticker))
    requestString.append("&exchangeCD=")
    if hasattr(exchangeCD,'__iter__') and not isinstance(exchangeCD, str):
        if len(exchangeCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = exchangeCD
            requestString.append(None)
        else:
            requestString.append(','.join(exchangeCD))
    else:
        requestString.append(exchangeCD)
    requestString.append("&spoTypeCD=")
    if hasattr(spoTypeCD,'__iter__') and not isinstance(spoTypeCD, str):
        if len(spoTypeCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = spoTypeCD
            requestString.append(None)
        else:
            requestString.append(','.join(spoTypeCD))
    else:
        requestString.append(spoTypeCD)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1134)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1134)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'exchangeCD', u'secShortName', u'secShortNameEn', u'iniPublishDate', u'planPublishDate', u'vldBeginDate', u'vldEndDate', u'issuePricePul', u'issuePricePll', u'issueSharesPul', u'issueSharesPll', u'changeTypeCD', u'proPublishDate', u'issueBeginDate', u'issueEndDate', u'spoTypeCD', u'listDate', u'issuePrice', u'frIssuePrice', u'currencyCD', u'issueShares', u'issueRaiseCap', u'frIssueRaiseCap', u'tradeShares']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','exchangeCD': 'str','secShortName': 'str','secShortNameEn': 'str','changeTypeCD': 'str','spoTypeCD': 'str','currencyCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def EquRefdJYGet(partyID, isPass = "", eventProcessCD = "", field = "", pandas = "1"):
    """
    获取股票股权分置改革的基本信息，包含股改进程、股改实施方案以及流通股的变动情况。
    
    :param partyID: 一个上市公司的公司代码。
    :param isPass: 改革方案是否通过。1-通过；0-未通过。,可以是列表,可空
    :param eventProcessCD: 事件进程。例如，1-董事会预案；2-股东大会通过；3-股东大会否决。对应DataAPI.SysCodeGet.codeTypeID=20001。,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/listedCorp/getEquRefdJY.csv?ispandas=1&') 
    if not isinstance(partyID, str) and not isinstance(partyID, unicode):
        partyID = str(partyID)

    requestString.append("partyID=%s"%(partyID))
    requestString.append("&isPass=")
    if hasattr(isPass,'__iter__') and not isinstance(isPass, str):
        if len(isPass) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = isPass
            requestString.append(None)
        else:
            requestString.append(','.join(isPass))
    else:
        requestString.append(isPass)
    requestString.append("&eventProcessCD=")
    if hasattr(eventProcessCD,'__iter__') and not isinstance(eventProcessCD, str):
        if len(eventProcessCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = eventProcessCD
            requestString.append(None)
        else:
            requestString.append(','.join(eventProcessCD))
    else:
        requestString.append(eventProcessCD)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1135)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1135)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'partyID', u'iniPublishDate', u'latPublishDate', u'isPass', u'eventProcessCD', u'adjTypeCD', u'imPublishDate', u'recordDate', u'haltDate', u'af1stTradeDate', u'cshareListDate', u'bfShares', u'bfNontradeShares', u'bfTradeShares', u'bfTradeAshares', u'afShares', u'afRestShares', u'afNonrestShares', u'afNonrestAshares']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'eventProcessCD': 'str','adjTypeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def EquRefcJYGet(partyID, isEffected = "", capTypeCD = "", field = "", pandas = "1"):
    """
    获取股票股权分置改革支付对价方案的具体信息，包含该方案是否生效以及具体的支付比例。
    
    :param partyID: 一个上市公司的公司代码。
    :param isEffected: 是否有效。1-是，0-否。,可以是列表,可空
    :param capTypeCD: 获付股东股本性质。例如，1-流通A股；2-H股；3-B股。对应DataAPI.SysCodeGet.codeTypeID=20013。,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/listedCorp/getEquRefcJY.csv?ispandas=1&') 
    if not isinstance(partyID, str) and not isinstance(partyID, unicode):
        partyID = str(partyID)

    requestString.append("partyID=%s"%(partyID))
    requestString.append("&isEffected=")
    if hasattr(isEffected,'__iter__') and not isinstance(isEffected, str):
        if len(isEffected) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = isEffected
            requestString.append(None)
        else:
            requestString.append(','.join(isEffected))
    else:
        requestString.append(isEffected)
    requestString.append("&capTypeCD=")
    if hasattr(capTypeCD,'__iter__') and not isinstance(capTypeCD, str):
        if len(capTypeCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = capTypeCD
            requestString.append(None)
        else:
            requestString.append(','.join(capTypeCD))
    else:
        requestString.append(capTypeCD)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1136)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1136)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'partyID', u'iniPublishDate', u'latPublishDate', u'isEffected', u'capTypeCD', u'perShareDivRatio', u'ntshPayShare', u'comPayShare', u'perShareTransRatio', u'ntshTransShare', u'comTransShare', u'perCashDiv', u'ntshPayCash', u'comPayCash', u'perCashDivAfTax', u'warrantRatio', u'ntshPayWarrant', u'comPayWarrant', u'comDtShares', u'comCash', u'comWarrant', u'bfNtsharesRatio', u'afNtsharesRatio', u'shareConsiRatio', u'perCashConsi', u'perCashConsiAfTax', u'warrantConsiRatio', u'shareConsi', u'cashConsi', u'warrantConsi']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'capTypeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def EquShareJYGet(partyID, changeTypeCD = "", changeDateStart = "", changeDateEnd = "", field = "", pandas = "1"):
    """
    获取上市公司最新股本结构及历次股本各部分变动情况数据。
    
    :param partyID: 一个上市公司的公司代码。
    :param changeTypeCD: 股本变动原因类别。例如，01-未变动；02-变动。对应DataAPI.SysCodeGet.codeTypeID=20005。,可以是列表,可空
    :param changeDateStart: 股本发生变更日期，输入格式“YYYYMMDD”，如输入起始日期"20130101"，截止日期"20131231"，可以查询到2013年期间所有股本发生变动的记录。,可空
    :param changeDateEnd: 股本发生变更日期，输入格式“YYYYMMDD”，如输入起始日期"20130101"，截止日期"20131231"，可以查询到2013年期间所有股本发生变动的记录。,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/listedCorp/getEquShareJY.csv?ispandas=1&') 
    if not isinstance(partyID, str) and not isinstance(partyID, unicode):
        partyID = str(partyID)

    requestString.append("partyID=%s"%(partyID))
    requestString.append("&changeTypeCD=")
    if hasattr(changeTypeCD,'__iter__') and not isinstance(changeTypeCD, str):
        if len(changeTypeCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = changeTypeCD
            requestString.append(None)
        else:
            requestString.append(','.join(changeTypeCD))
    else:
        requestString.append(changeTypeCD)
    try:
        changeDateStart = changeDateStart.strftime('%Y%m%d')
    except:
        changeDateStart = changeDateStart.replace('-', '')
    requestString.append("&changeDateStart=%s"%(changeDateStart))
    try:
        changeDateEnd = changeDateEnd.strftime('%Y%m%d')
    except:
        changeDateEnd = changeDateEnd.replace('-', '')
    requestString.append("&changeDateEnd=%s"%(changeDateEnd))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1137)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1137)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'partyID', u'publishDate', u'changeDate', u'totalShares', u'aShares', u'bShares', u'hShares', u'sShares', u'nShares', u'floatShares', u'floatA', u'nonrestFloatA', u'floatB', u'restShares', u'restA', u'nonListedA', u'nonListedB', u'changeTypeCD']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'changeTypeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def EquMainshJYGet(tickerA = "", tickerB = "", tickerH = "", partyID = "", infoTypeCD = "", shRank = "", shTypeCD = "", endDateStart = "", endDateEnd = "", field = "", pandas = "1"):
    """
    获取公司十大股东以及十大流通股东历次变动记录，包括主要股东构成及持股数量比例、持股性质。
    
    :param tickerA: A股交易代码,可以是列表,tickerA、tickerB、tickerH、partyID至少选择一个
    :param tickerB: B股交易代码,可以是列表,tickerA、tickerB、tickerH、partyID至少选择一个
    :param tickerH: H股交易代码,可以是列表,tickerA、tickerB、tickerH、partyID至少选择一个
    :param partyID: 一个上市公司的公司代码。,可以是列表,tickerA、tickerB、tickerH、partyID至少选择一个
    :param infoTypeCD: 信息类别。例如，1-前十大股东；2-前十大流通股东。对应DataAPI.SysCodeGet.codeTypeID=20017。,可空
    :param shRank: 十大股东持股排名，如输入1，得到第一大股东信息。,可以是列表,可空
    :param shTypeCD: 股东类别。例如，1-国有股东；2-外资股东。对应DataAPI.SysCodeGet.codeTypeID=20016。,可以是列表,可空
    :param endDateStart: 本次披露的十大股东统计截止日，输入格式“YYYYMMDD”，如输入起始日期"20130101"，截止日期"20131231"，可以查询到2013年期间披露的所有十大股东名单,可空
    :param endDateEnd: 本次披露的十大股东统计截止日，输入格式“YYYYMMDD”，如输入起始日期"20130101"，截止日期"20131231"，可以查询到2013年期间披露的所有十大股东名单,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/listedCorp/getEquMainshJY.csv?ispandas=1&') 
    requestString.append("tickerA=")
    if hasattr(tickerA,'__iter__') and not isinstance(tickerA, str):
        if len(tickerA) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = tickerA
            requestString.append(None)
        else:
            requestString.append(','.join(tickerA))
    else:
        requestString.append(tickerA)
    requestString.append("&tickerB=")
    if hasattr(tickerB,'__iter__') and not isinstance(tickerB, str):
        if len(tickerB) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = tickerB
            requestString.append(None)
        else:
            requestString.append(','.join(tickerB))
    else:
        requestString.append(tickerB)
    requestString.append("&tickerH=")
    if hasattr(tickerH,'__iter__') and not isinstance(tickerH, str):
        if len(tickerH) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = tickerH
            requestString.append(None)
        else:
            requestString.append(','.join(tickerH))
    else:
        requestString.append(tickerH)
    requestString.append("&partyID=")
    if hasattr(partyID,'__iter__') and not isinstance(partyID, str):
        if len(partyID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = partyID
            requestString.append(None)
        else:
            requestString.append(','.join(partyID))
    else:
        requestString.append(partyID)
    if not isinstance(infoTypeCD, str) and not isinstance(infoTypeCD, unicode):
        infoTypeCD = str(infoTypeCD)

    requestString.append("&infoTypeCD=%s"%(infoTypeCD))
    requestString.append("&shRank=")
    if hasattr(shRank,'__iter__') and not isinstance(shRank, str):
        if len(shRank) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = shRank
            requestString.append(None)
        else:
            requestString.append(','.join(shRank))
    else:
        requestString.append(shRank)
    requestString.append("&shTypeCD=")
    if hasattr(shTypeCD,'__iter__') and not isinstance(shTypeCD, str):
        if len(shTypeCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = shTypeCD
            requestString.append(None)
        else:
            requestString.append(','.join(shTypeCD))
    else:
        requestString.append(shTypeCD)
    try:
        endDateStart = endDateStart.strftime('%Y%m%d')
    except:
        endDateStart = endDateStart.replace('-', '')
    requestString.append("&endDateStart=%s"%(endDateStart))
    try:
        endDateEnd = endDateEnd.strftime('%Y%m%d')
    except:
        endDateEnd = endDateEnd.replace('-', '')
    requestString.append("&endDateEnd=%s"%(endDateEnd))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1138)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1138)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'partyID', u'tickerA', u'tickerB', u'tickerH', u'publishDate', u'endDate', u'infoTypeCD', u'shNum', u'shRank', u'shName', u'shChar', u'shTypeCD', u'holdVol', u'holdPct', u'shareChar', u'holdVolFa', u'holdVolB', u'holdNonrestVol', u'holdRestVol', u'pleVol', u'frzVol']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'tickerA': 'str','tickerB': 'str','tickerH': 'str','infoTypeCD': 'str','shName': 'str','shChar': 'str','shTypeCD': 'str','shareChar': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def EquMsChanJYGet(secID = "", ticker = "", exchangeCD = "", relationshipCD = "", changePctLl = "", changePctUl = "", field = "", pandas = "1"):
    """
    获取上市公司高管及其亲属买卖所在公司股份的情况，包括持股人与上市公司高管关系以及变动比例。
    
    :param secID: 一只证券代码,格式是“数字.交易所代码”，如000001.XSHE。,secID、ticker、exchangeCD至少选择一个
    :param ticker: 一只股票代码，如000001。,secID、ticker、exchangeCD至少选择一个
    :param exchangeCD: 交易市场。例如，XSHG-上海证券交易所；XSHE-深圳证券交易所。对应DataAPI.SysCodeGet.codeTypeID=10002。,可以是列表,secID、ticker、exchangeCD至少选择一个
    :param relationshipCD: 股份变动人与高管关系类别。例如，1-本人；2-父母。对应DataAPI.SysCodeGet.codeTypeID=20006。,可以是列表,可空
    :param changePctLl: 股份变动人持股变动比例下限,可空
    :param changePctUl: 股份变动人持股变动比例上限,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/listedCorp/getEquMsChanJY.csv?ispandas=1&') 
    if not isinstance(secID, str) and not isinstance(secID, unicode):
        secID = str(secID)

    requestString.append("secID=%s"%(secID))
    if not isinstance(ticker, str) and not isinstance(ticker, unicode):
        ticker = str(ticker)

    requestString.append("&ticker=%s"%(ticker))
    requestString.append("&exchangeCD=")
    if hasattr(exchangeCD,'__iter__') and not isinstance(exchangeCD, str):
        if len(exchangeCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = exchangeCD
            requestString.append(None)
        else:
            requestString.append(','.join(exchangeCD))
    else:
        requestString.append(exchangeCD)
    requestString.append("&relationshipCD=")
    if hasattr(relationshipCD,'__iter__') and not isinstance(relationshipCD, str):
        if len(relationshipCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = relationshipCD
            requestString.append(None)
        else:
            requestString.append(','.join(relationshipCD))
    else:
        requestString.append(relationshipCD)
    if not isinstance(changePctLl, str) and not isinstance(changePctLl, unicode):
        changePctLl = str(changePctLl)

    requestString.append("&changePctLl=%s"%(changePctLl))
    if not isinstance(changePctUl, str) and not isinstance(changePctUl, unicode):
        changePctUl = str(changePctUl)

    requestString.append("&changePctUl=%s"%(changePctUl))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1139)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1139)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'partyID', u'secID', u'ticker', u'exchangeCD', u'secShortName', u'secShortNameEn', u'reportDate', u'changeDate', u'serialNum', u'managerName', u'position', u'shName', u'relationshipCD', u'sharesChange', u'avgPrice', u'changePct', u'sharesBfChange', u'sharesAfChange', u'changeReasonType']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','exchangeCD': 'str','secShortName': 'str','secShortNameEn': 'str','managerName': 'str','position': 'str','shName': 'str','relationshipCD': 'str','changeReasonType': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def EquInstShJYGet(secID = "", ticker = "", exchangeCD = "", partyID = "", field = "", pandas = "1"):
    """
    获取各类机构投资者对每只股票的持仓数以及持仓比例。
    
    :param secID: 一只证券代码,格式是“数字.交易所代码”，如000001.XSHE。,secID、ticker、exchangeCD、partyID至少选择一个
    :param ticker: 一只股票代码，如000001。,secID、ticker、exchangeCD、partyID至少选择一个
    :param exchangeCD: 交易市场。例如，XSHG-上海证券交易所；XSHE-深圳证券交易所。对应DataAPI.SysCodeGet.codeTypeID=10002。,可以是列表,secID、ticker、exchangeCD、partyID至少选择一个
    :param partyID: 一个上市公司的公司代码。,secID、ticker、exchangeCD、partyID至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/listedCorp/getEquInstShJY.csv?ispandas=1&') 
    if not isinstance(secID, str) and not isinstance(secID, unicode):
        secID = str(secID)

    requestString.append("secID=%s"%(secID))
    if not isinstance(ticker, str) and not isinstance(ticker, unicode):
        ticker = str(ticker)

    requestString.append("&ticker=%s"%(ticker))
    requestString.append("&exchangeCD=")
    if hasattr(exchangeCD,'__iter__') and not isinstance(exchangeCD, str):
        if len(exchangeCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = exchangeCD
            requestString.append(None)
        else:
            requestString.append(','.join(exchangeCD))
    else:
        requestString.append(exchangeCD)
    if not isinstance(partyID, str) and not isinstance(partyID, unicode):
        partyID = str(partyID)

    requestString.append("&partyID=%s"%(partyID))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1140)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1140)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'partyID', u'secID', u'ticker', u'exchangeCD', u'secShortName', u'secShortNameEn', u'infoSource', u'endDate', u'instNrfa', u'instNrfaPct', u'instAshares', u'instAsharesPct', u'instShares', u'instSharesPct', u'fundNrfa', u'fundNrfaPct', u'fundAshares', u'fundAsharesPct', u'fundShares', u'fundSharesPct', u'brokerNrfa', u'brokerNrfaPct', u'brokerAshares', u'brokerAsharesPct', u'brokerShares', u'brokerSharesPct', u'fpNrfa', u'fpNrfaPct', u'fpAshares', u'fpAsharesPct', u'fpShares', u'fpSharesPct', u'qfiiNrfa', u'qfiiNrfaPct', u'qfiiAshares', u'qfiiAsharesPct', u'qfiiShares', u'qfiiSharesPct', u'inscNrfa', u'inscNrfaPct', u'inscAshares', u'inscAsharesPct', u'inscShares', u'inscSharesPct', u'siFundNrfa', u'siFundNrfaPct', u'siFundAshares', u'siFundAsharesPct', u'siFundShares', u'siFundSharesPct', u'eaNrfa', u'eaNrfaPct', u'eaAshares', u'eaAsharesPct', u'eaShares', u'eaSharesPct', u'tcNrfa', u'tcNrfaPct', u'tcAshares', u'tcAsharesPct', u'tcShares', u'tcSharesPct', u'fcNrfa', u'fcNrfaPct', u'fcAshares', u'fcAsharesPct', u'fcShares', u'fcSharesPct', u'otherInstNrfa', u'otherInstNrfaPct', u'otherInstAshares', u'otherInstAsharesPct', u'otherInstShares', u'otherInstSharesPct']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','exchangeCD': 'str','secShortName': 'str','secShortNameEn': 'str','infoSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def EquSuitJYGet(partyID, eventTypeCD = "", causeCD = "", eventProcessCD = "", eventSubCD = "", field = "", pandas = "1"):
    """
    获取公司诉讼仲裁事项描述说明。
    
    :param partyID: 一个上市公司的公司代码。
    :param eventTypeCD: 行为事件类别。例如，0901-诉讼；0902-仲裁。对应DataAPI.SysCodeGet.codeTypeID=20002。,可以是列表,可空
    :param causeCD: 案由类别。01-欠款未还；02-担保牵连；03-其他经济纠纷；04-其他。对应DataAPI.SysCodeGet.codeTypeID=20022。,可以是列表,可空
    :param eventProcessCD: 事件进程。例如，1-董事会预案；2-股东大会通过；3-股东大会否决。对应DataAPI.SysCodeGet.codeTypeID=20001。,可以是列表,可空
    :param eventSubCD: 事件主体类别。例如，01-上市公司；02-下属公司。对应DataAPI.SysCodeGet.codeTypeID=20023。,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/listedCorp/getEquSuitJY.csv?ispandas=1&') 
    if not isinstance(partyID, str) and not isinstance(partyID, unicode):
        partyID = str(partyID)

    requestString.append("partyID=%s"%(partyID))
    requestString.append("&eventTypeCD=")
    if hasattr(eventTypeCD,'__iter__') and not isinstance(eventTypeCD, str):
        if len(eventTypeCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = eventTypeCD
            requestString.append(None)
        else:
            requestString.append(','.join(eventTypeCD))
    else:
        requestString.append(eventTypeCD)
    requestString.append("&causeCD=")
    if hasattr(causeCD,'__iter__') and not isinstance(causeCD, str):
        if len(causeCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = causeCD
            requestString.append(None)
        else:
            requestString.append(','.join(causeCD))
    else:
        requestString.append(causeCD)
    requestString.append("&eventProcessCD=")
    if hasattr(eventProcessCD,'__iter__') and not isinstance(eventProcessCD, str):
        if len(eventProcessCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = eventProcessCD
            requestString.append(None)
        else:
            requestString.append(','.join(eventProcessCD))
    else:
        requestString.append(eventProcessCD)
    requestString.append("&eventSubCD=")
    if hasattr(eventSubCD,'__iter__') and not isinstance(eventSubCD, str):
        if len(eventSubCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = eventSubCD
            requestString.append(None)
        else:
            requestString.append(','.join(eventSubCD))
    else:
        requestString.append(eventSubCD)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1141)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1141)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'partyID', u'iniPublishDate', u'publishDate', u'infoSource', u'repTypeCD', u'discTypeCD', u'eventTypeCD', u'eventDesc', u'ifEnd', u'eventProcessCD', u'latestProg', u'causeCD', u'causeDesc', u'eventSubCD', u'subName', u'subRelationshipCD', u'subRoleCD', u'oppName', u'oppRelationshipCD', u'currencyCD', u'suitSum1st', u'latestSuitSum', u'complainant', u'complRelationshipCD', u'defendant', u'defRelationshipCD', u'jlPerson', u'jlpRelationshipCD', u'judgOrg', u'arbStatusCD', u'instStatusCD1st', u'instStatusCD2nd', u'supOrgStatusCD', u'ppeExeCD', u'judgExeCD']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'infoSource': 'str','repTypeCD': 'str','discTypeCD': 'str','eventTypeCD': 'str','eventDesc': 'str','eventProcessCD': 'str','latestProg': 'str','causeCD': 'str','causeDesc': 'str','eventSubCD': 'str','subName': 'str','subRelationshipCD': 'str','subRoleCD': 'str','oppName': 'str','oppRelationshipCD': 'str','currencyCD': 'str','complainant': 'str','complRelationshipCD': 'str','defendant': 'str','defRelationshipCD': 'str','jlPerson': 'str','jlpRelationshipCD': 'str','judgOrg': 'str','arbStatusCD': 'str','instStatusCD1st': 'str','instStatusCD2nd': 'str','supOrgStatusCD': 'str','ppeExeCD': 'str','judgExeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def EquPunishJYGet(partyID, subRelationshipCD = "", punishReasonCD = "", punishTypeCD = "", invovleTypeCD = "", punishObjCD = "", punishOrgCD = "", field = "", pandas = "1"):
    """
    获取公司违规受处罚事项描述说明。
    
    :param partyID: 一个上市公司的公司代码。
    :param subRelationshipCD: 事件主体与上市公司关联关系类别。例如，0-无关联关系；01-本公司。对应DataAPI.SysCodeGet.codeTypeID=20021。,可以是列表,可空
    :param punishReasonCD: 处罚原因类别。例如，01-信息披露遗漏；02-信息披露延误。对应DataAPI.SysCodeGet.codeTypeID=20028。,可以是列表,可空
    :param punishTypeCD: 处罚类型。例如，01-处罚；02-罚款。对应DataAPI.SysCodeGet.codeTypeID=20030。,可以是列表,可空
    :param invovleTypeCD: 涉及内容类别。例如，01-虚假利润；02-业绩预告。对应DataAPI.SysCodeGet.codeTypeID=20032。,可以是列表,可空
    :param punishObjCD: 处罚对象类别。例如，01-上市公司；02-公司领导人。对应DataAPI.SysCodeGet.codeTypeID=20029。,可以是列表,可空
    :param punishOrgCD: 处罚机构类别。例如，01-全国人大；02-国务院。对应DataAPI.SysCodeGet.codeTypeID=20031。,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/listedCorp/getEquPunishJY.csv?ispandas=1&') 
    if not isinstance(partyID, str) and not isinstance(partyID, unicode):
        partyID = str(partyID)

    requestString.append("partyID=%s"%(partyID))
    requestString.append("&subRelationshipCD=")
    if hasattr(subRelationshipCD,'__iter__') and not isinstance(subRelationshipCD, str):
        if len(subRelationshipCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = subRelationshipCD
            requestString.append(None)
        else:
            requestString.append(','.join(subRelationshipCD))
    else:
        requestString.append(subRelationshipCD)
    requestString.append("&punishReasonCD=")
    if hasattr(punishReasonCD,'__iter__') and not isinstance(punishReasonCD, str):
        if len(punishReasonCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = punishReasonCD
            requestString.append(None)
        else:
            requestString.append(','.join(punishReasonCD))
    else:
        requestString.append(punishReasonCD)
    requestString.append("&punishTypeCD=")
    if hasattr(punishTypeCD,'__iter__') and not isinstance(punishTypeCD, str):
        if len(punishTypeCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = punishTypeCD
            requestString.append(None)
        else:
            requestString.append(','.join(punishTypeCD))
    else:
        requestString.append(punishTypeCD)
    requestString.append("&invovleTypeCD=")
    if hasattr(invovleTypeCD,'__iter__') and not isinstance(invovleTypeCD, str):
        if len(invovleTypeCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = invovleTypeCD
            requestString.append(None)
        else:
            requestString.append(','.join(invovleTypeCD))
    else:
        requestString.append(invovleTypeCD)
    requestString.append("&punishObjCD=")
    if hasattr(punishObjCD,'__iter__') and not isinstance(punishObjCD, str):
        if len(punishObjCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = punishObjCD
            requestString.append(None)
        else:
            requestString.append(','.join(punishObjCD))
    else:
        requestString.append(punishObjCD)
    requestString.append("&punishOrgCD=")
    if hasattr(punishOrgCD,'__iter__') and not isinstance(punishOrgCD, str):
        if len(punishOrgCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = punishOrgCD
            requestString.append(None)
        else:
            requestString.append(','.join(punishOrgCD))
    else:
        requestString.append(punishOrgCD)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1142)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1142)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'partyID', u'publishDate', u'infoSource', u'subRelationshipCD', u'punishReasonCD', u'punishObjCD', u'punishTypeCD', u'punishOrgCD', u'invovleTypeCD', u'invovleCom', u'invoRelationshipCD', u'comPunishSum', u'indivPunishSum']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'infoSource': 'str','subRelationshipCD': 'str','punishReasonCD': 'str','punishObjCD': 'str','punishTypeCD': 'str','punishOrgCD': 'str','invovleTypeCD': 'str','invovleCom': 'str','invoRelationshipCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def EquRelTransJYGet(partyID, transTypeCD = "", relationshipCD = "", transPctLl = "", transPctUl = "", field = "", pandas = "1"):
    """
    获取公司与关联企业之间的各类关联交易。
    
    :param partyID: 一个上市公司的公司代码。
    :param transTypeCD: 交易类别。例如，1-销售商品；2-购买商品。对应DataAPI.SysCodeGet.codeTypeID=20034。,可以是列表,可空
    :param relationshipCD: 关联关系类别。例如，0-无关联关系；01-本公司。对应DataAPI.SysCodeGet.codeTypeID=20021。,可以是列表,可空
    :param transPctLl: 关联交易金额占项目总额比例下限。,可空
    :param transPctUl: 关联交易金额占项目总额比例上限。,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/listedCorp/getEquRelTransJY.csv?ispandas=1&') 
    if not isinstance(partyID, str) and not isinstance(partyID, unicode):
        partyID = str(partyID)

    requestString.append("partyID=%s"%(partyID))
    requestString.append("&transTypeCD=")
    if hasattr(transTypeCD,'__iter__') and not isinstance(transTypeCD, str):
        if len(transTypeCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = transTypeCD
            requestString.append(None)
        else:
            requestString.append(','.join(transTypeCD))
    else:
        requestString.append(transTypeCD)
    requestString.append("&relationshipCD=")
    if hasattr(relationshipCD,'__iter__') and not isinstance(relationshipCD, str):
        if len(relationshipCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = relationshipCD
            requestString.append(None)
        else:
            requestString.append(','.join(relationshipCD))
    else:
        requestString.append(relationshipCD)
    if not isinstance(transPctLl, str) and not isinstance(transPctLl, unicode):
        transPctLl = str(transPctLl)

    requestString.append("&transPctLl=%s"%(transPctLl))
    if not isinstance(transPctUl, str) and not isinstance(transPctUl, unicode):
        transPctUl = str(transPctUl)

    requestString.append("&transPctUl=%s"%(transPctUl))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1143)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1143)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'partyID', u'publishDate', u'infoSource', u'infoSourceCD', u'endDate', u'relatedCom', u'relationshipCD', u'transTypeCD', u'transDesc', u'transSum', u'transPct', u'pricePrinCD', u'payMode', u'transChangeCD']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'infoSource': 'str','infoSourceCD': 'str','relatedCom': 'str','relationshipCD': 'str','transTypeCD': 'str','transDesc': 'str','pricePrinCD': 'str','payMode': 'str','transChangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def IdxJYGet(secID = "", ticker = "", creatOrgCD = "", field = "", pandas = "1"):
    """
    获取国内外指数的基本要素信息，包括指数名称、指数代码、指数类型、发布机构、发布日期、基日、基点、加权方式等。
    
    :param secID: 指数展示代码,可通过指数代码和证券类型在DataAPI.JY.SecIDJYGet获取,可以是列表,可空
    :param ticker: 指数代码,如:000001 上海证券交易所综合指数,可以是列表,可空
    :param creatOrgCD: 编制机构编码,如:17764 上海证券交易所,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/listedCorp/getIdxJY.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&creatOrgCD=")
    if hasattr(creatOrgCD,'__iter__') and not isinstance(creatOrgCD, str):
        if len(creatOrgCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = creatOrgCD
            requestString.append(None)
        else:
            requestString.append(','.join(creatOrgCD))
    else:
        requestString.append(creatOrgCD)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1169)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1169)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'secShortName', u'ticker', u'indexPrepObj', u'consTypeCD', u'industryVersionCD', u'industryID', u'pubOrgCD', u'porgFullName', u'creatOrgCD', u'corgFullName', u'publishDate', u'baseDate', u'basePoint', u'wMethod', u'consNum', u'consAdPeriod', u'IndexDesc', u'endDate', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','secShortName': 'str','ticker': 'str','indexPrepObj': 'str','consTypeCD': 'str','industryVersionCD': 'str','industryID': 'str','porgFullName': 'str','corgFullName': 'str','wMethod': 'str','consAdPeriod': 'str','IndexDesc': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def IdxConsJYGet(secID = "", ticker = "", beginTime = "", endTime = "", isNew = "", secIDSrc = "", field = "", pandas = "1"):
    """
    获取国内外指数的成分构成情况，包括指数成分证券名称、成分证券代码、入选日期、剔除日期等。
    
    :param secID: 指数展示代码,可通过指数代码和证券类型在DataAPI.JY.SecIDJYGet获取,可以是列表,secID、ticker、beginTime、endTime至少选择一个
    :param ticker: 指数代码,如:000001 上海证券交易所综合指数,可以是列表,secID、ticker、beginTime、endTime至少选择一个
    :param beginTime: 输入数据更新时间的查询开始时间，输入格式YYYY-MM-DDTHH:MI:SS，如2016-01-01T00:00:00,secID、ticker、beginTime、endTime至少选择一个
    :param endTime: 输入数据更新时间的查询开始时间，输入格式YYYY-MM-DDTHH:MI:SS，如2016-01-01T00:00:00,secID、ticker、beginTime、endTime至少选择一个
    :param isNew: 是否最新:1 是;0 否,可以是列表,可空
    :param secIDSrc: 恒生聚源编制的证券唯一识别编码，支持多值输入,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/listedCorp/getIdxConsJY.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    if not isinstance(beginTime, str) and not isinstance(beginTime, unicode):
        beginTime = str(beginTime)

    requestString.append("&beginTime=%s"%(beginTime))
    if not isinstance(endTime, str) and not isinstance(endTime, unicode):
        endTime = str(endTime)

    requestString.append("&endTime=%s"%(endTime))
    requestString.append("&isNew=")
    if hasattr(isNew,'__iter__') and not isinstance(isNew, str):
        if len(isNew) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = isNew
            requestString.append(None)
        else:
            requestString.append(','.join(isNew))
    else:
        requestString.append(isNew)
    requestString.append("&secIDSrc=")
    if hasattr(secIDSrc,'__iter__') and not isinstance(secIDSrc, str):
        if len(secIDSrc) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secIDSrc
            requestString.append(None)
        else:
            requestString.append(','.join(secIDSrc))
    else:
        requestString.append(secIDSrc)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1171)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1171)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'secIDSrc', u'secShortName', u'secShortNameEn', u'ticker', u'consID', u'consShortName', u'consIDSrc', u'consShortNameEn', u'consticker', u'consExchangeCD', u'intoDate', u'outDate', u'isNew', u'updateTime', u'ID', u'JSID']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','secShortName': 'str','secShortNameEn': 'str','ticker': 'str','consID': 'str','consShortName': 'str','consShortNameEn': 'str','consticker': 'str','consExchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def IdxWeightJYGet(beginTime = "", endTime = "", secID = "", ticker = "", consID = "", consticker = "", secIDSrc = "", consExchangeCD = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取国内外指数的成分股权重信息，包括成分证券名称、成分证券代码、权重生效日、成分证券权重等。
    
    :param beginTime: 输入数据更新时间的查询开始时间，输入格式YYYY-MM-DDTHH:MI:SS，如2016-01-01T01:00:00,beginTime、endTime、secID、ticker至少选择一个
    :param endTime: 输入数据更新时间的查询截至时间，输入格式YYYY-MM-DDTHH:MI:SS，如2016-01-01T01:00:00,beginTime、endTime、secID、ticker至少选择一个
    :param secID: 指数展示代码,可通过指数代码和证券类型在DataAPI.JY.SecIDJYGet获取,可以是列表,beginTime、endTime、secID、ticker至少选择一个
    :param ticker: 指数代码,如:000001 上海证券交易所综合指数,可以是列表,beginTime、endTime、secID、ticker至少选择一个
    :param consID: 成分证券展示代码,如:601318.XSHG 中国平安保险(集团)股份有限公司,可以是列表,可空
    :param consticker: 成分证券代码,如:601318 中国平安保险(集团)股份有限公司,可以是列表,可空
    :param secIDSrc: 恒生聚源编制的证券唯一识别编码，支持多值输入,可以是列表,可空
    :param consExchangeCD: 成分证券市场代码,如:XSHG 上海证券交易所,可以是列表,可空
    :param beginDate: 开始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/listedCorp/getIdxWeightJY.csv?ispandas=1&') 
    if not isinstance(beginTime, str) and not isinstance(beginTime, unicode):
        beginTime = str(beginTime)

    requestString.append("beginTime=%s"%(beginTime))
    if not isinstance(endTime, str) and not isinstance(endTime, unicode):
        endTime = str(endTime)

    requestString.append("&endTime=%s"%(endTime))
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&consID=")
    if hasattr(consID,'__iter__') and not isinstance(consID, str):
        if len(consID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = consID
            requestString.append(None)
        else:
            requestString.append(','.join(consID))
    else:
        requestString.append(consID)
    requestString.append("&consticker=")
    if hasattr(consticker,'__iter__') and not isinstance(consticker, str):
        if len(consticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = consticker
            requestString.append(None)
        else:
            requestString.append(','.join(consticker))
    else:
        requestString.append(consticker)
    requestString.append("&secIDSrc=")
    if hasattr(secIDSrc,'__iter__') and not isinstance(secIDSrc, str):
        if len(secIDSrc) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secIDSrc
            requestString.append(None)
        else:
            requestString.append(','.join(secIDSrc))
    else:
        requestString.append(secIDSrc)
    requestString.append("&consExchangeCD=")
    if hasattr(consExchangeCD,'__iter__') and not isinstance(consExchangeCD, str):
        if len(consExchangeCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = consExchangeCD
            requestString.append(None)
        else:
            requestString.append(','.join(consExchangeCD))
    else:
        requestString.append(consExchangeCD)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1174)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1174)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secIDSrc', u'secID', u'secShortName', u'secShortNameEn', u'ticker', u'consID', u'consIDSrc', u'consShortName', u'consShortNameEn', u'consticker', u'consExchangeCD', u'infoSource', u'effDate', u'weight', u'updateTime', u'ID', u'JSID']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','secShortName': 'str','secShortNameEn': 'str','ticker': 'str','consID': 'str','consShortName': 'str','consShortNameEn': 'str','consticker': 'str','consExchangeCD': 'str','infoSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def IdxConsPrepJYGet(secID = "", ticker = "", consID = "", consticker = "", field = "", pandas = "1"):
    """
    获取主要指数的备询成分名单信息。
    
    :param secID: 指数展示代码,可通过指数代码和证券类型在DataAPI.JY.SecIDJYGet获取,可以是列表,secID、ticker至少选择一个
    :param ticker: 指数代码,如:000001 上海证券交易所综合指数,可以是列表,secID、ticker至少选择一个
    :param consID: 备选成分证券展示代码,如:000518.XSHE 江苏四环生物股份有限公司,可以是列表,可空
    :param consticker: 备选成分证券代码,如:000518 江苏四环生物股份有限公司,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/listedCorp/getIdxConsPrepJY.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&consID=")
    if hasattr(consID,'__iter__') and not isinstance(consID, str):
        if len(consID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = consID
            requestString.append(None)
        else:
            requestString.append(','.join(consID))
    else:
        requestString.append(consID)
    requestString.append("&consticker=")
    if hasattr(consticker,'__iter__') and not isinstance(consticker, str):
        if len(consticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = consticker
            requestString.append(None)
        else:
            requestString.append(','.join(consticker))
    else:
        requestString.append(consticker)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1182)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1182)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'secShortName', u'secShortNameEn', u'ticker', u'publishDate', u'effDate', u'prepSort', u'consID', u'consShortName', u'consShortNameEn', u'consticker', u'consExchangeCD', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','secShortName': 'str','secShortNameEn': 'str','ticker': 'str','consID': 'str','consShortName': 'str','consShortNameEn': 'str','consticker': 'str','consExchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def EquHdNumJYGet(SecID = "", ticker = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    反映公司全体股东、A股股东、B股东、H股东的持股情况及其历史变动情况等。
    
    :param SecID: 证券ID，可通过交易代码和交易市场在DataAPI.SecIDGet获取到。,可以是列表,SecID、ticker至少选择一个
    :param ticker: 交易代码,可以是列表,SecID、ticker至少选择一个
    :param beginDate: 查询开始日期，输入日期格式“YYYYMMDD”,可空
    :param endDate: 查询结束日期，输入日期格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/listedCorp/getEquHdNumJY.csv?ispandas=1&') 
    requestString.append("SecID=")
    if hasattr(SecID,'__iter__') and not isinstance(SecID, str):
        if len(SecID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = SecID
            requestString.append(None)
        else:
            requestString.append(','.join(SecID))
    else:
        requestString.append(SecID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1589)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1589)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'partyID', u'SecID', u'ticker', u'secShortName', u'publishDate', u'endDate', u'totalHolders', u'avgHoldShares', u'avgHoldProportion', u'proportionChange', u'AHolders', u'AAvgHoldShares', u'AAvgHoldProportion', u'AProportionChange', u'AFHolders', u'AFAvgHoldProportion', u'AFProportionChange', u'BHolders', u'BAvgHoldShares', u'BAvgHoldProportion', u'BProportionChange', u'HHolders', u'HAvgHoldShares', u'HAvgHoldProportion', u'HProportionChange']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'SecID': 'str','ticker': 'str','secShortName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def IssuanceExamJYGet(SecID = "", PartyID = "", field = "", pandas = "1"):
    """
    收录股票发行审核委员会历年来对各拟发行人的审核情况，包括审核会议召开日期、参会委员、是否通过等信息。
    
    :param SecID: 证券ID，可通过交易代码和交易市场在DataAPI.SecIDGet获取到。,可以是列表,可空
    :param PartyID: 机构ID，法人统一编码，可通过法人名称在DataAPI.PartyIDGet获取到。,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/listedCorp/getIssuanceExamJY.csv?ispandas=1&') 
    requestString.append("SecID=")
    if hasattr(SecID,'__iter__') and not isinstance(SecID, str):
        if len(SecID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = SecID
            requestString.append(None)
        else:
            requestString.append(','.join(SecID))
    else:
        requestString.append(SecID)
    requestString.append("&PartyID=")
    if hasattr(PartyID,'__iter__') and not isinstance(PartyID, str):
        if len(PartyID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = PartyID
            requestString.append(None)
        else:
            requestString.append(','.join(PartyID))
    else:
        requestString.append(PartyID)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'InitialInfoPublDate', u'InfoPublDate', u'InfoSource', u'Issuer', u'RegAddr', u'Province', u'ProvinceCode', u'BusinessMajor', u'CSRCIndustryNum', u'CSRCIndustryCode', u'MeetingNumber', u'ExaminationMeetingDate', u'PresentCommitteeman', u'ResultPublDate', u'IfPassed', u'PrecontractedDisclosureD', u'SecID', u'PartyID', u'RaisingMethod', u'RaisingMethodCode', u'SecuCategory', u'SecuCategoryCode', u'IssueShares', u'IssuePrice', u'TotalSharesBefore', u'TotalSharesAfter', u'PreparedListExchange', u'ListExchangeCode', u'Sponsor', u'EventDesc', u'IfImplemented', u'Remark']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'InfoSource': 'str','Issuer': 'str','RegAddr': 'str','Province': 'str','BusinessMajor': 'str','CSRCIndustryCode': 'str','PresentCommitteeman': 'str','SecID': 'str','RaisingMethod': 'str','SecuCategory': 'str','PreparedListExchange': 'str','Sponsor': 'str','EventDesc': 'str','Remark': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def IssueNListAgentJYGet(SecID = "", PartyID = "", field = "", pandas = "1"):
    """
    历次发行与上市聘请的所有中介结构包括主承销商、分销商、上市推荐人、国际协调人、会计师事务所、律师事务所、土地评估机构、收款银行等等。
    
    :param SecID: 证券ID，可通过交易代码和交易市场在DataAPI.SecIDGet获取到。,可以是列表,可空
    :param PartyID: 中介机构ID，法人统一编码，可通过法人名称在DataAPI.PartyIDGet获取到。,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/listedCorp/getIssueNListAgentJY.csv?ispandas=1&') 
    requestString.append("SecID=")
    if hasattr(SecID,'__iter__') and not isinstance(SecID, str):
        if len(SecID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = SecID
            requestString.append(None)
        else:
            requestString.append(','.join(SecID))
    else:
        requestString.append(SecID)
    requestString.append("&PartyID=")
    if hasattr(PartyID,'__iter__') and not isinstance(PartyID, str):
        if len(PartyID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = PartyID
            requestString.append(None)
        else:
            requestString.append(','.join(PartyID))
    else:
        requestString.append(PartyID)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'SecID', u'IssueAndListType', u'InitialInfoPublDate', u'AgentType', u'PartyID', u'FullName', u'AbbrName', u'LegalPersonRepr', u'Address', u'Code', u'Website', u'Email', u'Tel', u'Fax', u'Contactman', u'PersonInCharge', u'UnderwritingVol', u'UnderwritingSum', u'UnderwritingRatio', u'AgentData', u'Representative', u'IfEffected', u'CancelDate', u'Remark']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'SecID': 'str','FullName': 'str','AbbrName': 'str','LegalPersonRepr': 'str','Address': 'str','Code': 'str','Website': 'str','Email': 'str','Tel': 'str','Fax': 'str','Contactman': 'str','PersonInCharge': 'str','Representative': 'str','Remark': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def CapitalInvJYGet(SecID = "", PartyID = "", field = "", pandas = "1"):
    """
    公司自有资金、通过发行新股、增发新股、配股、发行可转债、发行企业债等方式所得募集资金的项目投资情况以及运用进展和改投状况.
    
    :param SecID: 证券ID，可通过交易代码和交易市场在DataAPI.SecIDGet获取到。,可以是列表,可空
    :param PartyID: 机构ID，法人统一编码，可通过法人名称在DataAPI.PartyIDGet获取到。,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/listedCorp/getCapitalInvJY.csv?ispandas=1&') 
    requestString.append("SecID=")
    if hasattr(SecID,'__iter__') and not isinstance(SecID, str):
        if len(SecID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = SecID
            requestString.append(None)
        else:
            requestString.append(','.join(SecID))
    else:
        requestString.append(SecID)
    requestString.append("&PartyID=")
    if hasattr(PartyID,'__iter__') and not isinstance(PartyID, str):
        if len(PartyID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = PartyID
            requestString.append(None)
        else:
            requestString.append(','.join(PartyID))
    else:
        requestString.append(PartyID)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'PartyID', u'InitialInfoPunlDate', u'InfoPublDate', u'InfoSource', u'RaisingMethod', u'InvestProject', u'ProjectStatement', u'PlannedSum', u'ActualInvestEndDate', u'ActualSum', u'Industry', u'InvestField', u'ProceedingStatement', u'IfSwitched', u'ProjectSwitchedTo', u'SumSwitched', u'SecID', u'PurchaseType', u'BookValue', u'AppraisalValue', u'PurchasePrice', u'EquityRatio', u'Transferor', u'Relationship', u'InvolvedStock', u'TransferorNature', u'TargetName', u'TargetNature', u'UpdateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'InfoSource': 'str','InvestProject': 'str','ProjectStatement': 'str','ProceedingStatement': 'str','ProjectSwitchedTo': 'str','SecID': 'str','Transferor': 'str','TargetName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def IPODeclarationJYGet(PartyID = "", field = "", pandas = "1"):
    """
    中国证监会公布的首次公开发行股票申报企业基本信息
    
    :param PartyID: 机构ID，法人统一编码，可通过法人名称在DataAPI.PartyIDGet获取到。,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/listedCorp/getIPODeclarationJY.csv?ispandas=1&') 
    requestString.append("PartyID=")
    if hasattr(PartyID,'__iter__') and not isinstance(PartyID, str):
        if len(PartyID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = PartyID
            requestString.append(None)
        else:
            requestString.append(','.join(PartyID))
    else:
        requestString.append(PartyID)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'PartyID', u'CompanyName', u'InfoSource', u'InfoPublDate', u'EndDate', u'PlateCode', u'RegPlaceCode', u'CSRCIndustryNum', u'CSRCIndustryCode', u'CSRCIndustryName', u'ListExchangeCode', u'SponsorName', u'SponsorRepresentative', u'AccountingFirm', u'SignatureAccountant', u'LawFirm', u'SignatureLaw', u'DeclareState', u'TerminationReviewDate']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'CompanyName': 'str','InfoSource': 'str','CSRCIndustryCode': 'str','CSRCIndustryName': 'str','SponsorName': 'str','SponsorRepresentative': 'str','AccountingFirm': 'str','SignatureAccountant': 'str','LawFirm': 'str','SignatureLaw': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def SHSubscriptionJYGet(SecID = "", field = "", pandas = "1"):
    """
    配股实施过程中大股东的认配状况，如全额实物认配、部分现金认配等等。
    
    :param SecID: 证券ID，可通过交易代码和交易市场在DataAPI.SecIDGet获取到。,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/listedCorp/getSHSubscriptionJY.csv?ispandas=1&') 
    requestString.append("SecID=")
    if hasattr(SecID,'__iter__') and not isinstance(SecID, str):
        if len(SecID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = SecID
            requestString.append(None)
        else:
            requestString.append(','.join(SecID))
    else:
        requestString.append(SecID)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'SecID', u'InitialInfoPublDate', u'SHSN', u'SHName', u'OughtShares', u'ActualShares']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'SecID': 'str','SHName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def LC7PercentChangeGet(secID = "", innerCode = "", ticker = "", tradingDay = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    沪深龙虎榜数据。可查询获取交易所公布的，触发日涨跌幅偏离值达到7％、日价格振幅达到15%、日换手率达到20％、连续三个交易日内收盘价格涨幅偏离值累计达到20%等各类披露条件的个股成交信息，包括个股总成交量、成交金额以及成交金额在前五名的营业部的成交明细等。
    
    :param secID: 证券ID（通联），通联编制，全商城证券唯一识别代码，可通过getsecID过去,可以是列表,secID、innerCode、ticker、tradingDay至少选择一个
    :param innerCode: 证券内部代码（聚源），恒生聚源编制，恒生聚源数据库证券唯一识别代码，可通过getsecIDJY获取,可以是列表,secID、innerCode、ticker、tradingDay至少选择一个
    :param ticker: 交易代码,可以是列表,secID、innerCode、ticker、tradingDay至少选择一个
    :param tradingDay: 交易日期,secID、innerCode、ticker、tradingDay至少选择一个
    :param beginDate: 查询开始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 查询结束日期，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/listedCorp/getLC7PercentChange.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&innerCode=")
    if hasattr(innerCode,'__iter__') and not isinstance(innerCode, str):
        if len(innerCode) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = innerCode
            requestString.append(None)
        else:
            requestString.append(','.join(innerCode))
    else:
        requestString.append(innerCode)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        tradingDay = tradingDay.strftime('%Y%m%d')
    except:
        tradingDay = tradingDay.replace('-', '')
    requestString.append("&tradingDay=%s"%(tradingDay))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1641)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1641)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'innerCode', u'ticker', u'secShortName', u'infoSource', u'tradingStartDate', u'tradingDay', u'turnoverVolume', u'turnoverValue', u'changePCT', u'changePCTOffset', u'fluctuatingAmptitude', u'turnoverRate', u'serialNum', u'salesDepartmentName', u'totalBuySaleSum', u'buySum', u'saleSum']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','infoSource': 'str','salesDepartmentName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def IRALeaderStockAlterGet(secID = "", ticker = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
     股东增减持数据，从2014年的第一个交易日开始，增减持2W股以上为一个增减持行为。 记录每个公司在每个交易日增减持行为。
    
    :param secID: 证券内部编码，可通过交易代码和交易市场在DataAPI.SecIDGet获取到。,可空
    :param ticker: 交易代码,可空
    :param beginDate: 查询开始日期，输入日期格式"YYYY-MM-DD",可空
    :param endDate: 查询截止日期，输入日期格式"YYYY-MM-DD",可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/listedCorp/getIRALeaderStockAlter.csv?ispandas=1&') 
    if not isinstance(secID, str) and not isinstance(secID, unicode):
        secID = str(secID)

    requestString.append("secID=%s"%(secID))
    if not isinstance(ticker, str) and not isinstance(ticker, unicode):
        ticker = str(ticker)

    requestString.append("&ticker=%s"%(ticker))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'tradeDate', u'sumShares', u'avgPrice', u'sumValue']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def RRPMainshFJYGet(PartyID, beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取公司十大流通股东历次变动记录，包括主要股东构成及持股数量比例、持股性质。
    
    :param PartyID: 机构ID，法人统一编码，可通过法人名称在DataAPI.PartyIDGet获取到。,可以是列表
    :param beginDate: 查询开始日期，输入日期格式“YYYYMMDD”,可空
    :param endDate: 查询结束日期，输入日期格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/listedCorp/getRRPMainshFJY.csv?ispandas=1&') 
    requestString.append("PartyID=")
    if hasattr(PartyID,'__iter__') and not isinstance(PartyID, str):
        if len(PartyID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = PartyID
            requestString.append(None)
        else:
            requestString.append(','.join(PartyID))
    else:
        requestString.append(PartyID)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'PartyID', u'endDate', u'InfoPublDate', u'SHNo', u'SHSerial', u'SHList', u'SHKind', u'SHType', u'holdSum', u'holdAShareSum', u'holdBShareSum', u'holdHShareSum', u'holdOthterShareSum', u'holdSumChange', u'holdSumChangeRate', u'restrainedTShare', u'unstintedTShare', u'PCTOfTotalShares', u'PCTOfFloatShares', u'shareCharacterStatement', u'pledgeInvolvedSum', u'freezeInvolvedSum', u'PFStatement', u'connectionRelation', u'connectionStatement', u'actInConcertStatement']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'SHList': 'str','SHKind': 'str','SHType': 'str','shareCharacterStatement': 'str','PFStatement': 'str','connectionRelation': 'str','connectionStatement': 'str','actInConcertStatement': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def RRPMainshJYGet(PartyID, beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取公司十大股东历次变动记录，包括主要股东构成及持股数量比例、持股性质。
    
    :param PartyID: 机构ID，法人统一编码，可通过法人名称在DataAPI.PartyIDGet获取到。,可以是列表
    :param beginDate: 查询开始日期，输入日期格式“YYYYMMDD”,可空
    :param endDate: 查询结束日期，输入日期格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/listedCorp/getRRPMainshJY.csv?ispandas=1&') 
    requestString.append("PartyID=")
    if hasattr(PartyID,'__iter__') and not isinstance(PartyID, str):
        if len(PartyID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = PartyID
            requestString.append(None)
        else:
            requestString.append(','.join(PartyID))
    else:
        requestString.append(PartyID)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'PartyID', u'endDate', u'InfoPublDate', u'SHNo', u'SHSerial', u'SHList', u'SHKind', u'SHType', u'holdSum', u'holdAShareSum', u'holdBShareSum', u'holdHShareSum', u'holdOthterShareSum', u'holdSumChange', u'holdSumChangeRate', u'restrainedTShare', u'unstintedTShare', u'PCTOfTotalShares', u'PCTOfFloatShares', u'shareCharacterStatement', u'pledgeInvolvedSum', u'freezeInvolvedSum', u'PFStatement', u'connectionRelation', u'connectionStatement', u'actInConcertStatement']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'SHList': 'str','SHKind': 'str','SHType': 'str','shareCharacterStatement': 'str','PFStatement': 'str','connectionRelation': 'str','connectionStatement': 'str','actInConcertStatement': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def EquShareFloatJYGet(SecID = "", tiker = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    收录上市公司因为股权分置改革、定向增发、公开增发等原因所限售的股票的具体解禁时间。
    
    :param SecID: 证券ID，可通过交易代码和交易市场在DataAPI.SecIDGet获取到。,可以是列表,SecID、tiker至少选择一个
    :param tiker: 交易代码,可以是列表,SecID、tiker至少选择一个
    :param beginDate: 查询流通起始日开始日期，输入日期格式“YYYYMMDD”,可空
    :param endDate: 查询流通起始日日期结束日期，输入日期格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/listedCorp/getEquShareFloatJY.csv?ispandas=1&') 
    requestString.append("SecID=")
    if hasattr(SecID,'__iter__') and not isinstance(SecID, str):
        if len(SecID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = SecID
            requestString.append(None)
        else:
            requestString.append(','.join(SecID))
    else:
        requestString.append(SecID)
    requestString.append("&tiker=")
    if hasattr(tiker,'__iter__') and not isinstance(tiker, str):
        if len(tiker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = tiker
            requestString.append(None)
        else:
            requestString.append(','.join(tiker))
    else:
        requestString.append(tiker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'SecID', u'tiker', u'startDateForFloating', u'newMarketableAShares', u'proportion1', u'accuMarketableAShares', u'nonMarketableAShares', u'totalAShares', u'proportion2', u'totalShares', u'newMarketableSharesSource', u'sourceType', u'changeReason']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'SecID': 'str','tiker': 'str','newMarketableSharesSource': 'str','changeReason': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def EquManagersInfoJYGet(PartyID, beginDate = "", endDate = "", ifIn = "", field = "", pandas = "1"):
    """
    包括所有在认和历任的领导人的简历介绍。
    
    :param PartyID: 机构ID，法人统一编码，可通过法人名称在DataAPI.PartyIDGet获取到。,可以是列表
    :param beginDate: 查询上任日期开始日期，输入日期格式“YYYYMMDD”,可空
    :param endDate: 查询上任日期结束日期，输入日期格式“YYYYMMDD”,可空
    :param ifIn: 在任与否， 1- 有 0-无,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/listedCorp/getEquManagersInfoJY.csv?ispandas=1&') 
    requestString.append("PartyID=")
    if hasattr(PartyID,'__iter__') and not isinstance(PartyID, str):
        if len(PartyID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = PartyID
            requestString.append(None)
        else:
            requestString.append(','.join(PartyID))
    else:
        requestString.append(PartyID)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    if not isinstance(ifIn, str) and not isinstance(ifIn, unicode):
        ifIn = str(ifIn)

    requestString.append("&ifIn=%s"%(ifIn))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'PartyID', u'infoPublDate', u'leaderName', u'position', u'leaderTitle', u'termNumIn', u'leaderGender', u'birthYM', u'leaderDegree', u'background', u'ifIn', u'inDate', u'offDate', u'concurrentPost']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'leaderName': 'str','background': 'str','concurrentPost': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def LcSpecialNoticeJYGet(beginTime = "", endTime = "", field = "", pandas = "1"):
    """
    公司发行上市、分红配股、公告停牌、临时停牌、召开股东大会、报告预约披露等等方面的当日提示、未来提示
    
    :param beginTime: 输入数据更新时间的查询开始时间，输入格式YYYY-MM-DDTHH:MI:SS，如2016-01-01T01:00:00,可空
    :param endTime: 输入数据更新时间的查询截至时间，输入格式YYYY-MM-DDTHH:MI:SS，如2016-01-01T01:00:00,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/listedCorp/getLcSpecialNoticeJY.csv?ispandas=1&') 
    if not isinstance(beginTime, str) and not isinstance(beginTime, unicode):
        beginTime = str(beginTime)

    requestString.append("beginTime=%s"%(beginTime))
    if not isinstance(endTime, str) and not isinstance(endTime, unicode):
        endTime = str(endTime)

    requestString.append("&endTime=%s"%(endTime))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1804)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1804)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'ID', u'innercode', u'noticeStartDate', u'noticeSndDate', u'noticeType', u'content', u'suspendTime', u'infoPublDate', u'bulletinType', u'bulletinSypeDame', u'eventType', u'eventSypeDame', u'categoryTevel1', u'categoryTevel2', u'updateTime', u'JSID']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'content': 'str','bulletinSypeDame': 'str','eventSypeDame': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def LCDividendJYGet(beginTime = "", endTime = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取上市公司A、B股历次分红预案及实施进展，以及下年分配次数、方式等。
    
    :param beginTime: 输入数据更新时间的查询开始时间，输入格式YYYY-MM-DDTHH:MI:SS，如2016-01-01T01:00:00,beginTime、endTime、beginDate、endDate至少选择一个
    :param endTime: 输入数据更新时间的查询截至时间，输入格式YYYY-MM-DDTHH:MI:SS，如2016-01-01T01:00:00,beginTime、endTime、beginDate、endDate至少选择一个
    :param beginDate: 截止日期查询开始时间，输入格式YYYYMMDD,beginTime、endTime、beginDate、endDate至少选择一个
    :param endDate: 截止日期查询结束时间，输入格式YYYYMMDD,beginTime、endTime、beginDate、endDate至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/listedCorp/getLCDividendJY.csv?ispandas=1&') 
    if not isinstance(beginTime, str) and not isinstance(beginTime, unicode):
        beginTime = str(beginTime)

    requestString.append("beginTime=%s"%(beginTime))
    if not isinstance(endTime, str) and not isinstance(endTime, unicode):
        endTime = str(endTime)

    requestString.append("&endTime=%s"%(endTime))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1808)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1808)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'ID', u'innerCode', u'endDate', u'eventProcedure', u'eventProcedureDesc', u'ifDividend', u'advanceDate', u'SMDeciPublDate', u'dividendImplementDate', u'EPS', u'bonusShareRatio', u'tranAddShareRaio', u'priceUnit', u'cashDiviRMB', u'actualCashDiviRMB', u'cashDiviFC', u'actualCashDiviFC', u'rightRegDate', u'exDiviDate', u'bonusShareListDate', u'toAccountDate', u'finalTradingDay', u'diviBase', u'sharesAfterDivi', u'diviObject', u'totalCashDiviComRMB', u'totalCashDiviComFC', u'cashDiviAShare', u'cashDiviBShareRMB', u'cashDiviBShareFC', u'diviStartDate', u'diviEndDate', u'iFSchemeChange', u'changeStatement', u'changeType', u'ifDiviBeforeChange', u'bonusShareRatioBeforeChange', u'tranAddShareRatioBeforeChange', u'cashDiviBeforeChangeRMB', u'cashDiviBeforeChangeFC', u'diviBaseBeforeChange', u'notes', u'undistributeStatement', u'distributeTimes', u'ceilingNext', u'floorNext', u'ceiling', u'floor', u'mainForm', u'cashDiviCeiling', u'cashDiviFloor', u'updateTime', u'JSID']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'eventProcedureDesc': 'str','changeStatement': 'str','notes': 'str','undistributeStatement': 'str','distributeTimes': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def LCExgIndustryJYGet(beginTime = "", endTime = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取上市公司在证监会行业划分、中信行业划分、GICS行业划分、申万行业划分、中信建投、中银(BOCI)行业分类、中证指数行业分类 、聚源行业划分等各种划分标准下的所属行业情况。
    
    :param beginTime: 输入数据更新时间的查询开始时间，输入格式YYYY-MM-DDTHH:MI:SS，如2016-01-01T01:00:00,beginTime、endTime、beginDate、endDate至少选择一个
    :param endTime: 输入数据更新时间的查询截至时间，输入格式YYYY-MM-DDTHH:MI:SS，如2016-01-01T01:00:00,beginTime、endTime、beginDate、endDate至少选择一个
    :param beginDate: 发布日期查询开始时间，输入格式YYYYMMDD,beginTime、endTime、beginDate、endDate至少选择一个
    :param endDate: 发布日期查询结束时间，输入格式YYYYMMDD,beginTime、endTime、beginDate、endDate至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/listedCorp/getLCExgIndustryJY.csv?ispandas=1&') 
    if not isinstance(beginTime, str) and not isinstance(beginTime, unicode):
        beginTime = str(beginTime)

    requestString.append("beginTime=%s"%(beginTime))
    if not isinstance(endTime, str) and not isinstance(endTime, unicode):
        endTime = str(endTime)

    requestString.append("&endTime=%s"%(endTime))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1809)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1809)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'ID', u'companyCode', u'infoPublDate', u'infoSource', u'standard', u'industry', u'ifPerformed', u'cancelDate', u'firstIndustryCode', u'firstIndustryName', u'secondIndustryCode', u'secondIndustryName', u'thirdIndustryCode', u'thirdIndustryName', u'fourthIndustryCode', u'fourthIndustryName', u'updateTime', u'JSID']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'infoSource': 'str','firstIndustryCode': 'str','firstIndustryName': 'str','secondIndustryCode': 'str','secondIndustryName': 'str','thirdIndustryCode': 'str','thirdIndustryName': 'str','fourthIndustryCode': 'str','fourthIndustryName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def LCMainSHListJYGet(beginTime = "", endTime = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    公司主要股东构成及持股数量比例、持股性质等明细资料，包括发行前和上市后的历次变动记录。
    
    :param beginTime: 输入数据更新时间的查询开始时间，输入格式YYYY-MM-DDTHH:MI:SS，如2016-01-01T01:00:00,beginTime、endTime、beginDate、endDate至少选择一个
    :param endTime: 输入数据更新时间的查询截至时间，输入格式YYYY-MM-DDTHH:MI:SS，如2016-01-01T01:00:00,beginTime、endTime、beginDate、endDate至少选择一个
    :param beginDate: 截止日期查询开始时间，输入格式YYYYMMDD,beginTime、endTime、beginDate、endDate至少选择一个
    :param endDate: 截止日期查询结束时间，输入格式YYYYMMDD,beginTime、endTime、beginDate、endDate至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/listedCorp/getLCMainSHListJY.csv?ispandas=1&') 
    if not isinstance(beginTime, str) and not isinstance(beginTime, unicode):
        beginTime = str(beginTime)

    requestString.append("beginTime=%s"%(beginTime))
    if not isinstance(endTime, str) and not isinstance(endTime, unicode):
        endTime = str(endTime)

    requestString.append("&endTime=%s"%(endTime))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1810)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1810)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'ID', u'companyCode', u'endDate', u'infoSource', u'infoTypeCode', u'infoPublDate', u'SHNo', u'SHSerial', u'SHList', u'SHKind', u'SHKindCode', u'SHTypeCode', u'SHType', u'secuCoBelongedCode', u'secuCoBelongedName', u'secuInnerCode', u'secuCode', u'secuAbbr', u'holdSum', u'holdAShareSum', u'holdBShareSum', u'holdHShareSum', u'holdOthterShareSum', u'holdSumChange', u'holdSumChangeRate', u'restrainedTShare', u'unstintedTShare', u'PCTOfTotalShares', u'PCTOfFloatShares', u'shareCharacterStatement', u'pledgeInvolvedSum', u'freezeInvolvedSum', u'PFStatement', u'connectionRelation', u'connectionStatement', u'actInConcertStatement', u'notes', u'updateTime', u'JSID']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'infoSource': 'str','SHList': 'str','SHKind': 'str','SHType': 'str','secuCoBelongedName': 'str','secuCode': 'str','secuAbbr': 'str','shareCharacterStatement': 'str','PFStatement': 'str','connectionRelation': 'str','connectionStatement': 'str','actInConcertStatement': 'str','notes': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def LCShareStruJYGet(beginTime = "", endTime = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取上市公司股本结构历史变动情况。
    
    :param beginTime: 输入数据更新时间的查询开始时间，输入格式YYYY-MM-DDTHH:MI:SS，如2016-01-01T01:00:00,beginTime、endTime、beginDate、endDate至少选择一个
    :param endTime: 输入数据更新时间的查询截至时间，输入格式YYYY-MM-DDTHH:MI:SS，如2016-01-01T01:00:00,beginTime、endTime、beginDate、endDate至少选择一个
    :param beginDate: 截止日期查询开始时间，输入格式YYYYMMDD,beginTime、endTime、beginDate、endDate至少选择一个
    :param endDate: 截止日期查询结束时间，输入格式YYYYMMDD,beginTime、endTime、beginDate、endDate至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/listedCorp/getLCShareStruJY.csv?ispandas=1&') 
    if not isinstance(beginTime, str) and not isinstance(beginTime, unicode):
        beginTime = str(beginTime)

    requestString.append("beginTime=%s"%(beginTime))
    if not isinstance(endTime, str) and not isinstance(endTime, unicode):
        endTime = str(endTime)

    requestString.append("&endTime=%s"%(endTime))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1811)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1811)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'ID', u'companyCode', u'endDate', u'infoPublDate', u'infoSource', u'perValue', u'totalShares', u'Ashares', u'AFloats', u'restrictedAShares', u'nonRestrictedShares', u'nonListedShares', u'bsharesTotal', u'listedBShares', u'nonListedRestrictedBShares', u'hshares', u'otherFloatShares', u'Sshares', u'Nshares', u'restrictedShares', u'stateHolding', u'SLegalPersonHolding', u'otherDCapitalHolding', u'DLegalPersonHolding', u'DNaturalPersonHolding', u'managementShares', u'foreignHolding', u'FLegalPersonHolding', u'FNaturalPersonHolding', u'otherRestrictedShares', u'promoterShares', u'stateShares', u'SLegalPersonShares', u'DLegalPersonShares', u'FLegalPersonShares', u'otherPromoterShares', u'raisedLPShares', u'raisedSLPShares', u'naturalPersonHoldLPShares', u'staffShares', u'rightsIssueTransferred', u'preferredAndOtherShares', u'preferredShares', u'otherFNonListedShares', u'floatShare', u'AFloatListed', u'stategicInvestorShares', u'commonLPShares', u'mutualFundShares', u'additionalIssueUnlisted', u'rightsIssueUnlisted', u'otherAFloatShares', u'restrictedAFloatShares', u'restrinctStaffShares', u'bshares', u'nonListedBShares', u'restrictedBFloatShares', u'foreignHoldingAshares', u'changeType', u'changeReason', u'updateTime', u'JSID']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'infoSource': 'str','changeReason': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def LCStockHoldingGet(secID = "", ticker = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取每个报告期末，各类机构投资者对每只股票的持仓情况，以及前十大（无限售条件)股东合计持股情况等。
    
    :param secID: 通联数据编制的证券唯一识别编码，支持多值输入,可以是列表,secID、ticker、beginDate、endDate至少选择一个
    :param ticker: 通常记录的是证券交易代码；支持多值输入,可以是列表,secID、ticker、beginDate、endDate至少选择一个
    :param beginDate: 截止日期查询开始时间，输入格式YYYYMMDD,secID、ticker、beginDate、endDate至少选择一个
    :param endDate: 截止日期查询结束时间，输入格式YYYYMMDD,secID、ticker、beginDate、endDate至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/listedCorp/getLCStockHolding.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1812)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1812)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'endDate', u'institutionsHoldings', u'fundsHoldings', u'securitiesCorpsHoldings', u'financingProductsHoldings', u'QFIIHoldings', u'insuranceCorpsHoldings', u'socialSecurityFundHold', u'enterpriseAnnuitiesHold', u'trustCompaniesHoldings', u'financeCompaniesHoldings', u'otherInstitutionHoldings', u'institutionsHoldProp', u'fundsHoldProp', u'securitiesCorpsHoldProp', u'financingProductsHoldProp', u'QFIIHoldProp', u'insuranceCorpsHoldProp', u'socialSecuFundHoldProp', u'corpAnnuitiesHoldProp', u'trustCompaniesHoldProp', u'financeCompaniesHoldProp', u'otherInstitutionHoldProp', u'institutionsHoldingsA', u'fundsHoldingsA', u'securitiesCorpsHoldingsA', u'financeProductsHoldingsA', u'QFIIHoldingsA', u'insuranceCorpsHoldingsA', u'socialSecurityFundHoldA', u'enterpriseAnnuitiesHoldA', u'trustCompaniesHoldingsA', u'financeCompHoldingsA', u'otherInstiHoldingsA', u'institutionsHoldPropA', u'fundsHoldPropA', u'securitiesCorpsHoldPropA', u'financeProductsHoldPropA', u'QFIIHoldPropA', u'insuranceCorpsHoldPropA', u'socialSecuFundHoldPropA', u'corpAnnuitiesHoldPropA', u'trustCompaniesHoldPropA', u'financeCompHoldPropA', u'otherInstiHoldPropA', u'institutionsHoldingsT', u'fundsHoldingsT', u'securitiesCorpsHoldingsT', u'financeProductsHoldingsT', u'qFIIHoldingsT', u'insuranceCorpsHoldingsT', u'socialSecurityFundHoldT', u'enterpriseAnnuitiesHoldT', u'trustCompaniesHoldingsT', u'financeCompHoldingsT', u'otherInstiHoldingsT', u'institutionsHoldPropT', u'fundsHoldPropT', u'securitiesCorpsHoldPropT', u'financeProductsHoldPropT', u'qFIIHoldPropT', u'insuranceCorpsHoldPropT', u'socialSecuFundHoldPropT', u'corpAnnuitiesHoldPropT', u'trustCompaniesHoldPropT', u'financeCompHoldPropT', u'otherInstiHoldPropT', u'top10StockholdersAmount', u'top10StockholdersProp', u'top10NRStockholdersAmount', u'top10NRHoldersAmountToNRS', u'top10NRHoldersAmountToTS', u'nRAFromTop10NRHolders', u'nRAFromTop10ToNRA']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def LCASharePlacementJYGet(beginTime = "", endTime = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    A股历次配股预案及实施进展明细
    
    :param beginTime: 输入数据更新时间的查询开始时间，输入格式YYYY-MM-DDTHH:MI:SS，如2016-01-01T01:00:00,beginTime、endTime、beginDate、endDate至少选择一个
    :param endTime: 输入数据更新时间的查询截至时间，输入格式YYYY-MM-DDTHH:MI:SS，如2016-01-01T01:00:00,beginTime、endTime、beginDate、endDate至少选择一个
    :param beginDate: 配股年度查询开始时间，输入格式YYYYMMDD,beginTime、endTime、beginDate、endDate至少选择一个
    :param endDate: 配股年度查询结束时间，输入格式YYYYMMDD,beginTime、endTime、beginDate、endDate至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/listedCorp/getLCASharePlacementJY.csv?ispandas=1&') 
    if not isinstance(beginTime, str) and not isinstance(beginTime, unicode):
        beginTime = str(beginTime)

    requestString.append("beginTime=%s"%(beginTime))
    if not isinstance(endTime, str) and not isinstance(endTime, unicode):
        endTime = str(endTime)

    requestString.append("&endTime=%s"%(endTime))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1817)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1817)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'ID', u'innerCode', u'initialInfoPublDate', u'plaYear', u'stockType', u'advanceDate', u'SMDeciPublDate', u'pricingModel', u'pricingDescription', u'advanceValidStartDate', u'advanceValidEndDate', u'plaRatioPlanned', u'plaPriceCeiling', u'plaPriceFloor', u'deciPublDate', u'plaProspectusPublDate', u'plaAbbrName', u'plaCode', u'baseShares', u'plannedPlaVol', u'actualPlaRatio', u'actualPlaVol', u'plaObject', u'parValue', u'plaPrice', u'transferPlaRatio', u'transferPlaVol', u'transferFeePerShare', u'oddLotsTreatment', u'plannedPlaProceeds', u'plaProceeds', u'plaCost', u'underwritingFee', u'CPAFee', u'assetAppraisalFee', u'landEvaluationFee', u'attorneyFee', u'totalAgentFee', u'onlineIssueFee', u'scripFee', u'sponsorFee', u'otherFee', u'plaNetProceeds', u'rightRegDate', u'exRightDate', u'payStartDate', u'payEndDate', u'dateToAccount', u'moneyToAccount', u'plaListDate', u'largeSHSubsStatement', u'schemeChange', u'changeStatement', u'underwritingMode', u'underwriterBoughtVol', u'publicSHSubscriptionEsti', u'publicSHSubscriptionActu', u'updateTime', u'JSID']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'pricingDescription': 'str','plaAbbrName': 'str','plaCode': 'str','plaObject': 'str','largeSHSubsStatement': 'str','changeStatement': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def LCIndexComponentJYGet(beginTime = "", endTime = "", flag = "", indexInnerCode = "", secuInnerCode = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取国内外指数的成分构成情况，包括指数成分证券名称、成分证券代码、入选日期、剔除日期等。
    
    :param beginTime: 输入数据更新时间的查询开始时间，输入格式YYYY-MM-DDTHH:MI:SS，如2016-01-01T00:00:00,可空
    :param endTime: 输入数据更新时间的查询截至时间，输入格式YYYY-MM-DDTHH:MI:SS，如2016-01-01T00:00:00,可空
    :param flag: 是否最新:1 是;0 否,可以是列表,可空
    :param indexInnerCode: 恒生聚源编制的证券唯一识别编码，支持多值输入,可以是列表,可空
    :param secuInnerCode: 恒生聚源编制的证券唯一识别编码，支持多值输入,可以是列表,可空
    :param beginDate: 开始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/listedCorp/getLCIndexComponentJY.csv?ispandas=1&') 
    if not isinstance(beginTime, str) and not isinstance(beginTime, unicode):
        beginTime = str(beginTime)

    requestString.append("beginTime=%s"%(beginTime))
    if not isinstance(endTime, str) and not isinstance(endTime, unicode):
        endTime = str(endTime)

    requestString.append("&endTime=%s"%(endTime))
    requestString.append("&flag=")
    if hasattr(flag,'__iter__') and not isinstance(flag, str):
        if len(flag) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = flag
            requestString.append(None)
        else:
            requestString.append(','.join(flag))
    else:
        requestString.append(flag)
    requestString.append("&indexInnerCode=")
    if hasattr(indexInnerCode,'__iter__') and not isinstance(indexInnerCode, str):
        if len(indexInnerCode) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indexInnerCode
            requestString.append(None)
        else:
            requestString.append(','.join(indexInnerCode))
    else:
        requestString.append(indexInnerCode)
    requestString.append("&secuInnerCode=")
    if hasattr(secuInnerCode,'__iter__') and not isinstance(secuInnerCode, str):
        if len(secuInnerCode) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secuInnerCode
            requestString.append(None)
        else:
            requestString.append(','.join(secuInnerCode))
    else:
        requestString.append(secuInnerCode)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1826)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1826)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'ID', u'indexInnerCode', u'secuInnerCode', u'secuMarket', u'inDate', u'outDate', u'flag', u'updateTime', u'JSID']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def LCIndexComponentsWeightJYGet(beginTime = "", endTime = "", startDate = "", endDate = "", indexCode = "", innerCode = "", field = "", pandas = "1"):
    """
    获取国内外指数的成分股权重信息，包括成分证券名称、成分证券代码、权重生效日、成分证券权重等。
    
    :param beginTime: 输入数据更新时间的查询开始时间，输入格式YYYY-MM-DDTHH:MI:SS，如2016-01-01T00:00:00,可空
    :param endTime: 输入数据更新时间的查询截至时间，输入格式YYYY-MM-DDTHH:MI:SS，如2016-01-01T00:00:00,可空
    :param startDate: 开始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，输入格式“YYYYMMDD”,可空
    :param indexCode: 恒生聚源编制的证券唯一识别编码，支持多值输入,可以是列表,可空
    :param innerCode: 恒生聚源编制的证券唯一识别编码，支持多值输入,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/listedCorp/getLCIndexComponentsWeightJY.csv?ispandas=1&') 
    if not isinstance(beginTime, str) and not isinstance(beginTime, unicode):
        beginTime = str(beginTime)

    requestString.append("beginTime=%s"%(beginTime))
    if not isinstance(endTime, str) and not isinstance(endTime, unicode):
        endTime = str(endTime)

    requestString.append("&endTime=%s"%(endTime))
    try:
        startDate = startDate.strftime('%Y%m%d')
    except:
        startDate = startDate.replace('-', '')
    requestString.append("&startDate=%s"%(startDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&indexCode=")
    if hasattr(indexCode,'__iter__') and not isinstance(indexCode, str):
        if len(indexCode) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indexCode
            requestString.append(None)
        else:
            requestString.append(','.join(indexCode))
    else:
        requestString.append(indexCode)
    requestString.append("&innerCode=")
    if hasattr(innerCode,'__iter__') and not isinstance(innerCode, str):
        if len(innerCode) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = innerCode
            requestString.append(None)
        else:
            requestString.append(','.join(innerCode))
    else:
        requestString.append(innerCode)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1827)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1827)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'ID', u'indexCode', u'innerCode', u'infoSource', u'endDate', u'weight', u'updateTime', u'JSID']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'infoSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktNpFundJYGet(secID, field = "", pandas = "1"):
    """
    展示在交易所交易的封闭式基金、LOF等，从最近一个交易日往前追溯一段时期的行情表现信息，包括当日、近1周、近1月、近1年的表现情况。本表中，“日表现”中的价格为未复权价格；“近一周表现”、“近一月表现”、  “近一年表现”等区间表现中涉及的价格均为后复权价格，涉及的价格对应日期均为后复权价格对应日期。
    
    :param secID: 证券内部编码，一串流水号,可先通过DataAPI.SecIDGet获取到，如在DataAPI.SecIDGet，选择证券类型为'F',输入'184701'，可获取到secID'184701.XSHE'后，在此输入'184701.XSHE'
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fund/getMktNpFundJY.csv?ispandas=1&') 
    if not isinstance(secID, str) and not isinstance(secID, unicode):
        secID = str(secID)

    requestString.append("secID=%s"%(secID))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 194)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 194)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'secShortNameEN', u'exchangeCD', u'tradeDate', u'preClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'turnovervalue', u'chg', u'chgPct', u'rangePct', u'turnoverRate', u'avgPrice', u'discount', u'discountRatio', u'preClosePriceRW', u'openPriceRW', u'highPriceRW', u'lowPriceRW', u'closePriceRW', u'highestClosePriceRW', u'lowestClosePrice RW', u'avgPriceRW', u'chgRW', u'chgPctRW', u'turnoverRateRW', u'avgTurnoverRateRW', u'rangePctRW', u'turnoverValueRW', u'turnoverVolRW', u'discountRW', u'discountRatioRW', u'dayHighRW', u'dayLowRW', u'dateHcpRW', u'dateLcpRW', u'relChgPctRW', u'preClosePriceRM', u'openPriceRM', u'highPriceRM', u'lowPriceRM', u'closePriceRM', u'highestClosePriceRM', u'lowestClosePrice RM', u'avgPriceRM', u'chgRM', u'chgPctRM', u'turnoverRateRM', u'avgTurnoverRateRM', u'rangePctRM', u'turnoverValueRM', u'turnoverVolRM', u'discountRM', u'discountRatioRM', u'dayHighRM', u'dayLowRM', u'dateHcpRM', u'dateLcpRM', u'relChgPctRM', u'preClosePriceRY', u'openPriceRY', u'highPriceRY', u'lowPriceRY', u'closePriceRY', u'highestClosePriceRY', u'lowestClosePrice RY', u'avgPriceRY', u'chgRY', u'chgPctRY', u'turnoverRateRY', u'avgTurnoverRateRY', u'rangePctRY', u'turnoverValueRY', u'turnoverVolRY', u'discountRY', u'discountRatioRY', u'dayHighRY', u'dayLowRY', u'dateHcpRY', u'dateLcpRY', u'relChgPctRY']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','secShortNameEN': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FundJYGet(secID = "", ticker = "", field = "", pandas = "1"):
    """
    获取基金的基本概况，包含基金名称、交易代码、基金分类、投资目标、投资范围、业绩比较基准、成立日期、设立规模、基金经理、基金管理人、基金托管人等信息。数据更新频率为不定期。
    
    :param secID: 证券内部编码，可通过交易代码和交易市场在DataAPI.SecIDGet获取到。,可以是列表,可空
    :param ticker: 输入一个或多个基金代码，用","分隔，如"000001"、"000001,000003",可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fund/getFundJY.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1109)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1109)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'exchangeCD', u'secShortName', u'subscriptionCodeFront', u'subscriptionCodeBack', u'exchangeTicker', u'category', u'category_desc', u'operationMode', u'isQdii', u'investTypeCD', u'investStyleCD', u'invest_field', u'invest_scope', u'invest_target', u'perf_benchmark', u'riskReturnCharacter', u'profitDistributionRule', u'fundProfile', u'foundedSize', u'establishDate', u'list_date', u'duration', u'startDate', u'expireDate', u'guarPeriod', u'convertDate', u'convertDate_desc', u'profitDistributionCD', u'manager', u'managementCompany', u'custodian', u'transferAgent', u'guarAgency', u'lowestPurchaseDesc', u'lowestRedemption', u'lowestRedemptionDesc', u'lowestHoldingShare', u'lowestHoldingDesc', u'moneyReceiptDays']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','exchangeCD': 'str','secShortName': 'str','subscriptionCodeFront': 'str','subscriptionCodeBack': 'str','exchangeTicker': 'str','category': 'str','category_desc': 'str','operationMode': 'str','investTypeCD': 'str','investStyleCD': 'str','invest_field': 'str','invest_scope': 'str','invest_target': 'str','perf_benchmark': 'str','riskReturnCharacter': 'str','profitDistributionRule': 'str','fundProfile': 'str','convertDate_desc': 'str','profitDistributionCD': 'str','manager': 'str','managementCompany': 'str','custodian': 'str','transferAgent': 'str','guarAgency': 'str','lowestPurchaseDesc': 'str','lowestRedemptionDesc': 'str','lowestHoldingDesc': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FundNavJYGet(secID = "", ticker = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取某只基金历史净值数据或某只货币型、短期理财债券型基金的历史收益数据，包含单位净值、累计净值、每万份基金单位当日收益、七日年化收益率等信息。收录了1998年以来的历史数据，数据更新频率为日。不输入日期则默认获取近一年以来的历史数据。注：净值日增长率、周增长率、封基升贴水率以小数形式（非百分数）提供。
    
    :param secID: 输入单个证券内部编码，可通过交易代码和交易市场在DataAPI.SecIDGet获取到。,secID、ticker至少选择一个
    :param ticker: 输入单个基金代码，如"000001"。,secID、ticker至少选择一个
    :param beginDate: 起始日期，输入格式为“YYYYMMDD”，不输则默认为一年前当日。,可空
    :param endDate: 截止日期,输入格式为“YYYYMMDD”，不输则默认为当日。,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fund/getFundNavJY.csv?ispandas=1&') 
    if not isinstance(secID, str) and not isinstance(secID, unicode):
        secID = str(secID)

    requestString.append("secID=%s"%(secID))
    if not isinstance(ticker, str) and not isinstance(ticker, unicode):
        ticker = str(ticker)

    requestString.append("&ticker=%s"%(ticker))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 178)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 178)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'exchangeCD', u'secShortName', u'publishDate', u'infoSource', u'endDate', u'nav', u'accumNav', u'dailyProfit', u'weeklyYield', u'netAssets', u'navDailyGr', u'navWeeklyGr', u'discountRate']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','exchangeCD': 'str','secShortName': 'str','infoSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FundDividendJYGet(secID = "", ticker = "", field = "", pandas = "1"):
    """
    获取基金历史分红信息，包含基金的单位分红、累计分红、权益登记日、除息日、分红在投资日、红利发放日等信息。收录了1999年以来的历史数据，数据更新频率为不定期。
    
    :param secID: 证券内部编码，可通过交易代码和交易市场在DataAPI.SecIDGet获取到。,可以是列表,secID、ticker至少选择一个
    :param ticker: 输入一个或多个基金代码，用","分隔，如"000001"、"000001,000003"。,可以是列表,secID、ticker至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fund/getFundDividendJY.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1110)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1110)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'exchangeCD', u'secShortName', u'publishDate', u'infoSource', u'endDate', u'ifDividend', u'dividendBfTax', u'dividendAfTax', u'dividendSum', u'regDate', u'exDivDate', u'exDivDateField', u'exDivDateOTC', u'reinvestDate', u'reinvAcctDate', u'reinvRedemDate', u'paymentDate', u'paymentDateField', u'paymentDateOTC', u'unitProfit', u'unitRetainedProfit', u'planChgDesc', u'unitDivYTD', u'divYTD', u'divTimesYTD', u'totalDiv', u'totalDivTimes', u'eventProcessCD', u'eventProcessDesc']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','exchangeCD': 'str','secShortName': 'str','infoSource': 'str','planChgDesc': 'str','eventProcessCD': 'str','eventProcessDesc': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FundSplitJYGet(secID = "", ticker = "", field = "", pandas = "1"):
    """
    获取基金历史拆分折算信息，包含基金的拆分折算日、折算比例、份额变更登记日等信息。收录了2005年以来的历史数据，数据更新频率为不定期。
    
    :param secID: 证券内部编码，可通过交易代码和交易市场在DataAPI.SecIDGet获取到。,可以是列表,secID、ticker至少选择一个
    :param ticker: 输入一个或多个基金代码，用","分隔，如"000001"、"000001,000003"。,可以是列表,secID、ticker至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fund/getFundSplitJY.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1112)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1112)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'exchangeCD', u'secShortName', u'publishDate', u'infoSource', u'splitDate', u'splitRatio', u'resultOutcomeDate', u'chgRegDate', u'netAsset', u'sharesBf', u'sharesAf', u'navBf', u'navAf', u'accumNavBf', u'accumNavAf', u'splitTypeCD']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','exchangeCD': 'str','secShortName': 'str','infoSource': 'str','splitTypeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FundAssetsJYGet(secID = "", ticker = "", endDate = "", beginDate = "", field = "", pandas = "1"):
    """
    获取非QDII基金的资产配置历史数据，包含定期报告中披露的各种资产类别及占比情况。收录了1998年12月以来的历史数据，数据更新频率为季度。不输入日期则默认获取近一年以来的历史数据。
    
    :param secID: 证券内部编码，可通过交易代码和交易市场在DataAPI.SecIDGet获取到。,可以是列表,secID、ticker至少选择一个
    :param ticker: 输入一个或多个基金代码，用","分隔，如"000001"、"000001,000003"。,可以是列表,secID、ticker至少选择一个
    :param endDate: 报告截止日期，输入"YYYYMMDD"格式。不输入则默认输出最近一年相关数据。,可空
    :param beginDate: 报告起始日期，输入"YYYYMMDD"格式。不输入则默认输出最近一年相关数据。,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fund/getFundAssetsJY.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1114)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1114)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'exchangeCD', u'secShortName', u'publishDate', u'reportDate', u'assetTypeCD', u'assetTypeDecs', u'marketValue', u'ratioInTA', u'ratioInNA']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','exchangeCD': 'str','secShortName': 'str','assetTypeCD': 'str','assetTypeDecs': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FundAssetsQDIIJYGet(secID = "", ticker = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取QDII基金的资产配置历史数据，包含定期报告中披露的各种资产类别及占比情况。收录了2007年12月以来的历史数据，数据更新频率为季度。不输入日期则默认获取近一年以来的历史数据。
    
    :param secID: 证券内部编码，可通过交易代码和交易市场在DataAPI.SecIDGet获取到。,可以是列表,secID、ticker至少选择一个
    :param ticker: 输入一个或多个基金代码，用","分隔，如"000001"、"000001,000003"。,可以是列表,secID、ticker至少选择一个
    :param beginDate: 报告起始日期，输入"YYYYMMDD"格式。不输入则默认输出最近一年相关数据。,可空
    :param endDate: 报告截止日期，输入"YYYYMMDD"格式。不输入则默认输出最近一年相关数据。,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fund/getFundAssetsQDIIJY.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1115)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1115)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'exchangeCD', u'secShortName', u'publishDate', u'reportDate', u'assetTypeCD', u'assetTypeDecs', u'marketValue', u'ratioInTA', u'ratioInNA']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','exchangeCD': 'str','secShortName': 'str','assetTypeCD': 'str','assetTypeDecs': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FundHoldingsEJYGet(secID = "", ticker = "", equitySecID = "", equityTicker = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取基金所投资的股票组合的历史数据，包含定期报告中披露的股票组合明细，包括主动投资与被动投资等相关数据。收录了2000年以来的历史数据，数据更新频率为每半年更新一次。不输入日期则默认获取近一年以来的历史数据。
    
    :param secID: 证券内部编码，可通过交易代码和交易市场在DataAPI.SecIDGet获取到。,可以是列表,secID、ticker、equitySecID、equityTicker至少选择一个
    :param ticker: 输入一个或多个基金代码，用","分隔，如"000001"、"000001,000003"。,可以是列表,secID、ticker、equitySecID、equityTicker至少选择一个
    :param equitySecID: 证券内部编码，可通过交易代码和交易市场在DataAPI.SecIDGet（证券编码及基本上市信息）获取到。,可以是列表,secID、ticker、equitySecID、equityTicker至少选择一个
    :param equityTicker: 股票交易代码,可以是列表,secID、ticker、equitySecID、equityTicker至少选择一个
    :param beginDate: 报告起始日期，输入"YYYYMMDD"格式。不输入则默认输出最近一年相关数据。,可空
    :param endDate: 报告截止日期，输入"YYYYMMDD"格式。不输入则默认输出最近一年相关数据。,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fund/getFundHoldingsEJY.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&equitySecID=")
    if hasattr(equitySecID,'__iter__') and not isinstance(equitySecID, str):
        if len(equitySecID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = equitySecID
            requestString.append(None)
        else:
            requestString.append(','.join(equitySecID))
    else:
        requestString.append(equitySecID)
    requestString.append("&equityTicker=")
    if hasattr(equityTicker,'__iter__') and not isinstance(equityTicker, str):
        if len(equityTicker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = equityTicker
            requestString.append(None)
        else:
            requestString.append(','.join(equityTicker))
    else:
        requestString.append(equityTicker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1116)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1116)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'exchangeCD', u'secShortName', u'publishDate', u'reportDate', u'investTypeCD', u'serialNumber', u'equitySecID', u'equityTicker', u'equityExchangeCD', u'equityShortName', u'holdVolume', u'marketValue', u'ratioInNA']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','exchangeCD': 'str','secShortName': 'str','investTypeCD': 'str','equitySecID': 'str','equityTicker': 'str','equityExchangeCD': 'str','equityShortName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FundHoldingsBJYGet(secID = "", ticker = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取基金所投资的债券组合的历史数据，包含定期报告中披露的债券组合明细。收录了2000年以来的历史数据，数据更新频率为季度。不输入日期则默认获取近一年以来的历史数据。
    
    :param secID: 证券内部编码，可通过交易代码和交易市场在DataAPI.SecIDGet获取到。,可以是列表,secID、ticker至少选择一个
    :param ticker: 输入一个或多个基金代码，用","分隔，如"000001"、"000001,000003"。,可以是列表,secID、ticker至少选择一个
    :param beginDate: 报告起始日期，输入"YYYYMMDD"格式。不输入则默认输出最近一年相关数据。,可空
    :param endDate: 报告截止日期，输入"YYYYMMDD"格式。不输入则默认输出最近一年相关数据。,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fund/getFundHoldingsBJY.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1117)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1117)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'exchangeCD', u'secShortName', u'publishDate', u'reportDate', u'serialNumber', u'bondSecID', u'bondTicker', u'bondExchangeCD', u'bondShortName', u'holdVolume', u'marketValue', u'ratioInNA', u'isConvertible']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','exchangeCD': 'str','secShortName': 'str','bondSecID': 'str','bondTicker': 'str','bondExchangeCD': 'str','bondShortName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FundHoldingsFJYGet(secID = "", ticker = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取基金所投资的目标基金的历史数据，包含ETF联接基金、FOF基金定期报告中披露的相关数据。收录了2009年以来的历史数据，数据更新频率为季度。不输入日期则默认获取近一年以来的历史数据。
    
    :param secID: 证券内部编码，可通过交易代码和交易市场在DataAPI.SecIDGet获取到。,可以是列表,secID、ticker至少选择一个
    :param ticker: 输入一个或多个基金代码，用","分隔，如"000001"、"000001,000003"。,可以是列表,secID、ticker至少选择一个
    :param beginDate: 报告起始日期，输入"YYYYMMDD"格式。不输入则默认输出最近一年相关数据。,可空
    :param endDate: 报告截止日期，输入"YYYYMMDD"格式。不输入则默认输出最近一年相关数据。,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fund/getFundHoldingsFJY.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1118)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1118)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'exchangeCD', u'secShortName', u'publishDate', u'reportDate', u'serialNumber', u'holdFundSecID', u'holdFundTicker', u'holdFundExchangeCD', u'holdFundShortName', u'holdVolume', u'marketValue', u'ratioInNA']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','exchangeCD': 'str','secShortName': 'str','holdFundSecID': 'str','holdFundTicker': 'str','holdFundExchangeCD': 'str','holdFundShortName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FundRelationJYGet(secID = "", ticker = "", field = "", pandas = "1"):
    """
    获取同一基金的分级关联代码、复制型基金的关联代码、封转开基金代码对应关系、基金与其收益线对应关系等信息。数据更新频率为不定期。
    
    :param secID: 输入单个证券内部编码，可通过交易代码和交易市场在DataAPI.SecIDGet获取到。,secID、ticker至少选择一个
    :param ticker: 输入单个基金代码，如"000001"。,secID、ticker至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fund/getFundRelationJY.csv?ispandas=1&') 
    if not isinstance(secID, str) and not isinstance(secID, unicode):
        secID = str(secID)

    requestString.append("secID=%s"%(secID))
    if not isinstance(ticker, str) and not isinstance(ticker, unicode):
        ticker = str(ticker)

    requestString.append("&ticker=%s"%(ticker))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1119)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1119)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'exchangeCD', u'secShortName', u'relationCD', u'RSecID', u'RTicker', u'RExchangeCD', u'RSecShortName']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','exchangeCD': 'str','secShortName': 'str','relationCD': 'str','RSecID': 'str','RTicker': 'str','RExchangeCD': 'str','RSecShortName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FundRelationFeederAndETFJYGet(SecID = "", ticker = "", field = "", pandas = "1"):
    """
    获取联接基金与目标ETF的代码关系。数据更新频率为不定期。
    
    :param SecID: 输入单个证券内部编码，可通过交易代码和交易市场在DataAPI.SecIDGet获取到。,SecID、ticker至少选择一个
    :param ticker: 输入单个基金代码，如"000001"。,SecID、ticker至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fund/getFundRelationFeederAndETFJY.csv?ispandas=1&') 
    if not isinstance(SecID, str) and not isinstance(SecID, unicode):
        SecID = str(SecID)

    requestString.append("SecID=%s"%(SecID))
    if not isinstance(ticker, str) and not isinstance(ticker, unicode):
        ticker = str(ticker)

    requestString.append("&ticker=%s"%(ticker))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1120)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1120)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'FeederSecID', u'FeederTicker', u'FeederExchangeCD', u'FeederShortName', u'ETFSecID', u'ETFticker', u'ETFExchangeCD', u'ETFShortName']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'FeederSecID': 'str','FeederTicker': 'str','FeederExchangeCD': 'str','FeederShortName': 'str','ETFSecID': 'str','ETFticker': 'str','ETFExchangeCD': 'str','ETFShortName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FundETFPRListJYGet(secID = "", ticker = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取ETF基金交易日的申赎清单基本信息，包括标的指数名称，上一交易日的现金差额、最小申赎单位净值、单位净值，交易日当日的预估现金差额、最小申赎单位、现金替代比例上限、是否允许申购赎回、是否公布IOPV等信息。收录了2008年以来的历史数据，数据更新频率为日。不输入日期则默认获取近两天的历史数据。
    
    :param secID: 输入单个证券内部编码，可通过交易代码和交易市场在DataAPI.SecIDGet获取到。,secID、ticker至少选择一个
    :param ticker: 输入单个基金代码，如"000001"。,secID、ticker至少选择一个
    :param beginDate: 报告起始日期，输入"YYYYMMDD"格式。不输入则默认输出当日数据。,可空
    :param endDate: 报告截止日期，输入"YYYYMMDD"格式。不输入则默认输出当日数据。,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fund/getFundETFPRListJY.csv?ispandas=1&') 
    if not isinstance(secID, str) and not isinstance(secID, unicode):
        secID = str(secID)

    requestString.append("secID=%s"%(secID))
    if not isinstance(ticker, str) and not isinstance(ticker, unicode):
        ticker = str(ticker)

    requestString.append("&ticker=%s"%(ticker))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1164)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1164)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'exchangeCD', u'secShortName', u'infoSource', u'primaryMarketTicker', u'underLyingIndex', u'idxShortName', u'preTradeDate', u'cashComp', u'navPerCu', u'nav', u'tradeDate', u'estCashComp', u'maxCashRatio', u'creationUnit', u'dividendPerCu', u'ifIOPVDesc', u'ifPurchasebleDesc', u'ifRedeemableDesc', u'ifIOPV', u'ifPurchaseble', u'ifRedeemable']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','exchangeCD': 'str','secShortName': 'str','infoSource': 'str','primaryMarketTicker': 'str','underLyingIndex': 'str','idxShortName': 'str','ifIOPVDesc': 'str','ifPurchasebleDesc': 'str','ifRedeemableDesc': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FundETFConsJYGet(secID = "", ticker = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取ETF基金每个交易日的跟踪的标的指数成分券清单，包括成分券的代码、简称、股票数量、现金替代溢价比、固定替代金额等信息。收录了2008年以来的历史数据，数据更新频率为日。不输入日期则默认获取近两天的历史数据。
    
    :param secID: 输入单个证券内部编码，可通过交易代码和交易市场在DataAPI.SecIDGet获取到。,secID、ticker至少选择一个
    :param ticker: 输入单个基金代码，如"000001"。,secID、ticker至少选择一个
    :param beginDate: 报告起始日期，输入"YYYYMMDD"格式。不输入则默认输出最近一年相关数据。,可空
    :param endDate: 报告截止日期，输入"YYYYMMDD"格式。不输入则默认输出最近一年相关数据。,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fund/getFundETFConsJY.csv?ispandas=1&') 
    if not isinstance(secID, str) and not isinstance(secID, unicode):
        secID = str(secID)

    requestString.append("secID=%s"%(secID))
    if not isinstance(ticker, str) and not isinstance(ticker, unicode):
        ticker = str(ticker)

    requestString.append("&ticker=%s"%(ticker))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1165)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1165)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'exchangeCD', u'secShortName', u'infoSource', u'tradeDate', u'consID', u'consTicker', u'consExchangeCD', u'consName', u'quantity', u'cashSubsSignDesc', u'cashSubsSign', u'cashRatio', u'fixedCashAmount']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','exchangeCD': 'str','secShortName': 'str','infoSource': 'str','consID': 'str','consTicker': 'str','consExchangeCD': 'str','consName': 'str','cashSubsSignDesc': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FundRatingMStarJYGet(secID = "", ticker = "", beginDate = "", endDate = "", reportPeriod = "", field = "", pandas = "1"):
    """
    获取晨星公司按照周给出的基金评级信息，包括周回报率、月回报率、三月回报率、六月回报率、年回报率、今年回报率、设立以来回报率等数据以及标准差、风险、夏普比率、风险调整与星级评价等相关数据。收录了2004年以来的历史数据，数据更新频率为周。不输入日期则默认获取近一年以来的历史数据。注：回报率数据以小数形式提供(非百分数)。
    
    :param secID: 证券内部编码，可通过交易代码和交易市场在DataAPI.SecIDGet获取到。,可以是列表,secID、ticker至少选择一个
    :param ticker: 输入一个或多个基金代码，用","分隔，如"000001"、"000001,000003"。,可以是列表,secID、ticker至少选择一个
    :param beginDate: 报告起始日期，输入"YYYYMMDD"格式。不输入则默认输出近一年以来历史数据。,可空
    :param endDate: 报告截止日期，输入"YYYYMMDD"格式。不输入则默认输出近一年以来历史数据。,可空
    :param reportPeriod: 报告周期，"M"为月，"W"为周。不输入默认选择"W"。,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fund/getFundRatingMStarJY.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    if not isinstance(reportPeriod, str) and not isinstance(reportPeriod, unicode):
        reportPeriod = str(reportPeriod)

    requestString.append("&reportPeriod=%s"%(reportPeriod))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'secShortName', u'ticker', u'exchangeCD', u'investStyleCD', u'publishDate', u'endDate', u'nav', u'reportPeriod', u'returnRate1W', u'returnRate1M', u'returnRate3M', u'returnRate6M', u'returnRate1Y', u'returnRate2Y', u'returnRate3Y', u'returnRate5Y', u'returnRate10Y', u'returnRateYTD', u'returnRateTotal', u'period', u'periodEndDate', u'STD', u'STDRank', u'riskFactor', u'riskRank', u'sharpRatio', u'sharpRatioRank', u'MRAR', u'overallRating', u'infoSource']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','secShortName': 'str','ticker': 'str','exchangeCD': 'str','investStyleCD': 'str','reportPeriod': 'str','period': 'str','STDRank': 'str','riskRank': 'str','sharpRatioRank': 'str','overallRating': 'str','infoSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FundManagerJYGet(secID = "", ticker = "", position = "", field = "", pandas = "1"):
    """
    获取某只基金的基金经理与基金经理助理的历史职位变动情况，包含学历、证券从业时间、任职日期与离职日期、任职期间基金净值增长率等信息。收录了1997年以来的历史数据，数据更新频率为不定期。
    
    :param secID: 证券内部编码，可通过交易代码和交易市场在DataAPI.SecIDGet获取到。,可以是列表,secID、ticker至少选择一个
    :param ticker: 输入一个或多个基金代码，用","分隔，如"000001"、"000001,000003"。,可以是列表,secID、ticker至少选择一个
    :param position: 输入职位类别，"FM"为基金经理，"FMA"为基金经理助理。不输入则默认输出所有情况。,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fund/getFundManagerJY.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    if not isinstance(position, str) and not isinstance(position, unicode):
        position = str(position)

    requestString.append("&position=%s"%(position))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1167)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1167)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'exchangeCD', u'secShortName', u'publishDate', u'infoSource', u'position', u'name', u'gender', u'birthday', u'birthdayDesc', u'eduBackg', u'experienceTime', u'practiceDate', u'background', u'isIncumbent', u'accessionDate', u'dimissionDate', u'performance', u'remark']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','exchangeCD': 'str','secShortName': 'str','infoSource': 'str','position': 'str','name': 'str','gender': 'str','birthdayDesc': 'str','eduBackg': 'str','background': 'str','remark': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FundHolderJYGet(secID = "", ticker = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取基金份额在某一截止日期的前十名份额持有人的情况，包含持有人名称，份额，占基金总份额的比例。
    
    :param secID: 证券内部编码，可通过交易代码和交易市场在DataAPI.SecIDGet获取到。,可以是列表,secID、ticker至少选择一个
    :param ticker: 输入一个或多个基金代码，用","分隔，如"000001"、"000001,000003",可以是列表,secID、ticker至少选择一个
    :param beginDate: 起始日期，默认为1年前当前日期，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，默认为今天，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fund/getFundHolderJY.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1318)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1318)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'exchangeCD', u'secShortName', u'publishDate', u'infoSource', u'endDate', u'serialNumber', u'holderName', u'holderID', u'holdVolume', u'holdRatio']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','exchangeCD': 'str','secShortName': 'str','infoSource': 'str','holderName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FundTradingUnitJYGet(secID = "", ticker = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取某一基金在季度末，年度末所披露的席位券商、交易席位个数、佣金以及股票、基金、债券、债券回购、权证等交易状况的相关数据。数据更新频度为半年度。注：占比数据以百分数形式提供（非小数）。
    
    :param secID: 证券内部编码，可通过交易代码和交易市场在DataAPI.SecIDGet获取到。,可以是列表,secID、ticker至少选择一个
    :param ticker: 输入一个或多个基金代码，用","分隔，如"000001"、"000001,000003",可以是列表,secID、ticker至少选择一个
    :param beginDate: 起始日期，默认为1年前当前日期，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，默认为今天，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fund/getFundTradingUnitJY.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1319)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1319)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'exchangeCD', u'secShortName', u'infoSource', u'reportDate', u'serialNumber', u'partyID', u'partyFullName', u'unitNumber', u'commision', u'ratioInTotalCommision', u'equityVol', u'ratioInTotalEquityVol', u'bondVol', u'ratioInTotalBondVol', u'repoVol', u'ratioInTotalRepoVol', u'fundVol', u'ratioInTotalFundVol', u'worrantVol', u'ratioInTotalWorrantVol']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','exchangeCD': 'str','secShortName': 'str','infoSource': 'str','partyFullName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FundHoldingsChgJYGet(secID = "", ticker = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取基金所投资的股票组合重大变动的历史数据，包含中报与年报的相关数据，揭示股票代码、股票名称、累计买入或卖出金额、占起初基金净值的比例等信息。收录了2004年以来的历史数据，数据更新频率为每半年更新一次。不输入日期则默认获取近一年以来的历史数据。注："占起初基金净值的比例"以百分数形式提供(非小数)。
    
    :param secID: 证券内部编码，可通过交易代码和交易市场在DataAPI.SecIDGet获取到。,可以是列表,secID、ticker至少选择一个
    :param ticker: 输入一个或多个基金代码，用","分隔，如"000001"、"000001,000003"。,可以是列表,secID、ticker至少选择一个
    :param beginDate: 报告起始日期，输入"YYYYMMDD"格式。不输入则默认输出最近一年相关数据。,可空
    :param endDate: 报告截止日期，输入"YYYYMMDD"格式。不输入则默认输出最近一年相关数据。,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fund/getFundHoldingsChgJY.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1320)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1320)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'exchangeCD', u'secShortName', u'reportDate', u'chgType', u'serialNumber', u'equitySecID', u'equityTicker', u'equityExchangeCD', u'equityShortName', u'chgAmount', u'chgInNvBf']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','exchangeCD': 'str','secShortName': 'str','chgType': 'str','equitySecID': 'str','equityTicker': 'str','equityExchangeCD': 'str','equityShortName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FundIpoResultJYGet(equityID = "", equityTicker = "", fundID = "", partyID = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取基金参与投资首次公开发行股票的网下配售结果数据，包含新股名称、新股代码、发行总数、中签公募基金、申购数量、获配数量、中签机构、信息来源等数据信息。数据收录了1994年以来的历史数据,数据更新频度为不定期。不输入日期可默认获取近一年以来的历史数据。
    
    :param equityID: 股票内部编码，可通过交易代码和交易市场在DataAPI.SecIDGet获取到。,可空
    :param equityTicker: 输入一个或多个股票代码，用","分隔，如"000001"、"000001,000002"。,可空
    :param fundID: 基金主编码，同一个基金合同下具有多种份额的分级基金具有相同的基金主编码。可通过交易代码和交易市场在DataAPI.FundGet获取到。,可空
    :param partyID: 机构内部编码,可空
    :param beginDate: 起始日期，输入格式为“YYYYMMDD”，不输则默认为一年前当日。,可空
    :param endDate: 截止日期,输入格式为“YYYYMMDD”，不输则默认为当日。,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fund/getFundIpoResultJY.csv?ispandas=1&') 
    if not isinstance(equityID, str) and not isinstance(equityID, unicode):
        equityID = str(equityID)

    requestString.append("equityID=%s"%(equityID))
    if not isinstance(equityTicker, str) and not isinstance(equityTicker, unicode):
        equityTicker = str(equityTicker)

    requestString.append("&equityTicker=%s"%(equityTicker))
    if not isinstance(fundID, str) and not isinstance(fundID, unicode):
        fundID = str(fundID)

    requestString.append("&fundID=%s"%(fundID))
    if not isinstance(partyID, str) and not isinstance(partyID, unicode):
        partyID = str(partyID)

    requestString.append("&partyID=%s"%(partyID))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1459)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1459)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'equityID', u'equityShortName', u'equityTicker', u'equityExchangeCD', u'equityExchange', u'publishDate', u'infoSource', u'totalAmount', u'serialNumber', u'partyID', u'partyFullName', u'fundID', u'fundFullName', u'purchaseAmount', u'aquireAmount']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'equityID': 'str','equityShortName': 'str','equityTicker': 'str','equityExchangeCD': 'str','equityExchange': 'str','infoSource': 'str','partyID': 'str','partyFullName': 'str','fundFullName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def fundAnnounceJYGet(effectDate = "", secID = "", ticker = "", beginDate = "", endDate = "", category = "", field = "", pandas = "1"):
    """
    获得基金首次发行股票的招股说明书、招股意向书、上市公告书等公告原文扩募、年报、中报、季报等定期公告等公告原文
    
    :param effectDate: 数据截止日期，获得该日期当天发布的数据，输入格式“YYYYMMDD”,effectDate、secID、ticker至少选择一个
    :param secID: 研究对象在通联内部的代码，可输入多个,可以是列表,effectDate、secID、ticker至少选择一个
    :param ticker: 研究对象上市代码，可输入多个,可以是列表,effectDate、secID、ticker至少选择一个
    :param beginDate: 数据截止日期，获得该日期之后发布的数据，输入格式“YYYYMMDD”,可空
    :param endDate: 数据截止日期，获得该日期之前发布的数据，输入格式“YYYYMMDD”,可空
    :param category: 可与系统常量信息（DataAPI.JY.CTSystemConstJYGet)关联，LB=1032获得相关分类,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fund/getfundAnnounceJY.csv?ispandas=1&') 
    try:
        effectDate = effectDate.strftime('%Y%m%d')
    except:
        effectDate = effectDate.replace('-', '')
    requestString.append("effectDate=%s"%(effectDate))
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    if not isinstance(category, str) and not isinstance(category, unicode):
        category = str(category)

    requestString.append("&category=%s"%(category))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1645)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1645)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'category', u'pubDate', u'effectDate', u'serialNumber', u'infoTitle', u'subTitle', u'content', u'media', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','category': 'str','infoTitle': 'str','subTitle': 'str','media': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def fundInterBulletinJYGet(pubDate = "", secID = "", ticker = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获得基金历年披露的除发行上市公告书、定期报告等以外的其他各类公告；其他机构如交易所、证监会等发布的相关公告
    
    :param pubDate: 数据发布日期，获得该天发布的数据，输入格式“YYYYMMDD”,pubDate、secID、ticker至少选择一个
    :param secID: 研究对象在通联内部的代码，可输入多个,可以是列表,pubDate、secID、ticker至少选择一个
    :param ticker: 研究对象上市代码，可输入多个,可以是列表,pubDate、secID、ticker至少选择一个
    :param beginDate: 数据开始日期，获得该日期之后发布的数据，输入格式“YYYYMMDD”,可空
    :param endDate: 数据截止日期，获得该日期之前发布的数据，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fund/getfundInterBulletinJY.csv?ispandas=1&') 
    try:
        pubDate = pubDate.strftime('%Y%m%d')
    except:
        pubDate = pubDate.replace('-', '')
    requestString.append("pubDate=%s"%(pubDate))
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1658)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1658)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'pubDate', u'infoTitle', u'detail', u'bulletinType', u'media', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','infoTitle': 'str','media': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def fundNewsJYGet(beginDate, endDate, field = "", pandas = "1"):
    """
    获得基金历年报道的各种新闻
    
    :param beginDate: 数据开始日期，获得该日期之后发布的数据，输入格式“YYYYMMDD”,不输默认返回近一周数据
    :param endDate: 数据截止日期，获得该日期之前发布的数据，输入格式“YYYYMMDD”,不输默认返回近一周数据
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fund/getfundNewsJY.csv?ispandas=1&') 
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1660)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1660)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'pubDate', u'media', u'writer', u'author', u'infoTitle', u'content', u'objectCD', u'object', u'areaCD', u'area', u'infoLevel', u'involvedInst', u'institution', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'media': 'str','writer': 'str','author': 'str','infoTitle': 'str','object': 'str','area': 'str','institution': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FundInvestIndustryJYGet(secID = "", ticker = "", beginReportDate = "", endReportDate = "", investType = "", induStandard = "", field = "", pandas = "1"):
    """
    基金行业投资分布信息
    
    :param secID: 证券内部编码，可通过交易代码和交易市场在DataAPI.SecIDGet获取到。,可以是列表,secID、ticker、beginReportDate、endReportDate至少选择一个
    :param ticker: 证券代码,可以是列表,secID、ticker、beginReportDate、endReportDate至少选择一个
    :param beginReportDate: 报告期,secID、ticker、beginReportDate、endReportDate至少选择一个
    :param endReportDate: 报告期,secID、ticker、beginReportDate、endReportDate至少选择一个
    :param investType: 投资类型,1-综合投资；2-积极投资；3-指数投资,可以是列表,可空
    :param induStandard: 行业划分标准,22-证监会行业分类2012版；为空，则为2012之前的版本。,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fund/getFundInvestIndustryJY.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginReportDate = beginReportDate.strftime('%Y%m%d')
    except:
        beginReportDate = beginReportDate.replace('-', '')
    requestString.append("&beginReportDate=%s"%(beginReportDate))
    try:
        endReportDate = endReportDate.strftime('%Y%m%d')
    except:
        endReportDate = endReportDate.replace('-', '')
    requestString.append("&endReportDate=%s"%(endReportDate))
    requestString.append("&investType=")
    if hasattr(investType,'__iter__') and not isinstance(investType, str):
        if len(investType) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = investType
            requestString.append(None)
        else:
            requestString.append(','.join(investType))
    else:
        requestString.append(investType)
    if not isinstance(induStandard, str) and not isinstance(induStandard, unicode):
        induStandard = str(induStandard)

    requestString.append("&induStandard=%s"%(induStandard))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1832)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1832)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'infoPublDate', u'reportDate', u'investType', u'investTypeDesc', u'induStandard', u'industryCode', u'induDiscCode', u'industryName', u'marketValue', u'ratioInNV', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','investTypeDesc': 'str','induDiscCode': 'str','industryName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FundNavPerformanceHisJYGet(secID = "", ticker = "", beginTradingDay = "", endTradingDay = "", tradingDay = "", field = "", pandas = "1"):
    """
    基金的历史表现，包括周、一个月、三个月、半年、一年、二年、三年、五年、十年、成立以来的回报
    
    :param secID: 证券内部编码，可通过交易代码和交易市场在DataAPI.SecIDGet获取到。,可以是列表,secID、ticker、beginTradingDay、endTradingDay、tradingDay至少选择一个
    :param ticker: 证券代码,可以是列表,secID、ticker、beginTradingDay、endTradingDay、tradingDay至少选择一个
    :param beginTradingDay: 交易开始日期，输入格式“YYYYMMDD”,secID、ticker、beginTradingDay、endTradingDay、tradingDay至少选择一个
    :param endTradingDay: 交易截止日期，输入格式“YYYYMMDD”,secID、ticker、beginTradingDay、endTradingDay、tradingDay至少选择一个
    :param tradingDay: 输入单个日期，输入格式“YYYYMMDD”，获取该日净值表现,secID、ticker、beginTradingDay、endTradingDay、tradingDay至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fund/getFundNavPerformanceHisJY.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginTradingDay = beginTradingDay.strftime('%Y%m%d')
    except:
        beginTradingDay = beginTradingDay.replace('-', '')
    requestString.append("&beginTradingDay=%s"%(beginTradingDay))
    try:
        endTradingDay = endTradingDay.strftime('%Y%m%d')
    except:
        endTradingDay = endTradingDay.replace('-', '')
    requestString.append("&endTradingDay=%s"%(endTradingDay))
    try:
        tradingDay = tradingDay.strftime('%Y%m%d')
    except:
        tradingDay = tradingDay.replace('-', '')
    requestString.append("&tradingDay=%s"%(tradingDay))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1833)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1833)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'tradingDay', u'unitNV', u'nvDailyGrowthRate', u'rrInSelectedWeek', u'rrInSingleWeek', u'rrInSelectedMonth', u'rrInSingleMonth', u'rrInThreeMonth', u'rrInSixMonth', u'rrSinceThisYear', u'rrInSingleYear', u'rrInTwoYear', u'annualizedRRInTwoYear', u'rrInThreeYear', u'annualizedRRInThreeYear', u'rrInFiveYear', u'annualizedRRInFiveYear', u'rrInTenYear', u'annualizedRRInTenYear', u'rrSinceStart', u'annualizedRRSinceStart', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FundNavPerformanceJYGet(secID = "", ticker = "", TradingDay = "", field = "", pandas = "1"):
    """
    基金的最新表现，包括周、一个月、三个月、半年、一年、二年、三年、五年、十年、成立以来的回报
    
    :param secID: 证券内部编码，可通过交易代码和交易市场在DataAPI.SecIDGet获取到。,可以是列表,secID、ticker、TradingDay至少选择一个
    :param ticker: 证券代码,可以是列表,secID、ticker、TradingDay至少选择一个
    :param TradingDay: 交易日,secID、ticker、TradingDay至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fund/getFundNavPerformanceJY.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        TradingDay = TradingDay.strftime('%Y%m%d')
    except:
        TradingDay = TradingDay.replace('-', '')
    requestString.append("&TradingDay=%s"%(TradingDay))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1834)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1834)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'tradingDay', u'unitNV', u'nvDailyGrowthRate', u'rrInSelectedWeek', u'rrInSingleWeek', u'rrInSelectedMonth', u'rrInSingleMonth', u'rrInThreeMonth', u'rrInSixMonth', u'rrSinceThisYear', u'rrInSingleYear', u'rrInTwoYear', u'annualizedRRInTwoYear', u'rrInThreeYear', u'annualizedRRInThreeYear', u'rrInFiveYear', u'annualizedRRInFiveYear', u'rrInTenYear', u'annualizedRRInTenYear', u'rrSinceStart', u'annualizedRRSinceStart', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FundMInvestPerformanceJYGet(secID = "", ticker = "", beginTradingDay = "", endTradingDay = "", tradingDay = "", field = "", pandas = "1"):
    """
    货币基金的定投收益表现，包括一年、二年、三年、五年、十年以来的定投收益表现
    
    :param secID: 证券内部编码，可通过交易代码和交易市场在DataAPI.SecIDGet获取到。,可以是列表,secID、ticker、beginTradingDay、endTradingDay、tradingDay至少选择一个
    :param ticker: 证券代码,可以是列表,secID、ticker、beginTradingDay、endTradingDay、tradingDay至少选择一个
    :param beginTradingDay: 交易开始日期，输入格式“YYYYMMDD”,secID、ticker、beginTradingDay、endTradingDay、tradingDay至少选择一个
    :param endTradingDay: 交易截止日期，输入格式“YYYYMMDD”,secID、ticker、beginTradingDay、endTradingDay、tradingDay至少选择一个
    :param tradingDay: 输入单个日期，输入格式“YYYYMMDD”，获取该日净值表现,secID、ticker、beginTradingDay、endTradingDay、tradingDay至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fund/getFundMInvestPerformanceJY.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginTradingDay = beginTradingDay.strftime('%Y%m%d')
    except:
        beginTradingDay = beginTradingDay.replace('-', '')
    requestString.append("&beginTradingDay=%s"%(beginTradingDay))
    try:
        endTradingDay = endTradingDay.strftime('%Y%m%d')
    except:
        endTradingDay = endTradingDay.replace('-', '')
    requestString.append("&endTradingDay=%s"%(endTradingDay))
    try:
        tradingDay = tradingDay.strftime('%Y%m%d')
    except:
        tradingDay = tradingDay.replace('-', '')
    requestString.append("&tradingDay=%s"%(tradingDay))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1898)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1898)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'tradingDay', u'IRInSingleYear', u'IRInTwoYear', u'IRInThreeYear', u'IRInFiveYear', u'IRInTenYear', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FundMYieldPerformanceJYGet(secID = "", ticker = "", beginTradingDay = "", endTradingDay = "", tradingDay = "", field = "", pandas = "1"):
    """
    货币基金的收益表现，包括7日、14日、21日、28日、35日、一个月、三个月、半年、一年、二年、三年、五年、十年、成立以来的表现。
    
    :param secID: 证券内部编码，可通过交易代码和交易市场在DataAPI.SecIDGet获取到。,可以是列表,secID、ticker、beginTradingDay、endTradingDay、tradingDay至少选择一个
    :param ticker: 证券代码,可以是列表,secID、ticker、beginTradingDay、endTradingDay、tradingDay至少选择一个
    :param beginTradingDay: 交易开始日期，输入格式“YYYYMMDD”,secID、ticker、beginTradingDay、endTradingDay、tradingDay至少选择一个
    :param endTradingDay: 交易截止日期，输入格式“YYYYMMDD”,secID、ticker、beginTradingDay、endTradingDay、tradingDay至少选择一个
    :param tradingDay: 输入单个日期，输入格式“YYYYMMDD”，获取该日净值表现,secID、ticker、beginTradingDay、endTradingDay、tradingDay至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fund/getFundMYieldPerformanceJY.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginTradingDay = beginTradingDay.strftime('%Y%m%d')
    except:
        beginTradingDay = beginTradingDay.replace('-', '')
    requestString.append("&beginTradingDay=%s"%(beginTradingDay))
    try:
        endTradingDay = endTradingDay.strftime('%Y%m%d')
    except:
        endTradingDay = endTradingDay.replace('-', '')
    requestString.append("&endTradingDay=%s"%(endTradingDay))
    try:
        tradingDay = tradingDay.strftime('%Y%m%d')
    except:
        tradingDay = tradingDay.replace('-', '')
    requestString.append("&tradingDay=%s"%(tradingDay))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1899)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1899)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'tradingDay', u'unitNV', u'accumulatedUnitNV', u'dailyProfit', u'latestWeeklyYield', u'involvedDays', u'dailyProfit1', u'annualizedRRInSingleWeek', u'annualizedRRInTwoWeek', u'annualizedRRInThreeWeek', u'annualizedRRInFourWeek', u'annualizedRRInFiveWeek', u'RRInThisWeek', u'RRInSingleWeek', u'RRInThisMonth', u'RRInSingleMonth', u'RRInThreeMonth', u'RRInSixMonth', u'RRSinceThisYear', u'RRInSingleYear', u'RRInTwoYear', u'annualizedRRInTwoYear', u'RRInThreeYear', u'annualizedRRInThreeYear', u'RRInFiveYear', u'annualizedRRInFiveYear', u'RRInTenYear', u'annualizedRRInTenYear', u'RRSinceStart', u'annualizedRRSinceStart', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def EcoDataRrpJYGet(indicID, beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    聚源宏观行业数据(产品用)，包含聚源宏观及行业的所有数据。输入指标ID，获取相关数据。
    
    :param indicID: 指标代码，可多值输入,可以是列表
    :param beginDate: 开始日期，所查询的指标数据起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 截止日期，所查询的指标数据结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getEcoDataRrpJY.csv?ispandas=1&') 
    requestString.append("indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'publishDate', u'periodDate', u'dataValue', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def EcoDataLatestRrpJYGet(beginTime = "", endTime = "", indicID = "", field = "", pandas = "1"):
    """
    聚源宏观行业最新期数据(产品用)，包含聚源宏观及行业的所有数据。输入指标ID，获取指标最新期数据。
    
    :param beginTime: 更新开始时间，格式为：YYYYMMDD、YYYY-MM-DD HH:MM:SS 、YYYY-MM-DDTHH:mm:SS或 YYYYMMDDHHMMSS，如：20150226、2015-02-26 18:05:24、2015-02-26T18:05:24或20150226180524,可空
    :param endTime: 更新截止时间，为空则表示至今为止，格式为：YYYYMMDD、YYYY-MM-DD HH:MM:SS 、YYYY-MM-DDTHH:mm:SS或 YYYYMMDDHHMMSS，如：20150226、2015-02-26 18:05:24、2015-02-26T18:05:24或20150226180524,可空
    :param indicID: 指标代码，可多值输入,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/macro/getEcoDataLatestRrpJY.csv?ispandas=1&') 
    if not isinstance(beginTime, str) and not isinstance(beginTime, unicode):
        beginTime = str(beginTime)

    requestString.append("beginTime=%s"%(beginTime))
    if not isinstance(endTime, str) and not isinstance(endTime, unicode):
        endTime = str(endTime)

    requestString.append("&endTime=%s"%(endTime))
    requestString.append("&indicID=")
    if hasattr(indicID,'__iter__') and not isinstance(indicID, str):
        if len(indicID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicID
            requestString.append(None)
        else:
            requestString.append(','.join(indicID))
    else:
        requestString.append(indicID)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indicID', u'publishDate', u'periodDate', u'dataValue', u'updateTime', u'beginDate']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FdmtBSJYGet(secID = "", ticker = "", publishDateBegin = "", publishDateEnd = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    1、依据2007年新会计准则收集了上市公司定期报告中各个期间资产负债表数据，并依据新旧会计准则的科目对应关系，收录主要科目的历史对应数据； 2、收集合并报表、母公司报表数据，包括其对应的期末和期初数据； 3、如果上市公司对外财务报表进行更正，调整，该表展示历次调整数据； 4、本表中单位为人民币元； 5、带“##”的特殊项目为单个公司披露的非标准化的科目，对应的“特殊字段说明”字段将对其作出说明；带“##”的调整项目是为了让报表的各个小项借贷平衡而设置的，便于客户对报表的遗漏和差错进行判断。
    
    :param secID: 证券内部编码,可通过交易代码和交易市场在DataAPI.SecIDGet获取到,如'000002.XSHE',可以是列表,secID、ticker至少选择一个
    :param ticker: 交易代码,如'000002',可以是列表,secID、ticker至少选择一个
    :param publishDateBegin: 证券交易所披露的信息发布日期，起始时间，默认为1年前当前日期，输入格式“YYYYMMDD”,可空
    :param publishDateEnd: 证券交易所披露的信息发布日期，结束时间，默认为当前日期，输入格式“YYYYMMDD”,可空
    :param beginDate: 会计期间截止日期，起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 会计期间截止日期，结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getFdmtBSJY.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        publishDateBegin = publishDateBegin.strftime('%Y%m%d')
    except:
        publishDateBegin = publishDateBegin.replace('-', '')
    requestString.append("&publishDateBegin=%s"%(publishDateBegin))
    try:
        publishDateEnd = publishDateEnd.strftime('%Y%m%d')
    except:
        publishDateEnd = publishDateEnd.replace('-', '')
    requestString.append("&publishDateEnd=%s"%(publishDateEnd))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1092)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1092)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'exchangeCD', u'ticker', u'secShortName', u'repTypeCD', u'infoSource', u'publishDate', u'endDate', u'adjustedFlag', u'mergedFlag', u'accoutingStandards', u'industryCategory', u'currencyCD', u'cashCEquiv', u'clientDepos', u'tradingFA', u'notesReceiv', u'divReceiv', u'intReceiv', u'AR', u'othReceiv', u'prepayment', u'inventories', u'BBA', u'deferExp', u'NCAWithin1Y', u'othCA', u'CAE', u'CAA', u'TCA', u'availForSaleFA', u'htmInvest', u'investRealEstate', u'LTEquityInvest', u'LTReceiv', u'fixedAssets', u'constMaterials', u'CIP', u'fixedAssetsDisp', u'producBiolAssets', u'oilAndGasAssets', u'intanAssets', u'transacSeatFee', u'RD', u'goodwill', u'LTAmorExp', u'deferTaxAssets', u'othNCA', u'NCAE', u'NCAA', u'TNCA', u'investAsReceiv', u'settProv', u'clientProv', u'deposInOthBFI', u'preciMetals', u'loanToOthBankFI', u'derivAssets', u'purResaleFA', u'disburLA', u'premiumReceiv', u'subrogRecoReceiv', u'reinsurReceiv', u'RRReinsUnePrem', u'RRReinsOutstdCla', u'RRReinsLinsLiab', u'RRReinsLthinsLiab', u'PHPledgeLoans', u'fixedTermDepos', u'refundDepos', u'refundCapDepos', u'indepAccAssets', u'othAssets', u'AE', u'AA', u'TAssets', u'STBorr', u'pledgeBorr', u'tradingFL', u'notesPayable', u'AP', u'STBondPayable', u'advanceReceipts', u'payrollPayable', u'divPayable', u'taxesPayable', u'intPayable', u'othPayable', u'accrExp', u'deferIncome', u'NCLWithin1Y', u'othCl', u'CLE', u'CLA', u'TCL', u'LTBorr', u'bondPayable', u'LTPayable', u'specificPayables', u'estimatedLiab', u'deferTaxLiab', u'othNCL', u'NCLE', u'NCLA', u'TNCL', u'CBBorr', u'deposFrOthBFI', u'loanFrOthBankFI', u'derivLiab', u'soldForRepurFA', u'depos', u'fundsSecTradAgen', u'fundsSecUndwAgen', u'deposReceiv', u'premReceivAdva', u'commisPayable', u'reinsurPayable', u'indemAccPayable', u'policyDivPayable', u'PHInvest', u'reserUnePrem', u'reserOutstdClaims', u'reserLinsLiab', u'reserLthinsLiab', u'indeptAccLiab', u'othLiab', u'LE', u'LA', u'TLiab', u'paidInCapital', u'capitalReser', u'surplusReser', u'retainedEarnings', u'treasuryShare', u'ordinRiskReser', u'forexDiffer', u'unInvestlLoss', u'othReser', u'specialReser', u'SEE', u'SEA', u'TEquityAttrP', u'minorityInt', u'othEffectSe', u'TShEquity', u'LEE', u'LEA', u'TLiabEquity', u'specFieldRemark']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','exchangeCD': 'str','ticker': 'str','secShortName': 'str','repTypeCD': 'str','infoSource': 'str','adjustedFlag': 'str','mergedFlag': 'str','accoutingStandards': 'str','industryCategory': 'str','currencyCD': 'str','specFieldRemark': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FdmtFBSJYGet(secID = "", ticker = "", publishDateBegin = "", publishDateEnd = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    1、依据2007年新会计准则收集了银行、证券公司、保险公司、信托公司等金融类上市公司定期报告中各个期间资产负债表数据，并依据新旧会计准则的科目对应关系，收录主要科目的历史对应数据； 2、收集合并报表、母公司报表数据，包括其对应的期末和期初数据； 3、某个报告期的数据有多次调整，则该表展示最新调整数据；若某报告期暂未披露调整后数据，则已调整类别下的数据与调整前的数据一致； 4、本表中单位为人民币元； 5、带“##”的特殊项目为单个公司披露的非标准化的科目，对应的“特殊字段说明”字段将对其作出说明；带“##”的调整项目是为了让报表的各个小项借贷平衡而设置的，便于客户对报表的遗漏和差错进行判断。
    
    :param secID: 证券内部编码,可通过交易代码和交易市场在DataAPI.SecIDGet获取到,如'000001.XSHE',可以是列表,secID、ticker至少选择一个
    :param ticker: 交易代码,如'000001',可以是列表,secID、ticker至少选择一个
    :param publishDateBegin: 证券交易所披露的信息发布日期，起始时间，默认为1年前当前日期，输入格式“YYYYMMDD”,可空
    :param publishDateEnd: 证券交易所披露的信息发布日期，结束时间，默认为当前日期，输入格式“YYYYMMDD”,可空
    :param beginDate: 会计期间截止日期，起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 会计期间截止日期，结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getFdmtFBSJY.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        publishDateBegin = publishDateBegin.strftime('%Y%m%d')
    except:
        publishDateBegin = publishDateBegin.replace('-', '')
    requestString.append("&publishDateBegin=%s"%(publishDateBegin))
    try:
        publishDateEnd = publishDateEnd.strftime('%Y%m%d')
    except:
        publishDateEnd = publishDateEnd.replace('-', '')
    requestString.append("&publishDateEnd=%s"%(publishDateEnd))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1093)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1093)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'exchangeCD', u'ticker', u'secShortName', u'repTypeCD', u'infoSource', u'publishDate', u'endDate', u'adjustedFlag', u'mergedFlag', u'accoutingStandards', u'industryCategory', u'currencyCD', u'cashCEquiv', u'clientDepos', u'settProv', u'clientProv', u'deposInOthBFI', u'preciMetals', u'loanToOthBankFI', u'tradingFA', u'derivAssets', u'investAsReceiv', u'purResaleFA', u'discountAssets', u'intReceiv', u'divReceiv', u'AR', u'premiumReceiv', u'subrogRecoReceiv', u'reinsurReceiv', u'RRReinsUnePrem', u'RRReinsOutstdCla', u'RRReinsLinsLiab', u'RRReinsLthinsLiab', u'othReceiv', u'inventories', u'deferExp', u'PHPledgeLoans', u'disburLA', u'refundDepos', u'fixedTermDepos', u'refundCapDepos', u'availForSaleFA', u'htmInvest', u'LTEquityInvest', u'investRealEstate', u'fixedAssets', u'CIP', u'fixedAssetsDisp', u'intanAssets', u'transacSeatFee', u'goodwill', u'LTAmorExp', u'indepAccAssets', u'deferTaxAssets', u'othAssets', u'AE', u'AA', u'TAssets', u'STBorr', u'pledgeBorr', u'CBBorr', u'deposFrOthBFI', u'deposReceiv', u'depos', u'loanFrOthBankFI', u'tradingFL', u'derivLiab', u'soldForRepurFA', u'STBondPayable', u'fundsSecTradAgen', u'fundsSecUndwAgen', u'premReceivAdva', u'commisPayable', u'reinsurPayable', u'indemAccPayable', u'policyDivPayable', u'PHInvest', u'reserUnePrem', u'reserOutstdClaims', u'reserLinsLiab', u'reserLthinsLiab', u'payrollPayable', u'divPayable', u'taxesPayable', u'intPayable', u'othPayable', u'deferIncome', u'estimatedLiab', u'LTBorr', u'bondPayable', u'LTPayable', u'indeptAccLiab', u'deferTaxLiab', u'othLiab', u'LE', u'LA', u'TLiab', u'paidInCapital', u'capitalReser', u'treasuryShare', u'surplusReser', u'ordinRiskReser', u'retainedEarnings', u'forexDiffer', u'unInvestlLoss', u'othReser', u'minorityInt', u'othEffectSe', u'SEE', u'SEA', u'TShEquity', u'SEWMI', u'LEE', u'LEA', u'TLiabEquity', u'specFieldRemark']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','exchangeCD': 'str','ticker': 'str','secShortName': 'str','repTypeCD': 'str','infoSource': 'str','adjustedFlag': 'str','mergedFlag': 'str','accoutingStandards': 'str','industryCategory': 'str','currencyCD': 'str','specFieldRemark': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FdmtNFBSJYGet(secID = "", ticker = "", publishDateBegin = "", publishDateEnd = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    1、依据2007年新会计准则收集了非金融类上市公司定期报告中各个期间资产负债表数据，并依据新旧会计准则的科目对应关系，收录主要科目的历史对应数据； 2、收集合并报表、母公司报表数据，包括其对应的期末和期初数据； 3、某个报告期的数据有多次调整，则该表展示最新调整数据；若某报告期暂未披露调整后数据，则已调整类别下的数据与调整前的数据一致； 4、本表中单位为人民币元； 5、带“##”的特殊项目为单个公司披露的非标准化的科目，对应的“特殊字段说明”字段将对其作出说明；带“##”的调整项目是为了让报表的各个小项借贷平衡而设置的，便于客户对报表的遗漏和差错进行判断。
    
    :param secID: 证券内部编码,可通过交易代码和交易市场在DataAPI.SecIDGet获取到,如'000002.XSHE',可以是列表,secID、ticker至少选择一个
    :param ticker: 交易代码,如'000002',可以是列表,secID、ticker至少选择一个
    :param publishDateBegin: 证券交易所披露的信息发布日期，起始时间，默认为1年前当前日期，输入格式“YYYYMMDD”,可空
    :param publishDateEnd: 证券交易所披露的信息发布日期，结束时间，默认为当前日期，输入格式“YYYYMMDD”,可空
    :param beginDate: 会计期间截止日期，起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 会计期间截止日期，结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getFdmtNFBSJY.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        publishDateBegin = publishDateBegin.strftime('%Y%m%d')
    except:
        publishDateBegin = publishDateBegin.replace('-', '')
    requestString.append("&publishDateBegin=%s"%(publishDateBegin))
    try:
        publishDateEnd = publishDateEnd.strftime('%Y%m%d')
    except:
        publishDateEnd = publishDateEnd.replace('-', '')
    requestString.append("&publishDateEnd=%s"%(publishDateEnd))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1094)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1094)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'exchangeCD', u'ticker', u'secShortName', u'repTypeCD', u'infoSource', u'publishDate', u'endDate', u'adjustedFlag', u'mergedFlag', u'accoutingStandards', u'currencyCD', u'cashCEquiv', u'tradingFA', u'notesReceiv', u'divReceiv', u'intReceiv', u'AR', u'othReceiv', u'prepayment', u'inventories', u'BBA', u'deferExp', u'NCAWithin1Y', u'othCA', u'CAE', u'CAA', u'TCA', u'availForSaleFA', u'htmInvest', u'investRealEstate', u'LTEquityInvest', u'LTReceiv', u'fixedAssets', u'constMaterials', u'CIP', u'fixedAssetsDisp', u'producBiolAssets', u'oilAndGasAssets', u'intanAssets', u'RD', u'goodwill', u'LTAmorExp', u'deferTaxAssets', u'othNCA', u'NCAE', u'NCAA', u'TNCA', u'AE', u'AA', u'TAssets', u'STBorr', u'pledgeBorr', u'tradingFL', u'notesPayable', u'AP', u'STBondPayable', u'advanceReceipts', u'payrollPayable', u'divPayable', u'taxesPayable', u'intPayable', u'othPayable', u'accrExp', u'deferIncome', u'NCLWithin1Y', u'othCl', u'CLE', u'CLA', u'TCL', u'LTBorr', u'bondPayable', u'LTPayable', u'specificPayables', u'estimatedLiab', u'deferTaxLiab', u'othNCL', u'NCLE', u'NCLA', u'TNCL', u'LE', u'LA', u'TLiab', u'paidInCapital', u'capitalReser', u'treasuryShare', u'specialReser', u'surplusReser', u'retainedEarnings', u'ordinRiskReser', u'forexDiffer', u'unInvestlLoss', u'othReser', u'SEE', u'SEA', u'tEquityAttrP', u'minorityInt', u'othEffectSe', u'TShEquity', u'LEE', u'LEA', u'TLiabEquity', u'specFieldRemark']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','exchangeCD': 'str','ticker': 'str','secShortName': 'str','repTypeCD': 'str','infoSource': 'str','adjustedFlag': 'str','mergedFlag': 'str','accoutingStandards': 'str','currencyCD': 'str','specFieldRemark': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FdmtISJYGet(secID = "", ticker = "", publishDateBegin = "", publishDateEnd = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    1、依据2007年新会计准则收集了上市公司定期报告中各个期间利润表数据，并依据新旧会计准则的科目对应关系，收录主要科目的历史对应数据； 2、收集合并报表、母公司报表数据，包括其对应的本期和上期数据； 3、如果上市公司对外财务报表进行更正，调整，该表展示历次调整数据； 4、本表中单位为人民币元； 5、带“##”的特殊项目为单个公司披露的非标准化的科目，对应的“特殊字段说明”字段将对其作出说明；带“##”的调整项目是为了让报表的各个小项借贷平衡而设置的，便于客户对报表的遗漏和差错进行判断。
    
    :param secID: 证券内部编码,可通过交易代码和交易市场在DataAPI.SecIDGet获取到,如'000002.XSHE',可以是列表,secID、ticker至少选择一个
    :param ticker: 交易代码,如'000002',可以是列表,secID、ticker至少选择一个
    :param publishDateBegin: 证券交易所披露的信息发布日期，起始时间，默认为1年前当前日期，输入格式“YYYYMMDD”,可空
    :param publishDateEnd: 证券交易所披露的信息发布日期，结束时间，默认为当前日期，输入格式“YYYYMMDD”,可空
    :param beginDate: 会计期间截止日期，起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 会计期间截止日期，结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getFdmtISJY.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        publishDateBegin = publishDateBegin.strftime('%Y%m%d')
    except:
        publishDateBegin = publishDateBegin.replace('-', '')
    requestString.append("&publishDateBegin=%s"%(publishDateBegin))
    try:
        publishDateEnd = publishDateEnd.strftime('%Y%m%d')
    except:
        publishDateEnd = publishDateEnd.replace('-', '')
    requestString.append("&publishDateEnd=%s"%(publishDateEnd))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1095)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1095)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'exchangeCD', u'ticker', u'secShortName', u'repTypeCD', u'infoSource', u'publishDate', u'endDate', u'adjustedFlag', u'mergedFlag', u'accoutingStandards', u'industryCategory', u'currencyCD', u'TRevenue', u'revenue', u'NIntIncome', u'intIncome', u'intExp', u'NCommisIncome', u'commisIncome', u'commisExp', u'NSecTaIncome', u'NUndwrtSecIncome', u'NTrustIncome', u'premEarned', u'grossPremWrit', u'reinsIncome', u'reinsur', u'unePremReser', u'othRevenue', u'specOR', u'AOR', u'TCOGS', u'payout', u'premRefund', u'compensPayout', u'compensPayoutRefu', u'reserInsurLiab', u'insurLiabReserRefu', u'policyDivPayt', u'reinsurExp', u'genlAdminExp', u'reinsCostRefund', u'insurCommisExp', u'othCost', u'COGS', u'bizTaxSurchg', u'sellExp', u'adminExp', u'finanExp', u'assetsImpairLoss', u'specTOC', u'ATOC', u'othNetRevenue', u'FValueChgGain', u'investIncome', u'AJInvestIncome', u'forexGain', u'othEffectOP', u'AEffectOP', u'operateProfit', u'NoperateIncome', u'NoperateExp', u'NCADisploss', u'othEffectTP', u'AEffectTP', u'TProfit', u'incomeTax', u'unInvestLoss', u'othEffectNP', u'AEffectNP', u'NIncome', u'NIncomeAttrP', u'minorityGain', u'othEffectNPP', u'AEffectNPP', u'othComprIncome', u'AEffectCI', u'TComprIncome', u'comprIncAttrP', u'comprIncAttrMS', u'AEffectPCI', u'basicEPS', u'dilutedEPS', u'specFieldRemark']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','exchangeCD': 'str','ticker': 'str','secShortName': 'str','repTypeCD': 'str','infoSource': 'str','adjustedFlag': 'str','mergedFlag': 'str','accoutingStandards': 'str','industryCategory': 'str','currencyCD': 'str','specFieldRemark': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FdmtFISJYGet(secID = "", ticker = "", publishDateBegin = "", publishDateEnd = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    1、依据2007年新会计准则收集了银行、证券公司、保险公司、信托公司等金融类上市公司定期报告中各个期间利润表数据，并依据新旧会计准则的科目对应关系，收录主要科目的历史对应数据； 2、收集合并报表、母公司报表数据，包括其对应的本期和上期数据； 3、某个报告期的数据有多次调整，则该表展示最新调整数据；若某报告期暂未披露调整后数据，则已调整类别下的数据与调整前的数据一致； 4、本表中单位为人民币元； 5、带“##”的特殊项目为单个公司披露的非标准化的科目，对应的“特殊字段说明”字段将对其作出说明；带“##”的调整项目是为了让报表的各个小项借贷平衡而设置的，便于客户对报表的遗漏和差错进行判断。
    
    :param secID: 证券内部编码,可通过交易代码和交易市场在DataAPI.SecIDGet获取到,如'000001.XSHE',可以是列表,secID、ticker至少选择一个
    :param ticker: 交易代码,如'000001',可以是列表,secID、ticker至少选择一个
    :param publishDateBegin: 证券交易所披露的信息发布日期，起始时间，默认为1年前当前日期，输入格式“YYYYMMDD”,可空
    :param publishDateEnd: 证券交易所披露的信息发布日期，结束时间，默认为当前日期，输入格式“YYYYMMDD”,可空
    :param beginDate: 会计期间截止日期，起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 会计期间截止日期，结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getFdmtFISJY.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        publishDateBegin = publishDateBegin.strftime('%Y%m%d')
    except:
        publishDateBegin = publishDateBegin.replace('-', '')
    requestString.append("&publishDateBegin=%s"%(publishDateBegin))
    try:
        publishDateEnd = publishDateEnd.strftime('%Y%m%d')
    except:
        publishDateEnd = publishDateEnd.replace('-', '')
    requestString.append("&publishDateEnd=%s"%(publishDateEnd))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1096)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1096)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'exchangeCD', u'ticker', u'secShortName', u'repTypeCD', u'infoSource', u'publishDate', u'endDate', u'adjustedFlag', u'mergedFlag', u'accoutingStandards', u'industryCategory', u'currencyCD', u'revenue', u'NIntIncome', u'intIncome', u'intExp', u'NCommisIncome', u'commisIncome', u'commisExp', u'NSecTaIncome', u'NUndwrtSecIncome', u'NTrustIncome', u'premEarned', u'grossPremWrit', u'reinsIncome', u'reinsur', u'unePremReser', u'FValueChgGain', u'investIncome', u'AJInvestIncome', u'forexGain', u'othRevenue', u'specOR', u'AOR', u'payout', u'premRefund', u'compensPayout', u'compensPayoutRefu', u'reserInsurLiab', u'insurLiabReserRefu', u'policyDivPayt', u'reinsurExp', u'insurCommisExp', u'bizTaxSurchg', u'genlAdminExp', u'reinsCostRefund', u'assetsImpairLoss', u'othCost', u'specOP', u'AOP', u'othEffectOP', u'AEffectOP', u'operateProfit', u'NoperateIncome', u'NoperateExp', u'NCADisploss', u'othEffectTP', u'AEffectTP', u'TProfit', u'incomeTax', u'unInvestLoss', u'othEffectNP', u'AEffectNP', u'NIncome', u'NIncomeAttrP', u'minorityGain', u'othComprIncome', u'AEffectCI', u'TComprIncome', u'comprIncAttrP', u'comprIncAttrMS', u'AEffectPCI', u'basicEPS', u'dilutedEPS', u'specFieldRemark']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','exchangeCD': 'str','ticker': 'str','secShortName': 'str','repTypeCD': 'str','infoSource': 'str','adjustedFlag': 'str','mergedFlag': 'str','accoutingStandards': 'str','industryCategory': 'str','currencyCD': 'str','specFieldRemark': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FdmtNFISJYGet(secID = "", ticker = "", publishDateBegin = "", publishDateEnd = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    1、依据2007年新会计准则收集了非金融类上市公司定期报告中各个期间利润表数据，并依据新旧会计准则的科目对应关系，收录主要科目的历史对应数据； 2、收集合并报表、母公司报表数据，包括其对应的本期和上期数据； 3、某个报告期的数据有多次调整，则该表展示最新调整数据；若某报告期暂未披露调整后数据，则已调整类别下的数据与调整前的数据一致； 4、本表中单位为人民币元； 5、带“##”的特殊项目为单个公司披露的非标准化的科目，对应的“特殊字段说明”字段将对其作出说明；带“##”的调整项目是为了让报表的各个小项借贷平衡而设置的，便于客户对报表的遗漏和差错进行判断。
    
    :param secID: 证券内部编码,可通过交易代码和交易市场在DataAPI.SecIDGet获取到,如'000002.XSHE',可以是列表,secID、ticker至少选择一个
    :param ticker: 交易代码,如'000002',可以是列表,secID、ticker至少选择一个
    :param publishDateBegin: 证券交易所披露的信息发布日期，起始时间，默认为1年前当前日期，输入格式“YYYYMMDD”,可空
    :param publishDateEnd: 证券交易所披露的信息发布日期，结束时间，默认为当前日期，输入格式“YYYYMMDD”,可空
    :param beginDate: 会计期间截止日期，起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 会计期间截止日期，结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getFdmtNFISJY.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        publishDateBegin = publishDateBegin.strftime('%Y%m%d')
    except:
        publishDateBegin = publishDateBegin.replace('-', '')
    requestString.append("&publishDateBegin=%s"%(publishDateBegin))
    try:
        publishDateEnd = publishDateEnd.strftime('%Y%m%d')
    except:
        publishDateEnd = publishDateEnd.replace('-', '')
    requestString.append("&publishDateEnd=%s"%(publishDateEnd))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1097)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1097)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'exchangeCD', u'ticker', u'secShortName', u'repTypeCD', u'infoSource', u'publishDate', u'endDate', u'adjustedFlag', u'mergedFlag', u'accoutingStandards', u'currencyCD', u'TRevenue', u'revenue', u'othRevenue', u'TCOGS', u'COGS', u'othCost', u'bizTaxSurchg', u'sellExp', u'adminExp', u'finanExp', u'assetsImpairLoss', u'specTOC', u'ATOC', u'othNetRevenue', u'FValueChgGain', u'investIncome', u'AJInvestIncome', u'forexGain', u'othEffectOP', u'AEffectOP', u'operateProfit', u'NoperateIncome', u'NoperateExp', u'NCADisploss', u'othEffectTP', u'AEffectTP', u'TProfit', u'incomeTax', u'unInvestLoss', u'othEffectNP', u'AEffectNP', u'NIncome', u'NIncomeAttrP', u'minorityGain', u'othComprIncome', u'AEffectCI', u'TComprIncome', u'comprIncAttrP', u'comprIncAttrMS', u'AEffectPCI', u'basicEPS', u'dilutedEPS', u'specFieldRemark']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','exchangeCD': 'str','ticker': 'str','secShortName': 'str','repTypeCD': 'str','infoSource': 'str','adjustedFlag': 'str','mergedFlag': 'str','accoutingStandards': 'str','currencyCD': 'str','specFieldRemark': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FdmtCFJYGet(secID = "", ticker = "", publishDateBegin = "", publishDateEnd = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    1、依据2007年新会计准则收集了上市公司定期报告中各个期间现金流量表数据，并依据新旧会计准则的科目对应关系，收录主要科目的历史对应数据； 2、收集合并报表、母公司报表数据，包括其对应的本期和上期数据； 3、如果上市公司对外财务报表进行更正，调整，该表展示历次调整数据； 4、本表中单位为人民币元； 5、带“##”的特殊项目为单个公司披露的非标准化的科目，对应的“特殊字段说明”字段将对其作出说明；带“##”的调整项目是为了让报表的各个小项借贷平衡而设置的，便于客户对报表的遗漏和差错进行判断。
    
    :param secID: 证券内部编码,可通过交易代码和交易市场在DataAPI.SecIDGet获取到,如'000002.XSHE',可以是列表,secID、ticker至少选择一个
    :param ticker: 交易代码,如'000002',可以是列表,secID、ticker至少选择一个
    :param publishDateBegin: 证券交易所披露的信息发布日期，起始时间，默认为1年前当前日期，输入格式“YYYYMMDD”,可空
    :param publishDateEnd: 证券交易所披露的信息发布日期，结束时间，默认为当前日期，输入格式“YYYYMMDD”,可空
    :param beginDate: 会计期间截止日期，起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 会计期间截止日期，结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getFdmtCFJY.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        publishDateBegin = publishDateBegin.strftime('%Y%m%d')
    except:
        publishDateBegin = publishDateBegin.replace('-', '')
    requestString.append("&publishDateBegin=%s"%(publishDateBegin))
    try:
        publishDateEnd = publishDateEnd.strftime('%Y%m%d')
    except:
        publishDateEnd = publishDateEnd.replace('-', '')
    requestString.append("&publishDateEnd=%s"%(publishDateEnd))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1098)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1098)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'exchangeCD', u'ticker', u'secShortName', u'repTypeCD', u'infoSource', u'publishDate', u'endDate', u'adjustedFlag', u'mergedFlag', u'accoutingStandards', u'industryCategory', u'currencyCD', u'CFrSaleGS', u'refundOfTax', u'NDeposIncrCFI', u'NIncrBorrFrCB', u'NIncBorrOthFI', u'drawBackLoansC', u'IFCCashIncr', u'NIncDispTradFA', u'NCapIncrRepur', u'premFrOrigContr', u'NReinsurPrem', u'NIncPhDeposInv', u'CFrOthOperateA', u'specOCIF', u'AOCIF', u'CInfFrOperateA', u'CPaidGS', u'CPaidToForEmpl', u'CPaidForTaxes', u'NIncDisburOfLA', u'netIncrDeposInFI', u'NIncrLoansToOthFI', u'CPaidIFC', u'origContrCIndem', u'NForReinsurPrem', u'CPaidPolDiv', u'CPaidForOthOpA', u'specOCOF', u'AOCOF', u'COutfOperateA', u'ANOCF', u'NCFOperateA', u'procSellInvest', u'gainInvest', u'dispFixAssetsOth', u'NDispSubsOthBizC', u'CFrOthInvestA', u'specCIF', u'ACIF', u'CInfFrInvestA', u'purFixAssetsOth', u'CPaidInvest', u'NCPaidAcquis', u'NIncrPledgeLoan', u'CPaidOthInvestA', u'specCOF', u'ACOF', u'COutfFrInvestA', u'ANICF', u'NCFFrInvestA', u'CFrCapContr', u'CFrMinoSSubs', u'CFrIssueBond', u'CFrBorr', u'CFrOthFinanA', u'specFCIF', u'AFCIF', u'CInfFrFinanA', u'CPaidForDebts', u'CPaidDivProfInt', u'divProfSubsMinoS', u'CPaidOthFinanA', u'specFCOF', u'AFCOF', u'COutfFrFinanA', u'ANFCF', u'NCFFrFinanA', u'forexEffects', u'othEffectCE', u'ACE', u'NChangeInCash', u'NCEBegBal', u'othEffectCEI', u'ACEI', u'NCEEndBal', u'NIncome', u'minorityGain', u'assetsImpairLoss', u'FADepr', u'intanAssetsAmor', u'LTAmorExpAmor', u'amorExpDecr', u'accrExpIncr', u'dispFAOthLoss', u'FAWritOff', u'FValueChgLoss', u'finanExp', u'invLoss', u'deferTADecr', u'deferTLIncr', u'invenDecr', u'operReceiDecr', u'operPayaIncr', u'other', u'specNOCF1', u'ANOCF1', u'NCFOperateANotes', u'contrANOCF', u'convDebtCapi', u'convBonds1Y', u'finanLeaFA', u'CEndBal', u'CBegBal', u'CEEndBal', u'CEBegBal', u'specC', u'AC', u'NChangeInCashNotes', u'contrANC', u'specFieldRemark']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','exchangeCD': 'str','ticker': 'str','secShortName': 'str','repTypeCD': 'str','infoSource': 'str','adjustedFlag': 'str','mergedFlag': 'str','accoutingStandards': 'str','industryCategory': 'str','currencyCD': 'str','specFieldRemark': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FdmtFCFJYGet(secID = "", ticker = "", publishDateBegin = "", publishDateEnd = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    1、依据2007年新会计准则收集了银行、证券公司、保险公司、信托公司等金融类上市公司定期报告中各个期间现金流量表数据，并依据新旧会计准则的科目对应关系，收录主要科目的历史对应数据； 2、收集合并报表、母公司报表数据，包括其对应的本期和上期数据； 3、某个报告期的数据有多次调整，则该表展示最新调整数据；若某报告期暂未披露调整后数据，则已调整类别下的数据与调整前的数据一致； 4、本表中单位为人民币元； 5、带“##”的特殊项目为单个公司披露的非标准化的科目，对应的“特殊字段说明”字段将对其作出说明；带“##”的调整项目是为了让报表的各个小项借贷平衡而设置的，便于客户对报表的遗漏和差错进行判断。
    
    :param secID: 证券内部编码,可通过交易代码和交易市场在DataAPI.SecIDGet获取到,如'000001.XSHE',可以是列表,secID、ticker至少选择一个
    :param ticker: 交易代码,如'000001',可以是列表,secID、ticker至少选择一个
    :param publishDateBegin: 证券交易所披露的信息发布日期，起始时间，默认为1年前当前日期，输入格式“YYYYMMDD”,可空
    :param publishDateEnd: 证券交易所披露的信息发布日期，结束时间，默认为当前日期，输入格式“YYYYMMDD”,可空
    :param beginDate: 会计期间截止日期，起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 会计期间截止日期，结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getFdmtFCFJY.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        publishDateBegin = publishDateBegin.strftime('%Y%m%d')
    except:
        publishDateBegin = publishDateBegin.replace('-', '')
    requestString.append("&publishDateBegin=%s"%(publishDateBegin))
    try:
        publishDateEnd = publishDateEnd.strftime('%Y%m%d')
    except:
        publishDateEnd = publishDateEnd.replace('-', '')
    requestString.append("&publishDateEnd=%s"%(publishDateEnd))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1099)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1099)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'exchangeCD', u'ticker', u'secShortName', u'repTypeCD', u'infoSource', u'publishDate', u'endDate', u'adjustedFlag', u'mergedFlag', u'accoutingStandards', u'industryCategory', u'currencyCD', u'NDeposIncrCFI', u'NIncrBorrFrCB', u'NIncBorrOthFI', u'drawBackLoansC', u'IFCCashIncr', u'NIncDispTradFA', u'NCapIncrRepur', u'premFrOrigContr', u'NReinsurPrem', u'NIncPhDeposInv', u'CFrOthOperateA', u'specOCIF', u'AOCIF', u'CInfFrOperateA', u'CPaidToForEmpl', u'CPaidForTaxes', u'NIncDisburOfLA', u'netIncrDeposInFI', u'NIncrLoansToOthFI', u'CPaidIFC', u'origContrCIndem', u'NForReinsurPrem', u'CPaidPolDiv', u'CPaidForOthOpA', u'specOCOF', u'AOCOF', u'COutfOperateA', u'ANOCF', u'NCFOperateA', u'procSellInvest', u'gainInvest', u'dispFixAssetsOth', u'NDispSubsOthBizC', u'CFrOthInvestA', u'specCIF', u'ACIF', u'CInfFrInvestA', u'purFixAssetsOth', u'CPaidInvest', u'NCPaidAcquis', u'NIncrPledgeLoan', u'CPaidOthInvestA', u'specCOF', u'ACOF', u'COutfFrInvestA', u'ANICF', u'NCFFrInvestA', u'CFrCapContr', u'CFrMinoSSubs', u'CFrIssueBond', u'CFrBorr', u'CFrOthFinanA', u'specFCIF', u'AFCIF', u'CInfFrFinanA', u'CPaidForDebts', u'CPaidDivProfInt', u'divProfSubsMinoS', u'CPaidOthFinanA', u'specFCOF', u'AFCOF', u'COutfFrFinanA', u'ANFCF', u'NCFFrFinanA', u'forexEffects', u'othEffectCE', u'ACE', u'NChangeInCash', u'NCEBegBal', u'NCEEndBal', u'NIncome', u'assetsImpairLoss', u'FADepr', u'intanAssetsAmor', u'LTAmorExpAmor', u'amorExpDecr', u'accrExpIncr', u'dispFAOthLoss', u'FAWritOff', u'FValueChgLoss', u'finanExp', u'invLoss', u'deferTADecr', u'deferTLIncr', u'invenDecr', u'operReceiDecr', u'operPayaIncr', u'other', u'specNOCF1', u'ANOCF1', u'NCFOperateANotes', u'contrANOCF', u'convDebtCapi', u'convBonds1Y', u'finanLeaFA', u'CEndBal', u'CBegBal', u'CEEndBal', u'CEBegBal', u'specC', u'AC', u'NChangeInCashNotes', u'contrANC', u'specFieldRemark']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','exchangeCD': 'str','ticker': 'str','secShortName': 'str','repTypeCD': 'str','infoSource': 'str','adjustedFlag': 'str','mergedFlag': 'str','accoutingStandards': 'str','industryCategory': 'str','currencyCD': 'str','specFieldRemark': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FdmtNFCFJYGet(secID = "", ticker = "", publishDateBegin = "", publishDateEnd = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    1、依据2007年新会计准则收集了非金融类上市公司定期报告中各个期间现金流量表数据，并依据新旧会计准则的科目对应关系，收录主要科目的历史对应数据； 2、收集合并报表、母公司报表数据，包括其对应的本期和上期数据； 3、某个报告期的数据有多次调整，则该表展示最新调整数据；若某报告期暂未披露调整后数据，则已调整类别下的数据与调整前的数据一致； 4、本表中单位为人民币元； 5、带“##”的特殊项目为单个公司披露的非标准化的科目，对应的“特殊字段说明”字段将对其作出说明；带“##”的调整项目是为了让报表的各个小项借贷平衡而设置的，便于客户对报表的遗漏和差错进行判断。
    
    :param secID: 证券内部编码,可通过交易代码和交易市场在DataAPI.SecIDGet获取到,如'000002.XSHE',可以是列表,secID、ticker至少选择一个
    :param ticker: 交易代码,如'000002',可以是列表,secID、ticker至少选择一个
    :param publishDateBegin: 证券交易所披露的信息发布日期，起始时间，默认为1年前当前日期，输入格式“YYYYMMDD”,可空
    :param publishDateEnd: 证券交易所披露的信息发布日期，结束时间，默认为当前日期，输入格式“YYYYMMDD”,可空
    :param beginDate: 会计期间截止日期，起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 会计期间截止日期，结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getFdmtNFCFJY.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        publishDateBegin = publishDateBegin.strftime('%Y%m%d')
    except:
        publishDateBegin = publishDateBegin.replace('-', '')
    requestString.append("&publishDateBegin=%s"%(publishDateBegin))
    try:
        publishDateEnd = publishDateEnd.strftime('%Y%m%d')
    except:
        publishDateEnd = publishDateEnd.replace('-', '')
    requestString.append("&publishDateEnd=%s"%(publishDateEnd))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1100)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1100)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'exchangeCD', u'ticker', u'secShortName', u'repTypeCD', u'infoSource', u'publishDate', u'endDate', u'adjustedFlag', u'mergedFlag', u'accoutingStandards', u'currencyCD', u'CFrSaleGS', u'refundOfTax', u'CFrOthOperateA', u'specOCIF', u'AOCIF', u'CInfFrOperateA', u'CPaidGS', u'CPaidToForEmpl', u'CPaidForTaxes', u'CPaidForOthOpA', u'specOCOF', u'AOCOF', u'COutfOperateA', u'ANOCF', u'NCFOperateA', u'procSellInvest', u'gainInvest', u'dispFixAssetsOth', u'NDispSubsOthBizC', u'CFrOthInvestA', u'specCIF', u'ACIF', u'CInfFrInvestA', u'purFixAssetsOth', u'CPaidInvest', u'NCPaidAcquis', u'NIncrPledgeLoan', u'CPaidOthInvestA', u'specCOF', u'ACOF', u'COutfFrInvestA', u'ANICF', u'NCFFrInvestA', u'CFrCapContr', u'CFrMinoSSubs', u'CFrIssueBond', u'CFrBorr', u'CFrOthFinanA', u'specFCIF', u'AFCIF', u'CInfFrFinanA', u'CPaidForDebts', u'CPaidDivProfInt', u'divProfSubsMinoS', u'CPaidOthFinanA', u'specFCOF', u'AFCOF', u'COutfFrFinanA', u'ANFCF', u'NCFFrFinanA', u'forexEffects', u'othEffectCE', u'ACE', u'NChangeInCash', u'NCEBegBal', u'NCEEndBal', u'NIncome', u'assetsImpairLoss', u'FADepr', u'intanAssetsAmor', u'LTAmorExpAmor', u'amorExpDecr', u'accrExpIncr', u'dispFAOthLoss', u'FAWritOff', u'FValueChgLoss', u'finanExp', u'invLoss', u'deferTADecr', u'deferTLIncr', u'invenDecr', u'operReceiDecr', u'operPayaIncr', u'other', u'specNOCF1', u'ANOCF1', u'NCFOperateANotes', u'contrANOCF', u'convDebtCapi', u'convBonds1Y', u'finanLeaFA', u'CEndBal', u'CBegBal', u'CEEndBal', u'CEBegBal', u'specC', u'AC', u'NChangeInCashNotes', u'contrANC', u'specFieldRemark']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','exchangeCD': 'str','ticker': 'str','secShortName': 'str','repTypeCD': 'str','infoSource': 'str','adjustedFlag': 'str','mergedFlag': 'str','accoutingStandards': 'str','currencyCD': 'str','specFieldRemark': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def BondFdmtBSJYGet(secID = "", ticker = "", publishDateBegin = "", publishDateEnd = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    1、依据2007年新会计准则收集了债券发行人定期报告中各个期间资产负债表数据，并依据新旧会计准则的科目对应关系，收录主要科目的历史对应数据； 2、收集合并报表、母公司报表数据，包括其对应的期末和期初数据； 3、如果上市公司对外财务报表进行更正，调整，该表展示历次调整数据； 4、本表中单位为人民币元； 5、带“##”的特殊项目为单个公司披露的非标准化的科目，对应的“特殊字段说明”字段将对其作出说明；带“##”的调整项目是为了让报表的各个小项借贷平衡而设置的，便于客户对报表的遗漏和差错进行判断。
    
    :param secID: 证券内部编码,可通过交易代码和交易市场在DataAPI.SecIDGet获取到,如'081601.XIBE',可以是列表,secID、ticker至少选择一个
    :param ticker: 交易代码,如'081601',可以是列表,secID、ticker至少选择一个
    :param publishDateBegin: 证券交易所披露的信息发布日期，起始时间，输入格式“YYYYMMDD”,可空
    :param publishDateEnd: 证券交易所披露的信息发布日期，结束时间，输入格式“YYYYMMDD”,可空
    :param beginDate: 会计期间截止日期，起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 会计期间截止日期，结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getBondFdmtBSJY.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        publishDateBegin = publishDateBegin.strftime('%Y%m%d')
    except:
        publishDateBegin = publishDateBegin.replace('-', '')
    requestString.append("&publishDateBegin=%s"%(publishDateBegin))
    try:
        publishDateEnd = publishDateEnd.strftime('%Y%m%d')
    except:
        publishDateEnd = publishDateEnd.replace('-', '')
    requestString.append("&publishDateEnd=%s"%(publishDateEnd))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1101)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1101)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'exchangeCD', u'ticker', u'secShortName', u'repTypeCD', u'infoSource', u'publishDate', u'endDate', u'adjustedFlag', u'mergedFlag', u'accoutingStandards', u'currencyCD', u'cashCEquiv', u'clientDepos', u'tradingFA', u'notesReceiv', u'divReceiv', u'intReceiv', u'AR', u'othReceiv', u'prepayment', u'inventories', u'BBA', u'deferExp', u'NCAWithin1Y', u'othCA', u'CAE', u'CAA', u'TCA', u'availForSaleFA', u'htmInvest', u'investRealEstate', u'LTEquityInvest', u'LTReceiv', u'fixedAssets', u'constMaterials', u'CIP', u'fixedAssetsDisp', u'producBiolAssets', u'oilAndGasAssets', u'intanAssets', u'transacSeatFee', u'RD', u'goodwill', u'LTAmorExp', u'deferTaxAssets', u'othNCA', u'NCAE', u'NCAA', u'TNCA', u'investAsReceiv', u'settProv', u'clientProv', u'deposInOthBFI', u'preciMetals', u'loanToOthBankFI', u'derivAssets', u'purResaleFA', u'disburLA', u'premiumReceiv', u'subrogRecoReceiv', u'reinsurReceiv', u'RRReinsUnePrem', u'RRReinsOutstdCla', u'RRReinsLinsLiab', u'RRReinsLthinsLiab', u'PHPledgeLoans', u'fixedTermDepos', u'refundDepos', u'refundCapDepos', u'indepAccAssets', u'othAssets', u'AE', u'AA', u'TAssets', u'STBorr', u'pledgeBorr', u'tradingFL', u'notesPayable', u'AP', u'STBondPayable', u'advanceReceipts', u'payrollPayable', u'divPayable', u'taxesPayable', u'intPayable', u'othPayable', u'accrExp', u'deferIncome', u'NCLWithin1Y', u'othCl', u'CLE', u'CLA', u'TCL', u'LTBorr', u'bondPayable', u'LTPayable', u'specificPayables', u'estimatedLiab', u'deferTaxLiab', u'othNCL', u'NCLE', u'NCLA', u'TNCL', u'CBBorr', u'deposFrOthBFI', u'loanFrOthBankFI', u'derivLiab', u'soldForRepurFA', u'depos', u'fundsSecTradAgen', u'fundsSecUndwAgen', u'deposReceiv', u'premReceivAdva', u'commisPayable', u'reinsurPayable', u'indemAccPayable', u'policyDivPayable', u'PHInvest', u'reserUnePrem', u'reserOutstdClaims', u'reserLinsLiab', u'reserLthinsLiab', u'indeptAccLiab', u'othLiab', u'LE', u'LA', u'TLiab', u'paidInCapital', u'capitalReser', u'surplusReser', u'retainedEarnings', u'treasuryShare', u'ordinRiskReser', u'forexDiffer', u'unInvestlLoss', u'othReser', u'specialReser', u'SEE', u'SEA', u'TEquityAttrP', u'minorityInt', u'othEffectSe', u'TShEquity', u'LEE', u'LEA', u'TLiabEquity', u'specFieldRemark']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','exchangeCD': 'str','ticker': 'str','secShortName': 'str','repTypeCD': 'str','infoSource': 'str','adjustedFlag': 'str','mergedFlag': 'str','accoutingStandards': 'str','currencyCD': 'str','specFieldRemark': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def BondFdmtISJYGet(secID = "", ticker = "", publishDateBegin = "", publishDateEnd = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    1、依据2007年新会计准则收集了债券发行人定期报告中各个期间利润表数据，并依据新旧会计准则的科目对应关系，收录主要科目的历史对应数据； 2、收集合并报表、母公司报表数据，包括其对应的本期和上期数据； 3、如果上市公司对外财务报表进行更正，调整，该表展示历次调整数据； 4、本表中单位为人民币元； 5、带“##”的特殊项目为单个公司披露的非标准化的科目，对应的“特殊字段说明”字段将对其作出说明；带“##”的调整项目是为了让报表的各个小项借贷平衡而设置的，便于客户对报表的遗漏和差错进行判断。
    
    :param secID: 证券内部编码,可通过交易代码和交易市场在DataAPI.SecIDGet获取到,如'081601.XIBE',可以是列表,secID、ticker至少选择一个
    :param ticker: 交易代码,如'081601',可以是列表,secID、ticker至少选择一个
    :param publishDateBegin: 证券交易所披露的信息发布日期，起始时间，输入格式“YYYYMMDD”,可空
    :param publishDateEnd: 证券交易所披露的信息发布日期，结束时间，输入格式“YYYYMMDD”,可空
    :param beginDate: 会计期间截止日期，起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 会计期间截止日期，结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getBondFdmtISJY.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        publishDateBegin = publishDateBegin.strftime('%Y%m%d')
    except:
        publishDateBegin = publishDateBegin.replace('-', '')
    requestString.append("&publishDateBegin=%s"%(publishDateBegin))
    try:
        publishDateEnd = publishDateEnd.strftime('%Y%m%d')
    except:
        publishDateEnd = publishDateEnd.replace('-', '')
    requestString.append("&publishDateEnd=%s"%(publishDateEnd))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1102)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1102)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'exchangeCD', u'ticker', u'secShortName', u'repTypeCD', u'infoSource', u'publishDate', u'endDate', u'adjustedFlag', u'mergedFlag', u'accoutingStandards', u'industryCategory', u'currencyCD', u'TRevenue', u'revenue', u'NIntIncome', u'intIncome', u'intExp', u'NCommisIncome', u'commisIncome', u'commisExp', u'NSecTaIncome', u'NUndwrtSecIncome', u'NTrustIncome', u'premEarned', u'grossPremWrit', u'reinsIncome', u'reinsur', u'unePremReser', u'othRevenue', u'specOR', u'AOR', u'TCOGS', u'payout', u'premRefund', u'compensPayout', u'compensPayoutRefu', u'reserInsurLiab', u'insurLiabReserRefu', u'policyDivPayt', u'reinsurExp', u'genlAdminExp', u'reinsCostRefund', u'insurCommisExp', u'othCost', u'COGS', u'bizTaxSurchg', u'sellExp', u'adminExp', u'finanExp', u'assetsImpairLoss', u'specTOC', u'ATOC', u'othNetRevenue', u'FValueChgGain', u'investIncome', u'AJInvestIncome', u'forexGain', u'othEffectOP', u'AEffectOP', u'operateProfit', u'NoperateIncome', u'NoperateExp', u'NCADisploss', u'othEffectTP', u'AEffectTP', u'TProfit', u'incomeTax', u'unInvestLoss', u'othEffectNP', u'AEffectNP', u'NIncome', u'NIncomeAttrP', u'minorityGain', u'othEffectNPP', u'AEffectNPP', u'othComprIncome', u'AEffectCI', u'TComprIncome', u'comprIncAttrP', u'comprIncAttrMS', u'AEffectPCI', u'basicEPS', u'dilutedEPS']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','exchangeCD': 'str','ticker': 'str','secShortName': 'str','repTypeCD': 'str','infoSource': 'str','adjustedFlag': 'str','mergedFlag': 'str','accoutingStandards': 'str','industryCategory': 'str','currencyCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def BondFdmtCFJYGet(secID = "", ticker = "", publishDateBegin = "", publishDateEnd = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    1、依据2007年新会计准则收集了债券发行人定期报告中各个期间现金流量表数据，并依据新旧会计准则的科目对应关系，收录主要科目的历史对应数据； 2、收集合并报表、母公司报表数据，包括其对应的本期和上期数据； 3、如果上市公司对外财务报表进行更正，调整，该表展示历次调整数据； 4、本表中单位为人民币元； 5、带“##”的特殊项目为单个公司披露的非标准化的科目，对应的“特殊字段说明”字段将对其作出说明；带“##”的调整项目是为了让报表的各个小项借贷平衡而设置的，便于客户对报表的遗漏和差错进行判断。
    
    :param secID: 证券内部编码,可通过交易代码和交易市场在DataAPI.SecIDGet获取到,如'081601.XIBE',可以是列表,secID、ticker至少选择一个
    :param ticker: 交易代码,如'081601',可以是列表,secID、ticker至少选择一个
    :param publishDateBegin: 证券交易所披露的信息发布日期，起始时间，输入格式“YYYYMMDD”,可空
    :param publishDateEnd: 证券交易所披露的信息发布日期，结束时间，输入格式“YYYYMMDD”,可空
    :param beginDate: 会计期间截止日期，起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 会计期间截止日期，结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getBondFdmtCFJY.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        publishDateBegin = publishDateBegin.strftime('%Y%m%d')
    except:
        publishDateBegin = publishDateBegin.replace('-', '')
    requestString.append("&publishDateBegin=%s"%(publishDateBegin))
    try:
        publishDateEnd = publishDateEnd.strftime('%Y%m%d')
    except:
        publishDateEnd = publishDateEnd.replace('-', '')
    requestString.append("&publishDateEnd=%s"%(publishDateEnd))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1103)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1103)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'exchangeCD', u'ticker', u'secShortName', u'repTypeCD', u'infoSource', u'publishDate', u'endDate', u'adjustedFlag', u'mergedFlag', u'accoutingStandards', u'industryCategory', u'currencyCD', u'CFrSaleGS', u'refundOfTax', u'NDeposIncrCFI', u'NIncrBorrFrCB', u'NIncBorrOthFI', u'drawBackLoansC', u'IFCCashIncr', u'NIncDispTradFA', u'NCapIncrRepur', u'premFrOrigContr', u'NReinsurPrem', u'NIncPhDeposInv', u'CFrOthOperateA', u'specOCIF', u'AOCIF', u'CInfFrOperateA', u'CPaidGS', u'CPaidToForEmpl', u'CPaidForTaxes', u'NIncDisburOfLA', u'netIncrDeposInFI', u'NIncrLoansToOthFI', u'CPaidIFC', u'origContrCIndem', u'NForReinsurPrem', u'CPaidPolDiv', u'CPaidForOthOpA', u'specOCOF', u'AOCOF', u'COutfOperateA', u'ANOCF', u'NCFOperateA', u'procSellInvest', u'gainInvest', u'dispFixAssetsOth', u'NDispSubsOthBizC', u'CFrOthInvestA', u'specCIF', u'ACIF', u'CInfFrInvestA', u'purFixAssetsOth', u'CPaidInvest', u'NCPaidAcquis', u'NIncrPledgeLoan', u'CPaidOthInvestA', u'specCOF', u'ACOF', u'COutfFrInvestA', u'ANICF', u'NCFFrInvestA', u'CFrCapContr', u'CFrMinoSSubs', u'CFrIssueBond', u'CFrBorr', u'CFrOthFinanA', u'specFCIF', u'AFCIF', u'CInfFrFinanA', u'CPaidForDebts', u'CPaidDivProfInt', u'divProfSubsMinoS', u'CPaidOthFinanA', u'specFCOF', u'AFCOF', u'COutfFrFinanA', u'ANFCF', u'NCFFrFinanA', u'forexEffects', u'othEffectCE', u'ACE', u'NChangeInCash', u'NCEBegBal', u'othEffectCEI', u'ACEI', u'NCEEndBal', u'NIncome', u'minorityGain', u'assetsImpairLoss', u'FADepr', u'intanAssetsAmor', u'LTAmorExpAmor', u'amorExpDecr', u'accrExpIncr', u'dispFAOthLoss', u'FAWritOff', u'FValueChgLoss', u'finanExp', u'invLoss', u'deferTADecr', u'deferTLIncr', u'invenDecr', u'operReceiDecr', u'operPayaIncr', u'other', u'specNOCF1', u'ANOCF1', u'NCFOperateANotes', u'contrANOCF', u'convDebtCapi', u'convBonds1Y', u'finanLeaFA', u'CEndBal', u'CBegBal', u'CEEndBal', u'CEBegBal', u'specC', u'AC', u'NChangeInCashNotes', u'contrANC', u'specFieldRemark']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','exchangeCD': 'str','ticker': 'str','secShortName': 'str','repTypeCD': 'str','infoSource': 'str','adjustedFlag': 'str','mergedFlag': 'str','accoutingStandards': 'str','industryCategory': 'str','currencyCD': 'str','specFieldRemark': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FdmtEEJYGet(secID = "", ticker = "", publishDateBegin = "", publishDateEnd = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取上市公司披露的业绩快报中的主要财务指标等其他数据，包括本期，去年同期，及本期与期初数值同比数据。（若上市公司同时发行债券等其他证券，也可通过其他证券代码查询快报数据）
    
    :param secID: 证券内部编码,可通过交易代码和交易市场在DataAPI.SecIDGet获取到,如'000002.XSHE',可以是列表,secID、ticker至少选择一个
    :param ticker: 交易代码,如'600000',可以是列表,secID、ticker至少选择一个
    :param publishDateBegin: 证券交易所披露的信息发布日期，起始时间，输入格式“YYYYMMDD”,可空
    :param publishDateEnd: 证券交易所披露的信息发布日期，结束时间，默认为当前日期，输入格式“YYYYMMDD”,可空
    :param beginDate: 会计期间截止日期，起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 会计期间截止日期，结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getFdmtEEJY.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        publishDateBegin = publishDateBegin.strftime('%Y%m%d')
    except:
        publishDateBegin = publishDateBegin.replace('-', '')
    requestString.append("&publishDateBegin=%s"%(publishDateBegin))
    try:
        publishDateEnd = publishDateEnd.strftime('%Y%m%d')
    except:
        publishDateEnd = publishDateEnd.replace('-', '')
    requestString.append("&publishDateEnd=%s"%(publishDateEnd))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1104)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1104)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'exchangeCD', u'ticker', u'secShortName', u'publishDate', u'endDate', u'mark', u'perMarkCD', u'revenue', u'primeOperRev', u'grossProfit', u'operateProfit', u'TProfit', u'NINCOMEAttrP', u'NINCOMECut', u'NCFOperA', u'basicEPS', u'EPSW', u'EPSCut', u'EPSCutW', u'ROE', u'ROEW', u'ROECut', u'ROECutW', u'NCFOperAPS', u'TAssets', u'TEquityAttrP', u'paidInCapital', u'NAssetPS', u'revenueLY', u'primeOperRevLY', u'grossProfitLY', u'operProfitLY', u'TProfitLY', u'NIncomeAttrPLY', u'NIncomeCutLY', u'NCFOperALY', u'basicEPSLY', u'EPSWLY', u'EPSCutLY', u'EPSCutWLY', u'ROELY', u'ROEWLY', u'ROECutLY', u'ROECutWLY', u'NCFOperAPSLY', u'TAssetsLY', u'TEquityAttrPLY', u'NAssetPSLY', u'revenueYOY', u'primeOperRevYOY', u'grossProfitYOY', u'operProfitYOY', u'TProfitYOY', u'NIncomeAttrPYOY', u'NIncomeCutYOY', u'NCFOperAYOY', u'basicEPSYOY', u'EPSWYOY', u'EPSCutYOY', u'EPSCutWYOY', u'ROEYOY', u'ROEWYOY', u'ROECutYOY', u'ROECutWYOY', u'NCFOperAPSYOY', u'TAssetsYOY', u'TEquityAttrPYOY', u'NAssetPSYOY']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','exchangeCD': 'str','ticker': 'str','secShortName': 'str','mark': 'str','perMarkCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FdmtEFJYGet(secID = "", ticker = "", publishDateBegin = "", publishDateEnd = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取上市公司披露的公告中的预期下一报告期收入、净利润、基本每股收益及其幅度变化等数据。（若上市公司同时发行债券等其他证券，也可通过其他证券代码查询预告数据）
    
    :param secID: 证券内部编码,可通过交易代码和交易市场在DataAPI.SecIDGet获取到,如'000002.XSHE',可以是列表,secID、ticker至少选择一个
    :param ticker: 交易代码,如'000005',可以是列表,secID、ticker至少选择一个
    :param publishDateBegin: 证券交易所披露的信息发布日期，起始时间，输入格式“YYYYMMDD”,可空
    :param publishDateEnd: 证券交易所披露的信息发布日期，结束时间，默认为当前日期，输入格式“YYYYMMDD”,可空
    :param beginDate: 会计期间截止日期，起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 会计期间截止日期，结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getFdmtEFJY.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        publishDateBegin = publishDateBegin.strftime('%Y%m%d')
    except:
        publishDateBegin = publishDateBegin.replace('-', '')
    requestString.append("&publishDateBegin=%s"%(publishDateBegin))
    try:
        publishDateEnd = publishDateEnd.strftime('%Y%m%d')
    except:
        publishDateEnd = publishDateEnd.replace('-', '')
    requestString.append("&publishDateEnd=%s"%(publishDateEnd))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1105)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1105)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'exchangeCD', u'ticker', u'secShortName', u'publishDate', u'endDate', u'forecastObjCD', u'forecastType', u'resultStat', u'forecastCont', u'revChgrLL', u'revChgrUPL', u'expRevLL', u'expRevUPL', u'NIncomeChgrLL', u'NIncomeChgrUPL', u'expnIncomeLL', u'expnIncomeUPL', u'expEPSLL', u'expEPSUPL', u'NPYOYConFor']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','exchangeCD': 'str','ticker': 'str','secShortName': 'str','forecastObjCD': 'str','forecastType': 'str','resultStat': 'str','forecastCont': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FdmtPrimeOperJYGet(secID = "", ticker = "", partyID = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    按行业、产品、地区、业务4个维度记录上市公司主营业务构成；包含有本期与上期主营业务收入、主营业务成本、主营业务利润以及与上期同比；历史数据：最早数据日期可追溯至1998年。
    
    :param secID: 证券ID，编制的唯一识别证券的编码；支持多值输入，如如'000001.XSHE,600000.XSHG',可以是列表,secID、ticker、partyID至少选择一个
    :param ticker: 证券交易代码，支持输入多值，如'000001,600000',可以是列表,secID、ticker、partyID至少选择一个
    :param partyID: 公司ID，编制的唯一识别公司的编码；支持多值输入，如'2,603',可以是列表,secID、ticker、partyID至少选择一个
    :param beginDate: 开始日期，输入格式“YYYYMMDD”,可空
    :param endDate: 结束日期，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getFdmtPrimeOperJY.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&partyID=")
    if hasattr(partyID,'__iter__') and not isinstance(partyID, str):
        if len(partyID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = partyID
            requestString.append(None)
        else:
            requestString.append(','.join(partyID))
    else:
        requestString.append(partyID)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'partyID', u'endDate', u'dataType', u'infoSource', u'mergedFlag', u'adjustedFlag', u'operClassCD', u'operClass', u'SN', u'operProject', u'primeOperRev', u'primeOperCogs', u'grossProfit', u'primeOperRevLY', u'primeOperCogsLY', u'grossProfitLY', u'primeOperRevYOY', u'primeOperCogsYOY', u'grossProfitYOY']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str','infoSource': 'str','operClass': 'str','operProject': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FdmtISFinExpPSJYGet(secID = "", ticker = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    1、上市公司财务费用科目明细 2、单位：元
    
    :param secID: 证券内部编码,可通过交易代码和交易市场在DataAPI.SecIDGet获取到,如'000002.XSHE',可以是列表,secID、ticker至少选择一个
    :param ticker: 交易代码,如'000002',可以是列表,secID、ticker至少选择一个
    :param beginDate: 会计期间截止日期，起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 会计期间截止日期，结束时间，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getFdmtISFinExpPSJY.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1470)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1470)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'exchangeCD', u'ticker', u'secShortName', u'endDate', u'mergedFlag', u'adjustedFlag', u'infoSource', u'intExp', u'FOccuExp', u'intExpDisc', u'intExpCapital', u'intIncome', u'FOccuIncome', u'intIncomeDisc', u'forexLoss', u'forexLossCapital', u'forexGain', u'CDiscount', u'othFinIncome', u'commission', u'SecuExp', u'othFinExp', u'finExp', u'chgPublishDate']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','exchangeCD': 'str','ticker': 'str','secShortName': 'str','adjustedFlag': 'str','infoSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FdmtMainOperJYGet(ticker = "", secID = "", endDate = "", beginDate = "", fiscalPeriod = "", mergedFlag = "", adjustedFlag = "", classifCD = "", field = "", pandas = "1"):
    """
    1、公司主营业务的收入来源、成本构成 2、公司主营业务收入、成本和利润与上年同期的对比较
    
    :param ticker: 股票交易代码，如'000002',可以是列表,ticker、secID至少选择一个
    :param secID: 证券内部编码,可通过交易代码和交易市场在DataAPI.SecIDGet获取到,如'000002.XSHE',可以是列表,ticker、secID至少选择一个
    :param endDate: 会计期间截止日期，结束时间，输入格式“YYYYMMDD”,可空
    :param beginDate: 会计期间截止日期，起始时间，输入格式“YYYYMMDD”,可空
    :param fiscalPeriod: 会计期间长度，3-3个月，6-6个月，9-9个月，12-12个月,可空
    :param mergedFlag: 合并类型。1-合并,2-母公司。对应DataAPI.SysCodeGet.codeTypeID=70003。,可空
    :param adjustedFlag: 是否调整数据。010104-调整，020101-未调整，030000-前。对应DataAPI.SysCodeGet.codeTypeID=70007。,可空
    :param classifCD: 主营业务分类方式。101-按行业，102-按产品，103-按地区。对应DataAPI.SysCodeGet.codeTypeID=70016。,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getFdmtMainOperJY.csv?ispandas=1&') 
    requestString.append("ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    if not isinstance(fiscalPeriod, str) and not isinstance(fiscalPeriod, unicode):
        fiscalPeriod = str(fiscalPeriod)

    requestString.append("&fiscalPeriod=%s"%(fiscalPeriod))
    if not isinstance(mergedFlag, str) and not isinstance(mergedFlag, unicode):
        mergedFlag = str(mergedFlag)

    requestString.append("&mergedFlag=%s"%(mergedFlag))
    if not isinstance(adjustedFlag, str) and not isinstance(adjustedFlag, unicode):
        adjustedFlag = str(adjustedFlag)

    requestString.append("&adjustedFlag=%s"%(adjustedFlag))
    if not isinstance(classifCD, str) and not isinstance(classifCD, unicode):
        classifCD = str(classifCD)

    requestString.append("&classifCD=%s"%(classifCD))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1491)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1491)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'partyID', u'ticker', u'secShortName', u'exchangeCD', u'endDate', u'fiscalPeriod', u'infoSource', u'mergedFlag', u'ifMerged', u'adjustedFlag', u'ifAdjusted', u'classifCD', u'classif', u'itemNO', u'itemName', u'enterpNatCD', u'enterpNat', u'MORevenue', u'MOCost', u'MOIncome', u'MORevenueLY', u'MOCostLY', u'MOIncomeLY', u'MORevenueYOY', u'MOCostYOY', u'MOIncomeYOY']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str','infoSource': 'str','mergedFlag': 'str','ifMerged': 'str','adjustedFlag': 'str','ifAdjusted': 'str','classifCD': 'str','classif': 'str','itemName': 'str','enterpNatCD': 'str','enterpNat': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FdmtMainIndiROEJYGet(ticker = "", secID = "", endDate = "", beginDate = "", publishDateEnd = "", publishDateBegin = "", field = "", pandas = "1"):
    """
    1、收集主要财务指标表ROE部分 2、若某个报告期的数据有多次调整，则该表展示最新调整数据；若某报告期暂未披露调整后数据，则已调整类别下的数据与调整前的数据一致。 3、该表中各财务科目的单位均为人民币元。
    
    :param ticker: 股票交易代码，如'000002',可以是列表,ticker、secID至少选择一个
    :param secID: 证券内部编码,可通过交易代码和交易市场在DataAPI.SecIDGet获取到,如'000002.XSHE',可以是列表,ticker、secID至少选择一个
    :param endDate: 会计期间截止日期，结束时间，输入格式“YYYYMMDD”,可空
    :param beginDate: 会计期间截止日期，起始时间，输入格式“YYYYMMDD”,可空
    :param publishDateEnd: 证券交易所披露的信息发布日期，截止时间，默认为当前日期，输入格式“YYYYMMDD”,可空
    :param publishDateBegin: 证券交易所披露的信息发布日期，开始时间，默认为1年前当前日期，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getFdmtMainIndiROEJY.csv?ispandas=1&') 
    requestString.append("ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        publishDateEnd = publishDateEnd.strftime('%Y%m%d')
    except:
        publishDateEnd = publishDateEnd.replace('-', '')
    requestString.append("&publishDateEnd=%s"%(publishDateEnd))
    try:
        publishDateBegin = publishDateBegin.strftime('%Y%m%d')
    except:
        publishDateBegin = publishDateBegin.replace('-', '')
    requestString.append("&publishDateBegin=%s"%(publishDateBegin))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1498)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1498)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'partyID', u'ticker', u'secShortName', u'exchangeCD', u'endDate', u'publishDate', u'infoSource', u'mark', u'markCN', u'ROE', u'ROECal', u'ROECut', u'ROEW', u'ROECutW']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str','infoSource': 'str','markCN': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FdmtISFvciPsJYGet(secID = "", ticker = "", beginDate = "", endDate = "", itemCD = "", field = "", pandas = "1"):
    """
    1、描述了上市公司2007年之后的公允价值变动收益的明细情况。2、对于公告原文披露的项目名称，收录在“科目名称(ITEM_NAME)”中；“科目代码(ITEM_CD)”则对披露的科目进行了归类，以便于横向比较。
    
    :param secID: 证券内部编码,可通过交易代码和交易市场在DataAPI.SecIDGet获取到,如'000002.XSHE',可以是列表,secID、ticker至少选择一个
    :param ticker: 交易代码,如'000002',可以是列表,secID、ticker至少选择一个
    :param beginDate: 会计期间截止日期，起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 会计期间截止日期，结束时间，输入格式“YYYYMMDD”,可空
    :param itemCD: 科目代码。2045-公允价值变动收益；204501-交易性金融资产变动收益；204502-衍生金融工具变动收益；204503-投资性房地产公允变动收益；204504-其他公允变动收益。对应DataAPI.SysCodeGet.codeTypeID=70014。,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getFdmtISFvciPsJY.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&itemCD=")
    if hasattr(itemCD,'__iter__') and not isinstance(itemCD, str):
        if len(itemCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = itemCD
            requestString.append(None)
        else:
            requestString.append(','.join(itemCD))
    else:
        requestString.append(itemCD)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1526)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1526)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'exchangeCD', u'ticker', u'secShortName', u'endDate', u'infoSource', u'mark', u'markCN', u'itemCD', u'item', u'itemName', u'valLy', u'val', u'remarks']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','exchangeCD': 'str','ticker': 'str','secShortName': 'str','infoSource': 'str','mark': 'str','markCN': 'str','itemCD': 'str','item': 'str','itemName': 'str','remarks': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FdmtBSPsJYGet(secID = "", ticker = "", beginDate = "", endDate = "", itemTypeCD = "", itemCD = "", field = "", pandas = "1"):
    """
    1、描述新会计准则下，上市公司2007年资产负债表附注的明细情况。2、对于公告原文披露的项目名称，收录在“科目名称(ITEM_NAME)”中；“科目代码(ITEM_CD)”。3、包括除固定资产，无形资产以外所有资产负债表科目的附注，科目分类(ITEM_CD)为资产负债表科目代码
    
    :param secID: 证券内部编码,可通过交易代码和交易市场在DataAPI.SecIDGet获取到,如'000002.XSHE',可以是列表,secID、ticker至少选择一个
    :param ticker: 交易代码,如'000002',可以是列表,secID、ticker至少选择一个
    :param beginDate: 会计期间截止日期，起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 会计期间截止日期，结束时间，输入格式“YYYYMMDD”,可空
    :param itemTypeCD: 科目类别代码。1001-货币资金；1006-交易性金融资产；1007-应收票据；1008-应收帐款；1009-预付帐款；1015-其他应收款；1017-存货；1024-可供出售金融资产；1066-短期借款；1073-应付帐款；1074-预收帐款；1077-应付职工薪酬；1081-其他应付款；1086-一年内到期的长期负债；1091-长期借款；1095-预计负债；1101-资产减值准备；1117-资本公积；1120-盈余公积；1200-短期投资；1200-预提费用；1202-长期投资；1078-应交税金。对应DataAPI.SysCodeGet.codeTypeID=70014。,可以是列表,可空
    :param itemCD: 科目代码。对应DataAPI.SysCodeGet.codeTypeID=70014。,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getFdmtBSPsJY.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&itemTypeCD=")
    if hasattr(itemTypeCD,'__iter__') and not isinstance(itemTypeCD, str):
        if len(itemTypeCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = itemTypeCD
            requestString.append(None)
        else:
            requestString.append(','.join(itemTypeCD))
    else:
        requestString.append(itemTypeCD)
    if not isinstance(itemCD, str) and not isinstance(itemCD, unicode):
        itemCD = str(itemCD)

    requestString.append("&itemCD=%s"%(itemCD))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1527)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1527)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'exchangeCD', u'ticker', u'secShortName', u'endDate', u'infoSource', u'mark', u'markCn', u'itemTypeCD', u'itemType', u'itemCD', u'item', u'itemName', u'openVal', u'provOpen', u'increaseCur', u'increaseMA', u'increaseBack', u'increaseOth', u'decreaseCur', u'decreaseBack', u'decreaseAmor', u'decreaseOth', u'endVal', u'provEnd', u'remarks']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','exchangeCD': 'str','ticker': 'str','secShortName': 'str','infoSource': 'str','mark': 'str','markCn': 'str','itemTypeCD': 'str','itemType': 'str','itemCD': 'str','item': 'str','itemName': 'str','remarks': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FdmtMainIndiJYGet(secID = "", ticker = "", beginDate = "", endDate = "", publishDateBegin = "", publishDateEnd = "", mark = "", field = "", pandas = "1"):
    """
    1、反映上市公司2007年后的主要财务指标。2、若某个报告期的数据有多次调整，则该表展示最新调整数据；若某报告期暂未披露调整后数据，则已调整类别下的数据与调整前的数据一致。3、计价货币为人民币：元。
    
    :param secID: 证券内部编码,可通过交易代码和交易市场在DataAPI.SecIDGet获取到,如'000002.XSHE',可以是列表,secID、ticker至少选择一个
    :param ticker: 交易代码,如'000002',可以是列表,secID、ticker至少选择一个
    :param beginDate: 会计期间截止日期，起始时间，输入格式“YYYYMMDD”，默认为一年前当前日期,可空
    :param endDate: 会计期间截止日期，结束时间，输入格式“YYYYMMDD”，默认为当前日期,可空
    :param publishDateBegin: 证券交易所披露的信息发布日期，截止时间，默认为当前日期，输入格式“YYYYMMDD”,可空
    :param publishDateEnd: 证券交易所披露的信息发布日期，开始时间，默认为1年前当前日期，输入格式“YYYYMMDD”,可空
    :param mark: 合并调整标志：1-合并调整，2-合并未调整,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getFdmtMainIndiJY.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    try:
        publishDateBegin = publishDateBegin.strftime('%Y%m%d')
    except:
        publishDateBegin = publishDateBegin.replace('-', '')
    requestString.append("&publishDateBegin=%s"%(publishDateBegin))
    try:
        publishDateEnd = publishDateEnd.strftime('%Y%m%d')
    except:
        publishDateEnd = publishDateEnd.replace('-', '')
    requestString.append("&publishDateEnd=%s"%(publishDateEnd))
    requestString.append("&mark=")
    if hasattr(mark,'__iter__') and not isinstance(mark, str):
        if len(mark) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = mark
            requestString.append(None)
        else:
            requestString.append(','.join(mark))
    else:
        requestString.append(mark)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1528)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1528)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'partyID', u'ticker', u'secShortName', u'exchangeCD', u'publishDate', u'endDate', u'infoSource', u'mark', u'markCN', u'ROE', u'ROECal', u'ROECut', u'ROEW', u'ROECutW', u'basicEPS', u'dilutedEPS', u'basicEPSCut', u'dilutedEPSCut', u'EPS', u'revenue', u'investIncome', u'finanExp', u'FValueChgGain', u'operateProfit', u'noperateIncome', u'noperateExp', u'TProfit', u'incomeTax', u'unInvestLoss', u'NIncomeAttrP', u'minorityGain', u'NIncome', u'nonRecGainLoss', u'NIncomeCut', u'NIncomeISA', u'MargStatement', u'NCFOperateA', u'NCFOperAPS', u'NCFFrInvestA', u'NCFFrFinanA', u'NChangeInCash', u'forexEffects', u'NCEEndBal', u'cashCEquiv', u'tradingFA', u'intReceiv', u'divReceiv', u'AR', u'othReceiv', u'inventories', u'TCA', u'availForSaleFA', u'htmInvest', u'investRealEstate', u'LTEquityInvest', u'intanAssets', u'TNCA', u'TAssets', u'STBorr', u'tradingFL', u'payrollPayable', u'divPayable', u'taxesPayable', u'intPayable', u'othPayable', u'NCLWithin1Y', u'TCL', u'TNCL', u'TLiab', u'paidInCapital', u'capitalReser', u'surplusReser', u'retainedEarnings', u'TEquityAttrP', u'minorityInt', u'TShEquity', u'TLiabEquity', u'NAssetISA', u'NAssetPS', u'NAssetPSCal', u'NAssetPSAdj', u'totalShares', u'divStatement', u'TRecompense', u'acconutExp', u'nonstanAuditOp']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str','infoSource': 'str','markCN': 'str','MargStatement': 'str','divStatement': 'str','nonstanAuditOp': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FdmtBSFaPsJYGet(secID = "", ticker = "", beginDate = "", endDate = "", itemCD = "", field = "", pandas = "1"):
    """
    1. 自2007年起，描述新会计准则下，上市公司固定资产及折旧的明细情况，包括固定资产的原值、累计折旧、减值准备、账面价值、净值等各项的期初、期间变化和期末数据。2. 对于公告原文披露的项目名称，收录在“科目名称(ITEM_NAME)”中；“科目分类(ITEM_CD)”则对披露的科目进行了归类，以便于横向比较。
    
    :param secID: 证券内部编码,可通过交易代码和交易市场在DataAPI.SecIDGet获取到,如'000002.XSHE',可以是列表,secID、ticker至少选择一个
    :param ticker: 交易代码,如'000002',可以是列表,secID、ticker至少选择一个
    :param beginDate: 会计期间截止日期，起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 会计期间截止日期，结束时间，输入格式“YYYYMMDD”,可空
    :param itemCD: 科目代码。1029-固定资产合计,102901-房屋、建筑物,102902-机器设备,102903-运输工具,102904-电气设备,102905-电子设备,102906-计算机及辅助设备,102907-通讯设备,102908-仪器仪表、计量标准器具及量具、衡器,102909-办公设备,102910-通用设备,102911-专用设备,102912-经营租赁租出设备,102913-融资租入固定资产,102914-文艺体育设备,102915-图书文物及陈列品,102916-家具用具,102917-其他设备,102918-路桥及构筑物,102919-飞机,102920-多项资产合并,102921-其他固定资产。对应DataAPI.SysCodeGet.codeTypeID=70014。,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getFdmtBSFaPsJY.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    if not isinstance(itemCD, str) and not isinstance(itemCD, unicode):
        itemCD = str(itemCD)

    requestString.append("&itemCD=%s"%(itemCD))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1529)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1529)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'endDate', u'itemCD', u'item', u'itemNo', u'itemName', u'mark', u'markCn', u'infoSource', u'openValCost', u'increaseCurCost', u'decreaseCurCost', u'endValCost', u'openValAccu', u'increaseCurAccu', u'decreaseCurAccu', u'endValAccu', u'openValNv', u'increaseCurNv', u'decreaseCurNv', u'endValNv', u'openValDr', u'increaseCurDr', u'decreaseCurDr', u'endValDr', u'openValBv', u'increaseCurBv', u'decreaseCurBv', u'endValBv', u'remarks']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str','itemCD': 'str','item': 'str','itemNo': 'str','itemName': 'str','mark': 'str','markCn': 'str','infoSource': 'str','remarks': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FdmtBSIaPsJYGet(secID = "", ticker = "", beginDate = "", endDate = "", itemCD = "", field = "", pandas = "1"):
    """
    1. 自2007年起，描述新会计准则下，上市公司无形资产的明细情况。2. 对于公告原文披露的项目名称，收录在“科目名称(ITEM_NAME)”中；“科目代码(ITEM_CD)”则对披露的科目进行了归类，以便于横向比较。
    
    :param secID: 证券内部编码,可通过交易代码和交易市场在DataAPI.SecIDGet获取到,如'000002.XSHE',可以是列表,secID、ticker至少选择一个
    :param ticker: 交易代码,如'000002',可以是列表,secID、ticker至少选择一个
    :param beginDate: 会计期间截止日期，起始时间，输入格式“YYYYMMDD”,可空
    :param endDate: 会计期间截止日期，结束时间，输入格式“YYYYMMDD”,可空
    :param itemCD: 科目代码。1036-无形资产合计,103601-房屋及建筑物,103602-其他投资性房地产,103603-土地使用权,103604-特许使用权,103605-其他使用权,103606-经营权,103607-商标,103608-商誉,103609-软件,103610-专利,103611-专有技术、非专利技术、技术投资,10361101-#专有技术,10361102-#非专利技术,103612-矿区权益,103614-井及相关设施,103615-其他油气资产,103616-其他无形资产,103617-种植业,103618-林业,103619-水产业,103620-其他生产性生物资产,10361201-未探明矿区权益,10361202-探明矿区权益,103699-合计特别调整。对应DataAPI.SysCodeGet.codeTypeID=70014。,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getFdmtBSIaPsJY.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    if not isinstance(itemCD, str) and not isinstance(itemCD, unicode):
        itemCD = str(itemCD)

    requestString.append("&itemCD=%s"%(itemCD))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1530)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1530)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'endDate', u'infoSource', u'mark', u'markCn', u'itemCD', u'item', u'itemName', u'bookValueOpen', u'increaseCur', u'increaseMA', u'increaseWrtBack', u'increaseOthr', u'decreaseCur', u'decreaseTransOut', u'decreaseAmor', u'decreaseOthr', u'bookValueClose', u'accumAmor', u'origValueClose', u'calcSumOpen', u'calcSumClose', u'resiAmorTerm', u'getWay', u'remarks']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str','infoSource': 'str','mark': 'str','markCn': 'str','itemCD': 'str','item': 'str','itemName': 'str','getWay': 'str','remarks': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FdmtISFvciPsLatelyJYGet(field = "", pandas = "1"):
    """
    1、描述了上市公司2007年之后的公允价值变动收益的明细情况。2、对于公告原文披露的项目名称，收录在“科目名称(ITEM_NAME)”中；“科目代码(ITEM_CD)”则对披露的科目进行了归类，以便于横向比较。3、最新一期会计期间数据
    
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getFdmtISFvciPsLatelyJY.csv?ispandas=1&') 
    requestString.append("field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1531)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1531)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'exchangeCD', u'ticker', u'secShortName', u'endDate', u'infoSource', u'mark', u'markCN', u'itemCD', u'item', u'itemName', u'valLy', u'val', u'remarks']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','exchangeCD': 'str','ticker': 'str','secShortName': 'str','infoSource': 'str','mark': 'str','markCN': 'str','itemCD': 'str','item': 'str','itemName': 'str','remarks': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FdmtBSPsLatelyJYGet(field = "", pandas = "1"):
    """
    1、描述新会计准则下，上市公司2007年资产负债表附注的明细情况。2、对于公告原文披露的项目名称，收录在“科目名称(ITEM_NAME)”中；“科目代码(ITEM_CD)”。3、包括除固定资产，无形资产以外所有资产负债表科目的附注，科目分类(ITEM_CD)为资产负债表科目代码。4、最新一期会计期间数据
    
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getFdmtBSPsLatelyJY.csv?ispandas=1&') 
    requestString.append("field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1532)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1532)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'exchangeCD', u'ticker', u'secShortName', u'endDate', u'infoSource', u'mark', u'markCn', u'itemTypeCD', u'itemType', u'itemCD', u'item', u'itemName', u'openVal', u'provOpen', u'increaseCur', u'increaseMA', u'increaseBack', u'increaseOth', u'decreaseCur', u'decreaseBack', u'decreaseAmor', u'decreaseOth', u'endVal', u'provEnd', u'remarks']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','exchangeCD': 'str','ticker': 'str','secShortName': 'str','infoSource': 'str','mark': 'str','markCn': 'str','itemTypeCD': 'str','itemType': 'str','itemCD': 'str','item': 'str','itemName': 'str','remarks': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FdmtMainIndiLatelyJYGet(field = "", pandas = "1"):
    """
    1、反映上市公司2007年后的主要财务指标。2、若某个报告期的数据有多次调整，则该表展示最新调整数据；若某报告期暂未披露调整后数据，则已调整类别下的数据与调整前的数据一致。3、计价货币为人民币：元。4、最新一期会计期间数据
    
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getFdmtMainIndiLatelyJY.csv?ispandas=1&') 
    requestString.append("field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1533)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1533)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'partyID', u'ticker', u'secShortName', u'exchangeCD', u'publishDate', u'endDate', u'infoSource', u'mark', u'markCN', u'ROE', u'ROECal', u'ROECut', u'ROEW', u'ROECutW', u'basicEPS', u'dilutedEPS', u'basicEPSCut', u'dilutedEPSCut', u'EPS', u'revenue', u'investIncome', u'finanExp', u'FValueChgGain', u'operateProfit', u'noperateIncome', u'noperateExp', u'TProfit', u'incomeTax', u'unInvestLoss', u'NIncomeAttrP', u'minorityGain', u'NIncome', u'nonRecGainLoss', u'NIncomeCut', u'NIncomeISA', u'MargStatement', u'NCFOperateA', u'NCFOperAPS', u'NCFFrInvestA', u'NCFFrFinanA', u'NChangeInCash', u'forexEffects', u'NCEEndBal', u'cashCEquiv', u'tradingFA', u'intReceiv', u'divReceiv', u'AR', u'othReceiv', u'inventories', u'TCA', u'availForSaleFA', u'htmInvest', u'investRealEstate', u'LTEquityInvest', u'intanAssets', u'TNCA', u'TAssets', u'STBorr', u'tradingFL', u'payrollPayable', u'divPayable', u'taxesPayable', u'intPayable', u'othPayable', u'NCLWithin1Y', u'TCL', u'TNCL', u'TLiab', u'paidInCapital', u'capitalReser', u'surplusReser', u'retainedEarnings', u'TEquityAttrP', u'minorityInt', u'TShEquity', u'TLiabEquity', u'NAssetISA', u'NAssetPS', u'NAssetPSCal', u'NAssetPSAdj', u'totalShares', u'divStatement', u'TRecompense', u'acconutExp', u'nonstanAuditOp']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str','infoSource': 'str','markCN': 'str','MargStatement': 'str','divStatement': 'str','nonstanAuditOp': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FdmtBSFaPsLatelyJYGet(field = "", pandas = "1"):
    """
    1. 自2007年起，描述新会计准则下，上市公司固定资产及折旧的明细情况，包括固定资产的原值、累计折旧、减值准备、账面价值、净值等各项的期初、期间变化和期末数据。2. 对于公告原文披露的项目名称，收录在“科目名称(ITEM_NAME)”中；“科目分类(ITEM_CD)”则对披露的科目进行了归类，以便于横向比较。3、最新一期会计期间数据
    
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getFdmtBSFaPsLatelyJY.csv?ispandas=1&') 
    requestString.append("field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1534)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1534)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'endDate', u'itemCD', u'item', u'itemNo', u'itemName', u'mark', u'markCn', u'infoSource', u'openValCost', u'increaseCurCost', u'decreaseCurCost', u'endValCost', u'openValAccu', u'increaseCurAccu', u'decreaseCurAccu', u'endValAccu', u'openValNv', u'increaseCurNv', u'decreaseCurNv', u'endValNv', u'openValDr', u'increaseCurDr', u'decreaseCurDr', u'endValDr', u'openValBv', u'increaseCurBv', u'decreaseCurBv', u'endValBv', u'remarks']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str','itemCD': 'str','item': 'str','itemNo': 'str','itemName': 'str','mark': 'str','markCn': 'str','infoSource': 'str','remarks': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FdmtBSIaPsLatelyJYGet(field = "", pandas = "1"):
    """
    1. 自2007年起，描述新会计准则下，上市公司无形资产的明细情况。2. 对于公告原文披露的项目名称，收录在“科目名称(ITEM_NAME)”中；“科目代码(ITEM_CD)”则对披露的科目进行了归类，以便于横向比较。3、最新一期会计期间数据
    
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getFdmtBSIaPsLatelyJY.csv?ispandas=1&') 
    requestString.append("field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1535)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1535)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'endDate', u'infoSource', u'mark', u'markCn', u'itemCD', u'item', u'itemName', u'bookValueOpen', u'increaseCur', u'increaseMA', u'increaseWrtBack', u'increaseOthr', u'decreaseCur', u'decreaseTransOut', u'decreaseAmor', u'decreaseOthr', u'bookValueClose', u'accumAmor', u'origValueClose', u'calcSumOpen', u'calcSumClose', u'resiAmorTerm', u'getWay', u'remarks']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str','infoSource': 'str','mark': 'str','markCn': 'str','itemCD': 'str','item': 'str','itemName': 'str','getWay': 'str','remarks': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FdmtMainOperLatelyJYGet(field = "", pandas = "1"):
    """
    1、公司主营业务的收入来源、成本构成 2、公司主营业务收入、成本和利润与上年同期的对比较
    
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getFdmtMainOperLatelyJY.csv?ispandas=1&') 
    requestString.append("field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1536)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1536)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'partyID', u'ticker', u'secShortName', u'exchangeCD', u'endDate', u'fiscalPeriod', u'infoSource', u'mergedFlag', u'ifMerged', u'adjustedFlag', u'ifAdjusted', u'classifCD', u'classif', u'itemNO', u'itemName', u'enterpNatCD', u'enterpNat', u'MORevenue', u'MOCost', u'MOIncome', u'MORevenueLY', u'MOCostLY', u'MOIncomeLY', u'MORevenueYOY', u'MOCostYOY', u'MOIncomeYOY']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str','infoSource': 'str','mergedFlag': 'str','ifMerged': 'str','adjustedFlag': 'str','ifAdjusted': 'str','classifCD': 'str','classif': 'str','itemName': 'str','enterpNatCD': 'str','enterpNat': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def LCAuditOpinionJYGet(partyID = "", beginDate = "", endDate = "", reportType = "", opinionType = "", field = "", pandas = "1"):
    """
    获取公司历年审计意见，中介机构对公司季度、半年度、年度经营情况的评价，区分审计单位、审计意见类型，包括公司招股以来的历次纪录。
    
    :param partyID: 机构内部ID，通过机构名称在DataAPI.PartyIDGet获取，可多值输入，如'2','603',可以是列表,partyID、beginDate、endDate、reportType至少选择一个
    :param beginDate: 会计期末，输入开始日期,partyID、beginDate、endDate、reportType至少选择一个
    :param endDate: 会计期末，输入截止日期,partyID、beginDate、endDate、reportType至少选择一个
    :param reportType: 报告类型。Q1-一季度，S1-半年度，Q3-三季度，A-年度。对应DataAPI.SysCodeGet.codeTypeID=70001。,可以是列表,partyID、beginDate、endDate、reportType至少选择一个
    :param opinionType: 审计意见类型。1-无保留，2-无保留带解释性说明，3-保留意见，4-拒绝/无法表示意见，5-否定意见，6-未经审计，7-保留带解释性说明，9-修改意见。对应DataAPI.JY.CTSystemConstJYGet.LB=1051得到审计意见类型的具体描述。,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getLCAuditOpinionJY.csv?ispandas=1&') 
    requestString.append("partyID=")
    if hasattr(partyID,'__iter__') and not isinstance(partyID, str):
        if len(partyID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = partyID
            requestString.append(None)
        else:
            requestString.append(','.join(partyID))
    else:
        requestString.append(partyID)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&reportType=")
    if hasattr(reportType,'__iter__') and not isinstance(reportType, str):
        if len(reportType) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = reportType
            requestString.append(None)
        else:
            requestString.append(','.join(reportType))
    else:
        requestString.append(reportType)
    requestString.append("&opinionType=")
    if hasattr(opinionType,'__iter__') and not isinstance(opinionType, str):
        if len(opinionType) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = opinionType
            requestString.append(None)
        else:
            requestString.append(','.join(opinionType))
    else:
        requestString.append(opinionType)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1601)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1601)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'partyID', u'partyFullName', u'endDate', u'infoSource', u'accountingFirms', u'instiBelongedCode', u'CPA', u'opinionType', u'opinionFullText']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'partyFullName': 'str','infoSource': 'str','accountingFirms': 'str','CPA': 'str','opinionFullText': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def LCModelIndexJYGet(partyID = "", beginDate = "", endDate = "", reportType = "", field = "", pandas = "1"):
    """
    获取公司模型指标，该类指标都是根据一些成熟的模型计算而出。
    
    :param partyID: 机构内部ID，通过机构名称在DataAPI.PartyIDGet获取，可多值输入，如'2','603',可以是列表,partyID、beginDate、endDate、reportType至少选择一个
    :param beginDate: 会计期末，输入开始日期,partyID、beginDate、endDate、reportType至少选择一个
    :param endDate: 会计期末，输入截止日期,partyID、beginDate、endDate、reportType至少选择一个
    :param reportType: 报告类型。Q1-一季度，S1-半年度，Q3-三季度，A-年度。对应DataAPI.SysCodeGet.codeTypeID=70001。,可以是列表,partyID、beginDate、endDate、reportType至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getLCModelIndexJY.csv?ispandas=1&') 
    requestString.append("partyID=")
    if hasattr(partyID,'__iter__') and not isinstance(partyID, str):
        if len(partyID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = partyID
            requestString.append(None)
        else:
            requestString.append(','.join(partyID))
    else:
        requestString.append(partyID)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&reportType=")
    if hasattr(reportType,'__iter__') and not isinstance(reportType, str):
        if len(reportType) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = reportType
            requestString.append(None)
        else:
            requestString.append(','.join(reportType))
    else:
        requestString.append(reportType)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1602)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1602)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'partyID', u'partyFullName', u'endDate', u'Z', u'M5', u'M8', u'DOL', u'DFL', u'DTL']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'partyFullName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def LCQFinancialIndexJYGet(partyID = "", beginDate = "", endDate = "", reportType = "", field = "", pandas = "1"):
    """
    获取单季财务指标,该类指标的计算基础是公司的单季利润表和现金流量表，反映公司的经营成果和现金流量情况，总共分为偿债能力、盈利能力、现金流量分析、经营发展能力、资产管理能力以及每股指标等六类，其所用到的数据全部是调整前及合并报表数据。
    
    :param partyID: 机构内部ID，通过机构名称在DataAPI.PartyIDGet获取，可多值输入，如'2','603',可以是列表,partyID、beginDate、endDate、reportType至少选择一个
    :param beginDate: 会计期末，输入开始日期,partyID、beginDate、endDate、reportType至少选择一个
    :param endDate: 会计期末，输入截止日期,partyID、beginDate、endDate、reportType至少选择一个
    :param reportType: 报告类型。Q1-第一季度，Q2-第二季度，Q3-第三季度，Q4-第四季度。对应DataAPI.SysCodeGet.codeTypeID=70001。,可以是列表,partyID、beginDate、endDate、reportType至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getLCQFinancialIndexJY.csv?ispandas=1&') 
    requestString.append("partyID=")
    if hasattr(partyID,'__iter__') and not isinstance(partyID, str):
        if len(partyID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = partyID
            requestString.append(None)
        else:
            requestString.append(','.join(partyID))
    else:
        requestString.append(partyID)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&reportType=")
    if hasattr(reportType,'__iter__') and not isinstance(reportType, str):
        if len(reportType) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = reportType
            requestString.append(None)
        else:
            requestString.append(','.join(reportType))
    else:
        requestString.append(reportType)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1603)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1603)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'partyID', u'partyFullName', u'endDate', u'operCashInToDueDebt', u'operCashInToCurrentDebt', u'operCashInToTotalDebt', u'netProfitCut', u'netProfitRatio', u'grossIncomeRatio', u'taxRatio', u'costRatio', u'expenseRatio', u'ROA', u'ROE', u'ROECut', u'mainOperaProfitRatio', u'operatingProfitRatio', u'totalProfitCostRatio', u'nonRecurringGLProportion', u'cashRateOfSales', u'operCashInToAsset', u'cashToReinvest', u'netEarningWorkingIndex', u'cashWorkingIndex', u'netProfitCashCover', u'mainIncomeCashCover', u'forcedCashPayRatio', u'externalFinanceRatio', u'cashPayStaffRatio', u'operCashStability', u'netProfitGrowRate', u'mainIncomeGrowRate', u'grossProfitGrowRate', u'operProfitGrowRate', u'totalProfeiGrowRate', u'ARTRGrowRate', u'FATRGrowRate', u'capitalItemKeepRate', u'inventoryTRGrowRate', u'operCashPSGrowRate', u'operCycle', u'inventoryTRate', u'inventoryTDays', u'ARTRate', u'ARTDays', u'creditTRate', u'currentTRate', u'totalAssetTRate', u'fixedAssetTRate', u'equityTRate', u'accruedPayableTRate', u'EPS', u'EPSCut', u'operCashFlowPS', u'operProfitPS', u'mainOperProfitPS', u'mainIncomePS']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'partyFullName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def LCRepayandEarningIndexJYGet(partyID = "", beginDate = "", endDate = "", reportType = "", field = "", pandas = "1"):
    """
    获取报告期偿债盈利能力指标(旧)，包括上市公司偿债能力、盈利能力、分红转赠能力、获取现金能力以及资本结构指标,该指标都是用合并报表和调整前的数据计算出来，而且分别对金融类和非金融类公司的计算进行了说明。
    
    :param partyID: 机构内部ID，通过机构名称在DataAPI.PartyIDGet获取，可多值输入，如'2','603',可以是列表,partyID、beginDate、endDate、reportType至少选择一个
    :param beginDate: 会计期末，输入开始日期,partyID、beginDate、endDate、reportType至少选择一个
    :param endDate: 会计期末，输入截止日期,partyID、beginDate、endDate、reportType至少选择一个
    :param reportType: 报告类型。Q1-第一季报，S1-半年报，Q3-第三季报，CQ3-三季报（累计1-9月），A-年报。对应DataAPI.SysCodeGet.codeTypeID=70001。,可以是列表,partyID、beginDate、endDate、reportType至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getLCRepayandEarningIndexJY.csv?ispandas=1&') 
    requestString.append("partyID=")
    if hasattr(partyID,'__iter__') and not isinstance(partyID, str):
        if len(partyID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = partyID
            requestString.append(None)
        else:
            requestString.append(','.join(partyID))
    else:
        requestString.append(partyID)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&reportType=")
    if hasattr(reportType,'__iter__') and not isinstance(reportType, str):
        if len(reportType) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = reportType
            requestString.append(None)
        else:
            requestString.append(','.join(reportType))
    else:
        requestString.append(reportType)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1604)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1604)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'partyID', u'partyFullName', u'endDate', u'currentRatio', u'quickRatio', u'superQuickRatio', u'workingCapitalAssetRatio', u'interestCover', u'repaymentCover', u'debtAssetsRatio', u'longDebtToWorkingCapital', u'cashToCurrentDebt', u'debtEquityRatio', u'debtTangibleEquityRatio', u'operCashInToDueDebt', u'operCashInToCurrentDebt', u'operCashInToTotalDebt', u'netProfitCut', u'EBIT', u'EBIAT', u'EBITAssetRatio', u'EBITDA', u'netProfitRatio', u'grossIncomeRatio', u'taxRatio', u'costRatio', u'expenseRatio', u'ROA', u'capitalReturn', u'ROE', u'ROEWeighted', u'ROECut', u'ROECutWeighted', u'mainOperaProfitRatio', u'operatingProfitRatio', u'totalProfitCostRatio', u'equityGrowRate', u'retainedEarningAssetRatio', u'mainProfitProportion', u'nonRecurringGLProportion', u'profitatISA', u'marginIntoOut', u'incomeTaxProfitRatio', u'cashEquivalentPS', u'operCashPS', u'undividedProfit', u'accumulationFundPS', u'dividendPS', u'dividendCover', u'dividendPaidRatio', u'retainedEarningRatio', u'cashDividendCover', u'dividend', u'freeCashFlow', u'cashRateOfSales', u'operCashInToAsset', u'cashToMeetInvestNeeds', u'cashToReinvest', u'netEarningWorkingIndex', u'cashWorkingIndex', u'netProfitCashCover', u'mainIncomeCashCover', u'forcedCashPayRatio', u'externalFinanceRatio', u'cashPayStaffRatio', u'operCashStability', u'marginOperCashtoProfit', u'financingCashGrowRate', u'operCashGrowRate', u'investCashGrowRate', u'workingCapital', u'longDebtToAsset', u'bondsPayableToAsset', u'equityToAsset', u'longDebtToEquity', u'longAssetFitRate', u'fixAssetRatio', u'intangibleAssetRatio', u'equityMultipler', u'equityFixedAssetRatio', u'workCapitalLoanRatio', u'debtGrowth', u'capitalStockGrowth']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'partyFullName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def LCFBalanceSheetJYGet(partyID = "", beginDate = "", endDate = "", reportType = "", infoPublDateBegin = "", infoPublDateEnd = "", ifAdjusted = "", ifMerged = "", field = "", pandas = "1"):
    """
    获取金融类公司招股前三年及上市后历年季报、中报、年报的资产负债表（旧会计准则），包括当年的合并、母公司报表，以及当年对上年调整的合并、母公司报表；各财务科目单位均为人民币元。
    
    :param partyID: 机构内部ID，通过机构名称在DataAPI.PartyIDGet获取，可多值输入，如'2','603',可以是列表,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param beginDate: 会计期末，输入开始日期,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param endDate: 会计期末，输入截止日期,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param reportType: 报告类型。Q1-第一季报，S1-半年报，Q3-第三季报，CQ3-三季报（累计1-9月），A-年报。对应DataAPI.SysCodeGet.codeTypeID=70001。,可以是列表,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param infoPublDateBegin: 信息发布日期，输入开始日期,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param infoPublDateEnd: 信息发布日期，输入截止日期,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param ifAdjusted: 是否调整，1-调整，2-未调整，6-季末调整，7-二季末调整，8-三季末调整,可以是列表,可空
    :param ifMerged: 是否合并，1-合并报表，2-母公司报表,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getLCFBalanceSheetJY.csv?ispandas=1&') 
    requestString.append("partyID=")
    if hasattr(partyID,'__iter__') and not isinstance(partyID, str):
        if len(partyID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = partyID
            requestString.append(None)
        else:
            requestString.append(','.join(partyID))
    else:
        requestString.append(partyID)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&reportType=")
    if hasattr(reportType,'__iter__') and not isinstance(reportType, str):
        if len(reportType) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = reportType
            requestString.append(None)
        else:
            requestString.append(','.join(reportType))
    else:
        requestString.append(reportType)
    try:
        infoPublDateBegin = infoPublDateBegin.strftime('%Y%m%d')
    except:
        infoPublDateBegin = infoPublDateBegin.replace('-', '')
    requestString.append("&infoPublDateBegin=%s"%(infoPublDateBegin))
    try:
        infoPublDateEnd = infoPublDateEnd.strftime('%Y%m%d')
    except:
        infoPublDateEnd = infoPublDateEnd.replace('-', '')
    requestString.append("&infoPublDateEnd=%s"%(infoPublDateEnd))
    requestString.append("&ifAdjusted=")
    if hasattr(ifAdjusted,'__iter__') and not isinstance(ifAdjusted, str):
        if len(ifAdjusted) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ifAdjusted
            requestString.append(None)
        else:
            requestString.append(','.join(ifAdjusted))
    else:
        requestString.append(ifAdjusted)
    requestString.append("&ifMerged=")
    if hasattr(ifMerged,'__iter__') and not isinstance(ifMerged, str):
        if len(ifMerged) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ifMerged
            requestString.append(None)
        else:
            requestString.append(','.join(ifMerged))
    else:
        requestString.append(ifMerged)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1605)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1605)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'partyID', u'partyFullName', u'endDate', u'infoPublDate', u'ifAdjusted', u'ifMerged', u'cashDeposit', u'cash', u'clientDeposit', u'trustDeposit', u'RMetal', u'settlementprovi', u'brokerBusiprovi', u'trustBusiprovi', u'dealCover', u'depositInCentralBank', u'depositInInterbank', u'depositInAssociate', u'depositInSystem', u'lendCapital', u'lendToAssociate', u'lendToInterbank', u'lendToFinanceCo', u'shortTermLoan', u'mortgage', u'imOutportForeiCurrReserv', u'dividendReceivables', u'interestReceivables', u'accountReceivables', u'netAccountReceivables', u'otherReceivables', u'netOtherReceivables', u'badDebtprovision', u'netReceivables', u'prepays', u'discount', u'STermInvest', u'STermInvestDevalProvi', u'netShortTermInvest', u'interdepartmentalAccounts', u'trustLoanAndInvest', u'trustAsset', u'selfSecu', u'selfSecuDevalprovi', u'netSelfSecu', u'agentSecu', u'proxySecu', u'subIssueSecu', u'subHonorBond', u'issueExpenseToTransfer', u'boughtSellbackSecu', u'inventory', u'inventoryDevalprovi', u'netInventory', u'deferrredExpense', u'currentAssetToDealNetLoss', u'longInvestDueIn1Year', u'otherCurrentAsset', u'totalCurrentAsset', u'midLongtermLoan', u'overrideLoan', u'badLoan', u'deadLoan', u'badLoanprovision', u'rentalReceivable', u'rentIncomeUnReceived', u'subRentReceivable', u'rentAsset', u'rentAssetToTransfer', u'operRentAsset', u'operRentAssetDepreciation', u'longTermEquityInvest', u'longTermDebtInvest', u'otherLongTermInvest', u'totalLongTermInvest', u'longTermInvestDevalprovi', u'netLongTermInvest', u'mergingPriceDiffirence', u'equityInvestDiffirence', u'fixedAssetsCost', u'accumulatedDepreciation', u'netFixedAssets', u'fixedAssetsDevalprovi', u'fixedAssetsMarketValue', u'construInProcess', u'construInProcessDevalprovi', u'netConstruInProcess', u'fixedAssetLiquidation', u'lossOfFixedAssetToDeal', u'totalFixedAsset', u'totalLongTermAssets', u'intangibleAssets', u'deferredAssets', u'preoperateEexpense', u'seatCosts', u'deferredExpense', u'assetToDealForDebt', u'otherLongTermAssets', u'totalIntanAndOtherAssets', u'deferredTaxDebit', u'totalAsset', u'shortTermDeposit', u'shortTermSaveDeposit', u'financeDeposit', u'centralBankBorrowing', u'noteFinace', u'debitofInterbank', u'debitofAssociate', u'debitofSystem', u'shortTermBorrowing', u'pledgeBorrowing', u'borrowingCapital', u'interbankBorrowing', u'financeCoBorrowing', u'shortTermBailDeposit', u'remittanceToTransfer', u'outwardRemittance', u'trustedDeposit', u'entrustedDeposit', u'agentSecuProceedsPayable', u'proxySecuProceedsPayable', u'subIssueSecuProceeds', u'subHonorBondProceeds', u'soldBuybackSecuProceeds', u'notesPayable', u'accountsPayable', u'advanceReceipts', u'interestPayable', u'wagesPayable', u'welfarePayable', u'taxPayable', u'otherPayable', u'dividendPayable', u'otherAccrued', u'accruedExpense', u'deferredIncome', u'issuedShortTermBond', u'longTermDebtDueIn1Year', u'estimateLiability', u'otherCurrentLiability', u'totalCurrentLiability', u'longTermDeposit', u'longTermSaveDeposit', u'longTermBailDeposit', u'subLoanFund', u'subRentPayable', u'issuedLongTermBond', u'longTermBorrowing', u'longTermAccountPayable', u'bondPayable', u'otherLongTermLiability', u'houseTurnoverFund', u'totalLongtermLiability', u'otherLiability', u'deferredTaxCredit', u'totalLiability', u'minorityInterests', u'shareCapital', u'foreignCapitalReserveFund', u'ordinaryRiskReserveFund', u'capitalReserveFund', u'surplusReserveFund', u'commonwealFund', u'unrecognisedInvestLoss', u'retainedProfit', u'foreignCurrencyReportConvDiff', u'totalShareholderEquity', u'totalLiabilityAndEquity', u'changePublDate']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'partyFullName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def LCQIncomeStatementJYGet(partyID = "", beginDate = "", endDate = "", reportType = "", ifAdjusted = "", ifMerged = "", field = "", pandas = "1"):
    """
    获取自公布季报以来非金融公司单季利润表情况(旧会计准则)，包括合并调整、母公司调整、合并未调整、母公司未调整数据；各财务科目单位均为人民币元。
    
    :param partyID: 机构内部ID，通过机构名称在DataAPI.PartyIDGet获取，可多值输入，如'2','603',可以是列表,partyID、beginDate、endDate、reportType至少选择一个
    :param beginDate: 会计期末，输入开始日期,partyID、beginDate、endDate、reportType至少选择一个
    :param endDate: 会计期末，输入截止日期,partyID、beginDate、endDate、reportType至少选择一个
    :param reportType: 报告类型。Q1-第一季度，Q2-第二季度，Q3-第三季度，Q4-第四季度。对应DataAPI.SysCodeGet.codeTypeID=70001。,可以是列表,partyID、beginDate、endDate、reportType至少选择一个
    :param ifAdjusted: 是否调整，1-调整，2-未调整,可以是列表,可空
    :param ifMerged: 是否合并，1-合并报表，2-母公司报表,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getLCQIncomeStatementJY.csv?ispandas=1&') 
    requestString.append("partyID=")
    if hasattr(partyID,'__iter__') and not isinstance(partyID, str):
        if len(partyID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = partyID
            requestString.append(None)
        else:
            requestString.append(','.join(partyID))
    else:
        requestString.append(partyID)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&reportType=")
    if hasattr(reportType,'__iter__') and not isinstance(reportType, str):
        if len(reportType) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = reportType
            requestString.append(None)
        else:
            requestString.append(','.join(reportType))
    else:
        requestString.append(reportType)
    requestString.append("&ifAdjusted=")
    if hasattr(ifAdjusted,'__iter__') and not isinstance(ifAdjusted, str):
        if len(ifAdjusted) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ifAdjusted
            requestString.append(None)
        else:
            requestString.append(','.join(ifAdjusted))
    else:
        requestString.append(ifAdjusted)
    requestString.append("&ifMerged=")
    if hasattr(ifMerged,'__iter__') and not isinstance(ifMerged, str):
        if len(ifMerged) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ifMerged
            requestString.append(None)
        else:
            requestString.append(','.join(ifMerged))
    else:
        requestString.append(ifMerged)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1606)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1606)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'partyID', u'partyFullName', u'endDate', u'ifAdjusted', u'ifMerged', u'salesRevenue', u'salesDiscountsAllowances', u'netSalesRevenue', u'salesCost', u'salesTaxAndSurcharges', u'grossProfit', u'otherBizProfit', u'inventoryDevalLoss', u'operatingExpense', u'administrationExpense', u'financialExpense', u'otherExpenses', u'operatingProfit', u'investIncome', u'futuresInvestIncome', u'subsidyIncome', u'nonoperatingIncome', u'nonoperatingExpense', u'priorYearProfitAdjust', u'totalProfit', u'incomeTax', u'financeRefund', u'minorityProfit', u'unrecognisedInvestLoss', u'mergeAndAcquisitionAProfit', u'netProfit', u'changePublDate']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'partyFullName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def LCQCashFlowStatementJYGet(partyID = "", beginDate = "", endDate = "", reportType = "", ifMerged = "", field = "", pandas = "1"):
    """
    获取自公布季报以来非金融公司单季现金流量表情况(旧会计准则)，包括合并、母公司、调整前、调整后数据；各财务科目单位均为人民币元。
    
    :param partyID: 机构内部ID，通过机构名称在DataAPI.PartyIDGet获取，可多值输入，如'2','603',可以是列表,partyID、beginDate、endDate、reportType至少选择一个
    :param beginDate: 会计期末，输入开始日期,partyID、beginDate、endDate、reportType至少选择一个
    :param endDate: 会计期末，输入截止日期,partyID、beginDate、endDate、reportType至少选择一个
    :param reportType: 报告类型。Q1-第一季度，Q2-第二季度，Q3-第三季度，Q4-第四季度。对应DataAPI.SysCodeGet.codeTypeID=70001。,可以是列表,partyID、beginDate、endDate、reportType至少选择一个
    :param ifMerged: 是否合并，1-合并未调整，2-母公司未调整，3-合并调整，4-母公司调整,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getLCQCashFlowStatementJY.csv?ispandas=1&') 
    requestString.append("partyID=")
    if hasattr(partyID,'__iter__') and not isinstance(partyID, str):
        if len(partyID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = partyID
            requestString.append(None)
        else:
            requestString.append(','.join(partyID))
    else:
        requestString.append(partyID)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&reportType=")
    if hasattr(reportType,'__iter__') and not isinstance(reportType, str):
        if len(reportType) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = reportType
            requestString.append(None)
        else:
            requestString.append(','.join(reportType))
    else:
        requestString.append(reportType)
    requestString.append("&ifMerged=")
    if hasattr(ifMerged,'__iter__') and not isinstance(ifMerged, str):
        if len(ifMerged) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ifMerged
            requestString.append(None)
        else:
            requestString.append(','.join(ifMerged))
    else:
        requestString.append(ifMerged)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1607)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1607)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'partyID', u'partyFullName', u'endDate', u'ifMerged', u'goodsSaleServiceRenderCash', u'rentalReceived', u'vATReceivedAndRefunded', u'otherTaxLevyRefund', u'taxLevyRefund', u'otherCashInRelatedOperate', u'subtotalOperateCashInflow', u'goodsServicesCashPaid', u'operateLeasesCashPaid', u'staffBehalfPaid', u'vATPaid', u'incomeTaxPaid', u'otherTaxPaid', u'allTaxesPaid', u'otherOperateCashPaid', u'subtotalOperateCashOutflow', u'netOperateCashFlow', u'investWithdrawalCash', u'dividendAndProfitReceived', u'bondInterestIncome', u'fixIntanOtherAssetDispoCash', u'otherCashFromInvestAct', u'subtotalInvestCashInflow', u'fixIntanOtherAssetAcquiCash', u'equityInvestCashPaid', u'debtInvestCashPaid', u'otherCashToInvestAct', u'subtotalInvestCashOutflow', u'netInvestCashFlow', u'issueShareproceeds', u'minorityInvestproceeds', u'issueBondproceeds', u'borrowingproceeds', u'otherFinanceActproceeds', u'subtotalFinanceCashInflow', u'borrowingRepayment', u'financeActPayment', u'dividendProfitDistribPayment', u'subCompanyPaidDiviToMino', u'interestPayment', u'financeLeasePayment', u'regCapitalReductionPayment', u'subCompanyCapiReduPaidMino', u'otherFinanceActPayment', u'subtotalFinanceCashOutflow', u'netFinanceCashFlow', u'exchanRateChangeEffect', u'cashEquivalentIncrease', u'fixedAssetTransRepayment', u'investTransRepayment', u'fixedAssetFormInvest', u'inventoryTransRepayment', u'financeLeaseFixedAssets', u'netProfit', u'minorityProfit', u'mergeAcquisitionProfit', u'unrecognisedInvestLoss', u'badDebtWrittenOffProvision', u'fixedAssetDepreciation', u'intangibleAssetAmortization', u'preoperateEexpenseAmort', u'deferredExpenseAmort', u'deferredExpenseDecreased', u'accruedExpenseAdded', u'fixIntanOtherAssetDispoLoss', u'fixedAssetScrapLoss', u'financialExpense', u'investLoss', u'netDeferedTaxCredit', u'inventoryDecrease', u'inventoryDevalProvision', u'operateReceivableDecrease', u'operatePayableDecrease', u'VATNetIncrease', u'others', u'netOperateCashFlowNotes', u'changePublDate']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'partyFullName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def LCFinancialDataJYGet(partyID = "", beginDate = "", endDate = "", reportType = "", infoPublDateBegin = "", infoPublDateEnd = "", field = "", pandas = "1"):
    """
    获取上市公司常用财务报表数据(旧),包括金融类和非金融类上市公司常用的一些财务合并未调整的数据
    
    :param partyID: 机构内部ID，通过机构名称在DataAPI.PartyIDGet获取，可多值输入，如'2','603',可以是列表,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param beginDate: 会计期末，输入开始日期,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param endDate: 会计期末，输入截止日期,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param reportType: 报告类型。Q1-一季度，S1-半年度，Q3-三季度，A-年度。对应DataAPI.SysCodeGet.codeTypeID=70001。,可以是列表,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param infoPublDateBegin: 信息发布日期，输入开始日期,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param infoPublDateEnd: 信息发布日期，输入截止日期,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getLCFinancialDataJY.csv?ispandas=1&') 
    requestString.append("partyID=")
    if hasattr(partyID,'__iter__') and not isinstance(partyID, str):
        if len(partyID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = partyID
            requestString.append(None)
        else:
            requestString.append(','.join(partyID))
    else:
        requestString.append(partyID)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&reportType=")
    if hasattr(reportType,'__iter__') and not isinstance(reportType, str):
        if len(reportType) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = reportType
            requestString.append(None)
        else:
            requestString.append(','.join(reportType))
    else:
        requestString.append(reportType)
    try:
        infoPublDateBegin = infoPublDateBegin.strftime('%Y%m%d')
    except:
        infoPublDateBegin = infoPublDateBegin.replace('-', '')
    requestString.append("&infoPublDateBegin=%s"%(infoPublDateBegin))
    try:
        infoPublDateEnd = infoPublDateEnd.strftime('%Y%m%d')
    except:
        infoPublDateEnd = infoPublDateEnd.replace('-', '')
    requestString.append("&infoPublDateEnd=%s"%(infoPublDateEnd))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1611)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1611)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'partyID', u'partyFullName', u'endDate', u'infoPublDate', u'salesCost', u'grossProfit', u'salesRevenue', u'otherBizProfit', u'operatingProfit', u'investIncome', u'subsidyIncome', u'netNonoperating', u'totalProfit', u'netProfit', u'profitatISA', u'marginIntoOut', u'marginIntoOutStatement', u'netProfitCut', u'retainedProfit', u'cashEquivalentIncrease', u'netOperateCashFlow', u'goodsSaleServiceRenderCash', u'marginOperCashtoProfit', u'netProfitCashCover', u'mainIncomeCashCover', u'totalAsset', u'cashEquivalents', u'deposit', u'workingCapital', u'totalLiability', u'totalShareholderEquity', u'capitalReserveFund', u'surplusReserveFund', u'totalShares']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'partyFullName': 'str','marginIntoOutStatement': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def LCFSpecialIndicatorsJYGet(partyID = "", beginDate = "", endDate = "", reportType = "", infoPublDateBegin = "", infoPublDateEnd = "", mark = "", indicatorType = "", indicatorCode = "", field = "", pandas = "1"):
    """
    获取金融类公司特有指标(新)，反映银行、证券公司、保险公司等特有的指标数据。
    
    :param partyID: 机构内部ID，通过机构名称在DataAPI.PartyIDGet获取，可多值输入，如'2','603',可以是列表,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param beginDate: 会计期末，输入开始日期,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param endDate: 会计期末，输入截止日期,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param reportType: 报告类型。Q1-一季度，S1-半年度，Q3-三季度，A-年度。对应DataAPI.SysCodeGet.codeTypeID=70001。,可以是列表,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param infoPublDateBegin: 信息发布日期，输入开始日期,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param infoPublDateEnd: 信息发布日期，输入截止日期,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param mark: 合并调整标志,1-合并调整，2-合并未调整，3-母公司调整，4-母公司未调整,可以是列表,可空
    :param indicatorType: 指标类别。10-银行类专项指标，11-银行贷款五级分类，20-证券类专项指标，30-保险类专项指标。对应DataAPI.JY.CTSystemConstJYGet.LB=1467得到金融指标的具体类别。,可以是列表,可空
    :param indicatorCode: 指标代码，通过DataAPI.JY.CTSystemConstJYGet(LB='1468')得到金融指标的指标明细。,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getLCFSpecialIndicatorsJY.csv?ispandas=1&') 
    requestString.append("partyID=")
    if hasattr(partyID,'__iter__') and not isinstance(partyID, str):
        if len(partyID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = partyID
            requestString.append(None)
        else:
            requestString.append(','.join(partyID))
    else:
        requestString.append(partyID)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&reportType=")
    if hasattr(reportType,'__iter__') and not isinstance(reportType, str):
        if len(reportType) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = reportType
            requestString.append(None)
        else:
            requestString.append(','.join(reportType))
    else:
        requestString.append(reportType)
    try:
        infoPublDateBegin = infoPublDateBegin.strftime('%Y%m%d')
    except:
        infoPublDateBegin = infoPublDateBegin.replace('-', '')
    requestString.append("&infoPublDateBegin=%s"%(infoPublDateBegin))
    try:
        infoPublDateEnd = infoPublDateEnd.strftime('%Y%m%d')
    except:
        infoPublDateEnd = infoPublDateEnd.replace('-', '')
    requestString.append("&infoPublDateEnd=%s"%(infoPublDateEnd))
    requestString.append("&mark=")
    if hasattr(mark,'__iter__') and not isinstance(mark, str):
        if len(mark) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = mark
            requestString.append(None)
        else:
            requestString.append(','.join(mark))
    else:
        requestString.append(mark)
    requestString.append("&indicatorType=")
    if hasattr(indicatorType,'__iter__') and not isinstance(indicatorType, str):
        if len(indicatorType) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicatorType
            requestString.append(None)
        else:
            requestString.append(','.join(indicatorType))
    else:
        requestString.append(indicatorType)
    requestString.append("&indicatorCode=")
    if hasattr(indicatorCode,'__iter__') and not isinstance(indicatorCode, str):
        if len(indicatorCode) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = indicatorCode
            requestString.append(None)
        else:
            requestString.append(','.join(indicatorCode))
    else:
        requestString.append(indicatorCode)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1612)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1612)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'partyID', u'partyFullName', u'endDate', u'infoPublDate', u'infoSource', u'mark', u'indicatorType', u'indicatorName', u'indicatorCode', u'amount', u'ratioEOP', u'ratioAVG']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'partyFullName': 'str','infoSource': 'str','indicatorName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def LCMainIndexNewJYGet(partyID = "", beginDate = "", endDate = "", reportType = "", field = "", pandas = "1"):
    """
    获取公司主要财务分析指标_新会计准则，根据报告期公布的财务科目数据衍生而来的每股指标，以及反映公司盈利、偿债、成长、营运、分红、现金流、资本结构等能力的指标；若某个报告期的数据有多次调整，则该表展示最新合并调整数据；若某报告期暂未披露调整后数据，则展示调整前的合并数据；“十、杜邦分析”另有两个指标－“净资产收益率ROE_平均,计算”和“总资产周转率”，分别在“二、盈利能力”和“五、营运能力”下；本表中的同比数据计算公式为：（本期数据－去年同期数据）/︱去年同期数据︱*100%。
    
    :param partyID: 机构内部ID，通过机构名称在DataAPI.PartyIDGet获取，可多值输入，如'2','603',可以是列表,partyID、beginDate、endDate、reportType至少选择一个
    :param beginDate: 会计期末，输入开始日期,partyID、beginDate、endDate、reportType至少选择一个
    :param endDate: 会计期末，输入截止日期,partyID、beginDate、endDate、reportType至少选择一个
    :param reportType: 报告类型。Q1-一季度，S1-半年度，Q3-三季度，A-年度。对应DataAPI.SysCodeGet.codeTypeID=70001。,可以是列表,partyID、beginDate、endDate、reportType至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getLCMainIndexNewJY.csv?ispandas=1&') 
    requestString.append("partyID=")
    if hasattr(partyID,'__iter__') and not isinstance(partyID, str):
        if len(partyID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = partyID
            requestString.append(None)
        else:
            requestString.append(','.join(partyID))
    else:
        requestString.append(partyID)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&reportType=")
    if hasattr(reportType,'__iter__') and not isinstance(reportType, str):
        if len(reportType) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = reportType
            requestString.append(None)
        else:
            requestString.append(','.join(reportType))
    else:
        requestString.append(reportType)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1613)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1613)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'partyID', u'partyFullName', u'endDate', u'basicEPS', u'dilutedEPS', u'EPS', u'EPSTTM', u'netAssetPS', u'totalOperatingRevenuePS', u'mainIncomePS', u'operatingRevenuePSTTM', u'operProfitPS', u'EBITPS', u'capitalSurplusFundPS', u'surplusReserveFundPS', u'accumulationFundPS', u'undividedProfit', u'retainedEarningsPS', u'operCashFlowPS', u'operCashFlowPSTTM', u'cashFlowPS', u'cashFlowPSTTM', u'enterpriseFCFPS', u'shareHolderFCFPS', u'ROEAvg', u'ROEWeighted', u'ROE', u'ROECut', u'ROECutWeighted', u'ROETTM', u'ROA_EBIT', u'ROA_EBITTTM', u'ROA', u'ROATTM', u'ROIC', u'netProfitRatio', u'netProfitRatioTTM', u'grossIncomeRatio', u'grossIncomeRatioTTM', u'salesCostRatio', u'periodCostsRate', u'periodCostsRateTTM', u'NPToTOR', u'NPToTORTTM', u'operatingProfitToTOR', u'operatingProfitToTORTTM', u'EBITToTOR', u'EBITToTORTTM', u'TOperatingCostToTOR', u'TOperatingCostToTORTTM', u'operatingExpenseRate', u'operatingExpenseRateTTM', u'adminiExpenseRate', u'adminiExpenseRateTTM', u'financialExpenseRate', u'financialExpenseRateTTM', u'assetImpaLossToTOR', u'assetImpaLossToTORTTM', u'netProfit', u'netProfitCut', u'EBIT', u'EBITDA', u'operatingProfitRatio', u'totalProfitCostRatio', u'currentRatio', u'quickRatio', u'superQuickRatio', u'debtEquityRatio', u'SEWithoutMIToTL', u'SEWMIToInterestBearDebt', u'debtTangibleEquityRatio', u'tangibleAToInteBearDebt', u'tangibleAToNetDebt', u'EBITDAToTLiability', u'NOCFToTLiability', u'NOCFToInterestBearDebt', u'NOCFToCurrentLiability', u'NOCFToNetDebt', u'interestCover', u'longDebtToWorkingCapital', u'operCashInToCurrentDebt', u'basicEPSYOY', u'dilutedEPSYOY', u'operatingRevenueGrowRate', u'operProfitGrowRate', u'totalProfeiGrowRate', u'netProfitGrowRate', u'NPParentCompanyYOY', u'NPParentCompanyCutYOY', u'avgNPYOYPastFiveYear', u'netOperateCashFlowYOY', u'operCashPSGrowRate', u'NAORYOY', u'netAssetGrowRate', u'totalAssetGrowRate', u'EPSGrowRateYTD', u'SEWithoutMIGrowRateYTD', u'TAGrowRateYTD', u'sustainableGrowRate', u'operCycle', u'inventoryTRate', u'inventoryTDays', u'ARTRate', u'ARTDays', u'accountsPayablesTRate', u'accountsPayablesTDays', u'currentAssetsTRate', u'fixedAssetTRate', u'equityTRate', u'totalAssetTRate', u'saleServiceCashToOR', u'saleServiceCashToORTTM', u'cashRateOfSales', u'cashRateOfSalesTTM', u'NOCFToOperatingNI', u'NOCFToOperatingNITTM', u'capitalExpenditureToDM', u'cashEquivalentIncrease', u'netOperateCashFlow', u'goodsSaleServiceRenderCash', u'freeCashFlow', u'netProfitCashCover', u'operatingRevenueCashCover', u'operCashInToAsset', u'cashEquivalentPS', u'dividendPS', u'dividendCover', u'cashDividendCover', u'dividendPaidRatio', u'retainedEarningRatio', u'debtAssetsRatio', u'currentAssetsToTA', u'nonCurrentAssetsToTA', u'fixAssetRatio', u'intangibleAssetRatio', u'longDebtToAsset', u'bondsPayableToAsset', u'SEWithoutMIToTotalCapital', u'inteBearDebtToTotalCapital', u'currentLiabilityToTL', u'nonCurrentLiabilityToTL', u'equityToAsset', u'equityMultipler', u'workingCapital', u'longDebtToEquity', u'longAssetFitRate', u'operatingNIToTP', u'operatingMIToTPTTM', u'investRAssociatesToTP', u'investRAssociatesToTPTTM', u'valueChangeNIToTP', u'valueChangeNIToTPTTM', u'netNonOperatingIncomeToTP', u'netNonOIToTPTTM', u'taxesToTP', u'NPCutToTP', u'equityMultipler_DuPont', u'NPPCToNP_DuPont', u'NPToTOR_DuPont', u'NPToTP_DuPont', u'TPToEBIT_DuPont', u'EBITToTOR_DuPont']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'partyFullName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def LCMainQuarterDataJYGet(partyID = "", beginDate = "", endDate = "", reportType = "", infoPublDateBegin = "", infoPublDateEnd = "", mark = "", field = "", pandas = "1"):
    """
    获取季度主要会计数据及财务指标_新会计准则,反映上市公司的主要指标;若某个报告期的数据有多次调整，则该表展示最新调整数据；若某报告期暂未披露调整后数据，则已调整类别下的数据与调整前的数据一致;该表中各财务科目的单位均为人民币元。
    
    :param partyID: 机构内部ID，通过机构名称在DataAPI.PartyIDGet获取，可多值输入，如'2','603',可以是列表,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param beginDate: 会计期末，输入开始日期,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param endDate: 会计期末，输入截止日期,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param reportType: 报告类型。Q1-一季度，S1-半年度，Q3-三季度，A-年度。对应DataAPI.SysCodeGet.codeTypeID=70001。,可以是列表,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param infoPublDateBegin: 信息发布日期，输入开始日期,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param infoPublDateEnd: 信息发布日期，输入截止日期,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param mark: 合并调整标志,1-合并调整，2-合并未调整，3-母公司调整，4-母公司未调整,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getLCMainQuarterDataJY.csv?ispandas=1&') 
    requestString.append("partyID=")
    if hasattr(partyID,'__iter__') and not isinstance(partyID, str):
        if len(partyID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = partyID
            requestString.append(None)
        else:
            requestString.append(','.join(partyID))
    else:
        requestString.append(partyID)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&reportType=")
    if hasattr(reportType,'__iter__') and not isinstance(reportType, str):
        if len(reportType) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = reportType
            requestString.append(None)
        else:
            requestString.append(','.join(reportType))
    else:
        requestString.append(reportType)
    try:
        infoPublDateBegin = infoPublDateBegin.strftime('%Y%m%d')
    except:
        infoPublDateBegin = infoPublDateBegin.replace('-', '')
    requestString.append("&infoPublDateBegin=%s"%(infoPublDateBegin))
    try:
        infoPublDateEnd = infoPublDateEnd.strftime('%Y%m%d')
    except:
        infoPublDateEnd = infoPublDateEnd.replace('-', '')
    requestString.append("&infoPublDateEnd=%s"%(infoPublDateEnd))
    requestString.append("&mark=")
    if hasattr(mark,'__iter__') and not isinstance(mark, str):
        if len(mark) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = mark
            requestString.append(None)
        else:
            requestString.append(','.join(mark))
    else:
        requestString.append(mark)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1614)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1614)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'partyID', u'partyFullName', u'endDate', u'infoPublDate', u'infoSource', u'bulletinType', u'accountingStandards', u'mark', u'basicEPS', u'dilutedEPS', u'basicEPSCut', u'dilutedEPSCut', u'EPS', u'ROEByReport', u'ROE', u'ROECut', u'WROE', u'WROECut', u'operatingReenue', u'operatingProfit', u'totalProfit', u'NPFromParentCompanyOwners', u'netProfitCut', u'profitatISA', u'marginIntoOutStatement', u'retainedProfit', u'netOperateCashFlow', u'netOperateCashFlowPS', u'cashEquialentIncrease', u'cashEquialents', u'totalAssets', u'SEWithoutMI', u'netAssetISA', u'NAPSByReport', u'NAPS', u'NAPSAdjusted', u'capitalResereFund', u'totalShares', u'diidendFinancing', u'totalRecompense', u'feeForAccountantOffice', u'modifiedAuditOpinion']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'partyFullName': 'str','infoSource': 'str','bulletinType': 'str','marginIntoOutStatement': 'str','diidendFinancing': 'str','modifiedAuditOpinion': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def LCQIncomeStatementNewJYGet(partyID = "", beginDate = "", endDate = "", reportType = "", infoPublDateBegin = "", infoPublDateEnd = "", mark = "", companyType = "", field = "", pandas = "1"):
    """
    获取单季利润表_新会计准则，本表收录自公布季报以来公司的单季利润表情况，数据单位均为人民币元；科目的计算方法：第一、三季度直接取公布值；第二季度数据＝半年度数据－第一季度数据；第四季度数据＝年度数据－前三季度数据。各期的原始数据均取合并后的最新数据（有调整的为最新调整后数据）；由于会计期间可能发生同一控制下企业合并、企业自身错报漏报、企业列报项目变化等问题，将会导致二、四季度的单季数据的可靠性下降；带“##”的特殊项目为单个公司披露的非标准化的科目，对应的“特殊字段说明” 字段将对其作出说明；带“##”的调整项目是为了让报表的各个小项借贷平衡而设置的，便于客户对报表的遗漏和差错进行判断；无括号注释的为公共项。
    
    :param partyID: 机构内部ID，通过机构名称在DataAPI.PartyIDGet获取，可多值输入，如'2','603',可以是列表,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param beginDate: 会计期末，输入开始日期,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param endDate: 会计期末，输入截止日期,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param reportType: 报告类型。Q1-第一季度，Q2-第二季度，Q3-第三季度，Q4-第四季度。对应DataAPI.SysCodeGet.codeTypeID=70001。,可以是列表,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param infoPublDateBegin: 信息发布日期，输入开始日期,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param infoPublDateEnd: 信息发布日期，输入截止日期,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param mark: 合并调整标志,1-合并调整，2-合并未调整，3-母公司调整，4-母公司未调整,可以是列表,可空
    :param companyType: 公司类别。13-商业银行，31-证券公司，33-信托公司，35-保险公司，99-一般企业。对应DataAPI.JY.CTSystemConstJYGet.LB=1414得到公司类别的具体描述。,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getLCQIncomeStatementNewJY.csv?ispandas=1&') 
    requestString.append("partyID=")
    if hasattr(partyID,'__iter__') and not isinstance(partyID, str):
        if len(partyID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = partyID
            requestString.append(None)
        else:
            requestString.append(','.join(partyID))
    else:
        requestString.append(partyID)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&reportType=")
    if hasattr(reportType,'__iter__') and not isinstance(reportType, str):
        if len(reportType) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = reportType
            requestString.append(None)
        else:
            requestString.append(','.join(reportType))
    else:
        requestString.append(reportType)
    try:
        infoPublDateBegin = infoPublDateBegin.strftime('%Y%m%d')
    except:
        infoPublDateBegin = infoPublDateBegin.replace('-', '')
    requestString.append("&infoPublDateBegin=%s"%(infoPublDateBegin))
    try:
        infoPublDateEnd = infoPublDateEnd.strftime('%Y%m%d')
    except:
        infoPublDateEnd = infoPublDateEnd.replace('-', '')
    requestString.append("&infoPublDateEnd=%s"%(infoPublDateEnd))
    requestString.append("&mark=")
    if hasattr(mark,'__iter__') and not isinstance(mark, str):
        if len(mark) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = mark
            requestString.append(None)
        else:
            requestString.append(','.join(mark))
    else:
        requestString.append(mark)
    requestString.append("&companyType=")
    if hasattr(companyType,'__iter__') and not isinstance(companyType, str):
        if len(companyType) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = companyType
            requestString.append(None)
        else:
            requestString.append(','.join(companyType))
    else:
        requestString.append(companyType)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1615)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1615)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'partyID', u'partyFullName', u'endDate', u'infoPublDate', u'infoSource', u'bulletinType', u'mark', u'accountingStandards', u'companyType', u'totalOperatingRevenue', u'operatingRevenue', u'netInterestIncome', u'interestIncome', u'interestExpense', u'netCommissionIncome', u'commissionIncome', u'commissionExpense', u'netProxySecuIncome', u'netSubIssueSecuIncome', u'netTrustIncome', u'premiumsEarned', u'premiumsIncome', u'reinsuranceIncome', u'reinsurance', u'unearnedPremiumReserve', u'exchangeIncome', u'otherOperatingIncome', u'specialItemsOR', u'adjustmentItemsOR', u'otherOperatingRevenue', u'totalOperatingCost', u'operatingCost', u'operatingExpense', u'administrationExpense', u'financialExpense', u'operatingPayout', u'refundedPremiums', u'compensationExpense', u'amortizationExpense', u'premiumReserve', u'amortizationPremiumReserve', u'policyDividendPayout', u'reinsuranceCost', u'insuranceCommissionExpense', u'operatingTaxAndSurcharges', u'operatingAndAdminExpense', u'amortizationReinsuranceCost', u'assetImpairmentLoss', u'otherOperatingCost', u'specialItemsOP', u'adjustmentItemsOP', u'investIncome', u'investIncomeFromAssociates', u'fairValueChangeIncome', u'otherItemsEffectingOP', u'adjustedItemsEffectingOP', u'operatingProfit', u'nonoperatingIncome', u'nonoperatingExpense', u'nonCurrentAssetssDealLoss', u'otherItemsEffectingTP', u'adjustedItemsEffectingTP', u'totalProfit', u'incomeTaxCost', u'uncertainedInvestmentLosses', u'otherItemsEffectingNP', u'adjustedItemsEffectingNP', u'netProfit', u'NPFromParentCompanyOwners', u'minorityProfit']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'partyFullName': 'str','infoSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def LCQCashFlowStatementNewJYGet(partyID = "", beginDate = "", endDate = "", reportType = "", infoPublDateBegin = "", infoPublDateEnd = "", mark = "", companyType = "", field = "", pandas = "1"):
    """
    获取单季现金流量表_新会计准则，本表收录自公布季报以来公司的单季现金流量表情况，数据单位均为人民币元；科目的计算方法：第一、三季度直接取公布值；第二季度数据＝半年度数据－第一季度数据；第四季度数据＝年度数据－前三季度数据。各期的原始数据均取合并后的最新数据（有调整的为最新调整后数据）；由于会计期间可能发生同一控制下企业合并、企业自身错报漏报、企业列报项目变化等问题，将会导致二、四季度的单季数据的可靠性下降；带“##”的特殊项目为单个公司披露的非标准化的科目，对应的“特殊字段说明” 字段将对其作出说明；带“##”的调整项目是为了让报表的各个小项借贷平衡而设置的，便于客户对报表的遗漏和差错进行判断；无括号注释的为公共项。
    
    :param partyID: 机构内部ID，通过机构名称在DataAPI.PartyIDGet获取，可多值输入，如'2','603',可以是列表,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param beginDate: 会计期末，输入开始日期,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param endDate: 会计期末，输入截止日期,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param reportType: 报告类型。Q1-第一季度，Q2-第二季度，Q3-第三季度，Q4-第四季度。对应DataAPI.SysCodeGet.codeTypeID=70001。,可以是列表,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param infoPublDateBegin: 信息发布日期，输入开始日期,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param infoPublDateEnd: 信息发布日期，输入截止日期,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param mark: 合并调整标志,1-合并调整，2-合并未调整，3-母公司调整，4-母公司未调整,可以是列表,可空
    :param companyType: 公司类别。13-商业银行，31-证券公司，33-信托公司，35-保险公司，99-一般企业。对应DataAPI.JY.CTSystemConstJYGet.LB=1414得到公司类别的具体描述。,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getLCQCashFlowStatementNewJY.csv?ispandas=1&') 
    requestString.append("partyID=")
    if hasattr(partyID,'__iter__') and not isinstance(partyID, str):
        if len(partyID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = partyID
            requestString.append(None)
        else:
            requestString.append(','.join(partyID))
    else:
        requestString.append(partyID)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&reportType=")
    if hasattr(reportType,'__iter__') and not isinstance(reportType, str):
        if len(reportType) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = reportType
            requestString.append(None)
        else:
            requestString.append(','.join(reportType))
    else:
        requestString.append(reportType)
    try:
        infoPublDateBegin = infoPublDateBegin.strftime('%Y%m%d')
    except:
        infoPublDateBegin = infoPublDateBegin.replace('-', '')
    requestString.append("&infoPublDateBegin=%s"%(infoPublDateBegin))
    try:
        infoPublDateEnd = infoPublDateEnd.strftime('%Y%m%d')
    except:
        infoPublDateEnd = infoPublDateEnd.replace('-', '')
    requestString.append("&infoPublDateEnd=%s"%(infoPublDateEnd))
    requestString.append("&mark=")
    if hasattr(mark,'__iter__') and not isinstance(mark, str):
        if len(mark) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = mark
            requestString.append(None)
        else:
            requestString.append(','.join(mark))
    else:
        requestString.append(mark)
    requestString.append("&companyType=")
    if hasattr(companyType,'__iter__') and not isinstance(companyType, str):
        if len(companyType) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = companyType
            requestString.append(None)
        else:
            requestString.append(','.join(companyType))
    else:
        requestString.append(companyType)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1616)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1616)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'partyID', u'partyFullName', u'endDate', u'infoPublDate', u'infoSource', u'bulletinType', u'mark', u'accountingStandards', u'companyType', u'goodsSaleServiceRenderCash', u'taxLevyRefund', u'netDepositIncrease', u'netBorrowingFromCentralBank', u'netBorrowingFromFinanceCo', u'drawBackLoansCanceled', u'interestAndCommissionCashIn', u'netDealTradingAssets', u'netBuyBack', u'netOriginalInsuranceCash', u'netReinsuranceCash', u'netInsurerDepositInvestment', u'otherCashInRelatedOperate', u'specialItemsOCIF', u'adjustmentItemsOCIF', u'subtotalOperateCashInflow', u'goodsServicesCashPaid', u'staffBehalfPaid', u'allTaxesPaid', u'netLoanAndAdvanceIncrease', u'netDepositInCBAndIB', u'netLendCapital', u'commissionCashPaid', u'originalCompensationPaid', u'netCashForReinsurance', u'policyDividendCashPaid', u'otherOperateCashPaid', u'specialItemsOCOF', u'adjustmentItemsOCOF', u'subtotalOperateCashOutflow', u'adjustmentItemsNOCF', u'netOperateCashFlow', u'investWithdrawalCash', u'investproceeds', u'fixIntanOtherAssetDispoCash', u'netCashDealSubCompany', u'otherCashFromInvestAct', u'specialItemsICIF', u'adjustmentItemsICIF', u'subtotalInvestCashInflow', u'fixIntanOtherAssetAcquiCash', u'investCashPaid', u'netCashFromSubCompany', u'impawnedLoanNetIncrease', u'otherCashToInvestAct', u'specialItemsICOF', u'adjustmentItemsICOF', u'subtotalInvestCashOutflow', u'adjustmentItemsNICF', u'netInvestCashFlow', u'cashFromInvest', u'cashFromMinoSInvestSub', u'cashFromBondsIssue', u'cashFromBorrowing', u'otherFinanceActCash', u'specialItemsFCIF', u'adjustmentItemsFCIF', u'subtotalFinanceCashInflow', u'borrowingRepayment', u'dividendInterestPayment', u'proceedsFromSubToMinoS', u'otherFinanceActPayment', u'specialItemsFCOF', u'adjustmentItemsFCOF', u'subtotalFinanceCashOutflow', u'adjustmentItemsNFCF', u'netFinanceCashFlow', u'exchanRateChangeEffect', u'otherItemsEffectingCE', u'adjustmentItemsCE', u'cashEquivalentIncrease']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'partyFullName': 'str','infoSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def LCQFinancialIndexNewJYGet(partyID = "", beginDate = "", endDate = "", reportType = "", infoPublDateBegin = "", infoPublDateEnd = "", mark = "", field = "", pandas = "1"):
    """
    获取单季财务指标_新会计准则，本表收录自公布季报以来公司的单季主要财务指标信息，计算基础数据为“单季利润表”和“单季现金流量表”的合并调整后数据，单位均为人民币元；由于会计期间可能发生同一控制下企业合并、企业自身错报漏报、企业列报项目变化等问题，将会导致二、四季度的单季数据的可靠性下降。
    
    :param partyID: 机构内部ID，通过机构名称在DataAPI.PartyIDGet获取，可多值输入，如'2','603',可以是列表,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param beginDate: 会计期末，输入开始日期,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param endDate: 会计期末，输入截止日期,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param reportType: 报告类型。Q1-一季度，S1-半年度，Q3-三季度，A-年度。对应DataAPI.SysCodeGet.codeTypeID=70001。,可以是列表,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param infoPublDateBegin: 信息发布日期，输入开始日期,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param infoPublDateEnd: 信息发布日期，输入截止日期,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param mark: 合并调整标志,1-合并调整，2-合并未调整，3-母公司调整，4-母公司未调整,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getLCQFinancialIndexNewJY.csv?ispandas=1&') 
    requestString.append("partyID=")
    if hasattr(partyID,'__iter__') and not isinstance(partyID, str):
        if len(partyID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = partyID
            requestString.append(None)
        else:
            requestString.append(','.join(partyID))
    else:
        requestString.append(partyID)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&reportType=")
    if hasattr(reportType,'__iter__') and not isinstance(reportType, str):
        if len(reportType) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = reportType
            requestString.append(None)
        else:
            requestString.append(','.join(reportType))
    else:
        requestString.append(reportType)
    try:
        infoPublDateBegin = infoPublDateBegin.strftime('%Y%m%d')
    except:
        infoPublDateBegin = infoPublDateBegin.replace('-', '')
    requestString.append("&infoPublDateBegin=%s"%(infoPublDateBegin))
    try:
        infoPublDateEnd = infoPublDateEnd.strftime('%Y%m%d')
    except:
        infoPublDateEnd = infoPublDateEnd.replace('-', '')
    requestString.append("&infoPublDateEnd=%s"%(infoPublDateEnd))
    requestString.append("&mark=")
    if hasattr(mark,'__iter__') and not isinstance(mark, str):
        if len(mark) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = mark
            requestString.append(None)
        else:
            requestString.append(','.join(mark))
    else:
        requestString.append(mark)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1617)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1617)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'partyID', u'partyFullName', u'endDate', u'infoPublDate', u'bulletinType', u'mark', u'accountingStandards', u'NPFromParentCompanyOwners', u'EPS', u'netProfitRatio', u'grossIncomeRatio', u'operatingCostRate', u'periodCostsRate', u'operatingExpenseRate', u'adminiExpenseRate', u'financialExpenseRate', u'operatingProfitMargin', u'totalProfitCostRatio', u'operCycle', u'inventoryTRate', u'inventoryTDays', u'ARTRate', u'ARTDays', u'currentTRate', u'totalAssetTRate', u'fixedAssetTRate', u'ROA', u'ROE', u'cashRateOfSales', u'netProfitCashCover', u'operatingReveCashCover', u'operatingRevenueYOY', u'netProfitYOY', u'operatingRevenueMOM', u'netProfitMOM']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'partyFullName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def LCEquityChangesStatementJYGet(partyID = "", beginDate = "", endDate = "", reportType = "", infoPublDateBegin = "", infoPublDateEnd = "", mark = "", field = "", pandas = "1"):
    """
    获取权益变动表，反映上市公司依据2007年新会计准则在在年报、中报、季报中披露的权益变动表；收录同一公司在报告期末的四种财务报告，即未调整的合并报表、未调整的母公司报表、调整后的合并报表以及调整后的母公司报表；若某个报告期的数据有多次调整，则该表展示最新调整数据；若某报告期暂未披露调整后数据，则已调整类别下的数据与调整前的数据一致；该表中各财务科目的单位均为人民币元；带“##”的特殊项目为单个公司披露的非标准化的科目，对应的“特殊字段说明”字段将对其作出说明；带“##”的调整项目是为了让报表的各个小项借贷平衡而设置的，便于客户对报表的遗漏和差错进行判断。
    
    :param partyID: 机构内部ID，通过机构名称在DataAPI.PartyIDGet获取，可多值输入，如'2','603',可以是列表,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param beginDate: 会计期末，输入开始日期,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param endDate: 会计期末，输入截止日期,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param reportType: 报告类型。Q1-一季度，S1-半年度，Q3-三季度，A-年度。对应DataAPI.SysCodeGet.codeTypeID=70001。,可以是列表,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param infoPublDateBegin: 信息发布日期，输入开始日期,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param infoPublDateEnd: 信息发布日期，输入截止日期,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param mark: 合并调整标志,1-合并调整，2-合并未调整，3-母公司调整，4-母公司未调整,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getLCEquityChangesStatementJY.csv?ispandas=1&') 
    requestString.append("partyID=")
    if hasattr(partyID,'__iter__') and not isinstance(partyID, str):
        if len(partyID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = partyID
            requestString.append(None)
        else:
            requestString.append(','.join(partyID))
    else:
        requestString.append(partyID)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&reportType=")
    if hasattr(reportType,'__iter__') and not isinstance(reportType, str):
        if len(reportType) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = reportType
            requestString.append(None)
        else:
            requestString.append(','.join(reportType))
    else:
        requestString.append(reportType)
    try:
        infoPublDateBegin = infoPublDateBegin.strftime('%Y%m%d')
    except:
        infoPublDateBegin = infoPublDateBegin.replace('-', '')
    requestString.append("&infoPublDateBegin=%s"%(infoPublDateBegin))
    try:
        infoPublDateEnd = infoPublDateEnd.strftime('%Y%m%d')
    except:
        infoPublDateEnd = infoPublDateEnd.replace('-', '')
    requestString.append("&infoPublDateEnd=%s"%(infoPublDateEnd))
    requestString.append("&mark=")
    if hasattr(mark,'__iter__') and not isinstance(mark, str):
        if len(mark) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = mark
            requestString.append(None)
        else:
            requestString.append(','.join(mark))
    else:
        requestString.append(mark)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1618)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1618)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'partyID', u'partyFullName', u'endDate', u'infoPublDate', u'infoSource', u'bulletinType', u'mark', u'accountingStandards', u'itemsSN', u'itemsName', u'itemsType', u'paidInCapital', u'capitalReserveFund', u'surplusReserveFund', u'retainedProfit', u'treasuryStock', u'commonRiskReserve', u'conversionMarginInFCR', u'specificReserves', u'otherShareholderEquity', u'specialItem', u'adjustmentItem', u'totalParentCompanySE', u'minoritySE', u'totalShareholderEquity', u'specialFieldRemark']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'partyFullName': 'str','infoSource': 'str','itemsName': 'str','specialFieldRemark': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def LCIndicesForValuationJYGet(secID = "", ticker = "", beginDate = "", endDate = "", reportType = "", field = "", pandas = "1"):
    """
    获取公司估值分析指标_新会计准则，包含市盈率、市净率、PEG等估值指标；每个季度更新。
    
    :param secID: 证券内部编码,可通过交易代码和交易市场在DataAPI.SecIDGet获取到,如'000002.XSHE',可以是列表,secID、ticker、beginDate、endDate、reportType至少选择一个
    :param ticker: 交易代码,如'000002',可以是列表,secID、ticker、beginDate、endDate、reportType至少选择一个
    :param beginDate: 会计期末，输入开始日期,secID、ticker、beginDate、endDate、reportType至少选择一个
    :param endDate: 会计期末，输入截止日期,secID、ticker、beginDate、endDate、reportType至少选择一个
    :param reportType: 报告类型。Q1-一季度，S1-半年度，Q3-三季度，A-年度。对应DataAPI.SysCodeGet.codeTypeID=70001。,可以是列表,secID、ticker、beginDate、endDate、reportType至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getLCIndicesForValuationJY.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&reportType=")
    if hasattr(reportType,'__iter__') and not isinstance(reportType, str):
        if len(reportType) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = reportType
            requestString.append(None)
        else:
            requestString.append(','.join(reportType))
    else:
        requestString.append(reportType)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1619)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1619)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'endDate', u'PE', u'PB', u'PCF', u'PS', u'dividendRatio']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def LCPriceRatioIndexJYGet(secID = "", ticker = "", beginDate = "", endDate = "", reportType = "", field = "", pandas = "1"):
    """
    获取股票市价比率指标(旧)，该类指标主要反映各证券品种价格与财务相关的指标。
    
    :param secID: 证券内部编码,可通过交易代码和交易市场在DataAPI.SecIDGet获取到,如'000002.XSHE',可以是列表,secID、ticker、beginDate、endDate、reportType至少选择一个
    :param ticker: 交易代码,如'000002',可以是列表,secID、ticker、beginDate、endDate、reportType至少选择一个
    :param beginDate: 会计期末，输入开始日期,secID、ticker、beginDate、endDate、reportType至少选择一个
    :param endDate: 会计期末，输入截止日期,secID、ticker、beginDate、endDate、reportType至少选择一个
    :param reportType: 报告类型。Q1-一季度，S1-半年度，Q3-三季度，A-年度。对应DataAPI.SysCodeGet.codeTypeID=70001。,可以是列表,secID、ticker、beginDate、endDate、reportType至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getLCPriceRatioIndexJY.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&reportType=")
    if hasattr(reportType,'__iter__') and not isinstance(reportType, str):
        if len(reportType) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = reportType
            requestString.append(None)
        else:
            requestString.append(','.join(reportType))
    else:
        requestString.append(reportType)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1620)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1620)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'endDate', u'stockDividendRatio', u'stockPERatio1', u'stockPERatio2', u'stockPERatio3', u'stockPBRatio', u'stockPBRatioAdjusted', u'stockCFM1', u'stockCFM2', u'stockCFM3', u'stockPSRatio1', u'stockPSRatio2', u'stockPSRatio3']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def LCWorkandGrowIndexJYGet(partyID = "", beginDate = "", endDate = "", reportType = "", field = "", pandas = "1"):
    """
    获取报告期营运发展能力及其他重要指标(旧)，包括上市公司经营发展能力指标、资产管理能力指标、价格比率指标以及常用的每股指标和模型指标,该指标都是用合并报表和调整前的数据计算出来，而且分别对金融类和非金融类公司的计算进行了说明。
    
    :param partyID: 机构内部ID，通过机构名称在DataAPI.PartyIDGet获取，可多值输入，如'2','603',可以是列表,partyID、beginDate、endDate、reportType至少选择一个
    :param beginDate: 会计期末，输入开始日期,partyID、beginDate、endDate、reportType至少选择一个
    :param endDate: 会计期末，输入截止日期,partyID、beginDate、endDate、reportType至少选择一个
    :param reportType: 报告类型。Q1-一季度，S1-半年度，Q3-三季度，A-年度。对应DataAPI.SysCodeGet.codeTypeID=70001。,可以是列表,partyID、beginDate、endDate、reportType至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getLCWorkandGrowIndexJY.csv?ispandas=1&') 
    requestString.append("partyID=")
    if hasattr(partyID,'__iter__') and not isinstance(partyID, str):
        if len(partyID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = partyID
            requestString.append(None)
        else:
            requestString.append(','.join(partyID))
    else:
        requestString.append(partyID)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&reportType=")
    if hasattr(reportType,'__iter__') and not isinstance(reportType, str):
        if len(reportType) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = reportType
            requestString.append(None)
        else:
            requestString.append(','.join(reportType))
    else:
        requestString.append(reportType)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1628)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1628)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'partyID', u'partyFullName', u'endDate', u'netAssetGrowRate', u'netProfitGrowRate', u'mainIncomeGrowRate', u'grossProfitGrowRate', u'operProfitGrowRate', u'totalProfeiGrowRate', u'totalAssetGrowRate', u'ARTRGrowRate', u'FATRGrowRate', u'FAExpansionRate', u'capitalItemKeepRate', u'inventoryTRGrowRate', u'operCashPSGrowRate', u'cashEquivalentsGroRate', u'sustainableGrowRate', u'PBVGrowRate', u'EPSGrowRate', u'operCycle', u'inventoryTRate', u'inventoryTDays', u'ARTRate', u'ARTDays', u'creditTRate', u'currentTRate', u'totalAssetTRate', u'fixedAssetTRate', u'equityTRate', u'assetLossRatio', u'newnessRate', u'accruedPayableTRate', u'financialLeverage', u'EPS', u'EPSWeighted', u'EPSCut', u'EPSCutWeighted', u'netAssetPS', u'netAssetPSAdjusted', u'accumulationFundPS', u'undividedProfit', u'operCashFlowPS', u'cashEquivalentPS', u'operProfitPS', u'mainOperProfitPS', u'dividendPS', u'mainIncomePS', u'cashFlowPS', u'capitalSurplusFundPS', u'enterpriseValue', u'Q', u'EVPS', u'EVtoEBITDA', u'MVA', u'floatMVA', u'companyDividendRatio', u'marketValueToDebt1', u'marketValueToDebt2', u'debtToAssetValue1', u'debtToAssetValue2', u'companyPERatio1', u'companyPERatio2', u'companyPERatio3', u'companyPBRatio', u'companyPBRatioAdjusted', u'companyCFM1', u'companyCFM2', u'companyCFM3', u'companyPSRatio1', u'companyPSRatio2', u'companyPSRatio3']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'partyFullName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def LCNewestFinaIndexJYGet(partyID = "", beginDate = "", endDate = "", reportType = "", field = "", pandas = "1"):
    """
    获取最新财务指标，披露上市公司最新的一些财务指标，这些指标的主要特点是已经发生了变化，但尚未在报表中反映出来。
    
    :param partyID: 机构内部ID，通过机构名称在DataAPI.PartyIDGet获取，可多值输入，如'2','603',可以是列表,partyID、beginDate、endDate、reportType至少选择一个
    :param beginDate: 输入开始日期,partyID、beginDate、endDate、reportType至少选择一个
    :param endDate: 输入截止日期,partyID、beginDate、endDate、reportType至少选择一个
    :param reportType: 报告类型。Q1-一季度，S1-半年度，Q3-三季度，A-年度。对应DataAPI.SysCodeGet.codeTypeID=70001。,可以是列表,partyID、beginDate、endDate、reportType至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getLCNewestFinaIndexJY.csv?ispandas=1&') 
    requestString.append("partyID=")
    if hasattr(partyID,'__iter__') and not isinstance(partyID, str):
        if len(partyID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = partyID
            requestString.append(None)
        else:
            requestString.append(','.join(partyID))
    else:
        requestString.append(partyID)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&reportType=")
    if hasattr(reportType,'__iter__') and not isinstance(reportType, str):
        if len(reportType) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = reportType
            requestString.append(None)
        else:
            requestString.append(','.join(reportType))
    else:
        requestString.append(reportType)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1629)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1629)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'partyID', u'partyFullName', u'adjustDate', u'adjustReason', u'shareCapitalBeforeAdjust', u'sHareCapitalIncr', u'shareCapitalAftereAdjust', u'capitalReserveBeforeAdjust', u'capitalReserveIncr', u'capitalReserveAfterAdjust', u'retainedProfitBeforeAdjust', u'retainedProfitIncr', u'retainedProfitAfterAdjust', u'surplusReserveBeforeAdjust', u'surplusReserveIncr', u'surplusReserveAfterAdjust', u'netAssetBeforeAdjust', u'netAssetIncr', u'netAssetAfterAdjust', u'EPS', u'NAPS', u'retainedProfitPS', u'capitalReservePS', u'netOperateCashFlowPS']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'partyFullName': 'str','adjustReason': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def LCOperatingStatusJYGet(partyID = "", beginDate = "", endDate = "", reportType = "", field = "", pandas = "1"):
    """
    获取经营情况评述，公司管理层对季度、半年度、年度经营情况的自我评价，以及其后发展期后发展计划和预测，包括公司招股以来的历次纪录
    
    :param partyID: 机构内部ID，通过机构名称在DataAPI.PartyIDGet获取，可多值输入，如'2','603',可以是列表,partyID、beginDate、endDate、reportType至少选择一个
    :param beginDate: 会计期末，输入开始日期,partyID、beginDate、endDate、reportType至少选择一个
    :param endDate: 会计期末，输入截止日期,partyID、beginDate、endDate、reportType至少选择一个
    :param reportType: 报告类型。Q1-一季度，S1-半年度，Q3-三季度，A-年度。对应DataAPI.SysCodeGet.codeTypeID=70001。,可以是列表,partyID、beginDate、endDate、reportType至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getLCOperatingStatusJY.csv?ispandas=1&') 
    requestString.append("partyID=")
    if hasattr(partyID,'__iter__') and not isinstance(partyID, str):
        if len(partyID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = partyID
            requestString.append(None)
        else:
            requestString.append(','.join(partyID))
    else:
        requestString.append(partyID)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&reportType=")
    if hasattr(reportType,'__iter__') and not isinstance(reportType, str):
        if len(reportType) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = reportType
            requestString.append(None)
        else:
            requestString.append(','.join(reportType))
    else:
        requestString.append(reportType)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1630)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1630)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'partyID', u'partyFullName', u'endDate', u'infoSource', u'operatingStatement']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'partyFullName': 'str','infoSource': 'str','operatingStatement': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def LCFQIncomeStatementJYGet(partyID = "", beginDate = "", endDate = "", reportType = "", ifAdjusted = "", ifMerged = "", field = "", pandas = "1"):
    """
    获取金融类单季利润表(旧会计准则)，自公布季报以来金融类公司单季利润表情况，包括合并、母公司、调整前、调整后数据；各财务科目单位均为人民币元。
    
    :param partyID: 机构内部ID，通过机构名称在DataAPI.PartyIDGet获取，可多值输入，如'2','603',可以是列表,partyID、beginDate、endDate、reportType至少选择一个
    :param beginDate: 会计期末，输入开始日期,partyID、beginDate、endDate、reportType至少选择一个
    :param endDate: 会计期末，输入截止日期,partyID、beginDate、endDate、reportType至少选择一个
    :param reportType: 报告类型。Q1-第一季度，Q2-第二季度，Q3-第三季度，Q4-第四季度。对应DataAPI.SysCodeGet.codeTypeID=70001。,可以是列表,partyID、beginDate、endDate、reportType至少选择一个
    :param ifAdjusted: 是否调整，通过DataAPI.JY.CTSystemConstJYGet(LB='1188')得到。,可以是列表,可空
    :param ifMerged: 是否合并，通过DataAPI.JY.CTSystemConstJYGet(LB='1189')得到。,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getLCFQIncomeStatementJY.csv?ispandas=1&') 
    requestString.append("partyID=")
    if hasattr(partyID,'__iter__') and not isinstance(partyID, str):
        if len(partyID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = partyID
            requestString.append(None)
        else:
            requestString.append(','.join(partyID))
    else:
        requestString.append(partyID)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&reportType=")
    if hasattr(reportType,'__iter__') and not isinstance(reportType, str):
        if len(reportType) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = reportType
            requestString.append(None)
        else:
            requestString.append(','.join(reportType))
    else:
        requestString.append(reportType)
    requestString.append("&ifAdjusted=")
    if hasattr(ifAdjusted,'__iter__') and not isinstance(ifAdjusted, str):
        if len(ifAdjusted) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ifAdjusted
            requestString.append(None)
        else:
            requestString.append(','.join(ifAdjusted))
    else:
        requestString.append(ifAdjusted)
    requestString.append("&ifMerged=")
    if hasattr(ifMerged,'__iter__') and not isinstance(ifMerged, str):
        if len(ifMerged) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ifMerged
            requestString.append(None)
        else:
            requestString.append(','.join(ifMerged))
    else:
        requestString.append(ifMerged)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1631)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1631)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'partyID', u'partyFullName', u'endDate', u'ifAdjusted', u'ifMerged', u'operatingIncome', u'interestIncome', u'financeCoTurnoverIncome', u'inSystemTurnoverIncome', u'associateTurnoverIncome', u'commissionIncome', u'discountInterestIncome', u'secuSpreadIncome', u'secuIssueSpreadIncome', u'trustIncome', u'boughtSellbackSecuIncome', u'leaseoutIncome', u'exchangeIncome', u'investIncome', u'otherOperatingIncome', u'operatingPayout', u'interestExpense', u'financeCoTurnoverExpense', u'inSystemTurnoverExpense', u'associateTurnoverExpense', u'commissionExpense', u'selfSecuDevalLoss', u'inventoryDevalProvision', u'soldBuybackSecuExpense', u'exchangeLoss', u'administrationExpense', u'operatingExpense', u'financialExpense', u'otherOperatingExpense', u'operatingTaxAndSurcharges', u'netInvestIncome', u'operatingProfit', u'otherBizProfit', u'nonOperatingInvestIncome', u'subsidyIncome', u'nonoperatingIncome', u'nonoperatingExpense', u'priorYearProfitAdjust', u'assetLossReserve', u'totalProfit', u'incomeTax', u'financeRefund', u'minorityProfit', u'unrecognisedInvestLoss', u'mergeAndAcquisitionProfit', u'netProfit', u'changePublDate']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'partyFullName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def LCFQCashFlowStatementJYGet(partyID = "", beginDate = "", endDate = "", reportType = "", ifAdjusted = "", ifMerged = "", field = "", pandas = "1"):
    """
    获取金融类单季现金流量表(旧会计准则)，自公布季报以来金融类公司单季现金流量表情况，包括合并调整、合并未调整、母公司调整、母公司未调整数据；各财务科目单位均为人民币元。
    
    :param partyID: 机构内部ID，通过机构名称在DataAPI.PartyIDGet获取，可多值输入，如'2','603',可以是列表,partyID、beginDate、endDate、reportType至少选择一个
    :param beginDate: 会计期末，输入开始日期,partyID、beginDate、endDate、reportType至少选择一个
    :param endDate: 会计期末，输入截止日期,partyID、beginDate、endDate、reportType至少选择一个
    :param reportType: 报告类型。Q1-第一季度，Q2-第二季度，Q3-第三季度，Q4-第四季度。对应DataAPI.SysCodeGet.codeTypeID=70001。,可以是列表,partyID、beginDate、endDate、reportType至少选择一个
    :param ifAdjusted: 是否调整，1-调整，2-未调整,可以是列表,可空
    :param ifMerged: 是否合并，1-合并报表，2-母公司报表,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getLCFQCashFlowStatementJY.csv?ispandas=1&') 
    requestString.append("partyID=")
    if hasattr(partyID,'__iter__') and not isinstance(partyID, str):
        if len(partyID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = partyID
            requestString.append(None)
        else:
            requestString.append(','.join(partyID))
    else:
        requestString.append(partyID)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&reportType=")
    if hasattr(reportType,'__iter__') and not isinstance(reportType, str):
        if len(reportType) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = reportType
            requestString.append(None)
        else:
            requestString.append(','.join(reportType))
    else:
        requestString.append(reportType)
    requestString.append("&ifAdjusted=")
    if hasattr(ifAdjusted,'__iter__') and not isinstance(ifAdjusted, str):
        if len(ifAdjusted) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ifAdjusted
            requestString.append(None)
        else:
            requestString.append(','.join(ifAdjusted))
    else:
        requestString.append(ifAdjusted)
    requestString.append("&ifMerged=")
    if hasattr(ifMerged,'__iter__') and not isinstance(ifMerged, str):
        if len(ifMerged) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ifMerged
            requestString.append(None)
        else:
            requestString.append(','.join(ifMerged))
    else:
        requestString.append(ifMerged)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1632)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1632)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'partyID', u'partyFullName', u'endDate', u'ifAdjusted', u'ifMerged', u'MLTermLoanPrincipalReceived', u'STermLoanPrincipalReceived', u'interestReceived', u'netDepositIncrease', u'currentDepositCash', u'nonCurrentDepositCash', u'netDepositOfInterbankSystem', u'netBorrowingFromInterbank', u'netBorrowingFromFinanceCo', u'lendCapitalRepayment', u'financeCoTurnoverCashIn', u'CBTurnoverCashIncrease', u'interbankTurnoverIncome', u'commissionCashIn', u'operBondInvestIncomeCashIn', u'netExchangeIncomeCashIn', u'trustBusinessNetCashIn', u'writtenOffReceiveBack', u'netClientBail', u'selfSecuCashIn', u'proxySecuCashIn', u'subIssueSecuCashIn', u'subHonorSecuCashIn', u'soldBuybackSecuCashIn', u'soldSellbackSecuCashIn', u'secuSpreadIncomeCashIn', u'secuIssueSpreadIncomeCashIn', u'trustAssetCashIn', u'otherSecuBizCashIn', u'rentalReceived', u'goodsSaleServiceRenderCash', u'receivedRent', u'otherOperateCashReceived', u'taxesReceived', u'VATReceivedAndRefunded', u'otherTaxLevyRefund', u'otherCashInRelatedOperate', u'subtotalOperateCashInflow', u'netLoanIncrease', u'STermLoan', u'MLTermLoan', u'subLoan', u'currentDepositWithdrawal', u'MLTermDepositWithdrawal', u'increasedDiscountCashOut', u'netDepositInInterbankSystem', u'depositInCentralBank', u'netCommonDepositReserve', u'netLoanToInterbank', u'netLoanToFinanceCo', u'netNoteFinance', u'turnoverCashOut', u'trustBusinessCashOut', u'debtRepayment', u'interestExpenseCashOut', u'interbankTurnoverExpense', u'commissionCashOut', u'operBondInvestCashOut', u'selfSecuCashOut', u'proxySecuCashOut', u'subIssueSecuCashOut', u'subHonorSecuCashOut', u'boughtSellbackSecuCashOut', u'boughtBuybackSecuCashOut', u'trustAssetCashOut', u'operateLeasesCashPaid', u'goodsServicesCashPaid', u'otherOperateCashOut', u'staffBehalfPaid', u'operateExpenseCashPaid', u'taxesPaid', u'operateTaxSurchargesPaid', u'VATPaid', u'incomeTaxPaid', u'otherTaxesPaid', u'otherOperateCashPaid', u'subtotalOperateCashOutflow', u'netOperateCashFlow1', u'investWithdrawalCash', u'financeLeasePrincipalBack', u'financeLeaseRentalReceived', u'dividendAndProfitReceived', u'bondInterestIncome', u'fixIntanOtherAssetDispoCash', u'sellSubCompanyCashIn', u'otherCashFromInvestAct', u'subtotalInvestCashInflow', u'fixIntanOtherAssetAcquiCash', u'equityInvestCashPaid', u'debtInvestCashPaid', u'otherCashToInvestAct', u'subtotalInvestCashOutflow', u'netInvestCashFlow', u'issueShareproceeds', u'issueBondProceed', u'borrowingProceed', u'otherFinanceActProceed', u'subtotalFinanceCashInflow', u'borrowingRepayment', u'bondRedemptionCashPaid', u'financeActPayment', u'dividendProfitDistribPayment', u'interestPayment', u'MLTermBondInterestPaid', u'financeLeasePayment', u'regCapitalReductionPayment', u'otherFinanceActPayment', u'subtotalFinanceCashOutflow', u'netFinanceCashFlow', u'exchangeRateChangeEffect', u'cashEquivalentIncrease', u'fixedAssetTransRepayment', u'investTransRepayment', u'fixedAssetTransInvest', u'inventoryTransRepayment', u'financeLeaseFixedAssets', u'nonCashEndowment', u'investTransLoan', u'netProfit', u'minorityProfit', u'unrecognisedInvestLoss', u'badDebtWrittenOffProvision', u'riskReserve', u'selfSecuLossReserve', u'badLoanProvision', u'investLossReserve', u'inventoryDevalProvision', u'otherAssetLossReserve', u'fixedAssetDepreciation', u'seatFeeAmort', u'preoperateEexpenseAmort', u'deferredExpenseAmort', u'intangiDeferredAssetAmort', u'deferredExpenseDecreased', u'accruedExpenseAdded', u'fixIntanOtherAssetDispoLoss', u'fixedAssetScrapLoss', u'financialExpense', u'investLoss', u'inveFinaActExchGainOrLoss', u'netDeferedTaxCredit', u'inventoryDecr', u'lendCapitalDecr', u'STermLoanInvestDecr', u'subLoanDecr', u'secuAssetDecr', u'tradeBailDecr', u'receivablesDecr', u'trustAssetDecr', u'selfSecuDecr', u'boughtSellbackSecuDecr', u'proxySecuDecr', u'subIssueSecuDecr', u'subHonorSecuDecr', u'issueExpenseToTransDecr', u'operReceivablesDecr', u'trustDepositIncr', u'borrowingsIncr', u'secuDebtIncr', u'pledgeBorrowingIncr', u'trustCapitalIncr', u'agentSecuPayableIncr', u'proxySecuProceedsIncr', u'subIssueSecuProceedsIncr', u'subHonorSecuProceedsIncr', u'soldBuybackSecuProcIncr', u'payablesIncr', u'wagePayableIncr', u'welfarePayableIncr', u'taxSurchargesPayableIncr', u'operPayablesIncr', u'netVATIncr', u'otherNonCashExpenseOrLoss', u'netOperateCashFlow2', u'changePublDate']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'partyFullName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def LCFIncomeStatementJYGet(partyID = "", beginDate = "", endDate = "", reportType = "", infoPublDateBegin = "", infoPublDateEnd = "", ifAdjusted = "", ifMerged = "", field = "", pandas = "1"):
    """
    获取金融类报告期利润及分配表(旧会计准则)，金融类公司招股前三年及上市后历年季报、中报、年报的利润及利润分配报表，包括当年的合并、母公司报表，以及当年对上年调整的合并、母公司报表；各财务科目单位均为人民币元。
    
    :param partyID: 机构内部ID，通过机构名称在DataAPI.PartyIDGet获取，可多值输入，如'2','603',可以是列表,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param beginDate: 会计期末，输入开始日期,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param endDate: 会计期末，输入截止日期,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param reportType: 报告类型。Q1-一季度，S1-半年度，Q3-三季度，A-年度。对应DataAPI.SysCodeGet.codeTypeID=70001。,可以是列表,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param infoPublDateBegin: 信息发布日期，输入开始日期,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param infoPublDateEnd: 信息发布日期，输入截止日期,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param ifAdjusted: 是否调整，1-调整，2-未调整，4-季度未调整，5-季度调整。注：季度数据是第三季度财务数据,可以是列表,可空
    :param ifMerged: 是否合并，1-合并报表，2-母公司报表,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getLCFIncomeStatementJY.csv?ispandas=1&') 
    requestString.append("partyID=")
    if hasattr(partyID,'__iter__') and not isinstance(partyID, str):
        if len(partyID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = partyID
            requestString.append(None)
        else:
            requestString.append(','.join(partyID))
    else:
        requestString.append(partyID)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&reportType=")
    if hasattr(reportType,'__iter__') and not isinstance(reportType, str):
        if len(reportType) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = reportType
            requestString.append(None)
        else:
            requestString.append(','.join(reportType))
    else:
        requestString.append(reportType)
    try:
        infoPublDateBegin = infoPublDateBegin.strftime('%Y%m%d')
    except:
        infoPublDateBegin = infoPublDateBegin.replace('-', '')
    requestString.append("&infoPublDateBegin=%s"%(infoPublDateBegin))
    try:
        infoPublDateEnd = infoPublDateEnd.strftime('%Y%m%d')
    except:
        infoPublDateEnd = infoPublDateEnd.replace('-', '')
    requestString.append("&infoPublDateEnd=%s"%(infoPublDateEnd))
    requestString.append("&ifAdjusted=")
    if hasattr(ifAdjusted,'__iter__') and not isinstance(ifAdjusted, str):
        if len(ifAdjusted) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ifAdjusted
            requestString.append(None)
        else:
            requestString.append(','.join(ifAdjusted))
    else:
        requestString.append(ifAdjusted)
    requestString.append("&ifMerged=")
    if hasattr(ifMerged,'__iter__') and not isinstance(ifMerged, str):
        if len(ifMerged) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ifMerged
            requestString.append(None)
        else:
            requestString.append(','.join(ifMerged))
    else:
        requestString.append(ifMerged)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1633)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1633)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'partyID', u'partyFullName', u'endDate', u'infoPublDate', u'ifAdjusted', u'ifMerged', u'operatingIncome', u'interestIncome', u'financeCoTurnoverIncome', u'inSystemTurnoverIncome', u'associateTurnoverIncome', u'commissionIncome', u'discountInterestIncome', u'secuSpreadIncome', u'secuIssueSpreadIncome', u'trustIncome', u'boughtSellbackSecuIncome', u'leaseoutIncome', u'exchangeIncome', u'investIncome', u'otherOperatingIncome', u'operatingPayout', u'interestExpense', u'financeCoTurnoverExpense', u'inSystemTurnoverExpense', u'associateTurnoverExpense', u'commissionExpense', u'selfSecuDevalLoss', u'inventoryDevalProvision', u'soldBuybackSecuExpense', u'exchangeLoss', u'administrationExpense', u'operatingExpense', u'financialExpense', u'otherOperatingExpense', u'operatingTaxAndSurcharges', u'netInvestIncome', u'operatingProfit', u'otherBizProfit', u'nonOperatingInvestIncome', u'subsidyIncome', u'nonoperatingIncome', u'nonoperatingExpense', u'priorYearProfitAdjust', u'assetLossReserve', u'totalProfit', u'incomeTax', u'financeRefund', u'minorityProfit', u'unrecognisedInvestLoss', u'mergeAndAcquisitionProfit', u'netProfit', u'retainedProfitFromBegin', u'RPforReduceRegCapital', u'profitSwitchFromSurplus', u'conversionMargin', u'distributableProfit', u'statutorySurplusReserve', u'statutoryCommonWealFund', u'staffBonusAndWelfareFund', u'foreignCapitalReserve', u'ordinaryRiskReserve', u'profitforShareholder', u'preferredStockDividend', u'discretionarySurplusFund', u'commonDividendPayable', u'commonDiviChangeToCapital', u'profitFromMerging', u'retainedProfit', u'changePublDate']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'partyFullName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def LCFCashFlowStatementJYGet(partyID = "", beginDate = "", endDate = "", reportType = "", infoPublDateBegin = "", infoPublDateEnd = "", ifAdjusted = "", ifMerged = "", field = "", pandas = "1"):
    """
    获取金融类报告期现金流量表(旧会计准则)，98年中期以后金融类公司历年季报、中报、年报的现金流量报表，包括当年的合并、母公司报表，以及当年对上年调整的合并、母公司报表；各财务科目单位均为人民币元。
    
    :param partyID: 机构内部ID，通过机构名称在DataAPI.PartyIDGet获取，可多值输入，如'2','603',可以是列表,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param beginDate: 会计期末，输入开始日期,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param endDate: 会计期末，输入截止日期,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param reportType: 报告类型。Q1-一季度，S1-半年度，Q3-三季度，A-年度。对应DataAPI.SysCodeGet.codeTypeID=70001。,可以是列表,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param infoPublDateBegin: 信息发布日期，输入开始日期,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param infoPublDateEnd: 信息发布日期，输入截止日期,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param ifAdjusted: 是否调整，1-调整，2-未调整,可以是列表,可空
    :param ifMerged: 是否合并，1-合并报表，2-母公司报表,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getLCFCashFlowStatementJY.csv?ispandas=1&') 
    requestString.append("partyID=")
    if hasattr(partyID,'__iter__') and not isinstance(partyID, str):
        if len(partyID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = partyID
            requestString.append(None)
        else:
            requestString.append(','.join(partyID))
    else:
        requestString.append(partyID)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&reportType=")
    if hasattr(reportType,'__iter__') and not isinstance(reportType, str):
        if len(reportType) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = reportType
            requestString.append(None)
        else:
            requestString.append(','.join(reportType))
    else:
        requestString.append(reportType)
    try:
        infoPublDateBegin = infoPublDateBegin.strftime('%Y%m%d')
    except:
        infoPublDateBegin = infoPublDateBegin.replace('-', '')
    requestString.append("&infoPublDateBegin=%s"%(infoPublDateBegin))
    try:
        infoPublDateEnd = infoPublDateEnd.strftime('%Y%m%d')
    except:
        infoPublDateEnd = infoPublDateEnd.replace('-', '')
    requestString.append("&infoPublDateEnd=%s"%(infoPublDateEnd))
    requestString.append("&ifAdjusted=")
    if hasattr(ifAdjusted,'__iter__') and not isinstance(ifAdjusted, str):
        if len(ifAdjusted) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ifAdjusted
            requestString.append(None)
        else:
            requestString.append(','.join(ifAdjusted))
    else:
        requestString.append(ifAdjusted)
    requestString.append("&ifMerged=")
    if hasattr(ifMerged,'__iter__') and not isinstance(ifMerged, str):
        if len(ifMerged) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ifMerged
            requestString.append(None)
        else:
            requestString.append(','.join(ifMerged))
    else:
        requestString.append(ifMerged)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1634)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1634)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'partyID', u'partyFullName', u'endDate', u'infoPublDate', u'ifAdjusted', u'ifMerged', u'MLTermLoanPrincipalReceived', u'STermLoanPrincipalReceived', u'interestReceived', u'netDepositIncrease', u'currentDepositCash', u'nonCurrentDepositCash', u'netDepositOfInterbankSystem', u'netBorrowingFromInterbank', u'netBorrowingFromFinanceCo', u'lendCapitalRepayment', u'financeCoTurnoverCashIn', u'CBTurnoverCashIncrease', u'interbankTurnoverIncome', u'commissionCashIn', u'operBondInvestIncomeCashIn', u'netExchangeIncomeCashIn', u'trustBusinessNetCashIn', u'writtenOffReceiveBack', u'netClientBail', u'selfSecuCashIn', u'proxySecuCashIn', u'subIssueSecuCashIn', u'subHonorSecuCashIn', u'soldBuybackSecuCashIn', u'soldSellbackSecuCashIn', u'secuSpreadIncomeCashIn', u'secuIssueSpreadIncomeCashIn', u'trustAssetCashIn', u'otherSecuBizCashIn', u'rentalReceived', u'goodsSaleServiceRenderCash', u'receivedRent', u'otherOperateCashReceived', u'taxesReceived', u'VATReceivedAndRefunded', u'otherTaxLevyRefund', u'otherCashInRelatedOperate', u'subtotalOperateCashInflow', u'netLoanIncrease', u'STermLoan', u'MLTermLoan', u'subLoan', u'currentDepositWithdrawal', u'MLTermDepositWithdrawal', u'increasedDiscountCashOut', u'netDepositInInterbankSystem', u'depositInCentralBank', u'netCommonDepositReserve', u'netLoanToInterbank', u'netLoanToFinanceCo', u'netNoteFinance', u'turnoverCashOut', u'trustBusinessCashOut', u'debtRepayment', u'interestExpenseCashOut', u'interbankTurnoverExpense', u'commissionCashOut', u'operBondInvestCashOut', u'selfSecuCashOut', u'proxySecuCashOut', u'subIssueSecuCashOut', u'subHonorSecuCashOut', u'boughtSellbackSecuCashOut', u'boughtBuybackSecuCashOut', u'trustAssetCashOut', u'operateLeasesCashPaid', u'goodsServicesCashPaid', u'otherOperateCashOut', u'staffBehalfPaid', u'operateExpenseCashPaid', u'taxesPaid', u'operateTaxSurchargesPaid', u'VATPaid', u'incomeTaxPaid', u'otherTaxesPaid', u'otherOperateCashPaid', u'subtotalOperateCashOutflow', u'netOperateCashFlow1', u'investWithdrawalCash', u'financeLeasePrincipalBack', u'financeLeaseRentalReceived', u'dividendAndProfitReceived', u'bondInterestIncome', u'fixIntanOtherAssetDispoCash', u'sellSubCompanyCashIn', u'otherCashFromInvestAct', u'subtotalInvestCashInflow', u'fixIntanOtherAssetAcquiCash', u'equityInvestCashPaid', u'debtInvestCashPaid', u'otherCashToInvestAct', u'subtotalInvestCashOutflow', u'netInvestCashFlow', u'issueShareproceeds', u'issueBondProceed', u'borrowingProceed', u'otherFinanceActProceed', u'subtotalFinanceCashInflow', u'borrowingRepayment', u'bondRedemptionCashPaid', u'financeActPayment', u'dividendProfitDistribPayment', u'interestPayment', u'MLTermBondInterestPaid', u'financeLeasePayment', u'regCapitalReductionPayment', u'otherFinanceActPayment', u'subtotalFinanceCashOutflow', u'netFinanceCashFlow', u'exchangeRateChangeEffect', u'cashEquivalentIncrease1', u'fixedAssetTransRepayment', u'investTransRepayment', u'fixedAssetTransInvest', u'inventoryTransRepayment', u'financeLeaseFixedAssets', u'nonCashEndowment', u'investTransLoan', u'netProfit', u'minorityProfit', u'unrecognisedInvestLoss', u'badDebtWrittenOffProvision', u'riskReserve', u'selfSecuLossReserve', u'badLoanProvision', u'investLossReserve', u'inventoryDevalProvision', u'otherAssetLossReserve', u'fixedAssetDepreciation', u'seatFeeAmort', u'preoperateEexpenseAmort', u'deferredExpenseAmort', u'intangiDeferredAssetAmort', u'deferredExpenseDecreased', u'accruedExpenseAdded', u'fixIntanOtherAssetDispoLoss', u'fixedAssetScrapLoss', u'financialExpense', u'investLoss', u'inveFinaActExchGainOrLoss', u'netDeferedTaxCredit', u'inventoryDecr', u'lendCapitalDecr', u'STermLoanInvestDecr', u'subLoanDecr', u'secuAssetDecr', u'tradeBailDecr', u'receivablesDecr', u'trustAssetDecr', u'selfSecuDecr', u'boughtSellbackSecuDecr', u'proxySecuDecr', u'subIssueSecuDecr', u'subHonorSecuDecr', u'issueExpenseToTransDecr', u'operReceivablesDecr', u'trustDepositIncr', u'borrowingsIncr', u'secuDebtIncr', u'pledgeBorrowingIncr', u'trustCapitalIncr', u'agentSecuPayableIncr', u'proxySecuProceedsIncr', u'subIssueSecuProceedsIncr', u'subHonorSecuProceedsIncr', u'soldBuybackSecuProcIncr', u'payablesIncr', u'wagePayableIncr', u'welfarePayableIncr', u'taxSurchargesPayableIncr', u'operPayablesIncr', u'netVATIncr', u'otherNonCashExpenseOrLoss', u'netOperateCashFlow2', u'endPeriodCashEquivalent', u'endPeriodEquivalent', u'endPeriodCash', u'beginPeriodCashEquivalent', u'beginPeriodEquivalent', u'beginPeriodCash', u'cashEquivalentIncrease2', u'changePublDate']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'partyFullName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def LCCashFlowStatementJYGet(partyID = "", beginDate = "", endDate = "", reportType = "", infoPublDateBegin = "", infoPublDateEnd = "", ifMerged = "", field = "", pandas = "1"):
    """
    获取非金融类报告期现金流量表(旧会计准则)，98年中期以后非金融公司历年季报、中报、年报的现金流量报表，包括当年的合并、母公司报表；各财务科目单位均为人民币元。
    
    :param partyID: 机构内部ID，通过机构名称在DataAPI.PartyIDGet获取，可多值输入，如'2','603',可以是列表,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param beginDate: 会计期末，输入开始日期,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param endDate: 会计期末，输入截止日期,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param reportType: 报告类型。Q1-一季度，S1-半年度，Q3-三季度，A-年度。对应DataAPI.SysCodeGet.codeTypeID=70001。,可以是列表,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param infoPublDateBegin: 信息发布日期，输入开始日期,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param infoPublDateEnd: 信息发布日期，输入截止日期,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param ifMerged: 是否合并，通过DataAPI.JY.CTSystemConstJYGet(LB='1189')得到具体的合并情况描述。1-合并未调整，2-母公司未调整，3-合并调整，4-母公司调整,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getLCCashFlowStatementJY.csv?ispandas=1&') 
    requestString.append("partyID=")
    if hasattr(partyID,'__iter__') and not isinstance(partyID, str):
        if len(partyID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = partyID
            requestString.append(None)
        else:
            requestString.append(','.join(partyID))
    else:
        requestString.append(partyID)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&reportType=")
    if hasattr(reportType,'__iter__') and not isinstance(reportType, str):
        if len(reportType) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = reportType
            requestString.append(None)
        else:
            requestString.append(','.join(reportType))
    else:
        requestString.append(reportType)
    try:
        infoPublDateBegin = infoPublDateBegin.strftime('%Y%m%d')
    except:
        infoPublDateBegin = infoPublDateBegin.replace('-', '')
    requestString.append("&infoPublDateBegin=%s"%(infoPublDateBegin))
    try:
        infoPublDateEnd = infoPublDateEnd.strftime('%Y%m%d')
    except:
        infoPublDateEnd = infoPublDateEnd.replace('-', '')
    requestString.append("&infoPublDateEnd=%s"%(infoPublDateEnd))
    requestString.append("&ifMerged=")
    if hasattr(ifMerged,'__iter__') and not isinstance(ifMerged, str):
        if len(ifMerged) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ifMerged
            requestString.append(None)
        else:
            requestString.append(','.join(ifMerged))
    else:
        requestString.append(ifMerged)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1635)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1635)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'partyID', u'partyFullName', u'endDate', u'infoPublDate', u'ifMerged', u'goodsSaleServiceRenderCash', u'rentalReceived', u'VATReceivedAndRefunded', u'otherTaxLevyRefund', u'taxLevyRefund', u'otherCashInRelatedOperate', u'subtotalOperateCashInflow', u'goodsServicesCashPaid', u'operateLeasesCashPaid', u'staffBehalfPaid', u'VATPaid', u'incomeTaxPaid', u'otherTaxPaid', u'allTaxesPaid', u'otherOperateCashPaid', u'subtotalOperateCashOutflow', u'netOperateCashFlow', u'investWithdrawalCash', u'dividendAndProfitReceived', u'bondInterestIncome', u'fixIntanOtherAssetDispoCash', u'otherCashFromInvestAct', u'subtotalInvestCashInflow', u'fixIntanOtherAssetAcquiCash', u'equityInvestCashPaid', u'debtInvestCashPaid', u'otherCashToInvestAct', u'subtotalInvestCashOutflow', u'netInvestCashFlow', u'issueShareproceeds', u'minorityInvestproceeds', u'issueBondproceeds', u'borrowingproceeds', u'otherFinanceActproceeds', u'subtotalFinanceCashInflow', u'borrowingRepayment', u'financeActPayment', u'dividendProfitDistribPayment', u'subCompanyPaidDiviToMino', u'interestPayment', u'financeLeasePayment', u'regCapitalReductionPayment', u'subCompanyCapiReduPaidMino', u'otherFinanceActPayment', u'subtotalFinanceCashOutflow', u'netFinanceCashFlow', u'exchanRateChangeEffect', u'cashEquivalentIncrease', u'fixedAssetTransRepayment', u'investTransRepayment', u'fixedAssetFormInvest', u'inventoryTransRepayment', u'financeLeaseFixedAssets', u'netProfit', u'minorityProfit', u'mergeAcquisitionProfit', u'unrecognisedInvestLoss', u'badDebtWrittenOffProvision', u'fixedAssetDepreciation', u'intangibleAssetAmortization', u'preoperateEexpenseAmort', u'deferredExpenseAmort', u'deferredExpenseDecreased', u'accruedExpenseAdded', u'fixIntanOtherAssetDispoLoss', u'fixedAssetScrapLoss', u'financialExpense', u'investLoss', u'netDeferedTaxCredit', u'inventoryDecrease', u'inventoryDevalProvision', u'operateReceivableDecrease', u'operatePayableDecrease', u'VATNetIncrease', u'others', u'netOperateCashFlowNotes', u'endPeriodCash', u'beginPeriodCash', u'endPeriodCashEquivalent', u'beginPeriodCashEquivalent', u'cashEquivalentIncreaseNotes', u'changePublDate']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'partyFullName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def LCIncomeStatementJYGet(partyID = "", beginDate = "", endDate = "", reportType = "", infoPublDateBegin = "", infoPublDateEnd = "", ifAdjusted = "", ifMerged = "", field = "", pandas = "1"):
    """
    获取非金融类报告期利润及分配表(旧会计准则)，非金融公司招股前三年及上市后历年季报、中报、年报的利润及利润分配报表，包括当年的合并、母公司报表，以及当年对上年调整的合并、母公司报表；各财务科目单位均为人民币元。
    
    :param partyID: 机构内部ID，通过机构名称在DataAPI.PartyIDGet获取，可多值输入，如'2','603',可以是列表,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param beginDate: 会计期末，输入开始日期,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param endDate: 会计期末，输入截止日期,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param reportType: 报告类型。Q1-一季度，S1-半年度，Q3-三季度，A-年度。对应DataAPI.SysCodeGet.codeTypeID=70001。,可以是列表,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param infoPublDateBegin: 信息发布日期，输入开始日期,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param infoPublDateEnd: 信息发布日期，输入截止日期,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param ifAdjusted: 是否调整，1-调整，2-未调整，4-季度未调整，5-季度调整。注：季度数据是第三季度财务数据,可以是列表,可空
    :param ifMerged: 是否合并，1-合并报表，2-母公司报表,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getLCIncomeStatementJY.csv?ispandas=1&') 
    requestString.append("partyID=")
    if hasattr(partyID,'__iter__') and not isinstance(partyID, str):
        if len(partyID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = partyID
            requestString.append(None)
        else:
            requestString.append(','.join(partyID))
    else:
        requestString.append(partyID)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&reportType=")
    if hasattr(reportType,'__iter__') and not isinstance(reportType, str):
        if len(reportType) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = reportType
            requestString.append(None)
        else:
            requestString.append(','.join(reportType))
    else:
        requestString.append(reportType)
    try:
        infoPublDateBegin = infoPublDateBegin.strftime('%Y%m%d')
    except:
        infoPublDateBegin = infoPublDateBegin.replace('-', '')
    requestString.append("&infoPublDateBegin=%s"%(infoPublDateBegin))
    try:
        infoPublDateEnd = infoPublDateEnd.strftime('%Y%m%d')
    except:
        infoPublDateEnd = infoPublDateEnd.replace('-', '')
    requestString.append("&infoPublDateEnd=%s"%(infoPublDateEnd))
    requestString.append("&ifAdjusted=")
    if hasattr(ifAdjusted,'__iter__') and not isinstance(ifAdjusted, str):
        if len(ifAdjusted) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ifAdjusted
            requestString.append(None)
        else:
            requestString.append(','.join(ifAdjusted))
    else:
        requestString.append(ifAdjusted)
    requestString.append("&ifMerged=")
    if hasattr(ifMerged,'__iter__') and not isinstance(ifMerged, str):
        if len(ifMerged) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ifMerged
            requestString.append(None)
        else:
            requestString.append(','.join(ifMerged))
    else:
        requestString.append(ifMerged)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1636)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1636)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'partyID', u'partyFullName', u'endDate', u'infoPublDate', u'ifAdjusted', u'ifMerged', u'salesRevenue', u'salesDiscountsAllowances', u'netSalesRevenue', u'salesCost', u'salesTaxAndSurcharges', u'grossProfit', u'otherBizProfit', u'inventoryDevalLoss', u'operatingExpense', u'administrationExpense', u'financialExpense', u'otherExpenses', u'operatingProfit', u'investIncome', u'futuresInvestIncome', u'subsidyIncome', u'nonoperatingIncome', u'nonoperatingExpense', u'priorYearProfitAdjust', u'totalProfit', u'incomeTax', u'financeRefund', u'minorityProfit', u'unrecognisedInvestLoss', u'mergeAndAcquisitionProfit', u'netProfit', u'retainedProfitFromBegin', u'RPforReduceRegCapital', u'profitForSponsor', u'profitSwitchFromSurplus', u'conversionMargin', u'distributableProfit', u'statutorySurplusReserve', u'statutoryCommonWealFund', u'staffBonusAndWelfareFund', u'foreignCapitalReserve', u'reserveFundProvision', u'developProvision', u'profitRefundInvest', u'profitFromMerging', u'profitforShareholder', u'preferredStockDividend', u'discretionarySurplusFund', u'commonDividendPayable', u'commonDiviChangeToCapital', u'accumulatedLossOffset', u'retainedProfit', u'departmentSettlement', u'disasterLoss', u'accountingPolicyChange', u'otherSpecialItems', u'changePublDate']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'partyFullName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def LCBalanceSheetJYGet(partyID = "", beginDate = "", endDate = "", reportType = "", infoPublDateBegin = "", infoPublDateEnd = "", ifAdjusted = "", ifMerged = "", field = "", pandas = "1"):
    """
    获取非金融类资产负债表(旧会计准则)，非金融公司招股前三年及上市后历年季报、中报、年报的资产负债报表，包括当年的合并、母公司报表，以及当年对上年调整的合并、母公司报表；各财务科目单位均为人民币元。
    
    :param partyID: 机构内部ID，通过机构名称在DataAPI.PartyIDGet获取，可多值输入，如'2','603',可以是列表,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param beginDate: 会计期末，输入开始日期,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param endDate: 会计期末，输入截止日期,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param reportType: 报告类型。Q1-一季度，S1-半年度，Q3-三季度，A-年度。对应DataAPI.SysCodeGet.codeTypeID=70001。,可以是列表,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param infoPublDateBegin: 信息发布日期，输入开始日期,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param infoPublDateEnd: 信息发布日期，输入截止日期,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param ifAdjusted: 是否调整，1-调整，2-未调整，6-季末调整，7-二季末调整，8-三季末调整,可以是列表,可空
    :param ifMerged: 是否合并，1-合并报表，2-母公司报表,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getLCBalanceSheetJY.csv?ispandas=1&') 
    requestString.append("partyID=")
    if hasattr(partyID,'__iter__') and not isinstance(partyID, str):
        if len(partyID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = partyID
            requestString.append(None)
        else:
            requestString.append(','.join(partyID))
    else:
        requestString.append(partyID)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&reportType=")
    if hasattr(reportType,'__iter__') and not isinstance(reportType, str):
        if len(reportType) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = reportType
            requestString.append(None)
        else:
            requestString.append(','.join(reportType))
    else:
        requestString.append(reportType)
    try:
        infoPublDateBegin = infoPublDateBegin.strftime('%Y%m%d')
    except:
        infoPublDateBegin = infoPublDateBegin.replace('-', '')
    requestString.append("&infoPublDateBegin=%s"%(infoPublDateBegin))
    try:
        infoPublDateEnd = infoPublDateEnd.strftime('%Y%m%d')
    except:
        infoPublDateEnd = infoPublDateEnd.replace('-', '')
    requestString.append("&infoPublDateEnd=%s"%(infoPublDateEnd))
    requestString.append("&ifAdjusted=")
    if hasattr(ifAdjusted,'__iter__') and not isinstance(ifAdjusted, str):
        if len(ifAdjusted) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ifAdjusted
            requestString.append(None)
        else:
            requestString.append(','.join(ifAdjusted))
    else:
        requestString.append(ifAdjusted)
    requestString.append("&ifMerged=")
    if hasattr(ifMerged,'__iter__') and not isinstance(ifMerged, str):
        if len(ifMerged) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ifMerged
            requestString.append(None)
        else:
            requestString.append(','.join(ifMerged))
    else:
        requestString.append(ifMerged)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1637)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1637)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'partyID', u'partyFullName', u'endDate', u'infoPublDate', u'ifAdjusted', u'ifMerged', u'cashEquivalents', u'shortTermInvest', u'shortTermInvestDevalProvi', u'shorttermInvestNetVal', u'notesReceivable', u'dividendReceivable', u'interestReceivable', u'accountsReceivables', u'netAccountsReceivables', u'otherReceivables', u'netOtherReceivables', u'badDebtProvision', u'netReceivables', u'advancePayment', u'subsidyReceivable', u'futureMargin', u'seatFeeReceivable', u'inventory', u'constructionProject', u'inventoryDevalProvision', u'netInventory', u'interdepartmentalAccounts', u'deferredExpense', u'netLossOfCurrentAssetToDeal', u'longtermInvestBondsDueIn1Year', u'otherCurrentAsset', u'totalCurrentAsset', u'longtermEquityInvest', u'longtermCreditInvest', u'otherLongtermInvest', u'totalLongtermInvest', u'longtermInvestDevalProvi', u'longtermInvestNetVal', u'mergingPriceDiffirence', u'equityInvestDiff', u'fixedAssetsCost', u'accumulatedDepreciation', u'netFixedAssetsVal', u'fixedAssetsDevalProvi', u'netFixedAssetsMarketVal', u'constructionMaterials', u'construInProcess', u'construInProcessDevalProvi', u'fixedAssetsLiquidation', u'netLossOfFixedAssetToDeal', u'totalFixedAssets', u'intangibleAssets', u'deferredAssets', u'preoperateEexpense', u'longDeferredExpense', u'otherLongtermAssets', u'netTempFacility', u'totalIntangiAndOtherAssets', u'deferredTaxDebit', u'totalAsset', u'shortTermLoan', u'notesPayable', u'accountsPayable', u'advanceReceipts', u'shortTermBondPayable', u'consignedGoodAccounts', u'wagesPayable', u'welfarePayable', u'dividendsPayable', u'taxsPayable', u'othersPayable', u'otherAccountsPayable', u'accruedExpense', u'estimateLiability', u'longtermLiabilityDueIn1Year', u'otherCurrentLiability', u'totalCurrentLiability', u'longtermLoan', u'bondsPayable', u'longtermAccountPayable', u'specificAccountPayable', u'houseTurnoverFund', u'otherLongtermLiability', u'totalLongtermLiability', u'deferredTaxCredit', u'totalLiability', u'minorityInterests', u'othersLiabilityAndEquity', u'shareCapital', u'retiredCapital', u'netShareCapital', u'capitalReserveFund', u'addedCurrentCapital', u'surplusReserveFund', u'commonwealFund', u'unrecognisedInvestLoss', u'retainedProfit', u'foreignCurrencyReportConvDiff', u'capitalExchangeDiffAdjust', u'totalShareholderEquity', u'totalLiabilityAndEquity', u'changePublDate']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'partyFullName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def LCCSIIndusPEJYGet(tradingDate, statType, statRatio, secuCode = "", CSRCIndusCode = "", CSIIndusCode = "", field = "", pandas = "1"):
    """
    获取中证指数有限公司披露的沪深A股、证监会行业、中证行业的静态市盈率、动态市盈率、市净率和股息率数据。
    
    :param tradingDate: 交易日期，输入格式"YYYYMMDD"
    :param statType: 统计类型：1-个股统计，2-行业统计_证监会行业分类， 3-行业统计_中证行业分类,可以是列表
    :param statRatio: 统计指标：1-静态市盈率，2-动态市盈率，3-市净率， 4-股息率,可以是列表
    :param secuCode: 证券/行业代码，1-若statType=1，则输入证券代码，如需搜索"平安银行"相关数据,输入"000001"，2-若StatType=2，通过DataAPI.JY.CTSystemConstJYGet(LB='1755')获取行业代码，3-若StatType=3，通过DataAPI.JY.CTSystemConstJYGet(LB='1478')获取行业代码,可以是列表,可空
    :param CSRCIndusCode: 个股所属证监会行业分类代码，通过DataAPI.JY.CTSystemConstJYGet(LB='1755')获取行业代码,可以是列表,可空
    :param CSIIndusCode: 个股所属中证行业分类代码，通过DataAPI.JY.CTSystemConstJYGet(LB='1478')获取行业代码,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getLCCSIIndusPEJY.csv?ispandas=1&') 
    try:
        tradingDate = tradingDate.strftime('%Y%m%d')
    except:
        tradingDate = tradingDate.replace('-', '')
    requestString.append("tradingDate=%s"%(tradingDate))
    requestString.append("&statType=")
    if hasattr(statType,'__iter__') and not isinstance(statType, str):
        if len(statType) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = statType
            requestString.append(None)
        else:
            requestString.append(','.join(statType))
    else:
        requestString.append(statType)
    requestString.append("&statRatio=")
    if hasattr(statRatio,'__iter__') and not isinstance(statRatio, str):
        if len(statRatio) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = statRatio
            requestString.append(None)
        else:
            requestString.append(','.join(statRatio))
    else:
        requestString.append(statRatio)
    requestString.append("&secuCode=")
    if hasattr(secuCode,'__iter__') and not isinstance(secuCode, str):
        if len(secuCode) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secuCode
            requestString.append(None)
        else:
            requestString.append(','.join(secuCode))
    else:
        requestString.append(secuCode)
    requestString.append("&CSRCIndusCode=")
    if hasattr(CSRCIndusCode,'__iter__') and not isinstance(CSRCIndusCode, str):
        if len(CSRCIndusCode) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = CSRCIndusCode
            requestString.append(None)
        else:
            requestString.append(','.join(CSRCIndusCode))
    else:
        requestString.append(CSRCIndusCode)
    requestString.append("&CSIIndusCode=")
    if hasattr(CSIIndusCode,'__iter__') and not isinstance(CSIIndusCode, str):
        if len(CSIIndusCode) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = CSIIndusCode
            requestString.append(None)
        else:
            requestString.append(','.join(CSIIndusCode))
    else:
        requestString.append(CSIIndusCode)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1739)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1739)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'infoPublDate', u'tradingDate', u'statType', u'statRatio', u'secuCode', u'secuName', u'CSRCIndusCode', u'CSIIndusCode', u'RD', u'RM', u'R3M', u'R6M', u'R12M', u'numOfComp', u'typeEx', u'numOfCompEx', u'infoPublInst']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secuCode': 'str','secuName': 'str','CSRCIndusCode': 'str','CSIIndusCode': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def LCDerivativeDataJYGet(partyID = "", beginDate = "", endDate = "", reportType = "", infoPublDateBegin = "", infoPublDateEnd = "", field = "", pandas = "1"):
    """
    获取公司衍生报表数据_新会计准则，由上市公司的主要会计科目衍生出来的数据，单位均为人民币元；若某个报告期的数据有多次调整，则该表展示最新合并调整数据；若某报告期暂未披露调整后数据，则为合并调整前数据；TTM指标为滚动计算的指标，即最近四个季度的单季数据之和。
    
    :param partyID: 机构内部ID，通过机构名称在DataAPI.PartyIDGet获取，可多值输入，如'2','603',可以是列表,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param beginDate: 会计期末，输入开始日期,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param endDate: 会计期末，输入截止日期,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param reportType: 报告类型。Q1-一季度，S1-半年度，Q3-三季度，A-年度。对应DataAPI.SysCodeGet.codeTypeID=70001。,可以是列表,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param infoPublDateBegin: 信息发布日期，输入开始日期,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param infoPublDateEnd: 信息发布日期，输入截止日期,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getLCDerivativeDataJY.csv?ispandas=1&') 
    requestString.append("partyID=")
    if hasattr(partyID,'__iter__') and not isinstance(partyID, str):
        if len(partyID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = partyID
            requestString.append(None)
        else:
            requestString.append(','.join(partyID))
    else:
        requestString.append(partyID)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&reportType=")
    if hasattr(reportType,'__iter__') and not isinstance(reportType, str):
        if len(reportType) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = reportType
            requestString.append(None)
        else:
            requestString.append(','.join(reportType))
    else:
        requestString.append(reportType)
    try:
        infoPublDateBegin = infoPublDateBegin.strftime('%Y%m%d')
    except:
        infoPublDateBegin = infoPublDateBegin.replace('-', '')
    requestString.append("&infoPublDateBegin=%s"%(infoPublDateBegin))
    try:
        infoPublDateEnd = infoPublDateEnd.strftime('%Y%m%d')
    except:
        infoPublDateEnd = infoPublDateEnd.replace('-', '')
    requestString.append("&infoPublDateEnd=%s"%(infoPublDateEnd))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1740)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1740)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'partyID', u'partyFullName', u'endDate', u'infoPublDate', u'infoSource', u'bulletinType', u'accountingStandards', u'interestFreeCLiabilities', u'interestFreeNonCL', u'interestBearDebt', u'netDebt', u'totalPaidinCapital', u'workingCaital', u'netWorkingCaital', u'netTangibleAssets', u'retainedEarnings', u'nonRecurringProfitLoss', u'NPDeductNonRecurringPL', u'grossProfit', u'netIncomeFromOperating', u'netIncomeFromValueChange', u'EBIT', u'EBITDA', u'totalOperatingRevenueTTM', u'totalOperatingCostTTM', u'operatingRevenueTTM', u'operatingCostTTM', u'operatingPayoutTTM', u'grossProfitTTM', u'operatingExpenseTTM', u'administrationExpenseTTM', u'financialExpenseTTM', u'assetImpairmentLossTTM', u'NIFromOperatingTTM', u'NIFromValueChangeTTM', u'operatingProfitTTM', u'nonoperatingNetIncomeTTM', u'EBITTTM', u'totalProfitTTM', u'netProfitTTM', u'NPParentCompanyOwnersTTM', u'FCFF', u'FCFE', u'currentAccruedDA', u'saleServiceRenderCashTTM', u'netOperateCashFlowTTM', u'netInvestCashFlowTTM', u'netFinanceCashFlowTTM', u'netCashFlowTTM']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'partyFullName': 'str','infoSource': 'str','bulletinType': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def LCEmbeddedValueJYGet(partyID = "", beginDate = "", endDate = "", reportType = "", infoPublDateBegin = "", infoPublDateEnd = "", field = "", pandas = "1"):
    """
    获取保险公司内含价值表，反映保险公司在年报中披露的内含价值表数据；仅收录保险公司在报告期末未调整的合并报表；由于披露精度的问题，数据校验时，可能在百万位上有小额差异；该表中各科目的单位均为人民币元。
    
    :param partyID: 机构内部ID，通过机构名称在DataAPI.PartyIDGet获取，可多值输入，如'2','603',可以是列表,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param beginDate: 会计期末，输入开始日期,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param endDate: 会计期末，输入截止日期,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param reportType: 报告类型。Q1-一季度，S1-半年度，Q3-三季度，A-年度。对应DataAPI.SysCodeGet.codeTypeID=70001。,可以是列表,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param infoPublDateBegin: 信息发布日期，输入开始日期,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param infoPublDateEnd: 信息发布日期，输入截止日期,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getLCEmbeddedValueJY.csv?ispandas=1&') 
    requestString.append("partyID=")
    if hasattr(partyID,'__iter__') and not isinstance(partyID, str):
        if len(partyID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = partyID
            requestString.append(None)
        else:
            requestString.append(','.join(partyID))
    else:
        requestString.append(partyID)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&reportType=")
    if hasattr(reportType,'__iter__') and not isinstance(reportType, str):
        if len(reportType) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = reportType
            requestString.append(None)
        else:
            requestString.append(','.join(reportType))
    else:
        requestString.append(reportType)
    try:
        infoPublDateBegin = infoPublDateBegin.strftime('%Y%m%d')
    except:
        infoPublDateBegin = infoPublDateBegin.replace('-', '')
    requestString.append("&infoPublDateBegin=%s"%(infoPublDateBegin))
    try:
        infoPublDateEnd = infoPublDateEnd.strftime('%Y%m%d')
    except:
        infoPublDateEnd = infoPublDateEnd.replace('-', '')
    requestString.append("&infoPublDateEnd=%s"%(infoPublDateEnd))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1741)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1741)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'partyID', u'partyFullName', u'endDate', u'infoPublDate', u'infoSource', u'bulletinType', u'ANAVGroup', u'ANAVLifeInsurance', u'ANAVGroupInLife', u'ANAVGroupInGeneral', u'primeVIFB', u'latterVIFB', u'VIFB', u'solvencyMarginVIFB', u'VIFBExcludeCost', u'ratioGroupInLife', u'VIFBGroupInLife', u'EVGroup', u'EVLifeInsurance', u'EVGroupInLife', u'EVGroupInGeneral', u'FNBV', u'solvencyMarginFNBV', u'FNBVExcludeCost', u'FNBVGroupInLife', u'riskDiscountRateEV', u'riskDiscountRateFNBV', u'remarkOfRDR', u'returnOnInvestment', u'originYearROI', u'changingPattern', u'steadyReturnOnInvestment', u'originYearSROI', u'remarkOfROI', u'incomeTaxRate', u'exemptIncomeTaxRate', u'remarkOfITR']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'partyFullName': 'str','infoSource': 'str','remarkOfRDR': 'str','changingPattern': 'str','remarkOfROI': 'str','remarkOfITR': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def LCEmbeddedValueChangeJYGet(partyID = "", beginDate = "", endDate = "", reportType = "", infoPublDateBegin = "", infoPublDateEnd = "", field = "", pandas = "1"):
    """
    获取保险公司内含价值变动表，反映保险公司在年报中披露的内含价值变动数据；仅收录保险公司在报告期末未调整的合并报表；该表中各科目的单位均为人民币元；07年之前，保险公司未分别披露寿险业务和非寿险业务的内含价值变化，因此，07年之前，寿险业务内含价值中，包含了非寿险业务的部分；由于披露精度的问题，数据校验时，可能在百万位上有小额差异。
    
    :param partyID: 机构内部ID，通过机构名称在DataAPI.PartyIDGet获取，可多值输入，如'2','603',可以是列表,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param beginDate: 会计期末，输入开始日期,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param endDate: 会计期末，输入截止日期,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param reportType: 报告类型。Q1-一季度，S1-半年度，Q3-三季度，A-年度。对应DataAPI.SysCodeGet.codeTypeID=70001。,可以是列表,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param infoPublDateBegin: 信息发布日期，输入开始日期,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param infoPublDateEnd: 信息发布日期，输入截止日期,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getLCEmbeddedValueChangeJY.csv?ispandas=1&') 
    requestString.append("partyID=")
    if hasattr(partyID,'__iter__') and not isinstance(partyID, str):
        if len(partyID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = partyID
            requestString.append(None)
        else:
            requestString.append(','.join(partyID))
    else:
        requestString.append(partyID)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&reportType=")
    if hasattr(reportType,'__iter__') and not isinstance(reportType, str):
        if len(reportType) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = reportType
            requestString.append(None)
        else:
            requestString.append(','.join(reportType))
    else:
        requestString.append(reportType)
    try:
        infoPublDateBegin = infoPublDateBegin.strftime('%Y%m%d')
    except:
        infoPublDateBegin = infoPublDateBegin.replace('-', '')
    requestString.append("&infoPublDateBegin=%s"%(infoPublDateBegin))
    try:
        infoPublDateEnd = infoPublDateEnd.strftime('%Y%m%d')
    except:
        infoPublDateEnd = infoPublDateEnd.replace('-', '')
    requestString.append("&infoPublDateEnd=%s"%(infoPublDateEnd))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1742)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1742)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'partyID', u'partyFullName', u'endDate', u'infoPublDate', u'infoSource', u'bulletinType', u'beginEVLifeInsurance', u'expectedReturn', u'periodNewBusinessValue', u'operExperienceVariances', u'dividendVariances', u'investReturnVariances', u'riskDiscountRateChange', u'evaluationBaseChange', u'evaluationMethodChange', u'adjustedMarketValueLife', u'otherVariances', u'EVBeforeChange', u'capitalInjection', u'shareholderDividend', u'endEVLifeInsurance', u'beginEVGeneralInsurance', u'NAVBeforeChange', u'capitalInvestment', u'adjustedMarketValueGeneral', u'endEVGeneralInsurance', u'adjustedMinorityInterests', u'EndEVGroup', u'EndEVPS']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'partyFullName': 'str','infoSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def LCEmbeddedValueIndexJYGet(partyID = "", beginDate = "", endDate = "", reportType = "", infoPublDateBegin = "", infoPublDateEnd = "", field = "", pandas = "1"):
    """
    获取保险公司内含价值分析指标，根据报告期公布的数据进行内含价值的分析与预测，以反映保险公司内含价值相关指标的纵比分析、同比分析；仅收录保险公司在报告期末未调整的合并报表；该表中各科目的单位均为人民币元。
    
    :param partyID: 机构内部ID，通过机构名称在DataAPI.PartyIDGet获取，可多值输入，如'2','603',可以是列表,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param beginDate: 会计期末，输入开始日期,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param endDate: 会计期末，输入截止日期,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param reportType: 报告类型。Q1-一季度，S1-半年度，Q3-三季度，A-年度。对应DataAPI.SysCodeGet.codeTypeID=70001。,可以是列表,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param infoPublDateBegin: 信息发布日期，输入开始日期,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param infoPublDateEnd: 信息发布日期，输入截止日期,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getLCEmbeddedValueIndexJY.csv?ispandas=1&') 
    requestString.append("partyID=")
    if hasattr(partyID,'__iter__') and not isinstance(partyID, str):
        if len(partyID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = partyID
            requestString.append(None)
        else:
            requestString.append(','.join(partyID))
    else:
        requestString.append(partyID)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&reportType=")
    if hasattr(reportType,'__iter__') and not isinstance(reportType, str):
        if len(reportType) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = reportType
            requestString.append(None)
        else:
            requestString.append(','.join(reportType))
    else:
        requestString.append(reportType)
    try:
        infoPublDateBegin = infoPublDateBegin.strftime('%Y%m%d')
    except:
        infoPublDateBegin = infoPublDateBegin.replace('-', '')
    requestString.append("&infoPublDateBegin=%s"%(infoPublDateBegin))
    try:
        infoPublDateEnd = infoPublDateEnd.strftime('%Y%m%d')
    except:
        infoPublDateEnd = infoPublDateEnd.replace('-', '')
    requestString.append("&infoPublDateEnd=%s"%(infoPublDateEnd))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1743)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1743)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'partyID', u'partyFullName', u'endDate', u'infoPublDate', u'infoSource', u'bulletinType', u'embeddedValuePS', u'embeddedValuePSLife', u'embeddedValuePSGeneral', u'newBusinessValuePS', u'ANAVPS', u'VIFBPS', u'embeddedValueGR', u'EVOfInforceBusinessGR', u'newBusinessValueGR', u'lifeVIFBGR', u'lifeEVRatio', u'generalEVRatio', u'ANAVRatio', u'VIFBRatio']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'partyFullName': 'str','infoSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def LCFSDerivedDataJYGet(partyID = "", beginDate = "", endDate = "", reportType = "", infoPublDateBegin = "", infoPublDateEnd = "", ifAdjusted = "", field = "", pandas = "1"):
    """
    获取公司衍生报表数据_新会计准则（新），由上市公司的主要会计科目（合并报表）衍生出来的数据，单位均为人民币元，起始年度为2008年；若三大财务报表中任意报表在某报告期的数据经历调整/修订，则该表相关字段展示每个历史调整数据；未经历调整/修订的报表相关字段则沿用未调整数据；TTM指标为滚动计算的指标，即最近四个季度的单季数据之和
    
    :param partyID: 机构内部ID，通过机构名称在DataAPI.PartyIDGet获取，可多值输入，如'2','603',可以是列表,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param beginDate: 会计期末，输入开始日期,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param endDate: 会计期末，输入截止日期,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param reportType: 报告类型。Q1-一季度，S1-半年度，Q3-三季度，A-年度。对应DataAPI.SysCodeGet.codeTypeID=70001。,可以是列表,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param infoPublDateBegin: 信息发布日期，输入开始日期,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param infoPublDateEnd: 信息发布日期，输入截止日期,partyID、beginDate、endDate、reportType、infoPublDateBegin、infoPublDateEnd至少选择一个
    :param ifAdjusted: 是否调整 ：1-调整；2-未调整；6-一季末调整（年度资产负债表）；7-半年报调整（年度资产负债表）；8-三季末调整（年度资产负债表）,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getLCFSDerivedDataJY.csv?ispandas=1&') 
    requestString.append("partyID=")
    if hasattr(partyID,'__iter__') and not isinstance(partyID, str):
        if len(partyID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = partyID
            requestString.append(None)
        else:
            requestString.append(','.join(partyID))
    else:
        requestString.append(partyID)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&reportType=")
    if hasattr(reportType,'__iter__') and not isinstance(reportType, str):
        if len(reportType) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = reportType
            requestString.append(None)
        else:
            requestString.append(','.join(reportType))
    else:
        requestString.append(reportType)
    try:
        infoPublDateBegin = infoPublDateBegin.strftime('%Y%m%d')
    except:
        infoPublDateBegin = infoPublDateBegin.replace('-', '')
    requestString.append("&infoPublDateBegin=%s"%(infoPublDateBegin))
    try:
        infoPublDateEnd = infoPublDateEnd.strftime('%Y%m%d')
    except:
        infoPublDateEnd = infoPublDateEnd.replace('-', '')
    requestString.append("&infoPublDateEnd=%s"%(infoPublDateEnd))
    requestString.append("&ifAdjusted=")
    if hasattr(ifAdjusted,'__iter__') and not isinstance(ifAdjusted, str):
        if len(ifAdjusted) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ifAdjusted
            requestString.append(None)
        else:
            requestString.append(','.join(ifAdjusted))
    else:
        requestString.append(ifAdjusted)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1744)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1744)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'partyID', u'partyFullName', u'endDate', u'infoPublDate', u'infoSource', u'bulletinType', u'ifAdjusted', u'accountingStandards', u'interestFreeCLiabilities', u'interestFreeNonCL', u'interestBearDebt', u'netDebt', u'totalPaidinCapital', u'workingCaital', u'netWorkingCaital', u'netTangibleAssets', u'retainedEarnings', u'nonRecurringProfitLoss', u'NPDeductNonRecurringPL', u'grossProfit', u'netIncomeFromOperating', u'netIncomeFromValueChange', u'EBIT', u'EBITDA', u'totalOperatingRevenueTTM', u'totalOperatingCostTTM', u'operatingRevenueTTM', u'operatingCostTTM', u'operatingPayoutTTM', u'grossProfitTTM', u'operatingExpenseTTM', u'administrationExpenseTTM', u'financialExpenseTTM', u'assetImpairmentLossTTM', u'NIFromOperatingTTM', u'NIFromValueChangeTTM', u'operatingProfitTTM', u'nonoperatingNetIncomeTTM', u'EBITTTM', u'totalProfitTTM', u'netProfitTTM', u'NPParentCompanyOwnersTTM', u'FCFF', u'FCFE', u'currentAccruedDA', u'saleServiceRenderCashTTM', u'netOperateCashFlowTTM', u'netInvestCashFlowTTM', u'netFinanceCashFlowTTM', u'netCashFlowTTM']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'partyFullName': 'str','infoSource': 'str','bulletinType': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def LCBalanceSheetAllJYGet(beginDate = "", endDate = "", beginTime = "", endTime = "", field = "", pandas = "1"):
    """
    1.反映上市公司依据2007年新会计准则在年报、中报、季报中披露的资产负债表数据； 并依据新旧会计准则的科目对应关系，收录主要科目的历史对应数据。 2.收录同一公司在报告期末的四种财务报告，即未调整的合并报表、未调整的母公司 报表、调整后的合并报表以及调整后的母公司报表。 3.若某个报告期的数据有多次调整，则该表展示历次调整数据。 4.该表中各财务科目的单位均为人民币元。 5.带“##”的特殊项目为单个公司披露的非标准化的科目，对应的“特殊字段说明” 字段将对其作出说明；带“##”的调整项目是为了让报表的各个小项借贷平衡而设 置的，便于客户对报表的遗漏和差错进行判断。 6.备注中的红色数字对应企业性质标识，表示该字段适用的企业类别。 比如，13-仅适用于银行类上市公司； 31-仅适用于券商类上市公司； 35-仅适用于保险类上市公司； 13,33-仅适用于银行及信托类上市公司。
    
    :param beginDate: 会计期间截止日期，开始时间，输入格式“YYYYMMDD”,beginDate、endDate、beginTime、endTime至少选择一个
    :param endDate: 会计期间截止日期，结束时间，输入格式“YYYYMMDD”,beginDate、endDate、beginTime、endTime至少选择一个
    :param beginTime: 输入数据更新时间的查询开始时间，输入格式YYYY-MM-DDTHH:MI:SS，如2016-01-01T01:00:00,beginDate、endDate、beginTime、endTime至少选择一个
    :param endTime: 输入数据更新时间的查询截至时间，输入格式YYYY-MM-DDTHH:MI:SS，如2016-01-01T01:00:00,beginDate、endDate、beginTime、endTime至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getLCBalanceSheetAllJY.csv?ispandas=1&') 
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    if not isinstance(beginTime, str) and not isinstance(beginTime, unicode):
        beginTime = str(beginTime)

    requestString.append("&beginTime=%s"%(beginTime))
    if not isinstance(endTime, str) and not isinstance(endTime, unicode):
        endTime = str(endTime)

    requestString.append("&endTime=%s"%(endTime))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1805)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1805)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'ID', u'infoPublDate', u'infoSource', u'bulletinType', u'companyCode', u'endDate', u'ifAdjusted', u'ifMerged', u'accountingStandards', u'enterpriseType', u'ifComplete', u'cashEquivalents', u'clientDeposit', u'tradingAssets', u'billReceivable', u'dividendReceivable', u'interestReceivable', u'accountReceivable', u'otherReceivable', u'advancePayment', u'inventories', u'bearerBiologicalAssets', u'deferredExpense', u'holdAndFSAssets', u'nonCurrentAssetIn1Year', u'otherCurrentAssets', u'cAExceptionalItems', u'cAAdjustmentItems', u'totalCurrentAssets', u'holdForSaleAssets', u'holdToMaturityInvestments', u'investmentProperty', u'longtermEquityInvest', u'longtermReceivableAccount', u'fixedAssets', u'constructionMaterials', u'construInProcess', u'fixedAssetsLiquidation', u'biologicalAssets', u'oilGasAssets', u'intangibleAssets', u'seatCosts', u'developmentExpenditure', u'goodWill', u'longDeferredExpense', u'deferredTaxAssets', u'otherNonCurrentAssets', u'nCAExceptionalItems', u'nCAAdjustmentItems', u'totalNonCurrentAssets', u'loanAndAccountReceivables', u'settlementProvi', u'clientProvi', u'depositInInterbank', u'rMetal', u'lendCapital', u'derivativeAssets', u'boughtSellbackAssets', u'loanAndAdvance', u'insuranceReceivables', u'receivableSubrogationFee', u'reinsuranceReceivables', u'receivableUnearnedR', u'receivableClaimsR', u'receivableLifeR', u'receivableLTHealthR', u'insurerImpawnLoan', u'fixedDeposit', u'refundableDeposit', u'refundableCapitalDeposit', u'independenceAccountAssets', u'otherAssets', u'aExceptionalItems', u'aAdjustmentItems', u'totalAssets', u'shortTermLoan', u'impawnedLoan', u'tradingLiability', u'notesPayable', u'accountsPayable', u'sTBondsPayable', u'advanceReceipts', u'salariesPayable', u'dividendPayable', u'taxsPayable', u'interestPayable', u'otherPayable', u'accruedExpense', u'deferredProceeds', u'holdAndFSLi', u'nonCurrentLiabilityIn1Year', u'otherCurrentLiability', u'cLExceptionalItems', u'cLAdjustmentItems', u'totalCurrentLiability', u'longtermLoan', u'bondsPayable', u'lPreferStock', u'lPerpetualDebt', u'longtermAccountPayable', u'longSalariesPay', u'specificAccountPayable', u'estimateLiability', u'deferredTaxLiability', u'longDeferIncome', u'otherNonCurrentLiability', u'nCLExceptionalItems', u'nCLAdjustmentItems', u'totalNonCurrentLiability', u'borrowingFromCentralBank', u'depositOfInterbank', u'borrowingCapital', u'derivativeLiability', u'soldBuybackSecuProceeds', u'deposit', u'proxySecuProceeds', u'subIssueSecuProceeds', u'depositsReceived', u'advanceInsurance', u'commissionPayable', u'reinsurancePayables', u'compensationPayable', u'policyDividendPayable', u'insurerDepositInvestment', u'unearnedPremiumReserve', u'outstandingClaimReserve', u'lifeInsuranceReserve', u'lTHealthInsuranceLR', u'independenceLiability', u'otherLiability', u'lExceptionalItems', u'lAdjustmentItems', u'totalLiability', u'paidInCapital', u'otherEquityinstruments', u'ePreferStock', u'ePerpetualDebt', u'capitalReserveFund', u'surplusReserveFund', u'retainedProfit', u'treasuryStock', u'otherCompositeIncome', u'ordinaryRiskReserveFund', u'foreignCurrencyReportConvDiff', u'uncertainedInvestmentLoss', u'otherReserves', u'specificReserves', u'sEExceptionalItems', u'sEAdjustmentItems', u'sEWithoutMI', u'minorityInterests', u'otherItemsEffectingSE', u'totalShareholderEquity', u'lEExceptionalItems', u'lEAdjustmentItems', u'totalLiabilityAndEquity', u'specialFieldRemark', u'updateTime', u'JSID']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'infoSource': 'str','specialFieldRemark': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def LCCashFlowStatementAllJYGet(beginDate = "", endDate = "", beginTime = "", endTime = "", field = "", pandas = "1"):
    """
    1. 反映上市公司依据2007年新会计准则在年报、中报、季报中披露的现金流量表数据； 并依据新旧会计准则的科目对应 关系，收录了主要科目的历史对应数据。 2. 收录同一公司在报告期末的四种财务报告，即未调整的合并报表、未调整的母公司 报表、调整后的合并报表以及调整后的母公司报表。 3. 若某个报告期的数据有多次调整，则该表展示历次调整数据。 4. 该表中各财务科目的单位均为人民币元。 5. 带“##”的特殊项目为单个公司披露的非标准化的科目，对应的“特殊字段说明” 字段将对其作出说明；带“##”的调整项目是为了让报表的各个小项借贷平衡而设 置的，便于客户对报表的遗漏和差错进行判断。 6. 备注中的红色数字对应企业性质标识，表示该字段适用的企业类别。 比如，13-仅适用于银行类上市公司； 31-仅适用于券商类上市公司； 35-仅适用于保险类上市公司； 13,31-仅适用于银行及券商类上市公司。 企业类别为33的信托类上市公司参照银行类公司的披露方式
    
    :param beginDate: 会计期间截止日期，开始时间，输入格式“YYYYMMDD”,beginDate、endDate、beginTime、endTime至少选择一个
    :param endDate: 会计期间截止日期，结束时间，输入格式“YYYYMMDD”,beginDate、endDate、beginTime、endTime至少选择一个
    :param beginTime: 输入数据更新时间的查询开始时间，输入格式YYYY-MM-DDTHH:MI:SS，如2016-01-01T01:00:00,beginDate、endDate、beginTime、endTime至少选择一个
    :param endTime: 输入数据更新时间的查询截至时间，输入格式YYYY-MM-DDTHH:MI:SS，如2016-01-01T01:00:00,beginDate、endDate、beginTime、endTime至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getLCCashFlowStatementAllJY.csv?ispandas=1&') 
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    if not isinstance(beginTime, str) and not isinstance(beginTime, unicode):
        beginTime = str(beginTime)

    requestString.append("&beginTime=%s"%(beginTime))
    if not isinstance(endTime, str) and not isinstance(endTime, unicode):
        endTime = str(endTime)

    requestString.append("&endTime=%s"%(endTime))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1806)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1806)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'ID', u'infoPublDate', u'infoSource', u'bulletinType', u'companyCode', u'endDate', u'ifAdjusted', u'ifMerged', u'accountingStandards', u'enterpriseType', u'ifComplete', u'goodsSaleServiceRenderCash', u'taxLevyRefund', u'netDepositIncrease', u'netBorrowingFromCentralBank', u'netBorrowingFromFinanceCo', u'drawBackLoansCanceled', u'interestAndCommissionCashIn', u'netDealTradingAssets', u'netBuyBack', u'netOriginalInsuranceCash', u'netReinsuranceCash', u'netInsurerDepositInvestment', u'otherCashInRelatedOperate', u'specialItemsOCIF', u'adjustmentItemsOCIF', u'subtotalOperateCashInflow', u'goodsServicesCashPaid', u'staffBehalfPaid', u'allTaxesPaid', u'netLoanAndAdvanceIncrease', u'netDepositInCBAndIB', u'netLendCapital', u'commissionCashPaid', u'originalCompensationPaid', u'netCashForReinsurance', u'policyDividendCashPaid', u'otherOperateCashPaid', u'specialItemsOCOF', u'adjustmentItemsOCOF', u'subtotalOperateCashOutflow', u'adjustmentItemsNOCF', u'netOperateCashFlow', u'investWithdrawalCash', u'investproceeds', u'fixIntanOtherAssetDispoCash', u'netCashDealSubCompany', u'otherCashFromInvestAct', u'specialItemsICIF', u'adjustmentItemsICIF', u'subtotalInvestCashInflow', u'fixIntanOtherAssetAcquiCash', u'investCashPaid', u'netCashFromSubCompany', u'impawnedLoanNetIncrease', u'otherCashToInvestAct', u'specialItemsICOF', u'adjustmentItemsICOF', u'subtotalInvestCashOutflow', u'adjustmentItemsNICF', u'netInvestCashFlow', u'cashFromInvest', u'cashFromMinoSInvestSub', u'cashFromBondsIssue', u'cashFromBorrowing', u'otherFinanceActCash', u'specialItemsFCIF', u'adjustmentItemsFCIF', u'subtotalFinanceCashInflow', u'borrowingRepayment', u'dividendInterestPayment', u'proceedsFromSubToMinoS', u'otherFinanceActPayment', u'specialItemsFCOF', u'adjustmentItemsFCOF', u'subtotalFinanceCashOutflow', u'adjustmentItemsNFCF', u'netFinanceCashFlow', u'exchanRateChangeEffect', u'otherItemsEffectingCE', u'adjustmentItemsCE', u'cashEquivalentIncrease', u'beginPeriodCash', u'otherItemsEffectingCEI', u'adjustmentItemsCEI', u'endPeriodCashEquivalent', u'netProfit', u'minorityProfit', u'assetsDepreciationReserves', u'fixedAssetDepreciation', u'intangibleAssetAmortization', u'deferredExpenseAmort', u'deferredExpenseDecreased', u'accruedExpenseAdded', u'fixIntanOtherAssetDispoLoss', u'fixedAssetScrapLoss', u'lossFromFairValueChanges', u'financialExpense', u'investLoss', u'deferedTaxAssetDecrease', u'deferedTaxLiabilityIncrease', u'inventoryDecrease', u'operateReceivableDecrease', u'operatePayableIncrease', u'others', u'specialItemsNOCF1', u'adjustmentItemsNOCF1', u'netOperateCashFlowNotes', u'contrastAdjutmentNOCF', u'debtToCaptical', u'cBsExpiringWithin1Y', u'fixedAssetsFinanceLeases', u'cashAtEndOfYear', u'cashAtBeginningOfYear', u'cashEquivalentsAtEndOfYear', u'cashEquivalentsAtBeginning', u'specialItemsC', u'adjustmentItemsC', u'netIncrInCashAndEquivalents', u'contrastAdjutmentNC', u'specialFieldRemark', u'updateTime', u'JSID']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'infoSource': 'str','specialFieldRemark': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def LCIncomeStatementAllJYGet(beginDate = "", endDate = "", beginTime = "", endTime = "", field = "", pandas = "1"):
    """
    1.反映上市公司依据2007年新会计准则在在年报、中报、季报中披露的利润表数据； 并依据新旧会计准则的科目对应关系，收录了主要科目的历史对应数据。 2.收录同一公司在报告期末的四种财务报告，即未调整的合并报表、未调整的母公司 报表、调整后的合并报表以及调整后的母公司报表。 3.若某个报告期的数据有多次调整，则该表展示历次调整数据。 4.该表中各财务科目的单位均为人民币元。 5.带“##”的特殊项目为单个公司披露的非标准化的科目，对应的“特殊字段说明” 字段将对其作出说明；带“##”的调整项目是为了让报表的各个小项借贷平衡而设 置的，便于客户对报表的遗漏和差错进行判断。 6.备注中的红色数字对应企业性质标识，表示该字段适用的企业类别。 比如，13-仅适用于银行类上市公司； 31-仅适用于券商类上市公司； 35-仅适用于保险类上市公司； 13,31-仅适用于银行及券商类上市公司。 企业性质为33的信托类上市公司，其披露方式参照银行类及券商类上市公司。
    
    :param beginDate: 会计期间截止日期，开始时间，输入格式“YYYYMMDD”,beginDate、endDate、beginTime、endTime至少选择一个
    :param endDate: 会计期间截止日期，结束时间，输入格式“YYYYMMDD”,beginDate、endDate、beginTime、endTime至少选择一个
    :param beginTime: 输入数据更新时间的查询开始时间，输入格式YYYY-MM-DDTHH:MI:SS，如2016-01-01T01:00:00,beginDate、endDate、beginTime、endTime至少选择一个
    :param endTime: 输入数据更新时间的查询截至时间，输入格式YYYY-MM-DDTHH:MI:SS，如2016-01-01T01:00:00,beginDate、endDate、beginTime、endTime至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/fundamental/getLCIncomeStatementAllJY.csv?ispandas=1&') 
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    if not isinstance(beginTime, str) and not isinstance(beginTime, unicode):
        beginTime = str(beginTime)

    requestString.append("&beginTime=%s"%(beginTime))
    if not isinstance(endTime, str) and not isinstance(endTime, unicode):
        endTime = str(endTime)

    requestString.append("&endTime=%s"%(endTime))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1807)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1807)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'ID', u'infoPublDate', u'infoSource', u'bulletinType', u'companyCode', u'endDate', u'ifAdjusted', u'ifMerged', u'accountingStandards', u'enterpriseType', u'ifComplete', u'totalOperatingRevenue', u'operatingRevenue', u'netInterestIncome', u'interestIncome', u'interestExpense', u'netCommissionIncome', u'commissionIncome', u'commissionExpense', u'netProxySecuIncome', u'netSubIssueSecuIncome', u'netTrustIncome', u'premiumsEarned', u'premiumsIncome', u'reinsuranceIncome', u'reinsurance', u'unearnedPremiumReserve', u'otherOperatingRevenue', u'specialItemsOR', u'adjustmentItemsOR', u'totalOperatingCost', u'operatingPayout', u'refundedPremiums', u'compensationExpense', u'amortizationExpense', u'premiumReserve', u'amortizationPremiumReserve', u'policyDividendPayout', u'reinsuranceCost', u'operatingAndAdminExpense', u'amortizationReinsuranceCost', u'insuranceCommissionExpense', u'otherOperatingCost', u'operatingCost', u'operatingTaxSurcharges', u'operatingExpense', u'administrationExpense', u'financialExpense', u'assetImpairmentLoss', u'specialItemsTOC', u'adjustmentItemsTOC', u'otherNetRevenue', u'fairValueChangeIncome', u'investIncome', u'investIncomeAssociates', u'exchangeIncome', u'otherItemsEffectingOP', u'adjustedItemsEffectingOP', u'operatingProfit', u'nonoperatingIncome', u'nonoperatingExpense', u'nonCurrentAssetssDealLoss', u'otherItemsEffectingTP', u'adjustedItemsEffectingTP', u'totalProfit', u'incomeTaxCost', u'uncertainedInvestmentLosses', u'otherItemsEffectingNP', u'adjustedItemsEffectingNP', u'netProfit', u'nPParentCompanyOwners', u'minorityProfit', u'otherItemsEffectingNPP', u'adjustedItemsEffectingNPP', u'otherCompositeIncome', u'oCIParentCompanyOwners', u'oCINotInIncomeStatement', u'oCIReMearsure', u'oCIEquityNotInIS', u'oCIInIncomeStatement', u'oCIEquityInIS', u'oCIFairValue', u'oCIToMaturityFA', u'oCICFLoss', u'oCIForeignCurrencyFSA', u'oCIOthers', u'oCIMinorityOwners', u'adjustedItemsEffectingCI', u'totalCompositeIncome', u'cIParentCompanyOwners', u'cIMinorityOwners', u'adjustedItemsEffectingPCI', u'basicEPS', u'dilutedEPS', u'specialFieldRemark', u'updateTime', u'JSID']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'infoSource': 'str','specialFieldRemark': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktGoldtdJYGet(ticker, startDate = "", endDate = "", field = "", pandas = "1"):
    """
    收录上海黄金交易所交易行情，包括证券代码,证券简称,证券英文简称,交易市场,交易日期,信息来源,开盘价,最高价,最低价,收盘价,涨跌,涨跌幅,加权价,成交量,成交金额，历史追溯至2002年，每日更新
    
    :param ticker: 输入查询Ag(T+D),Ag99.99,Ag999,Au(T+5),Au(T+N1),Au(T+N2),Au100g,Au50g,Au99.95,Au99.99,Au995,AuT+D,iAu100g,iAu99.5,iAu99.99,mAu(T+D),Pt99.95
    :param startDate: 起始日期，输入格式为yyyymmdd,可空
    :param endDate: 结束日期，输入格式为yyyymmdd,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/futuForeignExG/getMktGoldtdJY.csv?ispandas=1&') 
    if not isinstance(ticker, str) and not isinstance(ticker, unicode):
        ticker = str(ticker)

    requestString.append("ticker=%s"%(ticker))
    try:
        startDate = startDate.strftime('%Y%m%d')
    except:
        startDate = startDate.replace('-', '')
    requestString.append("&startDate=%s"%(startDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 188)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 188)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'ticker', u'secShortName', u'secShortNameEN', u'exchangeCD', u'tradeDate', u'infoSource', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'chg', u'chgPct', u'wPrice', u'turnoverVol', u'turnovervalue']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'ticker': 'str','secShortName': 'str','secShortNameEN': 'str','exchangeCD': 'str','infoSource': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktEqudJYGet(secID, startDate = "", endDate = "", field = "", pandas = "1"):
    """
    交易所市场股票日行情，包括证券内部编码,证券代码,证券简称,证券英文简称,交易市场,交易日期,昨收盘,开盘价,最高价,最低价,收盘价,成交量,成交金额,成交笔数等，历史追溯至1990年，每日更新。
    
    :param secID: 证券内部编码，一串流水号,可先通过DataAPI.SecIDGet获取到，如在DataAPI.SecIDGet，选择证券类型为'E',输入'000001'，可获取到secID'000001.XSHE'后，在此输入'000001.XSHE'
    :param startDate: 起始日期，输入格式为yyyymmdd,可空
    :param endDate: 结束日期，输入格式为yyyymmdd,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktEqudJY.csv?ispandas=1&') 
    if not isinstance(secID, str) and not isinstance(secID, unicode):
        secID = str(secID)

    requestString.append("secID=%s"%(secID))
    if not isinstance(startDate, str) and not isinstance(startDate, unicode):
        startDate = str(startDate)

    requestString.append("&startDate=%s"%(startDate))
    if not isinstance(endDate, str) and not isinstance(endDate, unicode):
        endDate = str(endDate)

    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 186)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 186)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'secShortNameEN', u'exchangeCD', u'tradeDate', u'preClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'turnovervalue', u'dealAmount']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','secShortNameEN': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktIdxdJYGet(secIDSrc = "", indexID = "", beginTime = "", endTime = "", startDate = "", endDate = "", field = "", pandas = "1"):
    """
    收录指数日行情，包括交易日期,前收价,开盘价,最高价,最低价,收盘价,成交量,成交金额,成交笔数,涨跌幅,流通市值等，历史追溯至1928年，每日更新。
    
    :param secIDSrc: 恒生聚源编制的证券唯一识别编码，支持多值输入,可以是列表,secIDSrc、indexID至少选择一个
    :param indexID: 证券内部编码，一串流水号,可先通过DataAPI.SecIDGet获取到，如在DataAPI.SecIDGet，选择证券类型为'idx',输入'000001'，可获取到secID'000001.ZICN'后，在此输入'000001.ZICN',secIDSrc、indexID至少选择一个
    :param beginTime: 输入数据更新时间的查询开始时间，输入格式YYYY-MM-DDTHH:MI:SS，如2016-01-01T00:00:00,可空
    :param endTime: 输入数据更新时间的查询截至时间，输入格式YYYY-MM-DDTHH:MI:SS，如2016-01-01T00:00:00,可空
    :param startDate: 起始日期，输入格式为yyyymmdd,可空
    :param endDate: 结束日期，输入格式为yyyymmdd,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktIdxdJY.csv?ispandas=1&') 
    requestString.append("secIDSrc=")
    if hasattr(secIDSrc,'__iter__') and not isinstance(secIDSrc, str):
        if len(secIDSrc) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secIDSrc
            requestString.append(None)
        else:
            requestString.append(','.join(secIDSrc))
    else:
        requestString.append(secIDSrc)
    if not isinstance(indexID, str) and not isinstance(indexID, unicode):
        indexID = str(indexID)

    requestString.append("&indexID=%s"%(indexID))
    if not isinstance(beginTime, str) and not isinstance(beginTime, unicode):
        beginTime = str(beginTime)

    requestString.append("&beginTime=%s"%(beginTime))
    if not isinstance(endTime, str) and not isinstance(endTime, unicode):
        endTime = str(endTime)

    requestString.append("&endTime=%s"%(endTime))
    try:
        startDate = startDate.strftime('%Y%m%d')
    except:
        startDate = startDate.replace('-', '')
    requestString.append("&startDate=%s"%(startDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 190)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 190)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indexID', u'secIDSrc', u'ticker', u'secShortName', u'secShortNameEN', u'exchangeCD', u'tradeDate', u'preCloseIndex', u'openIndex', u'highestIndex', u'lowestIndex', u'closeIndex', u'turnoverValue', u'turnoverVol', u'dealAmount', u'chgPct', u'negMarketValue', u'updateTime', u'ID', u'JSID']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indexID': 'str','ticker': 'str','secShortName': 'str','secShortNameEN': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktInterestRateJYGet(startDate = "", endDate = "", field = "", pandas = "1"):
    """
    以1000点为基数，从1998年3月27日开始，按照人民币利率，计算活期存款、三个月定存、半年定存、一年定存、二年定存、三年定存、五年定存以及七天通知存款的收益，每日更新。
    
    :param startDate: 起始日期，输入格式为yyyymmdd,可空
    :param endDate: 结束日期，输入格式为yyyymmdd,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktInterestRateJY.csv?ispandas=1&') 
    try:
        startDate = startDate.strftime('%Y%m%d')
    except:
        startDate = startDate.replace('-', '')
    requestString.append("startDate=%s"%(startDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 191)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 191)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'tradeDate', u'baseDate', u'dd', u'td3M', u'td6M', u'td1Y', u'td2Y', u'td3Y', u'td5Y', u'nd7D']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktMonthJYGet(secID, tradeDate = "", field = "", pandas = "1"):
    """
    展示证券每月最后一个日期的收盘价及相关指标，包含收盘价，流通股本，总股本，市盈率TTM，市净率等，每月更新。
    
    :param secID: 证券内部编码，一串流水号,可先通过DataAPI.SecIDGet获取到，如在DataAPI.SecIDGet，选择证券类型为'E',输入'000001'，可获取到secID'000001.XSHE'后，在此输入'000001.XSHE'
    :param tradeDate: 交易日期，输入格式为yyyymmdd,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktMonthJY.csv?ispandas=1&') 
    if not isinstance(secID, str) and not isinstance(secID, unicode):
        secID = str(secID)

    requestString.append("secID=%s"%(secID))
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("&tradeDate=%s"%(tradeDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 192)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 192)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'secShortNameEN', u'exchangeCD', u'tradeDate', u'closePrice', u'floatShares', u'totalShares', u'PETTM', u'PB']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','secShortNameEN': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktNpEquJYGet(secID, field = "", pandas = "1"):
    """
    展示股票从最近一个交易日往前追溯一段时期的行情表现信息，包括近1周、1周以  来、近1月、1月以来、近3月、近半年、近1年、今年以来、上市以来的表现情况，  以及β、α、波动率、夏普比率等风险指标。
    
    :param secID: 证券内部编码，一串流水号,可先通过DataAPI.SecIDGet获取到，如在DataAPI.SecIDGet，选择证券类型为'E',输入'000001'，可获取到secID'000001.XSHE'后，在此输入'000001.XSHE',可以是列表
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktNpEquJY.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 193)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 193)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'secShortNameEN', u'exchangeCD', u'tradeDate', u'preClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'turnovervalue', u'chgPct', u'rangePct', u'turnoverRate', u'avgPrice', u'turnoverValueRW', u'turnovervolRW', u'chgPctRW', u'rangePctRW', u'turnoverRateRW', u'avgPriceRW', u'highPriceRW', u'lowPriceRW', u'highestClosePriceRW', u'lowestClosePriceRW', u'turnoverValuePerDayRW', u'turnoverRatePerDayRW', u'turnoverValueTW', u'turnovervolTW', u'chgPctTW', u'rangePctTW', u'turnoverRateTW', u'avgPriceTW', u'highPriceTW', u'lowPriceTW', u'highestClosePriceTW', u'lowestClosePriceTW', u'turnoverValuePerDayTW', u'turnoverRatePerDayTW', u'turnoverValueRM', u'turnovervolRM', u'chgPctRM', u'rangePctRM', u'turnoverRateRM', u'avgPriceRM', u'highPriceRM', u'lowPriceRM', u'highestClosePriceRM', u'lowestClosePriceRM', u'turnoverValuePerDayRM', u'turnoverRatePerDayRM', u'turnoverValueTM', u'turnovervolTM', u'chgPctTM', u'rangePctTM', u'turnoverRateTM', u'avgPriceTM', u'highPriceTM', u'lowPriceTM', u'highestClosePriceTM', u'lowestClosePriceTM', u'turnoverValuePerDayTM', u'turnoverRatePerDayTM', u'turnoverValueR3M', u'turnovervolR3M', u'chgPctR3M', u'rangePctR3M', u'turnoverRateR3M', u'turnoverValueR6M', u'turnovervolR6M', u'chgPctR6M', u'rangePctR6M', u'turnoverRateR6M', u'turnoverValueR12M', u'turnovervolR12M', u'chgPctR12M', u'rangePctR12M', u'turnoverRateR12M', u'avgPriceR12M', u'highPriceR12M', u'lowPriceR12M', u'highestClosePriceR12M', u'lowestClosePriceR12M', u'turnoverValuePerDayR12M', u'turnoverRatePerDayR12M', u'turnoverValueYTD', u'turnoverVolYTD', u'chgPctYTD', u'rangePctYTD', u'turnoverRateYTD', u'avgPriceYTD', u'highPriceYTD', u'lowPriceYTD', u'highestClosePriceYTD', u'lowestClosePriceYTD', u'turnoverValuePerDayYTD', u'turnoverRatePerDayYTD', u'hightestAdjustPrice', u'highestAdjustDate', u'betaHS300', u'betaComp', u'betaSws', u'betaWeekly2Y', u'adjustBetaWeekey2Y', u'alphaHS300', u'alphaComp', u'alphaSws', u'volatility1Y', u'sharpeRatio1Y', u'marketReturnArithAvg', u'marketReturnGeomAvg', u'marketValue', u'negMarketValue']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','secShortNameEN': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktOverseaEqudJYGet(secID, startDate = "", endDate = "", field = "", pandas = "1"):
    """
    收录在海外市场发行的中国概念股的每日收盘行情数据，市场涉及新加坡证券交易所、美国证券交易所、美国纳斯达克证券交易所、纽约证券    交易所、美国OTCBB市场等， 本表中收录的各市场的行情价格数据均以该市场报价货币计价，未进行兑换。历史追溯至1992年，每日更新。
    
    :param secID: 证券内部编码，一串流水号,可先通过DataAPI.SecIDGet获取到，如在DataAPI.SecIDGet，选择证券类型为'E',输入'C22'，可获取到secID'C22.XSES'后，在此输入'C22.XSES'
    :param startDate: 起始日期，输入格式为yyyymmdd,可空
    :param endDate: 结束日期，输入格式为yyyymmdd,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktOverseaEqudJY.csv?ispandas=1&') 
    if not isinstance(secID, str) and not isinstance(secID, unicode):
        secID = str(secID)

    requestString.append("secID=%s"%(secID))
    if not isinstance(startDate, str) and not isinstance(startDate, unicode):
        startDate = str(startDate)

    requestString.append("&startDate=%s"%(startDate))
    if not isinstance(endDate, str) and not isinstance(endDate, unicode):
        endDate = str(endDate)

    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 196)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 196)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'secShortNameEN', u'exchangeCD', u'tradeDate', u'preClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'turnoverValue', u'dealAmount']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','secShortNameEN': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktSpotTrandJYGet(secID, startDate = "", endDate = "", field = "", pandas = "1"):
    """
    主要是亚太地区的现货交易每日行情，包含前收盘,开盘价,最高价,最低价,收盘价,成交量,成交金额,涨跌,涨跌幅,振幅等，历史追溯至2007年，每日更新。
    
    :param secID: 证券内部编码，输入'GC.XCEC'，可获取到黄金现货的行情，输入'SI.XCEC',可获取到白银现货的行情，输入'PL.XCEC'，可获取到白金现货的行情
    :param startDate: 起始日期，输入格式为yyyymmdd,可空
    :param endDate: 结束日期，输入格式为yyyymmdd,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getMktSpotTrandJY.csv?ispandas=1&') 
    if not isinstance(secID, str) and not isinstance(secID, unicode):
        secID = str(secID)

    requestString.append("secID=%s"%(secID))
    try:
        startDate = startDate.strftime('%Y%m%d')
    except:
        startDate = startDate.replace('-', '')
    requestString.append("&startDate=%s"%(startDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 199)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 199)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'secShortName', u'exchangeCD', u'tradeDate', u'preClosePrice', u'openPrice', u'highPrice', u'lowPrice', u'closePrice', u'turnoverVol', u'turnoverValue', u'chg', u'chgPct', u'rangePct']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','secShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FstTotalJYGet(tradeDate = "", exchangeCD = "", field = "", pandas = "1"):
    """
    获取上海、深圳交易所公布的每个交易日的融资融券交易汇总的信息，包括成交量、成交金额。本交易日可获取前一交易日的数据。
    
    :param tradeDate: 交易日期，默认为前1天，输入格式“YYYYMMDD”,可空
    :param exchangeCD: 股票交易市场，可选择：XSHG上海证券交易所，XSHE深圳证券交易所。,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getFstTotalJY.csv?ispandas=1&') 
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("tradeDate=%s"%(tradeDate))
    requestString.append("&exchangeCD=")
    if hasattr(exchangeCD,'__iter__') and not isinstance(exchangeCD, str):
        if len(exchangeCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = exchangeCD
            requestString.append(None)
        else:
            requestString.append(','.join(exchangeCD))
    else:
        requestString.append(exchangeCD)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1144)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1144)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'tradeDate', u'exchangeCD', u'currencyCD', u'finVal', u'finBuyVal', u'secVol', u'secVal', u'secSellVol', u'tradeVal', u'finRatio']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'exchangeCD': 'str','currencyCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FstDetailJYGet(secID = "", ticker = "", assetClass = "", exchangeCD = "", tradeDate = "", field = "", pandas = "1"):
    """
    获取上海、深圳交易所公布的每个交易日的融资融券交易具体的信息，包括标的证券信息、融资融券金额以及数量方面的数据。本交易日可获取前一交易日的数据。
    
    :param secID: 一只或多只证券代码，用,分隔，格式是“数字.交易所代码”，如000001.XSHE。如果为空，则为全部证券。,可以是列表,secID、ticker、assetClass、exchangeCD至少选择一个
    :param ticker: 一只或多只股票代码，用,分隔，如000001,000002。,可以是列表,secID、ticker、assetClass、exchangeCD至少选择一个
    :param assetClass: 证券类型，可供选择类型：E 股票,B 债券,F 基金。,可以是列表,secID、ticker、assetClass、exchangeCD至少选择一个
    :param exchangeCD: 股票交易市场，可选择：XSHG上海证券交易所，XSHE深圳证券交易所。,可以是列表,secID、ticker、assetClass、exchangeCD至少选择一个
    :param tradeDate: 交易日期，默认为前1天，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getFstDetailJY.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&assetClass=")
    if hasattr(assetClass,'__iter__') and not isinstance(assetClass, str):
        if len(assetClass) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = assetClass
            requestString.append(None)
        else:
            requestString.append(','.join(assetClass))
    else:
        requestString.append(assetClass)
    requestString.append("&exchangeCD=")
    if hasattr(exchangeCD,'__iter__') and not isinstance(exchangeCD, str):
        if len(exchangeCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = exchangeCD
            requestString.append(None)
        else:
            requestString.append(','.join(exchangeCD))
    else:
        requestString.append(exchangeCD)
    try:
        tradeDate = tradeDate.strftime('%Y%m%d')
    except:
        tradeDate = tradeDate.replace('-', '')
    requestString.append("&tradeDate=%s"%(tradeDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1145)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1145)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'tradeDate', u'secID', u'ticker', u'assetClass', u'exchangeCD', u'secShortName', u'secShortNameEn', u'currencyCD', u'finVal', u'finBuyVal', u'finRefundVal', u'secVol', u'secSellVol', u'secRefundVol', u'secVal', u'tradeVal']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','assetClass': 'str','exchangeCD': 'str','secShortName': 'str','secShortNameEn': 'str','currencyCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FstTargetSecGet(secID = "", ticker = "", exchangeCD = "", targetTypeCD = "", targetFlg = "", field = "", pandas = "1"):
    """
    获取交易所公布的融资融券标的证券信息，包含历次入选和剔除融资（融券）标的变化情况。
    
    :param secID: 一只或多只证券代码，用,分隔，格式是“数字.交易所代码”，如000001.XSHE。如果为空，则为全部证券。,可以是列表,可空
    :param ticker: 一只或多只股票代码，用,分隔，如000001,000002。,可以是列表,可空
    :param exchangeCD: 交易市场。例如，XSHG-上海证券交易所；XSHE-深圳证券交易所。对应DataAPI.SysCodeGet.codeTypeID=10002。,可以是列表,可空
    :param targetTypeCD: 标的类别，如融资买入标的，融券卖出标的。,可以是列表,可空
    :param targetFlg: 是否标的证券的标志。,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getFstTargetSec.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&exchangeCD=")
    if hasattr(exchangeCD,'__iter__') and not isinstance(exchangeCD, str):
        if len(exchangeCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = exchangeCD
            requestString.append(None)
        else:
            requestString.append(','.join(exchangeCD))
    else:
        requestString.append(exchangeCD)
    requestString.append("&targetTypeCD=")
    if hasattr(targetTypeCD,'__iter__') and not isinstance(targetTypeCD, str):
        if len(targetTypeCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = targetTypeCD
            requestString.append(None)
        else:
            requestString.append(','.join(targetTypeCD))
    else:
        requestString.append(targetTypeCD)
    requestString.append("&targetFlg=")
    if hasattr(targetFlg,'__iter__') and not isinstance(targetFlg, str):
        if len(targetFlg) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = targetFlg
            requestString.append(None)
        else:
            requestString.append(','.join(targetFlg))
    else:
        requestString.append(targetFlg)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1482)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1482)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'exchangeCD', u'secShortName', u'intoDate', u'outDate', u'targetTypeCD', u'targetFlg']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','exchangeCD': 'str','secShortName': 'str','targetTypeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def FstGuaSecGet(secID = "", ticker = "", assetClass1St = "", assetClass1Nd = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取交易所及券商公布的每日可充抵保证金证券的券种及折算率等数据。
    
    :param secID: 一只或多只证券代码，用,分隔，格式是“数字.交易所代码”，如000001.XSHE。如果为空，则为全部证券。,secID、ticker、assetClass1St、assetClass1Nd至少选择一个
    :param ticker: 一只或多只股票代码，用,分隔，如000001,000002。,secID、ticker、assetClass1St、assetClass1Nd至少选择一个
    :param assetClass1St: 担保证券所属一级证券类别。,可以是列表,secID、ticker、assetClass1St、assetClass1Nd至少选择一个
    :param assetClass1Nd: 担保证券所属二级证券类别。,可以是列表,secID、ticker、assetClass1St、assetClass1Nd至少选择一个
    :param beginDate: 担保证券担保日期,可空
    :param endDate: 担保证券担保日期截止日,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getFstGuaSec.csv?ispandas=1&') 
    if not isinstance(secID, str) and not isinstance(secID, unicode):
        secID = str(secID)

    requestString.append("secID=%s"%(secID))
    if not isinstance(ticker, str) and not isinstance(ticker, unicode):
        ticker = str(ticker)

    requestString.append("&ticker=%s"%(ticker))
    requestString.append("&assetClass1St=")
    if hasattr(assetClass1St,'__iter__') and not isinstance(assetClass1St, str):
        if len(assetClass1St) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = assetClass1St
            requestString.append(None)
        else:
            requestString.append(','.join(assetClass1St))
    else:
        requestString.append(assetClass1St)
    requestString.append("&assetClass1Nd=")
    if hasattr(assetClass1Nd,'__iter__') and not isinstance(assetClass1Nd, str):
        if len(assetClass1Nd) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = assetClass1Nd
            requestString.append(None)
        else:
            requestString.append(','.join(assetClass1Nd))
    else:
        requestString.append(assetClass1Nd)
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1483)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1483)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'exchangeCD', u'secShortName', u'assetClass1St', u'assetClass1Nd', u'conversionRate', u'publishDate', u'publishOrg', u'publishOrgID', u'endDate']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','exchangeCD': 'str','secShortName': 'str','assetClass1St': 'str','assetClass1Nd': 'str','publishOrg': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def BlockTradingIntentJYGet(SecID = "", field = "", pandas = "1"):
    """
    交易所公布的大宗交易意向表。
    
    :param SecID: 证券ID，可通过交易代码和交易市场在DataAPI.SecIDGet获取到。,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getBlockTradingIntentJY.csv?ispandas=1&') 
    requestString.append("SecID=")
    if hasattr(SecID,'__iter__') and not isinstance(SecID, str):
        if len(SecID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = SecID
            requestString.append(None)
        else:
            requestString.append(','.join(SecID))
    else:
        requestString.append(SecID)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'SecID', u'TradingDay', u'BSDirection', u'BSDirectionCode', u'BSPrice', u'BSVolume', u'Remark']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'BSDirection': 'str','Remark': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def QTAdjustingFactorJYGet(beginTime = "", endTime = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取根据各股票、基金、债券等因为分红配股等计算出的复权因子。
    
    :param beginTime: 输入数据更新时间的查询开始时间，输入格式YYYY-MM-DDTHH:MI:SS，如2016-01-01T01:00:00,beginTime、endTime、beginDate、endDate至少选择一个
    :param endTime: 输入数据更新时间的查询截至时间，输入格式YYYY-MM-DDTHH:MI:SS，如2016-01-01T01:00:00,beginTime、endTime、beginDate、endDate至少选择一个
    :param beginDate: 除权除息日查询开始时间，输入格式YYYYMMDD,beginTime、endTime、beginDate、endDate至少选择一个
    :param endDate: 除权除息日查询结束时间，输入格式YYYYMMDD,beginTime、endTime、beginDate、endDate至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getQTAdjustingFactorJY.csv?ispandas=1&') 
    if not isinstance(beginTime, str) and not isinstance(beginTime, unicode):
        beginTime = str(beginTime)

    requestString.append("beginTime=%s"%(beginTime))
    if not isinstance(endTime, str) and not isinstance(endTime, unicode):
        endTime = str(endTime)

    requestString.append("&endTime=%s"%(endTime))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1813)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1813)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'ID', u'secIDSrc', u'exDiviDate', u'adjustingFactor', u'adjustingConst', u'ratioAdjustingFactor', u'accuCashDivi', u'accuBonusShareRatio', u'updateTime', u'JSID']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def QTDailyQuoteJYGet(beginTime = "", endTime = "", beginDate = "", endDate = "", innerCode = "", field = "", pandas = "1"):
    """
    获取交易所市场、银行间市场、银行柜台市场交易日行情报价及主要行情指标。
    
    :param beginTime: 输入数据更新时间的查询开始时间，输入格式YYYY-MM-DDTHH:MI:SS，如2016-01-01T01:00:00,beginTime、endTime、beginDate、endDate、innerCode至少选择一个
    :param endTime: 输入数据更新时间的查询截至时间，输入格式YYYY-MM-DDTHH:MI:SS，如2016-01-01T01:00:00,beginTime、endTime、beginDate、endDate、innerCode至少选择一个
    :param beginDate: 交易日期查询开始时间，输入格式YYYYMMDD,beginTime、endTime、beginDate、endDate、innerCode至少选择一个
    :param endDate: 交易日期查询结束时间，输入格式YYYYMMDD,beginTime、endTime、beginDate、endDate、innerCode至少选择一个
    :param innerCode: 恒生聚源编制的证券唯一识别编码，支持多值输入,可以是列表,beginTime、endTime、beginDate、endDate、innerCode至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getQTDailyQuoteJY.csv?ispandas=1&') 
    if not isinstance(beginTime, str) and not isinstance(beginTime, unicode):
        beginTime = str(beginTime)

    requestString.append("beginTime=%s"%(beginTime))
    if not isinstance(endTime, str) and not isinstance(endTime, unicode):
        endTime = str(endTime)

    requestString.append("&endTime=%s"%(endTime))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&innerCode=")
    if hasattr(innerCode,'__iter__') and not isinstance(innerCode, str):
        if len(innerCode) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = innerCode
            requestString.append(None)
        else:
            requestString.append(','.join(innerCode))
    else:
        requestString.append(innerCode)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1814)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1814)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'ID', u'innerCode', u'tradingDay', u'prevClosePrice', u'openPrice', u'highPrice', u'lowPrice', u'closePrice', u'turnoverVolume', u'turnoverValue', u'turnoverDeals', u'updateTime', u'JSID']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def QTTradingDayJYGet(beginTime = "", endTime = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取每个日期是否是交易日，是否是周末、月末、季末和年末。
    
    :param beginTime: 输入数据更新时间的查询开始时间，输入格式YYYY-MM-DDTHH:MI:SS，如2016-01-01T01:00:00,可空
    :param endTime: 输入数据更新时间的查询截至时间，输入格式YYYY-MM-DDTHH:MI:SS，如2016-01-01T01:00:00,可空
    :param beginDate: 日期查询开始时间，输入格式YYYYMMDD,可空
    :param endDate: 日期查询结束时间，输入格式YYYYMMDD,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getQTTradingDayJY.csv?ispandas=1&') 
    if not isinstance(beginTime, str) and not isinstance(beginTime, unicode):
        beginTime = str(beginTime)

    requestString.append("beginTime=%s"%(beginTime))
    if not isinstance(endTime, str) and not isinstance(endTime, unicode):
        endTime = str(endTime)

    requestString.append("&endTime=%s"%(endTime))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1815)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1815)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'ID', u'tradingDate', u'ifTradingDay', u'secuMarket', u'ifWeekEnd', u'ifMonthEnd', u'ifQuarterEnd', u'ifYearEnd', u'updateTime', u'JSID']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def QTIndexQuoteJYGet(beginTime = "", endTime = "", innerCode = "", startDate = "", endDate = "", field = "", pandas = "1"):
    """
    收录指数日行情，包括交易日期,前收价,开盘价,最高价,最低价,收盘价,成交量,成交金额,成交笔数,涨跌幅,流通市值等，历史追溯至1928年，每日更新。
    
    :param beginTime: 输入数据更新时间的查询开始时间，输入格式YYYY-MM-DDTHH:MI:SS，如2016-01-01T00:00:00,可空
    :param endTime: 输入数据更新时间的查询截至时间，输入格式YYYY-MM-DDTHH:MI:SS，如2016-01-01T00:00:00,可空
    :param innerCode: 恒生聚源编制的证券唯一识别编码，支持多值输入,可以是列表,可空
    :param startDate: 起始日期，输入格式为yyyymmdd,可空
    :param endDate: 结束日期，输入格式为yyyymmdd,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/market/getQTIndexQuoteJY.csv?ispandas=1&') 
    if not isinstance(beginTime, str) and not isinstance(beginTime, unicode):
        beginTime = str(beginTime)

    requestString.append("beginTime=%s"%(beginTime))
    if not isinstance(endTime, str) and not isinstance(endTime, unicode):
        endTime = str(endTime)

    requestString.append("&endTime=%s"%(endTime))
    requestString.append("&innerCode=")
    if hasattr(innerCode,'__iter__') and not isinstance(innerCode, str):
        if len(innerCode) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = innerCode
            requestString.append(None)
        else:
            requestString.append(','.join(innerCode))
    else:
        requestString.append(innerCode)
    try:
        startDate = startDate.strftime('%Y%m%d')
    except:
        startDate = startDate.replace('-', '')
    requestString.append("&startDate=%s"%(startDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1823)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1823)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'ID', u'innerCode', u'tradingDay', u'prevClosePrice', u'openPrice', u'highPrice', u'lowPrice', u'closePrice', u'turnoverVolume', u'turnoverValue', u'turnoverDeals', u'changePCT', u'negotiableMV', u'updateTime', u'JSID']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def CTSystemConstJYGet(beginTime = "", endTime = "", LB = "", DM = "", field = "", pandas = "1"):
    """
    数据库中常量值
    
    :param beginTime: 输入数据更新时间的查询开始时间，输入格式YYYY-MM-DDTHH:MI:SS，如2016-01-01T01:00:00,可空
    :param endTime: 输入数据更新时间的查询截至时间，输入格式YYYY-MM-DDTHH:MI:SS，如2016-01-01T01:00:00,可空
    :param LB: 常量分类编码,可以是列表,可空
    :param DM: 常量代码,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/param/getCTSystemConstJY.csv?ispandas=1&') 
    if not isinstance(beginTime, str) and not isinstance(beginTime, unicode):
        beginTime = str(beginTime)

    requestString.append("beginTime=%s"%(beginTime))
    if not isinstance(endTime, str) and not isinstance(endTime, unicode):
        endTime = str(endTime)

    requestString.append("&endTime=%s"%(endTime))
    requestString.append("&LB=")
    if hasattr(LB,'__iter__') and not isinstance(LB, str):
        if len(LB) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = LB
            requestString.append(None)
        else:
            requestString.append(','.join(LB))
    else:
        requestString.append(LB)
    requestString.append("&DM=")
    if hasattr(DM,'__iter__') and not isinstance(DM, str):
        if len(DM) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = DM
            requestString.append(None)
        else:
            requestString.append(','.join(DM))
    else:
        requestString.append(DM)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1600)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1600)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'LB', u'LBMC', u'MS', u'DM', u'JSID', u'updateTime', u'ID', u'fvalue', u'ivalue', u'dvalue', u'cvalue']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'LBMC': 'str','MS': 'str','cvalue': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def SecIDJYGet(secID = "", secIDSrc = "", ticker = "", exchangeCD = "", assetClass = "", listSectorCD = "", listStatusCD = "", partyID = "", partyIDSrc = "", beginTime = "", endTime = "", field = "", pandas = "1"):
    """
    单个证券品种（股票、基金、债券）的简称、上市交易所等信息。
    
    :param secID: 通联数据编制的证券唯一识别编码，支持多值输入,可以是列表,secID、secIDSrc、ticker、exchangeCD、assetClass、listSectorCD、listStatusCD、partyID、partyIDSrc、beginTime、endTime至少选择一个
    :param secIDSrc: 恒生聚源编制的证券唯一识别编码，支持多值输入,可以是列表,secID、secIDSrc、ticker、exchangeCD、assetClass、listSectorCD、listStatusCD、partyID、partyIDSrc、beginTime、endTime至少选择一个
    :param ticker: 通常记录的是证券交易代码；支持多值输入,可以是列表,secID、secIDSrc、ticker、exchangeCD、assetClass、listSectorCD、listStatusCD、partyID、partyIDSrc、beginTime、endTime至少选择一个
    :param exchangeCD: 证券市场。例如，83-上海证券交易所；89-银行间债券市场；90-深圳证券交易所等。对应DataAPI.JY.CTSystemConstJYGet.LB=201。,可以是列表,secID、secIDSrc、ticker、exchangeCD、assetClass、listSectorCD、listStatusCD、partyID、partyIDSrc、beginTime、endTime至少选择一个
    :param assetClass: 证券类别。例如，1-A股；2-B股等。对应DataAPI.JY.CTSystemConstJYGet.LB=1177。,可以是列表,secID、secIDSrc、ticker、exchangeCD、assetClass、listSectorCD、listStatusCD、partyID、partyIDSrc、beginTime、endTime至少选择一个
    :param listSectorCD: 上市板块。例如，1-主板；2-中小企业板；6-创业板等。对应DataAPI.JY.CTSystemConstJYGet.LB=207。,可以是列表,secID、secIDSrc、ticker、exchangeCD、assetClass、listSectorCD、listStatusCD、partyID、partyIDSrc、beginTime、endTime至少选择一个
    :param listStatusCD: 上市状态。例如，1-上市；5-终止等。对应DataAPI.JY.CTSystemConstJYGet.LB=1176。,可以是列表,secID、secIDSrc、ticker、exchangeCD、assetClass、listSectorCD、listStatusCD、partyID、partyIDSrc、beginTime、endTime至少选择一个
    :param partyID: 通联数据编制的公司唯一识别编码，支持多值输入,可以是列表,secID、secIDSrc、ticker、exchangeCD、assetClass、listSectorCD、listStatusCD、partyID、partyIDSrc、beginTime、endTime至少选择一个
    :param partyIDSrc: 恒生聚源编制的公司唯一识别编码，支持多值输入,可以是列表,secID、secIDSrc、ticker、exchangeCD、assetClass、listSectorCD、listStatusCD、partyID、partyIDSrc、beginTime、endTime至少选择一个
    :param beginTime: 记录更新查询开始开始时间，输入格式YYYY-MM-DD HH:MI:SS,secID、secIDSrc、ticker、exchangeCD、assetClass、listSectorCD、listStatusCD、partyID、partyIDSrc、beginTime、endTime至少选择一个
    :param endTime: 记录更新查询截至开始时间，输入格式YYYY-MM-DD HH:MI:SS,secID、secIDSrc、ticker、exchangeCD、assetClass、listSectorCD、listStatusCD、partyID、partyIDSrc、beginTime、endTime至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/param/getSecIDJY.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&secIDSrc=")
    if hasattr(secIDSrc,'__iter__') and not isinstance(secIDSrc, str):
        if len(secIDSrc) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secIDSrc
            requestString.append(None)
        else:
            requestString.append(','.join(secIDSrc))
    else:
        requestString.append(secIDSrc)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&exchangeCD=")
    if hasattr(exchangeCD,'__iter__') and not isinstance(exchangeCD, str):
        if len(exchangeCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = exchangeCD
            requestString.append(None)
        else:
            requestString.append(','.join(exchangeCD))
    else:
        requestString.append(exchangeCD)
    requestString.append("&assetClass=")
    if hasattr(assetClass,'__iter__') and not isinstance(assetClass, str):
        if len(assetClass) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = assetClass
            requestString.append(None)
        else:
            requestString.append(','.join(assetClass))
    else:
        requestString.append(assetClass)
    requestString.append("&listSectorCD=")
    if hasattr(listSectorCD,'__iter__') and not isinstance(listSectorCD, str):
        if len(listSectorCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = listSectorCD
            requestString.append(None)
        else:
            requestString.append(','.join(listSectorCD))
    else:
        requestString.append(listSectorCD)
    requestString.append("&listStatusCD=")
    if hasattr(listStatusCD,'__iter__') and not isinstance(listStatusCD, str):
        if len(listStatusCD) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = listStatusCD
            requestString.append(None)
        else:
            requestString.append(','.join(listStatusCD))
    else:
        requestString.append(listStatusCD)
    requestString.append("&partyID=")
    if hasattr(partyID,'__iter__') and not isinstance(partyID, str):
        if len(partyID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = partyID
            requestString.append(None)
        else:
            requestString.append(','.join(partyID))
    else:
        requestString.append(partyID)
    requestString.append("&partyIDSrc=")
    if hasattr(partyIDSrc,'__iter__') and not isinstance(partyIDSrc, str):
        if len(partyIDSrc) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = partyIDSrc
            requestString.append(None)
        else:
            requestString.append(','.join(partyIDSrc))
    else:
        requestString.append(partyIDSrc)
    if not isinstance(beginTime, str) and not isinstance(beginTime, unicode):
        beginTime = str(beginTime)

    requestString.append("&beginTime=%s"%(beginTime))
    if not isinstance(endTime, str) and not isinstance(endTime, unicode):
        endTime = str(endTime)

    requestString.append("&endTime=%s"%(endTime))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1797)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1797)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'secIDSrc', u'ticker', u'secFullName', u'secFullNameEN', u'secShortName', u'secShortNameEN', u'tradeAbbrName', u'cnSpell', u'exchangeCD', u'listSectorCD', u'assetClass', u'partyID', u'partyIDSrc', u'listStatusCD', u'listDate', u'ISIN', u'JSID', u'updateTime', u'ID']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secFullName': 'str','secFullNameEN': 'str','secShortName': 'str','secShortNameEN': 'str','tradeAbbrName': 'str','cnSpell': 'str','ISIN': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def DeleteRecJYGet(beginTime = "", endTime = "", field = "", pandas = "1"):
    """
    恒生聚源删除日志记录
    
    :param beginTime: 输入数据更新时间的查询开始时间，输入格式YYYY-MM-DDTHH:MI:SS，如2016-01-01T01:00:00,beginTime、endTime至少选择一个
    :param endTime: 输入数据更新时间的查询截至时间，输入格式YYYY-MM-DDTHH:MI:SS，如2016-01-01T01:00:00,beginTime、endTime至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/param/getDeleteRecJY.csv?ispandas=1&') 
    if not isinstance(beginTime, str) and not isinstance(beginTime, unicode):
        beginTime = str(beginTime)

    requestString.append("beginTime=%s"%(beginTime))
    if not isinstance(endTime, str) and not isinstance(endTime, unicode):
        endTime = str(endTime)

    requestString.append("&endTime=%s"%(endTime))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'tableName', u'recID', u'updateTime', u'JSID', u'ID']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'tableName': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def SecNameChangeJYGet(beginTime = "", endTime = "", innerCode = "", publishDateBegin = "", publishDateEnd = "", field = "", pandas = "1"):
    """
    单个证券品种（股票、基金、债券）的简称变更情况。
    
    :param beginTime: 输入数据更新时间的查询开始时间，输入格式YYYY-MM-DDTHH:MI:SS，如2016-01-01T01:00:00,beginTime、endTime、innerCode、publishDateBegin、publishDateEnd至少选择一个
    :param endTime: 输入数据更新时间的查询截至时间，输入格式YYYY-MM-DDTHH:MI:SS，如2016-01-01T01:00:00,beginTime、endTime、innerCode、publishDateBegin、publishDateEnd至少选择一个
    :param innerCode: 恒生聚源编制的证券编码。支持多值输入,可以是列表,beginTime、endTime、innerCode、publishDateBegin、publishDateEnd至少选择一个
    :param publishDateBegin: 根据信息发布时间段查询的开始日期，输入格式YYYYMMDD,beginTime、endTime、innerCode、publishDateBegin、publishDateEnd至少选择一个
    :param publishDateEnd: 根据信息发布时间段查询的结束日期，输入格式YYYYMMDD,beginTime、endTime、innerCode、publishDateBegin、publishDateEnd至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/param/getSecNameChangeJY.csv?ispandas=1&') 
    if not isinstance(beginTime, str) and not isinstance(beginTime, unicode):
        beginTime = str(beginTime)

    requestString.append("beginTime=%s"%(beginTime))
    if not isinstance(endTime, str) and not isinstance(endTime, unicode):
        endTime = str(endTime)

    requestString.append("&endTime=%s"%(endTime))
    requestString.append("&innerCode=")
    if hasattr(innerCode,'__iter__') and not isinstance(innerCode, str):
        if len(innerCode) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = innerCode
            requestString.append(None)
        else:
            requestString.append(','.join(innerCode))
    else:
        requestString.append(innerCode)
    try:
        publishDateBegin = publishDateBegin.strftime('%Y%m%d')
    except:
        publishDateBegin = publishDateBegin.replace('-', '')
    requestString.append("&publishDateBegin=%s"%(publishDateBegin))
    try:
        publishDateEnd = publishDateEnd.strftime('%Y%m%d')
    except:
        publishDateEnd = publishDateEnd.replace('-', '')
    requestString.append("&publishDateEnd=%s"%(publishDateEnd))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1816)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1816)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'ID', u'innerCode', u'publishDate', u'infoSrc', u'mtPubDate', u'isRejected', u'changeDate', u'tradeAbbrName', u'cnSpell', u'changeReason', u'updateTime', u'JSID']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'infoSrc': 'str','tradeAbbrName': 'str','cnSpell': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def SecCodeChangeJYGet(beginTime = "", endTime = "", innerCode = "", secuCode = "", companyCode = "", codeDefine = "", field = "", pandas = "1"):
    """
    证券代码的历次变更情况。
    
    :param beginTime: 输入数据更新时间的查询开始时间，输入格式YYYY-MM-DDTHH:MI:SS，如2016-01-01T01:00:00,beginTime、endTime、innerCode、secuCode、companyCode、codeDefine至少选择一个
    :param endTime: 输入数据更新时间的查询截至时间，输入格式YYYY-MM-DDTHH:MI:SS，如2016-01-01T01:00:00,beginTime、endTime、innerCode、secuCode、companyCode、codeDefine至少选择一个
    :param innerCode: 恒生聚源编制的证券编码。支持多值输入,可以是列表,beginTime、endTime、innerCode、secuCode、companyCode、codeDefine至少选择一个
    :param secuCode: 证券在证券市场通用的交易代码。支持多值输入,可以是列表,beginTime、endTime、innerCode、secuCode、companyCode、codeDefine至少选择一个
    :param companyCode: 恒生聚源编制的公司代码，支持多值输入,可以是列表,beginTime、endTime、innerCode、secuCode、companyCode、codeDefine至少选择一个
    :param codeDefine: 证券代码定义。例如，1-交易所；2-托管银行；3-聚源数据等。对应DataAPI.JY.CTSystemConstJYGet.LB=1006。,可以是列表,beginTime、endTime、innerCode、secuCode、companyCode、codeDefine至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/param/getSecCodeChangeJY.csv?ispandas=1&') 
    if not isinstance(beginTime, str) and not isinstance(beginTime, unicode):
        beginTime = str(beginTime)

    requestString.append("beginTime=%s"%(beginTime))
    if not isinstance(endTime, str) and not isinstance(endTime, unicode):
        endTime = str(endTime)

    requestString.append("&endTime=%s"%(endTime))
    requestString.append("&innerCode=")
    if hasattr(innerCode,'__iter__') and not isinstance(innerCode, str):
        if len(innerCode) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = innerCode
            requestString.append(None)
        else:
            requestString.append(','.join(innerCode))
    else:
        requestString.append(innerCode)
    requestString.append("&secuCode=")
    if hasattr(secuCode,'__iter__') and not isinstance(secuCode, str):
        if len(secuCode) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secuCode
            requestString.append(None)
        else:
            requestString.append(','.join(secuCode))
    else:
        requestString.append(secuCode)
    requestString.append("&companyCode=")
    if hasattr(companyCode,'__iter__') and not isinstance(companyCode, str):
        if len(companyCode) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = companyCode
            requestString.append(None)
        else:
            requestString.append(','.join(companyCode))
    else:
        requestString.append(companyCode)
    requestString.append("&codeDefine=")
    if hasattr(codeDefine,'__iter__') and not isinstance(codeDefine, str):
        if len(codeDefine) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = codeDefine
            requestString.append(None)
        else:
            requestString.append(','.join(codeDefine))
    else:
        requestString.append(codeDefine)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1818)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1818)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'ID', u'innerCode', u'secuCode', u'secuMarket', u'codeDefine', u'companyCode', u'beginDate', u'stopDate', u'updateTime', u'JSID']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secuCode': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def SecStatusChangeJYGet(beginTime = "", endTime = "", innerCode = "", changeType = "", changeDateBegin = "", changeDateEnd = "", field = "", pandas = "1"):
    """
    各证券上市状态变更的情况。
    
    :param beginTime: 输入数据更新时间的查询开始时间，输入格式YYYY-MM-DDTHH:MI:SS，如2016-01-01T01:00:00,beginTime、endTime、innerCode、changeType、changeDateBegin、changeDateEnd至少选择一个
    :param endTime: 输入数据更新时间的查询截至时间，输入格式YYYY-MM-DDTHH:MI:SS，如2016-01-01T01:00:00,beginTime、endTime、innerCode、changeType、changeDateBegin、changeDateEnd至少选择一个
    :param innerCode: 恒生聚源编制的证券编码。支持多值输入,可以是列表,beginTime、endTime、innerCode、changeType、changeDateBegin、changeDateEnd至少选择一个
    :param changeType: 上市状态变更类型。例如，1-上市；2-暂停上市；3-恢复上市等。对应DataAPI.JY.CTSystemConstJYGet.LB=1184。,可以是列表,beginTime、endTime、innerCode、changeType、changeDateBegin、changeDateEnd至少选择一个
    :param changeDateBegin: 根据变更时间查询的开始日期，输入格式YYYYMMDD,beginTime、endTime、innerCode、changeType、changeDateBegin、changeDateEnd至少选择一个
    :param changeDateEnd: 根据变更时间查询的结束日期，输入格式YYYYMMDD,beginTime、endTime、innerCode、changeType、changeDateBegin、changeDateEnd至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/param/getSecStatusChangeJY.csv?ispandas=1&') 
    if not isinstance(beginTime, str) and not isinstance(beginTime, unicode):
        beginTime = str(beginTime)

    requestString.append("beginTime=%s"%(beginTime))
    if not isinstance(endTime, str) and not isinstance(endTime, unicode):
        endTime = str(endTime)

    requestString.append("&endTime=%s"%(endTime))
    requestString.append("&innerCode=")
    if hasattr(innerCode,'__iter__') and not isinstance(innerCode, str):
        if len(innerCode) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = innerCode
            requestString.append(None)
        else:
            requestString.append(','.join(innerCode))
    else:
        requestString.append(innerCode)
    requestString.append("&changeType=")
    if hasattr(changeType,'__iter__') and not isinstance(changeType, str):
        if len(changeType) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = changeType
            requestString.append(None)
        else:
            requestString.append(','.join(changeType))
    else:
        requestString.append(changeType)
    try:
        changeDateBegin = changeDateBegin.strftime('%Y%m%d')
    except:
        changeDateBegin = changeDateBegin.replace('-', '')
    requestString.append("&changeDateBegin=%s"%(changeDateBegin))
    try:
        changeDateEnd = changeDateEnd.strftime('%Y%m%d')
    except:
        changeDateEnd = changeDateEnd.replace('-', '')
    requestString.append("&changeDateEnd=%s"%(changeDateEnd))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1819)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1819)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'ID', u'innerCode', u'secuMarket', u'changeDate', u'changeType', u'changeReason', u'changeStatement', u'largeApplyingMax', u'updateTime', u'JSID']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'changeStatement': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def SecSpecialTradeJYGet(publishDateBegin = "", publishDateEnd = "", beginTime = "", endTime = "", innerCode = "", specialTradeType = "", field = "", pandas = "1"):
    """
    证券被特别处理(或撤销)的相关信息,包括暂停上市、恢复上市、终止上市、代办转让、ST、PT、*ST、撤销ST、撤销PT、撤销*ST。
    
    :param publishDateBegin: 根据信息发布时间查询的开始日期，输入格式YYYYMMDD,publishDateBegin、publishDateEnd、beginTime、endTime、innerCode、specialTradeType至少选择一个
    :param publishDateEnd: 根据信息发布时间查询的结束日期，输入格式YYYYMMDD,publishDateBegin、publishDateEnd、beginTime、endTime、innerCode、specialTradeType至少选择一个
    :param beginTime: 输入数据更新时间的查询开始时间，输入格式YYYY-MM-DDTHH:MI:SS，如2016-01-01T01:00:00,publishDateBegin、publishDateEnd、beginTime、endTime、innerCode、specialTradeType至少选择一个
    :param endTime: 输入数据更新时间的查询截至时间，输入格式YYYY-MM-DDTHH:MI:SS，如2016-01-01T01:00:00,publishDateBegin、publishDateEnd、beginTime、endTime、innerCode、specialTradeType至少选择一个
    :param innerCode: 恒生聚源编制的证券编码。支持多值输入,可以是列表,publishDateBegin、publishDateEnd、beginTime、endTime、innerCode、specialTradeType至少选择一个
    :param specialTradeType: 特别处理(或撤销)类别。例如，1-ST；2-撤销ST；3-PT；4-撤销PT等。对应DataAPI.JY.CTSystemConstJYGet.LB=1185。,可以是列表,publishDateBegin、publishDateEnd、beginTime、endTime、innerCode、specialTradeType至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/param/getSecSpecialTradeJY.csv?ispandas=1&') 
    try:
        publishDateBegin = publishDateBegin.strftime('%Y%m%d')
    except:
        publishDateBegin = publishDateBegin.replace('-', '')
    requestString.append("publishDateBegin=%s"%(publishDateBegin))
    try:
        publishDateEnd = publishDateEnd.strftime('%Y%m%d')
    except:
        publishDateEnd = publishDateEnd.replace('-', '')
    requestString.append("&publishDateEnd=%s"%(publishDateEnd))
    if not isinstance(beginTime, str) and not isinstance(beginTime, unicode):
        beginTime = str(beginTime)

    requestString.append("&beginTime=%s"%(beginTime))
    if not isinstance(endTime, str) and not isinstance(endTime, unicode):
        endTime = str(endTime)

    requestString.append("&endTime=%s"%(endTime))
    requestString.append("&innerCode=")
    if hasattr(innerCode,'__iter__') and not isinstance(innerCode, str):
        if len(innerCode) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = innerCode
            requestString.append(None)
        else:
            requestString.append(','.join(innerCode))
    else:
        requestString.append(innerCode)
    requestString.append("&specialTradeType=")
    if hasattr(specialTradeType,'__iter__') and not isinstance(specialTradeType, str):
        if len(specialTradeType) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = specialTradeType
            requestString.append(None)
        else:
            requestString.append(','.join(specialTradeType))
    else:
        requestString.append(specialTradeType)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1820)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1820)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'ID', u'innerCode', u'publishDate', u'tradeAbbrName', u'specialTradeType', u'specialTradeTime', u'specialTradeStatement', u'specialTradeReason', u'updateTime', u'JSID']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'tradeAbbrName': 'str','specialTradeStatement': 'str','specialTradeReason': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def SecuMainJYGet(innerCode = "", companyCode = "", secuCode = "", beginTime = "", endTime = "", field = "", pandas = "1"):
    """
    单个证券品种（股票、基金、债券）的简称、上市交易所等信息。
    
    :param innerCode: 证券内部编码,可以是列表,innerCode、companyCode、secuCode、beginTime、endTime至少选择一个
    :param companyCode: 公司代码,可以是列表,innerCode、companyCode、secuCode、beginTime、endTime至少选择一个
    :param secuCode: 证券代码,可以是列表,innerCode、companyCode、secuCode、beginTime、endTime至少选择一个
    :param beginTime: 记录更新查询开始开始时间，输入格式YYYY-MM-DD HH:MI:SS,innerCode、companyCode、secuCode、beginTime、endTime至少选择一个
    :param endTime: 记录更新查询开始开始时间，输入格式YYYY-MM-DD HH:MI:SS,innerCode、companyCode、secuCode、beginTime、endTime至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/param/getSecuMainJY.csv?ispandas=1&') 
    requestString.append("innerCode=")
    if hasattr(innerCode,'__iter__') and not isinstance(innerCode, str):
        if len(innerCode) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = innerCode
            requestString.append(None)
        else:
            requestString.append(','.join(innerCode))
    else:
        requestString.append(innerCode)
    requestString.append("&companyCode=")
    if hasattr(companyCode,'__iter__') and not isinstance(companyCode, str):
        if len(companyCode) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = companyCode
            requestString.append(None)
        else:
            requestString.append(','.join(companyCode))
    else:
        requestString.append(companyCode)
    requestString.append("&secuCode=")
    if hasattr(secuCode,'__iter__') and not isinstance(secuCode, str):
        if len(secuCode) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secuCode
            requestString.append(None)
        else:
            requestString.append(','.join(secuCode))
    else:
        requestString.append(secuCode)
    if not isinstance(beginTime, str) and not isinstance(beginTime, unicode):
        beginTime = str(beginTime)

    requestString.append("&beginTime=%s"%(beginTime))
    if not isinstance(endTime, str) and not isinstance(endTime, unicode):
        endTime = str(endTime)

    requestString.append("&endTime=%s"%(endTime))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1828)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1828)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'ID', u'innerCode', u'companyCode', u'secuCode', u'chiName', u'chiNameAbbr', u'engName', u'engNameAbbr', u'secuAbbr', u'chiSpelling', u'secuMarket', u'secuCategory', u'listedDate', u'listedSector', u'listedState', u'updateTime', u'JSID', u'ISIN']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secuCode': 'str','chiName': 'str','chiNameAbbr': 'str','engName': 'str','engNameAbbr': 'str','secuAbbr': 'str','chiSpelling': 'str','ISIN': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktHkEqudJYGet(secID = "", ticker = "", startDate = "", endDate = "", field = "", pandas = "1"):
    """
    香港联合交易所交易日行情报价数据，包括前收价,开盘价,最高价,最低价,收盘价,成交量,成交金额,成交笔数,涨跌,涨跌幅,市盈率,息率,买入成交量,卖出成交量,买入价,卖出价,SMA10,SMA20,SMA50,SMA250等，历史追溯至1990年，每日更新。
    
    :param secID: 证券内部编码，一串流水号,可先通过DataAPI.SecIDGet获取到，如在DataAPI.SecIDGet，选择证券类型为'E',输入'00001'，可获取到secID'00001.XHKG'后，在此输入'00001.XHKG',可以是列表,secID、ticker至少选择一个
    :param ticker: 证券代码,可以是列表,secID、ticker至少选择一个
    :param startDate: 起始日期，输入格式为yyyymmdd,可空
    :param endDate: 结束日期，输入格式为yyyymmdd,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/HKequity/getMktHkEqudJY.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    if not isinstance(startDate, str) and not isinstance(startDate, unicode):
        startDate = str(startDate)

    requestString.append("&startDate=%s"%(startDate))
    if not isinstance(endDate, str) and not isinstance(endDate, unicode):
        endDate = str(endDate)

    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 189)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 189)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'secShortNameEN', u'tradeDate', u'preClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'turnoverValue', u'dealAmount', u'chg', u'chgPct', u'PE', u'yield', u'bidVol', u'askVol', u'bidPrice', u'askPrice', u'SMA10', u'SMA20', u'SMA50', u'SMA250', u'annualHigh', u'annulLow', u'monthHigh', u'monthLow']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','secShortNameEN': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HKFdmtBSJYGet(secID = "", ticker = "", publishDateBegin = "", publishDateEnd = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取港股上市公司资产负债表相关数据
    
    :param secID: 证券内部编码,可通过交易代码和交易市场在DataAPI.SecIDGet获取到,如'00001.XHKG',可以是列表,secID、ticker至少选择一个
    :param ticker: 交易代码,如'00001',可以是列表,secID、ticker至少选择一个
    :param publishDateBegin: 证券交易所披露的信息发布日期，起始时间，输入格式“YYYYMMDD”,可空
    :param publishDateEnd: 证券交易所披露的信息发布日期，结束时间，默认为当前日期，输入格式“YYYYMMDD”,可空
    :param beginDate: 会计期间截止日期，起始时间，输入格式“YYYYMM”,可空
    :param endDate: 会计期间截止日期，结束时间，输入格式“YYYYMM”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/HKequity/getHKFdmtBSJY.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        publishDateBegin = publishDateBegin.strftime('%Y%m%d')
    except:
        publishDateBegin = publishDateBegin.replace('-', '')
    requestString.append("&publishDateBegin=%s"%(publishDateBegin))
    try:
        publishDateEnd = publishDateEnd.strftime('%Y%m%d')
    except:
        publishDateEnd = publishDateEnd.replace('-', '')
    requestString.append("&publishDateEnd=%s"%(publishDateEnd))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1106)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1106)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'exchangeCD', u'ticker', u'secShortName', u'infoSource', u'publishDate', u'endDate', u'fiscalPeriod', u'mark', u'accoutingStandards', u'industryCategory', u'currencyCD', u'fixedAssets', u'workShopEquip', u'investProp', u'intanAssets', u'goodwill', u'landUseRight', u'CIP', u'deferTaxAssets', u'prepayment', u'LTReceiv', u'assocEquity', u'comEquity', u'subEquity', u'jointEquity', u'LTInvest', u'secInvest', u'othInvest', u'TNCA', u'inventories', u'devForSaleProp', u'AR', u'notesReceiv', u'othReceiv', u'assocReceiv', u'taxReceiv', u'STInvest', u'mortDeposit', u'cash', u'STDeposit', u'TCA', u'cashSTFun', u'deposFrOthBFIA', u'tradeBill', u'depositCard', u'owesCertiGovHK', u'clientLoanOthAcc', u'FSecInvest', u'othSecInvest', u'FAssocEquity', u'subOthEquity', u'FIntanAssets', u'FGoodWill', u'FFixedAssets', u'FInvestProp', u'FDeferTaxAssets', u'TAssets', u'TLiab', u'AP', u'notesPayable', u'taxesPayable', u'divPayable', u'assocPayableC', u'finanLeaseLiabC', u'deferIncomeST', u'othPayable', u'advanceReceipts', u'bankLoansOverdraft', u'othLoanC', u'accruedBadDebtC', u'TCL', u'NCA', u'TAssetsLessTCL', u'TAssetsLessTLiab', u'LTLoan', u'othLoanNC', u'deferTaxLiab', u'assocPayableNC', u'finanLeaseLiabNC', u'deferIncome', u'convBillBond', u'accruedBadDebtNC', u'LTPayable', u'TNCL', u'HKDollar', u'deposFrOthBFIL', u'depos', u'issuedDepositCard', u'issuedBond', u'FTaxesPayable', u'FDeferTaxLiab', u'othAccReser', u'minorityInt', u'NAssetsNFC', u'paidInCapital', u'reserve', u'stockPremium', u'holdProfit', u'reserFund', u'simAllotDiv', u'revalReser', u'forexReser', u'othReser', u'borrowCapital', u'TEquityAttrP', u'TShEquity', u'TShEquityAndTNCL', u'TShEquityAndTLiab']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','exchangeCD': 'str','ticker': 'str','secShortName': 'str','infoSource': 'str','fiscalPeriod': 'str','mark': 'str','accoutingStandards': 'str','industryCategory': 'str','currencyCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HKFdmtISJYGet(secID = "", ticker = "", publishDateBegin = "", publishDateEnd = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取港股上市公司利润表相关数据
    
    :param secID: 证券内部编码,可通过交易代码和交易市场在DataAPI.SecIDGet获取到,如'00001.XHKG',可以是列表,secID、ticker至少选择一个
    :param ticker: 交易代码,如'00001',可以是列表,secID、ticker至少选择一个
    :param publishDateBegin: 证券交易所披露的信息发布日期，起始时间，输入格式“YYYYMMDD”,可空
    :param publishDateEnd: 证券交易所披露的信息发布日期，结束时间，默认为当前日期，输入格式“YYYYMMDD”,可空
    :param beginDate: 会计期间截止日期，起始时间，输入格式“YYYYMM”,可空
    :param endDate: 会计期间截止日期，结束时间，输入格式“YYYYMM”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/HKequity/getHKFdmtISJY.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        publishDateBegin = publishDateBegin.strftime('%Y%m%d')
    except:
        publishDateBegin = publishDateBegin.replace('-', '')
    requestString.append("&publishDateBegin=%s"%(publishDateBegin))
    try:
        publishDateEnd = publishDateEnd.strftime('%Y%m%d')
    except:
        publishDateEnd = publishDateEnd.replace('-', '')
    requestString.append("&publishDateEnd=%s"%(publishDateEnd))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1107)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1107)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'exchangeCD', u'ticker', u'secShortName', u'infoSource', u'publishDate', u'endDate', u'fiscalPeriod', u'fiscalYear', u'mark', u'accoutingStandards', u'industryCategory', u'currencyCD', u'revenue', u'othOperRev', u'operRev', u'operExp', u'salesCosts', u'grossIncome', u'operProfit', u'sellExp', u'adminExp', u'devalAccBadDebt', u'revalSurplus', u'profitAssetsVend', u'depAmor', u'operateProfit', u'intIncome', u'finanCost', u'FIntIncome', u'FIntExp', u'NIntIncome', u'FOthOperRev', u'NCommisIncome', u'divIncome', u'forexIncome', u'secuexInvestIncome', u'NRentIncome', u'FOperRev', u'FOperExp', u'befPrepOperProfit', u'badDebtBudget', u'aftPrepOperProfit', u'FDevalAccBadDebt', u'FRevalSurplus', u'FProfitAssetsVend', u'FOperateProfit', u'assocProfit', u'jointProfit', u'comProfit', u'TProfit', u'tax', u'endSpecProfit', u'NIncome', u'minorityGain', u'shareHoldProfit', u'dividend', u'basicEPS', u'dilutedEPS', u'DPS']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','exchangeCD': 'str','ticker': 'str','secShortName': 'str','infoSource': 'str','fiscalPeriod': 'str','mark': 'str','accoutingStandards': 'str','industryCategory': 'str','currencyCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HKFdmtCFJYGet(secID = "", ticker = "", publishDateBegin = "", publishDateEnd = "", beginDate = "", endDate = "", field = "", pandas = "1"):
    """
    获取港股上市公司现金流量表相关数据
    
    :param secID: 证券内部编码,可通过交易代码和交易市场在DataAPI.SecIDGet获取到,如'00001.XHKG',可以是列表,secID、ticker至少选择一个
    :param ticker: 交易代码,如'00001',可以是列表,secID、ticker至少选择一个
    :param publishDateBegin: 证券交易所披露的信息发布日期，起始时间，输入格式“YYYYMMDD”,可空
    :param publishDateEnd: 证券交易所披露的信息发布日期，结束时间，默认为当前日期，输入格式“YYYYMMDD”,可空
    :param beginDate: 会计期间截止日期，起始时间，输入格式“YYYYMM”,可空
    :param endDate: 会计期间截止日期，结束时间，输入格式“YYYYMM”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/HKequity/getHKFdmtCFJY.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    try:
        publishDateBegin = publishDateBegin.strftime('%Y%m%d')
    except:
        publishDateBegin = publishDateBegin.replace('-', '')
    requestString.append("&publishDateBegin=%s"%(publishDateBegin))
    try:
        publishDateEnd = publishDateEnd.strftime('%Y%m%d')
    except:
        publishDateEnd = publishDateEnd.replace('-', '')
    requestString.append("&publishDateEnd=%s"%(publishDateEnd))
    try:
        beginDate = beginDate.strftime('%Y%m%d')
    except:
        beginDate = beginDate.replace('-', '')
    requestString.append("&beginDate=%s"%(beginDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1108)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1108)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'exchangeCD', u'ticker', u'secShortName', u'infoSource', u'publishDate', u'endDate', u'fiscalPeriod', u'fiscalYear', u'mark', u'accoutingStandards', u'industryCategory', u'currencyCD', u'befTaxProfit', u'intIncome', u'intExp', u'investIncome', u'FILProfit', u'devalAccBadDebt', u'revalSurplus', u'profitAssetsVend', u'depAmor', u'OAOI', u'OAI', u'befWorkCapProfit', u'invenDecr', u'ARDec', u'assocReceivDec', u'APInc', u'assocPayableInc', u'CFrOperate', u'receivIntOperate', u'payableIntOperate', u'payableTaxes', u'specOperate', u'AOperate', u'NCFOperateA', u'taxes', u'finanRedoundCF', u'receivIntInvest', u'receivDivInvest', u'deposDec', u'dispFixAssets', u'purFixAssets', u'dispIntanOthAssets', u'purIntanOthAssets', u'dispSub', u'purSub', u'procSellInvest', u'CPaidInvest', u'specInvest', u'AInvest', u'NCFFrInvestA', u'specBefFinan', u'NCFBefFinan', u'newLoan', u'refund', u'payableIntFinan', u'payableDivFinan', u'CFrCapContr', u'issueBond', u'issueExpRedeemSec', u'specFinan', u'AFinan', u'NCFFrFinanA', u'forexEffects', u'NChangeInCash', u'NCEBegBal', u'specPeriod', u'APeriod', u'NCEEndBal']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','exchangeCD': 'str','ticker': 'str','secShortName': 'str','infoSource': 'str','fiscalPeriod': 'str','mark': 'str','accoutingStandards': 'str','industryCategory': 'str','currencyCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HKscJYGet(secID, dirAnnoDate = "", field = "", pandas = "1"):
    """
    港股拆股并股资料，涵盖交易代码，董事会股东会相关重要日期，拆股并股方案说明，配套方案，事件进程，重组方式，合并数据，拆分数据，面值单位，旧面值，新面值，股份注销基准，注销面值，旧的交易单位，新的交易单位，已发行股份，生效后的股份，临时交易代码，临时证券简称，临时买卖单位，临时并行买卖相关日期，零碎股买卖代理人及其联系方式，零碎股买卖开始日期和结束日期
    
    :param secID: 证券内部编码，可通过交易代码和交易市场在DataAPI.SecIDGet获取到，如'00001.XHKG',可以是列表
    :param dirAnnoDate: 董事会公告日期，如'2015-01-01',可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/HKequity/getHKscJY.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    if not isinstance(dirAnnoDate, str) and not isinstance(dirAnnoDate, unicode):
        dirAnnoDate = str(dirAnnoDate)

    requestString.append("&dirAnnoDate=%s"%(dirAnnoDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'dirAnnoDate', u'dirSignDate', u'mtDate', u'cclAnnoDate', u'expAnnoDate', u'effectDate', u'schRemark', u'supplementTypeCd', u'processCd', u'refromTypeCd', u'combX', u'combY', u'splitX', u'splitY', u'currencyCd', u'parValueOld', u'parValueNew', u'wrtOffBase', u'wrtoffParValue', u'tradingUnitOld', u'tradingUnitNew', u'issueShares', u'sharesAfEffect', u'tmpTicker', u'tmpStkName', u'tmpStkTradingUnit', u'tmpDateBegin', u'parDateBegin', u'parDateEnd', u'svcAgent', u'agentTel', u'agentAdd', u'oddlotsTradeBegin', u'oddlotsTradeEnd', u'remark']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','schRemark': 'str','supplementTypeCd': 'str','processCd': 'str','refromTypeCd': 'str','currencyCd': 'str','wrtOffBase': 'str','tmpTicker': 'str','tmpStkName': 'str','svcAgent': 'str','agentTel': 'str','agentAdd': 'str','remark': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HKsstrJYGet(partyId, publishDate = "", infoSource = "", field = "", pandas = "1"):
    """
    港股股本结构资料，涵盖机构代码，信息发布日期，信息来源，普通股和优先股面值，普通股法定股本，法定股数，实收股本，实收股数，已上市股数，待上市股数和非港股股数，优先股法定股本，法定股数，实收股本，实收股数，普通股和优先股合计法定股本，法定股数，实收股本，实收股数，普通股实收变动股数，优先股实收变动股数，股本变动原因说明
    
    :param partyId: 机构ID，法人统一编码，可通过法人名称在DataAPI.PartyIDGet获取到
    :param publishDate: 信息发布日期，输入格式“YYYYMMDD”,可空
    :param infoSource: 信息来源，有‘定期报告’，‘临时公告’，‘招股章程’三种情况,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/HKequity/getHKsstrJY.csv?ispandas=1&') 
    if not isinstance(partyId, str) and not isinstance(partyId, unicode):
        partyId = str(partyId)

    requestString.append("partyId=%s"%(partyId))
    try:
        publishDate = publishDate.strftime('%Y%m%d')
    except:
        publishDate = publishDate.replace('-', '')
    requestString.append("&publishDate=%s"%(publishDate))
    if not isinstance(infoSource, str) and not isinstance(infoSource, unicode):
        infoSource = str(infoSource)

    requestString.append("&infoSource=%s"%(infoSource))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'partyId', u'publishDate', u'infoSource', u'endDate', u'cshParCurrCd', u'cshParValue', u'pshParCurrCd', u'pshParValue', u'cshAuthCap', u'cshAuthShares', u'cshPaidCap', u'cshPaidShares', u'listedShares', u'unlistedShares', u'notHKShares', u'pshAuthCap', u'pshAuthShares', u'pshPaidCap', u'pshPaidShares', u'totalAuthCap', u'totalAuthShares', u'totalPaidCap', u'totalPaidShares']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'infoSource': 'str','cshParCurrCd': 'str','pshParCurrCd': 'str','cshAuthCap': 'str','cshPaidCap': 'str','pshAuthCap': 'str','pshPaidCap': 'str','totalAuthCap': 'str','totalPaidCap': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HKbbkJYGet(secId = "", partyId = "", publishDate = "", infoSource = "", field = "", pandas = "1"):
    """
    港股股份回购资料，涵盖交易代码，机构代码，信息发布日期，信息来源，股份类别，面值单位，面值，本次回购数量，最高价，最低价，回购金额，本年累积回购数量，本年累积回购数量占总股本的比列
    
    :param secId: 证券ID，可通过交易代码和交易市场在DataAPI.SecIDGet获取到，如'00001.XHKG',可以是列表,secId、partyId至少选择一个
    :param partyId: 机构ID，法人统一编码，可通过法人名称在DataAPI.PartyIDGet获取到,secId、partyId至少选择一个
    :param publishDate: 信息发布日期，输入格式“YYYYMMDD”,可空
    :param infoSource: 信息来源，有‘股份回购报告’，‘临时公告’，‘股份购回报告’三种情况,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/HKequity/getHKbbkJY.csv?ispandas=1&') 
    requestString.append("secId=")
    if hasattr(secId,'__iter__') and not isinstance(secId, str):
        if len(secId) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secId
            requestString.append(None)
        else:
            requestString.append(','.join(secId))
    else:
        requestString.append(secId)
    if not isinstance(partyId, str) and not isinstance(partyId, unicode):
        partyId = str(partyId)

    requestString.append("&partyId=%s"%(partyId))
    try:
        publishDate = publishDate.strftime('%Y%m%d')
    except:
        publishDate = publishDate.replace('-', '')
    requestString.append("&publishDate=%s"%(publishDate))
    if not isinstance(infoSource, str) and not isinstance(infoSource, unicode):
        infoSource = str(infoSource)

    requestString.append("&infoSource=%s"%(infoSource))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secId', u'partyId', u'publishDate', u'infoSource', u'endDate', u'equTypeCd', u'equType', u'parCurrencyCd', u'parValueUnit', u'parValue', u'buyBackSum', u'highestPrice', u'lowestPrice', u'buyBackMoney', u'cumulSum', u'cumulSumToTs', u'methodComment']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secId': 'str','infoSource': 'str','equTypeCd': 'str','equType': 'str','parCurrencyCd': 'str','parValueUnit': 'str','buyBackMoney': 'str','methodComment': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HKsipoJYGet(secId, dirAnnoDate = "", field = "", pandas = "1"):
    """
    港股发行与上市资料，涵盖交易代码，首次信息发布日期，事件进程，董事会股东会相关重要日程，发行类别，发行方式，发行对象，面值，交易单位，发行价单位，承销方式，定量方式，计划发行总股数，包括配售和公开发行的新股及存量股数的资料，预计超额配售权股数，每股最低价，每股最高价，按最高价每手支付价格，预期参考价位，预计募资总额，净额超额配售所得款净额，预计发行总费用，佣金比例，发行有效期截止日，最后交易日，除权日，登记日，截止过户首日和末日，缴款截止日，发行截止日，股票发放日，退款寄放日，发行完成日，预计上市日，超额配售股权预计上市日，供股数据，发行基准及发行基准股数，实际发行总股数，占原来股份比例，占扩大后股份比例，实际发行的股份中配售和公开发售的新股和存量股数数据，每股发行价，募资总额和所得款净额，超额配售募资总额和所得款净额，公众股认购有效申请份数，全职员工，合资格股东有效申请份数，有效申请总股数，不可撤回承诺股数，认购不足股数，包销未认购股数，承配人总数及相关重要配售人配售股数
    
    :param secId: 证券内部编码，可通过交易代码和交易市场在DataAPI.SecIDGet获取到，如'00001.XHKG',可以是列表
    :param dirAnnoDate: 董事会公告日期，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/HKequity/getHKsipoJY.csv?ispandas=1&') 
    requestString.append("secId=")
    if hasattr(secId,'__iter__') and not isinstance(secId, str):
        if len(secId) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secId
            requestString.append(None)
        else:
            requestString.append(','.join(secId))
    else:
        requestString.append(secId)
    try:
        dirAnnoDate = dirAnnoDate.strftime('%Y%m%d')
    except:
        dirAnnoDate = dirAnnoDate.replace('-', '')
    requestString.append("&dirAnnoDate=%s"%(dirAnnoDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secId', u'initiInfoPubDate', u'processCd', u'dirAnnoDate', u'dirSignDate', u'mtDate', u'prospPubDate', u'contractSignDate', u'expAnnoDate', u'issueTypeCd', u'issueObjectCd', u'parCurrencyCd', u'parValue', u'tradingUnit', u'issuePrCurrencyCd', u'underwModelCd', u'rationModelCd', u'issueVolPlan', u'nshareVolPlan', u'stshareVolPlan', u'qedShAllotPlan', u'pubNsharePlan', u'pubStsharePlan', u'staffPriAllotPlan', u'oaoPlan', u'issueLowestPrice', u'issueHighestPrice', u'unitprAtCeiling', u'refPriceCd', u'proceedsPlan', u'netProceedsPlan', u'oallotPrcdPlan', u'issueCostPlan', u'commisionRatio', u'issueExpDate', u'lastTradeDate', u'exDate', u'recordDate', u'nonRegBegin', u'nonRegEnd', u'payEndDate', u'issueEndDate', u'nsharePayDate', u'refundOutDate', u'issueComplishDate', u'proposeListDate', u'oallotPrpoLdate', u'issResPubDate', u'oaoExpDate', u'offerRationX', u'offerRationY', u'issueBaseCd', u'issueBaseShares', u'issueVol', u'ratioInPrishas', u'ratioInPostshas', u'nshareVol', u'stshareAllot', u'qedShPriAllot', u'pubOfferNshare', u'pubOfferStshare', u'staffPriAllot', u'overAllotOption', u'overAllotNshare', u'overAllotStshare', u'issuePrice', u'totalProceeds', u'netProceeds', u'overAllotPrcd', u'overAllotNetPrcd', u'pubApplyUnit', u'pubApplyShares', u'pubApplyMutip', u'staffApplyUnit', u'staffApplyShares', u'staffApplyMutip', u'allotApplyUnit', u'allotApplyShares', u'allotApplyMutip', u'qedShApplyUnit', u'qedShApplyShares', u'qedShApplyMutip', u'validApplyShares', u'vapplyAllotShares', u'vapplyOallotShares', u'irbleUndertShares', u'subsRemainShares', u'underwBoughtVol', u'underwNum', u'firstUnderwAllot', u'first5UnderwAllot', u'first10UnderwAllot', u'first15UnderwAllot', u'first20UnderwAllot', u'first25UnderwAllot', u'relAllot', u'remark']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secId': 'str','processCd': 'str','issueTypeCd': 'str','issueObjectCd': 'str','parCurrencyCd': 'str','issuePrCurrencyCd': 'str','underwModelCd': 'str','rationModelCd': 'str','unitprAtCeiling': 'str','refPriceCd': 'str','proceedsPlan': 'str','netProceedsPlan': 'str','oallotPrcdPlan': 'str','issueCostPlan': 'str','issueBaseCd': 'str','totalProceeds': 'str','netProceeds': 'str','overAllotPrcd': 'str','overAllotNetPrcd': 'str','remark': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HKdivJYGet(secId, dirAnnoDate = "", field = "", pandas = "1"):
    """
    港股分红资料，涵盖交易代码，分红相关日期，财政年度，股息期间，是否分红，分红方式，每股股息，每股特别股息，送红股比例，送红利认股证比例，派实物比例，派现总额，派发基准股数，红股总股数，红利认股证总份数，分红日期安排数据，以股代息数据
    
    :param secId: 证券ID，可通过交易代码和交易市场在DataAPI.SecIDGet获取到，如'00001.XHKG',可以是列表
    :param dirAnnoDate: 董事会公告日，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/HKequity/getHKdivJY.csv?ispandas=1&') 
    requestString.append("secId=")
    if hasattr(secId,'__iter__') and not isinstance(secId, str):
        if len(secId) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secId
            requestString.append(None)
        else:
            requestString.append(','.join(secId))
    else:
        requestString.append(secId)
    try:
        dirAnnoDate = dirAnnoDate.strftime('%Y%m%d')
    except:
        dirAnnoDate = dirAnnoDate.replace('-', '')
    requestString.append("&dirAnnoDate=%s"%(dirAnnoDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secId', u'initiInfoPubDate', u'processCd', u'dirAnnoDate', u'dirSignDate', u'mtDate', u'cclAnnoDate', u'endDate', u'fiscalPeriodCd', u'fiscalYear', u'ifDiv', u'divCurrencyCd', u'dps', u'otherOptionCd', u'specialDivPs', u'specialDivSubsCd', u'shareDivRateX', u'shareDivRateY', u'wtsDivRateX', u'wtsDivRateY', u'physicalDivRateX', u'physicalDivRateY', u'remark', u'tatalCashDiv', u'divBaseCd', u'divBaseShares', u'totalShareDiv', u'totalWtsDiv', u'lastTradeDate', u'exDate', u'recodeDate', u'nonRegBegin', u'nonRegEnd', u'payDate', u'payOutDate', u'bonusShareLdate', u'scripDivIssuePr', u'scripDivPoutDate', u'scripDivListDate', u'scripDivSum']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secId': 'str','processCd': 'str','fiscalPeriodCd': 'str','ifDiv': 'str','divCurrencyCd': 'str','otherOptionCd': 'str','specialDivSubsCd': 'str','remark': 'str','tatalCashDiv': 'str','divBaseCd': 'str','scripDivIssuePr': 'str','scripDivSum': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HKagentJYGet(secId, initiInfoPubDate = "", field = "", pandas = "1"):
    """
    港股中介机构资料，涵盖交易代码，发行类别，机构类别，机构名称
    
    :param secId: 证券ID，可通过交易代码和交易市场在DataAPI.SecIDGet获取到，如'00001.XHKG',可以是列表
    :param initiInfoPubDate: 首次信息发布日期，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/HKequity/getHKagentJY.csv?ispandas=1&') 
    requestString.append("secId=")
    if hasattr(secId,'__iter__') and not isinstance(secId, str):
        if len(secId) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secId
            requestString.append(None)
        else:
            requestString.append(','.join(secId))
    else:
        requestString.append(secId)
    try:
        initiInfoPubDate = initiInfoPubDate.strftime('%Y%m%d')
    except:
        initiInfoPubDate = initiInfoPubDate.replace('-', '')
    requestString.append("&initiInfoPubDate=%s"%(initiInfoPubDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1159)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1159)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secId', u'initiInfoPubDate', u'issueTypeCd', u'agentTypeName', u'agentTypeCd', u'agentName', u'ifEffected']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secId': 'str','issueTypeCd': 'str','agentTypeName': 'str','agentTypeCd': 'str','agentName': 'str','ifEffected': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HKdequJYGet(partyId, initiInfoPubDate = "", infoSource = "", directorName = "", field = "", pandas = "1"):
    """
    港股董事权益资料，涵盖机构代码，信息来源和信息发布时间，董事名称，权益类别，权益性质，权益总数，占已发行股份比例，股份权益总数，占已发行股份比例，个人权益股数，家族权益股数，公司权益股数，其他权益股数，相关股份权益总数，占已发行股份比例，购股权权益股数，认股权证权益股数，可换股债券权益股数，其他相关权益股数
    
    :param partyId: 机构ID，法人统一编码，可通过法人名称在DataAPI.PartyIDGet获取到,可以是列表
    :param initiInfoPubDate: 信息发布日期，输入格式“YYYYMMDD”,可空
    :param infoSource: 信息来源，有‘年度报告’，‘招股章程’，‘中期报告’三种情况,可空
    :param directorName: 董事名称，如‘李嘉诚’,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/HKequity/getHKdequJY.csv?ispandas=1&') 
    requestString.append("partyId=")
    if hasattr(partyId,'__iter__') and not isinstance(partyId, str):
        if len(partyId) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = partyId
            requestString.append(None)
        else:
            requestString.append(','.join(partyId))
    else:
        requestString.append(partyId)
    try:
        initiInfoPubDate = initiInfoPubDate.strftime('%Y%m%d')
    except:
        initiInfoPubDate = initiInfoPubDate.replace('-', '')
    requestString.append("&initiInfoPubDate=%s"%(initiInfoPubDate))
    if not isinstance(infoSource, str) and not isinstance(infoSource, unicode):
        infoSource = str(infoSource)

    requestString.append("&infoSource=%s"%(infoSource))
    if not isinstance(directorName, str) and not isinstance(directorName, unicode):
        directorName = str(directorName)

    requestString.append("&directorName=%s"%(directorName))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'partyId', u'initiInfoPubDate', u'endDate', u'infoSource', u'directorName', u'equTypeCd', u'equCharacterCd', u'currencyCd', u'equStatusDesc', u'relEquStatusDesc', u'equVolume', u'equRatioInTotal', u'holdSum', u'hsInTotal', u'perInt', u'famInt', u'comInt', u'otherInt', u'relEquHoldSum', u'rehsRatioInTotal', u'stockRightEqu', u'wtsEqu', u'conbleBondEqu', u'otherRelEqu', u'remark']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'partyId': 'str','initiInfoPubDate': 'str','endDate': 'str','infoSource': 'str','directorName': 'str','equTypeCd': 'str','equCharacterCd': 'str','currencyCd': 'str','equStatusDesc': 'str','relEquStatusDesc': 'str','remark': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HKsnotJYGet(secId = "", partyId = "", noticeStart = "", noticeTypeName = "", field = "", pandas = "1"):
    """
    港股特别提示资料，公司发行上市、分红配股、公告停牌、临时停牌、召开股东大会、报告预约披露等等方面的当日提示、未来提示
    
    :param secId: 证券ID，可通过交易代码和交易市场在DataAPI.SecIDGet获取到，如'00001.XHKG',可以是列表,secId、partyId至少选择一个
    :param partyId: 机构ID，法人统一编码，可通过法人名称在DataAPI.PartyIDGet获取到,secId、partyId至少选择一个
    :param noticeStart: 提示起始日，输入格式“YYYYMMDD”,可空
    :param noticeTypeName: 提示类别名称，如‘除净日’,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/HKequity/getHKsnotJY.csv?ispandas=1&') 
    requestString.append("secId=")
    if hasattr(secId,'__iter__') and not isinstance(secId, str):
        if len(secId) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secId
            requestString.append(None)
        else:
            requestString.append(','.join(secId))
    else:
        requestString.append(secId)
    if not isinstance(partyId, str) and not isinstance(partyId, unicode):
        partyId = str(partyId)

    requestString.append("&partyId=%s"%(partyId))
    try:
        noticeStart = noticeStart.strftime('%Y%m%d')
    except:
        noticeStart = noticeStart.replace('-', '')
    requestString.append("&noticeStart=%s"%(noticeStart))
    if not isinstance(noticeTypeName, str) and not isinstance(noticeTypeName, unicode):
        noticeTypeName = str(noticeTypeName)

    requestString.append("&noticeTypeName=%s"%(noticeTypeName))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1161)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1161)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secId', u'partyId', u'secShortName', u'noticeStart', u'noticeEnd', u'startDateNotes', u'endDateNots', u'noticeTypeCd', u'noticeTypeName', u'remark']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secId': 'str','secShortName': 'str','startDateNotes': 'str','endDateNots': 'str','noticeTypeCd': 'str','noticeTypeName': 'str','remark': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HKdrcJYGet(partyId, infoSource = "", directorName = "", copName = "", initiInfoPubDate = "", field = "", pandas = "1"):
    """
    港股董事相关发团权益资料，涵盖机构代码，信息来源和信息发布时间，董事名称，法团名称，权益类别，权益性质，权益总数，占已发行股份比例，股份权益总数，占已发行股份比例，个人权益股数，家族权益股数，公司权益股数，其他权益股数，相关股份权益总数，占已发行股份比例，购股权权益股数，认股权证权益股数，可换股债券权益股数，其他相关权益股数
    
    :param partyId: 机构ID，法人统一编码，可通过法人名称在DataAPI.PartyIDGet获取到
    :param infoSource: 信息来源，包括‘年度报告’，‘招股章程’，‘中期报告’三种情况,可空
    :param directorName: 董事名称，如‘李嘉诚’,可空
    :param copName: 法团名称，如‘長江基建集團有限公司’,可空
    :param initiInfoPubDate: 信息发布日期，输入格式“YYYYMMDD”,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/HKequity/getHKdrcJY.csv?ispandas=1&') 
    if not isinstance(partyId, str) and not isinstance(partyId, unicode):
        partyId = str(partyId)

    requestString.append("partyId=%s"%(partyId))
    if not isinstance(infoSource, str) and not isinstance(infoSource, unicode):
        infoSource = str(infoSource)

    requestString.append("&infoSource=%s"%(infoSource))
    if not isinstance(directorName, str) and not isinstance(directorName, unicode):
        directorName = str(directorName)

    requestString.append("&directorName=%s"%(directorName))
    if not isinstance(copName, str) and not isinstance(copName, unicode):
        copName = str(copName)

    requestString.append("&copName=%s"%(copName))
    try:
        initiInfoPubDate = initiInfoPubDate.strftime('%Y%m%d')
    except:
        initiInfoPubDate = initiInfoPubDate.replace('-', '')
    requestString.append("&initiInfoPubDate=%s"%(initiInfoPubDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'partyId', u'initiInfoPubDate', u'endDate', u'infoSource', u'directorName', u'copName', u'equTypeCd', u'equCharacterCd', u'currencyCd', u'equVolumn', u'equRatioInTotal', u'holdSum', u'hsInTotal', u'perInt', u'famInt', u'comInt', u'otherInt', u'relEquHoldSum', u'rehsRatioInTotal', u'stockRightEqu', u'wtsEqu', u'conbleBondEqu', u'otherRelEqu', u'remark']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'infoSource': 'str','directorName': 'str','copName': 'str','equTypeCd': 'str','equCharacterCd': 'str','currencyCd': 'str','remark': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HKshequJYGet(partyId, initiInfoPubDate = "", infoSource = "", directorName = "", field = "", pandas = "1"):
    """
    港股股东权益资料，涵盖机构代码，信息来源和信息发布时间，持有人名称，持有人性质，权益类别，权益性质，权益总数，占已发行股份比例，股份权益总数，占已发行股份比例，个人权益股数，家族权益股数，公司权益股数，其他权益股数，相关股份权益总数，占已发行股份比例，购股权权益股数，认股权证权益股数，可换股债券权益股数，其他相关权益股数
    
    :param partyId: 机构ID，法人统一编码，可通过法人名称在DataAPI.PartyIDGet获取到
    :param initiInfoPubDate: 信息发布日期，输入格式“YYYYMMDD”,可空
    :param infoSource: 信息来源，包括‘年度报告’，‘招股章程’，‘中期报告’三种情况,可空
    :param directorName: 股东名称，如‘李嘉诚’,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/HKequity/getHKshequJY.csv?ispandas=1&') 
    if not isinstance(partyId, str) and not isinstance(partyId, unicode):
        partyId = str(partyId)

    requestString.append("partyId=%s"%(partyId))
    try:
        initiInfoPubDate = initiInfoPubDate.strftime('%Y%m%d')
    except:
        initiInfoPubDate = initiInfoPubDate.replace('-', '')
    requestString.append("&initiInfoPubDate=%s"%(initiInfoPubDate))
    if not isinstance(infoSource, str) and not isinstance(infoSource, unicode):
        infoSource = str(infoSource)

    requestString.append("&infoSource=%s"%(infoSource))
    if not isinstance(directorName, str) and not isinstance(directorName, unicode):
        directorName = str(directorName)

    requestString.append("&directorName=%s"%(directorName))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, -1)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, -1)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'partyId', u'initiInfoPubDate', u'endDate', u'infoSource', u'directorName', u'equTypeCd', u'equCharacterCd', u'currencyCd', u'equVolumn', u'equRatioInTotal', u'holdSum', u'hsInTotal', u'perInt', u'famInt', u'comInt', u'otherInt', u'relEquHoldSum', u'rehsRatioInTotal', u'stockRightEqu', u'wtsEqu', u'conbleBondEqu', u'otherRelEqu', u'remark']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'infoSource': 'str','directorName': 'str','equTypeCd': 'str','equCharacterCd': 'str','currencyCd': 'str','remark': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def IdxConsHkJYGet(secID = "", ticker = "", isNew = "", field = "", pandas = "1"):
    """
    获取港股市场上主要指数的成分构成情况，包括指数成分证券名称、成分证券代码、入选日期、剔除日期等。
    
    :param secID: 指数展示代码,可通过指数代码和证券类型在DataAPI.SecurityHkJYGet获取,可以是列表,secID、ticker至少选择一个
    :param ticker: 指数代码,如:HSI 恒生指数,可以是列表,secID、ticker至少选择一个
    :param isNew: 是否最新:1 是；0 否。对应DataAPI.SysCodeGet.codeTypeID=10007。,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/HKequity/getIdxConsHkJY.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&isNew=")
    if hasattr(isNew,'__iter__') and not isinstance(isNew, str):
        if len(isNew) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = isNew
            requestString.append(None)
        else:
            requestString.append(','.join(isNew))
    else:
        requestString.append(isNew)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1173)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1173)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'secShortName', u'secShortNameEn', u'ticker', u'consID', u'consShortName', u'consShortNameEn', u'consticker', u'consExchangeCD', u'intoDate', u'outDate', u'isNew', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','secShortName': 'str','secShortNameEn': 'str','ticker': 'str','consID': 'str','consShortName': 'str','consShortNameEn': 'str','consticker': 'str','consExchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def HKNewsJYGet(publishDate, secID = "", field = "", pandas = "1"):
    """
    香港动态信息资料，涵盖港股的新闻、涉及股市的评论等
    
    :param publishDate: 信息发布日期，如‘20150101’
    :param secID: 证券内部编码，可通过交易代码和交易市场在DataAPI.SecIDGet获取到，如'00001.XHKG',可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/HKequity/getHKNewsJY.csv?ispandas=1&') 
    try:
        publishDate = publishDate.strftime('%Y%m%d')
    except:
        publishDate = publishDate.replace('-', '')
    requestString.append("publishDate=%s"%(publishDate))
    requestString.append("&secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1472)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1472)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'category', u'media', u'publishDate', u'marketOpinion', u'stockOpinion', u'infoTitle', u'content', u'writer', u'author', u'conclusion', u'fcLowestPrice', u'fcHighestPrice', u'infoLevel', u'recordDate']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','category': 'str','media': 'str','marketOpinion': 'str','stockOpinion': 'str','infoTitle': 'str','content': 'str','writer': 'str','author': 'str','conclusion': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def BondInfo1JYGet(secID = "", ticker = "", typeID = "", field = "", pandas = "1"):
    """
    1.本表展现所有债券（除可转债以外）的基本要素；2.该表中的资产支持证券为人民银行监管的债券，包括ABS和MBS两种;3.数据范围涵盖自1981年至今的将近2万只债券，每日更新。
    
    :param secID: 证券内部编码，可通过交易代码和交易市场在DataAPI.SecIDGet获取到。,可以是列表,secID、ticker至少选择一个
    :param ticker: 交易代码,可以是列表,secID、ticker至少选择一个
    :param typeID: 债券分类ID。例如，0202010101-国债；0202010201-央行票据。对应DataAPI.SysCodeGet.codeTypeID=30018。,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/bond/getBondInfo1JY.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    if not isinstance(typeID, str) and not isinstance(typeID, unicode):
        typeID = str(typeID)

    requestString.append("&typeID=%s"%(typeID))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1086)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1086)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'bondID', u'secID', u'ticker', u'secShortName', u'exchangeCD', u'secFullName', u'bondForm', u'typeID', u'optionType', u'issuer', u'issuerEN', u'couponTypeCD', u'cpnFreqCD', u'paymentCD', u'coupon', u'par', u'currencyCD', u'hybridCD', u'publishDate', u'listDate', u'delistDate', u'actMaturityDate', u'firstAccrDate', u'maturityDate', u'firstRedempDate', u'minCoupon', u'frnRefRateCD', u'frnCurrBmkRate', u'frnMargin', u'issueInvNum', u'privInvNum', u'absIssuer', u'absLevelCD', u'absLevelRatio', u'absCouponCap', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'bondID': 'str','secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str','secFullName': 'str','bondForm': 'str','typeID': 'str','optionType': 'str','issuer': 'str','issuerEN': 'str','couponTypeCD': 'str','cpnFreqCD': 'str','paymentCD': 'str','currencyCD': 'str','hybridCD': 'str','frnRefRateCD': 'str','absIssuer': 'str','absLevelCD': 'str','absCouponCap': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def BondInfo2JYGet(secID = "", ticker = "", field = "", pandas = "1"):
    """
    1.包含可转换债券的评级人、担保人、债券要素、上市情况、以及发行公告中的转股和赎回信息等。2.历史数据追溯至1991年，每日更新。
    
    :param secID: 证券内部编码，可通过交易代码和交易市场在DataAPI.SecIDGet获取到。,可以是列表,secID、ticker至少选择一个
    :param ticker: 交易代码,可以是列表,secID、ticker至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/bond/getBondInfo2JY.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1087)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1087)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'bondID', u'secID', u'ticker', u'secShortName', u'exchangeCD', u'secFullName', u'guarantor', u'guarantorEN', u'couponTypeCD', u'cpnFreqCD', u'coupon', u'par', u'publishDate', u'listDate', u'delistDate', u'firstAccrDate', u'maturityDate', u'minCoupon', u'frnCurrBmkRate', u'frnMargin', u'convStkShortName', u'convCode', u'convStartDate', u'convEndDate', u'stopConvDate', u'callProt', u'callPriceEnd', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'bondID': 'str','secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str','secFullName': 'str','guarantor': 'str','guarantorEN': 'str','couponTypeCD': 'str','cpnFreqCD': 'str','convStkShortName': 'str','convCode': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def BondInfo3JYGet(secID = "", ticker = "", field = "", pandas = "1"):
    """
    1.收录由中国证监会监管的专项资产收益计划的基本资料；2.历史数据追溯至2005年，每日更新。
    
    :param secID: 证券内部编码，可通过交易代码和交易市场在DataAPI.SecIDGet获取到。,可以是列表,secID、ticker至少选择一个
    :param ticker: 交易代码,可以是列表,secID、ticker至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/bond/getBondInfo3JY.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1088)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1088)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'bondID', u'secID', u'ticker', u'secShortName', u'exchangeCD', u'secFullName', u'projectType', u'issuer', u'guarantor', u'guarantorEN', u'guarMethod', u'basicAsset', u'rating', u'par', u'cpnFreqCD', u'publishDate', u'TransferStDate', u'TransferEdDate', u'MaturityStDate', u'MaturityEndDate', u'RedemptionDate', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'bondID': 'str','secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str','secFullName': 'str','projectType': 'str','issuer': 'str','guarantor': 'str','guarantorEN': 'str','guarMethod': 'str','basicAsset': 'str','rating': 'str','cpnFreqCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def BondIssueJYGet(secID = "", ticker = "", field = "", pandas = "1"):
    """
    1.记录所有债券在不同市场上的发行和上市信息；2.同一债券若在多个市场上市，将对应多条记录；3.历史数据追溯至1995年，每日更新。
    
    :param secID: 证券内部编码，可通过交易代码和交易市场在DataAPI.SecIDGet获取到。,可以是列表,secID、ticker至少选择一个
    :param ticker: 交易代码,可以是列表,secID、ticker至少选择一个
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/bond/getBondIssueJY.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1089)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1089)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'bondID', u'secID', u'ticker', u'secShortName', u'exchangeCD', u'secFullName', u'typeID', u'bondForm', u'currencyCD', u'crossExchange', u'publishDate', u'issuePrice', u'issueDate', u'issuer', u'issuerEN', u'issuerType', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'bondID': 'str','secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str','secFullName': 'str','typeID': 'str','bondForm': 'str','currencyCD': 'str','issuer': 'str','issuerEN': 'str','issuerType': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def BondIssueProject1JYGet(issuer, field = "", pandas = "1"):
    """
    1.上市公司发行企业债、短期融资券等债券（不包括可转换债券）的发行预案信息；2.该表仅收录股东大会尚未表决或未通过的预案信息；若预案通过，则剔除；3.历史数据追溯至2000年，每日更新。
    
    :param issuer: 发行人
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/bond/getBondIssueProject1JY.csv?ispandas=1&') 
    if not isinstance(issuer, str) and not isinstance(issuer, unicode):
        issuer = str(issuer)

    requestString.append("issuer=%s"%(issuer))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1090)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1090)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'issuer', u'issuerType', u'ticker', u'secShortName', u'publishDate', u'projPubDate', u'smDeciPubDate', u'ValidStartDate', u'ValidEndDate', u'typeID', u'maturity', u'IssueSizePlan', u'ProjAltrType', u'ProjAltrRemark', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'issuer': 'str','issuerType': 'str','ticker': 'str','secShortName': 'str','typeID': 'str','ProjAltrType': 'str','ProjAltrRemark': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def BondIssueProject2JYGet(secID = "", ticker = "", issuerID = "", field = "", pandas = "1"):
    """
    1.上市公司发行可转换债券的发行预案信息；2.该表收录了所有可转换债券的发行预案信息，尚未实施的预案可以通过“实施与否”字段进行判断；3.历史数据追溯至1991年，每日更新。
    
    :param secID: 证券ID，输入发行人沪深股票证券ID。,可以是列表,secID、ticker至少选择一个
    :param ticker: 发行人股票代码，输入发行人沪深股票交易代码。,可以是列表,secID、ticker至少选择一个
    :param issuerID: 发行人ID,可以是列表,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/bond/getBondIssueProject2JY.csv?ispandas=1&') 
    requestString.append("secID=")
    if hasattr(secID,'__iter__') and not isinstance(secID, str):
        if len(secID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = secID
            requestString.append(None)
        else:
            requestString.append(','.join(secID))
    else:
        requestString.append(secID)
    requestString.append("&ticker=")
    if hasattr(ticker,'__iter__') and not isinstance(ticker, str):
        if len(ticker) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = ticker
            requestString.append(None)
        else:
            requestString.append(','.join(ticker))
    else:
        requestString.append(ticker)
    requestString.append("&issuerID=")
    if hasattr(issuerID,'__iter__') and not isinstance(issuerID, str):
        if len(issuerID) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = issuerID
            requestString.append(None)
        else:
            requestString.append(','.join(issuerID))
    else:
        requestString.append(issuerID)
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 1091)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 1091)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'issuerID', u'issuer', u'ticker', u'secShortName', u'publishDate', u'EventProcessCD', u'projPubDate', u'smDeciPubDate', u'ValidStartDate', u'ValidEndDate', u'HybridCD', u'LowerLimit', u'UpperLimit', u'ProjAltrType', u'ProjAltrRemark', u'IfImplemented', u'updateTime']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','issuer': 'str','ticker': 'str','secShortName': 'str','EventProcessCD': 'str','HybridCD': 'str','ProjAltrType': 'str','ProjAltrRemark': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktBondIdxdJYGet(indexID, startDate = "", endDate = "", field = "", pandas = "1"):
    """
    收录上证国债指数、上证企债指数、深证企债指数、新富债全指数、新富国债净价指数、新富国债全价指数、中信标普全债指数、中信标普国债指数、中信企债指数、中信银债指数、中信转债全价指数等数十只指数的盘后行情数据，包含证券内部编码,证券代码,证券简称,证券英文简称,交易市场,交易日期,昨收盘,今开盘,最高价,最低价,收盘价,成交金额,成交量,成交笔数,涨跌幅等，历史追溯至1996年，每日更新。
    
    :param indexID: 证券内部编码，一串流水号,可先通过DataAPI.SecIDGet获取到，如在DataAPI.SecIDGet，选择证券类型为'idx',输入'000012'，可获取到secID'000012.ZICN'后，在此输入'000012.ZICN'
    :param startDate: 起始日期，输入格式为yyyymmdd,可空
    :param endDate: 结束日期，输入格式为yyyymmdd,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/bond/getMktBondIdxdJY.csv?ispandas=1&') 
    if not isinstance(indexID, str) and not isinstance(indexID, unicode):
        indexID = str(indexID)

    requestString.append("indexID=%s"%(indexID))
    try:
        startDate = startDate.strftime('%Y%m%d')
    except:
        startDate = startDate.replace('-', '')
    requestString.append("&startDate=%s"%(startDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 183)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 183)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'indexID', u'ticker', u'secShortName', u'secShortNameEN', u'exchangeCD', u'tradeDate', u'preCloseIndex', u'openIndex', u'highestIndex', u'lowestIndex', u'closeIndex', u'turnoverValue', u'turnoverVol', u'dealAmount', u'chgPct']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'indexID': 'str','ticker': 'str','secShortName': 'str','secShortNameEN': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktBonddJYGet(secID, startDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含目前在交易所交易的债券（可转债、回购除外）的行情信息。 提供根据当天行情计算的净价、全价、均价、涨跌幅、振幅、换手率、到期收益率、麦氏久期、修正久期、凸度、利息回报、价格回报等数据，历史追溯至1996年，每日更新。
    
    :param secID: 证券内部编码，一串流水号,可先通过DataAPI.SecIDGet获取到
    :param startDate: 起始日期，输入格式为yyyymmdd,可空
    :param endDate: 结束日期，输入格式为yyyymmdd,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/bond/getMktBonddJY.csv?ispandas=1&') 
    if not isinstance(secID, str) and not isinstance(secID, unicode):
        secID = str(secID)

    requestString.append("secID=%s"%(secID))
    try:
        startDate = startDate.strftime('%Y%m%d')
    except:
        startDate = startDate.replace('-', '')
    requestString.append("&startDate=%s"%(startDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 182)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 182)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'secShortNameEN', u'exchangeCD', u'tradeDate', u'preCloseNetPrice', u'openNetPrice', u'hightestNetPrice', u'lowestNetPrice', u'closeNetPrice', u'aveNetPrice', u'netChg', u'netRangePct', u'turnoverRate', u'turnoverVol', u'turnoverValue', u'dealAmount', u'preClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'close', u'avePrice', u'chg', u'rangePct', u'YRM', u'YTMOpen', u'dOpen', u'mdOpen', u'convxOpen', u'YTMHigh', u'dHigh', u'mdHigh', u'convxHigh', u'YTMLow', u'dLow', u'mdLow', u'convxLow', u'YTMClose', u'dClose', u'mdClose', u'convxClose', u'YTMAvg', u'dAvg', u'mdAvg', u'convxAvg', u'intReturn', u'priceReturn', u'tReturn']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','secShortNameEN': 'str','exchangeCD': 'str','YRM': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktConBonddJYGet(secID, startDate = "", endDate = "", field = "", pandas = "1"):
    """
    包含所有可转换债券的行情、成交情况、基础股票收盘价等，并提供根据当天行情计算的转股溢价率、转换平价等。2008-10-13日起，上交所的可分离可转债为净价交易，每日更新。
    
    :param secID: 证券内部编码，一串流水号,可先通过DataAPI.SecIDGet获取到，如在DataAPI.SecIDGet，选择证券类型为'B',输入'125002'，可获取到secID'125002.XSHE'后，在此输入'125002.XSHE'
    :param startDate: 起始日期，输入格式为yyyymmdd,可空
    :param endDate: 结束日期，输入格式为yyyymmdd,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/bond/getMktConBonddJY.csv?ispandas=1&') 
    if not isinstance(secID, str) and not isinstance(secID, unicode):
        secID = str(secID)

    requestString.append("secID=%s"%(secID))
    try:
        startDate = startDate.strftime('%Y%m%d')
    except:
        startDate = startDate.replace('-', '')
    requestString.append("&startDate=%s"%(startDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None:
            split_index = len(requestString)
            split_param = field
            requestString.append(None)
        else:
            requestString.append(','.join(field))
    else:
        requestString.append(field)
    if split_param is None:
        csvString = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
        if csvString is None or len(csvString) == 0 or (csvString[0] == '-' and not api_base.is_no_data_warn(csvString, False)) or csvString[0] == '{':
            api_base.handle_error(csvString, 184)
        elif csvString[:2] == '-1':
            csvString = ''
    else:
        p_list = api_base.splist(split_param, 100)
        csvString = []
        for index, item in enumerate(p_list):
            requestString[split_index] = ','.join(item)
            temp_result = api_base.__getCSV__(''.join(requestString), httpClient, gw=True)
            if temp_result is None or len(temp_result) == 0 or temp_result[0] == '{' or (temp_result[0] == '-' and not api_base.is_no_data_warn(temp_result, False)):
                api_base.handle_error(temp_result, 184)
            if temp_result[:2] != '-1':
                csvString.append(temp_result if len(csvString) == 0 else temp_result[temp_result.find('\n')+1:])
        csvString = ''.join(csvString)

    if len(csvString) == 0:
        if 'field' not in locals() or len(field) == 0:
            field = [u'secID', u'ticker', u'secShortName', u'exchangeCD', u'tradeDate', u'preClosePrice', u'openPrice', u'highestPrice', u'lowestPrice', u'closePrice', u'turnoverVol', u'turnovervalue', u'dealAmount']
        if hasattr(field, '__iter__') and not isinstance(field, str):
            csvString = ','.join(field) + '\n'
        else:
            csvString = field + '\n'
    if pandas != "1":
        put_data_in_cache(func_name, cache_key, csvString)
        return csvString
    try:
        myIO = StringIO(csvString)
        pdFrame = pd.read_csv(myIO, dtype = {'secID': 'str','ticker': 'str','secShortName': 'str','exchangeCD': 'str'},  )
        put_data_in_cache(func_name, cache_key, pdFrame)
        return pdFrame
    except Exception as e:
        raise e
    finally:
        myIO.close()

def MktRepodJYGet(secID, startDate = "", endDate = "", repoType = "", field = "", pandas = "1"):
    """
    收录每个交易日，上海交易所、深圳交易所以及银行间市场上，所有债券回购的盘后行情数据，包含交易市场,回购类型,交易日期,昨收盘,开盘价,最高价,最低价,收盘价,加权价,成交量,成交金额,成交笔数等，历史追溯至1994年，每日更新。
    
    :param secID: 证券内部编码，一串流水号,可先通过DataAPI.SecIDGet获取到，如在DataAPI.SecIDGet，选择证券类型为'repo',输入'131800'，可获取到secID'131800.XSHE'后，在此输入'131800.XSHE'
    :param startDate: 起始日期，输入格式为yyyymmdd,可空
    :param endDate: 结束日期，输入格式为yyyymmdd,可空
    :param repoType: 回购类型，01为质押式回购，02为买断式回购，0101为质押式企债回购，0102为质押式国债回购,可空
    :param field: 所需字段,可以是列表,可空
    :param pandas: 1表示返回 pandas data frame，0表示返回csv,可空
    :return: :raise e: API查询的结果，是CSV或者被转成pandas data frame；若查询API失败，返回空data frame； 若解析失败，则抛出异常
    """
        
    pretty_traceback()
    frame = inspect.currentframe()
    func_name, cache_key = get_cache_key(frame)
    cache_result = get_data_from_cache(func_name, cache_key)
    if cache_result is not None:
        return cache_result
    split_index = None
    split_param = None
    httpClient = api_base.__getConn__()    
    requestString = []
    requestString.append('/api/bond/getMktRepodJY.csv?ispandas=1&') 
    if not isinstance(secID, str) and not isinstance(secID, unicode):
        secID = str(secID)

    requestString.append("secID=%s"%(secID))
    try:
        startDate = startDate.strftime('%Y%m%d')
    except:
        startDate = startDate.replace('-', '')
    requestString.append("&startDate=%s"%(startDate))
    try:
        endDate = endDate.strftime('%Y%m%d')
    except:
        endDate = endDate.replace('-', '')
    requestString.append("&endDate=%s"%(endDate))
    if not isinstance(repoType, str) and not isinstance(repoType, unicode):
        repoType = str(repoType)

    requestString.append("&repoType=%s"%(repoType))
    requestString.append("&field=")
    if hasattr(field,'__iter__') and not isinstance(field, str):
        if len(field) > 100 and split_param is None: