# coding: utf-8

"""
    Toast API

    ## Authentication API  The authentication API returns an authentication token that you can present when your integration client software uses other Toast APIs. For more information about authentication, see [the Toast Developer Guide](https://doc.toasttab.com/doc/devguide/authentication.html).  ## Menus API  Returns information about a restaurant's menus.  _Important:_ Ordering integrations should use menus API V3. Other integration types should continue to use menus API V2 until further notice. See <a href=\"https://doc.toasttab.com/doc/devguide/apiComparingMenusAPIV2AndV3.html\">Comparing menus API V2 and V3</a> for more information.  ## Orders API  The orders API includes operations that create, update, and retrieve information about restaurant guest orders.  Information on orders includes the checks, items ordered, prices, payments, discounts, and customer data.  You can create a new order. The orders API includes an operation to retrieve the order prices before you `POST` the order.  You can add items to an existing check.  The orders API also allows you to retrieve payment information for the order and add a credit card payment to the order. You cannot update an existing payment, but you can update the tip amount.  For delivery orders, you can update the delivery information.  You can retrieve the applicable discounts for an order, and then add a discount to a menu item selection or a check.  The orders API supports email addresses that:    - Are up to 53 characters long.    - Start with the email prefix, ends with the email domain name, where the prefix and domain are separated by an @.    - Use the following supported characters:     - a-z     - A-Z     - 0-9     - _ (underscore)     - International characters are not supported  ## Labor API  Toast labor API is a set of REST web services that you can use to  manage the employees, jobs, and shifts for your restaurant. The  labor API is intended for software engineers, managers, and  technical staff who are responsible for integrating third-party  systems with the Toast platform. ## Restaurants API  Returns information about the configuration of restaurant.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictStr
from typing import List, Optional
from typing_extensions import Annotated
from toastapi.models.employee import Employee

from toastapi.api_client import ApiClient, RequestSerialized
from toastapi.api_response import ApiResponse
from toastapi.rest import RESTResponseType


class EmployeesApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    async def employees_employee_id_delete(
        self,
        toast_restaurant_external_id: Annotated[StrictStr, Field(description="The Toast platform GUID of the restaurant that is the  context for this operation. ")],
        employee_id: Annotated[StrictStr, Field(description="The Toast platform GUID or external identifier for the  employee to be deleted. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Employee:
        """Delete an employee

        Deletes a restaurant employee record by marking the record as  deleted. A deleted employee cannot log in at the restaurant or  open new time entries.  If you `GET` an employee record that has been deleted, its  `deleted` value is `true` and its `deletedDate` value contains  the date and time the record was deleted.   If you delete an employee that has already been deleted then  the result is successful (200) and no change is made.  The deleted record appears in the list of deleted employees for  the restaurant in Toast Web. From the  list of deleted employees, you can enable a deleted record so  that the employee can use it again. Information about deleted  employees remains available in reports.  You cannot delete employees who have open time entries (time  entries that do not have an out date value). 

        :param toast_restaurant_external_id: The Toast platform GUID of the restaurant that is the  context for this operation.  (required)
        :type toast_restaurant_external_id: str
        :param employee_id: The Toast platform GUID or external identifier for the  employee to be deleted.  (required)
        :type employee_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._employees_employee_id_delete_serialize(
            toast_restaurant_external_id=toast_restaurant_external_id,
            employee_id=employee_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Employee",
            '400': None,
            '404': None,
            '500': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def employees_employee_id_delete_with_http_info(
        self,
        toast_restaurant_external_id: Annotated[StrictStr, Field(description="The Toast platform GUID of the restaurant that is the  context for this operation. ")],
        employee_id: Annotated[StrictStr, Field(description="The Toast platform GUID or external identifier for the  employee to be deleted. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[Employee]:
        """Delete an employee

        Deletes a restaurant employee record by marking the record as  deleted. A deleted employee cannot log in at the restaurant or  open new time entries.  If you `GET` an employee record that has been deleted, its  `deleted` value is `true` and its `deletedDate` value contains  the date and time the record was deleted.   If you delete an employee that has already been deleted then  the result is successful (200) and no change is made.  The deleted record appears in the list of deleted employees for  the restaurant in Toast Web. From the  list of deleted employees, you can enable a deleted record so  that the employee can use it again. Information about deleted  employees remains available in reports.  You cannot delete employees who have open time entries (time  entries that do not have an out date value). 

        :param toast_restaurant_external_id: The Toast platform GUID of the restaurant that is the  context for this operation.  (required)
        :type toast_restaurant_external_id: str
        :param employee_id: The Toast platform GUID or external identifier for the  employee to be deleted.  (required)
        :type employee_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._employees_employee_id_delete_serialize(
            toast_restaurant_external_id=toast_restaurant_external_id,
            employee_id=employee_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Employee",
            '400': None,
            '404': None,
            '500': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def employees_employee_id_delete_without_preload_content(
        self,
        toast_restaurant_external_id: Annotated[StrictStr, Field(description="The Toast platform GUID of the restaurant that is the  context for this operation. ")],
        employee_id: Annotated[StrictStr, Field(description="The Toast platform GUID or external identifier for the  employee to be deleted. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Delete an employee

        Deletes a restaurant employee record by marking the record as  deleted. A deleted employee cannot log in at the restaurant or  open new time entries.  If you `GET` an employee record that has been deleted, its  `deleted` value is `true` and its `deletedDate` value contains  the date and time the record was deleted.   If you delete an employee that has already been deleted then  the result is successful (200) and no change is made.  The deleted record appears in the list of deleted employees for  the restaurant in Toast Web. From the  list of deleted employees, you can enable a deleted record so  that the employee can use it again. Information about deleted  employees remains available in reports.  You cannot delete employees who have open time entries (time  entries that do not have an out date value). 

        :param toast_restaurant_external_id: The Toast platform GUID of the restaurant that is the  context for this operation.  (required)
        :type toast_restaurant_external_id: str
        :param employee_id: The Toast platform GUID or external identifier for the  employee to be deleted.  (required)
        :type employee_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._employees_employee_id_delete_serialize(
            toast_restaurant_external_id=toast_restaurant_external_id,
            employee_id=employee_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Employee",
            '400': None,
            '404': None,
            '500': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _employees_employee_id_delete_serialize(
        self,
        toast_restaurant_external_id,
        employee_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if employee_id is not None:
            _path_params['employeeId'] = employee_id
        # process the query parameters
        # process the header parameters
        if toast_restaurant_external_id is not None:
            _header_params['Toast-Restaurant-External-ID'] = toast_restaurant_external_id
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'oauth2'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/labor/v1/employees/{employeeId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def employees_employee_id_external_id_post(
        self,
        employee_id: Annotated[StrictStr, Field(description="The Toast platform GUID of the employee record. ")],
        toast_restaurant_external_id: Annotated[StrictStr, Field(description="The Toast platform GUID of the restaurant that is the  context for this operation. ")],
        content_type: Annotated[StrictStr, Field(description="The Internet Assigned Numbers Authority (IANA) media type  of the message body data. The value must be  `application/json`. ")],
        body: Annotated[StrictStr, Field(description="The JSON string value of the `externalId` for the employee  record. Wrap the value in double quotation marks to make it  valid JSON syntax. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Employee:
        """Add an external identifier

        Adds an external identifier for an existing employee. Include  the string value of the new external identifier in the message  body.  You cannot change an existing external identifier with another  `POST` request; use `PUT` instead. The Toast platform uses this  external identifier as one of the unique, persistent  identifiers for an employee record. 

        :param employee_id: The Toast platform GUID of the employee record.  (required)
        :type employee_id: str
        :param toast_restaurant_external_id: The Toast platform GUID of the restaurant that is the  context for this operation.  (required)
        :type toast_restaurant_external_id: str
        :param content_type: The Internet Assigned Numbers Authority (IANA) media type  of the message body data. The value must be  `application/json`.  (required)
        :type content_type: str
        :param body: The JSON string value of the `externalId` for the employee  record. Wrap the value in double quotation marks to make it  valid JSON syntax.  (required)
        :type body: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._employees_employee_id_external_id_post_serialize(
            employee_id=employee_id,
            toast_restaurant_external_id=toast_restaurant_external_id,
            content_type=content_type,
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Employee",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def employees_employee_id_external_id_post_with_http_info(
        self,
        employee_id: Annotated[StrictStr, Field(description="The Toast platform GUID of the employee record. ")],
        toast_restaurant_external_id: Annotated[StrictStr, Field(description="The Toast platform GUID of the restaurant that is the  context for this operation. ")],
        content_type: Annotated[StrictStr, Field(description="The Internet Assigned Numbers Authority (IANA) media type  of the message body data. The value must be  `application/json`. ")],
        body: Annotated[StrictStr, Field(description="The JSON string value of the `externalId` for the employee  record. Wrap the value in double quotation marks to make it  valid JSON syntax. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[Employee]:
        """Add an external identifier

        Adds an external identifier for an existing employee. Include  the string value of the new external identifier in the message  body.  You cannot change an existing external identifier with another  `POST` request; use `PUT` instead. The Toast platform uses this  external identifier as one of the unique, persistent  identifiers for an employee record. 

        :param employee_id: The Toast platform GUID of the employee record.  (required)
        :type employee_id: str
        :param toast_restaurant_external_id: The Toast platform GUID of the restaurant that is the  context for this operation.  (required)
        :type toast_restaurant_external_id: str
        :param content_type: The Internet Assigned Numbers Authority (IANA) media type  of the message body data. The value must be  `application/json`.  (required)
        :type content_type: str
        :param body: The JSON string value of the `externalId` for the employee  record. Wrap the value in double quotation marks to make it  valid JSON syntax.  (required)
        :type body: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._employees_employee_id_external_id_post_serialize(
            employee_id=employee_id,
            toast_restaurant_external_id=toast_restaurant_external_id,
            content_type=content_type,
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Employee",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def employees_employee_id_external_id_post_without_preload_content(
        self,
        employee_id: Annotated[StrictStr, Field(description="The Toast platform GUID of the employee record. ")],
        toast_restaurant_external_id: Annotated[StrictStr, Field(description="The Toast platform GUID of the restaurant that is the  context for this operation. ")],
        content_type: Annotated[StrictStr, Field(description="The Internet Assigned Numbers Authority (IANA) media type  of the message body data. The value must be  `application/json`. ")],
        body: Annotated[StrictStr, Field(description="The JSON string value of the `externalId` for the employee  record. Wrap the value in double quotation marks to make it  valid JSON syntax. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Add an external identifier

        Adds an external identifier for an existing employee. Include  the string value of the new external identifier in the message  body.  You cannot change an existing external identifier with another  `POST` request; use `PUT` instead. The Toast platform uses this  external identifier as one of the unique, persistent  identifiers for an employee record. 

        :param employee_id: The Toast platform GUID of the employee record.  (required)
        :type employee_id: str
        :param toast_restaurant_external_id: The Toast platform GUID of the restaurant that is the  context for this operation.  (required)
        :type toast_restaurant_external_id: str
        :param content_type: The Internet Assigned Numbers Authority (IANA) media type  of the message body data. The value must be  `application/json`.  (required)
        :type content_type: str
        :param body: The JSON string value of the `externalId` for the employee  record. Wrap the value in double quotation marks to make it  valid JSON syntax.  (required)
        :type body: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._employees_employee_id_external_id_post_serialize(
            employee_id=employee_id,
            toast_restaurant_external_id=toast_restaurant_external_id,
            content_type=content_type,
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Employee",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _employees_employee_id_external_id_post_serialize(
        self,
        employee_id,
        toast_restaurant_external_id,
        content_type,
        body,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if employee_id is not None:
            _path_params['employeeId'] = employee_id
        # process the query parameters
        # process the header parameters
        if toast_restaurant_external_id is not None:
            _header_params['Toast-Restaurant-External-ID'] = toast_restaurant_external_id
        if content_type is not None:
            _header_params['Content-Type'] = content_type
        # process the form parameters
        # process the body parameter
        if body is not None:
            _body_params = body


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'oauth2'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/labor/v1/employees/{employeeId}/externalId',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def employees_employee_id_external_id_put(
        self,
        employee_id: Annotated[StrictStr, Field(description="The Toast platform GUID of the employee record. ")],
        toast_restaurant_external_id: Annotated[StrictStr, Field(description="The Toast platform GUID of the restaurant that is the  context for this operation. ")],
        content_type: Annotated[StrictStr, Field(description="The Internet Assigned Numbers Authority (IANA) media type  of the message body data. The value must be  `application/json`. ")],
        body: Annotated[StrictStr, Field(description="The JSON string value of the `externalId` for the employee  record. Wrap the value in double quotation marks to make it  valid JSON syntax. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Employee:
        """Add or replace an external identifier

        Adds or replaces the external identifier for an existing employee. Include the string value of the new external identifier in the message body.  The Toast platform uses this external identifier as one of the  unique, persistent identifiers for an employee record.  _Changing the external identifier for an existing employee  might affect reporting and other Toast platform functions that  select employees using the `externalId` value._ 

        :param employee_id: The Toast platform GUID of the employee record.  (required)
        :type employee_id: str
        :param toast_restaurant_external_id: The Toast platform GUID of the restaurant that is the  context for this operation.  (required)
        :type toast_restaurant_external_id: str
        :param content_type: The Internet Assigned Numbers Authority (IANA) media type  of the message body data. The value must be  `application/json`.  (required)
        :type content_type: str
        :param body: The JSON string value of the `externalId` for the employee  record. Wrap the value in double quotation marks to make it  valid JSON syntax.  (required)
        :type body: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._employees_employee_id_external_id_put_serialize(
            employee_id=employee_id,
            toast_restaurant_external_id=toast_restaurant_external_id,
            content_type=content_type,
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Employee",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def employees_employee_id_external_id_put_with_http_info(
        self,
        employee_id: Annotated[StrictStr, Field(description="The Toast platform GUID of the employee record. ")],
        toast_restaurant_external_id: Annotated[StrictStr, Field(description="The Toast platform GUID of the restaurant that is the  context for this operation. ")],
        content_type: Annotated[StrictStr, Field(description="The Internet Assigned Numbers Authority (IANA) media type  of the message body data. The value must be  `application/json`. ")],
        body: Annotated[StrictStr, Field(description="The JSON string value of the `externalId` for the employee  record. Wrap the value in double quotation marks to make it  valid JSON syntax. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[Employee]:
        """Add or replace an external identifier

        Adds or replaces the external identifier for an existing employee. Include the string value of the new external identifier in the message body.  The Toast platform uses this external identifier as one of the  unique, persistent identifiers for an employee record.  _Changing the external identifier for an existing employee  might affect reporting and other Toast platform functions that  select employees using the `externalId` value._ 

        :param employee_id: The Toast platform GUID of the employee record.  (required)
        :type employee_id: str
        :param toast_restaurant_external_id: The Toast platform GUID of the restaurant that is the  context for this operation.  (required)
        :type toast_restaurant_external_id: str
        :param content_type: The Internet Assigned Numbers Authority (IANA) media type  of the message body data. The value must be  `application/json`.  (required)
        :type content_type: str
        :param body: The JSON string value of the `externalId` for the employee  record. Wrap the value in double quotation marks to make it  valid JSON syntax.  (required)
        :type body: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._employees_employee_id_external_id_put_serialize(
            employee_id=employee_id,
            toast_restaurant_external_id=toast_restaurant_external_id,
            content_type=content_type,
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Employee",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def employees_employee_id_external_id_put_without_preload_content(
        self,
        employee_id: Annotated[StrictStr, Field(description="The Toast platform GUID of the employee record. ")],
        toast_restaurant_external_id: Annotated[StrictStr, Field(description="The Toast platform GUID of the restaurant that is the  context for this operation. ")],
        content_type: Annotated[StrictStr, Field(description="The Internet Assigned Numbers Authority (IANA) media type  of the message body data. The value must be  `application/json`. ")],
        body: Annotated[StrictStr, Field(description="The JSON string value of the `externalId` for the employee  record. Wrap the value in double quotation marks to make it  valid JSON syntax. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Add or replace an external identifier

        Adds or replaces the external identifier for an existing employee. Include the string value of the new external identifier in the message body.  The Toast platform uses this external identifier as one of the  unique, persistent identifiers for an employee record.  _Changing the external identifier for an existing employee  might affect reporting and other Toast platform functions that  select employees using the `externalId` value._ 

        :param employee_id: The Toast platform GUID of the employee record.  (required)
        :type employee_id: str
        :param toast_restaurant_external_id: The Toast platform GUID of the restaurant that is the  context for this operation.  (required)
        :type toast_restaurant_external_id: str
        :param content_type: The Internet Assigned Numbers Authority (IANA) media type  of the message body data. The value must be  `application/json`.  (required)
        :type content_type: str
        :param body: The JSON string value of the `externalId` for the employee  record. Wrap the value in double quotation marks to make it  valid JSON syntax.  (required)
        :type body: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._employees_employee_id_external_id_put_serialize(
            employee_id=employee_id,
            toast_restaurant_external_id=toast_restaurant_external_id,
            content_type=content_type,
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Employee",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _employees_employee_id_external_id_put_serialize(
        self,
        employee_id,
        toast_restaurant_external_id,
        content_type,
        body,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if employee_id is not None:
            _path_params['employeeId'] = employee_id
        # process the query parameters
        # process the header parameters
        if toast_restaurant_external_id is not None:
            _header_params['Toast-Restaurant-External-ID'] = toast_restaurant_external_id
        if content_type is not None:
            _header_params['Content-Type'] = content_type
        # process the form parameters
        # process the body parameter
        if body is not None:
            _body_params = body


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'oauth2'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/labor/v1/employees/{employeeId}/externalId',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def employees_employee_id_get(
        self,
        toast_restaurant_external_id: Annotated[StrictStr, Field(description="The Toast platform GUID of the restaurant that is the  context for this operation. ")],
        employee_id: Annotated[StrictStr, Field(description="The Toast platform GUID or external identifier for the  employee to be returned. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Employee:
        """Get information about one employee

        Returns an `Employee` object containing information about one  restaurant employee. 

        :param toast_restaurant_external_id: The Toast platform GUID of the restaurant that is the  context for this operation.  (required)
        :type toast_restaurant_external_id: str
        :param employee_id: The Toast platform GUID or external identifier for the  employee to be returned.  (required)
        :type employee_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._employees_employee_id_get_serialize(
            toast_restaurant_external_id=toast_restaurant_external_id,
            employee_id=employee_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Employee",
            '400': None,
            '404': None,
            '500': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def employees_employee_id_get_with_http_info(
        self,
        toast_restaurant_external_id: Annotated[StrictStr, Field(description="The Toast platform GUID of the restaurant that is the  context for this operation. ")],
        employee_id: Annotated[StrictStr, Field(description="The Toast platform GUID or external identifier for the  employee to be returned. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[Employee]:
        """Get information about one employee

        Returns an `Employee` object containing information about one  restaurant employee. 

        :param toast_restaurant_external_id: The Toast platform GUID of the restaurant that is the  context for this operation.  (required)
        :type toast_restaurant_external_id: str
        :param employee_id: The Toast platform GUID or external identifier for the  employee to be returned.  (required)
        :type employee_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._employees_employee_id_get_serialize(
            toast_restaurant_external_id=toast_restaurant_external_id,
            employee_id=employee_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Employee",
            '400': None,
            '404': None,
            '500': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def employees_employee_id_get_without_preload_content(
        self,
        toast_restaurant_external_id: Annotated[StrictStr, Field(description="The Toast platform GUID of the restaurant that is the  context for this operation. ")],
        employee_id: Annotated[StrictStr, Field(description="The Toast platform GUID or external identifier for the  employee to be returned. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get information about one employee

        Returns an `Employee` object containing information about one  restaurant employee. 

        :param toast_restaurant_external_id: The Toast platform GUID of the restaurant that is the  context for this operation.  (required)
        :type toast_restaurant_external_id: str
        :param employee_id: The Toast platform GUID or external identifier for the  employee to be returned.  (required)
        :type employee_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._employees_employee_id_get_serialize(
            toast_restaurant_external_id=toast_restaurant_external_id,
            employee_id=employee_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Employee",
            '400': None,
            '404': None,
            '500': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _employees_employee_id_get_serialize(
        self,
        toast_restaurant_external_id,
        employee_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if employee_id is not None:
            _path_params['employeeId'] = employee_id
        # process the query parameters
        # process the header parameters
        if toast_restaurant_external_id is not None:
            _header_params['Toast-Restaurant-External-ID'] = toast_restaurant_external_id
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'oauth2'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/labor/v1/employees/{employeeId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def employees_employee_id_jobs_put(
        self,
        employee_id: Annotated[StrictStr, Field(description="The Toast platform GUID of the employee record. ")],
        toast_restaurant_external_id: Annotated[StrictStr, Field(description="The Toast platform GUID of the restaurant that is the  context for this operation. ")],
        content_type: Annotated[StrictStr, Field(description="The Internet Assigned Numbers Authority (IANA) media type  of the message body data. The value must be  `application/json`. ")],
        body: Annotated[StrictStr, Field(description="An array of JSON objects containing identifiers for jobs.  The identifiers can be either Toast platform GUIDs or  external identifiers. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Employee:
        """Replace a jobs list

        Replaces the list of jobs for an employee. Include a JSON   array of job identifiers in the message body.  If a job is defined at the restaurant group or subgroup level,  this operation adds or removes that job for the the employee at  _all restaurant locations_ in the group or subgroup. 

        :param employee_id: The Toast platform GUID of the employee record.  (required)
        :type employee_id: str
        :param toast_restaurant_external_id: The Toast platform GUID of the restaurant that is the  context for this operation.  (required)
        :type toast_restaurant_external_id: str
        :param content_type: The Internet Assigned Numbers Authority (IANA) media type  of the message body data. The value must be  `application/json`.  (required)
        :type content_type: str
        :param body: An array of JSON objects containing identifiers for jobs.  The identifiers can be either Toast platform GUIDs or  external identifiers.  (required)
        :type body: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._employees_employee_id_jobs_put_serialize(
            employee_id=employee_id,
            toast_restaurant_external_id=toast_restaurant_external_id,
            content_type=content_type,
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Employee",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def employees_employee_id_jobs_put_with_http_info(
        self,
        employee_id: Annotated[StrictStr, Field(description="The Toast platform GUID of the employee record. ")],
        toast_restaurant_external_id: Annotated[StrictStr, Field(description="The Toast platform GUID of the restaurant that is the  context for this operation. ")],
        content_type: Annotated[StrictStr, Field(description="The Internet Assigned Numbers Authority (IANA) media type  of the message body data. The value must be  `application/json`. ")],
        body: Annotated[StrictStr, Field(description="An array of JSON objects containing identifiers for jobs.  The identifiers can be either Toast platform GUIDs or  external identifiers. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[Employee]:
        """Replace a jobs list

        Replaces the list of jobs for an employee. Include a JSON   array of job identifiers in the message body.  If a job is defined at the restaurant group or subgroup level,  this operation adds or removes that job for the the employee at  _all restaurant locations_ in the group or subgroup. 

        :param employee_id: The Toast platform GUID of the employee record.  (required)
        :type employee_id: str
        :param toast_restaurant_external_id: The Toast platform GUID of the restaurant that is the  context for this operation.  (required)
        :type toast_restaurant_external_id: str
        :param content_type: The Internet Assigned Numbers Authority (IANA) media type  of the message body data. The value must be  `application/json`.  (required)
        :type content_type: str
        :param body: An array of JSON objects containing identifiers for jobs.  The identifiers can be either Toast platform GUIDs or  external identifiers.  (required)
        :type body: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._employees_employee_id_jobs_put_serialize(
            employee_id=employee_id,
            toast_restaurant_external_id=toast_restaurant_external_id,
            content_type=content_type,
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Employee",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def employees_employee_id_jobs_put_without_preload_content(
        self,
        employee_id: Annotated[StrictStr, Field(description="The Toast platform GUID of the employee record. ")],
        toast_restaurant_external_id: Annotated[StrictStr, Field(description="The Toast platform GUID of the restaurant that is the  context for this operation. ")],
        content_type: Annotated[StrictStr, Field(description="The Internet Assigned Numbers Authority (IANA) media type  of the message body data. The value must be  `application/json`. ")],
        body: Annotated[StrictStr, Field(description="An array of JSON objects containing identifiers for jobs.  The identifiers can be either Toast platform GUIDs or  external identifiers. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Replace a jobs list

        Replaces the list of jobs for an employee. Include a JSON   array of job identifiers in the message body.  If a job is defined at the restaurant group or subgroup level,  this operation adds or removes that job for the the employee at  _all restaurant locations_ in the group or subgroup. 

        :param employee_id: The Toast platform GUID of the employee record.  (required)
        :type employee_id: str
        :param toast_restaurant_external_id: The Toast platform GUID of the restaurant that is the  context for this operation.  (required)
        :type toast_restaurant_external_id: str
        :param content_type: The Internet Assigned Numbers Authority (IANA) media type  of the message body data. The value must be  `application/json`.  (required)
        :type content_type: str
        :param body: An array of JSON objects containing identifiers for jobs.  The identifiers can be either Toast platform GUIDs or  external identifiers.  (required)
        :type body: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._employees_employee_id_jobs_put_serialize(
            employee_id=employee_id,
            toast_restaurant_external_id=toast_restaurant_external_id,
            content_type=content_type,
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Employee",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _employees_employee_id_jobs_put_serialize(
        self,
        employee_id,
        toast_restaurant_external_id,
        content_type,
        body,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if employee_id is not None:
            _path_params['employeeId'] = employee_id
        # process the query parameters
        # process the header parameters
        if toast_restaurant_external_id is not None:
            _header_params['Toast-Restaurant-External-ID'] = toast_restaurant_external_id
        if content_type is not None:
            _header_params['Content-Type'] = content_type
        # process the form parameters
        # process the body parameter
        if body is not None:
            _body_params = body


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'oauth2'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/labor/v1/employees/{employeeId}/jobs',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def employees_employee_id_patch(
        self,
        toast_restaurant_external_id: Annotated[StrictStr, Field(description="The Toast platform GUID of the restaurant that is the  context for this operation. ")],
        content_type: Annotated[StrictStr, Field(description="The Internet Assigned Numbers Authority (IANA) media type  of the message body data. The value must be  `application/json`. ")],
        employee_id: Annotated[StrictStr, Field(description="The Toast platform GUID or external identifier for the  employee to be returned. ")],
        body: Annotated[StrictStr, Field(description="A JSON object containing the employee information that you  are updating. You can update an employee's:  * `firstName` - First name.  * `chosenName` - Chosen name.  * `lastName` - Last name.  * `externalEmployeeId` - External employee identifier.  * `passcode` - The passcode for access to Toast POS devices.  All values are optional. You must include at least one  value. Each value that you include must contain information  (not null). If you include the `passcode` value to update  an employee's passcode you must include the employee's  current passcode in the `currentPasscode` value. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Employee:
        """Update employee information

        Updates the first name, chosen name, last name, external employee ID, and/or  passcode of a restaurant employee. The `PATCH` operation cannot  update any other employee information. 

        :param toast_restaurant_external_id: The Toast platform GUID of the restaurant that is the  context for this operation.  (required)
        :type toast_restaurant_external_id: str
        :param content_type: The Internet Assigned Numbers Authority (IANA) media type  of the message body data. The value must be  `application/json`.  (required)
        :type content_type: str
        :param employee_id: The Toast platform GUID or external identifier for the  employee to be returned.  (required)
        :type employee_id: str
        :param body: A JSON object containing the employee information that you  are updating. You can update an employee's:  * `firstName` - First name.  * `chosenName` - Chosen name.  * `lastName` - Last name.  * `externalEmployeeId` - External employee identifier.  * `passcode` - The passcode for access to Toast POS devices.  All values are optional. You must include at least one  value. Each value that you include must contain information  (not null). If you include the `passcode` value to update  an employee's passcode you must include the employee's  current passcode in the `currentPasscode` value.  (required)
        :type body: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._employees_employee_id_patch_serialize(
            toast_restaurant_external_id=toast_restaurant_external_id,
            content_type=content_type,
            employee_id=employee_id,
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Employee",
            '400': None,
            '404': None,
            '500': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def employees_employee_id_patch_with_http_info(
        self,
        toast_restaurant_external_id: Annotated[StrictStr, Field(description="The Toast platform GUID of the restaurant that is the  context for this operation. ")],
        content_type: Annotated[StrictStr, Field(description="The Internet Assigned Numbers Authority (IANA) media type  of the message body data. The value must be  `application/json`. ")],
        employee_id: Annotated[StrictStr, Field(description="The Toast platform GUID or external identifier for the  employee to be returned. ")],
        body: Annotated[StrictStr, Field(description="A JSON object containing the employee information that you  are updating. You can update an employee's:  * `firstName` - First name.  * `chosenName` - Chosen name.  * `lastName` - Last name.  * `externalEmployeeId` - External employee identifier.  * `passcode` - The passcode for access to Toast POS devices.  All values are optional. You must include at least one  value. Each value that you include must contain information  (not null). If you include the `passcode` value to update  an employee's passcode you must include the employee's  current passcode in the `currentPasscode` value. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[Employee]:
        """Update employee information

        Updates the first name, chosen name, last name, external employee ID, and/or  passcode of a restaurant employee. The `PATCH` operation cannot  update any other employee information. 

        :param toast_restaurant_external_id: The Toast platform GUID of the restaurant that is the  context for this operation.  (required)
        :type toast_restaurant_external_id: str
        :param content_type: The Internet Assigned Numbers Authority (IANA) media type  of the message body data. The value must be  `application/json`.  (required)
        :type content_type: str
        :param employee_id: The Toast platform GUID or external identifier for the  employee to be returned.  (required)
        :type employee_id: str
        :param body: A JSON object containing the employee information that you  are updating. You can update an employee's:  * `firstName` - First name.  * `chosenName` - Chosen name.  * `lastName` - Last name.  * `externalEmployeeId` - External employee identifier.  * `passcode` - The passcode for access to Toast POS devices.  All values are optional. You must include at least one  value. Each value that you include must contain information  (not null). If you include the `passcode` value to update  an employee's passcode you must include the employee's  current passcode in the `currentPasscode` value.  (required)
        :type body: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._employees_employee_id_patch_serialize(
            toast_restaurant_external_id=toast_restaurant_external_id,
            content_type=content_type,
            employee_id=employee_id,
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Employee",
            '400': None,
            '404': None,
            '500': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def employees_employee_id_patch_without_preload_content(
        self,
        toast_restaurant_external_id: Annotated[StrictStr, Field(description="The Toast platform GUID of the restaurant that is the  context for this operation. ")],
        content_type: Annotated[StrictStr, Field(description="The Internet Assigned Numbers Authority (IANA) media type  of the message body data. The value must be  `application/json`. ")],
        employee_id: Annotated[StrictStr, Field(description="The Toast platform GUID or external identifier for the  employee to be returned. ")],
        body: Annotated[StrictStr, Field(description="A JSON object containing the employee information that you  are updating. You can update an employee's:  * `firstName` - First name.  * `chosenName` - Chosen name.  * `lastName` - Last name.  * `externalEmployeeId` - External employee identifier.  * `passcode` - The passcode for access to Toast POS devices.  All values are optional. You must include at least one  value. Each value that you include must contain information  (not null). If you include the `passcode` value to update  an employee's passcode you must include the employee's  current passcode in the `currentPasscode` value. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Update employee information

        Updates the first name, chosen name, last name, external employee ID, and/or  passcode of a restaurant employee. The `PATCH` operation cannot  update any other employee information. 

        :param toast_restaurant_external_id: The Toast platform GUID of the restaurant that is the  context for this operation.  (required)
        :type toast_restaurant_external_id: str
        :param content_type: The Internet Assigned Numbers Authority (IANA) media type  of the message body data. The value must be  `application/json`.  (required)
        :type content_type: str
        :param employee_id: The Toast platform GUID or external identifier for the  employee to be returned.  (required)
        :type employee_id: str
        :param body: A JSON object containing the employee information that you  are updating. You can update an employee's:  * `firstName` - First name.  * `chosenName` - Chosen name.  * `lastName` - Last name.  * `externalEmployeeId` - External employee identifier.  * `passcode` - The passcode for access to Toast POS devices.  All values are optional. You must include at least one  value. Each value that you include must contain information  (not null). If you include the `passcode` value to update  an employee's passcode you must include the employee's  current passcode in the `currentPasscode` value.  (required)
        :type body: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._employees_employee_id_patch_serialize(
            toast_restaurant_external_id=toast_restaurant_external_id,
            content_type=content_type,
            employee_id=employee_id,
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Employee",
            '400': None,
            '404': None,
            '500': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _employees_employee_id_patch_serialize(
        self,
        toast_restaurant_external_id,
        content_type,
        employee_id,
        body,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if employee_id is not None:
            _path_params['employeeId'] = employee_id
        # process the query parameters
        # process the header parameters
        if toast_restaurant_external_id is not None:
            _header_params['Toast-Restaurant-External-ID'] = toast_restaurant_external_id
        if content_type is not None:
            _header_params['Content-Type'] = content_type
        # process the form parameters
        # process the body parameter
        if body is not None:
            _body_params = body


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'oauth2'
        ]

        return self.api_client.param_serialize(
            method='PATCH',
            resource_path='/labor/v1/employees/{employeeId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def employees_employee_id_unarchive_put(
        self,
        employee_id: Annotated[StrictStr, Field(description="The Toast platform GUID of the employee record. ")],
        toast_restaurant_external_id: Annotated[StrictStr, Field(description="The Toast platform GUID of the restaurant that is the  context for this operation. ")],
        content_type: Annotated[StrictStr, Field(description="The Internet Assigned Numbers Authority (IANA) media type  of the message body data. The value must be  `application/json`. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Employee:
        """Unarchive an employee

        Unarchives an employee record that was previously archived.  * Unarchived employees can sign into the Toast POS. * Unarchived employees can sign in to Toast Web.  * When you unarchive an employee, the employee has all    jobs that were previously assigned to them. * If an employee had a swipe card for signing into the    Toast POS, the swipe card _is not_ re-associated with    the employee when you unarchive them.  If you unarchive an employee who will take a different  role than the one they had when they were archived, you  must update the employee's jobs list and verify that the  employee should continue to sign into Toast Web. 

        :param employee_id: The Toast platform GUID of the employee record.  (required)
        :type employee_id: str
        :param toast_restaurant_external_id: The Toast platform GUID of the restaurant that is the  context for this operation.  (required)
        :type toast_restaurant_external_id: str
        :param content_type: The Internet Assigned Numbers Authority (IANA) media type  of the message body data. The value must be  `application/json`.  (required)
        :type content_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._employees_employee_id_unarchive_put_serialize(
            employee_id=employee_id,
            toast_restaurant_external_id=toast_restaurant_external_id,
            content_type=content_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Employee",
            '400': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def employees_employee_id_unarchive_put_with_http_info(
        self,
        employee_id: Annotated[StrictStr, Field(description="The Toast platform GUID of the employee record. ")],
        toast_restaurant_external_id: Annotated[StrictStr, Field(description="The Toast platform GUID of the restaurant that is the  context for this operation. ")],
        content_type: Annotated[StrictStr, Field(description="The Internet Assigned Numbers Authority (IANA) media type  of the message body data. The value must be  `application/json`. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[Employee]:
        """Unarchive an employee

        Unarchives an employee record that was previously archived.  * Unarchived employees can sign into the Toast POS. * Unarchived employees can sign in to Toast Web.  * When you unarchive an employee, the employee has all    jobs that were previously assigned to them. * If an employee had a swipe card for signing into the    Toast POS, the swipe card _is not_ re-associated with    the employee when you unarchive them.  If you unarchive an employee who will take a different  role than the one they had when they were archived, you  must update the employee's jobs list and verify that the  employee should continue to sign into Toast Web. 

        :param employee_id: The Toast platform GUID of the employee record.  (required)
        :type employee_id: str
        :param toast_restaurant_external_id: The Toast platform GUID of the restaurant that is the  context for this operation.  (required)
        :type toast_restaurant_external_id: str
        :param content_type: The Internet Assigned Numbers Authority (IANA) media type  of the message body data. The value must be  `application/json`.  (required)
        :type content_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._employees_employee_id_unarchive_put_serialize(
            employee_id=employee_id,
            toast_restaurant_external_id=toast_restaurant_external_id,
            content_type=content_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Employee",
            '400': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def employees_employee_id_unarchive_put_without_preload_content(
        self,
        employee_id: Annotated[StrictStr, Field(description="The Toast platform GUID of the employee record. ")],
        toast_restaurant_external_id: Annotated[StrictStr, Field(description="The Toast platform GUID of the restaurant that is the  context for this operation. ")],
        content_type: Annotated[StrictStr, Field(description="The Internet Assigned Numbers Authority (IANA) media type  of the message body data. The value must be  `application/json`. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Unarchive an employee

        Unarchives an employee record that was previously archived.  * Unarchived employees can sign into the Toast POS. * Unarchived employees can sign in to Toast Web.  * When you unarchive an employee, the employee has all    jobs that were previously assigned to them. * If an employee had a swipe card for signing into the    Toast POS, the swipe card _is not_ re-associated with    the employee when you unarchive them.  If you unarchive an employee who will take a different  role than the one they had when they were archived, you  must update the employee's jobs list and verify that the  employee should continue to sign into Toast Web. 

        :param employee_id: The Toast platform GUID of the employee record.  (required)
        :type employee_id: str
        :param toast_restaurant_external_id: The Toast platform GUID of the restaurant that is the  context for this operation.  (required)
        :type toast_restaurant_external_id: str
        :param content_type: The Internet Assigned Numbers Authority (IANA) media type  of the message body data. The value must be  `application/json`.  (required)
        :type content_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._employees_employee_id_unarchive_put_serialize(
            employee_id=employee_id,
            toast_restaurant_external_id=toast_restaurant_external_id,
            content_type=content_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Employee",
            '400': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _employees_employee_id_unarchive_put_serialize(
        self,
        employee_id,
        toast_restaurant_external_id,
        content_type,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if employee_id is not None:
            _path_params['employeeId'] = employee_id
        # process the query parameters
        # process the header parameters
        if toast_restaurant_external_id is not None:
            _header_params['Toast-Restaurant-External-ID'] = toast_restaurant_external_id
        if content_type is not None:
            _header_params['Content-Type'] = content_type
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'oauth2'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/labor/v1/employees/{employeeId}/unarchive',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def employees_employee_id_wage_overrides_put(
        self,
        employee_id: Annotated[StrictStr, Field(description="The Toast platform GUID of the employee record. ")],
        toast_restaurant_external_id: Annotated[StrictStr, Field(description="The Toast platform GUID of the restaurant that is the  context for this operation. ")],
        content_type: Annotated[StrictStr, Field(description="The Internet Assigned Numbers Authority (IANA) media type  of the message body data. The value must be  `application/json`. ")],
        body: Annotated[StrictStr, Field(description="An array of JSON `JobWageOverride` objects. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Employee:
        """Replace wage overrides

        Replaces the list of wage overrides for the jobs that are  assigned to an employee. Include a JSON  array of  `JobWageOverride` objects in the message body. Include the new  wage for the employee in the `wage` value. Specify the wage in  U.S. dollars.  You must include all existing wage overrides in the message  body. Any wage overrides that are not present in the array are  removed from the employee record. 

        :param employee_id: The Toast platform GUID of the employee record.  (required)
        :type employee_id: str
        :param toast_restaurant_external_id: The Toast platform GUID of the restaurant that is the  context for this operation.  (required)
        :type toast_restaurant_external_id: str
        :param content_type: The Internet Assigned Numbers Authority (IANA) media type  of the message body data. The value must be  `application/json`.  (required)
        :type content_type: str
        :param body: An array of JSON `JobWageOverride` objects.  (required)
        :type body: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._employees_employee_id_wage_overrides_put_serialize(
            employee_id=employee_id,
            toast_restaurant_external_id=toast_restaurant_external_id,
            content_type=content_type,
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Employee",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def employees_employee_id_wage_overrides_put_with_http_info(
        self,
        employee_id: Annotated[StrictStr, Field(description="The Toast platform GUID of the employee record. ")],
        toast_restaurant_external_id: Annotated[StrictStr, Field(description="The Toast platform GUID of the restaurant that is the  context for this operation. ")],
        content_type: Annotated[StrictStr, Field(description="The Internet Assigned Numbers Authority (IANA) media type  of the message body data. The value must be  `application/json`. ")],
        body: Annotated[StrictStr, Field(description="An array of JSON `JobWageOverride` objects. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[Employee]:
        """Replace wage overrides

        Replaces the list of wage overrides for the jobs that are  assigned to an employee. Include a JSON  array of  `JobWageOverride` objects in the message body. Include the new  wage for the employee in the `wage` value. Specify the wage in  U.S. dollars.  You must include all existing wage overrides in the message  body. Any wage overrides that are not present in the array are  removed from the employee record. 

        :param employee_id: The Toast platform GUID of the employee record.  (required)
        :type employee_id: str
        :param toast_restaurant_external_id: The Toast platform GUID of the restaurant that is the  context for this operation.  (required)
        :type toast_restaurant_external_id: str
        :param content_type: The Internet Assigned Numbers Authority (IANA) media type  of the message body data. The value must be  `application/json`.  (required)
        :type content_type: str
        :param body: An array of JSON `JobWageOverride` objects.  (required)
        :type body: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._employees_employee_id_wage_overrides_put_serialize(
            employee_id=employee_id,
            toast_restaurant_external_id=toast_restaurant_external_id,
            content_type=content_type,
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Employee",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def employees_employee_id_wage_overrides_put_without_preload_content(
        self,
        employee_id: Annotated[StrictStr, Field(description="The Toast platform GUID of the employee record. ")],
        toast_restaurant_external_id: Annotated[StrictStr, Field(description="The Toast platform GUID of the restaurant that is the  context for this operation. ")],
        content_type: Annotated[StrictStr, Field(description="The Internet Assigned Numbers Authority (IANA) media type  of the message body data. The value must be  `application/json`. ")],
        body: Annotated[StrictStr, Field(description="An array of JSON `JobWageOverride` objects. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Replace wage overrides

        Replaces the list of wage overrides for the jobs that are  assigned to an employee. Include a JSON  array of  `JobWageOverride` objects in the message body. Include the new  wage for the employee in the `wage` value. Specify the wage in  U.S. dollars.  You must include all existing wage overrides in the message  body. Any wage overrides that are not present in the array are  removed from the employee record. 

        :param employee_id: The Toast platform GUID of the employee record.  (required)
        :type employee_id: str
        :param toast_restaurant_external_id: The Toast platform GUID of the restaurant that is the  context for this operation.  (required)
        :type toast_restaurant_external_id: str
        :param content_type: The Internet Assigned Numbers Authority (IANA) media type  of the message body data. The value must be  `application/json`.  (required)
        :type content_type: str
        :param body: An array of JSON `JobWageOverride` objects.  (required)
        :type body: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._employees_employee_id_wage_overrides_put_serialize(
            employee_id=employee_id,
            toast_restaurant_external_id=toast_restaurant_external_id,
            content_type=content_type,
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Employee",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _employees_employee_id_wage_overrides_put_serialize(
        self,
        employee_id,
        toast_restaurant_external_id,
        content_type,
        body,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if employee_id is not None:
            _path_params['employeeId'] = employee_id
        # process the query parameters
        # process the header parameters
        if toast_restaurant_external_id is not None:
            _header_params['Toast-Restaurant-External-ID'] = toast_restaurant_external_id
        if content_type is not None:
            _header_params['Content-Type'] = content_type
        # process the form parameters
        # process the body parameter
        if body is not None:
            _body_params = body


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'oauth2'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/labor/v1/employees/{employeeId}/wageOverrides',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def employees_get(
        self,
        toast_restaurant_external_id: Annotated[StrictStr, Field(description="The Toast platform GUID of the restaurant that is the  context for this operation. ")],
        employee_ids: Annotated[Optional[StrictStr], Field(description="An optional identifier that filters return values for a  specific employee. The identifier can be a Toast platform  GUID or an external identifier. If present, the `employees`  resource will only return the employees you specify. You  can include multiple `employeeIds` query parameters  (maximum 100). If not present, the resource returns each  employee for the restaurant. ")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[Employee]:
        """Get employees

        Returns an array of `Employee` objects containing information  about restaurant employees. 

        :param toast_restaurant_external_id: The Toast platform GUID of the restaurant that is the  context for this operation.  (required)
        :type toast_restaurant_external_id: str
        :param employee_ids: An optional identifier that filters return values for a  specific employee. The identifier can be a Toast platform  GUID or an external identifier. If present, the `employees`  resource will only return the employees you specify. You  can include multiple `employeeIds` query parameters  (maximum 100). If not present, the resource returns each  employee for the restaurant. 
        :type employee_ids: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._employees_get_serialize(
            toast_restaurant_external_id=toast_restaurant_external_id,
            employee_ids=employee_ids,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[Employee]",
            '500': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def employees_get_with_http_info(
        self,
        toast_restaurant_external_id: Annotated[StrictStr, Field(description="The Toast platform GUID of the restaurant that is the  context for this operation. ")],
        employee_ids: Annotated[Optional[StrictStr], Field(description="An optional identifier that filters return values for a  specific employee. The identifier can be a Toast platform  GUID or an external identifier. If present, the `employees`  resource will only return the employees you specify. You  can include multiple `employeeIds` query parameters  (maximum 100). If not present, the resource returns each  employee for the restaurant. ")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[Employee]]:
        """Get employees

        Returns an array of `Employee` objects containing information  about restaurant employees. 

        :param toast_restaurant_external_id: The Toast platform GUID of the restaurant that is the  context for this operation.  (required)
        :type toast_restaurant_external_id: str
        :param employee_ids: An optional identifier that filters return values for a  specific employee. The identifier can be a Toast platform  GUID or an external identifier. If present, the `employees`  resource will only return the employees you specify. You  can include multiple `employeeIds` query parameters  (maximum 100). If not present, the resource returns each  employee for the restaurant. 
        :type employee_ids: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._employees_get_serialize(
            toast_restaurant_external_id=toast_restaurant_external_id,
            employee_ids=employee_ids,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[Employee]",
            '500': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def employees_get_without_preload_content(
        self,
        toast_restaurant_external_id: Annotated[StrictStr, Field(description="The Toast platform GUID of the restaurant that is the  context for this operation. ")],
        employee_ids: Annotated[Optional[StrictStr], Field(description="An optional identifier that filters return values for a  specific employee. The identifier can be a Toast platform  GUID or an external identifier. If present, the `employees`  resource will only return the employees you specify. You  can include multiple `employeeIds` query parameters  (maximum 100). If not present, the resource returns each  employee for the restaurant. ")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get employees

        Returns an array of `Employee` objects containing information  about restaurant employees. 

        :param toast_restaurant_external_id: The Toast platform GUID of the restaurant that is the  context for this operation.  (required)
        :type toast_restaurant_external_id: str
        :param employee_ids: An optional identifier that filters return values for a  specific employee. The identifier can be a Toast platform  GUID or an external identifier. If present, the `employees`  resource will only return the employees you specify. You  can include multiple `employeeIds` query parameters  (maximum 100). If not present, the resource returns each  employee for the restaurant. 
        :type employee_ids: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._employees_get_serialize(
            toast_restaurant_external_id=toast_restaurant_external_id,
            employee_ids=employee_ids,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[Employee]",
            '500': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _employees_get_serialize(
        self,
        toast_restaurant_external_id,
        employee_ids,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if employee_ids is not None:
            
            _query_params.append(('employeeIds', employee_ids))
            
        # process the header parameters
        if toast_restaurant_external_id is not None:
            _header_params['Toast-Restaurant-External-ID'] = toast_restaurant_external_id
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'oauth2'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/labor/v1/employees',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def employees_post(
        self,
        toast_restaurant_external_id: Annotated[StrictStr, Field(description="The Toast platform GUID of the restaurant that is the  context for this operation. ")],
        content_type: Annotated[StrictStr, Field(description="The Internet Assigned Numbers Authority (IANA) media type  of the message body data. The value must be  `application/json`. ")],
        body: Annotated[StrictStr, Field(description="An `Employee` object containing information about the  employee, including the employee's name and email address. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Employee:
        """Add an employee

        Creates a restaurant employee record. 

        :param toast_restaurant_external_id: The Toast platform GUID of the restaurant that is the  context for this operation.  (required)
        :type toast_restaurant_external_id: str
        :param content_type: The Internet Assigned Numbers Authority (IANA) media type  of the message body data. The value must be  `application/json`.  (required)
        :type content_type: str
        :param body: An `Employee` object containing information about the  employee, including the employee's name and email address.  (required)
        :type body: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._employees_post_serialize(
            toast_restaurant_external_id=toast_restaurant_external_id,
            content_type=content_type,
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Employee",
            '400': None,
            '415': None,
            '500': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def employees_post_with_http_info(
        self,
        toast_restaurant_external_id: Annotated[StrictStr, Field(description="The Toast platform GUID of the restaurant that is the  context for this operation. ")],
        content_type: Annotated[StrictStr, Field(description="The Internet Assigned Numbers Authority (IANA) media type  of the message body data. The value must be  `application/json`. ")],
        body: Annotated[StrictStr, Field(description="An `Employee` object containing information about the  employee, including the employee's name and email address. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[Employee]:
        """Add an employee

        Creates a restaurant employee record. 

        :param toast_restaurant_external_id: The Toast platform GUID of the restaurant that is the  context for this operation.  (required)
        :type toast_restaurant_external_id: str
        :param content_type: The Internet Assigned Numbers Authority (IANA) media type  of the message body data. The value must be  `application/json`.  (required)
        :type content_type: str
        :param body: An `Employee` object containing information about the  employee, including the employee's name and email address.  (required)
        :type body: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._employees_post_serialize(
            toast_restaurant_external_id=toast_restaurant_external_id,
            content_type=content_type,
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Employee",
            '400': None,
            '415': None,
            '500': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def employees_post_without_preload_content(
        self,
        toast_restaurant_external_id: Annotated[StrictStr, Field(description="The Toast platform GUID of the restaurant that is the  context for this operation. ")],
        content_type: Annotated[StrictStr, Field(description="The Internet Assigned Numbers Authority (IANA) media type  of the message body data. The value must be  `application/json`. ")],
        body: Annotated[StrictStr, Field(description="An `Employee` object containing information about the  employee, including the employee's name and email address. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Add an employee

        Creates a restaurant employee record. 

        :param toast_restaurant_external_id: The Toast platform GUID of the restaurant that is the  context for this operation.  (required)
        :type toast_restaurant_external_id: str
        :param content_type: The Internet Assigned Numbers Authority (IANA) media type  of the message body data. The value must be  `application/json`.  (required)
        :type content_type: str
        :param body: An `Employee` object containing information about the  employee, including the employee's name and email address.  (required)
        :type body: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._employees_post_serialize(
            toast_restaurant_external_id=toast_restaurant_external_id,
            content_type=content_type,
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Employee",
            '400': None,
            '415': None,
            '500': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _employees_post_serialize(
        self,
        toast_restaurant_external_id,
        content_type,
        body,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        if toast_restaurant_external_id is not None:
            _header_params['Toast-Restaurant-External-ID'] = toast_restaurant_external_id
        if content_type is not None:
            _header_params['Content-Type'] = content_type
        # process the form parameters
        # process the body parameter
        if body is not None:
            _body_params = body


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'oauth2'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/labor/v1/employees',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


