Thank you for your issue. 

{%- if questions -%}
{% if questions|length == 1 %}
We found the following entry in the [FAQ]({{ faq_url }}) which you may find helpful:
{%- else %}
We found the following entries in the [FAQ]({{ faq_url }}) which you may find helpful:
{%- endif %}

{% for question in questions %}
- [{{ question.title }}]({{ faq_url }}#{{ question.slug }})
{%- endfor %}

{%- else -%}
You might want to check the [FAQ]({{ faq_url }}) if you haven't done so already.
{%- endif %}

Feel free to close this issue if you found an answer in the FAQ. 

If your issue is a feature request, please read [this](https://xyproblem.info/) first and update your request accordingly, if needed.

If your issue is a bug report, please provide a [minimum reproducible example](https://stackoverflow.com/help/minimal-reproducible-example) as a link to a self-contained [Google Colab](https://colab.research.google.com/) notebook containing everthing needed to reproduce the bug: 
  - installation
  - data preparation
  - model download
  - etc.
  
Providing an MRE will increase your chance of getting an answer from the community (either maintainers or other power users).

Companies relying on `pyannote.audio` in production may contact [me](https://herve.niderb.fr) via email regarding:
* paid scientific consulting around speaker diarization and speech processing in general;
* custom models and tailored features (via the local tech transfer office).

> This is an automated reply, generated by [FAQtory](https://github.com/willmcgugan/faqtory)
