# thri


[![PyPI version](https://badge.fury.io/py/thri.svg)](https://badge.fury.io/py/thri)
[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](https://opensource.org/licenses/MIT)


This library was created to simplify the concept of trees by displaying them in the same way as in the linkedit library. To make it clear that trees are just linked lists that can refer to at most two nodes instead of one. Trees can also refer to a single node or no nodes at all, such as the end of a linked list. Trees are a recursive and non-linear data structure. This library is specifically designed for beginners in data structures.


## Installation


You can install `thri` via pip:


```bash
pip install thri
```


## Usage 


### For Binary Search Tree


```python
from thri import binarySearchTree


x = binarySearchTree([5, 4, 6, 2, 8, 1, 3, 7, 9])
# it's use level-order algorithm as default 
print(x)
```


### Output


```bash
╒════════════════╤════════════════════════╤══════════════╤══════════════════════╤═══════════════╤═══════════════════════╕
│ Current node   │ Current node @ddress   │ Left child   │ Left child @ddress   │ Right child   │ Right child @ddress   │
╞════════════════╪════════════════════════╪══════════════╪══════════════════════╪═══════════════╪═══════════════════════╡
│ 5 (Root)       │ 0x7f4900821c10         │ 4            │ 0x7f4900820750       │ 6             │ 0x7f4900821e90        │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 4              │ 0x7f4900820750         │ 2            │ 0x7f4900821f10       │ None          │ 0x959cc0 (nil/0x0)    │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 6              │ 0x7f4900821e90         │ None         │ 0x959cc0 (nil/0x0)   │ 8             │ 0x7f4900897cd0        │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 2              │ 0x7f4900821f10         │ 1            │ 0x7f4900663d90       │ 3             │ 0x7f4900663810        │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 8              │ 0x7f4900897cd0         │ 7            │ 0x7f4900663a50       │ 9             │ 0x7f4900663750        │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 1              │ 0x7f4900663d90         │ None         │ 0x959cc0 (nil/0x0)   │ None          │ 0x959cc0 (nil/0x0)    │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 3              │ 0x7f4900663810         │ None         │ 0x959cc0 (nil/0x0)   │ None          │ 0x959cc0 (nil/0x0)    │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 7              │ 0x7f4900663a50         │ None         │ 0x959cc0 (nil/0x0)   │ None          │ 0x959cc0 (nil/0x0)    │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 9              │ 0x7f4900663750         │ None         │ 0x959cc0 (nil/0x0)   │ None          │ 0x959cc0 (nil/0x0)    │
╘════════════════╧════════════════════════╧══════════════╧══════════════════════╧═══════════════╧═══════════════════════╛
```


#### You Can print The Tree With All Possible Traversing Algorithms


##### pre-order Algorithm


```python
from thri import binarySearchTree


x = binarySearchTree([5, 4, 6, 2, 8, 1, 3, 7, 9], algorithm="pre-order")
print(x)
```


### Output


```bash
╒════════════════╤════════════════════════╤══════════════╤══════════════════════╤═══════════════╤═══════════════════════╕
│ Current node   │ Current node @ddress   │ Left child   │ Left child @ddress   │ Right child   │ Right child @ddress   │
╞════════════════╪════════════════════════╪══════════════╪══════════════════════╪═══════════════╪═══════════════════════╡
│ 5 (Root)       │ 0x7f6bc7ac4750         │ 4            │ 0x7f6bc7ac4810       │ 6             │ 0x7f6bc7ac5f10        │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 4              │ 0x7f6bc7ac4810         │ 2            │ 0x7f6bc7ac5610       │ None          │ 0x959cc0 (nil/0x0)    │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 2              │ 0x7f6bc7ac5610         │ 1            │ 0x7f6bc7b3bd10       │ 3             │ 0x7f6bc793fb50        │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 1              │ 0x7f6bc7b3bd10         │ None         │ 0x959cc0 (nil/0x0)   │ None          │ 0x959cc0 (nil/0x0)    │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 3              │ 0x7f6bc793fb50         │ None         │ 0x959cc0 (nil/0x0)   │ None          │ 0x959cc0 (nil/0x0)    │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 6              │ 0x7f6bc7ac5f10         │ None         │ 0x959cc0 (nil/0x0)   │ 8             │ 0x7f6bc7ac5e90        │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 8              │ 0x7f6bc7ac5e90         │ 7            │ 0x7f6bc793fb90       │ 9             │ 0x7f6bc793f610        │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 7              │ 0x7f6bc793fb90         │ None         │ 0x959cc0 (nil/0x0)   │ None          │ 0x959cc0 (nil/0x0)    │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 9              │ 0x7f6bc793f610         │ None         │ 0x959cc0 (nil/0x0)   │ None          │ 0x959cc0 (nil/0x0)    │
╘════════════════╧════════════════════════╧══════════════╧══════════════════════╧═══════════════╧═══════════════════════╛
```


##### in-order Algorithm


```python
from thri import binarySearchTree


x = binarySearchTree([5, 4, 6, 2, 8, 1, 3, 7, 9], algorithm="in-order")
print(x)
```


### Output


```bash
╒════════════════╤════════════════════════╤══════════════╤══════════════════════╤═══════════════╤═══════════════════════╕
│ Current node   │ Current node @ddress   │ Left child   │ Left child @ddress   │ Right child   │ Right child @ddress   │
╞════════════════╪════════════════════════╪══════════════╪══════════════════════╪═══════════════╪═══════════════════════╡
│ 1              │ 0x7fa196023c90         │ None         │ 0x959cc0 (nil/0x0)   │ None          │ 0x959cc0 (nil/0x0)    │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 2              │ 0x7fa1961c1e90         │ 1            │ 0x7fa196023c90       │ 3             │ 0x7fa196023cd0        │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 3              │ 0x7fa196023cd0         │ None         │ 0x959cc0 (nil/0x0)   │ None          │ 0x959cc0 (nil/0x0)    │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 4              │ 0x7fa1961c1f10         │ 2            │ 0x7fa1961c1e90       │ None          │ 0x959cc0 (nil/0x0)    │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 5 (Root)       │ 0x7fa1961c0810         │ 4            │ 0x7fa1961c1f10       │ 6             │ 0x7fa1961c1610        │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 6              │ 0x7fa1961c1610         │ None         │ 0x959cc0 (nil/0x0)   │ 8             │ 0x7fa196237d10        │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 7              │ 0x7fa196023750         │ None         │ 0x959cc0 (nil/0x0)   │ None          │ 0x959cc0 (nil/0x0)    │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 8              │ 0x7fa196237d10         │ 7            │ 0x7fa196023750       │ 9             │ 0x7fa196023990        │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 9              │ 0x7fa196023990         │ None         │ 0x959cc0 (nil/0x0)   │ None          │ 0x959cc0 (nil/0x0)    │
╘════════════════╧════════════════════════╧══════════════╧══════════════════════╧═══════════════╧═══════════════════════╛
```


##### post-order Algorithm


```python
from thri import binarySearchTree


x = binarySearchTree([5, 4, 6, 2, 8, 1, 3, 7, 9], algorithm="post-order")
print(x)
```


### Output


```bash
╒════════════════╤════════════════════════╤══════════════╤══════════════════════╤═══════════════╤═══════════════════════╕
│ Current node   │ Current node @ddress   │ Left child   │ Left child @ddress   │ Right child   │ Right child @ddress   │
╞════════════════╪════════════════════════╪══════════════╪══════════════════════╪═══════════════╪═══════════════════════╡
│ 1              │ 0x7f99ed423c90         │ None         │ 0x959cc0 (nil/0x0)   │ None          │ 0x959cc0 (nil/0x0)    │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 3              │ 0x7f99ed423cd0         │ None         │ 0x959cc0 (nil/0x0)   │ None          │ 0x959cc0 (nil/0x0)    │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 2              │ 0x7f99ed5c1e90         │ 1            │ 0x7f99ed423c90       │ 3             │ 0x7f99ed423cd0        │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 4              │ 0x7f99ed5c1f10         │ 2            │ 0x7f99ed5c1e90       │ None          │ 0x959cc0 (nil/0x0)    │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 7              │ 0x7f99ed423750         │ None         │ 0x959cc0 (nil/0x0)   │ None          │ 0x959cc0 (nil/0x0)    │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 9              │ 0x7f99ed423990         │ None         │ 0x959cc0 (nil/0x0)   │ None          │ 0x959cc0 (nil/0x0)    │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 8              │ 0x7f99ed637d10         │ 7            │ 0x7f99ed423750       │ 9             │ 0x7f99ed423990        │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 6              │ 0x7f99ed5c1610         │ None         │ 0x959cc0 (nil/0x0)   │ 8             │ 0x7f99ed637d10        │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 5 (Root)       │ 0x7f99ed5c0810         │ 4            │ 0x7f99ed5c1f10       │ 6             │ 0x7f99ed5c1610        │
╘════════════════╧════════════════════════╧══════════════╧══════════════════════╧═══════════════╧═══════════════════════╛
```


#### You Can Add Nodes After Creation Or Create The Binary Search Tree From Scratch Node By Node 


```python
from thri import binarySearchTree


x = binarySearchTree()
x.add(5)
x.add(4)
x.add(6)
x.add(2)
x.add(8)
x.add(1)
x.add(3)
x.add(7)
x.add(9)
print(x)
```


### Output


```bash
╒════════════════╤════════════════════════╤══════════════╤══════════════════════╤═══════════════╤═══════════════════════╕
│ Current node   │ Current node @ddress   │ Left child   │ Left child @ddress   │ Right child   │ Right child @ddress   │
╞════════════════╪════════════════════════╪══════════════╪══════════════════════╪═══════════════╪═══════════════════════╡
│ 5 (Root)       │ 0x7ff824dc1c10         │ 4            │ 0x7ff824dc0750       │ 6             │ 0x7ff824dc1e90        │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 4              │ 0x7ff824dc0750         │ 2            │ 0x7ff824dc1f10       │ None          │ 0x959cc0 (nil/0x0)    │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 6              │ 0x7ff824dc1e90         │ None         │ 0x959cc0 (nil/0x0)   │ 8             │ 0x7ff824e37cd0        │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 2              │ 0x7ff824dc1f10         │ 1            │ 0x7ff824c43c50       │ 3             │ 0x7ff824c43c90        │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 8              │ 0x7ff824e37cd0         │ 7            │ 0x7ff824c43710       │ 9             │ 0x7ff824c43950        │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 1              │ 0x7ff824c43c50         │ None         │ 0x959cc0 (nil/0x0)   │ None          │ 0x959cc0 (nil/0x0)    │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 3              │ 0x7ff824c43c90         │ None         │ 0x959cc0 (nil/0x0)   │ None          │ 0x959cc0 (nil/0x0)    │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 7              │ 0x7ff824c43710         │ None         │ 0x959cc0 (nil/0x0)   │ None          │ 0x959cc0 (nil/0x0)    │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 9              │ 0x7ff824c43950         │ None         │ 0x959cc0 (nil/0x0)   │ None          │ 0x959cc0 (nil/0x0)    │
╘════════════════╧════════════════════════╧══════════════╧══════════════════════╧═══════════════╧═══════════════════════╛
```


#### You Can Search For A Value


```python
from thri import binarySearchTree


x = binarySearchTree([5, 4, 6, 2, 8, 1, 3, 7, 9])
x.search(4)
x.search(5)
x.search(3)
```


### Output


```bash
Found after 1 step
Found after 0 step
Found after 3 steps with the path : [5, 4, 2]
```


#### You Can Delete A Node By Value


```python
from thri import binarySearchTree


x = binarySearchTree([5, 4, 6, 2, 8, 1, 3, 7, 9])
print(x)
x.remove(5)
print(x)
```


### Output


```bash
╒════════════════╤════════════════════════╤══════════════╤══════════════════════╤═══════════════╤═══════════════════════╕
│ Current node   │ Current node @ddress   │ Left child   │ Left child @ddress   │ Right child   │ Right child @ddress   │
╞════════════════╪════════════════════════╪══════════════╪══════════════════════╪═══════════════╪═══════════════════════╡
│ 5 (Root)       │ 0x7f4a34921b10         │ 4            │ 0x7f4a34920650       │ 6             │ 0x7f4a34921e10        │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 4              │ 0x7f4a34920650         │ 2            │ 0x7f4a34923590       │ None          │ 0x959cc0 (nil/0x0)    │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 6              │ 0x7f4a34921e10         │ None         │ 0x959cc0 (nil/0x0)   │ 8             │ 0x7f4a34997bd0        │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 2              │ 0x7f4a34923590         │ 1            │ 0x7f4a347638d0       │ 3             │ 0x7f4a34763cd0        │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 8              │ 0x7f4a34997bd0         │ 7            │ 0x7f4a347636d0       │ 9             │ 0x7f4a34763910        │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 1              │ 0x7f4a347638d0         │ None         │ 0x959cc0 (nil/0x0)   │ None          │ 0x959cc0 (nil/0x0)    │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 3              │ 0x7f4a34763cd0         │ None         │ 0x959cc0 (nil/0x0)   │ None          │ 0x959cc0 (nil/0x0)    │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 7              │ 0x7f4a347636d0         │ None         │ 0x959cc0 (nil/0x0)   │ None          │ 0x959cc0 (nil/0x0)    │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 9              │ 0x7f4a34763910         │ None         │ 0x959cc0 (nil/0x0)   │ None          │ 0x959cc0 (nil/0x0)    │
╘════════════════╧════════════════════════╧══════════════╧══════════════════════╧═══════════════╧═══════════════════════╛
╒════════════════╤════════════════════════╤══════════════╤══════════════════════╤═══════════════╤═══════════════════════╕
│ Current node   │ Current node @ddress   │ Left child   │ Left child @ddress   │ Right child   │ Right child @ddress   │
╞════════════════╪════════════════════════╪══════════════╪══════════════════════╪═══════════════╪═══════════════════════╡
│ 4 (Root)       │ 0x7f4a34921b10         │ 2            │ 0x7f4a34923590       │ 6             │ 0x7f4a34921e10        │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 2              │ 0x7f4a34923590         │ 1            │ 0x7f4a347638d0       │ 3             │ 0x7f4a34763cd0        │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 6              │ 0x7f4a34921e10         │ None         │ 0x959cc0 (nil/0x0)   │ 8             │ 0x7f4a34997bd0        │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 1              │ 0x7f4a347638d0         │ None         │ 0x959cc0 (nil/0x0)   │ None          │ 0x959cc0 (nil/0x0)    │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 3              │ 0x7f4a34763cd0         │ None         │ 0x959cc0 (nil/0x0)   │ None          │ 0x959cc0 (nil/0x0)    │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 8              │ 0x7f4a34997bd0         │ 7            │ 0x7f4a347636d0       │ 9             │ 0x7f4a34763910        │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 7              │ 0x7f4a347636d0         │ None         │ 0x959cc0 (nil/0x0)   │ None          │ 0x959cc0 (nil/0x0)    │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 9              │ 0x7f4a34763910         │ None         │ 0x959cc0 (nil/0x0)   │ None          │ 0x959cc0 (nil/0x0)    │
╘════════════════╧════════════════════════╧══════════════╧══════════════════════╧═══════════════╧═══════════════════════╛
```


#### You Can Know How Many Node In The Tree


```python
from thri import binarySearchTree

x = binarySearchTree([5, 4, 6, 2, 8, 1, 3, 7, 9])
print(len(x))
```


### Output


```bash
9
```


#### You Can Know The Max/Min Value In The Tree


```python
from thri import binarySearchTree


x = binarySearchTree([5, 4, 6, 2, 8, 1, 3, 7, 9])
print(x.max())
print(x.min())

```


### Output


```bash
9
1
```


## Advanced Usage


```python
from thri import binarySearchTree


def pre_order(root):
    if root is not None:
        print(root.get_data())
        pre_order(root.left_child())
        pre_order(root.right_child())


def in_order(root):
    if root is not None:
        in_order(root.left_child())
        print(root.get_data())
        in_order(root.right_child())


def post_order(root):
    if root is not None:
        post_order(root.left_child())
        post_order(root.right_child())
        print(root.get_data())


x = binarySearchTree([5, 4, 6, 2, 8, 1, 3, 7, 9])
root = x.root
print("pre-order: ")
pre_order(root)
print("in-order: ")
in_order(root)
print("post-order: ")
post_order(root)
```


### Output


```bash
pre-order: 
5
4
2
1
3
6
8
7
9
in-order: 
1
2
3
4
5
6
7
8
9
post-order: 
1
3
2
4
7
9
8
6
5
```


### For Complete Binary Tree


```python
from thri import completeBinaryTree


x = completeBinaryTree([5, 4, 6, 2, 8, 1, 3, 7, 9])
# it's use level-order algorithm as default
print(x)
```


### Output


```bash
╒════════════════╤════════════════════════╤══════════════╤══════════════════════╤═══════════════╤═══════════════════════╕
│ Current node   │ Current node @ddress   │ Left child   │ Left child @ddress   │ Right child   │ Right child @ddress   │
╞════════════════╪════════════════════════╪══════════════╪══════════════════════╪═══════════════╪═══════════════════════╡
│ 5 (Root)       │ 0x7fd4ec525b10         │ 4            │ 0x7fd4ec525e10       │ 6             │ 0x7fd4ec59bc50        │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 4              │ 0x7fd4ec525e10         │ 2            │ 0x7fd4ec525d90       │ 8             │ 0x7fd4ec37f690        │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 6              │ 0x7fd4ec59bc50         │ 1            │ 0x7fd4ec37fbd0       │ 3             │ 0x7fd4ec37f450        │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 2              │ 0x7fd4ec525d90         │ 7            │ 0x7fd4ec37fc10       │ 9             │ 0x7fd4ec37f890        │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 8              │ 0x7fd4ec37f690         │ None         │ 0x959cc0 (nil/0x0)   │ None          │ 0x959cc0 (nil/0x0)    │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 1              │ 0x7fd4ec37fbd0         │ None         │ 0x959cc0 (nil/0x0)   │ None          │ 0x959cc0 (nil/0x0)    │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 3              │ 0x7fd4ec37f450         │ None         │ 0x959cc0 (nil/0x0)   │ None          │ 0x959cc0 (nil/0x0)    │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 7              │ 0x7fd4ec37fc10         │ None         │ 0x959cc0 (nil/0x0)   │ None          │ 0x959cc0 (nil/0x0)    │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 9              │ 0x7fd4ec37f890         │ None         │ 0x959cc0 (nil/0x0)   │ None          │ 0x959cc0 (nil/0x0)    │
╘════════════════╧════════════════════════╧══════════════╧══════════════════════╧═══════════════╧═══════════════════════╛
```


#### printing The Tree With All Possible Traversing Algorithms


##### pre-order Algorithm


```python
from thri import completeBinaryTree


x = completeBinaryTree([5, 4, 6, 2, 8, 1, 3, 7, 9], algorithm="pre-order")
print(x)
```


### Output


```bash
╒════════════════╤════════════════════════╤══════════════╤══════════════════════╤═══════════════╤═══════════════════════╕
│ Current node   │ Current node @ddress   │ Left child   │ Left child @ddress   │ Right child   │ Right child @ddress   │
╞════════════════╪════════════════════════╪══════════════╪══════════════════════╪═══════════════╪═══════════════════════╡
│ 5 (Root)       │ 0x7fcb70524810         │ 4            │ 0x7fcb70525e90       │ 6             │ 0x7fcb7059bd10        │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 4              │ 0x7fcb70525e90         │ 2            │ 0x7fcb70525610       │ 8             │ 0x7fcb7037f610        │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 2              │ 0x7fcb70525610         │ 7            │ 0x7fcb7037fb90       │ 9             │ 0x7fcb7037f810        │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 7              │ 0x7fcb7037fb90         │ None         │ 0x959cc0 (nil/0x0)   │ None          │ 0x959cc0 (nil/0x0)    │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 9              │ 0x7fcb7037f810         │ None         │ 0x959cc0 (nil/0x0)   │ None          │ 0x959cc0 (nil/0x0)    │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 8              │ 0x7fcb7037f610         │ None         │ 0x959cc0 (nil/0x0)   │ None          │ 0x959cc0 (nil/0x0)    │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 6              │ 0x7fcb7059bd10         │ 1            │ 0x7fcb7037fb50       │ 3             │ 0x7fcb7037f3d0        │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 1              │ 0x7fcb7037fb50         │ None         │ 0x959cc0 (nil/0x0)   │ None          │ 0x959cc0 (nil/0x0)    │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 3              │ 0x7fcb7037f3d0         │ None         │ 0x959cc0 (nil/0x0)   │ None          │ 0x959cc0 (nil/0x0)    │
╘════════════════╧════════════════════════╧══════════════╧══════════════════════╧═══════════════╧═══════════════════════╛
```


##### in-order Algorithm


```python
from thri import completeBinaryTree


x = completeBinaryTree([5, 4, 6, 2, 8, 1, 3, 7, 9], algorithm="in-order")
print(x)
```


### Output


```bash
╒════════════════╤════════════════════════╤══════════════╤══════════════════════╤═══════════════╤═══════════════════════╕
│ Current node   │ Current node @ddress   │ Left child   │ Left child @ddress   │ Right child   │ Right child @ddress   │
╞════════════════╪════════════════════════╪══════════════╪══════════════════════╪═══════════════╪═══════════════════════╡
│ 7              │ 0x7f287057fb90         │ None         │ 0x959cc0 (nil/0x0)   │ None          │ 0x959cc0 (nil/0x0)    │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 2              │ 0x7f2870725610         │ 7            │ 0x7f287057fb90       │ 9             │ 0x7f287057f810        │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 9              │ 0x7f287057f810         │ None         │ 0x959cc0 (nil/0x0)   │ None          │ 0x959cc0 (nil/0x0)    │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 4              │ 0x7f2870725e90         │ 2            │ 0x7f2870725610       │ 8             │ 0x7f287057f610        │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 8              │ 0x7f287057f610         │ None         │ 0x959cc0 (nil/0x0)   │ None          │ 0x959cc0 (nil/0x0)    │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 5 (Root)       │ 0x7f2870724810         │ 4            │ 0x7f2870725e90       │ 6             │ 0x7f287079bd10        │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 1              │ 0x7f287057fb50         │ None         │ 0x959cc0 (nil/0x0)   │ None          │ 0x959cc0 (nil/0x0)    │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 6              │ 0x7f287079bd10         │ 1            │ 0x7f287057fb50       │ 3             │ 0x7f287057f3d0        │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 3              │ 0x7f287057f3d0         │ None         │ 0x959cc0 (nil/0x0)   │ None          │ 0x959cc0 (nil/0x0)    │
╘════════════════╧════════════════════════╧══════════════╧══════════════════════╧═══════════════╧═══════════════════════╛
```


##### post-order Algorithm


```python
from thri import completeBinaryTree


x = completeBinaryTree([5, 4, 6, 2, 8, 1, 3, 7, 9], algorithm="post-order")
print(x)
```


### Output


```bash
╒════════════════╤════════════════════════╤══════════════╤══════════════════════╤═══════════════╤═══════════════════════╕
│ Current node   │ Current node @ddress   │ Left child   │ Left child @ddress   │ Right child   │ Right child @ddress   │
╞════════════════╪════════════════════════╪══════════════╪══════════════════════╪═══════════════╪═══════════════════════╡
│ 7              │ 0x7f83ddc838d0         │ None         │ 0x959cc0 (nil/0x0)   │ None          │ 0x959cc0 (nil/0x0)    │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 9              │ 0x7f83ddc28150         │ None         │ 0x959cc0 (nil/0x0)   │ None          │ 0x959cc0 (nil/0x0)    │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 2              │ 0x7f83dde21610         │ 7            │ 0x7f83ddc838d0       │ 9             │ 0x7f83ddc28150        │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 8              │ 0x7f83ddc83b10         │ None         │ 0x959cc0 (nil/0x0)   │ None          │ 0x959cc0 (nil/0x0)    │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 4              │ 0x7f83dde21e90         │ 2            │ 0x7f83dde21610       │ 8             │ 0x7f83ddc83b10        │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 1              │ 0x7f83ddc83e10         │ None         │ 0x959cc0 (nil/0x0)   │ None          │ 0x959cc0 (nil/0x0)    │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 3              │ 0x7f83ddc83b90         │ None         │ 0x959cc0 (nil/0x0)   │ None          │ 0x959cc0 (nil/0x0)    │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 6              │ 0x7f83dde97d10         │ 1            │ 0x7f83ddc83e10       │ 3             │ 0x7f83ddc83b90        │
├────────────────┼────────────────────────┼──────────────┼──────────────────────┼───────────────┼───────────────────────┤
│ 5 (Root)       │ 0x7f83dde20810         │ 4            │ 0x7f83dde21e90       │ 6             │ 0x7f83dde97d10        │
╘════════════════╧════════════════════════╧══════════════╧══════════════════════╧═══════════════╧═══════════════════════╛
```


#### Knowing How Many Node In The Tree


```python
from thri import completeBinaryTree

x = completeBinaryTree([5, 4, 6, 2, 8, 1, 3, 7, 9])
print(len(x))
```


### Output


```bash
9
```


## Advanced Usage


```python
from thri import completeBinaryTree


def pre_order(root):
    if root is not None:
        print(root.get_data())
        pre_order(root.left_child())
        pre_order(root.right_child())


def in_order(root):
    if root is not None:
        in_order(root.left_child())
        print(root.get_data())
        in_order(root.right_child())


def post_order(root):
    if root is not None:
        post_order(root.left_child())
        post_order(root.right_child())
        print(root.get_data())


x = completeBinaryTree([5, 4, 6, 2, 8, 1, 3, 7, 9])
root = x.root
print("pre-order: ")
pre_order(root)
print("in-order: ")
in_order(root)
print("post-order: ")
post_order(root)
```


### Output


```bash
pre-order: 
5
4
2
7
9
8
6
1
3
in-order: 
7
2
9
4
8
5
1
6
3
post-order: 
7
9
2
8
4
1
3
6
5
```


## License


This project is licensed under the MIT LICENSE - see the [LICENSE](https://opensource.org/licenses/MIT) for more details.
