#!/usr/bin/env python
#
# xhydro documentation build configuration file, created by
# sphinx-quickstart on Fri Jun  9 13:47:02 2017.
#
# This file is execfile()d with the current directory set to its
# containing dir.
#
# Note that not all possible configuration values are present in this
# autogenerated file.
#
# All configuration values have a default; values that are commented out
# serve to show the default.

# If extensions (or modules to document with autodoc) are in another
# directory, add these directories to sys.path here. If the directory is
# relative to the documentation root, use os.path.abspath to make it
# absolute, like shown here.
import warnings
import os
import sys
from pathlib import Path
from typing import Any

sys.path.insert(0, os.path.abspath(".."))
if os.environ.get("READTHEDOCS") and "ESMFMKFILE" not in os.environ:
    # RTD doesn't activate the env, and esmpy depends on an env var set there
    # We assume the `os` package is in {ENV}/lib/pythonX.X/os.py
    # See conda-forge/esmf-feedstock#91 and readthedocs/readthedocs.org#4067
    os.environ["ESMFMKFILE"] = str(Path(os.__file__).parent.parent / "esmf.mk")

import xhydro  # noqa: E402

# -- General configuration ---------------------------------------------

# If your documentation needs a minimal Sphinx version, state it here.
#
# needs_sphinx = '1.0'

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom ones.
extensions = [
    "sphinx.ext.autodoc",
    "sphinx.ext.autosectionlabel",
    "sphinx.ext.extlinks",
    "sphinx.ext.intersphinx",
    "sphinx.ext.viewcode",
    "sphinx.ext.todo",
    "sphinx_codeautolink",
    "sphinx_copybutton",
    "nbsphinx",
]

autosectionlabel_prefix_document = True
autosectionlabel_maxdepth = 2

# To ensure that underlined fields (e.g. `_field`) are shown in the docs.
autodoc_default_options = {
    "members": True,
    "undoc-members": True,
    "private-members": False,
    "special-members": False,
}

autodoc_mock_imports = ["esmpy", "juliacall", "juliapkg", "xesmf"]

# For styling class attributes
napoleon_use_ivar = True

# For external documentation links
intersphinx_mapping = {
    "pooch": ("https://www.fatiando.org/pooch/latest/", None),
    "xclim": ("https://xclim.readthedocs.io/en/latest/", None),
    "xscen": ("https://xscen.readthedocs.io/en/latest/", None),
}

extlinks = {
    "issue": ("https://github.com/hydrologie/xhydro/issues/%s", "GH/%s"),
    "pull": ("https://github.com/hydrologie/xhydro/pull/%s", "PR/%s"),
    "user": ("https://github.com/%s", "@%s"),
}

# Generate documentation from Jupyter notebooks.
skip_notebooks = os.getenv("SKIP_NOTEBOOKS")
if skip_notebooks:
    warnings.warn("Not executing notebooks.")
    nbsphinx_execute = "never"
elif os.getenv("GITHUB_ACTIONS"):
    nbsphinx_execute = "always"
else:
    nbsphinx_execute = "auto"

# Add any paths that contain templates here, relative to this directory.
templates_path = ["_templates"]

# The suffix(es) of source filenames.
# You can specify multiple suffix as a dictionary of suffix: filetype
source_suffix = {".rst": "restructuredtext"}

# The master toctree document.
master_doc = "index"

# General information about the project.
project = "xHydro"
copyright = "2023, Thomas-Charles Fortier Filion"
author = "Thomas-Charles Fortier Filion"

# The version info for the project you're documenting, acts as replacement
# for |version| and |release|, also used in various other places throughout
# the built documents.
#
# The short X.Y version.
version = xhydro.__version__.split("-")[0]
# The full version, including alpha/beta/rc tags.
release = xhydro.__version__

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
language = "en"

# Sphinx-intl configuration
locale_dirs = ["locales"]
gettext_compact = False  # optional

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This patterns also effect to html_static_path and html_extra_path
exclude_patterns = ["_build", "Thumbs.db", ".DS_Store"]

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = "sphinx"

# If true, `todo` and `todoList` produce output, else they produce nothing.
todo_include_todos = True


# -- Options for HTML output -------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#
html_theme = "furo"

# Theme options are theme-specific and customize the look and feel of a theme further.
# For a list of options available for each theme, see the documentation.
#
html_theme_options = {
    "light_logo": "xhydro-logo-light.png",
    "dark_logo": "xhydro-logo-transparent.png",
}

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
if not os.path.exists("_static"):
    os.makedirs("_static")
html_static_path = ["_static", "logos"]

html_sidebars = {
    "**": [
        "sidebar/scroll-start.html",
        "sidebar/brand.html",
        "sidebar/search.html",
        "sidebar/navigation.html",
        "sidebar/ethical-ads.html",
        "sidebar/scroll-end.html",
    ]
}

# -- Options for HTMLHelp output ---------------------------------------

# Output file base name for HTML help builder.
htmlhelp_basename = "xhydrodoc"


# -- Options for LaTeX output ------------------------------------------

latex_elements: dict[str, Any] = {
    # The paper size ('letterpaper' or 'a4paper').
    #
    # 'papersize': 'letterpaper',
    # The font size ('10pt', '11pt' or '12pt').
    #
    # 'pointsize': '10pt',
    # Additional stuff for the LaTeX preamble.
    #
    # 'preamble': '',
    # Latex figure (float) alignment
    #
    # 'figure_align': 'htbp',
}

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title, author, documentclass
# [howto, manual, or own class]).
latex_documents = [
    (
        master_doc,
        "xhydro.tex",
        "xHydro Documentation",
        "Thomas-Charles Fortier Filion",
        "manual",
    ),
]


# -- Options for manual page output ------------------------------------

# One entry per manual page. List of tuples
# (source start file, name, description, authors, manual section).
man_pages = [(master_doc, "xhydro", "xHydro Documentation", [author], 1)]


# -- Options for Texinfo output ----------------------------------------

# Grouping the document tree into Texinfo files. List of tuples
# (source start file, target name, title, author,
#  dir menu entry, description, category)
texinfo_documents = [
    (
        master_doc,
        "xhydro",
        "xHydro Documentation",
        author,
        "xhydro",
        "Hydrological analysis library built with xarray.",
        "hydrology",
    ),
]


def setup(app):
    app.add_css_file("style.css")
