# Py3dtiles Governance

[[_TOC_]]

## Foreword

This document is inspired by the [Meritocratic Governance Model document](http://oss-watch.ac.uk/resources/meritocraticgovernancemodel) from Ross Gardler and Gabriel Hanganu, available as Creative Common By-Sa. The template has been adapted for Py3dtiles.

## Overview

Py3dtiles is a meritocratic, consensus-based community project. Anyone with an interest in the project can join the community, contribute to the project design and participate in the decision making process. This document describes how that participation takes place and how to set about earning merit within the project community.

We believe in running the project transparently. This includes everything from decision-making to defects in the code.

## Roles and responsibilities

### Users

Users are community members who have a need for the project. They are the most important members of the community and without them the project would have no purpose. Anyone can be a user; there are no special requirements.

The project asks its users to participate in the project and community as much as possible. User contributions enable the project team to ensure that they are satisfying the needs of those users. Common user contributions include (but are not limited to):

- communicating about the project (e.g. a link on a website and word-of-mouth awareness raising)
- informing developers of strengths and weaknesses from a new user perspective
- providing moral support (a ‘thank you’ goes a long way)
- providing financial support (the software is open source, but its developers need to eat)

Users who continue to engage with the project and its community will often become more and more involved. Such users may find themselves becoming contributors, as described in the next section.

### Contributors

Contributors are community members who contribute in concrete ways to the project. Anyone can become a contributor, and contributions can take many forms, as detailed in [CONTRIBUTING.md](./CONTRIBUTING.md). There is no expectation of commitment to the project, no specific skill requirements and no selection process.

In addition to their actions as users, contributors may also find themselves doing one or more of the following:

- supporting new users (existing users are often the best people to support new users)
- reporting bugs
- identifying requirements
- providing graphics and web design
- programming
- assisting with project infrastructure
- writing documentation
- fixing bugs
- adding features

Contributors engage with the project through the issue tracker and communication channel, or by writing or editing documentation. They submit changes to the project itself via patches and Merge Requests, which will be considered for inclusion in the project by existing committers (see next section). The developer communication channel is the most appropriate place to ask for help when making that first contribution.

As contributors gain experience and familiarity with the project, their profile within, and commitment to, the community will increase. At some stage, they may find themselves being nominated for committership.

Contributors must agree to the [Code of Conduct](CODE_OF_CONDUCT.md) as well as the [Contributor's Guidelines](CONTRIBUTING.md).

### Committers

Committers are community members who have shown that they are committed to the continued development of the project through ongoing engagement with the community. Committership allows contributors to more easily carry on with their project related activities by giving them direct access to the project’s resources. That is, they can make changes directly to project outputs, without having to submit changes via patches.

This does not mean that a committer is free to do what they want. In fact, committers have no more authority over the project than contributors. While committership indicates a valued member of the community who has demonstrated a healthy respect for the project’s aims and objectives, their work continues to be reviewed by the community before acceptance in an official release. The key difference between a committer and a contributor is when this approval is sought from the community. A committer seeks approval after the contribution is made, rather than before.

Seeking approval after making a contribution is known as a commit-then-review process. It is more efficient to allow trusted people to make direct contributions, as the majority of those contributions will be accepted by the project. The project employs various communication mechanisms to ensure that all contributions are reviewed by the community as a whole. By the time a contributor is invited to become a committer, they will have become familiar with the project’s various tools as a user and then as a contributor.

Anyone can become a committer; there are no special requirements, other than to have shown a willingness and ability to participate in the project as a team player. Typically, a potential committer will need to show that they have an understanding of the project, its objectives and its strategy. They will also have provided valuable contributions to the project over a period of time.

The project encourages committers to come from multiple organizations and diverse origins.

New committers can be nominated by any existing committer. Once they have been nominated, there will be a vote by the project management committee (PSC; see below). Committer voting is one of the few activities that takes place on the project’s private management channel. This is to allow PSC members to freely express their opinions about a nominee without causing embarrassment. Once the vote has been held, the aggregated voting results are published on the public communication channel. The nominee is entitled to request an explanation of any ‘no’ votes against them, regardless of the outcome of the vote. This explanation will be provided by the PSC Chair (see below) and will be anonymous and constructive in nature.

Nominees may decline their appointment as a committer. However, this is unusual, as the project does not expect any specific time or resource commitment from its community members. The intention behind the role of committer is to allow people to contribute to the project more easily, not to tie them in to the project in any formal way.

It is important to recognise that committership is a privilege, not a right. That privilege must be earned and once earned it can be removed by the PSC (see next section) under particular circumstances. However, under normal circumstances committership exists for as long as the committer wishes to continue engaging with the project, and actively participates to its development.

A committer who shows an above-average level of contribution to the project, particularly with respect to its strategic direction and long-term health, may be nominated to become a member of the PSC. This role is described below.

### Project Steering committee (PSC)

The project management committee consists of those individuals identified as ‘project owners’ on the development site. The PSC has additional responsibilities over and above those of a committer. These responsibilities ensure the smooth running of the project. PSC members are expected to participate in strategic planning, approve changes to the governance model and manage the copyrights within the project outputs.

Members of the PSC do not have significant authority over other members of the community, although it is the PSC that votes on new committers. It also makes decisions when community consensus cannot be reached. In addition, the PSC has access to the project’s private communication channel and its archives. This channel is used for sensitive issues, such as votes for new committers and legal matters that cannot be discussed in public. It is never used for project management or planning.

Membership of the PSC is by invitation from the existing PSC members. A nomination will result in discussion and then a vote by the existing PSC members. PSC membership votes are subject to consensus approval of the current PSC members.

PSC members should be affiliated to multiple organizations, and the number of PSC members affiliated to a same organization should not represent a majority of votes.

### PSC Chair

The PSC Chair is a single individual, voted for by the PSC members. Once someone has been appointed Chair, they remain in that role:

- for a time period of 3 year
- or until they choose to retire
- or when the PSC casts a two-thirds majority vote to remove them.

The PSC Chair has no additional authority over other members of the PSC: the role is one of coordinator and facilitator. The Chair is also expected to ensure that all governance processes are adhered to, and has the casting vote when the project fails to reach consensus.

## Support

All participants in the community are encouraged to provide support for new users within the project management infrastructure. This support is provided as a way of growing the community.

Those seeking support should recognise that all support activity within the project is voluntary and is therefore provided as and when time allows. A user requiring guaranteed response times or results should therefore seek to purchase a support contract from a community member or a company providing this service.

However, for those willing to engage with the project on its own terms, and willing to help support other users, the community support channels are ideal.

## Contribution process

Anyone can contribute to the project, regardless of their skills, as there are many ways to contribute. For instance, a contributor might be active on the project communication channel and issue tracker, or might supply patches. The various ways of contributing are described in more detail in [CONTRIBUTING.md](./CONTRIBUTING.md).

The developer communication channel is the most appropriate place for a contributor to ask for help when making their first contribution.

## Communications

- chatroom: <https://matrix.to/#/#py3dtiles:matrix.org>
- developer channel: to be defined
- PSC channel: to be defined

## Decision making process

Decisions about the future of the project are made through discussion with all members of the community, from the newest user to the most experienced PSC member. All non-sensitive project management discussion takes place on the project contributors’ communication channel.

Occasionally, sensitive discussion may occur on a private communication channel.

In order to ensure that the project is not bogged down by endless discussion and continual voting, the project operates a policy of lazy consensus. This allows the majority of decisions to be made without resorting to a formal vote.

### Lazy consensus

Decision making typically involves the following steps:

- Proposal
- Discussion
- Vote (if consensus is not reached through discussion)
- Decision

Any community member can make a proposal for consideration by the community. In order to initiate a discussion about a new idea, they should send a message to the project contributors’ channel or submit a patch implementing the idea to the issue tracker (or version-control system if they have commit access).

This will prompt a review and, if necessary, a discussion of the idea. The goal of this review and discussion is to gain approval for the contribution. Since most people in the project community have a shared vision, there is often little need for discussion in order to reach consensus.

In general, as long as nobody explicitly opposes a proposal or patch, it is recognised as having the support of the community. This is called lazy consensus - that is, those who have not stated their opinion explicitly have implicitly agreed to the implementation of the proposal.

Lazy consensus is a very important concept within the project. It is this process that allows a large group of people to efficiently reach consensus, as someone with no objections to a proposal need not spend time stating their position, and others need not spend time reading such mails.

For lazy consensus to be effective, it is necessary to allow at least 72 hours before assuming that there are no objections to the proposal. This requirement ensures that everyone is given enough time to read, digest and respond to the proposal. This time period is chosen so as to be as inclusive as possible of all participants, regardless of their location and time commitments.

### Voting modes

Not all decisions can be made using lazy consensus. If a consensus cannot be reached, the proposal is postponed, or a vote can be asked for.

Also, issues such as those affecting the strategic direction or legal standing of the project must gain explicit approval in the form of a vote on the project development communication channel. Every member of the community is encouraged to express their opinions in all discussions and all votes. However, only project committers and/or PSC members (as defined above) have binding votes for the purposes of decision making.

Where necessary (e.g. discussion and vote about specific people to be new committers) PSC voting may take place on the private PSC communication channel.

Votes are clearly indicated by subject line starting with `[VOTE]`. Discussion and proposal should have happened prior to the vote. Voting is carried out by replying to the vote mail. See voting procedure below. Votes are expressed using one of the following symbols:

- `+1`: "Yes," "Agree," or "the action should be performed." In general, this vote also indicates a willingness on the behalf of the voter to assist with "making it happen".
- `+0`: This vote indicates a willingness for the action under consideration to go ahead. The voter, however will not be able to help.
- `-0`: This vote indicates that the voter does not, in general, agree with the proposed action but is not concerned enough to prevent the action going ahead.
- `-1`: This is a negative vote. On issues where consensus is required, this vote counts as a veto. All vetoes must contain an explanation of why the veto is appropriate. Vetoes with no explanation are void. It may also be appropriate for a -1 vote to include an alternative course of action.
- `abstain`: People can abstain from voting. They can either remain silent or express their reason.

All participants in the project are encouraged to show their preference for a particular action by voting. When the votes are tallied, only the votes of PSC members or committers are binding. Non-binding votes are still useful to enable everyone to understand the perception of an action by the wider community.

Voting can also be applied to changes made to the project codebase. These typically take the form of a veto (-1) in reply to the commit message or Merge Request sent when the commit is made.

Types of approval:

- **Lazy consensus**: see above, no voting
- **Consensus approval**: Consensus approval requires 3 binding +1 votes and no binding vetoes.
- **Lazy majority (majority consensus)**: A lazy majority vote requires 3 binding +1 votes and more binding +1 votes than -1 votes.
- **Lazy approval**: An action with lazy approval is implicitly allowed unless a -1 vote is received, at which time, depending on the type of action, either lazy majority or consensus approval must be obtained.
- **2/3 majority**: Some actions require a 2/3 majority of binding votes. Such actions typically affect the foundation of the project (e.g. adopting a new codebase to replace an existing product). The higher threshold is designed to ensure such changes are strongly supported. To pass this vote requires at least 2/3 of the votes that are cast to be +1.
- **Unanimous approval**:  All of the votes that are cast are to be +1 and there can be no binding vetoes (-1).

A valid veto cannot be over-ruled, it can only be withdrawn by its issuer. Any veto must be accompanied by reasoning and be prepared to defend it.

The validity of a veto, if challenged, can be confirmed by anyone who has a binding vote. This does not necessarily signify agreement with the veto - merely that the veto is valid. In case of disputes about whether a veto is valid, then opinion of the PSC chair is final.

If you disagree with a valid veto, then you must engage the person casting the veto to further discuss the issues. The vetoer is obliged to vote early and to then work with the community to resolve the matter.

If a veto is not withdrawn, the action that has been vetoed must be reversed in a timely manner.

For breakdown situations and those requiring unanimous consensus, if this consensus cannot be reached within the extended timeframe, then the PSC chair makes the ultimate decision.

### Actions & voting

This section describes the various actions which are undertaken within the project, the corresponding approval required for that action, and those who have binding votes over the action.

| Action | Description | Approval | Binding Votes |
|:-------|:------------|:---------|:--------------|
| Code change  |    A change made to a codebase of the project by a committer. This includes source code, documentation, website content, etc. | Lazy consensus | N/A |
| Release plan |    Defines the timetable and actions for a release. A release plan cannot be vetoed (hence lazy majority). | Lazy majority | committers |
| Product release |  When a release of one of the project's products is ready, a vote is required to accept the release as an official release of the project. A release cannot be vetoed (hence lazy majority). A Release Manager might choose to get an issue resolved or re-schedule, but that is their decision. | Lazy majority | committers |
| Adoption of new codebase | When the codebase for an existing, released product is to be replaced with an alternative codebase. If such a vote fails to gain approval, the existing code base will continue. This also covers the creation of new sub-projects within the project. | 2/3 majority | PSC members |
| New committer | When a new committer is proposed for the project. | Consensus approval | Committers |
| New PSC member | When a new member is proposed for the PSC. | Consensus approval | PSC members |
| Reinstate emeritus member | An emeritus PSC member can be reinstated. | Consensus approval | PSC members (excluding the member in question) |
| Committer removal | When removal of commit privileges is sought. | Unanimous consensus | PSC members (excluding the committer in question if a member of the PSC) |
| PSC member removal | When removal of a PSC member is sought. | Unanimous consensus | PSC members (excluding the member in question) |

### Voting timeframes & procedure

Votes are normally open for a period of one week to allow all active voters time to consider the vote. If the vote has not achieved a quorum (the chair decides if sufficient people have voted), then it can be extended for another week. If still no quorum, then the vote fails, and would need to be raised again later. Votes relating to code changes are not subject to a strict timetable, but should be made as timely as possible.

Be careful about holidays when calling a vote. This is hard when we do not know customs in every part of the world. So if someone knows that there is a problem with the vote timing, then please say so.

Discussion about the topic would have already happened in a [Proposal] email thread an issue or Merge Request on the tracker, to express the issues and opinions. The [Vote] thread is to ratify the proposal if that is felt to be necessary.

The instigator sends the Vote email to the dev communication channel. Describe the issue with no ambiguity and in a positive sense. Define the date and time for the end of the vote period.

Votes are expressed by replying email using the voting symbols defined above. Voters can change their vote during the timeframe. At the end of the vote period, the instigator tallies the number of final votes and reports the results.

## Relations to other organizations

### Project independance

The project, as an opensource community project, or common good, is not directly owned by another organization, nor dependant of any other organization or company.

Users, contributors, committers, PSC members are expected to act for decisions they take within the project on their own behalf and for the interest of the project.

Py3dtiles is part of the Free and OpenSource Sofware for Geospatial community (FOSS4G), and as such is expected to behave coherently with this community, be it on a technical or organizational level.

Py3dtiles roadmap is not decided through a top-down approach with a waterfall ( define the roadmap, fully specify, plan and schedule, code, test, release ) development model, but with the meritocraty organizational model described above. As such, there is no strict roadmap, no fixed delivery schedule, and no group deciding which priorities future features will get.

### Funding the project

While project members act independently, they are also members of corporate organizations of various kinds. Companies or other organizations using the product can help the project and orient it towards their use cases in various ways:

- Donate money to the OSGeo: there is no legal entity representing Py3dtiles. The only way to give money to the project itself would be through the OSGeo Foundation, which would then allocate resources to Py3dtiles.
- Hire a freelance: there are freelance developers who can be hired to work on the project, and you can specify which features you want him to implement
- Hire a service company: there are service companies supporting and developing Py3dtiles, and you can hire them to develop the product
- Directly contribute: you can assign one of your developer to work on Py3dtiles, making direct contributions

Funding the project allow organizations to assign manpower to the items of the roadmap which are top priority for them. While contributions are always subject to the rules of meritocracy stated above, funding the project is a way to enhance the project in a specific direction, while preserving its independence.

## References

- [Meritocratic Governance Model document](http://oss-watch.ac.uk/resources/meritocraticgovernancemodel)
- [OSGeo project graduation checklist](https://www.osgeo.org/resources/project-graduation-checklist/)
- [Apache Forrest governance document, with voting methods](https://forrest.apache.org/guidelines.html#decision)

## Current team composition

**Committers**

- Augustin Trancart (Oslandia)
- Lorenzo Marnat (Liris)
- Raphaël Delhome (Oslandia)

**PSC**

TBD
