import os
import sys

# Configuration file for the Sphinx documentation builder.
#
# This file does only contain a selection of the most common options. For a
# full list see the documentation:
# http://www.sphinx-doc.org/en/master/config

# -- Path setup --------------------------------------------------------------

# Add the extensions directory to the Python path
sys.path.append(os.path.abspath("./extensions"))

# -- Project information -----------------------------------------------------
project = "py3dtiles"
copyright = "2023, the py3dtiles contributors"  # noqa: A001
author = "Antoine Facchini, Augustin Trancart, Paul Blottiere, Éric Lemoine, Frédéric Bonifas, Vincent Jaillot, Jean-Marie Kerloch, Jérémy Gaillard, Julien Cabieces, Lorenzo Marnat, Ludovic Delauné, Marco Duiker, Michael Holthausen, Nicolas Saul, Pierre-Eric Pelloux-Prayer, Raphaël Delhome, romainthal, Sébastien Guimmara, Sylvain Beorchia, Sylvain Meylan, Taro Matsuzawa aka. btm, Tom Roussel, Vincent Picavet"

# -- General configuration ---------------------------------------------------

# If your documentation needs a minimal Sphinx version, state it here.
#
# needs_sphinx = '1.0'

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = [
    "myst_parser",
    "sphinx.ext.autodoc",
    "sphinx.ext.autosectionlabel",
    "sphinx.ext.doctest",
    "sphinx.ext.intersphinx",
    "sphinx.ext.todo",
    "sphinx.ext.coverage",
    "sphinx.ext.mathjax",
    "sphinx.ext.viewcode",
    "sphinx_multiversion",
    "sphinxcontrib.apidoc",
    "py3dtiles_sphinx_ext",
]

# Add any paths that contain templates here, relative to this directory.
templates_path = ["_templates"]

# The suffix(es) of source filenames.
# You can specify multiple suffix as a list of string:
#
# source_suffix = ['.rst', '.md']
source_suffix = ".rst"

# The master toctree document.
master_doc = "index"

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
language = "en"

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This pattern also affects html_static_path and html_extra_path.
exclude_patterns = ["_build", "Thumbs.db", ".DS_Store"]

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = None


# -- Options for sphinx-multiversion

# Whitelist pattern for tags (set to None to ignore all tags)
# KEEP THAT IN SYNC with released_pattern in ./versions_switcher_builder.py
smv_tag_whitelist = r"^v(\d+\.)?(\d+\.)?(\*|\d+)$"

# Whitelist pattern for branches (set to None to ignore all branches)
smv_branch_whitelist = r"^main$"

# Whitelist pattern for remotes (set to None to use local branches only)
# set to upstream because we add this remote for gitlab, see .gitlab-ci.yml
smv_remote_whitelist = r"^upstream|origin$"

# Pattern for released versions
# KEEP THAT IN SYNC with released_pattern in ./versions_switcher_builder.py
smv_released_pattern = r"^tags/^v(\d+\.)?(\d+\.)?(\*|\d+)$"

# Format for versioned output directories inside the build directory
smv_outputdir_format = "{ref.name}"

# Determines whether remote or local git branches/tags are preferred if their output dirs conflict
smv_prefer_remote_refs = True


# -- Options for HTML output -------------------------------------------------

html_logo = "../graphics/logo.svg"
html_favicon = "../graphics/favicons/favicon.ico"

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#
html_theme = "pydata_sphinx_theme"

# version switcher
# TODO size of the dropdown list (width) to avoid the jumping effect
html_theme_options = {
    "logo": {
        "link": "/",
    },
    "switcher": {
        "json_url": "/version_switcher.json",
        "version_match": "dummy",  # will be replaced in the html template by our extension
    },
    "navbar_start": ["navbar-logo", "version-switcher"],
}

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ["_static"]

html_css_files = [
    "css/common.css",
    "css/custom.css",
]

# Custom sidebar templates, must be a dictionary that maps document names
# to template names.
#
# The default sidebars (for documents that don't match any pattern) are
# defined by theme itself.  Builtin themes are using these templates by
# default: ``['localtoc.html', 'relations.html', 'sourcelink.html',
# 'searchbox.html']``.

# -- Options for sphinxcontrib.apidoc
apidoc_module_dir = "../py3dtiles"
apidoc_output_dir = "./api"
apidoc_excluded_paths = ["tests"]
apidoc_separate_modules = True
apidoc_module_first = True
apidoc_toc_file = False
apidoc_extra_args = ["-d 3"]

# -- Options for HTMLHelp output ---------------------------------------------

# Output file base name for HTML help builder.
htmlhelp_basename = "py3dtilesdoc"


# -- Options for LaTeX output ------------------------------------------------

latex_elements = {
    # The paper size ('letterpaper' or 'a4paper').
    #
    # 'papersize': 'letterpaper',
    # The font size ('10pt', '11pt' or '12pt').
    #
    # 'pointsize': '10pt',
    # Additional stuff for the LaTeX preamble.
    #
    # 'preamble': '',
    # Latex figure (float) alignment
    #
    # 'figure_align': 'htbp',
}

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title,
#  author, documentclass [howto, manual, or own class]).
latex_documents = [
    (
        master_doc,
        "py3dtiles.tex",
        "py3dtiles Documentation",
        "Augustin Trancart, Paul Blottière, Jérémy Gaillard, Ludovic Delauné, Nicolas Saul, Pierre-Éric Pelloux-Prayer, Raphaël Delhome, Vincent Jaillot, Éric Lemoine, Antoine Facchini",
        "manual",
    ),
]


# -- Options for manual page output ------------------------------------------

# One entry per manual page. List of tuples
# (source start file, name, description, authors, manual section).
man_pages = [(master_doc, "py3dtiles", "py3dtiles Documentation", [author], 1)]


# -- Options for Texinfo output ----------------------------------------------

# Grouping the document tree into Texinfo files. List of tuples
# (source start file, target name, title, author,
#  dir menu entry, description, category)
texinfo_documents = [
    (
        master_doc,
        "py3dtiles",
        "py3dtiles Documentation",
        author,
        "py3dtiles",
        "One line description of project.",
        "Miscellaneous",
    ),
]


# -- Options for Epub output -------------------------------------------------

# Bibliographic Dublin Core info.
epub_title = project

# The unique identifier of the text. This can be a ISBN number
# or the project homepage.
#
# epub_identifier = ''

# A unique identification for the text.
#
# epub_uid = ''

# A list of files that should not be packed into the epub file.
epub_exclude_files = ["search.html"]


# -- Extension configuration -------------------------------------------------

# -- Options for intersphinx extension ---------------------------------------

# Example configuration for intersphinx: refer to the Python standard library.
intersphinx_mapping = {"python": ("https://docs.python.org/3", None)}

# -- Options for todo extension ----------------------------------------------

# If true, `todo` and `todoList` produce output, else they produce nothing.
todo_include_todos = True

# -- Options for sphinx.ext.autosectionlabel ----------------------------------
autosectionlabel_prefix_document = True
