# Generated by Django 4.1.5 on 2023-02-07 02:51

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Author',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(blank=True, max_length=255, null=True, verbose_name='Name')),
                ('email', models.EmailField(blank=True, db_index=True, max_length=254, verbose_name='Author email')),
                ('profile_url', models.URLField(blank=True, null=True, verbose_name='Profile URL')),
            ],
            options={
                'verbose_name': 'Author',
                'verbose_name_plural': 'Authors',
                'ordering': ('name', 'email'),
            },
        ),
        migrations.CreateModel(
            name='Blog',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=255, verbose_name='title')),
                ('url', models.URLField(unique=True, verbose_name='Url')),
                ('date_created', models.DateTimeField(auto_now_add=True, verbose_name='Date created')),
            ],
            options={
                'verbose_name': 'Blog',
                'verbose_name_plural': 'Blogs',
                'ordering': ('title', 'url'),
            },
        ),
        migrations.CreateModel(
            name='Feed',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('url', models.URLField(unique=True, verbose_name='Url')),
                ('title', models.CharField(max_length=255, verbose_name='Title')),
                ('subtitle', models.TextField(blank=True, null=True, verbose_name='Subtitle')),
                ('rights', models.CharField(blank=True, max_length=255, null=True, verbose_name='Rights')),
                ('language', models.CharField(blank=True, max_length=50, null=True, verbose_name='Language')),
                ('guid', models.CharField(max_length=32, unique=True, verbose_name='Global Unique Identifier')),
                ('etag', models.CharField(blank=True, max_length=50, null=True, verbose_name='Etag')),
                ('last_modified', models.DateTimeField(blank=True, null=True, verbose_name='Last modified')),
                ('last_checked', models.DateTimeField(blank=True, null=True, verbose_name='Last checked')),
                ('is_active', models.BooleanField(default=True, help_text='If disabled, this feed will not be further updated.', verbose_name='Is active')),
                ('blog', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='planet.blog')),
            ],
            options={
                'verbose_name': 'Feed',
                'verbose_name_plural': 'Feeds',
                'ordering': ('title',),
            },
        ),
        migrations.CreateModel(
            name='Post',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=255, verbose_name='Title')),
                ('url', models.URLField(max_length=1000, verbose_name='Url')),
                ('guid', models.CharField(max_length=32, unique=True, verbose_name='Guid')),
                ('content', models.TextField(verbose_name='Content')),
                ('language', models.CharField(blank=True, max_length=50, null=True, verbose_name='Language')),
                ('comments_url', models.URLField(blank=True, null=True, verbose_name='Comments URL')),
                ('date_published', models.DateTimeField(verbose_name='Date Published')),
                ('date_modified', models.DateTimeField(auto_now=True, verbose_name='Date Modified')),
                ('date_created', models.DateTimeField(auto_now_add=True, verbose_name='Date Created')),
            ],
            options={
                'verbose_name': 'Post',
                'verbose_name_plural': 'Posts',
                'ordering': ['-date_published'],
            },
        ),
        migrations.CreateModel(
            name='PostAuthorData',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('is_contributor', models.BooleanField(default=False, verbose_name='Is Contributor?')),
                ('date_created', models.DateField(auto_now_add=True, verbose_name='Date created')),
                ('author', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='planet.author')),
                ('post', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='planet.post')),
            ],
            options={
                'verbose_name': 'Post Author Data',
                'verbose_name_plural': 'Post Author Data',
                'ordering': ('author', 'post', 'is_contributor'),
            },
        ),
        migrations.AddField(
            model_name='post',
            name='authors',
            field=models.ManyToManyField(through='planet.PostAuthorData', to='planet.author'),
        ),
        migrations.AddField(
            model_name='post',
            name='feed',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='planet.feed'),
        ),
        migrations.AddIndex(
            model_name='blog',
            index=models.Index(fields=['title'], name='planet_blog_title_f7c63c_idx'),
        ),
        migrations.AddIndex(
            model_name='blog',
            index=models.Index(fields=['url'], name='planet_blog_url_350eef_idx'),
        ),
        migrations.AddIndex(
            model_name='blog',
            index=models.Index(fields=['-date_created'], name='planet_blog_date_cr_bc921f_idx'),
        ),
        migrations.AddIndex(
            model_name='blog',
            index=models.Index(fields=['title', 'url'], name='planet_blog_title_4cc66e_idx'),
        ),
        migrations.AddIndex(
            model_name='author',
            index=models.Index(fields=['name'], name='planet_auth_name_8b275b_idx'),
        ),
        migrations.AddIndex(
            model_name='author',
            index=models.Index(fields=['name', 'email'], name='planet_auth_name_6dad32_idx'),
        ),
        migrations.AddIndex(
            model_name='postauthordata',
            index=models.Index(fields=['author', 'post', 'is_contributor'], name='planet_post_author__8a6a3a_idx'),
        ),
        migrations.AddIndex(
            model_name='post',
            index=models.Index(fields=['title'], name='planet_post_title_9d6b78_idx'),
        ),
        migrations.AddIndex(
            model_name='post',
            index=models.Index(fields=['guid'], name='planet_post_guid_4dc425_idx'),
        ),
        migrations.AddIndex(
            model_name='post',
            index=models.Index(fields=['language'], name='planet_post_languag_ac49fa_idx'),
        ),
        migrations.AddIndex(
            model_name='post',
            index=models.Index(fields=['-date_modified'], name='planet_post_date_mo_e3d607_idx'),
        ),
        migrations.AddIndex(
            model_name='post',
            index=models.Index(fields=['-date_created'], name='planet_post_date_cr_c18ee0_idx'),
        ),
        migrations.AddIndex(
            model_name='post',
            index=models.Index(fields=['-date_published'], name='planet_post_date_pu_cea8df_idx'),
        ),
        migrations.AlterUniqueTogether(
            name='post',
            unique_together={('feed', 'guid')},
        ),
        migrations.AddIndex(
            model_name='feed',
            index=models.Index(fields=['title'], name='planet_feed_title_d16ef4_idx'),
        ),
        migrations.AddIndex(
            model_name='feed',
            index=models.Index(fields=['guid'], name='planet_feed_guid_de0af2_idx'),
        ),
        migrations.AddIndex(
            model_name='feed',
            index=models.Index(fields=['etag'], name='planet_feed_etag_dfca19_idx'),
        ),
        migrations.AddIndex(
            model_name='feed',
            index=models.Index(fields=['-last_modified'], name='planet_feed_last_mo_abcf2a_idx'),
        ),
        migrations.AddIndex(
            model_name='feed',
            index=models.Index(fields=['-last_checked'], name='planet_feed_last_ch_bb71ae_idx'),
        ),
        migrations.AddIndex(
            model_name='feed',
            index=models.Index(fields=['is_active'], name='planet_feed_is_acti_1ed7f8_idx'),
        ),
    ]
