from setuptools import setup, find_packages

setup(
    name='notebook_copilot',
    version='0.1.5',
    packages=find_packages(),
    description='The Bridge from Thoughts to Well-Crafted Jupyter Notebook',
    install_requires=[
        'setuptools~=65.5.1',
        'ipython~=8.13.2',
        'langchain~=0.0.187',
        'pandas~=2.0.2',
        'pydantic~=1.10.8',
        'tiktoken~=0.4.0',
        'faiss-cpu~=1.7.4'
    ],
    python_requires='>=3.7.1, <4',
    classifiers=[
        "Development Status :: 3 - Alpha",
        "Intended Audience :: Science/Research",
        "Intended Audience :: Developers",
        "Topic :: Software Development :: Libraries :: Python Modules",
        "Topic :: Scientific/Engineering :: Artificial Intelligence",
        "Topic :: Scientific/Engineering :: Information Analysis",
        "License :: OSI Approved :: MIT License",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
        "Operating System :: OS Independent",
        "Framework :: Jupyter",
        "Natural Language :: English",
    ],
    author="Tal Peretz",
    author_email="tp@aihumanlabs.com",
    long_description=open('README.md').read(),
    long_description_content_type='text/markdown',
    url="https://github.com/talperetz/notebook_copilot",
    license="MIT",
)
