# Getting Started

Welcome to the Open Autonomy Framework documentation! This section will help you understand and get started with building your own agent services.

## What are Agent Services?

Agent services are decentralized off-chain services that run as multi-agent systems and are secured on public blockchains. They enable complex processing and autonomous actions while maintaining decentralization, trust-minimization, transparency, and robustness.

## Key Topics

1. [What is an Agent Service?](./what_is_an_agent_service.md)  
   Learn about the architecture and components of agent services, including how they work and interact with blockchain networks.

2. [Why do we need Agent Services?](./why_do_we_need_agent_services.md)  
   Understand the challenges in blockchain technology that agent services address and their role in the crypto ecosystem.

3. [Use cases](./use_cases.md)  
   Explore practical applications of agent services, from DAO operations to customizable infrastructure solutions.

4. [Agent Services compared](./agent_services_compared_to.md)  
   See how agent services compare to other software solutions and understand when to use them.

## Next Steps

After understanding the basics of agent services, you can:

- Follow our [Quick Start Guide](../guides/quick_start.md) to build your first agent service
- Learn about the [Development Process](../guides/overview_of_the_development_process.md)
- Explore [Key Concepts](../key_concepts/index.md) in depth

## Need Help?

If you have questions or need assistance:

- Check our [Questions and Answers](../questions-and-answers.md) section
- Join our community on [Discord](https://discord.com/invite/z2PT65jKqQ)
- Visit the [Autonolas website](https://www.olas.network/) for more resources