import { defineConfig } from '@playwright/test'

export default defineConfig({
  testDir: 'tests',
  timeout: 60_000,
  // TODO: When stable, allow retries in CI
  retries: process.env.CI ? 2 : 0,
  workers: 4,
  reporter: [['html', { outputFolder: 'playwright-report' }], ['list']],
  globalSetup: './tests/global-setup.ts',
  projects: [
    {
      name: 'electron-vscode',
      use: {
        browserName: 'chromium',
        headless: true,
        launchOptions: {
          slowMo: process.env.CI ? 0 : 100,
        },
        viewport: { width: 1512, height: 944 },
        video: 'retain-on-failure',
      },
    },
  ],
})
