"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .affirmitineraryoptions import (
    AffirmItineraryOptions,
    AffirmItineraryOptionsTypedDict,
)
from gr4vy.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing import Any, Dict
from typing_extensions import NotRequired, TypedDict


class AffirmOptionsTypedDict(TypedDict):
    discounts: NotRequired[Nullable[Dict[str, Dict[str, Any]]]]
    r"""Passes additional discounts to the Affirm widget."""
    itinerary: NotRequired[Nullable[AffirmItineraryOptionsTypedDict]]
    r"""Passes itinerary data to the Affirm API."""


class AffirmOptions(BaseModel):
    discounts: OptionalNullable[Dict[str, Dict[str, Any]]] = UNSET
    r"""Passes additional discounts to the Affirm widget."""

    itinerary: OptionalNullable[AffirmItineraryOptions] = UNSET
    r"""Passes itinerary data to the Affirm API."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["discounts", "itinerary"]
        nullable_fields = ["discounts", "itinerary"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
